# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['UpgradeRabbitmqArgs', 'UpgradeRabbitmq']

@pulumi.input_type
class UpgradeRabbitmqArgs:
    def __init__(__self__, *,
                 instance_id: pulumi.Input[int]):
        """
        The set of arguments for constructing a UpgradeRabbitmq resource.
        :param pulumi.Input[int] instance_id: The CloudAMQP instance identifier
        """
        pulumi.set(__self__, "instance_id", instance_id)

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Input[int]:
        """
        The CloudAMQP instance identifier
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: pulumi.Input[int]):
        pulumi.set(self, "instance_id", value)


@pulumi.input_type
class _UpgradeRabbitmqState:
    def __init__(__self__, *,
                 instance_id: Optional[pulumi.Input[int]] = None):
        """
        Input properties used for looking up and filtering UpgradeRabbitmq resources.
        :param pulumi.Input[int] instance_id: The CloudAMQP instance identifier
        """
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[int]]:
        """
        The CloudAMQP instance identifier
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "instance_id", value)


class UpgradeRabbitmq(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 instance_id: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        """
        This resource allows you to automatically upgrade to latest possible upgradable versions for RabbitMQ and Erlang. Depending on initial versions of RabbitMQ and Erlang of the CloudAMQP instance, multiple runs may be needed to get to latest versions. After completed upgrade, check data source _get_upgradable_versions_ to see if newer versions is available. Then delete `UpgradeRabbitmq` and create it again to invoke the upgrade.

        > **Important Upgrade Information**
        > - All nodes in a cluster must run the same major and minor version of RabbitMQ. The entire cluster will be offline while upgrading major or minor versions.
        > - Auto delete queues (queues that are marked AD) will be deleted during the update.
        > - Any custom plugins support has installed on your behalf will be disabled and you need to contact support@cloudamqp.com and ask to have them re-installed.
        > - TLS 1.0 and 1.1 will not be supported after the update.

        Only available for dedicated subscription plans.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudamqp as cloudamqp

        versions = cloudamqp.get_upgradable_versions(instance_id=cloudamqp_instance["instance"]["id"])
        # Invoke automatically upgrade to latest possible upgradable versions for RabbitMQ and Erlang
        upgrade = cloudamqp.UpgradeRabbitmq("upgrade", instance_id=cloudamqp_instance["instance"]["id"])
        ```

        ```python
        import pulumi
        import pulumi_cloudamqp as cloudamqp

        versions = cloudamqp.get_upgradable_versions(instance_id=cloudamqp_instance["instance"]["id"])
        ```

        If newer version is still available to be upgradable in the data source, re-run again.

        ```python
        import pulumi
        import pulumi_cloudamqp as cloudamqp

        versions = cloudamqp.get_upgradable_versions(instance_id=cloudamqp_instance["instance"]["id"])
        # Invoke automatically upgrade to latest possible upgradable versions for RabbitMQ and Erlang
        upgrade = cloudamqp.UpgradeRabbitmq("upgrade", instance_id=cloudamqp_instance["instance"]["id"])
        ```

        ## Import

        Not possible to import this resource.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] instance_id: The CloudAMQP instance identifier
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: UpgradeRabbitmqArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource allows you to automatically upgrade to latest possible upgradable versions for RabbitMQ and Erlang. Depending on initial versions of RabbitMQ and Erlang of the CloudAMQP instance, multiple runs may be needed to get to latest versions. After completed upgrade, check data source _get_upgradable_versions_ to see if newer versions is available. Then delete `UpgradeRabbitmq` and create it again to invoke the upgrade.

        > **Important Upgrade Information**
        > - All nodes in a cluster must run the same major and minor version of RabbitMQ. The entire cluster will be offline while upgrading major or minor versions.
        > - Auto delete queues (queues that are marked AD) will be deleted during the update.
        > - Any custom plugins support has installed on your behalf will be disabled and you need to contact support@cloudamqp.com and ask to have them re-installed.
        > - TLS 1.0 and 1.1 will not be supported after the update.

        Only available for dedicated subscription plans.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudamqp as cloudamqp

        versions = cloudamqp.get_upgradable_versions(instance_id=cloudamqp_instance["instance"]["id"])
        # Invoke automatically upgrade to latest possible upgradable versions for RabbitMQ and Erlang
        upgrade = cloudamqp.UpgradeRabbitmq("upgrade", instance_id=cloudamqp_instance["instance"]["id"])
        ```

        ```python
        import pulumi
        import pulumi_cloudamqp as cloudamqp

        versions = cloudamqp.get_upgradable_versions(instance_id=cloudamqp_instance["instance"]["id"])
        ```

        If newer version is still available to be upgradable in the data source, re-run again.

        ```python
        import pulumi
        import pulumi_cloudamqp as cloudamqp

        versions = cloudamqp.get_upgradable_versions(instance_id=cloudamqp_instance["instance"]["id"])
        # Invoke automatically upgrade to latest possible upgradable versions for RabbitMQ and Erlang
        upgrade = cloudamqp.UpgradeRabbitmq("upgrade", instance_id=cloudamqp_instance["instance"]["id"])
        ```

        ## Import

        Not possible to import this resource.

        :param str resource_name: The name of the resource.
        :param UpgradeRabbitmqArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(UpgradeRabbitmqArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 instance_id: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = UpgradeRabbitmqArgs.__new__(UpgradeRabbitmqArgs)

            if instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'instance_id'")
            __props__.__dict__["instance_id"] = instance_id
        super(UpgradeRabbitmq, __self__).__init__(
            'cloudamqp:index/upgradeRabbitmq:UpgradeRabbitmq',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            instance_id: Optional[pulumi.Input[int]] = None) -> 'UpgradeRabbitmq':
        """
        Get an existing UpgradeRabbitmq resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] instance_id: The CloudAMQP instance identifier
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _UpgradeRabbitmqState.__new__(_UpgradeRabbitmqState)

        __props__.__dict__["instance_id"] = instance_id
        return UpgradeRabbitmq(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Output[int]:
        """
        The CloudAMQP instance identifier
        """
        return pulumi.get(self, "instance_id")

