import { S as SvelteComponent, i as init, s as safe_not_equal, e as element, c as create_component, a as space, b as attr, f as insert, m as mount_component, g as append, j as transition_in, k as transition_out, n as detach, o as destroy_component, E as createEventDispatcher, t as text, h as set_data, a6 as tick, H as binding_callbacks, a3 as set_input_value, M as action_destroyer, l as listen, x as is_function, z as run_all, a4 as flush, P as assign, Q as StatusTracker, N as bind, R as get_spread_update, T as get_spread_object, K as add_flush_callback, J as bubble } from './index.fd4f54ee.js';
import { B as Block } from './Block.ea25c0f9.js';
import { B as BlockTitle } from './BlockTitle.eaa41e18.js';
import './styles.ed3b21b5.js';

/* home/runner/work/gradio/gradio/ui/packages/form/src/Textbox.svelte generated by Svelte v3.49.0 */

function create_default_slot$1(ctx) {
	let t;

	return {
		c() {
			t = text(/*label*/ ctx[3]);
		},
		m(target, anchor) {
			insert(target, t, anchor);
		},
		p(ctx, dirty) {
			if (dirty & /*label*/ 8) set_data(t, /*label*/ ctx[3]);
		},
		d(detaching) {
			if (detaching) detach(t);
		}
	};
}

// (84:1) {:else}
function create_else_block(ctx) {
	let textarea;
	let text_area_resize_action;
	let mounted;
	let dispose;

	return {
		c() {
			textarea = element("textarea");
			attr(textarea, "data-testid", "textbox");
			attr(textarea, "class", "scroll-hide block gr-box gr-input w-full gr-text-input");
			attr(textarea, "placeholder", /*placeholder*/ ctx[2]);
			attr(textarea, "rows", /*lines*/ ctx[1]);
			textarea.disabled = /*disabled*/ ctx[4];
		},
		m(target, anchor) {
			insert(target, textarea, anchor);
			set_input_value(textarea, /*value*/ ctx[0]);
			/*textarea_binding*/ ctx[13](textarea);

			if (!mounted) {
				dispose = [
					action_destroyer(text_area_resize_action = /*text_area_resize*/ ctx[9].call(null, textarea, /*value*/ ctx[0])),
					listen(textarea, "input", /*textarea_input_handler*/ ctx[12]),
					listen(textarea, "keypress", /*handle_keypress*/ ctx[8])
				];

				mounted = true;
			}
		},
		p(ctx, dirty) {
			if (dirty & /*placeholder*/ 4) {
				attr(textarea, "placeholder", /*placeholder*/ ctx[2]);
			}

			if (dirty & /*lines*/ 2) {
				attr(textarea, "rows", /*lines*/ ctx[1]);
			}

			if (dirty & /*disabled*/ 16) {
				textarea.disabled = /*disabled*/ ctx[4];
			}

			if (text_area_resize_action && is_function(text_area_resize_action.update) && dirty & /*value*/ 1) text_area_resize_action.update.call(null, /*value*/ ctx[0]);

			if (dirty & /*value*/ 1) {
				set_input_value(textarea, /*value*/ ctx[0]);
			}
		},
		d(detaching) {
			if (detaching) detach(textarea);
			/*textarea_binding*/ ctx[13](null);
			mounted = false;
			run_all(dispose);
		}
	};
}

// (73:1) {#if lines === 1 && max_lines === 1}
function create_if_block(ctx) {
	let input;
	let mounted;
	let dispose;

	return {
		c() {
			input = element("input");
			attr(input, "data-testid", "textbox");
			attr(input, "type", "text");
			attr(input, "class", "scroll-hide block gr-box gr-input w-full gr-text-input");
			attr(input, "placeholder", /*placeholder*/ ctx[2]);
			input.disabled = /*disabled*/ ctx[4];
		},
		m(target, anchor) {
			insert(target, input, anchor);
			set_input_value(input, /*value*/ ctx[0]);
			/*input_binding*/ ctx[11](input);

			if (!mounted) {
				dispose = [
					listen(input, "input", /*input_input_handler*/ ctx[10]),
					listen(input, "keypress", /*handle_keypress*/ ctx[8])
				];

				mounted = true;
			}
		},
		p(ctx, dirty) {
			if (dirty & /*placeholder*/ 4) {
				attr(input, "placeholder", /*placeholder*/ ctx[2]);
			}

			if (dirty & /*disabled*/ 16) {
				input.disabled = /*disabled*/ ctx[4];
			}

			if (dirty & /*value*/ 1 && input.value !== /*value*/ ctx[0]) {
				set_input_value(input, /*value*/ ctx[0]);
			}
		},
		d(detaching) {
			if (detaching) detach(input);
			/*input_binding*/ ctx[11](null);
			mounted = false;
			run_all(dispose);
		}
	};
}

function create_fragment$1(ctx) {
	let label_1;
	let blocktitle;
	let t;
	let current;

	blocktitle = new BlockTitle({
			props: {
				show_label: /*show_label*/ ctx[5],
				$$slots: { default: [create_default_slot$1] },
				$$scope: { ctx }
			}
		});

	function select_block_type(ctx, dirty) {
		if (/*lines*/ ctx[1] === 1 && /*max_lines*/ ctx[6] === 1) return create_if_block;
		return create_else_block;
	}

	let current_block_type = select_block_type(ctx);
	let if_block = current_block_type(ctx);

	return {
		c() {
			label_1 = element("label");
			create_component(blocktitle.$$.fragment);
			t = space();
			if_block.c();
			attr(label_1, "class", "block w-full");
		},
		m(target, anchor) {
			insert(target, label_1, anchor);
			mount_component(blocktitle, label_1, null);
			append(label_1, t);
			if_block.m(label_1, null);
			current = true;
		},
		p(ctx, [dirty]) {
			const blocktitle_changes = {};
			if (dirty & /*show_label*/ 32) blocktitle_changes.show_label = /*show_label*/ ctx[5];

			if (dirty & /*$$scope, label*/ 131080) {
				blocktitle_changes.$$scope = { dirty, ctx };
			}

			blocktitle.$set(blocktitle_changes);

			if (current_block_type === (current_block_type = select_block_type(ctx)) && if_block) {
				if_block.p(ctx, dirty);
			} else {
				if_block.d(1);
				if_block = current_block_type(ctx);

				if (if_block) {
					if_block.c();
					if_block.m(label_1, null);
				}
			}
		},
		i(local) {
			if (current) return;
			transition_in(blocktitle.$$.fragment, local);
			current = true;
		},
		o(local) {
			transition_out(blocktitle.$$.fragment, local);
			current = false;
		},
		d(detaching) {
			if (detaching) detach(label_1);
			destroy_component(blocktitle);
			if_block.d();
		}
	};
}

function instance$1($$self, $$props, $$invalidate) {
	let { value = "" } = $$props;
	let { lines = 1 } = $$props;
	let { placeholder = "Type here..." } = $$props;
	let { label } = $$props;
	let { disabled = false } = $$props;
	let { show_label = true } = $$props;
	let { max_lines } = $$props;
	let el;
	const dispatch = createEventDispatcher();

	function handle_change(val) {
		dispatch("change", val);
	}

	async function handle_keypress(e) {
		await tick();

		if (e.key === "Enter" && e.shiftKey && lines > 1) {
			e.preventDefault();
			dispatch("submit");
		} else if (e.key === "Enter" && !e.shiftKey && lines === 1 && max_lines >= 1) {
			e.preventDefault();
			dispatch("submit");
		}
	}

	async function resize(event) {
		await tick();
		if (lines === max_lines) return;

		let max = max_lines === false
		? false
		: max_lines === undefined ? 21 * 11 : 21 * (max_lines + 1); // default

		let min = 21 * (lines + 1);
		const target = event.target;
		target.style.height = "1px";
		let scroll_height;

		if (max && target.scrollHeight > max) {
			scroll_height = max;
		} else if (target.scrollHeight < min) {
			scroll_height = min;
		} else {
			scroll_height = target.scrollHeight;
		}

		target.style.height = `${scroll_height}px`;
	}

	function text_area_resize(el, value) {
		if (lines === max_lines) return;
		el.style.overflowY = "scroll";
		el.addEventListener("input", resize);
		if (!value.trim()) return;
		resize({ target: el });

		return {
			destroy: () => el.removeEventListener("input", resize)
		};
	}

	function input_input_handler() {
		value = this.value;
		$$invalidate(0, value);
	}

	function input_binding($$value) {
		binding_callbacks[$$value ? 'unshift' : 'push'](() => {
			el = $$value;
			$$invalidate(7, el);
		});
	}

	function textarea_input_handler() {
		value = this.value;
		$$invalidate(0, value);
	}

	function textarea_binding($$value) {
		binding_callbacks[$$value ? 'unshift' : 'push'](() => {
			el = $$value;
			$$invalidate(7, el);
		});
	}

	$$self.$$set = $$props => {
		if ('value' in $$props) $$invalidate(0, value = $$props.value);
		if ('lines' in $$props) $$invalidate(1, lines = $$props.lines);
		if ('placeholder' in $$props) $$invalidate(2, placeholder = $$props.placeholder);
		if ('label' in $$props) $$invalidate(3, label = $$props.label);
		if ('disabled' in $$props) $$invalidate(4, disabled = $$props.disabled);
		if ('show_label' in $$props) $$invalidate(5, show_label = $$props.show_label);
		if ('max_lines' in $$props) $$invalidate(6, max_lines = $$props.max_lines);
	};

	$$self.$$.update = () => {
		if ($$self.$$.dirty & /*value, el, lines, max_lines*/ 195) {
			(el && lines !== max_lines && resize({ target: el }));
		}

		if ($$self.$$.dirty & /*value*/ 1) {
			handle_change(value);
		}
	};

	return [
		value,
		lines,
		placeholder,
		label,
		disabled,
		show_label,
		max_lines,
		el,
		handle_keypress,
		text_area_resize,
		input_input_handler,
		input_binding,
		textarea_input_handler,
		textarea_binding
	];
}

class Textbox$2 extends SvelteComponent {
	constructor(options) {
		super();

		init(this, options, instance$1, create_fragment$1, safe_not_equal, {
			value: 0,
			lines: 1,
			placeholder: 2,
			label: 3,
			disabled: 4,
			show_label: 5,
			max_lines: 6
		});
	}
}

/* src/components/Textbox/Textbox.svelte generated by Svelte v3.49.0 */

function create_default_slot(ctx) {
	let statustracker;
	let t;
	let textbox;
	let updating_value;
	let current;
	const statustracker_spread_levels = [/*loading_status*/ ctx[9]];
	let statustracker_props = {};

	for (let i = 0; i < statustracker_spread_levels.length; i += 1) {
		statustracker_props = assign(statustracker_props, statustracker_spread_levels[i]);
	}

	statustracker = new StatusTracker({ props: statustracker_props });

	function textbox_value_binding(value) {
		/*textbox_value_binding*/ ctx[11](value);
	}

	let textbox_props = {
		label: /*label*/ ctx[1],
		show_label: /*show_label*/ ctx[6],
		lines: /*lines*/ ctx[4],
		max_lines: !/*max_lines*/ ctx[7] && /*mode*/ ctx[10] === "static"
		? /*lines*/ ctx[4] + 1
		: /*max_lines*/ ctx[7],
		placeholder: /*placeholder*/ ctx[5],
		disabled: /*mode*/ ctx[10] === "static"
	};

	if (/*value*/ ctx[0] !== void 0) {
		textbox_props.value = /*value*/ ctx[0];
	}

	textbox = new Textbox$2({ props: textbox_props });
	binding_callbacks.push(() => bind(textbox, 'value', textbox_value_binding));
	textbox.$on("change", /*change_handler*/ ctx[12]);
	textbox.$on("submit", /*submit_handler*/ ctx[13]);

	return {
		c() {
			create_component(statustracker.$$.fragment);
			t = space();
			create_component(textbox.$$.fragment);
		},
		m(target, anchor) {
			mount_component(statustracker, target, anchor);
			insert(target, t, anchor);
			mount_component(textbox, target, anchor);
			current = true;
		},
		p(ctx, dirty) {
			const statustracker_changes = (dirty & /*loading_status*/ 512)
			? get_spread_update(statustracker_spread_levels, [get_spread_object(/*loading_status*/ ctx[9])])
			: {};

			statustracker.$set(statustracker_changes);
			const textbox_changes = {};
			if (dirty & /*label*/ 2) textbox_changes.label = /*label*/ ctx[1];
			if (dirty & /*show_label*/ 64) textbox_changes.show_label = /*show_label*/ ctx[6];
			if (dirty & /*lines*/ 16) textbox_changes.lines = /*lines*/ ctx[4];

			if (dirty & /*max_lines, mode, lines*/ 1168) textbox_changes.max_lines = !/*max_lines*/ ctx[7] && /*mode*/ ctx[10] === "static"
			? /*lines*/ ctx[4] + 1
			: /*max_lines*/ ctx[7];

			if (dirty & /*placeholder*/ 32) textbox_changes.placeholder = /*placeholder*/ ctx[5];
			if (dirty & /*mode*/ 1024) textbox_changes.disabled = /*mode*/ ctx[10] === "static";

			if (!updating_value && dirty & /*value*/ 1) {
				updating_value = true;
				textbox_changes.value = /*value*/ ctx[0];
				add_flush_callback(() => updating_value = false);
			}

			textbox.$set(textbox_changes);
		},
		i(local) {
			if (current) return;
			transition_in(statustracker.$$.fragment, local);
			transition_in(textbox.$$.fragment, local);
			current = true;
		},
		o(local) {
			transition_out(statustracker.$$.fragment, local);
			transition_out(textbox.$$.fragment, local);
			current = false;
		},
		d(detaching) {
			destroy_component(statustracker, detaching);
			if (detaching) detach(t);
			destroy_component(textbox, detaching);
		}
	};
}

function create_fragment(ctx) {
	let block;
	let current;

	block = new Block({
			props: {
				visible: /*visible*/ ctx[3],
				elem_id: /*elem_id*/ ctx[2],
				disable: typeof /*style*/ ctx[8].container === "boolean" && !/*style*/ ctx[8].container,
				$$slots: { default: [create_default_slot] },
				$$scope: { ctx }
			}
		});

	return {
		c() {
			create_component(block.$$.fragment);
		},
		m(target, anchor) {
			mount_component(block, target, anchor);
			current = true;
		},
		p(ctx, [dirty]) {
			const block_changes = {};
			if (dirty & /*visible*/ 8) block_changes.visible = /*visible*/ ctx[3];
			if (dirty & /*elem_id*/ 4) block_changes.elem_id = /*elem_id*/ ctx[2];
			if (dirty & /*style*/ 256) block_changes.disable = typeof /*style*/ ctx[8].container === "boolean" && !/*style*/ ctx[8].container;

			if (dirty & /*$$scope, label, show_label, lines, max_lines, mode, placeholder, value, loading_status*/ 18163) {
				block_changes.$$scope = { dirty, ctx };
			}

			block.$set(block_changes);
		},
		i(local) {
			if (current) return;
			transition_in(block.$$.fragment, local);
			current = true;
		},
		o(local) {
			transition_out(block.$$.fragment, local);
			current = false;
		},
		d(detaching) {
			destroy_component(block, detaching);
		}
	};
}

function instance($$self, $$props, $$invalidate) {
	let { label = "Textbox" } = $$props;
	let { elem_id = "" } = $$props;
	let { visible = true } = $$props;
	let { value = "" } = $$props;
	let { lines } = $$props;
	let { placeholder = "" } = $$props;
	let { show_label } = $$props;
	let { max_lines } = $$props;
	let { style = {} } = $$props;
	let { loading_status } = $$props;
	let { mode } = $$props;

	function textbox_value_binding(value$1) {
		value = value$1;
		$$invalidate(0, value);
	}

	function change_handler(event) {
		bubble.call(this, $$self, event);
	}

	function submit_handler(event) {
		bubble.call(this, $$self, event);
	}

	$$self.$$set = $$props => {
		if ('label' in $$props) $$invalidate(1, label = $$props.label);
		if ('elem_id' in $$props) $$invalidate(2, elem_id = $$props.elem_id);
		if ('visible' in $$props) $$invalidate(3, visible = $$props.visible);
		if ('value' in $$props) $$invalidate(0, value = $$props.value);
		if ('lines' in $$props) $$invalidate(4, lines = $$props.lines);
		if ('placeholder' in $$props) $$invalidate(5, placeholder = $$props.placeholder);
		if ('show_label' in $$props) $$invalidate(6, show_label = $$props.show_label);
		if ('max_lines' in $$props) $$invalidate(7, max_lines = $$props.max_lines);
		if ('style' in $$props) $$invalidate(8, style = $$props.style);
		if ('loading_status' in $$props) $$invalidate(9, loading_status = $$props.loading_status);
		if ('mode' in $$props) $$invalidate(10, mode = $$props.mode);
	};

	return [
		value,
		label,
		elem_id,
		visible,
		lines,
		placeholder,
		show_label,
		max_lines,
		style,
		loading_status,
		mode,
		textbox_value_binding,
		change_handler,
		submit_handler
	];
}

class Textbox extends SvelteComponent {
	constructor(options) {
		super();

		init(this, options, instance, create_fragment, safe_not_equal, {
			label: 1,
			elem_id: 2,
			visible: 3,
			value: 0,
			lines: 4,
			placeholder: 5,
			show_label: 6,
			max_lines: 7,
			style: 8,
			loading_status: 9,
			mode: 10
		});
	}

	get label() {
		return this.$$.ctx[1];
	}

	set label(label) {
		this.$$set({ label });
		flush();
	}

	get elem_id() {
		return this.$$.ctx[2];
	}

	set elem_id(elem_id) {
		this.$$set({ elem_id });
		flush();
	}

	get visible() {
		return this.$$.ctx[3];
	}

	set visible(visible) {
		this.$$set({ visible });
		flush();
	}

	get value() {
		return this.$$.ctx[0];
	}

	set value(value) {
		this.$$set({ value });
		flush();
	}

	get lines() {
		return this.$$.ctx[4];
	}

	set lines(lines) {
		this.$$set({ lines });
		flush();
	}

	get placeholder() {
		return this.$$.ctx[5];
	}

	set placeholder(placeholder) {
		this.$$set({ placeholder });
		flush();
	}

	get show_label() {
		return this.$$.ctx[6];
	}

	set show_label(show_label) {
		this.$$set({ show_label });
		flush();
	}

	get max_lines() {
		return this.$$.ctx[7];
	}

	set max_lines(max_lines) {
		this.$$set({ max_lines });
		flush();
	}

	get style() {
		return this.$$.ctx[8];
	}

	set style(style) {
		this.$$set({ style });
		flush();
	}

	get loading_status() {
		return this.$$.ctx[9];
	}

	set loading_status(loading_status) {
		this.$$set({ loading_status });
		flush();
	}

	get mode() {
		return this.$$.ctx[10];
	}

	set mode(mode) {
		this.$$set({ mode });
		flush();
	}
}

var Textbox$1 = Textbox;

const modes = ["static", "dynamic"];

export { Textbox$1 as Component, modes };
