import { S as SvelteComponent, i as init, s as safe_not_equal, f as element, m as space, h as text, b as attr, t as toggle_class, c as insert, d as append, l as listen, j as set_data, e as detach, q as create_component, u as mount_component, v as transition_in, w as transition_out, x as destroy_component, o as destroy_each, A as createEventDispatcher, L as assign, M as StatusTracker, D as binding_callbacks, J as bind, N as get_spread_update, O as get_spread_object, G as add_flush_callback, F as bubble } from './index.73d5e133.js';
import { g as get_styles } from './styles.db46e346.js';
import { B as BlockTitle } from './BlockTitle.58812728.js';
import { B as Block } from './Block.737700ca.js';

/* home/runner/work/gradio/gradio/ui/packages/form/src/CheckboxGroup.svelte generated by Svelte v3.47.0 */

function get_each_context(ctx, list, i) {
	const child_ctx = ctx.slice();
	child_ctx[12] = list[i];
	child_ctx[14] = i;
	return child_ctx;
}

// (28:0) <BlockTitle {show_label}>
function create_default_slot$1(ctx) {
	let t;

	return {
		c() {
			t = text(/*label*/ ctx[3]);
		},
		m(target, anchor) {
			insert(target, t, anchor);
		},
		p(ctx, dirty) {
			if (dirty & /*label*/ 8) set_data(t, /*label*/ ctx[3]);
		},
		d(detaching) {
			if (detaching) detach(t);
		}
	};
}

// (31:1) {#each choices as choice, i}
function create_each_block(ctx) {
	let label_1;
	let input;
	let input_checked_value;
	let input_class_value;
	let t0;
	let span;
	let t1_value = /*choice*/ ctx[12] + "";
	let t1;
	let label_1_class_value;
	let mounted;
	let dispose;

	function change_handler() {
		return /*change_handler*/ ctx[10](/*choice*/ ctx[12]);
	}

	return {
		c() {
			label_1 = element("label");
			input = element("input");
			t0 = space();
			span = element("span");
			t1 = text(t1_value);
			input.disabled = /*disabled*/ ctx[2];
			input.checked = input_checked_value = /*value*/ ctx[0].includes(/*choice*/ ctx[12]);
			attr(input, "type", "checkbox");
			attr(input, "name", "test");
			attr(input, "class", input_class_value = "gr-check-radio gr-checkbox " + /*rounded*/ ctx[7] + " " + /*border*/ ctx[6]);
			attr(span, "class", "ml-2");
			attr(label_1, "class", label_1_class_value = "gr-input-label flex items-center text-gray-700 text-sm space-x-2 border py-1.5 px-3 rounded-lg cursor-pointer bg-white shadow-sm checked:shadow-inner " + /*item_container*/ ctx[5]);
			toggle_class(label_1, "!cursor-not-allowed", /*disabled*/ ctx[2]);
		},
		m(target, anchor) {
			insert(target, label_1, anchor);
			append(label_1, input);
			append(label_1, t0);
			append(label_1, span);
			append(span, t1);

			if (!mounted) {
				dispose = listen(input, "change", change_handler);
				mounted = true;
			}
		},
		p(new_ctx, dirty) {
			ctx = new_ctx;

			if (dirty & /*disabled*/ 4) {
				input.disabled = /*disabled*/ ctx[2];
			}

			if (dirty & /*value, choices*/ 3 && input_checked_value !== (input_checked_value = /*value*/ ctx[0].includes(/*choice*/ ctx[12]))) {
				input.checked = input_checked_value;
			}

			if (dirty & /*rounded, border*/ 192 && input_class_value !== (input_class_value = "gr-check-radio gr-checkbox " + /*rounded*/ ctx[7] + " " + /*border*/ ctx[6])) {
				attr(input, "class", input_class_value);
			}

			if (dirty & /*choices*/ 2 && t1_value !== (t1_value = /*choice*/ ctx[12] + "")) set_data(t1, t1_value);

			if (dirty & /*item_container*/ 32 && label_1_class_value !== (label_1_class_value = "gr-input-label flex items-center text-gray-700 text-sm space-x-2 border py-1.5 px-3 rounded-lg cursor-pointer bg-white shadow-sm checked:shadow-inner " + /*item_container*/ ctx[5])) {
				attr(label_1, "class", label_1_class_value);
			}

			if (dirty & /*item_container, disabled*/ 36) {
				toggle_class(label_1, "!cursor-not-allowed", /*disabled*/ ctx[2]);
			}
		},
		d(detaching) {
			if (detaching) detach(label_1);
			mounted = false;
			dispose();
		}
	};
}

function create_fragment$1(ctx) {
	let blocktitle;
	let t;
	let div;
	let current;

	blocktitle = new BlockTitle({
			props: {
				show_label: /*show_label*/ ctx[4],
				$$slots: { default: [create_default_slot$1] },
				$$scope: { ctx }
			}
		});

	let each_value = /*choices*/ ctx[1];
	let each_blocks = [];

	for (let i = 0; i < each_value.length; i += 1) {
		each_blocks[i] = create_each_block(get_each_context(ctx, each_value, i));
	}

	return {
		c() {
			create_component(blocktitle.$$.fragment);
			t = space();
			div = element("div");

			for (let i = 0; i < each_blocks.length; i += 1) {
				each_blocks[i].c();
			}

			attr(div, "class", "flex flex-wrap gap-2");
			attr(div, "data-testid", "checkbox-group");
		},
		m(target, anchor) {
			mount_component(blocktitle, target, anchor);
			insert(target, t, anchor);
			insert(target, div, anchor);

			for (let i = 0; i < each_blocks.length; i += 1) {
				each_blocks[i].m(div, null);
			}

			current = true;
		},
		p(ctx, [dirty]) {
			const blocktitle_changes = {};
			if (dirty & /*show_label*/ 16) blocktitle_changes.show_label = /*show_label*/ ctx[4];

			if (dirty & /*$$scope, label*/ 32776) {
				blocktitle_changes.$$scope = { dirty, ctx };
			}

			blocktitle.$set(blocktitle_changes);

			if (dirty & /*item_container, disabled, choices, value, rounded, border, toggleChoice*/ 487) {
				each_value = /*choices*/ ctx[1];
				let i;

				for (i = 0; i < each_value.length; i += 1) {
					const child_ctx = get_each_context(ctx, each_value, i);

					if (each_blocks[i]) {
						each_blocks[i].p(child_ctx, dirty);
					} else {
						each_blocks[i] = create_each_block(child_ctx);
						each_blocks[i].c();
						each_blocks[i].m(div, null);
					}
				}

				for (; i < each_blocks.length; i += 1) {
					each_blocks[i].d(1);
				}

				each_blocks.length = each_value.length;
			}
		},
		i(local) {
			if (current) return;
			transition_in(blocktitle.$$.fragment, local);
			current = true;
		},
		o(local) {
			transition_out(blocktitle.$$.fragment, local);
			current = false;
		},
		d(detaching) {
			destroy_component(blocktitle, detaching);
			if (detaching) detach(t);
			if (detaching) detach(div);
			destroy_each(each_blocks, detaching);
		}
	};
}

function instance$1($$self, $$props, $$invalidate) {
	let rounded;
	let border;
	let item_container;
	let { value = [] } = $$props;
	let { style = {} } = $$props;
	let { choices } = $$props;
	let { disabled = false } = $$props;
	let { label } = $$props;
	let { show_label } = $$props;
	const dispatch = createEventDispatcher();

	const toggleChoice = choice => {
		if (value.includes(choice)) {
			value.splice(value.indexOf(choice), 1);
		} else {
			value.push(choice);
		}

		dispatch("change", value);
		$$invalidate(0, value);
	};

	const change_handler = choice => toggleChoice(choice);

	$$self.$$set = $$props => {
		if ('value' in $$props) $$invalidate(0, value = $$props.value);
		if ('style' in $$props) $$invalidate(9, style = $$props.style);
		if ('choices' in $$props) $$invalidate(1, choices = $$props.choices);
		if ('disabled' in $$props) $$invalidate(2, disabled = $$props.disabled);
		if ('label' in $$props) $$invalidate(3, label = $$props.label);
		if ('show_label' in $$props) $$invalidate(4, show_label = $$props.show_label);
	};

	$$self.$$.update = () => {
		if ($$self.$$.dirty & /*style*/ 512) {
			$$invalidate(7, { rounded, border, item_container } = get_styles(style, ["rounded", "border", "item_container"]), rounded, ($$invalidate(6, border), $$invalidate(9, style)), ($$invalidate(5, item_container), $$invalidate(9, style)));
		}
	};

	return [
		value,
		choices,
		disabled,
		label,
		show_label,
		item_container,
		border,
		rounded,
		toggleChoice,
		style,
		change_handler
	];
}

class CheckboxGroup extends SvelteComponent {
	constructor(options) {
		super();

		init(this, options, instance$1, create_fragment$1, safe_not_equal, {
			value: 0,
			style: 9,
			choices: 1,
			disabled: 2,
			label: 3,
			show_label: 4
		});
	}
}

/* src/components/CheckboxGroup/CheckboxGroup.svelte generated by Svelte v3.47.0 */

function create_default_slot(ctx) {
	let statustracker;
	let t;
	let checkboxgroup;
	let updating_value;
	let current;
	const statustracker_spread_levels = [/*loading_status*/ ctx[9]];
	let statustracker_props = {};

	for (let i = 0; i < statustracker_spread_levels.length; i += 1) {
		statustracker_props = assign(statustracker_props, statustracker_spread_levels[i]);
	}

	statustracker = new StatusTracker({ props: statustracker_props });

	function checkboxgroup_value_binding(value) {
		/*checkboxgroup_value_binding*/ ctx[10](value);
	}

	let checkboxgroup_props = {
		choices: /*choices*/ ctx[3],
		label: /*label*/ ctx[6],
		style: /*style*/ ctx[4],
		show_label: /*show_label*/ ctx[8],
		disabled: /*mode*/ ctx[5] === "static"
	};

	if (/*value*/ ctx[0] !== void 0) {
		checkboxgroup_props.value = /*value*/ ctx[0];
	}

	checkboxgroup = new CheckboxGroup({ props: checkboxgroup_props });
	binding_callbacks.push(() => bind(checkboxgroup, 'value', checkboxgroup_value_binding));
	checkboxgroup.$on("change", /*change_handler*/ ctx[11]);

	return {
		c() {
			create_component(statustracker.$$.fragment);
			t = space();
			create_component(checkboxgroup.$$.fragment);
		},
		m(target, anchor) {
			mount_component(statustracker, target, anchor);
			insert(target, t, anchor);
			mount_component(checkboxgroup, target, anchor);
			current = true;
		},
		p(ctx, dirty) {
			const statustracker_changes = (dirty & /*loading_status*/ 512)
			? get_spread_update(statustracker_spread_levels, [get_spread_object(/*loading_status*/ ctx[9])])
			: {};

			statustracker.$set(statustracker_changes);
			const checkboxgroup_changes = {};
			if (dirty & /*choices*/ 8) checkboxgroup_changes.choices = /*choices*/ ctx[3];
			if (dirty & /*label*/ 64) checkboxgroup_changes.label = /*label*/ ctx[6];
			if (dirty & /*style*/ 16) checkboxgroup_changes.style = /*style*/ ctx[4];
			if (dirty & /*show_label*/ 256) checkboxgroup_changes.show_label = /*show_label*/ ctx[8];
			if (dirty & /*mode*/ 32) checkboxgroup_changes.disabled = /*mode*/ ctx[5] === "static";

			if (!updating_value && dirty & /*value*/ 1) {
				updating_value = true;
				checkboxgroup_changes.value = /*value*/ ctx[0];
				add_flush_callback(() => updating_value = false);
			}

			checkboxgroup.$set(checkboxgroup_changes);
		},
		i(local) {
			if (current) return;
			transition_in(statustracker.$$.fragment, local);
			transition_in(checkboxgroup.$$.fragment, local);
			current = true;
		},
		o(local) {
			transition_out(statustracker.$$.fragment, local);
			transition_out(checkboxgroup.$$.fragment, local);
			current = false;
		},
		d(detaching) {
			destroy_component(statustracker, detaching);
			if (detaching) detach(t);
			destroy_component(checkboxgroup, detaching);
		}
	};
}

function create_fragment(ctx) {
	let block;
	let current;

	block = new Block({
			props: {
				visible: /*visible*/ ctx[2],
				form_position: /*form_position*/ ctx[7],
				elem_id: /*elem_id*/ ctx[1],
				type: "fieldset",
				disable: typeof /*style*/ ctx[4].container === "boolean" && !/*style*/ ctx[4].container,
				$$slots: { default: [create_default_slot] },
				$$scope: { ctx }
			}
		});

	return {
		c() {
			create_component(block.$$.fragment);
		},
		m(target, anchor) {
			mount_component(block, target, anchor);
			current = true;
		},
		p(ctx, [dirty]) {
			const block_changes = {};
			if (dirty & /*visible*/ 4) block_changes.visible = /*visible*/ ctx[2];
			if (dirty & /*form_position*/ 128) block_changes.form_position = /*form_position*/ ctx[7];
			if (dirty & /*elem_id*/ 2) block_changes.elem_id = /*elem_id*/ ctx[1];
			if (dirty & /*style*/ 16) block_changes.disable = typeof /*style*/ ctx[4].container === "boolean" && !/*style*/ ctx[4].container;

			if (dirty & /*$$scope, choices, label, style, show_label, mode, value, loading_status*/ 4985) {
				block_changes.$$scope = { dirty, ctx };
			}

			block.$set(block_changes);
		},
		i(local) {
			if (current) return;
			transition_in(block.$$.fragment, local);
			current = true;
		},
		o(local) {
			transition_out(block.$$.fragment, local);
			current = false;
		},
		d(detaching) {
			destroy_component(block, detaching);
		}
	};
}

function instance($$self, $$props, $$invalidate) {
	let { elem_id = "" } = $$props;
	let { visible = true } = $$props;
	let { value = [] } = $$props;
	let { choices } = $$props;
	let { style = {} } = $$props;
	let { mode } = $$props;
	let { label = "Checkbox Group" } = $$props;
	let { form_position = "single" } = $$props;
	let { show_label } = $$props;
	let { loading_status } = $$props;

	function checkboxgroup_value_binding(value$1) {
		value = value$1;
		$$invalidate(0, value);
	}

	function change_handler(event) {
		bubble.call(this, $$self, event);
	}

	$$self.$$set = $$props => {
		if ('elem_id' in $$props) $$invalidate(1, elem_id = $$props.elem_id);
		if ('visible' in $$props) $$invalidate(2, visible = $$props.visible);
		if ('value' in $$props) $$invalidate(0, value = $$props.value);
		if ('choices' in $$props) $$invalidate(3, choices = $$props.choices);
		if ('style' in $$props) $$invalidate(4, style = $$props.style);
		if ('mode' in $$props) $$invalidate(5, mode = $$props.mode);
		if ('label' in $$props) $$invalidate(6, label = $$props.label);
		if ('form_position' in $$props) $$invalidate(7, form_position = $$props.form_position);
		if ('show_label' in $$props) $$invalidate(8, show_label = $$props.show_label);
		if ('loading_status' in $$props) $$invalidate(9, loading_status = $$props.loading_status);
	};

	return [
		value,
		elem_id,
		visible,
		choices,
		style,
		mode,
		label,
		form_position,
		show_label,
		loading_status,
		checkboxgroup_value_binding,
		change_handler
	];
}

class CheckboxGroup_1 extends SvelteComponent {
	constructor(options) {
		super();

		init(this, options, instance, create_fragment, safe_not_equal, {
			elem_id: 1,
			visible: 2,
			value: 0,
			choices: 3,
			style: 4,
			mode: 5,
			label: 6,
			form_position: 7,
			show_label: 8,
			loading_status: 9
		});
	}
}

var CheckboxGroup_1$1 = CheckboxGroup_1;

const modes = ["static", "dynamic"];

export { CheckboxGroup_1$1 as Component, modes };
