import { S as SvelteComponent, i as init, s as safe_not_equal, f as element, q as create_component, m as space, b as attr, c as insert, u as mount_component, d as append, a2 as set_input_value, l as listen, ai as to_number, v as transition_in, w as transition_out, e as detach, x as destroy_component, r as run_all, A as createEventDispatcher, h as text, j as set_data, a5 as tick, L as assign, M as StatusTracker, D as binding_callbacks, J as bind, N as get_spread_update, O as get_spread_object, G as add_flush_callback, F as bubble } from './index.73d5e133.js';
import { B as Block } from './Block.737700ca.js';
import { g as get_styles } from './styles.db46e346.js';
import { B as BlockTitle } from './BlockTitle.58812728.js';

/* home/runner/work/gradio/gradio/ui/packages/form/src/Number.svelte generated by Svelte v3.47.0 */

function create_default_slot$1(ctx) {
	let t;

	return {
		c() {
			t = text(/*label*/ ctx[2]);
		},
		m(target, anchor) {
			insert(target, t, anchor);
		},
		p(ctx, dirty) {
			if (dirty & /*label*/ 4) set_data(t, /*label*/ ctx[2]);
		},
		d(detaching) {
			if (detaching) detach(t);
		}
	};
}

function create_fragment$1(ctx) {
	let label_1;
	let blocktitle;
	let t;
	let input;
	let input_class_value;
	let current;
	let mounted;
	let dispose;

	blocktitle = new BlockTitle({
			props: {
				show_label: /*show_label*/ ctx[3],
				$$slots: { default: [create_default_slot$1] },
				$$scope: { ctx }
			}
		});

	return {
		c() {
			label_1 = element("label");
			create_component(blocktitle.$$.fragment);
			t = space();
			input = element("input");
			attr(input, "type", "number");
			attr(input, "class", input_class_value = "gr-box gr-input w-full gr-text-input " + /*classes*/ ctx[4]);
			input.disabled = /*disabled*/ ctx[1];
			attr(label_1, "class", "block");
		},
		m(target, anchor) {
			insert(target, label_1, anchor);
			mount_component(blocktitle, label_1, null);
			append(label_1, t);
			append(label_1, input);
			set_input_value(input, /*value*/ ctx[0]);
			current = true;

			if (!mounted) {
				dispose = [
					listen(input, "input", /*input_input_handler*/ ctx[7]),
					listen(input, "keypress", /*handle_keypress*/ ctx[5])
				];

				mounted = true;
			}
		},
		p(ctx, [dirty]) {
			const blocktitle_changes = {};
			if (dirty & /*show_label*/ 8) blocktitle_changes.show_label = /*show_label*/ ctx[3];

			if (dirty & /*$$scope, label*/ 1028) {
				blocktitle_changes.$$scope = { dirty, ctx };
			}

			blocktitle.$set(blocktitle_changes);

			if (!current || dirty & /*classes*/ 16 && input_class_value !== (input_class_value = "gr-box gr-input w-full gr-text-input " + /*classes*/ ctx[4])) {
				attr(input, "class", input_class_value);
			}

			if (!current || dirty & /*disabled*/ 2) {
				input.disabled = /*disabled*/ ctx[1];
			}

			if (dirty & /*value*/ 1 && to_number(input.value) !== /*value*/ ctx[0]) {
				set_input_value(input, /*value*/ ctx[0]);
			}
		},
		i(local) {
			if (current) return;
			transition_in(blocktitle.$$.fragment, local);
			current = true;
		},
		o(local) {
			transition_out(blocktitle.$$.fragment, local);
			current = false;
		},
		d(detaching) {
			if (detaching) detach(label_1);
			destroy_component(blocktitle);
			mounted = false;
			run_all(dispose);
		}
	};
}

function instance$1($$self, $$props, $$invalidate) {
	let classes;
	let { value = 0 } = $$props;
	let { style = {} } = $$props;
	let { disabled = false } = $$props;
	let { label } = $$props;
	let { show_label } = $$props;
	const dispatch = createEventDispatcher();

	function handle_change(n) {
		if (!isNaN(n) && n !== null) {
			dispatch("change", n);
		}
	}

	async function handle_keypress(e) {
		await tick();

		if (e.key === "Enter") {
			e.preventDefault();
			dispatch("submit");
		}
	}

	function input_input_handler() {
		value = to_number(this.value);
		$$invalidate(0, value);
	}

	$$self.$$set = $$props => {
		if ('value' in $$props) $$invalidate(0, value = $$props.value);
		if ('style' in $$props) $$invalidate(6, style = $$props.style);
		if ('disabled' in $$props) $$invalidate(1, disabled = $$props.disabled);
		if ('label' in $$props) $$invalidate(2, label = $$props.label);
		if ('show_label' in $$props) $$invalidate(3, show_label = $$props.show_label);
	};

	$$self.$$.update = () => {
		if ($$self.$$.dirty & /*value*/ 1) {
			handle_change(value);
		}

		if ($$self.$$.dirty & /*style*/ 64) {
			$$invalidate(4, { classes } = get_styles(style, ["rounded", "border"]), classes);
		}
	};

	return [
		value,
		disabled,
		label,
		show_label,
		classes,
		handle_keypress,
		style,
		input_input_handler
	];
}

class Number extends SvelteComponent {
	constructor(options) {
		super();

		init(this, options, instance$1, create_fragment$1, safe_not_equal, {
			value: 0,
			style: 6,
			disabled: 1,
			label: 2,
			show_label: 3
		});
	}
}

/* src/components/Number/Number.svelte generated by Svelte v3.47.0 */

function create_default_slot(ctx) {
	let statustracker;
	let t;
	let number;
	let updating_value;
	let current;
	const statustracker_spread_levels = [/*loading_status*/ ctx[7]];
	let statustracker_props = {};

	for (let i = 0; i < statustracker_spread_levels.length; i += 1) {
		statustracker_props = assign(statustracker_props, statustracker_spread_levels[i]);
	}

	statustracker = new StatusTracker({ props: statustracker_props });

	function number_value_binding(value) {
		/*number_value_binding*/ ctx[9](value);
	}

	let number_props = {
		label: /*label*/ ctx[1],
		show_label: /*show_label*/ ctx[6],
		style: /*style*/ ctx[4],
		disabled: /*mode*/ ctx[8] === "static"
	};

	if (/*value*/ ctx[0] !== void 0) {
		number_props.value = /*value*/ ctx[0];
	}

	number = new Number({ props: number_props });
	binding_callbacks.push(() => bind(number, 'value', number_value_binding));
	number.$on("change", /*change_handler*/ ctx[10]);
	number.$on("submit", /*submit_handler*/ ctx[11]);

	return {
		c() {
			create_component(statustracker.$$.fragment);
			t = space();
			create_component(number.$$.fragment);
		},
		m(target, anchor) {
			mount_component(statustracker, target, anchor);
			insert(target, t, anchor);
			mount_component(number, target, anchor);
			current = true;
		},
		p(ctx, dirty) {
			const statustracker_changes = (dirty & /*loading_status*/ 128)
			? get_spread_update(statustracker_spread_levels, [get_spread_object(/*loading_status*/ ctx[7])])
			: {};

			statustracker.$set(statustracker_changes);
			const number_changes = {};
			if (dirty & /*label*/ 2) number_changes.label = /*label*/ ctx[1];
			if (dirty & /*show_label*/ 64) number_changes.show_label = /*show_label*/ ctx[6];
			if (dirty & /*style*/ 16) number_changes.style = /*style*/ ctx[4];
			if (dirty & /*mode*/ 256) number_changes.disabled = /*mode*/ ctx[8] === "static";

			if (!updating_value && dirty & /*value*/ 1) {
				updating_value = true;
				number_changes.value = /*value*/ ctx[0];
				add_flush_callback(() => updating_value = false);
			}

			number.$set(number_changes);
		},
		i(local) {
			if (current) return;
			transition_in(statustracker.$$.fragment, local);
			transition_in(number.$$.fragment, local);
			current = true;
		},
		o(local) {
			transition_out(statustracker.$$.fragment, local);
			transition_out(number.$$.fragment, local);
			current = false;
		},
		d(detaching) {
			destroy_component(statustracker, detaching);
			if (detaching) detach(t);
			destroy_component(number, detaching);
		}
	};
}

function create_fragment(ctx) {
	let block;
	let current;

	block = new Block({
			props: {
				visible: /*visible*/ ctx[3],
				form_position: /*form_position*/ ctx[5],
				elem_id: /*elem_id*/ ctx[2],
				disable: typeof /*style*/ ctx[4].container === "boolean" && !/*style*/ ctx[4].container,
				$$slots: { default: [create_default_slot] },
				$$scope: { ctx }
			}
		});

	return {
		c() {
			create_component(block.$$.fragment);
		},
		m(target, anchor) {
			mount_component(block, target, anchor);
			current = true;
		},
		p(ctx, [dirty]) {
			const block_changes = {};
			if (dirty & /*visible*/ 8) block_changes.visible = /*visible*/ ctx[3];
			if (dirty & /*form_position*/ 32) block_changes.form_position = /*form_position*/ ctx[5];
			if (dirty & /*elem_id*/ 4) block_changes.elem_id = /*elem_id*/ ctx[2];
			if (dirty & /*style*/ 16) block_changes.disable = typeof /*style*/ ctx[4].container === "boolean" && !/*style*/ ctx[4].container;

			if (dirty & /*$$scope, label, show_label, style, mode, value, loading_status*/ 4563) {
				block_changes.$$scope = { dirty, ctx };
			}

			block.$set(block_changes);
		},
		i(local) {
			if (current) return;
			transition_in(block.$$.fragment, local);
			current = true;
		},
		o(local) {
			transition_out(block.$$.fragment, local);
			current = false;
		},
		d(detaching) {
			destroy_component(block, detaching);
		}
	};
}

function instance($$self, $$props, $$invalidate) {
	let { label = "Number" } = $$props;
	let { elem_id = "" } = $$props;
	let { visible = true } = $$props;
	let { style = {} } = $$props;
	let { value = 0 } = $$props;
	let { form_position = "single" } = $$props;
	let { show_label } = $$props;
	let { loading_status } = $$props;
	let { mode } = $$props;

	function number_value_binding(value$1) {
		value = value$1;
		$$invalidate(0, value);
	}

	function change_handler(event) {
		bubble.call(this, $$self, event);
	}

	function submit_handler(event) {
		bubble.call(this, $$self, event);
	}

	$$self.$$set = $$props => {
		if ('label' in $$props) $$invalidate(1, label = $$props.label);
		if ('elem_id' in $$props) $$invalidate(2, elem_id = $$props.elem_id);
		if ('visible' in $$props) $$invalidate(3, visible = $$props.visible);
		if ('style' in $$props) $$invalidate(4, style = $$props.style);
		if ('value' in $$props) $$invalidate(0, value = $$props.value);
		if ('form_position' in $$props) $$invalidate(5, form_position = $$props.form_position);
		if ('show_label' in $$props) $$invalidate(6, show_label = $$props.show_label);
		if ('loading_status' in $$props) $$invalidate(7, loading_status = $$props.loading_status);
		if ('mode' in $$props) $$invalidate(8, mode = $$props.mode);
	};

	return [
		value,
		label,
		elem_id,
		visible,
		style,
		form_position,
		show_label,
		loading_status,
		mode,
		number_value_binding,
		change_handler,
		submit_handler
	];
}

class Number_1 extends SvelteComponent {
	constructor(options) {
		super();

		init(this, options, instance, create_fragment, safe_not_equal, {
			label: 1,
			elem_id: 2,
			visible: 3,
			style: 4,
			value: 0,
			form_position: 5,
			show_label: 6,
			loading_status: 7,
			mode: 8
		});
	}
}

var Number_1$1 = Number_1;

const modes = ["static", "dynamic"];

export { Number_1$1 as Component, modes };
