# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from . import _utilities, _tables

__all__ = ['AdminRoleTargets']


class AdminRoleTargets(pulumi.CustomResource):
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 apps: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 groups: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 role_type: Optional[pulumi.Input[str]] = None,
                 user_id: Optional[pulumi.Input[str]] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        """
        Manages targets for administrator roles.

        This resource allows you to define permissions for admin roles into a smaller subset of Groups or Apps within your org.
        You can define admin roles to target Groups, Applications, and Application Instances.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_okta as okta

        example = okta.AdminRoleTargets("example",
            apps=[
                "oidc_client.<app_id>",
                "facebook",
            ],
            role_type="APP_ADMIN",
            user_id="<user_id>")
        ```

        ## Import

        Okta Admin Role Targets can be imported via the Okta ID.

        ```sh
         $ pulumi import okta:index/adminRoleTargets:AdminRoleTargets example <user id>/<role type>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] apps: List of app names (name represents set of app instances) or a combination of app name and app instance ID (like 'salesforce' or 'facebook.0oapsqQ6dv19pqyEo0g3').
        :param pulumi.Input[Sequence[pulumi.Input[str]]] groups: List of group IDs. Conflicts with `apps`.
        :param pulumi.Input[str] role_type: Name of the role associated with the user.
        :param pulumi.Input[str] user_id: ID of the user.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['apps'] = apps
            __props__['groups'] = groups
            if role_type is None and not opts.urn:
                raise TypeError("Missing required property 'role_type'")
            __props__['role_type'] = role_type
            if user_id is None and not opts.urn:
                raise TypeError("Missing required property 'user_id'")
            __props__['user_id'] = user_id
            __props__['role_id'] = None
        super(AdminRoleTargets, __self__).__init__(
            'okta:index/adminRoleTargets:AdminRoleTargets',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            apps: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            groups: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            role_id: Optional[pulumi.Input[str]] = None,
            role_type: Optional[pulumi.Input[str]] = None,
            user_id: Optional[pulumi.Input[str]] = None) -> 'AdminRoleTargets':
        """
        Get an existing AdminRoleTargets resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] apps: List of app names (name represents set of app instances) or a combination of app name and app instance ID (like 'salesforce' or 'facebook.0oapsqQ6dv19pqyEo0g3').
        :param pulumi.Input[Sequence[pulumi.Input[str]]] groups: List of group IDs. Conflicts with `apps`.
        :param pulumi.Input[str] role_id: Role ID.
        :param pulumi.Input[str] role_type: Name of the role associated with the user.
        :param pulumi.Input[str] user_id: ID of the user.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["apps"] = apps
        __props__["groups"] = groups
        __props__["role_id"] = role_id
        __props__["role_type"] = role_type
        __props__["user_id"] = user_id
        return AdminRoleTargets(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def apps(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        List of app names (name represents set of app instances) or a combination of app name and app instance ID (like 'salesforce' or 'facebook.0oapsqQ6dv19pqyEo0g3').
        """
        return pulumi.get(self, "apps")

    @property
    @pulumi.getter
    def groups(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        List of group IDs. Conflicts with `apps`.
        """
        return pulumi.get(self, "groups")

    @property
    @pulumi.getter(name="roleId")
    def role_id(self) -> pulumi.Output[str]:
        """
        Role ID.
        """
        return pulumi.get(self, "role_id")

    @property
    @pulumi.getter(name="roleType")
    def role_type(self) -> pulumi.Output[str]:
        """
        Name of the role associated with the user.
        """
        return pulumi.get(self, "role_type")

    @property
    @pulumi.getter(name="userId")
    def user_id(self) -> pulumi.Output[str]:
        """
        ID of the user.
        """
        return pulumi.get(self, "user_id")

    def translate_output_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return _tables.SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

