# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from .. import _utilities, _tables

__all__ = [
    'GetAppResult',
    'AwaitableGetAppResult',
    'get_app',
]

@pulumi.output_type
class GetAppResult:
    """
    A collection of values returned by getApp.
    """
    def __init__(__self__, active_only=None, id=None, label=None, label_prefix=None, name=None, status=None):
        if active_only and not isinstance(active_only, bool):
            raise TypeError("Expected argument 'active_only' to be a bool")
        pulumi.set(__self__, "active_only", active_only)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if label and not isinstance(label, str):
            raise TypeError("Expected argument 'label' to be a str")
        pulumi.set(__self__, "label", label)
        if label_prefix and not isinstance(label_prefix, str):
            raise TypeError("Expected argument 'label_prefix' to be a str")
        pulumi.set(__self__, "label_prefix", label_prefix)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="activeOnly")
    def active_only(self) -> Optional[bool]:
        return pulumi.get(self, "active_only")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        `id` of application.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def label(self) -> Optional[str]:
        """
        `label` of application.
        """
        return pulumi.get(self, "label")

    @property
    @pulumi.getter(name="labelPrefix")
    def label_prefix(self) -> Optional[str]:
        return pulumi.get(self, "label_prefix")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        `name` of application.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        `status` of application.
        """
        return pulumi.get(self, "status")


class AwaitableGetAppResult(GetAppResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAppResult(
            active_only=self.active_only,
            id=self.id,
            label=self.label,
            label_prefix=self.label_prefix,
            name=self.name,
            status=self.status)


def get_app(active_only: Optional[bool] = None,
            id: Optional[str] = None,
            label: Optional[str] = None,
            label_prefix: Optional[str] = None,
            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAppResult:
    """
    Use this data source to retrieve the collaborators for a given repository.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_okta as okta

    example = okta.app.get_app(label="Example App")
    ```


    :param bool active_only: tells the provider to query for only `ACTIVE` applications.
    :param str id: `id` of application to retrieve, conflicts with `label` and `label_prefix`.
    :param str label: The label of the app to retrieve, conflicts with `label_prefix` and `id`. Label uses the `?q=<label>` query parameter exposed by Okta's API. It should be noted that at this time this searches both `name` and `label`. This is used to avoid paginating through all applications.
    :param str label_prefix: Label prefix of the app to retrieve, conflicts with `label` and `id`. This will tell the provider to do a `starts with` query as opposed to an `equals` query.
    """
    __args__ = dict()
    __args__['activeOnly'] = active_only
    __args__['id'] = id
    __args__['label'] = label
    __args__['labelPrefix'] = label_prefix
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('okta:app/getApp:getApp', __args__, opts=opts, typ=GetAppResult).value

    return AwaitableGetAppResult(
        active_only=__ret__.active_only,
        id=__ret__.id,
        label=__ret__.label,
        label_prefix=__ret__.label_prefix,
        name=__ret__.name,
        status=__ret__.status)
