# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from .. import _utilities, _tables

__all__ = ['ServerPolicyClaim']

warnings.warn("""okta.auth.ServerPolicyClaim has been deprecated in favor of okta.auth.ServerPolicyRule""", DeprecationWarning)


class ServerPolicyClaim(pulumi.CustomResource):
    warnings.warn("""okta.auth.ServerPolicyClaim has been deprecated in favor of okta.auth.ServerPolicyRule""", DeprecationWarning)

    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_token_lifetime_minutes: Optional[pulumi.Input[int]] = None,
                 auth_server_id: Optional[pulumi.Input[str]] = None,
                 grant_type_whitelists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 group_blacklists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 group_whitelists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 inline_hook_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 policy_id: Optional[pulumi.Input[str]] = None,
                 priority: Optional[pulumi.Input[int]] = None,
                 refresh_token_lifetime_minutes: Optional[pulumi.Input[int]] = None,
                 refresh_token_window_minutes: Optional[pulumi.Input[int]] = None,
                 scope_whitelists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 user_blacklists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 user_whitelists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        """
        Creates an Authorization Server Policy Rule.

        This resource allows you to create and configure an Authorization Server Policy Rule.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_okta as okta

        example = okta.auth.ServerPolicyRule("example",
            auth_server_id="<auth server id>",
            grant_type_whitelists=["implicit"],
            group_whitelists=["<group ids>"],
            policy_id="<auth server policy id>",
            priority=1,
            status="ACTIVE")
        ```

        ## Import

        Authorization Server Policy Rule can be imported via the Auth Server ID, Policy ID, and Policy Rule ID.

        ```sh
         $ pulumi import okta:auth/serverPolicyClaim:ServerPolicyClaim example <auth server id>/<policy id>/<policy rule id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] access_token_lifetime_minutes: Lifetime of access token. Can be set to a value between 5 and 1440 minutes.
        :param pulumi.Input[str] auth_server_id: Auth Server ID.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] grant_type_whitelists: Accepted grant type values, `"authorization_code"`, `"implicit"`, `"password"` or `"client_credentials"`. For `"implicit"` value either `user_whitelist` or `group_whitelist` should be set.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] group_blacklists: Specifies a set of Groups whose Users are to be excluded.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] group_whitelists: Specifies a set of Groups whose Users are to be included. Can be set to Group ID or to the following: "EVERYONE".
        :param pulumi.Input[str] inline_hook_id: The ID of the inline token to trigger.
        :param pulumi.Input[str] name: Auth Server Policy Rule name.
        :param pulumi.Input[str] policy_id: Auth Server Policy ID.
        :param pulumi.Input[int] priority: Priority of the auth server policy rule.
        :param pulumi.Input[int] refresh_token_lifetime_minutes: Lifetime of refresh token.
        :param pulumi.Input[int] refresh_token_window_minutes: Window in which a refresh token can be used. It can be a value between 5 and 2628000 (5 years) minutes.
               `"refresh_token_window_minutes"` must be between `"access_token_lifetime_minutes"` and `"refresh_token_lifetime_minutes"`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] scope_whitelists: Scopes allowed for this policy rule. They can be whitelisted by name or all can be whitelisted with `"*"`.
        :param pulumi.Input[str] status: The status of the Auth Server Policy Rule.
        :param pulumi.Input[str] type: The type of the Auth Server Policy Rule.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] user_blacklists: Specifies a set of Users to be excluded.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] user_whitelists: Specifies a set of Users to be included.
        """
        pulumi.log.warn("""ServerPolicyClaim is deprecated: okta.auth.ServerPolicyClaim has been deprecated in favor of okta.auth.ServerPolicyRule""")
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['access_token_lifetime_minutes'] = access_token_lifetime_minutes
            if auth_server_id is None and not opts.urn:
                raise TypeError("Missing required property 'auth_server_id'")
            __props__['auth_server_id'] = auth_server_id
            if grant_type_whitelists is None and not opts.urn:
                raise TypeError("Missing required property 'grant_type_whitelists'")
            __props__['grant_type_whitelists'] = grant_type_whitelists
            __props__['group_blacklists'] = group_blacklists
            __props__['group_whitelists'] = group_whitelists
            __props__['inline_hook_id'] = inline_hook_id
            __props__['name'] = name
            if policy_id is None and not opts.urn:
                raise TypeError("Missing required property 'policy_id'")
            __props__['policy_id'] = policy_id
            if priority is None and not opts.urn:
                raise TypeError("Missing required property 'priority'")
            __props__['priority'] = priority
            __props__['refresh_token_lifetime_minutes'] = refresh_token_lifetime_minutes
            __props__['refresh_token_window_minutes'] = refresh_token_window_minutes
            __props__['scope_whitelists'] = scope_whitelists
            __props__['status'] = status
            __props__['type'] = type
            __props__['user_blacklists'] = user_blacklists
            __props__['user_whitelists'] = user_whitelists
        super(ServerPolicyClaim, __self__).__init__(
            'okta:auth/serverPolicyClaim:ServerPolicyClaim',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            access_token_lifetime_minutes: Optional[pulumi.Input[int]] = None,
            auth_server_id: Optional[pulumi.Input[str]] = None,
            grant_type_whitelists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            group_blacklists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            group_whitelists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            inline_hook_id: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            policy_id: Optional[pulumi.Input[str]] = None,
            priority: Optional[pulumi.Input[int]] = None,
            refresh_token_lifetime_minutes: Optional[pulumi.Input[int]] = None,
            refresh_token_window_minutes: Optional[pulumi.Input[int]] = None,
            scope_whitelists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            status: Optional[pulumi.Input[str]] = None,
            type: Optional[pulumi.Input[str]] = None,
            user_blacklists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            user_whitelists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None) -> 'ServerPolicyClaim':
        """
        Get an existing ServerPolicyClaim resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] access_token_lifetime_minutes: Lifetime of access token. Can be set to a value between 5 and 1440 minutes.
        :param pulumi.Input[str] auth_server_id: Auth Server ID.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] grant_type_whitelists: Accepted grant type values, `"authorization_code"`, `"implicit"`, `"password"` or `"client_credentials"`. For `"implicit"` value either `user_whitelist` or `group_whitelist` should be set.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] group_blacklists: Specifies a set of Groups whose Users are to be excluded.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] group_whitelists: Specifies a set of Groups whose Users are to be included. Can be set to Group ID or to the following: "EVERYONE".
        :param pulumi.Input[str] inline_hook_id: The ID of the inline token to trigger.
        :param pulumi.Input[str] name: Auth Server Policy Rule name.
        :param pulumi.Input[str] policy_id: Auth Server Policy ID.
        :param pulumi.Input[int] priority: Priority of the auth server policy rule.
        :param pulumi.Input[int] refresh_token_lifetime_minutes: Lifetime of refresh token.
        :param pulumi.Input[int] refresh_token_window_minutes: Window in which a refresh token can be used. It can be a value between 5 and 2628000 (5 years) minutes.
               `"refresh_token_window_minutes"` must be between `"access_token_lifetime_minutes"` and `"refresh_token_lifetime_minutes"`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] scope_whitelists: Scopes allowed for this policy rule. They can be whitelisted by name or all can be whitelisted with `"*"`.
        :param pulumi.Input[str] status: The status of the Auth Server Policy Rule.
        :param pulumi.Input[str] type: The type of the Auth Server Policy Rule.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] user_blacklists: Specifies a set of Users to be excluded.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] user_whitelists: Specifies a set of Users to be included.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["access_token_lifetime_minutes"] = access_token_lifetime_minutes
        __props__["auth_server_id"] = auth_server_id
        __props__["grant_type_whitelists"] = grant_type_whitelists
        __props__["group_blacklists"] = group_blacklists
        __props__["group_whitelists"] = group_whitelists
        __props__["inline_hook_id"] = inline_hook_id
        __props__["name"] = name
        __props__["policy_id"] = policy_id
        __props__["priority"] = priority
        __props__["refresh_token_lifetime_minutes"] = refresh_token_lifetime_minutes
        __props__["refresh_token_window_minutes"] = refresh_token_window_minutes
        __props__["scope_whitelists"] = scope_whitelists
        __props__["status"] = status
        __props__["type"] = type
        __props__["user_blacklists"] = user_blacklists
        __props__["user_whitelists"] = user_whitelists
        return ServerPolicyClaim(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accessTokenLifetimeMinutes")
    def access_token_lifetime_minutes(self) -> pulumi.Output[Optional[int]]:
        """
        Lifetime of access token. Can be set to a value between 5 and 1440 minutes.
        """
        return pulumi.get(self, "access_token_lifetime_minutes")

    @property
    @pulumi.getter(name="authServerId")
    def auth_server_id(self) -> pulumi.Output[str]:
        """
        Auth Server ID.
        """
        return pulumi.get(self, "auth_server_id")

    @property
    @pulumi.getter(name="grantTypeWhitelists")
    def grant_type_whitelists(self) -> pulumi.Output[Sequence[str]]:
        """
        Accepted grant type values, `"authorization_code"`, `"implicit"`, `"password"` or `"client_credentials"`. For `"implicit"` value either `user_whitelist` or `group_whitelist` should be set.
        """
        return pulumi.get(self, "grant_type_whitelists")

    @property
    @pulumi.getter(name="groupBlacklists")
    def group_blacklists(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Specifies a set of Groups whose Users are to be excluded.
        """
        return pulumi.get(self, "group_blacklists")

    @property
    @pulumi.getter(name="groupWhitelists")
    def group_whitelists(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Specifies a set of Groups whose Users are to be included. Can be set to Group ID or to the following: "EVERYONE".
        """
        return pulumi.get(self, "group_whitelists")

    @property
    @pulumi.getter(name="inlineHookId")
    def inline_hook_id(self) -> pulumi.Output[Optional[str]]:
        """
        The ID of the inline token to trigger.
        """
        return pulumi.get(self, "inline_hook_id")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Auth Server Policy Rule name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="policyId")
    def policy_id(self) -> pulumi.Output[str]:
        """
        Auth Server Policy ID.
        """
        return pulumi.get(self, "policy_id")

    @property
    @pulumi.getter
    def priority(self) -> pulumi.Output[int]:
        """
        Priority of the auth server policy rule.
        """
        return pulumi.get(self, "priority")

    @property
    @pulumi.getter(name="refreshTokenLifetimeMinutes")
    def refresh_token_lifetime_minutes(self) -> pulumi.Output[Optional[int]]:
        """
        Lifetime of refresh token.
        """
        return pulumi.get(self, "refresh_token_lifetime_minutes")

    @property
    @pulumi.getter(name="refreshTokenWindowMinutes")
    def refresh_token_window_minutes(self) -> pulumi.Output[Optional[int]]:
        """
        Window in which a refresh token can be used. It can be a value between 5 and 2628000 (5 years) minutes.
        `"refresh_token_window_minutes"` must be between `"access_token_lifetime_minutes"` and `"refresh_token_lifetime_minutes"`.
        """
        return pulumi.get(self, "refresh_token_window_minutes")

    @property
    @pulumi.getter(name="scopeWhitelists")
    def scope_whitelists(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Scopes allowed for this policy rule. They can be whitelisted by name or all can be whitelisted with `"*"`.
        """
        return pulumi.get(self, "scope_whitelists")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[Optional[str]]:
        """
        The status of the Auth Server Policy Rule.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[Optional[str]]:
        """
        The type of the Auth Server Policy Rule.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="userBlacklists")
    def user_blacklists(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Specifies a set of Users to be excluded.
        """
        return pulumi.get(self, "user_blacklists")

    @property
    @pulumi.getter(name="userWhitelists")
    def user_whitelists(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Specifies a set of Users to be included.
        """
        return pulumi.get(self, "user_whitelists")

    def translate_output_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return _tables.SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

