# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from .. import _utilities, _tables
from . import outputs
from ._inputs import *

__all__ = ['RuleIdpDiscovery']


class RuleIdpDiscovery(pulumi.CustomResource):
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 app_excludes: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['RuleIdpDiscoveryAppExcludeArgs']]]]] = None,
                 app_includes: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['RuleIdpDiscoveryAppIncludeArgs']]]]] = None,
                 idp_id: Optional[pulumi.Input[str]] = None,
                 idp_type: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network_connection: Optional[pulumi.Input[str]] = None,
                 network_excludes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 network_includes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 platform_includes: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['RuleIdpDiscoveryPlatformIncludeArgs']]]]] = None,
                 policyid: Optional[pulumi.Input[str]] = None,
                 priority: Optional[pulumi.Input[int]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 user_identifier_attribute: Optional[pulumi.Input[str]] = None,
                 user_identifier_patterns: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['RuleIdpDiscoveryUserIdentifierPatternArgs']]]]] = None,
                 user_identifier_type: Optional[pulumi.Input[str]] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        """
        Creates an IdP Discovery Policy Rule.

        This resource allows you to create and configure an IdP Discovery Policy Rule.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_okta as okta

        example = okta.policy.RuleIdpDiscovery("example",
            app_excludes=[
                okta.policy.RuleIdpDiscoveryAppExcludeArgs(
                    id="<app id>",
                    type="APP",
                ),
                okta.policy.RuleIdpDiscoveryAppExcludeArgs(
                    name="yahoo_mail",
                    type="APP_TYPE",
                ),
            ],
            app_includes=[
                okta.policy.RuleIdpDiscoveryAppIncludeArgs(
                    id="<app id>",
                    type="APP",
                ),
                okta.policy.RuleIdpDiscoveryAppIncludeArgs(
                    name="<app type name>",
                    type="APP_TYPE",
                ),
            ],
            idp_id="<idp id>",
            idp_type="OIDC",
            network_connection="ANYWHERE",
            platform_includes=[okta.policy.RuleIdpDiscoveryPlatformIncludeArgs(
                os_type="OSX",
                type="MOBILE",
            )],
            policyid="<policy id>",
            priority=1,
            status="ACTIVE",
            user_identifier_attribute="company",
            user_identifier_patterns=[okta.policy.RuleIdpDiscoveryUserIdentifierPatternArgs(
                match_type="EQUALS",
                value="Articulate",
            )],
            user_identifier_type="ATTRIBUTE")
        ```

        ## Import

        A Policy Rule can be imported via the Policy and Rule ID.

        ```sh
         $ pulumi import okta:policy/ruleIdpDiscovery:RuleIdpDiscovery example <policy id>/<rule id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['RuleIdpDiscoveryAppExcludeArgs']]]] app_excludes: Applications to exclude in discovery. See `app_include` for details.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['RuleIdpDiscoveryAppIncludeArgs']]]] app_includes: Applications to include in discovery rule.
        :param pulumi.Input[str] idp_id: The identifier for the Idp the rule should route to if all conditions are met.
        :param pulumi.Input[str] idp_type: Type of Idp. One of: `"SAML2"`, `"IWA"`, `"AgentlessDSSO"`, `"X509"`, `"FACEBOOK"`, `"GOOGLE"`, `"LINKEDIN"`, `"MICROSOFT"`, `"OIDC"`
        :param pulumi.Input[str] name: Use if the `type` is `"APP_TYPE"` to indicate the type of application(s) to include in instances where an entire group (i.e. `yahoo_mail`) of applications should be included.
        :param pulumi.Input[str] network_connection: The network selection mode. One of `"ANYWEHRE"` or `"ZONE"`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] network_excludes: Required if `network_connection` = `"ZONE"`. Indicates the network zones to exclude.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] network_includes: Required if `network_connection` = `"ZONE"`. Indicates the network zones to include.
        :param pulumi.Input[str] policyid: Policy ID.
        :param pulumi.Input[int] priority: Idp rule priority. This attribute can be set to a valid priority. To avoid an endless diff situation an error is thrown if an invalid property is provided. The Okta API defaults to the last (lowest) if not provided.
        :param pulumi.Input[str] status: Idp rule status: `"ACTIVE"` or `"INACTIVE"`. By default, it is `"ACTIVE"`.
        :param pulumi.Input[str] user_identifier_attribute: Profile attribute matching can only have a single value that describes the type indicated in `user_identifier_type`. This is the attribute or identifier that the `user_identifier_patterns` are checked against.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['RuleIdpDiscoveryUserIdentifierPatternArgs']]]] user_identifier_patterns: Specifies a User Identifier pattern condition to match against. If `match_type` of `"EXPRESSION"` is used, only a *single* element can be set, otherwise multiple elements of matching patterns may be provided.
        :param pulumi.Input[str] user_identifier_type: One of: `"IDENTIFIER"`, `"ATTRIBUTE"`
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['app_excludes'] = app_excludes
            __props__['app_includes'] = app_includes
            __props__['idp_id'] = idp_id
            __props__['idp_type'] = idp_type
            __props__['name'] = name
            __props__['network_connection'] = network_connection
            __props__['network_excludes'] = network_excludes
            __props__['network_includes'] = network_includes
            __props__['platform_includes'] = platform_includes
            if policyid is None and not opts.urn:
                raise TypeError("Missing required property 'policyid'")
            __props__['policyid'] = policyid
            __props__['priority'] = priority
            __props__['status'] = status
            __props__['user_identifier_attribute'] = user_identifier_attribute
            __props__['user_identifier_patterns'] = user_identifier_patterns
            __props__['user_identifier_type'] = user_identifier_type
        super(RuleIdpDiscovery, __self__).__init__(
            'okta:policy/ruleIdpDiscovery:RuleIdpDiscovery',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            app_excludes: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['RuleIdpDiscoveryAppExcludeArgs']]]]] = None,
            app_includes: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['RuleIdpDiscoveryAppIncludeArgs']]]]] = None,
            idp_id: Optional[pulumi.Input[str]] = None,
            idp_type: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            network_connection: Optional[pulumi.Input[str]] = None,
            network_excludes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            network_includes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            platform_includes: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['RuleIdpDiscoveryPlatformIncludeArgs']]]]] = None,
            policyid: Optional[pulumi.Input[str]] = None,
            priority: Optional[pulumi.Input[int]] = None,
            status: Optional[pulumi.Input[str]] = None,
            user_identifier_attribute: Optional[pulumi.Input[str]] = None,
            user_identifier_patterns: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['RuleIdpDiscoveryUserIdentifierPatternArgs']]]]] = None,
            user_identifier_type: Optional[pulumi.Input[str]] = None) -> 'RuleIdpDiscovery':
        """
        Get an existing RuleIdpDiscovery resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['RuleIdpDiscoveryAppExcludeArgs']]]] app_excludes: Applications to exclude in discovery. See `app_include` for details.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['RuleIdpDiscoveryAppIncludeArgs']]]] app_includes: Applications to include in discovery rule.
        :param pulumi.Input[str] idp_id: The identifier for the Idp the rule should route to if all conditions are met.
        :param pulumi.Input[str] idp_type: Type of Idp. One of: `"SAML2"`, `"IWA"`, `"AgentlessDSSO"`, `"X509"`, `"FACEBOOK"`, `"GOOGLE"`, `"LINKEDIN"`, `"MICROSOFT"`, `"OIDC"`
        :param pulumi.Input[str] name: Use if the `type` is `"APP_TYPE"` to indicate the type of application(s) to include in instances where an entire group (i.e. `yahoo_mail`) of applications should be included.
        :param pulumi.Input[str] network_connection: The network selection mode. One of `"ANYWEHRE"` or `"ZONE"`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] network_excludes: Required if `network_connection` = `"ZONE"`. Indicates the network zones to exclude.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] network_includes: Required if `network_connection` = `"ZONE"`. Indicates the network zones to include.
        :param pulumi.Input[str] policyid: Policy ID.
        :param pulumi.Input[int] priority: Idp rule priority. This attribute can be set to a valid priority. To avoid an endless diff situation an error is thrown if an invalid property is provided. The Okta API defaults to the last (lowest) if not provided.
        :param pulumi.Input[str] status: Idp rule status: `"ACTIVE"` or `"INACTIVE"`. By default, it is `"ACTIVE"`.
        :param pulumi.Input[str] user_identifier_attribute: Profile attribute matching can only have a single value that describes the type indicated in `user_identifier_type`. This is the attribute or identifier that the `user_identifier_patterns` are checked against.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['RuleIdpDiscoveryUserIdentifierPatternArgs']]]] user_identifier_patterns: Specifies a User Identifier pattern condition to match against. If `match_type` of `"EXPRESSION"` is used, only a *single* element can be set, otherwise multiple elements of matching patterns may be provided.
        :param pulumi.Input[str] user_identifier_type: One of: `"IDENTIFIER"`, `"ATTRIBUTE"`
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["app_excludes"] = app_excludes
        __props__["app_includes"] = app_includes
        __props__["idp_id"] = idp_id
        __props__["idp_type"] = idp_type
        __props__["name"] = name
        __props__["network_connection"] = network_connection
        __props__["network_excludes"] = network_excludes
        __props__["network_includes"] = network_includes
        __props__["platform_includes"] = platform_includes
        __props__["policyid"] = policyid
        __props__["priority"] = priority
        __props__["status"] = status
        __props__["user_identifier_attribute"] = user_identifier_attribute
        __props__["user_identifier_patterns"] = user_identifier_patterns
        __props__["user_identifier_type"] = user_identifier_type
        return RuleIdpDiscovery(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="appExcludes")
    def app_excludes(self) -> pulumi.Output[Optional[Sequence['outputs.RuleIdpDiscoveryAppExclude']]]:
        """
        Applications to exclude in discovery. See `app_include` for details.
        """
        return pulumi.get(self, "app_excludes")

    @property
    @pulumi.getter(name="appIncludes")
    def app_includes(self) -> pulumi.Output[Optional[Sequence['outputs.RuleIdpDiscoveryAppInclude']]]:
        """
        Applications to include in discovery rule.
        """
        return pulumi.get(self, "app_includes")

    @property
    @pulumi.getter(name="idpId")
    def idp_id(self) -> pulumi.Output[Optional[str]]:
        """
        The identifier for the Idp the rule should route to if all conditions are met.
        """
        return pulumi.get(self, "idp_id")

    @property
    @pulumi.getter(name="idpType")
    def idp_type(self) -> pulumi.Output[Optional[str]]:
        """
        Type of Idp. One of: `"SAML2"`, `"IWA"`, `"AgentlessDSSO"`, `"X509"`, `"FACEBOOK"`, `"GOOGLE"`, `"LINKEDIN"`, `"MICROSOFT"`, `"OIDC"`
        """
        return pulumi.get(self, "idp_type")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Use if the `type` is `"APP_TYPE"` to indicate the type of application(s) to include in instances where an entire group (i.e. `yahoo_mail`) of applications should be included.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="networkConnection")
    def network_connection(self) -> pulumi.Output[Optional[str]]:
        """
        The network selection mode. One of `"ANYWEHRE"` or `"ZONE"`.
        """
        return pulumi.get(self, "network_connection")

    @property
    @pulumi.getter(name="networkExcludes")
    def network_excludes(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Required if `network_connection` = `"ZONE"`. Indicates the network zones to exclude.
        """
        return pulumi.get(self, "network_excludes")

    @property
    @pulumi.getter(name="networkIncludes")
    def network_includes(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Required if `network_connection` = `"ZONE"`. Indicates the network zones to include.
        """
        return pulumi.get(self, "network_includes")

    @property
    @pulumi.getter(name="platformIncludes")
    def platform_includes(self) -> pulumi.Output[Optional[Sequence['outputs.RuleIdpDiscoveryPlatformInclude']]]:
        return pulumi.get(self, "platform_includes")

    @property
    @pulumi.getter
    def policyid(self) -> pulumi.Output[str]:
        """
        Policy ID.
        """
        return pulumi.get(self, "policyid")

    @property
    @pulumi.getter
    def priority(self) -> pulumi.Output[Optional[int]]:
        """
        Idp rule priority. This attribute can be set to a valid priority. To avoid an endless diff situation an error is thrown if an invalid property is provided. The Okta API defaults to the last (lowest) if not provided.
        """
        return pulumi.get(self, "priority")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[Optional[str]]:
        """
        Idp rule status: `"ACTIVE"` or `"INACTIVE"`. By default, it is `"ACTIVE"`.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="userIdentifierAttribute")
    def user_identifier_attribute(self) -> pulumi.Output[Optional[str]]:
        """
        Profile attribute matching can only have a single value that describes the type indicated in `user_identifier_type`. This is the attribute or identifier that the `user_identifier_patterns` are checked against.
        """
        return pulumi.get(self, "user_identifier_attribute")

    @property
    @pulumi.getter(name="userIdentifierPatterns")
    def user_identifier_patterns(self) -> pulumi.Output[Optional[Sequence['outputs.RuleIdpDiscoveryUserIdentifierPattern']]]:
        """
        Specifies a User Identifier pattern condition to match against. If `match_type` of `"EXPRESSION"` is used, only a *single* element can be set, otherwise multiple elements of matching patterns may be provided.
        """
        return pulumi.get(self, "user_identifier_patterns")

    @property
    @pulumi.getter(name="userIdentifierType")
    def user_identifier_type(self) -> pulumi.Output[Optional[str]]:
        """
        One of: `"IDENTIFIER"`, `"ATTRIBUTE"`
        """
        return pulumi.get(self, "user_identifier_type")

    def translate_output_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return _tables.SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

