# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from .. import _utilities, _tables
from . import outputs
from ._inputs import *

__all__ = [
    'GetUsersResult',
    'AwaitableGetUsersResult',
    'get_users',
]

@pulumi.output_type
class GetUsersResult:
    """
    A collection of values returned by getUsers.
    """
    def __init__(__self__, id=None, searches=None, users=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if searches and not isinstance(searches, list):
            raise TypeError("Expected argument 'searches' to be a list")
        pulumi.set(__self__, "searches", searches)
        if users and not isinstance(users, list):
            raise TypeError("Expected argument 'users' to be a list")
        pulumi.set(__self__, "users", users)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def searches(self) -> Sequence['outputs.GetUsersSearchResult']:
        return pulumi.get(self, "searches")

    @property
    @pulumi.getter
    def users(self) -> Optional[Sequence['outputs.GetUsersUserResult']]:
        """
        collection of users retrieved from Okta with the following properties.
        """
        return pulumi.get(self, "users")


class AwaitableGetUsersResult(GetUsersResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetUsersResult(
            id=self.id,
            searches=self.searches,
            users=self.users)


def get_users(searches: Optional[Sequence[pulumi.InputType['GetUsersSearchArgs']]] = None,
              users: Optional[Sequence[pulumi.InputType['GetUsersUserArgs']]] = None,
              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetUsersResult:
    """
    Use this data source to retrieve a list of users from Okta.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_okta as okta

    example = okta.user.get_users(searches=[okta.user.GetUsersSearchArgs(
        comparison="sw",
        name="profile.company",
        value="Articulate",
    )])
    ```


    :param Sequence[pulumi.InputType['GetUsersSearchArgs']] searches: Map of search criteria to find users. It supports the following properties.
    :param Sequence[pulumi.InputType['GetUsersUserArgs']] users: collection of users retrieved from Okta with the following properties.
    """
    __args__ = dict()
    __args__['searches'] = searches
    __args__['users'] = users
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('okta:user/getUsers:getUsers', __args__, opts=opts, typ=GetUsersResult).value

    return AwaitableGetUsersResult(
        id=__ret__.id,
        searches=__ret__.searches,
        users=__ret__.users)
