# Vashishta potential file for SiO2
# W. Wang, A. Nakano, R. K. Kalia and P. Vashishta
# Interatomic potentials for molecular dynamics simulations of hydrolosis and stress corrosion cracking of silica class
# (Unpublished)

molecule = "OSiO"

citation = ("W. Wang, A. Nakano, R. K. Kalia and P. Vashishta, "
            "Interatomic potentials for molecular dynamics simulations of hydrolosis and stress corrosion cracking of silica class "
            "(Unpublished)")

params = {"SiSiSi":    {"H": 0.39246,
                        "eta": 11,
                        "Zi": 1.2,
                        "Zj": 1.2,
                        "r1s": 4.43,
                        "D": 0.0,
                        "r4s": 2.5,
                        "W": 0.0,
                        "rc": 5.5,
                        "B": 0.0,
                        "xi": 0.0,
                        "r0": 0.0,
                        "C": 0.0,
                        "cos(theta)": 0.0},

          "OOO":       {"H": 355.5263,
                        "eta": 7,
                        "Zi": -0.6,
                        "Zj": -0.6,
                        "r1s": 4.43,
                        "D": 12.4413912,
                        "r4s": 2.5,
                        "W": 0.0,
                        "rc": 5.5,
                        "B": 0.0,
                        "xi": 0.0,
                        "r0": 0.0,
                        "C": 0.0,
                        "cos(theta)": 0.0},

          "OSiSi":     {"H": 78.3143,
                        "eta": 9,
                        "Zi": -0.6,
                        "Zj": 1.2,
                        "r1s": 4.43,
                        "D": 24.8827823,
                        "r4s": 2.5,
                        "W": 0.0,
                        "rc": 5.5,
                        "B": 19.972,
                        "xi": 1.0,
                        "r0": 2.60,
                        "C": 0.0,
                        "cos(theta)": -0.77714596},

          "SiOO":      {"H": 78.3143,
                        "eta": 9,
                        "Zi": 1.2,
                        "Zj": -0.6,
                        "r1s": 4.43,
                        "D": 24.8827823,
                        "r4s": 2.5,
                        "W": 0.0,
                        "rc": 5.5,
                        "B": 4.993,
                        "xi": 1.0,
                        "r0": 2.60,
                        "C": 0.0,
                        "cos(theta)": -0.333313248},

          "SiOSi":     {"H": 0.0,
                        "eta": 0.0,
                        "Zi": 0.0,
                        "Zj": 0.0,
                        "r1s": 0.0,
                        "D": 0.0,
                        "r4s": 0.0,
                        "W": 0.0,
                        "rc": 0.0,
                        "B": 0.0,
                        "xi": 0.0,
                        "r0": 0.0,
                        "C": 0.0,
                        "cos(theta)": 0.0},

          "SiSiO":     {"H": 0.0,
                        "eta": 0.0,
                        "Zi": 0.0,
                        "Zj": 0.0,
                        "r1s": 0.0,
                        "D": 0.0,
                        "r4s": 0.0,
                        "W": 0.0,
                        "rc": 0.0,
                        "B": 0.0,
                        "xi": 0.0,
                        "r0": 0.0,
                        "C": 0.0,
                        "cos(theta)": 0.0},

          "OSiO":      {"H": 0.0,
                        "eta": 0.0,
                        "Zi": 0.0,
                        "Zj": 0.0,
                        "r1s": 0.0,
                        "D": 0.0,
                        "r4s": 0.0,
                        "W": 0.0,
                        "rc": 0.0,
                        "B": 0.0,
                        "xi": 0.0,
                        "r0": 0.0,
                        "C": 0.0,
                        "cos(theta)": 0.0},

          "OOSi":      {"H": 0.0,
                        "eta": 0.0,
                        "Zi": 0.0,
                        "Zj": 0.0,
                        "r1s": 0.0,
                        "D": 0.0,
                        "r4s": 0.0,
                        "W": 0.0,
                        "rc": 0.0,
                        "B": 0.0,
                        "xi": 0.0,
                        "r0": 0.0,
                        "C": 0.0,
                        "cos(theta)": 0.0}}
