# Coronal Mass Ejections
## Activity ID: 2022-07-04T13:25:00-CME-001
### Catalog: M2M_CATALOG
### Start Time: 2022-07-04T13:25Z
### Source Location: 
### Active Region Number: None
### [Link](https://kauai.ccmc.gsfc.nasa.gov/DONKI/view/CME/20705/-1)
### Note: 
### Instruments
#### SOHO: LASCO/C2
#### SOHO: LASCO/C3
### Analysis
#### Time: 2022-07-04T20:15Z
#### Latitude: None
#### Longitude: -122.0
#### Half Angle: 33.0
#### Speed: 498.0
#### Type: S
#### Most Accurate: True
#### Level of Data: 0
#### [Link](https://kauai.ccmc.gsfc.nasa.gov/DONKI/view/CMEAnalysis/20706/-1)
#### Note: CME S in SOHO LASCO C2 and C3 overlapping with streamer. Source: TBD
## Activity ID: 2022-07-04T21:12:00-CME-001
### Catalog: M2M_CATALOG
### Start Time: 2022-07-04T21:12Z
### Source Location: 
### Active Region Number: None
### [Link](https://kauai.ccmc.gsfc.nasa.gov/DONKI/view/CME/20719/-1)
### Note: This CME is visible to the W/NW as seen in SOHO LASCO C2/C3 and STEREO A COR2 coronagraphs. The source is likely far-sided due to the lack of a clear source signature on the Earth-facing disk.
### Instruments
#### SOHO: LASCO/C2
#### SOHO: LASCO/C3
#### STEREO A: SECCHI/COR2
### Analysis
#### Time: 2022-07-05T12:00Z
#### Latitude: 9.0
#### Longitude: 97.0
#### Half Angle: 27.0
#### Speed: 299.0
#### Type: S
#### Most Accurate: True
#### Level of Data: 0
#### [Link](https://kauai.ccmc.gsfc.nasa.gov/DONKI/view/CMEAnalysis/20720/-1)
#### Note: Since there were no clear source signatures on the Earth-facing disk, the longitude may vary +/- 10 degrees. This measurement is based on the best fit between SOHO LASCO C2/C3 and STEREO A COR2 coronagraphs.
## Activity ID: 2022-07-05T04:24:00-CME-001
### Catalog: M2M_CATALOG
### Start Time: 2022-07-05T04:24Z
### Source Location: S20W23
### Active Region Number: 13047
### [Link](https://kauai.ccmc.gsfc.nasa.gov/DONKI/view/CME/20714/-1)
### Note: This partial halo CME is very faint but can be seen to the SW in SOHO LASCO C2/C3 and STEREO A COR2 coronagraphs. The source is likely the eruption from AR 3047 seen best in SDO AIA 171 and 304 at 2022-07-05T04:01Z. This eruption is also visible in the SW quadrant of STEREO A EUVI 195 and 304 imagery.
### Instruments
#### SOHO: LASCO/C2
#### SOHO: LASCO/C3
#### STEREO A: SECCHI/COR2
### Analysis
#### Time: 2022-07-05T10:21Z
#### Latitude: -24.0
#### Longitude: 27.0
#### Half Angle: 42.0
#### Speed: 514.0
#### Type: C
#### Most Accurate: True
#### Level of Data: 0
#### [Link](https://kauai.ccmc.gsfc.nasa.gov/DONKI/view/CMEAnalysis/20715/-1)
#### Note: The leading edge boundary is hard to see due to the faintness of the CME. For this reason the sides of the CME, which are brighter in comparison, were used to guide this measurement. Speed measurements ranged from 514 to 621 km/s.
## Activity ID: 2022-07-05T04:48:00-CME-001
### Catalog: M2M_CATALOG
### Start Time: 2022-07-05T04:48Z
### Source Location: 
### Active Region Number: None
### [Link](https://kauai.ccmc.gsfc.nasa.gov/DONKI/view/CME/20717/-1)
### Note: This CME is visible in the W/NW of SOHO LASCO C2/C3 and STEREO A COR2 coronagraphs. The source is likely back-sided as there are no clear source signatures on the Earth-facing disk. However, around 2022-07-05T05:30Z post eruptive loops may form beyond the NW limb as seen in SDO AIA 171 imagery. It is possible this originates from the same eruption which was responsible for this CME.
### Instruments
#### SOHO: LASCO/C2
#### SOHO: LASCO/C3
#### STEREO A: SECCHI/COR2
### Analysis
#### Time: 2022-07-05T10:38Z
#### Latitude: 5.0
#### Longitude: 119.0
#### Half Angle: 26.0
#### Speed: 543.0
#### Type: C
#### Most Accurate: True
#### Level of Data: 0
#### [Link](https://kauai.ccmc.gsfc.nasa.gov/DONKI/view/CMEAnalysis/20718/-1)
#### Note: The leading edge boundary becomes diffuse before 21.5 Rs so earlier time stamps were primarily used in this measurement. However, the CME appears to move at a fairly consistent speed throughout the measurement.
## Activity ID: 2022-07-06T13:25:00-CME-001
### Catalog: M2M_CATALOG
### Start Time: 2022-07-06T13:25Z
### Source Location: 
### Active Region Number: None
### [Link](https://kauai.ccmc.gsfc.nasa.gov/DONKI/view/CME/20726/-1)
### Note: Visible in the SE of STEREO A COR2 and SOHO LASCO C2/C3. The source is an eruption on or beyond the SW limb of STEREO A EUVI 195 starting around 2022-07-06T09:00Z. It is characterized by eruption material and opening field lines.
### Instruments
#### SOHO: LASCO/C2
#### SOHO: LASCO/C3
#### STEREO A: SECCHI/COR2
### Analysis
#### Time: 2022-07-06T21:49Z
#### Latitude: -33.0
#### Longitude: -131.0
#### Half Angle: 16.0
#### Speed: 395.0
#### Type: S
#### Most Accurate: True
#### Level of Data: 0
#### [Link](https://kauai.ccmc.gsfc.nasa.gov/DONKI/view/CMEAnalysis/20727/-1)
#### Note: Parameters obtained using knowledge of the source location near the southeast limb as seen in STEREO A EUVI imagery and the best fit between SOHO LASCO C2/C3 and STEREO A COR2 in SWPC_CAT.
## Activity ID: 2022-07-06T13:48:00-CME-001
### Catalog: M2M_CATALOG
### Start Time: 2022-07-06T13:48Z
### Source Location: 
### Active Region Number: None
### [Link](https://kauai.ccmc.gsfc.nasa.gov/DONKI/view/CME/20729/-1)
### Note: Visible in the N/NW of SOHO LASCO C2/C3 and STEREO A COR2. The source is unclear, but there are opening field lines faintly visible beyond the NW limb in SDO AIA 193 beginning around 2022-07-06T10:100Z.
### Instruments
#### SOHO: LASCO/C2
#### SOHO: LASCO/C3
#### STEREO A: SECCHI/COR2
### Analysis
#### Time: 2022-07-07T01:28Z
#### Latitude: 47.0
#### Longitude: 129.0
#### Half Angle: 36.0
#### Speed: 284.0
#### Type: S
#### Most Accurate: True
#### Level of Data: 0
#### [Link](https://kauai.ccmc.gsfc.nasa.gov/DONKI/view/CMEAnalysis/20730/-1)
#### Note: Parameters obtained using knowledge of a potential source location visible beyond the west limb as seen from SDO AIA imagery as well as the best fit between SOHO LASCO C2/C3 and STEREO A COR2 imagery in SWPC_CAT.
## Activity ID: 2022-07-06T23:12:00-CME-001
### Catalog: M2M_CATALOG
### Start Time: 2022-07-06T23:12Z
### Source Location: 
### Active Region Number: None
### [Link](https://kauai.ccmc.gsfc.nasa.gov/DONKI/view/CME/20737/-1)
### Note: A narrow eruption which is reminiscent of but slower than a jet, the eruption doesn't seem to have a definite Earth-facing source. One possible source for this eruption is moving and opening field lines which are seen on the southwest limb, approximately with a longitude between E 100-115 as seen by Stereo Ahead EUVI 195 imagery around 2022-07-6T23:00Z.
### Instruments
#### SOHO: LASCO/C2
#### SOHO: LASCO/C3
#### STEREO A: SECCHI/COR2
### Analysis
#### Time: 2022-07-07T07:14Z
#### Latitude: -42.0
#### Longitude: -105.0
#### Half Angle: 10.0
#### Speed: 425.0
#### Type: S
#### Most Accurate: True
#### Level of Data: 0
#### [Link](https://kauai.ccmc.gsfc.nasa.gov/DONKI/view/CMEAnalysis/20738/-1)
#### Note: The source longitude was approximated from the coronal imagery observations due to the event likely being back-sided.
## Activity ID: 2022-07-07T04:48:00-CME-001
### Catalog: M2M_CATALOG
### Start Time: 2022-07-07T04:48Z
### Source Location: 
### Active Region Number: None
### [Link](https://kauai.ccmc.gsfc.nasa.gov/DONKI/view/CME/20739/-1)
### Note: The likely source is outflow associated with a broad area of magnetic field lines located in the NW though no CME/ejecta is seen in coronal imagery.
### Instruments
#### SOHO: LASCO/C2
#### SOHO: LASCO/C3
#### STEREO A: SECCHI/COR2
### Analysis
#### Time: 2022-07-07T12:27Z
#### Latitude: 9.0
#### Longitude: 109.0
#### Half Angle: 20.0
#### Speed: 465.0
#### Type: S
#### Most Accurate: True
#### Level of Data: 0
#### [Link](https://kauai.ccmc.gsfc.nasa.gov/DONKI/view/CMEAnalysis/20742/-1)
#### Note: Measurement which incorporated more frames and accounted for a wider half-width.
#### Time: 2022-07-07T10:54Z
#### Latitude: 8.0
#### Longitude: 112.0
#### Half Angle: 18.0
#### Speed: 595.0
#### Type: C
#### Most Accurate: False
#### Level of Data: 0
#### [Link](https://kauai.ccmc.gsfc.nasa.gov/DONKI/view/CMEAnalysis/20740/-1)
#### Note: A preliminary measurement of the CME bulk--this measurement may benefit from decreasing the half-width to obtain a more accurate result.
## Activity ID: 2022-07-07T13:25:00-CME-001
### Catalog: M2M_CATALOG
### Start Time: 2022-07-07T13:25Z
### Source Location: S30E70
### Active Region Number: None
### [Link](https://kauai.ccmc.gsfc.nasa.gov/DONKI/view/CME/20744/-1)
### Note: The eruption appears to be associated with plasma outflow and moving field lines suspended above an unnumbered active region in the SE of the Earth facing disk with footpoints approximately located around S30E70 or so. No eruption signature is seen in Stereo-A EUVI imagery.
### Instruments
#### SOHO: LASCO/C2
#### SOHO: LASCO/C3
### Analysis
#### Time: 2022-07-07T21:39Z
#### Latitude: -45.0
#### Longitude: None
#### Half Angle: 11.0
#### Speed: 446.0
#### Type: S
#### Most Accurate: True
#### Level of Data: 0
#### [Link](https://kauai.ccmc.gsfc.nasa.gov/DONKI/view/CMEAnalysis/20745/-1)
#### Note: A SOHO plane of sky measurement of the jet leading edge because the CME was not seen in Stereo A white light or running difference imagery.
## Activity ID: 2022-07-07T17:36:00-CME-001
### Catalog: M2M_CATALOG
### Start Time: 2022-07-07T17:36Z
### Source Location: 
### Active Region Number: None
### [Link](https://kauai.ccmc.gsfc.nasa.gov/DONKI/view/CME/20751/-1)
### Note: This CME is seen to the west in SOHO LASCO C2/C3 and STEREO A COR2 coronagraphs. A potential source is the filament eruption along the SW limb visible in SDO/AIA 304 around 2022-07-07:17:00Z. Moving/opening field lines in are also visible in SDO/AIA 171 around the same time.
### Instruments
#### SOHO: LASCO/C2
#### SOHO: LASCO/C3
#### STEREO A: SECCHI/COR2
### Analysis
#### Time: 2022-07-08T00:16Z
#### Latitude: -14.0
#### Longitude: 97.0
#### Half Angle: 11.0
#### Speed: 593.0
#### Type: C
#### Most Accurate: True
#### Level of Data: 0
#### [Link](https://kauai.ccmc.gsfc.nasa.gov/DONKI/view/CMEAnalysis/20752/-1)
#### Note: The CME is hard to track in later time stamps of SOHO LASCO C3 due to an emerging CME in the same direction. The CME also becomes faint as it progresses outward in the field of view, so primarily earlier time stamps from 2022-07-07T18:30Z to 20:00Z were used in this measurement.
## Activity ID: 2022-07-07T19:00:00-CME-001
### Catalog: M2M_CATALOG
### Start Time: 2022-07-07T19:00Z
### Source Location: 
### Active Region Number: None
### [Link](https://kauai.ccmc.gsfc.nasa.gov/DONKI/view/CME/20749/-1)
### Note: This CME is visible to the west in SOHO LASCO C2/C3 and STEREO A COR2 coronagraphs. A potential source is the faint field line movement visible in SDO/AIA 171 along the W/SW limb around 2022-07-07T19:40Z.
### Instruments
#### SOHO: LASCO/C2
#### SOHO: LASCO/C3
#### STEREO A: SECCHI/COR2
### Analysis
#### Time: 2022-07-08T03:11Z
#### Latitude: 3.0
#### Longitude: 104.0
#### Half Angle: 28.0
#### Speed: 436.0
#### Type: S
#### Most Accurate: True
#### Level of Data: 0
#### [Link](https://kauai.ccmc.gsfc.nasa.gov/DONKI/view/CMEAnalysis/20750/-1)
#### Note: The CME is not visible in SOHO LASCO C3 from 2022-07-07T20:30Z to 21:30Z due to imaging issues and there is a data gap in STEREO A COR2 starting at 21:38Z. However, outside of these time frames the CME is clearly seen. Speed measurements ranged from 436 to 594 km/s.
## Activity ID: 2022-07-08T01:25:00-CME-001
### Catalog: M2M_CATALOG
### Start Time: 2022-07-08T01:25Z
### Source Location: 
### Active Region Number: None
### [Link](https://kauai.ccmc.gsfc.nasa.gov/DONKI/view/CME/20747/-1)
### Note: The CME is visible to the SW in SOHO LASCO C2/C3 but is not seen in STEREO A COR2 due to a data gap from 2022-07-07T21:38Z to 2022-07-08T07:23Z. The source is likely the filament eruption seen along SW limb starting around 2022-07-07T23:00Z in SDO/AIA 304, 171 and 193.
### Instruments
#### SOHO: LASCO/C2
#### SOHO: LASCO/C3
### Analysis
#### Time: 2022-07-08T04:04Z
#### Latitude: -52.0
#### Longitude: 80.0
#### Half Angle: 27.0
#### Speed: 1289.0
#### Type: O
#### Most Accurate: True
#### Level of Data: 0
#### [Link](https://kauai.ccmc.gsfc.nasa.gov/DONKI/view/CMEAnalysis/20748/-1)
#### Note: This measurement follows the large shock front portion which moves faster than the bulk of the CME. Speed measurements ranged from 979 to 1388 km/s
## Activity ID: 2022-07-08T15:12:00-CME-001
### Catalog: M2M_CATALOG
### Start Time: 2022-07-08T15:12Z
### Source Location: 
### Active Region Number: None
### [Link](https://kauai.ccmc.gsfc.nasa.gov/DONKI/view/CME/20763/-1)
### Note: The CME contains an asymmetrical leading edge with filamentary structures that appear to be rotating seen to the east and southeast in SOHO and Stereo-A coronagraph imagery. There are simultaneous eruptions with ejected plasma from AR 3055 (S18E50) and another unnumbered active region seen in the SE of the Stereo-A facing disk at approximately longitude E100.
### Instruments
#### SOHO: LASCO/C2
#### SOHO: LASCO/C3
#### STEREO A: SECCHI/COR2
### Analysis
#### Time: 2022-07-09T03:45Z
#### Latitude: -15.0
#### Longitude: 100.0
#### Half Angle: 21.0
#### Speed: 316.0
#### Type: S
#### Most Accurate: True
#### Level of Data: 0
#### [Link](https://kauai.ccmc.gsfc.nasa.gov/DONKI/view/CMEAnalysis/20768/-1)
#### Note: The structure appears to be rotating and potentially overlapping another previous event which makes it appear that the longitude changes over time; a larger width was selected to incorporate these changes over time.
## Activity ID: 2022-07-08T20:48:00-CME-001
### Catalog: M2M_CATALOG
### Start Time: 2022-07-08T20:48Z
### Source Location: N20E40
### Active Region Number: 13053
### [Link](https://kauai.ccmc.gsfc.nasa.gov/DONKI/view/CME/20757/-1)
### Note: An eruption associated with the long-duration M2.5-class solar flare which occurred near N20E40. The CME presents itself as a faint halo in SOHO/C3 imagery and possibly a halo in Stereo-A/COR2A imagery with a bulk component mostly to the east in all available coronagraph imagery. The eruption as seen in coronal imagery is relatively unimpressive with mostly bright post-eruptive arcades and an EUV wave that traverses north and west of the source region best seen in SDO AIA 211 imagery.
### Instruments
#### SOHO: LASCO/C2
#### SOHO: LASCO/C3
#### STEREO A: SECCHI/COR2
### Analysis
#### Time: 2022-07-09T00:14Z
#### Latitude: 2.0
#### Longitude: -33.0
#### Half Angle: 47.0
#### Speed: 735.0
#### Type: C
#### Most Accurate: True
#### Level of Data: 0
#### [Link](https://kauai.ccmc.gsfc.nasa.gov/DONKI/view/CMEAnalysis/20759/-1)
#### Note: A measurement of the CME bulk associated with this eruption.
#### Time: 2022-07-08T23:26Z
#### Latitude: 6.0
#### Longitude: -24.0
#### Half Angle: 47.0
#### Speed: 1110.0
#### Type: O
#### Most Accurate: True
#### Level of Data: 0
#### [Link](https://kauai.ccmc.gsfc.nasa.gov/DONKI/view/CMEAnalysis/20762/-1)
#### Note: A third measurement of the faintest shock front visible in all coronagraph imagery.
#### Time: 2022-07-08T23:06Z
#### Latitude: 6.0
#### Longitude: -21.0
#### Half Angle: 49.0
#### Speed: 1287.0
#### Type: O
#### Most Accurate: False
#### Level of Data: 0
#### [Link](https://kauai.ccmc.gsfc.nasa.gov/DONKI/view/CMEAnalysis/20758/-1)
#### Note: A measurement of the faintest, fastest halo feature that is seen in SOHO and Stereo-A running difference imagery which quickly exits the Stereo-A field of view. This is a possible upper bound of the CME speed as it is uncertain whether this feature is associated with the halo.
#### Time: 2022-07-09T00:31Z
#### Latitude: 3.0
#### Longitude: -56.0
#### Half Angle: 17.0
#### Speed: 707.0
#### Type: C
#### Most Accurate: False
#### Level of Data: 0
#### [Link](https://kauai.ccmc.gsfc.nasa.gov/DONKI/view/CMEAnalysis/20760/-1)
#### Note: A measurement of the bulk of the CME.
#### Time: 2022-07-09T00:23Z
#### Latitude: 3.0
#### Longitude: -41.0
#### Half Angle: 43.0
#### Speed: 941.0
#### Type: C
#### Most Accurate: False
#### Level of Data: 0
#### [Link](https://kauai.ccmc.gsfc.nasa.gov/DONKI/view/CMEAnalysis/20761/-1)
#### Note: A measurement of the left-hand boundary of the CME, but wide enough to incorporate some aspects of the halo feature.
## Activity ID: 2022-07-09T14:00:00-CME-001
### Catalog: M2M_CATALOG
### Start Time: 2022-07-09T14:00Z
### Source Location: S22W88
### Active Region Number: 13045
### [Link](https://kauai.ccmc.gsfc.nasa.gov/DONKI/view/CME/20771/-1)
### Note: The source is a flare and associated fast, jet-like eruption with a bright emerging loop from AR3045 as seen in SDO 171/193/304A. The prominence material contained within the leading edge is not symmetric across the leading edge.
### Instruments
#### SOHO: LASCO/C2
#### SOHO: LASCO/C3
#### STEREO A: SECCHI/COR2
### Analysis
#### Time: 2022-07-09T17:05Z
#### Latitude: -7.0
#### Longitude: 88.0
#### Half Angle: 39.0
#### Speed: 1080.0
#### Type: O
#### Most Accurate: True
#### Level of Data: 0
#### [Link](https://kauai.ccmc.gsfc.nasa.gov/DONKI/view/CMEAnalysis/20772/-1)
#### Note: A preliminary measurement of the leading edge using only earliest available frames of SOHO/C3.
## Activity ID: 2022-07-09T15:36:00-CME-001
### Catalog: M2M_CATALOG
### Start Time: 2022-07-09T15:36Z
### Source Location: 
### Active Region Number: None
### [Link](https://kauai.ccmc.gsfc.nasa.gov/DONKI/view/CME/20776/-1)
### Note: A CME seen to the northwest in SOHO coronagraphs and north in Stereo-A coronagraphs. The source appears to be some very weakly moving field lines off the NW limb present in SDO 171.
### Instruments
#### SOHO: LASCO/C2
#### SOHO: LASCO/C3
#### STEREO A: SECCHI/COR2
### Analysis
#### Time: 2022-07-10T01:05Z
#### Latitude: 22.0
#### Longitude: 145.0
#### Half Angle: 33.0
#### Speed: 372.0
#### Type: S
#### Most Accurate: True
#### Level of Data: 0
#### [Link](https://kauai.ccmc.gsfc.nasa.gov/DONKI/view/CMEAnalysis/20777/-1)
#### Note: A measurement of the bulk of the CME using all available coronagraph imagery.
## Activity ID: 2022-07-09T23:12:00-CME-001
### Catalog: M2M_CATALOG
### Start Time: 2022-07-09T23:12Z
### Source Location: N15E10
### Active Region Number: 13053
### [Link](https://kauai.ccmc.gsfc.nasa.gov/DONKI/view/CME/20787/-1)
### Note: A complicated eruption consisting of a generally unimpressive flare/subsequent eruption in coronal imagery located around center-disk (N15E10) from AR3053. A fast jet of plasma is seen sharply deflecting towards the northwest due to the present of multiple coronal holes surrounding the active region, but SOHO/C2 coronagraph imagery shows what could be a faint, wider bulk associated with this eruption generally toward the northwest and an even fainter partial halo emanating generally to the west. It is uncertain whether the halo or bulk is associated with this center-disk eruption or another simultaneous eruption occurring off the Sun's western limb; moving field lines seen in SDO AIA 171 indicate this possibility. A Stereo-A COR2A outage at the time complicates the analysis of this event.
### Instruments
#### SOHO: LASCO/C2
#### SOHO: LASCO/C3
#### STEREO A: SECCHI/COR2
### Analysis
#### Time: 2022-07-10T01:36Z
#### Latitude: 24.0
#### Longitude: 30.0
#### Half Angle: 24.0
#### Speed: 1258.0
#### Type: O
#### Most Accurate: True
#### Level of Data: 0
#### [Link](https://kauai.ccmc.gsfc.nasa.gov/DONKI/view/CMEAnalysis/20802/-1)
#### Note: A measurement of the CME bulk generally headed toward the northwest in SOHO C2/C3 imagery.
#### Time: 2022-07-10T02:18Z
#### Latitude: 24.0
#### Longitude: 48.0
#### Half Angle: 22.0
#### Speed: 1084.0
#### Type: O
#### Most Accurate: False
#### Level of Data: 0
#### [Link](https://kauai.ccmc.gsfc.nasa.gov/DONKI/view/CMEAnalysis/20788/-1)
#### Note: A measurement of what is thought to be the bulk associated with the center-disk eruption and which is sharply deflected due to the presence of coronal holes near AR 3053.
#### Time: 2022-07-10T01:38Z
#### Latitude: 20.0
#### Longitude: 16.0
#### Half Angle: 45.0
#### Speed: 1314.0
#### Type: O
#### Most Accurate: False
#### Level of Data: 0
#### [Link](https://kauai.ccmc.gsfc.nasa.gov/DONKI/view/CMEAnalysis/20789/-1)
#### Note: A preliminary measurement of a faint shock feature that may possibly be associated with the center-disk eruption seen emanating to the west. It is unclear whether this feature is associated with this eruption or a simultaneous eruption behind the Sun's western limb. A Stereo A COR2A outage at this time complicated the analysis process of this feature.
#### Time: 2022-07-10T02:11Z
#### Latitude: 13.0
#### Longitude: 12.0
#### Half Angle: 45.0
#### Speed: 963.0
#### Type: C
#### Most Accurate: False
#### Level of Data: 0
#### [Link](https://kauai.ccmc.gsfc.nasa.gov/DONKI/view/CMEAnalysis/20800/-1)
#### Note: This CME analysis is very uncertain. This is a very faint halo in C2 and even fainter in C3 and no STEREO A COR2 imagery (b/c of a data gap in STEREO A COR2). The 45 degree half-width is the default, the CME is probably narrower since it is very faint and the associated eruption area is small.
## Activity ID: 2022-07-10T02:23:00-CME-001
### Catalog: M2M_CATALOG
### Start Time: 2022-07-10T02:23Z
### Source Location: 
### Active Region Number: None
### [Link](https://kauai.ccmc.gsfc.nasa.gov/DONKI/view/CME/20781/-1)
### Note: A faint CME that appears generally to the north in SOHO C2/C3 coronagraph imagery and to the northeast in Stereo-A COR2A coronagraph imagery. No Earth-facing source signatures were found for this event.
### Instruments
#### STEREO A: SECCHI/COR2
#### SOHO: LASCO/C2
#### SOHO: LASCO/C3
### Analysis
#### Time: 2022-07-10T10:49Z
#### Latitude: 18.0
#### Longitude: -178.0
#### Half Angle: 25.0
#### Speed: 401.0
#### Type: S
#### Most Accurate: True
#### Level of Data: 0
#### [Link](https://kauai.ccmc.gsfc.nasa.gov/DONKI/view/CMEAnalysis/20782/-1)
#### Note: A measurement of the CME's leading edge, the measuring tool confirmed that this was likely a back-sided event.
## Activity ID: 2022-07-10T18:12:00-CME-001
### Catalog: M2M_CATALOG
### Start Time: 2022-07-10T18:12Z
### Source Location: S50W70
### Active Region Number: None
### [Link](https://kauai.ccmc.gsfc.nasa.gov/DONKI/view/CME/20798/-1)
### Note: A filament/prominence eruption seen to the southwest in SOHO C2/C3 and Stereo-A coronagraph imagery; the filament material is best seen in SDO AIA 304 as early as 2022-07-10T16:19Z and the plasma seems to exhibit rotation while being ejected from the chromosphere.
### Instruments
#### SOHO: LASCO/C2
#### SOHO: LASCO/C3
#### STEREO A: SECCHI/COR2
### Analysis
#### Time: 2022-07-10T20:57Z
#### Latitude: -61.0
#### Longitude: 75.0
#### Half Angle: 14.0
#### Speed: 1276.0
#### Type: O
#### Most Accurate: True
#### Level of Data: 0
#### [Link](https://kauai.ccmc.gsfc.nasa.gov/DONKI/view/CMEAnalysis/20799/-1)
#### Note: A measurement of the CME's leading edge despite generally being asymmetrical due to the shape of the rotating plasma.
## Activity ID: 2022-07-11T13:09:00-CME-001
### Catalog: M2M_CATALOG
### Start Time: 2022-07-11T13:09Z
### Source Location: S20W100
### Active Region Number: 13047
### [Link](https://kauai.ccmc.gsfc.nasa.gov/DONKI/view/CME/20806/-1)
### Note: CME going West in SOHO LASCO C2/C3 and in STEREO A COR2, with the source a filament eruption on/behind the West limb seen in SDO 304 starting 2022-07-11T12:25Z, probably near Active Region 3047, which has rotated behind the limb in the past 24 hours.
### Instruments
#### STEREO A: SECCHI/COR2
#### SOHO: LASCO/C2
#### SOHO: LASCO/C3
### Analysis
#### Time: 2022-07-11T16:50Z
#### Latitude: 7.0
#### Longitude: 116.0
#### Half Angle: 35.0
#### Speed: 846.0
#### Type: C
#### Most Accurate: True
#### Level of Data: 0
#### [Link](https://kauai.ccmc.gsfc.nasa.gov/DONKI/view/CMEAnalysis/20807/-1)
#### Note: Analysis based on best fit in SWPC CAT, taking into account that the filament eruption seems to happen just behind the West limb in SDO.
## Activity ID: 2022-07-13T13:25:00-CME-001
### Catalog: M2M_CATALOG
### Start Time: 2022-07-13T13:25Z
### Source Location: N15W52
### Active Region Number: 13052
### [Link](https://kauai.ccmc.gsfc.nasa.gov/DONKI/view/CME/20814/-1)
### Note: Seen as a faint, fast, and narrow event to the west in SOHO C2/C3 coronagraphs and Stereo-A COR2A, likely associated with a minor eruption of AR 3052 occurring around 2022-07-13T13:00Z.
### Instruments
#### SOHO: LASCO/C2
#### SOHO: LASCO/C3
#### STEREO A: SECCHI/COR2
### Analysis
#### Time: 2022-07-13T16:34Z
#### Latitude: 12.0
#### Longitude: 54.0
#### Half Angle: 17.0
#### Speed: 988.0
#### Type: C
#### Most Accurate: True
#### Level of Data: 0
#### [Link](https://kauai.ccmc.gsfc.nasa.gov/DONKI/view/CMEAnalysis/20815/-1)
#### Note: Measurement of the narrow CME leading edge using SOHO and Stereo-A coronagraph imagery. The CME quickly leaves the C2 field of view and appears to accelerate using C3 frames.
## Activity ID: 2022-07-14T04:12:00-CME-001
### Catalog: M2M_CATALOG
### Start Time: 2022-07-14T04:12Z
### Source Location: 
### Active Region Number: None
### [Link](https://kauai.ccmc.gsfc.nasa.gov/DONKI/view/CME/20821/-1)
### Note: The source signature for this CME observed to the NE of SOHO LASCO C2/C3 and STEREO A COR2 imagery could not be identified in the available EUV imagery.
### Instruments
#### SOHO: LASCO/C2
#### SOHO: LASCO/C3
#### STEREO A: SECCHI/COR2
### Analysis
#### Time: 2022-07-14T14:20Z
#### Latitude: 13.0
#### Longitude: -153.0
#### Half Angle: 37.0
#### Speed: 363.0
#### Type: S
#### Most Accurate: True
#### Level of Data: 1
#### [Link](https://kauai.ccmc.gsfc.nasa.gov/DONKI/view/CMEAnalysis/20822/-1)
#### Note: This SWPC_CAT measurement approximates a longitude of -153 deg by matching the leading edge of the CME in SOHO LASCO C2/C3 and STEREO A COR2 difference imagery.
## Activity ID: 2022-07-14T14:00:00-CME-001
### Catalog: M2M_CATALOG
### Start Time: 2022-07-14T14:00Z
### Source Location: 
### Active Region Number: None
### [Link](https://kauai.ccmc.gsfc.nasa.gov/DONKI/view/CME/20827/-1)
### Note: Observed towards the NW in SOHO LASCO C2; no imagery available from STEREO A COR2 during real-time analysis.  No source could be located for this event.
### Instruments
#### SOHO: LASCO/C2
### Analysis
#### Time: 2022-07-15T00:28Z
#### Latitude: 27.0
#### Longitude: None
#### Half Angle: 19.0
#### Speed: 351.0
#### Type: S
#### Most Accurate: True
#### Level of Data: 0
#### [Link](https://kauai.ccmc.gsfc.nasa.gov/DONKI/view/CMEAnalysis/20828/-1)
#### Note: POS measurement (lon W90) due to lack of second coronagraph and unknown source location.
## Activity ID: 2022-07-14T15:12:00-CME-001
### Catalog: M2M_CATALOG
### Start Time: 2022-07-14T15:12Z
### Source Location: 
### Active Region Number: None
### [Link](https://kauai.ccmc.gsfc.nasa.gov/DONKI/view/CME/20829/-1)
### Note: Observed to SE in SOHO LASCO C2/C3; no STEREO A COR2 imagery available during real-time analysis. Source is likely the prominence eruption observed from SE limb of SDO AIA 304 starting around 2022-07-14T14:30Z.
### Instruments
#### SOHO: LASCO/C2
#### SOHO: LASCO/C3
### Analysis
#### Time: 2022-07-15T03:48Z
#### Latitude: 2.0
#### Longitude: -90.0
#### Half Angle: 26.0
#### Speed: 298.0
#### Type: S
#### Most Accurate: True
#### Level of Data: 0
#### [Link](https://kauai.ccmc.gsfc.nasa.gov/DONKI/view/CMEAnalysis/20830/-1)
#### Note: Longitude approximated from source location; no STEREO A COR2 imagery available for two-spacecraft measurement.
## Activity ID: 2022-07-14T22:24:00-CME-001
### Catalog: M2M_CATALOG
### Start Time: 2022-07-14T22:24Z
### Source Location: N15E71
### Active Region Number: 13058
### [Link](https://kauai.ccmc.gsfc.nasa.gov/DONKI/view/CME/20831/-1)
### Note: Visible in the E in SOHO LASCO C2/C3 and STEREO A COR2 (following STEREO A data gap).  May be associated with M2.8 flare from AR 13058.  Eruption visible in SDO AIA 193/304 beginning around 2022-07-14T20:48Z, rising/opening field lines visible in SDO AIA 171 beginning around 2022-07-14T21:21Z.  Eruption appears to be further west than the associated flare (around longitude E85).  Potentially some slowing as the CME develops.
### Instruments
#### SOHO: LASCO/C2
#### SOHO: LASCO/C3
#### STEREO A: SECCHI/COR2
### Analysis
#### Time: 2022-07-15T05:01Z
#### Latitude: 14.0
#### Longitude: -103.0
#### Half Angle: 18.0
#### Speed: 591.0
#### Type: C
#### Most Accurate: True
#### Level of Data: 0
#### [Link](https://kauai.ccmc.gsfc.nasa.gov/DONKI/view/CMEAnalysis/20832/-1)
#### Note: 
## Activity ID: 2022-07-15T01:25:00-CME-001
### Catalog: M2M_CATALOG
### Start Time: 2022-07-15T01:25Z
### Source Location: N25W20
### Active Region Number: None
### [Link](https://kauai.ccmc.gsfc.nasa.gov/DONKI/view/CME/20833/-1)
### Note: Faintly visible in NNE of SOHO LASCO C2 and in the NW in STEREO A COR2 (following STEREO A data gap).  May be associated with small filament eruption near N25W20, just off the W end of a much larger filament crossing the central meridian in the northern hemisphere.  Visible in SDO AIA 171/193/304 beginning around 2022-07-14T22:37Z.
### Instruments
#### SOHO: LASCO/C2
#### STEREO A: SECCHI/COR2
### Analysis
#### Time: 2022-07-15T06:21Z
#### Latitude: 22.0
#### Longitude: -9.0
#### Half Angle: 10.0
#### Speed: 454.0
#### Type: S
#### Most Accurate: True
#### Level of Data: 0
#### [Link](https://kauai.ccmc.gsfc.nasa.gov/DONKI/view/CMEAnalysis/20834/-1)
#### Note: CME may be narrower than 10 degrees (perhaps 8-9 degrees half-width).  Leading edge is very faint and event vanishes before exiting COR2A FOV.
## Activity ID: 2022-07-15T08:12:00-CME-001
### Catalog: M2M_CATALOG
### Start Time: 2022-07-15T08:12Z
### Source Location: N12E62
### Active Region Number: 13058
### [Link](https://kauai.ccmc.gsfc.nasa.gov/DONKI/view/CME/20835/-1)
### Note: Visible in the E in SOHO LASCO C2/C3 and STEREO A COR2.  May be associated with C3.1 flare from AR 13058 peaking 2022-07-15T07:24Z.  Eruption visible in SDO AIA 131/171/193/304 and STEREO A EUVI 195 beginning 2022-07-15T07:21Z.
### Instruments
#### SOHO: LASCO/C2
#### SOHO: LASCO/C3
#### STEREO A: SECCHI/COR2
### Analysis
#### Time: 2022-07-15T19:14Z
#### Latitude: 5.0
#### Longitude: -78.0
#### Half Angle: 10.0
#### Speed: 321.0
#### Type: S
#### Most Accurate: True
#### Level of Data: 0
#### [Link](https://kauai.ccmc.gsfc.nasa.gov/DONKI/view/CMEAnalysis/20836/-1)
#### Note: Possibly as narrow as 8-9 degrees half-width.  Leading edge is diffuse and difficult to measure.
## Activity ID: 2022-07-15T13:36:00-CME-001
### Catalog: M2M_CATALOG
### Start Time: 2022-07-15T13:36Z
### Source Location: N15E64
### Active Region Number: 13058
### [Link](https://kauai.ccmc.gsfc.nasa.gov/DONKI/view/CME/20839/-1)
### Note: Visible in the E in SOHO LASCO C2, no STEREO A COR2 imagery available during real-time analysis.  Associated with C5.5 flare, start 2022-07-15T11:56Z and eruption visible in GOES-16 SUVI 171/195/131 beginning 2022-07-15T11:56Z.
### Instruments
#### SOHO: LASCO/C2
### Analysis
#### Time: 2022-07-15T23:12Z
#### Latitude: 3.0
#### Longitude: -70.0
#### Half Angle: 11.0
#### Speed: 379.0
#### Type: S
#### Most Accurate: True
#### Level of Data: 1
#### [Link](https://kauai.ccmc.gsfc.nasa.gov/DONKI/view/CMEAnalysis/20844/-1)
#### Note: Remeasured with C3/COR2A imagery following downlink.
#### Time: 2022-07-15T20:59Z
#### Latitude: 9.0
#### Longitude: -65.0
#### Half Angle: 12.0
#### Speed: 467.0
#### Type: S
#### Most Accurate: False
#### Level of Data: 0
#### [Link](https://kauai.ccmc.gsfc.nasa.gov/DONKI/view/CMEAnalysis/20840/-1)
#### Note: Preliminary measurement using only C2 imagery; no COR2A imagery available.  Longitude approximated from source location.
## Activity ID: 2022-07-15T15:23:00-CME-001
### Catalog: M2M_CATALOG
### Start Time: 2022-07-15T15:23Z
### Source Location: N25W15
### Active Region Number: None
### [Link](https://kauai.ccmc.gsfc.nasa.gov/DONKI/view/CME/20841/-1)
### Note: Visible in the NW in STEREO A COR2 and as a partial halo N in SOHO LASCO C2.  Associated with large north-central filament eruption beginning 2022-07-15T13:02Z, visible in GOES-16 SUVI 171/304.
### Instruments
#### STEREO A: SECCHI/COR2
#### SOHO: LASCO/C2
### Analysis
#### Time: 2022-07-15T23:33Z
#### Latitude: 21.0
#### Longitude: 12.0
#### Half Angle: 41.0
#### Speed: 539.0
#### Type: C
#### Most Accurate: True
#### Level of Data: 1
#### [Link](https://kauai.ccmc.gsfc.nasa.gov/DONKI/view/CMEAnalysis/20859/-1)
#### Note: Remeasured following C3 data downlink.
#### Time: 2022-07-15T23:31Z
#### Latitude: 11.0
#### Longitude: 1.0
#### Half Angle: 34.0
#### Speed: 382.0
#### Type: S
#### Most Accurate: False
#### Level of Data: 0
#### [Link](https://kauai.ccmc.gsfc.nasa.gov/DONKI/view/CMEAnalysis/20842/-1)
#### Note: Very preliminary measurement using 1 frame in COR2A and 2 frames in C2.  Should be remeasured following subsequent coronagraph downlinks.
#### Time: 2022-07-16T01:15Z
#### Latitude: 20.0
#### Longitude: 7.0
#### Half Angle: 41.0
#### Speed: 379.0
#### Type: S
#### Most Accurate: False
#### Level of Data: 0
#### [Link](https://kauai.ccmc.gsfc.nasa.gov/DONKI/view/CMEAnalysis/20845/-1)
#### Note: 2-spacecraft measurement mostly confirming the preliminary analysis, but should be remeasured as it develops into the C3 FOV.
## Activity ID: 2022-07-15T18:12:00-CME-001
### Catalog: M2M_CATALOG
### Start Time: 2022-07-15T18:12Z
### Source Location: N15E62
### Active Region Number: 13058
### [Link](https://kauai.ccmc.gsfc.nasa.gov/DONKI/view/CME/20851/-1)
### Note: Narrow CME visible in the E in both SOHO LASCO C2/C3 and STEREO A COR2.  May be associated with eruption from AR 13058 (N15E62), visible in SDO AIA 131/193/304 beginning 2022-06-15T15:25Z.
### Instruments
#### SOHO: LASCO/C2
#### SOHO: LASCO/C3
#### STEREO A: SECCHI/COR2
### Analysis
#### Time: 2022-07-16T01:18Z
#### Latitude: 4.0
#### Longitude: -90.0
#### Half Angle: 10.0
#### Speed: 509.0
#### Type: C
#### Most Accurate: True
#### Level of Data: 0
#### [Link](https://kauai.ccmc.gsfc.nasa.gov/DONKI/view/CMEAnalysis/20852/-1)
#### Note: Very narrow, perhaps only 6-7 degrees half-width.
## Activity ID: 2022-07-15T21:12:00-CME-001
### Catalog: M2M_CATALOG
### Start Time: 2022-07-15T21:12Z
### Source Location: N15E61
### Active Region Number: 13058
### [Link](https://kauai.ccmc.gsfc.nasa.gov/DONKI/view/CME/20853/-1)
### Note: Narrow CME which overlaps with 2022-07-15T18:12Z CME; visible in E in SOHO LASCO C2 and in the E in STEREO A COR2 (before data gap).  May be associated with eruption from AR 13058 (N15E61), visible in SDO AIA 131/193/304 beginning 2022-06-15T18:12Z.
### Instruments
#### SOHO: LASCO/C2
#### STEREO A: SECCHI/COR2
### Analysis
#### Time: 2022-07-16T03:32Z
#### Latitude: 3.0
#### Longitude: -71.0
#### Half Angle: 10.0
#### Speed: 515.0
#### Type: C
#### Most Accurate: True
#### Level of Data: 0
#### [Link](https://kauai.ccmc.gsfc.nasa.gov/DONKI/view/CMEAnalysis/20854/-1)
#### Note: 
## Activity ID: 2022-07-16T00:48:00-CME-001
### Catalog: M2M_CATALOG
### Start Time: 2022-07-16T00:48Z
### Source Location: N15E59
### Active Region Number: 13058
### [Link](https://kauai.ccmc.gsfc.nasa.gov/DONKI/view/CME/20855/-1)
### Note: Visible in the E in both SOHO LASCO C2 and STEREO A COR2; overlaps with previous CME from same AR.  May be associated with eruption from AR 13058 (N15E59), visible in SDO AIA 171/193/304 beginning 2022-07-15T22:07Z.
### Instruments
#### SOHO: LASCO/C2
#### STEREO A: SECCHI/COR2
### Analysis
#### Time: 2022-07-16T06:50Z
#### Latitude: 10.0
#### Longitude: -70.0
#### Half Angle: 15.0
#### Speed: 490.0
#### Type: S
#### Most Accurate: True
#### Level of Data: 0
#### [Link](https://kauai.ccmc.gsfc.nasa.gov/DONKI/view/CMEAnalysis/20856/-1)
#### Note: 
## Activity ID: 2022-07-16T07:36:00-CME-001
### Catalog: M2M_CATALOG
### Start Time: 2022-07-16T07:36Z
### Source Location: N40W10
### Active Region Number: None
### [Link](https://kauai.ccmc.gsfc.nasa.gov/DONKI/view/CME/20857/-1)
### Note: Faintly visible in N in SOHO LASCO C2/C3 and in NNW in STEREO A COR2.  May possibly be associated with dimming north of a filament eruption centered near N30W10, visible in SDO AIA 171/193/304 and STEREO A EUVI 195/304 beginning 2022-07-16T04:30Z.
### Instruments
#### SOHO: LASCO/C2
#### SOHO: LASCO/C3
#### STEREO A: SECCHI/COR2
### Analysis
#### Time: 2022-07-16T16:26Z
#### Latitude: 41.0
#### Longitude: 2.0
#### Half Angle: 16.0
#### Speed: 423.0
#### Type: S
#### Most Accurate: True
#### Level of Data: 0
#### [Link](https://kauai.ccmc.gsfc.nasa.gov/DONKI/view/CMEAnalysis/20858/-1)
#### Note: 
## Activity ID: 2022-07-16T16:53:00-CME-001
### Catalog: M2M_CATALOG
### Start Time: 2022-07-16T16:53Z
### Source Location: N20W60
### Active Region Number: 13053
### [Link](https://kauai.ccmc.gsfc.nasa.gov/DONKI/view/CME/20863/-1)
### Note: Visible in the W in STEREO A COR2 (overlaps with streamer), no SOHO LASCO direct imagery available during real-time analysis.  May be associated with an eruption near N20W60 (vicinity of AR 13053), visible in SDO AIA 131/171/193/304 and STEREO A EUVI 195/304 beginning 2022-07-16T15:25Z.
### Instruments
#### STEREO A: SECCHI/COR2
### Analysis
#### Time: 2022-07-17T02:10Z
#### Latitude: 0.0
#### Longitude: 55.0
#### Half Angle: 10.0
#### Speed: 370.0
#### Type: S
#### Most Accurate: True
#### Level of Data: 1
#### [Link](https://kauai.ccmc.gsfc.nasa.gov/DONKI/view/CMEAnalysis/20869/-1)
#### Note: Remeasured following subsequent downlink of SOHO coronagraph data.
#### Time: 2022-07-16T21:07Z
#### Latitude: -8.0
#### Longitude: None
#### Half Angle: 13.0
#### Speed: 745.0
#### Type: C
#### Most Accurate: False
#### Level of Data: 0
#### [Link](https://kauai.ccmc.gsfc.nasa.gov/DONKI/view/CMEAnalysis/20864/-1)
#### Note: Preliminary measurement with only 3 frames of COR2A difference imagery available during real-time analysis.
## Activity ID: 2022-07-16T17:09:00-CME-001
### Catalog: M2M_CATALOG
### Start Time: 2022-07-16T17:09Z
### Source Location: N05W25
### Active Region Number: None
### [Link](https://kauai.ccmc.gsfc.nasa.gov/DONKI/view/CME/20865/-1)
### Note: Visible in the WNW in STEREO A COR2, no SOHO LASCO direct imagery available during real-time analysis.  May possibly be associated with dimming visible in SDO AIA 193 beginning around 2022-07-16T16:00Z and filament eruption faintly visible in SDO AIA 304 at the same time.  This appears to have the same trigger as the filament eruption near S30W50, visible in SDO AIA 304 beginning around 2022-07-16T16:30Z.  Possibly deflected NE due to coronal hole to the SW (centered near S15W35).
### Instruments
#### STEREO A: SECCHI/COR2
### Analysis
#### Time: 2022-07-17T00:17Z
#### Latitude: 18.0
#### Longitude: 15.0
#### Half Angle: 31.0
#### Speed: 518.0
#### Type: C
#### Most Accurate: True
#### Level of Data: 1
#### [Link](https://kauai.ccmc.gsfc.nasa.gov/DONKI/view/CMEAnalysis/20870/-1)
#### Note: Remeasured following subsequent downlink of SOHO LASCO imagery.  Event fades before exiting C2 FOV.
#### Time: 2022-07-17T02:23Z
#### Latitude: 16.0
#### Longitude: 60.0
#### Half Angle: 36.0
#### Speed: 386.0
#### Type: S
#### Most Accurate: False
#### Level of Data: 0
#### [Link](https://kauai.ccmc.gsfc.nasa.gov/DONKI/view/CMEAnalysis/20866/-1)
#### Note: Longitude approximated from source location, preliminary measurement with only two frames of COR2A difference imagery.
## Activity ID: 2022-07-16T17:53:00-CME-001
### Catalog: M2M_CATALOG
### Start Time: 2022-07-16T17:53Z
### Source Location: 
### Active Region Number: None
### [Link](https://kauai.ccmc.gsfc.nasa.gov/DONKI/view/CME/20871/-1)
### Note: Visible in the NE in STEREO A COR2.  No SOHO LASCO direct imagery, but visible in SOHO LASCO C2/C3 difference imagery (overlap with NE streamer).  No clear source visible for this event.
### Instruments
#### STEREO A: SECCHI/COR2
#### SOHO: LASCO/C2
#### SOHO: LASCO/C3
### Analysis
#### Time: 2022-07-17T02:38Z
#### Latitude: 38.0
#### Longitude: -117.0
#### Half Angle: 38.0
#### Speed: 405.0
#### Type: S
#### Most Accurate: True
#### Level of Data: 0
#### [Link](https://kauai.ccmc.gsfc.nasa.gov/DONKI/view/CMEAnalysis/20872/-1)
#### Note: 
## Activity ID: 2022-07-16T18:09:00-CME-001
### Catalog: M2M_CATALOG
### Start Time: 2022-07-16T18:09Z
### Source Location: S30W50
### Active Region Number: None
### [Link](https://kauai.ccmc.gsfc.nasa.gov/DONKI/view/CME/20873/-1)
### Note: Visible in the S in STEREO A COR2.  No SOHO LASCO direct imagery available during real-time analysis, but visible in the SW in SOHO LASCO C2/C3 difference imagery.  May be associated with a filament eruption near S30W50, visible in SDO AIA 304 beginning around 2022-07-16T16:30Z.
### Instruments
#### STEREO A: SECCHI/COR2
#### SOHO: LASCO/C2
#### SOHO: LASCO/C3
### Analysis
#### Time: 2022-07-16T23:38Z
#### Latitude: -55.0
#### Longitude: 37.0
#### Half Angle: 32.0
#### Speed: 577.0
#### Type: C
#### Most Accurate: True
#### Level of Data: 0
#### [Link](https://kauai.ccmc.gsfc.nasa.gov/DONKI/view/CMEAnalysis/20874/-1)
#### Note: 
## Activity ID: 2022-07-16T18:36:00-CME-001
### Catalog: M2M_CATALOG
### Start Time: 2022-07-16T18:36Z
### Source Location: 
### Active Region Number: None
### [Link](https://kauai.ccmc.gsfc.nasa.gov/DONKI/view/CME/20883/-1)
### Note: Visible in the SW in STEREO A COR2.  No SOHO LASCO direct imagery available during real-time analysis, but this event is visible in the SW in SOHO LASCO C2/C3 difference imagery.  One of several overlapping CMEs that may be associated with the filament eruption near S30W50, visible in SDO AIA 304 beginning around 2022-07-16T16:30Z.  There appears to be deflection in the FOV, and the CME appears to slow down in the FOV.
### Instruments
#### SOHO: LASCO/C2
#### SOHO: LASCO/C3
#### STEREO A: SECCHI/COR2
### Analysis
#### Time: 2022-07-17T03:42Z
#### Latitude: -14.0
#### Longitude: 44.0
#### Half Angle: 33.0
#### Speed: 326.0
#### Type: S
#### Most Accurate: True
#### Level of Data: 0
#### [Link](https://kauai.ccmc.gsfc.nasa.gov/DONKI/view/CMEAnalysis/20884/-1)
#### Note: Appears faster in the C2 FOV, as fast as 425-450 km/s.  This event was modeled in a 2-CME simulation with the 2022-07-16T17:09Z CME but did not significantly perturb the predicted impacts of that CME.
## Activity ID: 2022-07-17T02:38:00-CME-001
### Catalog: M2M_CATALOG
### Start Time: 2022-07-17T02:38Z
### Source Location: N15W78
### Active Region Number: 13053
### [Link](https://kauai.ccmc.gsfc.nasa.gov/DONKI/view/CME/20875/-1)
### Note: Visible in the W in STEREO A COR2.  No SOHO LASCO direct imagery available during real-time analysis, but visible in the W in SOHO LASCO C2/C3 difference imagery.  May be associated with eruption and rising field lines from AR 13053 (N15W78), visible in SDO AIA 171/193/304 beginning 2022-07-17T01:12Z.
### Instruments
#### STEREO A: SECCHI/COR2
#### SOHO: LASCO/C2
#### SOHO: LASCO/C3
### Analysis
#### Time: 2022-07-17T07:33Z
#### Latitude: 24.0
#### Longitude: 76.0
#### Half Angle: 25.0
#### Speed: 714.0
#### Type: C
#### Most Accurate: True
#### Level of Data: 0
#### [Link](https://kauai.ccmc.gsfc.nasa.gov/DONKI/view/CMEAnalysis/20876/-1)
#### Note: 
## Activity ID: 2022-07-18T03:53:00-CME-001
### Catalog: M2M_CATALOG
### Start Time: 2022-07-18T03:53Z
### Source Location: S20E110
### Active Region Number: None
### [Link](https://kauai.ccmc.gsfc.nasa.gov/DONKI/view/CME/20887/-1)
### Note: Faintly visible in the SE in STEREO A COR2 and in SOHO LASCO C2.  No SDO imagery of the source due to a data gap.  May be associated with an eruption from unnumbered AR near E limb of STEREO A (near S20E110), visible in STEREO A EUVI 195/304 beginning 2022-07-18T02:05Z.
### Instruments
#### STEREO A: SECCHI/COR2
#### SOHO: LASCO/C2
### Analysis
#### Time: 2022-07-18T13:48Z
#### Latitude: -26.0
#### Longitude: -107.0
#### Half Angle: 10.0
#### Speed: 346.0
#### Type: S
#### Most Accurate: True
#### Level of Data: 0
#### [Link](https://kauai.ccmc.gsfc.nasa.gov/DONKI/view/CMEAnalysis/20888/-1)
#### Note: A bit of equatorward deflection, but the front fades before it exits either FOV.  Very narrow, perhaps half-width closer to 6-7 degrees.
## Activity ID: 2022-07-18T16:36:00-CME-001
### Catalog: M2M_CATALOG
### Start Time: 2022-07-18T16:36Z
### Source Location: 
### Active Region Number: None
### [Link](https://kauai.ccmc.gsfc.nasa.gov/DONKI/view/CME/20892/-1)
### Note: Faintly visible in the NW of SOHO LASCO C2/C3 and STEREO A COR2.  May possibly be associated with a faint field line rising/opening visible in SDO AIA 171 beginning 2022-07-18T15:54Z, which may possibly be associated with an eruption over the NW limb (near lat N25), visible in GOES-16 SUVI 171/195/304 beginning 2022-07-18T15:40Z.
### Instruments
#### SOHO: LASCO/C2
#### SOHO: LASCO/C3
#### STEREO A: SECCHI/COR2
### Analysis
#### Time: 2022-07-18T20:28Z
#### Latitude: 27.0
#### Longitude: 139.0
#### Half Angle: 27.0
#### Speed: 801.0
#### Type: C
#### Most Accurate: True
#### Level of Data: 0
#### [Link](https://kauai.ccmc.gsfc.nasa.gov/DONKI/view/CMEAnalysis/20893/-1)
#### Note: Preliminary measurement using C2 and COR2A.
## Activity ID: 2022-07-18T17:24:00-CME-001
### Catalog: M2M_CATALOG
### Start Time: 2022-07-18T17:24Z
### Source Location: S30W30
### Active Region Number: 13056
### [Link](https://kauai.ccmc.gsfc.nasa.gov/DONKI/view/CME/20900/-1)
### Note: Bright CME SW in SOHO LASCO and STEREO A COR2. This CME seems to have accelerated over time. Its source seems to be a slow filament eruption mostly SE from AR 3056 (which was located at W40S17 at the time of eruption), possibly stretching along latitude of ~30 deg, with dimming stretching from W10 to W30 and post-eruptive arcades at W30-W50.
### Instruments
#### SOHO: LASCO/C2
#### SOHO: LASCO/C3
#### STEREO A: SECCHI/COR2
### Analysis
#### Time: 2022-07-19T05:15Z
#### Latitude: -37.0
#### Longitude: 22.0
#### Half Angle: 35.0
#### Speed: 483.0
#### Type: S
#### Most Accurate: True
#### Level of Data: 0
#### [Link](https://kauai.ccmc.gsfc.nasa.gov/DONKI/view/CMEAnalysis/20918/-1)
#### Note: These are updated parameters based off of more imagery available in SOHO LASCO C3 to account for increase in speed as the CME propagated outwards in the field of view.
#### Time: 2022-07-19T05:56Z
#### Latitude: -40.0
#### Longitude: 29.0
#### Half Angle: 35.0
#### Speed: 385.0
#### Type: S
#### Most Accurate: False
#### Level of Data: 0
#### [Link](https://kauai.ccmc.gsfc.nasa.gov/DONKI/view/CMEAnalysis/20901/-1)
#### Note: Analysis is mostly based on the best fit of two coronagraphs in SWPC_CAT because the eruption has a wide range of longitudes. To account for the CME speeding up only later timestamps were used in this analysis.
#### Time: 2022-07-19T05:32Z
#### Latitude: -37.0
#### Longitude: 20.0
#### Half Angle: 33.0
#### Speed: 410.0
#### Type: S
#### Most Accurate: False
#### Level of Data: 1
#### [Link](https://kauai.ccmc.gsfc.nasa.gov/DONKI/view/CMEAnalysis/20903/-1)
#### Note: Analysis based on the best fit of two coronagraphs in SWPC_CAT.
## Activity ID: 2022-07-18T17:24:00-CME-002
### Catalog: M2M_CATALOG
### Start Time: 2022-07-18T17:24Z
### Source Location: 
### Active Region Number: None
### [Link](https://kauai.ccmc.gsfc.nasa.gov/DONKI/view/CME/20909/-1)
### Note: Narrow jet CME starting 2022-07-18T17:24Z SE in both coronagraphs. Associated with eruption seen in AIA 171 behind the SE limb and in EUVI A 195 on the SE limb.
### Instruments
#### SOHO: LASCO/C2
#### SOHO: LASCO/C3
#### STEREO A: SECCHI/COR2
### Analysis
#### Time: 2022-07-19T10:28Z
#### Latitude: -23.0
#### Longitude: -99.0
#### Half Angle: 10.0
#### Speed: 551.0
#### Type: C
#### Most Accurate: True
#### Level of Data: 1
#### [Link](https://kauai.ccmc.gsfc.nasa.gov/DONKI/view/CMEAnalysis/20910/-1)
#### Note: 
## Activity ID: 2022-07-19T11:36:00-CME-001
### Catalog: M2M_CATALOG
### Start Time: 2022-07-19T11:36Z
### Source Location: S25W90
### Active Region Number: None
### [Link](https://kauai.ccmc.gsfc.nasa.gov/DONKI/view/CME/20911/-1)
### Note: Very narrow and fast CME SW in C2/C3, COR2A | Source: Eruption seen best in SDO AIA 304 around 2022-07-19T11:09Z just on the SW limb.
### Instruments
#### SOHO: LASCO/C2
#### SOHO: LASCO/C3
#### STEREO A: SECCHI/COR2
### Analysis
#### Time: 2022-07-19T16:04Z
#### Latitude: -25.0
#### Longitude: 79.0
#### Half Angle: 10.0
#### Speed: 761.0
#### Type: C
#### Most Accurate: True
#### Level of Data: 1
#### [Link](https://kauai.ccmc.gsfc.nasa.gov/DONKI/view/CMEAnalysis/20912/-1)
#### Note: 
## Activity ID: 2022-07-19T23:12:00-CME-001
### Catalog: M2M_CATALOG
### Start Time: 2022-07-19T23:12Z
### Source Location: N10E55
### Active Region Number: None
### [Link](https://kauai.ccmc.gsfc.nasa.gov/DONKI/view/CME/20915/-1)
### Note: Visible in the NE of SOHO LASCO C2/C3 and STEREO A COR2. There is a data gap during this event from 2022-07-20T02:36Z to 09:06Z in SOHO LASCO C2/C3. The likely source is an eruption centered at N10E55 starting around 2022-07-19T18:00Z. The source signature is dimming best seen in SDO AIA 193 and STEREO A EUVI 195.
### Instruments
#### SOHO: LASCO/C2
#### SOHO: LASCO/C3
#### STEREO A: SECCHI/COR2
### Analysis
#### Time: 2022-07-20T13:21Z
#### Latitude: 24.0
#### Longitude: -63.0
#### Half Angle: 17.0
#### Speed: 272.0
#### Type: S
#### Most Accurate: True
#### Level of Data: 0
#### [Link](https://kauai.ccmc.gsfc.nasa.gov/DONKI/view/CMEAnalysis/20916/-1)
#### Note: Due to the data gap in SOHO LASCO C2/C3, STEREO A COR2 imagery was used for the majority of this measurement. SOHO LASCO C3 frames were available for later timestamps.
## Activity ID: 2022-07-20T00:36:00-CME-001
### Catalog: M2M_CATALOG
### Start Time: 2022-07-20T00:36Z
### Source Location: 
### Active Region Number: None
### [Link](https://kauai.ccmc.gsfc.nasa.gov/DONKI/view/CME/20913/-1)
### Note: Jet like CME seen to the SW in SOHO LASCO C2 and C3. The features is not clearly visible in STEREO A COR2 imagery. The potential source for this CME is a jet of plasma that is erupting along the SW limb just prior to the first visible portion of the CME in SOHO LASCO C2. The close timing of the source and the event visibility in SOHO LASCO C2 may suggest the source is not the right match.
### Instruments
#### SOHO: LASCO/C2
#### SOHO: LASCO/C3
### Analysis
#### Time: 2022-07-20T08:18Z
#### Latitude: -20.0
#### Longitude: None
#### Half Angle: 15.0
#### Speed: 469.0
#### Type: S
#### Most Accurate: True
#### Level of Data: 0
#### [Link](https://kauai.ccmc.gsfc.nasa.gov/DONKI/view/CMEAnalysis/20914/-1)
#### Note: The half-width of this CME may be closer to 10 degrees. These parameters provided the best fit with the faint/diffuse front visible in SOHO LASCO C2, C3 difference imagery. Speeds may vary between 450 km/s and 550 km/s.
## Activity ID: 2022-07-21T01:25:00-CME-001
### Catalog: M2M_CATALOG
### Start Time: 2022-07-21T01:25Z
### Source Location: S26W60
### Active Region Number: 13062
### [Link](https://kauai.ccmc.gsfc.nasa.gov/DONKI/view/CME/20930/-1)
### Note: The first of three difficult to analyze CMEs due to SOHO and Stereo-A coronagraph gaps that were present in the field of view following data resumption. This CME appears to be associated with moving field lines best seen in SDO AIA 193 and post eruptive arcades near AR 3062, though an SDO calibration maneuver limited analysis of this event.
### Instruments
#### SOHO: LASCO/C2
#### SOHO: LASCO/C3
### Analysis
#### Time: 2022-07-21T02:34Z
#### Latitude: -25.0
#### Longitude: -51.0
#### Half Angle: 22.0
#### Speed: 1479.0
#### Type: O
#### Most Accurate: True
#### Level of Data: 1
#### [Link](https://kauai.ccmc.gsfc.nasa.gov/DONKI/view/CMEAnalysis/20937/-1)
#### Note: A measurement of the leading edge of the CME which was already into the field of view following a SOHO data gap. No Stereo-A coronagraph imagery was available for this event.
#### Time: 2022-07-21T02:49Z
#### Latitude: -26.0
#### Longitude: -60.0
#### Half Angle: 28.0
#### Speed: 1374.0
#### Type: O
#### Most Accurate: False
#### Level of Data: 0
#### [Link](https://kauai.ccmc.gsfc.nasa.gov/DONKI/view/CMEAnalysis/20935/-1)
#### Note: A measurement of the leading edge of the CME using the source location of AR3062 to approximate the longitude.
## Activity ID: 2022-07-21T01:36:00-CME-001
### Catalog: M2M_CATALOG
### Start Time: 2022-07-21T01:36Z
### Source Location: N25E10
### Active Region Number: None
### [Link](https://kauai.ccmc.gsfc.nasa.gov/DONKI/view/CME/20922/-1)
### Note: Second of a triplet of CMEs that are difficult to analyze due to ongoing coronagraph data gaps. This CME's source location appears to be associated with dimming seen around the vicinity of N25E10 from 19:30Z to 21:00Z in GOES SUVI 195 imagery due to an ongoing SDO maneuver at the time.
### Instruments
#### SOHO: LASCO/C2
#### SOHO: LASCO/C3
### Analysis
#### Time: 2022-07-21T03:09Z
#### Latitude: 11.0
#### Longitude: -18.0
#### Half Angle: 25.0
#### Speed: 950.0
#### Type: C
#### Most Accurate: True
#### Level of Data: 0
#### [Link](https://kauai.ccmc.gsfc.nasa.gov/DONKI/view/CMEAnalysis/20923/-1)
#### Note: A measurement of the bulk of the CME which is generally moving east in SOHO coronagraph imagery and ignoring the faint halo feature that is possibly associated with the event. Given the source longitude at approximately W04, this measurement may represent the most eastward possible longitude for this event.
#### Time: 2022-07-21T04:24Z
#### Latitude: 9.0
#### Longitude: -9.0
#### Half Angle: 45.0
#### Speed: 798.0
#### Type: C
#### Most Accurate: False
#### Level of Data: 0
#### [Link](https://kauai.ccmc.gsfc.nasa.gov/DONKI/view/CMEAnalysis/20925/-1)
#### Note: A measurement of the leading edge of the bulk directed toward the east, but wide enough to encapsulate the leading edge of the halo feature as well, assuming the events are correlated.
## Activity ID: 2022-07-21T01:48:00-CME-001
### Catalog: M2M_CATALOG
### Start Time: 2022-07-21T01:48Z
### Source Location: N13W04
### Active Region Number: 13060
### [Link](https://kauai.ccmc.gsfc.nasa.gov/DONKI/view/CME/20932/-1)
### Note: A faint, full halo CME seen in SOHO running difference imagery that seems to be associated with a C5.6-class flare occurring around the Sun's center disk from AR3060. A Stereo-Ahead coronagraph data gap at this time increases the uncertainty of the analysis.
### Instruments
#### SOHO: LASCO/C2
#### SOHO: LASCO/C3
### Analysis
#### Time: 2022-07-21T03:55Z
#### Latitude: 8.0
#### Longitude: 2.0
#### Half Angle: 45.0
#### Speed: 1355.0
#### Type: O
#### Most Accurate: True
#### Level of Data: 0
#### [Link](https://kauai.ccmc.gsfc.nasa.gov/DONKI/view/CMEAnalysis/20934/-1)
#### Note: A measurement of the faint shock halo using more available SOHO C3 frames.
#### Time: 2022-07-21T03:43Z
#### Latitude: 8.0
#### Longitude: 3.0
#### Half Angle: 45.0
#### Speed: 1546.0
#### Type: O
#### Most Accurate: False
#### Level of Data: 0
#### [Link](https://kauai.ccmc.gsfc.nasa.gov/DONKI/view/CMEAnalysis/20924/-1)
#### Note: A preliminary measurement of the faint, fast halo associated with the eruption using only SOHO coronagraph imagery and knowledge of the likely source location.
## Activity ID: 2022-07-21T23:26:00-CME-001
### Catalog: M2M_CATALOG
### Start Time: 2022-07-21T23:26Z
### Source Location: 
### Active Region Number: None
### [Link](https://kauai.ccmc.gsfc.nasa.gov/DONKI/view/CME/20941/-1)
### Note: Visible in the N in SOHO LASCO C2/C3, faintly visible outside of real-time data gap in the N in STEREO A COR2.  May be associated with a filament eruption over the N limb, visible in SDO AIA 171/304 beginning 2022-07-21T21:18Z.  Apparent westward deflection (backside) of CME from apparent source location.
### Instruments
#### SOHO: LASCO/C2
#### SOHO: LASCO/C3
#### STEREO A: SECCHI/COR2
### Analysis
#### Time: 2022-07-22T07:50Z
#### Latitude: 53.0
#### Longitude: -146.0
#### Half Angle: 35.0
#### Speed: 385.0
#### Type: S
#### Most Accurate: True
#### Level of Data: 0
#### [Link](https://kauai.ccmc.gsfc.nasa.gov/DONKI/view/CMEAnalysis/20942/-1)
#### Note: 
## Activity ID: 2022-07-22T14:23:00-CME-001
### Catalog: M2M_CATALOG
### Start Time: 2022-07-22T14:23Z
### Source Location: 
### Active Region Number: None
### [Link](https://kauai.ccmc.gsfc.nasa.gov/DONKI/view/CME/20943/-1)
### Note: Faintly visible in the E in STEREO A COR2 and SOHO LASCO C2.  Overlaps with NE streamer in SOHO LASCO C2.  No definitive source, but may possibly be associated with small filament eruption visible over E limb in STEREO A EUVI 304 around 2022-07-22T12:15Z.
### Instruments
#### STEREO A: SECCHI/COR2
#### SOHO: LASCO/C2
### Analysis
#### Time: 2022-07-23T00:05Z
#### Latitude: -2.0
#### Longitude: -151.0
#### Half Angle: 21.0
#### Speed: 373.0
#### Type: S
#### Most Accurate: True
#### Level of Data: 0
#### [Link](https://kauai.ccmc.gsfc.nasa.gov/DONKI/view/CMEAnalysis/20944/-1)
#### Note: Preliminary measurement with limited coronagraph data available during real-time analysis.
## Activity ID: 2022-07-22T16:25:00-CME-001
### Catalog: M2M_CATALOG
### Start Time: 2022-07-22T16:25Z
### Source Location: 
### Active Region Number: None
### [Link](https://kauai.ccmc.gsfc.nasa.gov/DONKI/view/CME/20949/-1)
### Note: Visible in the SW in SOHO LASCO C2 and STEREO A COR2.  May be associated with eruption from vicinity of S25W85, visible in SDO AIA 171/193/304 beginning 2022-07-22T14:28Z.
### Instruments
#### SOHO: LASCO/C2
#### STEREO A: SECCHI/COR2
### Analysis
#### Time: 2022-07-23T00:37Z
#### Latitude: -29.0
#### Longitude: 80.0
#### Half Angle: 14.0
#### Speed: 632.0
#### Type: C
#### Most Accurate: True
#### Level of Data: 0
#### [Link](https://kauai.ccmc.gsfc.nasa.gov/DONKI/view/CMEAnalysis/20955/-1)
#### Note: These parameters are based off of the shock front measurement made in swpc_cat. Similar speeds were found using StereoCAT to measure the shock front.
#### Time: 2022-07-23T05:11Z
#### Latitude: -32.0
#### Longitude: 82.0
#### Half Angle: 26.0
#### Speed: 286.0
#### Type: S
#### Most Accurate: False
#### Level of Data: 0
#### [Link](https://kauai.ccmc.gsfc.nasa.gov/DONKI/view/CMEAnalysis/20950/-1)
#### Note: Preliminary measurement in early development with 4 frames C2 and 2 frames COR2A.
#### Time: 2022-07-23T05:53Z
#### Latitude: -30.0
#### Longitude: 91.0
#### Half Angle: 24.0
#### Speed: 331.0
#### Type: S
#### Most Accurate: False
#### Level of Data: 0
#### [Link](https://kauai.ccmc.gsfc.nasa.gov/DONKI/view/CMEAnalysis/20956/-1)
#### Note: These parameters are based off of the bulk of the CME. The brighter leading edge was used for this measurement. Measured speeds ranged from 270km/s-340km/s.
## Activity ID: 2022-07-22T17:24:00-CME-001
### Catalog: M2M_CATALOG
### Start Time: 2022-07-22T17:24Z
### Source Location: 
### Active Region Number: None
### [Link](https://kauai.ccmc.gsfc.nasa.gov/DONKI/view/CME/20946/-1)
### Note: Visible in the NW in SOHO LASCO C2 and STEREO A COR2.  Moves quickly through C2 FOV.  No definitive source, but may possibly be associated with opening/rising field lines faintly visible in SDO AIA 171 beginning 2022-07-22T16:57Z.
### Instruments
#### SOHO: LASCO/C2
#### SOHO: LASCO/C3
#### STEREO A: SECCHI/COR2
### Analysis
#### Time: 2022-07-22T20:07Z
#### Latitude: 21.0
#### Longitude: 121.0
#### Half Angle: 31.0
#### Speed: 1361.0
#### Type: O
#### Most Accurate: True
#### Level of Data: 0
#### [Link](https://kauai.ccmc.gsfc.nasa.gov/DONKI/view/CMEAnalysis/20947/-1)
#### Note: 
#### Time: 2022-07-22T20:22Z
#### Latitude: 20.0
#### Longitude: 117.0
#### Half Angle: 32.0
#### Speed: 1197.0
#### Type: O
#### Most Accurate: False
#### Level of Data: 0
#### [Link](https://kauai.ccmc.gsfc.nasa.gov/DONKI/view/CMEAnalysis/20948/-1)
#### Note: 
## Activity ID: 2022-07-23T19:00:00-CME-001
### Catalog: M2M_CATALOG
### Start Time: 2022-07-23T19:00Z
### Source Location: 
### Active Region Number: None
### [Link](https://kauai.ccmc.gsfc.nasa.gov/DONKI/view/CME/20959/-1)
### Note: Full halo CME visible mainly to the southwest in SOHO LASCO C2, C3 and STEREO A COR2 imagery. This halo overlaps another halo that is more towards the northeast in SOHO LASCO C2, C3, and STEREO A COR2 imagery. The source of this CME is not visible due to the backsided nature of the event. There is some uncertainty with this event due to multiple CMEs occurring during the time of this event.
### Instruments
#### SOHO: LASCO/C2
#### SOHO: LASCO/C3
#### STEREO A: SECCHI/COR2
### Analysis
#### Time: 2022-07-23T21:30Z
#### Latitude: -18.0
#### Longitude: -178.0
#### Half Angle: 47.0
#### Speed: 1380.0
#### Type: O
#### Most Accurate: True
#### Level of Data: 0
#### [Link](https://kauai.ccmc.gsfc.nasa.gov/DONKI/view/CMEAnalysis/20960/-1)
#### Note: These parameters are based off of the best fit with matching features in both SOHO LASCO coronagraphs and the STEREO A COR2 coronagraph. The tracked halo feature is seen mainly to the southwest in all coronagraphs and overlaps a more northern halo feature. The speeds measured for this halo ranged from roughly 1200 km/s to roughly 1500 km/s. There is uncertainty with this event due to the number of CME features in the coronagraphs at the time of the event making for tricky analysis.
## Activity ID: 2022-07-23T19:09:00-CME-001
### Catalog: M2M_CATALOG
### Start Time: 2022-07-23T19:09Z
### Source Location: 
### Active Region Number: None
### [Link](https://kauai.ccmc.gsfc.nasa.gov/DONKI/view/CME/20961/-1)
### Note: This halo CME is visible mainly to the north/northeast in SOHO LASCO C2, C3 and more towards the north/northwest in STEREO A COR2 imagery. The front of this CME is relatively faint compared to the other CMEs occurring around the same time. The source of this CME is unclear due to the backsided nature of the event. Due to the multiple CMEs at the time of this event, the analysis of this event was difficult and may have some uncertainty with the parameters.
### Instruments
#### STEREO A: SECCHI/COR2
#### SOHO: LASCO/C2
#### SOHO: LASCO/C3
### Analysis
#### Time: 2022-07-23T21:08Z
#### Latitude: 4.0
#### Longitude: 175.0
#### Half Angle: 45.0
#### Speed: 1582.0
#### Type: O
#### Most Accurate: True
#### Level of Data: 0
#### [Link](https://kauai.ccmc.gsfc.nasa.gov/DONKI/view/CMEAnalysis/20962/-1)
#### Note: These parameters are based off of the best fit between SOHO LASCO coronagraphs and the STEREO A COR2 coronagraph imagery. There are multiple CMEs at the time of this event making for a tricky analysis process. Uncertainty may be higher than normal with this event. The measured speed of this CME ranges from roughly 900 km/s to 1800 km/s. The wide range of speeds is due to a portion of the leading edge of the CME seen towards the northeast in SOHO LASCO C2, C3, and STEREO A COR2 moving faster in later frames.
## Activity ID: 2022-07-23T19:12:00-CME-001
### Catalog: M2M_CATALOG
### Start Time: 2022-07-23T19:12Z
### Source Location: 
### Active Region Number: None
### [Link](https://kauai.ccmc.gsfc.nasa.gov/DONKI/view/CME/20963/-1)
### Note: This CME is seen faintly to the SW in SOHO LASCO C2, C3 and more clearly to the SW in STEREO A COR2 imagery. The potential source of this CME is a minor eruption to the south of AR13059 that is associated with filament material. The exact start time of this CME was difficult to delineate due to the overlapping of multiple CMEs.
### Instruments
#### SOHO: LASCO/C2
#### SOHO: LASCO/C3
#### STEREO A: SECCHI/COR2
### Analysis
#### Time: 2022-07-23T23:33Z
#### Latitude: -45.0
#### Longitude: 95.0
#### Half Angle: 34.0
#### Speed: 952.0
#### Type: C
#### Most Accurate: True
#### Level of Data: 0
#### [Link](https://kauai.ccmc.gsfc.nasa.gov/DONKI/view/CMEAnalysis/20964/-1)
#### Note: This CME was difficult to analyze due to the overlapping nature of this CME with multiple other CMEs occurring in the coronagraphs at the time, therefore these parameters may have a higher degree of uncertainty. Updates may be made for this CME as the STEREO A science imagery becomes available.
## Activity ID: 2022-07-23T19:36:00-CME-001
### Catalog: M2M_CATALOG
### Start Time: 2022-07-23T19:36Z
### Source Location: 
### Active Region Number: None
### [Link](https://kauai.ccmc.gsfc.nasa.gov/DONKI/view/CME/20965/-1)
### Note: This CME is associated with a large filament eruption seen clearly in SDO/AIA 304 and 171. The filament is seen beyond the limb to the SW and is believed to be backsided. There is associated field line movement visible in SDO/AIA 171. Bright H-alpha emission is visible with the filament as it propagates outward in the SOHO LASCO C2, C3 and STEREO A COR2 fields of view. This CME overlaps with multiple other CMEs seen in the coronagraphs.
### Instruments
#### SOHO: LASCO/C2
#### SOHO: LASCO/C3
#### STEREO A: SECCHI/COR2
### Analysis
#### Time: 2022-07-24T00:27Z
#### Latitude: -31.0
#### Longitude: 147.0
#### Half Angle: 24.0
#### Speed: 859.0
#### Type: C
#### Most Accurate: True
#### Level of Data: 0
#### [Link](https://kauai.ccmc.gsfc.nasa.gov/DONKI/view/CMEAnalysis/20966/-1)
#### Note: These parameters are based off of the fit around the filament feature since the edges of the CME are not clearly visible in the coronagraphs due to overlap with multiple CMEs. Therefore, this CME may be wider and slightly slower. StereoCAT measurements suggest speeds closer to 650-700 km/s.
## Activity ID: 2022-07-23T20:53:00-CME-001
### Catalog: M2M_CATALOG
### Start Time: 2022-07-23T20:53Z
### Source Location: 
### Active Region Number: None
### [Link](https://kauai.ccmc.gsfc.nasa.gov/DONKI/view/CME/20979/-1)
### Note: This CME is visible to the northeast in STEREO A COR2 imagery and to the north/northeast in SOHO LASCO C2 imagery. It is faintly visible in SOHO LASCO C3 difference imagery for a frame or two, but not enough to use for analysis. The source of this CME appears to be a filament eruption beyond the eastern limb of STEREO A EUVI data as seen in one frame of STEREO A EUVI 304 at 2022-07-23T20:15Z. There is a large data gap in STEREO A data that impacted the analysis of this CME, especially when locating the source location.
### Instruments
#### STEREO A: SECCHI/COR2
#### SOHO: LASCO/C2
### Analysis
#### Time: 2022-07-24T04:43Z
#### Latitude: 14.0
#### Longitude: -173.0
#### Half Angle: 15.0
#### Speed: 409.0
#### Type: S
#### Most Accurate: True
#### Level of Data: 0
#### [Link](https://kauai.ccmc.gsfc.nasa.gov/DONKI/view/CMEAnalysis/20980/-1)
#### Note: These parameters are based off of the best fit of the brighter filamentary feature seen to the northeast in STEREO A COR2 and to the north-northeast in SOHO LASCO C2. A portion of the CME was left out of this measurement to gain a better fit. The portion was seen to the left of the CME and moved with the main filament structure, but did not appear fully connected. It was harder to track in the imagery, therefore it was excluded. Updated parameters may be provided when STEREO A Science Data becomes available.
## Activity ID: 2022-07-24T00:36:00-CME-001
### Catalog: M2M_CATALOG
### Start Time: 2022-07-24T00:36Z
### Source Location: 
### Active Region Number: None
### [Link](https://kauai.ccmc.gsfc.nasa.gov/DONKI/view/CME/20981/-1)
### Note: The eruption is a minor eruption which seems to follow the path of a larger filament eruption occurring a few hours before it; as like the filament, the source seems to be beyond the southeastern limb. There is no usable Stereo-A data at the time of the eruption.
### Instruments
#### SOHO: LASCO/C2
#### SOHO: LASCO/C3
### Analysis
#### Time: 2022-07-24T07:12Z
#### Latitude: -31.0
#### Longitude: None
#### Half Angle: 30.0
#### Speed: 537.0
#### Type: C
#### Most Accurate: True
#### Level of Data: 0
#### [Link](https://kauai.ccmc.gsfc.nasa.gov/DONKI/view/CMEAnalysis/20982/-1)
#### Note: A measurement of the CME leading edge using early SOHO frames as no Stereo-A data was available at the time of the eruption.
## Activity ID: 2022-07-24T12:00:00-CME-001
### Catalog: M2M_CATALOG
### Start Time: 2022-07-24T12:00Z
### Source Location: 
### Active Region Number: None
### [Link](https://kauai.ccmc.gsfc.nasa.gov/DONKI/view/CME/20976/-1)
### Note: A likely back-sided event with a faint front seen in SOHO running difference imagery just before a wider event. The event was seen to the southeast in SOHO and Stereo A coronagraph imagery starting around 2022-07-24T12:00Z and moving field lines were seen beyond the southeast limb in SDO imagery.
### Instruments
#### SOHO: LASCO/C2
#### SOHO: LASCO/C3
#### STEREO A: SECCHI/COR2
### Analysis
#### Time: 2022-07-24T21:27Z
#### Latitude: -48.0
#### Longitude: -168.0
#### Half Angle: 43.0
#### Speed: 357.0
#### Type: S
#### Most Accurate: True
#### Level of Data: 0
#### [Link](https://kauai.ccmc.gsfc.nasa.gov/DONKI/view/CMEAnalysis/20977/-1)
#### Note: A measurement of the faint leading edge of the CME.
## Activity ID: 2022-07-24T13:25:00-CME-001
### Catalog: M2M_CATALOG
### Start Time: 2022-07-24T13:25Z
### Source Location: 
### Active Region Number: None
### [Link](https://kauai.ccmc.gsfc.nasa.gov/DONKI/view/CME/20972/-1)
### Note: A CME that may be associated with a minor eruption as seen by SDO AIA 171/193 imagery on the southeast portion of the Earth facing disk, though moving magnetic field lines off the eastern limb were also noted at this time. The CME is made up of a very wide and faint front with a dark inner rarefaction region that may possibly be back-sided.
### Instruments
#### SOHO: LASCO/C2
#### STEREO A: SECCHI/COR2
### Analysis
#### Time: 2022-07-25T01:29Z
#### Latitude: -51.0
#### Longitude: -124.0
#### Half Angle: 36.0
#### Speed: 298.0
#### Type: S
#### Most Accurate: True
#### Level of Data: 0
#### [Link](https://kauai.ccmc.gsfc.nasa.gov/DONKI/view/CMEAnalysis/20973/-1)
#### Note: A measurement of the leading edge of the CME; the CME was at first attempted to be fit to the front-sided source but the linear regression was poor. It was found that a back-sided source with longitude -124 seemed to be a better fit of the CME.
## Activity ID: 2022-07-24T18:00:00-CME-001
### Catalog: M2M_CATALOG
### Start Time: 2022-07-24T18:00Z
### Source Location: 
### Active Region Number: None
### [Link](https://kauai.ccmc.gsfc.nasa.gov/DONKI/view/CME/20983/-1)
### Note: A very faint, fast CME seen as a loop structure off the southeast limb in SOHO and Stereo-A coronagraph data which seems to overlap previous CME loop structures, deflected more due east than other CMEs emanating from the area at similar times. The front is not seen well in running difference imagery but is seen in white light/direct imagery.
### Instruments
#### SOHO: LASCO/C2
#### SOHO: LASCO/C3
#### STEREO A: SECCHI/COR2
### Analysis
#### Time: 2022-07-24T21:56Z
#### Latitude: -35.0
#### Longitude: -160.0
#### Half Angle: 27.0
#### Speed: 765.0
#### Type: C
#### Most Accurate: True
#### Level of Data: 0
#### [Link](https://kauai.ccmc.gsfc.nasa.gov/DONKI/view/CMEAnalysis/20984/-1)
#### Note: A measurement of the CME front using StereoCat as the front was not able to be seen in SOHO/STA running difference imagery. The measurement is fairly speculative due to how faint and diffuse the CME appears to be. Other measurements velocities ranged from 500 km/s up to 900 km/s.
## Activity ID: 2022-07-24T19:09:00-CME-001
### Catalog: M2M_CATALOG
### Start Time: 2022-07-24T19:09Z
### Source Location: S25E20
### Active Region Number: 13062
### [Link](https://kauai.ccmc.gsfc.nasa.gov/DONKI/view/CME/20970/-1)
### Note: An eruption from AR3062 occurring around 2022-07-24T18:48Z as seen in SDO AIA 171. An EUV wave is seen emanating to the north and east of the eruption with only a faint CME seen propagating in SOHO and LASCO imagery.
### Instruments
#### STEREO A: SECCHI/COR2
#### SOHO: LASCO/C2
#### SOHO: LASCO/C3
### Analysis
#### Time: 2022-07-24T23:35Z
#### Latitude: -42.0
#### Longitude: -66.0
#### Half Angle: 33.0
#### Speed: 729.0
#### Type: C
#### Most Accurate: True
#### Level of Data: 0
#### [Link](https://kauai.ccmc.gsfc.nasa.gov/DONKI/view/CMEAnalysis/20971/-1)
#### Note: A measurement of the faint leading edge associated with the CME.
## Activity ID: 2022-07-25T08:36:00-CME-001
### Catalog: M2M_CATALOG
### Start Time: 2022-07-25T08:36Z
### Source Location: 
### Active Region Number: None
### [Link](https://kauai.ccmc.gsfc.nasa.gov/DONKI/view/CME/20986/-1)
### Note: Faint and narrow CME seen to the NE in SOHO LASCO C2, C3 and STEREO A COR2 data. There is no clear source for this CME.
### Instruments
#### SOHO: LASCO/C2
#### SOHO: LASCO/C3
#### STEREO A: SECCHI/COR2
### Analysis
#### Time: 2022-07-25T13:09Z
#### Latitude: 26.0
#### Longitude: -125.0
#### Half Angle: 15.0
#### Speed: 726.0
#### Type: C
#### Most Accurate: True
#### Level of Data: 0
#### [Link](https://kauai.ccmc.gsfc.nasa.gov/DONKI/view/CMEAnalysis/20987/-1)
#### Note: These parameters are based off of the best fit between the features seen in both SOHO LASCO and STEREO A coronagraphs. The front of this CME is pretty diffuse, making for a difficult measurement. The measured speeds range from 500 km/s - 800 km/s.
## Activity ID: 2022-07-25T08:38:00-CME-001
### Catalog: M2M_CATALOG
### Start Time: 2022-07-25T08:38Z
### Source Location: 
### Active Region Number: None
### [Link](https://kauai.ccmc.gsfc.nasa.gov/DONKI/view/CME/20988/-1)
### Note: This CME is visible to the west/northwest in STEREO A COR2 and SOHO LASCO C2, C3 imagery. The potential source for this CME is moving/opening field lines visible along the west/northwest limb of STEREO A EUVI 195 and slightly seen in SDO/AIA 171 before and after the moon occults the disk around 07:00Z.
### Instruments
#### STEREO A: SECCHI/COR2
#### SOHO: LASCO/C2
#### SOHO: LASCO/C3
### Analysis
#### Time: 2022-07-25T15:48Z
#### Latitude: 12.0
#### Longitude: 81.0
#### Half Angle: 19.0
#### Speed: 616.0
#### Type: C
#### Most Accurate: True
#### Level of Data: 0
#### [Link](https://kauai.ccmc.gsfc.nasa.gov/DONKI/view/CMEAnalysis/20989/-1)
#### Note: These parameters are based off of the best fit between SOHO LASCO C2, C3 and STEREO A COR2 imagery. The CME features a faint, diffuse front which made it difficult to analyze. The brightest more defined leading edge was tracked for this measurement. Other measurements provided speeds between 600 km/s and 700 km/s.
## Activity ID: 2022-07-26T08:48:00-CME-001
### Catalog: M2M_CATALOG
### Start Time: 2022-07-26T08:48Z
### Source Location: 
### Active Region Number: None
### [Link](https://kauai.ccmc.gsfc.nasa.gov/DONKI/view/CME/20992/-1)
### Note: This CME is visible in the northwest of SOHO LASCO C2 and faintly visible in C3. It is too faint to be seen in STEREO A COR2. The likely source is opening field lines seen on the NW limb in SDO AIA 171/193 starting around 08:00Z.
### Instruments
#### SOHO: LASCO/C2
#### SOHO: LASCO/C3
### Analysis
#### Time: 2022-07-26T14:48Z
#### Latitude: 25.0
#### Longitude: None
#### Half Angle: 13.0
#### Speed: 647.0
#### Type: C
#### Most Accurate: True
#### Level of Data: 0
#### [Link](https://kauai.ccmc.gsfc.nasa.gov/DONKI/view/CMEAnalysis/20993/-1)
#### Note: Plane of sky measurement using SOHO LASCO C2/C3 difference imagery in SWPC_CAT. The plane of sky technique was used because the CME was not visible in STEREO A COR2 and was seen in only one frame of C3.
## Activity ID: 2022-07-26T16:23:00-CME-001
### Catalog: M2M_CATALOG
### Start Time: 2022-07-26T16:23Z
### Source Location: 
### Active Region Number: 13060
### [Link](https://kauai.ccmc.gsfc.nasa.gov/DONKI/view/CME/20995/-1)
### Note: Visible in the west of SOHO LASCO C2/C3 and STEREO A COR2. Associated with a C8.5 flare and opening field lines seen in SDO AIA and STEREO A EUVI 195 imagery. The CME may deflect from the source location due to proximity to a coronal hole previously seen on the Earth-facing disk.
### Instruments
#### STEREO A: SECCHI/COR2
#### SOHO: LASCO/C2
#### SOHO: LASCO/C3
### Analysis
#### Time: 2022-07-27T00:12Z
#### Latitude: 3.0
#### Longitude: 55.0
#### Half Angle: 19.0
#### Speed: 456.0
#### Type: S
#### Most Accurate: True
#### Level of Data: 0
#### [Link](https://kauai.ccmc.gsfc.nasa.gov/DONKI/view/CMEAnalysis/20996/-1)
#### Note: CME longitude varies from the source location by about 30 degrees and may have been deflected in the coronagraphs. While it is no longer clear due to it's location on the limb, the source Active Region was previously seen surrounded by a coronal hole in earlier SDO AIA imagery.
## Activity ID: 2022-07-27T04:00:00-CME-001
### Catalog: M2M_CATALOG
### Start Time: 2022-07-27T04:00Z
### Source Location: N35W52
### Active Region Number: None
### [Link](https://kauai.ccmc.gsfc.nasa.gov/DONKI/view/CME/20999/-1)
### Note: Faint CME NW in SOHO LASCO C2/C3. Its front is not seen in COR2A b/c of the large data gap in STEREO A imagery. A probable source could be a minor eruption in the NW seen in SDO AIA 193 after 2022-07-27T03:30Z as an area of dimming (~N40W52) with the rising loops to the South of it (~N30W52). However, there is also a filament eruption seen close to the NW limb in SDO AIA 304 around 2022-07-27T05:30Z, also seen as moving field lines on the NW limb in SDO AIA 171/193.
### Instruments
#### SOHO: LASCO/C2
#### SOHO: LASCO/C3
### Analysis
#### Time: 2022-07-27T08:23Z
#### Latitude: 32.0
#### Longitude: 52.0
#### Half Angle: 26.0
#### Speed: 781.0
#### Type: C
#### Most Accurate: True
#### Level of Data: 0
#### [Link](https://kauai.ccmc.gsfc.nasa.gov/DONKI/view/CMEAnalysis/21000/-1)
#### Note: Because the front of the CME is not seen in COR2A (data gap), this SWPC CAT analysis is based solely on the possible source of ~N35W52 and SOHO LASCO C2/C3 imagery, however the source location might be further West (based on AIA 304 imagery), therefore this analysis is not reliable.
## Activity ID: 2022-07-27T06:12:00-CME-001
### Catalog: M2M_CATALOG
### Start Time: 2022-07-27T06:12Z
### Source Location: N20W85
### Active Region Number: None
### [Link](https://kauai.ccmc.gsfc.nasa.gov/DONKI/view/CME/21006/-1)
### Note: Narrow (jet) CME NW in SOHO LASCO C2 and STEREP A COR2. Its source is probably the eruption of a filament seen in AIA 304 around 2022-07-27T05:30Z close to the NW limb, also seen as moving field lines on the NW limb in AIA 171 /193 at the time.
### Instruments
#### SOHO: LASCO/C2
#### STEREO A: SECCHI/COR2
### Analysis
#### Time: 2022-07-27T19:53Z
#### Latitude: 12.0
#### Longitude: 85.0
#### Half Angle: 10.0
#### Speed: 255.0
#### Type: S
#### Most Accurate: True
#### Level of Data: 0
#### [Link](https://kauai.ccmc.gsfc.nasa.gov/DONKI/view/CMEAnalysis/21007/-1)
#### Note: 
## Activity ID: 2022-07-27T18:48:00-CME-001
### Catalog: M2M_CATALOG
### Start Time: 2022-07-27T18:48Z
### Source Location: S30W05
### Active Region Number: None
### [Link](https://kauai.ccmc.gsfc.nasa.gov/DONKI/view/CME/21010/-1)
### Note: This CME is seen to the SW in SOHO LASCO C2/C3 and STEREO A COR2 coronagraphs. The likely source is a longitudinally-stretched filament eruption centered around S30W05 starting at 2022-07027T16:30Z seen best in AIA 193/304 and STEREO A EUVI 195 imagery.
### Instruments
#### SOHO: LASCO/C2
#### SOHO: LASCO/C3
#### STEREO A: SECCHI/COR2
### Analysis
#### Time: 2022-07-27T23:38Z
#### Latitude: -15.0
#### Longitude: 27.0
#### Half Angle: 17.0
#### Speed: 684.0
#### Type: C
#### Most Accurate: True
#### Level of Data: 0
#### [Link](https://kauai.ccmc.gsfc.nasa.gov/DONKI/view/CMEAnalysis/21011/-1)
#### Note: The shock front portion used to track this CME between primarily SOHO LASCO C2 and STEREO A COR2 becomes diffuse in later SOHO LASCO C3 frames. Speed measurements range from 547 to 684 km/s.
## Activity ID: 2022-07-27T19:24:00-CME-001
### Catalog: M2M_CATALOG
### Start Time: 2022-07-27T19:24Z
### Source Location: 
### Active Region Number: None
### [Link](https://kauai.ccmc.gsfc.nasa.gov/DONKI/view/CME/21014/-1)
### Note: This CME is visible to the NW in SOHO LASCO C2/C3 and is very faint but can also be viewed to NW when looking at STEREO A COR2 difference imagery. The source is likely back-sided as there are no clear source signatures on the Earth-facing disk.
### Instruments
#### SOHO: LASCO/C2
#### SOHO: LASCO/C3
#### STEREO A: SECCHI/COR2
### Analysis
#### Time: 2022-07-28T05:18Z
#### Latitude: 24.0
#### Longitude: 138.0
#### Half Angle: 31.0
#### Speed: 316.0
#### Type: S
#### Most Accurate: True
#### Level of Data: 0
#### [Link](https://kauai.ccmc.gsfc.nasa.gov/DONKI/view/CMEAnalysis/21015/-1)
#### Note: The upper, outermost feature of this CME was tracked between SOHO LASCO C2 and STEREO A COR2 coronagraphs. However, this same feature was obscured by the pylon in SOHO LASCO C3 hence why it was omitted from the measurement. Since the source is likely far-sided, the longitude may vary +/- 10 degrees.
## Activity ID: 2022-07-28T14:36:00-CME-001
### Catalog: M2M_CATALOG
### Start Time: 2022-07-28T14:36Z
### Source Location: 
### Active Region Number: None
### [Link](https://kauai.ccmc.gsfc.nasa.gov/DONKI/view/CME/21016/-1)
### Note: Narrow, bright CME visible in the west of SOHO LASCO C2/C3 and STEREO A COR2. Source is opening field lines seen in the northwest of SDO AIA 171/193 starting around 2022-07-28T13:52Z.
### Instruments
#### SOHO: LASCO/C2
#### SOHO: LASCO/C3
#### STEREO A: SECCHI/COR2
### Analysis
#### Time: 2022-07-28T21:02Z
#### Latitude: 8.0
#### Longitude: 91.0
#### Half Angle: 10.0
#### Speed: 562.0
#### Type: C
#### Most Accurate: True
#### Level of Data: 0
#### [Link](https://kauai.ccmc.gsfc.nasa.gov/DONKI/view/CMEAnalysis/21017/-1)
#### Note: 
## Activity ID: 2022-07-28T19:53:00-CME-001
### Catalog: M2M_CATALOG
### Start Time: 2022-07-28T19:53Z
### Source Location: 
### Active Region Number: None
### [Link](https://kauai.ccmc.gsfc.nasa.gov/DONKI/view/CME/21022/-1)
### Note: Visible in the SSE in STEREO A COR2 and SOHO LASCO C2.  No clear source location, only faintly visible in STEREO A COR2 direct imagery and not visible at all in STEREO A COR2 difference imagery.
### Instruments
#### STEREO A: SECCHI/COR2
#### SOHO: LASCO/C2
### Analysis
#### Time: 2022-07-29T02:12Z
#### Latitude: -71.0
#### Longitude: None
#### Half Angle: 10.0
#### Speed: 588.0
#### Type: C
#### Most Accurate: True
#### Level of Data: 0
#### [Link](https://kauai.ccmc.gsfc.nasa.gov/DONKI/view/CMEAnalysis/21023/-1)
#### Note: Very narrow (perhaps only 8-9 degrees half-width); POS measurement (lon -90) due to lack of definitive source location and second coronagraph imagery.
## Activity ID: 2022-07-29T00:36:00-CME-001
### Catalog: M2M_CATALOG
### Start Time: 2022-07-29T00:36Z
### Source Location: S45W30
### Active Region Number: None
### [Link](https://kauai.ccmc.gsfc.nasa.gov/DONKI/view/CME/21020/-1)
### Note: Visible in the SW in SOHO LASCO C2/C3 and in STEREO A COR2.  May be associated with an eruption near S45W30, visible in SDO AIA 171/193/304 beginning 2022-07-28T21:30Z.  Coronal signature occurs during STEREO A data gap.
### Instruments
#### SOHO: LASCO/C2
#### SOHO: LASCO/C3
#### STEREO A: SECCHI/COR2
### Analysis
#### Time: 2022-07-29T06:02Z
#### Latitude: -21.0
#### Longitude: 39.0
#### Half Angle: 20.0
#### Speed: 630.0
#### Type: C
#### Most Accurate: True
#### Level of Data: 0
#### [Link](https://kauai.ccmc.gsfc.nasa.gov/DONKI/view/CMEAnalysis/21021/-1)
#### Note: 
## Activity ID: 2022-07-29T07:12:00-CME-001
### Catalog: M2M_CATALOG
### Start Time: 2022-07-29T07:12Z
### Source Location: 
### Active Region Number: None
### [Link](https://kauai.ccmc.gsfc.nasa.gov/DONKI/view/CME/21024/-1)
### Note: Very narrow (perhaps jetlike) CME visible in SE in SOHO LASCO C2 and STEREO A COR2 (difference imagery only).  May be associated with narrow filament eruption over E limb, visible in SDO AIA 171/304 beginning 2022-07-29T06:15Z.  Field line opening visible over E limb in STEREO A EUVI 195 (near lat S15) beginning 2022-07-29T06:25Z.
### Instruments
#### SOHO: LASCO/C2
#### STEREO A: SECCHI/COR2
### Analysis
#### Time: 2022-07-29T18:46Z
#### Latitude: -22.0
#### Longitude: -110.0
#### Half Angle: 10.0
#### Speed: 324.0
#### Type: S
#### Most Accurate: True
#### Level of Data: 0
#### [Link](https://kauai.ccmc.gsfc.nasa.gov/DONKI/view/CMEAnalysis/21025/-1)
#### Note: 
## Activity ID: 2022-07-29T13:08:00-CME-001
### Catalog: M2M_CATALOG
### Start Time: 2022-07-29T13:08Z
### Source Location: N15W110
### Active Region Number: 13060
### [Link](https://kauai.ccmc.gsfc.nasa.gov/DONKI/view/CME/21030/-1)
### Note: Clearly visible in the W in SOHO LASCO C2/C3 and in STEREO A COR2.  Associated with an eruption over W limb, visible in SDO AIA 171/193/304 beginning 2022-07-29T12:03Z.
### Instruments
#### SOHO: LASCO/C2
#### SOHO: LASCO/C3
#### STEREO A: SECCHI/COR2
### Analysis
#### Time: 2022-07-29T17:29Z
#### Latitude: 9.0
#### Longitude: 109.0
#### Half Angle: 20.0
#### Speed: 769.0
#### Type: C
#### Most Accurate: True
#### Level of Data: 0
#### [Link](https://kauai.ccmc.gsfc.nasa.gov/DONKI/view/CMEAnalysis/21031/-1)
#### Note: 
## Activity ID: 2022-07-29T15:12:00-CME-001
### Catalog: M2M_CATALOG
### Start Time: 2022-07-29T15:12Z
### Source Location: S30E75
### Active Region Number: None
### [Link](https://kauai.ccmc.gsfc.nasa.gov/DONKI/view/CME/21034/-1)
### Note: Narrow (perhaps jetlike) CME visible in the SE in SOHO LASCO C2/C3; visible in SE in STEREO A COR2 difference imagery but not in direct imagery.  May be associated with a jet eruption near S30E75, visible in SDO AIA 304 beginning 2022-07-29T12:18Z.
### Instruments
#### SOHO: LASCO/C2
#### SOHO: LASCO/C3
#### STEREO A: SECCHI/COR2
### Analysis
#### Time: 2022-07-29T20:25Z
#### Latitude: -26.0
#### Longitude: -63.0
#### Half Angle: 10.0
#### Speed: 629.0
#### Type: C
#### Most Accurate: True
#### Level of Data: 0
#### [Link](https://kauai.ccmc.gsfc.nasa.gov/DONKI/view/CMEAnalysis/21035/-1)
#### Note: Very narrow, perhaps 5-6 degrees half-width.
## Activity ID: 2022-07-30T02:53:00-CME-001
### Catalog: M2M_CATALOG
### Start Time: 2022-07-30T02:53Z
### Source Location: 
### Active Region Number: None
### [Link](https://kauai.ccmc.gsfc.nasa.gov/DONKI/view/CME/21037/-1)
### Note: This CME is visible as a partial halo in STEREO A COR2 and SOHO LASCO C2/C3 moving primarily southeast. The source is likely far-sided as there are no clear source signatures on the Earth or STEREO A facing disk. However, there is an eruption or possible post eruptive signature visible in STEREO A EUVI 304 imagery at 2022-07-30T-2:15Z beyond the eastern limb. There is also a data gap in STEREO A EUVI 195 imagery from 2022-07-29T21:05Z to 2022-07-30T02:55Z but when imagery appears it is clear there was an opening of field lines/ noticeable change in field line structure visible to the E/SE which is the direction this CME is headed. It is possible the main eruption occurred during this data gap and only the post eruptive signatures are detectable.
### Instruments
#### STEREO A: SECCHI/COR2
#### SOHO: LASCO/C2
#### SOHO: LASCO/C3
### Analysis
#### Time: 2022-07-30T09:36Z
#### Latitude: -26.0
#### Longitude: -172.0
#### Half Angle: 59.0
#### Speed: 552.0
#### Type: C
#### Most Accurate: True
#### Level of Data: 0
#### [Link](https://kauai.ccmc.gsfc.nasa.gov/DONKI/view/CMEAnalysis/21038/-1)
#### Note: This measurement uses a large half-width to encompass the entirety of the bulk portion of the CME. However, smaller half-widths were also measured resulting in speeds ranging from 552 to 857 km/s. The longitude may vary +/-10 degrees since the source is far-sided.
## Activity ID: 2022-07-30T05:53:00-CME-001
### Catalog: M2M_CATALOG
### Start Time: 2022-07-30T05:53Z
### Source Location: 
### Active Region Number: None
### [Link](https://kauai.ccmc.gsfc.nasa.gov/DONKI/view/CME/21039/-1)
### Note: This CME is visible to the east in STEREO A COR2 and SOHO LASCO C2/C3 coronagraphs. The source is likely the eruption and opening of field lines visible just on or slightly beyond the NE limb in STEREO A EUVI 195 imagery at 2022-07-30T03:45Z. This eruption is also visible in SDO AIA 131,171,193, 304 beyond the NE limb at the same time.
### Instruments
#### STEREO A: SECCHI/COR2
#### SOHO: LASCO/C2
#### SOHO: LASCO/C3
### Analysis
#### Time: 2022-07-30T10:26Z
#### Latitude: -1.0
#### Longitude: -151.0
#### Half Angle: 18.0
#### Speed: 711.0
#### Type: C
#### Most Accurate: True
#### Level of Data: 0
#### [Link](https://kauai.ccmc.gsfc.nasa.gov/DONKI/view/CMEAnalysis/21040/-1)
#### Note: This measurement follows the brightest leading edge portion of the CME. Speed measurements ranged from 625 to 730 km/s.
## Activity ID: 2022-07-30T09:36:00-CME-001
### Catalog: M2M_CATALOG
### Start Time: 2022-07-30T09:36Z
### Source Location: 
### Active Region Number: None
### [Link](https://kauai.ccmc.gsfc.nasa.gov/DONKI/view/CME/21042/-1)
### Note: The CME is visible to the west in SOHO LASCO C2/C3 and STEREO A COR2, but is very faint when viewing in white light imagery. The source is likely far-sided due to the absence of a clear source signature on the Earth-facing disk. However, there is some faint field line movement seen beyond the western limb in SDO AIA 171 at 2022-07-30T08:40Z but the actual eruption may be obscured by a large bright region just beyond the limb.
### Instruments
#### SOHO: LASCO/C2
#### SOHO: LASCO/C3
#### STEREO A: SECCHI/COR2
### Analysis
#### Time: 2022-07-30T16:36Z
#### Latitude: 6.0
#### Longitude: 99.0
#### Half Angle: 10.0
#### Speed: 498.0
#### Type: S
#### Most Accurate: True
#### Level of Data: 0
#### [Link](https://kauai.ccmc.gsfc.nasa.gov/DONKI/view/CMEAnalysis/21043/-1)
#### Note: This CME has a long shock front region which becomes faint/diffuse in later imagery, especially in STEREO A COR2. Due to this only a few frames of STEREO A COR2 were usable in this measurement.
## Activity ID: 2022-07-30T12:38:00-CME-001
### Catalog: M2M_CATALOG
### Start Time: 2022-07-30T12:38Z
### Source Location: 
### Active Region Number: None
### [Link](https://kauai.ccmc.gsfc.nasa.gov/DONKI/view/CME/21044/-1)
### Note: This CME is seen to the E/NE in STEREO A COR2 and SOHO LASCO C2/C3 imagery. A possible source is the faint brightening/potential eruption and subsequent opening of field lines seen off the eastern limb in STEREO A EUVI 195 around 2022-07-30T11:45Z.
### Instruments
#### STEREO A: SECCHI/COR2
### Analysis
#### Time: 2022-07-30T18:45Z
#### Latitude: 6.0
#### Longitude: -151.0
#### Half Angle: 17.0
#### Speed: 518.0
#### Type: C
#### Most Accurate: True
#### Level of Data: 0
#### [Link](https://kauai.ccmc.gsfc.nasa.gov/DONKI/view/CMEAnalysis/21048/-1)
#### Note: This measurement includes backfilled data from SOHO LASCO C2/C3. Since the CME front becomes so diffuse in later imagery primarily earlier time stamps were used in this measurement.
#### Time: 2022-07-30T20:04Z
#### Latitude: 7.0
#### Longitude: None
#### Half Angle: 18.0
#### Speed: 455.0
#### Type: S
#### Most Accurate: False
#### Level of Data: 0
#### [Link](https://kauai.ccmc.gsfc.nasa.gov/DONKI/view/CMEAnalysis/21045/-1)
#### Note: This is a plane of sky measurement using COR2A difference imagery in SWPC_CAT. The source location is seen on or slightly beyond the eastern limb in STEREO A COR2 imagery, so the true longitude may be more eastern than this plane-of-sky longitude.
## Activity ID: 2022-07-30T23:12:00-CME-001
### Catalog: M2M_CATALOG
### Start Time: 2022-07-30T23:12Z
### Source Location: 
### Active Region Number: None
### [Link](https://kauai.ccmc.gsfc.nasa.gov/DONKI/view/CME/21054/-1)
### Note: This CME is seen to the NW in SOHO LASCO C2/C3 and STEREO A COR2 coronagraph imagery. A possible source may be connected to field line movement seen beyond the NW limb in SDO AIA 171 and 193 around 2022-07-30T22:20Z. There is a data gap until 2022-07-31T02:05Z in STEREO A during the time of the source eruption, but this is likely a far-sided event.
### Instruments
#### SOHO: LASCO/C2
#### SOHO: LASCO/C3
#### STEREO A: SECCHI/COR2
### Analysis
#### Time: 2022-07-31T08:06Z
#### Latitude: 39.0
#### Longitude: 99.0
#### Half Angle: 40.0
#### Speed: 356.0
#### Type: S
#### Most Accurate: True
#### Level of Data: 0
#### [Link](https://kauai.ccmc.gsfc.nasa.gov/DONKI/view/CMEAnalysis/21055/-1)
#### Note: Due to a data gap in STEREO A COR2 there is only later imagery available for this CME, making it difficult to find a fit between the later COR2 and SOHO LASCO C3 frames where the CME becomes faint. The CME shape is also irregular but this measurement includes most of the bulk portion.
## Activity ID: 2022-07-31T01:25:00-CME-001
### Catalog: M2M_CATALOG
### Start Time: 2022-07-31T01:25Z
### Source Location: 
### Active Region Number: None
### [Link](https://kauai.ccmc.gsfc.nasa.gov/DONKI/view/CME/21052/-1)
### Note: This CME is visible to the west in SOHO LASCO C2/C3 and STEREO A COR2 coronagraphs. The source is likely a far-sided eruption which appears over the NW limb in SDO AIA 304 around 2022-07-31T01:15Z. Opening of field lines observed in this same NW region in SDO AIA 171 at 00:48Z. Although there is a data gap in STEREO A during this eruption, when imagery reappears at 02:05Z a reconfiguration/ opening of field lines appears in the same NW region.
### Instruments
#### SOHO: LASCO/C2
#### SOHO: LASCO/C3
#### STEREO A: SECCHI/COR2
### Analysis
#### Time: 2022-07-31T04:58Z
#### Latitude: -2.0
#### Longitude: 122.0
#### Half Angle: 11.0
#### Speed: 832.0
#### Type: C
#### Most Accurate: True
#### Level of Data: 0
#### [Link](https://kauai.ccmc.gsfc.nasa.gov/DONKI/view/CMEAnalysis/21053/-1)
#### Note: The CME leading edge becomes diffuse in later STEREO A COR2 imagery, so the shock front portion may speed up faster than the leading edge which was used in this measurement.
## Activity ID: 2022-07-31T02:00:00-CME-001
### Catalog: M2M_CATALOG
### Start Time: 2022-07-31T02:00Z
### Source Location: 
### Active Region Number: None
### [Link](https://kauai.ccmc.gsfc.nasa.gov/DONKI/view/CME/21059/-1)
### Note: This CME is visible to the south in SOHO LASCO C2/C3 and STEREO A COR2 coronagraph imagery. The source is likely far-sided as there are no clear source signatures on the Earth-facing disk.
### Instruments
#### SOHO: LASCO/C2
#### SOHO: LASCO/C3
#### STEREO A: SECCHI/COR2
### Analysis
#### Time: 2022-07-31T15:16Z
#### Latitude: -60.0
#### Longitude: -163.0
#### Half Angle: 20.0
#### Speed: 258.0
#### Type: S
#### Most Accurate: True
#### Level of Data: 0
#### [Link](https://kauai.ccmc.gsfc.nasa.gov/DONKI/view/CMEAnalysis/21060/-1)
#### Note: This measurement tracks the shock front portion of the CME, which becomes diffuse in later imagery. Primarily earlier time stamps were used in this CME as the shock front feature disappears before exiting STEREO A COR2.
## Activity ID: 2022-07-31T06:48:00-CME-001
### Catalog: M2M_CATALOG
### Start Time: 2022-07-31T06:48Z
### Source Location: 
### Active Region Number: None
### [Link](https://kauai.ccmc.gsfc.nasa.gov/DONKI/view/CME/21056/-1)
### Note: This CME is very faint in white light imagery but is visible to the NW in SOHO LASCO C2/C3 and STEREO A COR2 coronagraph imagery. The source is likely far-sided but there is a faint opening of field lines seen beyond the NW limb in STEREO A EUVI 195 around 2022-07-31T05:45Z which may be connected to this event.
### Instruments
#### SOHO: LASCO/C2
#### SOHO: LASCO/C3
#### STEREO A: SECCHI/COR2
### Analysis
#### Time: 2022-07-31T16:31Z
#### Latitude: 59.0
#### Longitude: 114.0
#### Half Angle: 45.0
#### Speed: 367.0
#### Type: S
#### Most Accurate: True
#### Level of Data: 0
#### [Link](https://kauai.ccmc.gsfc.nasa.gov/DONKI/view/CMEAnalysis/21057/-1)
#### Note: This measurement follows the outermost shock front feature, but the CME is very faint even in difference imagery. The feature tracked in this measurement disappears before exiting STEREO A COR2 so primarily earlier time stamps were used.
## Activity ID: 2022-07-31T19:48:00-CME-001
### Catalog: M2M_CATALOG
### Start Time: 2022-07-31T19:48Z
### Source Location: 
### Active Region Number: None
### [Link](https://kauai.ccmc.gsfc.nasa.gov/DONKI/view/CME/21073/-1)
### Note: This CME is faint in white light imagery but is visible to the southeast in SOHO LASCO C2/C3 and STEREO A COR2 coronagraph imagery. The source is likely an eruption first seen from behind the SE limb at 2022-07-31T18:50Z in SDO AIA 304. An opening of field lines is seen in this same SE region in STA EUVI 195 at 19:15Z.
### Instruments
#### SOHO: LASCO/C2
#### SOHO: LASCO/C3
#### STEREO A: SECCHI/COR2
### Analysis
#### Time: 2022-08-01T02:33Z
#### Latitude: -38.0
#### Longitude: -124.0
#### Half Angle: 14.0
#### Speed: 531.0
#### Type: C
#### Most Accurate: True
#### Level of Data: 0
#### [Link](https://kauai.ccmc.gsfc.nasa.gov/DONKI/view/CMEAnalysis/21074/-1)
#### Note: There is a data gap in STEREO A COR2 from 2022-07-31T20:53 to 2022-08-01T01:53Z so primarily earlier time stamps were used in this measurement. However, around this time is when the leading edge becomes too diffuse to track.
## Activity ID: 2022-07-31T23:12:00-CME-001
### Catalog: M2M_CATALOG
### Start Time: 2022-07-31T23:12Z
### Source Location: N15E95
### Active Region Number: None
### [Link](https://kauai.ccmc.gsfc.nasa.gov/DONKI/view/CME/21067/-1)
### Note: This CME is visible to the E/NE in SOHO LASCO C2/C3 and STEREO A COR2 coronagraphs. The source is a  filament lift-off just beyond the NE limb (near N15E95) seen in SDO AIA 304 at 2022-07-31T22:40Z. An opening of field lines is visible in this same region around 23:00Z in SDO AIA 171 and 193. There is a data gap in STEREO A during the eruption but once imagery reappears around 2022-08-01T01:25Z there is a clear reconfiguration/ opening of field lines off the NE limb. Finally, this CME is associated with a C9.3 flare originating from just beyond the NW limb.
### Instruments
#### SOHO: LASCO/C2
#### SOHO: LASCO/C3
#### STEREO A: SECCHI/COR2
### Analysis
#### Time: 2022-08-01T02:20Z
#### Latitude: 16.0
#### Longitude: -95.0
#### Half Angle: 29.0
#### Speed: 1038.0
#### Type: O
#### Most Accurate: True
#### Level of Data: 0
#### [Link](https://kauai.ccmc.gsfc.nasa.gov/DONKI/view/CMEAnalysis/21068/-1)
#### Note: This measurement is based on the approximate source location so the longitude may vary +/-10 degrees. The CME also exhibits a deceleration in later frames, hence why speed measurements range from 882 to 1251 km/s depending on if later or earlier frames are used.
## Activity ID: 2022-08-01T01:48:00-CME-001
### Catalog: M2M_CATALOG
### Start Time: 2022-08-01T01:48Z
### Source Location: 
### Active Region Number: None
### [Link](https://kauai.ccmc.gsfc.nasa.gov/DONKI/view/CME/21065/-1)
### Note: This CME is visible to the W/NE in SOHO LASCO C2/C3 and STEREO A COR2 coronagraph imagery. A possible source is the small eruption visible beyond the NW limb starting around 2022-07-31T23:04Z in SDO AIA 304 imagery.
### Instruments
#### SOHO: LASCO/C2
#### SOHO: LASCO/C3
#### STEREO A: SECCHI/COR2
### Analysis
#### Time: 2022-08-01T10:39Z
#### Latitude: 9.0
#### Longitude: 107.0
#### Half Angle: 18.0
#### Speed: 393.0
#### Type: S
#### Most Accurate: True
#### Level of Data: 0
#### [Link](https://kauai.ccmc.gsfc.nasa.gov/DONKI/view/CMEAnalysis/21066/-1)
#### Note: This measurement tracks the leading edge which appears to accelerate as the CME moves outwards, especially compared to earlier frames.
## Activity ID: 2022-08-01T03:24:00-CME-001
### Catalog: M2M_CATALOG
### Start Time: 2022-08-01T03:24Z
### Source Location: 
### Active Region Number: None
### [Link](https://kauai.ccmc.gsfc.nasa.gov/DONKI/view/CME/21063/-1)
### Note: This CME is visible to the west in SOHO LASCO C2/C3 and STEREO A COR2 coronagraph imagery. A possible source is the small eruption seen just beyond the NW limb at 2022-08-01T02:00Z in SDO AIA 304 imagery. This CME follows in the path of CME: 2022-08-01T01:48Z.
### Instruments
#### SOHO: LASCO/C2
#### SOHO: LASCO/C3
#### STEREO A: SECCHI/COR2
### Analysis
#### Time: 2022-08-01T09:22Z
#### Latitude: 4.0
#### Longitude: 121.0
#### Half Angle: 14.0
#### Speed: 545.0
#### Type: C
#### Most Accurate: True
#### Level of Data: 0
#### [Link](https://kauai.ccmc.gsfc.nasa.gov/DONKI/view/CMEAnalysis/21064/-1)
#### Note: The leading edge was difficult to track between frames in SOHO LASCO C3 because certain features were more or less obscured by a preceding CME (CME: 2022-08-01T01:48Z).
## Activity ID: 2022-08-01T06:12:00-CME-001
### Catalog: M2M_CATALOG
### Start Time: 2022-08-01T06:12Z
### Source Location: 
### Active Region Number: None
### [Link](https://kauai.ccmc.gsfc.nasa.gov/DONKI/view/CME/21070/-1)
### Note: This CME is visible to the east in SOHO LASCO C2/C3 coronagraph imagery but is not visible in STEREO A COR2 due to a data gap. A possible source is the eruption beyond the eastern limb first seen in SDO AIA 131 and 304 around 2022-08-01T05:45Z. An opening of field lines is visible at this time off the east limb in STEREO A EUVI 195 as well.
### Instruments
#### SOHO: LASCO/C2
#### SOHO: LASCO/C3
### Analysis
#### Time: 2022-08-01T10:51Z
#### Latitude: 5.0
#### Longitude: None
#### Half Angle: 18.0
#### Speed: 749.0
#### Type: C
#### Most Accurate: True
#### Level of Data: 0
#### [Link](https://kauai.ccmc.gsfc.nasa.gov/DONKI/view/CMEAnalysis/21071/-1)
#### Note: This is a plane of sky measurement using SOHO LASCO C2/C3 difference imagery in SWPC_CAT. The likely source location is slightly beyond the eastern limb as seen in SDO AIA 304 imagery so the true longitude is likely more eastern.
## Activity ID: 2022-08-01T14:00:00-CME-001
### Catalog: M2M_CATALOG
### Start Time: 2022-08-01T14:00Z
### Source Location: 
### Active Region Number: None
### [Link](https://kauai.ccmc.gsfc.nasa.gov/DONKI/view/CME/21077/-1)
### Note: This CME is faint but visible to the west in SOHO LASCO C2/C3. It is either obscured or too faint to be seen in STEREO A COR2 imagery. A possible source is the small eruption seen beyond the western limb in SDO AIA 304 around 2022-08-01T12:20Z.
### Instruments
#### SOHO: LASCO/C2
#### SOHO: LASCO/C3
### Analysis
#### Time: 2022-08-02T02:22Z
#### Latitude: 9.0
#### Longitude: None
#### Half Angle: 12.0
#### Speed: 293.0
#### Type: S
#### Most Accurate: True
#### Level of Data: 0
#### [Link](https://kauai.ccmc.gsfc.nasa.gov/DONKI/view/CMEAnalysis/21078/-1)
#### Note: This is a plane of sky measurement using SOHO LASCO C2/C3 in SWPC_CAT. The source is believed to originate just beyond the western limb, so the longitude is likely greater than 90.
## Activity ID: 2022-08-02T06:36:00-CME-001
### Catalog: M2M_CATALOG
### Start Time: 2022-08-02T06:36Z
### Source Location: 
### Active Region Number: None
### [Link](https://kauai.ccmc.gsfc.nasa.gov/DONKI/view/CME/21079/-1)
### Note: Visible in the NW of SOHO LASCO C2/C3. The CME is not visible in STEREO A COR2 due to a data gap from 2022-08-01T20:53Z to 2022-08-02T10:53Z. The source is unclear, but may be faint field line movement seen beyond the southwest limb in SDO AIA 171/193.
### Instruments
#### SOHO: LASCO/C2
#### SOHO: LASCO/C3
### Analysis
#### Time: 2022-08-02T13:28Z
#### Latitude: 24.0
#### Longitude: None
#### Half Angle: 17.0
#### Speed: 579.0
#### Type: C
#### Most Accurate: True
#### Level of Data: 0
#### [Link](https://kauai.ccmc.gsfc.nasa.gov/DONKI/view/CMEAnalysis/21080/-1)
#### Note: Plane of sky measurement using SOHO LASCO C2/C3 difference imagery in SWPC_CAT.
## Activity ID: 2022-08-02T06:48:00-CME-001
### Catalog: M2M_CATALOG
### Start Time: 2022-08-02T06:48Z
### Source Location: N15E80
### Active Region Number: None
### [Link](https://kauai.ccmc.gsfc.nasa.gov/DONKI/view/CME/21081/-1)
### Note: Visible in the East of SOHO LASCO C2/C3. The CME is not visible in STEREO A COR2 due to a data gap from 2022-08-01T20:53Z to 2022-08-02T10:53Z. The source is an eruption starting around 2022-08-02T06:00Z and centered around N15E80. Most of the eruption can be clearly seen in SDO AIA 304 before a data gap from 06:45Z-07:55Z. Brightening is visible on the disk in SDO AIA 193 and opening field lines are visible in SDO AIA 171.
### Instruments
#### SOHO: LASCO/C2
#### SOHO: LASCO/C3
### Analysis
#### Time: 2022-08-02T10:10Z
#### Latitude: 12.0
#### Longitude: -80.0
#### Half Angle: 14.0
#### Speed: 1024.0
#### Type: O
#### Most Accurate: True
#### Level of Data: 0
#### [Link](https://kauai.ccmc.gsfc.nasa.gov/DONKI/view/CMEAnalysis/21083/-1)
#### Note: SWPC_CAT measurement with longitude approximated from the source location.
#### Time: 2022-08-02T09:45Z
#### Latitude: 11.0
#### Longitude: None
#### Half Angle: 12.0
#### Speed: 1211.0
#### Type: O
#### Most Accurate: False
#### Level of Data: 0
#### [Link](https://kauai.ccmc.gsfc.nasa.gov/DONKI/view/CMEAnalysis/21082/-1)
#### Note: Plane of sky measurement using SOHO LASCO C2/C3 difference imagery in SWPC_CAT. Plane of sky measurement technique used due to lack of STEREO A COR2 imagery.
## Activity ID: 2022-08-02T12:48:00-CME-001
### Catalog: M2M_CATALOG
### Start Time: 2022-08-02T12:48Z
### Source Location: 
### Active Region Number: None
### [Link](https://kauai.ccmc.gsfc.nasa.gov/DONKI/view/CME/21085/-1)
### Note: Visible in the west of SOHO LASCO C2/C3 and faintly visible along the streamer in STEREO A COR2. The source is not identified and may be beyond the west limb of the Earth-facing disk.
### Instruments
#### SOHO: LASCO/C2
#### SOHO: LASCO/C3
#### STEREO A: SECCHI/COR2
### Analysis
#### Time: 2022-08-03T02:06Z
#### Latitude: 23.0
#### Longitude: 112.0
#### Half Angle: 29.0
#### Speed: 263.0
#### Type: S
#### Most Accurate: True
#### Level of Data: 0
#### [Link](https://kauai.ccmc.gsfc.nasa.gov/DONKI/view/CMEAnalysis/21086/-1)
#### Note: Longitude based off best fit in SOHO LASCO C2 and STEREO A COR2.