var root;(()=>{var __webpack_modules__={978:module=>{eval("class BraidClient {\n  constructor (...endpoint) {\n    if (endpoint === '.') {\n      endpoint = window.location\n    }\n    this.endpoint = endpoint\n    this.initialReconnectDelay = 1000\n    this.currentReconnectDelay = this.initialReconnectDelay\n    this.maxReconnectDelay = 16000\n\n    this.subscribe = this.subscribe.bind(this)\n    this.publish = this.publish.bind(this)\n  }\n\n  currentState () {\n    return fetch(this.endpoint, {\n      credentials: 'same-origin',\n      headers: {\n        accept: 'application/json'\n      }\n    })\n      .then(response => response.json())\n      .then(data => {\n        return data\n      })\n  }\n\n  subscribe (handler) {\n    const reconnect = () => {\n      console.log(`Reconnecting to braid at: ${this.endpoint}`)\n      setTimeout(() => {\n        if (this.currentReconnectDelay < this.maxReconnectDelay) {\n          this.currentReconnectDelay *= 2\n        }\n        this.subscribe(handler)\n      }, this.currentReconnectDelay + Math.floor(Math.random() * 3000))\n    }\n\n    fetch(this.endpoint, {\n      headers: {\n        credentials: 'same-origin',\n        subscribe: 'keep-alive'\n      }\n    }).then(response => {\n      const reader = response.body.getReader()\n      const decoder = new TextDecoder('utf-8')\n      let buffer = ''\n      reader.read().then(function processText ({ done, value }) {\n        if (done) {\n          console.log('BRAID: end of stream')\n          return\n        }\n        buffer += decoder.decode(value)\n        const headers = {}\n        const patchParts = buffer.split('\\n\\n')\n        patchParts[0].split('\\n').forEach(header => {\n          const headerName = header.slice(0, header.indexOf(':')).toLowerCase()\n          const headerValue = header.slice(header.indexOf(':') + 1)\n          headers[headerName] = headerValue\n        })\n        if (Number(headers['content-length']) === patchParts[1].length) {\n          buffer = ''\n          const range = headers['content-range'].split('=')[1]\n          const body = JSON.parse(patchParts[1])\n          console.log('BRAID: patch received: ', range, body)\n          handler(range, body)\n        }\n        return reader.read().then(processText)\n      }).catch(err => {\n        console.error('BRAID:', err)\n        reconnect()\n      })\n    }).catch(err => {\n      console.error('BRAID:', err)\n      reconnect()\n    })\n  }\n\n  publish (range, body) {\n    const patch = JSON.stringify(body)\n    fetch(this.endpoint, {\n      method: 'PUT',\n      headers: {\n        credentials: 'same-origin',\n        patches: 1\n      },\n      body: `Content-Length: ${patch.length}\nContent-Range: json=${range}\n\n${patch}`\n    }).then(() => {\n      console.log('BRAID: patch sent: ', range, body)\n    })\n  }\n}\n\nmodule.exports = BraidClient\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///978\n")},10:(module,__unused_webpack_exports,__webpack_require__)=>{eval("const BraidClient = __webpack_require__(978)\nconst jsonpatch = __webpack_require__(224)\nconst jsonpointer = __webpack_require__(573)\n\n// TODO use custom handlers instead of auto-creating\n// TODO remove callback in place of walking the JSON and calling each handler\n// TODO make a class, prepare for sync9 and provide `.data`\n\nconst root = async (braidURL, elementMap, callback) => {\n  const braid = new BraidClient(braidURL)\n\n  let data = await braid.currentState()\n  // Initialize elements with the current state.\n  Object.keys(elementMap).forEach(function (targetRange) {\n    // const handler = elementMap[targetRange]\n    // const el = document.getElementById(handler[0])\n    // handler[1](el, braid.publish, targetRange)\n    const handler = elementMap[targetRange]\n    const body = jsonpointer(data, targetRange)\n    handler[2](document.getElementById(handler[0]), null, null, body, data)\n  })\n\n  // Subscribe to patches and update elements accordingly.\n  braid.subscribe((range, body) => {\n    const op = range.endsWith('-') ? 'add' : 'replace'\n    data = jsonpatch.apply(data, { op: op, path: range, value: body })\n    Object.keys(elementMap).forEach(function (targetRange) {\n      if (op === 'add') {\n        if (range.slice(0, -2) !== targetRange) {\n          return\n        }\n      } else if (op === 'replace') {\n        if (range !== targetRange) {\n          return\n        }\n      }\n      const handler = elementMap[targetRange]\n      handler[2](document.getElementById(handler[0]), op, range, body, data)\n    })\n    // callback(data)\n  })\n\n  // Assign handlers to publish patches when an element updates.\n  Object.keys(elementMap).forEach(function (targetRange) {\n    const handler = elementMap[targetRange]\n    const el = document.getElementById(handler[0])\n    handler[1](el, braid.publish, targetRange)\n  })\n}\n\nmodule.exports = root\n\n// XXX Object.keys(elementMap).forEach(function (id) {\n// XXX   const el = document.getElementById(id)\n// XXX   switch (el.tagName) {\n// XXX     case 'INPUT':\n// XXX       el.value = jsonpointer(data, elementMap[id])\n// XXX       break\n// XXX   }\n// XXX })\n// XXX callback(data)\n\n// XXX const el = document.getElementById(id)\n// XXX let li\n// XXX switch (el.tagName) {\n// XXX   case 'UL':\n// XXX     li = document.createElement('LI')\n// XXX     li.appendChild(document.createTextNode(body))\n// XXX     el.appendChild(li)\n// XXX     break\n// XXX }\n// XXX switch (el.tagName) {\n// XXX   case 'INPUT':\n// XXX     el.value = jsonpointer(data, range)\n// XXX     break\n// XXX }\n\n// XXX Object.keys(elementMap).forEach(function (id) {\n// XXX   const el = document.getElementById(id)\n// XXX   switch (el.tagName) {\n// XXX     case 'INPUT':\n// XXX       el.addEventListener('input', () => {\n// XXX         braid.publish(elementMap[id], el.value)\n// XXX       })\n// XXX       break\n// XXX   }\n// XXX })\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///10\n")},804:module=>{eval("\nvar hasOwn = Object.prototype.hasOwnProperty;\nvar toString = Object.prototype.toString;\n\nmodule.exports = function forEach (obj, fn, ctx) {\n    if (toString.call(fn) !== '[object Function]') {\n        throw new TypeError('iterator must be a function');\n    }\n    var l = obj.length;\n    if (l === +l) {\n        for (var i = 0; i < l; i++) {\n            fn.call(ctx, obj[i], i, obj);\n        }\n    } else {\n        for (var k in obj) {\n            if (hasOwn.call(obj, k)) {\n                fn.call(ctx, obj[k], k, obj);\n            }\n        }\n    }\n};\n\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly9yb290Ly4vbm9kZV9tb2R1bGVzL2ZvcmVhY2gvaW5kZXguanM/YmZhZCJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiO0FBQ0E7QUFDQTs7QUFFQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSx1QkFBdUIsT0FBTztBQUM5QjtBQUNBO0FBQ0EsS0FBSztBQUNMO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBIiwiZmlsZSI6IjgwNC5qcyIsInNvdXJjZXNDb250ZW50IjpbIlxudmFyIGhhc093biA9IE9iamVjdC5wcm90b3R5cGUuaGFzT3duUHJvcGVydHk7XG52YXIgdG9TdHJpbmcgPSBPYmplY3QucHJvdG90eXBlLnRvU3RyaW5nO1xuXG5tb2R1bGUuZXhwb3J0cyA9IGZ1bmN0aW9uIGZvckVhY2ggKG9iaiwgZm4sIGN0eCkge1xuICAgIGlmICh0b1N0cmluZy5jYWxsKGZuKSAhPT0gJ1tvYmplY3QgRnVuY3Rpb25dJykge1xuICAgICAgICB0aHJvdyBuZXcgVHlwZUVycm9yKCdpdGVyYXRvciBtdXN0IGJlIGEgZnVuY3Rpb24nKTtcbiAgICB9XG4gICAgdmFyIGwgPSBvYmoubGVuZ3RoO1xuICAgIGlmIChsID09PSArbCkge1xuICAgICAgICBmb3IgKHZhciBpID0gMDsgaSA8IGw7IGkrKykge1xuICAgICAgICAgICAgZm4uY2FsbChjdHgsIG9ialtpXSwgaSwgb2JqKTtcbiAgICAgICAgfVxuICAgIH0gZWxzZSB7XG4gICAgICAgIGZvciAodmFyIGsgaW4gb2JqKSB7XG4gICAgICAgICAgICBpZiAoaGFzT3duLmNhbGwob2JqLCBrKSkge1xuICAgICAgICAgICAgICAgIGZuLmNhbGwoY3R4LCBvYmpba10sIGssIG9iaik7XG4gICAgICAgICAgICB9XG4gICAgICAgIH1cbiAgICB9XG59O1xuXG4iXSwic291cmNlUm9vdCI6IiJ9\n//# sourceURL=webpack-internal:///804\n")},224:function(__unused_webpack_module,exports,__webpack_require__){eval("// Generated by CoffeeScript 1.12.7\n(function() {\n  var indexOf = [].indexOf || function(item) { for (var i = 0, l = this.length; i < l; i++) { if (i in this && this[i] === item) return i; } return -1; },\n    extend = function(child, parent) { for (var key in parent) { if (hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },\n    hasProp = {}.hasOwnProperty;\n\n  (function(factory) {\n    var root;\n    root = typeof window !== \"undefined\" && window !== null ? window : typeof __webpack_require__.g !== \"undefined\" && __webpack_require__.g !== null ? __webpack_require__.g : this;\n    if (true) {\n      return factory(exports);\n    } else {}\n  })(function(exports) {\n    var AddPatch, CopyPatch, InvalidPatchError, InvalidPointerError, JSONPatch, JSONPatchError, JSONPointer, MovePatch, PatchConflictError, PatchTestFailed, RemovePatch, ReplacePatch, TestPatch, _isEqual, accessorMatch, apply, compile, escapedSlash, escapedTilde, hasOwnProperty, isArray, isEqual, isObject, isString, operationMap, toString;\n    toString = Object.prototype.toString;\n    hasOwnProperty = Object.prototype.hasOwnProperty;\n    isArray = function(obj) {\n      return toString.call(obj) === '[object Array]';\n    };\n    isObject = function(obj) {\n      return toString.call(obj) === '[object Object]';\n    };\n    isString = function(obj) {\n      return toString.call(obj) === '[object String]';\n    };\n    _isEqual = function(a, b, stack) {\n      var className, key, length, result, size;\n      if (a === b) {\n        return a !== 0 || 1 / a === 1 / b;\n      }\n      if (a === null || b === null) {\n        return a === b;\n      }\n      className = toString.call(a);\n      if (className !== toString.call(b)) {\n        return false;\n      }\n      switch (className) {\n        case '[object String]':\n          String(a) === String(b);\n          break;\n        case '[object Number]':\n          a = +a;\n          b = +b;\n          if (a !== a) {\n            b !== b;\n          } else {\n            if (a === 0) {\n              1 / a === 1 / b;\n            } else {\n              a === b;\n            }\n          }\n          break;\n        case '[object Boolean]':\n          +a === +b;\n      }\n      if (typeof a !== 'object' || typeof b !== 'object') {\n        return false;\n      }\n      length = stack.length;\n      while (length--) {\n        if (stack[length] === a) {\n          return true;\n        }\n      }\n      stack.push(a);\n      size = 0;\n      result = true;\n      if (className === '[object Array]') {\n        size = a.length;\n        result = size === b.length;\n        if (result) {\n          while (size--) {\n            if (!(result = indexOf.call(a, size) >= 0 === indexOf.call(b, size) >= 0 && _isEqual(a[size], b[size], stack))) {\n              break;\n            }\n          }\n        }\n      } else {\n        if (indexOf.call(a, \"constructor\") >= 0 !== indexOf.call(b, \"constructor\") >= 0 || a.constructor !== b.constructor) {\n          return false;\n        }\n        for (key in a) {\n          if (hasOwnProperty.call(a, key)) {\n            size++;\n            if (!(result = hasOwnProperty.call(b, key) && _isEqual(a[key], b[key], stack))) {\n              break;\n            }\n          }\n        }\n        if (result) {\n          for (key in b) {\n            if (hasOwnProperty.call(b, key) && !size--) {\n              break;\n            }\n          }\n          result = !size;\n        }\n      }\n      stack.pop();\n      return result;\n    };\n    isEqual = function(a, b) {\n      return _isEqual(a, b, []);\n    };\n    JSONPatchError = (function(superClass) {\n      extend(JSONPatchError, superClass);\n\n      function JSONPatchError(message) {\n        this.message = message != null ? message : 'JSON patch error';\n        this.name = 'JSONPatchError';\n      }\n\n      return JSONPatchError;\n\n    })(Error);\n    InvalidPointerError = (function(superClass) {\n      extend(InvalidPointerError, superClass);\n\n      function InvalidPointerError(message) {\n        this.message = message != null ? message : 'Invalid pointer';\n        this.name = 'InvalidPointer';\n      }\n\n      return InvalidPointerError;\n\n    })(Error);\n    InvalidPatchError = (function(superClass) {\n      extend(InvalidPatchError, superClass);\n\n      function InvalidPatchError(message) {\n        this.message = message != null ? message : 'Invalid patch';\n        this.name = 'InvalidPatch';\n      }\n\n      return InvalidPatchError;\n\n    })(JSONPatchError);\n    PatchConflictError = (function(superClass) {\n      extend(PatchConflictError, superClass);\n\n      function PatchConflictError(message) {\n        this.message = message != null ? message : 'Patch conflict';\n        this.name = 'PatchConflictError';\n      }\n\n      return PatchConflictError;\n\n    })(JSONPatchError);\n    PatchTestFailed = (function(superClass) {\n      extend(PatchTestFailed, superClass);\n\n      function PatchTestFailed(message) {\n        this.message = message != null ? message : 'Patch test failed';\n        this.name = 'PatchTestFailed';\n      }\n\n      return PatchTestFailed;\n\n    })(Error);\n    escapedSlash = /~1/g;\n    escapedTilde = /~0/g;\n    accessorMatch = /^[-+]?\\d+$/;\n    JSONPointer = (function() {\n      function JSONPointer(path) {\n        var i, j, len1, step, steps;\n        steps = [];\n        if (path && (steps = path.split('/')).shift() !== '') {\n          throw new InvalidPointerError();\n        }\n        for (i = j = 0, len1 = steps.length; j < len1; i = ++j) {\n          step = steps[i];\n          steps[i] = step.replace(escapedSlash, '/').replace(escapedTilde, '~');\n        }\n        this.accessor = steps.pop();\n        this.steps = steps;\n        this.path = path;\n      }\n\n      JSONPointer.prototype.getReference = function(parent) {\n        var j, len1, ref, step;\n        ref = this.steps;\n        for (j = 0, len1 = ref.length; j < len1; j++) {\n          step = ref[j];\n          if (isArray(parent)) {\n            step = parseInt(step, 10);\n          }\n          if (!(step in parent)) {\n            throw new PatchConflictError('Array location out of bounds or not an instance property');\n          }\n          parent = parent[step];\n        }\n        return parent;\n      };\n\n      JSONPointer.prototype.coerce = function(reference, accessor) {\n        if (isArray(reference)) {\n          if (isString(accessor)) {\n            if (accessor === '-') {\n              accessor = reference.length;\n            } else if (accessorMatch.test(accessor)) {\n              accessor = parseInt(accessor, 10);\n            } else {\n              throw new InvalidPointerError('Invalid array index number');\n            }\n          }\n        }\n        return accessor;\n      };\n\n      return JSONPointer;\n\n    })();\n    JSONPatch = (function() {\n      function JSONPatch(patch) {\n        if (!('path' in patch)) {\n          throw new InvalidPatchError();\n        }\n        this.validate(patch);\n        this.patch = patch;\n        this.path = new JSONPointer(patch.path);\n        this.initialize(patch);\n      }\n\n      JSONPatch.prototype.initialize = function() {};\n\n      JSONPatch.prototype.validate = function(patch) {};\n\n      JSONPatch.prototype.apply = function(document) {\n        throw new Error('Method not implemented');\n      };\n\n      return JSONPatch;\n\n    })();\n    AddPatch = (function(superClass) {\n      extend(AddPatch, superClass);\n\n      function AddPatch() {\n        return AddPatch.__super__.constructor.apply(this, arguments);\n      }\n\n      AddPatch.prototype.validate = function(patch) {\n        if (!('value' in patch)) {\n          throw new InvalidPatchError();\n        }\n      };\n\n      AddPatch.prototype.apply = function(document) {\n        var accessor, reference, value;\n        reference = this.path.getReference(document);\n        accessor = this.path.accessor;\n        value = this.patch.value;\n        if (isArray(reference)) {\n          accessor = this.path.coerce(reference, accessor);\n          if (accessor < 0 || accessor > reference.length) {\n            throw new PatchConflictError(\"Index \" + accessor + \" out of bounds\");\n          }\n          reference.splice(accessor, 0, value);\n        } else if (accessor == null) {\n          document = value;\n        } else {\n          reference[accessor] = value;\n        }\n        return document;\n      };\n\n      return AddPatch;\n\n    })(JSONPatch);\n    RemovePatch = (function(superClass) {\n      extend(RemovePatch, superClass);\n\n      function RemovePatch() {\n        return RemovePatch.__super__.constructor.apply(this, arguments);\n      }\n\n      RemovePatch.prototype.apply = function(document) {\n        var accessor, reference;\n        reference = this.path.getReference(document);\n        accessor = this.path.accessor;\n        if (isArray(reference)) {\n          accessor = this.path.coerce(reference, accessor);\n          if (accessor >= reference.length) {\n            throw new PatchConflictError(\"Value at \" + accessor + \" does not exist\");\n          }\n          reference.splice(accessor, 1);\n        } else {\n          if (!(accessor in reference)) {\n            throw new PatchConflictError(\"Value at \" + accessor + \" does not exist\");\n          }\n          delete reference[accessor];\n        }\n        return document;\n      };\n\n      return RemovePatch;\n\n    })(JSONPatch);\n    ReplacePatch = (function(superClass) {\n      extend(ReplacePatch, superClass);\n\n      function ReplacePatch() {\n        return ReplacePatch.__super__.constructor.apply(this, arguments);\n      }\n\n      ReplacePatch.prototype.validate = function(patch) {\n        if (!('value' in patch)) {\n          throw new InvalidPatchError();\n        }\n      };\n\n      ReplacePatch.prototype.apply = function(document) {\n        var accessor, reference, value;\n        reference = this.path.getReference(document);\n        accessor = this.path.accessor;\n        value = this.patch.value;\n        if (accessor == null) {\n          return value;\n        }\n        if (isArray(reference)) {\n          accessor = this.path.coerce(reference, accessor);\n          if (accessor >= reference.length) {\n            throw new PatchConflictError(\"Value at \" + accessor + \" does not exist\");\n          }\n          reference.splice(accessor, 1, value);\n        } else {\n          if (!(accessor in reference)) {\n            throw new PatchConflictError(\"Value at \" + accessor + \" does not exist\");\n          }\n          reference[accessor] = value;\n        }\n        return document;\n      };\n\n      return ReplacePatch;\n\n    })(JSONPatch);\n    TestPatch = (function(superClass) {\n      extend(TestPatch, superClass);\n\n      function TestPatch() {\n        return TestPatch.__super__.constructor.apply(this, arguments);\n      }\n\n      TestPatch.prototype.validate = function(patch) {\n        if (!('value' in patch)) {\n          throw new InvalidPatchError(\"'value' member is required\");\n        }\n      };\n\n      TestPatch.prototype.apply = function(document) {\n        var accessor, reference, value;\n        reference = this.path.getReference(document);\n        accessor = this.path.accessor;\n        value = this.patch.value;\n        if (isArray(reference)) {\n          accessor = this.path.coerce(reference, accessor);\n        }\n        if (!isEqual(reference[accessor], value)) {\n          throw new PatchTestFailed();\n        }\n        return document;\n      };\n\n      return TestPatch;\n\n    })(JSONPatch);\n    MovePatch = (function(superClass) {\n      extend(MovePatch, superClass);\n\n      function MovePatch() {\n        return MovePatch.__super__.constructor.apply(this, arguments);\n      }\n\n      MovePatch.prototype.initialize = function(patch) {\n        var i, j, len, ref, within;\n        this.from = new JSONPointer(patch.from);\n        len = this.from.steps.length;\n        within = true;\n        for (i = j = 0, ref = len; 0 <= ref ? j <= ref : j >= ref; i = 0 <= ref ? ++j : --j) {\n          if (this.from.steps[i] !== this.path.steps[i]) {\n            within = false;\n            break;\n          }\n        }\n        if (within) {\n          if (this.path.steps.length !== len) {\n            throw new InvalidPatchError(\"'to' member cannot be a descendent of 'path'\");\n          }\n          if (this.from.accessor === this.path.accessor) {\n            return this.apply = function(document) {\n              return document;\n            };\n          }\n        }\n      };\n\n      MovePatch.prototype.validate = function(patch) {\n        if (!('from' in patch)) {\n          throw new InvalidPatchError(\"'from' member is required\");\n        }\n      };\n\n      MovePatch.prototype.apply = function(document) {\n        var accessor, reference, value;\n        reference = this.from.getReference(document);\n        accessor = this.from.accessor;\n        if (isArray(reference)) {\n          accessor = this.from.coerce(reference, accessor);\n          if (accessor >= reference.length) {\n            throw new PatchConflictError(\"Value at \" + accessor + \" does not exist\");\n          }\n          value = reference.splice(accessor, 1)[0];\n        } else {\n          if (!(accessor in reference)) {\n            throw new PatchConflictError(\"Value at \" + accessor + \" does not exist\");\n          }\n          value = reference[accessor];\n          delete reference[accessor];\n        }\n        reference = this.path.getReference(document);\n        accessor = this.path.accessor;\n        if (isArray(reference)) {\n          accessor = this.path.coerce(reference, accessor);\n          if (accessor < 0 || accessor > reference.length) {\n            throw new PatchConflictError(\"Index \" + accessor + \" out of bounds\");\n          }\n          reference.splice(accessor, 0, value);\n        } else {\n          if (accessor in reference) {\n            throw new PatchConflictError(\"Value at \" + accessor + \" exists\");\n          }\n          reference[accessor] = value;\n        }\n        return document;\n      };\n\n      return MovePatch;\n\n    })(JSONPatch);\n    CopyPatch = (function(superClass) {\n      extend(CopyPatch, superClass);\n\n      function CopyPatch() {\n        return CopyPatch.__super__.constructor.apply(this, arguments);\n      }\n\n      CopyPatch.prototype.apply = function(document) {\n        var accessor, reference, value;\n        reference = this.from.getReference(document);\n        accessor = this.from.accessor;\n        if (isArray(reference)) {\n          accessor = this.from.coerce(reference, accessor);\n          if (accessor >= reference.length) {\n            throw new PatchConflictError(\"Value at \" + accessor + \" does not exist\");\n          }\n          value = reference.slice(accessor, accessor + 1)[0];\n        } else {\n          if (!(accessor in reference)) {\n            throw new PatchConflictError(\"Value at \" + accessor + \" does not exist\");\n          }\n          value = reference[accessor];\n        }\n        reference = this.path.getReference(document);\n        accessor = this.path.accessor;\n        if (isArray(reference)) {\n          accessor = this.path.coerce(reference, accessor);\n          if (accessor < 0 || accessor > reference.length) {\n            throw new PatchConflictError(\"Index \" + accessor + \" out of bounds\");\n          }\n          reference.splice(accessor, 0, value);\n        } else {\n          if (accessor in reference) {\n            throw new PatchConflictError(\"Value at \" + accessor + \" exists\");\n          }\n          reference[accessor] = value;\n        }\n        return document;\n      };\n\n      return CopyPatch;\n\n    })(MovePatch);\n    operationMap = {\n      add: AddPatch,\n      remove: RemovePatch,\n      replace: ReplacePatch,\n      move: MovePatch,\n      copy: CopyPatch,\n      test: TestPatch\n    };\n    compile = function(patch) {\n      var j, klass, len1, ops, p;\n      if (!isArray(patch)) {\n        if (isObject(patch)) {\n          patch = [patch];\n        } else {\n          throw new InvalidPatchError('patch must be an object or array');\n        }\n      }\n      ops = [];\n      for (j = 0, len1 = patch.length; j < len1; j++) {\n        p = patch[j];\n        if (!(klass = operationMap[p.op])) {\n          throw new InvalidPatchError('invalid operation: ' + p.op);\n        }\n        ops.push(new klass(p));\n      }\n      return function(document) {\n        var k, len2, op, result;\n        result = document;\n        for (k = 0, len2 = ops.length; k < len2; k++) {\n          op = ops[k];\n          result = op.apply(result);\n        }\n        return result;\n      };\n    };\n    apply = function(document, patch) {\n      return compile(patch)(document);\n    };\n    exports.version = '0.7.0';\n    exports.apply = apply;\n    exports.compile = compile;\n    exports.JSONPointer = JSONPointer;\n    exports.JSONPatch = JSONPatch;\n    exports.JSONPatchError = JSONPatchError;\n    exports.InvalidPointerError = InvalidPointerError;\n    exports.InvalidPatchError = InvalidPatchError;\n    exports.PatchConflictError = PatchConflictError;\n    exports.PatchTestFailed = PatchTestFailed;\n    return exports;\n  });\n\n}).call(this);\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///224\n")},573:(module,__unused_webpack_exports,__webpack_require__)=>{"use strict";eval("\n\nvar each = __webpack_require__(804);\nmodule.exports = api;\n\n\n/**\n * Convenience wrapper around the api.\n * Calls `.get` when called with an `object` and a `pointer`.\n * Calls `.set` when also called with `value`.\n * If only supplied `object`, returns a partially applied function, mapped to the object.\n *\n * @param {Object} obj\n * @param {String|Array} pointer\n * @param value\n * @returns {*}\n */\n\nfunction api (obj, pointer, value) {\n    // .set()\n    if (arguments.length === 3) {\n        return api.set(obj, pointer, value);\n    }\n    // .get()\n    if (arguments.length === 2) {\n        return api.get(obj, pointer);\n    }\n    // Return a partially applied function on `obj`.\n    var wrapped = api.bind(api, obj);\n\n    // Support for oo style\n    for (var name in api) {\n        if (api.hasOwnProperty(name)) {\n            wrapped[name] = api[name].bind(wrapped, obj);\n        }\n    }\n    return wrapped;\n}\n\n\n/**\n * Lookup a json pointer in an object\n *\n * @param {Object} obj\n * @param {String|Array} pointer\n * @returns {*}\n */\napi.get = function get (obj, pointer) {\n    var refTokens = Array.isArray(pointer) ? pointer : api.parse(pointer);\n\n    for (var i = 0; i < refTokens.length; ++i) {\n        var tok = refTokens[i];\n        if (!(typeof obj == 'object' && tok in obj)) {\n            throw new Error('Invalid reference token: ' + tok);\n        }\n        obj = obj[tok];\n    }\n    return obj;\n};\n\n/**\n * Sets a value on an object\n *\n * @param {Object} obj\n * @param {String|Array} pointer\n * @param value\n */\napi.set = function set (obj, pointer, value) {\n    var refTokens = Array.isArray(pointer) ? pointer : api.parse(pointer),\n      nextTok = refTokens[0];\n\n    if (refTokens.length === 0) {\n      throw Error('Can not set the root object');\n    }\n\n    for (var i = 0; i < refTokens.length - 1; ++i) {\n        var tok = refTokens[i];\n        if (tok === \"__proto__\" || tok === \"constructor\" || tok === \"prototype\") {\n            continue\n        }\n        if (tok === '-' && Array.isArray(obj)) {\n          tok = obj.length;\n        }\n        nextTok = refTokens[i + 1];\n\n        if (!(tok in obj)) {\n            if (nextTok.match(/^(\\d+|-)$/)) {\n                obj[tok] = [];\n            } else {\n                obj[tok] = {};\n            }\n        }\n        obj = obj[tok];\n    }\n    if (nextTok === '-' && Array.isArray(obj)) {\n      nextTok = obj.length;\n    }\n    obj[nextTok] = value;\n    return this;\n};\n\n/**\n * Removes an attribute\n *\n * @param {Object} obj\n * @param {String|Array} pointer\n */\napi.remove = function (obj, pointer) {\n    var refTokens = Array.isArray(pointer) ? pointer : api.parse(pointer);\n    var finalToken = refTokens[refTokens.length -1];\n    if (finalToken === undefined) {\n        throw new Error('Invalid JSON pointer for remove: \"' + pointer + '\"');\n    }\n\n    var parent = api.get(obj, refTokens.slice(0, -1));\n    if (Array.isArray(parent)) {\n      var index = +finalToken;\n      if (finalToken === '' && isNaN(index)) {\n        throw new Error('Invalid array index: \"' + finalToken + '\"');\n      }\n\n      Array.prototype.splice.call(parent, index, 1);\n    } else {\n      delete parent[finalToken];\n    }\n};\n\n/**\n * Returns a (pointer -> value) dictionary for an object\n *\n * @param obj\n * @param {function} descend\n * @returns {}\n */\napi.dict = function dict (obj, descend) {\n    var results = {};\n    api.walk(obj, function (value, pointer) {\n        results[pointer] = value;\n    }, descend);\n    return results;\n};\n\n/**\n * Iterates over an object\n * Iterator: function (value, pointer) {}\n *\n * @param obj\n * @param {function} iterator\n * @param {function} descend\n */\napi.walk = function walk (obj, iterator, descend) {\n    var refTokens = [];\n\n    descend = descend || function (value) {\n        var type = Object.prototype.toString.call(value);\n        return type === '[object Object]' || type === '[object Array]';\n    };\n\n    (function next (cur) {\n        each(cur, function (value, key) {\n            refTokens.push(String(key));\n            if (descend(value)) {\n                next(value);\n            } else {\n                iterator(value, api.compile(refTokens));\n            }\n            refTokens.pop();\n        });\n    }(obj));\n};\n\n/**\n * Tests if an object has a value for a json pointer\n *\n * @param obj\n * @param pointer\n * @returns {boolean}\n */\napi.has = function has (obj, pointer) {\n    try {\n        api.get(obj, pointer);\n    } catch (e) {\n        return false;\n    }\n    return true;\n};\n\n/**\n * Escapes a reference token\n *\n * @param str\n * @returns {string}\n */\napi.escape = function escape (str) {\n    return str.toString().replace(/~/g, '~0').replace(/\\//g, '~1');\n};\n\n/**\n * Unescapes a reference token\n *\n * @param str\n * @returns {string}\n */\napi.unescape = function unescape (str) {\n    return str.replace(/~1/g, '/').replace(/~0/g, '~');\n};\n\n/**\n * Converts a json pointer into a array of reference tokens\n *\n * @param pointer\n * @returns {Array}\n */\napi.parse = function parse (pointer) {\n    if (pointer === '') { return []; }\n    if (pointer.charAt(0) !== '/') { throw new Error('Invalid JSON pointer: ' + pointer); }\n    return pointer.substring(1).split(/\\//).map(api.unescape);\n};\n\n/**\n * Builds a json pointer from a array of reference tokens\n *\n * @param refTokens\n * @returns {string}\n */\napi.compile = function compile (refTokens) {\n    if (refTokens.length === 0) { return ''; }\n    return '/' + refTokens.map(api.escape).join('/');\n};\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///573\n")}},__webpack_module_cache__={};function __webpack_require__(g){var I=__webpack_module_cache__[g];if(void 0!==I)return I.exports;var n=__webpack_module_cache__[g]={exports:{}};return __webpack_modules__[g].call(n.exports,n,n.exports,__webpack_require__),n.exports}__webpack_require__.g=function(){if("object"==typeof globalThis)return globalThis;try{return this||new Function("return this")()}catch(g){if("object"==typeof window)return window}}();var __webpack_exports__=__webpack_require__(10);root=__webpack_exports__})();