import configparser
from odoo_env import __version__

class OdooConf(object):
    """ Representa el archivo odoo.conf y sus metodos para leer
        salvar y agregarle datos
    """

    def __init__(self, filename):
        self._filename = filename
        self.config = dict()

    def read_config(self):
        """ lee el config y lo vuelca a un diccionario
        """
        config = configparser.ConfigParser()
        config.read(self._filename)
        self.config = config._sections

    def write_config(self):
        """ Escribe o sobreescribe el config file
        """
        config = configparser.ConfigParser(allow_no_value=True)
        config.add_section('options')
        config.set('options', '; Configuration file generated by odoo-env v%s' % __version__)
        config.read_dict(self.config)
        with open(self._filename, 'w') as _fp:
            config.write(_fp)

    @staticmethod
    def _parse(line):
        """ dado un string de la forma 'key = value'
            devuelve key y value
        """
        splited = line.split('=')
        key = splited[0].strip()
        value = splited[1].strip()
        return key, value

    def add_list_data(self, datas):
        """ Agrega al config parametros de una lista con la sintaxis que tendra
            finalmente el archivo. o sea 'key = value'
        """
        for data in datas:
            key, value = self._parse(data)
            self.config['options'][key] = value
