# -*- coding: utf-8 -*-
#  Copyright (c) 2020. Distributed under the terms of the MIT License.

import pytest
from pymatgen import Structure
from vise.analyzer.dash_components.main import mpid_and_link
from vise.util.structure_symmetrizer import StructureSymmetrizer


def test_mpid_and_link():
    structure = Structure.from_str("""Na4 Mg4 F12
    1.00000000000000
    5.5403959532636717    0.0000000000000000    0.0000000000000000
    0.0000000000000000    7.7192894192012265    0.0000000000000000
    0.0000000000000000    0.0000000000000000    5.3769536232127138
    Na   Mg   F
    4     4    12
    Direct
    0.9497921992239995  0.7500000000000000  0.0129542690007938
    0.5502078007760005  0.2500000000000000  0.5129542690007938
    0.4497921992239995  0.7500000000000000  0.4870457309992062
    0.0502078007760005  0.2500000000000000  0.9870457309992062
    0.5000000000000000  0.5000000000000000  0.0000000000000000
    0.0000000000000000  0.5000000000000000  0.5000000000000000
    0.0000000000000000  0.0000000000000000  0.5000000000000000
    0.5000000000000000  0.0000000000000000  0.0000000000000000
    0.2969351011472696  0.4487202654645159  0.7001676173426432
    0.2030648988527304  0.5512797345354841  0.2001676173426432
    0.7969351011472696  0.0512797345354841  0.7998323826573568
    0.7030648988527304  0.9487202654645159  0.2998323826573568
    0.7030648988527304  0.5512797345354841  0.2998323826573568
    0.7969351011472696  0.4487202654645159  0.7998323826573568
    0.2030648988527304  0.9487202654645159  0.2001676173426432
    0.2969351011472696  0.0512797345354841  0.7001676173426432
    0.4659271295707299  0.2500000000000000  0.0977064851714076
    0.0340728704292701  0.7500000000000000  0.5977064851714076
    0.9659271295707299  0.2500000000000000  0.4022935148285924
    0.5340728704292701  0.7500000000000000  0.9022935148285924""", fmt="POSCAR")
    symmetrizer = StructureSymmetrizer(structure)
    print(mpid_and_link(symmetrizer))


"""
TODO
-

DONE
"""
