#!/usr/bin/python
#
# Copyright 2018-2021 Polyaxon, Inc.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# coding: utf-8

"""
    Polyaxon SDKs and REST API specification.

    Polyaxon SDKs and REST API specification.  # noqa: E501

    The version of the OpenAPI document: 1.15.0
    Contact: contact@polyaxon.com
    Generated by: https://openapi-generator.tech
"""


try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from polyaxon_sdk.configuration import Configuration


class V1Tag(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'uuid': 'str',
        'name': 'str',
        'color': 'str',
        'description': 'str',
        'icon': 'str',
        'stats': 'object'
    }

    attribute_map = {
        'uuid': 'uuid',
        'name': 'name',
        'color': 'color',
        'description': 'description',
        'icon': 'icon',
        'stats': 'stats'
    }

    def __init__(self, uuid=None, name=None, color=None, description=None, icon=None, stats=None, local_vars_configuration=None):  # noqa: E501
        """V1Tag - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration.get_default_copy()
        self.local_vars_configuration = local_vars_configuration

        self._uuid = None
        self._name = None
        self._color = None
        self._description = None
        self._icon = None
        self._stats = None
        self.discriminator = None

        if uuid is not None:
            self.uuid = uuid
        if name is not None:
            self.name = name
        if color is not None:
            self.color = color
        if description is not None:
            self.description = description
        if icon is not None:
            self.icon = icon
        if stats is not None:
            self.stats = stats

    @property
    def uuid(self):
        """Gets the uuid of this V1Tag.  # noqa: E501


        :return: The uuid of this V1Tag.  # noqa: E501
        :rtype: str
        """
        return self._uuid

    @uuid.setter
    def uuid(self, uuid):
        """Sets the uuid of this V1Tag.


        :param uuid: The uuid of this V1Tag.  # noqa: E501
        :type uuid: str
        """

        self._uuid = uuid

    @property
    def name(self):
        """Gets the name of this V1Tag.  # noqa: E501


        :return: The name of this V1Tag.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this V1Tag.


        :param name: The name of this V1Tag.  # noqa: E501
        :type name: str
        """

        self._name = name

    @property
    def color(self):
        """Gets the color of this V1Tag.  # noqa: E501


        :return: The color of this V1Tag.  # noqa: E501
        :rtype: str
        """
        return self._color

    @color.setter
    def color(self, color):
        """Sets the color of this V1Tag.


        :param color: The color of this V1Tag.  # noqa: E501
        :type color: str
        """

        self._color = color

    @property
    def description(self):
        """Gets the description of this V1Tag.  # noqa: E501


        :return: The description of this V1Tag.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this V1Tag.


        :param description: The description of this V1Tag.  # noqa: E501
        :type description: str
        """

        self._description = description

    @property
    def icon(self):
        """Gets the icon of this V1Tag.  # noqa: E501


        :return: The icon of this V1Tag.  # noqa: E501
        :rtype: str
        """
        return self._icon

    @icon.setter
    def icon(self, icon):
        """Sets the icon of this V1Tag.


        :param icon: The icon of this V1Tag.  # noqa: E501
        :type icon: str
        """

        self._icon = icon

    @property
    def stats(self):
        """Gets the stats of this V1Tag.  # noqa: E501


        :return: The stats of this V1Tag.  # noqa: E501
        :rtype: object
        """
        return self._stats

    @stats.setter
    def stats(self, stats):
        """Sets the stats of this V1Tag.


        :param stats: The stats of this V1Tag.  # noqa: E501
        :type stats: object
        """

        self._stats = stats

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, V1Tag):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, V1Tag):
            return True

        return self.to_dict() != other.to_dict()
