#!/usr/bin/python
#
# Copyright 2018-2021 Polyaxon, Inc.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# coding: utf-8

"""
    Polyaxon SDKs and REST API specification.

    Polyaxon SDKs and REST API specification.  # noqa: E501

    The version of the OpenAPI document: 1.15.0
    Contact: contact@polyaxon.com
    Generated by: https://openapi-generator.tech
"""


try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from polyaxon_sdk.configuration import Configuration


class V1TeamSettings(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'projects': 'list[V1SettingsCatalog]',
        'hubs': 'list[V1SettingsCatalog]',
        'registries': 'list[V1SettingsCatalog]'
    }

    attribute_map = {
        'projects': 'projects',
        'hubs': 'hubs',
        'registries': 'registries'
    }

    def __init__(self, projects=None, hubs=None, registries=None, local_vars_configuration=None):  # noqa: E501
        """V1TeamSettings - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration.get_default_copy()
        self.local_vars_configuration = local_vars_configuration

        self._projects = None
        self._hubs = None
        self._registries = None
        self.discriminator = None

        if projects is not None:
            self.projects = projects
        if hubs is not None:
            self.hubs = hubs
        if registries is not None:
            self.registries = registries

    @property
    def projects(self):
        """Gets the projects of this V1TeamSettings.  # noqa: E501


        :return: The projects of this V1TeamSettings.  # noqa: E501
        :rtype: list[V1SettingsCatalog]
        """
        return self._projects

    @projects.setter
    def projects(self, projects):
        """Sets the projects of this V1TeamSettings.


        :param projects: The projects of this V1TeamSettings.  # noqa: E501
        :type projects: list[V1SettingsCatalog]
        """

        self._projects = projects

    @property
    def hubs(self):
        """Gets the hubs of this V1TeamSettings.  # noqa: E501


        :return: The hubs of this V1TeamSettings.  # noqa: E501
        :rtype: list[V1SettingsCatalog]
        """
        return self._hubs

    @hubs.setter
    def hubs(self, hubs):
        """Sets the hubs of this V1TeamSettings.


        :param hubs: The hubs of this V1TeamSettings.  # noqa: E501
        :type hubs: list[V1SettingsCatalog]
        """

        self._hubs = hubs

    @property
    def registries(self):
        """Gets the registries of this V1TeamSettings.  # noqa: E501


        :return: The registries of this V1TeamSettings.  # noqa: E501
        :rtype: list[V1SettingsCatalog]
        """
        return self._registries

    @registries.setter
    def registries(self, registries):
        """Sets the registries of this V1TeamSettings.


        :param registries: The registries of this V1TeamSettings.  # noqa: E501
        :type registries: list[V1SettingsCatalog]
        """

        self._registries = registries

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, V1TeamSettings):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, V1TeamSettings):
            return True

        return self.to_dict() != other.to_dict()
