"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Awsconnector = void 0;
const shared_1 = require("../shared");
/**
 * Statement provider for service [awsconnector](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsconnectorservice.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class Awsconnector extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [awsconnector](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsconnectorservice.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid) {
        super(sid);
        this.servicePrefix = 'awsconnector';
        this.accessLevelList = {
            "Read": [
                "GetConnectorHealth",
                "ValidateConnectorId"
            ],
            "Write": [
                "RegisterConnector"
            ]
        };
    }
    /**
     * Retrieves all health metrics that were published from the Server Migration Connector.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/server-migration-service/latest/userguide/prereqs.html#connector-permissions
     */
    toGetConnectorHealth() {
        this.to('awsconnector:GetConnectorHealth');
        return this;
    }
    /**
     * Registers AWS Connector with AWS Connector Service.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/server-migration-service/latest/userguide/prereqs.html#connector-permissions
     */
    toRegisterConnector() {
        this.to('awsconnector:RegisterConnector');
        return this;
    }
    /**
     * Validates Server Migration Connector Id that was registered with AWS Connector Service.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/server-migration-service/latest/userguide/prereqs.html#connector-permissions
     */
    toValidateConnectorId() {
        this.to('awsconnector:ValidateConnectorId');
        return this;
    }
}
exports.Awsconnector = Awsconnector;
//# sourceMappingURL=data:application/json;base64,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