import { AccessLevelList } from "../shared/access-level";
import { PolicyStatement } from "../shared";
/**
 * Statement provider for service [devicefarm](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsdevicefarm.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class Devicefarm extends PolicyStatement {
    servicePrefix: string;
    /**
     * Statement provider for service [devicefarm](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsdevicefarm.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid?: string);
    /**
     * Grants permission to create a device pool within a project
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_CreateDevicePool.html
     */
    toCreateDevicePool(): this;
    /**
     * Grants permission to create a device instance profile
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_CreateInstanceProfile.html
     */
    toCreateInstanceProfile(): this;
    /**
     * Grants permission to create a network profile within a project
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_CreateNetworkProfile.html
     */
    toCreateNetworkProfile(): this;
    /**
     * Grants permission to create a project for mobile testing
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_CreateProject.html
     */
    toCreateProject(): this;
    /**
     * Grants permission to start a remote access session to a device instance
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_CreateRemoteAccessSession.html
     */
    toCreateRemoteAccessSession(): this;
    /**
     * Grants permission to create a project for desktop testing
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_CreateTestGridProject.html
     */
    toCreateTestGridProject(): this;
    /**
     * Grants permission to generate a new pre-signed url used to access our test grid service
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_CreateTestGridUrl.html
     */
    toCreateTestGridUrl(): this;
    /**
     * Grants permission to upload a new file or app within a project
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_CreateUpload.html
     */
    toCreateUpload(): this;
    /**
     * Grants permission to create an Amazon Virtual Private Cloud (VPC) endpoint configuration
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_CreateVPCEConfiguration.html
     */
    toCreateVPCEConfiguration(): this;
    /**
     * Grants permission to delete a user-generated device pool
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_DeleteDevicePool.html
     */
    toDeleteDevicePool(): this;
    /**
     * Grants permission to delete a user-generated instance profile
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_DeleteInstanceProfile.html
     */
    toDeleteInstanceProfile(): this;
    /**
     * Grants permission to delete a user-generated network profile
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/DeleteNetworkProfile.html
     */
    toDeleteNetworkProfile(): this;
    /**
     * Grants permission to delete a mobile testing project
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_DeleteProject.html
     */
    toDeleteProject(): this;
    /**
     * Grants permission to delete a completed remote access session and its results
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_DeleteRemoteAccessSession.html
     */
    toDeleteRemoteAccessSession(): this;
    /**
     * Grants permission to delete a run
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_DeleteRun.html
     */
    toDeleteRun(): this;
    /**
     * Grants permission to delete a desktop testing project
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_DeleteTestGridProject.html
     */
    toDeleteTestGridProject(): this;
    /**
     * Grants permission to delete a user-uploaded file
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_DeleteUpload.html
     */
    toDeleteUpload(): this;
    /**
     * Grants permission to delete an Amazon Virtual Private Cloud (VPC) endpoint configuration
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_DeleteVPCEConfiguration.html
     */
    toDeleteVPCEConfiguration(): this;
    /**
     * Grants permission to retrieve the number of unmetered iOS and/or unmetered Android devices purchased by the account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_GetAccountSettings.html
     */
    toGetAccountSettings(): this;
    /**
     * Grants permission to retrieve the information of a unique device type
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_GetDevice.html
     */
    toGetDevice(): this;
    /**
     * Grants permission to retireve the information of a device instance
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_GetDeviceInstance.html
     */
    toGetDeviceInstance(): this;
    /**
     * Grants permission to retireve the information of a device pool
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_GetDevicePool.html
     */
    toGetDevicePool(): this;
    /**
     * Grants permission to retrieve information about the compatibility of a test and/or app with a device pool
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_GetDevicePoolCompatibility.html
     */
    toGetDevicePoolCompatibility(): this;
    /**
     * Grants permission to retireve the information of an instance profile
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_GetInstanceProfile.html
     */
    toGetInstanceProfile(): this;
    /**
     * Grants permission to retireve the information of a job
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_GetJob.html
     */
    toGetJob(): this;
    /**
     * Grants permission to retireve the information of a network profile
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_GetNetworkProfile.html
     */
    toGetNetworkProfile(): this;
    /**
     * Grants permission to retrieve the current status and future status of all offerings purchased by an AWS account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_GetOfferingStatus.html
     */
    toGetOfferingStatus(): this;
    /**
     * Grants permission to retrieve information about a mobile testing project
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_GetProject.html
     */
    toGetProject(): this;
    /**
     * Grants permission to retireve the link to a currently running remote access session
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_GetRemoteAccessSession.html
     */
    toGetRemoteAccessSession(): this;
    /**
     * Grants permission to retireve the information of a run
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_GetRun.html
     */
    toGetRun(): this;
    /**
     * Grants permission to retireve the information of a testing suite
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_GetSuite.html
     */
    toGetSuite(): this;
    /**
     * Grants permission to retireve the information of a test case
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_GetTest.html
     */
    toGetTest(): this;
    /**
     * Grants permission to retrieve information about a desktop testing project
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_GetTestGridProject.html
     */
    toGetTestGridProject(): this;
    /**
     * Grants permission to retireve the information of a test grid session
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_GetTestGridSession.html
     */
    toGetTestGridSession(): this;
    /**
     * Grants permission to retireve the information of an uploaded file
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_GetUpload.html
     */
    toGetUpload(): this;
    /**
     * Grants permission to retireve the information of an Amazon Virtual Private Cloud (VPC) endpoint configuration
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_GetVPCEConfiguration.html
     */
    toGetVPCEConfiguration(): this;
    /**
     * Grants permission to install an application to a device in a remote access session
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_InstallToRemoteAccessSession.html
     */
    toInstallToRemoteAccessSession(): this;
    /**
     * Grants permission to list the artifacts in a project
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_ListArtifacts.html
     */
    toListArtifacts(): this;
    /**
     * Grants permission to list the information of device instances
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_ListDeviceInstances.html
     */
    toListDeviceInstances(): this;
    /**
     * Grants permission to list the information of device pools
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_ListDevicePools.html
     */
    toListDevicePools(): this;
    /**
     * Grants permission to list the information of unique device types
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_ListDevices.html
     */
    toListDevices(): this;
    /**
     * Grants permission to list the information of device instance profiles
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_ListInstanceProfiles.html
     */
    toListInstanceProfiles(): this;
    /**
     * Grants permission to list the information of jobs within a run
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_ListJobs.html
     */
    toListJobs(): this;
    /**
     * Grants permission to list the information of network profiles within a project
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_ListNetworkProfiles.html
     */
    toListNetworkProfiles(): this;
    /**
     * Grants permission to list the offering promotions
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_ListOfferingPromotions.html
     */
    toListOfferingPromotions(): this;
    /**
     * Grants permission to list all of the historical purchases, renewals, and system renewal transactions for an AWS account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_ListOfferingTransactions.html
     */
    toListOfferingTransactions(): this;
    /**
     * Grants permission to list the products or offerings that the user can manage through the API
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_ListOfferings.html
     */
    toListOfferings(): this;
    /**
     * Grants permission to list the information of mobile testing projects for an AWS account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_ListProjects.html
     */
    toListProjects(): this;
    /**
     * Grants permission to list the information of currently running remote access sessions
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_ListRemoteAccessSessions.html
     */
    toListRemoteAccessSessions(): this;
    /**
     * Grants permission to list the information of runs within a project
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_ListRuns.html
     */
    toListRuns(): this;
    /**
     * Grants permission to list the information of samples within a project
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_ListSamples.html
     */
    toListSamples(): this;
    /**
     * Grants permission to list the information of testing suites within a job
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_ListSuites.html
     */
    toListSuites(): this;
    /**
     * Grants permission to list the tags of a resource
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_ListTagsForResource.html
     */
    toListTagsForResource(): this;
    /**
     * Grants permission to list the information of desktop testing projects for an AWS account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_ListTestGridProjects.html
     */
    toListTestGridProjects(): this;
    /**
     * Grants permission to list the session actions performed during a test grid session
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_ListTestGridSessionActions.html
     */
    toListTestGridSessionActions(): this;
    /**
     * Grants permission to list the artifacts generated by a test grid session
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_ListTestGridSessionArtifacts.html
     */
    toListTestGridSessionArtifacts(): this;
    /**
     * Grants permission to list the sessions within a test grid project
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_ListTestGridSessions.html
     */
    toListTestGridSessions(): this;
    /**
     * Grants permission to list the information of tests within a testing suite
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_ListTests.html
     */
    toListTests(): this;
    /**
     * Grants permission to list the information of unique problems within a run
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_ListUniqueProblems.html
     */
    toListUniqueProblems(): this;
    /**
     * Grants permission to list the information of uploads within a project
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_ListUploads.html
     */
    toListUploads(): this;
    /**
     * Grants permission to list the information of Amazon Virtual Private Cloud (VPC) endpoint configurations
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_ListVPCEConfigurations.html
     */
    toListVPCEConfigurations(): this;
    /**
     * Grants permission to purchase offerings for an AWS account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_PurchaseOffering.html
     */
    toPurchaseOffering(): this;
    /**
     * Grants permission to set the quantity of devices to renew for an offering
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_RenewOffering.html
     */
    toRenewOffering(): this;
    /**
     * Grants permission to schedule a run
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_ScheduleRun.html
     */
    toScheduleRun(): this;
    /**
     * Grants permission to terminate a running job
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_StopJob.html
     */
    toStopJob(): this;
    /**
     * Grants permission to terminate a running remote access session
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_StopRemoteAccessSession.html
     */
    toStopRemoteAccessSession(): this;
    /**
     * Grants permission to terminate a running test run
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_StopRun.html
     */
    toStopRun(): this;
    /**
     * Grants permission to add tags to a resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_TagResource.html
     */
    toTagResource(): this;
    /**
     * Grants permission to remove tags from a resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_UntagResource.html
     */
    toUntagResource(): this;
    /**
     * Grants permission to modify an existing device instance
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_UpdateDeviceInstance.html
     */
    toUpdateDeviceInstance(): this;
    /**
     * Grants permission to modify an existing device pool
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_UpdateDevicePool.html
     */
    toUpdateDevicePool(): this;
    /**
     * Grants permission to modify an existing instance profile
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_UpdateInstanceProfile.html
     */
    toUpdateInstanceProfile(): this;
    /**
     * Grants permission to modify an existing network profile
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_UpdateNetworkProfile.html
     */
    toUpdateNetworkProfile(): this;
    /**
     * Grants permission to modify an existing mobile testing project
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_UpdateProject.html
     */
    toUpdateProject(): this;
    /**
     * Grants permission to modify an existing desktop testing project
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_UpdateTestGridProject.html
     */
    toUpdateTestGridProject(): this;
    /**
     * Grants permission to modify an existing upload
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_UpdateUpload.html
     */
    toUpdateUpload(): this;
    /**
     * Grants permission to modify an existing Amazon Virtual Private Cloud (VPC) endpoint configuration
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_UpdateVPCEConfiguration.html
     */
    toUpdateVPCEConfiguration(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type project to the statement
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_Project.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onProject(resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type run to the statement
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_Run.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onRun(resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type job to the statement
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_Job.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     */
    onJob(resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type suite to the statement
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_Suite.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     */
    onSuite(resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type test to the statement
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_Test.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     */
    onTest(resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type upload to the statement
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_Upload.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     */
    onUpload(resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type artifact to the statement
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_Artifact.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     */
    onArtifact(resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type sample to the statement
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_Sample.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     */
    onSample(resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type networkprofile to the statement
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_NetworkProfile.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onNetworkprofile(resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type deviceinstance to the statement
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_DeviceInstance.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onDeviceinstance(resourceId: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type session to the statement
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_RemoteAccessSession.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onSession(resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type devicepool to the statement
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_DevicePool.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onDevicepool(resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type device to the statement
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_Device.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onDevice(resourceId: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type instanceprofile to the statement
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_InstanceProfile.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onInstanceprofile(resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type vpceconfiguration to the statement
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_VPCEConfiguration.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onVpceconfiguration(resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type testgrid-project to the statement
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_TestGridProject.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onTestgridProject(resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type testgrid-session to the statement
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_TestGridSession.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onTestgridSession(resourceId: string, account?: string, region?: string, partition?: string): this;
}
