"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Ec2 = void 0;
const shared_1 = require("../shared");
/**
 * Statement provider for service [ec2](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonec2.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class Ec2 extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [ec2](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonec2.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid) {
        super(sid);
        this.servicePrefix = 'ec2';
        this.accessLevelList = {
            "Write": [
                "AcceptReservedInstancesExchangeQuote",
                "AcceptTransitGatewayPeeringAttachment",
                "AcceptTransitGatewayVpcAttachment",
                "AcceptVpcEndpointConnections",
                "AcceptVpcPeeringConnection",
                "AdvertiseByoipCidr",
                "AllocateAddress",
                "AllocateHosts",
                "ApplySecurityGroupsToClientVpnTargetNetwork",
                "AssignIpv6Addresses",
                "AssignPrivateIpAddresses",
                "AssociateAddress",
                "AssociateClientVpnTargetNetwork",
                "AssociateDhcpOptions",
                "AssociateIamInstanceProfile",
                "AssociateRouteTable",
                "AssociateSubnetCidrBlock",
                "AssociateTransitGatewayMulticastDomain",
                "AssociateTransitGatewayRouteTable",
                "AssociateVpcCidrBlock",
                "AttachClassicLinkVpc",
                "AttachInternetGateway",
                "AttachNetworkInterface",
                "AttachVolume",
                "AttachVpnGateway",
                "AuthorizeClientVpnIngress",
                "AuthorizeSecurityGroupEgress",
                "AuthorizeSecurityGroupIngress",
                "BundleInstance",
                "CancelBundleTask",
                "CancelCapacityReservation",
                "CancelConversionTask",
                "CancelExportTask",
                "CancelImportTask",
                "CancelReservedInstancesListing",
                "CancelSpotFleetRequests",
                "CancelSpotInstanceRequests",
                "ConfirmProductInstance",
                "CopyFpgaImage",
                "CopyImage",
                "CopySnapshot",
                "CreateCapacityReservation",
                "CreateCarrierGateway",
                "CreateClientVpnEndpoint",
                "CreateClientVpnRoute",
                "CreateCustomerGateway",
                "CreateDefaultSubnet",
                "CreateDefaultVpc",
                "CreateDhcpOptions",
                "CreateEgressOnlyInternetGateway",
                "CreateFleet",
                "CreateFlowLogs",
                "CreateFpgaImage",
                "CreateImage",
                "CreateInstanceExportTask",
                "CreateInternetGateway",
                "CreateKeyPair",
                "CreateLaunchTemplate",
                "CreateLaunchTemplateVersion",
                "CreateLocalGatewayRoute",
                "CreateLocalGatewayRouteTableVpcAssociation",
                "CreateManagedPrefixList",
                "CreateNatGateway",
                "CreateNetworkAcl",
                "CreateNetworkAclEntry",
                "CreateNetworkInterface",
                "CreatePlacementGroup",
                "CreateReservedInstancesListing",
                "CreateRoute",
                "CreateRouteTable",
                "CreateSecurityGroup",
                "CreateSnapshot",
                "CreateSnapshots",
                "CreateSpotDatafeedSubscription",
                "CreateSubnet",
                "CreateTrafficMirrorFilter",
                "CreateTrafficMirrorFilterRule",
                "CreateTrafficMirrorSession",
                "CreateTrafficMirrorTarget",
                "CreateTransitGateway",
                "CreateTransitGatewayMulticastDomain",
                "CreateTransitGatewayPeeringAttachment",
                "CreateTransitGatewayPrefixListReference",
                "CreateTransitGatewayRoute",
                "CreateTransitGatewayRouteTable",
                "CreateTransitGatewayVpcAttachment",
                "CreateVolume",
                "CreateVpc",
                "CreateVpcEndpoint",
                "CreateVpcEndpointConnectionNotification",
                "CreateVpcEndpointServiceConfiguration",
                "CreateVpcPeeringConnection",
                "CreateVpnConnection",
                "CreateVpnConnectionRoute",
                "CreateVpnGateway",
                "DeleteCarrierGateway",
                "DeleteClientVpnEndpoint",
                "DeleteClientVpnRoute",
                "DeleteCustomerGateway",
                "DeleteDhcpOptions",
                "DeleteEgressOnlyInternetGateway",
                "DeleteFleets",
                "DeleteFlowLogs",
                "DeleteFpgaImage",
                "DeleteInternetGateway",
                "DeleteKeyPair",
                "DeleteLaunchTemplate",
                "DeleteLaunchTemplateVersions",
                "DeleteLocalGatewayRoute",
                "DeleteLocalGatewayRouteTableVpcAssociation",
                "DeleteManagedPrefixList",
                "DeleteNatGateway",
                "DeleteNetworkAcl",
                "DeleteNetworkAclEntry",
                "DeleteNetworkInterface",
                "DeletePlacementGroup",
                "DeleteRoute",
                "DeleteRouteTable",
                "DeleteSecurityGroup",
                "DeleteSnapshot",
                "DeleteSpotDatafeedSubscription",
                "DeleteSubnet",
                "DeleteTrafficMirrorFilter",
                "DeleteTrafficMirrorFilterRule",
                "DeleteTrafficMirrorSession",
                "DeleteTrafficMirrorTarget",
                "DeleteTransitGateway",
                "DeleteTransitGatewayMulticastDomain",
                "DeleteTransitGatewayPeeringAttachment",
                "DeleteTransitGatewayPrefixListReference",
                "DeleteTransitGatewayRoute",
                "DeleteTransitGatewayRouteTable",
                "DeleteTransitGatewayVpcAttachment",
                "DeleteVolume",
                "DeleteVpc",
                "DeleteVpcEndpointConnectionNotifications",
                "DeleteVpcEndpointServiceConfigurations",
                "DeleteVpcEndpoints",
                "DeleteVpcPeeringConnection",
                "DeleteVpnConnection",
                "DeleteVpnConnectionRoute",
                "DeleteVpnGateway",
                "DeprovisionByoipCidr",
                "DeregisterImage",
                "DeregisterInstanceEventNotificationAttributes",
                "DeregisterTransitGatewayMulticastGroupMembers",
                "DeregisterTransitGatewayMulticastGroupSources",
                "DetachClassicLinkVpc",
                "DetachInternetGateway",
                "DetachNetworkInterface",
                "DetachVolume",
                "DetachVpnGateway",
                "DisableEbsEncryptionByDefault",
                "DisableFastSnapshotRestores",
                "DisableTransitGatewayRouteTablePropagation",
                "DisableVgwRoutePropagation",
                "DisableVpcClassicLink",
                "DisableVpcClassicLinkDnsSupport",
                "DisassociateAddress",
                "DisassociateClientVpnTargetNetwork",
                "DisassociateIamInstanceProfile",
                "DisassociateRouteTable",
                "DisassociateSubnetCidrBlock",
                "DisassociateTransitGatewayMulticastDomain",
                "DisassociateTransitGatewayRouteTable",
                "DisassociateVpcCidrBlock",
                "EnableEbsEncryptionByDefault",
                "EnableFastSnapshotRestores",
                "EnableTransitGatewayRouteTablePropagation",
                "EnableVgwRoutePropagation",
                "EnableVolumeIO",
                "EnableVpcClassicLink",
                "EnableVpcClassicLinkDnsSupport",
                "ExportImage",
                "ExportTransitGatewayRoutes",
                "ImportClientVpnClientCertificateRevocationList",
                "ImportImage",
                "ImportInstance",
                "ImportKeyPair",
                "ImportSnapshot",
                "ImportVolume",
                "ModifyCapacityReservation",
                "ModifyClientVpnEndpoint",
                "ModifyDefaultCreditSpecification",
                "ModifyEbsDefaultKmsKeyId",
                "ModifyFleet",
                "ModifyFpgaImageAttribute",
                "ModifyHosts",
                "ModifyIdFormat",
                "ModifyIdentityIdFormat",
                "ModifyImageAttribute",
                "ModifyInstanceAttribute",
                "ModifyInstanceCapacityReservationAttributes",
                "ModifyInstanceCreditSpecification",
                "ModifyInstanceEventStartTime",
                "ModifyInstanceMetadataOptions",
                "ModifyInstancePlacement",
                "ModifyLaunchTemplate",
                "ModifyManagedPrefixList",
                "ModifyNetworkInterfaceAttribute",
                "ModifyReservedInstances",
                "ModifySpotFleetRequest",
                "ModifySubnetAttribute",
                "ModifyTrafficMirrorFilterNetworkServices",
                "ModifyTrafficMirrorFilterRule",
                "ModifyTrafficMirrorSession",
                "ModifyTransitGateway",
                "ModifyTransitGatewayPrefixListReference",
                "ModifyTransitGatewayVpcAttachment",
                "ModifyVolume",
                "ModifyVolumeAttribute",
                "ModifyVpcAttribute",
                "ModifyVpcEndpoint",
                "ModifyVpcEndpointConnectionNotification",
                "ModifyVpcEndpointServiceConfiguration",
                "ModifyVpcPeeringConnectionOptions",
                "ModifyVpcTenancy",
                "ModifyVpnConnection",
                "ModifyVpnTunnelCertificate",
                "ModifyVpnTunnelOptions",
                "MonitorInstances",
                "MoveAddressToVpc",
                "ProvisionByoipCidr",
                "PurchaseHostReservation",
                "PurchaseReservedInstancesOffering",
                "PurchaseScheduledInstances",
                "RebootInstances",
                "RegisterImage",
                "RegisterInstanceEventNotificationAttributes",
                "RegisterTransitGatewayMulticastGroupMembers",
                "RegisterTransitGatewayMulticastGroupSources",
                "RejectTransitGatewayPeeringAttachment",
                "RejectTransitGatewayVpcAttachment",
                "RejectVpcEndpointConnections",
                "RejectVpcPeeringConnection",
                "ReleaseAddress",
                "ReleaseHosts",
                "ReplaceIamInstanceProfileAssociation",
                "ReplaceNetworkAclAssociation",
                "ReplaceNetworkAclEntry",
                "ReplaceRoute",
                "ReplaceRouteTableAssociation",
                "ReplaceTransitGatewayRoute",
                "ReportInstanceStatus",
                "RequestSpotFleet",
                "RequestSpotInstances",
                "ResetEbsDefaultKmsKeyId",
                "ResetFpgaImageAttribute",
                "ResetImageAttribute",
                "ResetInstanceAttribute",
                "ResetNetworkInterfaceAttribute",
                "RestoreAddressToClassic",
                "RestoreManagedPrefixListVersion",
                "RevokeClientVpnIngress",
                "RevokeSecurityGroupEgress",
                "RevokeSecurityGroupIngress",
                "RunInstances",
                "RunScheduledInstances",
                "SendDiagnosticInterrupt",
                "StartInstances",
                "StartVpcEndpointServicePrivateDnsVerification",
                "StopInstances",
                "TerminateClientVpnConnections",
                "TerminateInstances",
                "UnassignIpv6Addresses",
                "UnassignPrivateIpAddresses",
                "UnmonitorInstances",
                "UpdateSecurityGroupRuleDescriptionsEgress",
                "UpdateSecurityGroupRuleDescriptionsIngress",
                "WithdrawByoipCidr"
            ],
            "Permissions management": [
                "CreateNetworkInterfacePermission",
                "DeleteNetworkInterfacePermission",
                "ModifySnapshotAttribute",
                "ModifyVpcEndpointServicePermissions",
                "ResetSnapshotAttribute"
            ],
            "Tagging": [
                "CreateTags",
                "DeleteTags"
            ],
            "List": [
                "DescribeAccountAttributes",
                "DescribeAddresses",
                "DescribeAggregateIdFormat",
                "DescribeAvailabilityZones",
                "DescribeBundleTasks",
                "DescribeByoipCidrs",
                "DescribeCapacityReservations",
                "DescribeCarrierGateways",
                "DescribeClassicLinkInstances",
                "DescribeClientVpnAuthorizationRules",
                "DescribeClientVpnConnections",
                "DescribeClientVpnEndpoints",
                "DescribeClientVpnRoutes",
                "DescribeClientVpnTargetNetworks",
                "DescribeCoipPools",
                "DescribeConversionTasks",
                "DescribeCustomerGateways",
                "DescribeDhcpOptions",
                "DescribeEgressOnlyInternetGateways",
                "DescribeExportImageTasks",
                "DescribeExportTasks",
                "DescribeFleetHistory",
                "DescribeFleetInstances",
                "DescribeFleets",
                "DescribeFlowLogs",
                "DescribeFpgaImageAttribute",
                "DescribeFpgaImages",
                "DescribeHostReservationOfferings",
                "DescribeHostReservations",
                "DescribeHosts",
                "DescribeIamInstanceProfileAssociations",
                "DescribeIdFormat",
                "DescribeIdentityIdFormat",
                "DescribeImageAttribute",
                "DescribeImages",
                "DescribeImportImageTasks",
                "DescribeImportSnapshotTasks",
                "DescribeInstanceAttribute",
                "DescribeInstanceCreditSpecifications",
                "DescribeInstanceEventNotificationAttributes",
                "DescribeInstanceStatus",
                "DescribeInstanceTypeOfferings",
                "DescribeInstanceTypes",
                "DescribeInstances",
                "DescribeInternetGateways",
                "DescribeKeyPairs",
                "DescribeLaunchTemplateVersions",
                "DescribeLaunchTemplates",
                "DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociations",
                "DescribeLocalGatewayRouteTableVpcAssociations",
                "DescribeLocalGatewayRouteTables",
                "DescribeLocalGatewayVirtualInterfaceGroups",
                "DescribeLocalGatewayVirtualInterfaces",
                "DescribeLocalGateways",
                "DescribeManagedPrefixLists",
                "DescribeMovingAddresses",
                "DescribeNatGateways",
                "DescribeNetworkAcls",
                "DescribeNetworkInterfaceAttribute",
                "DescribeNetworkInterfacePermissions",
                "DescribeNetworkInterfaces",
                "DescribePlacementGroups",
                "DescribePrefixLists",
                "DescribePrincipalIdFormat",
                "DescribePublicIpv4Pools",
                "DescribeRegions",
                "DescribeReservedInstances",
                "DescribeReservedInstancesListings",
                "DescribeReservedInstancesModifications",
                "DescribeReservedInstancesOfferings",
                "DescribeRouteTables",
                "DescribeSecurityGroupReferences",
                "DescribeSecurityGroups",
                "DescribeSnapshotAttribute",
                "DescribeSnapshots",
                "DescribeSpotDatafeedSubscription",
                "DescribeSpotFleetInstances",
                "DescribeSpotFleetRequestHistory",
                "DescribeSpotFleetRequests",
                "DescribeSpotInstanceRequests",
                "DescribeSpotPriceHistory",
                "DescribeStaleSecurityGroups",
                "DescribeSubnets",
                "DescribeTrafficMirrorFilters",
                "DescribeTrafficMirrorSessions",
                "DescribeTrafficMirrorTargets",
                "DescribeTransitGatewayAttachments",
                "DescribeTransitGatewayMulticastDomains",
                "DescribeTransitGatewayPeeringAttachments",
                "DescribeTransitGatewayRouteTables",
                "DescribeTransitGatewayVpcAttachments",
                "DescribeTransitGateways",
                "DescribeVolumeAttribute",
                "DescribeVolumeStatus",
                "DescribeVolumes",
                "DescribeVpcAttribute",
                "DescribeVpcClassicLink",
                "DescribeVpcClassicLinkDnsSupport",
                "DescribeVpcEndpointConnectionNotifications",
                "DescribeVpcEndpointConnections",
                "DescribeVpcEndpointServiceConfigurations",
                "DescribeVpcEndpointServicePermissions",
                "DescribeVpcEndpointServices",
                "DescribeVpcEndpoints",
                "DescribeVpcPeeringConnections",
                "DescribeVpcs",
                "DescribeVpnGateways",
                "ExportClientVpnClientCertificateRevocationList",
                "ExportClientVpnClientConfiguration",
                "GetTransitGatewayAttachmentPropagations",
                "GetTransitGatewayMulticastDomainAssociations",
                "GetTransitGatewayPrefixListReferences",
                "GetTransitGatewayRouteTableAssociations",
                "GetTransitGatewayRouteTablePropagations",
                "SearchLocalGatewayRoutes",
                "SearchTransitGatewayMulticastGroups",
                "SearchTransitGatewayRoutes"
            ],
            "Read": [
                "DescribeElasticGpus",
                "DescribeFastSnapshotRestores",
                "DescribeScheduledInstanceAvailability",
                "DescribeScheduledInstances",
                "DescribeTags",
                "DescribeVolumesModifications",
                "DescribeVpnConnections",
                "GetCapacityReservationUsage",
                "GetCoipPoolUsage",
                "GetConsoleOutput",
                "GetConsoleScreenshot",
                "GetDefaultCreditSpecification",
                "GetEbsDefaultKmsKeyId",
                "GetEbsEncryptionByDefault",
                "GetHostReservationPurchasePreview",
                "GetLaunchTemplateData",
                "GetManagedPrefixListAssociations",
                "GetManagedPrefixListEntries",
                "GetPasswordData",
                "GetReservedInstancesExchangeQuote"
            ]
        };
    }
    /**
     * Grants permission to accept a Convertible Reserved Instance exchange quote
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_AcceptReservedInstancesExchangeQuote.html
     */
    toAcceptReservedInstancesExchangeQuote() {
        this.to('ec2:AcceptReservedInstancesExchangeQuote');
        return this;
    }
    /**
     * Grants permission to accept a transit gateway peering attachment request
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_AcceptTransitGatewayPeeringAttachment.html
     */
    toAcceptTransitGatewayPeeringAttachment() {
        this.to('ec2:AcceptTransitGatewayPeeringAttachment');
        return this;
    }
    /**
     * Grants permission to accept a request to attach a VPC to a transit gateway
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_AcceptTransitGatewayVpcAttachment.html
     */
    toAcceptTransitGatewayVpcAttachment() {
        this.to('ec2:AcceptTransitGatewayVpcAttachment');
        return this;
    }
    /**
     * Grants permission to accept one or more interface VPC endpoint connections to your VPC endpoint service
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_AcceptVpcEndpointConnections.html
     */
    toAcceptVpcEndpointConnections() {
        this.to('ec2:AcceptVpcEndpointConnections');
        return this;
    }
    /**
     * Grants permission to accept a VPC peering connection request
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_AcceptVpcPeeringConnection.html
     */
    toAcceptVpcPeeringConnection() {
        this.to('ec2:AcceptVpcPeeringConnection');
        return this;
    }
    /**
     * Grants permission to advertise an IP address range that is provisioned for use in AWS through bring your own IP addresses (BYOIP)
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_AdvertiseByoipCidr.html
     */
    toAdvertiseByoipCidr() {
        this.to('ec2:AdvertiseByoipCidr');
        return this;
    }
    /**
     * Grants permission to allocate an Elastic IP address (EIP) to your account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_AllocateAddress.html
     */
    toAllocateAddress() {
        this.to('ec2:AllocateAddress');
        return this;
    }
    /**
     * Grants permission to allocate a Dedicated Host to your account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_AllocateHosts.html
     */
    toAllocateHosts() {
        this.to('ec2:AllocateHosts');
        return this;
    }
    /**
     * Grants permission to apply a security group to the association between a Client VPN endpoint and a target network
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ApplySecurityGroupsToClientVpnTargetNetwork.html
     */
    toApplySecurityGroupsToClientVpnTargetNetwork() {
        this.to('ec2:ApplySecurityGroupsToClientVpnTargetNetwork');
        return this;
    }
    /**
     * Grants permission to assign one or more IPv6 addresses to a network interface
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_AssignIpv6Addresses.html
     */
    toAssignIpv6Addresses() {
        this.to('ec2:AssignIpv6Addresses');
        return this;
    }
    /**
     * Grants permission to assign one or more secondary private IP addresses to a network interface
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_AssignPrivateIpAddresses.html
     */
    toAssignPrivateIpAddresses() {
        this.to('ec2:AssignPrivateIpAddresses');
        return this;
    }
    /**
     * Grants permission to associate an Elastic IP address (EIP) with an instance or a network interface
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_AssociateAddress.html
     */
    toAssociateAddress() {
        this.to('ec2:AssociateAddress');
        return this;
    }
    /**
     * Grants permission to associate a target network with a Client VPN endpoint
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_AssociateClientVpnTargetNetwork.html
     */
    toAssociateClientVpnTargetNetwork() {
        this.to('ec2:AssociateClientVpnTargetNetwork');
        return this;
    }
    /**
     * Grants permission to associate or disassociate a set of DHCP options with a VPC
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_AssociateDhcpOptions.html
     */
    toAssociateDhcpOptions() {
        this.to('ec2:AssociateDhcpOptions');
        return this;
    }
    /**
     * Grants permission to associate an IAM instance profile with a running or stopped instance
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - iam:PassRole
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_AssociateIamInstanceProfile.html
     */
    toAssociateIamInstanceProfile() {
        this.to('ec2:AssociateIamInstanceProfile');
        return this;
    }
    /**
     * Grants permission to associate a subnet or gateway with a route table
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_AssociateRouteTable.html
     */
    toAssociateRouteTable() {
        this.to('ec2:AssociateRouteTable');
        return this;
    }
    /**
     * Grants permission to associate a CIDR block with a subnet
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_AssociateSubnetCidrBlock.html
     */
    toAssociateSubnetCidrBlock() {
        this.to('ec2:AssociateSubnetCidrBlock');
        return this;
    }
    /**
     * Grants permission to associate an attachment and list of subnets with a transit gateway multicast domain
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_AssociateTransitGatewayMulticastDomain.html
     */
    toAssociateTransitGatewayMulticastDomain() {
        this.to('ec2:AssociateTransitGatewayMulticastDomain');
        return this;
    }
    /**
     * Grants permission to associate an attachment with a transit gateway route table
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_AssociateTransitGatewayRouteTable.html
     */
    toAssociateTransitGatewayRouteTable() {
        this.to('ec2:AssociateTransitGatewayRouteTable');
        return this;
    }
    /**
     * Grants permission to associate a CIDR block with a VPC
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_AssociateVpcCidrBlock.html
     */
    toAssociateVpcCidrBlock() {
        this.to('ec2:AssociateVpcCidrBlock');
        return this;
    }
    /**
     * Grants permission to link an EC2-Classic instance to a ClassicLink-enabled VPC through one or more of the VPC's security groups
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_AttachClassicLinkVpc.html
     */
    toAttachClassicLinkVpc() {
        this.to('ec2:AttachClassicLinkVpc');
        return this;
    }
    /**
     * Grants permission to attach an internet gateway to a VPC
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_AttachInternetGateway.html
     */
    toAttachInternetGateway() {
        this.to('ec2:AttachInternetGateway');
        return this;
    }
    /**
     * Grants permission to attach a network interface to an instance
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_AttachNetworkInterface.html
     */
    toAttachNetworkInterface() {
        this.to('ec2:AttachNetworkInterface');
        return this;
    }
    /**
     * Grants permission to attach an EBS volume to a running or stopped instance and expose it to the instance with the specified device name
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_AttachVolume.html
     */
    toAttachVolume() {
        this.to('ec2:AttachVolume');
        return this;
    }
    /**
     * Grants permission to attach a virtual private gateway to a VPC
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_AttachVpnGateway.html
     */
    toAttachVpnGateway() {
        this.to('ec2:AttachVpnGateway');
        return this;
    }
    /**
     * Grants permission to add an inbound authorization rule to a Client VPN endpoint
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_AuthorizeClientVpnIngress.html
     */
    toAuthorizeClientVpnIngress() {
        this.to('ec2:AuthorizeClientVpnIngress');
        return this;
    }
    /**
     * Grants permission to add one or more outbound rules to a VPC security group
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_AuthorizeSecurityGroupEgress.html
     */
    toAuthorizeSecurityGroupEgress() {
        this.to('ec2:AuthorizeSecurityGroupEgress');
        return this;
    }
    /**
     * Grants permission to add one or more inbound rules to a security group
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_AuthorizeSecurityGroupIngress.html
     */
    toAuthorizeSecurityGroupIngress() {
        this.to('ec2:AuthorizeSecurityGroupIngress');
        return this;
    }
    /**
     * Grants permission to bundle an instance store-backed Windows instance
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_BundleInstance.html
     */
    toBundleInstance() {
        this.to('ec2:BundleInstance');
        return this;
    }
    /**
     * Grants permission to cancel a bundling operation
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CancelBundleTask.html
     */
    toCancelBundleTask() {
        this.to('ec2:CancelBundleTask');
        return this;
    }
    /**
     * Grants permission to cancel a Capacity Reservation and release the reserved capacity
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CancelCapacityReservation.html
     */
    toCancelCapacityReservation() {
        this.to('ec2:CancelCapacityReservation');
        return this;
    }
    /**
     * Grants permission to cancel an active conversion task
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CancelConversionTask.html
     */
    toCancelConversionTask() {
        this.to('ec2:CancelConversionTask');
        return this;
    }
    /**
     * Grants permission to cancel an active export task
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CancelExportTask.html
     */
    toCancelExportTask() {
        this.to('ec2:CancelExportTask');
        return this;
    }
    /**
     * Grants permission to cancel an in-process import virtual machine or import snapshot task
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CancelImportTask.html
     */
    toCancelImportTask() {
        this.to('ec2:CancelImportTask');
        return this;
    }
    /**
     * Grants permission to cancel a Reserved Instance listing on the Reserved Instance Marketplace
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CancelReservedInstancesListing.html
     */
    toCancelReservedInstancesListing() {
        this.to('ec2:CancelReservedInstancesListing');
        return this;
    }
    /**
     * Grants permission to cancel one or more Spot Fleet requests
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CancelSpotFleetRequests.html
     */
    toCancelSpotFleetRequests() {
        this.to('ec2:CancelSpotFleetRequests');
        return this;
    }
    /**
     * Grants permission to cancel one or more Spot Instance requests
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CancelSpotInstanceRequests.html
     */
    toCancelSpotInstanceRequests() {
        this.to('ec2:CancelSpotInstanceRequests');
        return this;
    }
    /**
     * Grants permission to determine whether an owned product code is associated with an instance
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ConfirmProductInstance.html
     */
    toConfirmProductInstance() {
        this.to('ec2:ConfirmProductInstance');
        return this;
    }
    /**
     * Grants permission to copy a source Amazon FPGA image (AFI) to the current Region
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CopyFpgaImage.html
     */
    toCopyFpgaImage() {
        this.to('ec2:CopyFpgaImage');
        return this;
    }
    /**
     * Grants permission to copy an Amazon Machine Image (AMI) from a source Region to the current Region
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CopyImage.html
     */
    toCopyImage() {
        this.to('ec2:CopyImage');
        return this;
    }
    /**
     * Grants permission to copy a point-in-time snapshot of an EBS volume and store it in Amazon S3
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CopySnapshot.html
     */
    toCopySnapshot() {
        this.to('ec2:CopySnapshot');
        return this;
    }
    /**
     * Grants permission to create a Capacity Reservation
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateCapacityReservation.html
     */
    toCreateCapacityReservation() {
        this.to('ec2:CreateCapacityReservation');
        return this;
    }
    /**
     * Grants permission to create a carrier gateway and provides CSP connectivity to VPC customers.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateCarrierGateway.html
     */
    toCreateCarrierGateway() {
        this.to('ec2:CreateCarrierGateway');
        return this;
    }
    /**
     * Grants permission to create a Client VPN endpoint
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateClientVpnEndpoint.html
     */
    toCreateClientVpnEndpoint() {
        this.to('ec2:CreateClientVpnEndpoint');
        return this;
    }
    /**
     * Grants permission to add a network route to a Client VPN endpoint's route table
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateClientVpnRoute.html
     */
    toCreateClientVpnRoute() {
        this.to('ec2:CreateClientVpnRoute');
        return this;
    }
    /**
     * Grants permission to create a customer gateway, which provides information to AWS about your customer gateway device
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateCustomerGateway.html
     */
    toCreateCustomerGateway() {
        this.to('ec2:CreateCustomerGateway');
        return this;
    }
    /**
     * Grants permission to create a default subnet in a specified Availability Zone in a default VPC
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateDefaultSubnet.html
     */
    toCreateDefaultSubnet() {
        this.to('ec2:CreateDefaultSubnet');
        return this;
    }
    /**
     * Grants permission to create a default VPC with a default subnet in each Availability Zone
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateDefaultVpc.html
     */
    toCreateDefaultVpc() {
        this.to('ec2:CreateDefaultVpc');
        return this;
    }
    /**
     * Grants permission to create a set of DHCP options for a VPC
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateDhcpOptions.html
     */
    toCreateDhcpOptions() {
        this.to('ec2:CreateDhcpOptions');
        return this;
    }
    /**
     * Grants permission to create an egress-only internet gateway for a VPC
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateEgressOnlyInternetGateway.html
     */
    toCreateEgressOnlyInternetGateway() {
        this.to('ec2:CreateEgressOnlyInternetGateway');
        return this;
    }
    /**
     * Grants permission to launch an EC2 Fleet
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateFleet.html
     */
    toCreateFleet() {
        this.to('ec2:CreateFleet');
        return this;
    }
    /**
     * Grants permission to create one or more flow logs to capture IP traffic for a network interface
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - iam:PassRole
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateFlowLogs.html
     */
    toCreateFlowLogs() {
        this.to('ec2:CreateFlowLogs');
        return this;
    }
    /**
     * Grants permission to create an Amazon FPGA Image (AFI) from a design checkpoint (DCP)
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateFpgaImage.html
     */
    toCreateFpgaImage() {
        this.to('ec2:CreateFpgaImage');
        return this;
    }
    /**
     * Grants permission to create an Amazon EBS-backed AMI from a stopped or running Amazon EBS-backed instance
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateImage.html
     */
    toCreateImage() {
        this.to('ec2:CreateImage');
        return this;
    }
    /**
     * Grants permission to export a running or stopped instance to an Amazon S3 bucket
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateInstanceExportTask.html
     */
    toCreateInstanceExportTask() {
        this.to('ec2:CreateInstanceExportTask');
        return this;
    }
    /**
     * Grants permission to create an internet gateway for a VPC
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateInternetGateway.html
     */
    toCreateInternetGateway() {
        this.to('ec2:CreateInternetGateway');
        return this;
    }
    /**
     * Grants permission to create a 2048-bit RSA key pair
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateKeyPair.html
     */
    toCreateKeyPair() {
        this.to('ec2:CreateKeyPair');
        return this;
    }
    /**
     * Grants permission to create a launch template
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateLaunchTemplate.html
     */
    toCreateLaunchTemplate() {
        this.to('ec2:CreateLaunchTemplate');
        return this;
    }
    /**
     * Grants permission to create a new version of a launch template
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateLaunchTemplateVersion.html
     */
    toCreateLaunchTemplateVersion() {
        this.to('ec2:CreateLaunchTemplateVersion');
        return this;
    }
    /**
     * Grants permission to create a static route for a local gateway route table
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateLocalGatewayRoute.html
     */
    toCreateLocalGatewayRoute() {
        this.to('ec2:CreateLocalGatewayRoute');
        return this;
    }
    /**
     * Grants permission to associate a VPC with a local gateway route table
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateLocalGatewayRouteTableVpcAssociation.html
     */
    toCreateLocalGatewayRouteTableVpcAssociation() {
        this.to('ec2:CreateLocalGatewayRouteTableVpcAssociation');
        return this;
    }
    /**
     * Grants permission to create a managed prefix list
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateManagedPrefixList.html
     */
    toCreateManagedPrefixList() {
        this.to('ec2:CreateManagedPrefixList');
        return this;
    }
    /**
     * Grants permission to create a NAT gateway in a subnet
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateNatGateway.html
     */
    toCreateNatGateway() {
        this.to('ec2:CreateNatGateway');
        return this;
    }
    /**
     * Grants permission to create a network ACL in a VPC
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateNetworkAcl.html
     */
    toCreateNetworkAcl() {
        this.to('ec2:CreateNetworkAcl');
        return this;
    }
    /**
     * Grants permission to create a numbered entry (a rule) in a network ACL
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateNetworkAclEntry.html
     */
    toCreateNetworkAclEntry() {
        this.to('ec2:CreateNetworkAclEntry');
        return this;
    }
    /**
     * Grants permission to create a network interface in a subnet
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateNetworkInterface.html
     */
    toCreateNetworkInterface() {
        this.to('ec2:CreateNetworkInterface');
        return this;
    }
    /**
     * Grants permission to create a permission for an AWS-authorized user to perform certain operations on a network interface
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateNetworkInterfacePermission.html
     */
    toCreateNetworkInterfacePermission() {
        this.to('ec2:CreateNetworkInterfacePermission');
        return this;
    }
    /**
     * Grants permission to create a placement group
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreatePlacementGroup.html
     */
    toCreatePlacementGroup() {
        this.to('ec2:CreatePlacementGroup');
        return this;
    }
    /**
     * Grants permission to create a listing for Standard Reserved Instances to be sold in the Reserved Instance Marketplace
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateReservedInstancesListing.html
     */
    toCreateReservedInstancesListing() {
        this.to('ec2:CreateReservedInstancesListing');
        return this;
    }
    /**
     * Grants permission to create a route in a VPC route table
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateRoute.html
     */
    toCreateRoute() {
        this.to('ec2:CreateRoute');
        return this;
    }
    /**
     * Grants permission to create a route table for a VPC
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateRouteTable.html
     */
    toCreateRouteTable() {
        this.to('ec2:CreateRouteTable');
        return this;
    }
    /**
     * Grants permission to create a security group
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateSecurityGroup.html
     */
    toCreateSecurityGroup() {
        this.to('ec2:CreateSecurityGroup');
        return this;
    }
    /**
     * Grants permission to create a snapshot of an EBS volume and store it in Amazon S3
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateSnapshot.html
     */
    toCreateSnapshot() {
        this.to('ec2:CreateSnapshot');
        return this;
    }
    /**
     * Grants permission to create crash-consistent snapshots of multiple EBS volumes and store them in Amazon S3
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateSnapshots.html
     */
    toCreateSnapshots() {
        this.to('ec2:CreateSnapshots');
        return this;
    }
    /**
     * Grants permission to create a data feed for Spot Instances to view Spot Instance usage logs
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateSpotDatafeedSubscription.html
     */
    toCreateSpotDatafeedSubscription() {
        this.to('ec2:CreateSpotDatafeedSubscription');
        return this;
    }
    /**
     * Grants permission to create a subnet in a VPC
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateSubnet.html
     */
    toCreateSubnet() {
        this.to('ec2:CreateSubnet');
        return this;
    }
    /**
     * Grants permission to add or overwrite one or more tags for Amazon EC2 resources
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifCreateAction()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateTags.html
     */
    toCreateTags() {
        this.to('ec2:CreateTags');
        return this;
    }
    /**
     * Grants permission to create a traffic mirror filter
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateTrafficMirrorFilter.html
     */
    toCreateTrafficMirrorFilter() {
        this.to('ec2:CreateTrafficMirrorFilter');
        return this;
    }
    /**
     * Grants permission to create a traffic mirror filter rule
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateTrafficMirrorFilterRule.html
     */
    toCreateTrafficMirrorFilterRule() {
        this.to('ec2:CreateTrafficMirrorFilterRule');
        return this;
    }
    /**
     * Grants permission to create a traffic mirror session
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateTrafficMirrorSession.html
     */
    toCreateTrafficMirrorSession() {
        this.to('ec2:CreateTrafficMirrorSession');
        return this;
    }
    /**
     * Grants permission to create a traffic mirror target
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateTrafficMirrorTarget.html
     */
    toCreateTrafficMirrorTarget() {
        this.to('ec2:CreateTrafficMirrorTarget');
        return this;
    }
    /**
     * Grants permission to create a transit gateway
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateTransitGateway.html
     */
    toCreateTransitGateway() {
        this.to('ec2:CreateTransitGateway');
        return this;
    }
    /**
     * Grants permission to create a multicast domain for a transit gateway
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateTransitGatewayMulticastDomain.html
     */
    toCreateTransitGatewayMulticastDomain() {
        this.to('ec2:CreateTransitGatewayMulticastDomain');
        return this;
    }
    /**
     * Grants permission to request a transit gateway peering attachment between a requester and accepter transit gateway
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateTransitGatewayPeeringAttachment.html
     */
    toCreateTransitGatewayPeeringAttachment() {
        this.to('ec2:CreateTransitGatewayPeeringAttachment');
        return this;
    }
    /**
     * Grants permission to create a transit gateway prefix list reference
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateTransitGatewayPrefixListReference.html
     */
    toCreateTransitGatewayPrefixListReference() {
        this.to('ec2:CreateTransitGatewayPrefixListReference');
        return this;
    }
    /**
     * Grants permission to create a static route for a transit gateway route table
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateTransitGatewayRoute.html
     */
    toCreateTransitGatewayRoute() {
        this.to('ec2:CreateTransitGatewayRoute');
        return this;
    }
    /**
     * Grants permission to create a route table for a transit gateway
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateTransitGatewayRouteTable.html
     */
    toCreateTransitGatewayRouteTable() {
        this.to('ec2:CreateTransitGatewayRouteTable');
        return this;
    }
    /**
     * Grants permission to attach a VPC to a transit gateway
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateTransitGatewayVpcAttachment.html
     */
    toCreateTransitGatewayVpcAttachment() {
        this.to('ec2:CreateTransitGatewayVpcAttachment');
        return this;
    }
    /**
     * Grants permission to create an EBS volume
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateVolume.html
     */
    toCreateVolume() {
        this.to('ec2:CreateVolume');
        return this;
    }
    /**
     * Grants permission to create a VPC with a specified CIDR block
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateVpc.html
     */
    toCreateVpc() {
        this.to('ec2:CreateVpc');
        return this;
    }
    /**
     * Grants permission to create a VPC endpoint for an AWS service
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - route53:AssociateVPCWithHostedZone
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateVpcEndpoint.html
     */
    toCreateVpcEndpoint() {
        this.to('ec2:CreateVpcEndpoint');
        return this;
    }
    /**
     * Grants permission to create a connection notification for a VPC endpoint or VPC endpoint service
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateVpcEndpointConnectionNotification.html
     */
    toCreateVpcEndpointConnectionNotification() {
        this.to('ec2:CreateVpcEndpointConnectionNotification');
        return this;
    }
    /**
     * Grants permission to create a VPC endpoint service configuration to which service consumers (AWS accounts, IAM users, and IAM roles) can connect
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateVpcEndpointServiceConfiguration.html
     */
    toCreateVpcEndpointServiceConfiguration() {
        this.to('ec2:CreateVpcEndpointServiceConfiguration');
        return this;
    }
    /**
     * Grants permission to request a VPC peering connection between two VPCs
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateVpcPeeringConnection.html
     */
    toCreateVpcPeeringConnection() {
        this.to('ec2:CreateVpcPeeringConnection');
        return this;
    }
    /**
     * Grants permission to create a VPN connection between a virtual private gateway or transit gateway and a customer gateway
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateVpnConnection.html
     */
    toCreateVpnConnection() {
        this.to('ec2:CreateVpnConnection');
        return this;
    }
    /**
     * Grants permission to create a static route for a VPN connection between a virtual private gateway and a customer gateway
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateVpnConnectionRoute.html
     */
    toCreateVpnConnectionRoute() {
        this.to('ec2:CreateVpnConnectionRoute');
        return this;
    }
    /**
     * Grants permission to create a virtual private gateway
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateVpnGateway.html
     */
    toCreateVpnGateway() {
        this.to('ec2:CreateVpnGateway');
        return this;
    }
    /**
     * Grants permission to delete a carrier gateway
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeleteCarrierGateway.html
     */
    toDeleteCarrierGateway() {
        this.to('ec2:DeleteCarrierGateway');
        return this;
    }
    /**
     * Grants permission to delete a Client VPN endpoint
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeleteClientVpnEndpoint.html
     */
    toDeleteClientVpnEndpoint() {
        this.to('ec2:DeleteClientVpnEndpoint');
        return this;
    }
    /**
     * Grants permission to delete a route from a Client VPN endpoint
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeleteClientVpnRoute.html
     */
    toDeleteClientVpnRoute() {
        this.to('ec2:DeleteClientVpnRoute');
        return this;
    }
    /**
     * Grants permission to delete a customer gateway
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeleteCustomerGateway.html
     */
    toDeleteCustomerGateway() {
        this.to('ec2:DeleteCustomerGateway');
        return this;
    }
    /**
     * Grants permission to delete a set of DHCP options
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeleteDhcpOptions.html
     */
    toDeleteDhcpOptions() {
        this.to('ec2:DeleteDhcpOptions');
        return this;
    }
    /**
     * Grants permission to delete an egress-only internet gateway
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeleteEgressOnlyInternetGateway.html
     */
    toDeleteEgressOnlyInternetGateway() {
        this.to('ec2:DeleteEgressOnlyInternetGateway');
        return this;
    }
    /**
     * Grants permission to delete one or more EC2 Fleets
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeleteFleets.html
     */
    toDeleteFleets() {
        this.to('ec2:DeleteFleets');
        return this;
    }
    /**
     * Grants permission to delete one or more flow logs
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeleteFlowLogs.html
     */
    toDeleteFlowLogs() {
        this.to('ec2:DeleteFlowLogs');
        return this;
    }
    /**
     * Grants permission to delete an Amazon FPGA Image (AFI)
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeleteFpgaImage.html
     */
    toDeleteFpgaImage() {
        this.to('ec2:DeleteFpgaImage');
        return this;
    }
    /**
     * Grants permission to delete an internet gateway
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeleteInternetGateway.html
     */
    toDeleteInternetGateway() {
        this.to('ec2:DeleteInternetGateway');
        return this;
    }
    /**
     * Grants permission to delete a key pair by removing the public key from Amazon EC2
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeleteKeyPair.html
     */
    toDeleteKeyPair() {
        this.to('ec2:DeleteKeyPair');
        return this;
    }
    /**
     * Grants permission to delete a launch template and its associated versions
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeleteLaunchTemplate.html
     */
    toDeleteLaunchTemplate() {
        this.to('ec2:DeleteLaunchTemplate');
        return this;
    }
    /**
     * Grants permission to delete one or more versions of a launch template
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeleteLaunchTemplateVersions.html
     */
    toDeleteLaunchTemplateVersions() {
        this.to('ec2:DeleteLaunchTemplateVersions');
        return this;
    }
    /**
     * Grants permission to delete a route from a local gateway route table
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeleteLocalGatewayRoute.html
     */
    toDeleteLocalGatewayRoute() {
        this.to('ec2:DeleteLocalGatewayRoute');
        return this;
    }
    /**
     * Grants permission to delete an association between a VPC and local gateway route table
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeleteLocalGatewayRouteTableVpcAssociation.html
     */
    toDeleteLocalGatewayRouteTableVpcAssociation() {
        this.to('ec2:DeleteLocalGatewayRouteTableVpcAssociation');
        return this;
    }
    /**
     * Grants permission to delete a managed prefix list
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeleteManagedPrefixList.html
     */
    toDeleteManagedPrefixList() {
        this.to('ec2:DeleteManagedPrefixList');
        return this;
    }
    /**
     * Grants permission to delete a NAT gateway
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeleteNatGateway.html
     */
    toDeleteNatGateway() {
        this.to('ec2:DeleteNatGateway');
        return this;
    }
    /**
     * Grants permission to delete a network ACL
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeleteNetworkAcl.html
     */
    toDeleteNetworkAcl() {
        this.to('ec2:DeleteNetworkAcl');
        return this;
    }
    /**
     * Grants permission to delete an inbound or outbound entry (rule) from a network ACL
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeleteNetworkAclEntry.html
     */
    toDeleteNetworkAclEntry() {
        this.to('ec2:DeleteNetworkAclEntry');
        return this;
    }
    /**
     * Grants permission to delete a detached network interface
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeleteNetworkInterface.html
     */
    toDeleteNetworkInterface() {
        this.to('ec2:DeleteNetworkInterface');
        return this;
    }
    /**
     * Grants permission to delete a permission that is associated with a network interface
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeleteNetworkInterfacePermission.html
     */
    toDeleteNetworkInterfacePermission() {
        this.to('ec2:DeleteNetworkInterfacePermission');
        return this;
    }
    /**
     * Grants permission to delete a placement group
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeletePlacementGroup.html
     */
    toDeletePlacementGroup() {
        this.to('ec2:DeletePlacementGroup');
        return this;
    }
    /**
     * Grants permission to delete a route from a route table
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeleteRoute.html
     */
    toDeleteRoute() {
        this.to('ec2:DeleteRoute');
        return this;
    }
    /**
     * Grants permission to delete a route table
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeleteRouteTable.html
     */
    toDeleteRouteTable() {
        this.to('ec2:DeleteRouteTable');
        return this;
    }
    /**
     * Grants permission to delete a security group
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeleteSecurityGroup.html
     */
    toDeleteSecurityGroup() {
        this.to('ec2:DeleteSecurityGroup');
        return this;
    }
    /**
     * Grants permission to delete a snapshot of an EBS volume
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeleteSnapshot.html
     */
    toDeleteSnapshot() {
        this.to('ec2:DeleteSnapshot');
        return this;
    }
    /**
     * Grants permission to delete a data feed for Spot Instances
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeleteSpotDatafeedSubscription.html
     */
    toDeleteSpotDatafeedSubscription() {
        this.to('ec2:DeleteSpotDatafeedSubscription');
        return this;
    }
    /**
     * Grants permission to delete a subnet
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeleteSubnet.html
     */
    toDeleteSubnet() {
        this.to('ec2:DeleteSubnet');
        return this;
    }
    /**
     * Grants permission to delete one or more tags from Amazon EC2 resources
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeleteTags.html
     */
    toDeleteTags() {
        this.to('ec2:DeleteTags');
        return this;
    }
    /**
     * Grants permission to delete a traffic mirror filter
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeleteTrafficMirrorFilter.html
     */
    toDeleteTrafficMirrorFilter() {
        this.to('ec2:DeleteTrafficMirrorFilter');
        return this;
    }
    /**
     * Grants permission to delete a traffic mirror filter rule
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeleteTrafficMirrorFilterRule.html
     */
    toDeleteTrafficMirrorFilterRule() {
        this.to('ec2:DeleteTrafficMirrorFilterRule');
        return this;
    }
    /**
     * Grants permission to delete a traffic mirror session
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeleteTrafficMirrorSession.html
     */
    toDeleteTrafficMirrorSession() {
        this.to('ec2:DeleteTrafficMirrorSession');
        return this;
    }
    /**
     * Grants permission to delete a traffic mirror target
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeleteTrafficMirrorTarget.html
     */
    toDeleteTrafficMirrorTarget() {
        this.to('ec2:DeleteTrafficMirrorTarget');
        return this;
    }
    /**
     * Grants permission to delete a transit gateway
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeleteTransitGateway.html
     */
    toDeleteTransitGateway() {
        this.to('ec2:DeleteTransitGateway');
        return this;
    }
    /**
     * Grants permissions to delete a transit gateway multicast domain
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeleteTransitGatewayMulticastDomain.html
     */
    toDeleteTransitGatewayMulticastDomain() {
        this.to('ec2:DeleteTransitGatewayMulticastDomain');
        return this;
    }
    /**
     * Grants permission to delete a peering attachment from a transit gateway
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeleteTransitGatewayPeeringAttachment.html
     */
    toDeleteTransitGatewayPeeringAttachment() {
        this.to('ec2:DeleteTransitGatewayPeeringAttachment');
        return this;
    }
    /**
     * Grants permission to delete a transit gateway prefix list reference
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeleteTransitGatewayPrefixListReference.html
     */
    toDeleteTransitGatewayPrefixListReference() {
        this.to('ec2:DeleteTransitGatewayPrefixListReference');
        return this;
    }
    /**
     * Grants permission to delete a route from a transit gateway route table
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeleteTransitGatewayRoute.html
     */
    toDeleteTransitGatewayRoute() {
        this.to('ec2:DeleteTransitGatewayRoute');
        return this;
    }
    /**
     * Grants permission to delete a transit gateway route table
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeleteTransitGatewayRouteTable.html
     */
    toDeleteTransitGatewayRouteTable() {
        this.to('ec2:DeleteTransitGatewayRouteTable');
        return this;
    }
    /**
     * Grants permission to delete a VPC attachment from a transit gateway
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeleteTransitGatewayVpcAttachment.html
     */
    toDeleteTransitGatewayVpcAttachment() {
        this.to('ec2:DeleteTransitGatewayVpcAttachment');
        return this;
    }
    /**
     * Grants permission to delete an EBS volume
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeleteVolume.html
     */
    toDeleteVolume() {
        this.to('ec2:DeleteVolume');
        return this;
    }
    /**
     * Grants permission to delete a VPC
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeleteVpc.html
     */
    toDeleteVpc() {
        this.to('ec2:DeleteVpc');
        return this;
    }
    /**
     * Grants permission to delete one or more VPC endpoint connection notifications
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeleteVpcEndpointConnectionNotifications.html
     */
    toDeleteVpcEndpointConnectionNotifications() {
        this.to('ec2:DeleteVpcEndpointConnectionNotifications');
        return this;
    }
    /**
     * Grants permission to delete one or more VPC endpoint service configurations
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeleteVpcEndpointServiceConfigurations.html
     */
    toDeleteVpcEndpointServiceConfigurations() {
        this.to('ec2:DeleteVpcEndpointServiceConfigurations');
        return this;
    }
    /**
     * Grants permission to delete one or more VPC endpoints
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeleteVpcEndpoints.html
     */
    toDeleteVpcEndpoints() {
        this.to('ec2:DeleteVpcEndpoints');
        return this;
    }
    /**
     * Grants permission to delete a VPC peering connection
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeleteVpcPeeringConnection.html
     */
    toDeleteVpcPeeringConnection() {
        this.to('ec2:DeleteVpcPeeringConnection');
        return this;
    }
    /**
     * Grants permission to delete a VPN connection
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeleteVpnConnection.html
     */
    toDeleteVpnConnection() {
        this.to('ec2:DeleteVpnConnection');
        return this;
    }
    /**
     * Grants permission to delete a static route for a VPN connection between a virtual private gateway and a customer gateway
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeleteVpnConnectionRoute.html
     */
    toDeleteVpnConnectionRoute() {
        this.to('ec2:DeleteVpnConnectionRoute');
        return this;
    }
    /**
     * Grants permission to delete a virtual private gateway
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeleteVpnGateway.html
     */
    toDeleteVpnGateway() {
        this.to('ec2:DeleteVpnGateway');
        return this;
    }
    /**
     * Grants permission to release an IP address range that was provisioned through bring your own IP addresses (BYOIP), and to delete the corresponding address pool
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeprovisionByoipCidr.html
     */
    toDeprovisionByoipCidr() {
        this.to('ec2:DeprovisionByoipCidr');
        return this;
    }
    /**
     * Grants permission to deregister an Amazon Machine Image (AMI)
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeregisterImage.html
     */
    toDeregisterImage() {
        this.to('ec2:DeregisterImage');
        return this;
    }
    /**
     * Grants permission to remove tags from the set of tags to include in notifications about scheduled events for your instances
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeregisterInstanceEventNotificationAttributes.html
     */
    toDeregisterInstanceEventNotificationAttributes() {
        this.to('ec2:DeregisterInstanceEventNotificationAttributes');
        return this;
    }
    /**
     * Grants permission to deregister one or more network interface members from a group IP address in a transit gateway multicast domain
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeregisterTransitGatewayMulticastGroupMembers.html
     */
    toDeregisterTransitGatewayMulticastGroupMembers() {
        this.to('ec2:DeregisterTransitGatewayMulticastGroupMembers');
        return this;
    }
    /**
     * Grants permission to deregister one or more network interface sources from a group IP address in a transit gateway multicast domain
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeregisterTransitGatewayMulticastGroupSources.html
     */
    toDeregisterTransitGatewayMulticastGroupSources() {
        this.to('ec2:DeregisterTransitGatewayMulticastGroupSources');
        return this;
    }
    /**
     * Grants permission to describe the attributes of the AWS account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeAccountAttributes.html
     */
    toDescribeAccountAttributes() {
        this.to('ec2:DescribeAccountAttributes');
        return this;
    }
    /**
     * Grants permission to describe one or more Elastic IP addresses
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeAddresses.html
     */
    toDescribeAddresses() {
        this.to('ec2:DescribeAddresses');
        return this;
    }
    /**
     * Grants permission to describe the longer ID format settings for all resource types
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeAggregateIdFormat.html
     */
    toDescribeAggregateIdFormat() {
        this.to('ec2:DescribeAggregateIdFormat');
        return this;
    }
    /**
     * Grants permission to describe one or more of the Availability Zones that are available to you
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeAvailabilityZones.html
     */
    toDescribeAvailabilityZones() {
        this.to('ec2:DescribeAvailabilityZones');
        return this;
    }
    /**
     * Grants permission to describe one or more bundling tasks
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeBundleTasks.html
     */
    toDescribeBundleTasks() {
        this.to('ec2:DescribeBundleTasks');
        return this;
    }
    /**
     * Grants permission to describe the IP address ranges that were provisioned through bring your own IP addresses (BYOIP)
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeByoipCidrs.html
     */
    toDescribeByoipCidrs() {
        this.to('ec2:DescribeByoipCidrs');
        return this;
    }
    /**
     * Grants permission to describe one or more Capacity Reservations
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeCapacityReservations.html
     */
    toDescribeCapacityReservations() {
        this.to('ec2:DescribeCapacityReservations');
        return this;
    }
    /**
     * Grants permission to describe one or more Carrier Gateways
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeCarrierGateways.html
     */
    toDescribeCarrierGateways() {
        this.to('ec2:DescribeCarrierGateways');
        return this;
    }
    /**
     * Grants permission to describe one or more linked EC2-Classic instances
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeClassicLinkInstances.html
     */
    toDescribeClassicLinkInstances() {
        this.to('ec2:DescribeClassicLinkInstances');
        return this;
    }
    /**
     * Grants permission to describe the authorization rules for a Client VPN endpoint
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeClientVpnAuthorizationRules.html
     */
    toDescribeClientVpnAuthorizationRules() {
        this.to('ec2:DescribeClientVpnAuthorizationRules');
        return this;
    }
    /**
     * Grants permission to describe active client connections and connections that have been terminated within the last 60 minutes for a Client VPN endpoint
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeClientVpnConnections.html
     */
    toDescribeClientVpnConnections() {
        this.to('ec2:DescribeClientVpnConnections');
        return this;
    }
    /**
     * Grants permission to describe one or more Client VPN endpoints
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeClientVpnEndpoints.html
     */
    toDescribeClientVpnEndpoints() {
        this.to('ec2:DescribeClientVpnEndpoints');
        return this;
    }
    /**
     * Grants permission to describe the routes for a Client VPN endpoint
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeClientVpnRoutes.html
     */
    toDescribeClientVpnRoutes() {
        this.to('ec2:DescribeClientVpnRoutes');
        return this;
    }
    /**
     * Grants permission to describe the target networks that are associated with a Client VPN endpoint
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeClientVpnTargetNetworks.html
     */
    toDescribeClientVpnTargetNetworks() {
        this.to('ec2:DescribeClientVpnTargetNetworks');
        return this;
    }
    /**
     * Grants permission to describe the specified customer-owned address pools or all of your customer-owned address pools
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeCoipPools.html
     */
    toDescribeCoipPools() {
        this.to('ec2:DescribeCoipPools');
        return this;
    }
    /**
     * Grants permission to describe one or more conversion tasks
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeConversionTasks.html
     */
    toDescribeConversionTasks() {
        this.to('ec2:DescribeConversionTasks');
        return this;
    }
    /**
     * Grants permission to describe one or more customer gateways
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeCustomerGateways.html
     */
    toDescribeCustomerGateways() {
        this.to('ec2:DescribeCustomerGateways');
        return this;
    }
    /**
     * Grants permission to describe one or more DHCP options sets
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeDhcpOptions.html
     */
    toDescribeDhcpOptions() {
        this.to('ec2:DescribeDhcpOptions');
        return this;
    }
    /**
     * Grants permission to describe one or more egress-only internet gateways
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeEgressOnlyInternetGateways.html
     */
    toDescribeEgressOnlyInternetGateways() {
        this.to('ec2:DescribeEgressOnlyInternetGateways');
        return this;
    }
    /**
     * Grants permission to describe an Elastic Graphics accelerator that is associated with an instance
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeElasticGpus.html
     */
    toDescribeElasticGpus() {
        this.to('ec2:DescribeElasticGpus');
        return this;
    }
    /**
     * Grants permission to describe one or more export image tasks
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeExportImageTasks.html
     */
    toDescribeExportImageTasks() {
        this.to('ec2:DescribeExportImageTasks');
        return this;
    }
    /**
     * Grants permission to describe one or more export instance tasks
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeExportTasks.html
     */
    toDescribeExportTasks() {
        this.to('ec2:DescribeExportTasks');
        return this;
    }
    /**
     * Grants permission to describe the state of fast snapshot restores for snapshots
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeFastSnapshotRestores.html
     */
    toDescribeFastSnapshotRestores() {
        this.to('ec2:DescribeFastSnapshotRestores');
        return this;
    }
    /**
     * Grants permission to describe the events for an EC2 Fleet during a specified time
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeFleetHistory.html
     */
    toDescribeFleetHistory() {
        this.to('ec2:DescribeFleetHistory');
        return this;
    }
    /**
     * Grants permission to describe the running instances for an EC2 Fleet
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeFleetInstances.html
     */
    toDescribeFleetInstances() {
        this.to('ec2:DescribeFleetInstances');
        return this;
    }
    /**
     * Grants permission to describe one or more EC2 Fleets
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeFleets.html
     */
    toDescribeFleets() {
        this.to('ec2:DescribeFleets');
        return this;
    }
    /**
     * Grants permission to describe one or more flow logs
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeFlowLogs.html
     */
    toDescribeFlowLogs() {
        this.to('ec2:DescribeFlowLogs');
        return this;
    }
    /**
     * Grants permission to describe the attributes of an Amazon FPGA Image (AFI)
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeFpgaImageAttribute.html
     */
    toDescribeFpgaImageAttribute() {
        this.to('ec2:DescribeFpgaImageAttribute');
        return this;
    }
    /**
     * Grants permission to describe one or more Amazon FPGA Images (AFIs)
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeFpgaImages.html
     */
    toDescribeFpgaImages() {
        this.to('ec2:DescribeFpgaImages');
        return this;
    }
    /**
     * Grants permission to describe the Dedicated Host Reservations that are available to purchase
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeHostReservationOfferings.html
     */
    toDescribeHostReservationOfferings() {
        this.to('ec2:DescribeHostReservationOfferings');
        return this;
    }
    /**
     * Grants permission to describe the Dedicated Host Reservations that are associated with Dedicated Hosts in the AWS account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeHostReservations.html
     */
    toDescribeHostReservations() {
        this.to('ec2:DescribeHostReservations');
        return this;
    }
    /**
     * Grants permission to describe one or more Dedicated Hosts
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeHosts.html
     */
    toDescribeHosts() {
        this.to('ec2:DescribeHosts');
        return this;
    }
    /**
     * Grants permission to describe the IAM instance profile associations
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeIamInstanceProfileAssociations.html
     */
    toDescribeIamInstanceProfileAssociations() {
        this.to('ec2:DescribeIamInstanceProfileAssociations');
        return this;
    }
    /**
     * Grants permission to describe the ID format settings for resources
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeIdFormat.html
     */
    toDescribeIdFormat() {
        this.to('ec2:DescribeIdFormat');
        return this;
    }
    /**
     * Grants permission to describe the ID format settings for resources for an IAM user, IAM role, or root user
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeIdentityIdFormat.html
     */
    toDescribeIdentityIdFormat() {
        this.to('ec2:DescribeIdentityIdFormat');
        return this;
    }
    /**
     * Grants permission to describe an attribute of an Amazon Machine Image (AMI)
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeImageAttribute.html
     */
    toDescribeImageAttribute() {
        this.to('ec2:DescribeImageAttribute');
        return this;
    }
    /**
     * Grants permission to describe one or more images (AMIs, AKIs, and ARIs)
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeImages.html
     */
    toDescribeImages() {
        this.to('ec2:DescribeImages');
        return this;
    }
    /**
     * Grants permission to describe import virtual machine or import snapshot tasks
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeImportImageTasks.html
     */
    toDescribeImportImageTasks() {
        this.to('ec2:DescribeImportImageTasks');
        return this;
    }
    /**
     * Grants permission to describe import snapshot tasks
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeImportSnapshotTasks.html
     */
    toDescribeImportSnapshotTasks() {
        this.to('ec2:DescribeImportSnapshotTasks');
        return this;
    }
    /**
     * Grants permission to describe the attributes of an instance
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeInstanceAttribute.html
     */
    toDescribeInstanceAttribute() {
        this.to('ec2:DescribeInstanceAttribute');
        return this;
    }
    /**
     * Grants permission to describe the credit option for CPU usage of one or more burstable performance instances
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeInstanceCreditSpecifications.html
     */
    toDescribeInstanceCreditSpecifications() {
        this.to('ec2:DescribeInstanceCreditSpecifications');
        return this;
    }
    /**
     * Grants permission to describe the set of tags to include in notifications about scheduled events for your instances
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeInstanceEventNotificationAttributes.html
     */
    toDescribeInstanceEventNotificationAttributes() {
        this.to('ec2:DescribeInstanceEventNotificationAttributes');
        return this;
    }
    /**
     * Grants permission to describe the status of one or more instances
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeInstanceStatus.html
     */
    toDescribeInstanceStatus() {
        this.to('ec2:DescribeInstanceStatus');
        return this;
    }
    /**
     * Grants permission to describe the set of instance types that are offered in a location
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeInstanceTypeOfferings.html
     */
    toDescribeInstanceTypeOfferings() {
        this.to('ec2:DescribeInstanceTypeOfferings');
        return this;
    }
    /**
     * Grants permission to describe the details of instance types that are offered in a location
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeInstanceTypes.html
     */
    toDescribeInstanceTypes() {
        this.to('ec2:DescribeInstanceTypes');
        return this;
    }
    /**
     * Grants permission to describe one or more instances
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeInstances.html
     */
    toDescribeInstances() {
        this.to('ec2:DescribeInstances');
        return this;
    }
    /**
     * Grants permission to describe one or more internet gateways
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeInternetGateways.html
     */
    toDescribeInternetGateways() {
        this.to('ec2:DescribeInternetGateways');
        return this;
    }
    /**
     * Grants permission to describe one or more key pairs
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeKeyPairs.html
     */
    toDescribeKeyPairs() {
        this.to('ec2:DescribeKeyPairs');
        return this;
    }
    /**
     * Grants permission to describe one or more launch template versions
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeLaunchTemplateVersions.html
     */
    toDescribeLaunchTemplateVersions() {
        this.to('ec2:DescribeLaunchTemplateVersions');
        return this;
    }
    /**
     * Grants permission to describe one or more launch templates
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeLaunchTemplates.html
     */
    toDescribeLaunchTemplates() {
        this.to('ec2:DescribeLaunchTemplates');
        return this;
    }
    /**
     * Grants permission to describe the associations between virtual interface groups and local gateway route tables
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociations.html
     */
    toDescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociations() {
        this.to('ec2:DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociations');
        return this;
    }
    /**
     * Grants permission to describe an association between VPCs and local gateway route tables
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeLocalGatewayRouteTableVpcAssociations.html
     */
    toDescribeLocalGatewayRouteTableVpcAssociations() {
        this.to('ec2:DescribeLocalGatewayRouteTableVpcAssociations');
        return this;
    }
    /**
     * Grants permission to describe one or more local gateway route tables
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeLocalGatewayRouteTables.html
     */
    toDescribeLocalGatewayRouteTables() {
        this.to('ec2:DescribeLocalGatewayRouteTables');
        return this;
    }
    /**
     * Grants permission to describe local gateway virtual interface groups
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeLocalGatewayVirtualInterfaceGroups.html
     */
    toDescribeLocalGatewayVirtualInterfaceGroups() {
        this.to('ec2:DescribeLocalGatewayVirtualInterfaceGroups');
        return this;
    }
    /**
     * Grants permission to describe local gateway virtual interfaces
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeLocalGatewayVirtualInterfaces.html
     */
    toDescribeLocalGatewayVirtualInterfaces() {
        this.to('ec2:DescribeLocalGatewayVirtualInterfaces');
        return this;
    }
    /**
     * Grants permission to describe one or more local gateways
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeLocalGateways.html
     */
    toDescribeLocalGateways() {
        this.to('ec2:DescribeLocalGateways');
        return this;
    }
    /**
     * Grants permission to describe your managed prefix lists and any AWS-managed prefix lists
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeManagedPrefixLists.html
     */
    toDescribeManagedPrefixLists() {
        this.to('ec2:DescribeManagedPrefixLists');
        return this;
    }
    /**
     * Grants permission to describe Elastic IP addresses that are being moved to the EC2-VPC platform
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeMovingAddresses.html
     */
    toDescribeMovingAddresses() {
        this.to('ec2:DescribeMovingAddresses');
        return this;
    }
    /**
     * Grants permission to describe one or more NAT gateways
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeNatGateways.html
     */
    toDescribeNatGateways() {
        this.to('ec2:DescribeNatGateways');
        return this;
    }
    /**
     * Grants permission to describe one or more network ACLs
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeNetworkAcls.html
     */
    toDescribeNetworkAcls() {
        this.to('ec2:DescribeNetworkAcls');
        return this;
    }
    /**
     * Grants permission to describe a network interface attribute
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeNetworkInterfaceAttribute.html
     */
    toDescribeNetworkInterfaceAttribute() {
        this.to('ec2:DescribeNetworkInterfaceAttribute');
        return this;
    }
    /**
     * Grants permission to describe the permissions that are associated with a network interface
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeNetworkInterfacePermissions.html
     */
    toDescribeNetworkInterfacePermissions() {
        this.to('ec2:DescribeNetworkInterfacePermissions');
        return this;
    }
    /**
     * Grants permission to describe one or more network interfaces
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeNetworkInterfaces.html
     */
    toDescribeNetworkInterfaces() {
        this.to('ec2:DescribeNetworkInterfaces');
        return this;
    }
    /**
     * Grants permission to describe one or more placement groups
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribePlacementGroups.html
     */
    toDescribePlacementGroups() {
        this.to('ec2:DescribePlacementGroups');
        return this;
    }
    /**
     * Grants permission to describe available AWS services in a prefix list format
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribePrefixLists.html
     */
    toDescribePrefixLists() {
        this.to('ec2:DescribePrefixLists');
        return this;
    }
    /**
     * Grants permission to describe the ID format settings for the root user and all IAM roles and IAM users that have explicitly specified a longer ID (17-character ID) preference
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribePrincipalIdFormat.html
     */
    toDescribePrincipalIdFormat() {
        this.to('ec2:DescribePrincipalIdFormat');
        return this;
    }
    /**
     * Grants permission to describe one or more IPv4 address pools
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribePublicIpv4Pools.html
     */
    toDescribePublicIpv4Pools() {
        this.to('ec2:DescribePublicIpv4Pools');
        return this;
    }
    /**
     * Grants permission to describe one or more AWS Regions that are currently available in your account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeRegions.html
     */
    toDescribeRegions() {
        this.to('ec2:DescribeRegions');
        return this;
    }
    /**
     * Grants permission to describe one or more purchased Reserved Instances in your account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeReservedInstances.html
     */
    toDescribeReservedInstances() {
        this.to('ec2:DescribeReservedInstances');
        return this;
    }
    /**
     * Grants permission to describe your account's Reserved Instance listings in the Reserved Instance Marketplace
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeReservedInstancesListings.html
     */
    toDescribeReservedInstancesListings() {
        this.to('ec2:DescribeReservedInstancesListings');
        return this;
    }
    /**
     * Grants permission to describe the modifications made to one or more Reserved Instances
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeReservedInstancesModifications.html
     */
    toDescribeReservedInstancesModifications() {
        this.to('ec2:DescribeReservedInstancesModifications');
        return this;
    }
    /**
     * Grants permission to describe the Reserved Instance offerings that are available for purchase
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeReservedInstancesOfferings.html
     */
    toDescribeReservedInstancesOfferings() {
        this.to('ec2:DescribeReservedInstancesOfferings');
        return this;
    }
    /**
     * Grants permission to describe one or more route tables
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeRouteTables.html
     */
    toDescribeRouteTables() {
        this.to('ec2:DescribeRouteTables');
        return this;
    }
    /**
     * Grants permission to find available schedules for Scheduled Instances
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeScheduledInstanceAvailability.html
     */
    toDescribeScheduledInstanceAvailability() {
        this.to('ec2:DescribeScheduledInstanceAvailability');
        return this;
    }
    /**
     * Grants permission to describe one or more Scheduled Instances in your account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeScheduledInstances.html
     */
    toDescribeScheduledInstances() {
        this.to('ec2:DescribeScheduledInstances');
        return this;
    }
    /**
     * Grants permission to describe the VPCs on the other side of a VPC peering connection that are referencing specified VPC security groups
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeSecurityGroupReferences.html
     */
    toDescribeSecurityGroupReferences() {
        this.to('ec2:DescribeSecurityGroupReferences');
        return this;
    }
    /**
     * Grants permission to describe one or more security groups
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeSecurityGroups.html
     */
    toDescribeSecurityGroups() {
        this.to('ec2:DescribeSecurityGroups');
        return this;
    }
    /**
     * Grants permission to describe an attribute of a snapshot
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeSnapshotAttribute.html
     */
    toDescribeSnapshotAttribute() {
        this.to('ec2:DescribeSnapshotAttribute');
        return this;
    }
    /**
     * Grants permission to describe one or more EBS snapshots
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeSnapshots.html
     */
    toDescribeSnapshots() {
        this.to('ec2:DescribeSnapshots');
        return this;
    }
    /**
     * Grants permission to describe the data feed for Spot Instances
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeSpotDatafeedSubscription.html
     */
    toDescribeSpotDatafeedSubscription() {
        this.to('ec2:DescribeSpotDatafeedSubscription');
        return this;
    }
    /**
     * Grants permission to describe the running instances for a Spot Fleet
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeSpotFleetInstances.html
     */
    toDescribeSpotFleetInstances() {
        this.to('ec2:DescribeSpotFleetInstances');
        return this;
    }
    /**
     * Grants permission to describe the events for a Spot Fleet request during a specified time
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeSpotFleetRequestHistory.html
     */
    toDescribeSpotFleetRequestHistory() {
        this.to('ec2:DescribeSpotFleetRequestHistory');
        return this;
    }
    /**
     * Grants permission to describe one or more Spot Fleet requests
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeSpotFleetRequests.html
     */
    toDescribeSpotFleetRequests() {
        this.to('ec2:DescribeSpotFleetRequests');
        return this;
    }
    /**
     * Grants permission to describe one or more Spot Instance requests
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeSpotInstanceRequests.html
     */
    toDescribeSpotInstanceRequests() {
        this.to('ec2:DescribeSpotInstanceRequests');
        return this;
    }
    /**
     * Grants permission to describe the Spot Instance price history
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeSpotPriceHistory.html
     */
    toDescribeSpotPriceHistory() {
        this.to('ec2:DescribeSpotPriceHistory');
        return this;
    }
    /**
     * Grants permission to describe the stale security group rules for security groups in a specified VPC
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeStaleSecurityGroups.html
     */
    toDescribeStaleSecurityGroups() {
        this.to('ec2:DescribeStaleSecurityGroups');
        return this;
    }
    /**
     * Grants permission to describe one or more subnets
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeSubnets.html
     */
    toDescribeSubnets() {
        this.to('ec2:DescribeSubnets');
        return this;
    }
    /**
     * Grants permission to describe one or more tags for an Amazon EC2 resource
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeTags.html
     */
    toDescribeTags() {
        this.to('ec2:DescribeTags');
        return this;
    }
    /**
     * Grants permission to describe one or more traffic mirror filters
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeTrafficMirrorFilters.html
     */
    toDescribeTrafficMirrorFilters() {
        this.to('ec2:DescribeTrafficMirrorFilters');
        return this;
    }
    /**
     * Grants permission to describe one or more traffic mirror sessions
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeTrafficMirrorSessions.html
     */
    toDescribeTrafficMirrorSessions() {
        this.to('ec2:DescribeTrafficMirrorSessions');
        return this;
    }
    /**
     * Grants permission to describe one or more traffic mirror targets
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeTrafficMirrorTargets.html
     */
    toDescribeTrafficMirrorTargets() {
        this.to('ec2:DescribeTrafficMirrorTargets');
        return this;
    }
    /**
     * Grants permission to describe one or more attachments between resources and transit gateways
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeTransitGatewayAttachments.html
     */
    toDescribeTransitGatewayAttachments() {
        this.to('ec2:DescribeTransitGatewayAttachments');
        return this;
    }
    /**
     * Grants permission to describe one or more transit gateway multicast domains
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeTransitGatewayMulticastDomains.html
     */
    toDescribeTransitGatewayMulticastDomains() {
        this.to('ec2:DescribeTransitGatewayMulticastDomains');
        return this;
    }
    /**
     * Grants permission to describe one or more transit gateway peering attachments
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeTransitGatewayPeeringAttachments.html
     */
    toDescribeTransitGatewayPeeringAttachments() {
        this.to('ec2:DescribeTransitGatewayPeeringAttachments');
        return this;
    }
    /**
     * Grants permission to describe one or more transit gateway route tables
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeTransitGatewayRouteTables.html
     */
    toDescribeTransitGatewayRouteTables() {
        this.to('ec2:DescribeTransitGatewayRouteTables');
        return this;
    }
    /**
     * Grants permission to describe one or more VPC attachments on a transit gateway
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeTransitGatewayVpcAttachments.html
     */
    toDescribeTransitGatewayVpcAttachments() {
        this.to('ec2:DescribeTransitGatewayVpcAttachments');
        return this;
    }
    /**
     * Grants permission to describe one or more transit gateways
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeTransitGateways.html
     */
    toDescribeTransitGateways() {
        this.to('ec2:DescribeTransitGateways');
        return this;
    }
    /**
     * Grants permission to describe an attribute of an EBS volume
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeVolumeAttribute.html
     */
    toDescribeVolumeAttribute() {
        this.to('ec2:DescribeVolumeAttribute');
        return this;
    }
    /**
     * Grants permission to describe the status of one or more EBS volumes
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeVolumeStatus.html
     */
    toDescribeVolumeStatus() {
        this.to('ec2:DescribeVolumeStatus');
        return this;
    }
    /**
     * Grants permission to describe one or more EBS volumes
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeVolumes.html
     */
    toDescribeVolumes() {
        this.to('ec2:DescribeVolumes');
        return this;
    }
    /**
     * Grants permission to describe the current modification status of one or more EBS volumes
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeVolumesModifications.html
     */
    toDescribeVolumesModifications() {
        this.to('ec2:DescribeVolumesModifications');
        return this;
    }
    /**
     * Grants permission to describe an attribute of a VPC
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeVpcAttribute.html
     */
    toDescribeVpcAttribute() {
        this.to('ec2:DescribeVpcAttribute');
        return this;
    }
    /**
     * Grants permission to describe the ClassicLink status of one or more VPCs
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeVpcClassicLink.html
     */
    toDescribeVpcClassicLink() {
        this.to('ec2:DescribeVpcClassicLink');
        return this;
    }
    /**
     * Grants permission to describe the ClassicLink DNS support status of one or more VPCs
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeVpcClassicLinkDnsSupport.html
     */
    toDescribeVpcClassicLinkDnsSupport() {
        this.to('ec2:DescribeVpcClassicLinkDnsSupport');
        return this;
    }
    /**
     * Grants permission to describe the connection notifications for VPC endpoints and VPC endpoint services
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeVpcEndpointConnectionNotifications.html
     */
    toDescribeVpcEndpointConnectionNotifications() {
        this.to('ec2:DescribeVpcEndpointConnectionNotifications');
        return this;
    }
    /**
     * Grants permission to describe the VPC endpoint connections to your VPC endpoint services
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeVpcEndpointConnections.html
     */
    toDescribeVpcEndpointConnections() {
        this.to('ec2:DescribeVpcEndpointConnections');
        return this;
    }
    /**
     * Grants permission to describe VPC endpoint service configurations (your services)
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeVpcEndpointServiceConfigurations.html
     */
    toDescribeVpcEndpointServiceConfigurations() {
        this.to('ec2:DescribeVpcEndpointServiceConfigurations');
        return this;
    }
    /**
     * Grants permission to describe the principals (service consumers) that are permitted to discover your VPC endpoint service
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeVpcEndpointServicePermissions.html
     */
    toDescribeVpcEndpointServicePermissions() {
        this.to('ec2:DescribeVpcEndpointServicePermissions');
        return this;
    }
    /**
     * Grants permission to describe all supported AWS services that can be specified when creating a VPC endpoint
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeVpcEndpointServices.html
     */
    toDescribeVpcEndpointServices() {
        this.to('ec2:DescribeVpcEndpointServices');
        return this;
    }
    /**
     * Grants permission to describe one or more VPC endpoints
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeVpcEndpoints.html
     */
    toDescribeVpcEndpoints() {
        this.to('ec2:DescribeVpcEndpoints');
        return this;
    }
    /**
     * Grants permission to describe one or more VPC peering connections
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeVpcPeeringConnections.html
     */
    toDescribeVpcPeeringConnections() {
        this.to('ec2:DescribeVpcPeeringConnections');
        return this;
    }
    /**
     * Grants permission to describe one or more VPCs
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeVpcs.html
     */
    toDescribeVpcs() {
        this.to('ec2:DescribeVpcs');
        return this;
    }
    /**
     * Grants permission to describe one or more VPN connections
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeVpnConnections.html
     */
    toDescribeVpnConnections() {
        this.to('ec2:DescribeVpnConnections');
        return this;
    }
    /**
     * Grants permission to describe one or more virtual private gateways
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeVpnGateways.html
     */
    toDescribeVpnGateways() {
        this.to('ec2:DescribeVpnGateways');
        return this;
    }
    /**
     * Grants permission to unlink (detach) a linked EC2-Classic instance from a VPC
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DetachClassicLinkVpc.html
     */
    toDetachClassicLinkVpc() {
        this.to('ec2:DetachClassicLinkVpc');
        return this;
    }
    /**
     * Grants permission to detach an internet gateway from a VPC
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DetachInternetGateway.html
     */
    toDetachInternetGateway() {
        this.to('ec2:DetachInternetGateway');
        return this;
    }
    /**
     * Grants permission to detach a network interface from an instance
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DetachNetworkInterface.html
     */
    toDetachNetworkInterface() {
        this.to('ec2:DetachNetworkInterface');
        return this;
    }
    /**
     * Grants permission to detach an EBS volume from an instance
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DetachVolume.html
     */
    toDetachVolume() {
        this.to('ec2:DetachVolume');
        return this;
    }
    /**
     * Grants permission to detach a virtual private gateway from a VPC
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DetachVpnGateway.html
     */
    toDetachVpnGateway() {
        this.to('ec2:DetachVpnGateway');
        return this;
    }
    /**
     * Grants permission to disable EBS encryption by default for your account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DisableEbsEncryptionByDefault.html
     */
    toDisableEbsEncryptionByDefault() {
        this.to('ec2:DisableEbsEncryptionByDefault');
        return this;
    }
    /**
     * Grants permission to disable fast snapshot restores for one or more snapshots in specified Availability Zones
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DisableFastSnapshotRestores.html
     */
    toDisableFastSnapshotRestores() {
        this.to('ec2:DisableFastSnapshotRestores');
        return this;
    }
    /**
     * Grants permission to disable a resource attachment from propagating routes to the specified propagation route table
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DisableTransitGatewayRouteTablePropagation.html
     */
    toDisableTransitGatewayRouteTablePropagation() {
        this.to('ec2:DisableTransitGatewayRouteTablePropagation');
        return this;
    }
    /**
     * Grants permission to disable a virtual private gateway from propagating routes to a specified route table of a VPC
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DisableVgwRoutePropagation.html
     */
    toDisableVgwRoutePropagation() {
        this.to('ec2:DisableVgwRoutePropagation');
        return this;
    }
    /**
     * Grants permission to disable ClassicLink for a VPC
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DisableVpcClassicLink.html
     */
    toDisableVpcClassicLink() {
        this.to('ec2:DisableVpcClassicLink');
        return this;
    }
    /**
     * Grants permission to disable ClassicLink DNS support for a VPC
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DisableVpcClassicLinkDnsSupport.html
     */
    toDisableVpcClassicLinkDnsSupport() {
        this.to('ec2:DisableVpcClassicLinkDnsSupport');
        return this;
    }
    /**
     * Grants permission to disassociate an Elastic IP address from an instance or network interface
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DisassociateAddress.html
     */
    toDisassociateAddress() {
        this.to('ec2:DisassociateAddress');
        return this;
    }
    /**
     * Grants permission to disassociate a target network from a Client VPN endpoint
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DisassociateClientVpnTargetNetwork.html
     */
    toDisassociateClientVpnTargetNetwork() {
        this.to('ec2:DisassociateClientVpnTargetNetwork');
        return this;
    }
    /**
     * Grants permission to disassociate an IAM instance profile from a running or stopped instance
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DisassociateIamInstanceProfile.html
     */
    toDisassociateIamInstanceProfile() {
        this.to('ec2:DisassociateIamInstanceProfile');
        return this;
    }
    /**
     * Grants permission to disassociate a subnet from a route table
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DisassociateRouteTable.html
     */
    toDisassociateRouteTable() {
        this.to('ec2:DisassociateRouteTable');
        return this;
    }
    /**
     * Grants permission to disassociate a CIDR block from a subnet
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DisassociateSubnetCidrBlock.html
     */
    toDisassociateSubnetCidrBlock() {
        this.to('ec2:DisassociateSubnetCidrBlock');
        return this;
    }
    /**
     * Grants permission to disassociate one or more subnets from a transit gateway multicast domain
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DisassociateTransitGatewayMulticastDomain.html
     */
    toDisassociateTransitGatewayMulticastDomain() {
        this.to('ec2:DisassociateTransitGatewayMulticastDomain');
        return this;
    }
    /**
     * Grants permission to disassociate a resource attachment from a transit gateway route table
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DisassociateTransitGatewayRouteTable.html
     */
    toDisassociateTransitGatewayRouteTable() {
        this.to('ec2:DisassociateTransitGatewayRouteTable');
        return this;
    }
    /**
     * Grants permission to disassociate a CIDR block from a VPC
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DisassociateVpcCidrBlock.html
     */
    toDisassociateVpcCidrBlock() {
        this.to('ec2:DisassociateVpcCidrBlock');
        return this;
    }
    /**
     * Grants permission to enable EBS encryption by default for your account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_EnableEbsEncryptionByDefault.html
     */
    toEnableEbsEncryptionByDefault() {
        this.to('ec2:EnableEbsEncryptionByDefault');
        return this;
    }
    /**
     * Grants permission to enable fast snapshot restores for one or more snapshots in specified Availability Zones
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_EnableFastSnapshotRestores.html
     */
    toEnableFastSnapshotRestores() {
        this.to('ec2:EnableFastSnapshotRestores');
        return this;
    }
    /**
     * Grants permission to enable an attachment to propagate routes to a propagation route table
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_EnableTransitGatewayRouteTablePropagation.html
     */
    toEnableTransitGatewayRouteTablePropagation() {
        this.to('ec2:EnableTransitGatewayRouteTablePropagation');
        return this;
    }
    /**
     * Grants permission to enable a virtual private gateway to propagate routes to a VPC route table
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_EnableVgwRoutePropagation.html
     */
    toEnableVgwRoutePropagation() {
        this.to('ec2:EnableVgwRoutePropagation');
        return this;
    }
    /**
     * Grants permission to enable I/O operations for a volume that had I/O operations disabled
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_EnableVolumeIO.html
     */
    toEnableVolumeIO() {
        this.to('ec2:EnableVolumeIO');
        return this;
    }
    /**
     * Grants permission to enable a VPC for ClassicLink
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_EnableVpcClassicLink.html
     */
    toEnableVpcClassicLink() {
        this.to('ec2:EnableVpcClassicLink');
        return this;
    }
    /**
     * Grants permission to enable a VPC to support DNS hostname resolution for ClassicLink
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_EnableVpcClassicLinkDnsSupport.html
     */
    toEnableVpcClassicLinkDnsSupport() {
        this.to('ec2:EnableVpcClassicLinkDnsSupport');
        return this;
    }
    /**
     * Grants permission to download the client certificate revocation list for a Client VPN endpoint
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ExportClientVpnClientCertificateRevocationList.html
     */
    toExportClientVpnClientCertificateRevocationList() {
        this.to('ec2:ExportClientVpnClientCertificateRevocationList');
        return this;
    }
    /**
     * Grants permission to download the contents of the Client VPN endpoint configuration file for a Client VPN endpoint
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ExportClientVpnClientConfiguration.html
     */
    toExportClientVpnClientConfiguration() {
        this.to('ec2:ExportClientVpnClientConfiguration');
        return this;
    }
    /**
     * Grants permission to export an Amazon Machine Image (AMI) to a VM file
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ExportImage.html
     */
    toExportImage() {
        this.to('ec2:ExportImage');
        return this;
    }
    /**
     * Grants permission to export routes from a transit gateway route table to an Amazon S3 bucket
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ExportTransitGatewayRoutes.html
     */
    toExportTransitGatewayRoutes() {
        this.to('ec2:ExportTransitGatewayRoutes');
        return this;
    }
    /**
     * Grants permission to get usage information about a Capacity Reservation
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_GetCapacityReservationUsage.html
     */
    toGetCapacityReservationUsage() {
        this.to('ec2:GetCapacityReservationUsage');
        return this;
    }
    /**
     * Grants permission to describe the allocations from the specified customer-owned address pool
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_GetCoipPoolUsage.html
     */
    toGetCoipPoolUsage() {
        this.to('ec2:GetCoipPoolUsage');
        return this;
    }
    /**
     * Grants permission to get the console output for an instance
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_GetConsoleOutput.html
     */
    toGetConsoleOutput() {
        this.to('ec2:GetConsoleOutput');
        return this;
    }
    /**
     * Grants permission to retrieve a JPG-format screenshot of a running instance
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_GetConsoleScreenshot.html
     */
    toGetConsoleScreenshot() {
        this.to('ec2:GetConsoleScreenshot');
        return this;
    }
    /**
     * Grants permission to get the default credit option for CPU usage of a burstable performance instance family
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_GetDefaultCreditSpecification.html
     */
    toGetDefaultCreditSpecification() {
        this.to('ec2:GetDefaultCreditSpecification');
        return this;
    }
    /**
     * Grants permission to get the ID of the default customer master key (CMK) for EBS encryption by default
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_GetEbsDefaultKmsKeyId.html
     */
    toGetEbsDefaultKmsKeyId() {
        this.to('ec2:GetEbsDefaultKmsKeyId');
        return this;
    }
    /**
     * Grants permission to describe whether EBS encryption by default is enabled for your account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_GetEbsEncryptionByDefault.html
     */
    toGetEbsEncryptionByDefault() {
        this.to('ec2:GetEbsEncryptionByDefault');
        return this;
    }
    /**
     * Grants permission to preview a reservation purchase with configurations that match those of a Dedicated Host
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_GetHostReservationPurchasePreview.html
     */
    toGetHostReservationPurchasePreview() {
        this.to('ec2:GetHostReservationPurchasePreview');
        return this;
    }
    /**
     * Grants permission to get the configuration data of the specified instance for use with a new launch template or launch template version
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_GetLaunchTemplateData.html
     */
    toGetLaunchTemplateData() {
        this.to('ec2:GetLaunchTemplateData');
        return this;
    }
    /**
     * Grants permission to get information about the resources that are associated with the specified managed prefix list
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_GetManagedPrefixListAssociations.html
     */
    toGetManagedPrefixListAssociations() {
        this.to('ec2:GetManagedPrefixListAssociations');
        return this;
    }
    /**
     * Grants permission to get information about the entries for a specified managed prefix list
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_GetManagedPrefixListEntries.html
     */
    toGetManagedPrefixListEntries() {
        this.to('ec2:GetManagedPrefixListEntries');
        return this;
    }
    /**
     * Grants permission to retrieve the encrypted administrator password for a running Windows instance
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_GetPasswordData.html
     */
    toGetPasswordData() {
        this.to('ec2:GetPasswordData');
        return this;
    }
    /**
     * Grants permission to return a quote and exchange information for exchanging one or more Convertible Reserved Instances for a new Convertible Reserved Instance
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_GetReservedInstancesExchangeQuote.html
     */
    toGetReservedInstancesExchangeQuote() {
        this.to('ec2:GetReservedInstancesExchangeQuote');
        return this;
    }
    /**
     * Grants permission to list the route tables to which a resource attachment propagates routes
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_GetTransitGatewayAttachmentPropagations.html
     */
    toGetTransitGatewayAttachmentPropagations() {
        this.to('ec2:GetTransitGatewayAttachmentPropagations');
        return this;
    }
    /**
     * Grants permission to get information about the associations for a transit gateway multicast domain
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_GetTransitGatewayMulticastDomainAssociations.html
     */
    toGetTransitGatewayMulticastDomainAssociations() {
        this.to('ec2:GetTransitGatewayMulticastDomainAssociations');
        return this;
    }
    /**
     * Grants permission to get information about prefix list references for a transit gateway route table
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_GetTransitGatewayPrefixListReference.html
     */
    toGetTransitGatewayPrefixListReferences() {
        this.to('ec2:GetTransitGatewayPrefixListReferences');
        return this;
    }
    /**
     * Grants permission to get information about associations for a transit gateway route table
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_GetTransitGatewayRouteTableAssociations.html
     */
    toGetTransitGatewayRouteTableAssociations() {
        this.to('ec2:GetTransitGatewayRouteTableAssociations');
        return this;
    }
    /**
     * Grants permission to get information about the route table propagations for a transit gateway route table
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_GetTransitGatewayRouteTablePropagations.html
     */
    toGetTransitGatewayRouteTablePropagations() {
        this.to('ec2:GetTransitGatewayRouteTablePropagations');
        return this;
    }
    /**
     * Grants permission to upload a client certificate revocation list to a Client VPN endpoint
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ImportClientVpnClientCertificateRevocationList.html
     */
    toImportClientVpnClientCertificateRevocationList() {
        this.to('ec2:ImportClientVpnClientCertificateRevocationList');
        return this;
    }
    /**
     * Grants permission to import single or multi-volume disk images or EBS snapshots into an Amazon Machine Image (AMI)
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ImportImage.html
     */
    toImportImage() {
        this.to('ec2:ImportImage');
        return this;
    }
    /**
     * Grants permission to create an import instance task using metadata from a disk image
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ImportInstance.html
     */
    toImportInstance() {
        this.to('ec2:ImportInstance');
        return this;
    }
    /**
     * Grants permission to import a public key from an RSA key pair that was created with a third-party tool
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ImportKeyPair.html
     */
    toImportKeyPair() {
        this.to('ec2:ImportKeyPair');
        return this;
    }
    /**
     * Grants permission to import a disk into an EBS snapshot
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ImportSnapshot.html
     */
    toImportSnapshot() {
        this.to('ec2:ImportSnapshot');
        return this;
    }
    /**
     * Grants permission to create an import volume task using metadata from a disk image
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ImportVolume.html
     */
    toImportVolume() {
        this.to('ec2:ImportVolume');
        return this;
    }
    /**
     * Grants permission to modify a Capacity Reservation's capacity and the conditions under which it is to be released
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyCapacityReservation.html
     */
    toModifyCapacityReservation() {
        this.to('ec2:ModifyCapacityReservation');
        return this;
    }
    /**
     * Grants permission to modify a Client VPN endpoint
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyClientVpnEndpoint.html
     */
    toModifyClientVpnEndpoint() {
        this.to('ec2:ModifyClientVpnEndpoint');
        return this;
    }
    /**
     * Grants permission to change the account level default credit option for CPU usage of burstable performance instances
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyDefaultCreditSpecification.html
     */
    toModifyDefaultCreditSpecification() {
        this.to('ec2:ModifyDefaultCreditSpecification');
        return this;
    }
    /**
     * Grants permission to change the default customer master key (CMK) for EBS encryption by default for your account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyEbsDefaultKmsKeyId.html
     */
    toModifyEbsDefaultKmsKeyId() {
        this.to('ec2:ModifyEbsDefaultKmsKeyId');
        return this;
    }
    /**
     * Grants permission to modify an EC2 Fleet
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyFleet.html
     */
    toModifyFleet() {
        this.to('ec2:ModifyFleet');
        return this;
    }
    /**
     * Grants permission to modify an attribute of an Amazon FPGA Image (AFI)
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyFpgaImageAttribute.html
     */
    toModifyFpgaImageAttribute() {
        this.to('ec2:ModifyFpgaImageAttribute');
        return this;
    }
    /**
     * Grants permission to modify a Dedicated Host
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyHosts.html
     */
    toModifyHosts() {
        this.to('ec2:ModifyHosts');
        return this;
    }
    /**
     * Grants permission to modify the ID format for a resource
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyIdFormat.html
     */
    toModifyIdFormat() {
        this.to('ec2:ModifyIdFormat');
        return this;
    }
    /**
     * Grants permission to modify the ID format of a resource for a specific principal in your account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyIdentityIdFormat.html
     */
    toModifyIdentityIdFormat() {
        this.to('ec2:ModifyIdentityIdFormat');
        return this;
    }
    /**
     * Grants permission to modify an attribute of an Amazon Machine Image (AMI)
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyImageAttribute.html
     */
    toModifyImageAttribute() {
        this.to('ec2:ModifyImageAttribute');
        return this;
    }
    /**
     * Grants permission to modify an attribute of an instance
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyInstanceAttribute.html
     */
    toModifyInstanceAttribute() {
        this.to('ec2:ModifyInstanceAttribute');
        return this;
    }
    /**
     * Grants permission to modify the Capacity Reservation settings for a stopped instance
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyInstanceCapacityReservationAttributes.html
     */
    toModifyInstanceCapacityReservationAttributes() {
        this.to('ec2:ModifyInstanceCapacityReservationAttributes');
        return this;
    }
    /**
     * Grants permission to modify the credit option for CPU usage on an instance
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyInstanceCreditSpecification.html
     */
    toModifyInstanceCreditSpecification() {
        this.to('ec2:ModifyInstanceCreditSpecification');
        return this;
    }
    /**
     * Grants permission to modify the start time for a scheduled EC2 instance event
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyInstanceEventStartTime.html
     */
    toModifyInstanceEventStartTime() {
        this.to('ec2:ModifyInstanceEventStartTime');
        return this;
    }
    /**
     * Grants permission to modify the metadata options for an instance
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyInstanceMetadataOptions.html
     */
    toModifyInstanceMetadataOptions() {
        this.to('ec2:ModifyInstanceMetadataOptions');
        return this;
    }
    /**
     * Grants permission to modify the placement attributes for an instance
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyInstancePlacement.html
     */
    toModifyInstancePlacement() {
        this.to('ec2:ModifyInstancePlacement');
        return this;
    }
    /**
     * Grants permission to modify a launch template
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyLaunchTemplate.html
     */
    toModifyLaunchTemplate() {
        this.to('ec2:ModifyLaunchTemplate');
        return this;
    }
    /**
     * Grants permission to modify a managed prefix list
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyManagedPrefixList.html
     */
    toModifyManagedPrefixList() {
        this.to('ec2:ModifyManagedPrefixList');
        return this;
    }
    /**
     * Grants permission to modify an attribute of a network interface
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyNetworkInterfaceAttribute.html
     */
    toModifyNetworkInterfaceAttribute() {
        this.to('ec2:ModifyNetworkInterfaceAttribute');
        return this;
    }
    /**
     * Grants permission to modify attributes of one or more Reserved Instances
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyReservedInstances.html
     */
    toModifyReservedInstances() {
        this.to('ec2:ModifyReservedInstances');
        return this;
    }
    /**
     * Grants permission to add or remove permission settings for a snapshot
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifySnapshotAttribute.html
     */
    toModifySnapshotAttribute() {
        this.to('ec2:ModifySnapshotAttribute');
        return this;
    }
    /**
     * Grants permission to modify a Spot Fleet request
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifySpotFleetRequest.html
     */
    toModifySpotFleetRequest() {
        this.to('ec2:ModifySpotFleetRequest');
        return this;
    }
    /**
     * Grants permission to modify an attribute of a subnet
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifySubnetAttribute.html
     */
    toModifySubnetAttribute() {
        this.to('ec2:ModifySubnetAttribute');
        return this;
    }
    /**
     * Grants permission to allow or restrict mirroring network services
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyTrafficMirrorFilterNetworkServices.html
     */
    toModifyTrafficMirrorFilterNetworkServices() {
        this.to('ec2:ModifyTrafficMirrorFilterNetworkServices');
        return this;
    }
    /**
     * Grants permission to modify a traffic mirror rule
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyTrafficMirrorFilterRule.html
     */
    toModifyTrafficMirrorFilterRule() {
        this.to('ec2:ModifyTrafficMirrorFilterRule');
        return this;
    }
    /**
     * Grants permission to modify a traffic mirror session
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyTrafficMirrorSession.html
     */
    toModifyTrafficMirrorSession() {
        this.to('ec2:ModifyTrafficMirrorSession');
        return this;
    }
    /**
     * Grants permission to modify a transit gateway
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyTransitGateway.html
     */
    toModifyTransitGateway() {
        this.to('ec2:ModifyTransitGateway');
        return this;
    }
    /**
     * Grants permission to modify a transit gateway prefix list reference
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyTransitGatewayPrefixListReference.html
     */
    toModifyTransitGatewayPrefixListReference() {
        this.to('ec2:ModifyTransitGatewayPrefixListReference');
        return this;
    }
    /**
     * Grants permission to modify a VPC attachment on a transit gateway
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyTransitGatewayVpcAttachment.html
     */
    toModifyTransitGatewayVpcAttachment() {
        this.to('ec2:ModifyTransitGatewayVpcAttachment');
        return this;
    }
    /**
     * Grants permission to modify the parameters of an EBS volume
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyVolume.html
     */
    toModifyVolume() {
        this.to('ec2:ModifyVolume');
        return this;
    }
    /**
     * Grants permission to modify an attribute of a volume
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyVolumeAttribute.html
     */
    toModifyVolumeAttribute() {
        this.to('ec2:ModifyVolumeAttribute');
        return this;
    }
    /**
     * Grants permission to modify an attribute of a VPC
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyVpcAttribute.html
     */
    toModifyVpcAttribute() {
        this.to('ec2:ModifyVpcAttribute');
        return this;
    }
    /**
     * Grants permission to modify an attribute of a VPC endpoint
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyVpcEndpoint.html
     */
    toModifyVpcEndpoint() {
        this.to('ec2:ModifyVpcEndpoint');
        return this;
    }
    /**
     * Grants permission to modify a connection notification for a VPC endpoint or VPC endpoint service
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyVpcEndpointConnectionNotification.html
     */
    toModifyVpcEndpointConnectionNotification() {
        this.to('ec2:ModifyVpcEndpointConnectionNotification');
        return this;
    }
    /**
     * Grants permission to modify the attributes of a VPC endpoint service configuration
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyVpcEndpointServiceConfiguration.html
     */
    toModifyVpcEndpointServiceConfiguration() {
        this.to('ec2:ModifyVpcEndpointServiceConfiguration');
        return this;
    }
    /**
     * Grants permission to modify the permissions for a VPC endpoint service
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyVpcEndpointServicePermissions.html
     */
    toModifyVpcEndpointServicePermissions() {
        this.to('ec2:ModifyVpcEndpointServicePermissions');
        return this;
    }
    /**
     * Grants permission to modify the VPC peering connection options on one side of a VPC peering connection
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyVpcPeeringConnectionOptions.html
     */
    toModifyVpcPeeringConnectionOptions() {
        this.to('ec2:ModifyVpcPeeringConnectionOptions');
        return this;
    }
    /**
     * Grants permission to modify the instance tenancy attribute of a VPC
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyVpcTenancy.html
     */
    toModifyVpcTenancy() {
        this.to('ec2:ModifyVpcTenancy');
        return this;
    }
    /**
     * Grants permission to modify the target gateway of a Site-to-Site VPN connection
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyVpnConnection.html
     */
    toModifyVpnConnection() {
        this.to('ec2:ModifyVpnConnection');
        return this;
    }
    /**
     * Grants permission to modify the certificate for a Site-to-Site VPN connection
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyVpnTunnelCertificate
     */
    toModifyVpnTunnelCertificate() {
        this.to('ec2:ModifyVpnTunnelCertificate');
        return this;
    }
    /**
     * Grants permission to modify the options for a Site-to-Site VPN connection
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyVpnTunnelOptions.html
     */
    toModifyVpnTunnelOptions() {
        this.to('ec2:ModifyVpnTunnelOptions');
        return this;
    }
    /**
     * Grants permission to enable detailed monitoring for a running instance
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_MonitorInstances.html
     */
    toMonitorInstances() {
        this.to('ec2:MonitorInstances');
        return this;
    }
    /**
     * Grants permission to move an Elastic IP address from the EC2-Classic platform to the EC2-VPC platform
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_MoveAddressToVpc.html
     */
    toMoveAddressToVpc() {
        this.to('ec2:MoveAddressToVpc');
        return this;
    }
    /**
     * Grants permission to provision an address range for use in AWS through bring your own IP addresses (BYOIP), and to create a corresponding address pool
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ProvisionByoipCidr.html
     */
    toProvisionByoipCidr() {
        this.to('ec2:ProvisionByoipCidr');
        return this;
    }
    /**
     * Grants permission to purchase a reservation with configurations that match those of a Dedicated Host
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_PurchaseHostReservation.html
     */
    toPurchaseHostReservation() {
        this.to('ec2:PurchaseHostReservation');
        return this;
    }
    /**
     * Grants permission to purchase a Reserved Instance offering
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_PurchaseReservedInstancesOffering.html
     */
    toPurchaseReservedInstancesOffering() {
        this.to('ec2:PurchaseReservedInstancesOffering');
        return this;
    }
    /**
     * Grants permission to purchase one or more Scheduled Instances with a specified schedule
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_PurchaseScheduledInstances.html
     */
    toPurchaseScheduledInstances() {
        this.to('ec2:PurchaseScheduledInstances');
        return this;
    }
    /**
     * Grants permission to request a reboot of one or more instances
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RebootInstances.html
     */
    toRebootInstances() {
        this.to('ec2:RebootInstances');
        return this;
    }
    /**
     * Grants permission to register an Amazon Machine Image (AMI)
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RegisterImage.html
     */
    toRegisterImage() {
        this.to('ec2:RegisterImage');
        return this;
    }
    /**
     * Grants permission to add tags to the set of tags to include in notifications about scheduled events for your instances
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RegisterInstanceEventNotificationAttributes.html
     */
    toRegisterInstanceEventNotificationAttributes() {
        this.to('ec2:RegisterInstanceEventNotificationAttributes');
        return this;
    }
    /**
     * Grants permission to register one or more network interfaces as a member of a group IP address in a transit gateway multicast domain
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RegisterTransitGatewayMulticastGroupMembers.html
     */
    toRegisterTransitGatewayMulticastGroupMembers() {
        this.to('ec2:RegisterTransitGatewayMulticastGroupMembers');
        return this;
    }
    /**
     * Grants permission to register one or more network interfaces as a source of a group IP address in a transit gateway multicast domain
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RegisterTransitGatewayMulticastGroupSources.html
     */
    toRegisterTransitGatewayMulticastGroupSources() {
        this.to('ec2:RegisterTransitGatewayMulticastGroupSources');
        return this;
    }
    /**
     * Grants permission to reject a transit gateway peering attachment request
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RejectTransitGatewayPeeringAttachment.html
     */
    toRejectTransitGatewayPeeringAttachment() {
        this.to('ec2:RejectTransitGatewayPeeringAttachment');
        return this;
    }
    /**
     * Grants permission to reject a request to attach a VPC to a transit gateway
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RejectTransitGatewayVpcAttachment.html
     */
    toRejectTransitGatewayVpcAttachment() {
        this.to('ec2:RejectTransitGatewayVpcAttachment');
        return this;
    }
    /**
     * Grants permission to reject one or more VPC endpoint connection requests to a VPC endpoint service
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RejectVpcEndpointConnections.html
     */
    toRejectVpcEndpointConnections() {
        this.to('ec2:RejectVpcEndpointConnections');
        return this;
    }
    /**
     * Grants permission to reject a VPC peering connection request
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RejectVpcPeeringConnection.html
     */
    toRejectVpcPeeringConnection() {
        this.to('ec2:RejectVpcPeeringConnection');
        return this;
    }
    /**
     * Grants permission to release an Elastic IP address
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ReleaseAddress.html
     */
    toReleaseAddress() {
        this.to('ec2:ReleaseAddress');
        return this;
    }
    /**
     * Grants permission to release one or more On-Demand Dedicated Hosts
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ReleaseHosts.html
     */
    toReleaseHosts() {
        this.to('ec2:ReleaseHosts');
        return this;
    }
    /**
     * Grants permission to replace an IAM instance profile for an instance
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - iam:PassRole
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ReplaceIamInstanceProfileAssociation.html
     */
    toReplaceIamInstanceProfileAssociation() {
        this.to('ec2:ReplaceIamInstanceProfileAssociation');
        return this;
    }
    /**
     * Grants permission to change which network ACL a subnet is associated with
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ReplaceNetworkAclAssociation.html
     */
    toReplaceNetworkAclAssociation() {
        this.to('ec2:ReplaceNetworkAclAssociation');
        return this;
    }
    /**
     * Grants permission to replace an entry (rule) in a network ACL
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ReplaceNetworkAclEntry.html
     */
    toReplaceNetworkAclEntry() {
        this.to('ec2:ReplaceNetworkAclEntry');
        return this;
    }
    /**
     * Grants permission to replace a route within a route table in a VPC
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ReplaceRoute.html
     */
    toReplaceRoute() {
        this.to('ec2:ReplaceRoute');
        return this;
    }
    /**
     * Grants permission to change the route table that is associated with a subnet
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ReplaceRouteTableAssociation.html
     */
    toReplaceRouteTableAssociation() {
        this.to('ec2:ReplaceRouteTableAssociation');
        return this;
    }
    /**
     * Grants permission to replace a route in a transit gateway route table
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ReplaceTransitGatewayRoute.html
     */
    toReplaceTransitGatewayRoute() {
        this.to('ec2:ReplaceTransitGatewayRoute');
        return this;
    }
    /**
     * Grants permission to submit feedback about the status of an instance
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ReportInstanceStatus.html
     */
    toReportInstanceStatus() {
        this.to('ec2:ReportInstanceStatus');
        return this;
    }
    /**
     * Grants permission to create a Spot Fleet request
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RequestSpotFleet.html
     */
    toRequestSpotFleet() {
        this.to('ec2:RequestSpotFleet');
        return this;
    }
    /**
     * Grants permission to create a Spot Instance request
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RequestSpotInstances.html
     */
    toRequestSpotInstances() {
        this.to('ec2:RequestSpotInstances');
        return this;
    }
    /**
     * Grants permission to reset the default customer master key (CMK) for EBS encryption for your account to use the AWS-managed CMK for EBS
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ResetEbsDefaultKmsKeyId.html
     */
    toResetEbsDefaultKmsKeyId() {
        this.to('ec2:ResetEbsDefaultKmsKeyId');
        return this;
    }
    /**
     * Grants permission to reset an attribute of an Amazon FPGA Image (AFI) to its default value
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ResetFpgaImageAttribute.html
     */
    toResetFpgaImageAttribute() {
        this.to('ec2:ResetFpgaImageAttribute');
        return this;
    }
    /**
     * Grants permission to reset an attribute of an Amazon Machine Image (AMI) to its default value
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ResetImageAttribute.html
     */
    toResetImageAttribute() {
        this.to('ec2:ResetImageAttribute');
        return this;
    }
    /**
     * Grants permission to reset an attribute of an instance to its default value
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ResetInstanceAttribute.html
     */
    toResetInstanceAttribute() {
        this.to('ec2:ResetInstanceAttribute');
        return this;
    }
    /**
     * Grants permission to reset an attribute of a network interface
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ResetNetworkInterfaceAttribute.html
     */
    toResetNetworkInterfaceAttribute() {
        this.to('ec2:ResetNetworkInterfaceAttribute');
        return this;
    }
    /**
     * Grants permission to reset permission settings for a snapshot
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ResetSnapshotAttribute.html
     */
    toResetSnapshotAttribute() {
        this.to('ec2:ResetSnapshotAttribute');
        return this;
    }
    /**
     * Grants permission to restore an Elastic IP address that was previously moved to the EC2-VPC platform back to the EC2-Classic platform
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RestoreAddressToClassic.html
     */
    toRestoreAddressToClassic() {
        this.to('ec2:RestoreAddressToClassic');
        return this;
    }
    /**
     * Grants permission to restore the entries from a previous version of a managed prefix list to a new version of the prefix list
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RestoreManagedPrefixListVersion.html
     */
    toRestoreManagedPrefixListVersion() {
        this.to('ec2:RestoreManagedPrefixListVersion');
        return this;
    }
    /**
     * Grants permission to remove an inbound authorization rule from a Client VPN endpoint
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RevokeClientVpnIngress.html
     */
    toRevokeClientVpnIngress() {
        this.to('ec2:RevokeClientVpnIngress');
        return this;
    }
    /**
     * Grants permission to remove one or more outbound rules from a VPC security group
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RevokeSecurityGroupEgress.html
     */
    toRevokeSecurityGroupEgress() {
        this.to('ec2:RevokeSecurityGroupEgress');
        return this;
    }
    /**
     * Grants permission to remove one or more inbound rules from a security group
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RevokeSecurityGroupIngress.html
     */
    toRevokeSecurityGroupIngress() {
        this.to('ec2:RevokeSecurityGroupIngress');
        return this;
    }
    /**
     * Grants permission to launch one or more instances
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RunInstances.html
     */
    toRunInstances() {
        this.to('ec2:RunInstances');
        return this;
    }
    /**
     * Grants permission to launch one or more Scheduled Instances
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RunScheduledInstances.html
     */
    toRunScheduledInstances() {
        this.to('ec2:RunScheduledInstances');
        return this;
    }
    /**
     * Grants permission to search for routes in a local gateway route table
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_SearchLocalGatewayRoutes.html
     */
    toSearchLocalGatewayRoutes() {
        this.to('ec2:SearchLocalGatewayRoutes');
        return this;
    }
    /**
     * Grants permission to search for groups, sources, and members in a transit gateway multicast domain
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_SearchTransitGatewayMulticastGroups.html
     */
    toSearchTransitGatewayMulticastGroups() {
        this.to('ec2:SearchTransitGatewayMulticastGroups');
        return this;
    }
    /**
     * Grants permission to search for routes in a transit gateway route table
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_SearchTransitGatewayRoutes.html
     */
    toSearchTransitGatewayRoutes() {
        this.to('ec2:SearchTransitGatewayRoutes');
        return this;
    }
    /**
     * Grants permission to send a diagnostic interrupt to an Amazon EC2 instance
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_SendDiagnosticInterrupt.html
     */
    toSendDiagnosticInterrupt() {
        this.to('ec2:SendDiagnosticInterrupt');
        return this;
    }
    /**
     * Grants permission to start a stopped instance
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_StartInstances.html
     */
    toStartInstances() {
        this.to('ec2:StartInstances');
        return this;
    }
    /**
     * Grants permission to start the private DNS verification process for a VPC endpoint service
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_StartVpcEndpointServicePrivateDnsVerification.html
     */
    toStartVpcEndpointServicePrivateDnsVerification() {
        this.to('ec2:StartVpcEndpointServicePrivateDnsVerification');
        return this;
    }
    /**
     * Grants permission to stop an Amazon EBS-backed instance
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_StopInstances.html
     */
    toStopInstances() {
        this.to('ec2:StopInstances');
        return this;
    }
    /**
     * Grants permission to terminate active Client VPN endpoint connections
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_TerminateClientVpnConnections.html
     */
    toTerminateClientVpnConnections() {
        this.to('ec2:TerminateClientVpnConnections');
        return this;
    }
    /**
     * Grants permission to shut down one or more instances
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_TerminateInstances.html
     */
    toTerminateInstances() {
        this.to('ec2:TerminateInstances');
        return this;
    }
    /**
     * Grants permission to unassign one or more IPv6 addresses from a network interface
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_UnassignIpv6Addresses.html
     */
    toUnassignIpv6Addresses() {
        this.to('ec2:UnassignIpv6Addresses');
        return this;
    }
    /**
     * Grants permission to unassign one or more secondary private IP addresses from a network interface
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_UnassignPrivateIpAddresses.html
     */
    toUnassignPrivateIpAddresses() {
        this.to('ec2:UnassignPrivateIpAddresses');
        return this;
    }
    /**
     * Grants permission to disable detailed monitoring for a running instance
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_UnmonitorInstances.html
     */
    toUnmonitorInstances() {
        this.to('ec2:UnmonitorInstances');
        return this;
    }
    /**
     * Grants permission to update descriptions for one or more outbound rules in a VPC security group
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_UpdateSecurityGroupRuleDescriptionsEgress.html
     */
    toUpdateSecurityGroupRuleDescriptionsEgress() {
        this.to('ec2:UpdateSecurityGroupRuleDescriptionsEgress');
        return this;
    }
    /**
     * Grants permission to update descriptions for one or more inbound rules in a security group
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_UpdateSecurityGroupRuleDescriptionsIngress.html
     */
    toUpdateSecurityGroupRuleDescriptionsIngress() {
        this.to('ec2:UpdateSecurityGroupRuleDescriptionsIngress');
        return this;
    }
    /**
     * Grants permission to stop advertising an address range that was provisioned for use in AWS through bring your own IP addresses (BYOIP)
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_WithdrawByoipCidr.html
     */
    toWithdrawByoipCidr() {
        this.to('ec2:WithdrawByoipCidr');
        return this;
    }
    /**
     * Adds a resource of type capacity-reservation to the statement
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-capacity-reservations.html
     *
     * @param capacityReservationId - Identifier for the capacityReservationId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     * - .ifAwsTagKeys()
     * - .ifRegion()
     * - .ifResourceTag()
     */
    onCapacityReservation(capacityReservationId, account, region, partition) {
        var arn = 'arn:${Partition}:ec2:${Region}:${Account}:capacity-reservation/${CapacityReservationId}';
        arn = arn.replace('${CapacityReservationId}', capacityReservationId);
        arn = arn.replace('${Account}', account || '*');
        arn = arn.replace('${Region}', region || '*');
        arn = arn.replace('${Partition}', partition || 'aws');
        return this.on(arn);
    }
    /**
     * Adds a resource of type carrier-gateway to the statement
     *
     * https://docs.aws.amazon.com/vpc/latest/userguide/Carrier_Gateway.html
     *
     * @param carrierGatewayId - Identifier for the carrierGatewayId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     * - .ifAwsTagKeys()
     * - .ifRegion()
     * - .ifResourceTag()
     */
    onCarrierGateway(carrierGatewayId, account, region, partition) {
        var arn = 'arn:${Partition}:ec2:${Region}:${Account}:carrier-gateway/${CarrierGatewayId}';
        arn = arn.replace('${CarrierGatewayId}', carrierGatewayId);
        arn = arn.replace('${Account}', account || '*');
        arn = arn.replace('${Region}', region || '*');
        arn = arn.replace('${Partition}', partition || 'aws');
        return this.on(arn);
    }
    /**
     * Adds a resource of type client-vpn-endpoint to the statement
     *
     * https://docs.aws.amazon.com/vpn/latest/clientvpn-admin/what-is.html
     *
     * @param clientVpnEndpointId - Identifier for the clientVpnEndpointId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     * - .ifAwsTagKeys()
     * - .ifRegion()
     * - .ifResourceTag()
     */
    onClientVpnEndpoint(clientVpnEndpointId, account, region, partition) {
        var arn = 'arn:${Partition}:ec2:${Region}:${Account}:client-vpn-endpoint/${ClientVpnEndpointId}';
        arn = arn.replace('${ClientVpnEndpointId}', clientVpnEndpointId);
        arn = arn.replace('${Account}', account || '*');
        arn = arn.replace('${Region}', region || '*');
        arn = arn.replace('${Partition}', partition || 'aws');
        return this.on(arn);
    }
    /**
     * Adds a resource of type customer-gateway to the statement
     *
     * https://docs.aws.amazon.com/vpn/latest/s2svpn/VPC_VPN.html
     *
     * @param customerGatewayId - Identifier for the customerGatewayId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifRegion()
     * - .ifResourceTag()
     */
    onCustomerGateway(customerGatewayId, account, region, partition) {
        var arn = 'arn:${Partition}:ec2:${Region}:${Account}:customer-gateway/${CustomerGatewayId}';
        arn = arn.replace('${CustomerGatewayId}', customerGatewayId);
        arn = arn.replace('${Account}', account || '*');
        arn = arn.replace('${Region}', region || '*');
        arn = arn.replace('${Partition}', partition || 'aws');
        return this.on(arn);
    }
    /**
     * Adds a resource of type dedicated-host to the statement
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/dedicated-hosts-overview.html
     *
     * @param hostId - Identifier for the hostId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     * - .ifAwsTagKeys()
     * - .ifAutoPlacement()
     * - .ifAvailabilityZone()
     * - .ifHostRecovery()
     * - .ifInstanceType()
     * - .ifQuantity()
     * - .ifResourceTag()
     */
    onDedicatedHost(hostId, account, region, partition) {
        var arn = 'arn:${Partition}:ec2:${Region}:${Account}:dedicated-host/${HostId}';
        arn = arn.replace('${HostId}', hostId);
        arn = arn.replace('${Account}', account || '*');
        arn = arn.replace('${Region}', region || '*');
        arn = arn.replace('${Partition}', partition || 'aws');
        return this.on(arn);
    }
    /**
     * Adds a resource of type dhcp-options to the statement
     *
     * https://docs.aws.amazon.com/vpc/latest/userguide/VPC_DHCP_Options.html
     *
     * @param dhcpOptionsId - Identifier for the dhcpOptionsId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     * - .ifAwsTagKeys()
     * - .ifRegion()
     * - .ifResourceTag()
     */
    onDhcpOptions(dhcpOptionsId, account, region, partition) {
        var arn = 'arn:${Partition}:ec2:${Region}:${Account}:dhcp-options/${DhcpOptionsId}';
        arn = arn.replace('${DhcpOptionsId}', dhcpOptionsId);
        arn = arn.replace('${Account}', account || '*');
        arn = arn.replace('${Region}', region || '*');
        arn = arn.replace('${Partition}', partition || 'aws');
        return this.on(arn);
    }
    /**
     * Adds a resource of type egress-only-internet-gateway to the statement
     *
     * https://docs.aws.amazon.com/vpc/latest/userguide/egress-only-internet-gateway.html
     *
     * @param egressOnlyInternetGatewayId - Identifier for the egressOnlyInternetGatewayId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     * - .ifAwsTagKeys()
     * - .ifRegion()
     * - .ifResourceTag()
     */
    onEgressOnlyInternetGateway(egressOnlyInternetGatewayId, account, region, partition) {
        var arn = 'arn:${Partition}:ec2:${Region}:${Account}:egress-only-internet-gateway/${EgressOnlyInternetGatewayId}';
        arn = arn.replace('${EgressOnlyInternetGatewayId}', egressOnlyInternetGatewayId);
        arn = arn.replace('${Account}', account || '*');
        arn = arn.replace('${Region}', region || '*');
        arn = arn.replace('${Partition}', partition || 'aws');
        return this.on(arn);
    }
    /**
     * Adds a resource of type elastic-gpu to the statement
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/elastic-gpus.html
     *
     * @param elasticGpuId - Identifier for the elasticGpuId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifElasticGpuType()
     */
    onElasticGpu(elasticGpuId, account, region, partition) {
        var arn = 'arn:${Partition}:ec2:${Region}:${Account}:elastic-gpu/${ElasticGpuId}';
        arn = arn.replace('${ElasticGpuId}', elasticGpuId);
        arn = arn.replace('${Account}', account || '*');
        arn = arn.replace('${Region}', region || '*');
        arn = arn.replace('${Partition}', partition || 'aws');
        return this.on(arn);
    }
    /**
     * Adds a resource of type elastic-inference to the statement
     *
     * https://docs.aws.amazon.com/elastic-inference/latest/developerguide/what-is-ei.html
     *
     * @param elasticInferenceAcceleratorId - Identifier for the elasticInferenceAcceleratorId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     */
    onElasticInference(elasticInferenceAcceleratorId, account, region, partition) {
        var arn = 'arn:${Partition}:elastic-inference:${Region}:${Account}:elastic-inference-accelerator/${ElasticInferenceAcceleratorId}';
        arn = arn.replace('${ElasticInferenceAcceleratorId}', elasticInferenceAcceleratorId);
        arn = arn.replace('${Account}', account || '*');
        arn = arn.replace('${Region}', region || '*');
        arn = arn.replace('${Partition}', partition || 'aws');
        return this.on(arn);
    }
    /**
     * Adds a resource of type export-instance-task to the statement
     *
     * https://docs.aws.amazon.com/vm-import/latest/userguide/vmexport.html
     *
     * @param exportTaskId - Identifier for the exportTaskId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     * - .ifAwsTagKeys()
     * - .ifRegion()
     * - .ifResourceTag()
     */
    onExportInstanceTask(exportTaskId, account, region, partition) {
        var arn = 'arn:${Partition}:ec2:${Region}:${Account}:export-instance-task/${ExportTaskId}';
        arn = arn.replace('${ExportTaskId}', exportTaskId);
        arn = arn.replace('${Account}', account || '*');
        arn = arn.replace('${Region}', region || '*');
        arn = arn.replace('${Partition}', partition || 'aws');
        return this.on(arn);
    }
    /**
     * Adds a resource of type fleet to the statement
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-fleet.html
     *
     * @param fleetId - Identifier for the fleetId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     * - .ifAwsTagKeys()
     * - .ifRegion()
     * - .ifResourceTag()
     */
    onFleet(fleetId, account, region, partition) {
        var arn = 'arn:${Partition}:ec2:${Region}:${Account}:fleet/${FleetId}';
        arn = arn.replace('${FleetId}', fleetId);
        arn = arn.replace('${Account}', account || '*');
        arn = arn.replace('${Region}', region || '*');
        arn = arn.replace('${Partition}', partition || 'aws');
        return this.on(arn);
    }
    /**
     * Adds a resource of type fpga-image to the statement
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/iam-policy-structure.html#EC2_ARN_Format
     *
     * @param fpgaImageId - Identifier for the fpgaImageId.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     * - .ifAwsTagKeys()
     * - .ifOwner()
     * - .ifPublic()
     * - .ifRegion()
     * - .ifResourceTag()
     */
    onFpgaImage(fpgaImageId, region, partition) {
        var arn = 'arn:${Partition}:ec2:${Region}::fpga-image/${FpgaImageId}';
        arn = arn.replace('${FpgaImageId}', fpgaImageId);
        arn = arn.replace('${Region}', region || '*');
        arn = arn.replace('${Partition}', partition || 'aws');
        return this.on(arn);
    }
    /**
     * Adds a resource of type image to the statement
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/AMIs.html
     *
     * @param imageId - Identifier for the imageId.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     * - .ifAwsTagKeys()
     * - .ifImageType()
     * - .ifOwner()
     * - .ifPublic()
     * - .ifRegion()
     * - .ifResourceTag()
     * - .ifRootDeviceType()
     */
    onImage(imageId, region, partition) {
        var arn = 'arn:${Partition}:ec2:${Region}::image/${ImageId}';
        arn = arn.replace('${ImageId}', imageId);
        arn = arn.replace('${Region}', region || '*');
        arn = arn.replace('${Partition}', partition || 'aws');
        return this.on(arn);
    }
    /**
     * Adds a resource of type instance to the statement
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Instances.html
     *
     * @param instanceId - Identifier for the instanceId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     * - .ifAwsTagKeys()
     * - .ifAvailabilityZone()
     * - .ifEbsOptimized()
     * - .ifInstanceProfile()
     * - .ifInstanceType()
     * - .ifPlacementGroup()
     * - .ifRegion()
     * - .ifResourceTag()
     * - .ifRootDeviceType()
     * - .ifTenancy()
     */
    onInstance(instanceId, account, region, partition) {
        var arn = 'arn:${Partition}:ec2:${Region}:${Account}:instance/${InstanceId}';
        arn = arn.replace('${InstanceId}', instanceId);
        arn = arn.replace('${Account}', account || '*');
        arn = arn.replace('${Region}', region || '*');
        arn = arn.replace('${Partition}', partition || 'aws');
        return this.on(arn);
    }
    /**
     * Adds a resource of type internet-gateway to the statement
     *
     * https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Internet_Gateway.html
     *
     * @param internetGatewayId - Identifier for the internetGatewayId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     * - .ifAwsTagKeys()
     * - .ifRegion()
     * - .ifResourceTag()
     */
    onInternetGateway(internetGatewayId, account, region, partition) {
        var arn = 'arn:${Partition}:ec2:${Region}:${Account}:internet-gateway/${InternetGatewayId}';
        arn = arn.replace('${InternetGatewayId}', internetGatewayId);
        arn = arn.replace('${Account}', account || '*');
        arn = arn.replace('${Region}', region || '*');
        arn = arn.replace('${Partition}', partition || 'aws');
        return this.on(arn);
    }
    /**
     * Adds a resource of type key-pair to the statement
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-key-pairs.html
     *
     * @param keyPairName - Identifier for the keyPairName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     * - .ifAwsTagKeys()
     * - .ifRegion()
     * - .ifResourceTag()
     */
    onKeyPair(keyPairName, account, region, partition) {
        var arn = 'arn:${Partition}:ec2:${Region}:${Account}:key-pair/${KeyPairName}';
        arn = arn.replace('${KeyPairName}', keyPairName);
        arn = arn.replace('${Account}', account || '*');
        arn = arn.replace('${Region}', region || '*');
        arn = arn.replace('${Partition}', partition || 'aws');
        return this.on(arn);
    }
    /**
     * Adds a resource of type launch-template to the statement
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-launch-templates.html
     *
     * @param launchTemplateId - Identifier for the launchTemplateId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     * - .ifAwsTagKeys()
     * - .ifRegion()
     * - .ifResourceTag()
     */
    onLaunchTemplate(launchTemplateId, account, region, partition) {
        var arn = 'arn:${Partition}:ec2:${Region}:${Account}:launch-template/${LaunchTemplateId}';
        arn = arn.replace('${LaunchTemplateId}', launchTemplateId);
        arn = arn.replace('${Account}', account || '*');
        arn = arn.replace('${Region}', region || '*');
        arn = arn.replace('${Partition}', partition || 'aws');
        return this.on(arn);
    }
    /**
     * Adds a resource of type local-gateway to the statement
     *
     * https://docs.aws.amazon.com/outposts/latest/userguide/outposts-local-gateways.html
     *
     * @param localGatewayId - Identifier for the localGatewayId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     * - .ifAwsTagKeys()
     * - .ifRegion()
     * - .ifResourceTag()
     */
    onLocalGateway(localGatewayId, account, region, partition) {
        var arn = 'arn:${Partition}:ec2:${Region}:${Account}:local-gateway/${LocalGatewayId}';
        arn = arn.replace('${LocalGatewayId}', localGatewayId);
        arn = arn.replace('${Account}', account || '*');
        arn = arn.replace('${Region}', region || '*');
        arn = arn.replace('${Partition}', partition || 'aws');
        return this.on(arn);
    }
    /**
     * Adds a resource of type local-gateway-route-table to the statement
     *
     * https://docs.aws.amazon.com/outposts/latest/userguide/outposts-local-gateways.html
     *
     * @param localGatewayRouteTableId - Identifier for the localGatewayRouteTableId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     * - .ifAwsTagKeys()
     * - .ifRegion()
     * - .ifResourceTag()
     */
    onLocalGatewayRouteTable(localGatewayRouteTableId, account, region, partition) {
        var arn = 'arn:${Partition}:ec2:${Region}:${Account}:local-gateway-route-table/${LocalGatewayRouteTableId}';
        arn = arn.replace('${LocalGatewayRouteTableId}', localGatewayRouteTableId);
        arn = arn.replace('${Account}', account || '*');
        arn = arn.replace('${Region}', region || '*');
        arn = arn.replace('${Partition}', partition || 'aws');
        return this.on(arn);
    }
    /**
     * Adds a resource of type local-gateway-route-table-virtual-interface-group-association to the statement
     *
     * https://docs.aws.amazon.com/outposts/latest/userguide/outposts-local-gateways.html
     *
     * @param localGatewayRouteTableVirtualInterfaceGroupAssociationId - Identifier for the localGatewayRouteTableVirtualInterfaceGroupAssociationId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     * - .ifAwsTagKeys()
     * - .ifRegion()
     * - .ifResourceTag()
     */
    onLocalGatewayRouteTableVirtualInterfaceGroupAssociation(localGatewayRouteTableVirtualInterfaceGroupAssociationId, account, region, partition) {
        var arn = 'arn:${Partition}:ec2:${Region}:${Account}:local-gateway-route-table-virtual-interface-group-association/${LocalGatewayRouteTableVirtualInterfaceGroupAssociationId}';
        arn = arn.replace('${LocalGatewayRouteTableVirtualInterfaceGroupAssociationId}', localGatewayRouteTableVirtualInterfaceGroupAssociationId);
        arn = arn.replace('${Account}', account || '*');
        arn = arn.replace('${Region}', region || '*');
        arn = arn.replace('${Partition}', partition || 'aws');
        return this.on(arn);
    }
    /**
     * Adds a resource of type local-gateway-route-table-vpc-association to the statement
     *
     * https://docs.aws.amazon.com/outposts/latest/userguide/outposts-local-gateways.html
     *
     * @param localGatewayRouteTableVpcAssociationId - Identifier for the localGatewayRouteTableVpcAssociationId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     * - .ifAwsTagKeys()
     * - .ifRegion()
     * - .ifResourceTag()
     */
    onLocalGatewayRouteTableVpcAssociation(localGatewayRouteTableVpcAssociationId, account, region, partition) {
        var arn = 'arn:${Partition}:ec2:${Region}:${Account}:local-gateway-route-table-vpc-association/${LocalGatewayRouteTableVpcAssociationId}';
        arn = arn.replace('${LocalGatewayRouteTableVpcAssociationId}', localGatewayRouteTableVpcAssociationId);
        arn = arn.replace('${Account}', account || '*');
        arn = arn.replace('${Region}', region || '*');
        arn = arn.replace('${Partition}', partition || 'aws');
        return this.on(arn);
    }
    /**
     * Adds a resource of type local-gateway-virtual-interface to the statement
     *
     * https://docs.aws.amazon.com/outposts/latest/userguide/outposts-local-gateways.html
     *
     * @param localGatewayVirtualInterfaceId - Identifier for the localGatewayVirtualInterfaceId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     * - .ifAwsTagKeys()
     * - .ifRegion()
     * - .ifResourceTag()
     */
    onLocalGatewayVirtualInterface(localGatewayVirtualInterfaceId, account, region, partition) {
        var arn = 'arn:${Partition}:ec2:${Region}:${Account}:local-gateway-virtual-interface/${LocalGatewayVirtualInterfaceId}';
        arn = arn.replace('${LocalGatewayVirtualInterfaceId}', localGatewayVirtualInterfaceId);
        arn = arn.replace('${Account}', account || '*');
        arn = arn.replace('${Region}', region || '*');
        arn = arn.replace('${Partition}', partition || 'aws');
        return this.on(arn);
    }
    /**
     * Adds a resource of type local-gateway-virtual-interface-group to the statement
     *
     * https://docs.aws.amazon.com/outposts/latest/userguide/outposts-local-gateways.html
     *
     * @param localGatewayVirtualInterfaceGroupId - Identifier for the localGatewayVirtualInterfaceGroupId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     * - .ifAwsTagKeys()
     * - .ifRegion()
     * - .ifResourceTag()
     */
    onLocalGatewayVirtualInterfaceGroup(localGatewayVirtualInterfaceGroupId, account, region, partition) {
        var arn = 'arn:${Partition}:ec2:${Region}:${Account}:local-gateway-virtual-interface-group/${LocalGatewayVirtualInterfaceGroupId}';
        arn = arn.replace('${LocalGatewayVirtualInterfaceGroupId}', localGatewayVirtualInterfaceGroupId);
        arn = arn.replace('${Account}', account || '*');
        arn = arn.replace('${Region}', region || '*');
        arn = arn.replace('${Partition}', partition || 'aws');
        return this.on(arn);
    }
    /**
     * Adds a resource of type natgateway to the statement
     *
     * https://docs.aws.amazon.com/vpc/latest/userguide/vpc-nat-gateway.html
     *
     * @param natGatewayId - Identifier for the natGatewayId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     * - .ifAwsTagKeys()
     * - .ifRegion()
     * - .ifResourceTag()
     */
    onNatgateway(natGatewayId, account, region, partition) {
        var arn = 'arn:${Partition}:ec2:${Region}:${Account}:natgateway/${NatGatewayId}';
        arn = arn.replace('${NatGatewayId}', natGatewayId);
        arn = arn.replace('${Account}', account || '*');
        arn = arn.replace('${Region}', region || '*');
        arn = arn.replace('${Partition}', partition || 'aws');
        return this.on(arn);
    }
    /**
     * Adds a resource of type network-acl to the statement
     *
     * https://docs.aws.amazon.com/vpc/latest/userguide/vpc-network-acls.html
     *
     * @param naclId - Identifier for the naclId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     * - .ifAwsTagKeys()
     * - .ifRegion()
     * - .ifResourceTag()
     * - .ifVpc()
     */
    onNetworkAcl(naclId, account, region, partition) {
        var arn = 'arn:${Partition}:ec2:${Region}:${Account}:network-acl/${NaclId}';
        arn = arn.replace('${NaclId}', naclId);
        arn = arn.replace('${Account}', account || '*');
        arn = arn.replace('${Region}', region || '*');
        arn = arn.replace('${Partition}', partition || 'aws');
        return this.on(arn);
    }
    /**
     * Adds a resource of type network-interface to the statement
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-eni.html
     *
     * @param networkInterfaceId - Identifier for the networkInterfaceId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     * - .ifAwsTagKeys()
     * - .ifAssociatePublicIpAddress()
     * - .ifAuthorizedService()
     * - .ifAvailabilityZone()
     * - .ifRegion()
     * - .ifResourceTag()
     * - .ifSubnet()
     * - .ifVpc()
     */
    onNetworkInterface(networkInterfaceId, account, region, partition) {
        var arn = 'arn:${Partition}:ec2:${Region}:${Account}:network-interface/${NetworkInterfaceId}';
        arn = arn.replace('${NetworkInterfaceId}', networkInterfaceId);
        arn = arn.replace('${Account}', account || '*');
        arn = arn.replace('${Region}', region || '*');
        arn = arn.replace('${Partition}', partition || 'aws');
        return this.on(arn);
    }
    /**
     * Adds a resource of type placement-group to the statement
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/placement-groups.html
     *
     * @param placementGroupName - Identifier for the placementGroupName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     * - .ifAwsTagKeys()
     * - .ifPlacementGroupStrategy()
     * - .ifRegion()
     * - .ifResourceTag()
     */
    onPlacementGroup(placementGroupName, account, region, partition) {
        var arn = 'arn:${Partition}:ec2:${Region}:${Account}:placement-group/${PlacementGroupName}';
        arn = arn.replace('${PlacementGroupName}', placementGroupName);
        arn = arn.replace('${Account}', account || '*');
        arn = arn.replace('${Region}', region || '*');
        arn = arn.replace('${Partition}', partition || 'aws');
        return this.on(arn);
    }
    /**
     * Adds a resource of type prefix-list to the statement
     *
     * @param prefixListId - Identifier for the prefixListId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     * - .ifAwsTagKeys()
     * - .ifRegion()
     * - .ifResourceTag()
     */
    onPrefixList(prefixListId, account, region, partition) {
        var arn = 'arn:${Partition}:ec2:${Region}:${Account}:prefix-list/${PrefixListId}';
        arn = arn.replace('${PrefixListId}', prefixListId);
        arn = arn.replace('${Account}', account || '*');
        arn = arn.replace('${Region}', region || '*');
        arn = arn.replace('${Partition}', partition || 'aws');
        return this.on(arn);
    }
    /**
     * Adds a resource of type reserved-instances to the statement
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-reserved-instances.html
     *
     * @param reservationId - Identifier for the reservationId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     * - .ifAwsTagKeys()
     * - .ifAvailabilityZone()
     * - .ifInstanceType()
     * - .ifRegion()
     * - .ifReservedInstancesOfferingType()
     * - .ifResourceTag()
     * - .ifTenancy()
     */
    onReservedInstances(reservationId, account, region, partition) {
        var arn = 'arn:${Partition}:ec2:${Region}:${Account}:reserved-instances/${ReservationId}';
        arn = arn.replace('${ReservationId}', reservationId);
        arn = arn.replace('${Account}', account || '*');
        arn = arn.replace('${Region}', region || '*');
        arn = arn.replace('${Partition}', partition || 'aws');
        return this.on(arn);
    }
    /**
     * Adds a resource of type route-table to the statement
     *
     * https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Route_Tables.html
     *
     * @param routeTableId - Identifier for the routeTableId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     * - .ifAwsTagKeys()
     * - .ifRegion()
     * - .ifResourceTag()
     * - .ifVpc()
     */
    onRouteTable(routeTableId, account, region, partition) {
        var arn = 'arn:${Partition}:ec2:${Region}:${Account}:route-table/${RouteTableId}';
        arn = arn.replace('${RouteTableId}', routeTableId);
        arn = arn.replace('${Account}', account || '*');
        arn = arn.replace('${Region}', region || '*');
        arn = arn.replace('${Partition}', partition || 'aws');
        return this.on(arn);
    }
    /**
     * Adds a resource of type security-group to the statement
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-security-groups.html
     *
     * @param securityGroupId - Identifier for the securityGroupId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     * - .ifAwsTagKeys()
     * - .ifRegion()
     * - .ifResourceTag()
     * - .ifVpc()
     */
    onSecurityGroup(securityGroupId, account, region, partition) {
        var arn = 'arn:${Partition}:ec2:${Region}:${Account}:security-group/${SecurityGroupId}';
        arn = arn.replace('${SecurityGroupId}', securityGroupId);
        arn = arn.replace('${Account}', account || '*');
        arn = arn.replace('${Region}', region || '*');
        arn = arn.replace('${Partition}', partition || 'aws');
        return this.on(arn);
    }
    /**
     * Adds a resource of type snapshot to the statement
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSSnapshots.html
     *
     * @param snapshotId - Identifier for the snapshotId.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     * - .ifAwsTagKeys()
     * - .ifOwner()
     * - .ifParentVolume()
     * - .ifRegion()
     * - .ifResourceTag()
     * - .ifSnapshotTime()
     * - .ifVolumeSize()
     */
    onSnapshot(snapshotId, region, partition) {
        var arn = 'arn:${Partition}:ec2:${Region}::snapshot/${SnapshotId}';
        arn = arn.replace('${SnapshotId}', snapshotId);
        arn = arn.replace('${Region}', region || '*');
        arn = arn.replace('${Partition}', partition || 'aws');
        return this.on(arn);
    }
    /**
     * Adds a resource of type spot-instance-request to the statement
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-spot-instances.html
     *
     * @param spotInstanceRequestId - Identifier for the spotInstanceRequestId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     * - .ifAwsTagKeys()
     * - .ifRegion()
     * - .ifResourceTag()
     */
    onSpotInstanceRequest(spotInstanceRequestId, account, region, partition) {
        var arn = 'arn:${Partition}:ec2:${Region}:${Account}:spot-instances-request/${SpotInstanceRequestId}';
        arn = arn.replace('${SpotInstanceRequestId}', spotInstanceRequestId);
        arn = arn.replace('${Account}', account || '*');
        arn = arn.replace('${Region}', region || '*');
        arn = arn.replace('${Partition}', partition || 'aws');
        return this.on(arn);
    }
    /**
     * Adds a resource of type subnet to the statement
     *
     * https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html
     *
     * @param subnetId - Identifier for the subnetId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     * - .ifAwsTagKeys()
     * - .ifAvailabilityZone()
     * - .ifRegion()
     * - .ifResourceTag()
     * - .ifVpc()
     */
    onSubnet(subnetId, account, region, partition) {
        var arn = 'arn:${Partition}:ec2:${Region}:${Account}:subnet/${SubnetId}';
        arn = arn.replace('${SubnetId}', subnetId);
        arn = arn.replace('${Account}', account || '*');
        arn = arn.replace('${Region}', region || '*');
        arn = arn.replace('${Partition}', partition || 'aws');
        return this.on(arn);
    }
    /**
     * Adds a resource of type traffic-mirror-session to the statement
     *
     * https://docs.aws.amazon.com/vpc/latest/mirroring/traffic-mirroring-session.html
     *
     * @param trafficMirrorSessionId - Identifier for the trafficMirrorSessionId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     * - .ifAwsTagKeys()
     * - .ifRegion()
     * - .ifResourceTag()
     */
    onTrafficMirrorSession(trafficMirrorSessionId, account, region, partition) {
        var arn = 'arn:${Partition}:ec2:${Region}:${Account}:traffic-mirror-session/${TrafficMirrorSessionId}';
        arn = arn.replace('${TrafficMirrorSessionId}', trafficMirrorSessionId);
        arn = arn.replace('${Account}', account || '*');
        arn = arn.replace('${Region}', region || '*');
        arn = arn.replace('${Partition}', partition || 'aws');
        return this.on(arn);
    }
    /**
     * Adds a resource of type traffic-mirror-target to the statement
     *
     * https://docs.aws.amazon.com/vpc/latest/mirroring/traffic-mirroring-target.html
     *
     * @param trafficMirrorTargetId - Identifier for the trafficMirrorTargetId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     * - .ifAwsTagKeys()
     * - .ifRegion()
     * - .ifResourceTag()
     */
    onTrafficMirrorTarget(trafficMirrorTargetId, account, region, partition) {
        var arn = 'arn:${Partition}:ec2:${Region}:${Account}:traffic-mirror-target/${TrafficMirrorTargetId}';
        arn = arn.replace('${TrafficMirrorTargetId}', trafficMirrorTargetId);
        arn = arn.replace('${Account}', account || '*');
        arn = arn.replace('${Region}', region || '*');
        arn = arn.replace('${Partition}', partition || 'aws');
        return this.on(arn);
    }
    /**
     * Adds a resource of type traffic-mirror-filter to the statement
     *
     * https://docs.aws.amazon.com/vpc/latest/mirroring/traffic-mirroring-filter.html
     *
     * @param trafficMirrorFilterId - Identifier for the trafficMirrorFilterId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     * - .ifAwsTagKeys()
     * - .ifRegion()
     * - .ifResourceTag()
     */
    onTrafficMirrorFilter(trafficMirrorFilterId, account, region, partition) {
        var arn = 'arn:${Partition}:ec2:${Region}:${Account}:traffic-mirror-filter/${TrafficMirrorFilterId}';
        arn = arn.replace('${TrafficMirrorFilterId}', trafficMirrorFilterId);
        arn = arn.replace('${Account}', account || '*');
        arn = arn.replace('${Region}', region || '*');
        arn = arn.replace('${Partition}', partition || 'aws');
        return this.on(arn);
    }
    /**
     * Adds a resource of type traffic-mirror-filter-rule to the statement
     *
     * https://docs.aws.amazon.com/vpc/latest/mirroring/traffic-mirroring-filter.html
     *
     * @param trafficMirrorFilterRuleId - Identifier for the trafficMirrorFilterRuleId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifRegion()
     */
    onTrafficMirrorFilterRule(trafficMirrorFilterRuleId, account, region, partition) {
        var arn = 'arn:${Partition}:ec2:${Region}:${Account}:traffic-mirror-filter-rule/${TrafficMirrorFilterRuleId}';
        arn = arn.replace('${TrafficMirrorFilterRuleId}', trafficMirrorFilterRuleId);
        arn = arn.replace('${Account}', account || '*');
        arn = arn.replace('${Region}', region || '*');
        arn = arn.replace('${Partition}', partition || 'aws');
        return this.on(arn);
    }
    /**
     * Adds a resource of type transit-gateway-attachment to the statement
     *
     * https://docs.aws.amazon.com/vpc/latest/tgw/how-transit-gateways-work.html
     *
     * @param transitGatewayAttachmentId - Identifier for the transitGatewayAttachmentId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     * - .ifAwsTagKeys()
     * - .ifRegion()
     * - .ifResourceTag()
     */
    onTransitGatewayAttachment(transitGatewayAttachmentId, account, region, partition) {
        var arn = 'arn:${Partition}:ec2:${Region}:${Account}:transit-gateway-attachment/${TransitGatewayAttachmentId}';
        arn = arn.replace('${TransitGatewayAttachmentId}', transitGatewayAttachmentId);
        arn = arn.replace('${Account}', account || '*');
        arn = arn.replace('${Region}', region || '*');
        arn = arn.replace('${Partition}', partition || 'aws');
        return this.on(arn);
    }
    /**
     * Adds a resource of type transit-gateway-multicast-domain to the statement
     *
     * https://docs.aws.amazon.com/vpc/latest/tgw/tgw-multicast-overview.html
     *
     * @param transitGatewayMulticastDomainId - Identifier for the transitGatewayMulticastDomainId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     * - .ifAwsTagKeys()
     * - .ifRegion()
     * - .ifResourceTag()
     */
    onTransitGatewayMulticastDomain(transitGatewayMulticastDomainId, account, region, partition) {
        var arn = 'arn:${Partition}:ec2:${Region}:${Account}:transit-gateway-multicast-domain/${TransitGatewayMulticastDomainId}';
        arn = arn.replace('${TransitGatewayMulticastDomainId}', transitGatewayMulticastDomainId);
        arn = arn.replace('${Account}', account || '*');
        arn = arn.replace('${Region}', region || '*');
        arn = arn.replace('${Partition}', partition || 'aws');
        return this.on(arn);
    }
    /**
     * Adds a resource of type transit-gateway-route-table to the statement
     *
     * https://docs.aws.amazon.com/vpc/latest/tgw/how-transit-gateways-work.html
     *
     * @param transitGatewayRouteTableId - Identifier for the transitGatewayRouteTableId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     * - .ifAwsTagKeys()
     * - .ifRegion()
     * - .ifResourceTag()
     */
    onTransitGatewayRouteTable(transitGatewayRouteTableId, account, region, partition) {
        var arn = 'arn:${Partition}:ec2:${Region}:${Account}:transit-gateway-route-table/${TransitGatewayRouteTableId}';
        arn = arn.replace('${TransitGatewayRouteTableId}', transitGatewayRouteTableId);
        arn = arn.replace('${Account}', account || '*');
        arn = arn.replace('${Region}', region || '*');
        arn = arn.replace('${Partition}', partition || 'aws');
        return this.on(arn);
    }
    /**
     * Adds a resource of type transit-gateway to the statement
     *
     * https://docs.aws.amazon.com/vpc/latest/tgw/how-transit-gateways-work.html
     *
     * @param transitGatewayId - Identifier for the transitGatewayId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     * - .ifAwsTagKeys()
     * - .ifRegion()
     * - .ifResourceTag()
     */
    onTransitGateway(transitGatewayId, account, region, partition) {
        var arn = 'arn:${Partition}:ec2:${Region}:${Account}:transit-gateway/${TransitGatewayId}';
        arn = arn.replace('${TransitGatewayId}', transitGatewayId);
        arn = arn.replace('${Account}', account || '*');
        arn = arn.replace('${Region}', region || '*');
        arn = arn.replace('${Partition}', partition || 'aws');
        return this.on(arn);
    }
    /**
     * Adds a resource of type volume to the statement
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-volumes.html
     *
     * @param volumeId - Identifier for the volumeId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     * - .ifAwsTagKeys()
     * - .ifAvailabilityZone()
     * - .ifEncrypted()
     * - .ifParentSnapshot()
     * - .ifRegion()
     * - .ifResourceTag()
     * - .ifVolumeIops()
     * - .ifVolumeSize()
     * - .ifVolumeType()
     */
    onVolume(volumeId, account, region, partition) {
        var arn = 'arn:${Partition}:ec2:${Region}:${Account}:volume/${VolumeId}';
        arn = arn.replace('${VolumeId}', volumeId);
        arn = arn.replace('${Account}', account || '*');
        arn = arn.replace('${Region}', region || '*');
        arn = arn.replace('${Partition}', partition || 'aws');
        return this.on(arn);
    }
    /**
     * Adds a resource of type vpc to the statement
     *
     * https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html
     *
     * @param vpcId - Identifier for the vpcId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     * - .ifAwsTagKeys()
     * - .ifRegion()
     * - .ifResourceTag()
     * - .ifTenancy()
     */
    onVpc(vpcId, account, region, partition) {
        var arn = 'arn:${Partition}:ec2:${Region}:${Account}:vpc/${VpcId}';
        arn = arn.replace('${VpcId}', vpcId);
        arn = arn.replace('${Account}', account || '*');
        arn = arn.replace('${Region}', region || '*');
        arn = arn.replace('${Partition}', partition || 'aws');
        return this.on(arn);
    }
    /**
     * Adds a resource of type vpc-endpoint to the statement
     *
     * https://docs.aws.amazon.com/vpc/latest/userguide/endpoint-services-overview.html
     *
     * @param vpceId - Identifier for the vpceId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     * - .ifAwsTagKeys()
     * - .ifRegion()
     * - .ifResourceTag()
     * - .ifVpceServiceName()
     * - .ifVpceServiceOwner()
     */
    onVpcEndpoint(vpceId, account, region, partition) {
        var arn = 'arn:${Partition}:ec2:${Region}:${Account}:vpc-endpoint/${VpceId}';
        arn = arn.replace('${VpceId}', vpceId);
        arn = arn.replace('${Account}', account || '*');
        arn = arn.replace('${Region}', region || '*');
        arn = arn.replace('${Partition}', partition || 'aws');
        return this.on(arn);
    }
    /**
     * Adds a resource of type vpc-endpoint-service to the statement
     *
     * https://docs.aws.amazon.com/vpc/latest/userguide/endpoint-services-overview.html
     *
     * @param vpceServiceId - Identifier for the vpceServiceId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     * - .ifAwsTagKeys()
     * - .ifRegion()
     * - .ifResourceTag()
     * - .ifVpceServicePrivateDnsName()
     */
    onVpcEndpointService(vpceServiceId, account, region, partition) {
        var arn = 'arn:${Partition}:ec2:${Region}:${Account}:vpc-endpoint-service/${VpceServiceId}';
        arn = arn.replace('${VpceServiceId}', vpceServiceId);
        arn = arn.replace('${Account}', account || '*');
        arn = arn.replace('${Region}', region || '*');
        arn = arn.replace('${Partition}', partition || 'aws');
        return this.on(arn);
    }
    /**
     * Adds a resource of type vpc-flow-log to the statement
     *
     * https://docs.aws.amazon.com/vpc/latest/userguide/flow-logs.html
     *
     * @param vpcFlowLogId - Identifier for the vpcFlowLogId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     * - .ifAwsTagKeys()
     * - .ifRegion()
     * - .ifResourceTag()
     */
    onVpcFlowLog(vpcFlowLogId, account, region, partition) {
        var arn = 'arn:${Partition}:ec2:${Region}:${Account}:vpc-flow-log/${VpcFlowLogId}';
        arn = arn.replace('${VpcFlowLogId}', vpcFlowLogId);
        arn = arn.replace('${Account}', account || '*');
        arn = arn.replace('${Region}', region || '*');
        arn = arn.replace('${Partition}', partition || 'aws');
        return this.on(arn);
    }
    /**
     * Adds a resource of type vpc-peering-connection to the statement
     *
     * https://docs.aws.amazon.com/vpc/latest/peering/what-is-vpc-peering.html
     *
     * @param vpcPeeringConnectionId - Identifier for the vpcPeeringConnectionId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifAccepterVpc()
     * - .ifRegion()
     * - .ifRequesterVpc()
     * - .ifResourceTag()
     */
    onVpcPeeringConnection(vpcPeeringConnectionId, account, region, partition) {
        var arn = 'arn:${Partition}:ec2:${Region}:${Account}:vpc-peering-connection/${VpcPeeringConnectionId}';
        arn = arn.replace('${VpcPeeringConnectionId}', vpcPeeringConnectionId);
        arn = arn.replace('${Account}', account || '*');
        arn = arn.replace('${Region}', region || '*');
        arn = arn.replace('${Partition}', partition || 'aws');
        return this.on(arn);
    }
    /**
     * Adds a resource of type vpn-connection to the statement
     *
     * https://docs.aws.amazon.com/vpn/latest/s2svpn/VPC_VPN.html
     *
     * @param vpnConnectionId - Identifier for the vpnConnectionId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     * - .ifAwsTagKeys()
     * - .ifAuthenticationType()
     * - .ifDPDTimeoutSeconds()
     * - .ifGatewayType()
     * - .ifIKEVersions()
     * - .ifInsideTunnelCidr()
     * - .ifPhase1DHGroupNumbers()
     * - .ifPhase1EncryptionAlgorithms()
     * - .ifPhase1IntegrityAlgorithms()
     * - .ifPhase1LifetimeSeconds()
     * - .ifPhase2DHGroupNumbers()
     * - .ifPhase2EncryptionAlgorithms()
     * - .ifPhase2IntegrityAlgorithms()
     * - .ifPhase2LifetimeSeconds()
     * - .ifPresharedKeys()
     * - .ifRegion()
     * - .ifRekeyFuzzPercentage()
     * - .ifRekeyMarginTimeSeconds()
     * - .ifResourceTag()
     * - .ifRoutingType()
     */
    onVpnConnection(vpnConnectionId, account, region, partition) {
        var arn = 'arn:${Partition}:ec2:${Region}:${Account}:vpn-connection/${VpnConnectionId}';
        arn = arn.replace('${VpnConnectionId}', vpnConnectionId);
        arn = arn.replace('${Account}', account || '*');
        arn = arn.replace('${Region}', region || '*');
        arn = arn.replace('${Partition}', partition || 'aws');
        return this.on(arn);
    }
    /**
     * Adds a resource of type vpn-gateway to the statement
     *
     * https://docs.aws.amazon.com/vpn/latest/s2svpn/VPC_VPN.html
     *
     * @param vpnGatewayId - Identifier for the vpnGatewayId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     */
    onVpnGateway(vpnGatewayId, account, region, partition) {
        var arn = 'arn:${Partition}:ec2:${Region}:${Account}:vpn-gateway/${VpnGatewayId}';
        arn = arn.replace('${VpnGatewayId}', vpnGatewayId);
        arn = arn.replace('${Account}', account || '*');
        arn = arn.replace('${Region}', region || '*');
        arn = arn.replace('${Partition}', partition || 'aws');
        return this.on(arn);
    }
    /**
     * Filters access by the ARN of an accepter VPC in a VPC peering connection
     *
     * https://docs.aws.amazon.com/vpc/latest/peering/security-iam.html
     *
     * Applies to actions:
     * - .toAcceptVpcPeeringConnection()
     * - .toCreateVpcPeeringConnection()
     * - .toDeleteVpcPeeringConnection()
     * - .toRejectVpcPeeringConnection()
     *
     * Applies to resource types:
     * - vpc-peering-connection
     *
     * @param value The value(s) to check
     * @param operator Works with [arn operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_ARN). **Default:** `ArnLike`
     */
    ifAccepterVpc(value, operator) {
        return this.if(`ec2:AccepterVpc`, value, operator || 'ArnLike');
    }
    /**
     * Filters access by whether the user wants to associate a public IP address with the instance
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/iam-policy-structure.html#amazon-ec2-keys
     *
     * Applies to actions:
     * - .toCreateTags()
     * - .toRunInstances()
     *
     * Applies to resource types:
     * - network-interface
     *
     * @param value `true` or `false`. **Default:** `true`
     */
    ifAssociatePublicIpAddress(value) {
        return this.if(`ec2:AssociatePublicIpAddress`, (typeof value !== 'undefined' ? value : true), 'Bool');
    }
    /**
     * Filters access by the authentication type for the VPN tunnel endpoints
     *
     * https://docs.aws.amazon.com/vpn/latest/s2svpn/vpn-authentication-access-control.html
     *
     * Applies to actions:
     * - .toCreateVpnConnection()
     * - .toModifyVpnTunnelOptions()
     *
     * Applies to resource types:
     * - vpn-connection
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAuthenticationType(value, operator) {
        return this.if(`ec2:AuthenticationType`, value, operator || 'StringLike');
    }
    /**
     * Filters access by the AWS service that has permission to use a resource
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/iam-policy-structure.html#amazon-ec2-keys
     *
     * Applies to actions:
     * - .toCreateNetworkInterfacePermission()
     *
     * Applies to resource types:
     * - network-interface
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAuthorizedService(value, operator) {
        return this.if(`ec2:AuthorizedService`, value, operator || 'StringLike');
    }
    /**
     * Filters access by an IAM principal that has permission to use a resource
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/iam-policy-structure.html#amazon-ec2-keys
     *
     * Applies to actions:
     * - .toCreateNetworkInterfacePermission()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAuthorizedUser(value, operator) {
        return this.if(`ec2:AuthorizedUser`, value, operator || 'StringLike');
    }
    /**
     * Filters access by the Auto Placement properties of a Dedicated Host
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/iam-policy-structure.html#amazon-ec2-keys
     *
     * Applies to resource types:
     * - dedicated-host
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAutoPlacement(value, operator) {
        return this.if(`ec2:AutoPlacement`, value, operator || 'StringLike');
    }
    /**
     * Filters access by the name of an Availability Zone in an AWS Region
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/iam-policy-structure.html#amazon-ec2-keys
     *
     * Applies to actions:
     * - .toAssociateIamInstanceProfile()
     * - .toAttachClassicLinkVpc()
     * - .toAttachVolume()
     * - .toCreateFlowLogs()
     * - .toCreateNetworkInterfacePermission()
     * - .toCreateSnapshots()
     * - .toCreateTags()
     * - .toCreateVolume()
     * - .toDeleteVolume()
     * - .toDetachClassicLinkVpc()
     * - .toDetachVolume()
     * - .toDisableFastSnapshotRestores()
     * - .toDisassociateIamInstanceProfile()
     * - .toEnableFastSnapshotRestores()
     * - .toGetConsoleScreenshot()
     * - .toRebootInstances()
     * - .toReplaceIamInstanceProfileAssociation()
     * - .toRunInstances()
     * - .toSendDiagnosticInterrupt()
     * - .toStartInstances()
     * - .toStopInstances()
     * - .toTerminateInstances()
     *
     * Applies to resource types:
     * - dedicated-host
     * - instance
     * - network-interface
     * - reserved-instances
     * - subnet
     * - volume
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAvailabilityZone(value, operator) {
        return this.if(`ec2:AvailabilityZone`, value, operator || 'StringLike');
    }
    /**
     * Filters access by the name of a resource-creating API action
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/supported-iam-actions-tagging.html
     *
     * Applies to actions:
     * - .toCreateTags()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifCreateAction(value, operator) {
        return this.if(`ec2:CreateAction`, value, operator || 'StringLike');
    }
    /**
     * Filters access by the duration after which DPD timeout occurs on a VPN tunnel
     *
     * https://docs.aws.amazon.com/vpn/latest/s2svpn/vpn-authentication-access-control.html
     *
     * Applies to actions:
     * - .toCreateVpnConnection()
     * - .toModifyVpnTunnelOptions()
     *
     * Applies to resource types:
     * - vpn-connection
     *
     * @param value The value(s) to check
     * @param operator Works with [numeric operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_Numeric). **Default:** `NumericEquals`
     */
    ifDPDTimeoutSeconds(value, operator) {
        return this.if(`ec2:DPDTimeoutSeconds`, value, operator || 'NumericEquals');
    }
    /**
     * Filters access by whether the instance is enabled for EBS optimization
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/iam-policy-structure.html#amazon-ec2-keys
     *
     * Applies to actions:
     * - .toAssociateIamInstanceProfile()
     * - .toAttachClassicLinkVpc()
     * - .toAttachVolume()
     * - .toCreateSnapshots()
     * - .toCreateTags()
     * - .toDetachClassicLinkVpc()
     * - .toDetachVolume()
     * - .toDisassociateIamInstanceProfile()
     * - .toGetConsoleScreenshot()
     * - .toRebootInstances()
     * - .toReplaceIamInstanceProfileAssociation()
     * - .toRunInstances()
     * - .toSendDiagnosticInterrupt()
     * - .toStartInstances()
     * - .toStopInstances()
     * - .toTerminateInstances()
     *
     * Applies to resource types:
     * - instance
     *
     * @param value `true` or `false`. **Default:** `true`
     */
    ifEbsOptimized(value) {
        return this.if(`ec2:EbsOptimized`, (typeof value !== 'undefined' ? value : true), 'Bool');
    }
    /**
     * Filters access by the type of Elastic Graphics accelerator
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/iam-policy-structure.html#amazon-ec2-keys
     *
     * Applies to actions:
     * - .toRunInstances()
     *
     * Applies to resource types:
     * - elastic-gpu
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifElasticGpuType(value, operator) {
        return this.if(`ec2:ElasticGpuType`, value, operator || 'StringLike');
    }
    /**
     * Filters access by whether the EBS volume is encrypted
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/iam-policy-structure.html#amazon-ec2-keys
     *
     * Applies to actions:
     * - .toAttachVolume()
     * - .toCreateSnapshot()
     * - .toCreateSnapshots()
     * - .toCreateTags()
     * - .toCreateVolume()
     * - .toDeleteVolume()
     * - .toDetachVolume()
     * - .toDisableFastSnapshotRestores()
     * - .toEnableFastSnapshotRestores()
     * - .toRunInstances()
     *
     * Applies to resource types:
     * - volume
     *
     * @param value `true` or `false`. **Default:** `true`
     */
    ifEncrypted(value) {
        return this.if(`ec2:Encrypted`, (typeof value !== 'undefined' ? value : true), 'Bool');
    }
    /**
     * Filters access by the gateway type for a VPN endpoint on the AWS side of a VPN connection
     *
     * https://docs.aws.amazon.com/vpn/latest/s2svpn/vpn-authentication-access-control.html
     *
     * Applies to actions:
     * - .toCreateVpnConnection()
     * - .toModifyVpnConnection()
     *
     * Applies to resource types:
     * - vpn-connection
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifGatewayType(value, operator) {
        return this.if(`ec2:GatewayType`, value, operator || 'StringLike');
    }
    /**
     * Filters access by whether host recovery is enabled for a Dedicated Host
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/iam-policy-structure.html#amazon-ec2-keys
     *
     * Applies to resource types:
     * - dedicated-host
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifHostRecovery(value, operator) {
        return this.if(`ec2:HostRecovery`, value, operator || 'StringLike');
    }
    /**
     * Filters access by the internet key exchange (IKE) versions that are permitted for a VPN tunnel
     *
     * https://docs.aws.amazon.com/vpn/latest/s2svpn/vpn-authentication-access-control.html
     *
     * Applies to actions:
     * - .toCreateVpnConnection()
     * - .toModifyVpnTunnelOptions()
     *
     * Applies to resource types:
     * - vpn-connection
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifIKEVersions(value, operator) {
        return this.if(`ec2:IKEVersions`, value, operator || 'StringLike');
    }
    /**
     * Filters access by the type of image (machine, aki, or ari)
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/iam-policy-structure.html#amazon-ec2-keys
     *
     * Applies to actions:
     * - .toCreateTags()
     * - .toRunInstances()
     *
     * Applies to resource types:
     * - image
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifImageType(value, operator) {
        return this.if(`ec2:ImageType`, value, operator || 'StringLike');
    }
    /**
     * Filters access by the range of inside IP addresses for a VPN tunnel
     *
     * https://docs.aws.amazon.com/vpn/latest/s2svpn/vpn-authentication-access-control.html
     *
     * Applies to actions:
     * - .toCreateVpnConnection()
     * - .toModifyVpnTunnelOptions()
     *
     * Applies to resource types:
     * - vpn-connection
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifInsideTunnelCidr(value, operator) {
        return this.if(`ec2:InsideTunnelCidr`, value, operator || 'StringLike');
    }
    /**
     * Filters access by the market or purchasing option of an instance (on-demand or spot)
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/iam-policy-structure.html#amazon-ec2-keys
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifInstanceMarketType(value, operator) {
        return this.if(`ec2:InstanceMarketType`, value, operator || 'StringLike');
    }
    /**
     * Filters access by the ARN of an instance profile
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/iam-policy-structure.html#amazon-ec2-keys
     *
     * Applies to actions:
     * - .toAssociateIamInstanceProfile()
     * - .toAttachClassicLinkVpc()
     * - .toAttachVolume()
     * - .toCreateSnapshots()
     * - .toCreateTags()
     * - .toDetachClassicLinkVpc()
     * - .toDetachVolume()
     * - .toDisassociateIamInstanceProfile()
     * - .toGetConsoleScreenshot()
     * - .toRebootInstances()
     * - .toReplaceIamInstanceProfileAssociation()
     * - .toRunInstances()
     * - .toSendDiagnosticInterrupt()
     * - .toStartInstances()
     * - .toStopInstances()
     * - .toTerminateInstances()
     *
     * Applies to resource types:
     * - instance
     *
     * @param value The value(s) to check
     * @param operator Works with [arn operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_ARN). **Default:** `ArnLike`
     */
    ifInstanceProfile(value, operator) {
        return this.if(`ec2:InstanceProfile`, value, operator || 'ArnLike');
    }
    /**
     * Filters access by the type of instance
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/iam-policy-structure.html#amazon-ec2-keys
     *
     * Applies to actions:
     * - .toAssociateIamInstanceProfile()
     * - .toAttachClassicLinkVpc()
     * - .toAttachVolume()
     * - .toCreateSnapshots()
     * - .toCreateTags()
     * - .toDetachClassicLinkVpc()
     * - .toDetachVolume()
     * - .toDisassociateIamInstanceProfile()
     * - .toGetConsoleScreenshot()
     * - .toRebootInstances()
     * - .toReplaceIamInstanceProfileAssociation()
     * - .toRunInstances()
     * - .toSendDiagnosticInterrupt()
     * - .toStartInstances()
     * - .toStopInstances()
     * - .toTerminateInstances()
     *
     * Applies to resource types:
     * - dedicated-host
     * - instance
     * - reserved-instances
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifInstanceType(value, operator) {
        return this.if(`ec2:InstanceType`, value, operator || 'StringLike');
    }
    /**
     * Filters access by whether users are able to override resources that are specified in the launch template
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/iam-policy-structure.html#amazon-ec2-keys
     *
     * Applies to actions:
     * - .toRunInstances()
     *
     * @param value `true` or `false`. **Default:** `true`
     */
    ifIsLaunchTemplateResource(value) {
        return this.if(`ec2:IsLaunchTemplateResource`, (typeof value !== 'undefined' ? value : true), 'Bool');
    }
    /**
     * Filters access by the ARN of a launch template
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/iam-policy-structure.html#amazon-ec2-keys
     *
     * Applies to actions:
     * - .toRunInstances()
     *
     * @param value The value(s) to check
     * @param operator Works with [arn operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_ARN). **Default:** `ArnLike`
     */
    ifLaunchTemplate(value, operator) {
        return this.if(`ec2:LaunchTemplate`, value, operator || 'ArnLike');
    }
    /**
     * Filters access by whether the HTTP endpoint is enabled for the instance metadata service
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/iam-policy-structure.html#amazon-ec2-keys
     *
     * Applies to actions:
     * - .toRunInstances()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifMetadataHttpEndpoint(value, operator) {
        return this.if(`ec2:MetadataHttpEndpoint`, value, operator || 'StringLike');
    }
    /**
     * Filters access by the allowed number of hops when calling the instance metadata service
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/iam-policy-structure.html#amazon-ec2-keys
     *
     * Applies to actions:
     * - .toRunInstances()
     *
     * @param value The value(s) to check
     * @param operator Works with [numeric operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_Numeric). **Default:** `NumericEquals`
     */
    ifMetadataHttpPutResponseHopLimit(value, operator) {
        return this.if(`ec2:MetadataHttpPutResponseHopLimit`, value, operator || 'NumericEquals');
    }
    /**
     * Filters access by whether tokens are required when calling the instance metadata service (optional or required)
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/iam-policy-structure.html#amazon-ec2-keys
     *
     * Applies to actions:
     * - .toRunInstances()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifMetadataHttpTokens(value, operator) {
        return this.if(`ec2:MetadataHttpTokens`, value, operator || 'StringLike');
    }
    /**
     * Filters access by the owner of the resource (amazon, aws-marketplace, or an AWS account ID)
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/iam-policy-structure.html#amazon-ec2-keys
     *
     * Applies to actions:
     * - .toCreateTags()
     * - .toDeleteSnapshot()
     * - .toDisableFastSnapshotRestores()
     * - .toEnableFastSnapshotRestores()
     * - .toModifySnapshotAttribute()
     * - .toRunInstances()
     *
     * Applies to resource types:
     * - fpga-image
     * - image
     * - snapshot
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifOwner(value, operator) {
        return this.if(`ec2:Owner`, value, operator || 'StringLike');
    }
    /**
     * Filters access by the ARN of the parent snapshot
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/iam-policy-structure.html#amazon-ec2-keys
     *
     * Applies to actions:
     * - .toAttachVolume()
     * - .toCreateTags()
     * - .toCreateVolume()
     * - .toDeleteVolume()
     * - .toDetachVolume()
     * - .toRunInstances()
     *
     * Applies to resource types:
     * - volume
     *
     * @param value The value(s) to check
     * @param operator Works with [arn operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_ARN). **Default:** `ArnLike`
     */
    ifParentSnapshot(value, operator) {
        return this.if(`ec2:ParentSnapshot`, value, operator || 'ArnLike');
    }
    /**
     * Filters access by the ARN of the parent volume from which the snapshot was created
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/iam-policy-structure.html#amazon-ec2-keys
     *
     * Applies to actions:
     * - .toCreateSnapshot()
     * - .toCreateSnapshots()
     * - .toCreateTags()
     * - .toDeleteSnapshot()
     * - .toDisableFastSnapshotRestores()
     * - .toEnableFastSnapshotRestores()
     * - .toModifySnapshotAttribute()
     * - .toRunInstances()
     *
     * Applies to resource types:
     * - snapshot
     *
     * @param value The value(s) to check
     * @param operator Works with [arn operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_ARN). **Default:** `ArnLike`
     */
    ifParentVolume(value, operator) {
        return this.if(`ec2:ParentVolume`, value, operator || 'ArnLike');
    }
    /**
     * Filters access by the type of permission for a resource (INSTANCE-ATTACH or EIP-ASSOCIATE)
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/iam-policy-structure.html#amazon-ec2-keys
     *
     * Applies to actions:
     * - .toCreateNetworkInterfacePermission()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifPermission(value, operator) {
        return this.if(`ec2:Permission`, value, operator || 'StringLike');
    }
    /**
     * Filters access by the Diffie-Hellman group numbers that are permitted for a VPN tunnel for the phase 1 IKE negotiations
     *
     * https://docs.aws.amazon.com/vpn/latest/s2svpn/vpn-authentication-access-control.html
     *
     * Applies to actions:
     * - .toCreateVpnConnection()
     * - .toModifyVpnTunnelOptions()
     *
     * Applies to resource types:
     * - vpn-connection
     *
     * @param value The value(s) to check
     * @param operator Works with [numeric operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_Numeric). **Default:** `NumericEquals`
     */
    ifPhase1DHGroupNumbers(value, operator) {
        return this.if(`ec2:Phase1DHGroupNumbers`, value, operator || 'NumericEquals');
    }
    /**
     * Filters access by the encryption algorithms that are permitted for a VPN tunnel for the phase 1 IKE negotiations
     *
     * https://docs.aws.amazon.com/vpn/latest/s2svpn/vpn-authentication-access-control.htmls
     *
     * Applies to actions:
     * - .toCreateVpnConnection()
     * - .toModifyVpnTunnelOptions()
     *
     * Applies to resource types:
     * - vpn-connection
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifPhase1EncryptionAlgorithms(value, operator) {
        return this.if(`ec2:Phase1EncryptionAlgorithms`, value, operator || 'StringLike');
    }
    /**
     * Filters access by the integrity algorithms that are permitted for a VPN tunnel for the phase 1 IKE negotiations
     *
     * https://docs.aws.amazon.com/vpn/latest/s2svpn/vpn-authentication-access-control.html
     *
     * Applies to actions:
     * - .toCreateVpnConnection()
     * - .toModifyVpnTunnelOptions()
     *
     * Applies to resource types:
     * - vpn-connection
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifPhase1IntegrityAlgorithms(value, operator) {
        return this.if(`ec2:Phase1IntegrityAlgorithms`, value, operator || 'StringLike');
    }
    /**
     * Filters access by the lifetime in seconds for phase 1 of the IKE negotiations for a VPN tunnel
     *
     * https://docs.aws.amazon.com/vpn/latest/s2svpn/vpn-authentication-access-control.html
     *
     * Applies to actions:
     * - .toCreateVpnConnection()
     * - .toModifyVpnTunnelOptions()
     *
     * Applies to resource types:
     * - vpn-connection
     *
     * @param value The value(s) to check
     * @param operator Works with [numeric operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_Numeric). **Default:** `NumericEquals`
     */
    ifPhase1LifetimeSeconds(value, operator) {
        return this.if(`ec2:Phase1LifetimeSeconds`, value, operator || 'NumericEquals');
    }
    /**
     * Filters access by the Diffie-Hellman group numbers that are permitted for a VPN tunnel for the phase 2 IKE negotiations
     *
     * https://docs.aws.amazon.com/vpn/latest/s2svpn/vpn-authentication-access-control.html
     *
     * Applies to actions:
     * - .toCreateVpnConnection()
     * - .toModifyVpnTunnelOptions()
     *
     * Applies to resource types:
     * - vpn-connection
     *
     * @param value The value(s) to check
     * @param operator Works with [numeric operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_Numeric). **Default:** `NumericEquals`
     */
    ifPhase2DHGroupNumbers(value, operator) {
        return this.if(`ec2:Phase2DHGroupNumbers`, value, operator || 'NumericEquals');
    }
    /**
     * Filters access by the encryption algorithms that are permitted for a VPN tunnel for the phase 2 IKE negotiations
     *
     * https://docs.aws.amazon.com/vpn/latest/s2svpn/vpn-authentication-access-control.html
     *
     * Applies to actions:
     * - .toCreateVpnConnection()
     * - .toModifyVpnTunnelOptions()
     *
     * Applies to resource types:
     * - vpn-connection
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifPhase2EncryptionAlgorithms(value, operator) {
        return this.if(`ec2:Phase2EncryptionAlgorithms`, value, operator || 'StringLike');
    }
    /**
     * Filters access by the integrity algorithms that are permitted for a VPN tunnel for the phase 2 IKE negotiations
     *
     * https://docs.aws.amazon.com/vpn/latest/s2svpn/vpn-authentication-access-control.html
     *
     * Applies to actions:
     * - .toCreateVpnConnection()
     * - .toModifyVpnTunnelOptions()
     *
     * Applies to resource types:
     * - vpn-connection
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifPhase2IntegrityAlgorithms(value, operator) {
        return this.if(`ec2:Phase2IntegrityAlgorithms`, value, operator || 'StringLike');
    }
    /**
     * Filters access by the lifetime in seconds for phase 2 of the IKE negotiations for a VPN tunnel
     *
     * https://docs.aws.amazon.com/vpn/latest/s2svpn/vpn-authentication-access-control.html
     *
     * Applies to actions:
     * - .toCreateVpnConnection()
     * - .toModifyVpnTunnelOptions()
     *
     * Applies to resource types:
     * - vpn-connection
     *
     * @param value The value(s) to check
     * @param operator Works with [numeric operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_Numeric). **Default:** `NumericEquals`
     */
    ifPhase2LifetimeSeconds(value, operator) {
        return this.if(`ec2:Phase2LifetimeSeconds`, value, operator || 'NumericEquals');
    }
    /**
     * Filters access by the ARN of the placement group
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/iam-policy-structure.html#amazon-ec2-keys
     *
     * Applies to actions:
     * - .toAssociateIamInstanceProfile()
     * - .toAttachClassicLinkVpc()
     * - .toAttachVolume()
     * - .toCreateSnapshots()
     * - .toCreateTags()
     * - .toDetachClassicLinkVpc()
     * - .toDetachVolume()
     * - .toDisassociateIamInstanceProfile()
     * - .toGetConsoleScreenshot()
     * - .toRebootInstances()
     * - .toReplaceIamInstanceProfileAssociation()
     * - .toRunInstances()
     * - .toSendDiagnosticInterrupt()
     * - .toStartInstances()
     * - .toStopInstances()
     * - .toTerminateInstances()
     *
     * Applies to resource types:
     * - instance
     *
     * @param value The value(s) to check
     * @param operator Works with [arn operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_ARN). **Default:** `ArnLike`
     */
    ifPlacementGroup(value, operator) {
        return this.if(`ec2:PlacementGroup`, value, operator || 'ArnLike');
    }
    /**
     * Filters access by the instance placement strategy used by the placement group (cluster, spread, or partition)
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/iam-policy-structure.html#amazon-ec2-keys
     *
     * Applies to actions:
     * - .toRunInstances()
     *
     * Applies to resource types:
     * - placement-group
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifPlacementGroupStrategy(value, operator) {
        return this.if(`ec2:PlacementGroupStrategy`, value, operator || 'StringLike');
    }
    /**
     * Filters access by the pre-shared key (PSK) used to establish the initial IKE security association between a virtual private gateway and a customer gateway
     *
     * https://docs.aws.amazon.com/vpn/latest/s2svpn/vpn-authentication-access-control.html
     *
     * Applies to actions:
     * - .toCreateVpnConnection()
     * - .toModifyVpnTunnelOptions()
     *
     * Applies to resource types:
     * - vpn-connection
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifPresharedKeys(value, operator) {
        return this.if(`ec2:PresharedKeys`, value, operator || 'StringLike');
    }
    /**
     * Filters access by the product code that is associated with the AMI
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/iam-policy-structure.html#amazon-ec2-keys
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifProductCode(value, operator) {
        return this.if(`ec2:ProductCode`, value, operator || 'StringLike');
    }
    /**
     * Filters access by whether the image has public launch permissions
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/iam-policy-structure.html#amazon-ec2-keys
     *
     * Applies to actions:
     * - .toCreateTags()
     * - .toRunInstances()
     *
     * Applies to resource types:
     * - fpga-image
     * - image
     *
     * @param value `true` or `false`. **Default:** `true`
     */
    ifPublic(value) {
        return this.if(`ec2:Public`, (typeof value !== 'undefined' ? value : true), 'Bool');
    }
    /**
     * Filters access by the number of Dedicated Hosts in a request
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/iam-policy-structure.html#amazon-ec2-keys
     *
     * Applies to resource types:
     * - dedicated-host
     *
     * @param value The value(s) to check
     * @param operator Works with [numeric operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_Numeric). **Default:** `NumericEquals`
     */
    ifQuantity(value, operator) {
        return this.if(`ec2:Quantity`, value, operator || 'NumericEquals');
    }
    /**
     * Filters access by the name of the AWS Region
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/iam-policy-structure.html#amazon-ec2-keys
     *
     * Applies to actions:
     * - .toAcceptTransitGatewayPeeringAttachment()
     * - .toAcceptTransitGatewayVpcAttachment()
     * - .toAcceptVpcEndpointConnections()
     * - .toAcceptVpcPeeringConnection()
     * - .toApplySecurityGroupsToClientVpnTargetNetwork()
     * - .toAssociateClientVpnTargetNetwork()
     * - .toAssociateIamInstanceProfile()
     * - .toAssociateTransitGatewayMulticastDomain()
     * - .toAssociateTransitGatewayRouteTable()
     * - .toAttachClassicLinkVpc()
     * - .toAttachVolume()
     * - .toAuthorizeClientVpnIngress()
     * - .toAuthorizeSecurityGroupEgress()
     * - .toAuthorizeSecurityGroupIngress()
     * - .toCancelCapacityReservation()
     * - .toCopySnapshot()
     * - .toCreateCapacityReservation()
     * - .toCreateCarrierGateway()
     * - .toCreateClientVpnEndpoint()
     * - .toCreateClientVpnRoute()
     * - .toCreateDhcpOptions()
     * - .toCreateEgressOnlyInternetGateway()
     * - .toCreateFleet()
     * - .toCreateFlowLogs()
     * - .toCreateFpgaImage()
     * - .toCreateInstanceExportTask()
     * - .toCreateInternetGateway()
     * - .toCreateKeyPair()
     * - .toCreateLaunchTemplate()
     * - .toCreateLaunchTemplateVersion()
     * - .toCreateLocalGatewayRoute()
     * - .toCreateLocalGatewayRouteTableVpcAssociation()
     * - .toCreateManagedPrefixList()
     * - .toCreateNatGateway()
     * - .toCreateNetworkAcl()
     * - .toCreateNetworkInterface()
     * - .toCreateNetworkInterfacePermission()
     * - .toCreatePlacementGroup()
     * - .toCreateRoute()
     * - .toCreateSecurityGroup()
     * - .toCreateSnapshot()
     * - .toCreateSnapshots()
     * - .toCreateSubnet()
     * - .toCreateTags()
     * - .toCreateTrafficMirrorFilter()
     * - .toCreateTrafficMirrorFilterRule()
     * - .toCreateTrafficMirrorSession()
     * - .toCreateTrafficMirrorTarget()
     * - .toCreateTransitGateway()
     * - .toCreateTransitGatewayMulticastDomain()
     * - .toCreateTransitGatewayPeeringAttachment()
     * - .toCreateTransitGatewayPrefixListReference()
     * - .toCreateTransitGatewayRoute()
     * - .toCreateTransitGatewayRouteTable()
     * - .toCreateTransitGatewayVpcAttachment()
     * - .toCreateVolume()
     * - .toCreateVpc()
     * - .toCreateVpcEndpoint()
     * - .toCreateVpcEndpointServiceConfiguration()
     * - .toCreateVpcPeeringConnection()
     * - .toCreateVpnConnection()
     * - .toDeleteCarrierGateway()
     * - .toDeleteClientVpnEndpoint()
     * - .toDeleteClientVpnRoute()
     * - .toDeleteCustomerGateway()
     * - .toDeleteDhcpOptions()
     * - .toDeleteFlowLogs()
     * - .toDeleteInternetGateway()
     * - .toDeleteLaunchTemplate()
     * - .toDeleteLaunchTemplateVersions()
     * - .toDeleteLocalGatewayRoute()
     * - .toDeleteLocalGatewayRouteTableVpcAssociation()
     * - .toDeleteManagedPrefixList()
     * - .toDeleteNetworkAcl()
     * - .toDeleteNetworkAclEntry()
     * - .toDeleteRoute()
     * - .toDeleteRouteTable()
     * - .toDeleteSecurityGroup()
     * - .toDeleteSnapshot()
     * - .toDeleteTags()
     * - .toDeleteTrafficMirrorFilter()
     * - .toDeleteTrafficMirrorFilterRule()
     * - .toDeleteTrafficMirrorSession()
     * - .toDeleteTrafficMirrorTarget()
     * - .toDeleteTransitGateway()
     * - .toDeleteTransitGatewayMulticastDomain()
     * - .toDeleteTransitGatewayPeeringAttachment()
     * - .toDeleteTransitGatewayPrefixListReference()
     * - .toDeleteTransitGatewayRoute()
     * - .toDeleteTransitGatewayRouteTable()
     * - .toDeleteTransitGatewayVpcAttachment()
     * - .toDeleteVolume()
     * - .toDeleteVpcEndpointServiceConfigurations()
     * - .toDeleteVpcEndpoints()
     * - .toDeleteVpcPeeringConnection()
     * - .toDeregisterTransitGatewayMulticastGroupMembers()
     * - .toDeregisterTransitGatewayMulticastGroupSources()
     * - .toDetachClassicLinkVpc()
     * - .toDetachVolume()
     * - .toDisableFastSnapshotRestores()
     * - .toDisableTransitGatewayRouteTablePropagation()
     * - .toDisableVpcClassicLink()
     * - .toDisassociateClientVpnTargetNetwork()
     * - .toDisassociateIamInstanceProfile()
     * - .toDisassociateTransitGatewayMulticastDomain()
     * - .toDisassociateTransitGatewayRouteTable()
     * - .toEnableFastSnapshotRestores()
     * - .toEnableTransitGatewayRouteTablePropagation()
     * - .toEnableVpcClassicLink()
     * - .toGetConsoleScreenshot()
     * - .toImportClientVpnClientCertificateRevocationList()
     * - .toModifyCapacityReservation()
     * - .toModifyClientVpnEndpoint()
     * - .toModifyInstanceEventStartTime()
     * - .toModifyLaunchTemplate()
     * - .toModifyManagedPrefixList()
     * - .toModifySnapshotAttribute()
     * - .toModifyTrafficMirrorFilterNetworkServices()
     * - .toModifyTrafficMirrorFilterRule()
     * - .toModifyTrafficMirrorSession()
     * - .toModifyTransitGateway()
     * - .toModifyTransitGatewayPrefixListReference()
     * - .toModifyTransitGatewayVpcAttachment()
     * - .toModifyVpcEndpoint()
     * - .toModifyVpcEndpointServiceConfiguration()
     * - .toModifyVpcEndpointServicePermissions()
     * - .toModifyVpnConnection()
     * - .toModifyVpnTunnelOptions()
     * - .toRebootInstances()
     * - .toRegisterTransitGatewayMulticastGroupMembers()
     * - .toRegisterTransitGatewayMulticastGroupSources()
     * - .toRejectTransitGatewayPeeringAttachment()
     * - .toRejectTransitGatewayVpcAttachment()
     * - .toRejectVpcEndpointConnections()
     * - .toRejectVpcPeeringConnection()
     * - .toReplaceIamInstanceProfileAssociation()
     * - .toReplaceRoute()
     * - .toReplaceTransitGatewayRoute()
     * - .toRestoreManagedPrefixListVersion()
     * - .toRevokeClientVpnIngress()
     * - .toRevokeSecurityGroupEgress()
     * - .toRevokeSecurityGroupIngress()
     * - .toRunInstances()
     * - .toSendDiagnosticInterrupt()
     * - .toStartInstances()
     * - .toStartVpcEndpointServicePrivateDnsVerification()
     * - .toStopInstances()
     * - .toTerminateClientVpnConnections()
     * - .toTerminateInstances()
     * - .toUpdateSecurityGroupRuleDescriptionsEgress()
     * - .toUpdateSecurityGroupRuleDescriptionsIngress()
     *
     * Applies to resource types:
     * - capacity-reservation
     * - carrier-gateway
     * - client-vpn-endpoint
     * - customer-gateway
     * - dhcp-options
     * - egress-only-internet-gateway
     * - export-instance-task
     * - fleet
     * - fpga-image
     * - image
     * - instance
     * - internet-gateway
     * - key-pair
     * - launch-template
     * - local-gateway
     * - local-gateway-route-table
     * - local-gateway-route-table-virtual-interface-group-association
     * - local-gateway-route-table-vpc-association
     * - local-gateway-virtual-interface
     * - local-gateway-virtual-interface-group
     * - natgateway
     * - network-acl
     * - network-interface
     * - placement-group
     * - prefix-list
     * - reserved-instances
     * - route-table
     * - security-group
     * - snapshot
     * - spot-instance-request
     * - subnet
     * - traffic-mirror-session
     * - traffic-mirror-target
     * - traffic-mirror-filter
     * - traffic-mirror-filter-rule
     * - transit-gateway-attachment
     * - transit-gateway-multicast-domain
     * - transit-gateway-route-table
     * - transit-gateway
     * - volume
     * - vpc
     * - vpc-endpoint
     * - vpc-endpoint-service
     * - vpc-flow-log
     * - vpc-peering-connection
     * - vpn-connection
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifRegion(value, operator) {
        return this.if(`ec2:Region`, value, operator || 'StringLike');
    }
    /**
     * Filters access by the percentage of increase of the rekey window (determined by the rekey margin time) within which the rekey time is randomly selected for a VPN tunnel
     *
     * https://docs.aws.amazon.com/vpn/latest/s2svpn/vpn-authentication-access-control.html
     *
     * Applies to actions:
     * - .toCreateVpnConnection()
     * - .toModifyVpnTunnelOptions()
     *
     * Applies to resource types:
     * - vpn-connection
     *
     * @param value The value(s) to check
     * @param operator Works with [numeric operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_Numeric). **Default:** `NumericEquals`
     */
    ifRekeyFuzzPercentage(value, operator) {
        return this.if(`ec2:RekeyFuzzPercentage`, value, operator || 'NumericEquals');
    }
    /**
     * Filters access by the margin time before the phase 2 lifetime expires for a VPN tunnel
     *
     * https://docs.aws.amazon.com/vpn/latest/s2svpn/vpn-authentication-access-control.html
     *
     * Applies to actions:
     * - .toCreateVpnConnection()
     * - .toModifyVpnTunnelOptions()
     *
     * Applies to resource types:
     * - vpn-connection
     *
     * @param value The value(s) to check
     * @param operator Works with [numeric operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_Numeric). **Default:** `NumericEquals`
     */
    ifRekeyMarginTimeSeconds(value, operator) {
        return this.if(`ec2:RekeyMarginTimeSeconds`, value, operator || 'NumericEquals');
    }
    /**
     * Filters access by the ARN of a requester VPC in a VPC peering connection
     *
     * https://docs.aws.amazon.com/vpc/latest/peering/security-iam.html
     *
     * Applies to actions:
     * - .toAcceptVpcPeeringConnection()
     * - .toCreateVpcPeeringConnection()
     * - .toDeleteVpcPeeringConnection()
     * - .toRejectVpcPeeringConnection()
     *
     * Applies to resource types:
     * - vpc-peering-connection
     *
     * @param value The value(s) to check
     * @param operator Works with [arn operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_ARN). **Default:** `ArnLike`
     */
    ifRequesterVpc(value, operator) {
        return this.if(`ec2:RequesterVpc`, value, operator || 'ArnLike');
    }
    /**
     * Filters access by the payment option of the Reserved Instance offering (No Upfront, Partial Upfront, or All Upfront)
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-reserved-instances.html#ri-payment-options
     *
     * Applies to actions:
     * - .toCreateTags()
     *
     * Applies to resource types:
     * - reserved-instances
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifReservedInstancesOfferingType(value, operator) {
        return this.if(`ec2:ReservedInstancesOfferingType`, value, operator || 'StringLike');
    }
    /**
     * Filters access by the preface string for a tag key and value pair that are attached to a resource
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/control-access-with-tags.html
     *
     * Applies to actions:
     * - .toRunInstances()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifResourceTagExists(value, operator) {
        return this.if(`ec2:ResourceTag/`, value, operator || 'StringLike');
    }
    /**
     * Filters access by a tag key and value pair of a resource
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/control-access-with-tags.html
     *
     * Applies to actions:
     * - .toAcceptTransitGatewayPeeringAttachment()
     * - .toAcceptTransitGatewayVpcAttachment()
     * - .toAcceptVpcEndpointConnections()
     * - .toAcceptVpcPeeringConnection()
     * - .toApplySecurityGroupsToClientVpnTargetNetwork()
     * - .toAssociateClientVpnTargetNetwork()
     * - .toAssociateIamInstanceProfile()
     * - .toAssociateTransitGatewayMulticastDomain()
     * - .toAssociateTransitGatewayRouteTable()
     * - .toAttachClassicLinkVpc()
     * - .toAttachVolume()
     * - .toAuthorizeClientVpnIngress()
     * - .toAuthorizeSecurityGroupEgress()
     * - .toAuthorizeSecurityGroupIngress()
     * - .toCancelCapacityReservation()
     * - .toCreateClientVpnRoute()
     * - .toCreateFlowLogs()
     * - .toCreateLaunchTemplateVersion()
     * - .toCreateLocalGatewayRoute()
     * - .toCreateLocalGatewayRouteTableVpcAssociation()
     * - .toCreateNetworkInterfacePermission()
     * - .toCreateRoute()
     * - .toCreateSnapshot()
     * - .toCreateSnapshots()
     * - .toCreateTags()
     * - .toCreateTrafficMirrorFilterRule()
     * - .toCreateTrafficMirrorSession()
     * - .toCreateTrafficMirrorTarget()
     * - .toCreateTransitGatewayMulticastDomain()
     * - .toCreateTransitGatewayPeeringAttachment()
     * - .toCreateTransitGatewayPrefixListReference()
     * - .toCreateTransitGatewayRoute()
     * - .toCreateTransitGatewayRouteTable()
     * - .toCreateTransitGatewayVpcAttachment()
     * - .toCreateVpcEndpoint()
     * - .toCreateVpcPeeringConnection()
     * - .toDeleteCarrierGateway()
     * - .toDeleteClientVpnEndpoint()
     * - .toDeleteClientVpnRoute()
     * - .toDeleteCustomerGateway()
     * - .toDeleteDhcpOptions()
     * - .toDeleteFlowLogs()
     * - .toDeleteInternetGateway()
     * - .toDeleteLaunchTemplate()
     * - .toDeleteLaunchTemplateVersions()
     * - .toDeleteLocalGatewayRoute()
     * - .toDeleteLocalGatewayRouteTableVpcAssociation()
     * - .toDeleteManagedPrefixList()
     * - .toDeleteNetworkAcl()
     * - .toDeleteNetworkAclEntry()
     * - .toDeleteRoute()
     * - .toDeleteRouteTable()
     * - .toDeleteSecurityGroup()
     * - .toDeleteSnapshot()
     * - .toDeleteTags()
     * - .toDeleteTrafficMirrorFilter()
     * - .toDeleteTrafficMirrorFilterRule()
     * - .toDeleteTrafficMirrorSession()
     * - .toDeleteTrafficMirrorTarget()
     * - .toDeleteTransitGateway()
     * - .toDeleteTransitGatewayMulticastDomain()
     * - .toDeleteTransitGatewayPeeringAttachment()
     * - .toDeleteTransitGatewayPrefixListReference()
     * - .toDeleteTransitGatewayRoute()
     * - .toDeleteTransitGatewayRouteTable()
     * - .toDeleteTransitGatewayVpcAttachment()
     * - .toDeleteVolume()
     * - .toDeleteVpcEndpointServiceConfigurations()
     * - .toDeleteVpcEndpoints()
     * - .toDeleteVpcPeeringConnection()
     * - .toDeregisterTransitGatewayMulticastGroupMembers()
     * - .toDeregisterTransitGatewayMulticastGroupSources()
     * - .toDetachClassicLinkVpc()
     * - .toDetachVolume()
     * - .toDisableFastSnapshotRestores()
     * - .toDisableTransitGatewayRouteTablePropagation()
     * - .toDisableVpcClassicLink()
     * - .toDisassociateClientVpnTargetNetwork()
     * - .toDisassociateIamInstanceProfile()
     * - .toDisassociateTransitGatewayMulticastDomain()
     * - .toDisassociateTransitGatewayRouteTable()
     * - .toEnableFastSnapshotRestores()
     * - .toEnableTransitGatewayRouteTablePropagation()
     * - .toEnableVpcClassicLink()
     * - .toGetConsoleScreenshot()
     * - .toImportClientVpnClientCertificateRevocationList()
     * - .toModifyCapacityReservation()
     * - .toModifyClientVpnEndpoint()
     * - .toModifyLaunchTemplate()
     * - .toModifyManagedPrefixList()
     * - .toModifySnapshotAttribute()
     * - .toModifyTrafficMirrorFilterNetworkServices()
     * - .toModifyTrafficMirrorFilterRule()
     * - .toModifyTrafficMirrorSession()
     * - .toModifyTransitGateway()
     * - .toModifyTransitGatewayPrefixListReference()
     * - .toModifyTransitGatewayVpcAttachment()
     * - .toModifyVpcEndpoint()
     * - .toModifyVpcEndpointServiceConfiguration()
     * - .toModifyVpcEndpointServicePermissions()
     * - .toModifyVpnConnection()
     * - .toModifyVpnTunnelOptions()
     * - .toRebootInstances()
     * - .toRegisterTransitGatewayMulticastGroupMembers()
     * - .toRegisterTransitGatewayMulticastGroupSources()
     * - .toRejectTransitGatewayPeeringAttachment()
     * - .toRejectTransitGatewayVpcAttachment()
     * - .toRejectVpcEndpointConnections()
     * - .toRejectVpcPeeringConnection()
     * - .toReplaceIamInstanceProfileAssociation()
     * - .toReplaceRoute()
     * - .toReplaceTransitGatewayRoute()
     * - .toRestoreManagedPrefixListVersion()
     * - .toRevokeClientVpnIngress()
     * - .toRevokeSecurityGroupEgress()
     * - .toRevokeSecurityGroupIngress()
     * - .toRunInstances()
     * - .toSendDiagnosticInterrupt()
     * - .toStartInstances()
     * - .toStartVpcEndpointServicePrivateDnsVerification()
     * - .toStopInstances()
     * - .toTerminateClientVpnConnections()
     * - .toTerminateInstances()
     * - .toUpdateSecurityGroupRuleDescriptionsEgress()
     * - .toUpdateSecurityGroupRuleDescriptionsIngress()
     *
     * Applies to resource types:
     * - capacity-reservation
     * - carrier-gateway
     * - client-vpn-endpoint
     * - customer-gateway
     * - dedicated-host
     * - dhcp-options
     * - egress-only-internet-gateway
     * - export-instance-task
     * - fleet
     * - fpga-image
     * - image
     * - instance
     * - internet-gateway
     * - key-pair
     * - launch-template
     * - local-gateway
     * - local-gateway-route-table
     * - local-gateway-route-table-virtual-interface-group-association
     * - local-gateway-route-table-vpc-association
     * - local-gateway-virtual-interface
     * - local-gateway-virtual-interface-group
     * - natgateway
     * - network-acl
     * - network-interface
     * - placement-group
     * - prefix-list
     * - reserved-instances
     * - route-table
     * - security-group
     * - snapshot
     * - spot-instance-request
     * - subnet
     * - traffic-mirror-session
     * - traffic-mirror-target
     * - traffic-mirror-filter
     * - transit-gateway-attachment
     * - transit-gateway-multicast-domain
     * - transit-gateway-route-table
     * - transit-gateway
     * - volume
     * - vpc
     * - vpc-endpoint
     * - vpc-endpoint-service
     * - vpc-flow-log
     * - vpc-peering-connection
     * - vpn-connection
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifResourceTag(tagKey, value, operator) {
        return this.if(`ec2:ResourceTag/${tagKey}`, value, operator || 'StringLike');
    }
    /**
     * Filters access by the version of the instance metadata service for retrieving IAM role credentials for EC2
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/iam-policy-structure.html#amazon-ec2-keys
     *
     * @param value The value(s) to check
     * @param operator Works with [numeric operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_Numeric). **Default:** `NumericEquals`
     */
    ifRoleDelivery(value, operator) {
        return this.if(`ec2:RoleDelivery`, value, operator || 'NumericEquals');
    }
    /**
     * Filters access by the root device type of the instance (ebs or instance-store)
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/iam-policy-structure.html#amazon-ec2-keys
     *
     * Applies to actions:
     * - .toAssociateIamInstanceProfile()
     * - .toAttachClassicLinkVpc()
     * - .toAttachVolume()
     * - .toCreateSnapshots()
     * - .toCreateTags()
     * - .toDetachClassicLinkVpc()
     * - .toDetachVolume()
     * - .toDisassociateIamInstanceProfile()
     * - .toGetConsoleScreenshot()
     * - .toRebootInstances()
     * - .toReplaceIamInstanceProfileAssociation()
     * - .toRunInstances()
     * - .toSendDiagnosticInterrupt()
     * - .toStartInstances()
     * - .toStopInstances()
     * - .toTerminateInstances()
     *
     * Applies to resource types:
     * - image
     * - instance
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifRootDeviceType(value, operator) {
        return this.if(`ec2:RootDeviceType`, value, operator || 'StringLike');
    }
    /**
     * Filters access by the routing type for the VPN connection
     *
     * https://docs.aws.amazon.com/vpn/latest/s2svpn/vpn-authentication-access-control.html
     *
     * Applies to actions:
     * - .toCreateVpnConnection()
     * - .toModifyVpnTunnelOptions()
     *
     * Applies to resource types:
     * - vpn-connection
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifRoutingType(value, operator) {
        return this.if(`ec2:RoutingType`, value, operator || 'StringLike');
    }
    /**
     * Filters access by the initiation time of a snapshot
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/iam-policy-structure.html#amazon-ec2-keys
     *
     * Applies to actions:
     * - .toCreateTags()
     * - .toDeleteSnapshot()
     * - .toDisableFastSnapshotRestores()
     * - .toEnableFastSnapshotRestores()
     * - .toModifySnapshotAttribute()
     * - .toRunInstances()
     *
     * Applies to resource types:
     * - snapshot
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifSnapshotTime(value, operator) {
        return this.if(`ec2:SnapshotTime`, value, operator || 'StringLike');
    }
    /**
     * Filters access by the ARN of the instance from which the request originated
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/iam-policy-structure.html#amazon-ec2-keys
     *
     * @param value The value(s) to check
     * @param operator Works with [arn operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_ARN). **Default:** `ArnLike`
     */
    ifSourceInstanceARN(value, operator) {
        return this.if(`ec2:SourceInstanceARN`, value, operator || 'ArnLike');
    }
    /**
     * Filters access by the ARN of the subnet
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/iam-policy-structure.html#amazon-ec2-keys
     *
     * Applies to actions:
     * - .toCreateFlowLogs()
     * - .toCreateNetworkInterfacePermission()
     * - .toCreateTags()
     * - .toRunInstances()
     *
     * Applies to resource types:
     * - network-interface
     *
     * @param value The value(s) to check
     * @param operator Works with [arn operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_ARN). **Default:** `ArnLike`
     */
    ifSubnet(value, operator) {
        return this.if(`ec2:Subnet`, value, operator || 'ArnLike');
    }
    /**
     * Filters access by the tenancy of the VPC or instance (default, dedicated, or host)
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/iam-policy-structure.html#amazon-ec2-keys
     *
     * Applies to actions:
     * - .toAcceptVpcPeeringConnection()
     * - .toAssociateIamInstanceProfile()
     * - .toAttachClassicLinkVpc()
     * - .toAttachVolume()
     * - .toCreateFlowLogs()
     * - .toCreateLocalGatewayRouteTableVpcAssociation()
     * - .toCreateSnapshots()
     * - .toCreateTags()
     * - .toCreateVpcPeeringConnection()
     * - .toDetachClassicLinkVpc()
     * - .toDetachVolume()
     * - .toDisableVpcClassicLink()
     * - .toDisassociateIamInstanceProfile()
     * - .toEnableVpcClassicLink()
     * - .toGetConsoleScreenshot()
     * - .toRebootInstances()
     * - .toReplaceIamInstanceProfileAssociation()
     * - .toRunInstances()
     * - .toSendDiagnosticInterrupt()
     * - .toStartInstances()
     * - .toStopInstances()
     * - .toTerminateInstances()
     *
     * Applies to resource types:
     * - instance
     * - reserved-instances
     * - vpc
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifTenancy(value, operator) {
        return this.if(`ec2:Tenancy`, value, operator || 'StringLike');
    }
    /**
     * Filters access by the the number of input/output operations per second (IOPS) provisioned for the volume
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/iam-policy-structure.html#amazon-ec2-keys
     *
     * Applies to actions:
     * - .toAttachVolume()
     * - .toCreateSnapshot()
     * - .toCreateSnapshots()
     * - .toCreateTags()
     * - .toCreateVolume()
     * - .toDeleteVolume()
     * - .toDetachVolume()
     * - .toRunInstances()
     *
     * Applies to resource types:
     * - volume
     *
     * @param value The value(s) to check
     * @param operator Works with [numeric operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_Numeric). **Default:** `NumericEquals`
     */
    ifVolumeIops(value, operator) {
        return this.if(`ec2:VolumeIops`, value, operator || 'NumericEquals');
    }
    /**
     * Filters access by the size of the volume, in GiB.
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/iam-policy-structure.html#amazon-ec2-keys
     *
     * Applies to actions:
     * - .toAttachVolume()
     * - .toCreateSnapshot()
     * - .toCreateSnapshots()
     * - .toCreateTags()
     * - .toCreateVolume()
     * - .toDeleteSnapshot()
     * - .toDeleteVolume()
     * - .toDetachVolume()
     * - .toDisableFastSnapshotRestores()
     * - .toEnableFastSnapshotRestores()
     * - .toModifySnapshotAttribute()
     * - .toRunInstances()
     *
     * Applies to resource types:
     * - snapshot
     * - volume
     *
     * @param value The value(s) to check
     * @param operator Works with [numeric operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_Numeric). **Default:** `NumericEquals`
     */
    ifVolumeSize(value, operator) {
        return this.if(`ec2:VolumeSize`, value, operator || 'NumericEquals');
    }
    /**
     * Filters access by the type of volume (gp2, io1, io2, st1, sc1, or standard)
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/iam-policy-structure.html#amazon-ec2-keys
     *
     * Applies to actions:
     * - .toAttachVolume()
     * - .toCreateSnapshot()
     * - .toCreateSnapshots()
     * - .toCreateTags()
     * - .toCreateVolume()
     * - .toDeleteVolume()
     * - .toDetachVolume()
     * - .toRunInstances()
     *
     * Applies to resource types:
     * - volume
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifVolumeType(value, operator) {
        return this.if(`ec2:VolumeType`, value, operator || 'StringLike');
    }
    /**
     * Filters access by the ARN of the VPC
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/iam-policy-structure.html#amazon-ec2-keys
     *
     * Applies to actions:
     * - .toAttachClassicLinkVpc()
     * - .toAuthorizeSecurityGroupEgress()
     * - .toAuthorizeSecurityGroupIngress()
     * - .toCreateFlowLogs()
     * - .toCreateNetworkInterfacePermission()
     * - .toCreateRoute()
     * - .toCreateTags()
     * - .toDeleteNetworkAcl()
     * - .toDeleteNetworkAclEntry()
     * - .toDeleteRoute()
     * - .toDeleteRouteTable()
     * - .toDeleteSecurityGroup()
     * - .toReplaceRoute()
     * - .toRevokeSecurityGroupEgress()
     * - .toRevokeSecurityGroupIngress()
     * - .toRunInstances()
     * - .toUpdateSecurityGroupRuleDescriptionsEgress()
     * - .toUpdateSecurityGroupRuleDescriptionsIngress()
     *
     * Applies to resource types:
     * - network-acl
     * - network-interface
     * - route-table
     * - security-group
     * - subnet
     *
     * @param value The value(s) to check
     * @param operator Works with [arn operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_ARN). **Default:** `ArnLike`
     */
    ifVpc(value, operator) {
        return this.if(`ec2:Vpc`, value, operator || 'ArnLike');
    }
    /**
     * Filters access by the name of the VPC endpoint service
     *
     * Applies to actions:
     * - .toCreateVpcEndpoint()
     *
     * Applies to resource types:
     * - vpc-endpoint
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifVpceServiceName(value, operator) {
        return this.if(`ec2:VpceServiceName`, value, operator || 'StringLike');
    }
    /**
     * Filters access by the service owner of the VPC endpoint service (amazon, aws-marketplace, or an AWS account ID)
     *
     * Applies to actions:
     * - .toCreateVpcEndpoint()
     *
     * Applies to resource types:
     * - vpc-endpoint
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifVpceServiceOwner(value, operator) {
        return this.if(`ec2:VpceServiceOwner`, value, operator || 'StringLike');
    }
    /**
     * Filters access by the private DNS name of the VPC endpoint service
     *
     * Applies to actions:
     * - .toCreateVpcEndpointServiceConfiguration()
     * - .toModifyVpcEndpointServiceConfiguration()
     *
     * Applies to resource types:
     * - vpc-endpoint-service
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifVpceServicePrivateDnsName(value, operator) {
        return this.if(`ec2:VpceServicePrivateDnsName`, value, operator || 'StringLike');
    }
}
exports.Ec2 = Ec2;
//# sourceMappingURL=data:application/json;base64,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