"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Groundtruthlabeling = void 0;
const shared_1 = require("../shared");
/**
 * Statement provider for service [groundtruthlabeling](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazongroundtruthlabeling.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class Groundtruthlabeling extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [groundtruthlabeling](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazongroundtruthlabeling.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid) {
        super(sid);
        this.servicePrefix = 'groundtruthlabeling';
        this.accessLevelList = {
            "Read": [
                "DescribeConsoleJob",
                "ListDatasetObjects"
            ],
            "Write": [
                "RunFilterOrSampleDatasetJob",
                "RunGenerateManifestByCrawlingJob"
            ]
        };
    }
    /**
     * Get status of GroundTruthLabeling Jobs.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/sagemaker/latest/dg/sms-data-input.html#sms-console-create-manifest-file
     */
    toDescribeConsoleJob() {
        this.to('groundtruthlabeling:DescribeConsoleJob');
        return this;
    }
    /**
     * Paginated list API to list dataset objects in a manifest file.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/sagemaker/latest/dg/sms-data-input.html#sms-console-create-manifest-file
     */
    toListDatasetObjects() {
        this.to('groundtruthlabeling:ListDatasetObjects');
        return this;
    }
    /**
     * Filter records from a manifest file using S3 select. Get sample entries based on random sampling.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/sagemaker/latest/dg/sms-data-input.html#sms-data-filtering
     */
    toRunFilterOrSampleDatasetJob() {
        this.to('groundtruthlabeling:RunFilterOrSampleDatasetJob');
        return this;
    }
    /**
     * List a S3 prefix and create manifest files from objects in that location.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/sagemaker/latest/dg/sms-data-input.html#sms-console-create-manifest-file
     */
    toRunGenerateManifestByCrawlingJob() {
        this.to('groundtruthlabeling:RunGenerateManifestByCrawlingJob');
        return this;
    }
}
exports.Groundtruthlabeling = Groundtruthlabeling;
//# sourceMappingURL=data:application/json;base64,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