"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.IotDeviceTester = void 0;
const shared_1 = require("../shared");
/**
 * Statement provider for service [iot-device-tester](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiotdevicetester.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class IotDeviceTester extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [iot-device-tester](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiotdevicetester.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid) {
        super(sid);
        this.servicePrefix = 'iot-device-tester';
        this.accessLevelList = {
            "Read": [
                "CheckVersion",
                "DownloadTestSuite",
                "LatestIdt",
                "SupportedVersion"
            ],
            "Write": [
                "SendMetrics"
            ]
        };
    }
    /**
     * Grants permission for IoT Device Tester to check if a given set of product, test suite and device tester version are compatible
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/freertos/latest/userguide/dev-tester-prereqs.html
     */
    toCheckVersion() {
        this.to('iot-device-tester:CheckVersion');
        return this;
    }
    /**
     * Grants permission for IoT Device Tester to download compatible test suite versions
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/freertos/latest/userguide/dev-tester-prereqs.html
     */
    toDownloadTestSuite() {
        this.to('iot-device-tester:DownloadTestSuite');
        return this;
    }
    /**
     * Grants permission for IoT Device Tester to get information on latest version of device tester available
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/freertos/latest/userguide/dev-tester-prereqs.html
     */
    toLatestIdt() {
        this.to('iot-device-tester:LatestIdt');
        return this;
    }
    /**
     * Grants permissions for IoT Device Tester to send usage metrics on your behalf
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/freertos/latest/userguide/dev-tester-prereqs.html
     */
    toSendMetrics() {
        this.to('iot-device-tester:SendMetrics');
        return this;
    }
    /**
     * Grants permission for IoT Device Tester to get list of supported products and test suite versions
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/freertos/latest/userguide/dev-tester-prereqs.html
     */
    toSupportedVersion() {
        this.to('iot-device-tester:SupportedVersion');
        return this;
    }
}
exports.IotDeviceTester = IotDeviceTester;
//# sourceMappingURL=data:application/json;base64,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