"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Lakeformation = void 0;
const shared_1 = require("../shared");
/**
 * Statement provider for service [lakeformation](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awslakeformation.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class Lakeformation extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [lakeformation](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awslakeformation.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid) {
        super(sid);
        this.servicePrefix = 'lakeformation';
        this.accessLevelList = {
            "Permissions management": [
                "BatchGrantPermissions",
                "BatchRevokePermissions",
                "GrantPermissions",
                "PutDataLakeSettings",
                "RevokePermissions"
            ],
            "Write": [
                "DeregisterResource",
                "GetDataAccess",
                "RegisterResource",
                "UpdateResource"
            ],
            "Read": [
                "DescribeResource",
                "GetDataLakeSettings",
                "GetEffectivePermissionsForPath"
            ],
            "List": [
                "ListPermissions",
                "ListResources"
            ]
        };
    }
    /**
     * Grants data lake permissions to one or more principals in a batch.
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api.html
     */
    toBatchGrantPermissions() {
        this.to('lakeformation:BatchGrantPermissions');
        return this;
    }
    /**
     * Revokes data lake permissions from one or more principals in a batch.
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api.html
     */
    toBatchRevokePermissions() {
        this.to('lakeformation:BatchRevokePermissions');
        return this;
    }
    /**
     * Deregisters a registered location.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api.html
     */
    toDeregisterResource() {
        this.to('lakeformation:DeregisterResource');
        return this;
    }
    /**
     * Describes a registered location.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api.html
     */
    toDescribeResource() {
        this.to('lakeformation:DescribeResource');
        return this;
    }
    /**
     * Grants virtual data lake access permissions.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api.html
     */
    toGetDataAccess() {
        this.to('lakeformation:GetDataAccess');
        return this;
    }
    /**
     * Retrieves data lake settings such as the list of data lake administrators and database and table default permissions.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api.html
     */
    toGetDataLakeSettings() {
        this.to('lakeformation:GetDataLakeSettings');
        return this;
    }
    /**
     * Retrieves permissions attached to resources in the given path.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api.html
     */
    toGetEffectivePermissionsForPath() {
        this.to('lakeformation:GetEffectivePermissionsForPath');
        return this;
    }
    /**
     * Grants data lake permissions to a principal.
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api.html
     */
    toGrantPermissions() {
        this.to('lakeformation:GrantPermissions');
        return this;
    }
    /**
     * Lists permissions filtered by principal or resource.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api.html
     */
    toListPermissions() {
        this.to('lakeformation:ListPermissions');
        return this;
    }
    /**
     * Lists registered locations.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api.html
     */
    toListResources() {
        this.to('lakeformation:ListResources');
        return this;
    }
    /**
     * Overwrites data lake settings such as the list of data lake administrators and database and table default permissions.
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api.html
     */
    toPutDataLakeSettings() {
        this.to('lakeformation:PutDataLakeSettings');
        return this;
    }
    /**
     * Registers a new location to be managed by Lake Formation.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api.html
     */
    toRegisterResource() {
        this.to('lakeformation:RegisterResource');
        return this;
    }
    /**
     * Revokes data lake permissions from a principal.
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api.html
     */
    toRevokePermissions() {
        this.to('lakeformation:RevokePermissions');
        return this;
    }
    /**
     * Updates a registered location.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api.html
     */
    toUpdateResource() {
        this.to('lakeformation:UpdateResource');
        return this;
    }
}
exports.Lakeformation = Lakeformation;
//# sourceMappingURL=data:application/json;base64,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