"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AwsMarketplaceProcurementSystemsIntegration = void 0;
const shared_1 = require("../shared");
/**
 * Statement provider for service [aws-marketplace-procurement-systems-integration](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsmarketplaceprocurementsystemsintegration.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class AwsMarketplaceProcurementSystemsIntegration extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [aws-marketplace-procurement-systems-integration](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsmarketplaceprocurementsystemsintegration.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid) {
        super(sid);
        this.servicePrefix = 'aws-marketplace-procurement-systems-integration';
        this.accessLevelList = {
            "Read": [
                "DescribeProcurementSystemConfiguration"
            ],
            "Write": [
                "PutProcurementSystemConfiguration"
            ]
        };
    }
    /**
     * Describes the Procurement System integration configuration (e.g. Coupa) for the individual account, or for the entire AWS Organization if one exists. This action can only be performed by the master account if using an AWS Organization.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/marketplace/latest/buyerguide/procurement-systems-integration.html
     */
    toDescribeProcurementSystemConfiguration() {
        this.to('aws-marketplace-procurement-systems-integration:DescribeProcurementSystemConfiguration');
        return this;
    }
    /**
     * Creates or updates the Procurement System integration configuration (e.g. Coupa) for the individual account, or for the entire AWS Organization if one exists. This action can only be performed by the master account if using an AWS Organization.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/marketplace/latest/buyerguide/procurement-systems-integration.html
     */
    toPutProcurementSystemConfiguration() {
        this.to('aws-marketplace-procurement-systems-integration:PutProcurementSystemConfiguration');
        return this;
    }
}
exports.AwsMarketplaceProcurementSystemsIntegration = AwsMarketplaceProcurementSystemsIntegration;
//# sourceMappingURL=data:application/json;base64,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