"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Translate = void 0;
const shared_1 = require("../shared");
/**
 * Statement provider for service [translate](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazontranslate.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class Translate extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [translate](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazontranslate.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid) {
        super(sid);
        this.servicePrefix = 'translate';
        this.accessLevelList = {
            "Write": [
                "DeleteTerminology",
                "ImportTerminology",
                "StartTextTranslationJob",
                "StopTextTranslationJob"
            ],
            "Read": [
                "DescribeTextTranslationJob",
                "GetTerminology",
                "ListTerminologies",
                "ListTextTranslationJobs",
                "TranslateText"
            ]
        };
    }
    /**
     * A synchronous action that deletes a custom terminology.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/translate/latest/dg/API_DeleteTerminology.html
     */
    toDeleteTerminology() {
        this.to('translate:DeleteTerminology');
        return this;
    }
    /**
     * Gets the properties associated with an asynchronous batch translation job including name, ID, status, source and target languages, input/output S3 buckets, and so on.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/translate/latest/dg/API_DescribeTextTranslationJob.html
     */
    toDescribeTextTranslationJob() {
        this.to('translate:DescribeTextTranslationJob');
        return this;
    }
    /**
     * Retrieves a custom terminology.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/translate/latest/dg/API_GetTerminology.html
     */
    toGetTerminology() {
        this.to('translate:GetTerminology');
        return this;
    }
    /**
     * Creates or updates a custom terminology, depending on whether or not one already exists for the given terminology name.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/translate/latest/dg/API_ImportTerminology.html
     */
    toImportTerminology() {
        this.to('translate:ImportTerminology');
        return this;
    }
    /**
     * Provides a list of custom terminologies associated with your account.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/translate/latest/dg/API_ListTerminologies.html
     */
    toListTerminologies() {
        this.to('translate:ListTerminologies');
        return this;
    }
    /**
     * Gets a list of the batch translation jobs that you have submitted.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/translate/latest/dg/API_ListTextTranslationJobs.html
     */
    toListTextTranslationJobs() {
        this.to('translate:ListTextTranslationJobs');
        return this;
    }
    /**
     * Starts an asynchronous batch translation job. Batch translation jobs can be used to translate large volumes of text across multiple documents at once.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/translate/latest/dg/API_StartTextTranslationJob.html
     */
    toStartTextTranslationJob() {
        this.to('translate:StartTextTranslationJob');
        return this;
    }
    /**
     * Stops an asynchronous batch translation job that is in progress.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/translate/latest/dg/API_StopTextTranslationJob.html
     */
    toStopTextTranslationJob() {
        this.to('translate:StopTextTranslationJob');
        return this;
    }
    /**
     * Translate text from a source language to a target language.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/translate/latest/dg/API_TranslateText.html
     */
    toTranslateText() {
        this.to('translate:TranslateText');
        return this;
    }
}
exports.Translate = Translate;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidHJhbnNsYXRlLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsidHJhbnNsYXRlLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7OztBQUNBLHNDQUE0QztBQUU1Qzs7OztHQUlHO0FBQ0gsTUFBYSxTQUFVLFNBQVEsd0JBQWU7SUFHNUM7Ozs7T0FJRztJQUNILFlBQWEsR0FBWTtRQUN2QixLQUFLLENBQUMsR0FBRyxDQUFDLENBQUM7UUFSTixrQkFBYSxHQUFHLFdBQVcsQ0FBQztRQXVIekIsb0JBQWUsR0FBb0I7WUFDM0MsT0FBTyxFQUFFO2dCQUNQLG1CQUFtQjtnQkFDbkIsbUJBQW1CO2dCQUNuQix5QkFBeUI7Z0JBQ3pCLHdCQUF3QjthQUN6QjtZQUNELE1BQU0sRUFBRTtnQkFDTiw0QkFBNEI7Z0JBQzVCLGdCQUFnQjtnQkFDaEIsbUJBQW1CO2dCQUNuQix5QkFBeUI7Z0JBQ3pCLGVBQWU7YUFDaEI7U0FDRixDQUFDO0lBNUhGLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSxtQkFBbUI7UUFDeEIsSUFBSSxDQUFDLEVBQUUsQ0FBQyw2QkFBNkIsQ0FBQyxDQUFDO1FBQ3ZDLE9BQU8sSUFBSSxDQUFDO0lBQ2QsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLDRCQUE0QjtRQUNqQyxJQUFJLENBQUMsRUFBRSxDQUFDLHNDQUFzQyxDQUFDLENBQUM7UUFDaEQsT0FBTyxJQUFJLENBQUM7SUFDZCxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksZ0JBQWdCO1FBQ3JCLElBQUksQ0FBQyxFQUFFLENBQUMsMEJBQTBCLENBQUMsQ0FBQztRQUNwQyxPQUFPLElBQUksQ0FBQztJQUNkLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSxtQkFBbUI7UUFDeEIsSUFBSSxDQUFDLEVBQUUsQ0FBQyw2QkFBNkIsQ0FBQyxDQUFDO1FBQ3ZDLE9BQU8sSUFBSSxDQUFDO0lBQ2QsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLG1CQUFtQjtRQUN4QixJQUFJLENBQUMsRUFBRSxDQUFDLDZCQUE2QixDQUFDLENBQUM7UUFDdkMsT0FBTyxJQUFJLENBQUM7SUFDZCxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0kseUJBQXlCO1FBQzlCLElBQUksQ0FBQyxFQUFFLENBQUMsbUNBQW1DLENBQUMsQ0FBQztRQUM3QyxPQUFPLElBQUksQ0FBQztJQUNkLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSx5QkFBeUI7UUFDOUIsSUFBSSxDQUFDLEVBQUUsQ0FBQyxtQ0FBbUMsQ0FBQyxDQUFDO1FBQzdDLE9BQU8sSUFBSSxDQUFDO0lBQ2QsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLHdCQUF3QjtRQUM3QixJQUFJLENBQUMsRUFBRSxDQUFDLGtDQUFrQyxDQUFDLENBQUM7UUFDNUMsT0FBTyxJQUFJLENBQUM7SUFDZCxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksZUFBZTtRQUNwQixJQUFJLENBQUMsRUFBRSxDQUFDLHlCQUF5QixDQUFDLENBQUM7UUFDbkMsT0FBTyxJQUFJLENBQUM7SUFDZCxDQUFDO0NBaUJGO0FBdklELDhCQXVJQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IEFjY2Vzc0xldmVsTGlzdCB9IGZyb20gXCIuLi9zaGFyZWQvYWNjZXNzLWxldmVsXCI7XG5pbXBvcnQgeyBQb2xpY3lTdGF0ZW1lbnQgfSBmcm9tIFwiLi4vc2hhcmVkXCI7XG5cbi8qKlxuICogU3RhdGVtZW50IHByb3ZpZGVyIGZvciBzZXJ2aWNlIFt0cmFuc2xhdGVdKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9zZXJ2aWNlLWF1dGhvcml6YXRpb24vbGF0ZXN0L3JlZmVyZW5jZS9saXN0X2FtYXpvbnRyYW5zbGF0ZS5odG1sKS5cbiAqXG4gKiBAcGFyYW0gc2lkIFtTSURdKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9JQU0vbGF0ZXN0L1VzZXJHdWlkZS9yZWZlcmVuY2VfcG9saWNpZXNfZWxlbWVudHNfc2lkLmh0bWwpIG9mIHRoZSBzdGF0ZW1lbnRcbiAqL1xuZXhwb3J0IGNsYXNzIFRyYW5zbGF0ZSBleHRlbmRzIFBvbGljeVN0YXRlbWVudCB7XG4gIHB1YmxpYyBzZXJ2aWNlUHJlZml4ID0gJ3RyYW5zbGF0ZSc7XG5cbiAgLyoqXG4gICAqIFN0YXRlbWVudCBwcm92aWRlciBmb3Igc2VydmljZSBbdHJhbnNsYXRlXShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vc2VydmljZS1hdXRob3JpemF0aW9uL2xhdGVzdC9yZWZlcmVuY2UvbGlzdF9hbWF6b250cmFuc2xhdGUuaHRtbCkuXG4gICAqXG4gICAqIEBwYXJhbSBzaWQgW1NJRF0oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0lBTS9sYXRlc3QvVXNlckd1aWRlL3JlZmVyZW5jZV9wb2xpY2llc19lbGVtZW50c19zaWQuaHRtbCkgb2YgdGhlIHN0YXRlbWVudFxuICAgKi9cbiAgY29uc3RydWN0b3IgKHNpZD86IHN0cmluZykge1xuICAgIHN1cGVyKHNpZCk7XG4gIH1cblxuICAvKipcbiAgICogQSBzeW5jaHJvbm91cyBhY3Rpb24gdGhhdCBkZWxldGVzIGEgY3VzdG9tIHRlcm1pbm9sb2d5LlxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFdyaXRlXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS90cmFuc2xhdGUvbGF0ZXN0L2RnL0FQSV9EZWxldGVUZXJtaW5vbG9neS5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9EZWxldGVUZXJtaW5vbG9neSgpIHtcbiAgICB0aGlzLnRvKCd0cmFuc2xhdGU6RGVsZXRlVGVybWlub2xvZ3knKTtcbiAgICByZXR1cm4gdGhpcztcbiAgfVxuXG4gIC8qKlxuICAgKiBHZXRzIHRoZSBwcm9wZXJ0aWVzIGFzc29jaWF0ZWQgd2l0aCBhbiBhc3luY2hyb25vdXMgYmF0Y2ggdHJhbnNsYXRpb24gam9iIGluY2x1ZGluZyBuYW1lLCBJRCwgc3RhdHVzLCBzb3VyY2UgYW5kIHRhcmdldCBsYW5ndWFnZXMsIGlucHV0L291dHB1dCBTMyBidWNrZXRzLCBhbmQgc28gb24uXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogUmVhZFxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vdHJhbnNsYXRlL2xhdGVzdC9kZy9BUElfRGVzY3JpYmVUZXh0VHJhbnNsYXRpb25Kb2IuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvRGVzY3JpYmVUZXh0VHJhbnNsYXRpb25Kb2IoKSB7XG4gICAgdGhpcy50bygndHJhbnNsYXRlOkRlc2NyaWJlVGV4dFRyYW5zbGF0aW9uSm9iJyk7XG4gICAgcmV0dXJuIHRoaXM7XG4gIH1cblxuICAvKipcbiAgICogUmV0cmlldmVzIGEgY3VzdG9tIHRlcm1pbm9sb2d5LlxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFJlYWRcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL3RyYW5zbGF0ZS9sYXRlc3QvZGcvQVBJX0dldFRlcm1pbm9sb2d5Lmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0dldFRlcm1pbm9sb2d5KCkge1xuICAgIHRoaXMudG8oJ3RyYW5zbGF0ZTpHZXRUZXJtaW5vbG9neScpO1xuICAgIHJldHVybiB0aGlzO1xuICB9XG5cbiAgLyoqXG4gICAqIENyZWF0ZXMgb3IgdXBkYXRlcyBhIGN1c3RvbSB0ZXJtaW5vbG9neSwgZGVwZW5kaW5nIG9uIHdoZXRoZXIgb3Igbm90IG9uZSBhbHJlYWR5IGV4aXN0cyBmb3IgdGhlIGdpdmVuIHRlcm1pbm9sb2d5IG5hbWUuXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogV3JpdGVcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL3RyYW5zbGF0ZS9sYXRlc3QvZGcvQVBJX0ltcG9ydFRlcm1pbm9sb2d5Lmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0ltcG9ydFRlcm1pbm9sb2d5KCkge1xuICAgIHRoaXMudG8oJ3RyYW5zbGF0ZTpJbXBvcnRUZXJtaW5vbG9neScpO1xuICAgIHJldHVybiB0aGlzO1xuICB9XG5cbiAgLyoqXG4gICAqIFByb3ZpZGVzIGEgbGlzdCBvZiBjdXN0b20gdGVybWlub2xvZ2llcyBhc3NvY2lhdGVkIHdpdGggeW91ciBhY2NvdW50LlxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFJlYWRcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL3RyYW5zbGF0ZS9sYXRlc3QvZGcvQVBJX0xpc3RUZXJtaW5vbG9naWVzLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0xpc3RUZXJtaW5vbG9naWVzKCkge1xuICAgIHRoaXMudG8oJ3RyYW5zbGF0ZTpMaXN0VGVybWlub2xvZ2llcycpO1xuICAgIHJldHVybiB0aGlzO1xuICB9XG5cbiAgLyoqXG4gICAqIEdldHMgYSBsaXN0IG9mIHRoZSBiYXRjaCB0cmFuc2xhdGlvbiBqb2JzIHRoYXQgeW91IGhhdmUgc3VibWl0dGVkLlxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFJlYWRcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL3RyYW5zbGF0ZS9sYXRlc3QvZGcvQVBJX0xpc3RUZXh0VHJhbnNsYXRpb25Kb2JzLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0xpc3RUZXh0VHJhbnNsYXRpb25Kb2JzKCkge1xuICAgIHRoaXMudG8oJ3RyYW5zbGF0ZTpMaXN0VGV4dFRyYW5zbGF0aW9uSm9icycpO1xuICAgIHJldHVybiB0aGlzO1xuICB9XG5cbiAgLyoqXG4gICAqIFN0YXJ0cyBhbiBhc3luY2hyb25vdXMgYmF0Y2ggdHJhbnNsYXRpb24gam9iLiBCYXRjaCB0cmFuc2xhdGlvbiBqb2JzIGNhbiBiZSB1c2VkIHRvIHRyYW5zbGF0ZSBsYXJnZSB2b2x1bWVzIG9mIHRleHQgYWNyb3NzIG11bHRpcGxlIGRvY3VtZW50cyBhdCBvbmNlLlxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFdyaXRlXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS90cmFuc2xhdGUvbGF0ZXN0L2RnL0FQSV9TdGFydFRleHRUcmFuc2xhdGlvbkpvYi5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9TdGFydFRleHRUcmFuc2xhdGlvbkpvYigpIHtcbiAgICB0aGlzLnRvKCd0cmFuc2xhdGU6U3RhcnRUZXh0VHJhbnNsYXRpb25Kb2InKTtcbiAgICByZXR1cm4gdGhpcztcbiAgfVxuXG4gIC8qKlxuICAgKiBTdG9wcyBhbiBhc3luY2hyb25vdXMgYmF0Y2ggdHJhbnNsYXRpb24gam9iIHRoYXQgaXMgaW4gcHJvZ3Jlc3MuXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogV3JpdGVcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL3RyYW5zbGF0ZS9sYXRlc3QvZGcvQVBJX1N0b3BUZXh0VHJhbnNsYXRpb25Kb2IuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvU3RvcFRleHRUcmFuc2xhdGlvbkpvYigpIHtcbiAgICB0aGlzLnRvKCd0cmFuc2xhdGU6U3RvcFRleHRUcmFuc2xhdGlvbkpvYicpO1xuICAgIHJldHVybiB0aGlzO1xuICB9XG5cbiAgLyoqXG4gICAqIFRyYW5zbGF0ZSB0ZXh0IGZyb20gYSBzb3VyY2UgbGFuZ3VhZ2UgdG8gYSB0YXJnZXQgbGFuZ3VhZ2UuXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogUmVhZFxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vdHJhbnNsYXRlL2xhdGVzdC9kZy9BUElfVHJhbnNsYXRlVGV4dC5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9UcmFuc2xhdGVUZXh0KCkge1xuICAgIHRoaXMudG8oJ3RyYW5zbGF0ZTpUcmFuc2xhdGVUZXh0Jyk7XG4gICAgcmV0dXJuIHRoaXM7XG4gIH1cblxuICBwcm90ZWN0ZWQgYWNjZXNzTGV2ZWxMaXN0OiBBY2Nlc3NMZXZlbExpc3QgPSB7XG4gICAgXCJXcml0ZVwiOiBbXG4gICAgICBcIkRlbGV0ZVRlcm1pbm9sb2d5XCIsXG4gICAgICBcIkltcG9ydFRlcm1pbm9sb2d5XCIsXG4gICAgICBcIlN0YXJ0VGV4dFRyYW5zbGF0aW9uSm9iXCIsXG4gICAgICBcIlN0b3BUZXh0VHJhbnNsYXRpb25Kb2JcIlxuICAgIF0sXG4gICAgXCJSZWFkXCI6IFtcbiAgICAgIFwiRGVzY3JpYmVUZXh0VHJhbnNsYXRpb25Kb2JcIixcbiAgICAgIFwiR2V0VGVybWlub2xvZ3lcIixcbiAgICAgIFwiTGlzdFRlcm1pbm9sb2dpZXNcIixcbiAgICAgIFwiTGlzdFRleHRUcmFuc2xhdGlvbkpvYnNcIixcbiAgICAgIFwiVHJhbnNsYXRlVGV4dFwiXG4gICAgXVxuICB9O1xufVxuIl19