"""
# IAM Floyd

[![Source](https://img.shields.io/github/stars/udondan/iam-floyd?logo=github&label=GitHub%20Stars)](https://github.com/udondan/iam-floyd)
[![iam-floyd](https://img.shields.io/github/v/release/udondan/iam-floyd)](https://github.com/udondan/iam-floyd)
[![libraries.io](https://img.shields.io/badge/packages-libraries.io-yellow)](https://libraries.io/search?q=iam-floyd)
[![Documentation](https://img.shields.io/badge/Documentation-Read%20the%20Docs-orange)](https://iam-floyd.readthedocs.io/en/latest/)
[![CDKio](https://img.shields.io/badge/awscdk.io-cdk--iam--floyd-orange)](https://awscdk.io/packages/cdk-iam-floyd@0.95.0)
[![GitHub](https://img.shields.io/github/license/udondan/iam-floyd)](https://github.com/udondan/iam-floyd/blob/main/LICENSE)
[![Maintainability](https://api.codeclimate.com/v1/badges/cdb84b5646c6805b1a23/maintainability)](https://codeclimate.com/github/udondan/iam-floyd/maintainability)

<!-- put back - when we actually have tests
[![Test Coverage](https://api.codeclimate.com/v1/badges/cdb84b5646c6805b1a23/test_coverage)](https://codeclimate.com/github/udondan/iam-floyd/test_coverage)
-->

**AWS [IAM policy statement](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_statement.html) generator with fluent interface.**

<!-- stats -->

Support for:

* 244 Services
* 8319 Actions
* 821 Resource Types
* 495 Conditions

<!-- /stats -->

![EXPERIMENTAL](https://img.shields.io/badge/stability-experimantal-orange?style=for-the-badge)**<br>This is an early version of the package. The API will change while I implement new features. Therefore make sure you use an exact version in your `package.json` before it reaches 1.0.0.**

## Documentation

Find the documentation at [Read the Docs](https://iam-floyd.readthedocs.io/en/latest/).

[![Auto completion demo](https://raw.githubusercontent.com/udondan/iam-floyd/main/docs/movie-preview.png)](https://www.youtube.com/watch?v=4dHY8qPHbKA)

## Packages

There are two different package variants available:

* **iam-floyd**: Can be used in AWS SDK, Boto 3 or for whatever you need an IAM policy statement for <br>[![npm](https://img.shields.io/npm/dt/iam-floyd?label=npm&color=blueviolet)](https://www.npmjs.com/package/iam-floyd)
  [![PyPI](https://img.shields.io/pypi/dm/iam-floyd?label=pypi&color=blueviolet)](https://pypi.org/project/iam-floyd/)
  [![NuGet](https://img.shields.io/nuget/dt/IAM.Floyd?label=nuget&color=blueviolet)](https://www.nuget.org/packages/IAM.Floyd/)
* **cdk-iam-floyd**: Integrates into [AWS CDK](https://aws.amazon.com/cdk/) and extends [`iam.PolicyStatement`](https://docs.aws.amazon.com/cdk/api/latest/docs/@aws-cdk_aws-iam.PolicyStatement.html)<br>[![npm](https://img.shields.io/npm/dt/cdk-iam-floyd?label=npm&color=orange)](https://www.npmjs.com/package/cdk-iam-floyd)
  [![PyPI](https://img.shields.io/pypi/dm/cdk-iam-floyd?label=pypi&color=orange)](https://pypi.org/project/cdk-iam-floyd/)
  [![NuGet](https://img.shields.io/nuget/dt/CDK.IAM.Floyd?label=nuget&color=orange)](https://www.nuget.org/packages/CDK.IAM.Floyd/)

Find them all on [libraries.io](https://libraries.io/search?q=iam-floyd).

---


## Legal

The code contained in the [lib/generated](https://github.com/udondan/iam-floyd/tree/main/lib/generated) folder is generated from the [AWS documentation](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_actions-resources-contextkeys.html). The class- and function-names and their description therefore are property of AWS.

AWS and their services are trademarks, registered trademarks or trade dress of AWS in the U.S. and/or other countries.

This project is not affiliated, funded, or in any way associated with AWS.
"""
import abc
import builtins
import datetime
import enum
import typing

import jsii
import publication
import typing_extensions

from ._jsii import *


@jsii.data_type(
    jsii_type="iam-floyd.AccessLevelList",
    jsii_struct_bases=[],
    name_mapping={},
)
class AccessLevelList:
    def __init__(self) -> None:
        """
        stability
        :stability: experimental
        """
        self._values: typing.Dict[str, typing.Any] = {}

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AccessLevelList(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class Collection(metaclass=jsii.JSIIMeta, jsii_type="iam-floyd.Collection"):
    """
    stability
    :stability: experimental
    """

    def __init__(self) -> None:
        """
        stability
        :stability: experimental
        """
        jsii.create(Collection, self, [])

    @jsii.member(jsii_name="allowEc2InstanceDeleteByOwner")
    def allow_ec2_instance_delete_by_owner(self) -> typing.List["Ec2"]:
        """
        stability
        :stability: experimental
        """
        return jsii.invoke(self, "allowEc2InstanceDeleteByOwner", [])


@jsii.data_type(
    jsii_type="iam-floyd.Conditions",
    jsii_struct_bases=[],
    name_mapping={},
)
class Conditions:
    def __init__(self) -> None:
        """A collection of Condition's.

        stability
        :stability: experimental
        """
        self._values: typing.Dict[str, typing.Any] = {}

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "Conditions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.enum(jsii_type="iam-floyd.Effect")
class Effect(enum.Enum):
    """Policy effects.

    stability
    :stability: experimental
    """

    ALLOW = "ALLOW"
    """
    stability
    :stability: experimental
    """
    DENY = "DENY"
    """
    stability
    :stability: experimental
    """


class Operator(metaclass=jsii.JSIIMeta, jsii_type="iam-floyd.Operator"):
    """Use condition operators in the ``Condition`` element to match the condition key and value in the policy against values in the request context.

    For more information about the ``Condition`` element, see `IAM JSON Policy Elements: Condition <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition.html>`_.

    The condition operator that you can use in a policy depends on the condition key you choose. You can choose a global condition key or a service-specific condition key. To learn which condition operator you can use for a global condition key, see `AWS Global Condition Context Keys <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html>`_. To learn which condition operator you can use for a service-specific condition key, see `Actions, Resources, and Condition Keys for AWS Services <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_actions-resources-contextkeys.html>`_ and choose the service that you want to view.

    https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html

    stability
    :stability: experimental
    """

    def __init__(self) -> None:
        """
        stability
        :stability: experimental
        """
        jsii.create(Operator, self, [])

    @jsii.member(jsii_name="arnEquals")
    def arn_equals(self) -> "Operator":
        """Match of the ARN, case sensitive.

        Each of the six colon-delimited components of the ARN is checked separately and each can include a multi-character match wildcard (``*``) or a single-character match wildcard (``?``).

        ``ArnEquals`` and ``ArnLike`` behave identical.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "arnEquals", [])

    @jsii.member(jsii_name="arnLike")
    def arn_like(self) -> "Operator":
        """Match of the ARN, case sensitive.

        Each of the six colon-delimited components of the ARN is checked separately and each can include a multi-character match wildcard (``*``) or a single-character match wildcard (``?``).

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "arnLike", [])

    @jsii.member(jsii_name="arnNotEquals")
    def arn_not_equals(self) -> "Operator":
        """Negated match of the ARN, case sensitive.

        Each of the six colon-delimited components of the ARN is checked separately and each can include a multi-character match wildcard (``*``) or a single-character match wildcard (``?``).

        ``ArnNotEquals`` and ``ArnNotLike`` behave identical.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "arnNotEquals", [])

    @jsii.member(jsii_name="arnNotLike")
    def arn_not_like(self) -> "Operator":
        """Negated match of the ARN, case sensitive.

        Each of the six colon-delimited components of the ARN is checked separately and each can include a multi-character match wildcard (``*``) or a single-character match wildcard (``?``).

        ``ArnNotEquals`` and ``ArnNotLike`` behave identical.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "arnNotLike", [])

    @jsii.member(jsii_name="binaryEquals")
    def binary_equals(self) -> "Operator":
        """The BinaryEquals condition operator lets you construct Condition elements that test key values that are in binary format.

        It compares the value of the specified key byte for byte against a `base-64 <https://en.wikipedia.org/wiki/Base64>`_ encoded representation of the binary value in the policy.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "binaryEquals", [])

    @jsii.member(jsii_name="bool")
    def bool(self) -> "Operator":
        """Boolean match.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "bool", [])

    @jsii.member(jsii_name="dateEquals")
    def date_equals(self) -> "Operator":
        """Match a specific date: ``=``.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "dateEquals", [])

    @jsii.member(jsii_name="dateGreaterThan")
    def date_greater_than(self) -> "Operator":
        """Match after a specific a date and time: ``>``.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "dateGreaterThan", [])

    @jsii.member(jsii_name="dateGreaterThanEquals")
    def date_greater_than_equals(self) -> "Operator":
        """Match at or after a specific date and time: ``>=``.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "dateGreaterThanEquals", [])

    @jsii.member(jsii_name="dateLessThan")
    def date_less_than(self) -> "Operator":
        """Match before a specific date and time: ``<``.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "dateLessThan", [])

    @jsii.member(jsii_name="dateLessThanEquals")
    def date_less_than_equals(self) -> "Operator":
        """Match at or before a specific date and time: ``<=``.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "dateLessThanEquals", [])

    @jsii.member(jsii_name="dateNotEquals")
    def date_not_equals(self) -> "Operator":
        """Negated match for a specific date: ``!=``.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "dateNotEquals", [])

    @jsii.member(jsii_name="forAllValues")
    def for_all_values(self) -> "Operator":
        """Tests whether the value of every member of the request set is a subset of the condition key set.

        The condition returns true if every key value in the request matches at least one value in the policy. It also returns true if there are no keys in the request, or if the key values resolve to a null data set, such as an empty string.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "forAllValues", [])

    @jsii.member(jsii_name="forAnyValue")
    def for_any_value(self) -> "Operator":
        """Tests whether at least one member of the set of request values matches at least one member of the set of condition key values.

        The condition returns true if any one of the key values in the request matches any one of the condition values in the policy. For no matching key or a null dataset, the condition returns false.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "forAnyValue", [])

    @jsii.member(jsii_name="ifExists")
    def if_exists(self) -> "Operator":
        """You can add ``IfExists`` to the end of any condition operator name except the ``Null`` condition.

        For example, ``StringLikeIfExists``. You do this to say "If the policy key is present in the context of the request, process the key as specified in the policy. If the key is not present, evaluate the condition element as true." Other condition elements in the statement can still result in a nonmatch, but not a missing key when checked with ``...IfExists``.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "ifExists", [])

    @jsii.member(jsii_name="ipAddress")
    def ip_address(self) -> "Operator":
        """Match an IP address or range: ``=``.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "ipAddress", [])

    @jsii.member(jsii_name="notIpAddress")
    def not_ip_address(self) -> "Operator":
        """All IP addresses except the specified IP address or range ``!=``.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "notIpAddress", [])

    @jsii.member(jsii_name="null")
    def null(self) -> "Operator":
        """Check if a key is present at the time of authorization.

        In the policy statement, use either true (the key doesn't exist — it is null) or false (the key exists and its value is not null).

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "null", [])

    @jsii.member(jsii_name="numericEquals")
    def numeric_equals(self) -> "Operator":
        """Exact match.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "numericEquals", [])

    @jsii.member(jsii_name="numericGreaterThan")
    def numeric_greater_than(self) -> "Operator":
        """Match numbers higher than value: ``>``.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "numericGreaterThan", [])

    @jsii.member(jsii_name="numericGreaterThanEquals")
    def numeric_greater_than_equals(self) -> "Operator":
        """Match numbers higher or equal value: ``>=``.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "numericGreaterThanEquals", [])

    @jsii.member(jsii_name="numericLessThan")
    def numeric_less_than(self) -> "Operator":
        """Match numbers lower than value: ``<``.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "numericLessThan", [])

    @jsii.member(jsii_name="numericLessThanEquals")
    def numeric_less_than_equals(self) -> "Operator":
        """Match numbers lower or equal to value: ``<=``.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "numericLessThanEquals", [])

    @jsii.member(jsii_name="numericNotEquals")
    def numeric_not_equals(self) -> "Operator":
        """Negated exact match.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "numericNotEquals", [])

    @jsii.member(jsii_name="stringEquals")
    def string_equals(self) -> "Operator":
        """Exact match, case sensitive.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "stringEquals", [])

    @jsii.member(jsii_name="stringEqualsIgnoreCase")
    def string_equals_ignore_case(self) -> "Operator":
        """Exact match, ignore case.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "stringEqualsIgnoreCase", [])

    @jsii.member(jsii_name="stringLike")
    def string_like(self) -> "Operator":
        """Case-sensitive match.

        The values can include a multi-character match wildcard (``*``) or a single-character match wildcard (``?``) anywhere in the string.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "stringLike", [])

    @jsii.member(jsii_name="stringNotEquals")
    def string_not_equals(self) -> "Operator":
        """Negated exact match, case sensitive.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "stringNotEquals", [])

    @jsii.member(jsii_name="stringNotEqualsIgnoreCase")
    def string_not_equals_ignore_case(self) -> "Operator":
        """Exact exact match, ignore case.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "stringNotEqualsIgnoreCase", [])

    @jsii.member(jsii_name="stringNotLike")
    def string_not_like(self) -> "Operator":
        """Negated case-sensitive matching.

        The values can include a multi-character match wildcard (``*``) or a single-character match wildcard (``?``) anywhere in the string.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "stringNotLike", [])

    @jsii.member(jsii_name="toString")
    def to_string(self) -> builtins.str:
        """
        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toString", [])


class PolicyStatementBase(
    metaclass=jsii.JSIIMeta,
    jsii_type="iam-floyd.PolicyStatementBase",
):
    """Base class for the Policy Statement.

    stability
    :stability: experimental
    """

    def __init__(self, sid: typing.Optional[builtins.str] = None) -> None:
        """
        :param sid: -

        stability
        :stability: experimental
        """
        jsii.create(PolicyStatementBase, self, [sid])

    @jsii.member(jsii_name="toJSON")
    def to_json(self) -> typing.Any:
        """JSON-ify the policy statement.

        Used when JSON.stringify() is called

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toJSON", [])

    @builtins.property # type: ignore
    @jsii.member(jsii_name="servicePrefix")
    def service_prefix(self) -> builtins.str:
        """Holds the prefix of the service actions, e.g. ``ec2``.

        stability
        :stability: experimental
        """
        return jsii.get(self, "servicePrefix")

    @service_prefix.setter # type: ignore
    def service_prefix(self, value: builtins.str) -> None:
        jsii.set(self, "servicePrefix", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="sid")
    def sid(self) -> builtins.str:
        """
        stability
        :stability: experimental
        """
        return jsii.get(self, "sid")

    @sid.setter # type: ignore
    def sid(self, value: builtins.str) -> None:
        jsii.set(self, "sid", value)


class PolicyStatementWithCondition(
    PolicyStatementBase,
    metaclass=jsii.JSIIMeta,
    jsii_type="iam-floyd.PolicyStatementWithCondition",
):
    """Adds "condition" functionality to the Policy Statement.

    stability
    :stability: experimental
    """

    def __init__(self, sid: typing.Optional[builtins.str] = None) -> None:
        """
        :param sid: -

        stability
        :stability: experimental
        """
        jsii.create(PolicyStatementWithCondition, self, [sid])

    @jsii.member(jsii_name="hasConditions")
    def has_conditions(self) -> builtins.bool:
        """Checks weather a condition was applied to the policy.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "hasConditions", [])

    @jsii.member(jsii_name="if")
    def if_(
        self,
        key: builtins.str,
        value: typing.Any,
        operator: typing.Optional[typing.Union[builtins.str, "Operator"]] = None,
    ) -> "PolicyStatementWithCondition":
        """Adds a condition to the statement.

        :param key: The key of the condition.
        :param value: The value(s) to check for.
        :param operator: `Operator <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html>`_ of the condition. **Default:** ``StringLike``.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "if", [key, value, operator])

    @jsii.member(jsii_name="ifAwsCalledVia")
    def if_aws_called_via(
        self,
        value: typing.Union[builtins.str, typing.List[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, "Operator"]] = None,
    ) -> "PolicyStatementWithCondition":
        """Compare the services with the services that made requests on behalf of the IAM principal (user or role).

        When a principal makes a request to an AWS service, that service might use the principal's credentials to make subsequent requests to other services.

        The ``aws:CalledVia`` key contains an ordered list of each service in the chain that made requests on the principal's behalf.

        **Availability:** This key is present in the request when a service that supports aws:CalledVia uses the credentials of an IAM principal to make a request to another service. This key is not present if the service uses a `service role <https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_terms-and-concepts.html#iam-term-service-role>`_ or `service-linked role <https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_terms-and-concepts.html#iam-term-service-linked-role>`_ to make a call on the principal's behalf. This key is also not present when the principal makes the call directly.

        https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-calledvia

        :param value: The service(s) to check for.
        :param operator: Works with `string operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String>`_. **Default:** ``ForAnyValue:StringEquals``.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "ifAwsCalledVia", [value, operator])

    @jsii.member(jsii_name="ifAwsCalledViaFirst")
    def if_aws_called_via_first(
        self,
        value: typing.Union[builtins.str, typing.List[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, "Operator"]] = None,
    ) -> "PolicyStatementWithCondition":
        """Compare the services with the first service that made a request on behalf of the IAM principal (user or role).

        For more information, see `aws:CalledVia <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-calledvia>`_.

        **Availability:** This key is present in the request when a service that supports aws:CalledVia uses the credentials of an IAM principal to make a request to another service. This key is not present if the service uses a `service role <https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_terms-and-concepts.html#iam-term-service-role>`_ or `service-linked role <https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_terms-and-concepts.html#iam-term-service-linked-role>`_ to make a call on the principal's behalf. This key is also not present when the principal makes the call directly.

        https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-calledviafirst

        :param value: The service(s) to check for.
        :param operator: Works with `string operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String>`_. **Default:** ``StringLike``.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "ifAwsCalledViaFirst", [value, operator])

    @jsii.member(jsii_name="ifAwsCalledViaLast")
    def if_aws_called_via_last(
        self,
        value: typing.Union[builtins.str, typing.List[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, "Operator"]] = None,
    ) -> "PolicyStatementWithCondition":
        """Compare the services with the last service that made a request on behalf of the IAM principal (user or role).

        For more information, see `aws:CalledVia <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-calledvia>`_.

        **Availability:** This key is present in the request when a service that supports aws:CalledVia uses the credentials of an IAM principal to make a request to another service. This key is not present if the service uses a `service role <https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_terms-and-concepts.html#iam-term-service-role>`_ or `service-linked role <https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_terms-and-concepts.html#iam-term-service-linked-role>`_ to make a call on the principal's behalf. This key is also not present when the principal makes the call directly.

        https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-calledvialast

        :param value: The service(s) to check for.
        :param operator: Works with `string operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String>`_. **Default:** ``StringLike``.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "ifAwsCalledViaLast", [value, operator])

    @jsii.member(jsii_name="ifAwsCurrentTime")
    def if_aws_current_time(
        self,
        value: typing.Union[builtins.str, datetime.datetime, typing.List[typing.Union[builtins.str, datetime.datetime]]],
        operator: typing.Optional[typing.Union[builtins.str, "Operator"]] = None,
    ) -> "PolicyStatementWithCondition":
        """Compare the date and time of the request with the date and time that you specify.

        To view an example policy that uses this condition key, see `AWS: Allows Access Within Specific Dates <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_examples_aws-dates.html>`_.

        **Availability:** This key is always included in the request context.

        https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-currenttime

        :param value: The date and time to check for. Can be a string in one of the `W3C implementations of the ISO 8601 date <https://www.w3.org/TR/NOTE-datetime>`_ (e.g. ``2020-04-01T00:00:00Z``) or in epoch (UNIX) time or a ``Date()`` object (JavaScript only)
        :param operator: Works with `date operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_Date>`_. **Default:** ``DateLessThanEquals``.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "ifAwsCurrentTime", [value, operator])

    @jsii.member(jsii_name="ifAwsEpochTime")
    def if_aws_epoch_time(
        self,
        value: typing.Union[builtins.str, jsii.Number, datetime.datetime, typing.List[typing.Union[builtins.str, jsii.Number, datetime.datetime]]],
        operator: typing.Optional[typing.Union[builtins.str, "Operator"]] = None,
    ) -> "PolicyStatementWithCondition":
        """Compare the date and time of the request in epoch or Unix time with the value that you specify.

        This key also accepts the number of seconds since January 1, 1970.

        **Availability:** This key is always included in the request context.

        https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-epochtime

        :param value: The date and time to check for. Can be a string in one of the `W3C implementations of the ISO 8601 date <https://www.w3.org/TR/NOTE-datetime>`_ (e.g. ``2020-04-01T00:00:00Z``) or in epoch (UNIX) time or a ``Date()`` object (JavaScript only)
        :param operator: Works with `date <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_Date>`_ and `numeric operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_Numeric>`_. **Default:** ``DateLessThanEquals``.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "ifAwsEpochTime", [value, operator])

    @jsii.member(jsii_name="ifAwsMultiFactorAuthAge")
    def if_aws_multi_factor_auth_age(
        self,
        value: typing.Union[jsii.Number, typing.List[jsii.Number]],
        operator: typing.Optional[typing.Union[builtins.str, "Operator"]] = None,
    ) -> "PolicyStatementWithCondition":
        """Compare the number of seconds since the requesting principal was authorized using MFA with the number that you specify.

        For more information about MFA, see `Using Multi-Factor Authentication (MFA) in AWS <https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_mfa.html>`_.

        **Availability:** This key is included in the request context only if the principal was authenticated using MFA. If MFA was not used, this key is not present.

        https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-multifactorauthage

        :param value: Number of seconds.
        :param operator: Works with `numeric operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_Numeric>`_. **Default:** ``NumericLessThan``.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "ifAwsMultiFactorAuthAge", [value, operator])

    @jsii.member(jsii_name="ifAwsMultiFactorAuthPresent")
    def if_aws_multi_factor_auth_present(
        self,
        value: typing.Optional[builtins.bool] = None,
    ) -> "PolicyStatementWithCondition":
        """Check whether multi-factor authentication (MFA) was used to validate the temporary security credentials that made the request.

        **Availability:** This key is included in the request context only when the principal uses temporary credentials to make the request. The key is not present in AWS CLI, AWS API, or AWS SDK requests that are made using long-term credentials.

        Temporary credentials are used to authenticate IAM roles, federated users, IAM users with temporary tokens from ``sts:GetSessionToken``, and users of the AWS Management Console. IAM users in the AWS Management Console unknowingly use temporary credentials. Users sign into the console using their user name and password, which are long-term credentials. However, in the background, the console generates temporary credentials on behalf of the user. To learn which services support using temporary credentials, see `AWS Services That Work with IAM <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-services-that-work-with-iam.html>`_.

        The ``aws:MultiFactorAuthPresent`` key is not present when an API or CLI command is called with long-term credentials, such as user access key pairs. Therefore we recommend that when you check for this key that you use the `...IfExists <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_IfExists>`_ versions of the condition operators.

        https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-multifactorauthpresent

        :param value: Weather the MFA should be present or absent. **Default:** ``true``

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "ifAwsMultiFactorAuthPresent", [value])

    @jsii.member(jsii_name="ifAwsPrincipalAccount")
    def if_aws_principal_account(
        self,
        value: typing.Union[builtins.str, typing.List[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, "Operator"]] = None,
    ) -> "PolicyStatementWithCondition":
        """Compare the account to which the requesting principal belongs with the account identifier that you specify.

        **Availability:** This key is always included in the request context.

        https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-principalaccount

        :param value: Account identifier(s).
        :param operator: Works with `string operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String>`_. **Default:** ``StringLike``.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "ifAwsPrincipalAccount", [value, operator])

    @jsii.member(jsii_name="ifAwsPrincipalArn")
    def if_aws_principal_arn(
        self,
        value: typing.Union[builtins.str, typing.List[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, "Operator"]] = None,
    ) -> "PolicyStatementWithCondition":
        """Compare the `Amazon Resource Name <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html#identifiers-arns>`_ (ARN) of the principal that made the request with the ARN that you specify.

        For IAM roles, the request context returns the ARN of the role, not the ARN of the user that assumed the role. To learn which types of principals you can specify in this condition key, see `Specifying a Principal <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_principal.html#Principal_specifying>`_.

        **Availability:** This key is always included in the request context.

        https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-principalarn

        :param value: Principle ARN(s).
        :param operator: Works with `ARN operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_ARN>`_ and `string operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String>`_. **Default:** ``ArnLike``.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "ifAwsPrincipalArn", [value, operator])

    @jsii.member(jsii_name="ifAwsPrincipalOrgID")
    def if_aws_principal_org_id(
        self,
        value: typing.Union[builtins.str, typing.List[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, "Operator"]] = None,
    ) -> "PolicyStatementWithCondition":
        """Compare the identifier of the organization in AWS Organizations to which the requesting principal belongs with the identifier you specify.

        **Availability:** This key is included in the request context only if the principal is a member of an organization.

        This global key provides an alternative to listing all the account IDs for all AWS accounts in an organization. You can use this condition key to simplify specifying the ``Principal`` element in a resource-based policy. You can specify the organization ID in the condition element. When you add and remove accounts, policies that include the ``aws:PrincipalOrgID`` key automatically include the correct accounts and don't require manual updating.

        https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-principalorgid

        :param value: Organization ID(s) in format ``o-xxxxxxxxxxx``.
        :param operator: Works with `string operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String>`_. **Default:** ``StringLike``.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "ifAwsPrincipalOrgID", [value, operator])

    @jsii.member(jsii_name="ifAwsPrincipalOrgPaths")
    def if_aws_principal_org_paths(
        self,
        value: typing.Union[builtins.str, typing.List[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, "Operator"]] = None,
    ) -> "PolicyStatementWithCondition":
        """Compare the AWS Organizations path for the principal who is making the request to the path you provide.

        That principal can be an IAM user, IAM role, federated user, or AWS account root user.

        This condition ensures that the requester is an account member within the specified organization root or organizational units (OUs) in AWS Organizations. An AWS Organizations path is a text representation of the structure of an Organizations entity. For more information about using and understanding paths, see Understand the `AWS Organizations Entity Path <https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor-view-data-orgs.html#access_policies_access-advisor-viewing-orgs-entity-path>`_.

        **Availability:** This key is included in the request context only if the principal is a member of an organization.

        **Note:** Organization IDs are globally unique but OU IDs and root IDs are unique only within an organization. This means that no two organizations share the same organization ID. However, another organization might have an OU or root with the same ID as yours. We recommend that you always include the organization ID when you specify an OU or root.

        ``aws:PrincipalOrgPaths`` is a multivalued condition key. Multivalued keys include one or more values in a list format. The result is a logical ``OR``. When you use multiple values with the ``ForAnyValue:`` condition operator, the principal's path must match one of the paths provided. For policies that include multiple values for a single key, you must enclose the conditions within brackets like an array (``"Key":["Value1", "Value2"]``). You should also include these brackets when there is a single value. For more information about multivalued condition keys, see `Creating a Condition with Multiple Keys or Values <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_multi-value-conditions.html>`_.

        https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-principalorgpaths

        :param value: Organization path(s) in the format of ``o-xxxxxxxxxxx/r-xxxxxxxxxx/ou-xxxx-xxxxxxxx/ou-xxxx-xxxxxxxx/``.
        :param operator: Works with `string operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String>`_. **Default:** ``StringEquals``.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "ifAwsPrincipalOrgPaths", [value, operator])

    @jsii.member(jsii_name="ifAwsPrincipalTag")
    def if_aws_principal_tag(
        self,
        key: builtins.str,
        value: typing.Union[builtins.str, typing.List[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, "Operator"]] = None,
    ) -> "PolicyStatementWithCondition":
        """Compare the tag attached to the principal making the request with the tag that you specify.

        If the principal has more than one tag attached, the request context includes one aws:PrincipalTag key for each attached tag key.

        **Availability:** This key is included in the request context if the principal is using an IAM user with attached tags. It is included for a principal using an IAM role with attached tags or `session tags <https://docs.aws.amazon.com/IAM/latest/UserGuide/id_session-tags.html>`_.

        You can add custom attributes to a user or role in the form of a key-value pair. For more information about IAM tags, see `Tagging IAM Users and Roles <https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html>`_. You can use ``aws:PrincipalTag`` to `control access <https://docs.aws.amazon.com/IAM/latest/UserGuide/access_iam-tags.html#access_iam-tags_control-resources>`_ for AWS principals.

        https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-principaltag

        :param key: The tag key to check.
        :param value: The tag value(s) to check against.
        :param operator: Works with `string operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String>`_. **Default:** ``StringLike``.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "ifAwsPrincipalTag", [key, value, operator])

    @jsii.member(jsii_name="ifAwsPrincipalType")
    def if_aws_principal_type(
        self,
        value: typing.Union[builtins.str, typing.List[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, "Operator"]] = None,
    ) -> "PolicyStatementWithCondition":
        """Compare the type of principal making the request with the principal type that you specify.

        For details about how the information appears in the request context for different principals, see `Specifying a Principal <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_principal.html#Principal_specifying>`_.

        **Availability:** This key is always included in the request context.

        https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-principaltype

        :param value: The principal type(s). Any of ``Account``, ``User``, ``FederatedUser``, ``AssumedRole``, ``Anonymous``
        :param operator: Works with `string operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String>`_. **Default:** ``StringEquals``.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "ifAwsPrincipalType", [value, operator])

    @jsii.member(jsii_name="ifAwsReferer")
    def if_aws_referer(
        self,
        value: typing.Union[builtins.str, typing.List[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, "Operator"]] = None,
    ) -> "PolicyStatementWithCondition":
        """Compare who referred the request in the client browser with the referer that you specify.

        The ``aws:referer`` request context value is provided by the caller in an HTTP header.

        **Availability:** This key is included in the request context only if the request was invoked using a URL in the browser.

        For example, you can call `Amazon S3 API operations directly using a web browser <https://docs.aws.amazon.com/AmazonS3/latest/dev/example-bucket-policies.html#example-bucket-policies-use-case-4>`_. This means that you can view S3 objects, such as images and documents, directly through a web browser. The ``aws:referer`` condition allows you to restrict access to specific values in the HTTP or HTTPS request based on the value of the referrer header.

        **Warning:** This condition should be used carefully. It is dangerous to include a publicly known referer header value. Unauthorized parties can use modified or custom browsers to provide any ``aws:referer`` value that they choose. As a result, ``aws:referer`` should not be used to prevent unauthorized parties from making direct AWS requests. It is offered only to allow customers to protect their digital content, such as content stored in Amazon S3, from being referenced on unauthorized third-party sites.

        https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-referer

        :param value: The referer url(s).
        :param operator: Works with `string operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String>`_. **Default:** ``StringLike``.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "ifAwsReferer", [value, operator])

    @jsii.member(jsii_name="ifAwsRequestedRegion")
    def if_aws_requested_region(
        self,
        value: typing.Union[builtins.str, typing.List[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, "Operator"]] = None,
    ) -> "PolicyStatementWithCondition":
        """Compare the AWS Region that was called in the request with the Region that you specify.

        You can use this global condition key to control which Regions can be requested. To view the AWS Regions for each service, see `Service endpoints and quotas <https://docs.aws.amazon.com/general/latest/gr/aws-service-information.html>`_ in the Amazon Web Services General Reference.

        **Availability:** This key is always included in the request context.

        Some global services, such as IAM, have a single endpoint. Because this endpoint is physically located in the US East (N. Virginia) Region, IAM calls are always made to the us-east-1 Region. For example, if you create a policy that denies access to all services if the requested Region is not us-west-2, then IAM calls always fail. To view an example of how to work around this, see `NotAction with Deny <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_notaction.html>`_.

        **Note:** The ``aws:RequestedRegion`` condition key allows you to control which endpoint of a service is invoked but does not control the impact of the operation. Some services have cross-Region impacts. For example, Amazon S3 has API operations that control cross-Region replication. You can invoke ``s3:PutBucketReplication`` in one Region (which is affected by the ``aws:RequestedRegion`` condition key), but other Regions are affected based on the replications configuration settings.

        https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-requestedregion

        :param value: The region(s).
        :param operator: Works with `string operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String>`_. **Default:** ``StringEquals``.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "ifAwsRequestedRegion", [value, operator])

    @jsii.member(jsii_name="ifAwsRequestTag")
    def if_aws_request_tag(
        self,
        key: builtins.str,
        value: typing.Union[builtins.str, typing.List[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, "Operator"]] = None,
    ) -> "PolicyStatementWithCondition":
        """Compare the tag key-value pair that was passed in the request with the tag pair that you specify.

        For example, you could check whether the request includes the tag key ``Dept`` and that it has the value ``Accounting``. For more information, see `Controlling Access During AWS Requests <https://docs.aws.amazon.com/IAM/latest/UserGuide/access_tags.html#access_tags_control-requests>`_.

        **Availability:** This key is included in the request context when tags are passed in the request. When multiple tags are passed in the request, there is one context key for each tag key-value pair.

        Because you can include multiple tag key-value pairs in a request, the request content could be a multivalued request. In this case, you should consider using the ``ForAllValues`` or ``ForAnyValue`` set operators. For more information, see `Using Multiple Keys and Values <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_multi-value-conditions.html#reference_policies_multi-key-or-value-conditions>`_.

        https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-requesttag

        :param key: The tag key to check.
        :param value: The tag value(s) to check against.
        :param operator: Works with `string operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String>`_. **Default:** ``StringLike``.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "ifAwsRequestTag", [key, value, operator])

    @jsii.member(jsii_name="ifAwsResourceTag")
    def if_aws_resource_tag(
        self,
        key: builtins.str,
        value: typing.Union[builtins.str, typing.List[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, "Operator"]] = None,
    ) -> "PolicyStatementWithCondition":
        """Compare the tag key-value pair that you specify with the key-value pair that is attached to the resource.

        For example, you could require that access to a resource is allowed only if the resource has the attached tag key ``Dept`` with the value ``Marketing``. For more information, see `Controlling Access to AWS Resources <https://docs.aws.amazon.com/IAM/latest/UserGuide/access_tags.html#access_tags_control-resources>`_.

        **Availability:** This key is included in the request context when the requested resource already has attached tags. This key is returned only for resources that `support authorization based on tags <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-services-that-work-with-iam.html>`_. There is one context key for each tag key-value pair.

        https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-resourcetag

        :param key: The tag key to check.
        :param value: The tag value(s) to check against.
        :param operator: Works with `string operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String>`_. **Default:** ``StringLike``.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "ifAwsResourceTag", [key, value, operator])

    @jsii.member(jsii_name="ifAwsSecureTransport")
    def if_aws_secure_transport(
        self,
        value: typing.Optional[builtins.bool] = None,
    ) -> "PolicyStatementWithCondition":
        """Check whether the request was sent using SSL.

        The request context returns ``true`` or ``false``. In a policy, you can allow specific actions only if the request is sent using SSL.

        **Availability:** This key is always included in the request context.

        https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-securetransport

        :param value: Weather request was sent using SSL. **Default:** ``true``

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "ifAwsSecureTransport", [value])

    @jsii.member(jsii_name="ifAwsSourceAccount")
    def if_aws_source_account(
        self,
        value: typing.Union[builtins.str, typing.List[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, "Operator"]] = None,
    ) -> "PolicyStatementWithCondition":
        """Compare the account ID of the resource making a service-to-service request with the account ID that you specify.

        **Availability:** This key is included in the request context only if accessing a resource triggers an AWS service to call another service on behalf of the resource owner. The calling service must pass the resource ARN of the source to the called service. This ARN includes the source account ID.

        You can use this condition key to check that Amazon S3 is not being used as a `confused deputy <https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_create_for-user_externalid.html#confused-deputy>`_. For example, when an Amazon S3 bucket update triggers an Amazon SNS topic post, the Amazon S3 service invokes the ``sns:Publish`` API operation. The bucket is considered the source of the SNS request and the value of the key is the account ID from the bucket's ARN.

        https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-sourceaccount

        :param value: The account ID(s).
        :param operator: Works with `string operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String>`_. **Default:** ``StringLike``.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "ifAwsSourceAccount", [value, operator])

    @jsii.member(jsii_name="ifAwsSourceArn")
    def if_aws_source_arn(
        self,
        value: typing.Union[builtins.str, typing.List[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, "Operator"]] = None,
    ) -> "PolicyStatementWithCondition":
        """Compare the `Amazon Resource Name (ARN) <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html#identifiers-arns>`_ of the resource making a service-to-service request with the ARN that you specify.

        This key does not work with the ARN of the principal making the request. Instead, use `aws:PrincipalArn <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-principalarn>`_. The source's ARN includes the account ID, so it is not necessary to use ``aws:SourceAccount`` with ``aws:SourceArn``.

        **Availability:** This key is included in the request context only if accessing a resource triggers an AWS service to call another service on behalf of the resource owner. The calling service must pass the ARN of the original resource to the called service.

        You can use this condition key to check that Amazon S3 is not being used as a `confused deputy <https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_create_for-user_externalid.html#confused-deputy>`_. For example, when an Amazon S3 bucket update triggers an Amazon SNS topic post, the Amazon S3 service invokes the ``sns:Publish`` API operation. The bucket is considered the source of the SNS request and the value of the key is the bucket's ARN.

        https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-sourcearn

        :param value: The source ARN(s).
        :param operator: Works with `ARN operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_ARN>`_ and `string operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String>`_. **Default:** ``ArnLike``.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "ifAwsSourceArn", [value, operator])

    @jsii.member(jsii_name="ifAwsSourceIp")
    def if_aws_source_ip(
        self,
        value: typing.Union[builtins.str, typing.List[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, "Operator"]] = None,
    ) -> "PolicyStatementWithCondition":
        """Compare the requester's IP address with the IP address that you specify.

        **Availability:** This key is included in the request context, except when the requester uses a VPC endpoint to make the request.

        The ``aws:SourceIp`` condition key can be used in a policy to allow principals to make requests only from within a specified IP range. However, this policy denies access if an AWS service makes calls on the principal's behalf. In this case, you can use ``aws:SourceIp`` with the `aws:ViaAWSService <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-viaawsservice>`_ key to ensure that the source IP restriction applies only to requests made directly by a principal.

        https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-sourceip

        :param value: The source IP(s).
        :param operator: Works with IP `address operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_IPAddress>`_. **Default:** ``IpAddress``.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "ifAwsSourceIp", [value, operator])

    @jsii.member(jsii_name="ifAwsSourceVpc")
    def if_aws_source_vpc(
        self,
        value: typing.Union[builtins.str, typing.List[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, "Operator"]] = None,
    ) -> "PolicyStatementWithCondition":
        """Check whether the request comes from the VPC that you specify.

        In a policy, you can use this condition to allow access to only a specific VPC. For more information, see `Restricting Access to a Specific VPC <https://docs.aws.amazon.com/AmazonS3/latest/dev/example-bucket-policies-vpc-endpoint.html#example-bucket-policies-restrict-access-vpc>`_ in the *Amazon Simple Storage Service Developer Guide*.

        **Availability:** This key is included in the request context only if the requester uses a VPC endpoint to make the request.

        https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-sourcevpc

        :param value: The VPS ID(s).
        :param operator: Works with `string operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String>`_. **Default:** ``StringEquals``.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "ifAwsSourceVpc", [value, operator])

    @jsii.member(jsii_name="ifAwsSourceVpce")
    def if_aws_source_vpce(
        self,
        value: typing.Union[builtins.str, typing.List[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, "Operator"]] = None,
    ) -> "PolicyStatementWithCondition":
        """Compare the VPC endpoint identifier of the request with the endpoint ID that you specify.

        In a policy, you can use this condition to restrict access to a specific VPC endpoint. For more information, see `Restricting Access to a Specific VPC Endpoint <https://docs.aws.amazon.com/AmazonS3/latest/dev/example-bucket-policies-vpc-endpoint.html#example-bucket-policies-restrict-access-vpc-endpoint>`_ in the *Amazon Simple Storage Service Developer Guide*.

        **Availability:** This key is included in the request context only if the requester uses a VPC endpoint to make the request.

        https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-sourcevpce

        :param value: The VPC Endpoint ID(s).
        :param operator: Works with `string operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String>`_. **Default:** ``StringLike``.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "ifAwsSourceVpce", [value, operator])

    @jsii.member(jsii_name="ifAwsTagKeys")
    def if_aws_tag_keys(
        self,
        value: typing.Union[builtins.str, typing.List[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, "Operator"]] = None,
    ) -> "PolicyStatementWithCondition":
        """Compare the tag keys in a request with the keys that you specify.

        As a best practice when you use policies to control access using tags, use the ``aws:TagKeys`` condition key to define what tag keys are allowed. For example policies and more information, see `Controlling Access Based on Tag Keys <https://docs.aws.amazon.com/IAM/latest/UserGuide/access_tags.html#access_tags_control-tag-keys>`_.

        **Availability:** This key is included in the request context only if the operation supports attaching tags to resources.

        Because you can include multiple tag key-value pairs in a request, the request content could be a `multivalued <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_multi-value-conditions.html>`_ request. In this case, you should consider using the ``ForAllValues`` or ``ForAnyValue`` set operators. For more information, see Using Multiple Keys and Values.

        Some services support tagging with resource operations, such as creating, modifying, or deleting a resource. To allow tagging and operations as a single call, you must create a policy that includes both the tagging action and the resource-modifying action. You can then use the ``aws:TagKeys`` condition key to enforce using specific tag keys in the request. For example, to limit tags when someone creates an Amazon EC2 snapshot, you must include the ``ec2:CreateSnapshot`` creation action ***and*** the ``ec2:CreateTags`` tagging action in the policy. To view a policy for this scenario that uses ``aws:TagKeys``, see `Creating a Snapshot with Tags <https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ExamplePolicies_EC2.html#iam-creating-snapshot-with-tags>`_ in the *Amazon EC2 User Guide for Linux Instances*.

        https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-tagkeys

        :param value: The tag key(s).
        :param operator: Works with `string operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String>`_. **Default:** ``StringLike``.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "ifAwsTagKeys", [value, operator])

    @jsii.member(jsii_name="ifAwsTokenIssueTime")
    def if_aws_token_issue_time(
        self,
        value: typing.Union[builtins.str, datetime.datetime],
        operator: typing.Optional[typing.Union[builtins.str, "Operator"]] = None,
    ) -> "PolicyStatementWithCondition":
        """Compare the date and time that temporary security credentials were issued with the date and time that you specify.

        **Availability:** This key is included in the request context only when the principal uses temporary credentials to make the request. They key is not present in AWS CLI, AWS API, or AWS SDK requests that are made using access keys.

        To learn which services support using temporary credentials, see `AWS Services That Work with IAM <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-services-that-work-with-iam.html>`_.

        https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-tokenissuetime

        :param value: The date and time to check for. Can be a string in one of the `W3C implementations of the ISO 8601 date <https://www.w3.org/TR/NOTE-datetime>`_ (e.g. ``2020-04-01T00:00:00Z``) or in epoch (UNIX) time or a ``Date()`` object (JavaScript only)
        :param operator: Works with `date operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_Date>`_. **Default:** ``DateGreaterThanEquals``.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "ifAwsTokenIssueTime", [value, operator])

    @jsii.member(jsii_name="ifAwsUserAgent")
    def if_aws_user_agent(
        self,
        value: typing.Union[builtins.str, typing.List[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, "Operator"]] = None,
    ) -> "PolicyStatementWithCondition":
        """Compare the requester's client application with the application that you specify.

        **Availability:** This key is always included in the request context.

        **Warning:** This key should be used carefully. Since the ``aws:UserAgent`` value is provided by the caller in an HTTP header, unauthorized parties can use modified or custom browsers to provide any ``aws:UserAgent`` value that they choose. As a result, ``aws:UserAgent`` should not be used to prevent unauthorized parties from making direct AWS requests. You can use it to allow only specific client applications, and only after testing your policy.

        https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-useragent

        :param value: The User Agent string(s).
        :param operator: Works with `string operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String>`_. **Default:** ``StringLike``.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "ifAwsUserAgent", [value, operator])

    @jsii.member(jsii_name="ifAwsUserid")
    def if_aws_userid(
        self,
        value: typing.Union[builtins.str, typing.List[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, "Operator"]] = None,
    ) -> "PolicyStatementWithCondition":
        """Compare the requester's principal identifier with the ID that you specify.

        For IAM users, the request context value is the user ID. For IAM roles, this value format can vary. For details about how the information appears for different principals, see `Specifying a Principal <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_principal.html#Principal_specifying>`_.

        **Availability:** This key is included in the request context for all signed requests. Anonymous requests do not include this key.

        https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-userid

        :param value: The principal identifier(s).
        :param operator: Works with `string operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String>`_. **Default:** ``StringLike``.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "ifAwsUserid", [value, operator])

    @jsii.member(jsii_name="ifAwsUsername")
    def if_aws_username(
        self,
        value: typing.Union[builtins.str, typing.List[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, "Operator"]] = None,
    ) -> "PolicyStatementWithCondition":
        """Compare the requester's user name with the user name that you specify.

        For details about how the information appears for different principals, see `Specifying a Principal <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_principal.html#Principal_specifying>`_.

        **Availability:** This key is always included in the request context for IAM users. Anonymous requests and requests that are made using the AWS account root user or IAM roles do not include this key.

        https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-username

        :param value: The user name(s).
        :param operator: Works with `string operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String>`_. **Default:** ``StringLike``.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "ifAwsUsername", [value, operator])

    @jsii.member(jsii_name="ifAwsViaAWSService")
    def if_aws_via_aws_service(
        self,
        value: typing.Optional[builtins.bool] = None,
    ) -> "PolicyStatementWithCondition":
        """Check whether an AWS service makes a request to another service on your behalf.

        The request context key returns ``true`` when a service uses the credentials of an IAM principal to make a request on behalf of the principal. The context key returns ``false`` if the service uses a `service role <https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_terms-and-concepts.html#iam-term-service-role>`_ or `service-linked role <https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_terms-and-concepts.html#iam-term-service-linked-role>`_ to make a call on the principal's behalf. The request context key also returns ``false`` when the principal makes the call directly.

        **Availability:** This key is always included in the request context for most services.

        The following services do not currently support ``aws:ViaAWSService``:

        - Amazon EC2
        - AWS Glue
        - AWS Lake Formation
        - AWS OpsWorks

        You can use this condition key to allow or deny access based on whether a request was made by a service. To view an example policy, see `AWS: Denies Access to AWS Based on the Source IP <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_examples_aws_deny-ip.html>`_.

        https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-viaawsservice

        :param value: Whether a request was made by a service. **Default:** ``true``

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "ifAwsViaAWSService", [value])

    @jsii.member(jsii_name="ifAwsVpcSourceIp")
    def if_aws_vpc_source_ip(
        self,
        value: typing.Union[builtins.str, typing.List[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, "Operator"]] = None,
    ) -> "PolicyStatementWithCondition":
        """Compare the IP address from which a request was made with the IP address that you specify.

        In a policy, the key matches only if the request originates from the specified IP address and it goes through a VPC endpoint.

        **Availability:** This key is included in the request context only if the request is made using a VPC endpoint.

        For more information, see `Controlling Access to Services with VPC Endpoints <https://docs.aws.amazon.com/vpc/latest/userguide/vpc-endpoints-access.html>`_ in the *Amazon VPC User Guide*.

        https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-vpcsourceip

        :param value: The VPC source IP(s).
        :param operator: Works with IP `address operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_IPAddress>`_. **Default:** ``IpAddress``.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "ifAwsVpcSourceIp", [value, operator])

    @jsii.member(jsii_name="toJSON")
    def to_json(self) -> typing.Any:
        """Injects conditions into the statement.

        Only relevant for the main package. In CDK mode this only calls super.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toJSON", [])

    @jsii.member(jsii_name="toStatementJson")
    def to_statement_json(self) -> typing.Any:
        """
        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toStatementJson", [])

    @builtins.property # type: ignore
    @jsii.member(jsii_name="conditions")
    def _conditions(self) -> "Conditions":
        """
        stability
        :stability: experimental
        """
        return jsii.get(self, "conditions")

    @_conditions.setter # type: ignore
    def _conditions(self, value: "Conditions") -> None:
        jsii.set(self, "conditions", value)


@jsii.data_type(
    jsii_type="iam-floyd.Principals",
    jsii_struct_bases=[],
    name_mapping={},
)
class Principals:
    def __init__(self) -> None:
        """A collection of Principal's.

        stability
        :stability: experimental
        """
        self._values: typing.Dict[str, typing.Any] = {}

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "Principals(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="iam-floyd.ResourceTypes",
    jsii_struct_bases=[],
    name_mapping={},
)
class ResourceTypes:
    def __init__(self) -> None:
        """
        stability
        :stability: experimental
        """
        self._values: typing.Dict[str, typing.Any] = {}

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ResourceTypes(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class PolicyStatementWithActions(
    PolicyStatementWithCondition,
    metaclass=jsii.JSIIMeta,
    jsii_type="iam-floyd.PolicyStatementWithActions",
):
    """Adds "action" functionality to the Policy Statement.

    stability
    :stability: experimental
    """

    def __init__(self, sid: typing.Optional[builtins.str] = None) -> None:
        """
        :param sid: -

        stability
        :stability: experimental
        """
        jsii.create(PolicyStatementWithActions, self, [sid])

    @jsii.member(jsii_name="allActions")
    def all_actions(self) -> "PolicyStatementWithActions":
        """Adds all actions of the statement provider to the statement, e.g. ``actions: 'ec2:*'``.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "allActions", [])

    @jsii.member(jsii_name="allListActions")
    def all_list_actions(self) -> "PolicyStatementWithActions":
        """Adds all actions with `access level <https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_understand-policy-summary-access-level-summaries.html#access_policies_access-level>`_ LIST to the statement.

        Permission to list resources within the service to determine whether an object exists.

        Actions with this level of access can list objects but cannot see the contents of a resource.

        For example, the Amazon S3 action ``ListBucket`` has the List access level.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "allListActions", [])

    @jsii.member(jsii_name="allMatchingActions")
    def all_matching_actions(
        self,
        *expressions: builtins.str,
    ) -> "PolicyStatementWithActions":
        """Adds all actions that match one of the given regular expressions.

        :param expressions: One or more regular expressions. The regular expressions need to be in `Perl/JavaScript literal style <https://developer.mozilla.org/en-US/docs/Web/JavaScript/Guide/Regular_Expressions>`_ and need to be passed as strings, For example:: allMatchingActions('/vpn/i')

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "allMatchingActions", [*expressions])

    @jsii.member(jsii_name="allPermissionManagementActions")
    def all_permission_management_actions(self) -> "PolicyStatementWithActions":
        """Adds all actions with `access level <https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_understand-policy-summary-access-level-summaries.html#access_policies_access-level>`_ PERMISSION MANAGEMENT to the statement.

        Permission to grant or modify resource permissions in the service.

        For example, most IAM and AWS Organizations actions, as well as actions like the Amazon S3 actions ``PutBucketPolicy`` and ``DeleteBucketPolicy`` have the Permissions management access level.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "allPermissionManagementActions", [])

    @jsii.member(jsii_name="allReadActions")
    def all_read_actions(self) -> "PolicyStatementWithActions":
        """Adds all actions with `access level <https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_understand-policy-summary-access-level-summaries.html#access_policies_access-level>`_ READ to the statement.

        Permission to read but not edit the contents and attributes of resources in the service.

        For example, the Amazon S3 actions ``GetObject`` and ``GetBucketLocation`` have the Read access level.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "allReadActions", [])

    @jsii.member(jsii_name="allTaggingActions")
    def all_tagging_actions(self) -> "PolicyStatementWithActions":
        """Adds all actions with `access level <https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_understand-policy-summary-access-level-summaries.html#access_policies_access-level>`_ TAGGING to the statement.

        Permission to perform actions that only change the state of resource tags.

        For example, the IAM actions ``TagRole`` and ``UntagRole`` have the Tagging access level because they allow only tagging or untagging a role. However, the ``CreateRole`` action allows tagging a role resource when you create that role. Because the action does not only add a tag, it has the Write access level.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "allTaggingActions", [])

    @jsii.member(jsii_name="allWriteActions")
    def all_write_actions(self) -> "PolicyStatementWithActions":
        """Adds all actions with `access level <https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_understand-policy-summary-access-level-summaries.html#access_policies_access-level>`_ WRITE to the statement.

        Permission to create, delete, or modify resources in the service.

        For example, the Amazon S3 actions ``CreateBucket``, ``DeleteBucket`` and ``PutObject`` have the Write access level.

        Write actions might also allow modifying a resource tag. However, an action that allows only changes to tags has the Tagging access level.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "allWriteActions", [])

    @jsii.member(jsii_name="hasActions")
    def has_actions(self) -> builtins.bool:
        """Checks weather actions have been applied to the policy.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "hasActions", [])

    @jsii.member(jsii_name="notActions")
    def not_actions(self) -> "PolicyStatementWithActions":
        """Switches the statement to use ```NotAction`` <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_notaction.html>`_.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "notActions", [])

    @jsii.member(jsii_name="to")
    def to(self, action: builtins.str) -> "PolicyStatementWithActions":
        """Adds actions by name.

        Depending on the "mode", actions will be either added to the list of ```Actions`` <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_action.html>`_ or ```NotActions`` <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_notaction.html>`_.

        The mode can be switched by calling ``notActions()``.

        :param action: Actions that will be added to the statement.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "to", [action])

    @jsii.member(jsii_name="toJSON")
    def to_json(self) -> typing.Any:
        """Injects actions into the statement.

        Only relevant for the main package. In CDK mode this only calls super.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toJSON", [])

    @jsii.member(jsii_name="toStatementJson")
    def to_statement_json(self) -> typing.Any:
        """
        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toStatementJson", [])

    @builtins.property # type: ignore
    @jsii.member(jsii_name="accessLevelList")
    def _access_level_list(self) -> "AccessLevelList":
        """
        stability
        :stability: experimental
        """
        return jsii.get(self, "accessLevelList")

    @_access_level_list.setter # type: ignore
    def _access_level_list(self, value: "AccessLevelList") -> None:
        jsii.set(self, "accessLevelList", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="actions")
    def _actions(self) -> typing.List[builtins.str]:
        """
        stability
        :stability: experimental
        """
        return jsii.get(self, "actions")

    @_actions.setter # type: ignore
    def _actions(self, value: typing.List[builtins.str]) -> None:
        jsii.set(self, "actions", value)


class PolicyStatementWithResources(
    PolicyStatementWithActions,
    metaclass=jsii.JSIIMeta,
    jsii_type="iam-floyd.PolicyStatementWithResources",
):
    """Adds "resource" functionality to the Policy Statement.

    stability
    :stability: experimental
    """

    def __init__(self, sid: typing.Optional[builtins.str] = None) -> None:
        """
        :param sid: -

        stability
        :stability: experimental
        """
        jsii.create(PolicyStatementWithResources, self, [sid])

    @jsii.member(jsii_name="hasPrincipals")
    def has_principals(self) -> builtins.bool:
        """Dummy method. Will be overridden by 6-principal.ts.

        We just need it here so we can reference it in method ``ensureResource``

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "hasPrincipals", [])

    @jsii.member(jsii_name="hasResources")
    def has_resources(self) -> builtins.bool:
        """Checks weather any resource was applied to the policy.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "hasResources", [])

    @jsii.member(jsii_name="notResources")
    def not_resources(self) -> "PolicyStatementWithResources":
        """Switches the statement to use ```NotResource`` <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_notresource.html>`_.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "notResources", [])

    @jsii.member(jsii_name="on")
    def on(self, *arns: builtins.str) -> "PolicyStatementWithResources":
        """Limit statement to specified resources.

        To allow all resources, pass ``*``

        :param arns: -

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "on", [*arns])

    @jsii.member(jsii_name="onAllResources")
    def on_all_resources(self) -> "PolicyStatementWithResources":
        """Add all resources (``*``) to the statement.

        This is the default behavior, unless the statement has principals.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "onAllResources", [])

    @jsii.member(jsii_name="toJSON")
    def to_json(self) -> typing.Any:
        """Injects resources into the statement.

        Only relevant for the main package. In CDK mode this only calls super.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toJSON", [])

    @jsii.member(jsii_name="toStatementJson")
    def to_statement_json(self) -> typing.Any:
        """
        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toStatementJson", [])

    @builtins.property # type: ignore
    @jsii.member(jsii_name="resources")
    def _resources(self) -> typing.List[builtins.str]:
        """
        stability
        :stability: experimental
        """
        return jsii.get(self, "resources")

    @_resources.setter # type: ignore
    def _resources(self, value: typing.List[builtins.str]) -> None:
        jsii.set(self, "resources", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="skipAutoResource")
    def _skip_auto_resource(self) -> builtins.bool:
        """
        stability
        :stability: experimental
        """
        return jsii.get(self, "skipAutoResource")

    @_skip_auto_resource.setter # type: ignore
    def _skip_auto_resource(self, value: builtins.bool) -> None:
        jsii.set(self, "skipAutoResource", value)


class PolicyStatementWithEffect(
    PolicyStatementWithResources,
    metaclass=jsii.JSIIMeta,
    jsii_type="iam-floyd.PolicyStatementWithEffect",
):
    """Adds "effect" functionality to the Policy Statement.

    stability
    :stability: experimental
    """

    def __init__(self, sid: typing.Optional[builtins.str] = None) -> None:
        """
        :param sid: -

        stability
        :stability: experimental
        """
        jsii.create(PolicyStatementWithEffect, self, [sid])

    @jsii.member(jsii_name="allow")
    def allow(
        self,
        explicit: typing.Optional[builtins.bool] = None,
    ) -> "PolicyStatementWithEffect":
        """Allow the actions in this statement.

        The default ``Effect`` is ``Allow``. Therefore by default the ``Effect`` key
        will not be present in the statement. To enforce the ``Effect`` key, pass
        ``true`` as argument.

        :param explicit: Enforce the ``Effect`` key to be present in the statement.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "allow", [explicit])

    @jsii.member(jsii_name="deny")
    def deny(self) -> "PolicyStatementWithEffect":
        """Deny the actions in this statement.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "deny", [])

    @jsii.member(jsii_name="toJSON")
    def to_json(self) -> typing.Any:
        """Injects effect into the statement.

        Only relevant for the main package. In CDK mode this only calls super.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toJSON", [])

    @builtins.property # type: ignore
    @jsii.member(jsii_name="effect")
    def effect(self) -> "Effect":
        """
        stability
        :stability: experimental
        """
        return jsii.get(self, "effect")

    @effect.setter # type: ignore
    def effect(self, value: "Effect") -> None:
        jsii.set(self, "effect", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="explicitAllow")
    def _explicit_allow(self) -> builtins.bool:
        """When ``true``, an "Effect: Allow" will be put into the policy statement.

        By default it will be omitted, since ``Allow`` is the default anyway.

        stability
        :stability: experimental
        """
        return jsii.get(self, "explicitAllow")

    @_explicit_allow.setter # type: ignore
    def _explicit_allow(self, value: builtins.bool) -> None:
        jsii.set(self, "explicitAllow", value)


class PolicyStatementWithPrincipal(
    PolicyStatementWithEffect,
    metaclass=jsii.JSIIMeta,
    jsii_type="iam-floyd.PolicyStatementWithPrincipal",
):
    """Adds "principal" functionality to the Policy Statement.

    stability
    :stability: experimental
    """

    def __init__(self, sid: typing.Optional[builtins.str] = None) -> None:
        """
        :param sid: -

        stability
        :stability: experimental
        """
        jsii.create(PolicyStatementWithPrincipal, self, [sid])

    @jsii.member(jsii_name="addPrincipal")
    def _add_principal(
        self,
        prefix: builtins.str,
        principal: builtins.str,
    ) -> "PolicyStatementWithPrincipal":
        """Adds a principal to the statement.

        :param prefix: One of **AWS**, **Federated**, **CanonicalUser** or **Service**.
        :param principal: The principal string.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "addPrincipal", [prefix, principal])

    @jsii.member(jsii_name="cdkApplyPrincipals")
    def _cdk_apply_principals(self) -> None:
        """
        stability
        :stability: experimental
        """
        return jsii.invoke(self, "cdkApplyPrincipals", [])

    @jsii.member(jsii_name="for")
    def for_(
        self,
        arn: builtins.str,
        prefix: typing.Optional[builtins.str] = None,
    ) -> "PolicyStatementWithPrincipal":
        """Adds any principal to the statement.

        :param arn: The ARN of the principal.
        :param prefix: One of **AWS**, **Federated**, **CanonicalUser** or **Service** - Default: **AWS**.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "for", [arn, prefix])

    @jsii.member(jsii_name="forAccount")
    def for_account(self, account: builtins.str) -> "PolicyStatementWithPrincipal":
        """Adds an account principal to the statement.

        :param account: ID of the AWS account.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "forAccount", [account])

    @jsii.member(jsii_name="forAssumedRoleSession")
    def for_assumed_role_session(
        self,
        account: builtins.str,
        role_name: builtins.str,
        session_name: builtins.str,
    ) -> "PolicyStatementWithPrincipal":
        """Adds a specific assumed role session principal to the statement.

        :param account: ID of the AWS account.
        :param role_name: Name of the IAM role.
        :param session_name: Name of the session. You cannot use a wildcard (``*``) to mean *all sessions*. Principals must always name a specific session

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "forAssumedRoleSession", [account, role_name, session_name])

    @jsii.member(jsii_name="forCanonicalUser")
    def for_canonical_user(
        self,
        user_id: builtins.str,
    ) -> "PolicyStatementWithPrincipal":
        """Adds a canonical user principal to the statement.

        :param user_id: The user ID. You can `find the canonical user ID <https://docs.aws.amazon.com/general/latest/gr/acct-identifiers.html#FindingCanonicalId>`_ for your AWS account in the AWS Management Console. The canonical user ID for an AWS account is specific to the account. You can retrieve the canonical user ID for your AWS account as either the root user or an IAM user.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "forCanonicalUser", [user_id])

    @jsii.member(jsii_name="forFederated")
    def for_federated(self, provider: builtins.str) -> "PolicyStatementWithPrincipal":
        """Adds a `federated <https://aws.amazon.com/identity/federation/>`_ (web identity) principal to the statement.

        :param provider: ID of the AWS account.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "forFederated", [provider])

    @jsii.member(jsii_name="forFederatedAmazon")
    def for_federated_amazon(self) -> "PolicyStatementWithPrincipal":
        """Adds a federated `Amazon <https://login.amazon.com/>`_ principal to the statement.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "forFederatedAmazon", [])

    @jsii.member(jsii_name="forFederatedCognito")
    def for_federated_cognito(self) -> "PolicyStatementWithPrincipal":
        """Adds a federated `AWS Cognito <https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_providers_oidc_cognito.html>`_ principal to the statement.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "forFederatedCognito", [])

    @jsii.member(jsii_name="forFederatedFacebook")
    def for_federated_facebook(self) -> "PolicyStatementWithPrincipal":
        """Adds a federated `Facebook <https://developers.facebook.com/docs/facebook-login>`_ principal to the statement.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "forFederatedFacebook", [])

    @jsii.member(jsii_name="forFederatedGoogle")
    def for_federated_google(self) -> "PolicyStatementWithPrincipal":
        """Adds a federated `Google <https://developers.google.com/identity/protocols/oauth2/openid-connect>`_ principal to the statement.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "forFederatedGoogle", [])

    @jsii.member(jsii_name="forPublic")
    def for_public(self) -> "PolicyStatementWithPrincipal":
        """Grants public asses.

        **EVERYONE IN THE WORLD HAS ACCESS**

        We strongly recommend that you do not use a wildcard in the Principal element in a role's trust policy unless you otherwise restrict access through a Condition element in the policy. Otherwise, any IAM user in any account in your partition can access the role.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "forPublic", [])

    @jsii.member(jsii_name="forRole")
    def for_role(
        self,
        account: builtins.str,
        role: builtins.str,
    ) -> "PolicyStatementWithPrincipal":
        """Adds an IAM role principal to the statement.

        :param account: ID of the AWS account.
        :param role: Name of the IAM role.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "forRole", [account, role])

    @jsii.member(jsii_name="forSaml")
    def for_saml(
        self,
        account: builtins.str,
        provider_name: builtins.str,
    ) -> "PolicyStatementWithPrincipal":
        """Adds federated SAML principal to the statement.

        :param account: ID of the AWS account.
        :param provider_name: Name of the SAML provider.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "forSaml", [account, provider_name])

    @jsii.member(jsii_name="forService")
    def for_service(self, service: builtins.str) -> "PolicyStatementWithPrincipal":
        """Adds a service principal to the statement.

        :param service: Long version of the service name. Usually in the format: ``long_service-name.amazonaws.com``. The service principal is defined by the service. To learn the service principal for a service, see the documentation for that service. For some services, see `AWS Services That Work with IAM <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-services-that-work-with-iam.html>`_ and look for the services that have **Yes** in the **Service-Linked Role** column. Choose a **Yes** with a link to view the service-linked role documentation for that service. View the **Service-Linked Role Permissions** section for that service to view the service principal.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "forService", [service])

    @jsii.member(jsii_name="forUser")
    def for_user(
        self,
        account: builtins.str,
        user: builtins.str,
    ) -> "PolicyStatementWithPrincipal":
        """Adds an IAM user principal to the statement.

        :param account: ID of the AWS account.
        :param user: Name of the IAM user.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "forUser", [account, user])

    @jsii.member(jsii_name="hasPrincipals")
    def has_principals(self) -> builtins.bool:
        """Checks weather a principal was applied to the policy.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "hasPrincipals", [])

    @jsii.member(jsii_name="notPrincipals")
    def not_principals(self) -> "PolicyStatementWithPrincipal":
        """Switches the statement to use ```notPrincipal`` <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_notprincipal.html>`_.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "notPrincipals", [])

    @jsii.member(jsii_name="toJSON")
    def to_json(self) -> typing.Any:
        """Injects principals into the statement.

        Only relevant for the main package. In CDK mode this only calls super.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toJSON", [])

    @jsii.member(jsii_name="toStatementJson")
    def to_statement_json(self) -> typing.Any:
        """
        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toStatementJson", [])

    @builtins.property # type: ignore
    @jsii.member(jsii_name="principals")
    def _principals(self) -> "Principals":
        """
        stability
        :stability: experimental
        """
        return jsii.get(self, "principals")

    @_principals.setter # type: ignore
    def _principals(self, value: "Principals") -> None:
        jsii.set(self, "principals", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="useNotPrincipals")
    def _use_not_principals(self) -> builtins.bool:
        """
        stability
        :stability: experimental
        """
        return jsii.get(self, "useNotPrincipals")

    @_use_not_principals.setter # type: ignore
    def _use_not_principals(self, value: builtins.bool) -> None:
        jsii.set(self, "useNotPrincipals", value)


class PolicyStatement(
    PolicyStatementWithPrincipal,
    metaclass=jsii.JSIIMeta,
    jsii_type="iam-floyd.PolicyStatement",
):
    """Represents a statement in an IAM policy document.

    stability
    :stability: experimental
    """

    def __init__(self, sid: typing.Optional[builtins.str] = None) -> None:
        """
        :param sid: -

        stability
        :stability: experimental
        """
        jsii.create(PolicyStatement, self, [sid])

    @jsii.member(jsii_name="toJSON")
    def to_json(self) -> typing.Any:
        """JSON-ify the policy statement.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toJSON", [])

    @builtins.property # type: ignore
    @jsii.member(jsii_name="cdkApplied")
    def _cdk_applied(self) -> builtins.bool:
        """
        stability
        :stability: experimental
        """
        return jsii.get(self, "cdkApplied")

    @_cdk_applied.setter # type: ignore
    def _cdk_applied(self, value: builtins.bool) -> None:
        jsii.set(self, "cdkApplied", value)


class Polly(PolicyStatement, metaclass=jsii.JSIIMeta, jsii_type="iam-floyd.Polly"):
    """Statement provider for service `polly <https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonpolly.html>`_.

    stability
    :stability: experimental
    """

    def __init__(self, sid: typing.Optional[builtins.str] = None) -> None:
        """Statement provider for service `polly <https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonpolly.html>`_.

        :param sid: `SID <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html>`_ of the statement.

        stability
        :stability: experimental
        """
        jsii.create(Polly, self, [sid])

    @jsii.member(jsii_name="onLexicon")
    def on_lexicon(
        self,
        lexicon_name: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Polly":
        """Adds a resource of type lexicon to the statement.

        https://docs.aws.amazon.com/polly/latest/dg/managing-lexicons.html

        :param lexicon_name: - Identifier for the lexiconName.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "onLexicon", [lexicon_name, account, region, partition])

    @jsii.member(jsii_name="toDeleteLexicon")
    def to_delete_lexicon(self) -> "Polly":
        """Deletes the specified pronunciation lexicon stored in an AWS Region.

        Access Level: Write

        https://docs.aws.amazon.com/polly/latest/dg/API_DeleteLexicon.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDeleteLexicon", [])

    @jsii.member(jsii_name="toDescribeVoices")
    def to_describe_voices(self) -> "Polly":
        """Returns the list of voices that are available for use when requesting speech synthesis.

        Access Level: List

        https://docs.aws.amazon.com/polly/latest/dg/API_DescribeVoices.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDescribeVoices", [])

    @jsii.member(jsii_name="toGetLexicon")
    def to_get_lexicon(self) -> "Polly":
        """Returns the content of the specified pronunciation lexicon stored in an AWS Region.

        Access Level: Read

        https://docs.aws.amazon.com/polly/latest/dg/API_GetLexicon.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toGetLexicon", [])

    @jsii.member(jsii_name="toGetSpeechSynthesisTask")
    def to_get_speech_synthesis_task(self) -> "Polly":
        """Enables the user to get information about specific speech synthesis task.

        Access Level: Read

        https://docs.aws.amazon.com/polly/latest/dg/API_GetSpeechSynthesisTask.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toGetSpeechSynthesisTask", [])

    @jsii.member(jsii_name="toListLexicons")
    def to_list_lexicons(self) -> "Polly":
        """Returns a list of pronunciation lexicons stored in an AWS Region.

        Access Level: List

        https://docs.aws.amazon.com/polly/latest/dg/API_ListLexicons.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toListLexicons", [])

    @jsii.member(jsii_name="toListSpeechSynthesisTasks")
    def to_list_speech_synthesis_tasks(self) -> "Polly":
        """Enables the user to list requested speech synthesis tasks.

        Access Level: List

        https://docs.aws.amazon.com/polly/latest/dg/API_ListSpeechSynthesisTasks.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toListSpeechSynthesisTasks", [])

    @jsii.member(jsii_name="toPutLexicon")
    def to_put_lexicon(self) -> "Polly":
        """Stores a pronunciation lexicon in an AWS Region.

        Access Level: Write

        https://docs.aws.amazon.com/polly/latest/dg/API_PutLexicon.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toPutLexicon", [])

    @jsii.member(jsii_name="toStartSpeechSynthesisTask")
    def to_start_speech_synthesis_task(self) -> "Polly":
        """Enables the user to synthesize long inputs to provided S3 location.

        Access Level: Write

        Dependent actions:

        - s3:PutObject

        https://docs.aws.amazon.com/polly/latest/dg/API_StartSpeechSynthesisTask.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toStartSpeechSynthesisTask", [])

    @jsii.member(jsii_name="toSynthesizeSpeech")
    def to_synthesize_speech(self) -> "Polly":
        """Synthesizes UTF-8 input, plain text or SSML, to a stream of bytes.

        Access Level: Read

        https://docs.aws.amazon.com/polly/latest/dg/API_SynthesizeSpeech.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toSynthesizeSpeech", [])

    @builtins.property # type: ignore
    @jsii.member(jsii_name="accessLevelList")
    def _access_level_list(self) -> "AccessLevelList":
        """
        stability
        :stability: experimental
        """
        return jsii.get(self, "accessLevelList")

    @_access_level_list.setter # type: ignore
    def _access_level_list(self, value: "AccessLevelList") -> None:
        jsii.set(self, "accessLevelList", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="servicePrefix")
    def service_prefix(self) -> builtins.str:
        """Holds the prefix of the service actions, e.g. ``ec2``.

        stability
        :stability: experimental
        """
        return jsii.get(self, "servicePrefix")

    @service_prefix.setter # type: ignore
    def service_prefix(self, value: builtins.str) -> None:
        jsii.set(self, "servicePrefix", value)


class Pricing(PolicyStatement, metaclass=jsii.JSIIMeta, jsii_type="iam-floyd.Pricing"):
    """Statement provider for service `pricing <https://docs.aws.amazon.com/service-authorization/latest/reference/list_awspricelist.html>`_.

    stability
    :stability: experimental
    """

    def __init__(self, sid: typing.Optional[builtins.str] = None) -> None:
        """Statement provider for service `pricing <https://docs.aws.amazon.com/service-authorization/latest/reference/list_awspricelist.html>`_.

        :param sid: `SID <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html>`_ of the statement.

        stability
        :stability: experimental
        """
        jsii.create(Pricing, self, [sid])

    @jsii.member(jsii_name="toDescribeServices")
    def to_describe_services(self) -> "Pricing":
        """Returns the service details for all (paginated) services (if serviceCode is not set) or service detail for a particular service (if given serviceCode).

        Access Level: Read

        https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_DescribeServices.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDescribeServices", [])

    @jsii.member(jsii_name="toGetAttributeValues")
    def to_get_attribute_values(self) -> "Pricing":
        """Returns all (paginated) possible values for a given attribute.

        Access Level: Read

        https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_GetAttributeValues.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toGetAttributeValues", [])

    @jsii.member(jsii_name="toGetProducts")
    def to_get_products(self) -> "Pricing":
        """Returns all matching products with given search criteria.

        Access Level: Read

        https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_GetProducts.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toGetProducts", [])

    @builtins.property # type: ignore
    @jsii.member(jsii_name="accessLevelList")
    def _access_level_list(self) -> "AccessLevelList":
        """
        stability
        :stability: experimental
        """
        return jsii.get(self, "accessLevelList")

    @_access_level_list.setter # type: ignore
    def _access_level_list(self, value: "AccessLevelList") -> None:
        jsii.set(self, "accessLevelList", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="servicePrefix")
    def service_prefix(self) -> builtins.str:
        """Holds the prefix of the service actions, e.g. ``ec2``.

        stability
        :stability: experimental
        """
        return jsii.get(self, "servicePrefix")

    @service_prefix.setter # type: ignore
    def service_prefix(self, value: builtins.str) -> None:
        jsii.set(self, "servicePrefix", value)


class PurchaseOrders(
    PolicyStatement,
    metaclass=jsii.JSIIMeta,
    jsii_type="iam-floyd.PurchaseOrders",
):
    """Statement provider for service `purchase-orders <https://docs.aws.amazon.com/service-authorization/latest/reference/list_awspurchaseordersconsole.html>`_.

    stability
    :stability: experimental
    """

    def __init__(self, sid: typing.Optional[builtins.str] = None) -> None:
        """Statement provider for service `purchase-orders <https://docs.aws.amazon.com/service-authorization/latest/reference/list_awspurchaseordersconsole.html>`_.

        :param sid: `SID <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html>`_ of the statement.

        stability
        :stability: experimental
        """
        jsii.create(PurchaseOrders, self, [sid])

    @jsii.member(jsii_name="toModifyPurchaseOrders")
    def to_modify_purchase_orders(self) -> "PurchaseOrders":
        """Modify purchase orders and details.

        Access Level: Write

        https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/billing-permissions-ref.html#user-permissions

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toModifyPurchaseOrders", [])

    @jsii.member(jsii_name="toViewPurchaseOrders")
    def to_view_purchase_orders(self) -> "PurchaseOrders":
        """View purchase orders and details.

        Access Level: Read

        https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/billing-permissions-ref.html#user-permissions

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toViewPurchaseOrders", [])

    @builtins.property # type: ignore
    @jsii.member(jsii_name="accessLevelList")
    def _access_level_list(self) -> "AccessLevelList":
        """
        stability
        :stability: experimental
        """
        return jsii.get(self, "accessLevelList")

    @_access_level_list.setter # type: ignore
    def _access_level_list(self, value: "AccessLevelList") -> None:
        jsii.set(self, "accessLevelList", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="servicePrefix")
    def service_prefix(self) -> builtins.str:
        """Holds the prefix of the service actions, e.g. ``ec2``.

        stability
        :stability: experimental
        """
        return jsii.get(self, "servicePrefix")

    @service_prefix.setter # type: ignore
    def service_prefix(self, value: builtins.str) -> None:
        jsii.set(self, "servicePrefix", value)


class Qldb(PolicyStatement, metaclass=jsii.JSIIMeta, jsii_type="iam-floyd.Qldb"):
    """Statement provider for service `qldb <https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonqldb.html>`_.

    stability
    :stability: experimental
    """

    def __init__(self, sid: typing.Optional[builtins.str] = None) -> None:
        """Statement provider for service `qldb <https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonqldb.html>`_.

        :param sid: `SID <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html>`_ of the statement.

        stability
        :stability: experimental
        """
        jsii.create(Qldb, self, [sid])

    @jsii.member(jsii_name="onLedger")
    def on_ledger(
        self,
        ledger_name: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Qldb":
        """Adds a resource of type ledger to the statement.

        https://docs.aws.amazon.com/qldb/latest/developerguide/what-is.html

        :param ledger_name: - Identifier for the ledgerName.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``. Possible conditions: - .ifAwsResourceTag()

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "onLedger", [ledger_name, account, region, partition])

    @jsii.member(jsii_name="onStream")
    def on_stream(
        self,
        ledger_name: builtins.str,
        stream_id: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Qldb":
        """Adds a resource of type stream to the statement.

        https://docs.aws.amazon.com/qldb/latest/developerguide/what-is.html

        :param ledger_name: - Identifier for the ledgerName.
        :param stream_id: - Identifier for the streamId.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``. Possible conditions: - .ifAwsResourceTag()

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "onStream", [ledger_name, stream_id, account, region, partition])

    @jsii.member(jsii_name="toCancelJournalKinesisStream")
    def to_cancel_journal_kinesis_stream(self) -> "Qldb":
        """Grants permission to cancel a journal kinesis stream.

        Access Level: Write

        https://docs.aws.amazon.com/qldb/latest/developerguide/API_CancelJournalKinesisStream.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toCancelJournalKinesisStream", [])

    @jsii.member(jsii_name="toCreateLedger")
    def to_create_ledger(self) -> "Qldb":
        """Grants permission to create a ledger.

        Access Level: Write

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsTagKeys()

        https://docs.aws.amazon.com/qldb/latest/developerguide/API_CreateLedger.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toCreateLedger", [])

    @jsii.member(jsii_name="toDeleteLedger")
    def to_delete_ledger(self) -> "Qldb":
        """Grants permission to delete a ledger.

        Access Level: Write

        https://docs.aws.amazon.com/qldb/latest/developerguide/API_DeleteLedger.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDeleteLedger", [])

    @jsii.member(jsii_name="toDescribeJournalKinesisStream")
    def to_describe_journal_kinesis_stream(self) -> "Qldb":
        """Grants permission to describe information about a journal kinesis stream.

        Access Level: Read

        https://docs.aws.amazon.com/qldb/latest/developerguide/API_DescribeJournalKinesisStream.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDescribeJournalKinesisStream", [])

    @jsii.member(jsii_name="toDescribeJournalS3Export")
    def to_describe_journal_s3_export(self) -> "Qldb":
        """Grants permission to describe information about a journal export job.

        Access Level: Read

        https://docs.aws.amazon.com/qldb/latest/developerguide/API_DescribeJournalS3Export.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDescribeJournalS3Export", [])

    @jsii.member(jsii_name="toDescribeLedger")
    def to_describe_ledger(self) -> "Qldb":
        """Grants permission to describe a ledger.

        Access Level: Read

        https://docs.aws.amazon.com/qldb/latest/developerguide/API_DescribeLedger.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDescribeLedger", [])

    @jsii.member(jsii_name="toExecuteStatement")
    def to_execute_statement(self) -> "Qldb":
        """Grants permission to send commands to a ledger via the console.

        Access Level: Write

        https://docs.aws.amazon.com/qldb/latest/developerguide/console_QLDB.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toExecuteStatement", [])

    @jsii.member(jsii_name="toExportJournalToS3")
    def to_export_journal_to_s3(self) -> "Qldb":
        """Grants permission to export journal contents to an Amazon S3 bucket.

        Access Level: Write

        https://docs.aws.amazon.com/qldb/latest/developerguide/API_ExportJournalToS3.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toExportJournalToS3", [])

    @jsii.member(jsii_name="toGetBlock")
    def to_get_block(self) -> "Qldb":
        """Grants permission to retrieve a block from a ledger for a given BlockAddress.

        Access Level: Read

        https://docs.aws.amazon.com/qldb/latest/developerguide/API_GetBlock.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toGetBlock", [])

    @jsii.member(jsii_name="toGetDigest")
    def to_get_digest(self) -> "Qldb":
        """Grants permission to retrieve a digest from a ledger for a given BlockAddress.

        Access Level: Read

        https://docs.aws.amazon.com/qldb/latest/developerguide/API_GetDigest.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toGetDigest", [])

    @jsii.member(jsii_name="toGetRevision")
    def to_get_revision(self) -> "Qldb":
        """Grants permission to retrieve a revision for a given document ID and a given BlockAddress.

        Access Level: Read

        https://docs.aws.amazon.com/qldb/latest/developerguide/API_GetRevision.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toGetRevision", [])

    @jsii.member(jsii_name="toInsertSampleData")
    def to_insert_sample_data(self) -> "Qldb":
        """Grants permission to insert sample application data via the console.

        Access Level: Write

        https://docs.aws.amazon.com/qldb/latest/developerguide/console_QLDB.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toInsertSampleData", [])

    @jsii.member(jsii_name="toListJournalKinesisStreamsForLedger")
    def to_list_journal_kinesis_streams_for_ledger(self) -> "Qldb":
        """Grants permission to list journal kinesis streams for a specified ledger.

        Access Level: List

        https://docs.aws.amazon.com/qldb/latest/developerguide/API_ListJournalKinesisStreamsForLedger.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toListJournalKinesisStreamsForLedger", [])

    @jsii.member(jsii_name="toListJournalS3Exports")
    def to_list_journal_s3_exports(self) -> "Qldb":
        """Grants permission to list journal export jobs for all ledgers.

        Access Level: List

        https://docs.aws.amazon.com/qldb/latest/developerguide/API_ListJournalS3Exports.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toListJournalS3Exports", [])

    @jsii.member(jsii_name="toListJournalS3ExportsForLedger")
    def to_list_journal_s3_exports_for_ledger(self) -> "Qldb":
        """Grants permission to list journal export jobs for a specified ledger.

        Access Level: List

        https://docs.aws.amazon.com/qldb/latest/developerguide/API_ListJournalS3ExportsForLedger.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toListJournalS3ExportsForLedger", [])

    @jsii.member(jsii_name="toListLedgers")
    def to_list_ledgers(self) -> "Qldb":
        """Grants permission to list existing ledgers.

        Access Level: List

        https://docs.aws.amazon.com/qldb/latest/developerguide/API_ListLedgers.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toListLedgers", [])

    @jsii.member(jsii_name="toListTagsForResource")
    def to_list_tags_for_resource(self) -> "Qldb":
        """Grants permission to list tags for a resource.

        Access Level: Read

        https://docs.aws.amazon.com/qldb/latest/developerguide/API_ListTagsForResource.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toListTagsForResource", [])

    @jsii.member(jsii_name="toSendCommand")
    def to_send_command(self) -> "Qldb":
        """Grants permission to send commands to a ledger.

        Access Level: Write

        https://docs.aws.amazon.com/qldb/latest/developerguide/Using.API.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toSendCommand", [])

    @jsii.member(jsii_name="toShowCatalog")
    def to_show_catalog(self) -> "Qldb":
        """Grants permission to view a ledger's catalog via the console.

        Access Level: Write

        https://docs.aws.amazon.com/qldb/latest/developerguide/console_QLDB.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toShowCatalog", [])

    @jsii.member(jsii_name="toStreamJournalToKinesis")
    def to_stream_journal_to_kinesis(self) -> "Qldb":
        """Grants permission to stream journal contents to a Kinesis Data Stream.

        Access Level: Write

        https://docs.aws.amazon.com/qldb/latest/developerguide/API_StreamJournalToKinesis.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toStreamJournalToKinesis", [])

    @jsii.member(jsii_name="toTagResource")
    def to_tag_resource(self) -> "Qldb":
        """Grants permission to add one or more tags to a resource.

        Access Level: Tagging

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsTagKeys()

        https://docs.aws.amazon.com/qldb/latest/developerguide/API_TagResource.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toTagResource", [])

    @jsii.member(jsii_name="toUntagResource")
    def to_untag_resource(self) -> "Qldb":
        """Grants permission to remove one or more tags to a resource.

        Access Level: Tagging

        Possible conditions:

        - .ifAwsTagKeys()

        https://docs.aws.amazon.com/qldb/latest/developerguide/API_UntagResource.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toUntagResource", [])

    @jsii.member(jsii_name="toUpdateLedger")
    def to_update_ledger(self) -> "Qldb":
        """Grants permission to update properties on a ledger.

        Access Level: Write

        https://docs.aws.amazon.com/qldb/latest/developerguide/API_UpdateLedger.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toUpdateLedger", [])

    @builtins.property # type: ignore
    @jsii.member(jsii_name="accessLevelList")
    def _access_level_list(self) -> "AccessLevelList":
        """
        stability
        :stability: experimental
        """
        return jsii.get(self, "accessLevelList")

    @_access_level_list.setter # type: ignore
    def _access_level_list(self, value: "AccessLevelList") -> None:
        jsii.set(self, "accessLevelList", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="servicePrefix")
    def service_prefix(self) -> builtins.str:
        """Holds the prefix of the service actions, e.g. ``ec2``.

        stability
        :stability: experimental
        """
        return jsii.get(self, "servicePrefix")

    @service_prefix.setter # type: ignore
    def service_prefix(self, value: builtins.str) -> None:
        jsii.set(self, "servicePrefix", value)


class Quicksight(
    PolicyStatement,
    metaclass=jsii.JSIIMeta,
    jsii_type="iam-floyd.Quicksight",
):
    """Statement provider for service `quicksight <https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonquicksight.html>`_.

    stability
    :stability: experimental
    """

    def __init__(self, sid: typing.Optional[builtins.str] = None) -> None:
        """Statement provider for service `quicksight <https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonquicksight.html>`_.

        :param sid: `SID <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html>`_ of the statement.

        stability
        :stability: experimental
        """
        jsii.create(Quicksight, self, [sid])

    @jsii.member(jsii_name="ifIamArn")
    def if_iam_arn(
        self,
        value: typing.Union[builtins.str, typing.List[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, "Operator"]] = None,
    ) -> "Quicksight":
        """IAM user ARN or role ARN.

        https://docs.aws.amazon.com/quicksight/latest/user/iam-actions.html

        Applies to actions:

        - .toRegisterUser()

        :param value: The value(s) to check.
        :param operator: Works with `string operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String>`_. **Default:** ``StringLike``.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "ifIamArn", [value, operator])

    @jsii.member(jsii_name="ifSessionName")
    def if_session_name(
        self,
        value: typing.Union[builtins.str, typing.List[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, "Operator"]] = None,
    ) -> "Quicksight":
        """The session name.

        https://docs.aws.amazon.com/quicksight/latest/user/iam-actions.html

        Applies to actions:

        - .toRegisterUser()

        :param value: The value(s) to check.
        :param operator: Works with `string operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String>`_. **Default:** ``StringLike``.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "ifSessionName", [value, operator])

    @jsii.member(jsii_name="ifUserName")
    def if_user_name(
        self,
        value: typing.Union[builtins.str, typing.List[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, "Operator"]] = None,
    ) -> "Quicksight":
        """The user name.

        https://docs.aws.amazon.com/quicksight/latest/user/iam-actions.html

        Applies to actions:

        - .toCreateGroupMembership()
        - .toDeleteGroupMembership()

        :param value: The value(s) to check.
        :param operator: Works with `string operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String>`_. **Default:** ``StringLike``.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "ifUserName", [value, operator])

    @jsii.member(jsii_name="onAnalysis")
    def on_analysis(
        self,
        resource_id: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Quicksight":
        """Adds a resource of type analysis to the statement.

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_Analysis.html

        :param resource_id: - Identifier for the resourceId.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``. Possible conditions: - .ifAwsResourceTag()

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "onAnalysis", [resource_id, account, region, partition])

    @jsii.member(jsii_name="onAssignment")
    def on_assignment(
        self,
        resource_id: builtins.str,
        account: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Quicksight":
        """Adds a resource of type assignment to the statement.

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_IAMPolicyAssignment.html

        :param resource_id: - Identifier for the resourceId.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "onAssignment", [resource_id, account, partition])

    @jsii.member(jsii_name="onCustomization")
    def on_customization(
        self,
        resource_id: builtins.str,
        account: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Quicksight":
        """Adds a resource of type customization to the statement.

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_AccountCustomization.html

        :param resource_id: - Identifier for the resourceId.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``. Possible conditions: - .ifAwsResourceTag()

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "onCustomization", [resource_id, account, partition])

    @jsii.member(jsii_name="onDashboard")
    def on_dashboard(
        self,
        resource_id: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Quicksight":
        """Adds a resource of type dashboard to the statement.

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_Dashboard.html

        :param resource_id: - Identifier for the resourceId.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``. Possible conditions: - .ifAwsResourceTag()

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "onDashboard", [resource_id, account, region, partition])

    @jsii.member(jsii_name="onDataset")
    def on_dataset(
        self,
        resource_id: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Quicksight":
        """Adds a resource of type dataset to the statement.

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DataSet.html

        :param resource_id: - Identifier for the resourceId.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``. Possible conditions: - .ifAwsResourceTag()

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "onDataset", [resource_id, account, region, partition])

    @jsii.member(jsii_name="onDatasource")
    def on_datasource(
        self,
        resource_id: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Quicksight":
        """Adds a resource of type datasource to the statement.

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DataSource.html

        :param resource_id: - Identifier for the resourceId.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``. Possible conditions: - .ifAwsResourceTag()

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "onDatasource", [resource_id, account, region, partition])

    @jsii.member(jsii_name="onGroup")
    def on_group(
        self,
        resource_id: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Quicksight":
        """Adds a resource of type group to the statement.

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_Group.html

        :param resource_id: - Identifier for the resourceId.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "onGroup", [resource_id, account, region, partition])

    @jsii.member(jsii_name="onIngestion")
    def on_ingestion(
        self,
        dataset_id: builtins.str,
        resource_id: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Quicksight":
        """Adds a resource of type ingestion to the statement.

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_Ingestion.html

        :param dataset_id: - Identifier for the datasetId.
        :param resource_id: - Identifier for the resourceId.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``. Possible conditions: - .ifAwsResourceTag()

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "onIngestion", [dataset_id, resource_id, account, region, partition])

    @jsii.member(jsii_name="onNamespace")
    def on_namespace(
        self,
        resource_id: builtins.str,
        account: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Quicksight":
        """Adds a resource of type namespace to the statement.

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_Namespace.html

        :param resource_id: - Identifier for the resourceId.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "onNamespace", [resource_id, account, partition])

    @jsii.member(jsii_name="onTemplate")
    def on_template(
        self,
        resource_id: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Quicksight":
        """Adds a resource of type template to the statement.

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_Template.html

        :param resource_id: - Identifier for the resourceId.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``. Possible conditions: - .ifAwsResourceTag()

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "onTemplate", [resource_id, account, region, partition])

    @jsii.member(jsii_name="onTheme")
    def on_theme(
        self,
        resource_id: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Quicksight":
        """Adds a resource of type theme to the statement.

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_Theme.html

        :param resource_id: - Identifier for the resourceId.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``. Possible conditions: - .ifAwsResourceTag()

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "onTheme", [resource_id, account, region, partition])

    @jsii.member(jsii_name="onUser")
    def on_user(
        self,
        resource_id: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Quicksight":
        """Adds a resource of type user to the statement.

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_User.html

        :param resource_id: - Identifier for the resourceId.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "onUser", [resource_id, account, region, partition])

    @jsii.member(jsii_name="toCancelIngestion")
    def to_cancel_ingestion(self) -> "Quicksight":
        """Grants permission to cancel a SPICE ingestions on a dataset.

        Access Level: Write

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsTagKeys()

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_CancelIngestion.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toCancelIngestion", [])

    @jsii.member(jsii_name="toCreateAccountCustomization")
    def to_create_account_customization(self) -> "Quicksight":
        """Grants permission to create an account customization for QuickSight account or namespace.

        Access Level: Write

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsTagKeys()

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_CreateAccountCustomization.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toCreateAccountCustomization", [])

    @jsii.member(jsii_name="toCreateAdmin")
    def to_create_admin(self) -> "Quicksight":
        """CreateAdmin enables the user to provision Amazon QuickSight administrators, authors, and readers.

        Access Level: Write

        https://docs.aws.amazon.com/quicksight/latest/user/iam-actions.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toCreateAdmin", [])

    @jsii.member(jsii_name="toCreateAnalysis")
    def to_create_analysis(self) -> "Quicksight":
        """Creates an analysis from a template.

        Access Level: Write

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsTagKeys()

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_CreateAnalysis.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toCreateAnalysis", [])

    @jsii.member(jsii_name="toCreateCustomPermissions")
    def to_create_custom_permissions(self) -> "Quicksight":
        """Grants permission to create a custom permissions resource for restricting user access.

        Access Level: Write

        https://docs.aws.amazon.com/quicksight/latest/user/iam-actions.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toCreateCustomPermissions", [])

    @jsii.member(jsii_name="toCreateDashboard")
    def to_create_dashboard(self) -> "Quicksight":
        """Creates a dashboard from a template.

        Access Level: Write

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsTagKeys()

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_CreateDashboard.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toCreateDashboard", [])

    @jsii.member(jsii_name="toCreateDataSet")
    def to_create_data_set(self) -> "Quicksight":
        """Grants permission to create a dataset.

        Access Level: Write

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsTagKeys()

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_CreateDataSet.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toCreateDataSet", [])

    @jsii.member(jsii_name="toCreateDataSource")
    def to_create_data_source(self) -> "Quicksight":
        """Grants permission to create a data source.

        Access Level: Write

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsTagKeys()

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_CreateDataSource.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toCreateDataSource", [])

    @jsii.member(jsii_name="toCreateGroup")
    def to_create_group(self) -> "Quicksight":
        """Create a QuickSight group.

        Access Level: Write

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_CreateGroup.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toCreateGroup", [])

    @jsii.member(jsii_name="toCreateGroupMembership")
    def to_create_group_membership(self) -> "Quicksight":
        """Add a QuickSight user to a QuickSight group.

        Access Level: Write

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_CreateGroupMembership.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toCreateGroupMembership", [])

    @jsii.member(jsii_name="toCreateIAMPolicyAssignment")
    def to_create_iam_policy_assignment(self) -> "Quicksight":
        """Creates an assignment with one specified IAM Policy ARN that will be assigned to specified groups or users of QuickSight.

        Access Level: Write

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_CreateIAMPolicyAssignment.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toCreateIAMPolicyAssignment", [])

    @jsii.member(jsii_name="toCreateIngestion")
    def to_create_ingestion(self) -> "Quicksight":
        """Grants permission to start a SPICE ingestion on a dataset.

        Access Level: Write

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsTagKeys()

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_CreateIngestion.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toCreateIngestion", [])

    @jsii.member(jsii_name="toCreateNamespace")
    def to_create_namespace(self) -> "Quicksight":
        """Grants permission to create an QuickSight namespace.

        Access Level: Write

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_CreateNamespace.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toCreateNamespace", [])

    @jsii.member(jsii_name="toCreateReader")
    def to_create_reader(self) -> "Quicksight":
        """CreateReader enables the user to provision Amazon QuickSight readers.

        Access Level: Write

        https://docs.aws.amazon.com/quicksight/latest/user/iam-actions.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toCreateReader", [])

    @jsii.member(jsii_name="toCreateTemplate")
    def to_create_template(self) -> "Quicksight":
        """Creates a template from an existing QuickSight analysis or template.

        Access Level: Write

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsTagKeys()

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_CreateTemplate.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toCreateTemplate", [])

    @jsii.member(jsii_name="toCreateTemplateAlias")
    def to_create_template_alias(self) -> "Quicksight":
        """Creates a template alias for a template.

        Access Level: Write

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_CreateTemplateAlias.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toCreateTemplateAlias", [])

    @jsii.member(jsii_name="toCreateTheme")
    def to_create_theme(self) -> "Quicksight":
        """Creates a QuickSight theme.

        Access Level: Write

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsTagKeys()

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_CreateTheme.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toCreateTheme", [])

    @jsii.member(jsii_name="toCreateThemeAlias")
    def to_create_theme_alias(self) -> "Quicksight":
        """Creates a theme alias for a theme.

        Access Level: Write

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_CreateThemeAlias.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toCreateThemeAlias", [])

    @jsii.member(jsii_name="toCreateUser")
    def to_create_user(self) -> "Quicksight":
        """CreateUser enables the user to provision Amazon QuickSight authors and readers.

        Access Level: Write

        https://docs.aws.amazon.com/quicksight/latest/user/iam-actions.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toCreateUser", [])

    @jsii.member(jsii_name="toDeleteAccountCustomization")
    def to_delete_account_customization(self) -> "Quicksight":
        """Grants permission to delete an account customization for QuickSight account or namespace.

        Access Level: Write

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DeleteAccountCustomization.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDeleteAccountCustomization", [])

    @jsii.member(jsii_name="toDeleteAnalysis")
    def to_delete_analysis(self) -> "Quicksight":
        """Deletes an analysis.

        Access Level: Write

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DeleteAnalysis.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDeleteAnalysis", [])

    @jsii.member(jsii_name="toDeleteDashboard")
    def to_delete_dashboard(self) -> "Quicksight":
        """Deletes a dashboard.

        Access Level: Write

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DeleteDashboard.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDeleteDashboard", [])

    @jsii.member(jsii_name="toDeleteDataSet")
    def to_delete_data_set(self) -> "Quicksight":
        """Grants permission to delete a dataset.

        Access Level: Write

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsTagKeys()

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DeleteDataSet.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDeleteDataSet", [])

    @jsii.member(jsii_name="toDeleteDataSource")
    def to_delete_data_source(self) -> "Quicksight":
        """Grants permission to delete a data source.

        Access Level: Write

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsTagKeys()

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DeleteDataSource.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDeleteDataSource", [])

    @jsii.member(jsii_name="toDeleteGroup")
    def to_delete_group(self) -> "Quicksight":
        """Remove a user group from QuickSight.

        Access Level: Write

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DeleteGroup.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDeleteGroup", [])

    @jsii.member(jsii_name="toDeleteGroupMembership")
    def to_delete_group_membership(self) -> "Quicksight":
        """Remove a user from a group so that he/she is no longer a member of the group.

        Access Level: Write

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DeleteGroupMembership.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDeleteGroupMembership", [])

    @jsii.member(jsii_name="toDeleteIAMPolicyAssignment")
    def to_delete_iam_policy_assignment(self) -> "Quicksight":
        """Update an existing assignment.

        Access Level: Write

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DeleteIAMPolicyAssignment.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDeleteIAMPolicyAssignment", [])

    @jsii.member(jsii_name="toDeleteNamespace")
    def to_delete_namespace(self) -> "Quicksight":
        """Grants permission to delete a QuickSight namespace.

        Access Level: Write

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DeleteNamespace.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDeleteNamespace", [])

    @jsii.member(jsii_name="toDeleteTemplate")
    def to_delete_template(self) -> "Quicksight":
        """Deletes a template.

        Access Level: Write

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DeleteTemplate.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDeleteTemplate", [])

    @jsii.member(jsii_name="toDeleteTemplateAlias")
    def to_delete_template_alias(self) -> "Quicksight":
        """Deletes the item that the specified template alias points to.

        Access Level: Write

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DeleteTemplateAlias.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDeleteTemplateAlias", [])

    @jsii.member(jsii_name="toDeleteTheme")
    def to_delete_theme(self) -> "Quicksight":
        """Deletes a theme.

        Access Level: Write

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DeleteTheme.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDeleteTheme", [])

    @jsii.member(jsii_name="toDeleteThemeAlias")
    def to_delete_theme_alias(self) -> "Quicksight":
        """Deletes the item that the specified theme alias points to.

        Access Level: Write

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DeleteThemeAlias.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDeleteThemeAlias", [])

    @jsii.member(jsii_name="toDeleteUser")
    def to_delete_user(self) -> "Quicksight":
        """Delete the QuickSight user that is associated with the identity of the IAM user/role making the call.

        The IAM user is not deleted as a result of this call.

        Access Level: Write

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DeleteUser.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDeleteUser", [])

    @jsii.member(jsii_name="toDeleteUserByPrincipalId")
    def to_delete_user_by_principal_id(self) -> "Quicksight":
        """Deletes a user identified by its principal ID.

        Access Level: Write

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DeleteUserByPrincipalId.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDeleteUserByPrincipalId", [])

    @jsii.member(jsii_name="toDescribeAccountCustomization")
    def to_describe_account_customization(self) -> "Quicksight":
        """Grants permission to describe an account customization for QuickSight account or namespace.

        Access Level: Read

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DescribeAccountCustomization.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDescribeAccountCustomization", [])

    @jsii.member(jsii_name="toDescribeAccountSettings")
    def to_describe_account_settings(self) -> "Quicksight":
        """Grants permission to describe the administrative account settings for QuickSight account.

        Access Level: Read

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DescribeAccountSettings.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDescribeAccountSettings", [])

    @jsii.member(jsii_name="toDescribeAnalysis")
    def to_describe_analysis(self) -> "Quicksight":
        """Provides a summary for an analysis.

        Access Level: Read

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DescribeAnalysis.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDescribeAnalysis", [])

    @jsii.member(jsii_name="toDescribeAnalysisPermissions")
    def to_describe_analysis_permissions(self) -> "Quicksight":
        """Describes read and write permissions for an analysis.

        Access Level: Read

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DescribeAnalysisPermissions.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDescribeAnalysisPermissions", [])

    @jsii.member(jsii_name="toDescribeCustomPermissions")
    def to_describe_custom_permissions(self) -> "Quicksight":
        """Grants permission to describe a custom permissions resource in a QuickSight account.

        Access Level: Write

        https://docs.aws.amazon.com/quicksight/latest/user/iam-actions.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDescribeCustomPermissions", [])

    @jsii.member(jsii_name="toDescribeDashboard")
    def to_describe_dashboard(self) -> "Quicksight":
        """Provides a summary for a dashboard.

        Access Level: Read

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DescribeDashboard.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDescribeDashboard", [])

    @jsii.member(jsii_name="toDescribeDashboardPermissions")
    def to_describe_dashboard_permissions(self) -> "Quicksight":
        """Describes read and write permissions for a dashboard.

        Access Level: Read

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DescribeDashboardPermissions.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDescribeDashboardPermissions", [])

    @jsii.member(jsii_name="toDescribeDataSet")
    def to_describe_data_set(self) -> "Quicksight":
        """Grants permission to describe a dataset.

        Access Level: Read

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsTagKeys()

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DescribeDataSet.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDescribeDataSet", [])

    @jsii.member(jsii_name="toDescribeDataSetPermissions")
    def to_describe_data_set_permissions(self) -> "Quicksight":
        """Grants permission to describe the resource policy of a dataset.

        Access Level: Permissions management

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsTagKeys()

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DescribeDataSetPermissions.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDescribeDataSetPermissions", [])

    @jsii.member(jsii_name="toDescribeDataSource")
    def to_describe_data_source(self) -> "Quicksight":
        """Grants permission to describe a data source.

        Access Level: Read

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsTagKeys()

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DescribeDataSource.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDescribeDataSource", [])

    @jsii.member(jsii_name="toDescribeDataSourcePermissions")
    def to_describe_data_source_permissions(self) -> "Quicksight":
        """Grants permission to describe the resource policy of a data source.

        Access Level: Permissions management

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsTagKeys()

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DescribeDataSourcePermissions.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDescribeDataSourcePermissions", [])

    @jsii.member(jsii_name="toDescribeGroup")
    def to_describe_group(self) -> "Quicksight":
        """Return a QuickSight group’s description and ARN.

        Access Level: Read

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DescribeGroup.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDescribeGroup", [])

    @jsii.member(jsii_name="toDescribeIAMPolicyAssignment")
    def to_describe_iam_policy_assignment(self) -> "Quicksight":
        """Describe an existing assignment.

        Access Level: Read

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DescribeIAMPolicyAssignment.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDescribeIAMPolicyAssignment", [])

    @jsii.member(jsii_name="toDescribeIngestion")
    def to_describe_ingestion(self) -> "Quicksight":
        """Grants permission to describe a SPICE ingestion on a dataset.

        Access Level: Read

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsTagKeys()

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DescribeIngestion.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDescribeIngestion", [])

    @jsii.member(jsii_name="toDescribeNamespace")
    def to_describe_namespace(self) -> "Quicksight":
        """Grants permission to describe a QuickSight namespace.

        Access Level: Read

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DescribeNamespace.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDescribeNamespace", [])

    @jsii.member(jsii_name="toDescribeTemplate")
    def to_describe_template(self) -> "Quicksight":
        """Describes a template's metadata.

        Access Level: Read

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DescribeTemplate.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDescribeTemplate", [])

    @jsii.member(jsii_name="toDescribeTemplateAlias")
    def to_describe_template_alias(self) -> "Quicksight":
        """Describes the template alias for a template.

        Access Level: Read

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DescribeTemplateAlias.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDescribeTemplateAlias", [])

    @jsii.member(jsii_name="toDescribeTemplatePermissions")
    def to_describe_template_permissions(self) -> "Quicksight":
        """Describes read and write permissions on a template.

        Access Level: Read

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DescribeTemplatePermissions.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDescribeTemplatePermissions", [])

    @jsii.member(jsii_name="toDescribeTheme")
    def to_describe_theme(self) -> "Quicksight":
        """Describes a theme's metadata.

        Access Level: Read

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DescribeTheme.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDescribeTheme", [])

    @jsii.member(jsii_name="toDescribeThemeAlias")
    def to_describe_theme_alias(self) -> "Quicksight":
        """Describes the theme alias for a theme.

        Access Level: Read

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DescribeThemeAlias.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDescribeThemeAlias", [])

    @jsii.member(jsii_name="toDescribeThemePermissions")
    def to_describe_theme_permissions(self) -> "Quicksight":
        """Describes read and write permissions on a theme.

        Access Level: Read

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DescribeThemePermissions.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDescribeThemePermissions", [])

    @jsii.member(jsii_name="toDescribeUser")
    def to_describe_user(self) -> "Quicksight":
        """Return information about a user, given the user name.

        Access Level: Read

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DescribeUser.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDescribeUser", [])

    @jsii.member(jsii_name="toGetAuthCode")
    def to_get_auth_code(self) -> "Quicksight":
        """Return an auth code representing a QuickSight user.

        Access Level: Read

        https://docs.aws.amazon.com/quicksight/latest/user/iam-actions.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toGetAuthCode", [])

    @jsii.member(jsii_name="toGetDashboardEmbedUrl")
    def to_get_dashboard_embed_url(self) -> "Quicksight":
        """Return a QuickSight dashboard embedding URL.

        Access Level: Read

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_GetDashboardEmbedUrl.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toGetDashboardEmbedUrl", [])

    @jsii.member(jsii_name="toGetGroupMapping")
    def to_get_group_mapping(self) -> "Quicksight":
        """GetGroupMapping is used only in Amazon QuickSight Enterprise edition accounts.

        It enables the user to use Amazon QuickSight to identify and display the Microsoft Active Directory (Microsoft Active Directory) directory groups that are mapped to roles in Amazon QuickSight.

        Access Level: Read

        https://docs.aws.amazon.com/quicksight/latest/user/iam-actions.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toGetGroupMapping", [])

    @jsii.member(jsii_name="toGetSessionEmbedUrl")
    def to_get_session_embed_url(self) -> "Quicksight":
        """Grants permission to get a URL to embed QuickSight console experience.

        Access Level: Read

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_GetSessionEmbedUrl.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toGetSessionEmbedUrl", [])

    @jsii.member(jsii_name="toListAnalyses")
    def to_list_analyses(self) -> "Quicksight":
        """Lists analyses in an AWS account.

        Access Level: List

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_ListAnalyses.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toListAnalyses", [])

    @jsii.member(jsii_name="toListCustomPermissions")
    def to_list_custom_permissions(self) -> "Quicksight":
        """Grants permission to list custom permissions resources in QuickSight account.

        Access Level: Write

        https://docs.aws.amazon.com/quicksight/latest/user/iam-actions.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toListCustomPermissions", [])

    @jsii.member(jsii_name="toListDashboards")
    def to_list_dashboards(self) -> "Quicksight":
        """Lists dashboards in an AWS account.

        Access Level: List

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_ListDashboards.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toListDashboards", [])

    @jsii.member(jsii_name="toListDashboardVersions")
    def to_list_dashboard_versions(self) -> "Quicksight":
        """Lists all the versions of the dashboards in the QuickSight subscription.

        Access Level: List

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_ListDashboardVersions.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toListDashboardVersions", [])

    @jsii.member(jsii_name="toListDataSets")
    def to_list_data_sets(self) -> "Quicksight":
        """Grants permission to list all datasets.

        Access Level: List

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsTagKeys()

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_ListDataSets.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toListDataSets", [])

    @jsii.member(jsii_name="toListDataSources")
    def to_list_data_sources(self) -> "Quicksight":
        """Grants permission to list all data sources.

        Access Level: List

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsTagKeys()

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_ListDataSources.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toListDataSources", [])

    @jsii.member(jsii_name="toListGroupMemberships")
    def to_list_group_memberships(self) -> "Quicksight":
        """Return a list of member users in a group.

        Access Level: List

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_ListGroupMemberships.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toListGroupMemberships", [])

    @jsii.member(jsii_name="toListGroups")
    def to_list_groups(self) -> "Quicksight":
        """Get a list of all user groups in QuickSight.

        Access Level: List

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_ListGroups.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toListGroups", [])

    @jsii.member(jsii_name="toListIAMPolicyAssignments")
    def to_list_iam_policy_assignments(self) -> "Quicksight":
        """List all assignments in the current Amazon QuickSight account.

        Access Level: List

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_ListIAMPolicyAssignments.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toListIAMPolicyAssignments", [])

    @jsii.member(jsii_name="toListIAMPolicyAssignmentsForUser")
    def to_list_iam_policy_assignments_for_user(self) -> "Quicksight":
        """List all assignments assigned to a user and the groups it belongs.

        Access Level: List

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_ListIAMPolicyAssignmentsForUser.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toListIAMPolicyAssignmentsForUser", [])

    @jsii.member(jsii_name="toListIngestions")
    def to_list_ingestions(self) -> "Quicksight":
        """Grants permission to list all SPICE ingestions on a dataset.

        Access Level: Read

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsTagKeys()

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_ListIngestions.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toListIngestions", [])

    @jsii.member(jsii_name="toListNamespaces")
    def to_list_namespaces(self) -> "Quicksight":
        """Grants permission to lists all namespaces in a QuickSight account.

        Access Level: Write

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_ListNamespaces.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toListNamespaces", [])

    @jsii.member(jsii_name="toListTagsForResource")
    def to_list_tags_for_resource(self) -> "Quicksight":
        """List tags of a QuickSight resource.

        Access Level: List

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_ListTagsForResource.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toListTagsForResource", [])

    @jsii.member(jsii_name="toListTemplateAliases")
    def to_list_template_aliases(self) -> "Quicksight":
        """Lists all the aliases of a template.

        Access Level: List

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_ListTemplateAliases.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toListTemplateAliases", [])

    @jsii.member(jsii_name="toListTemplates")
    def to_list_templates(self) -> "Quicksight":
        """Lists all the templates in the current Amazon QuickSight account.

        Access Level: List

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_ListTemplates.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toListTemplates", [])

    @jsii.member(jsii_name="toListTemplateVersions")
    def to_list_template_versions(self) -> "Quicksight":
        """Lists all the versions of the templates in the current Amazon QuickSight account.

        Access Level: List

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_ListTemplateVersions.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toListTemplateVersions", [])

    @jsii.member(jsii_name="toListThemeAliases")
    def to_list_theme_aliases(self) -> "Quicksight":
        """Lists all the aliases of a theme.

        Access Level: List

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_ListThemeAliases.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toListThemeAliases", [])

    @jsii.member(jsii_name="toListThemes")
    def to_list_themes(self) -> "Quicksight":
        """Lists all the themes in the current Amazon QuickSight account.

        Access Level: List

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_ListThemes.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toListThemes", [])

    @jsii.member(jsii_name="toListThemeVersions")
    def to_list_theme_versions(self) -> "Quicksight":
        """Lists all the versions of a theme.

        Access Level: List

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_ListThemeVersions.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toListThemeVersions", [])

    @jsii.member(jsii_name="toListUserGroups")
    def to_list_user_groups(self) -> "Quicksight":
        """Return a list of groups that a given user is a member of.

        Access Level: List

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_ListUserGroups.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toListUserGroups", [])

    @jsii.member(jsii_name="toListUsers")
    def to_list_users(self) -> "Quicksight":
        """Return a list of all of the QuickSight users belonging to this account.

        Access Level: List

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_ListUsers.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toListUsers", [])

    @jsii.member(jsii_name="toPassDataSet")
    def to_pass_data_set(self) -> "Quicksight":
        """Grants permission to use a dataset for a template.

        Access Level: Read

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsTagKeys()

        https://docs.aws.amazon.com/quicksight/latest/APIReference/qs-api-overview.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toPassDataSet", [])

    @jsii.member(jsii_name="toPassDataSource")
    def to_pass_data_source(self) -> "Quicksight":
        """Grants permission to use a data source for a data set.

        Access Level: Read

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsTagKeys()

        https://docs.aws.amazon.com/quicksight/latest/APIReference/qs-api-overview.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toPassDataSource", [])

    @jsii.member(jsii_name="toRegisterUser")
    def to_register_user(self) -> "Quicksight":
        """Create a QuickSight user, whose identity is associated with the IAM identity/role specified in the request.

        Access Level: Write

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_RegisterUser.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toRegisterUser", [])

    @jsii.member(jsii_name="toRestoreAnalysis")
    def to_restore_analysis(self) -> "Quicksight":
        """Restores a deleted analysis.

        Access Level: Write

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_RestoreAnalysis.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toRestoreAnalysis", [])

    @jsii.member(jsii_name="toSearchAnalyses")
    def to_search_analyses(self) -> "Quicksight":
        """Searches for analyses that belong to the user specified in the filter.

        Access Level: List

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_SearchAnalyses.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toSearchAnalyses", [])

    @jsii.member(jsii_name="toSearchDashboards")
    def to_search_dashboards(self) -> "Quicksight":
        """Searches for dashboards that belong to a user.

        Access Level: List

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_SearchDashboards.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toSearchDashboards", [])

    @jsii.member(jsii_name="toSearchDirectoryGroups")
    def to_search_directory_groups(self) -> "Quicksight":
        """SearchDirectoryGroups is used only in Amazon QuickSight Enterprise edition accounts.

        It enables the user to use Amazon QuickSight to display your Microsoft Active Directory directory groups so that you can choose which ones to map to roles in Amazon QuickSight.

        Access Level: Write

        https://docs.aws.amazon.com/quicksight/latest/user/iam-actions.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toSearchDirectoryGroups", [])

    @jsii.member(jsii_name="toSetGroupMapping")
    def to_set_group_mapping(self) -> "Quicksight":
        """SearchDirectoryGroups is used only in Amazon QuickSight Enterprise edition accounts.

        It enables the user to use Amazon QuickSight to display your Microsoft Active Directory directory groups so that you can choose which ones to map to roles in Amazon QuickSight.

        Access Level: Write

        https://docs.aws.amazon.com/quicksight/latest/user/iam-actions.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toSetGroupMapping", [])

    @jsii.member(jsii_name="toSubscribe")
    def to_subscribe(self) -> "Quicksight":
        """Subscribe enables the user to subscribe to Amazon QuickSight.

        Enabling this action also allows the user to upgrade the subscription to Enterprise edition.

        Access Level: Write

        https://docs.aws.amazon.com/quicksight/latest/user/iam-actions.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toSubscribe", [])

    @jsii.member(jsii_name="toTagResource")
    def to_tag_resource(self) -> "Quicksight":
        """Add tags to a QuickSight resource.

        Access Level: Tagging

        Possible conditions:

        - .ifAwsTagKeys()
        - .ifAwsRequestTag()

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_TagResource.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toTagResource", [])

    @jsii.member(jsii_name="toUnsubscribe")
    def to_unsubscribe(self) -> "Quicksight":
        """Unsubscribe enables the user to unsubscribe from Amazon QuickSight, which permanently deletes all users and their resources from Amazon QuickSight.

        Access Level: Write

        https://docs.aws.amazon.com/quicksight/latest/user/iam-actions.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toUnsubscribe", [])

    @jsii.member(jsii_name="toUntagResource")
    def to_untag_resource(self) -> "Quicksight":
        """Remove tags from a QuickSight resource.

        Access Level: Tagging

        Possible conditions:

        - .ifAwsTagKeys()

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_UntagResource.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toUntagResource", [])

    @jsii.member(jsii_name="toUpdateAccountCustomization")
    def to_update_account_customization(self) -> "Quicksight":
        """Grants permission to update an account customization for QuickSight account or namespace.

        Access Level: Write

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_UpdateAccountCustomization.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toUpdateAccountCustomization", [])

    @jsii.member(jsii_name="toUpdateAccountSettings")
    def to_update_account_settings(self) -> "Quicksight":
        """Grants permission to update the administrative account settings for QuickSight account.

        Access Level: Write

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_UpdateAccountSettings.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toUpdateAccountSettings", [])

    @jsii.member(jsii_name="toUpdateAnalysis")
    def to_update_analysis(self) -> "Quicksight":
        """Updates an analysis in an AWS account.

        Access Level: Write

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_UpdateAnalysis.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toUpdateAnalysis", [])

    @jsii.member(jsii_name="toUpdateAnalysisPermissions")
    def to_update_analysis_permissions(self) -> "Quicksight":
        """Updates read and write permissions on an analysis.

        Access Level: Write

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_UpdateAnalysisPermissions.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toUpdateAnalysisPermissions", [])

    @jsii.member(jsii_name="toUpdateCustomPermissions")
    def to_update_custom_permissions(self) -> "Quicksight":
        """Grants permission to update a custom permissions resource.

        Access Level: Write

        https://docs.aws.amazon.com/quicksight/latest/user/iam-actions.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toUpdateCustomPermissions", [])

    @jsii.member(jsii_name="toUpdateDashboard")
    def to_update_dashboard(self) -> "Quicksight":
        """Updates a dashboard in an AWS account.

        Access Level: Write

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_UpdateDashboard.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toUpdateDashboard", [])

    @jsii.member(jsii_name="toUpdateDashboardPermissions")
    def to_update_dashboard_permissions(self) -> "Quicksight":
        """Updates read and write permissions on a dashboard.

        Access Level: Write

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_UpdateDashboardPermissions.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toUpdateDashboardPermissions", [])

    @jsii.member(jsii_name="toUpdateDashboardPublishedVersion")
    def to_update_dashboard_published_version(self) -> "Quicksight":
        """Updates the published version of a dashboard.

        Access Level: Write

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_UpdateDashboardPublishedVersion.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toUpdateDashboardPublishedVersion", [])

    @jsii.member(jsii_name="toUpdateDataSet")
    def to_update_data_set(self) -> "Quicksight":
        """Grants permission to update a dataset.

        Access Level: Write

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsTagKeys()

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_UpdateDataSet.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toUpdateDataSet", [])

    @jsii.member(jsii_name="toUpdateDataSetPermissions")
    def to_update_data_set_permissions(self) -> "Quicksight":
        """Grants permission to update the resource policy of a dataset.

        Access Level: Permissions management

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsTagKeys()

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_UpdateDataSetPermissions.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toUpdateDataSetPermissions", [])

    @jsii.member(jsii_name="toUpdateDataSource")
    def to_update_data_source(self) -> "Quicksight":
        """Grants permission to update a data source.

        Access Level: Write

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsTagKeys()

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_UpdateDataSource.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toUpdateDataSource", [])

    @jsii.member(jsii_name="toUpdateDataSourcePermissions")
    def to_update_data_source_permissions(self) -> "Quicksight":
        """Grants permission to update the resource policy of a data source.

        Access Level: Permissions management

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsTagKeys()

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_UpdateDataSourcePermissions.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toUpdateDataSourcePermissions", [])

    @jsii.member(jsii_name="toUpdateGroup")
    def to_update_group(self) -> "Quicksight":
        """Change group description.

        Access Level: Write

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_UpdateGroup.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toUpdateGroup", [])

    @jsii.member(jsii_name="toUpdateIAMPolicyAssignment")
    def to_update_iam_policy_assignment(self) -> "Quicksight":
        """Update an existing assignment.

        Access Level: Write

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_UpdateIAMPolicyAssignment.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toUpdateIAMPolicyAssignment", [])

    @jsii.member(jsii_name="toUpdateTemplate")
    def to_update_template(self) -> "Quicksight":
        """Updates a template from an existing Amazon QuickSight analysis or another template.

        Access Level: Write

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_UpdateTemplate.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toUpdateTemplate", [])

    @jsii.member(jsii_name="toUpdateTemplateAlias")
    def to_update_template_alias(self) -> "Quicksight":
        """Updates the template alias of a template.

        Access Level: Write

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_UpdateTemplateAlias.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toUpdateTemplateAlias", [])

    @jsii.member(jsii_name="toUpdateTemplatePermissions")
    def to_update_template_permissions(self) -> "Quicksight":
        """Updates the resource permissions for a template.

        Access Level: Write

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_UpdateTemplatePermissions.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toUpdateTemplatePermissions", [])

    @jsii.member(jsii_name="toUpdateTheme")
    def to_update_theme(self) -> "Quicksight":
        """Updates a theme.

        Access Level: Write

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_UpdateTheme.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toUpdateTheme", [])

    @jsii.member(jsii_name="toUpdateThemeAlias")
    def to_update_theme_alias(self) -> "Quicksight":
        """Updates the theme alias of a theme.

        Access Level: Write

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_UpdateThemeAlias.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toUpdateThemeAlias", [])

    @jsii.member(jsii_name="toUpdateThemePermissions")
    def to_update_theme_permissions(self) -> "Quicksight":
        """Updates the resource permissions for a theme.

        Access Level: Write

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_UpdateThemePermissions.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toUpdateThemePermissions", [])

    @jsii.member(jsii_name="toUpdateUser")
    def to_update_user(self) -> "Quicksight":
        """Updates an Amazon QuickSight user.

        Access Level: Write

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_UpdateUser.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toUpdateUser", [])

    @builtins.property # type: ignore
    @jsii.member(jsii_name="accessLevelList")
    def _access_level_list(self) -> "AccessLevelList":
        """
        stability
        :stability: experimental
        """
        return jsii.get(self, "accessLevelList")

    @_access_level_list.setter # type: ignore
    def _access_level_list(self, value: "AccessLevelList") -> None:
        jsii.set(self, "accessLevelList", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="servicePrefix")
    def service_prefix(self) -> builtins.str:
        """Holds the prefix of the service actions, e.g. ``ec2``.

        stability
        :stability: experimental
        """
        return jsii.get(self, "servicePrefix")

    @service_prefix.setter # type: ignore
    def service_prefix(self, value: builtins.str) -> None:
        jsii.set(self, "servicePrefix", value)


class Ram(PolicyStatement, metaclass=jsii.JSIIMeta, jsii_type="iam-floyd.Ram"):
    """Statement provider for service `ram <https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsresourceaccessmanager.html>`_.

    stability
    :stability: experimental
    """

    def __init__(self, sid: typing.Optional[builtins.str] = None) -> None:
        """Statement provider for service `ram <https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsresourceaccessmanager.html>`_.

        :param sid: `SID <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html>`_ of the statement.

        stability
        :stability: experimental
        """
        jsii.create(Ram, self, [sid])

    @jsii.member(jsii_name="ifAllowsExternalPrincipals")
    def if_allows_external_principals(
        self,
        value: typing.Optional[builtins.bool] = None,
    ) -> "Ram":
        """Indicates that the action can only be performed on resource shares that allow or deny sharing with external principals.

        For example, specify true if the action can only be performed on resource shares that allow sharing with external principals. External principals are AWS accounts that are outside of its AWS organization

        https://docs.aws.amazon.com/ram/latest/userguide/iam-policies.html#iam-policies-condition

        Applies to actions:

        - .toAssociateResourceShare()
        - .toAssociateResourceSharePermission()
        - .toDeleteResourceShare()
        - .toDisassociateResourceShare()
        - .toDisassociateResourceSharePermission()
        - .toListResourceSharePermissions()
        - .toPromoteResourceShareCreatedFromPolicy()
        - .toUpdateResourceShare()

        Applies to resource types:

        - resource-share

        :param value: ``true`` or ``false``. **Default:** ``true``

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "ifAllowsExternalPrincipals", [value])

    @jsii.member(jsii_name="ifPermissionArn")
    def if_permission_arn(
        self,
        value: typing.Union[builtins.str, typing.List[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, "Operator"]] = None,
    ) -> "Ram":
        """Indicates that the action can only be performed on a resource using the specified Permission ARN.

        https://docs.aws.amazon.com/ram/latest/userguide/iam-policies.html#iam-policies-condition

        Applies to actions:

        - .toAssociateResourceSharePermission()
        - .toDisassociateResourceSharePermission()
        - .toGetPermission()

        Applies to resource types:

        - permission

        :param value: The value(s) to check.
        :param operator: Works with `arn operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_ARN>`_. **Default:** ``ArnLike``.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "ifPermissionArn", [value, operator])

    @jsii.member(jsii_name="ifPrincipal")
    def if_principal(
        self,
        value: typing.Union[builtins.str, typing.List[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, "Operator"]] = None,
    ) -> "Ram":
        """Principals with the specified format can be associated to or disassociated from a resource share.

        https://docs.aws.amazon.com/ram/latest/userguide/iam-policies.html#iam-policies-condition

        Applies to actions:

        - .toAssociateResourceShare()
        - .toCreateResourceShare()
        - .toDisassociateResourceShare()

        :param value: The value(s) to check.
        :param operator: Works with `string operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String>`_. **Default:** ``StringLike``.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "ifPrincipal", [value, operator])

    @jsii.member(jsii_name="ifRequestedAllowsExternalPrincipals")
    def if_requested_allows_external_principals(
        self,
        value: typing.Optional[builtins.bool] = None,
    ) -> "Ram":
        """The request must have the specified value for 'allowExternalPrincipals'.

        External principals are AWS accounts that are outside of its AWS Organization

        https://docs.aws.amazon.com/ram/latest/userguide/iam-policies.html#iam-policies-condition

        Applies to actions:

        - .toCreateResourceShare()
        - .toUpdateResourceShare()

        :param value: ``true`` or ``false``. **Default:** ``true``

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "ifRequestedAllowsExternalPrincipals", [value])

    @jsii.member(jsii_name="ifRequestedResourceType")
    def if_requested_resource_type(
        self,
        value: typing.Union[builtins.str, typing.List[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, "Operator"]] = None,
    ) -> "Ram":
        """Indicates that the action can only be performed on the specified resource type.

        https://docs.aws.amazon.com/ram/latest/userguide/iam-policies.html#iam-policies-condition

        Applies to actions:

        - .toAssociateResourceShare()
        - .toCreateResourceShare()
        - .toDisassociateResourceShare()

        :param value: The value(s) to check.
        :param operator: Works with `string operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String>`_. **Default:** ``StringLike``.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "ifRequestedResourceType", [value, operator])

    @jsii.member(jsii_name="ifResourceArn")
    def if_resource_arn(
        self,
        value: typing.Union[builtins.str, typing.List[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, "Operator"]] = None,
    ) -> "Ram":
        """Indicates that the action can only be performed on a resource with the specified ARN.

        https://docs.aws.amazon.com/ram/latest/userguide/iam-policies.html#iam-policies-condition

        Applies to actions:

        - .toAssociateResourceShare()
        - .toCreateResourceShare()
        - .toDisassociateResourceShare()

        :param value: The value(s) to check.
        :param operator: Works with `arn operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_ARN>`_. **Default:** ``ArnLike``.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "ifResourceArn", [value, operator])

    @jsii.member(jsii_name="ifResourceShareName")
    def if_resource_share_name(
        self,
        value: typing.Union[builtins.str, typing.List[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, "Operator"]] = None,
    ) -> "Ram":
        """Indicates that the action can only be performed on a resource share with the specified name.

        https://docs.aws.amazon.com/ram/latest/userguide/iam-policies.html#iam-policies-condition

        Applies to actions:

        - .toAssociateResourceShare()
        - .toAssociateResourceSharePermission()
        - .toDeleteResourceShare()
        - .toDisassociateResourceShare()
        - .toDisassociateResourceSharePermission()
        - .toListResourceSharePermissions()
        - .toPromoteResourceShareCreatedFromPolicy()
        - .toUpdateResourceShare()

        Applies to resource types:

        - resource-share

        :param value: The value(s) to check.
        :param operator: Works with `string operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String>`_. **Default:** ``StringLike``.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "ifResourceShareName", [value, operator])

    @jsii.member(jsii_name="ifShareOwnerAccountId")
    def if_share_owner_account_id(
        self,
        value: typing.Union[builtins.str, typing.List[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, "Operator"]] = None,
    ) -> "Ram":
        """Indicates that the action can only be performed on resource shares owned by a specific account.

        For example, you can use this condition key to specify which resource share invitations can be accepted or rejected based on the resource share owner’s account ID.

        https://docs.aws.amazon.com/ram/latest/userguide/iam-policies.html#iam-policies-condition

        Applies to actions:

        - .toAcceptResourceShareInvitation()
        - .toRejectResourceShareInvitation()

        :param value: The value(s) to check.
        :param operator: Works with `string operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String>`_. **Default:** ``StringLike``.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "ifShareOwnerAccountId", [value, operator])

    @jsii.member(jsii_name="onPermission")
    def on_permission(
        self,
        resource_path: builtins.str,
        account: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Ram":
        """Adds a resource of type permission to the statement.

        https://docs.aws.amazon.com/ram/latest/APIReference/API_ResourceSharePermissionDetail.html

        :param resource_path: - Identifier for the resourcePath.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``. Possible conditions: - .ifPermissionArn()

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "onPermission", [resource_path, account, partition])

    @jsii.member(jsii_name="onResourceShare")
    def on_resource_share(
        self,
        resource_path: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Ram":
        """Adds a resource of type resource-share to the statement.

        https://docs.aws.amazon.com/ram/latest/APIReference/API_ResourceShare.html

        :param resource_path: - Identifier for the resourcePath.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``. Possible conditions: - .ifAwsResourceTag() - .ifAllowsExternalPrincipals() - .ifResourceShareName()

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "onResourceShare", [resource_path, account, region, partition])

    @jsii.member(jsii_name="onResourceShareInvitation")
    def on_resource_share_invitation(
        self,
        resource_path: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Ram":
        """Adds a resource of type resource-share-invitation to the statement.

        https://docs.aws.amazon.com/ram/latest/APIReference/API_ResourceShareInvitation.html

        :param resource_path: - Identifier for the resourcePath.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "onResourceShareInvitation", [resource_path, account, region, partition])

    @jsii.member(jsii_name="toAcceptResourceShareInvitation")
    def to_accept_resource_share_invitation(self) -> "Ram":
        """Accept the specified resource share invitation.

        Access Level: Write

        Possible conditions:

        - .ifShareOwnerAccountId()

        https://docs.aws.amazon.com/ram/latest/APIReference/API_AcceptResourceShareInvitation.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toAcceptResourceShareInvitation", [])

    @jsii.member(jsii_name="toAssociateResourceShare")
    def to_associate_resource_share(self) -> "Ram":
        """Associates resource(s) and/or principal(s) to a resource share.

        Access Level: Write

        Possible conditions:

        - .ifAwsResourceTag()
        - .ifResourceShareName()
        - .ifAllowsExternalPrincipals()
        - .ifPrincipal()
        - .ifRequestedResourceType()
        - .ifResourceArn()

        https://docs.aws.amazon.com/ram/latest/APIReference/API_AssociateResourceShare.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toAssociateResourceShare", [])

    @jsii.member(jsii_name="toAssociateResourceSharePermission")
    def to_associate_resource_share_permission(self) -> "Ram":
        """Associate a Permission with a Resource Share.

        Access Level: Write

        Possible conditions:

        - .ifAwsResourceTag()
        - .ifAllowsExternalPrincipals()
        - .ifResourceShareName()
        - .ifPermissionArn()

        https://docs.aws.amazon.com/ram/latest/APIReference/API_AssociateResourceSharePermission.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toAssociateResourceSharePermission", [])

    @jsii.member(jsii_name="toCreateResourceShare")
    def to_create_resource_share(self) -> "Ram":
        """Create resource share with provided resource(s) and/or principal(s).

        Access Level: Write

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsTagKeys()
        - .ifRequestedResourceType()
        - .ifResourceArn()
        - .ifRequestedAllowsExternalPrincipals()
        - .ifPrincipal()

        https://docs.aws.amazon.com/ram/latest/APIReference/API_CreateResourceShare.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toCreateResourceShare", [])

    @jsii.member(jsii_name="toDeleteResourceShare")
    def to_delete_resource_share(self) -> "Ram":
        """Delete resource share.

        Access Level: Write

        Possible conditions:

        - .ifAwsResourceTag()
        - .ifResourceShareName()
        - .ifAllowsExternalPrincipals()

        https://docs.aws.amazon.com/ram/latest/APIReference/API_DeleteResourceShare.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDeleteResourceShare", [])

    @jsii.member(jsii_name="toDisassociateResourceShare")
    def to_disassociate_resource_share(self) -> "Ram":
        """Disassociates resource(s) and/or principal(s) from a resource share.

        Access Level: Write

        Possible conditions:

        - .ifAwsResourceTag()
        - .ifResourceShareName()
        - .ifAllowsExternalPrincipals()
        - .ifPrincipal()
        - .ifRequestedResourceType()
        - .ifResourceArn()

        https://docs.aws.amazon.com/ram/latest/APIReference/API_DisassociateResourceShare.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDisassociateResourceShare", [])

    @jsii.member(jsii_name="toDisassociateResourceSharePermission")
    def to_disassociate_resource_share_permission(self) -> "Ram":
        """Disassociate a Permission from a Resource Share.

        Access Level: Write

        Possible conditions:

        - .ifAwsResourceTag()
        - .ifAllowsExternalPrincipals()
        - .ifResourceShareName()
        - .ifPermissionArn()

        https://docs.aws.amazon.com/ram/latest/APIReference/API_DisassociateResourceSharePermission.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDisassociateResourceSharePermission", [])

    @jsii.member(jsii_name="toEnableSharingWithAwsOrganization")
    def to_enable_sharing_with_aws_organization(self) -> "Ram":
        """Grants permission to access customer's organization and create a SLR in the customer's account.

        Access Level: Write

        https://docs.aws.amazon.com/ram/latest/APIReference/API_EnableSharingWithAwsOrganization.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toEnableSharingWithAwsOrganization", [])

    @jsii.member(jsii_name="toGetPermission")
    def to_get_permission(self) -> "Ram":
        """Gets the contents of an AWS RAM permission.

        Access Level: Read

        Possible conditions:

        - .ifPermissionArn()

        https://docs.aws.amazon.com/ram/latest/APIReference/API_GetPermission.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toGetPermission", [])

    @jsii.member(jsii_name="toGetResourcePolicies")
    def to_get_resource_policies(self) -> "Ram":
        """Gets the policies for the specified resources that you own and have shared.

        Access Level: Read

        https://docs.aws.amazon.com/ram/latest/APIReference/API_GetResourcePolicies.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toGetResourcePolicies", [])

    @jsii.member(jsii_name="toGetResourceShareAssociations")
    def to_get_resource_share_associations(self) -> "Ram":
        """Get a set of resource share associations from a provided list or with a specified status of the specified type.

        Access Level: Read

        https://docs.aws.amazon.com/ram/latest/APIReference/API_GetResourceShareAssociations.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toGetResourceShareAssociations", [])

    @jsii.member(jsii_name="toGetResourceShareInvitations")
    def to_get_resource_share_invitations(self) -> "Ram":
        """Get resource share invitations by the specified invitation arn or those for the resource share.

        Access Level: Read

        https://docs.aws.amazon.com/ram/latest/APIReference/API_GetResourceShareInvitations.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toGetResourceShareInvitations", [])

    @jsii.member(jsii_name="toGetResourceShares")
    def to_get_resource_shares(self) -> "Ram":
        """Get a set of resource shares from a provided list or with a specified status.

        Access Level: Read

        https://docs.aws.amazon.com/ram/latest/APIReference/API_GetResourceShares.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toGetResourceShares", [])

    @jsii.member(jsii_name="toListPendingInvitationResources")
    def to_list_pending_invitation_resources(self) -> "Ram":
        """Lists the resources in a resource share that is shared with you but that the invitation is still pending for.

        Access Level: Read

        https://docs.aws.amazon.com/ram/latest/APIReference/API_ListPendingInvitationResources.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toListPendingInvitationResources", [])

    @jsii.member(jsii_name="toListPermissions")
    def to_list_permissions(self) -> "Ram":
        """Lists the AWS RAM permissions.

        Access Level: List

        https://docs.aws.amazon.com/ram/latest/APIReference/API_ListPermissions.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toListPermissions", [])

    @jsii.member(jsii_name="toListPrincipals")
    def to_list_principals(self) -> "Ram":
        """Lists the principals that you have shared resources with or that have shared resources with you.

        Access Level: List

        https://docs.aws.amazon.com/ram/latest/APIReference/API_ListPrincipals.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toListPrincipals", [])

    @jsii.member(jsii_name="toListResources")
    def to_list_resources(self) -> "Ram":
        """Lists the resources that you added to a resource shares or the resources that are shared with you.

        Access Level: List

        https://docs.aws.amazon.com/ram/latest/APIReference/API_ListResources.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toListResources", [])

    @jsii.member(jsii_name="toListResourceSharePermissions")
    def to_list_resource_share_permissions(self) -> "Ram":
        """List the Permissions associated with a Resource Share.

        Access Level: List

        Possible conditions:

        - .ifAwsResourceTag()
        - .ifResourceShareName()
        - .ifAllowsExternalPrincipals()

        https://docs.aws.amazon.com/ram/latest/APIReference/API_ListResourceSharePermissions.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toListResourceSharePermissions", [])

    @jsii.member(jsii_name="toListResourceTypes")
    def to_list_resource_types(self) -> "Ram":
        """Lists the shareable resource types supported by AWS RAM.

        Access Level: List

        https://docs.aws.amazon.com/ram/latest/APIReference/API_ListResourceTypes.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toListResourceTypes", [])

    @jsii.member(jsii_name="toPromoteResourceShareCreatedFromPolicy")
    def to_promote_resource_share_created_from_policy(self) -> "Ram":
        """Use this API action to promote the resource share.

        Access Level: Write

        https://docs.aws.amazon.com/ram/latest/APIReference/API_PromoteResourceShareCreatedFromPolicy.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toPromoteResourceShareCreatedFromPolicy", [])

    @jsii.member(jsii_name="toRejectResourceShareInvitation")
    def to_reject_resource_share_invitation(self) -> "Ram":
        """Reject the specified resource share invitation.

        Access Level: Write

        Possible conditions:

        - .ifShareOwnerAccountId()

        https://docs.aws.amazon.com/ram/latest/APIReference/API_RejectResourceShareInvitation.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toRejectResourceShareInvitation", [])

    @jsii.member(jsii_name="toTagResource")
    def to_tag_resource(self) -> "Ram":
        """Tag the specified resources share.

        Access Level: Write

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsTagKeys()

        https://docs.aws.amazon.com/ram/latest/APIReference/API_TagResource.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toTagResource", [])

    @jsii.member(jsii_name="toUntagResource")
    def to_untag_resource(self) -> "Ram":
        """Untag the specified resource share.

        Access Level: Write

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsTagKeys()

        https://docs.aws.amazon.com/ram/latest/APIReference/API_UntagResource.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toUntagResource", [])

    @jsii.member(jsii_name="toUpdateResourceShare")
    def to_update_resource_share(self) -> "Ram":
        """Update attributes of the resource share.

        Access Level: Write

        Possible conditions:

        - .ifAwsResourceTag()
        - .ifResourceShareName()
        - .ifAllowsExternalPrincipals()
        - .ifRequestedAllowsExternalPrincipals()

        https://docs.aws.amazon.com/ram/latest/APIReference/API_UpdateResourceShare.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toUpdateResourceShare", [])

    @builtins.property # type: ignore
    @jsii.member(jsii_name="accessLevelList")
    def _access_level_list(self) -> "AccessLevelList":
        """
        stability
        :stability: experimental
        """
        return jsii.get(self, "accessLevelList")

    @_access_level_list.setter # type: ignore
    def _access_level_list(self, value: "AccessLevelList") -> None:
        jsii.set(self, "accessLevelList", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="servicePrefix")
    def service_prefix(self) -> builtins.str:
        """Holds the prefix of the service actions, e.g. ``ec2``.

        stability
        :stability: experimental
        """
        return jsii.get(self, "servicePrefix")

    @service_prefix.setter # type: ignore
    def service_prefix(self, value: builtins.str) -> None:
        jsii.set(self, "servicePrefix", value)


class Rds(PolicyStatement, metaclass=jsii.JSIIMeta, jsii_type="iam-floyd.Rds"):
    """Statement provider for service `rds <https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonrds.html>`_.

    stability
    :stability: experimental
    """

    def __init__(self, sid: typing.Optional[builtins.str] = None) -> None:
        """Statement provider for service `rds <https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonrds.html>`_.

        :param sid: `SID <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html>`_ of the statement.

        stability
        :stability: experimental
        """
        jsii.create(Rds, self, [sid])

    @jsii.member(jsii_name="ifClusterPgTag")
    def if_cluster_pg_tag(
        self,
        tag_key: builtins.str,
        value: typing.Union[builtins.str, typing.List[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, "Operator"]] = None,
    ) -> "Rds":
        """Filters access by the tag attached to a DB cluster parameter group.

        https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/security_iam_service-with-iam.html#UsingWithRDS.IAM.Conditions

        Applies to resource types:

        - cluster-pg

        :param tag_key: The tag key to check.
        :param value: The value(s) to check.
        :param operator: Works with `string operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String>`_. **Default:** ``StringLike``.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "ifClusterPgTag", [tag_key, value, operator])

    @jsii.member(jsii_name="ifClusterSnapshotTag")
    def if_cluster_snapshot_tag(
        self,
        tag_key: builtins.str,
        value: typing.Union[builtins.str, typing.List[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, "Operator"]] = None,
    ) -> "Rds":
        """Filters access by the tag attached to a DB cluster snapshot.

        https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/security_iam_service-with-iam.html#UsingWithRDS.IAM.Conditions

        Applies to resource types:

        - cluster-snapshot

        :param tag_key: The tag key to check.
        :param value: The value(s) to check.
        :param operator: Works with `string operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String>`_. **Default:** ``StringLike``.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "ifClusterSnapshotTag", [tag_key, value, operator])

    @jsii.member(jsii_name="ifClusterTag")
    def if_cluster_tag(
        self,
        tag_key: builtins.str,
        value: typing.Union[builtins.str, typing.List[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, "Operator"]] = None,
    ) -> "Rds":
        """Filters access by the tag attached to a DB cluster.

        https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/security_iam_service-with-iam.html#UsingWithRDS.IAM.Conditions

        Applies to resource types:

        - cluster

        :param tag_key: The tag key to check.
        :param value: The value(s) to check.
        :param operator: Works with `string operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String>`_. **Default:** ``StringLike``.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "ifClusterTag", [tag_key, value, operator])

    @jsii.member(jsii_name="ifDatabaseClass")
    def if_database_class(
        self,
        value: typing.Union[builtins.str, typing.List[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, "Operator"]] = None,
    ) -> "Rds":
        """Filters access by the type of DB instance class.

        https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/security_iam_service-with-iam.html#UsingWithRDS.IAM.Conditions

        Applies to resource types:

        - db

        :param value: The value(s) to check.
        :param operator: Works with `string operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String>`_. **Default:** ``StringLike``.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "ifDatabaseClass", [value, operator])

    @jsii.member(jsii_name="ifDatabaseEngine")
    def if_database_engine(
        self,
        value: typing.Union[builtins.str, typing.List[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, "Operator"]] = None,
    ) -> "Rds":
        """Filters access by the database engine. For possible values refer to the engine parameter in CreateDBInstance API.

        https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/security_iam_service-with-iam.html#UsingWithRDS.IAM.Conditions

        Applies to actions:

        - .toCreateDBCluster()
        - .toRestoreDBClusterFromS3()

        Applies to resource types:

        - db

        :param value: The value(s) to check.
        :param operator: Works with `string operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String>`_. **Default:** ``StringLike``.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "ifDatabaseEngine", [value, operator])

    @jsii.member(jsii_name="ifDatabaseName")
    def if_database_name(
        self,
        value: typing.Union[builtins.str, typing.List[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, "Operator"]] = None,
    ) -> "Rds":
        """Filters access by the user-defined name of the database on the DB instance.

        https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/security_iam_service-with-iam.html#UsingWithRDS.IAM.Conditions

        Applies to actions:

        - .toCreateDBCluster()
        - .toRestoreDBClusterFromS3()

        Applies to resource types:

        - db

        :param value: The value(s) to check.
        :param operator: Works with `string operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String>`_. **Default:** ``StringLike``.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "ifDatabaseName", [value, operator])

    @jsii.member(jsii_name="ifDbTag")
    def if_db_tag(
        self,
        tag_key: builtins.str,
        value: typing.Union[builtins.str, typing.List[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, "Operator"]] = None,
    ) -> "Rds":
        """Filters access by the tag attached to a DB instance.

        https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/security_iam_service-with-iam.html#UsingWithRDS.IAM.Conditions

        Applies to resource types:

        - db

        :param tag_key: The tag key to check.
        :param value: The value(s) to check.
        :param operator: Works with `string operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String>`_. **Default:** ``StringLike``.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "ifDbTag", [tag_key, value, operator])

    @jsii.member(jsii_name="ifEndpointType")
    def if_endpoint_type(
        self,
        value: typing.Union[builtins.str, typing.List[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, "Operator"]] = None,
    ) -> "Rds":
        """Filters access by the type of the endpoint. One of: READER, WRITER, CUSTOM.

        https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/security_iam_service-with-iam.html#UsingWithRDS.IAM.Conditions

        Applies to actions:

        - .toCreateDBClusterEndpoint()

        :param value: The value(s) to check.
        :param operator: Works with `string operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String>`_. **Default:** ``StringLike``.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "ifEndpointType", [value, operator])

    @jsii.member(jsii_name="ifEsTag")
    def if_es_tag(
        self,
        tag_key: builtins.str,
        value: typing.Union[builtins.str, typing.List[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, "Operator"]] = None,
    ) -> "Rds":
        """Filters access by the tag attached to an event subscription.

        https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/security_iam_service-with-iam.html#UsingWithRDS.IAM.Conditions

        Applies to resource types:

        - es

        :param tag_key: The tag key to check.
        :param value: The value(s) to check.
        :param operator: Works with `string operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String>`_. **Default:** ``StringLike``.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "ifEsTag", [tag_key, value, operator])

    @jsii.member(jsii_name="ifMultiAz")
    def if_multi_az(self, value: typing.Optional[builtins.bool] = None) -> "Rds":
        """Filters access by the value that specifies whether the DB instance runs in multiple Availability Zones.

        To indicate that the DB instance is using Multi-AZ, specify true

        https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/security_iam_service-with-iam.html#UsingWithRDS.IAM.Conditions

        Applies to resource types:

        - db

        :param value: ``true`` or ``false``. **Default:** ``true``

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "ifMultiAz", [value])

    @jsii.member(jsii_name="ifOgTag")
    def if_og_tag(
        self,
        tag_key: builtins.str,
        value: typing.Union[builtins.str, typing.List[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, "Operator"]] = None,
    ) -> "Rds":
        """Filters access by the tag attached to a DB option group.

        https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/security_iam_service-with-iam.html#UsingWithRDS.IAM.Conditions

        Applies to resource types:

        - og

        :param tag_key: The tag key to check.
        :param value: The value(s) to check.
        :param operator: Works with `string operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String>`_. **Default:** ``StringLike``.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "ifOgTag", [tag_key, value, operator])

    @jsii.member(jsii_name="ifPgTag")
    def if_pg_tag(
        self,
        tag_key: builtins.str,
        value: typing.Union[builtins.str, typing.List[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, "Operator"]] = None,
    ) -> "Rds":
        """Filters access by the tag attached to a DB parameter group.

        https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/security_iam_service-with-iam.html#UsingWithRDS.IAM.Conditions

        Applies to resource types:

        - pg

        :param tag_key: The tag key to check.
        :param value: The value(s) to check.
        :param operator: Works with `string operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String>`_. **Default:** ``StringLike``.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "ifPgTag", [tag_key, value, operator])

    @jsii.member(jsii_name="ifPiops")
    def if_piops(
        self,
        value: typing.Union[jsii.Number, typing.List[jsii.Number]],
        operator: typing.Optional[typing.Union[builtins.str, "Operator"]] = None,
    ) -> "Rds":
        """Filters access by the value that contains the number of Provisioned IOPS (PIOPS) that the instance supports.

        To indicate a DB instance that does not have PIOPS enabled, specify 0

        https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/security_iam_service-with-iam.html#UsingWithRDS.IAM.Conditions

        Applies to resource types:

        - db

        :param value: The value(s) to check.
        :param operator: Works with `numeric operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_Numeric>`_. **Default:** ``NumericEquals``.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "ifPiops", [value, operator])

    @jsii.member(jsii_name="ifReqTag")
    def if_req_tag(
        self,
        tag_key: builtins.str,
        value: typing.Union[builtins.str, typing.List[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, "Operator"]] = None,
    ) -> "Rds":
        """Filters access by the set of tag keys and values that can be used to tag a resource.

        https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/security_iam_service-with-iam.html#UsingWithRDS.IAM.Conditions

        Applies to actions:

        - .toAddTagsToResource()
        - .toCreateDBCluster()
        - .toCreateDBClusterParameterGroup()
        - .toCreateDBClusterSnapshot()
        - .toCreateDBInstance()
        - .toCreateDBInstanceReadReplica()
        - .toCreateDBParameterGroup()
        - .toCreateDBSecurityGroup()
        - .toCreateDBSnapshot()
        - .toCreateDBSubnetGroup()
        - .toCreateEventSubscription()
        - .toCreateOptionGroup()
        - .toRemoveTagsFromResource()
        - .toRestoreDBClusterFromS3()
        - .toRestoreDBClusterFromSnapshot()
        - .toRestoreDBClusterToPointInTime()
        - .toRestoreDBInstanceFromDBSnapshot()
        - .toRestoreDBInstanceFromS3()
        - .toRestoreDBInstanceToPointInTime()

        :param tag_key: The tag key to check.
        :param value: The value(s) to check.
        :param operator: Works with `string operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String>`_. **Default:** ``StringLike``.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "ifReqTag", [tag_key, value, operator])

    @jsii.member(jsii_name="ifRiTag")
    def if_ri_tag(
        self,
        tag_key: builtins.str,
        value: typing.Union[builtins.str, typing.List[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, "Operator"]] = None,
    ) -> "Rds":
        """Filters access by the tag attached to a reserved DB instance.

        https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/security_iam_service-with-iam.html#UsingWithRDS.IAM.Conditions

        Applies to resource types:

        - ri

        :param tag_key: The tag key to check.
        :param value: The value(s) to check.
        :param operator: Works with `string operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String>`_. **Default:** ``StringLike``.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "ifRiTag", [tag_key, value, operator])

    @jsii.member(jsii_name="ifSecgrpTag")
    def if_secgrp_tag(
        self,
        tag_key: builtins.str,
        value: typing.Union[builtins.str, typing.List[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, "Operator"]] = None,
    ) -> "Rds":
        """Filters access by the tag attached to a DB security group.

        https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/security_iam_service-with-iam.html#UsingWithRDS.IAM.Conditions

        Applies to resource types:

        - secgrp

        :param tag_key: The tag key to check.
        :param value: The value(s) to check.
        :param operator: Works with `string operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String>`_. **Default:** ``StringLike``.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "ifSecgrpTag", [tag_key, value, operator])

    @jsii.member(jsii_name="ifSnapshotTag")
    def if_snapshot_tag(
        self,
        tag_key: builtins.str,
        value: typing.Union[builtins.str, typing.List[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, "Operator"]] = None,
    ) -> "Rds":
        """Filters access by the tag attached to a DB snapshot.

        https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/security_iam_service-with-iam.html#UsingWithRDS.IAM.Conditions

        Applies to resource types:

        - snapshot

        :param tag_key: The tag key to check.
        :param value: The value(s) to check.
        :param operator: Works with `string operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String>`_. **Default:** ``StringLike``.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "ifSnapshotTag", [tag_key, value, operator])

    @jsii.member(jsii_name="ifStorageEncrypted")
    def if_storage_encrypted(
        self,
        value: typing.Optional[builtins.bool] = None,
    ) -> "Rds":
        """Filters access by the value that specifies whether the DB instance storage should be encrypted.

        To enforce storage encryption, specify true

        https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/security_iam_service-with-iam.html#UsingWithRDS.IAM.Conditions

        Applies to actions:

        - .toCreateDBCluster()
        - .toRestoreDBClusterFromS3()

        Applies to resource types:

        - db

        :param value: ``true`` or ``false``. **Default:** ``true``

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "ifStorageEncrypted", [value])

    @jsii.member(jsii_name="ifStorageSize")
    def if_storage_size(
        self,
        value: typing.Union[jsii.Number, typing.List[jsii.Number]],
        operator: typing.Optional[typing.Union[builtins.str, "Operator"]] = None,
    ) -> "Rds":
        """Filters access by the storage volume size (in GB).

        https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/security_iam_service-with-iam.html#UsingWithRDS.IAM.Conditions

        Applies to resource types:

        - db

        :param value: The value(s) to check.
        :param operator: Works with `numeric operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_Numeric>`_. **Default:** ``NumericEquals``.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "ifStorageSize", [value, operator])

    @jsii.member(jsii_name="ifSubgrpTag")
    def if_subgrp_tag(
        self,
        tag_key: builtins.str,
        value: typing.Union[builtins.str, typing.List[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, "Operator"]] = None,
    ) -> "Rds":
        """Filters access by the tag attached to a DB subnet group.

        https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/security_iam_service-with-iam.html#UsingWithRDS.IAM.Conditions

        Applies to resource types:

        - subgrp

        :param tag_key: The tag key to check.
        :param value: The value(s) to check.
        :param operator: Works with `string operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String>`_. **Default:** ``StringLike``.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "ifSubgrpTag", [tag_key, value, operator])

    @jsii.member(jsii_name="ifVpc")
    def if_vpc(self, value: typing.Optional[builtins.bool] = None) -> "Rds":
        """Filters access by the value that specifies whether the DB instance runs in an Amazon Virtual Private Cloud (Amazon VPC).

        To indicate that the DB instance runs in an Amazon VPC, specify true

        https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/security_iam_service-with-iam.html#UsingWithRDS.IAM.Conditions

        Applies to resource types:

        - db

        :param value: ``true`` or ``false``. **Default:** ``true``

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "ifVpc", [value])

    @jsii.member(jsii_name="onCluster")
    def on_cluster(
        self,
        db_cluster_instance_name: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Rds":
        """Adds a resource of type cluster to the statement.

        https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Aurora.Managing.html

        :param db_cluster_instance_name: - Identifier for the dbClusterInstanceName.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``. Possible conditions: - .ifAwsResourceTag() - .ifClusterTag()

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "onCluster", [db_cluster_instance_name, account, region, partition])

    @jsii.member(jsii_name="onClusterEndpoint")
    def on_cluster_endpoint(
        self,
        db_cluster_endpoint: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Rds":
        """Adds a resource of type cluster-endpoint to the statement.

        https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Aurora.Overview.Endpoints.html

        :param db_cluster_endpoint: - Identifier for the dbClusterEndpoint.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``. Possible conditions: - .ifAwsResourceTag()

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "onClusterEndpoint", [db_cluster_endpoint, account, region, partition])

    @jsii.member(jsii_name="onClusterPg")
    def on_cluster_pg(
        self,
        cluster_parameter_group_name: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Rds":
        """Adds a resource of type cluster-pg to the statement.

        https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_WorkingWithParamGroups.html

        :param cluster_parameter_group_name: - Identifier for the clusterParameterGroupName.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``. Possible conditions: - .ifAwsResourceTag() - .ifClusterPgTag()

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "onClusterPg", [cluster_parameter_group_name, account, region, partition])

    @jsii.member(jsii_name="onClusterSnapshot")
    def on_cluster_snapshot(
        self,
        cluster_snapshot_name: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Rds":
        """Adds a resource of type cluster-snapshot to the statement.

        https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_WorkingWithAutomatedBackups.html

        :param cluster_snapshot_name: - Identifier for the clusterSnapshotName.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``. Possible conditions: - .ifAwsResourceTag() - .ifClusterSnapshotTag()

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "onClusterSnapshot", [cluster_snapshot_name, account, region, partition])

    @jsii.member(jsii_name="onDb")
    def on_db(
        self,
        db_instance_name: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Rds":
        """Adds a resource of type db to the statement.

        https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Overview.DBInstance.html

        :param db_instance_name: - Identifier for the dbInstanceName.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``. Possible conditions: - .ifAwsResourceTag() - .ifDatabaseClass() - .ifDatabaseEngine() - .ifDatabaseName() - .ifMultiAz() - .ifPiops() - .ifStorageEncrypted() - .ifStorageSize() - .ifVpc() - .ifDbTag()

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "onDb", [db_instance_name, account, region, partition])

    @jsii.member(jsii_name="onEs")
    def on_es(
        self,
        subscription_name: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Rds":
        """Adds a resource of type es to the statement.

        https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Events.html

        :param subscription_name: - Identifier for the subscriptionName.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``. Possible conditions: - .ifAwsResourceTag() - .ifEsTag()

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "onEs", [subscription_name, account, region, partition])

    @jsii.member(jsii_name="onGlobalCluster")
    def on_global_cluster(
        self,
        global_cluster: builtins.str,
        account: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Rds":
        """Adds a resource of type global-cluster to the statement.

        https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.Aurora.GlobalDB.html

        :param global_cluster: - Identifier for the globalCluster.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "onGlobalCluster", [global_cluster, account, partition])

    @jsii.member(jsii_name="onOg")
    def on_og(
        self,
        option_group_name: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Rds":
        """Adds a resource of type og to the statement.

        https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_WorkingWithOptionGroups.html

        :param option_group_name: - Identifier for the optionGroupName.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``. Possible conditions: - .ifAwsResourceTag() - .ifOgTag()

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "onOg", [option_group_name, account, region, partition])

    @jsii.member(jsii_name="onPg")
    def on_pg(
        self,
        parameter_group_name: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Rds":
        """Adds a resource of type pg to the statement.

        https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_WorkingWithParamGroups.html

        :param parameter_group_name: - Identifier for the parameterGroupName.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``. Possible conditions: - .ifAwsResourceTag() - .ifPgTag()

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "onPg", [parameter_group_name, account, region, partition])

    @jsii.member(jsii_name="onProxy")
    def on_proxy(
        self,
        db_proxy_id: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Rds":
        """Adds a resource of type proxy to the statement.

        https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Overview.DBProxy.html

        :param db_proxy_id: - Identifier for the dbProxyId.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``. Possible conditions: - .ifAwsResourceTag()

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "onProxy", [db_proxy_id, account, region, partition])

    @jsii.member(jsii_name="onRi")
    def on_ri(
        self,
        reserved_db_instance_name: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Rds":
        """Adds a resource of type ri to the statement.

        https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_WorkingWithReservedDBInstances.html

        :param reserved_db_instance_name: - Identifier for the reservedDbInstanceName.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``. Possible conditions: - .ifAwsResourceTag() - .ifRiTag()

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "onRi", [reserved_db_instance_name, account, region, partition])

    @jsii.member(jsii_name="onSecgrp")
    def on_secgrp(
        self,
        security_group_name: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Rds":
        """Adds a resource of type secgrp to the statement.

        https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_WorkingWithSecurityGroups.html

        :param security_group_name: - Identifier for the securityGroupName.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``. Possible conditions: - .ifAwsResourceTag() - .ifSecgrpTag()

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "onSecgrp", [security_group_name, account, region, partition])

    @jsii.member(jsii_name="onSnapshot")
    def on_snapshot(
        self,
        snapshot_name: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Rds":
        """Adds a resource of type snapshot to the statement.

        https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_WorkingWithAutomatedBackups.html

        :param snapshot_name: - Identifier for the snapshotName.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``. Possible conditions: - .ifAwsResourceTag() - .ifSnapshotTag()

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "onSnapshot", [snapshot_name, account, region, partition])

    @jsii.member(jsii_name="onSubgrp")
    def on_subgrp(
        self,
        subnet_group_name: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Rds":
        """Adds a resource of type subgrp to the statement.

        https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_VPC.Scenarios.html#USER_VPC.Scenario1

        :param subnet_group_name: - Identifier for the subnetGroupName.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``. Possible conditions: - .ifAwsResourceTag() - .ifSubgrpTag()

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "onSubgrp", [subnet_group_name, account, region, partition])

    @jsii.member(jsii_name="onTarget")
    def on_target(
        self,
        target_id: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Rds":
        """Adds a resource of type target to the statement.

        https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Overview.DBProxy.html

        :param target_id: - Identifier for the targetId.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "onTarget", [target_id, account, region, partition])

    @jsii.member(jsii_name="onTargetGroup")
    def on_target_group(
        self,
        target_group_id: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Rds":
        """Adds a resource of type target-group to the statement.

        https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Overview.DBProxy.html

        :param target_group_id: - Identifier for the targetGroupId.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``. Possible conditions: - .ifAwsResourceTag()

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "onTargetGroup", [target_group_id, account, region, partition])

    @jsii.member(jsii_name="toAddRoleToDBCluster")
    def to_add_role_to_db_cluster(self) -> "Rds":
        """Grants permission to associate an Identity and Access Management (IAM) role from an Aurora DB cluster.

        Access Level: Write

        Dependent actions:

        - iam:PassRole

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_AddRoleToDBCluster.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toAddRoleToDBCluster", [])

    @jsii.member(jsii_name="toAddRoleToDBInstance")
    def to_add_role_to_db_instance(self) -> "Rds":
        """Grants permission to associate an AWS Identity and Access Management (IAM) role with a DB instance.

        Access Level: Write

        Dependent actions:

        - iam:PassRole

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_AddRoleToDBInstance.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toAddRoleToDBInstance", [])

    @jsii.member(jsii_name="toAddSourceIdentifierToSubscription")
    def to_add_source_identifier_to_subscription(self) -> "Rds":
        """Grants permission to add a source identifier to an existing RDS event notification subscription.

        Access Level: Write

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_AddSourceIdentifierToSubscription.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toAddSourceIdentifierToSubscription", [])

    @jsii.member(jsii_name="toAddTagsToResource")
    def to_add_tags_to_resource(self) -> "Rds":
        """Grants permission to add metadata tags to an Amazon RDS resource.

        Access Level: Tagging

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsTagKeys()
        - .ifReqTag()

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_AddTagsToResource.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toAddTagsToResource", [])

    @jsii.member(jsii_name="toApplyPendingMaintenanceAction")
    def to_apply_pending_maintenance_action(self) -> "Rds":
        """Grants permission to apply a pending maintenance action to a resource.

        Access Level: Write

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_ApplyPendingMaintenanceAction.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toApplyPendingMaintenanceAction", [])

    @jsii.member(jsii_name="toAuthorizeDBSecurityGroupIngress")
    def to_authorize_db_security_group_ingress(self) -> "Rds":
        """Grants permission to enable ingress to a DBSecurityGroup using one of two forms of authorization.

        Access Level: Permissions management

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_AuthorizeDBSecurityGroupIngress.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toAuthorizeDBSecurityGroupIngress", [])

    @jsii.member(jsii_name="toBacktrackDBCluster")
    def to_backtrack_db_cluster(self) -> "Rds":
        """Grants permission to backtrack a DB cluster to a specific time, without creating a new DB cluster.

        Access Level: Write

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_BacktrackDBCluster.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toBacktrackDBCluster", [])

    @jsii.member(jsii_name="toCancelExportTask")
    def to_cancel_export_task(self) -> "Rds":
        """Grants permission to cancel an export task in progress.

        Access Level: Write

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_CancelExportTask.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toCancelExportTask", [])

    @jsii.member(jsii_name="toCopyDBClusterParameterGroup")
    def to_copy_db_cluster_parameter_group(self) -> "Rds":
        """Grants permission to copy the specified DB cluster parameter group.

        Access Level: Write

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsTagKeys()

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_CopyDBClusterParameterGroup.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toCopyDBClusterParameterGroup", [])

    @jsii.member(jsii_name="toCopyDBClusterSnapshot")
    def to_copy_db_cluster_snapshot(self) -> "Rds":
        """Grants permission to create a snapshot of a DB cluster.

        Access Level: Write

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsTagKeys()

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_CopyDBClusterSnapshot.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toCopyDBClusterSnapshot", [])

    @jsii.member(jsii_name="toCopyDBParameterGroup")
    def to_copy_db_parameter_group(self) -> "Rds":
        """Grants permission to copy the specified DB parameter group.

        Access Level: Write

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsTagKeys()

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_CopyDBParameterGroup.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toCopyDBParameterGroup", [])

    @jsii.member(jsii_name="toCopyDBSnapshot")
    def to_copy_db_snapshot(self) -> "Rds":
        """Grants permission to copy the specified DB snapshot.

        Access Level: Write

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsTagKeys()

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_CopyDBSnapshot.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toCopyDBSnapshot", [])

    @jsii.member(jsii_name="toCopyOptionGroup")
    def to_copy_option_group(self) -> "Rds":
        """Grants permission to copy the specified option group.

        Access Level: Write

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsTagKeys()

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_CopyOptionGroup.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toCopyOptionGroup", [])

    @jsii.member(jsii_name="toCreateDBCluster")
    def to_create_db_cluster(self) -> "Rds":
        """Grants permission to create a new Amazon Aurora DB cluster.

        Access Level: Write

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsTagKeys()
        - .ifReqTag()
        - .ifDatabaseEngine()
        - .ifDatabaseName()
        - .ifStorageEncrypted()

        Dependent actions:

        - iam:PassRole

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_CreateDBCluster.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toCreateDBCluster", [])

    @jsii.member(jsii_name="toCreateDBClusterEndpoint")
    def to_create_db_cluster_endpoint(self) -> "Rds":
        """Grants permission to create a new custom endpoint and associates it with an Amazon Aurora DB cluster.

        Access Level: Write

        Possible conditions:

        - .ifEndpointType()
        - .ifAwsRequestTag()
        - .ifAwsTagKeys()

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_CreateDBClusterEndpoint.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toCreateDBClusterEndpoint", [])

    @jsii.member(jsii_name="toCreateDBClusterParameterGroup")
    def to_create_db_cluster_parameter_group(self) -> "Rds":
        """Grants permission to create a new DB cluster parameter group.

        Access Level: Write

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsTagKeys()
        - .ifReqTag()

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_CreateDBClusterParameterGroup.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toCreateDBClusterParameterGroup", [])

    @jsii.member(jsii_name="toCreateDBClusterSnapshot")
    def to_create_db_cluster_snapshot(self) -> "Rds":
        """Grants permission to create a snapshot of a DB cluster.

        Access Level: Write

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsTagKeys()
        - .ifReqTag()

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_CreateDBClusterSnapshot.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toCreateDBClusterSnapshot", [])

    @jsii.member(jsii_name="toCreateDBInstance")
    def to_create_db_instance(self) -> "Rds":
        """Grants permission to create a new DB instance.

        Access Level: Write

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsTagKeys()
        - .ifReqTag()

        Dependent actions:

        - iam:PassRole

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_CreateDBInstance.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toCreateDBInstance", [])

    @jsii.member(jsii_name="toCreateDBInstanceReadReplica")
    def to_create_db_instance_read_replica(self) -> "Rds":
        """Grants permission to create a DB instance that acts as a Read Replica of a source DB instance.

        Access Level: Write

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsTagKeys()
        - .ifReqTag()

        Dependent actions:

        - iam:PassRole

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_CreateDBInstanceReadReplica.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toCreateDBInstanceReadReplica", [])

    @jsii.member(jsii_name="toCreateDBParameterGroup")
    def to_create_db_parameter_group(self) -> "Rds":
        """Grants permission to create a new DB parameter group.

        Access Level: Write

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsTagKeys()
        - .ifReqTag()

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_CreateDBParameterGroup.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toCreateDBParameterGroup", [])

    @jsii.member(jsii_name="toCreateDBProxy")
    def to_create_db_proxy(self) -> "Rds":
        """Grants permission to create a database proxy.

        Access Level: Write

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsTagKeys()

        Dependent actions:

        - iam:PassRole

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_CreateDBProxy.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toCreateDBProxy", [])

    @jsii.member(jsii_name="toCreateDBSecurityGroup")
    def to_create_db_security_group(self) -> "Rds":
        """Grants permission to create a new DB security group. DB security groups control access to a DB instance.

        Access Level: Write

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsTagKeys()
        - .ifReqTag()

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_CreateDBSecurityGroup.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toCreateDBSecurityGroup", [])

    @jsii.member(jsii_name="toCreateDBSnapshot")
    def to_create_db_snapshot(self) -> "Rds":
        """Grants permission to create a DBSnapshot.

        Access Level: Write

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsTagKeys()
        - .ifReqTag()

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_CreateDBSnapshot.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toCreateDBSnapshot", [])

    @jsii.member(jsii_name="toCreateDBSubnetGroup")
    def to_create_db_subnet_group(self) -> "Rds":
        """Grants permission to create a new DB subnet group.

        Access Level: Write

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsTagKeys()
        - .ifReqTag()

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_CreateDBSubnetGroup.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toCreateDBSubnetGroup", [])

    @jsii.member(jsii_name="toCreateEventSubscription")
    def to_create_event_subscription(self) -> "Rds":
        """Grants permission to create an RDS event notification subscription.

        Access Level: Write

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsTagKeys()
        - .ifReqTag()

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_CreateEventSubscription.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toCreateEventSubscription", [])

    @jsii.member(jsii_name="toCreateGlobalCluster")
    def to_create_global_cluster(self) -> "Rds":
        """Grants permission to create an Aurora global database spread across multiple regions.

        Access Level: Write

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_CreateGlobalCluster.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toCreateGlobalCluster", [])

    @jsii.member(jsii_name="toCreateOptionGroup")
    def to_create_option_group(self) -> "Rds":
        """Grants permission to create a new option group.

        Access Level: Write

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsTagKeys()
        - .ifReqTag()

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_CreateOptionGroup.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toCreateOptionGroup", [])

    @jsii.member(jsii_name="toCrossRegionCommunication")
    def to_cross_region_communication(self) -> "Rds":
        """Grants permission to access a resource in the remote Region when executing cross-Region operations, such as cross-Region snapshot copy or cross-Region read replica creation.

        Access Level: Write

        https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/security_iam_service-with-iam.html#UsingWithRDS.IAM.Conditions

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toCrossRegionCommunication", [])

    @jsii.member(jsii_name="toDeleteDBCluster")
    def to_delete_db_cluster(self) -> "Rds":
        """Grants permission to delete a previously provisioned DB cluster.

        Access Level: Write

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_DeleteDBCluster.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDeleteDBCluster", [])

    @jsii.member(jsii_name="toDeleteDBClusterEndpoint")
    def to_delete_db_cluster_endpoint(self) -> "Rds":
        """Grants permission to delete a custom endpoint and removes it from an Amazon Aurora DB cluster.

        Access Level: Write

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_DeleteDBClusterEndpoint.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDeleteDBClusterEndpoint", [])

    @jsii.member(jsii_name="toDeleteDBClusterParameterGroup")
    def to_delete_db_cluster_parameter_group(self) -> "Rds":
        """Grants permission to delete a specified DB cluster parameter group.

        Access Level: Write

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_DeleteDBClusterParameterGroup.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDeleteDBClusterParameterGroup", [])

    @jsii.member(jsii_name="toDeleteDBClusterSnapshot")
    def to_delete_db_cluster_snapshot(self) -> "Rds":
        """Grants permission to delete a DB cluster snapshot.

        Access Level: Write

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_DeleteDBClusterSnapshot.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDeleteDBClusterSnapshot", [])

    @jsii.member(jsii_name="toDeleteDBInstance")
    def to_delete_db_instance(self) -> "Rds":
        """Grants permission to delete a previously provisioned DB instance.

        Access Level: Write

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_DeleteDBInstance.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDeleteDBInstance", [])

    @jsii.member(jsii_name="toDeleteDBInstanceAutomatedBackup")
    def to_delete_db_instance_automated_backup(self) -> "Rds":
        """Grants permission to deletes automated backups based on the source instance's DbiResourceId value or the restorable instance's resource ID.

        Access Level: Write

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_DeleteDBInstanceAutomatedBackup.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDeleteDBInstanceAutomatedBackup", [])

    @jsii.member(jsii_name="toDeleteDBParameterGroup")
    def to_delete_db_parameter_group(self) -> "Rds":
        """Grants permission to delete a specified DBParameterGroup.

        Access Level: Write

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_DeleteDBParameterGroup.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDeleteDBParameterGroup", [])

    @jsii.member(jsii_name="toDeleteDBProxy")
    def to_delete_db_proxy(self) -> "Rds":
        """Grants permission to delete a database proxy.

        Access Level: Write

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_DeleteDBProxy.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDeleteDBProxy", [])

    @jsii.member(jsii_name="toDeleteDBSecurityGroup")
    def to_delete_db_security_group(self) -> "Rds":
        """Grants permission to delete a DB security group.

        Access Level: Write

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_DeleteDBSecurityGroup.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDeleteDBSecurityGroup", [])

    @jsii.member(jsii_name="toDeleteDBSnapshot")
    def to_delete_db_snapshot(self) -> "Rds":
        """Grants permission to delete a DBSnapshot.

        Access Level: Write

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_DeleteDBSnapshot.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDeleteDBSnapshot", [])

    @jsii.member(jsii_name="toDeleteDBSubnetGroup")
    def to_delete_db_subnet_group(self) -> "Rds":
        """Grants permission to delete a DB subnet group.

        Access Level: Write

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_DeleteDBSubnetGroup.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDeleteDBSubnetGroup", [])

    @jsii.member(jsii_name="toDeleteEventSubscription")
    def to_delete_event_subscription(self) -> "Rds":
        """Grants permission to delete an RDS event notification subscription.

        Access Level: Write

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_DeleteEventSubscription.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDeleteEventSubscription", [])

    @jsii.member(jsii_name="toDeleteGlobalCluster")
    def to_delete_global_cluster(self) -> "Rds":
        """Grants permission to delete a global database cluster.

        Access Level: Write

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_DeleteGlobalCluster.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDeleteGlobalCluster", [])

    @jsii.member(jsii_name="toDeleteOptionGroup")
    def to_delete_option_group(self) -> "Rds":
        """Grants permission to delete an existing option group.

        Access Level: Write

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_DeleteOptionGroup.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDeleteOptionGroup", [])

    @jsii.member(jsii_name="toDeregisterDBProxyTargets")
    def to_deregister_db_proxy_targets(self) -> "Rds":
        """Grants permission to remove targets from a database proxy target group.

        Access Level: Write

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_DeregisterDBProxyTargets.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDeregisterDBProxyTargets", [])

    @jsii.member(jsii_name="toDescribeAccountAttributes")
    def to_describe_account_attributes(self) -> "Rds":
        """Grants permission to list all of the attributes for a customer account.

        Access Level: List

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_DescribeAccountAttributes.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDescribeAccountAttributes", [])

    @jsii.member(jsii_name="toDescribeCertificates")
    def to_describe_certificates(self) -> "Rds":
        """Lists the set of CA certificates provided by Amazon RDS for this AWS account.

        Access Level: List

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_DescribeCertificates.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDescribeCertificates", [])

    @jsii.member(jsii_name="toDescribeDBClusterBacktracks")
    def to_describe_db_cluster_backtracks(self) -> "Rds":
        """Grants permission to return information about backtracks for a DB cluster.

        Access Level: List

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_DescribeDBClusterBacktracks.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDescribeDBClusterBacktracks", [])

    @jsii.member(jsii_name="toDescribeDBClusterEndpoints")
    def to_describe_db_cluster_endpoints(self) -> "Rds":
        """Grants permission to return information about endpoints for an Amazon Aurora DB cluster.

        Access Level: List

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_DescribeDBClusterEndpoints.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDescribeDBClusterEndpoints", [])

    @jsii.member(jsii_name="toDescribeDBClusterParameterGroups")
    def to_describe_db_cluster_parameter_groups(self) -> "Rds":
        """Grants permission to return a list of DBClusterParameterGroup descriptions.

        Access Level: List

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_DescribeDBClusterParameterGroups.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDescribeDBClusterParameterGroups", [])

    @jsii.member(jsii_name="toDescribeDBClusterParameters")
    def to_describe_db_cluster_parameters(self) -> "Rds":
        """Grants permission to return the detailed parameter list for a particular DB cluster parameter group.

        Access Level: List

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_DescribeDBClusterParameters.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDescribeDBClusterParameters", [])

    @jsii.member(jsii_name="toDescribeDBClusters")
    def to_describe_db_clusters(self) -> "Rds":
        """Grants permission to return information about provisioned Aurora DB clusters.

        Access Level: List

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_DescribeDBClusters.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDescribeDBClusters", [])

    @jsii.member(jsii_name="toDescribeDBClusterSnapshotAttributes")
    def to_describe_db_cluster_snapshot_attributes(self) -> "Rds":
        """Grants permission to return a list of DB cluster snapshot attribute names and values for a manual DB cluster snapshot.

        Access Level: List

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_DescribeDBClusterSnapshotAttributes.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDescribeDBClusterSnapshotAttributes", [])

    @jsii.member(jsii_name="toDescribeDBClusterSnapshots")
    def to_describe_db_cluster_snapshots(self) -> "Rds":
        """Grants permission to return information about DB cluster snapshots.

        Access Level: List

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_DescribeDBClusterSnapshots.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDescribeDBClusterSnapshots", [])

    @jsii.member(jsii_name="toDescribeDBEngineVersions")
    def to_describe_db_engine_versions(self) -> "Rds":
        """Grants permission to return a list of the available DB engines.

        Access Level: List

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_DescribeDBEngineVersions.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDescribeDBEngineVersions", [])

    @jsii.member(jsii_name="toDescribeDBInstanceAutomatedBackups")
    def to_describe_db_instance_automated_backups(self) -> "Rds":
        """Grants permission to return a list of automated backups for both current and deleted instances.

        Access Level: List

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_DescribeDBInstanceAutomatedBackups.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDescribeDBInstanceAutomatedBackups", [])

    @jsii.member(jsii_name="toDescribeDBInstances")
    def to_describe_db_instances(self) -> "Rds":
        """Grants permission to return information about provisioned RDS instances.

        Access Level: List

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_DescribeDBInstances.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDescribeDBInstances", [])

    @jsii.member(jsii_name="toDescribeDBLogFiles")
    def to_describe_db_log_files(self) -> "Rds":
        """Grants permission to return a list of DB log files for the DB instance.

        Access Level: List

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_DescribeDBLogFiles.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDescribeDBLogFiles", [])

    @jsii.member(jsii_name="toDescribeDBParameterGroups")
    def to_describe_db_parameter_groups(self) -> "Rds":
        """Grants permission to return a list of DBParameterGroup descriptions.

        Access Level: List

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_DescribeDBParameterGroups.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDescribeDBParameterGroups", [])

    @jsii.member(jsii_name="toDescribeDBParameters")
    def to_describe_db_parameters(self) -> "Rds":
        """Grants permission to return the detailed parameter list for a particular DB parameter group.

        Access Level: List

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_DescribeDBParameters.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDescribeDBParameters", [])

    @jsii.member(jsii_name="toDescribeDBProxies")
    def to_describe_db_proxies(self) -> "Rds":
        """Grants permission to view proxies.

        Access Level: List

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_DescribeDBProxies.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDescribeDBProxies", [])

    @jsii.member(jsii_name="toDescribeDBProxyTargetGroups")
    def to_describe_db_proxy_target_groups(self) -> "Rds":
        """Grants permission to view database proxy target group details.

        Access Level: List

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_DescribeDBProxyTargetGroups.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDescribeDBProxyTargetGroups", [])

    @jsii.member(jsii_name="toDescribeDBProxyTargets")
    def to_describe_db_proxy_targets(self) -> "Rds":
        """Grants permission to view database proxy target details.

        Access Level: List

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_DescribeDBProxyTargets.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDescribeDBProxyTargets", [])

    @jsii.member(jsii_name="toDescribeDBSecurityGroups")
    def to_describe_db_security_groups(self) -> "Rds":
        """Grants permission to return a list of DBSecurityGroup descriptions.

        Access Level: List

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_DescribeDBSecurityGroups.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDescribeDBSecurityGroups", [])

    @jsii.member(jsii_name="toDescribeDBSnapshotAttributes")
    def to_describe_db_snapshot_attributes(self) -> "Rds":
        """Grants permission to return a list of DB snapshot attribute names and values for a manual DB snapshot.

        Access Level: List

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_DescribeDBSnapshotAttributes.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDescribeDBSnapshotAttributes", [])

    @jsii.member(jsii_name="toDescribeDBSnapshots")
    def to_describe_db_snapshots(self) -> "Rds":
        """Grants permission to return information about DB snapshots.

        Access Level: List

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_DescribeDBSnapshots.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDescribeDBSnapshots", [])

    @jsii.member(jsii_name="toDescribeDBSubnetGroups")
    def to_describe_db_subnet_groups(self) -> "Rds":
        """Grants permission to return a list of DBSubnetGroup descriptions.

        Access Level: List

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_DescribeDBSubnetGroups.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDescribeDBSubnetGroups", [])

    @jsii.member(jsii_name="toDescribeEngineDefaultClusterParameters")
    def to_describe_engine_default_cluster_parameters(self) -> "Rds":
        """Grants permission to return the default engine and system parameter information for the cluster database engine.

        Access Level: List

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_DescribeEngineDefaultClusterParameters.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDescribeEngineDefaultClusterParameters", [])

    @jsii.member(jsii_name="toDescribeEngineDefaultParameters")
    def to_describe_engine_default_parameters(self) -> "Rds":
        """Grants permission to return the default engine and system parameter information for the specified database engine.

        Access Level: List

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_DescribeEngineDefaultParameters.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDescribeEngineDefaultParameters", [])

    @jsii.member(jsii_name="toDescribeEventCategories")
    def to_describe_event_categories(self) -> "Rds":
        """Grants permission to display a list of categories for all event source types, or, if specified, for a specified source type.

        Access Level: List

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_DescribeEventCategories.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDescribeEventCategories", [])

    @jsii.member(jsii_name="toDescribeEvents")
    def to_describe_events(self) -> "Rds":
        """Grants permission to return events related to DB instances, DB security groups, DB snapshots, and DB parameter groups for the past 14 days.

        Access Level: List

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_DescribeEvents.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDescribeEvents", [])

    @jsii.member(jsii_name="toDescribeEventSubscriptions")
    def to_describe_event_subscriptions(self) -> "Rds":
        """Grants permission to list all the subscription descriptions for a customer account.

        Access Level: List

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_DescribeEventSubscriptions.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDescribeEventSubscriptions", [])

    @jsii.member(jsii_name="toDescribeExportTasks")
    def to_describe_export_tasks(self) -> "Rds":
        """Grants permission to return information about the export tasks.

        Access Level: List

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_DescribeExportTasks.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDescribeExportTasks", [])

    @jsii.member(jsii_name="toDescribeGlobalClusters")
    def to_describe_global_clusters(self) -> "Rds":
        """Grants permission to return information about Aurora global database clusters.

        Access Level: List

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_DescribeGlobalClusters.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDescribeGlobalClusters", [])

    @jsii.member(jsii_name="toDescribeOptionGroupOptions")
    def to_describe_option_group_options(self) -> "Rds":
        """Grants permission to describe all available options.

        Access Level: List

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_DescribeOptionGroupOptions.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDescribeOptionGroupOptions", [])

    @jsii.member(jsii_name="toDescribeOptionGroups")
    def to_describe_option_groups(self) -> "Rds":
        """Grants permission to describe the available option groups.

        Access Level: List

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_DescribeOptionGroups.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDescribeOptionGroups", [])

    @jsii.member(jsii_name="toDescribeOrderableDBInstanceOptions")
    def to_describe_orderable_db_instance_options(self) -> "Rds":
        """Grants permission to return a list of orderable DB instance options for the specified engine.

        Access Level: List

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_DescribeOrderableDBInstanceOptions.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDescribeOrderableDBInstanceOptions", [])

    @jsii.member(jsii_name="toDescribePendingMaintenanceActions")
    def to_describe_pending_maintenance_actions(self) -> "Rds":
        """Grants permission to return a list of resources (for example, DB instances) that have at least one pending maintenance action.

        Access Level: List

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_DescribePendingMaintenanceActions.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDescribePendingMaintenanceActions", [])

    @jsii.member(jsii_name="toDescribeReservedDBInstances")
    def to_describe_reserved_db_instances(self) -> "Rds":
        """Grants permission to return information about reserved DB instances for this account, or about a specified reserved DB instance.

        Access Level: List

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_DescribeReservedDBInstances.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDescribeReservedDBInstances", [])

    @jsii.member(jsii_name="toDescribeReservedDBInstancesOfferings")
    def to_describe_reserved_db_instances_offerings(self) -> "Rds":
        """Grants permission to list available reserved DB instance offerings.

        Access Level: List

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_DescribeReservedDBInstancesOfferings.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDescribeReservedDBInstancesOfferings", [])

    @jsii.member(jsii_name="toDescribeSourceRegions")
    def to_describe_source_regions(self) -> "Rds":
        """Grants permission to return a list of the source AWS Regions where the current AWS Region can create a Read Replica or copy a DB snapshot from.

        Access Level: List

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_DescribeSourceRegions.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDescribeSourceRegions", [])

    @jsii.member(jsii_name="toDescribeValidDBInstanceModifications")
    def to_describe_valid_db_instance_modifications(self) -> "Rds":
        """Grants permission to list available modifications you can make to your DB instance.

        Access Level: List

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_DescribeValidDBInstanceModifications.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDescribeValidDBInstanceModifications", [])

    @jsii.member(jsii_name="toDownloadDBLogFilePortion")
    def to_download_db_log_file_portion(self) -> "Rds":
        """Grants permission to download all or a portion of the specified log file, up to 1 MB in size.

        Access Level: Read

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_DownloadDBLogFilePortion.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDownloadDBLogFilePortion", [])

    @jsii.member(jsii_name="toFailoverDBCluster")
    def to_failover_db_cluster(self) -> "Rds":
        """Grants permission to force a failover for a DB cluster.

        Access Level: Write

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_FailoverDBCluster.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toFailoverDBCluster", [])

    @jsii.member(jsii_name="toListTagsForResource")
    def to_list_tags_for_resource(self) -> "Rds":
        """Grants permission to list all tags on an Amazon RDS resource.

        Access Level: Read

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_ListTagsForResource.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toListTagsForResource", [])

    @jsii.member(jsii_name="toModifyCurrentDBClusterCapacity")
    def to_modify_current_db_cluster_capacity(self) -> "Rds":
        """Grants permission to modify current cluster capacity for an Amazon Aurora Severless DB cluster.

        Access Level: Write

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_ModifyCurrentDBClusterCapacity.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toModifyCurrentDBClusterCapacity", [])

    @jsii.member(jsii_name="toModifyDBCluster")
    def to_modify_db_cluster(self) -> "Rds":
        """Grants permission to modify a setting for an Amazon Aurora DB cluster.

        Access Level: Write

        Dependent actions:

        - iam:PassRole

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_ModifyDBCluster.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toModifyDBCluster", [])

    @jsii.member(jsii_name="toModifyDBClusterEndpoint")
    def to_modify_db_cluster_endpoint(self) -> "Rds":
        """Grants permission to modify the properties of an endpoint in an Amazon Aurora DB cluster.

        Access Level: Write

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_ModifyDBClusterEndpoint.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toModifyDBClusterEndpoint", [])

    @jsii.member(jsii_name="toModifyDBClusterParameterGroup")
    def to_modify_db_cluster_parameter_group(self) -> "Rds":
        """Grants permission to modify the parameters of a DB cluster parameter group.

        Access Level: Write

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_ModifyDBClusterParameterGroup.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toModifyDBClusterParameterGroup", [])

    @jsii.member(jsii_name="toModifyDBClusterSnapshotAttribute")
    def to_modify_db_cluster_snapshot_attribute(self) -> "Rds":
        """Grants permission to add an attribute and values to, or removes an attribute and values from, a manual DB cluster snapshot.

        Access Level: Write

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_ModifyDBClusterSnapshotAttribute.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toModifyDBClusterSnapshotAttribute", [])

    @jsii.member(jsii_name="toModifyDBInstance")
    def to_modify_db_instance(self) -> "Rds":
        """Grants permission to modify settings for a DB instance.

        Access Level: Write

        Dependent actions:

        - iam:PassRole

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_ModifyDBInstance.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toModifyDBInstance", [])

    @jsii.member(jsii_name="toModifyDBParameterGroup")
    def to_modify_db_parameter_group(self) -> "Rds":
        """Grants permission to modify the parameters of a DB parameter group.

        Access Level: Write

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_ModifyDBParameterGroup.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toModifyDBParameterGroup", [])

    @jsii.member(jsii_name="toModifyDBProxy")
    def to_modify_db_proxy(self) -> "Rds":
        """Grants permission to modify database proxy.

        Access Level: Write

        Dependent actions:

        - iam:PassRole

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_ModifyDBProxy.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toModifyDBProxy", [])

    @jsii.member(jsii_name="toModifyDBProxyTargetGroup")
    def to_modify_db_proxy_target_group(self) -> "Rds":
        """Grants permission to modify target group for a database proxy.

        Access Level: Write

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_ModifyDBProxyTargetGroup.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toModifyDBProxyTargetGroup", [])

    @jsii.member(jsii_name="toModifyDBSnapshot")
    def to_modify_db_snapshot(self) -> "Rds":
        """Grants permission to update a manual DB snapshot, which can be encrypted or not encrypted, with a new engine version.

        Access Level: Write

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_ModifyDBSnapshot.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toModifyDBSnapshot", [])

    @jsii.member(jsii_name="toModifyDBSnapshotAttribute")
    def to_modify_db_snapshot_attribute(self) -> "Rds":
        """Grants permission to add an attribute and values to, or removes an attribute and values from, a manual DB snapshot.

        Access Level: Write

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_ModifyDBSnapshotAttribute.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toModifyDBSnapshotAttribute", [])

    @jsii.member(jsii_name="toModifyDBSubnetGroup")
    def to_modify_db_subnet_group(self) -> "Rds":
        """Grants permission to modify an existing DB subnet group.

        Access Level: Write

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_ModifyDBSubnetGroup.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toModifyDBSubnetGroup", [])

    @jsii.member(jsii_name="toModifyEventSubscription")
    def to_modify_event_subscription(self) -> "Rds":
        """Grants permission to modify an existing RDS event notification subscription.

        Access Level: Write

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_ModifyEventSubscription.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toModifyEventSubscription", [])

    @jsii.member(jsii_name="toModifyGlobalCluster")
    def to_modify_global_cluster(self) -> "Rds":
        """Grants permission to modify a setting for an Amazon Aurora global cluster.

        Access Level: Write

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_ModifyGlobalCluster.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toModifyGlobalCluster", [])

    @jsii.member(jsii_name="toModifyOptionGroup")
    def to_modify_option_group(self) -> "Rds":
        """Grants permission to modify an existing option group.

        Access Level: Write

        Dependent actions:

        - iam:PassRole

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_ModifyOptionGroup.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toModifyOptionGroup", [])

    @jsii.member(jsii_name="toPromoteReadReplica")
    def to_promote_read_replica(self) -> "Rds":
        """Grants permission to promote a Read Replica DB instance to a standalone DB instance.

        Access Level: Write

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_PromoteReadReplica.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toPromoteReadReplica", [])

    @jsii.member(jsii_name="toPromoteReadReplicaDBCluster")
    def to_promote_read_replica_db_cluster(self) -> "Rds":
        """Grants permission to promote a Read Replica DB cluster to a standalone DB cluster.

        Access Level: Write

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_PromoteReadReplicaDBCluster.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toPromoteReadReplicaDBCluster", [])

    @jsii.member(jsii_name="toPurchaseReservedDBInstancesOffering")
    def to_purchase_reserved_db_instances_offering(self) -> "Rds":
        """Grants permission to purchase a reserved DB instance offering.

        Access Level: Write

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsTagKeys()

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_PurchaseReservedDBInstancesOffering.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toPurchaseReservedDBInstancesOffering", [])

    @jsii.member(jsii_name="toRebootDBInstance")
    def to_reboot_db_instance(self) -> "Rds":
        """Grants permission to restart the database engine service.

        Access Level: Write

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_RebootDBInstance.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toRebootDBInstance", [])

    @jsii.member(jsii_name="toRegisterDBProxyTargets")
    def to_register_db_proxy_targets(self) -> "Rds":
        """Grants permission to add targets to a database proxy target group.

        Access Level: Write

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_RegisterDBProxyTargets.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toRegisterDBProxyTargets", [])

    @jsii.member(jsii_name="toRemoveFromGlobalCluster")
    def to_remove_from_global_cluster(self) -> "Rds":
        """Grants permission to detach an Aurora secondary cluster from an Aurora global database cluster.

        Access Level: Write

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_RemoveFromGlobalCluster.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toRemoveFromGlobalCluster", [])

    @jsii.member(jsii_name="toRemoveRoleFromDBCluster")
    def to_remove_role_from_db_cluster(self) -> "Rds":
        """Grants permission to disassociate an AWS Identity and Access Management (IAM) role from an Amazon Aurora DB cluster.

        Access Level: Write

        Dependent actions:

        - iam:PassRole

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_RemoveRoleFromDBCluster.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toRemoveRoleFromDBCluster", [])

    @jsii.member(jsii_name="toRemoveRoleFromDBInstance")
    def to_remove_role_from_db_instance(self) -> "Rds":
        """Grants permission to disassociate an AWS Identity and Access Management (IAM) role from a DB instance.

        Access Level: Write

        Dependent actions:

        - iam:PassRole

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_RemoveRoleFromDBInstance.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toRemoveRoleFromDBInstance", [])

    @jsii.member(jsii_name="toRemoveSourceIdentifierFromSubscription")
    def to_remove_source_identifier_from_subscription(self) -> "Rds":
        """Grants permission to remove a source identifier from an existing RDS event notification subscription.

        Access Level: Write

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_RemoveSourceIdentifierFromSubscription.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toRemoveSourceIdentifierFromSubscription", [])

    @jsii.member(jsii_name="toRemoveTagsFromResource")
    def to_remove_tags_from_resource(self) -> "Rds":
        """Grants permission to remove metadata tags from an Amazon RDS resource.

        Access Level: Tagging

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsTagKeys()
        - .ifReqTag()

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_RemoveTagsFromResource.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toRemoveTagsFromResource", [])

    @jsii.member(jsii_name="toResetDBClusterParameterGroup")
    def to_reset_db_cluster_parameter_group(self) -> "Rds":
        """Grants permission to modify the parameters of a DB cluster parameter group to the default value.

        Access Level: Write

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_ResetDBClusterParameterGroup.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toResetDBClusterParameterGroup", [])

    @jsii.member(jsii_name="toResetDBParameterGroup")
    def to_reset_db_parameter_group(self) -> "Rds":
        """Grants permission to modify the parameters of a DB parameter group to the engine/system default value.

        Access Level: Write

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_ResetDBParameterGroup.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toResetDBParameterGroup", [])

    @jsii.member(jsii_name="toRestoreDBClusterFromS3")
    def to_restore_db_cluster_from_s3(self) -> "Rds":
        """Grants permission to create an Amazon Aurora DB cluster from data stored in an Amazon S3 bucket.

        Access Level: Write

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsTagKeys()
        - .ifReqTag()
        - .ifDatabaseEngine()
        - .ifDatabaseName()
        - .ifStorageEncrypted()

        Dependent actions:

        - iam:PassRole

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_RestoreDBClusterFromS3.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toRestoreDBClusterFromS3", [])

    @jsii.member(jsii_name="toRestoreDBClusterFromSnapshot")
    def to_restore_db_cluster_from_snapshot(self) -> "Rds":
        """Grants permission to create a new DB cluster from a DB cluster snapshot.

        Access Level: Write

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsTagKeys()
        - .ifReqTag()

        Dependent actions:

        - iam:PassRole

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_RestoreDBClusterFromSnapshot.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toRestoreDBClusterFromSnapshot", [])

    @jsii.member(jsii_name="toRestoreDBClusterToPointInTime")
    def to_restore_db_cluster_to_point_in_time(self) -> "Rds":
        """Grants permission to restore a DB cluster to an arbitrary point in time.

        Access Level: Write

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsTagKeys()
        - .ifReqTag()

        Dependent actions:

        - iam:PassRole

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_RestoreDBClusterToPointInTime.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toRestoreDBClusterToPointInTime", [])

    @jsii.member(jsii_name="toRestoreDBInstanceFromDBSnapshot")
    def to_restore_db_instance_from_db_snapshot(self) -> "Rds":
        """Grants permission to create a new DB instance from a DB snapshot.

        Access Level: Write

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsTagKeys()
        - .ifReqTag()

        Dependent actions:

        - iam:PassRole

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_RestoreDBInstanceFromDBSnapshot.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toRestoreDBInstanceFromDBSnapshot", [])

    @jsii.member(jsii_name="toRestoreDBInstanceFromS3")
    def to_restore_db_instance_from_s3(self) -> "Rds":
        """Grants permission to create a new DB instance from an Amazon S3 bucket.

        Access Level: Write

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsTagKeys()
        - .ifReqTag()

        Dependent actions:

        - iam:PassRole

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_RestoreDBInstanceFromS3.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toRestoreDBInstanceFromS3", [])

    @jsii.member(jsii_name="toRestoreDBInstanceToPointInTime")
    def to_restore_db_instance_to_point_in_time(self) -> "Rds":
        """Grants permission to restore a DB instance to an arbitrary point in time.

        Access Level: Write

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsTagKeys()
        - .ifReqTag()

        Dependent actions:

        - iam:PassRole

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_RestoreDBInstanceToPointInTime.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toRestoreDBInstanceToPointInTime", [])

    @jsii.member(jsii_name="toRevokeDBSecurityGroupIngress")
    def to_revoke_db_security_group_ingress(self) -> "Rds":
        """Grants permission to revoke ingress from a DBSecurityGroup for previously authorized IP ranges or EC2 or VPC Security Groups.

        Access Level: Write

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_RevokeDBSecurityGroupIngress.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toRevokeDBSecurityGroupIngress", [])

    @jsii.member(jsii_name="toStartActivityStream")
    def to_start_activity_stream(self) -> "Rds":
        """Grants permission to start Activity Stream.

        Access Level: Write

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_StartActivityStream.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toStartActivityStream", [])

    @jsii.member(jsii_name="toStartDBCluster")
    def to_start_db_cluster(self) -> "Rds":
        """Starts the DB cluster.

        Access Level: Write

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_StartDBCluster.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toStartDBCluster", [])

    @jsii.member(jsii_name="toStartDBInstance")
    def to_start_db_instance(self) -> "Rds":
        """Grants permission to start the DB instance.

        Access Level: Write

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_StartDBInstance.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toStartDBInstance", [])

    @jsii.member(jsii_name="toStartExportTask")
    def to_start_export_task(self) -> "Rds":
        """Grants permission to start a new Export task for a DB snapshot.

        Access Level: Write

        Dependent actions:

        - iam:PassRole

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_StartExportTask.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toStartExportTask", [])

    @jsii.member(jsii_name="toStopActivityStream")
    def to_stop_activity_stream(self) -> "Rds":
        """Grants permission to stop Activity Stream.

        Access Level: Write

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_StopActivityStream.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toStopActivityStream", [])

    @jsii.member(jsii_name="toStopDBCluster")
    def to_stop_db_cluster(self) -> "Rds":
        """Grants permission to stop the DB cluster.

        Access Level: Write

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_StopDBCluster.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toStopDBCluster", [])

    @jsii.member(jsii_name="toStopDBInstance")
    def to_stop_db_instance(self) -> "Rds":
        """Grants permission to stop the DB instance.

        Access Level: Write

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_StopDBInstance.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toStopDBInstance", [])

    @builtins.property # type: ignore
    @jsii.member(jsii_name="accessLevelList")
    def _access_level_list(self) -> "AccessLevelList":
        """
        stability
        :stability: experimental
        """
        return jsii.get(self, "accessLevelList")

    @_access_level_list.setter # type: ignore
    def _access_level_list(self, value: "AccessLevelList") -> None:
        jsii.set(self, "accessLevelList", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="servicePrefix")
    def service_prefix(self) -> builtins.str:
        """Holds the prefix of the service actions, e.g. ``ec2``.

        stability
        :stability: experimental
        """
        return jsii.get(self, "servicePrefix")

    @service_prefix.setter # type: ignore
    def service_prefix(self, value: builtins.str) -> None:
        jsii.set(self, "servicePrefix", value)


class RdsData(PolicyStatement, metaclass=jsii.JSIIMeta, jsii_type="iam-floyd.RdsData"):
    """Statement provider for service `rds-data <https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonrdsdataapi.html>`_.

    stability
    :stability: experimental
    """

    def __init__(self, sid: typing.Optional[builtins.str] = None) -> None:
        """Statement provider for service `rds-data <https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonrdsdataapi.html>`_.

        :param sid: `SID <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html>`_ of the statement.

        stability
        :stability: experimental
        """
        jsii.create(RdsData, self, [sid])

    @jsii.member(jsii_name="toBatchExecuteStatement")
    def to_batch_execute_statement(self) -> "RdsData":
        """Runs a batch SQL statement over an array of data.

        Access Level: Write

        https://docs.aws.amazon.com/rdsdataservice/latest/APIReference/API_BatchExecuteStatement.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toBatchExecuteStatement", [])

    @jsii.member(jsii_name="toBeginTransaction")
    def to_begin_transaction(self) -> "RdsData":
        """Starts a SQL transaction.

        Access Level: Write

        https://docs.aws.amazon.com/rdsdataservice/latest/APIReference/API_BeginTransaction.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toBeginTransaction", [])

    @jsii.member(jsii_name="toCommitTransaction")
    def to_commit_transaction(self) -> "RdsData":
        """Ends a SQL transaction started with the BeginTransaction operation and commits the changes.

        Access Level: Write

        Dependent actions:

        - rds-data:BeginTransaction

        https://docs.aws.amazon.com/rdsdataservice/latest/APIReference/API_CommitTransaction.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toCommitTransaction", [])

    @jsii.member(jsii_name="toExecuteSql")
    def to_execute_sql(self) -> "RdsData":
        """Runs one or more SQL statements. This operation is deprecated. Use the BatchExecuteStatement or ExecuteStatement operation.

        Access Level: Write

        https://docs.aws.amazon.com/rdsdataservice/latest/APIReference/API_ExecuteSql.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toExecuteSql", [])

    @jsii.member(jsii_name="toExecuteStatement")
    def to_execute_statement(self) -> "RdsData":
        """Runs a SQL statement against a database.

        Access Level: Write

        https://docs.aws.amazon.com/rdsdataservice/latest/APIReference/API_ExecuteStatement.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toExecuteStatement", [])

    @jsii.member(jsii_name="toRollbackTransaction")
    def to_rollback_transaction(self) -> "RdsData":
        """Performs a rollback of a transaction. Rolling back a transaction cancels its changes.

        Access Level: Write

        Dependent actions:

        - rds-data:BeginTransaction

        https://docs.aws.amazon.com/rdsdataservice/latest/APIReference/API_RollbackTransaction.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toRollbackTransaction", [])

    @builtins.property # type: ignore
    @jsii.member(jsii_name="accessLevelList")
    def _access_level_list(self) -> "AccessLevelList":
        """
        stability
        :stability: experimental
        """
        return jsii.get(self, "accessLevelList")

    @_access_level_list.setter # type: ignore
    def _access_level_list(self, value: "AccessLevelList") -> None:
        jsii.set(self, "accessLevelList", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="servicePrefix")
    def service_prefix(self) -> builtins.str:
        """Holds the prefix of the service actions, e.g. ``ec2``.

        stability
        :stability: experimental
        """
        return jsii.get(self, "servicePrefix")

    @service_prefix.setter # type: ignore
    def service_prefix(self, value: builtins.str) -> None:
        jsii.set(self, "servicePrefix", value)


class RdsDb(PolicyStatement, metaclass=jsii.JSIIMeta, jsii_type="iam-floyd.RdsDb"):
    """Statement provider for service `rds-db <https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonrdsiamauthentication.html>`_.

    stability
    :stability: experimental
    """

    def __init__(self, sid: typing.Optional[builtins.str] = None) -> None:
        """Statement provider for service `rds-db <https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonrdsiamauthentication.html>`_.

        :param sid: `SID <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html>`_ of the statement.

        stability
        :stability: experimental
        """
        jsii.create(RdsDb, self, [sid])

    @jsii.member(jsii_name="onDbUser")
    def on_db_user(
        self,
        dbi_resource_id: builtins.str,
        db_user_name: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "RdsDb":
        """Adds a resource of type db-user to the statement.

        https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.IAMDBAuth.DBAccounts.html

        :param dbi_resource_id: - Identifier for the dbiResourceId.
        :param db_user_name: - Identifier for the dbUserName.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "onDbUser", [dbi_resource_id, db_user_name, account, region, partition])

    @jsii.member(jsii_name="toconnect")
    def toconnect(self) -> "RdsDb":
        """Allows IAM role or user to connect to RDS database.

        Access Level: Permissions management

        https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.IAMDBAuth.IAMPolicy.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toconnect", [])

    @builtins.property # type: ignore
    @jsii.member(jsii_name="accessLevelList")
    def _access_level_list(self) -> "AccessLevelList":
        """
        stability
        :stability: experimental
        """
        return jsii.get(self, "accessLevelList")

    @_access_level_list.setter # type: ignore
    def _access_level_list(self, value: "AccessLevelList") -> None:
        jsii.set(self, "accessLevelList", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="servicePrefix")
    def service_prefix(self) -> builtins.str:
        """Holds the prefix of the service actions, e.g. ``ec2``.

        stability
        :stability: experimental
        """
        return jsii.get(self, "servicePrefix")

    @service_prefix.setter # type: ignore
    def service_prefix(self, value: builtins.str) -> None:
        jsii.set(self, "servicePrefix", value)


class Redshift(
    PolicyStatement,
    metaclass=jsii.JSIIMeta,
    jsii_type="iam-floyd.Redshift",
):
    """Statement provider for service `redshift <https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonredshift.html>`_.

    stability
    :stability: experimental
    """

    def __init__(self, sid: typing.Optional[builtins.str] = None) -> None:
        """Statement provider for service `redshift <https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonredshift.html>`_.

        :param sid: `SID <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html>`_ of the statement.

        stability
        :stability: experimental
        """
        jsii.create(Redshift, self, [sid])

    @jsii.member(jsii_name="ifDbName")
    def if_db_name(
        self,
        value: typing.Union[builtins.str, typing.List[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, "Operator"]] = None,
    ) -> "Redshift":
        """Filters access by the database name.

        https://docs.aws.amazon.com/redshift/latest/mgmt/redshift-iam-access-control-overview.html#redshift-policy-resources.conditions

        Applies to actions:

        - .toGetClusterCredentials()

        :param value: The value(s) to check.
        :param operator: Works with `string operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String>`_. **Default:** ``StringLike``.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "ifDbName", [value, operator])

    @jsii.member(jsii_name="ifDbUser")
    def if_db_user(
        self,
        value: typing.Union[builtins.str, typing.List[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, "Operator"]] = None,
    ) -> "Redshift":
        """Filters access by the database user name.

        https://docs.aws.amazon.com/redshift/latest/mgmt/redshift-iam-access-control-overview.html#redshift-policy-resources.conditions

        Applies to actions:

        - .toCreateClusterUser()
        - .toGetClusterCredentials()

        :param value: The value(s) to check.
        :param operator: Works with `string operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String>`_. **Default:** ``StringLike``.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "ifDbUser", [value, operator])

    @jsii.member(jsii_name="ifDurationSeconds")
    def if_duration_seconds(
        self,
        value: typing.Union[builtins.str, typing.List[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, "Operator"]] = None,
    ) -> "Redshift":
        """Filters access by the number of seconds until a temporary credential set expires.

        https://docs.aws.amazon.com/redshift/latest/mgmt/redshift-iam-access-control-overview.html#redshift-policy-resources.conditions

        Applies to actions:

        - .toGetClusterCredentials()

        :param value: The value(s) to check.
        :param operator: Works with `string operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String>`_. **Default:** ``StringLike``.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "ifDurationSeconds", [value, operator])

    @jsii.member(jsii_name="onCluster")
    def on_cluster(
        self,
        cluster_name: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Redshift":
        """Adds a resource of type cluster to the statement.

        https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html

        :param cluster_name: - Identifier for the clusterName.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``. Possible conditions: - .ifAwsResourceTag()

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "onCluster", [cluster_name, account, region, partition])

    @jsii.member(jsii_name="onDbgroup")
    def on_dbgroup(
        self,
        cluster_name: builtins.str,
        db_group: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Redshift":
        """Adds a resource of type dbgroup to the statement.

        https://docs.aws.amazon.com/redshift/latest/dg/r_CREATE_GROUP.html

        :param cluster_name: - Identifier for the clusterName.
        :param db_group: - Identifier for the dbGroup.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``. Possible conditions: - .ifAwsResourceTag()

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "onDbgroup", [cluster_name, db_group, account, region, partition])

    @jsii.member(jsii_name="onDbname")
    def on_dbname(
        self,
        cluster_name: builtins.str,
        db_name: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Redshift":
        """Adds a resource of type dbname to the statement.

        https://docs.aws.amazon.com/redshift/latest/dg/t_creating_database.html

        :param cluster_name: - Identifier for the clusterName.
        :param db_name: - Identifier for the dbName.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``. Possible conditions: - .ifAwsResourceTag()

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "onDbname", [cluster_name, db_name, account, region, partition])

    @jsii.member(jsii_name="onDbuser")
    def on_dbuser(
        self,
        cluster_name: builtins.str,
        db_user: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Redshift":
        """Adds a resource of type dbuser to the statement.

        https://docs.aws.amazon.com/redshift/latest/dg/r_Users.html

        :param cluster_name: - Identifier for the clusterName.
        :param db_user: - Identifier for the dbUser.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``. Possible conditions: - .ifAwsResourceTag()

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "onDbuser", [cluster_name, db_user, account, region, partition])

    @jsii.member(jsii_name="onEventsubscription")
    def on_eventsubscription(
        self,
        event_subscription_name: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Redshift":
        """Adds a resource of type eventsubscription to the statement.

        https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-events.html

        :param event_subscription_name: - Identifier for the eventSubscriptionName.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``. Possible conditions: - .ifAwsResourceTag()

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "onEventsubscription", [event_subscription_name, account, region, partition])

    @jsii.member(jsii_name="onHsmclientcertificate")
    def on_hsmclientcertificate(
        self,
        h_sm_client_certificate_id: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Redshift":
        """Adds a resource of type hsmclientcertificate to the statement.

        https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-db-encryption.html#working-with-HSM

        :param h_sm_client_certificate_id: - Identifier for the hSMClientCertificateId.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``. Possible conditions: - .ifAwsResourceTag()

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "onHsmclientcertificate", [h_sm_client_certificate_id, account, region, partition])

    @jsii.member(jsii_name="onHsmconfiguration")
    def on_hsmconfiguration(
        self,
        h_sm_configuration_id: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Redshift":
        """Adds a resource of type hsmconfiguration to the statement.

        https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-db-encryption.html#working-with-HSM

        :param h_sm_configuration_id: - Identifier for the hSMConfigurationId.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``. Possible conditions: - .ifAwsResourceTag()

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "onHsmconfiguration", [h_sm_configuration_id, account, region, partition])

    @jsii.member(jsii_name="onParametergroup")
    def on_parametergroup(
        self,
        parameter_group_name: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Redshift":
        """Adds a resource of type parametergroup to the statement.

        https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html

        :param parameter_group_name: - Identifier for the parameterGroupName.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``. Possible conditions: - .ifAwsResourceTag()

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "onParametergroup", [parameter_group_name, account, region, partition])

    @jsii.member(jsii_name="onSecuritygroup")
    def on_securitygroup(
        self,
        security_group_name: builtins.str,
        owner: builtins.str,
        ec2_security_group_id: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Redshift":
        """Adds a resource of type securitygroup to the statement.

        https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-security-groups.html

        :param security_group_name: - Identifier for the securityGroupName.
        :param owner: - Identifier for the owner.
        :param ec2_security_group_id: - Identifier for the ec2SecurityGroupId.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``. Possible conditions: - .ifAwsResourceTag()

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "onSecuritygroup", [security_group_name, owner, ec2_security_group_id, account, region, partition])

    @jsii.member(jsii_name="onSecuritygroupingressCidr")
    def on_securitygroupingress_cidr(
        self,
        security_group_name: builtins.str,
        ip_range: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Redshift":
        """Adds a resource of type securitygroupingress-cidr to the statement.

        https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-security-groups.html

        :param security_group_name: - Identifier for the securityGroupName.
        :param ip_range: - Identifier for the ipRange.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``. Possible conditions: - .ifAwsResourceTag()

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "onSecuritygroupingressCidr", [security_group_name, ip_range, account, region, partition])

    @jsii.member(jsii_name="onSecuritygroupingressEc2securitygroup")
    def on_securitygroupingress_ec2securitygroup(
        self,
        security_group_name: builtins.str,
        owner: builtins.str,
        ece2_securitygroup_id: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Redshift":
        """Adds a resource of type securitygroupingress-ec2securitygroup to the statement.

        https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-security-groups.html

        :param security_group_name: - Identifier for the securityGroupName.
        :param owner: - Identifier for the owner.
        :param ece2_securitygroup_id: - Identifier for the ece2SecuritygroupId.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``. Possible conditions: - .ifAwsResourceTag()

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "onSecuritygroupingressEc2securitygroup", [security_group_name, owner, ece2_securitygroup_id, account, region, partition])

    @jsii.member(jsii_name="onSnapshot")
    def on_snapshot(
        self,
        cluster_name: builtins.str,
        snapshot_name: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Redshift":
        """Adds a resource of type snapshot to the statement.

        https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-snapshots.html

        :param cluster_name: - Identifier for the clusterName.
        :param snapshot_name: - Identifier for the snapshotName.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``. Possible conditions: - .ifAwsResourceTag()

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "onSnapshot", [cluster_name, snapshot_name, account, region, partition])

    @jsii.member(jsii_name="onSnapshotcopygrant")
    def on_snapshotcopygrant(
        self,
        snapshot_copy_grant_name: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Redshift":
        """Adds a resource of type snapshotcopygrant to the statement.

        https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-db-encryption.html#configure-snapshot-copy-grant

        :param snapshot_copy_grant_name: - Identifier for the snapshotCopyGrantName.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``. Possible conditions: - .ifAwsResourceTag()

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "onSnapshotcopygrant", [snapshot_copy_grant_name, account, region, partition])

    @jsii.member(jsii_name="onSnapshotschedule")
    def on_snapshotschedule(
        self,
        parameter_group_name: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Redshift":
        """Adds a resource of type snapshotschedule to the statement.

        https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-snapshots.html

        :param parameter_group_name: - Identifier for the parameterGroupName.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``. Possible conditions: - .ifAwsResourceTag()

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "onSnapshotschedule", [parameter_group_name, account, region, partition])

    @jsii.member(jsii_name="onSubnetgroup")
    def on_subnetgroup(
        self,
        subnet_group_name: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Redshift":
        """Adds a resource of type subnetgroup to the statement.

        https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-cluster-subnet-groups.html

        :param subnet_group_name: - Identifier for the subnetGroupName.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``. Possible conditions: - .ifAwsResourceTag()

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "onSubnetgroup", [subnet_group_name, account, region, partition])

    @jsii.member(jsii_name="toAcceptReservedNodeExchange")
    def to_accept_reserved_node_exchange(self) -> "Redshift":
        """Grants permission to exchange a DC1 reserved node for a DC2 reserved node with no changes to the configuration.

        Access Level: Write

        https://docs.aws.amazon.com/redshift/latest/APIReference/API_AcceptReservedNodeExchange.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toAcceptReservedNodeExchange", [])

    @jsii.member(jsii_name="toAuthorizeClusterSecurityGroupIngress")
    def to_authorize_cluster_security_group_ingress(self) -> "Redshift":
        """Grants permission to add an inbound (ingress) rule to an Amazon Redshift security group.

        Access Level: Permissions management

        https://docs.aws.amazon.com/redshift/latest/APIReference/API_AuthorizeClusterSecurityGroupIngress.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toAuthorizeClusterSecurityGroupIngress", [])

    @jsii.member(jsii_name="toAuthorizeSnapshotAccess")
    def to_authorize_snapshot_access(self) -> "Redshift":
        """Grants permission to the specified AWS account to restore a snapshot.

        Access Level: Permissions management

        https://docs.aws.amazon.com/redshift/latest/APIReference/API_AuthorizeSnapshotAccess.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toAuthorizeSnapshotAccess", [])

    @jsii.member(jsii_name="toBatchDeleteClusterSnapshots")
    def to_batch_delete_cluster_snapshots(self) -> "Redshift":
        """Grants permission to delete snapshots in a batch of size upto 100.

        Access Level: Write

        https://docs.aws.amazon.com/redshift/latest/APIReference/API_BatchDeleteClusterSnapshots.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toBatchDeleteClusterSnapshots", [])

    @jsii.member(jsii_name="toBatchModifyClusterSnapshots")
    def to_batch_modify_cluster_snapshots(self) -> "Redshift":
        """Grants permission to modify settings for a list of snapshots.

        Access Level: Write

        https://docs.aws.amazon.com/redshift/latest/APIReference/API_BatchModifyClusterSnapshots.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toBatchModifyClusterSnapshots", [])

    @jsii.member(jsii_name="toCancelQuery")
    def to_cancel_query(self) -> "Redshift":
        """Grants permission to cancel a query through the Amazon Redshift console.

        Access Level: Write

        https://docs.aws.amazon.com/redshift/latest/mgmt/redshift-policy-resources.resource-permissions.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toCancelQuery", [])

    @jsii.member(jsii_name="toCancelQuerySession")
    def to_cancel_query_session(self) -> "Redshift":
        """Grants permission to see queries in the Amazon Redshift console.

        Access Level: Write

        https://docs.aws.amazon.com/redshift/latest/mgmt/redshift-policy-resources.resource-permissions.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toCancelQuerySession", [])

    @jsii.member(jsii_name="toCancelResize")
    def to_cancel_resize(self) -> "Redshift":
        """Grants permission to cancel a resize operation.

        Access Level: Write

        https://docs.aws.amazon.com/redshift/latest/APIReference/API_CancelResize.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toCancelResize", [])

    @jsii.member(jsii_name="toCopyClusterSnapshot")
    def to_copy_cluster_snapshot(self) -> "Redshift":
        """Grants permission to copy a cluster snapshot.

        Access Level: Write

        https://docs.aws.amazon.com/redshift/latest/APIReference/API_CopyClusterSnapshot.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toCopyClusterSnapshot", [])

    @jsii.member(jsii_name="toCreateCluster")
    def to_create_cluster(self) -> "Redshift":
        """Grants permission to create a cluster.

        Access Level: Write

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsTagKeys()

        https://docs.aws.amazon.com/redshift/latest/APIReference/API_CreateCluster.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toCreateCluster", [])

    @jsii.member(jsii_name="toCreateClusterParameterGroup")
    def to_create_cluster_parameter_group(self) -> "Redshift":
        """Grants permission to create an Amazon Redshift parameter group.

        Access Level: Write

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsTagKeys()

        https://docs.aws.amazon.com/redshift/latest/APIReference/API_CreateClusterParameterGroup.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toCreateClusterParameterGroup", [])

    @jsii.member(jsii_name="toCreateClusterSecurityGroup")
    def to_create_cluster_security_group(self) -> "Redshift":
        """Grants permission to create an Amazon Redshift security group.

        Access Level: Write

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsTagKeys()

        https://docs.aws.amazon.com/redshift/latest/APIReference/API_CreateClusterSecurityGroup.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toCreateClusterSecurityGroup", [])

    @jsii.member(jsii_name="toCreateClusterSnapshot")
    def to_create_cluster_snapshot(self) -> "Redshift":
        """Grants permission to create a manual snapshot of the specified cluster.

        Access Level: Write

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsTagKeys()

        https://docs.aws.amazon.com/redshift/latest/APIReference/API_CreateClusterSnapshot.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toCreateClusterSnapshot", [])

    @jsii.member(jsii_name="toCreateClusterSubnetGroup")
    def to_create_cluster_subnet_group(self) -> "Redshift":
        """Grants permission to create an Amazon Redshift subnet group.

        Access Level: Write

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsTagKeys()

        https://docs.aws.amazon.com/redshift/latest/APIReference/API_CreateClusterSubnetGroup.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toCreateClusterSubnetGroup", [])

    @jsii.member(jsii_name="toCreateClusterUser")
    def to_create_cluster_user(self) -> "Redshift":
        """Grants permission to automatically create the specified Amazon Redshift user if it does not exist.

        Access Level: Permissions management

        Possible conditions:

        - .ifDbUser()

        https://docs.aws.amazon.com/redshift/latest/mgmt/generating-iam-credentials-role-permissions.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toCreateClusterUser", [])

    @jsii.member(jsii_name="toCreateEventSubscription")
    def to_create_event_subscription(self) -> "Redshift":
        """Grants permission to create an Amazon Redshift event notification subscription.

        Access Level: Write

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsTagKeys()

        https://docs.aws.amazon.com/redshift/latest/APIReference/API_CreateEventSubscription.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toCreateEventSubscription", [])

    @jsii.member(jsii_name="toCreateHsmClientCertificate")
    def to_create_hsm_client_certificate(self) -> "Redshift":
        """Grants permission to create an HSM client certificate that a cluster uses to connect to an HSM.

        Access Level: Write

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsTagKeys()

        https://docs.aws.amazon.com/redshift/latest/APIReference/API_CreateHsmClientCertificate.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toCreateHsmClientCertificate", [])

    @jsii.member(jsii_name="toCreateHsmConfiguration")
    def to_create_hsm_configuration(self) -> "Redshift":
        """Grants permission to create an HSM configuration that contains information required by a cluster to store and use database encryption keys in a hardware security module (HSM).

        Access Level: Write

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsTagKeys()

        https://docs.aws.amazon.com/redshift/latest/APIReference/API_CreateHsmConfiguration.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toCreateHsmConfiguration", [])

    @jsii.member(jsii_name="toCreateSavedQuery")
    def to_create_saved_query(self) -> "Redshift":
        """Grants permission to create saved SQL queries through the Amazon Redshift console.

        Access Level: Write

        https://docs.aws.amazon.com/redshift/latest/mgmt/redshift-policy-resources.resource-permissions.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toCreateSavedQuery", [])

    @jsii.member(jsii_name="toCreateScheduledAction")
    def to_create_scheduled_action(self) -> "Redshift":
        """Grants permission to create an Amazon Redshift scheduled action.

        Access Level: Write

        https://docs.aws.amazon.com/redshift/latest/APIReference/API_CreateScheduledAction.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toCreateScheduledAction", [])

    @jsii.member(jsii_name="toCreateSnapshotCopyGrant")
    def to_create_snapshot_copy_grant(self) -> "Redshift":
        """Grants permission to create a snapshot copy grant and encrypt copied snapshots in a destination AWS Region.

        Access Level: Permissions management

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsTagKeys()

        https://docs.aws.amazon.com/redshift/latest/APIReference/API_CreateSnapshotCopyGrant.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toCreateSnapshotCopyGrant", [])

    @jsii.member(jsii_name="toCreateSnapshotSchedule")
    def to_create_snapshot_schedule(self) -> "Redshift":
        """Grants permission to create a snapshot schedule.

        Access Level: Write

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsTagKeys()

        https://docs.aws.amazon.com/redshift/latest/APIReference/API_CreateSnapshotSchedule.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toCreateSnapshotSchedule", [])

    @jsii.member(jsii_name="toCreateTags")
    def to_create_tags(self) -> "Redshift":
        """Grants permission to add one or more tags to a specified resource.

        Access Level: Tagging

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsTagKeys()

        https://docs.aws.amazon.com/redshift/latest/APIReference/API_CreateTags.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toCreateTags", [])

    @jsii.member(jsii_name="toDeleteCluster")
    def to_delete_cluster(self) -> "Redshift":
        """Grants permission to delete a previously provisioned cluster.

        Access Level: Write

        https://docs.aws.amazon.com/redshift/latest/APIReference/API_DeleteCluster.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDeleteCluster", [])

    @jsii.member(jsii_name="toDeleteClusterParameterGroup")
    def to_delete_cluster_parameter_group(self) -> "Redshift":
        """Grants permission to delete an Amazon Redshift parameter group.

        Access Level: Write

        https://docs.aws.amazon.com/redshift/latest/APIReference/API_DeleteClusterParameterGroup.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDeleteClusterParameterGroup", [])

    @jsii.member(jsii_name="toDeleteClusterSecurityGroup")
    def to_delete_cluster_security_group(self) -> "Redshift":
        """Grants permission to delete an Amazon Redshift security group.

        Access Level: Write

        https://docs.aws.amazon.com/redshift/latest/APIReference/API_DeleteClusterSecurityGroup.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDeleteClusterSecurityGroup", [])

    @jsii.member(jsii_name="toDeleteClusterSnapshot")
    def to_delete_cluster_snapshot(self) -> "Redshift":
        """Grants permission to delete a manual snapshot.

        Access Level: Write

        https://docs.aws.amazon.com/redshift/latest/APIReference/API_DeleteClusterSnapshot.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDeleteClusterSnapshot", [])

    @jsii.member(jsii_name="toDeleteClusterSubnetGroup")
    def to_delete_cluster_subnet_group(self) -> "Redshift":
        """Grants permission to delete a cluster subnet group.

        Access Level: Write

        https://docs.aws.amazon.com/redshift/latest/APIReference/API_DeleteClusterSubnetGroup.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDeleteClusterSubnetGroup", [])

    @jsii.member(jsii_name="toDeleteEventSubscription")
    def to_delete_event_subscription(self) -> "Redshift":
        """Grants permission to delete an Amazon Redshift event notification subscription.

        Access Level: Write

        https://docs.aws.amazon.com/redshift/latest/APIReference/API_DeleteEventSubscription.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDeleteEventSubscription", [])

    @jsii.member(jsii_name="toDeleteHsmClientCertificate")
    def to_delete_hsm_client_certificate(self) -> "Redshift":
        """Grants permission to delete an HSM client certificate.

        Access Level: Write

        https://docs.aws.amazon.com/redshift/latest/APIReference/API_DeleteHsmClientCertificate.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDeleteHsmClientCertificate", [])

    @jsii.member(jsii_name="toDeleteHsmConfiguration")
    def to_delete_hsm_configuration(self) -> "Redshift":
        """Grants permission to delete an Amazon Redshift HSM configuration.

        Access Level: Write

        https://docs.aws.amazon.com/redshift/latest/APIReference/API_DeleteHsmConfiguration.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDeleteHsmConfiguration", [])

    @jsii.member(jsii_name="toDeleteSavedQueries")
    def to_delete_saved_queries(self) -> "Redshift":
        """Grants permission to delete saved SQL queries through the Amazon Redshift console.

        Access Level: Write

        https://docs.aws.amazon.com/redshift/latest/mgmt/redshift-policy-resources.resource-permissions.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDeleteSavedQueries", [])

    @jsii.member(jsii_name="toDeleteScheduledAction")
    def to_delete_scheduled_action(self) -> "Redshift":
        """Grants permission to delete an Amazon Redshift scheduled action.

        Access Level: Write

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDeleteScheduledAction", [])

    @jsii.member(jsii_name="toDeleteSnapshotCopyGrant")
    def to_delete_snapshot_copy_grant(self) -> "Redshift":
        """Grants permission to delete a snapshot copy grant.

        Access Level: Write

        https://docs.aws.amazon.com/redshift/latest/APIReference/API_DeleteSnapshotCopyGrant.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDeleteSnapshotCopyGrant", [])

    @jsii.member(jsii_name="toDeleteSnapshotSchedule")
    def to_delete_snapshot_schedule(self) -> "Redshift":
        """Grants permission to delete a snapshot schedule.

        Access Level: Write

        https://docs.aws.amazon.com/redshift/latest/APIReference/API_DeleteSnapshotSchedule.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDeleteSnapshotSchedule", [])

    @jsii.member(jsii_name="toDeleteTags")
    def to_delete_tags(self) -> "Redshift":
        """Grants permission to delete a tag or tags from a resource.

        Access Level: Tagging

        Possible conditions:

        - .ifAwsTagKeys()

        https://docs.aws.amazon.com/redshift/latest/APIReference/API_DeleteTags.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDeleteTags", [])

    @jsii.member(jsii_name="toDescribeAccountAttributes")
    def to_describe_account_attributes(self) -> "Redshift":
        """Grants permission to describe attributes attached to the specified AWS account.

        Access Level: Read

        https://docs.aws.amazon.com/redshift/latest/APIReference/API_DescribeAccountAttributes.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDescribeAccountAttributes", [])

    @jsii.member(jsii_name="toDescribeClusterDbRevisions")
    def to_describe_cluster_db_revisions(self) -> "Redshift":
        """Grants permission to describe database revisions for a cluster.

        Access Level: List

        https://docs.aws.amazon.com/redshift/latest/APIReference/API_DescribeClusterDbRevisions.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDescribeClusterDbRevisions", [])

    @jsii.member(jsii_name="toDescribeClusterParameterGroups")
    def to_describe_cluster_parameter_groups(self) -> "Redshift":
        """Grants permission to describe Amazon Redshift parameter groups, including parameter groups you created and the default parameter group.

        Access Level: Read

        https://docs.aws.amazon.com/redshift/latest/APIReference/API_DescribeClusterParameterGroups.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDescribeClusterParameterGroups", [])

    @jsii.member(jsii_name="toDescribeClusterParameters")
    def to_describe_cluster_parameters(self) -> "Redshift":
        """Grants permission to describe parameters contained within an Amazon Redshift parameter group.

        Access Level: Read

        https://docs.aws.amazon.com/redshift/latest/APIReference/API_DescribeClusterParameters.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDescribeClusterParameters", [])

    @jsii.member(jsii_name="toDescribeClusters")
    def to_describe_clusters(self) -> "Redshift":
        """Grants permission to describe properties of provisioned clusters.

        Access Level: List

        https://docs.aws.amazon.com/redshift/latest/APIReference/API_DescribeClusters.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDescribeClusters", [])

    @jsii.member(jsii_name="toDescribeClusterSecurityGroups")
    def to_describe_cluster_security_groups(self) -> "Redshift":
        """Grants permission to describe Amazon Redshift security groups.

        Access Level: Read

        https://docs.aws.amazon.com/redshift/latest/APIReference/API_DescribeClusterSecurityGroups.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDescribeClusterSecurityGroups", [])

    @jsii.member(jsii_name="toDescribeClusterSnapshots")
    def to_describe_cluster_snapshots(self) -> "Redshift":
        """Grants permission to describe one or more snapshot objects, which contain metadata about your cluster snapshots.

        Access Level: Read

        https://docs.aws.amazon.com/redshift/latest/APIReference/API_DescribeClusterSnapshots.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDescribeClusterSnapshots", [])

    @jsii.member(jsii_name="toDescribeClusterSubnetGroups")
    def to_describe_cluster_subnet_groups(self) -> "Redshift":
        """Grants permission to describe one or more cluster subnet group objects, which contain metadata about your cluster subnet groups.

        Access Level: Read

        https://docs.aws.amazon.com/redshift/latest/APIReference/API_DescribeClusterSubnetGroups.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDescribeClusterSubnetGroups", [])

    @jsii.member(jsii_name="toDescribeClusterTracks")
    def to_describe_cluster_tracks(self) -> "Redshift":
        """Grants permission to describe available maintenance tracks.

        Access Level: List

        https://docs.aws.amazon.com/redshift/latest/APIReference/API_DescribeClusterTracks.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDescribeClusterTracks", [])

    @jsii.member(jsii_name="toDescribeClusterVersions")
    def to_describe_cluster_versions(self) -> "Redshift":
        """Grants permission to describe available Amazon Redshift cluster versions.

        Access Level: Read

        https://docs.aws.amazon.com/redshift/latest/APIReference/API_DescribeClusterVersions.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDescribeClusterVersions", [])

    @jsii.member(jsii_name="toDescribeDefaultClusterParameters")
    def to_describe_default_cluster_parameters(self) -> "Redshift":
        """Grants permission to describe parameter settings for a parameter group family.

        Access Level: Read

        https://docs.aws.amazon.com/redshift/latest/APIReference/API_DescribeDefaultClusterParameters.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDescribeDefaultClusterParameters", [])

    @jsii.member(jsii_name="toDescribeEventCategories")
    def to_describe_event_categories(self) -> "Redshift":
        """Grants permission to describe event categories for all event source types, or for a specified source type.

        Access Level: Read

        https://docs.aws.amazon.com/redshift/latest/APIReference/API_DescribeEventCategories.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDescribeEventCategories", [])

    @jsii.member(jsii_name="toDescribeEvents")
    def to_describe_events(self) -> "Redshift":
        """Grants permission to describe events related to clusters, security groups, snapshots, and parameter groups for the past 14 days.

        Access Level: List

        https://docs.aws.amazon.com/redshift/latest/APIReference/API_DescribeEvents.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDescribeEvents", [])

    @jsii.member(jsii_name="toDescribeEventSubscriptions")
    def to_describe_event_subscriptions(self) -> "Redshift":
        """Grants permission to describe Amazon Redshift event notification subscriptions for the specified AWS account.

        Access Level: Read

        https://docs.aws.amazon.com/redshift/latest/APIReference/API_DescribeEventSubscriptions.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDescribeEventSubscriptions", [])

    @jsii.member(jsii_name="toDescribeHsmClientCertificates")
    def to_describe_hsm_client_certificates(self) -> "Redshift":
        """Grants permission to describe HSM client certificates.

        Access Level: Read

        https://docs.aws.amazon.com/redshift/latest/APIReference/API_DescribeHsmClientCertificates.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDescribeHsmClientCertificates", [])

    @jsii.member(jsii_name="toDescribeHsmConfigurations")
    def to_describe_hsm_configurations(self) -> "Redshift":
        """Grants permission to describe Amazon Redshift HSM configurations.

        Access Level: Read

        https://docs.aws.amazon.com/redshift/latest/APIReference/API_DescribeHsmConfigurations.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDescribeHsmConfigurations", [])

    @jsii.member(jsii_name="toDescribeLoggingStatus")
    def to_describe_logging_status(self) -> "Redshift":
        """Grants permission to describe whether information, such as queries and connection attempts, is being logged for a cluster.

        Access Level: Read

        https://docs.aws.amazon.com/redshift/latest/APIReference/API_DescribeLoggingStatus.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDescribeLoggingStatus", [])

    @jsii.member(jsii_name="toDescribeNodeConfigurationOptions")
    def to_describe_node_configuration_options(self) -> "Redshift":
        """Grants permission to describe properties of possible node configurations such as node type, number of nodes, and disk usage for the specified action type.

        Access Level: List

        https://docs.aws.amazon.com/redshift/latest/APIReference/API_DescribeNodeConfigurationOptions.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDescribeNodeConfigurationOptions", [])

    @jsii.member(jsii_name="toDescribeOrderableClusterOptions")
    def to_describe_orderable_cluster_options(self) -> "Redshift":
        """Grants permission to describe orderable cluster options.

        Access Level: Read

        https://docs.aws.amazon.com/redshift/latest/APIReference/API_DescribeOrderableClusterOptions.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDescribeOrderableClusterOptions", [])

    @jsii.member(jsii_name="toDescribeQuery")
    def to_describe_query(self) -> "Redshift":
        """Grants permission to describe a query through the Amazon Redshift console.

        Access Level: Read

        https://docs.aws.amazon.com/redshift/latest/mgmt/redshift-policy-resources.resource-permissions.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDescribeQuery", [])

    @jsii.member(jsii_name="toDescribeReservedNodeOfferings")
    def to_describe_reserved_node_offerings(self) -> "Redshift":
        """Grants permission to describe available reserved node offerings by Amazon Redshift.

        Access Level: Read

        https://docs.aws.amazon.com/redshift/latest/APIReference/API_DescribeReservedNodeOfferings.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDescribeReservedNodeOfferings", [])

    @jsii.member(jsii_name="toDescribeReservedNodes")
    def to_describe_reserved_nodes(self) -> "Redshift":
        """Grants permission to describe the reserved nodes.

        Access Level: Read

        https://docs.aws.amazon.com/redshift/latest/APIReference/API_DescribeReservedNodes.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDescribeReservedNodes", [])

    @jsii.member(jsii_name="toDescribeResize")
    def to_describe_resize(self) -> "Redshift":
        """Grants permission to describe the last resize operation for a cluster.

        Access Level: Read

        https://docs.aws.amazon.com/redshift/latest/APIReference/API_DescribeResize.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDescribeResize", [])

    @jsii.member(jsii_name="toDescribeSavedQueries")
    def to_describe_saved_queries(self) -> "Redshift":
        """Grants permission to describe saved queries through the Amazon Redshift console.

        Access Level: Read

        https://docs.aws.amazon.com/redshift/latest/mgmt/redshift-policy-resources.resource-permissions.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDescribeSavedQueries", [])

    @jsii.member(jsii_name="toDescribeScheduledActions")
    def to_describe_scheduled_actions(self) -> "Redshift":
        """Grants permission to describe created Amazon Redshift scheduled actions.

        Access Level: Read

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDescribeScheduledActions", [])

    @jsii.member(jsii_name="toDescribeSnapshotCopyGrants")
    def to_describe_snapshot_copy_grants(self) -> "Redshift":
        """Grants permission to describe snapshot copy grants owned by the specified AWS account in the destination AWS Region.

        Access Level: Read

        https://docs.aws.amazon.com/redshift/latest/APIReference/API_DescribeSnapshotCopyGrants.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDescribeSnapshotCopyGrants", [])

    @jsii.member(jsii_name="toDescribeSnapshotSchedules")
    def to_describe_snapshot_schedules(self) -> "Redshift":
        """Grants permission to describe snapshot schedules.

        Access Level: Read

        https://docs.aws.amazon.com/redshift/latest/APIReference/API_DescribeSnapshotSchedules.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDescribeSnapshotSchedules", [])

    @jsii.member(jsii_name="toDescribeStorage")
    def to_describe_storage(self) -> "Redshift":
        """Grants permission to describe account level backups storage size and provisional storage.

        Access Level: Read

        https://docs.aws.amazon.com/redshift/latest/APIReference/API_DescribeStorage.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDescribeStorage", [])

    @jsii.member(jsii_name="toDescribeTable")
    def to_describe_table(self) -> "Redshift":
        """Grants permission to describe a table through the Amazon Redshift console.

        Access Level: Read

        https://docs.aws.amazon.com/redshift/latest/mgmt/redshift-policy-resources.resource-permissions.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDescribeTable", [])

    @jsii.member(jsii_name="toDescribeTableRestoreStatus")
    def to_describe_table_restore_status(self) -> "Redshift":
        """Grants permission to describe status of one or more table restore requests made using the RestoreTableFromClusterSnapshot API action.

        Access Level: Read

        https://docs.aws.amazon.com/redshift/latest/APIReference/API_DescribeTableRestoreStatus.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDescribeTableRestoreStatus", [])

    @jsii.member(jsii_name="toDescribeTags")
    def to_describe_tags(self) -> "Redshift":
        """Grants permission to describe tags.

        Access Level: Read

        https://docs.aws.amazon.com/redshift/latest/APIReference/API_DescribeTags.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDescribeTags", [])

    @jsii.member(jsii_name="toDisableLogging")
    def to_disable_logging(self) -> "Redshift":
        """Grants permission to disable logging information, such as queries and connection attempts, for a cluster.

        Access Level: Write

        https://docs.aws.amazon.com/redshift/latest/APIReference/API_DisableLogging.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDisableLogging", [])

    @jsii.member(jsii_name="toDisableSnapshotCopy")
    def to_disable_snapshot_copy(self) -> "Redshift":
        """Grants permission to disable the automatic copy of snapshots for a cluster.

        Access Level: Write

        https://docs.aws.amazon.com/redshift/latest/APIReference/API_DisableSnapshotCopy.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDisableSnapshotCopy", [])

    @jsii.member(jsii_name="toEnableLogging")
    def to_enable_logging(self) -> "Redshift":
        """Grants permission to enable logging information, such as queries and connection attempts, for a cluster.

        Access Level: Write

        https://docs.aws.amazon.com/redshift/latest/APIReference/API_EnableLogging.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toEnableLogging", [])

    @jsii.member(jsii_name="toEnableSnapshotCopy")
    def to_enable_snapshot_copy(self) -> "Redshift":
        """Grants permission to enable the automatic copy of snapshots for a cluster.

        Access Level: Write

        https://docs.aws.amazon.com/redshift/latest/APIReference/API_EnableSnapshotCopy.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toEnableSnapshotCopy", [])

    @jsii.member(jsii_name="toExecuteQuery")
    def to_execute_query(self) -> "Redshift":
        """Grants permission to execute a query through the Amazon Redshift console.

        Access Level: Write

        https://docs.aws.amazon.com/redshift/latest/mgmt/redshift-policy-resources.resource-permissions.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toExecuteQuery", [])

    @jsii.member(jsii_name="toFetchResults")
    def to_fetch_results(self) -> "Redshift":
        """Grants permission to fetch query results through the Amazon Redshift console.

        Access Level: Read

        https://docs.aws.amazon.com/redshift/latest/mgmt/redshift-policy-resources.resource-permissions.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toFetchResults", [])

    @jsii.member(jsii_name="toGetClusterCredentials")
    def to_get_cluster_credentials(self) -> "Redshift":
        """Grants permission to get temporary credentials to access an Amazon Redshift database by the specified AWS account.

        Access Level: Write

        Possible conditions:

        - .ifDbName()
        - .ifDbUser()
        - .ifDurationSeconds()

        https://docs.aws.amazon.com/redshift/latest/APIReference/API_GetClusterCredentials.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toGetClusterCredentials", [])

    @jsii.member(jsii_name="toGetReservedNodeExchangeOfferings")
    def to_get_reserved_node_exchange_offerings(self) -> "Redshift":
        """Grants permission to get an array of DC2 ReservedNodeOfferings that matches the payment type, term, and usage price of the given DC1 reserved node.

        Access Level: Read

        https://docs.aws.amazon.com/redshift/latest/APIReference/API_GetReservedNodeExchangeOfferings.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toGetReservedNodeExchangeOfferings", [])

    @jsii.member(jsii_name="toJoinGroup")
    def to_join_group(self) -> "Redshift":
        """Grants permission to join the specified Amazon Redshift group.

        Access Level: Permissions management

        https://docs.aws.amazon.com/redshift/latest/APIReference/API_GetClusterCredentials.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toJoinGroup", [])

    @jsii.member(jsii_name="toListDatabases")
    def to_list_databases(self) -> "Redshift":
        """Grants permission to list databases through the Amazon Redshift console.

        Access Level: List

        https://docs.aws.amazon.com/redshift/latest/mgmt/redshift-policy-resources.resource-permissions.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toListDatabases", [])

    @jsii.member(jsii_name="toListSavedQueries")
    def to_list_saved_queries(self) -> "Redshift":
        """Grants permission to list saved queries through the Amazon Redshift console.

        Access Level: List

        https://docs.aws.amazon.com/redshift/latest/mgmt/redshift-policy-resources.resource-permissions.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toListSavedQueries", [])

    @jsii.member(jsii_name="toListSchemas")
    def to_list_schemas(self) -> "Redshift":
        """Grants permission to list schemas through the Amazon Redshift console.

        Access Level: List

        https://docs.aws.amazon.com/redshift/latest/mgmt/redshift-policy-resources.resource-permissions.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toListSchemas", [])

    @jsii.member(jsii_name="toListTables")
    def to_list_tables(self) -> "Redshift":
        """Grants permission to list tables through the Amazon Redshift console.

        Access Level: List

        https://docs.aws.amazon.com/redshift/latest/mgmt/redshift-policy-resources.resource-permissions.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toListTables", [])

    @jsii.member(jsii_name="toModifyCluster")
    def to_modify_cluster(self) -> "Redshift":
        """Grants permission to modify the settings of a cluster.

        Access Level: Write

        https://docs.aws.amazon.com/redshift/latest/APIReference/API_ModifyCluster.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toModifyCluster", [])

    @jsii.member(jsii_name="toModifyClusterDbRevision")
    def to_modify_cluster_db_revision(self) -> "Redshift":
        """Grants permission to modify the database revision of a cluster.

        Access Level: Write

        https://docs.aws.amazon.com/redshift/latest/APIReference/API_ModifyClusterDbRevision.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toModifyClusterDbRevision", [])

    @jsii.member(jsii_name="toModifyClusterIamRoles")
    def to_modify_cluster_iam_roles(self) -> "Redshift":
        """Grants permission to modify the list of AWS Identity and Access Management (IAM) roles that can be used by a cluster to access other AWS services.

        Access Level: Permissions management

        https://docs.aws.amazon.com/redshift/latest/APIReference/API_ModifyClusterIamRoles.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toModifyClusterIamRoles", [])

    @jsii.member(jsii_name="toModifyClusterMaintenance")
    def to_modify_cluster_maintenance(self) -> "Redshift":
        """Grants permission to modify the maintenance settings of a cluster.

        Access Level: Write

        https://docs.aws.amazon.com/redshift/latest/APIReference/API_ModifyClusterMaintenance.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toModifyClusterMaintenance", [])

    @jsii.member(jsii_name="toModifyClusterParameterGroup")
    def to_modify_cluster_parameter_group(self) -> "Redshift":
        """Grants permission to modify the parameters of a parameter group.

        Access Level: Write

        https://docs.aws.amazon.com/redshift/latest/APIReference/API_ModifyClusterParameterGroup.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toModifyClusterParameterGroup", [])

    @jsii.member(jsii_name="toModifyClusterSnapshot")
    def to_modify_cluster_snapshot(self) -> "Redshift":
        """Grants permission to modify the settings of a snapshot.

        Access Level: Write

        https://docs.aws.amazon.com/redshift/latest/APIReference/API_ModifyClusterSnapshot.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toModifyClusterSnapshot", [])

    @jsii.member(jsii_name="toModifyClusterSnapshotSchedule")
    def to_modify_cluster_snapshot_schedule(self) -> "Redshift":
        """Grants permission to modify a snapshot schedule for a cluster.

        Access Level: Write

        https://docs.aws.amazon.com/redshift/latest/APIReference/API_ModifyClusterSnapshotSchedule.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toModifyClusterSnapshotSchedule", [])

    @jsii.member(jsii_name="toModifyClusterSubnetGroup")
    def to_modify_cluster_subnet_group(self) -> "Redshift":
        """Grants permission to modify a cluster subnet group to include the specified list of VPC subnets.

        Access Level: Write

        https://docs.aws.amazon.com/redshift/latest/APIReference/API_ModifyClusterSubnetGroup.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toModifyClusterSubnetGroup", [])

    @jsii.member(jsii_name="toModifyEventSubscription")
    def to_modify_event_subscription(self) -> "Redshift":
        """Grants permission to modify an existing Amazon Redshift event notification subscription.

        Access Level: Write

        https://docs.aws.amazon.com/redshift/latest/APIReference/API_ModifyEventSubscription.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toModifyEventSubscription", [])

    @jsii.member(jsii_name="toModifySavedQuery")
    def to_modify_saved_query(self) -> "Redshift":
        """Grants permission to modify an existing saved query through the Amazon Redshift console.

        Access Level: Write

        https://docs.aws.amazon.com/redshift/latest/mgmt/redshift-policy-resources.resource-permissions.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toModifySavedQuery", [])

    @jsii.member(jsii_name="toModifyScheduledAction")
    def to_modify_scheduled_action(self) -> "Redshift":
        """Grants permission to modify an existing Amazon Redshift scheduled action.

        Access Level: Write

        https://docs.aws.amazon.com/redshift/latest/APIReference/API_ModifyScheduledAction.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toModifyScheduledAction", [])

    @jsii.member(jsii_name="toModifySnapshotCopyRetentionPeriod")
    def to_modify_snapshot_copy_retention_period(self) -> "Redshift":
        """Grants permission to modify the number of days to retain snapshots in the destination AWS Region after they are copied from the source AWS Region.

        Access Level: Write

        https://docs.aws.amazon.com/redshift/latest/APIReference/API_ModifySnapshotCopyRetentionPeriod.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toModifySnapshotCopyRetentionPeriod", [])

    @jsii.member(jsii_name="toModifySnapshotSchedule")
    def to_modify_snapshot_schedule(self) -> "Redshift":
        """Grants permission to modify a snapshot schedule.

        Access Level: Write

        https://docs.aws.amazon.com/redshift/latest/APIReference/API_ModifySnapshotSchedule.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toModifySnapshotSchedule", [])

    @jsii.member(jsii_name="toPauseCluster")
    def to_pause_cluster(self) -> "Redshift":
        """Grants permission to pause a cluster.

        Access Level: Write

        https://docs.aws.amazon.com/redshift/latest/APIReference/API_PauseCluster.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toPauseCluster", [])

    @jsii.member(jsii_name="toPurchaseReservedNodeOffering")
    def to_purchase_reserved_node_offering(self) -> "Redshift":
        """Grants permission to purchase a reserved node.

        Access Level: Write

        https://docs.aws.amazon.com/redshift/latest/APIReference/API_PurchaseReservedNodeOffering.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toPurchaseReservedNodeOffering", [])

    @jsii.member(jsii_name="toRebootCluster")
    def to_reboot_cluster(self) -> "Redshift":
        """Grants permission to reboot a cluster.

        Access Level: Write

        https://docs.aws.amazon.com/redshift/latest/APIReference/API_RebootCluster.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toRebootCluster", [])

    @jsii.member(jsii_name="toResetClusterParameterGroup")
    def to_reset_cluster_parameter_group(self) -> "Redshift":
        """Grants permission to set one or more parameters of a parameter group to their default values and set the source values of the parameters to "engine-default".

        Access Level: Write

        https://docs.aws.amazon.com/redshift/latest/APIReference/API_ResetClusterParameterGroup.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toResetClusterParameterGroup", [])

    @jsii.member(jsii_name="toResizeCluster")
    def to_resize_cluster(self) -> "Redshift":
        """Grants permission to change the size of a cluster.

        Access Level: Write

        https://docs.aws.amazon.com/redshift/latest/APIReference/API_ResizeCluster.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toResizeCluster", [])

    @jsii.member(jsii_name="toRestoreFromClusterSnapshot")
    def to_restore_from_cluster_snapshot(self) -> "Redshift":
        """Grants permission to create a cluster from a snapshot.

        Access Level: Write

        https://docs.aws.amazon.com/redshift/latest/APIReference/API_RestoreFromClusterSnapshot.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toRestoreFromClusterSnapshot", [])

    @jsii.member(jsii_name="toRestoreTableFromClusterSnapshot")
    def to_restore_table_from_cluster_snapshot(self) -> "Redshift":
        """Grants permission to create a table from a table in an Amazon Redshift cluster snapshot.

        Access Level: Write

        https://docs.aws.amazon.com/redshift/latest/APIReference/API_RestoreTableFromClusterSnapshot.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toRestoreTableFromClusterSnapshot", [])

    @jsii.member(jsii_name="toResumeCluster")
    def to_resume_cluster(self) -> "Redshift":
        """Grants permission to resume a cluster.

        Access Level: Write

        https://docs.aws.amazon.com/redshift/latest/APIReference/API_ResumeCluster.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toResumeCluster", [])

    @jsii.member(jsii_name="toRevokeClusterSecurityGroupIngress")
    def to_revoke_cluster_security_group_ingress(self) -> "Redshift":
        """Grants permission to revoke an ingress rule in an Amazon Redshift security group for a previously authorized IP range or Amazon EC2 security group.

        Access Level: Permissions management

        https://docs.aws.amazon.com/redshift/latest/APIReference/API_RevokeClusterSecurityGroupIngress.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toRevokeClusterSecurityGroupIngress", [])

    @jsii.member(jsii_name="toRevokeSnapshotAccess")
    def to_revoke_snapshot_access(self) -> "Redshift":
        """Grants permission to revoke access from the specified AWS account to restore a snapshot.

        Access Level: Permissions management

        https://docs.aws.amazon.com/redshift/latest/APIReference/API_RevokeSnapshotAccess.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toRevokeSnapshotAccess", [])

    @jsii.member(jsii_name="toRotateEncryptionKey")
    def to_rotate_encryption_key(self) -> "Redshift":
        """Grants permission to rotate an encryption key for a cluster.

        Access Level: Permissions management

        https://docs.aws.amazon.com/redshift/latest/APIReference/API_RotateEncryptionKey.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toRotateEncryptionKey", [])

    @jsii.member(jsii_name="toViewQueriesFromConsole")
    def to_view_queries_from_console(self) -> "Redshift":
        """Grants permission to view query results through the Amazon Redshift console.

        Access Level: List

        https://docs.aws.amazon.com/redshift/latest/mgmt/redshift-policy-resources.resource-permissions.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toViewQueriesFromConsole", [])

    @jsii.member(jsii_name="toViewQueriesInConsole")
    def to_view_queries_in_console(self) -> "Redshift":
        """Grants permission to terminate running queries and loads through the Amazon Redshift console.

        Access Level: List

        https://docs.aws.amazon.com/redshift/latest/mgmt/redshift-policy-resources.resource-permissions.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toViewQueriesInConsole", [])

    @builtins.property # type: ignore
    @jsii.member(jsii_name="accessLevelList")
    def _access_level_list(self) -> "AccessLevelList":
        """
        stability
        :stability: experimental
        """
        return jsii.get(self, "accessLevelList")

    @_access_level_list.setter # type: ignore
    def _access_level_list(self, value: "AccessLevelList") -> None:
        jsii.set(self, "accessLevelList", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="servicePrefix")
    def service_prefix(self) -> builtins.str:
        """Holds the prefix of the service actions, e.g. ``ec2``.

        stability
        :stability: experimental
        """
        return jsii.get(self, "servicePrefix")

    @service_prefix.setter # type: ignore
    def service_prefix(self, value: builtins.str) -> None:
        jsii.set(self, "servicePrefix", value)


class RedshiftData(
    PolicyStatement,
    metaclass=jsii.JSIIMeta,
    jsii_type="iam-floyd.RedshiftData",
):
    """Statement provider for service `redshift-data <https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonredshiftdataapi.html>`_.

    stability
    :stability: experimental
    """

    def __init__(self, sid: typing.Optional[builtins.str] = None) -> None:
        """Statement provider for service `redshift-data <https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonredshiftdataapi.html>`_.

        :param sid: `SID <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html>`_ of the statement.

        stability
        :stability: experimental
        """
        jsii.create(RedshiftData, self, [sid])

    @jsii.member(jsii_name="toCancelStatement")
    def to_cancel_statement(self) -> "RedshiftData":
        """Grants permission to cancel a running query.

        Access Level: Write

        https://docs.aws.amazon.com/redshift-data/latest/APIReference/API_CancelStatement.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toCancelStatement", [])

    @jsii.member(jsii_name="toDescribeStatement")
    def to_describe_statement(self) -> "RedshiftData":
        """Grants permission to retrieve detailed information about a statement execution.

        Access Level: Read

        https://docs.aws.amazon.com/redshift-data/latest/APIReference/API_DescribeStatement.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDescribeStatement", [])

    @jsii.member(jsii_name="toDescribeTable")
    def to_describe_table(self) -> "RedshiftData":
        """Grants permission to retrieve metadata about a particular table.

        Access Level: Read

        https://docs.aws.amazon.com/redshift-data/latest/APIReference/API_DescribeTable.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDescribeTable", [])

    @jsii.member(jsii_name="toExecuteStatement")
    def to_execute_statement(self) -> "RedshiftData":
        """Grants permission to execute a query.

        Access Level: Write

        https://docs.aws.amazon.com/redshift-data/latest/APIReference/API_ExecuteStatement.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toExecuteStatement", [])

    @jsii.member(jsii_name="toGetStatementResult")
    def to_get_statement_result(self) -> "RedshiftData":
        """Grants permission to fetch the result of a query.

        Access Level: Read

        https://docs.aws.amazon.com/redshift-data/latest/APIReference/API_GetStatementResult.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toGetStatementResult", [])

    @jsii.member(jsii_name="toListDatabases")
    def to_list_databases(self) -> "RedshiftData":
        """Grants permission to list databases for a given cluster.

        Access Level: List

        https://docs.aws.amazon.com/redshift-data/latest/APIReference/API_ListDatabases.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toListDatabases", [])

    @jsii.member(jsii_name="toListSchemas")
    def to_list_schemas(self) -> "RedshiftData":
        """Grants permission to list schemas for a given cluster.

        Access Level: List

        https://docs.aws.amazon.com/redshift-data/latest/APIReference/API_ListSchemas.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toListSchemas", [])

    @jsii.member(jsii_name="toListStatements")
    def to_list_statements(self) -> "RedshiftData":
        """Grants permission to list queries for a given principal.

        Access Level: List

        https://docs.aws.amazon.com/redshift-data/latest/APIReference/API_ListStatements.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toListStatements", [])

    @jsii.member(jsii_name="toListTables")
    def to_list_tables(self) -> "RedshiftData":
        """Grants permission to list tables for a given cluster.

        Access Level: List

        https://docs.aws.amazon.com/redshift-data/latest/APIReference/API_ListTables.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toListTables", [])

    @builtins.property # type: ignore
    @jsii.member(jsii_name="accessLevelList")
    def _access_level_list(self) -> "AccessLevelList":
        """
        stability
        :stability: experimental
        """
        return jsii.get(self, "accessLevelList")

    @_access_level_list.setter # type: ignore
    def _access_level_list(self, value: "AccessLevelList") -> None:
        jsii.set(self, "accessLevelList", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="servicePrefix")
    def service_prefix(self) -> builtins.str:
        """Holds the prefix of the service actions, e.g. ``ec2``.

        stability
        :stability: experimental
        """
        return jsii.get(self, "servicePrefix")

    @service_prefix.setter # type: ignore
    def service_prefix(self, value: builtins.str) -> None:
        jsii.set(self, "servicePrefix", value)


class Rekognition(
    PolicyStatement,
    metaclass=jsii.JSIIMeta,
    jsii_type="iam-floyd.Rekognition",
):
    """Statement provider for service `rekognition <https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonrekognition.html>`_.

    stability
    :stability: experimental
    """

    def __init__(self, sid: typing.Optional[builtins.str] = None) -> None:
        """Statement provider for service `rekognition <https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonrekognition.html>`_.

        :param sid: `SID <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html>`_ of the statement.

        stability
        :stability: experimental
        """
        jsii.create(Rekognition, self, [sid])

    @jsii.member(jsii_name="onCollection")
    def on_collection(
        self,
        collection_id: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Rekognition":
        """Adds a resource of type collection to the statement.

        https://docs.aws.amazon.com/rekognition/latest/dg/howitworks-collection.html

        :param collection_id: - Identifier for the collectionId.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "onCollection", [collection_id, account, region, partition])

    @jsii.member(jsii_name="onProject")
    def on_project(
        self,
        project_name: builtins.str,
        creation_timestamp: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Rekognition":
        """Adds a resource of type project to the statement.

        :param project_name: - Identifier for the projectName.
        :param creation_timestamp: - Identifier for the creationTimestamp.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "onProject", [project_name, creation_timestamp, account, region, partition])

    @jsii.member(jsii_name="onProjectversion")
    def on_projectversion(
        self,
        project_name: builtins.str,
        version_name: builtins.str,
        creation_timestamp: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Rekognition":
        """Adds a resource of type projectversion to the statement.

        :param project_name: - Identifier for the projectName.
        :param version_name: - Identifier for the versionName.
        :param creation_timestamp: - Identifier for the creationTimestamp.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "onProjectversion", [project_name, version_name, creation_timestamp, account, region, partition])

    @jsii.member(jsii_name="onStreamprocessor")
    def on_streamprocessor(
        self,
        streamprocessor_id: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Rekognition":
        """Adds a resource of type streamprocessor to the statement.

        :param streamprocessor_id: - Identifier for the streamprocessorId.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "onStreamprocessor", [streamprocessor_id, account, region, partition])

    @jsii.member(jsii_name="toCompareFaces")
    def to_compare_faces(self) -> "Rekognition":
        """Compares a face in source input image with each face detected in the target input image.

        Access Level: Read

        https://docs.aws.amazon.com/rekognition/latest/dg/API_CompareFaces.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toCompareFaces", [])

    @jsii.member(jsii_name="toCreateCollection")
    def to_create_collection(self) -> "Rekognition":
        """Creates a collection in an AWS region. You can then add faces to the collection using the IndexFaces API.

        Access Level: Write

        https://docs.aws.amazon.com/rekognition/latest/dg/API_CreateCollection.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toCreateCollection", [])

    @jsii.member(jsii_name="toCreateProject")
    def to_create_project(self) -> "Rekognition":
        """Creates a new Amazon Rekognition Custom Labels project.

        Access Level: Write

        https://docs.aws.amazon.com/rekognition/latest/dg/API_CreateProject.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toCreateProject", [])

    @jsii.member(jsii_name="toCreateProjectVersion")
    def to_create_project_version(self) -> "Rekognition":
        """Creates a new version of a model and begins training.

        Access Level: Write

        https://docs.aws.amazon.com/rekognition/latest/dg/API_CreateProjectVersion.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toCreateProjectVersion", [])

    @jsii.member(jsii_name="toCreateStreamProcessor")
    def to_create_stream_processor(self) -> "Rekognition":
        """Creates an Amazon Rekognition stream processor that you can use to detect and recognize faces in a streaming video.

        Access Level: Write

        https://docs.aws.amazon.com/rekognition/latest/dg/API_CreateStreamProcessor.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toCreateStreamProcessor", [])

    @jsii.member(jsii_name="toDeleteCollection")
    def to_delete_collection(self) -> "Rekognition":
        """Deletes the specified collection. Note that this operation removes all faces in the collection.

        Access Level: Write

        https://docs.aws.amazon.com/rekognition/latest/dg/API_DeleteCollection.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDeleteCollection", [])

    @jsii.member(jsii_name="toDeleteFaces")
    def to_delete_faces(self) -> "Rekognition":
        """Deletes faces from a collection.

        Access Level: Write

        https://docs.aws.amazon.com/rekognition/latest/dg/API_DeleteFaces.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDeleteFaces", [])

    @jsii.member(jsii_name="toDeleteProject")
    def to_delete_project(self) -> "Rekognition":
        """Deletes a project.

        Access Level: Write

        https://docs.aws.amazon.com/rekognition/latest/dg/API_DeleteProject.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDeleteProject", [])

    @jsii.member(jsii_name="toDeleteProjectVersion")
    def to_delete_project_version(self) -> "Rekognition":
        """Deletes a model.

        Access Level: Write

        https://docs.aws.amazon.com/rekognition/latest/dg/API_DeleteProjectVersion.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDeleteProjectVersion", [])

    @jsii.member(jsii_name="toDeleteStreamProcessor")
    def to_delete_stream_processor(self) -> "Rekognition":
        """Deletes the stream processor identified by Name.

        Access Level: Write

        https://docs.aws.amazon.com/rekognition/latest/dg/API_DeleteStreamProcessor.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDeleteStreamProcessor", [])

    @jsii.member(jsii_name="toDescribeCollection")
    def to_describe_collection(self) -> "Rekognition":
        """Describes the specified collection.

        Access Level: Read

        https://docs.aws.amazon.com/rekognition/latest/dg/API_DescribeCollection.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDescribeCollection", [])

    @jsii.member(jsii_name="toDescribeProjects")
    def to_describe_projects(self) -> "Rekognition":
        """Lists and gets information about your Amazon Rekognition Custom Labels projects.

        Access Level: Read

        https://docs.aws.amazon.com/rekognition/latest/dg/API_DescribeProjects.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDescribeProjects", [])

    @jsii.member(jsii_name="toDescribeProjectVersions")
    def to_describe_project_versions(self) -> "Rekognition":
        """Lists and describes the model versions in an Amazon Rekognition Custom Labels project.

        Access Level: Read

        https://docs.aws.amazon.com/rekognition/latest/dg/API_DescribeProjectVersions.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDescribeProjectVersions", [])

    @jsii.member(jsii_name="toDescribeStreamProcessor")
    def to_describe_stream_processor(self) -> "Rekognition":
        """Provides information about a stream processor created by CreateStreamProcessor.

        Access Level: Read

        https://docs.aws.amazon.com/rekognition/latest/dg/API_DescribeStreamProcessorh.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDescribeStreamProcessor", [])

    @jsii.member(jsii_name="toDetectCustomLabels")
    def to_detect_custom_labels(self) -> "Rekognition":
        """Detects custom labels in a supplied image by using an Amazon Rekognition Custom Labels model version.

        Access Level: Read

        https://docs.aws.amazon.com/rekognition/latest/dg/API_DetectCustomLabels.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDetectCustomLabels", [])

    @jsii.member(jsii_name="toDetectFaces")
    def to_detect_faces(self) -> "Rekognition":
        """Detects human faces within an image (JPEG or PNG) provided as input.

        Access Level: Read

        https://docs.aws.amazon.com/rekognition/latest/dg/API_DetectFaces.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDetectFaces", [])

    @jsii.member(jsii_name="toDetectLabels")
    def to_detect_labels(self) -> "Rekognition":
        """Detects instances of real-world labels within an image (JPEG or PNG) provided as input.

        Access Level: Read

        https://docs.aws.amazon.com/rekognition/latest/dg/API_DetectLabels.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDetectLabels", [])

    @jsii.member(jsii_name="toDetectModerationLabels")
    def to_detect_moderation_labels(self) -> "Rekognition":
        """Detects moderation labels within input image.

        Access Level: Read

        https://docs.aws.amazon.com/rekognition/latest/dg/API_DetectModerationLabels.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDetectModerationLabels", [])

    @jsii.member(jsii_name="toDetectProtectiveEquipment")
    def to_detect_protective_equipment(self) -> "Rekognition":
        """Detects Protective Equipment in the input image.

        Access Level: Read

        https://docs.aws.amazon.com/rekognition/latest/dg/API_DetectProtectiveEquipment.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDetectProtectiveEquipment", [])

    @jsii.member(jsii_name="toDetectText")
    def to_detect_text(self) -> "Rekognition":
        """Detects text in the input image and converts it into machine-readable text.

        Access Level: Read

        https://docs.aws.amazon.com/rekognition/latest/dg/API_DetectText.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDetectText", [])

    @jsii.member(jsii_name="toGetCelebrityInfo")
    def to_get_celebrity_info(self) -> "Rekognition":
        """Gets the name and additional information about a celebrity based on his or her Rekognition ID.

        Access Level: Read

        https://docs.aws.amazon.com/rekognition/latest/dg/API_GetCelebrityInfo.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toGetCelebrityInfo", [])

    @jsii.member(jsii_name="toGetCelebrityRecognition")
    def to_get_celebrity_recognition(self) -> "Rekognition":
        """Gets the celebrity recognition results for a Rekognition Video analysis started by StartCelebrityRecognition.

        Access Level: Read

        https://docs.aws.amazon.com/rekognition/latest/dg/API_GetCelebrityRecognition.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toGetCelebrityRecognition", [])

    @jsii.member(jsii_name="toGetContentModeration")
    def to_get_content_moderation(self) -> "Rekognition":
        """Gets the content moderation analysis results for a Rekognition Video analysis started by StartContentModeration.

        Access Level: Read

        https://docs.aws.amazon.com/rekognition/latest/dg/API_GetContentModeration.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toGetContentModeration", [])

    @jsii.member(jsii_name="toGetFaceDetection")
    def to_get_face_detection(self) -> "Rekognition":
        """Gets face detection results for a Rekognition Video analysis started by StartFaceDetection.

        Access Level: Read

        https://docs.aws.amazon.com/rekognition/latest/dg/API_GetFaceDetection.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toGetFaceDetection", [])

    @jsii.member(jsii_name="toGetFaceSearch")
    def to_get_face_search(self) -> "Rekognition":
        """Gets the face search results for Rekognition Video face search started by StartFaceSearch.

        Access Level: Read

        https://docs.aws.amazon.com/rekognition/latest/dg/API_GetFaceSearch.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toGetFaceSearch", [])

    @jsii.member(jsii_name="toGetLabelDetection")
    def to_get_label_detection(self) -> "Rekognition":
        """Gets the label detection results of a Rekognition Video analysis started by StartLabelDetection.

        Access Level: Read

        https://docs.aws.amazon.com/rekognition/latest/dg/API_GetLabelDetection.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toGetLabelDetection", [])

    @jsii.member(jsii_name="toGetPersonTracking")
    def to_get_person_tracking(self) -> "Rekognition":
        """Gets information about people detected within a video.

        Access Level: Read

        https://docs.aws.amazon.com/rekognition/latest/dg/API_GetPersonTracking.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toGetPersonTracking", [])

    @jsii.member(jsii_name="toGetSegmentDetection")
    def to_get_segment_detection(self) -> "Rekognition":
        """Gets segment detection results for a Rekognition Video analysis started by StartSegmentDetection.

        Access Level: Read

        https://docs.aws.amazon.com/rekognition/latest/dg/API_GetSegmentDetection.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toGetSegmentDetection", [])

    @jsii.member(jsii_name="toGetTextDetection")
    def to_get_text_detection(self) -> "Rekognition":
        """Gets text detection results for a Rekognition Video analysis started by StartTextDetection.

        Access Level: Read

        https://docs.aws.amazon.com/rekognition/latest/dg/API_GetTextDetection.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toGetTextDetection", [])

    @jsii.member(jsii_name="toIndexFaces")
    def to_index_faces(self) -> "Rekognition":
        """Detects faces in the input image and adds them to the specified collection.

        Access Level: Write

        https://docs.aws.amazon.com/rekognition/latest/dg/API_IndexFaces.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toIndexFaces", [])

    @jsii.member(jsii_name="toListCollections")
    def to_list_collections(self) -> "Rekognition":
        """Returns a list of collection IDs in your account.

        Access Level: Read

        https://docs.aws.amazon.com/rekognition/latest/dg/API_ListCollections.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toListCollections", [])

    @jsii.member(jsii_name="toListFaces")
    def to_list_faces(self) -> "Rekognition":
        """Returns metadata for faces in the specified collection.

        Access Level: Read

        https://docs.aws.amazon.com/rekognition/latest/dg/API_ListFaces.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toListFaces", [])

    @jsii.member(jsii_name="toListStreamProcessors")
    def to_list_stream_processors(self) -> "Rekognition":
        """Gets a list of stream processors that you have created with CreateStreamProcessor.

        Access Level: List

        https://docs.aws.amazon.com/rekognition/latest/dg/API_ListStreamProcessors.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toListStreamProcessors", [])

    @jsii.member(jsii_name="toRecognizeCelebrities")
    def to_recognize_celebrities(self) -> "Rekognition":
        """Returns an array of celebrities recognized in the input image.

        Access Level: Read

        https://docs.aws.amazon.com/rekognition/latest/dg/API_RecognizeCelebrities.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toRecognizeCelebrities", [])

    @jsii.member(jsii_name="toSearchFaces")
    def to_search_faces(self) -> "Rekognition":
        """For a given input face ID, searches the specified collection for matching faces.

        Access Level: Read

        https://docs.aws.amazon.com/rekognition/latest/dg/API_SearchFaces.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toSearchFaces", [])

    @jsii.member(jsii_name="toSearchFacesByImage")
    def to_search_faces_by_image(self) -> "Rekognition":
        """For a given input image, first detects the largest face in the image, and then searches the specified collection for matching faces.

        Access Level: Read

        https://docs.aws.amazon.com/rekognition/latest/dg/API_SearchFacesByImage.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toSearchFacesByImage", [])

    @jsii.member(jsii_name="toStartCelebrityRecognition")
    def to_start_celebrity_recognition(self) -> "Rekognition":
        """Starts asynchronous recognition of celebrities in a video.

        Access Level: Write

        https://docs.aws.amazon.com/rekognition/latest/dg/API_StartCelebrityRecognition.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toStartCelebrityRecognition", [])

    @jsii.member(jsii_name="toStartContentModeration")
    def to_start_content_moderation(self) -> "Rekognition":
        """Starts asynchronous detection of explicit or suggestive adult content in a video.

        Access Level: Write

        https://docs.aws.amazon.com/rekognition/latest/dg/API_StartContentModeration.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toStartContentModeration", [])

    @jsii.member(jsii_name="toStartFaceDetection")
    def to_start_face_detection(self) -> "Rekognition":
        """Starts asynchronous detection of faces in a video.

        Access Level: Write

        https://docs.aws.amazon.com/rekognition/latest/dg/API_StartFaceDetection.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toStartFaceDetection", [])

    @jsii.member(jsii_name="toStartFaceSearch")
    def to_start_face_search(self) -> "Rekognition":
        """Starts the asynchronous search for faces in a collection that match the faces of persons detected in a video.

        Access Level: Write

        https://docs.aws.amazon.com/rekognition/latest/dg/API_StartFaceSearch.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toStartFaceSearch", [])

    @jsii.member(jsii_name="toStartLabelDetection")
    def to_start_label_detection(self) -> "Rekognition":
        """Starts asynchronous detection of labels in a video.

        Access Level: Write

        https://docs.aws.amazon.com/rekognition/latest/dg/API_StartLabelDetection.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toStartLabelDetection", [])

    @jsii.member(jsii_name="toStartPersonTracking")
    def to_start_person_tracking(self) -> "Rekognition":
        """Starts the asynchronous tracking of persons in a video.

        Access Level: Write

        https://docs.aws.amazon.com/rekognition/latest/dg/API_StartPersonTracking.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toStartPersonTracking", [])

    @jsii.member(jsii_name="toStartProjectVersion")
    def to_start_project_version(self) -> "Rekognition":
        """Starts the deployment of a model version.

        Access Level: Write

        https://docs.aws.amazon.com/rekognition/latest/dg/API_StartProjectVersion.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toStartProjectVersion", [])

    @jsii.member(jsii_name="toStartSegmentDetection")
    def to_start_segment_detection(self) -> "Rekognition":
        """Starts asynchronous detection of segments in a video.

        Access Level: Write

        https://docs.aws.amazon.com/rekognition/latest/dg/API_StartSegmentDetection.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toStartSegmentDetection", [])

    @jsii.member(jsii_name="toStartStreamProcessor")
    def to_start_stream_processor(self) -> "Rekognition":
        """Starts processing a stream processor.

        Access Level: Write

        https://docs.aws.amazon.com/rekognition/latest/dg/API_StartStreamProcessor.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toStartStreamProcessor", [])

    @jsii.member(jsii_name="toStartTextDetection")
    def to_start_text_detection(self) -> "Rekognition":
        """Starts asynchronous detection of text in a video.

        Access Level: Write

        https://docs.aws.amazon.com/rekognition/latest/dg/API_StartTextDetection.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toStartTextDetection", [])

    @jsii.member(jsii_name="toStopProjectVersion")
    def to_stop_project_version(self) -> "Rekognition":
        """Stops a deployed model version.

        Access Level: Write

        https://docs.aws.amazon.com/rekognition/latest/dg/API_StopProjectVersion.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toStopProjectVersion", [])

    @jsii.member(jsii_name="toStopStreamProcessor")
    def to_stop_stream_processor(self) -> "Rekognition":
        """Stops a running stream processor that was created by CreateStreamProcessor.

        Access Level: Write

        https://docs.aws.amazon.com/rekognition/latest/dg/API_StopStreamProcessor.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toStopStreamProcessor", [])

    @builtins.property # type: ignore
    @jsii.member(jsii_name="accessLevelList")
    def _access_level_list(self) -> "AccessLevelList":
        """
        stability
        :stability: experimental
        """
        return jsii.get(self, "accessLevelList")

    @_access_level_list.setter # type: ignore
    def _access_level_list(self, value: "AccessLevelList") -> None:
        jsii.set(self, "accessLevelList", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="servicePrefix")
    def service_prefix(self) -> builtins.str:
        """Holds the prefix of the service actions, e.g. ``ec2``.

        stability
        :stability: experimental
        """
        return jsii.get(self, "servicePrefix")

    @service_prefix.setter # type: ignore
    def service_prefix(self, value: builtins.str) -> None:
        jsii.set(self, "servicePrefix", value)


class ResourceExplorer(
    PolicyStatement,
    metaclass=jsii.JSIIMeta,
    jsii_type="iam-floyd.ResourceExplorer",
):
    """Statement provider for service `resource-explorer <https://docs.aws.amazon.com/service-authorization/latest/reference/list_awstageditor.html>`_.

    stability
    :stability: experimental
    """

    def __init__(self, sid: typing.Optional[builtins.str] = None) -> None:
        """Statement provider for service `resource-explorer <https://docs.aws.amazon.com/service-authorization/latest/reference/list_awstageditor.html>`_.

        :param sid: `SID <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html>`_ of the statement.

        stability
        :stability: experimental
        """
        jsii.create(ResourceExplorer, self, [sid])

    @jsii.member(jsii_name="toListResources")
    def to_list_resources(self) -> "ResourceExplorer":
        """Grants permission to retrieve the identifiers of the resources in the AWS account.

        Access Level: List

        https://docs.aws.amazon.com/ARG/latest/userguide/gettingstarted-prereqs.html#rg-permissions-te

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toListResources", [])

    @jsii.member(jsii_name="toListResourceTypes")
    def to_list_resource_types(self) -> "ResourceExplorer":
        """Grants permission to retrieve the resource types currently supported by Tag Editor.

        Access Level: List

        https://docs.aws.amazon.com/ARG/latest/userguide/gettingstarted-prereqs.html#rg-permissions-te

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toListResourceTypes", [])

    @jsii.member(jsii_name="toListTags")
    def to_list_tags(self) -> "ResourceExplorer":
        """Grants permission to retrieve the tags attached to the specified resource identifiers.

        Access Level: Read

        Dependent actions:

        - tag:GetResources

        https://docs.aws.amazon.com/ARG/latest/userguide/gettingstarted-prereqs.html#rg-permissions-te

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toListTags", [])

    @builtins.property # type: ignore
    @jsii.member(jsii_name="accessLevelList")
    def _access_level_list(self) -> "AccessLevelList":
        """
        stability
        :stability: experimental
        """
        return jsii.get(self, "accessLevelList")

    @_access_level_list.setter # type: ignore
    def _access_level_list(self, value: "AccessLevelList") -> None:
        jsii.set(self, "accessLevelList", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="servicePrefix")
    def service_prefix(self) -> builtins.str:
        """Holds the prefix of the service actions, e.g. ``ec2``.

        stability
        :stability: experimental
        """
        return jsii.get(self, "servicePrefix")

    @service_prefix.setter # type: ignore
    def service_prefix(self, value: builtins.str) -> None:
        jsii.set(self, "servicePrefix", value)


class ResourceGroups(
    PolicyStatement,
    metaclass=jsii.JSIIMeta,
    jsii_type="iam-floyd.ResourceGroups",
):
    """Statement provider for service `resource-groups <https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsresourcegroups.html>`_.

    stability
    :stability: experimental
    """

    def __init__(self, sid: typing.Optional[builtins.str] = None) -> None:
        """Statement provider for service `resource-groups <https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsresourcegroups.html>`_.

        :param sid: `SID <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html>`_ of the statement.

        stability
        :stability: experimental
        """
        jsii.create(ResourceGroups, self, [sid])

    @jsii.member(jsii_name="onGroup")
    def on_group(
        self,
        group_name: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "ResourceGroups":
        """Adds a resource of type group to the statement.

        https://docs.aws.amazon.com/ARG/latest/userguide/welcome.html

        :param group_name: - Identifier for the groupName.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``. Possible conditions: - .ifAwsResourceTag()

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "onGroup", [group_name, account, region, partition])

    @jsii.member(jsii_name="toCreateGroup")
    def to_create_group(self) -> "ResourceGroups":
        """Creates a group with a specified name, description, and resource query.

        Access Level: Write

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsTagKeys()

        https://docs.aws.amazon.com/ARG/latest/APIReference/API_CreateGroup.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toCreateGroup", [])

    @jsii.member(jsii_name="toDeleteGroup")
    def to_delete_group(self) -> "ResourceGroups":
        """Deletes a specified resource group.

        Access Level: Write

        https://docs.aws.amazon.com/ARG/latest/APIReference/API_DeleteGroup.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDeleteGroup", [])

    @jsii.member(jsii_name="toGetGroup")
    def to_get_group(self) -> "ResourceGroups":
        """Gets information of a specified resource group.

        Access Level: Read

        https://docs.aws.amazon.com/ARG/latest/APIReference/API_GetGroup.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toGetGroup", [])

    @jsii.member(jsii_name="toGetGroupQuery")
    def to_get_group_query(self) -> "ResourceGroups":
        """Gets the query associated with a specified resource group.

        Access Level: Read

        https://docs.aws.amazon.com/ARG/latest/APIReference/API_GetGroupQuery.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toGetGroupQuery", [])

    @jsii.member(jsii_name="toGetTags")
    def to_get_tags(self) -> "ResourceGroups":
        """Gets the tags associated with a specified resource group.

        Access Level: Read

        https://docs.aws.amazon.com/ARG/latest/APIReference/API_GetTags.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toGetTags", [])

    @jsii.member(jsii_name="toListGroupResources")
    def to_list_group_resources(self) -> "ResourceGroups":
        """Lists the resources that are member of a specified resource group.

        Access Level: List

        https://docs.aws.amazon.com/ARG/latest/APIReference/API_ListGroupResources.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toListGroupResources", [])

    @jsii.member(jsii_name="toListGroups")
    def to_list_groups(self) -> "ResourceGroups":
        """Lists all resource groups.

        Access Level: List

        https://docs.aws.amazon.com/ARG/latest/APIReference/API_ListGroups.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toListGroups", [])

    @jsii.member(jsii_name="toSearchResources")
    def to_search_resources(self) -> "ResourceGroups":
        """Returns a list of AWS resource identifiers matching the given query.

        Access Level: List

        https://docs.aws.amazon.com/ARG/latest/APIReference/API_SearchResources.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toSearchResources", [])

    @jsii.member(jsii_name="toTag")
    def to_tag(self) -> "ResourceGroups":
        """Tags a specified resource group.

        Access Level: Tagging

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsTagKeys()

        https://docs.aws.amazon.com/ARG/latest/APIReference/API_Tag.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toTag", [])

    @jsii.member(jsii_name="toUntag")
    def to_untag(self) -> "ResourceGroups":
        """Removes tags associated with a specified resource group.

        Access Level: Tagging

        Possible conditions:

        - .ifAwsTagKeys()

        https://docs.aws.amazon.com/ARG/latest/APIReference/API_Untag.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toUntag", [])

    @jsii.member(jsii_name="toUpdateGroup")
    def to_update_group(self) -> "ResourceGroups":
        """Updates a specified resource group.

        Access Level: Write

        https://docs.aws.amazon.com/ARG/latest/APIReference/API_UpdateGroup.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toUpdateGroup", [])

    @jsii.member(jsii_name="toUpdateGroupQuery")
    def to_update_group_query(self) -> "ResourceGroups":
        """Updates the query associated with a specified resource group.

        Access Level: Write

        https://docs.aws.amazon.com/ARG/latest/APIReference/API_UpdateGroupQuery.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toUpdateGroupQuery", [])

    @builtins.property # type: ignore
    @jsii.member(jsii_name="accessLevelList")
    def _access_level_list(self) -> "AccessLevelList":
        """
        stability
        :stability: experimental
        """
        return jsii.get(self, "accessLevelList")

    @_access_level_list.setter # type: ignore
    def _access_level_list(self, value: "AccessLevelList") -> None:
        jsii.set(self, "accessLevelList", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="servicePrefix")
    def service_prefix(self) -> builtins.str:
        """Holds the prefix of the service actions, e.g. ``ec2``.

        stability
        :stability: experimental
        """
        return jsii.get(self, "servicePrefix")

    @service_prefix.setter # type: ignore
    def service_prefix(self, value: builtins.str) -> None:
        jsii.set(self, "servicePrefix", value)


class Robomaker(
    PolicyStatement,
    metaclass=jsii.JSIIMeta,
    jsii_type="iam-floyd.Robomaker",
):
    """Statement provider for service `robomaker <https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsrobomaker.html>`_.

    stability
    :stability: experimental
    """

    def __init__(self, sid: typing.Optional[builtins.str] = None) -> None:
        """Statement provider for service `robomaker <https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsrobomaker.html>`_.

        :param sid: `SID <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html>`_ of the statement.

        stability
        :stability: experimental
        """
        jsii.create(Robomaker, self, [sid])

    @jsii.member(jsii_name="onDeploymentFleet")
    def on_deployment_fleet(
        self,
        fleet_name: builtins.str,
        created_on_epoch: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Robomaker":
        """Adds a resource of type deploymentFleet to the statement.

        https://docs.aws.amazon.com/robomaker/latest/dg/managing-simulation-applications.html

        :param fleet_name: - Identifier for the fleetName.
        :param created_on_epoch: - Identifier for the createdOnEpoch.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``. Possible conditions: - .ifAwsResourceTag()

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "onDeploymentFleet", [fleet_name, created_on_epoch, account, region, partition])

    @jsii.member(jsii_name="onDeploymentJob")
    def on_deployment_job(
        self,
        deployment_job_id: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Robomaker":
        """Adds a resource of type deploymentJob to the statement.

        https://docs.aws.amazon.com/robomaker/latest/dg/deployment.html

        :param deployment_job_id: - Identifier for the deploymentJobId.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``. Possible conditions: - .ifAwsResourceTag()

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "onDeploymentJob", [deployment_job_id, account, region, partition])

    @jsii.member(jsii_name="onRobot")
    def on_robot(
        self,
        robot_name: builtins.str,
        created_on_epoch: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Robomaker":
        """Adds a resource of type robot to the statement.

        https://docs.aws.amazon.com/robomaker/latest/dg/fleets.html

        :param robot_name: - Identifier for the robotName.
        :param created_on_epoch: - Identifier for the createdOnEpoch.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``. Possible conditions: - .ifAwsResourceTag()

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "onRobot", [robot_name, created_on_epoch, account, region, partition])

    @jsii.member(jsii_name="onRobotApplication")
    def on_robot_application(
        self,
        application_name: builtins.str,
        created_on_epoch: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Robomaker":
        """Adds a resource of type robotApplication to the statement.

        https://docs.aws.amazon.com/robomaker/latest/dg/managing-robot-applications.html

        :param application_name: - Identifier for the applicationName.
        :param created_on_epoch: - Identifier for the createdOnEpoch.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``. Possible conditions: - .ifAwsResourceTag()

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "onRobotApplication", [application_name, created_on_epoch, account, region, partition])

    @jsii.member(jsii_name="onSimulationApplication")
    def on_simulation_application(
        self,
        application_name: builtins.str,
        created_on_epoch: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Robomaker":
        """Adds a resource of type simulationApplication to the statement.

        https://docs.aws.amazon.com/robomaker/latest/dg/managing-simulation-applications.html

        :param application_name: - Identifier for the applicationName.
        :param created_on_epoch: - Identifier for the createdOnEpoch.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``. Possible conditions: - .ifAwsResourceTag()

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "onSimulationApplication", [application_name, created_on_epoch, account, region, partition])

    @jsii.member(jsii_name="onSimulationJob")
    def on_simulation_job(
        self,
        simulation_job_id: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Robomaker":
        """Adds a resource of type simulationJob to the statement.

        https://docs.aws.amazon.com/robomaker/latest/dg/simulation.html

        :param simulation_job_id: - Identifier for the simulationJobId.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``. Possible conditions: - .ifAwsResourceTag()

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "onSimulationJob", [simulation_job_id, account, region, partition])

    @jsii.member(jsii_name="onSimulationJobBatch")
    def on_simulation_job_batch(
        self,
        simulation_job_batch_id: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Robomaker":
        """Adds a resource of type simulationJobBatch to the statement.

        https://docs.aws.amazon.com/robomaker/latest/dg/simulation-job-batch.html

        :param simulation_job_batch_id: - Identifier for the simulationJobBatchId.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``. Possible conditions: - .ifAwsResourceTag()

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "onSimulationJobBatch", [simulation_job_batch_id, account, region, partition])

    @jsii.member(jsii_name="onWorld")
    def on_world(
        self,
        world_id: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Robomaker":
        """Adds a resource of type world to the statement.

        https://docs.aws.amazon.com/robomaker/latest/dg/worlds-managing-generated-worlds.html

        :param world_id: - Identifier for the worldId.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``. Possible conditions: - .ifAwsResourceTag()

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "onWorld", [world_id, account, region, partition])

    @jsii.member(jsii_name="onWorldExportJob")
    def on_world_export_job(
        self,
        world_export_job_id: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Robomaker":
        """Adds a resource of type worldExportJob to the statement.

        https://docs.aws.amazon.com/robomaker/latest/dg/worlds-managing-export-jobs.html

        :param world_export_job_id: - Identifier for the worldExportJobId.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``. Possible conditions: - .ifAwsResourceTag()

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "onWorldExportJob", [world_export_job_id, account, region, partition])

    @jsii.member(jsii_name="onWorldGenerationJob")
    def on_world_generation_job(
        self,
        world_generation_job_id: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Robomaker":
        """Adds a resource of type worldGenerationJob to the statement.

        https://docs.aws.amazon.com/robomaker/latest/dg/worlds-managing-generation-jobs.html

        :param world_generation_job_id: - Identifier for the worldGenerationJobId.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``. Possible conditions: - .ifAwsResourceTag()

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "onWorldGenerationJob", [world_generation_job_id, account, region, partition])

    @jsii.member(jsii_name="onWorldTemplate")
    def on_world_template(
        self,
        world_template_job_id: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Robomaker":
        """Adds a resource of type worldTemplate to the statement.

        https://docs.aws.amazon.com/robomaker/latest/dg/worlds-managing-simworld-templates.html

        :param world_template_job_id: - Identifier for the worldTemplateJobId.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``. Possible conditions: - .ifAwsResourceTag()

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "onWorldTemplate", [world_template_job_id, account, region, partition])

    @jsii.member(jsii_name="toBatchDeleteWorlds")
    def to_batch_delete_worlds(self) -> "Robomaker":
        """Delete one or more worlds in a batch operation.

        Access Level: Write

        https://docs.aws.amazon.com/robomaker/latest/dg/API_BatchDeleteWorlds.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toBatchDeleteWorlds", [])

    @jsii.member(jsii_name="toBatchDescribeSimulationJob")
    def to_batch_describe_simulation_job(self) -> "Robomaker":
        """Describe multiple simulation jobs.

        Access Level: Read

        https://docs.aws.amazon.com/robomaker/latest/dg/API_BatchDescribeSimulationJob.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toBatchDescribeSimulationJob", [])

    @jsii.member(jsii_name="toCancelDeploymentJob")
    def to_cancel_deployment_job(self) -> "Robomaker":
        """Cancel a deployment job.

        Access Level: Write

        https://docs.aws.amazon.com/robomaker/latest/dg/API_CancelDeploymentJob.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toCancelDeploymentJob", [])

    @jsii.member(jsii_name="toCancelSimulationJob")
    def to_cancel_simulation_job(self) -> "Robomaker":
        """Cancel a simulation job.

        Access Level: Write

        https://docs.aws.amazon.com/robomaker/latest/dg/API_CancelSimulationJob.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toCancelSimulationJob", [])

    @jsii.member(jsii_name="toCancelSimulationJobBatch")
    def to_cancel_simulation_job_batch(self) -> "Robomaker":
        """Cancel a simulation job batch.

        Access Level: Write

        https://docs.aws.amazon.com/robomaker/latest/dg/API_CancelSimulationJobBatch.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toCancelSimulationJobBatch", [])

    @jsii.member(jsii_name="toCancelWorldExportJob")
    def to_cancel_world_export_job(self) -> "Robomaker":
        """Cancel a world export job.

        Access Level: Write

        https://docs.aws.amazon.com/robomaker/latest/dg/API_CancelWorldExportJob.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toCancelWorldExportJob", [])

    @jsii.member(jsii_name="toCancelWorldGenerationJob")
    def to_cancel_world_generation_job(self) -> "Robomaker":
        """Cancel a world generation job.

        Access Level: Write

        https://docs.aws.amazon.com/robomaker/latest/dg/API_CancelWorldGenerationJob.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toCancelWorldGenerationJob", [])

    @jsii.member(jsii_name="toCreateDeploymentJob")
    def to_create_deployment_job(self) -> "Robomaker":
        """Create a deployment job.

        Access Level: Write

        Possible conditions:

        - .ifAwsTagKeys()
        - .ifAwsRequestTag()

        Dependent actions:

        - iam:CreateServiceLinkedRole

        https://docs.aws.amazon.com/robomaker/latest/dg/API_CreateDeploymentJob.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toCreateDeploymentJob", [])

    @jsii.member(jsii_name="toCreateFleet")
    def to_create_fleet(self) -> "Robomaker":
        """Create a deployment fleet that represents a logical group of robots running the same robot application.

        Access Level: Write

        Possible conditions:

        - .ifAwsTagKeys()
        - .ifAwsRequestTag()

        https://docs.aws.amazon.com/robomaker/latest/dg/API_CreateFleet.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toCreateFleet", [])

    @jsii.member(jsii_name="toCreateRobot")
    def to_create_robot(self) -> "Robomaker":
        """Create a robot that can be registered to a fleet.

        Access Level: Write

        Possible conditions:

        - .ifAwsTagKeys()
        - .ifAwsRequestTag()

        Dependent actions:

        - iam:CreateServiceLinkedRole

        https://docs.aws.amazon.com/robomaker/latest/dg/API_CreateRobot.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toCreateRobot", [])

    @jsii.member(jsii_name="toCreateRobotApplication")
    def to_create_robot_application(self) -> "Robomaker":
        """Create a robot application.

        Access Level: Write

        Possible conditions:

        - .ifAwsTagKeys()
        - .ifAwsRequestTag()

        https://docs.aws.amazon.com/robomaker/latest/dg/API_CreateRobotApplication.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toCreateRobotApplication", [])

    @jsii.member(jsii_name="toCreateRobotApplicationVersion")
    def to_create_robot_application_version(self) -> "Robomaker":
        """Create a snapshot of a robot application.

        Access Level: Write

        Dependent actions:

        - s3:GetObject

        https://docs.aws.amazon.com/robomaker/latest/dg/API_CreateRobotApplicationVersion.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toCreateRobotApplicationVersion", [])

    @jsii.member(jsii_name="toCreateSimulationApplication")
    def to_create_simulation_application(self) -> "Robomaker":
        """Create a simulation application.

        Access Level: Write

        Possible conditions:

        - .ifAwsTagKeys()
        - .ifAwsRequestTag()

        https://docs.aws.amazon.com/robomaker/latest/dg/API_CreateSimulationApplication.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toCreateSimulationApplication", [])

    @jsii.member(jsii_name="toCreateSimulationApplicationVersion")
    def to_create_simulation_application_version(self) -> "Robomaker":
        """Create a snapshot of a simulation application.

        Access Level: Write

        Dependent actions:

        - s3:GetObject

        https://docs.aws.amazon.com/robomaker/latest/dg/API_CreateSimulationApplicationVersion.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toCreateSimulationApplicationVersion", [])

    @jsii.member(jsii_name="toCreateSimulationJob")
    def to_create_simulation_job(self) -> "Robomaker":
        """Create a simulation job.

        Access Level: Write

        Possible conditions:

        - .ifAwsTagKeys()
        - .ifAwsRequestTag()

        Dependent actions:

        - iam:CreateServiceLinkedRole

        https://docs.aws.amazon.com/robomaker/latest/dg/API_CreateSimulationJob.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toCreateSimulationJob", [])

    @jsii.member(jsii_name="toCreateWorldExportJob")
    def to_create_world_export_job(self) -> "Robomaker":
        """Create a world export job.

        Access Level: Write

        https://docs.aws.amazon.com/robomaker/latest/dg/API_CreateWorldExportJob.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toCreateWorldExportJob", [])

    @jsii.member(jsii_name="toCreateWorldGenerationJob")
    def to_create_world_generation_job(self) -> "Robomaker":
        """Create a world generation job.

        Access Level: Write

        https://docs.aws.amazon.com/robomaker/latest/dg/API_CreateWorldGenerationJob.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toCreateWorldGenerationJob", [])

    @jsii.member(jsii_name="toCreateWorldTemplate")
    def to_create_world_template(self) -> "Robomaker":
        """Create a world template.

        Access Level: Write

        https://docs.aws.amazon.com/robomaker/latest/dg/API_CreateWorldTemplate.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toCreateWorldTemplate", [])

    @jsii.member(jsii_name="toDeleteFleet")
    def to_delete_fleet(self) -> "Robomaker":
        """Delete a deployment fleet.

        Access Level: Write

        https://docs.aws.amazon.com/robomaker/latest/dg/API_DeleteFleet.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDeleteFleet", [])

    @jsii.member(jsii_name="toDeleteRobot")
    def to_delete_robot(self) -> "Robomaker":
        """Delete a robot.

        Access Level: Write

        https://docs.aws.amazon.com/robomaker/latest/dg/API_DeleteRobot.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDeleteRobot", [])

    @jsii.member(jsii_name="toDeleteRobotApplication")
    def to_delete_robot_application(self) -> "Robomaker":
        """Delete a robot application.

        Access Level: Write

        https://docs.aws.amazon.com/robomaker/latest/dg/API_DeleteRobotApplication.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDeleteRobotApplication", [])

    @jsii.member(jsii_name="toDeleteSimulationApplication")
    def to_delete_simulation_application(self) -> "Robomaker":
        """Delete a simulation application.

        Access Level: Write

        https://docs.aws.amazon.com/robomaker/latest/dg/API_DeleteSimulationApplication.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDeleteSimulationApplication", [])

    @jsii.member(jsii_name="toDeleteWorldTemplate")
    def to_delete_world_template(self) -> "Robomaker":
        """Delete a world template.

        Access Level: Write

        https://docs.aws.amazon.com/robomaker/latest/dg/API_DeleteWorldTemplate.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDeleteWorldTemplate", [])

    @jsii.member(jsii_name="toDeregisterRobot")
    def to_deregister_robot(self) -> "Robomaker":
        """Deregister a robot from a fleet.

        Access Level: Write

        https://docs.aws.amazon.com/robomaker/latest/dg/API_DeregisterRobot.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDeregisterRobot", [])

    @jsii.member(jsii_name="toDescribeDeploymentJob")
    def to_describe_deployment_job(self) -> "Robomaker":
        """Describe a deployment job.

        Access Level: Read

        https://docs.aws.amazon.com/robomaker/latest/dg/API_DescribeDeploymentJob.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDescribeDeploymentJob", [])

    @jsii.member(jsii_name="toDescribeFleet")
    def to_describe_fleet(self) -> "Robomaker":
        """Describe a deployment fleet.

        Access Level: Read

        https://docs.aws.amazon.com/robomaker/latest/dg/API_DescribeFleet.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDescribeFleet", [])

    @jsii.member(jsii_name="toDescribeRobot")
    def to_describe_robot(self) -> "Robomaker":
        """Describe a robot.

        Access Level: Read

        https://docs.aws.amazon.com/robomaker/latest/dg/API_DescribeRobot.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDescribeRobot", [])

    @jsii.member(jsii_name="toDescribeRobotApplication")
    def to_describe_robot_application(self) -> "Robomaker":
        """Describe a robot application.

        Access Level: Read

        https://docs.aws.amazon.com/robomaker/latest/dg/API_DescribeRobotApplication.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDescribeRobotApplication", [])

    @jsii.member(jsii_name="toDescribeSimulationApplication")
    def to_describe_simulation_application(self) -> "Robomaker":
        """Describe a simulation application.

        Access Level: Read

        https://docs.aws.amazon.com/robomaker/latest/dg/API_DescribeSimulationApplication.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDescribeSimulationApplication", [])

    @jsii.member(jsii_name="toDescribeSimulationJob")
    def to_describe_simulation_job(self) -> "Robomaker":
        """Describe a simulation job.

        Access Level: Read

        https://docs.aws.amazon.com/robomaker/latest/dg/API_DescribeSimulationJob.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDescribeSimulationJob", [])

    @jsii.member(jsii_name="toDescribeSimulationJobBatch")
    def to_describe_simulation_job_batch(self) -> "Robomaker":
        """Describe a simulation job batch.

        Access Level: Read

        https://docs.aws.amazon.com/robomaker/latest/dg/API_DescribeSimulationJobBatch.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDescribeSimulationJobBatch", [])

    @jsii.member(jsii_name="toDescribeWorld")
    def to_describe_world(self) -> "Robomaker":
        """Describe a world.

        Access Level: Read

        https://docs.aws.amazon.com/robomaker/latest/dg/API_DescribeWorld.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDescribeWorld", [])

    @jsii.member(jsii_name="toDescribeWorldExportJob")
    def to_describe_world_export_job(self) -> "Robomaker":
        """Describe a world export job.

        Access Level: Read

        https://docs.aws.amazon.com/robomaker/latest/dg/API_DescribeWorldExportJob.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDescribeWorldExportJob", [])

    @jsii.member(jsii_name="toDescribeWorldGenerationJob")
    def to_describe_world_generation_job(self) -> "Robomaker":
        """Describe a world generation job.

        Access Level: Read

        https://docs.aws.amazon.com/robomaker/latest/dg/API_DescribeWorldGenerationJob.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDescribeWorldGenerationJob", [])

    @jsii.member(jsii_name="toDescribeWorldTemplate")
    def to_describe_world_template(self) -> "Robomaker":
        """Describe a world template.

        Access Level: Read

        https://docs.aws.amazon.com/robomaker/latest/dg/API_DescribeWorldTemplate.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDescribeWorldTemplate", [])

    @jsii.member(jsii_name="toGetWorldTemplateBody")
    def to_get_world_template_body(self) -> "Robomaker":
        """Get the body of a world template.

        Access Level: Read

        https://docs.aws.amazon.com/robomaker/latest/dg/API_GetWorldTemplateBody.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toGetWorldTemplateBody", [])

    @jsii.member(jsii_name="toListDeploymentJobs")
    def to_list_deployment_jobs(self) -> "Robomaker":
        """List deployment jobs.

        Access Level: List

        https://docs.aws.amazon.com/robomaker/latest/dg/API_ListDeploymentJobs.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toListDeploymentJobs", [])

    @jsii.member(jsii_name="toListFleets")
    def to_list_fleets(self) -> "Robomaker":
        """List fleets.

        Access Level: List

        https://docs.aws.amazon.com/robomaker/latest/dg/API_ListFleets.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toListFleets", [])

    @jsii.member(jsii_name="toListRobotApplications")
    def to_list_robot_applications(self) -> "Robomaker":
        """List robot applications.

        Access Level: List

        https://docs.aws.amazon.com/robomaker/latest/dg/API_ListRobotApplications.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toListRobotApplications", [])

    @jsii.member(jsii_name="toListRobots")
    def to_list_robots(self) -> "Robomaker":
        """List robots.

        Access Level: List

        https://docs.aws.amazon.com/robomaker/latest/dg/API_ListRobots.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toListRobots", [])

    @jsii.member(jsii_name="toListSimulationApplications")
    def to_list_simulation_applications(self) -> "Robomaker":
        """List simulation applications.

        Access Level: List

        https://docs.aws.amazon.com/robomaker/latest/dg/API_ListSimulationApplications.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toListSimulationApplications", [])

    @jsii.member(jsii_name="toListSimulationJobBatches")
    def to_list_simulation_job_batches(self) -> "Robomaker":
        """List simulation job batches.

        Access Level: List

        https://docs.aws.amazon.com/robomaker/latest/dg/API_ListSimulationJobBatches.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toListSimulationJobBatches", [])

    @jsii.member(jsii_name="toListSimulationJobs")
    def to_list_simulation_jobs(self) -> "Robomaker":
        """List simulation jobs.

        Access Level: List

        https://docs.aws.amazon.com/robomaker/latest/dg/API_ListSimulationJobs.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toListSimulationJobs", [])

    @jsii.member(jsii_name="toListSupportedAvailabilityZones")
    def to_list_supported_availability_zones(self) -> "Robomaker":
        """Lists supported availability zones.

        Access Level: List

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toListSupportedAvailabilityZones", [])

    @jsii.member(jsii_name="toListTagsForResource")
    def to_list_tags_for_resource(self) -> "Robomaker":
        """List tags for a RoboMaker resource.

        Access Level: List

        https://docs.aws.amazon.com/robomaker/latest/dg/API_ListTagsForResource.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toListTagsForResource", [])

    @jsii.member(jsii_name="toListWorldExportJobs")
    def to_list_world_export_jobs(self) -> "Robomaker":
        """List world export jobs.

        Access Level: List

        https://docs.aws.amazon.com/robomaker/latest/dg/API_ListWorldExportJobs.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toListWorldExportJobs", [])

    @jsii.member(jsii_name="toListWorldGenerationJobs")
    def to_list_world_generation_jobs(self) -> "Robomaker":
        """List world generation jobs.

        Access Level: List

        https://docs.aws.amazon.com/robomaker/latest/dg/API_ListWorldGenerationJobs.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toListWorldGenerationJobs", [])

    @jsii.member(jsii_name="toListWorlds")
    def to_list_worlds(self) -> "Robomaker":
        """List worlds.

        Access Level: List

        https://docs.aws.amazon.com/robomaker/latest/dg/API_ListWorlds.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toListWorlds", [])

    @jsii.member(jsii_name="toListWorldTemplates")
    def to_list_world_templates(self) -> "Robomaker":
        """List world templates.

        Access Level: List

        https://docs.aws.amazon.com/robomaker/latest/dg/API_ListWorldTemplates.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toListWorldTemplates", [])

    @jsii.member(jsii_name="toRegisterRobot")
    def to_register_robot(self) -> "Robomaker":
        """Register a robot to a fleet.

        Access Level: Write

        https://docs.aws.amazon.com/robomaker/latest/dg/API_RegisterRobot.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toRegisterRobot", [])

    @jsii.member(jsii_name="toRestartSimulationJob")
    def to_restart_simulation_job(self) -> "Robomaker":
        """Restart a running simulation job.

        Access Level: Write

        https://docs.aws.amazon.com/robomaker/latest/dg/API_RestartSimulationJob.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toRestartSimulationJob", [])

    @jsii.member(jsii_name="toStartSimulationJobBatch")
    def to_start_simulation_job_batch(self) -> "Robomaker":
        """Create a simulation job batch.

        Access Level: Write

        Possible conditions:

        - .ifAwsTagKeys()
        - .ifAwsRequestTag()

        Dependent actions:

        - iam:CreateServiceLinkedRole

        https://docs.aws.amazon.com/robomaker/latest/dg/API_StartSimulationJobBatch.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toStartSimulationJobBatch", [])

    @jsii.member(jsii_name="toSyncDeploymentJob")
    def to_sync_deployment_job(self) -> "Robomaker":
        """Ensures the most recently deployed robot application is deployed to all robots in the fleet.

        Access Level: Write

        Dependent actions:

        - iam:CreateServiceLinkedRole

        https://docs.aws.amazon.com/robomaker/latest/dg/API_SyncDeploymentJob.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toSyncDeploymentJob", [])

    @jsii.member(jsii_name="toTagResource")
    def to_tag_resource(self) -> "Robomaker":
        """Add tags to a RoboMaker resource.

        Access Level: Write

        Possible conditions:

        - .ifAwsTagKeys()
        - .ifAwsRequestTag()

        https://docs.aws.amazon.com/robomaker/latest/dg/API_TagResource.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toTagResource", [])

    @jsii.member(jsii_name="toUntagResource")
    def to_untag_resource(self) -> "Robomaker":
        """Remove tags from a RoboMaker resource.

        Access Level: Write

        Possible conditions:

        - .ifAwsTagKeys()

        https://docs.aws.amazon.com/robomaker/latest/dg/API_UntagResource.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toUntagResource", [])

    @jsii.member(jsii_name="toUpdateRobotApplication")
    def to_update_robot_application(self) -> "Robomaker":
        """Update a robot application.

        Access Level: Write

        https://docs.aws.amazon.com/robomaker/latest/dg/API_UpdateRobotApplication.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toUpdateRobotApplication", [])

    @jsii.member(jsii_name="toUpdateRobotDeployment")
    def to_update_robot_deployment(self) -> "Robomaker":
        """Report the deployment status for an individual robot.

        Access Level: Write

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toUpdateRobotDeployment", [])

    @jsii.member(jsii_name="toUpdateSimulationApplication")
    def to_update_simulation_application(self) -> "Robomaker":
        """Update a simulation application.

        Access Level: Write

        https://docs.aws.amazon.com/robomaker/latest/dg/API_UpdateSimulationApplication.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toUpdateSimulationApplication", [])

    @jsii.member(jsii_name="toUpdateWorldTemplate")
    def to_update_world_template(self) -> "Robomaker":
        """Update a world template.

        Access Level: Write

        https://docs.aws.amazon.com/robomaker/latest/dg/API_UpdateWorldTemplate.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toUpdateWorldTemplate", [])

    @builtins.property # type: ignore
    @jsii.member(jsii_name="accessLevelList")
    def _access_level_list(self) -> "AccessLevelList":
        """
        stability
        :stability: experimental
        """
        return jsii.get(self, "accessLevelList")

    @_access_level_list.setter # type: ignore
    def _access_level_list(self, value: "AccessLevelList") -> None:
        jsii.set(self, "accessLevelList", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="servicePrefix")
    def service_prefix(self) -> builtins.str:
        """Holds the prefix of the service actions, e.g. ``ec2``.

        stability
        :stability: experimental
        """
        return jsii.get(self, "servicePrefix")

    @service_prefix.setter # type: ignore
    def service_prefix(self, value: builtins.str) -> None:
        jsii.set(self, "servicePrefix", value)


class Route53(PolicyStatement, metaclass=jsii.JSIIMeta, jsii_type="iam-floyd.Route53"):
    """Statement provider for service `route53 <https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonroute53.html>`_.

    stability
    :stability: experimental
    """

    def __init__(self, sid: typing.Optional[builtins.str] = None) -> None:
        """Statement provider for service `route53 <https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonroute53.html>`_.

        :param sid: `SID <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html>`_ of the statement.

        stability
        :stability: experimental
        """
        jsii.create(Route53, self, [sid])

    @jsii.member(jsii_name="onChange")
    def on_change(
        self,
        id: builtins.str,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Route53":
        """Adds a resource of type change to the statement.

        https://docs.aws.amazon.com/Route53/latest/APIReference/API_Change.html

        :param id: - Identifier for the id.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "onChange", [id, partition])

    @jsii.member(jsii_name="onDelegationset")
    def on_delegationset(
        self,
        id: builtins.str,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Route53":
        """Adds a resource of type delegationset to the statement.

        https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/route-53-concepts.html#route-53-concepts-reusable-delegation-set

        :param id: - Identifier for the id.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "onDelegationset", [id, partition])

    @jsii.member(jsii_name="onHealthcheck")
    def on_healthcheck(
        self,
        id: builtins.str,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Route53":
        """Adds a resource of type healthcheck to the statement.

        https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/route-53-concepts.html#route-53-concepts-health-check

        :param id: - Identifier for the id.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "onHealthcheck", [id, partition])

    @jsii.member(jsii_name="onHostedzone")
    def on_hostedzone(
        self,
        id: builtins.str,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Route53":
        """Adds a resource of type hostedzone to the statement.

        https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/route-53-concepts.html#route-53-concepts-hosted-zone

        :param id: - Identifier for the id.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "onHostedzone", [id, partition])

    @jsii.member(jsii_name="onQueryloggingconfig")
    def on_queryloggingconfig(
        self,
        id: builtins.str,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Route53":
        """Adds a resource of type queryloggingconfig to the statement.

        https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/query-logs.html

        :param id: - Identifier for the id.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "onQueryloggingconfig", [id, partition])

    @jsii.member(jsii_name="onTrafficpolicy")
    def on_trafficpolicy(
        self,
        id: builtins.str,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Route53":
        """Adds a resource of type trafficpolicy to the statement.

        https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/traffic-policies.html

        :param id: - Identifier for the id.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "onTrafficpolicy", [id, partition])

    @jsii.member(jsii_name="onTrafficpolicyinstance")
    def on_trafficpolicyinstance(
        self,
        id: builtins.str,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Route53":
        """Adds a resource of type trafficpolicyinstance to the statement.

        https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/traffic-policy-records.html

        :param id: - Identifier for the id.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "onTrafficpolicyinstance", [id, partition])

    @jsii.member(jsii_name="onVpc")
    def on_vpc(
        self,
        vpc_id: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Route53":
        """Adds a resource of type vpc to the statement.

        https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html

        :param vpc_id: - Identifier for the vpcId.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "onVpc", [vpc_id, account, region, partition])

    @jsii.member(jsii_name="toAssociateVPCWithHostedZone")
    def to_associate_vpc_with_hosted_zone(self) -> "Route53":
        """Grants permission to associate an additional Amazon VPC with a private hosted zone.

        Access Level: Write

        Dependent actions:

        - ec2:DescribeVpcs

        https://docs.aws.amazon.com/Route53/latest/APIReference/API_AssociateVPCWithHostedZone.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toAssociateVPCWithHostedZone", [])

    @jsii.member(jsii_name="toChangeResourceRecordSets")
    def to_change_resource_record_sets(self) -> "Route53":
        """Grants permission to create, update, or delete a record, which contains authoritative DNS information for a specified domain or subdomain name.

        Access Level: Write

        https://docs.aws.amazon.com/Route53/latest/APIReference/API_ChangeResourceRecordSets.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toChangeResourceRecordSets", [])

    @jsii.member(jsii_name="toChangeTagsForResource")
    def to_change_tags_for_resource(self) -> "Route53":
        """Grants permission to add, edit, or delete tags for a health check or a hosted zone.

        Access Level: Tagging

        https://docs.aws.amazon.com/Route53/latest/APIReference/API_ChangeTagsForResource.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toChangeTagsForResource", [])

    @jsii.member(jsii_name="toCreateHealthCheck")
    def to_create_health_check(self) -> "Route53":
        """Grants permission to create a new health check, which monitors the health and performance of your web applications, web servers, and other resources.

        Access Level: Write

        https://docs.aws.amazon.com/Route53/latest/APIReference/API_CreateHealthCheck.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toCreateHealthCheck", [])

    @jsii.member(jsii_name="toCreateHostedZone")
    def to_create_hosted_zone(self) -> "Route53":
        """Grants permission to create a public hosted zone, which you use to specify how the Domain Name System (DNS) routes traffic on the Internet for a domain, such as example.com, and its subdomains.

        Access Level: Write

        Dependent actions:

        - ec2:DescribeVpcs

        https://docs.aws.amazon.com/Route53/latest/APIReference/API_CreateHostedZone.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toCreateHostedZone", [])

    @jsii.member(jsii_name="toCreateQueryLoggingConfig")
    def to_create_query_logging_config(self) -> "Route53":
        """Grants permission to create a configuration for DNS query logging.

        Access Level: Write

        https://docs.aws.amazon.com/Route53/latest/APIReference/API_CreateQueryLoggingConfig.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toCreateQueryLoggingConfig", [])

    @jsii.member(jsii_name="toCreateReusableDelegationSet")
    def to_create_reusable_delegation_set(self) -> "Route53":
        """Grants permission to create a delegation set (a group of four name servers) that can be reused by multiple hosted zones.

        Access Level: Write

        https://docs.aws.amazon.com/Route53/latest/APIReference/API_CreateReusableDelegationSet.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toCreateReusableDelegationSet", [])

    @jsii.member(jsii_name="toCreateTrafficPolicy")
    def to_create_traffic_policy(self) -> "Route53":
        """Grants permission to create a traffic policy, which you use to create multiple DNS records for one domain name (such as example.com) or one subdomain name (such as www.example.com).

        Access Level: Write

        https://docs.aws.amazon.com/Route53/latest/APIReference/API_CreateTrafficPolicy.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toCreateTrafficPolicy", [])

    @jsii.member(jsii_name="toCreateTrafficPolicyInstance")
    def to_create_traffic_policy_instance(self) -> "Route53":
        """Grants permission to create records in a specified hosted zone based on the settings in a specified traffic policy version.

        Access Level: Write

        https://docs.aws.amazon.com/Route53/latest/APIReference/API_CreateTrafficPolicyInstance.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toCreateTrafficPolicyInstance", [])

    @jsii.member(jsii_name="toCreateTrafficPolicyVersion")
    def to_create_traffic_policy_version(self) -> "Route53":
        """Grants permission to create a new version of an existing traffic policy.

        Access Level: Write

        https://docs.aws.amazon.com/Route53/latest/APIReference/API_CreateTrafficPolicyVersion.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toCreateTrafficPolicyVersion", [])

    @jsii.member(jsii_name="toCreateVPCAssociationAuthorization")
    def to_create_vpc_association_authorization(self) -> "Route53":
        """Grants permission to authorize the AWS account that created a specified VPC to submit an AssociateVPCWithHostedZone request, which associates the VPC with a specified hosted zone that was created by a different account.

        Access Level: Write

        https://docs.aws.amazon.com/Route53/latest/APIReference/API_CreateVPCAssociationAuthorization.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toCreateVPCAssociationAuthorization", [])

    @jsii.member(jsii_name="toDeleteHealthCheck")
    def to_delete_health_check(self) -> "Route53":
        """Grants permission to delete a health check.

        Access Level: Write

        https://docs.aws.amazon.com/Route53/latest/APIReference/API_DeleteHealthCheck.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDeleteHealthCheck", [])

    @jsii.member(jsii_name="toDeleteHostedZone")
    def to_delete_hosted_zone(self) -> "Route53":
        """Grants permission to delete a hosted zone.

        Access Level: Write

        https://docs.aws.amazon.com/Route53/latest/APIReference/API_DeleteHostedZone.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDeleteHostedZone", [])

    @jsii.member(jsii_name="toDeleteQueryLoggingConfig")
    def to_delete_query_logging_config(self) -> "Route53":
        """Grants permission to delete a configuration for DNS query logging.

        Access Level: Write

        https://docs.aws.amazon.com/Route53/latest/APIReference/API_DeleteQueryLoggingConfig.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDeleteQueryLoggingConfig", [])

    @jsii.member(jsii_name="toDeleteReusableDelegationSet")
    def to_delete_reusable_delegation_set(self) -> "Route53":
        """Grants permission to delete a reusable delegation set.

        Access Level: Write

        https://docs.aws.amazon.com/Route53/latest/APIReference/API_DeleteReusableDelegationSet.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDeleteReusableDelegationSet", [])

    @jsii.member(jsii_name="toDeleteTrafficPolicy")
    def to_delete_traffic_policy(self) -> "Route53":
        """Grants permission to delete a traffic policy.

        Access Level: Write

        https://docs.aws.amazon.com/Route53/latest/APIReference/API_DeleteTrafficPolicy.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDeleteTrafficPolicy", [])

    @jsii.member(jsii_name="toDeleteTrafficPolicyInstance")
    def to_delete_traffic_policy_instance(self) -> "Route53":
        """Grants permission to delete a traffic policy instance and all the records that Route 53 created when you created the instance.

        Access Level: Write

        https://docs.aws.amazon.com/Route53/latest/APIReference/API_DeleteTrafficPolicyInstance.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDeleteTrafficPolicyInstance", [])

    @jsii.member(jsii_name="toDeleteVPCAssociationAuthorization")
    def to_delete_vpc_association_authorization(self) -> "Route53":
        """Grants permission to remove authorization for associating an Amazon Virtual Private Cloud with a Route 53 private hosted zone.

        Access Level: Write

        https://docs.aws.amazon.com/Route53/latest/APIReference/API_DeleteVPCAssociationAuthorization.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDeleteVPCAssociationAuthorization", [])

    @jsii.member(jsii_name="toDisassociateVPCFromHostedZone")
    def to_disassociate_vpc_from_hosted_zone(self) -> "Route53":
        """Grants permission to disassociate an Amazon Virtual Private Cloud from a Route 53 private hosted zone.

        Access Level: Write

        Dependent actions:

        - ec2:DescribeVpcs

        https://docs.aws.amazon.com/Route53/latest/APIReference/API_DisassociateVPCFromHostedZone.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDisassociateVPCFromHostedZone", [])

    @jsii.member(jsii_name="toGetAccountLimit")
    def to_get_account_limit(self) -> "Route53":
        """Grants permission to get the specified limit for the current account, for example, the maximum number of health checks that you can create using the account.

        Access Level: Read

        https://docs.aws.amazon.com/Route53/latest/APIReference/API_GetAccountLimit.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toGetAccountLimit", [])

    @jsii.member(jsii_name="toGetChange")
    def to_get_change(self) -> "Route53":
        """Grants permission to get the current status of a request to create, update, or delete one or more records.

        Access Level: List

        https://docs.aws.amazon.com/Route53/latest/APIReference/API_GetChange.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toGetChange", [])

    @jsii.member(jsii_name="toGetCheckerIpRanges")
    def to_get_checker_ip_ranges(self) -> "Route53":
        """Grants permission to get a list of the IP ranges that are used by Route 53 health checkers to check the health of your resources.

        Access Level: List

        https://docs.aws.amazon.com/Route53/latest/APIReference/API_GetCheckerIpRanges.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toGetCheckerIpRanges", [])

    @jsii.member(jsii_name="toGetGeoLocation")
    def to_get_geo_location(self) -> "Route53":
        """Grants permission to get information about whether a specified geographic location is supported for Route 53 geolocation records.

        Access Level: List

        https://docs.aws.amazon.com/Route53/latest/APIReference/API_GetGeoLocation.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toGetGeoLocation", [])

    @jsii.member(jsii_name="toGetHealthCheck")
    def to_get_health_check(self) -> "Route53":
        """Grants permission to get information about a specified health check.

        Access Level: Read

        https://docs.aws.amazon.com/Route53/latest/APIReference/API_GetHealthCheck.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toGetHealthCheck", [])

    @jsii.member(jsii_name="toGetHealthCheckCount")
    def to_get_health_check_count(self) -> "Route53":
        """Grants permission to get the number of health checks that are associated with the current AWS account.

        Access Level: List

        https://docs.aws.amazon.com/Route53/latest/APIReference/API_GetHealthCheckCount.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toGetHealthCheckCount", [])

    @jsii.member(jsii_name="toGetHealthCheckLastFailureReason")
    def to_get_health_check_last_failure_reason(self) -> "Route53":
        """Grants permission to get the reason that a specified health check failed most recently.

        Access Level: List

        https://docs.aws.amazon.com/Route53/latest/APIReference/API_GetHealthCheckLastFailureReason.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toGetHealthCheckLastFailureReason", [])

    @jsii.member(jsii_name="toGetHealthCheckStatus")
    def to_get_health_check_status(self) -> "Route53":
        """Grants permission to get the status of a specified health check.

        Access Level: List

        https://docs.aws.amazon.com/Route53/latest/APIReference/API_GetHealthCheckStatus.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toGetHealthCheckStatus", [])

    @jsii.member(jsii_name="toGetHostedZone")
    def to_get_hosted_zone(self) -> "Route53":
        """Grants permission to get information about a specified hosted zone including the four name servers that Route 53 assigned to the hosted zone.

        Access Level: List

        https://docs.aws.amazon.com/Route53/latest/APIReference/API_GetHostedZone.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toGetHostedZone", [])

    @jsii.member(jsii_name="toGetHostedZoneCount")
    def to_get_hosted_zone_count(self) -> "Route53":
        """Grants permission to get the number of hosted zones that are associated with the current AWS account.

        Access Level: List

        https://docs.aws.amazon.com/Route53/latest/APIReference/API_GetHostedZoneCount.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toGetHostedZoneCount", [])

    @jsii.member(jsii_name="toGetHostedZoneLimit")
    def to_get_hosted_zone_limit(self) -> "Route53":
        """Grants permission to get the specified limit for a specified hosted zone.

        Access Level: Read

        https://docs.aws.amazon.com/Route53/latest/APIReference/API_GetHostedZoneLimit.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toGetHostedZoneLimit", [])

    @jsii.member(jsii_name="toGetQueryLoggingConfig")
    def to_get_query_logging_config(self) -> "Route53":
        """Grants permission to get information about a specified configuration for DNS query logging.

        Access Level: Read

        https://docs.aws.amazon.com/Route53/latest/APIReference/API_GetQueryLoggingConfig.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toGetQueryLoggingConfig", [])

    @jsii.member(jsii_name="toGetReusableDelegationSet")
    def to_get_reusable_delegation_set(self) -> "Route53":
        """Grants permission to get information about a specified reusable delegation set, including the four name servers that are assigned to the delegation set.

        Access Level: List

        https://docs.aws.amazon.com/Route53/latest/APIReference/API_GetReusableDelegationSet.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toGetReusableDelegationSet", [])

    @jsii.member(jsii_name="toGetReusableDelegationSetLimit")
    def to_get_reusable_delegation_set_limit(self) -> "Route53":
        """Grants permission to get the maximum number of hosted zones that you can associate with the specified reusable delegation set.

        Access Level: Read

        https://docs.aws.amazon.com/Route53/latest/APIReference/API_GetReusableDelegationSetLimit.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toGetReusableDelegationSetLimit", [])

    @jsii.member(jsii_name="toGetTrafficPolicy")
    def to_get_traffic_policy(self) -> "Route53":
        """Grants permission to get information about a specified traffic policy version.

        Access Level: Read

        https://docs.aws.amazon.com/Route53/latest/APIReference/API_GetTrafficPolicy.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toGetTrafficPolicy", [])

    @jsii.member(jsii_name="toGetTrafficPolicyInstance")
    def to_get_traffic_policy_instance(self) -> "Route53":
        """Grants permission to get information about a specified traffic policy instance.

        Access Level: Read

        https://docs.aws.amazon.com/Route53/latest/APIReference/API_GetTrafficPolicyInstance.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toGetTrafficPolicyInstance", [])

    @jsii.member(jsii_name="toGetTrafficPolicyInstanceCount")
    def to_get_traffic_policy_instance_count(self) -> "Route53":
        """Grants permission to get the number of traffic policy instances that are associated with the current AWS account.

        Access Level: Read

        https://docs.aws.amazon.com/Route53/latest/APIReference/API_GetTrafficPolicyInstanceCount.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toGetTrafficPolicyInstanceCount", [])

    @jsii.member(jsii_name="toListGeoLocations")
    def to_list_geo_locations(self) -> "Route53":
        """Grants permission to get a list of geographic locations that Route 53 supports for geolocation.

        Access Level: List

        https://docs.aws.amazon.com/Route53/latest/APIReference/API_ListGeoLocations.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toListGeoLocations", [])

    @jsii.member(jsii_name="toListHealthChecks")
    def to_list_health_checks(self) -> "Route53":
        """Grants permission to get a list of the health checks that are associated with the current AWS account.

        Access Level: List

        https://docs.aws.amazon.com/Route53/latest/APIReference/API_ListHealthChecks.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toListHealthChecks", [])

    @jsii.member(jsii_name="toListHostedZones")
    def to_list_hosted_zones(self) -> "Route53":
        """Grants permission to get a list of the public and private hosted zones that are associated with the current AWS account.

        Access Level: List

        https://docs.aws.amazon.com/Route53/latest/APIReference/API_ListHostedZones.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toListHostedZones", [])

    @jsii.member(jsii_name="toListHostedZonesByName")
    def to_list_hosted_zones_by_name(self) -> "Route53":
        """Grants permission to get a list of your hosted zones in lexicographic order.

        Hosted zones are sorted by name with the labels reversed, for example, com.example.www.

        Access Level: List

        https://docs.aws.amazon.com/Route53/latest/APIReference/API_ListHostedZonesByName.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toListHostedZonesByName", [])

    @jsii.member(jsii_name="toListHostedZonesByVPC")
    def to_list_hosted_zones_by_vpc(self) -> "Route53":
        """Grants permission to get a list of all the private hosted zones that a specified VPC is associated with.

        Access Level: List

        Dependent actions:

        - ec2:DescribeVpcs

        https://docs.aws.amazon.com/Route53/latest/APIReference/API_ListHostedZonesByVPC.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toListHostedZonesByVPC", [])

    @jsii.member(jsii_name="toListQueryLoggingConfigs")
    def to_list_query_logging_configs(self) -> "Route53":
        """Grants permission to list the configurations for DNS query logging that are associated with the current AWS account or the configuration that is associated with a specified hosted zone.

        Access Level: List

        https://docs.aws.amazon.com/Route53/latest/APIReference/API_ListQueryLoggingConfigs.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toListQueryLoggingConfigs", [])

    @jsii.member(jsii_name="toListResourceRecordSets")
    def to_list_resource_record_sets(self) -> "Route53":
        """Grants permission to list the records in a specified hosted zone.

        Access Level: List

        https://docs.aws.amazon.com/Route53/latest/APIReference/API_ListResourceRecordSets.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toListResourceRecordSets", [])

    @jsii.member(jsii_name="toListReusableDelegationSets")
    def to_list_reusable_delegation_sets(self) -> "Route53":
        """Grants permission to list the reusable delegation sets that are associated with the current AWS account.

        Access Level: List

        https://docs.aws.amazon.com/Route53/latest/APIReference/API_ListReusableDelegationSets.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toListReusableDelegationSets", [])

    @jsii.member(jsii_name="toListTagsForResource")
    def to_list_tags_for_resource(self) -> "Route53":
        """Grants permission to list tags for one health check or hosted zone.

        Access Level: List

        https://docs.aws.amazon.com/Route53/latest/APIReference/API_ListTagsForResource.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toListTagsForResource", [])

    @jsii.member(jsii_name="toListTagsForResources")
    def to_list_tags_for_resources(self) -> "Route53":
        """Grants permission to list tags for up to 10 health checks or hosted zones.

        Access Level: List

        https://docs.aws.amazon.com/Route53/latest/APIReference/API_ListTagsForResources.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toListTagsForResources", [])

    @jsii.member(jsii_name="toListTrafficPolicies")
    def to_list_traffic_policies(self) -> "Route53":
        """Grants permission to get information about the latest version for every traffic policy that is associated with the current AWS account.

        Policies are listed in the order in which they were created.

        Access Level: List

        https://docs.aws.amazon.com/Route53/latest/APIReference/API_ListTrafficPolicies.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toListTrafficPolicies", [])

    @jsii.member(jsii_name="toListTrafficPolicyInstances")
    def to_list_traffic_policy_instances(self) -> "Route53":
        """Grants permission to get information about the traffic policy instances that you created by using the current AWS account.

        Access Level: List

        https://docs.aws.amazon.com/Route53/latest/APIReference/API_ListTrafficPolicyInstances.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toListTrafficPolicyInstances", [])

    @jsii.member(jsii_name="toListTrafficPolicyInstancesByHostedZone")
    def to_list_traffic_policy_instances_by_hosted_zone(self) -> "Route53":
        """Grants permission to get information about the traffic policy instances that you created in a specified hosted zone.

        Access Level: List

        https://docs.aws.amazon.com/Route53/latest/APIReference/API_ListTrafficPolicyInstancesByHostedZone.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toListTrafficPolicyInstancesByHostedZone", [])

    @jsii.member(jsii_name="toListTrafficPolicyInstancesByPolicy")
    def to_list_traffic_policy_instances_by_policy(self) -> "Route53":
        """Grants permission to get information about the traffic policy instances that you created using a specified traffic policy version.

        Access Level: List

        https://docs.aws.amazon.com/Route53/latest/APIReference/API_ListTrafficPolicyInstancesByPolicy.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toListTrafficPolicyInstancesByPolicy", [])

    @jsii.member(jsii_name="toListTrafficPolicyVersions")
    def to_list_traffic_policy_versions(self) -> "Route53":
        """Grants permission to get information about all the versions for a specified traffic policy.

        Access Level: List

        https://docs.aws.amazon.com/Route53/latest/APIReference/API_ListTrafficPolicyVersions.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toListTrafficPolicyVersions", [])

    @jsii.member(jsii_name="toListVPCAssociationAuthorizations")
    def to_list_vpc_association_authorizations(self) -> "Route53":
        """Grants permission to get a list of the VPCs that were created by other accounts and that can be associated with a specified hosted zone.

        Access Level: List

        https://docs.aws.amazon.com/Route53/latest/APIReference/API_ListVPCAssociationAuthorizations.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toListVPCAssociationAuthorizations", [])

    @jsii.member(jsii_name="toTestDNSAnswer")
    def to_test_dns_answer(self) -> "Route53":
        """Grants permission to get the value that Route 53 returns in response to a DNS query for a specified record name and type.

        Access Level: Read

        https://docs.aws.amazon.com/Route53/latest/APIReference/API_TestDNSAnswer.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toTestDNSAnswer", [])

    @jsii.member(jsii_name="toUpdateHealthCheck")
    def to_update_health_check(self) -> "Route53":
        """Grants permission to update an existing health check.

        Access Level: Write

        https://docs.aws.amazon.com/Route53/latest/APIReference/API_UpdateHealthCheck.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toUpdateHealthCheck", [])

    @jsii.member(jsii_name="toUpdateHostedZoneComment")
    def to_update_hosted_zone_comment(self) -> "Route53":
        """Grants permission to update the comment for a specified hosted zone.

        Access Level: Write

        https://docs.aws.amazon.com/Route53/latest/APIReference/API_UpdateHostedZoneComment.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toUpdateHostedZoneComment", [])

    @jsii.member(jsii_name="toUpdateTrafficPolicyComment")
    def to_update_traffic_policy_comment(self) -> "Route53":
        """Grants permission to update the comment for a specified traffic policy version.

        Access Level: Write

        https://docs.aws.amazon.com/Route53/latest/APIReference/API_UpdateTrafficPolicyComment.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toUpdateTrafficPolicyComment", [])

    @jsii.member(jsii_name="toUpdateTrafficPolicyInstance")
    def to_update_traffic_policy_instance(self) -> "Route53":
        """Grants permission to update the records in a specified hosted zone that were created based on the settings in a specified traffic policy version.

        Access Level: Write

        https://docs.aws.amazon.com/Route53/latest/APIReference/API_UpdateTrafficPolicyInstance.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toUpdateTrafficPolicyInstance", [])

    @builtins.property # type: ignore
    @jsii.member(jsii_name="accessLevelList")
    def _access_level_list(self) -> "AccessLevelList":
        """
        stability
        :stability: experimental
        """
        return jsii.get(self, "accessLevelList")

    @_access_level_list.setter # type: ignore
    def _access_level_list(self, value: "AccessLevelList") -> None:
        jsii.set(self, "accessLevelList", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="servicePrefix")
    def service_prefix(self) -> builtins.str:
        """Holds the prefix of the service actions, e.g. ``ec2``.

        stability
        :stability: experimental
        """
        return jsii.get(self, "servicePrefix")

    @service_prefix.setter # type: ignore
    def service_prefix(self, value: builtins.str) -> None:
        jsii.set(self, "servicePrefix", value)


class Route53domains(
    PolicyStatement,
    metaclass=jsii.JSIIMeta,
    jsii_type="iam-floyd.Route53domains",
):
    """Statement provider for service `route53domains <https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonroute53domains.html>`_.

    stability
    :stability: experimental
    """

    def __init__(self, sid: typing.Optional[builtins.str] = None) -> None:
        """Statement provider for service `route53domains <https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonroute53domains.html>`_.

        :param sid: `SID <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html>`_ of the statement.

        stability
        :stability: experimental
        """
        jsii.create(Route53domains, self, [sid])

    @jsii.member(jsii_name="toCheckDomainAvailability")
    def to_check_domain_availability(self) -> "Route53domains":
        """Grants permission to check the availability of one domain name.

        Access Level: Read

        https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_CheckDomainAvailability.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toCheckDomainAvailability", [])

    @jsii.member(jsii_name="toDeleteTagsForDomain")
    def to_delete_tags_for_domain(self) -> "Route53domains":
        """Grants permission to delete the specified tags for a domain.

        Access Level: Tagging

        https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_DeleteTagsForDomain.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDeleteTagsForDomain", [])

    @jsii.member(jsii_name="toDisableDomainAutoRenew")
    def to_disable_domain_auto_renew(self) -> "Route53domains":
        """Grants permission to configure Amazon Route 53 to automatically renew the specified domain before the domain registration expires.

        Access Level: Write

        https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_DisableDomainAutoRenew.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDisableDomainAutoRenew", [])

    @jsii.member(jsii_name="toDisableDomainTransferLock")
    def to_disable_domain_transfer_lock(self) -> "Route53domains":
        """Grants permission to remove the transfer lock on the domain (specifically the clientTransferProhibited status) to allow domain transfers.

        Access Level: Write

        https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_DisableDomainTransferLock.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDisableDomainTransferLock", [])

    @jsii.member(jsii_name="toEnableDomainAutoRenew")
    def to_enable_domain_auto_renew(self) -> "Route53domains":
        """Grants permission to configure Amazon Route 53 to automatically renew the specified domain before the domain registration expires.

        Access Level: Write

        https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_DisableDomainAutoRenew.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toEnableDomainAutoRenew", [])

    @jsii.member(jsii_name="toEnableDomainTransferLock")
    def to_enable_domain_transfer_lock(self) -> "Route53domains":
        """Grants permission to set the transfer lock on the domain (specifically the clientTransferProhibited status) to prevent domain transfers.

        Access Level: Write

        https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_EnableDomainTransferLock.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toEnableDomainTransferLock", [])

    @jsii.member(jsii_name="toGetContactReachabilityStatus")
    def to_get_contact_reachability_status(self) -> "Route53domains":
        """For operations that require confirmation that the email address for the registrant contact is valid, such as registering a new domain, grants permission to get information about whether the registrant contact has responded.

        Access Level: Read

        https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_GetContactReachabilityStatus.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toGetContactReachabilityStatus", [])

    @jsii.member(jsii_name="toGetDomainDetail")
    def to_get_domain_detail(self) -> "Route53domains":
        """Grants permission to get detailed information about a domain.

        Access Level: Read

        https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_GetDomainDetail.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toGetDomainDetail", [])

    @jsii.member(jsii_name="toGetDomainSuggestions")
    def to_get_domain_suggestions(self) -> "Route53domains":
        """Grants permission to get a list of suggested domain names given a string, which can either be a domain name or simply a word or phrase (without spaces).

        Access Level: Read

        https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_GetDomainSuggestions.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toGetDomainSuggestions", [])

    @jsii.member(jsii_name="toGetOperationDetail")
    def to_get_operation_detail(self) -> "Route53domains":
        """Grants permission to get the current status of an operation that is not completed.

        Access Level: Read

        https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_GetOperationDetail.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toGetOperationDetail", [])

    @jsii.member(jsii_name="toListDomains")
    def to_list_domains(self) -> "Route53domains":
        """Grants permission to list all the domain names registered with Amazon Route 53 for the current AWS account.

        Access Level: List

        https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_ListDomains.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toListDomains", [])

    @jsii.member(jsii_name="toListOperations")
    def to_list_operations(self) -> "Route53domains":
        """Grants permission to list the operation IDs of operations that are not yet complete.

        Access Level: List

        https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_ListOperations.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toListOperations", [])

    @jsii.member(jsii_name="toListTagsForDomain")
    def to_list_tags_for_domain(self) -> "Route53domains":
        """Grants permission to list all the tags that are associated with the specified domain.

        Access Level: List

        https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_ListTagsForDomain.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toListTagsForDomain", [])

    @jsii.member(jsii_name="toRegisterDomain")
    def to_register_domain(self) -> "Route53domains":
        """Grants permission to register domains.

        Access Level: Write

        https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_RegisterDomain.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toRegisterDomain", [])

    @jsii.member(jsii_name="toRenewDomain")
    def to_renew_domain(self) -> "Route53domains":
        """Grants permission to renew domains for the specified number of years.

        Access Level: Write

        https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_RenewDomain.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toRenewDomain", [])

    @jsii.member(jsii_name="toResendContactReachabilityEmail")
    def to_resend_contact_reachability_email(self) -> "Route53domains":
        """For operations that require confirmation that the email address for the registrant contact is valid, such as registering a new domain, grants permission to resend the confirmation email to the current email address for the registrant contact.

        Access Level: Write

        https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_ResendContactReachabilityEmail.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toResendContactReachabilityEmail", [])

    @jsii.member(jsii_name="toRetrieveDomainAuthCode")
    def to_retrieve_domain_auth_code(self) -> "Route53domains":
        """Grants permission to get the AuthCode for the domain.

        Access Level: Write

        https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_RetrieveDomainAuthCode.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toRetrieveDomainAuthCode", [])

    @jsii.member(jsii_name="toTransferDomain")
    def to_transfer_domain(self) -> "Route53domains":
        """Grants permission to transfer a domain from another registrar to Amazon Route 53.

        Access Level: Write

        https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_TransferDomain.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toTransferDomain", [])

    @jsii.member(jsii_name="toUpdateDomainContact")
    def to_update_domain_contact(self) -> "Route53domains":
        """Grants permission to update the contact information for domain.

        Access Level: Write

        https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_UpdateDomainContact.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toUpdateDomainContact", [])

    @jsii.member(jsii_name="toUpdateDomainContactPrivacy")
    def to_update_domain_contact_privacy(self) -> "Route53domains":
        """Grants permission to update the domain contact privacy setting.

        Access Level: Write

        https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_UpdateDomainContactPrivacy.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toUpdateDomainContactPrivacy", [])

    @jsii.member(jsii_name="toUpdateDomainNameservers")
    def to_update_domain_nameservers(self) -> "Route53domains":
        """Grants permission to replace the current set of name servers for a domain with the specified set of name servers.

        Access Level: Write

        https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_UpdateDomainNameservers.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toUpdateDomainNameservers", [])

    @jsii.member(jsii_name="toUpdateTagsForDomain")
    def to_update_tags_for_domain(self) -> "Route53domains":
        """Grants permission to add or update tags for a specified domain.

        Access Level: Tagging

        https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_UpdateTagsForDomain.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toUpdateTagsForDomain", [])

    @jsii.member(jsii_name="toViewBilling")
    def to_view_billing(self) -> "Route53domains":
        """Grants permission to get all the domain-related billing records for the current AWS account for a specified period.

        Access Level: Read

        https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_ViewBilling.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toViewBilling", [])

    @builtins.property # type: ignore
    @jsii.member(jsii_name="accessLevelList")
    def _access_level_list(self) -> "AccessLevelList":
        """
        stability
        :stability: experimental
        """
        return jsii.get(self, "accessLevelList")

    @_access_level_list.setter # type: ignore
    def _access_level_list(self, value: "AccessLevelList") -> None:
        jsii.set(self, "accessLevelList", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="servicePrefix")
    def service_prefix(self) -> builtins.str:
        """Holds the prefix of the service actions, e.g. ``ec2``.

        stability
        :stability: experimental
        """
        return jsii.get(self, "servicePrefix")

    @service_prefix.setter # type: ignore
    def service_prefix(self, value: builtins.str) -> None:
        jsii.set(self, "servicePrefix", value)


class Route53resolver(
    PolicyStatement,
    metaclass=jsii.JSIIMeta,
    jsii_type="iam-floyd.Route53resolver",
):
    """Statement provider for service `route53resolver <https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonroute53resolver.html>`_.

    stability
    :stability: experimental
    """

    def __init__(self, sid: typing.Optional[builtins.str] = None) -> None:
        """Statement provider for service `route53resolver <https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonroute53resolver.html>`_.

        :param sid: `SID <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html>`_ of the statement.

        stability
        :stability: experimental
        """
        jsii.create(Route53resolver, self, [sid])

    @jsii.member(jsii_name="onResolverEndpoint")
    def on_resolver_endpoint(
        self,
        resource_id: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Route53resolver":
        """Adds a resource of type resolver-endpoint to the statement.

        https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/access-control-overview.html#access-control-resources

        :param resource_id: - Identifier for the resourceId.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``. Possible conditions: - .ifAwsResourceTag()

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "onResolverEndpoint", [resource_id, account, region, partition])

    @jsii.member(jsii_name="onResolverQueryLogConfig")
    def on_resolver_query_log_config(
        self,
        resource_id: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Route53resolver":
        """Adds a resource of type resolver-query-log-config to the statement.

        https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/access-control-overview.html#access-control-resources

        :param resource_id: - Identifier for the resourceId.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``. Possible conditions: - .ifAwsResourceTag()

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "onResolverQueryLogConfig", [resource_id, account, region, partition])

    @jsii.member(jsii_name="onResolverRule")
    def on_resolver_rule(
        self,
        resource_id: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Route53resolver":
        """Adds a resource of type resolver-rule to the statement.

        https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/access-control-overview.html#access-control-resources

        :param resource_id: - Identifier for the resourceId.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``. Possible conditions: - .ifAwsResourceTag()

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "onResolverRule", [resource_id, account, region, partition])

    @jsii.member(jsii_name="toAssociateResolverEndpointIpAddress")
    def to_associate_resolver_endpoint_ip_address(self) -> "Route53resolver":
        """Grants permission to associate a specified IP address with a Resolver endpoint.

        This is an IP address that DNS queries pass through on the way to your network (outbound) or your VPCs (inbound)

        Access Level: Write

        https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_AssociateResolverEndpointIpAddress.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toAssociateResolverEndpointIpAddress", [])

    @jsii.member(jsii_name="toAssociateResolverQueryLogConfig")
    def to_associate_resolver_query_log_config(self) -> "Route53resolver":
        """Grants permission to associate an Amazon VPC with a specified query logging configuration.

        Access Level: Write

        https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_AssociateResolverQueryLogConfig.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toAssociateResolverQueryLogConfig", [])

    @jsii.member(jsii_name="toAssociateResolverRule")
    def to_associate_resolver_rule(self) -> "Route53resolver":
        """Grants permission to associate a specified Resolver rule with a specified VPC.

        Access Level: Write

        https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_AssociateResolverRule.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toAssociateResolverRule", [])

    @jsii.member(jsii_name="toCreateResolverEndpoint")
    def to_create_resolver_endpoint(self) -> "Route53resolver":
        """Grants permission to create a Resolver endpoint. There are two types of Resolver endpoints, inbound and outbound.

        Access Level: Write

        https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_CreateResolverEndpoint.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toCreateResolverEndpoint", [])

    @jsii.member(jsii_name="toCreateResolverQueryLogConfig")
    def to_create_resolver_query_log_config(self) -> "Route53resolver":
        """Grants permission to create a Resolver query logging configuration, which defines where you want Resolver to save DNS query logs that originate in your VPCs.

        Access Level: Write

        https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_CreateResolverQueryLogConfig.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toCreateResolverQueryLogConfig", [])

    @jsii.member(jsii_name="toCreateResolverRule")
    def to_create_resolver_rule(self) -> "Route53resolver":
        """For DNS queries that originate in your VPC, grants permission to define how to route the queries out of the VPC.

        Access Level: Write

        https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_CreateResolverRule.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toCreateResolverRule", [])

    @jsii.member(jsii_name="toDeleteResolverEndpoint")
    def to_delete_resolver_endpoint(self) -> "Route53resolver":
        """Grants permission to delete a Resolver endpoint.

        The effect of deleting a Resolver endpoint depends on whether it's an inbound or an outbound endpoint

        Access Level: Write

        https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_DeleteResolverEndpoint.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDeleteResolverEndpoint", [])

    @jsii.member(jsii_name="toDeleteResolverQueryLogConfig")
    def to_delete_resolver_query_log_config(self) -> "Route53resolver":
        """Grants permission to delete a Resolver query logging configuration.

        Access Level: Write

        https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_DeleteResolverQueryLogConfig.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDeleteResolverQueryLogConfig", [])

    @jsii.member(jsii_name="toDeleteResolverRule")
    def to_delete_resolver_rule(self) -> "Route53resolver":
        """Grants permission to delete a Resolver rule.

        Access Level: Write

        https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_DeleteResolverRule.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDeleteResolverRule", [])

    @jsii.member(jsii_name="toDisassociateResolverEndpointIpAddress")
    def to_disassociate_resolver_endpoint_ip_address(self) -> "Route53resolver":
        """Grants permission to remove a specified IP address from a Resolver endpoint.

        This is an IP address that DNS queries pass through on the way to your network (outbound) or your VPCs (inbound)

        Access Level: Write

        https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_DisassociateResolverEndpointIpAddress.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDisassociateResolverEndpointIpAddress", [])

    @jsii.member(jsii_name="toDisassociateResolverQueryLogConfig")
    def to_disassociate_resolver_query_log_config(self) -> "Route53resolver":
        """Grants permission to remove the association between a specified Resolver query logging configuration and a specified VPC.

        Access Level: Write

        https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_DisassociateResolverQueryLogConfig.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDisassociateResolverQueryLogConfig", [])

    @jsii.member(jsii_name="toDisassociateResolverRule")
    def to_disassociate_resolver_rule(self) -> "Route53resolver":
        """Grants permission to remove the association between a specified Resolver rule and a specified VPC.

        Access Level: Write

        https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_DisassociateResolverRule.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDisassociateResolverRule", [])

    @jsii.member(jsii_name="toGetResolverEndpoint")
    def to_get_resolver_endpoint(self) -> "Route53resolver":
        """Grants permission to get information about a specified Resolver endpoint, such as whether it's an inbound or an outbound endpoint, and the IP addresses in your VPC that DNS queries are forwarded to on the way into or out of your VPC.

        Access Level: Read

        https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_GetResolverEndpoint.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toGetResolverEndpoint", [])

    @jsii.member(jsii_name="toGetResolverQueryLogConfig")
    def to_get_resolver_query_log_config(self) -> "Route53resolver":
        """Grants permission to get information about a specified Resolver query logging configuration, such as the number of VPCs that the configuration is logging queries for and the location that logs are sent to.

        Access Level: Read

        https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_GetResolverQueryLogConfig.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toGetResolverQueryLogConfig", [])

    @jsii.member(jsii_name="toGetResolverQueryLogConfigAssociation")
    def to_get_resolver_query_log_config_association(self) -> "Route53resolver":
        """Grants permission to get information about a specified association between a Resolver query logging configuration and an Amazon VPC.

        When you associate a VPC with a query logging configuration, Resolver logs DNS queries that originate in that VPC

        Access Level: Read

        https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_GetResolverQueryLogConfigAssociation.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toGetResolverQueryLogConfigAssociation", [])

    @jsii.member(jsii_name="toGetResolverQueryLogConfigPolicy")
    def to_get_resolver_query_log_config_policy(self) -> "Route53resolver":
        """Grants permission to get information about a specified Resolver query logging policy, which specifies the Resolver query logging operations and resources that you want to allow another AWS account to use.

        Access Level: Read

        https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_GetResolverQueryLogConfigPolicy.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toGetResolverQueryLogConfigPolicy", [])

    @jsii.member(jsii_name="toGetResolverRule")
    def to_get_resolver_rule(self) -> "Route53resolver":
        """Grants permission to get information about a specified Resolver rule, such as the domain name that the rule forwards DNS queries for and the IP address that queries are forwarded to.

        Access Level: Read

        https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_GetResolverRule.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toGetResolverRule", [])

    @jsii.member(jsii_name="toGetResolverRuleAssociation")
    def to_get_resolver_rule_association(self) -> "Route53resolver":
        """Grants permission to get information about an association between a specified Resolver rule and a VPC.

        Access Level: Read

        https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_GetResolverRuleAssociation.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toGetResolverRuleAssociation", [])

    @jsii.member(jsii_name="toGetResolverRulePolicy")
    def to_get_resolver_rule_policy(self) -> "Route53resolver":
        """Grants permission to get information about a Resolver rule policy, which specifies the Resolver operations and resources that you want to allow another AWS account to use.

        Access Level: Read

        https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_GetResolverRulePolicy.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toGetResolverRulePolicy", [])

    @jsii.member(jsii_name="toListResolverEndpointIpAddresses")
    def to_list_resolver_endpoint_ip_addresses(self) -> "Route53resolver":
        """For a specified Resolver endpoint, grants permission to list the IP addresses that DNS queries pass through on the way to your network (outbound) or your VPCs (inbound).

        Access Level: List

        https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ListResolverEndpointIpAddresses.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toListResolverEndpointIpAddresses", [])

    @jsii.member(jsii_name="toListResolverEndpoints")
    def to_list_resolver_endpoints(self) -> "Route53resolver":
        """Grants permission to list all the Resolver endpoints that were created using the current AWS account.

        Access Level: List

        https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ListResolverEndpoints.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toListResolverEndpoints", [])

    @jsii.member(jsii_name="toListResolverQueryLogConfigAssociations")
    def to_list_resolver_query_log_config_associations(self) -> "Route53resolver":
        """Grants permission to list information about associations between Amazon VPCs and query logging configurations.

        Access Level: List

        https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ListResolverQueryLogConfigAssociations.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toListResolverQueryLogConfigAssociations", [])

    @jsii.member(jsii_name="toListResolverQueryLogConfigs")
    def to_list_resolver_query_log_configs(self) -> "Route53resolver":
        """Grants permission to list information about the specified query logging configurations, which define where you want Resolver to save DNS query logs and specify the VPCs that you want to log queries for.

        Access Level: List

        https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ListResolverQueryLogConfigs.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toListResolverQueryLogConfigs", [])

    @jsii.member(jsii_name="toListResolverRuleAssociations")
    def to_list_resolver_rule_associations(self) -> "Route53resolver":
        """Grants permission to list the associations that were created between Resolver rules and VPCs using the current AWS account.

        Access Level: List

        https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ListResolverRuleAssociations.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toListResolverRuleAssociations", [])

    @jsii.member(jsii_name="toListResolverRules")
    def to_list_resolver_rules(self) -> "Route53resolver":
        """Grants permission to list the Resolver rules that were created using the current AWS account.

        Access Level: List

        https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ListResolverRules.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toListResolverRules", [])

    @jsii.member(jsii_name="toListTagsForResource")
    def to_list_tags_for_resource(self) -> "Route53resolver":
        """Grants permission to list the tags that you associated with the specified resource.

        Access Level: Read

        https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ListTagsForResource.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toListTagsForResource", [])

    @jsii.member(jsii_name="toPutResolverQueryLogConfigPolicy")
    def to_put_resolver_query_log_config_policy(self) -> "Route53resolver":
        """Grants permission to specify an AWS account that you want to share a query logging configuration with, the query logging configuration that you want to share, and the operations that you want the account to be able to perform on the configuration.

        Access Level: Write

        https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_PutResolverQueryLogConfigPolicy.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toPutResolverQueryLogConfigPolicy", [])

    @jsii.member(jsii_name="toPutResolverRulePolicy")
    def to_put_resolver_rule_policy(self) -> "Route53resolver":
        """Grants permission to specify an AWS account that you want to share rules with, the Resolver rules that you want to share, and the operations that you want the account to be able to perform on those rules.

        Access Level: Write

        https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_PutResolverRulePolicy.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toPutResolverRulePolicy", [])

    @jsii.member(jsii_name="toTagResource")
    def to_tag_resource(self) -> "Route53resolver":
        """Grants permission to add one or more tags to a specified resource.

        Access Level: Tagging

        https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_TagResource.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toTagResource", [])

    @jsii.member(jsii_name="toUntagResource")
    def to_untag_resource(self) -> "Route53resolver":
        """Grants permission to remove one or more tags from a specified resource.

        Access Level: Tagging

        https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_UntagResource.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toUntagResource", [])

    @jsii.member(jsii_name="toUpdateResolverEndpoint")
    def to_update_resolver_endpoint(self) -> "Route53resolver":
        """Grants permission to update selected settings for an inbound or an outbound Resolver endpoint.

        Access Level: Write

        https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_UpdateResolverEndpoint.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toUpdateResolverEndpoint", [])

    @jsii.member(jsii_name="toUpdateResolverRule")
    def to_update_resolver_rule(self) -> "Route53resolver":
        """Grants permission to update settings for a specified Resolver rule.

        Access Level: Write

        https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_UpdateResolverRule.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toUpdateResolverRule", [])

    @builtins.property # type: ignore
    @jsii.member(jsii_name="accessLevelList")
    def _access_level_list(self) -> "AccessLevelList":
        """
        stability
        :stability: experimental
        """
        return jsii.get(self, "accessLevelList")

    @_access_level_list.setter # type: ignore
    def _access_level_list(self, value: "AccessLevelList") -> None:
        jsii.set(self, "accessLevelList", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="servicePrefix")
    def service_prefix(self) -> builtins.str:
        """Holds the prefix of the service actions, e.g. ``ec2``.

        stability
        :stability: experimental
        """
        return jsii.get(self, "servicePrefix")

    @service_prefix.setter # type: ignore
    def service_prefix(self, value: builtins.str) -> None:
        jsii.set(self, "servicePrefix", value)


class S3(PolicyStatement, metaclass=jsii.JSIIMeta, jsii_type="iam-floyd.S3"):
    """Statement provider for service `s3 <https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazons3.html>`_.

    stability
    :stability: experimental
    """

    def __init__(self, sid: typing.Optional[builtins.str] = None) -> None:
        """Statement provider for service `s3 <https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazons3.html>`_.

        :param sid: `SID <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html>`_ of the statement.

        stability
        :stability: experimental
        """
        jsii.create(S3, self, [sid])

    @jsii.member(jsii_name="ifAccessPointNetworkOrigin")
    def if_access_point_network_origin(
        self,
        value: typing.Union[builtins.str, typing.List[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, "Operator"]] = None,
    ) -> "S3":
        """Filters access by the network origin (Internet or VPC).

        https://docs.aws.amazon.com/AmazonS3/latest/dev/creating-access-points.html#access-points-policies

        Applies to actions:

        - .toAbortMultipartUpload()
        - .toBypassGovernanceRetention()
        - .toCreateAccessPoint()
        - .toDeleteAccessPoint()
        - .toDeleteAccessPointPolicy()
        - .toDeleteObject()
        - .toDeleteObjectTagging()
        - .toDeleteObjectVersion()
        - .toDeleteObjectVersionTagging()
        - .toGetAccessPoint()
        - .toGetAccessPointPolicy()
        - .toGetAccessPointPolicyStatus()
        - .toGetObject()
        - .toGetObjectAcl()
        - .toGetObjectLegalHold()
        - .toGetObjectRetention()
        - .toGetObjectTagging()
        - .toGetObjectVersion()
        - .toGetObjectVersionAcl()
        - .toGetObjectVersionTagging()
        - .toListBucket()
        - .toListBucketMultipartUploads()
        - .toListBucketVersions()
        - .toListMultipartUploadParts()
        - .toPutAccessPointPolicy()
        - .toPutObject()
        - .toPutObjectAcl()
        - .toPutObjectLegalHold()
        - .toPutObjectRetention()
        - .toPutObjectTagging()
        - .toPutObjectVersionAcl()
        - .toPutObjectVersionTagging()
        - .toRestoreObject()

        :param value: The value(s) to check.
        :param operator: Works with `string operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String>`_. **Default:** ``StringLike``.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "ifAccessPointNetworkOrigin", [value, operator])

    @jsii.member(jsii_name="ifAuthType")
    def if_auth_type(
        self,
        value: typing.Union[builtins.str, typing.List[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, "Operator"]] = None,
    ) -> "S3":
        """Filters access by authentication method.

        https://docs.aws.amazon.com/AmazonS3/latest/API/bucket-policy-s3-sigv4-conditions.html

        Applies to actions:

        - .toAbortMultipartUpload()
        - .toBypassGovernanceRetention()
        - .toCreateAccessPoint()
        - .toCreateBucket()
        - .toCreateJob()
        - .toDeleteAccessPoint()
        - .toDeleteAccessPointPolicy()
        - .toDeleteBucket()
        - .toDeleteBucketOwnershipControls()
        - .toDeleteBucketPolicy()
        - .toDeleteBucketWebsite()
        - .toDeleteJobTagging()
        - .toDeleteObject()
        - .toDeleteObjectTagging()
        - .toDeleteObjectVersion()
        - .toDeleteObjectVersionTagging()
        - .toDeleteStorageLensConfiguration()
        - .toDeleteStorageLensConfigurationTagging()
        - .toDescribeJob()
        - .toGetAccelerateConfiguration()
        - .toGetAccessPoint()
        - .toGetAccessPointPolicy()
        - .toGetAccessPointPolicyStatus()
        - .toGetAccountPublicAccessBlock()
        - .toGetAnalyticsConfiguration()
        - .toGetBucketAcl()
        - .toGetBucketCORS()
        - .toGetBucketLogging()
        - .toGetBucketNotification()
        - .toGetBucketObjectLockConfiguration()
        - .toGetBucketOwnershipControls()
        - .toGetBucketPolicy()
        - .toGetBucketPolicyStatus()
        - .toGetBucketPublicAccessBlock()
        - .toGetBucketRequestPayment()
        - .toGetBucketTagging()
        - .toGetBucketVersioning()
        - .toGetBucketWebsite()
        - .toGetEncryptionConfiguration()
        - .toGetInventoryConfiguration()
        - .toGetJobTagging()
        - .toGetLifecycleConfiguration()
        - .toGetMetricsConfiguration()
        - .toGetObject()
        - .toGetObjectAcl()
        - .toGetObjectLegalHold()
        - .toGetObjectRetention()
        - .toGetObjectTagging()
        - .toGetObjectTorrent()
        - .toGetObjectVersion()
        - .toGetObjectVersionAcl()
        - .toGetObjectVersionForReplication()
        - .toGetObjectVersionTagging()
        - .toGetObjectVersionTorrent()
        - .toGetReplicationConfiguration()
        - .toGetStorageLensConfiguration()
        - .toGetStorageLensConfigurationTagging()
        - .toGetStorageLensDashboard()
        - .toListAccessPoints()
        - .toListAllMyBuckets()
        - .toListBucket()
        - .toListBucketMultipartUploads()
        - .toListBucketVersions()
        - .toListJobs()
        - .toListMultipartUploadParts()
        - .toListStorageLensConfigurations()
        - .toObjectOwnerOverrideToBucketOwner()
        - .toPutAccelerateConfiguration()
        - .toPutAccessPointPolicy()
        - .toPutAccountPublicAccessBlock()
        - .toPutAnalyticsConfiguration()
        - .toPutBucketAcl()
        - .toPutBucketCORS()
        - .toPutBucketLogging()
        - .toPutBucketNotification()
        - .toPutBucketObjectLockConfiguration()
        - .toPutBucketOwnershipControls()
        - .toPutBucketPolicy()
        - .toPutBucketPublicAccessBlock()
        - .toPutBucketRequestPayment()
        - .toPutBucketTagging()
        - .toPutBucketVersioning()
        - .toPutBucketWebsite()
        - .toPutEncryptionConfiguration()
        - .toPutInventoryConfiguration()
        - .toPutJobTagging()
        - .toPutLifecycleConfiguration()
        - .toPutMetricsConfiguration()
        - .toPutObject()
        - .toPutObjectAcl()
        - .toPutObjectLegalHold()
        - .toPutObjectRetention()
        - .toPutObjectTagging()
        - .toPutObjectVersionAcl()
        - .toPutObjectVersionTagging()
        - .toPutReplicationConfiguration()
        - .toPutStorageLensConfiguration()
        - .toPutStorageLensConfigurationTagging()
        - .toReplicateDelete()
        - .toReplicateObject()
        - .toReplicateTags()
        - .toRestoreObject()
        - .toUpdateJobPriority()
        - .toUpdateJobStatus()

        :param value: The value(s) to check.
        :param operator: Works with `string operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String>`_. **Default:** ``StringLike``.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "ifAuthType", [value, operator])

    @jsii.member(jsii_name="ifDataAccessPointAccount")
    def if_data_access_point_account(
        self,
        value: typing.Union[builtins.str, typing.List[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, "Operator"]] = None,
    ) -> "S3":
        """Filters access by the AWS Account ID that owns the access point.

        https://docs.aws.amazon.com/AmazonS3/latest/dev/creating-access-points.html#access-points-policies

        Applies to actions:

        - .toAbortMultipartUpload()
        - .toBypassGovernanceRetention()
        - .toCreateAccessPoint()
        - .toDeleteAccessPoint()
        - .toDeleteAccessPointPolicy()
        - .toDeleteObject()
        - .toDeleteObjectTagging()
        - .toDeleteObjectVersion()
        - .toDeleteObjectVersionTagging()
        - .toGetAccessPoint()
        - .toGetAccessPointPolicy()
        - .toGetAccessPointPolicyStatus()
        - .toGetObject()
        - .toGetObjectAcl()
        - .toGetObjectLegalHold()
        - .toGetObjectRetention()
        - .toGetObjectTagging()
        - .toGetObjectVersion()
        - .toGetObjectVersionAcl()
        - .toGetObjectVersionTagging()
        - .toListBucket()
        - .toListBucketMultipartUploads()
        - .toListBucketVersions()
        - .toListMultipartUploadParts()
        - .toPutAccessPointPolicy()
        - .toPutObject()
        - .toPutObjectAcl()
        - .toPutObjectLegalHold()
        - .toPutObjectRetention()
        - .toPutObjectTagging()
        - .toPutObjectVersionAcl()
        - .toPutObjectVersionTagging()
        - .toRestoreObject()

        :param value: The value(s) to check.
        :param operator: Works with `string operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String>`_. **Default:** ``StringLike``.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "ifDataAccessPointAccount", [value, operator])

    @jsii.member(jsii_name="ifDataAccessPointArn")
    def if_data_access_point_arn(
        self,
        value: typing.Union[builtins.str, typing.List[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, "Operator"]] = None,
    ) -> "S3":
        """Filters access by an access point Amazon Resource Name (ARN).

        Applies to actions:

        - .toAbortMultipartUpload()
        - .toBypassGovernanceRetention()
        - .toCreateAccessPoint()
        - .toDeleteAccessPoint()
        - .toDeleteAccessPointPolicy()
        - .toDeleteObject()
        - .toDeleteObjectTagging()
        - .toDeleteObjectVersion()
        - .toDeleteObjectVersionTagging()
        - .toGetAccessPoint()
        - .toGetAccessPointPolicy()
        - .toGetAccessPointPolicyStatus()
        - .toGetObject()
        - .toGetObjectAcl()
        - .toGetObjectLegalHold()
        - .toGetObjectRetention()
        - .toGetObjectTagging()
        - .toGetObjectVersion()
        - .toGetObjectVersionAcl()
        - .toGetObjectVersionTagging()
        - .toListBucket()
        - .toListBucketMultipartUploads()
        - .toListBucketVersions()
        - .toListMultipartUploadParts()
        - .toPutAccessPointPolicy()
        - .toPutObject()
        - .toPutObjectAcl()
        - .toPutObjectLegalHold()
        - .toPutObjectRetention()
        - .toPutObjectTagging()
        - .toPutObjectVersionAcl()
        - .toPutObjectVersionTagging()
        - .toRestoreObject()

        :param value: The value(s) to check.
        :param operator: Works with `string operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String>`_. **Default:** ``StringLike``.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "ifDataAccessPointArn", [value, operator])

    @jsii.member(jsii_name="ifDelimiter")
    def if_delimiter(
        self,
        value: typing.Union[builtins.str, typing.List[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, "Operator"]] = None,
    ) -> "S3":
        """Filters access by delimiter parameter.

        https://docs.aws.amazon.com/AmazonS3/latest/dev/walkthrough1.html

        Applies to actions:

        - .toListBucket()
        - .toListBucketVersions()

        :param value: The value(s) to check.
        :param operator: Works with `string operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String>`_. **Default:** ``StringLike``.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "ifDelimiter", [value, operator])

    @jsii.member(jsii_name="ifExistingJobOperation")
    def if_existing_job_operation(
        self,
        value: typing.Union[builtins.str, typing.List[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, "Operator"]] = None,
    ) -> "S3":
        """Filters access to updating the job priority by operation.

        https://docs.aws.amazon.com/AmazonS3/latest/dev/batch-ops-job-tags-examples.html

        Applies to actions:

        - .toDeleteJobTagging()
        - .toPutJobTagging()
        - .toUpdateJobPriority()
        - .toUpdateJobStatus()

        :param value: The value(s) to check.
        :param operator: Works with `string operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String>`_. **Default:** ``StringLike``.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "ifExistingJobOperation", [value, operator])

    @jsii.member(jsii_name="ifExistingJobPriority")
    def if_existing_job_priority(
        self,
        value: typing.Union[jsii.Number, typing.List[jsii.Number]],
        operator: typing.Optional[typing.Union[builtins.str, "Operator"]] = None,
    ) -> "S3":
        """Filters access to cancelling existing jobs by priority range.

        https://docs.aws.amazon.com/AmazonS3/latest/dev/batch-ops-job-tags-examples.html

        Applies to actions:

        - .toDeleteJobTagging()
        - .toPutJobTagging()
        - .toUpdateJobPriority()
        - .toUpdateJobStatus()

        :param value: The value(s) to check.
        :param operator: Works with `numeric operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_Numeric>`_. **Default:** ``NumericEquals``.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "ifExistingJobPriority", [value, operator])

    @jsii.member(jsii_name="ifExistingObjectTag")
    def if_existing_object_tag(
        self,
        key: builtins.str,
        value: typing.Union[builtins.str, typing.List[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, "Operator"]] = None,
    ) -> "S3":
        """Filters access by existing object tag key and value.

        https://docs.aws.amazon.com/AmazonS3/latest/dev/object-tagging.html#tagging-and-policies

        Applies to actions:

        - .toDeleteObjectTagging()
        - .toDeleteObjectVersionTagging()
        - .toGetObject()
        - .toGetObjectAcl()
        - .toGetObjectTagging()
        - .toGetObjectVersion()
        - .toGetObjectVersionAcl()
        - .toGetObjectVersionTagging()
        - .toPutObjectAcl()
        - .toPutObjectTagging()
        - .toPutObjectVersionAcl()
        - .toPutObjectVersionTagging()

        :param key: The tag key to check.
        :param value: The value(s) to check.
        :param operator: Works with `string operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String>`_. **Default:** ``StringLike``.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "ifExistingObjectTag", [key, value, operator])

    @jsii.member(jsii_name="ifJobSuspendedCause")
    def if_job_suspended_cause(
        self,
        value: typing.Union[builtins.str, typing.List[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, "Operator"]] = None,
    ) -> "S3":
        """Filters access to cancelling suspended jobs by a specific job suspended cause (for example, AWAITING_CONFIRMATION).

        https://docs.aws.amazon.com/AmazonS3/latest/dev/batch-ops-job-tags-examples.html

        Applies to actions:

        - .toUpdateJobStatus()

        :param value: The value(s) to check.
        :param operator: Works with `string operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String>`_. **Default:** ``StringLike``.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "ifJobSuspendedCause", [value, operator])

    @jsii.member(jsii_name="ifLocationconstraint")
    def if_locationconstraint(
        self,
        value: typing.Union[builtins.str, typing.List[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, "Operator"]] = None,
    ) -> "S3":
        """Filters access by a specific Region.

        https://docs.aws.amazon.com/AmazonS3/latest/dev/amazon-s3-policy-keys.html#condition-key-bucket-ops-1

        Applies to actions:

        - .toCreateAccessPoint()
        - .toCreateBucket()

        :param value: The value(s) to check.
        :param operator: Works with `string operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String>`_. **Default:** ``StringLike``.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "ifLocationconstraint", [value, operator])

    @jsii.member(jsii_name="ifLocationConstraint")
    def if_location_constraint(
        self,
        value: typing.Union[builtins.str, typing.List[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, "Operator"]] = None,
    ) -> "S3":
        """Filters access by a specific Region.

        https://docs.aws.amazon.com/AmazonS3/latest/dev/amazon-s3-policy-keys.html#condition-key-bucket-ops-1

        :param value: The value(s) to check.
        :param operator: Works with `string operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String>`_. **Default:** ``StringLike``.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "ifLocationConstraint", [value, operator])

    @jsii.member(jsii_name="ifMaxKeys")
    def if_max_keys(
        self,
        value: typing.Union[jsii.Number, typing.List[jsii.Number]],
        operator: typing.Optional[typing.Union[builtins.str, "Operator"]] = None,
    ) -> "S3":
        """Filters access by maximum number of keys returned in a ListBucket request.

        https://docs.aws.amazon.com/AmazonS3/latest/dev/amazon-s3-policy-keys.html#example-numeric-condition-operators

        Applies to actions:

        - .toListBucket()
        - .toListBucketVersions()

        :param value: The value(s) to check.
        :param operator: Works with `numeric operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_Numeric>`_. **Default:** ``NumericEquals``.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "ifMaxKeys", [value, operator])

    @jsii.member(jsii_name="ifObjectLockLegalHold")
    def if_object_lock_legal_hold(
        self,
        value: typing.Union[builtins.str, typing.List[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, "Operator"]] = None,
    ) -> "S3":
        """Filters access by object legal hold status.

        https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lock-overview.html#object-lock-legal-holds

        Applies to actions:

        - .toBypassGovernanceRetention()
        - .toPutObject()
        - .toPutObjectLegalHold()

        :param value: The value(s) to check.
        :param operator: Works with `string operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String>`_. **Default:** ``StringLike``.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "ifObjectLockLegalHold", [value, operator])

    @jsii.member(jsii_name="ifObjectLockMode")
    def if_object_lock_mode(
        self,
        value: typing.Union[builtins.str, typing.List[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, "Operator"]] = None,
    ) -> "S3":
        """Filters access by object retention mode (COMPLIANCE or GOVERNANCE).

        Applies to actions:

        - .toBypassGovernanceRetention()
        - .toPutObject()
        - .toPutObjectRetention()

        :param value: The value(s) to check.
        :param operator: Works with `string operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String>`_. **Default:** ``StringLike``.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "ifObjectLockMode", [value, operator])

    @jsii.member(jsii_name="ifObjectLockRemainingRetentionDays")
    def if_object_lock_remaining_retention_days(
        self,
        value: typing.Union[builtins.str, typing.List[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, "Operator"]] = None,
    ) -> "S3":
        """Filters access by remaining object retention days.

        https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lock-managing.html#object-lock-managing-retention-limits

        Applies to actions:

        - .toBypassGovernanceRetention()
        - .toPutObject()
        - .toPutObjectRetention()

        :param value: The value(s) to check.
        :param operator: Works with `string operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String>`_. **Default:** ``StringLike``.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "ifObjectLockRemainingRetentionDays", [value, operator])

    @jsii.member(jsii_name="ifObjectLockRetainUntilDate")
    def if_object_lock_retain_until_date(
        self,
        value: typing.Union[builtins.str, typing.List[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, "Operator"]] = None,
    ) -> "S3":
        """Filters access by object retain-until date.

        https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lock-overview.html#object-lock-retention-periods

        Applies to actions:

        - .toBypassGovernanceRetention()
        - .toPutObject()
        - .toPutObjectRetention()

        :param value: The value(s) to check.
        :param operator: Works with `string operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String>`_. **Default:** ``StringLike``.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "ifObjectLockRetainUntilDate", [value, operator])

    @jsii.member(jsii_name="ifPrefix")
    def if_prefix(
        self,
        value: typing.Union[builtins.str, typing.List[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, "Operator"]] = None,
    ) -> "S3":
        """Filters access by key name prefix.

        https://docs.aws.amazon.com/AmazonS3/latest/dev/amazon-s3-policy-keys.html#condition-key-bucket-ops-2

        Applies to actions:

        - .toListBucket()
        - .toListBucketVersions()

        :param value: The value(s) to check.
        :param operator: Works with `string operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String>`_. **Default:** ``StringLike``.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "ifPrefix", [value, operator])

    @jsii.member(jsii_name="ifRequestJobOperation")
    def if_request_job_operation(
        self,
        value: typing.Union[builtins.str, typing.List[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, "Operator"]] = None,
    ) -> "S3":
        """Filters access to creating jobs by operation.

        https://docs.aws.amazon.com/AmazonS3/latest/dev/batch-ops-job-tags-examples.html

        Applies to actions:

        - .toCreateJob()

        :param value: The value(s) to check.
        :param operator: Works with `string operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String>`_. **Default:** ``StringLike``.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "ifRequestJobOperation", [value, operator])

    @jsii.member(jsii_name="ifRequestJobPriority")
    def if_request_job_priority(
        self,
        value: typing.Union[jsii.Number, typing.List[jsii.Number]],
        operator: typing.Optional[typing.Union[builtins.str, "Operator"]] = None,
    ) -> "S3":
        """Filters access to creating new jobs by priority range.

        https://docs.aws.amazon.com/AmazonS3/latest/dev/batch-ops-job-tags-examples.html

        Applies to actions:

        - .toCreateJob()
        - .toUpdateJobPriority()

        :param value: The value(s) to check.
        :param operator: Works with `numeric operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_Numeric>`_. **Default:** ``NumericEquals``.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "ifRequestJobPriority", [value, operator])

    @jsii.member(jsii_name="ifRequestObjectTag")
    def if_request_object_tag(
        self,
        key: builtins.str,
        value: typing.Union[builtins.str, typing.List[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, "Operator"]] = None,
    ) -> "S3":
        """Filters access by the tag keys and values to be added to objects.

        https://docs.aws.amazon.com/AmazonS3/latest/dev/object-tagging.html#tagging-and-policies

        Applies to actions:

        - .toBypassGovernanceRetention()
        - .toPutObject()
        - .toPutObjectTagging()
        - .toPutObjectVersionTagging()

        :param key: The tag key to check.
        :param value: The value(s) to check.
        :param operator: Works with `string operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String>`_. **Default:** ``StringLike``.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "ifRequestObjectTag", [key, value, operator])

    @jsii.member(jsii_name="ifRequestObjectTagKeys")
    def if_request_object_tag_keys(
        self,
        value: typing.Union[builtins.str, typing.List[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, "Operator"]] = None,
    ) -> "S3":
        """Filters access by the tag keys to be added to objects.

        https://docs.aws.amazon.com/AmazonS3/latest/dev/object-tagging.html#tagging-and-policies

        Applies to actions:

        - .toBypassGovernanceRetention()
        - .toPutObject()
        - .toPutObjectTagging()
        - .toPutObjectVersionTagging()

        :param value: The value(s) to check.
        :param operator: Works with `string operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String>`_. **Default:** ``StringLike``.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "ifRequestObjectTagKeys", [value, operator])

    @jsii.member(jsii_name="ifSignatureAge")
    def if_signature_age(
        self,
        value: typing.Union[jsii.Number, typing.List[jsii.Number]],
        operator: typing.Optional[typing.Union[builtins.str, "Operator"]] = None,
    ) -> "S3":
        """Filters access by the age in milliseconds of the request signature.

        https://docs.aws.amazon.com/AmazonS3/latest/API/bucket-policy-s3-sigv4-conditions.html

        Applies to actions:

        - .toAbortMultipartUpload()
        - .toBypassGovernanceRetention()
        - .toCreateAccessPoint()
        - .toCreateBucket()
        - .toCreateJob()
        - .toDeleteAccessPoint()
        - .toDeleteAccessPointPolicy()
        - .toDeleteBucket()
        - .toDeleteBucketOwnershipControls()
        - .toDeleteBucketPolicy()
        - .toDeleteBucketWebsite()
        - .toDeleteJobTagging()
        - .toDeleteObject()
        - .toDeleteObjectTagging()
        - .toDeleteObjectVersion()
        - .toDeleteObjectVersionTagging()
        - .toDeleteStorageLensConfiguration()
        - .toDeleteStorageLensConfigurationTagging()
        - .toDescribeJob()
        - .toGetAccelerateConfiguration()
        - .toGetAccessPoint()
        - .toGetAccessPointPolicy()
        - .toGetAccessPointPolicyStatus()
        - .toGetAccountPublicAccessBlock()
        - .toGetAnalyticsConfiguration()
        - .toGetBucketAcl()
        - .toGetBucketCORS()
        - .toGetBucketLogging()
        - .toGetBucketNotification()
        - .toGetBucketObjectLockConfiguration()
        - .toGetBucketOwnershipControls()
        - .toGetBucketPolicy()
        - .toGetBucketPolicyStatus()
        - .toGetBucketPublicAccessBlock()
        - .toGetBucketRequestPayment()
        - .toGetBucketTagging()
        - .toGetBucketVersioning()
        - .toGetBucketWebsite()
        - .toGetEncryptionConfiguration()
        - .toGetInventoryConfiguration()
        - .toGetJobTagging()
        - .toGetLifecycleConfiguration()
        - .toGetMetricsConfiguration()
        - .toGetObject()
        - .toGetObjectAcl()
        - .toGetObjectLegalHold()
        - .toGetObjectRetention()
        - .toGetObjectTagging()
        - .toGetObjectTorrent()
        - .toGetObjectVersion()
        - .toGetObjectVersionAcl()
        - .toGetObjectVersionForReplication()
        - .toGetObjectVersionTagging()
        - .toGetObjectVersionTorrent()
        - .toGetReplicationConfiguration()
        - .toGetStorageLensConfiguration()
        - .toGetStorageLensConfigurationTagging()
        - .toGetStorageLensDashboard()
        - .toListAccessPoints()
        - .toListAllMyBuckets()
        - .toListBucket()
        - .toListBucketMultipartUploads()
        - .toListBucketVersions()
        - .toListJobs()
        - .toListMultipartUploadParts()
        - .toListStorageLensConfigurations()
        - .toObjectOwnerOverrideToBucketOwner()
        - .toPutAccelerateConfiguration()
        - .toPutAccessPointPolicy()
        - .toPutAccountPublicAccessBlock()
        - .toPutAnalyticsConfiguration()
        - .toPutBucketAcl()
        - .toPutBucketCORS()
        - .toPutBucketLogging()
        - .toPutBucketNotification()
        - .toPutBucketObjectLockConfiguration()
        - .toPutBucketOwnershipControls()
        - .toPutBucketPolicy()
        - .toPutBucketPublicAccessBlock()
        - .toPutBucketRequestPayment()
        - .toPutBucketTagging()
        - .toPutBucketVersioning()
        - .toPutBucketWebsite()
        - .toPutEncryptionConfiguration()
        - .toPutInventoryConfiguration()
        - .toPutJobTagging()
        - .toPutLifecycleConfiguration()
        - .toPutMetricsConfiguration()
        - .toPutObject()
        - .toPutObjectAcl()
        - .toPutObjectLegalHold()
        - .toPutObjectRetention()
        - .toPutObjectTagging()
        - .toPutObjectVersionAcl()
        - .toPutObjectVersionTagging()
        - .toPutReplicationConfiguration()
        - .toPutStorageLensConfiguration()
        - .toPutStorageLensConfigurationTagging()
        - .toReplicateDelete()
        - .toReplicateObject()
        - .toReplicateTags()
        - .toRestoreObject()
        - .toUpdateJobPriority()
        - .toUpdateJobStatus()

        :param value: The value(s) to check.
        :param operator: Works with `numeric operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_Numeric>`_. **Default:** ``NumericEquals``.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "ifSignatureAge", [value, operator])

    @jsii.member(jsii_name="ifSignatureversion")
    def if_signatureversion(
        self,
        value: typing.Union[builtins.str, typing.List[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, "Operator"]] = None,
    ) -> "S3":
        """Filters access by the version of AWS Signature used on the request.

        https://docs.aws.amazon.com/AmazonS3/latest/API/bucket-policy-s3-sigv4-conditions.html

        Applies to actions:

        - .toAbortMultipartUpload()
        - .toBypassGovernanceRetention()
        - .toCreateAccessPoint()
        - .toCreateBucket()
        - .toCreateJob()
        - .toDeleteAccessPoint()
        - .toDeleteAccessPointPolicy()
        - .toDeleteBucket()
        - .toDeleteBucketOwnershipControls()
        - .toDeleteBucketPolicy()
        - .toDeleteBucketWebsite()
        - .toDeleteJobTagging()
        - .toDeleteObject()
        - .toDeleteObjectTagging()
        - .toDeleteObjectVersion()
        - .toDeleteObjectVersionTagging()
        - .toDeleteStorageLensConfiguration()
        - .toDeleteStorageLensConfigurationTagging()
        - .toDescribeJob()
        - .toGetAccelerateConfiguration()
        - .toGetAccessPoint()
        - .toGetAccessPointPolicy()
        - .toGetAccessPointPolicyStatus()
        - .toGetAccountPublicAccessBlock()
        - .toGetAnalyticsConfiguration()
        - .toGetBucketAcl()
        - .toGetBucketCORS()
        - .toGetBucketLogging()
        - .toGetBucketNotification()
        - .toGetBucketObjectLockConfiguration()
        - .toGetBucketOwnershipControls()
        - .toGetBucketPolicy()
        - .toGetBucketPolicyStatus()
        - .toGetBucketPublicAccessBlock()
        - .toGetBucketRequestPayment()
        - .toGetBucketTagging()
        - .toGetBucketVersioning()
        - .toGetBucketWebsite()
        - .toGetEncryptionConfiguration()
        - .toGetInventoryConfiguration()
        - .toGetJobTagging()
        - .toGetLifecycleConfiguration()
        - .toGetMetricsConfiguration()
        - .toGetObject()
        - .toGetObjectAcl()
        - .toGetObjectLegalHold()
        - .toGetObjectRetention()
        - .toGetObjectTagging()
        - .toGetObjectTorrent()
        - .toGetObjectVersion()
        - .toGetObjectVersionAcl()
        - .toGetObjectVersionForReplication()
        - .toGetObjectVersionTagging()
        - .toGetObjectVersionTorrent()
        - .toGetReplicationConfiguration()
        - .toGetStorageLensConfiguration()
        - .toGetStorageLensConfigurationTagging()
        - .toGetStorageLensDashboard()
        - .toListAccessPoints()
        - .toListAllMyBuckets()
        - .toListBucket()
        - .toListBucketMultipartUploads()
        - .toListBucketVersions()
        - .toListJobs()
        - .toListMultipartUploadParts()
        - .toListStorageLensConfigurations()
        - .toObjectOwnerOverrideToBucketOwner()
        - .toPutAccelerateConfiguration()
        - .toPutAccessPointPolicy()
        - .toPutAccountPublicAccessBlock()
        - .toPutAnalyticsConfiguration()
        - .toPutBucketAcl()
        - .toPutBucketCORS()
        - .toPutBucketLogging()
        - .toPutBucketNotification()
        - .toPutBucketObjectLockConfiguration()
        - .toPutBucketOwnershipControls()
        - .toPutBucketPolicy()
        - .toPutBucketPublicAccessBlock()
        - .toPutBucketRequestPayment()
        - .toPutBucketTagging()
        - .toPutBucketVersioning()
        - .toPutBucketWebsite()
        - .toPutEncryptionConfiguration()
        - .toPutInventoryConfiguration()
        - .toPutJobTagging()
        - .toPutLifecycleConfiguration()
        - .toPutMetricsConfiguration()
        - .toPutObject()
        - .toPutObjectAcl()
        - .toPutObjectLegalHold()
        - .toPutObjectRetention()
        - .toPutObjectTagging()
        - .toPutObjectVersionAcl()
        - .toPutObjectVersionTagging()
        - .toPutReplicationConfiguration()
        - .toPutStorageLensConfiguration()
        - .toPutStorageLensConfigurationTagging()
        - .toReplicateDelete()
        - .toReplicateObject()
        - .toReplicateTags()
        - .toRestoreObject()
        - .toUpdateJobPriority()
        - .toUpdateJobStatus()

        :param value: The value(s) to check.
        :param operator: Works with `string operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String>`_. **Default:** ``StringLike``.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "ifSignatureversion", [value, operator])

    @jsii.member(jsii_name="ifVersionid")
    def if_versionid(
        self,
        value: typing.Union[builtins.str, typing.List[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, "Operator"]] = None,
    ) -> "S3":
        """Filters access by a specific object version.

        https://docs.aws.amazon.com/AmazonS3/latest/dev/amazon-s3-policy-keys.html#getobjectversion-limit-access-to-specific-version-3

        Applies to actions:

        - .toDeleteObjectVersion()
        - .toDeleteObjectVersionTagging()
        - .toGetObjectVersion()
        - .toGetObjectVersionAcl()
        - .toGetObjectVersionTagging()
        - .toGetObjectVersionTorrent()
        - .toPutObjectVersionAcl()
        - .toPutObjectVersionTagging()

        :param value: The value(s) to check.
        :param operator: Works with `string operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String>`_. **Default:** ``StringLike``.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "ifVersionid", [value, operator])

    @jsii.member(jsii_name="ifVersionId")
    def if_version_id(
        self,
        value: typing.Union[builtins.str, typing.List[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, "Operator"]] = None,
    ) -> "S3":
        """Filters access by a specific object version.

        https://docs.aws.amazon.com/AmazonS3/latest/dev/amazon-s3-policy-keys.html#getobjectversion-limit-access-to-specific-version-3

        :param value: The value(s) to check.
        :param operator: Works with `string operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String>`_. **Default:** ``StringLike``.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "ifVersionId", [value, operator])

    @jsii.member(jsii_name="ifXAmzAcl")
    def if_x_amz_acl(
        self,
        value: typing.Union[builtins.str, typing.List[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, "Operator"]] = None,
    ) -> "S3":
        """Filters access by canned ACL in the request's x-amz-acl header.

        https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#permissions

        Applies to actions:

        - .toBypassGovernanceRetention()
        - .toCreateAccessPoint()
        - .toCreateBucket()
        - .toPutBucketAcl()
        - .toPutObject()
        - .toPutObjectAcl()
        - .toPutObjectVersionAcl()

        :param value: The value(s) to check.
        :param operator: Works with `string operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String>`_. **Default:** ``StringLike``.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "ifXAmzAcl", [value, operator])

    @jsii.member(jsii_name="ifXAmzContentSha256")
    def if_x_amz_content_sha256(
        self,
        value: typing.Union[builtins.str, typing.List[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, "Operator"]] = None,
    ) -> "S3":
        """Filters access to unsigned content in your bucket.

        https://docs.aws.amazon.com/AmazonS3/latest/API/bucket-policy-s3-sigv4-conditions.html

        Applies to actions:

        - .toAbortMultipartUpload()
        - .toBypassGovernanceRetention()
        - .toCreateAccessPoint()
        - .toCreateBucket()
        - .toCreateJob()
        - .toDeleteAccessPoint()
        - .toDeleteAccessPointPolicy()
        - .toDeleteBucket()
        - .toDeleteBucketOwnershipControls()
        - .toDeleteBucketPolicy()
        - .toDeleteBucketWebsite()
        - .toDeleteJobTagging()
        - .toDeleteObject()
        - .toDeleteObjectTagging()
        - .toDeleteObjectVersion()
        - .toDeleteObjectVersionTagging()
        - .toDeleteStorageLensConfiguration()
        - .toDeleteStorageLensConfigurationTagging()
        - .toDescribeJob()
        - .toGetAccelerateConfiguration()
        - .toGetAccessPoint()
        - .toGetAccessPointPolicy()
        - .toGetAccessPointPolicyStatus()
        - .toGetAccountPublicAccessBlock()
        - .toGetAnalyticsConfiguration()
        - .toGetBucketAcl()
        - .toGetBucketCORS()
        - .toGetBucketLogging()
        - .toGetBucketNotification()
        - .toGetBucketOwnershipControls()
        - .toGetBucketPolicy()
        - .toGetBucketPolicyStatus()
        - .toGetBucketPublicAccessBlock()
        - .toGetBucketRequestPayment()
        - .toGetBucketTagging()
        - .toGetBucketVersioning()
        - .toGetBucketWebsite()
        - .toGetEncryptionConfiguration()
        - .toGetInventoryConfiguration()
        - .toGetJobTagging()
        - .toGetLifecycleConfiguration()
        - .toGetMetricsConfiguration()
        - .toGetObject()
        - .toGetObjectAcl()
        - .toGetObjectLegalHold()
        - .toGetObjectRetention()
        - .toGetObjectTagging()
        - .toGetObjectTorrent()
        - .toGetObjectVersion()
        - .toGetObjectVersionAcl()
        - .toGetObjectVersionForReplication()
        - .toGetObjectVersionTagging()
        - .toGetObjectVersionTorrent()
        - .toGetReplicationConfiguration()
        - .toGetStorageLensConfiguration()
        - .toGetStorageLensConfigurationTagging()
        - .toGetStorageLensDashboard()
        - .toListAccessPoints()
        - .toListAllMyBuckets()
        - .toListBucket()
        - .toListBucketMultipartUploads()
        - .toListBucketVersions()
        - .toListJobs()
        - .toListMultipartUploadParts()
        - .toListStorageLensConfigurations()
        - .toObjectOwnerOverrideToBucketOwner()
        - .toPutAccelerateConfiguration()
        - .toPutAccessPointPolicy()
        - .toPutAccountPublicAccessBlock()
        - .toPutAnalyticsConfiguration()
        - .toPutBucketAcl()
        - .toPutBucketCORS()
        - .toPutBucketLogging()
        - .toPutBucketNotification()
        - .toPutBucketOwnershipControls()
        - .toPutBucketPolicy()
        - .toPutBucketPublicAccessBlock()
        - .toPutBucketRequestPayment()
        - .toPutBucketTagging()
        - .toPutBucketVersioning()
        - .toPutBucketWebsite()
        - .toPutEncryptionConfiguration()
        - .toPutInventoryConfiguration()
        - .toPutJobTagging()
        - .toPutLifecycleConfiguration()
        - .toPutMetricsConfiguration()
        - .toPutObject()
        - .toPutObjectAcl()
        - .toPutObjectLegalHold()
        - .toPutObjectRetention()
        - .toPutObjectTagging()
        - .toPutObjectVersionAcl()
        - .toPutObjectVersionTagging()
        - .toPutReplicationConfiguration()
        - .toPutStorageLensConfiguration()
        - .toPutStorageLensConfigurationTagging()
        - .toReplicateDelete()
        - .toReplicateObject()
        - .toReplicateTags()
        - .toRestoreObject()
        - .toUpdateJobPriority()
        - .toUpdateJobStatus()

        :param value: The value(s) to check.
        :param operator: Works with `string operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String>`_. **Default:** ``StringLike``.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "ifXAmzContentSha256", [value, operator])

    @jsii.member(jsii_name="ifXAmzCopySource")
    def if_x_amz_copy_source(
        self,
        value: typing.Union[builtins.str, typing.List[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, "Operator"]] = None,
    ) -> "S3":
        """Filters access to requests with a specific bucket, prefix, or object as the copy source.

        https://docs.aws.amazon.com/AmazonS3/latest/dev/amazon-s3-policy-keys.html#putobject-limit-copy-source-3

        Applies to actions:

        - .toBypassGovernanceRetention()
        - .toPutObject()

        :param value: The value(s) to check.
        :param operator: Works with `string operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String>`_. **Default:** ``StringLike``.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "ifXAmzCopySource", [value, operator])

    @jsii.member(jsii_name="ifXAmzGrantFullControl")
    def if_x_amz_grant_full_control(
        self,
        value: typing.Union[builtins.str, typing.List[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, "Operator"]] = None,
    ) -> "S3":
        """Filters access to requests with the x-amz-grant-full-control (full control) header.

        https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#permissions

        Applies to actions:

        - .toBypassGovernanceRetention()
        - .toCreateBucket()
        - .toPutBucketAcl()
        - .toPutObject()
        - .toPutObjectAcl()
        - .toPutObjectVersionAcl()

        :param value: The value(s) to check.
        :param operator: Works with `string operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String>`_. **Default:** ``StringLike``.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "ifXAmzGrantFullControl", [value, operator])

    @jsii.member(jsii_name="ifXAmzGrantRead")
    def if_x_amz_grant_read(
        self,
        value: typing.Union[builtins.str, typing.List[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, "Operator"]] = None,
    ) -> "S3":
        """Filters access to requests with the x-amz-grant-read (read access) header.

        https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#permissions

        Applies to actions:

        - .toBypassGovernanceRetention()
        - .toCreateBucket()
        - .toPutBucketAcl()
        - .toPutObject()
        - .toPutObjectAcl()
        - .toPutObjectVersionAcl()

        :param value: The value(s) to check.
        :param operator: Works with `string operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String>`_. **Default:** ``StringLike``.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "ifXAmzGrantRead", [value, operator])

    @jsii.member(jsii_name="ifXAmzGrantReadAcp")
    def if_x_amz_grant_read_acp(
        self,
        value: typing.Union[builtins.str, typing.List[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, "Operator"]] = None,
    ) -> "S3":
        """Filters access to requests with the x-amz-grant-read-acp (read permissions for the ACL) header.

        https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#permissions

        Applies to actions:

        - .toBypassGovernanceRetention()
        - .toCreateBucket()
        - .toPutBucketAcl()
        - .toPutObject()
        - .toPutObjectAcl()
        - .toPutObjectVersionAcl()

        :param value: The value(s) to check.
        :param operator: Works with `string operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String>`_. **Default:** ``StringLike``.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "ifXAmzGrantReadAcp", [value, operator])

    @jsii.member(jsii_name="ifXAmzGrantWrite")
    def if_x_amz_grant_write(
        self,
        value: typing.Union[builtins.str, typing.List[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, "Operator"]] = None,
    ) -> "S3":
        """Filters access to requests with the x-amz-grant-write (write access) header.

        https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#permissions

        Applies to actions:

        - .toBypassGovernanceRetention()
        - .toCreateBucket()
        - .toPutBucketAcl()
        - .toPutObject()
        - .toPutObjectAcl()
        - .toPutObjectVersionAcl()

        :param value: The value(s) to check.
        :param operator: Works with `string operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String>`_. **Default:** ``StringLike``.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "ifXAmzGrantWrite", [value, operator])

    @jsii.member(jsii_name="ifXAmzGrantWriteAcp")
    def if_x_amz_grant_write_acp(
        self,
        value: typing.Union[builtins.str, typing.List[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, "Operator"]] = None,
    ) -> "S3":
        """Filters access to requests with the x-amz-grant-write-acp (write permissions for the ACL) header.

        https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#permissions

        Applies to actions:

        - .toBypassGovernanceRetention()
        - .toCreateBucket()
        - .toPutBucketAcl()
        - .toPutObject()
        - .toPutObjectAcl()
        - .toPutObjectVersionAcl()

        :param value: The value(s) to check.
        :param operator: Works with `string operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String>`_. **Default:** ``StringLike``.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "ifXAmzGrantWriteAcp", [value, operator])

    @jsii.member(jsii_name="ifXAmzMetadataDirective")
    def if_x_amz_metadata_directive(
        self,
        value: typing.Union[builtins.str, typing.List[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, "Operator"]] = None,
    ) -> "S3":
        """Filters access by object metadata behavior (COPY or REPLACE) when objects are copied.

        https://docs.aws.amazon.com/AmazonS3/latest/API/API_CopyObject.html

        Applies to actions:

        - .toBypassGovernanceRetention()
        - .toPutObject()

        :param value: The value(s) to check.
        :param operator: Works with `string operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String>`_. **Default:** ``StringLike``.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "ifXAmzMetadataDirective", [value, operator])

    @jsii.member(jsii_name="ifXAmzServerSideEncryption")
    def if_x_amz_server_side_encryption(
        self,
        value: typing.Union[builtins.str, typing.List[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, "Operator"]] = None,
    ) -> "S3":
        """Filters access by server-side encryption.

        https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingServerSideEncryption.html

        Applies to actions:

        - .toBypassGovernanceRetention()
        - .toPutObject()
        - .toReplicateObject()

        :param value: The value(s) to check.
        :param operator: Works with `string operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String>`_. **Default:** ``StringLike``.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "ifXAmzServerSideEncryption", [value, operator])

    @jsii.member(jsii_name="ifXAmzServerSideEncryptionAwsKmsKeyId")
    def if_x_amz_server_side_encryption_aws_kms_key_id(
        self,
        value: typing.Union[builtins.str, typing.List[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, "Operator"]] = None,
    ) -> "S3":
        """Filters access by AWS KMS customer managed CMK for server-side encryption.

        https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingKMSEncryption.html#require-sse-kms

        Applies to actions:

        - .toBypassGovernanceRetention()
        - .toPutObject()
        - .toReplicateObject()

        :param value: The value(s) to check.
        :param operator: Works with `string operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String>`_. **Default:** ``StringLike``.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "ifXAmzServerSideEncryptionAwsKmsKeyId", [value, operator])

    @jsii.member(jsii_name="ifXAmzStorageClass")
    def if_x_amz_storage_class(
        self,
        value: typing.Union[builtins.str, typing.List[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, "Operator"]] = None,
    ) -> "S3":
        """Filters access by storage class.

        https://docs.aws.amazon.com/AmazonS3/latest/dev/storage-class-intro.html#sc-howtoset

        Applies to actions:

        - .toBypassGovernanceRetention()
        - .toPutObject()
        - .toPutObjectAcl()
        - .toPutObjectVersionAcl()

        :param value: The value(s) to check.
        :param operator: Works with `string operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String>`_. **Default:** ``StringLike``.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "ifXAmzStorageClass", [value, operator])

    @jsii.member(jsii_name="ifXAmzWebsiteRedirectLocation")
    def if_x_amz_website_redirect_location(
        self,
        value: typing.Union[builtins.str, typing.List[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, "Operator"]] = None,
    ) -> "S3":
        """Filters access by a specific website redirect location for buckets that are configured as static websites.

        https://docs.aws.amazon.com/AmazonS3/latest/dev/how-to-page-redirect.html#page-redirect-using-rest-api

        Applies to actions:

        - .toBypassGovernanceRetention()
        - .toPutObject()

        :param value: The value(s) to check.
        :param operator: Works with `string operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String>`_. **Default:** ``StringLike``.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "ifXAmzWebsiteRedirectLocation", [value, operator])

    @jsii.member(jsii_name="onAccesspoint")
    def on_accesspoint(
        self,
        access_point_name: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "S3":
        """Adds a resource of type accesspoint to the statement.

        https://docs.aws.amazon.com/AmazonS3/latest/dev/access-points.html

        :param access_point_name: - Identifier for the accessPointName.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "onAccesspoint", [access_point_name, account, region, partition])

    @jsii.member(jsii_name="onBucket")
    def on_bucket(
        self,
        bucket_name: builtins.str,
        partition: typing.Optional[builtins.str] = None,
    ) -> "S3":
        """Adds a resource of type bucket to the statement.

        https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingBucket.html

        :param bucket_name: - Identifier for the bucketName.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "onBucket", [bucket_name, partition])

    @jsii.member(jsii_name="onJob")
    def on_job(
        self,
        job_id: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "S3":
        """Adds a resource of type job to the statement.

        https://docs.aws.amazon.com/AmazonS3/latest/dev/batch-ops-managing-jobs.html

        :param job_id: - Identifier for the jobId.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "onJob", [job_id, account, region, partition])

    @jsii.member(jsii_name="onObject")
    def on_object(
        self,
        bucket_name: builtins.str,
        object_name: builtins.str,
        partition: typing.Optional[builtins.str] = None,
    ) -> "S3":
        """Adds a resource of type object to the statement.

        https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingObjects.html

        :param bucket_name: - Identifier for the bucketName.
        :param object_name: - Identifier for the objectName.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "onObject", [bucket_name, object_name, partition])

    @jsii.member(jsii_name="onStoragelensconfiguration")
    def on_storagelensconfiguration(
        self,
        config_id: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "S3":
        """Adds a resource of type storagelensconfiguration to the statement.

        https://docs.aws.amazon.com/AmazonS3/latest/dev/storage_lens.html

        :param config_id: - Identifier for the configId.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``. Possible conditions: - .ifAwsResourceTag()

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "onStoragelensconfiguration", [config_id, account, region, partition])

    @jsii.member(jsii_name="toAbortMultipartUpload")
    def to_abort_multipart_upload(self) -> "S3":
        """Grants permission to abort a multipart upload.

        Access Level: Write

        Possible conditions:

        - .ifDataAccessPointArn()
        - .ifDataAccessPointAccount()
        - .ifAccessPointNetworkOrigin()
        - .ifAuthType()
        - .ifSignatureAge()
        - .ifSignatureversion()
        - .ifXAmzContentSha256()

        https://docs.aws.amazon.com/AmazonS3/latest/API/API_AbortMultipartUpload.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toAbortMultipartUpload", [])

    @jsii.member(jsii_name="toBypassGovernanceRetention")
    def to_bypass_governance_retention(self) -> "S3":
        """Grants permission to allow circumvention of governance-mode object retention settings.

        Access Level: Permissions management

        Possible conditions:

        - .ifDataAccessPointAccount()
        - .ifDataAccessPointArn()
        - .ifAccessPointNetworkOrigin()
        - .ifRequestObjectTag()
        - .ifRequestObjectTagKeys()
        - .ifAuthType()
        - .ifSignatureAge()
        - .ifSignatureversion()
        - .ifXAmzAcl()
        - .ifXAmzContentSha256()
        - .ifXAmzCopySource()
        - .ifXAmzGrantFullControl()
        - .ifXAmzGrantRead()
        - .ifXAmzGrantReadAcp()
        - .ifXAmzGrantWrite()
        - .ifXAmzGrantWriteAcp()
        - .ifXAmzMetadataDirective()
        - .ifXAmzServerSideEncryption()
        - .ifXAmzServerSideEncryptionAwsKmsKeyId()
        - .ifXAmzStorageClass()
        - .ifXAmzWebsiteRedirectLocation()
        - .ifObjectLockMode()
        - .ifObjectLockRetainUntilDate()
        - .ifObjectLockRemainingRetentionDays()
        - .ifObjectLockLegalHold()

        https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lock-managing.html#object-lock-managing-bypass

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toBypassGovernanceRetention", [])

    @jsii.member(jsii_name="toCreateAccessPoint")
    def to_create_access_point(self) -> "S3":
        """Grants permission to create a new access point.

        Access Level: Write

        Possible conditions:

        - .ifDataAccessPointAccount()
        - .ifDataAccessPointArn()
        - .ifAccessPointNetworkOrigin()
        - .ifAuthType()
        - .ifLocationconstraint()
        - .ifSignatureAge()
        - .ifSignatureversion()
        - .ifXAmzAcl()
        - .ifXAmzContentSha256()

        https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateAccessPoint.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toCreateAccessPoint", [])

    @jsii.member(jsii_name="toCreateBucket")
    def to_create_bucket(self) -> "S3":
        """Grants permission to create a new bucket.

        Access Level: Write

        Possible conditions:

        - .ifAuthType()
        - .ifLocationconstraint()
        - .ifSignatureAge()
        - .ifSignatureversion()
        - .ifXAmzAcl()
        - .ifXAmzContentSha256()
        - .ifXAmzGrantFullControl()
        - .ifXAmzGrantRead()
        - .ifXAmzGrantReadAcp()
        - .ifXAmzGrantWrite()
        - .ifXAmzGrantWriteAcp()

        https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateBucket.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toCreateBucket", [])

    @jsii.member(jsii_name="toCreateJob")
    def to_create_job(self) -> "S3":
        """Grants permission to create a new Amazon S3 Batch Operations job.

        Access Level: Write

        Possible conditions:

        - .ifAuthType()
        - .ifSignatureAge()
        - .ifSignatureversion()
        - .ifXAmzContentSha256()
        - .ifRequestJobPriority()
        - .ifRequestJobOperation()
        - .ifAwsTagKeys()
        - .ifAwsRequestTag()

        Dependent actions:

        - iam:PassRole

        https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateJob.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toCreateJob", [])

    @jsii.member(jsii_name="toDeleteAccessPoint")
    def to_delete_access_point(self) -> "S3":
        """Grants permission to delete the access point named in the URI.

        Access Level: Write

        Possible conditions:

        - .ifDataAccessPointArn()
        - .ifDataAccessPointAccount()
        - .ifAccessPointNetworkOrigin()
        - .ifAuthType()
        - .ifSignatureAge()
        - .ifSignatureversion()
        - .ifXAmzContentSha256()

        https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteAccessPoint.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDeleteAccessPoint", [])

    @jsii.member(jsii_name="toDeleteAccessPointPolicy")
    def to_delete_access_point_policy(self) -> "S3":
        """Grants permission to delete the policy on a specified access point.

        Access Level: Permissions management

        Possible conditions:

        - .ifDataAccessPointArn()
        - .ifDataAccessPointAccount()
        - .ifAccessPointNetworkOrigin()
        - .ifAuthType()
        - .ifSignatureAge()
        - .ifSignatureversion()
        - .ifXAmzContentSha256()

        https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteAccessPointPolicy.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDeleteAccessPointPolicy", [])

    @jsii.member(jsii_name="toDeleteBucket")
    def to_delete_bucket(self) -> "S3":
        """Grants permission to delete the bucket named in the URI.

        Access Level: Write

        Possible conditions:

        - .ifAuthType()
        - .ifSignatureAge()
        - .ifSignatureversion()
        - .ifXAmzContentSha256()

        https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteBucket.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDeleteBucket", [])

    @jsii.member(jsii_name="toDeleteBucketOwnershipControls")
    def to_delete_bucket_ownership_controls(self) -> "S3":
        """Grants permission to delete ownership controls on a bucket.

        Access Level: Write

        Possible conditions:

        - .ifAuthType()
        - .ifSignatureAge()
        - .ifSignatureversion()
        - .ifXAmzContentSha256()

        https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteBucketOwnershipControls.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDeleteBucketOwnershipControls", [])

    @jsii.member(jsii_name="toDeleteBucketPolicy")
    def to_delete_bucket_policy(self) -> "S3":
        """Grants permission to delete the policy on a specified bucket.

        Access Level: Permissions management

        Possible conditions:

        - .ifAuthType()
        - .ifSignatureAge()
        - .ifSignatureversion()
        - .ifXAmzContentSha256()

        https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteBucketPolicy.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDeleteBucketPolicy", [])

    @jsii.member(jsii_name="toDeleteBucketWebsite")
    def to_delete_bucket_website(self) -> "S3":
        """Grants permission to remove the website configuration for a bucket.

        Access Level: Write

        Possible conditions:

        - .ifAuthType()
        - .ifSignatureAge()
        - .ifSignatureversion()
        - .ifXAmzContentSha256()

        https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteBucketWebsite.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDeleteBucketWebsite", [])

    @jsii.member(jsii_name="toDeleteJobTagging")
    def to_delete_job_tagging(self) -> "S3":
        """Grants permission to remove tags from an existing Amazon S3 Batch Operations job.

        Access Level: Tagging

        Possible conditions:

        - .ifAuthType()
        - .ifSignatureAge()
        - .ifSignatureversion()
        - .ifXAmzContentSha256()
        - .ifExistingJobPriority()
        - .ifExistingJobOperation()

        https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteJobTagging.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDeleteJobTagging", [])

    @jsii.member(jsii_name="toDeleteObject")
    def to_delete_object(self) -> "S3":
        """Grants permission to remove the null version of an object and insert a delete marker, which becomes the current version of the object.

        Access Level: Write

        Possible conditions:

        - .ifDataAccessPointAccount()
        - .ifDataAccessPointArn()
        - .ifAccessPointNetworkOrigin()
        - .ifAuthType()
        - .ifSignatureAge()
        - .ifSignatureversion()
        - .ifXAmzContentSha256()

        https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteObject.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDeleteObject", [])

    @jsii.member(jsii_name="toDeleteObjectTagging")
    def to_delete_object_tagging(self) -> "S3":
        """Grants permission to use the tagging subresource to remove the entire tag set from the specified object.

        Access Level: Tagging

        Possible conditions:

        - .ifDataAccessPointAccount()
        - .ifDataAccessPointArn()
        - .ifAccessPointNetworkOrigin()
        - .ifExistingObjectTag()
        - .ifAuthType()
        - .ifSignatureAge()
        - .ifSignatureversion()
        - .ifXAmzContentSha256()

        https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteObjectTagging.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDeleteObjectTagging", [])

    @jsii.member(jsii_name="toDeleteObjectVersion")
    def to_delete_object_version(self) -> "S3":
        """Grants permission to remove a specific version of an object.

        Access Level: Write

        Possible conditions:

        - .ifDataAccessPointAccount()
        - .ifDataAccessPointArn()
        - .ifAccessPointNetworkOrigin()
        - .ifAuthType()
        - .ifSignatureAge()
        - .ifSignatureversion()
        - .ifVersionid()
        - .ifXAmzContentSha256()

        https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteObject.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDeleteObjectVersion", [])

    @jsii.member(jsii_name="toDeleteObjectVersionTagging")
    def to_delete_object_version_tagging(self) -> "S3":
        """Grants permission to remove the entire tag set for a specific version of the object.

        Access Level: Tagging

        Possible conditions:

        - .ifDataAccessPointAccount()
        - .ifDataAccessPointArn()
        - .ifAccessPointNetworkOrigin()
        - .ifExistingObjectTag()
        - .ifAuthType()
        - .ifSignatureAge()
        - .ifSignatureversion()
        - .ifVersionid()
        - .ifXAmzContentSha256()

        https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteObjectTagging.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDeleteObjectVersionTagging", [])

    @jsii.member(jsii_name="toDeleteStorageLensConfiguration")
    def to_delete_storage_lens_configuration(self) -> "S3":
        """Grants permission to delete an existing Amazon S3 Storage Lens configuration.

        Access Level: Write

        Possible conditions:

        - .ifAuthType()
        - .ifSignatureAge()
        - .ifSignatureversion()
        - .ifXAmzContentSha256()

        https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteStorageLensConfiguration.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDeleteStorageLensConfiguration", [])

    @jsii.member(jsii_name="toDeleteStorageLensConfigurationTagging")
    def to_delete_storage_lens_configuration_tagging(self) -> "S3":
        """Grants permission to remove tags from an existing Amazon S3 Storage Lens configuration.

        Access Level: Tagging

        Possible conditions:

        - .ifAuthType()
        - .ifSignatureAge()
        - .ifSignatureversion()
        - .ifXAmzContentSha256()

        https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteStorageLensConfigurationTagging.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDeleteStorageLensConfigurationTagging", [])

    @jsii.member(jsii_name="toDescribeJob")
    def to_describe_job(self) -> "S3":
        """Grants permission to retrieve the configuration parameters and status for a batch operations job.

        Access Level: Read

        Possible conditions:

        - .ifAuthType()
        - .ifSignatureAge()
        - .ifSignatureversion()
        - .ifXAmzContentSha256()

        https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DescribeJob.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDescribeJob", [])

    @jsii.member(jsii_name="toGetAccelerateConfiguration")
    def to_get_accelerate_configuration(self) -> "S3":
        """Grants permission to uses the accelerate subresource to return the Transfer Acceleration state of a bucket, which is either Enabled or Suspended.

        Access Level: Read

        Possible conditions:

        - .ifAuthType()
        - .ifSignatureAge()
        - .ifSignatureversion()
        - .ifXAmzContentSha256()

        https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketAccelerateConfiguration.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toGetAccelerateConfiguration", [])

    @jsii.member(jsii_name="toGetAccessPoint")
    def to_get_access_point(self) -> "S3":
        """Grants permission to return configuration information about the specified access point.

        Access Level: Read

        Possible conditions:

        - .ifDataAccessPointAccount()
        - .ifDataAccessPointArn()
        - .ifAccessPointNetworkOrigin()
        - .ifAuthType()
        - .ifSignatureAge()
        - .ifSignatureversion()
        - .ifXAmzContentSha256()

        https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetAccessPoint.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toGetAccessPoint", [])

    @jsii.member(jsii_name="toGetAccessPointPolicy")
    def to_get_access_point_policy(self) -> "S3":
        """Grants permission to returns the access point policy associated with the specified access point.

        Access Level: Read

        Possible conditions:

        - .ifDataAccessPointAccount()
        - .ifDataAccessPointArn()
        - .ifAccessPointNetworkOrigin()
        - .ifAuthType()
        - .ifSignatureAge()
        - .ifSignatureversion()
        - .ifXAmzContentSha256()

        https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetAccessPointPolicy.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toGetAccessPointPolicy", [])

    @jsii.member(jsii_name="toGetAccessPointPolicyStatus")
    def to_get_access_point_policy_status(self) -> "S3":
        """Grants permission to return the policy status for a specific access point policy.

        Access Level: Read

        Possible conditions:

        - .ifDataAccessPointAccount()
        - .ifDataAccessPointArn()
        - .ifAccessPointNetworkOrigin()
        - .ifAuthType()
        - .ifSignatureAge()
        - .ifSignatureversion()
        - .ifXAmzContentSha256()

        https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetAccessPointPolicyStatus.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toGetAccessPointPolicyStatus", [])

    @jsii.member(jsii_name="toGetAccountPublicAccessBlock")
    def to_get_account_public_access_block(self) -> "S3":
        """Grants permission to retrieve the PublicAccessBlock configuration for an AWS account.

        Access Level: Read

        Possible conditions:

        - .ifAuthType()
        - .ifSignatureAge()
        - .ifSignatureversion()
        - .ifXAmzContentSha256()

        https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetPublicAccessBlock.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toGetAccountPublicAccessBlock", [])

    @jsii.member(jsii_name="toGetAnalyticsConfiguration")
    def to_get_analytics_configuration(self) -> "S3":
        """Grants permission to get an analytics configuration from an Amazon S3 bucket, identified by the analytics configuration ID.

        Access Level: Read

        Possible conditions:

        - .ifAuthType()
        - .ifSignatureAge()
        - .ifSignatureversion()
        - .ifXAmzContentSha256()

        https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketAnalyticsConfiguration.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toGetAnalyticsConfiguration", [])

    @jsii.member(jsii_name="toGetBucketAcl")
    def to_get_bucket_acl(self) -> "S3":
        """Grants permission to use the acl subresource to return the access control list (ACL) of an Amazon S3 bucket.

        Access Level: Read

        Possible conditions:

        - .ifAuthType()
        - .ifSignatureAge()
        - .ifSignatureversion()
        - .ifXAmzContentSha256()

        https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketAcl.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toGetBucketAcl", [])

    @jsii.member(jsii_name="toGetBucketCORS")
    def to_get_bucket_cors(self) -> "S3":
        """Grants permission to return the CORS configuration information set for an Amazon S3 bucket.

        Access Level: Read

        Possible conditions:

        - .ifAuthType()
        - .ifSignatureAge()
        - .ifSignatureversion()
        - .ifXAmzContentSha256()

        https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketCors.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toGetBucketCORS", [])

    @jsii.member(jsii_name="toGetBucketLocation")
    def to_get_bucket_location(self) -> "S3":
        """Grants permission to return the Region that an Amazon S3 bucket resides in.

        Access Level: Read

        https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketLocation.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toGetBucketLocation", [])

    @jsii.member(jsii_name="toGetBucketLogging")
    def to_get_bucket_logging(self) -> "S3":
        """Grants permission to return the logging status of an Amazon S3 bucket and the permissions users have to view or modify that status.

        Access Level: Read

        Possible conditions:

        - .ifAuthType()
        - .ifSignatureAge()
        - .ifSignatureversion()
        - .ifXAmzContentSha256()

        https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketLogging.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toGetBucketLogging", [])

    @jsii.member(jsii_name="toGetBucketNotification")
    def to_get_bucket_notification(self) -> "S3":
        """Grants permission to get the notification configuration of an Amazon S3 bucket.

        Access Level: Read

        Possible conditions:

        - .ifAuthType()
        - .ifSignatureAge()
        - .ifSignatureversion()
        - .ifXAmzContentSha256()

        https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketNotification.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toGetBucketNotification", [])

    @jsii.member(jsii_name="toGetBucketObjectLockConfiguration")
    def to_get_bucket_object_lock_configuration(self) -> "S3":
        """Grants permission to get the Object Lock configuration of an Amazon S3 bucket.

        Access Level: Read

        Possible conditions:

        - .ifAuthType()
        - .ifSignatureAge()
        - .ifSignatureversion()

        https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetObjectLockConfiguration.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toGetBucketObjectLockConfiguration", [])

    @jsii.member(jsii_name="toGetBucketOwnershipControls")
    def to_get_bucket_ownership_controls(self) -> "S3":
        """Grants permission to retrieve ownership controls on a bucket.

        Access Level: Read

        Possible conditions:

        - .ifAuthType()
        - .ifSignatureAge()
        - .ifSignatureversion()
        - .ifXAmzContentSha256()

        https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketOwnershipControls.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toGetBucketOwnershipControls", [])

    @jsii.member(jsii_name="toGetBucketPolicy")
    def to_get_bucket_policy(self) -> "S3":
        """Grants permission to return the policy of the specified bucket.

        Access Level: Read

        Possible conditions:

        - .ifAuthType()
        - .ifSignatureAge()
        - .ifSignatureversion()
        - .ifXAmzContentSha256()

        https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketPolicy.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toGetBucketPolicy", [])

    @jsii.member(jsii_name="toGetBucketPolicyStatus")
    def to_get_bucket_policy_status(self) -> "S3":
        """Grants permission to retrieve the policy status for a specific Amazon S3 bucket, which indicates whether the bucket is public.

        Access Level: Read

        Possible conditions:

        - .ifAuthType()
        - .ifSignatureAge()
        - .ifSignatureversion()
        - .ifXAmzContentSha256()

        https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketPolicyStatus.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toGetBucketPolicyStatus", [])

    @jsii.member(jsii_name="toGetBucketPublicAccessBlock")
    def to_get_bucket_public_access_block(self) -> "S3":
        """Grants permission to retrieve the PublicAccessBlock configuration for an Amazon S3 bucket.

        Access Level: Read

        Possible conditions:

        - .ifAuthType()
        - .ifSignatureAge()
        - .ifSignatureversion()
        - .ifXAmzContentSha256()

        https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetPublicAccessBlock.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toGetBucketPublicAccessBlock", [])

    @jsii.member(jsii_name="toGetBucketRequestPayment")
    def to_get_bucket_request_payment(self) -> "S3":
        """Grants permission to return the request payment configuration for an Amazon S3 bucket.

        Access Level: Read

        Possible conditions:

        - .ifAuthType()
        - .ifSignatureAge()
        - .ifSignatureversion()
        - .ifXAmzContentSha256()

        https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketRequestPayment.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toGetBucketRequestPayment", [])

    @jsii.member(jsii_name="toGetBucketTagging")
    def to_get_bucket_tagging(self) -> "S3":
        """Grants permission to return the tag set associated with an Amazon S3 bucket.

        Access Level: Read

        Possible conditions:

        - .ifAuthType()
        - .ifSignatureAge()
        - .ifSignatureversion()
        - .ifXAmzContentSha256()

        https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketTagging.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toGetBucketTagging", [])

    @jsii.member(jsii_name="toGetBucketVersioning")
    def to_get_bucket_versioning(self) -> "S3":
        """Grants permission to return the versioning state of an Amazon S3 bucket.

        Access Level: Read

        Possible conditions:

        - .ifAuthType()
        - .ifSignatureAge()
        - .ifSignatureversion()
        - .ifXAmzContentSha256()

        https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketVersioning.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toGetBucketVersioning", [])

    @jsii.member(jsii_name="toGetBucketWebsite")
    def to_get_bucket_website(self) -> "S3":
        """Grants permission to return the website configuration for an Amazon S3 bucket.

        Access Level: Read

        Possible conditions:

        - .ifAuthType()
        - .ifSignatureAge()
        - .ifSignatureversion()
        - .ifXAmzContentSha256()

        https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketWebsite.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toGetBucketWebsite", [])

    @jsii.member(jsii_name="toGetEncryptionConfiguration")
    def to_get_encryption_configuration(self) -> "S3":
        """Grants permission to return the default encryption configuration an Amazon S3 bucket.

        Access Level: Read

        Possible conditions:

        - .ifAuthType()
        - .ifSignatureAge()
        - .ifSignatureversion()
        - .ifXAmzContentSha256()

        https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketEncryption.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toGetEncryptionConfiguration", [])

    @jsii.member(jsii_name="toGetInventoryConfiguration")
    def to_get_inventory_configuration(self) -> "S3":
        """Grants permission to return an inventory configuration from an Amazon S3 bucket, identified by the inventory configuration ID.

        Access Level: Read

        Possible conditions:

        - .ifAuthType()
        - .ifSignatureAge()
        - .ifSignatureversion()
        - .ifXAmzContentSha256()

        https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketInventoryConfiguration.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toGetInventoryConfiguration", [])

    @jsii.member(jsii_name="toGetJobTagging")
    def to_get_job_tagging(self) -> "S3":
        """Grants permission to return the tag set of an existing Amazon S3 Batch Operations job.

        Access Level: Read

        Possible conditions:

        - .ifAuthType()
        - .ifSignatureAge()
        - .ifSignatureversion()
        - .ifXAmzContentSha256()

        https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetJobTagging.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toGetJobTagging", [])

    @jsii.member(jsii_name="toGetLifecycleConfiguration")
    def to_get_lifecycle_configuration(self) -> "S3":
        """Grants permission to return the lifecycle configuration information set on an Amazon S3 bucket.

        Access Level: Read

        Possible conditions:

        - .ifAuthType()
        - .ifSignatureAge()
        - .ifSignatureversion()
        - .ifXAmzContentSha256()

        https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketLifecycleConfiguration.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toGetLifecycleConfiguration", [])

    @jsii.member(jsii_name="toGetMetricsConfiguration")
    def to_get_metrics_configuration(self) -> "S3":
        """Grants permission to get a metrics configuration from an Amazon S3 bucket.

        Access Level: Read

        Possible conditions:

        - .ifAuthType()
        - .ifSignatureAge()
        - .ifSignatureversion()
        - .ifXAmzContentSha256()

        https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketMetricsConfiguration.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toGetMetricsConfiguration", [])

    @jsii.member(jsii_name="toGetObject")
    def to_get_object(self) -> "S3":
        """Grants permission to retrieve objects from Amazon S3.

        Access Level: Read

        Possible conditions:

        - .ifDataAccessPointAccount()
        - .ifDataAccessPointArn()
        - .ifAccessPointNetworkOrigin()
        - .ifExistingObjectTag()
        - .ifAuthType()
        - .ifSignatureAge()
        - .ifSignatureversion()
        - .ifXAmzContentSha256()

        https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetObject.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toGetObject", [])

    @jsii.member(jsii_name="toGetObjectAcl")
    def to_get_object_acl(self) -> "S3":
        """Grants permission to return the access control list (ACL) of an object.

        Access Level: Read

        Possible conditions:

        - .ifDataAccessPointAccount()
        - .ifDataAccessPointArn()
        - .ifAccessPointNetworkOrigin()
        - .ifExistingObjectTag()
        - .ifAuthType()
        - .ifSignatureAge()
        - .ifSignatureversion()
        - .ifXAmzContentSha256()

        https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetObjectAcl.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toGetObjectAcl", [])

    @jsii.member(jsii_name="toGetObjectLegalHold")
    def to_get_object_legal_hold(self) -> "S3":
        """Grants permission to get an object's current Legal Hold status.

        Access Level: Read

        Possible conditions:

        - .ifDataAccessPointAccount()
        - .ifDataAccessPointArn()
        - .ifAccessPointNetworkOrigin()
        - .ifAuthType()
        - .ifSignatureAge()
        - .ifSignatureversion()
        - .ifXAmzContentSha256()

        https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetObjectLegalHold.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toGetObjectLegalHold", [])

    @jsii.member(jsii_name="toGetObjectRetention")
    def to_get_object_retention(self) -> "S3":
        """Grants permission to retrieve the retention settings for an object.

        Access Level: Read

        Possible conditions:

        - .ifDataAccessPointAccount()
        - .ifDataAccessPointArn()
        - .ifAccessPointNetworkOrigin()
        - .ifAuthType()
        - .ifSignatureAge()
        - .ifSignatureversion()
        - .ifXAmzContentSha256()

        https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetObjectRetention.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toGetObjectRetention", [])

    @jsii.member(jsii_name="toGetObjectTagging")
    def to_get_object_tagging(self) -> "S3":
        """Grants permission to return the tag set of an object.

        Access Level: Read

        Possible conditions:

        - .ifDataAccessPointAccount()
        - .ifDataAccessPointArn()
        - .ifAccessPointNetworkOrigin()
        - .ifExistingObjectTag()
        - .ifAuthType()
        - .ifSignatureAge()
        - .ifSignatureversion()
        - .ifXAmzContentSha256()

        https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetObjectTagging.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toGetObjectTagging", [])

    @jsii.member(jsii_name="toGetObjectTorrent")
    def to_get_object_torrent(self) -> "S3":
        """Grants permission to return torrent files from an Amazon S3 bucket.

        Access Level: Read

        Possible conditions:

        - .ifAuthType()
        - .ifSignatureAge()
        - .ifSignatureversion()
        - .ifXAmzContentSha256()

        https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetObjectTorrent.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toGetObjectTorrent", [])

    @jsii.member(jsii_name="toGetObjectVersion")
    def to_get_object_version(self) -> "S3":
        """Grants permission to retrieve a specific version of an object.

        Access Level: Read

        Possible conditions:

        - .ifDataAccessPointAccount()
        - .ifDataAccessPointArn()
        - .ifAccessPointNetworkOrigin()
        - .ifExistingObjectTag()
        - .ifAuthType()
        - .ifSignatureAge()
        - .ifSignatureversion()
        - .ifVersionid()
        - .ifXAmzContentSha256()

        https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetObject.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toGetObjectVersion", [])

    @jsii.member(jsii_name="toGetObjectVersionAcl")
    def to_get_object_version_acl(self) -> "S3":
        """Grants permission to return the access control list (ACL) of a specific object version.

        Access Level: Read

        Possible conditions:

        - .ifDataAccessPointAccount()
        - .ifDataAccessPointArn()
        - .ifAccessPointNetworkOrigin()
        - .ifExistingObjectTag()
        - .ifAuthType()
        - .ifSignatureAge()
        - .ifSignatureversion()
        - .ifVersionid()
        - .ifXAmzContentSha256()

        https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetObjectAcl.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toGetObjectVersionAcl", [])

    @jsii.member(jsii_name="toGetObjectVersionForReplication")
    def to_get_object_version_for_replication(self) -> "S3":
        """Grants permission to replicate both unencrypted objects and objects encrypted with SSE-S3 or SSE-KMS.

        Access Level: Read

        Possible conditions:

        - .ifAuthType()
        - .ifSignatureAge()
        - .ifSignatureversion()
        - .ifXAmzContentSha256()

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toGetObjectVersionForReplication", [])

    @jsii.member(jsii_name="toGetObjectVersionTagging")
    def to_get_object_version_tagging(self) -> "S3":
        """Grants permission to return the tag set for a specific version of the object.

        Access Level: Read

        Possible conditions:

        - .ifDataAccessPointAccount()
        - .ifDataAccessPointArn()
        - .ifAccessPointNetworkOrigin()
        - .ifExistingObjectTag()
        - .ifAuthType()
        - .ifSignatureAge()
        - .ifSignatureversion()
        - .ifVersionid()
        - .ifXAmzContentSha256()

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toGetObjectVersionTagging", [])

    @jsii.member(jsii_name="toGetObjectVersionTorrent")
    def to_get_object_version_torrent(self) -> "S3":
        """Grants permission to get Torrent files about a different version using the versionId subresource.

        Access Level: Read

        Possible conditions:

        - .ifAuthType()
        - .ifSignatureAge()
        - .ifSignatureversion()
        - .ifVersionid()
        - .ifXAmzContentSha256()

        https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetObjectTorrent.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toGetObjectVersionTorrent", [])

    @jsii.member(jsii_name="toGetReplicationConfiguration")
    def to_get_replication_configuration(self) -> "S3":
        """Grants permission to get the replication configuration information set on an Amazon S3 bucket.

        Access Level: Read

        Possible conditions:

        - .ifAuthType()
        - .ifSignatureAge()
        - .ifSignatureversion()
        - .ifXAmzContentSha256()

        https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketReplication.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toGetReplicationConfiguration", [])

    @jsii.member(jsii_name="toGetStorageLensConfiguration")
    def to_get_storage_lens_configuration(self) -> "S3":
        """Grants permission to get an Amazon S3 Storage Lens configuration.

        Access Level: Read

        Possible conditions:

        - .ifAuthType()
        - .ifSignatureAge()
        - .ifSignatureversion()
        - .ifXAmzContentSha256()

        https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetStorageLensConfiguration.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toGetStorageLensConfiguration", [])

    @jsii.member(jsii_name="toGetStorageLensConfigurationTagging")
    def to_get_storage_lens_configuration_tagging(self) -> "S3":
        """Grants permission to get the tag set of an existing Amazon S3 Storage Lens configuration.

        Access Level: Read

        Possible conditions:

        - .ifAuthType()
        - .ifSignatureAge()
        - .ifSignatureversion()
        - .ifXAmzContentSha256()

        https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetStorageLensConfigurationTagging.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toGetStorageLensConfigurationTagging", [])

    @jsii.member(jsii_name="toGetStorageLensDashboard")
    def to_get_storage_lens_dashboard(self) -> "S3":
        """Grants permission to get an Amazon S3 Storage Lens dashboard.

        Access Level: Read

        Possible conditions:

        - .ifAuthType()
        - .ifSignatureAge()
        - .ifSignatureversion()
        - .ifXAmzContentSha256()

        https://docs.aws.amazon.com/AmazonS3/latest/dev/storage_lens_dashboard.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toGetStorageLensDashboard", [])

    @jsii.member(jsii_name="toListAccessPoints")
    def to_list_access_points(self) -> "S3":
        """Grants permission to list access points.

        Access Level: Read

        Possible conditions:

        - .ifAuthType()
        - .ifSignatureAge()
        - .ifSignatureversion()
        - .ifXAmzContentSha256()

        https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_ListAccessPoints.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toListAccessPoints", [])

    @jsii.member(jsii_name="toListAllMyBuckets")
    def to_list_all_my_buckets(self) -> "S3":
        """Grants permission to list all buckets owned by the authenticated sender of the request.

        Access Level: List

        Possible conditions:

        - .ifAuthType()
        - .ifSignatureAge()
        - .ifSignatureversion()
        - .ifXAmzContentSha256()

        https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListBuckets.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toListAllMyBuckets", [])

    @jsii.member(jsii_name="toListBucket")
    def to_list_bucket(self) -> "S3":
        """Grants permission to list some or all of the objects in an Amazon S3 bucket (up to 1000).

        Access Level: List

        Possible conditions:

        - .ifDataAccessPointAccount()
        - .ifDataAccessPointArn()
        - .ifAccessPointNetworkOrigin()
        - .ifAuthType()
        - .ifDelimiter()
        - .ifMaxKeys()
        - .ifPrefix()
        - .ifSignatureAge()
        - .ifSignatureversion()
        - .ifXAmzContentSha256()

        https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListObjectsV2.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toListBucket", [])

    @jsii.member(jsii_name="toListBucketMultipartUploads")
    def to_list_bucket_multipart_uploads(self) -> "S3":
        """Grants permission to list in-progress multipart uploads.

        Access Level: List

        Possible conditions:

        - .ifDataAccessPointAccount()
        - .ifDataAccessPointArn()
        - .ifAccessPointNetworkOrigin()
        - .ifAuthType()
        - .ifSignatureAge()
        - .ifSignatureversion()
        - .ifXAmzContentSha256()

        https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListMultipartUploads.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toListBucketMultipartUploads", [])

    @jsii.member(jsii_name="toListBucketVersions")
    def to_list_bucket_versions(self) -> "S3":
        """Grants permission to list metadata about all the versions of objects in an Amazon S3 bucket.

        Access Level: List

        Possible conditions:

        - .ifDataAccessPointAccount()
        - .ifDataAccessPointArn()
        - .ifAccessPointNetworkOrigin()
        - .ifAuthType()
        - .ifDelimiter()
        - .ifMaxKeys()
        - .ifPrefix()
        - .ifSignatureAge()
        - .ifSignatureversion()
        - .ifXAmzContentSha256()

        https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListObjectVersions.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toListBucketVersions", [])

    @jsii.member(jsii_name="toListJobs")
    def to_list_jobs(self) -> "S3":
        """Grants permission to list current jobs and jobs that have ended recently.

        Access Level: List

        Possible conditions:

        - .ifAuthType()
        - .ifSignatureAge()
        - .ifSignatureversion()
        - .ifXAmzContentSha256()

        https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_ListJobs.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toListJobs", [])

    @jsii.member(jsii_name="toListMultipartUploadParts")
    def to_list_multipart_upload_parts(self) -> "S3":
        """Grants permission to list the parts that have been uploaded for a specific multipart upload.

        Access Level: List

        Possible conditions:

        - .ifDataAccessPointAccount()
        - .ifDataAccessPointArn()
        - .ifAccessPointNetworkOrigin()
        - .ifAuthType()
        - .ifSignatureAge()
        - .ifSignatureversion()
        - .ifXAmzContentSha256()

        https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListParts.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toListMultipartUploadParts", [])

    @jsii.member(jsii_name="toListStorageLensConfigurations")
    def to_list_storage_lens_configurations(self) -> "S3":
        """Grants permission to list Amazon S3 Storage Lens configurations.

        Access Level: List

        Possible conditions:

        - .ifAuthType()
        - .ifSignatureAge()
        - .ifSignatureversion()
        - .ifXAmzContentSha256()

        https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_ListStorageLensConfigurations.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toListStorageLensConfigurations", [])

    @jsii.member(jsii_name="toObjectOwnerOverrideToBucketOwner")
    def to_object_owner_override_to_bucket_owner(self) -> "S3":
        """Grants permission to change replica ownership.

        Access Level: Permissions management

        Possible conditions:

        - .ifAuthType()
        - .ifSignatureAge()
        - .ifSignatureversion()
        - .ifXAmzContentSha256()

        https://docs.aws.amazon.com/AmazonS3/latest/dev/replication-change-owner.html#repl-ownership-add-role-permission

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toObjectOwnerOverrideToBucketOwner", [])

    @jsii.member(jsii_name="toPutAccelerateConfiguration")
    def to_put_accelerate_configuration(self) -> "S3":
        """Grants permission to use the accelerate subresource to set the Transfer Acceleration state of an existing S3 bucket.

        Access Level: Write

        Possible conditions:

        - .ifAuthType()
        - .ifSignatureAge()
        - .ifSignatureversion()
        - .ifXAmzContentSha256()

        https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketAccelerateConfiguration.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toPutAccelerateConfiguration", [])

    @jsii.member(jsii_name="toPutAccessPointPolicy")
    def to_put_access_point_policy(self) -> "S3":
        """Grants permission to associate an access policy with a specified access point.

        Access Level: Permissions management

        Possible conditions:

        - .ifDataAccessPointAccount()
        - .ifDataAccessPointArn()
        - .ifAccessPointNetworkOrigin()
        - .ifAuthType()
        - .ifSignatureAge()
        - .ifSignatureversion()
        - .ifXAmzContentSha256()

        https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutAccessPointPolicy.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toPutAccessPointPolicy", [])

    @jsii.member(jsii_name="toPutAccountPublicAccessBlock")
    def to_put_account_public_access_block(self) -> "S3":
        """Grants permission to create or modify the PublicAccessBlock configuration for an AWS account.

        Access Level: Permissions management

        Possible conditions:

        - .ifAuthType()
        - .ifSignatureAge()
        - .ifSignatureversion()
        - .ifXAmzContentSha256()

        https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutPublicAccessBlock.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toPutAccountPublicAccessBlock", [])

    @jsii.member(jsii_name="toPutAnalyticsConfiguration")
    def to_put_analytics_configuration(self) -> "S3":
        """Grants permission to set an analytics configuration for the bucket, specified by the analytics configuration ID.

        Access Level: Write

        Possible conditions:

        - .ifAuthType()
        - .ifSignatureAge()
        - .ifSignatureversion()
        - .ifXAmzContentSha256()

        https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketAnalyticsConfiguration.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toPutAnalyticsConfiguration", [])

    @jsii.member(jsii_name="toPutBucketAcl")
    def to_put_bucket_acl(self) -> "S3":
        """Grants permission to set the permissions on an existing bucket using access control lists (ACLs).

        Access Level: Permissions management

        Possible conditions:

        - .ifAuthType()
        - .ifSignatureAge()
        - .ifSignatureversion()
        - .ifXAmzAcl()
        - .ifXAmzContentSha256()
        - .ifXAmzGrantFullControl()
        - .ifXAmzGrantRead()
        - .ifXAmzGrantReadAcp()
        - .ifXAmzGrantWrite()
        - .ifXAmzGrantWriteAcp()

        https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketAcl.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toPutBucketAcl", [])

    @jsii.member(jsii_name="toPutBucketCORS")
    def to_put_bucket_cors(self) -> "S3":
        """Grants permission to set the CORS configuration for an Amazon S3 bucket.

        Access Level: Write

        Possible conditions:

        - .ifAuthType()
        - .ifSignatureAge()
        - .ifSignatureversion()
        - .ifXAmzContentSha256()

        https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketCors.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toPutBucketCORS", [])

    @jsii.member(jsii_name="toPutBucketLogging")
    def to_put_bucket_logging(self) -> "S3":
        """Grants permission to set the logging parameters for an Amazon S3 bucket.

        Access Level: Write

        Possible conditions:

        - .ifAuthType()
        - .ifSignatureAge()
        - .ifSignatureversion()
        - .ifXAmzContentSha256()

        https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketLogging.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toPutBucketLogging", [])

    @jsii.member(jsii_name="toPutBucketNotification")
    def to_put_bucket_notification(self) -> "S3":
        """Grants permission to receive notifications when certain events happen in an Amazon S3 bucket.

        Access Level: Write

        Possible conditions:

        - .ifAuthType()
        - .ifSignatureAge()
        - .ifSignatureversion()
        - .ifXAmzContentSha256()

        https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketNotification.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toPutBucketNotification", [])

    @jsii.member(jsii_name="toPutBucketObjectLockConfiguration")
    def to_put_bucket_object_lock_configuration(self) -> "S3":
        """Grants permission to put Object Lock configuration on a specific bucket.

        Access Level: Write

        Possible conditions:

        - .ifAuthType()
        - .ifSignatureAge()
        - .ifSignatureversion()

        https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutObjectLockConfiguration.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toPutBucketObjectLockConfiguration", [])

    @jsii.member(jsii_name="toPutBucketOwnershipControls")
    def to_put_bucket_ownership_controls(self) -> "S3":
        """Grants permission to add or replace ownership controls on a bucket.

        Access Level: Write

        Possible conditions:

        - .ifAuthType()
        - .ifSignatureAge()
        - .ifSignatureversion()
        - .ifXAmzContentSha256()

        https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketOwnershipControls.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toPutBucketOwnershipControls", [])

    @jsii.member(jsii_name="toPutBucketPolicy")
    def to_put_bucket_policy(self) -> "S3":
        """Grants permission to add or replace a bucket policy on a bucket.

        Access Level: Permissions management

        Possible conditions:

        - .ifAuthType()
        - .ifSignatureAge()
        - .ifSignatureversion()
        - .ifXAmzContentSha256()

        https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketPolicy.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toPutBucketPolicy", [])

    @jsii.member(jsii_name="toPutBucketPublicAccessBlock")
    def to_put_bucket_public_access_block(self) -> "S3":
        """Grants permission to create or modify the PublicAccessBlock configuration for a specific Amazon S3 bucket.

        Access Level: Permissions management

        Possible conditions:

        - .ifAuthType()
        - .ifSignatureAge()
        - .ifSignatureversion()
        - .ifXAmzContentSha256()

        https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutPublicAccessBlock.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toPutBucketPublicAccessBlock", [])

    @jsii.member(jsii_name="toPutBucketRequestPayment")
    def to_put_bucket_request_payment(self) -> "S3":
        """Grants permission to set the request payment configuration of a bucket.

        Access Level: Write

        Possible conditions:

        - .ifAuthType()
        - .ifSignatureAge()
        - .ifSignatureversion()
        - .ifXAmzContentSha256()

        https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketRequestPayment.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toPutBucketRequestPayment", [])

    @jsii.member(jsii_name="toPutBucketTagging")
    def to_put_bucket_tagging(self) -> "S3":
        """Grants permission to add a set of tags to an existing Amazon S3 bucket.

        Access Level: Tagging

        Possible conditions:

        - .ifAuthType()
        - .ifSignatureAge()
        - .ifSignatureversion()
        - .ifXAmzContentSha256()

        https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketTagging.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toPutBucketTagging", [])

    @jsii.member(jsii_name="toPutBucketVersioning")
    def to_put_bucket_versioning(self) -> "S3":
        """Grants permission to set the versioning state of an existing Amazon S3 bucket.

        Access Level: Write

        Possible conditions:

        - .ifAuthType()
        - .ifSignatureAge()
        - .ifSignatureversion()
        - .ifXAmzContentSha256()

        https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketVersioning.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toPutBucketVersioning", [])

    @jsii.member(jsii_name="toPutBucketWebsite")
    def to_put_bucket_website(self) -> "S3":
        """Grants permission to set the configuration of the website that is specified in the website subresource.

        Access Level: Write

        Possible conditions:

        - .ifAuthType()
        - .ifSignatureAge()
        - .ifSignatureversion()
        - .ifXAmzContentSha256()

        https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketWebsite.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toPutBucketWebsite", [])

    @jsii.member(jsii_name="toPutEncryptionConfiguration")
    def to_put_encryption_configuration(self) -> "S3":
        """Grants permission to set the encryption configuration for an Amazon S3 bucket.

        Access Level: Write

        Possible conditions:

        - .ifAuthType()
        - .ifSignatureAge()
        - .ifSignatureversion()
        - .ifXAmzContentSha256()

        https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketEncryption.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toPutEncryptionConfiguration", [])

    @jsii.member(jsii_name="toPutInventoryConfiguration")
    def to_put_inventory_configuration(self) -> "S3":
        """Grants permission to add an inventory configuration to the bucket, identified by the inventory ID.

        Access Level: Write

        Possible conditions:

        - .ifAuthType()
        - .ifSignatureAge()
        - .ifSignatureversion()
        - .ifXAmzContentSha256()

        https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketInventoryConfiguration.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toPutInventoryConfiguration", [])

    @jsii.member(jsii_name="toPutJobTagging")
    def to_put_job_tagging(self) -> "S3":
        """Grants permission to replace tags on an existing Amazon S3 Batch Operations job.

        Access Level: Tagging

        Possible conditions:

        - .ifAuthType()
        - .ifSignatureAge()
        - .ifSignatureversion()
        - .ifXAmzContentSha256()
        - .ifExistingJobPriority()
        - .ifExistingJobOperation()
        - .ifAwsTagKeys()
        - .ifAwsRequestTag()

        https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutJobTagging.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toPutJobTagging", [])

    @jsii.member(jsii_name="toPutLifecycleConfiguration")
    def to_put_lifecycle_configuration(self) -> "S3":
        """Grants permission to create a new lifecycle configuration for the bucket or replace an existing lifecycle configuration.

        Access Level: Write

        Possible conditions:

        - .ifAuthType()
        - .ifSignatureAge()
        - .ifSignatureversion()
        - .ifXAmzContentSha256()

        https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketLifecycleConfiguration.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toPutLifecycleConfiguration", [])

    @jsii.member(jsii_name="toPutMetricsConfiguration")
    def to_put_metrics_configuration(self) -> "S3":
        """Grants permission to set or update a metrics configuration for the CloudWatch request metrics from an Amazon S3 bucket.

        Access Level: Write

        Possible conditions:

        - .ifAuthType()
        - .ifSignatureAge()
        - .ifSignatureversion()
        - .ifXAmzContentSha256()

        https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketMetricsConfiguration.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toPutMetricsConfiguration", [])

    @jsii.member(jsii_name="toPutObject")
    def to_put_object(self) -> "S3":
        """Grants permission to add an object to a bucket.

        Access Level: Write

        Possible conditions:

        - .ifDataAccessPointAccount()
        - .ifDataAccessPointArn()
        - .ifAccessPointNetworkOrigin()
        - .ifRequestObjectTag()
        - .ifRequestObjectTagKeys()
        - .ifAuthType()
        - .ifSignatureAge()
        - .ifSignatureversion()
        - .ifXAmzAcl()
        - .ifXAmzContentSha256()
        - .ifXAmzCopySource()
        - .ifXAmzGrantFullControl()
        - .ifXAmzGrantRead()
        - .ifXAmzGrantReadAcp()
        - .ifXAmzGrantWrite()
        - .ifXAmzGrantWriteAcp()
        - .ifXAmzMetadataDirective()
        - .ifXAmzServerSideEncryption()
        - .ifXAmzServerSideEncryptionAwsKmsKeyId()
        - .ifXAmzStorageClass()
        - .ifXAmzWebsiteRedirectLocation()
        - .ifObjectLockMode()
        - .ifObjectLockRetainUntilDate()
        - .ifObjectLockRemainingRetentionDays()
        - .ifObjectLockLegalHold()

        https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutObject.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toPutObject", [])

    @jsii.member(jsii_name="toPutObjectAcl")
    def to_put_object_acl(self) -> "S3":
        """Grants permission to set the access control list (ACL) permissions for new or existing objects in an S3 bucket.

        Access Level: Permissions management

        Possible conditions:

        - .ifDataAccessPointAccount()
        - .ifDataAccessPointArn()
        - .ifAccessPointNetworkOrigin()
        - .ifExistingObjectTag()
        - .ifAuthType()
        - .ifSignatureAge()
        - .ifSignatureversion()
        - .ifXAmzAcl()
        - .ifXAmzContentSha256()
        - .ifXAmzGrantFullControl()
        - .ifXAmzGrantRead()
        - .ifXAmzGrantReadAcp()
        - .ifXAmzGrantWrite()
        - .ifXAmzGrantWriteAcp()
        - .ifXAmzStorageClass()

        https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutObjectAcl.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toPutObjectAcl", [])

    @jsii.member(jsii_name="toPutObjectLegalHold")
    def to_put_object_legal_hold(self) -> "S3":
        """Grants permission to apply a Legal Hold configuration to the specified object.

        Access Level: Write

        Possible conditions:

        - .ifDataAccessPointAccount()
        - .ifDataAccessPointArn()
        - .ifAccessPointNetworkOrigin()
        - .ifAuthType()
        - .ifSignatureAge()
        - .ifSignatureversion()
        - .ifXAmzContentSha256()
        - .ifObjectLockLegalHold()

        https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutObjectLegalHold.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toPutObjectLegalHold", [])

    @jsii.member(jsii_name="toPutObjectRetention")
    def to_put_object_retention(self) -> "S3":
        """Grants permission to place an Object Retention configuration on an object.

        Access Level: Write

        Possible conditions:

        - .ifDataAccessPointAccount()
        - .ifDataAccessPointArn()
        - .ifAccessPointNetworkOrigin()
        - .ifAuthType()
        - .ifSignatureAge()
        - .ifSignatureversion()
        - .ifXAmzContentSha256()
        - .ifObjectLockMode()
        - .ifObjectLockRetainUntilDate()
        - .ifObjectLockRemainingRetentionDays()

        https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutObjectRetention.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toPutObjectRetention", [])

    @jsii.member(jsii_name="toPutObjectTagging")
    def to_put_object_tagging(self) -> "S3":
        """Grants permission to set the supplied tag-set to an object that already exists in a bucket.

        Access Level: Tagging

        Possible conditions:

        - .ifDataAccessPointAccount()
        - .ifDataAccessPointArn()
        - .ifAccessPointNetworkOrigin()
        - .ifExistingObjectTag()
        - .ifRequestObjectTag()
        - .ifRequestObjectTagKeys()
        - .ifAuthType()
        - .ifSignatureAge()
        - .ifSignatureversion()
        - .ifXAmzContentSha256()

        https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutObjectTagging.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toPutObjectTagging", [])

    @jsii.member(jsii_name="toPutObjectVersionAcl")
    def to_put_object_version_acl(self) -> "S3":
        """Grants permission to use the acl subresource to set the access control list (ACL) permissions for an object that already exists in a bucket.

        Access Level: Permissions management

        Possible conditions:

        - .ifDataAccessPointAccount()
        - .ifDataAccessPointArn()
        - .ifAccessPointNetworkOrigin()
        - .ifExistingObjectTag()
        - .ifAuthType()
        - .ifSignatureAge()
        - .ifSignatureversion()
        - .ifVersionid()
        - .ifXAmzAcl()
        - .ifXAmzContentSha256()
        - .ifXAmzGrantFullControl()
        - .ifXAmzGrantRead()
        - .ifXAmzGrantReadAcp()
        - .ifXAmzGrantWrite()
        - .ifXAmzGrantWriteAcp()
        - .ifXAmzStorageClass()

        https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutObjectAcl.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toPutObjectVersionAcl", [])

    @jsii.member(jsii_name="toPutObjectVersionTagging")
    def to_put_object_version_tagging(self) -> "S3":
        """Grants permission to set the supplied tag-set for a specific version of an object.

        Access Level: Tagging

        Possible conditions:

        - .ifDataAccessPointAccount()
        - .ifDataAccessPointArn()
        - .ifAccessPointNetworkOrigin()
        - .ifExistingObjectTag()
        - .ifRequestObjectTag()
        - .ifRequestObjectTagKeys()
        - .ifAuthType()
        - .ifSignatureAge()
        - .ifSignatureversion()
        - .ifVersionid()
        - .ifXAmzContentSha256()

        https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutObjectTagging.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toPutObjectVersionTagging", [])

    @jsii.member(jsii_name="toPutReplicationConfiguration")
    def to_put_replication_configuration(self) -> "S3":
        """Grants permission to create a new replication configuration or replace an existing one.

        Access Level: Write

        Possible conditions:

        - .ifAuthType()
        - .ifSignatureAge()
        - .ifSignatureversion()
        - .ifXAmzContentSha256()

        Dependent actions:

        - iam:PassRole

        https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketReplication.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toPutReplicationConfiguration", [])

    @jsii.member(jsii_name="toPutStorageLensConfiguration")
    def to_put_storage_lens_configuration(self) -> "S3":
        """Grants permission to create or update an Amazon S3 Storage Lens configuration.

        Access Level: Write

        Possible conditions:

        - .ifAuthType()
        - .ifSignatureAge()
        - .ifSignatureversion()
        - .ifXAmzContentSha256()
        - .ifAwsTagKeys()
        - .ifAwsRequestTag()

        https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutStorageLensConfiguration.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toPutStorageLensConfiguration", [])

    @jsii.member(jsii_name="toPutStorageLensConfigurationTagging")
    def to_put_storage_lens_configuration_tagging(self) -> "S3":
        """Grants permission to put or replace tags on an existing Amazon S3 Storage Lens configuration.

        Access Level: Tagging

        Possible conditions:

        - .ifAuthType()
        - .ifSignatureAge()
        - .ifSignatureversion()
        - .ifXAmzContentSha256()
        - .ifAwsTagKeys()
        - .ifAwsRequestTag()

        https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutStorageLensConfigurationTagging.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toPutStorageLensConfigurationTagging", [])

    @jsii.member(jsii_name="toReplicateDelete")
    def to_replicate_delete(self) -> "S3":
        """Grants permission to replicate delete markers to the destination bucket.

        Access Level: Write

        Possible conditions:

        - .ifAuthType()
        - .ifSignatureAge()
        - .ifSignatureversion()
        - .ifXAmzContentSha256()

        https://docs.aws.amazon.com/AmazonS3/latest/dev/setting-repl-config-perm-overview.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toReplicateDelete", [])

    @jsii.member(jsii_name="toReplicateObject")
    def to_replicate_object(self) -> "S3":
        """Grants permission to replicate objects and object tags to the destination bucket.

        Access Level: Write

        Possible conditions:

        - .ifAuthType()
        - .ifSignatureAge()
        - .ifSignatureversion()
        - .ifXAmzContentSha256()
        - .ifXAmzServerSideEncryption()
        - .ifXAmzServerSideEncryptionAwsKmsKeyId()

        https://docs.aws.amazon.com/AmazonS3/latest/dev/setting-repl-config-perm-overview.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toReplicateObject", [])

    @jsii.member(jsii_name="toReplicateTags")
    def to_replicate_tags(self) -> "S3":
        """Grants permission to replicate object tags to the destination bucket.

        Access Level: Tagging

        Possible conditions:

        - .ifAuthType()
        - .ifSignatureAge()
        - .ifSignatureversion()
        - .ifXAmzContentSha256()

        https://docs.aws.amazon.com/AmazonS3/latest/dev/setting-repl-config-perm-overview.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toReplicateTags", [])

    @jsii.member(jsii_name="toRestoreObject")
    def to_restore_object(self) -> "S3":
        """Grants permission to restore an archived copy of an object back into Amazon S3.

        Access Level: Write

        Possible conditions:

        - .ifDataAccessPointAccount()
        - .ifDataAccessPointArn()
        - .ifAccessPointNetworkOrigin()
        - .ifAuthType()
        - .ifSignatureAge()
        - .ifSignatureversion()
        - .ifXAmzContentSha256()

        https://docs.aws.amazon.com/AmazonS3/latest/API/API_RestoreObject.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toRestoreObject", [])

    @jsii.member(jsii_name="toUpdateJobPriority")
    def to_update_job_priority(self) -> "S3":
        """Grants permission to update the priority of an existing job.

        Access Level: Write

        Possible conditions:

        - .ifAuthType()
        - .ifSignatureAge()
        - .ifSignatureversion()
        - .ifXAmzContentSha256()
        - .ifRequestJobPriority()
        - .ifExistingJobPriority()
        - .ifExistingJobOperation()

        https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_UpdateJobPriority.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toUpdateJobPriority", [])

    @jsii.member(jsii_name="toUpdateJobStatus")
    def to_update_job_status(self) -> "S3":
        """Grants permission to update the status for the specified job.

        Access Level: Write

        Possible conditions:

        - .ifAuthType()
        - .ifSignatureAge()
        - .ifSignatureversion()
        - .ifXAmzContentSha256()
        - .ifExistingJobPriority()
        - .ifExistingJobOperation()
        - .ifJobSuspendedCause()

        https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_UpdateJobStatus.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toUpdateJobStatus", [])

    @builtins.property # type: ignore
    @jsii.member(jsii_name="accessLevelList")
    def _access_level_list(self) -> "AccessLevelList":
        """
        stability
        :stability: experimental
        """
        return jsii.get(self, "accessLevelList")

    @_access_level_list.setter # type: ignore
    def _access_level_list(self, value: "AccessLevelList") -> None:
        jsii.set(self, "accessLevelList", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="servicePrefix")
    def service_prefix(self) -> builtins.str:
        """Holds the prefix of the service actions, e.g. ``ec2``.

        stability
        :stability: experimental
        """
        return jsii.get(self, "servicePrefix")

    @service_prefix.setter # type: ignore
    def service_prefix(self, value: builtins.str) -> None:
        jsii.set(self, "servicePrefix", value)


class S3Outposts(
    PolicyStatement,
    metaclass=jsii.JSIIMeta,
    jsii_type="iam-floyd.S3Outposts",
):
    """Statement provider for service `s3-outposts <https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazons3onoutposts.html>`_.

    stability
    :stability: experimental
    """

    def __init__(self, sid: typing.Optional[builtins.str] = None) -> None:
        """Statement provider for service `s3-outposts <https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazons3onoutposts.html>`_.

        :param sid: `SID <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html>`_ of the statement.

        stability
        :stability: experimental
        """
        jsii.create(S3Outposts, self, [sid])

    @jsii.member(jsii_name="ifAccessPointNetworkOrigin")
    def if_access_point_network_origin(
        self,
        value: typing.Union[builtins.str, typing.List[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, "Operator"]] = None,
    ) -> "S3Outposts":
        """Filters access by the network origin (Internet or VPC).

        https://docs.aws.amazon.com/AmazonS3/latest/dev/creating-access-points.html#access-points-policies

        Applies to actions:

        - .toAbortMultipartUpload()
        - .toCreateAccessPoint()
        - .toDeleteAccessPoint()
        - .toDeleteAccessPointPolicy()
        - .toDeleteObject()
        - .toDeleteObjectTagging()
        - .toGetAccessPoint()
        - .toGetAccessPointPolicy()
        - .toGetObject()
        - .toGetObjectTagging()
        - .toListBucket()
        - .toListBucketMultipartUploads()
        - .toListMultipartUploadParts()
        - .toPutAccessPointPolicy()
        - .toPutObject()
        - .toPutObjectAcl()
        - .toPutObjectTagging()

        :param value: The value(s) to check.
        :param operator: Works with `string operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String>`_. **Default:** ``StringLike``.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "ifAccessPointNetworkOrigin", [value, operator])

    @jsii.member(jsii_name="ifAuthType")
    def if_auth_type(
        self,
        value: typing.Union[builtins.str, typing.List[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, "Operator"]] = None,
    ) -> "S3Outposts":
        """Filters access by restricting incoming requests to a specific authentication method.

        https://docs.aws.amazon.com/AmazonS3/latest/API/bucket-policy-s3-sigv4-conditions.html

        Applies to actions:

        - .toAbortMultipartUpload()
        - .toCreateAccessPoint()
        - .toCreateBucket()
        - .toDeleteAccessPoint()
        - .toDeleteAccessPointPolicy()
        - .toDeleteBucket()
        - .toDeleteBucketPolicy()
        - .toDeleteObject()
        - .toDeleteObjectTagging()
        - .toGetAccessPoint()
        - .toGetAccessPointPolicy()
        - .toGetBucket()
        - .toGetBucketPolicy()
        - .toGetBucketTagging()
        - .toGetLifecycleConfiguration()
        - .toGetObject()
        - .toGetObjectTagging()
        - .toListAccessPoints()
        - .toListBucket()
        - .toListBucketMultipartUploads()
        - .toListMultipartUploadParts()
        - .toListRegionalBuckets()
        - .toPutAccessPointPolicy()
        - .toPutBucketPolicy()
        - .toPutBucketTagging()
        - .toPutLifecycleConfiguration()
        - .toPutObject()
        - .toPutObjectAcl()
        - .toPutObjectTagging()

        :param value: The value(s) to check.
        :param operator: Works with `string operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String>`_. **Default:** ``StringLike``.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "ifAuthType", [value, operator])

    @jsii.member(jsii_name="ifDataAccessPointAccount")
    def if_data_access_point_account(
        self,
        value: typing.Union[builtins.str, typing.List[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, "Operator"]] = None,
    ) -> "S3Outposts":
        """Filters access by the AWS Account ID that owns the access point.

        https://docs.aws.amazon.com/AmazonS3/latest/dev/creating-access-points.html#access-points-policies

        Applies to actions:

        - .toAbortMultipartUpload()
        - .toCreateAccessPoint()
        - .toDeleteAccessPoint()
        - .toDeleteAccessPointPolicy()
        - .toDeleteObject()
        - .toDeleteObjectTagging()
        - .toGetAccessPoint()
        - .toGetAccessPointPolicy()
        - .toGetObject()
        - .toGetObjectTagging()
        - .toListBucket()
        - .toListBucketMultipartUploads()
        - .toListMultipartUploadParts()
        - .toPutAccessPointPolicy()
        - .toPutObject()
        - .toPutObjectAcl()
        - .toPutObjectTagging()

        :param value: The value(s) to check.
        :param operator: Works with `string operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String>`_. **Default:** ``StringLike``.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "ifDataAccessPointAccount", [value, operator])

    @jsii.member(jsii_name="ifDataAccessPointArn")
    def if_data_access_point_arn(
        self,
        value: typing.Union[builtins.str, typing.List[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, "Operator"]] = None,
    ) -> "S3Outposts":
        """Filters access by an access point Amazon Resource Name (ARN).

        Applies to actions:

        - .toAbortMultipartUpload()
        - .toCreateAccessPoint()
        - .toDeleteAccessPoint()
        - .toDeleteAccessPointPolicy()
        - .toDeleteObject()
        - .toDeleteObjectTagging()
        - .toGetAccessPoint()
        - .toGetAccessPointPolicy()
        - .toGetObject()
        - .toGetObjectTagging()
        - .toListBucket()
        - .toListBucketMultipartUploads()
        - .toListMultipartUploadParts()
        - .toPutAccessPointPolicy()
        - .toPutObject()
        - .toPutObjectAcl()
        - .toPutObjectTagging()

        :param value: The value(s) to check.
        :param operator: Works with `string operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String>`_. **Default:** ``StringLike``.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "ifDataAccessPointArn", [value, operator])

    @jsii.member(jsii_name="ifDelimiter")
    def if_delimiter(
        self,
        value: typing.Union[builtins.str, typing.List[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, "Operator"]] = None,
    ) -> "S3Outposts":
        """Filters access by requiring the delimiter parameter.

        https://docs.aws.amazon.com/AmazonS3/latest/dev/walkthrough1.html

        Applies to actions:

        - .toListBucket()

        :param value: The value(s) to check.
        :param operator: Works with `string operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String>`_. **Default:** ``StringLike``.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "ifDelimiter", [value, operator])

    @jsii.member(jsii_name="ifExistingObjectTag")
    def if_existing_object_tag(
        self,
        key: builtins.str,
        value: typing.Union[builtins.str, typing.List[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, "Operator"]] = None,
    ) -> "S3Outposts":
        """Filters access by requiring that an existing object tag has a specific tag key and value.

        https://docs.aws.amazon.com/AmazonS3/latest/dev/object-tagging.html#tagging-and-policies

        Applies to actions:

        - .toDeleteObjectTagging()
        - .toGetObject()
        - .toGetObjectTagging()
        - .toPutObjectAcl()
        - .toPutObjectTagging()

        :param key: The tag key to check.
        :param value: The value(s) to check.
        :param operator: Works with `string operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String>`_. **Default:** ``StringLike``.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "ifExistingObjectTag", [key, value, operator])

    @jsii.member(jsii_name="ifMaxKeys")
    def if_max_keys(
        self,
        value: typing.Union[jsii.Number, typing.List[jsii.Number]],
        operator: typing.Optional[typing.Union[builtins.str, "Operator"]] = None,
    ) -> "S3Outposts":
        """Filters access by limiting the maximum number of keys returned in a ListBucket request.

        https://docs.aws.amazon.com/AmazonS3/latest/dev/amazon-s3-policy-keys.html#example-numeric-condition-operators

        Applies to actions:

        - .toListBucket()

        :param value: The value(s) to check.
        :param operator: Works with `numeric operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_Numeric>`_. **Default:** ``NumericEquals``.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "ifMaxKeys", [value, operator])

    @jsii.member(jsii_name="ifPrefix")
    def if_prefix(
        self,
        value: typing.Union[builtins.str, typing.List[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, "Operator"]] = None,
    ) -> "S3Outposts":
        """Filters access by key name prefix.

        https://docs.aws.amazon.com/AmazonS3/latest/dev/amazon-s3-policy-keys.html#condition-key-bucket-ops-2

        Applies to actions:

        - .toListBucket()

        :param value: The value(s) to check.
        :param operator: Works with `string operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String>`_. **Default:** ``StringLike``.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "ifPrefix", [value, operator])

    @jsii.member(jsii_name="ifRequestObjectTag")
    def if_request_object_tag(
        self,
        key: builtins.str,
        value: typing.Union[builtins.str, typing.List[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, "Operator"]] = None,
    ) -> "S3Outposts":
        """Filters access by restricting the tag keys and values allowed on objects.

        https://docs.aws.amazon.com/AmazonS3/latest/dev/object-tagging.html#tagging-and-policies

        Applies to actions:

        - .toPutObject()
        - .toPutObjectTagging()

        :param key: The tag key to check.
        :param value: The value(s) to check.
        :param operator: Works with `string operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String>`_. **Default:** ``StringLike``.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "ifRequestObjectTag", [key, value, operator])

    @jsii.member(jsii_name="ifRequestObjectTagKeys")
    def if_request_object_tag_keys(
        self,
        value: typing.Union[builtins.str, typing.List[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, "Operator"]] = None,
    ) -> "S3Outposts":
        """Filters access by restricting the tag keys allowed on objects.

        https://docs.aws.amazon.com/AmazonS3/latest/dev/object-tagging.html#tagging-and-policies

        Applies to actions:

        - .toPutObject()
        - .toPutObjectTagging()

        :param value: The value(s) to check.
        :param operator: Works with `string operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String>`_. **Default:** ``StringLike``.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "ifRequestObjectTagKeys", [value, operator])

    @jsii.member(jsii_name="ifSignatureAge")
    def if_signature_age(
        self,
        value: typing.Union[jsii.Number, typing.List[jsii.Number]],
        operator: typing.Optional[typing.Union[builtins.str, "Operator"]] = None,
    ) -> "S3Outposts":
        """Filters access by identifying the length of time, in milliseconds, that a signature is valid in an authenticated request.

        https://docs.aws.amazon.com/AmazonS3/latest/API/bucket-policy-s3-sigv4-conditions.html

        Applies to actions:

        - .toAbortMultipartUpload()
        - .toCreateAccessPoint()
        - .toCreateBucket()
        - .toDeleteAccessPoint()
        - .toDeleteAccessPointPolicy()
        - .toDeleteBucket()
        - .toDeleteBucketPolicy()
        - .toDeleteObject()
        - .toDeleteObjectTagging()
        - .toGetAccessPoint()
        - .toGetAccessPointPolicy()
        - .toGetBucket()
        - .toGetBucketPolicy()
        - .toGetBucketTagging()
        - .toGetLifecycleConfiguration()
        - .toGetObject()
        - .toGetObjectTagging()
        - .toListAccessPoints()
        - .toListBucket()
        - .toListBucketMultipartUploads()
        - .toListMultipartUploadParts()
        - .toListRegionalBuckets()
        - .toPutAccessPointPolicy()
        - .toPutBucketPolicy()
        - .toPutBucketTagging()
        - .toPutLifecycleConfiguration()
        - .toPutObject()
        - .toPutObjectAcl()
        - .toPutObjectTagging()

        :param value: The value(s) to check.
        :param operator: Works with `numeric operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_Numeric>`_. **Default:** ``NumericEquals``.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "ifSignatureAge", [value, operator])

    @jsii.member(jsii_name="ifSignatureversion")
    def if_signatureversion(
        self,
        value: typing.Union[builtins.str, typing.List[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, "Operator"]] = None,
    ) -> "S3Outposts":
        """Filters access by identifying the version of AWS Signature that is supported for authenticated requests.

        https://docs.aws.amazon.com/AmazonS3/latest/API/bucket-policy-s3-sigv4-conditions.html

        Applies to actions:

        - .toAbortMultipartUpload()
        - .toCreateAccessPoint()
        - .toCreateBucket()
        - .toDeleteAccessPoint()
        - .toDeleteAccessPointPolicy()
        - .toDeleteBucket()
        - .toDeleteBucketPolicy()
        - .toDeleteObject()
        - .toDeleteObjectTagging()
        - .toGetAccessPoint()
        - .toGetAccessPointPolicy()
        - .toGetBucket()
        - .toGetBucketPolicy()
        - .toGetBucketTagging()
        - .toGetLifecycleConfiguration()
        - .toGetObject()
        - .toGetObjectTagging()
        - .toListAccessPoints()
        - .toListBucket()
        - .toListBucketMultipartUploads()
        - .toListMultipartUploadParts()
        - .toListRegionalBuckets()
        - .toPutAccessPointPolicy()
        - .toPutBucketPolicy()
        - .toPutBucketTagging()
        - .toPutLifecycleConfiguration()
        - .toPutObject()
        - .toPutObjectAcl()
        - .toPutObjectTagging()

        :param value: The value(s) to check.
        :param operator: Works with `string operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String>`_. **Default:** ``StringLike``.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "ifSignatureversion", [value, operator])

    @jsii.member(jsii_name="ifXAmzAcl")
    def if_x_amz_acl(
        self,
        value: typing.Union[builtins.str, typing.List[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, "Operator"]] = None,
    ) -> "S3Outposts":
        """Filters access by requiring the x-amz-acl header with a specific canned ACL in a request.

        https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#permissions

        Applies to actions:

        - .toPutObject()
        - .toPutObjectAcl()

        :param value: The value(s) to check.
        :param operator: Works with `string operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String>`_. **Default:** ``StringLike``.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "ifXAmzAcl", [value, operator])

    @jsii.member(jsii_name="ifXAmzContentSha256")
    def if_x_amz_content_sha256(
        self,
        value: typing.Union[builtins.str, typing.List[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, "Operator"]] = None,
    ) -> "S3Outposts":
        """Filters access by disallowing unsigned content in your bucket.

        https://docs.aws.amazon.com/AmazonS3/latest/API/bucket-policy-s3-sigv4-conditions.html

        Applies to actions:

        - .toAbortMultipartUpload()
        - .toCreateAccessPoint()
        - .toCreateBucket()
        - .toDeleteAccessPoint()
        - .toDeleteAccessPointPolicy()
        - .toDeleteBucket()
        - .toDeleteBucketPolicy()
        - .toDeleteObject()
        - .toDeleteObjectTagging()
        - .toGetAccessPoint()
        - .toGetAccessPointPolicy()
        - .toGetBucket()
        - .toGetBucketPolicy()
        - .toGetBucketTagging()
        - .toGetLifecycleConfiguration()
        - .toGetObject()
        - .toGetObjectTagging()
        - .toListAccessPoints()
        - .toListBucket()
        - .toListBucketMultipartUploads()
        - .toListMultipartUploadParts()
        - .toListRegionalBuckets()
        - .toPutAccessPointPolicy()
        - .toPutBucketPolicy()
        - .toPutBucketTagging()
        - .toPutLifecycleConfiguration()
        - .toPutObject()
        - .toPutObjectAcl()
        - .toPutObjectTagging()

        :param value: The value(s) to check.
        :param operator: Works with `string operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String>`_. **Default:** ``StringLike``.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "ifXAmzContentSha256", [value, operator])

    @jsii.member(jsii_name="ifXAmzCopySource")
    def if_x_amz_copy_source(
        self,
        value: typing.Union[builtins.str, typing.List[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, "Operator"]] = None,
    ) -> "S3Outposts":
        """Filters access by restricting the copy source to a specific bucket, prefix, or object.

        https://docs.aws.amazon.com/AmazonS3/latest/dev/amazon-s3-policy-keys.html#putobject-limit-copy-source-3

        Applies to actions:

        - .toPutObject()

        :param value: The value(s) to check.
        :param operator: Works with `string operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String>`_. **Default:** ``StringLike``.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "ifXAmzCopySource", [value, operator])

    @jsii.member(jsii_name="ifXAmzMetadataDirective")
    def if_x_amz_metadata_directive(
        self,
        value: typing.Union[builtins.str, typing.List[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, "Operator"]] = None,
    ) -> "S3Outposts":
        """Filters access by enabling enforcement of object metadata behavior (COPY or REPLACE) when objects are copied.

        https://docs.aws.amazon.com/AmazonS3/latest/API/API_CopyObject.html

        Applies to actions:

        - .toPutObject()

        :param value: The value(s) to check.
        :param operator: Works with `string operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String>`_. **Default:** ``StringLike``.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "ifXAmzMetadataDirective", [value, operator])

    @jsii.member(jsii_name="ifXAmzServerSideEncryption")
    def if_x_amz_server_side_encryption(
        self,
        value: typing.Union[builtins.str, typing.List[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, "Operator"]] = None,
    ) -> "S3Outposts":
        """Filters access by requiring server-side encryption.

        https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingServerSideEncryption.html

        Applies to actions:

        - .toPutObject()

        :param value: The value(s) to check.
        :param operator: Works with `string operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String>`_. **Default:** ``StringLike``.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "ifXAmzServerSideEncryption", [value, operator])

    @jsii.member(jsii_name="ifXAmzStorageClass")
    def if_x_amz_storage_class(
        self,
        value: typing.Union[builtins.str, typing.List[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, "Operator"]] = None,
    ) -> "S3Outposts":
        """Filters access by storage class.

        https://docs.aws.amazon.com/AmazonS3/latest/dev/storage-class-intro.html#sc-howtoset

        Applies to actions:

        - .toPutObject()
        - .toPutObjectAcl()

        :param value: The value(s) to check.
        :param operator: Works with `string operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String>`_. **Default:** ``StringLike``.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "ifXAmzStorageClass", [value, operator])

    @jsii.member(jsii_name="onAccesspoint")
    def on_accesspoint(
        self,
        outpost_id: builtins.str,
        access_point_name: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "S3Outposts":
        """Adds a resource of type accesspoint to the statement.

        https://docs.aws.amazon.com/AmazonS3/latest/dev/access-points.html

        :param outpost_id: - Identifier for the outpostId.
        :param access_point_name: - Identifier for the accessPointName.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "onAccesspoint", [outpost_id, access_point_name, account, region, partition])

    @jsii.member(jsii_name="onBucket")
    def on_bucket(
        self,
        outpost_id: builtins.str,
        bucket_name: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "S3Outposts":
        """Adds a resource of type bucket to the statement.

        https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingBucket.html

        :param outpost_id: - Identifier for the outpostId.
        :param bucket_name: - Identifier for the bucketName.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "onBucket", [outpost_id, bucket_name, account, region, partition])

    @jsii.member(jsii_name="onEndpoint")
    def on_endpoint(
        self,
        outpost_id: builtins.str,
        endpoint_id: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "S3Outposts":
        """Adds a resource of type endpoint to the statement.

        https://docs.aws.amazon.com/AmazonS3/latest/dev/outposts-endpoints.html

        :param outpost_id: - Identifier for the outpostId.
        :param endpoint_id: - Identifier for the endpointId.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "onEndpoint", [outpost_id, endpoint_id, account, region, partition])

    @jsii.member(jsii_name="onObject")
    def on_object(
        self,
        outpost_id: builtins.str,
        bucket_name: builtins.str,
        object_name: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "S3Outposts":
        """Adds a resource of type object to the statement.

        https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingObjects.html

        :param outpost_id: - Identifier for the outpostId.
        :param bucket_name: - Identifier for the bucketName.
        :param object_name: - Identifier for the objectName.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "onObject", [outpost_id, bucket_name, object_name, account, region, partition])

    @jsii.member(jsii_name="toAbortMultipartUpload")
    def to_abort_multipart_upload(self) -> "S3Outposts":
        """Grants permission to abort a multipart upload.

        Access Level: Write

        Possible conditions:

        - .ifDataAccessPointArn()
        - .ifDataAccessPointAccount()
        - .ifAccessPointNetworkOrigin()
        - .ifAuthType()
        - .ifSignatureAge()
        - .ifSignatureversion()
        - .ifXAmzContentSha256()

        https://docs.aws.amazon.com/AmazonS3/latest/API/API_AbortMultipartUpload.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toAbortMultipartUpload", [])

    @jsii.member(jsii_name="toCreateAccessPoint")
    def to_create_access_point(self) -> "S3Outposts":
        """Grants permission to create a new access point.

        Access Level: Write

        Possible conditions:

        - .ifDataAccessPointAccount()
        - .ifDataAccessPointArn()
        - .ifAccessPointNetworkOrigin()
        - .ifAuthType()
        - .ifSignatureAge()
        - .ifSignatureversion()
        - .ifXAmzContentSha256()

        https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateAccessPoint.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toCreateAccessPoint", [])

    @jsii.member(jsii_name="toCreateBucket")
    def to_create_bucket(self) -> "S3Outposts":
        """Grants permission to create a new bucket.

        Access Level: Write

        Possible conditions:

        - .ifAuthType()
        - .ifSignatureAge()
        - .ifSignatureversion()
        - .ifXAmzContentSha256()

        https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateBucket.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toCreateBucket", [])

    @jsii.member(jsii_name="toCreateEndpoint")
    def to_create_endpoint(self) -> "S3Outposts":
        """Grants permission to create a new endpoint.

        Access Level: Write

        https://docs.aws.amazon.com/AmazonS3/latest/API/API_s3outposts_CreateEndpoint.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toCreateEndpoint", [])

    @jsii.member(jsii_name="toDeleteAccessPoint")
    def to_delete_access_point(self) -> "S3Outposts":
        """Grants permission to delete the access point named in the URI.

        Access Level: Write

        Possible conditions:

        - .ifDataAccessPointArn()
        - .ifDataAccessPointAccount()
        - .ifAccessPointNetworkOrigin()
        - .ifAuthType()
        - .ifSignatureAge()
        - .ifSignatureversion()
        - .ifXAmzContentSha256()

        https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteAccessPoint.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDeleteAccessPoint", [])

    @jsii.member(jsii_name="toDeleteAccessPointPolicy")
    def to_delete_access_point_policy(self) -> "S3Outposts":
        """Grants permission to delete the policy on a specified access point.

        Access Level: Permissions management

        Possible conditions:

        - .ifDataAccessPointArn()
        - .ifDataAccessPointAccount()
        - .ifAccessPointNetworkOrigin()
        - .ifAuthType()
        - .ifSignatureAge()
        - .ifSignatureversion()
        - .ifXAmzContentSha256()

        https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteAccessPointPolicy.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDeleteAccessPointPolicy", [])

    @jsii.member(jsii_name="toDeleteBucket")
    def to_delete_bucket(self) -> "S3Outposts":
        """Grants permission to delete the bucket named in the URI.

        Access Level: Write

        Possible conditions:

        - .ifAuthType()
        - .ifSignatureAge()
        - .ifSignatureversion()
        - .ifXAmzContentSha256()

        https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteBucket.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDeleteBucket", [])

    @jsii.member(jsii_name="toDeleteBucketPolicy")
    def to_delete_bucket_policy(self) -> "S3Outposts":
        """Grants permission to delete the policy on a specified bucket.

        Access Level: Permissions management

        Possible conditions:

        - .ifAuthType()
        - .ifSignatureAge()
        - .ifSignatureversion()
        - .ifXAmzContentSha256()

        https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteBucketPolicy.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDeleteBucketPolicy", [])

    @jsii.member(jsii_name="toDeleteEndpoint")
    def to_delete_endpoint(self) -> "S3Outposts":
        """Grants permission to delete the endpoint named in the URI.

        Access Level: Write

        https://docs.aws.amazon.com/AmazonS3/latest/API/API_s3outposts_DeleteEndpoint.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDeleteEndpoint", [])

    @jsii.member(jsii_name="toDeleteObject")
    def to_delete_object(self) -> "S3Outposts":
        """Grants permission to remove the null version of an object and insert a delete marker, which becomes the current version of the object.

        Access Level: Write

        Possible conditions:

        - .ifDataAccessPointAccount()
        - .ifDataAccessPointArn()
        - .ifAccessPointNetworkOrigin()
        - .ifAuthType()
        - .ifSignatureAge()
        - .ifSignatureversion()
        - .ifXAmzContentSha256()

        https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteObject.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDeleteObject", [])

    @jsii.member(jsii_name="toDeleteObjectTagging")
    def to_delete_object_tagging(self) -> "S3Outposts":
        """Grants permission to use the tagging subresource to remove the entire tag set from the specified object.

        Access Level: Tagging

        Possible conditions:

        - .ifDataAccessPointAccount()
        - .ifDataAccessPointArn()
        - .ifAccessPointNetworkOrigin()
        - .ifExistingObjectTag()
        - .ifAuthType()
        - .ifSignatureAge()
        - .ifSignatureversion()
        - .ifXAmzContentSha256()

        https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteObjectTagging.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDeleteObjectTagging", [])

    @jsii.member(jsii_name="toGetAccessPoint")
    def to_get_access_point(self) -> "S3Outposts":
        """Grants permission to return configuration information about the specified access point.

        Access Level: Read

        Possible conditions:

        - .ifDataAccessPointAccount()
        - .ifDataAccessPointArn()
        - .ifAccessPointNetworkOrigin()
        - .ifAuthType()
        - .ifSignatureAge()
        - .ifSignatureversion()
        - .ifXAmzContentSha256()

        https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetAccessPoint.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toGetAccessPoint", [])

    @jsii.member(jsii_name="toGetAccessPointPolicy")
    def to_get_access_point_policy(self) -> "S3Outposts":
        """Grants permission to returns the access point policy associated with the specified access point.

        Access Level: Read

        Possible conditions:

        - .ifDataAccessPointAccount()
        - .ifDataAccessPointArn()
        - .ifAccessPointNetworkOrigin()
        - .ifAuthType()
        - .ifSignatureAge()
        - .ifSignatureversion()
        - .ifXAmzContentSha256()

        https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetAccessPointPolicy.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toGetAccessPointPolicy", [])

    @jsii.member(jsii_name="toGetBucket")
    def to_get_bucket(self) -> "S3Outposts":
        """Grants permission to return the bucket configuration associated with an Amazon S3 bucket.

        Access Level: Read

        Possible conditions:

        - .ifAuthType()
        - .ifSignatureAge()
        - .ifSignatureversion()
        - .ifXAmzContentSha256()

        https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetBucket.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toGetBucket", [])

    @jsii.member(jsii_name="toGetBucketPolicy")
    def to_get_bucket_policy(self) -> "S3Outposts":
        """Grants permission to return the policy of the specified bucket.

        Access Level: Read

        Possible conditions:

        - .ifAuthType()
        - .ifSignatureAge()
        - .ifSignatureversion()
        - .ifXAmzContentSha256()

        https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetBucketPolicy.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toGetBucketPolicy", [])

    @jsii.member(jsii_name="toGetBucketTagging")
    def to_get_bucket_tagging(self) -> "S3Outposts":
        """Grants permission to return the tag set associated with an Amazon S3 bucket.

        Access Level: Read

        Possible conditions:

        - .ifAuthType()
        - .ifSignatureAge()
        - .ifSignatureversion()
        - .ifXAmzContentSha256()

        https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetBucketTagging.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toGetBucketTagging", [])

    @jsii.member(jsii_name="toGetLifecycleConfiguration")
    def to_get_lifecycle_configuration(self) -> "S3Outposts":
        """Grants permission to return the lifecycle configuration information set on an Amazon S3 bucket.

        Access Level: Read

        Possible conditions:

        - .ifAuthType()
        - .ifSignatureAge()
        - .ifSignatureversion()
        - .ifXAmzContentSha256()

        https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetBucketLifecycleConfiguration.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toGetLifecycleConfiguration", [])

    @jsii.member(jsii_name="toGetObject")
    def to_get_object(self) -> "S3Outposts":
        """Grants permission to retrieve objects from Amazon S3.

        Access Level: Read

        Possible conditions:

        - .ifDataAccessPointAccount()
        - .ifDataAccessPointArn()
        - .ifAccessPointNetworkOrigin()
        - .ifExistingObjectTag()
        - .ifAuthType()
        - .ifSignatureAge()
        - .ifSignatureversion()
        - .ifXAmzContentSha256()

        https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetObject.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toGetObject", [])

    @jsii.member(jsii_name="toGetObjectTagging")
    def to_get_object_tagging(self) -> "S3Outposts":
        """Grants permission to return the tag set of an object.

        Access Level: Read

        Possible conditions:

        - .ifDataAccessPointAccount()
        - .ifDataAccessPointArn()
        - .ifAccessPointNetworkOrigin()
        - .ifExistingObjectTag()
        - .ifAuthType()
        - .ifSignatureAge()
        - .ifSignatureversion()
        - .ifXAmzContentSha256()

        https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetObjectTagging.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toGetObjectTagging", [])

    @jsii.member(jsii_name="toListAccessPoints")
    def to_list_access_points(self) -> "S3Outposts":
        """Grants permission to list access points.

        Access Level: List

        Possible conditions:

        - .ifAuthType()
        - .ifSignatureAge()
        - .ifSignatureversion()
        - .ifXAmzContentSha256()

        https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_ListAccessPoints.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toListAccessPoints", [])

    @jsii.member(jsii_name="toListBucket")
    def to_list_bucket(self) -> "S3Outposts":
        """Grants permission to list some or all of the objects in an Amazon S3 bucket (up to 1000).

        Access Level: List

        Possible conditions:

        - .ifDataAccessPointAccount()
        - .ifDataAccessPointArn()
        - .ifAccessPointNetworkOrigin()
        - .ifAuthType()
        - .ifDelimiter()
        - .ifMaxKeys()
        - .ifPrefix()
        - .ifSignatureAge()
        - .ifSignatureversion()
        - .ifXAmzContentSha256()

        https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListObjectsV2.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toListBucket", [])

    @jsii.member(jsii_name="toListBucketMultipartUploads")
    def to_list_bucket_multipart_uploads(self) -> "S3Outposts":
        """Grants permission to list in-progress multipart uploads.

        Access Level: List

        Possible conditions:

        - .ifDataAccessPointAccount()
        - .ifDataAccessPointArn()
        - .ifAccessPointNetworkOrigin()
        - .ifAuthType()
        - .ifSignatureAge()
        - .ifSignatureversion()
        - .ifXAmzContentSha256()

        https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListMultipartUploads.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toListBucketMultipartUploads", [])

    @jsii.member(jsii_name="toListEndpoints")
    def to_list_endpoints(self) -> "S3Outposts":
        """Grants permission to list endpoints.

        Access Level: List

        https://docs.aws.amazon.com/AmazonS3/latest/API/API_s3outposts_ListEndpoints.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toListEndpoints", [])

    @jsii.member(jsii_name="toListMultipartUploadParts")
    def to_list_multipart_upload_parts(self) -> "S3Outposts":
        """Grants permission to list the parts that have been uploaded for a specific multipart upload.

        Access Level: List

        Possible conditions:

        - .ifDataAccessPointAccount()
        - .ifDataAccessPointArn()
        - .ifAccessPointNetworkOrigin()
        - .ifAuthType()
        - .ifSignatureAge()
        - .ifSignatureversion()
        - .ifXAmzContentSha256()

        https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListParts.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toListMultipartUploadParts", [])

    @jsii.member(jsii_name="toListRegionalBuckets")
    def to_list_regional_buckets(self) -> "S3Outposts":
        """Grants permission to list all buckets owned by the authenticated sender of the request.

        Access Level: List

        Possible conditions:

        - .ifAuthType()
        - .ifSignatureAge()
        - .ifSignatureversion()
        - .ifXAmzContentSha256()

        https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_ListRegionalBuckets.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toListRegionalBuckets", [])

    @jsii.member(jsii_name="toPutAccessPointPolicy")
    def to_put_access_point_policy(self) -> "S3Outposts":
        """Grants permission to associate an access policy with a specified access point.

        Access Level: Permissions management

        Possible conditions:

        - .ifDataAccessPointAccount()
        - .ifDataAccessPointArn()
        - .ifAccessPointNetworkOrigin()
        - .ifAuthType()
        - .ifSignatureAge()
        - .ifSignatureversion()
        - .ifXAmzContentSha256()

        https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutAccessPointPolicy.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toPutAccessPointPolicy", [])

    @jsii.member(jsii_name="toPutBucketPolicy")
    def to_put_bucket_policy(self) -> "S3Outposts":
        """Grants permission to add or replace a bucket policy on a bucket.

        Access Level: Permissions management

        Possible conditions:

        - .ifAuthType()
        - .ifSignatureAge()
        - .ifSignatureversion()
        - .ifXAmzContentSha256()

        https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutBucketPolicy.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toPutBucketPolicy", [])

    @jsii.member(jsii_name="toPutBucketTagging")
    def to_put_bucket_tagging(self) -> "S3Outposts":
        """Grants permission to add a set of tags to an existing Amazon S3 bucket.

        Access Level: Tagging

        Possible conditions:

        - .ifAuthType()
        - .ifSignatureAge()
        - .ifSignatureversion()
        - .ifXAmzContentSha256()

        https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutBucketTagging.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toPutBucketTagging", [])

    @jsii.member(jsii_name="toPutLifecycleConfiguration")
    def to_put_lifecycle_configuration(self) -> "S3Outposts":
        """Grants permission to create a new lifecycle configuration for the bucket or replace an existing lifecycle configuration.

        Access Level: Write

        Possible conditions:

        - .ifAuthType()
        - .ifSignatureAge()
        - .ifSignatureversion()
        - .ifXAmzContentSha256()

        https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutBucketLifecycleConfiguration.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toPutLifecycleConfiguration", [])

    @jsii.member(jsii_name="toPutObject")
    def to_put_object(self) -> "S3Outposts":
        """Grants permission to add an object to a bucket.

        Access Level: Write

        Possible conditions:

        - .ifDataAccessPointAccount()
        - .ifDataAccessPointArn()
        - .ifAccessPointNetworkOrigin()
        - .ifRequestObjectTag()
        - .ifRequestObjectTagKeys()
        - .ifAuthType()
        - .ifSignatureAge()
        - .ifSignatureversion()
        - .ifXAmzAcl()
        - .ifXAmzContentSha256()
        - .ifXAmzCopySource()
        - .ifXAmzMetadataDirective()
        - .ifXAmzServerSideEncryption()
        - .ifXAmzStorageClass()

        https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutObject.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toPutObject", [])

    @jsii.member(jsii_name="toPutObjectAcl")
    def to_put_object_acl(self) -> "S3Outposts":
        """Grants permission to set the access control list (ACL) permissions for an object that already exists in a bucket.

        Access Level: Permissions management

        Possible conditions:

        - .ifDataAccessPointAccount()
        - .ifDataAccessPointArn()
        - .ifAccessPointNetworkOrigin()
        - .ifExistingObjectTag()
        - .ifAuthType()
        - .ifSignatureAge()
        - .ifSignatureversion()
        - .ifXAmzAcl()
        - .ifXAmzContentSha256()
        - .ifXAmzStorageClass()

        https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutObjectAcl.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toPutObjectAcl", [])

    @jsii.member(jsii_name="toPutObjectTagging")
    def to_put_object_tagging(self) -> "S3Outposts":
        """Grants permission to set the supplied tag-set to an object that already exists in a bucket.

        Access Level: Tagging

        Possible conditions:

        - .ifDataAccessPointAccount()
        - .ifDataAccessPointArn()
        - .ifAccessPointNetworkOrigin()
        - .ifExistingObjectTag()
        - .ifRequestObjectTag()
        - .ifRequestObjectTagKeys()
        - .ifAuthType()
        - .ifSignatureAge()
        - .ifSignatureversion()
        - .ifXAmzContentSha256()

        https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutObjectTagging.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toPutObjectTagging", [])

    @builtins.property # type: ignore
    @jsii.member(jsii_name="accessLevelList")
    def _access_level_list(self) -> "AccessLevelList":
        """
        stability
        :stability: experimental
        """
        return jsii.get(self, "accessLevelList")

    @_access_level_list.setter # type: ignore
    def _access_level_list(self, value: "AccessLevelList") -> None:
        jsii.set(self, "accessLevelList", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="servicePrefix")
    def service_prefix(self) -> builtins.str:
        """Holds the prefix of the service actions, e.g. ``ec2``.

        stability
        :stability: experimental
        """
        return jsii.get(self, "servicePrefix")

    @service_prefix.setter # type: ignore
    def service_prefix(self, value: builtins.str) -> None:
        jsii.set(self, "servicePrefix", value)


class Sagemaker(
    PolicyStatement,
    metaclass=jsii.JSIIMeta,
    jsii_type="iam-floyd.Sagemaker",
):
    """Statement provider for service `sagemaker <https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonsagemaker.html>`_.

    stability
    :stability: experimental
    """

    def __init__(self, sid: typing.Optional[builtins.str] = None) -> None:
        """Statement provider for service `sagemaker <https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonsagemaker.html>`_.

        :param sid: `SID <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html>`_ of the statement.

        stability
        :stability: experimental
        """
        jsii.create(Sagemaker, self, [sid])

    @jsii.member(jsii_name="ifAcceleratorTypes")
    def if_accelerator_types(
        self,
        value: typing.Union[builtins.str, typing.List[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, "Operator"]] = None,
    ) -> "Sagemaker":
        """The list of all accelerator types associated with the resource in the request.

        https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazonsagemaker.html#amazonsagemaker-policy-keys

        Applies to actions:

        - .toCreateEndpointConfig()
        - .toCreateNotebookInstance()
        - .toUpdateNotebookInstance()

        :param value: The value(s) to check.
        :param operator: Works with `string operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String>`_. **Default:** ``StringLike``.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "ifAcceleratorTypes", [value, operator])

    @jsii.member(jsii_name="ifAppNetworkAccessType")
    def if_app_network_access_type(
        self,
        value: typing.Union[builtins.str, typing.List[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, "Operator"]] = None,
    ) -> "Sagemaker":
        """App network access type associated with the resource in the request.

        https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazonsagemaker.html#amazonsagemaker-policy-keys

        Applies to actions:

        - .toCreateDomain()

        :param value: The value(s) to check.
        :param operator: Works with `string operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String>`_. **Default:** ``StringLike``.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "ifAppNetworkAccessType", [value, operator])

    @jsii.member(jsii_name="ifDirectInternetAccess")
    def if_direct_internet_access(
        self,
        value: typing.Union[builtins.str, typing.List[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, "Operator"]] = None,
    ) -> "Sagemaker":
        """The direct internet access associated with the resource in the request.

        https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazonsagemaker.html#amazonsagemaker-policy-keys

        Applies to actions:

        - .toCreateNotebookInstance()

        :param value: The value(s) to check.
        :param operator: Works with `string operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String>`_. **Default:** ``StringLike``.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "ifDirectInternetAccess", [value, operator])

    @jsii.member(jsii_name="ifDomainSharingOutputKmsKey")
    def if_domain_sharing_output_kms_key(
        self,
        value: typing.Union[builtins.str, typing.List[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, "Operator"]] = None,
    ) -> "Sagemaker":
        """The Domain sharing output KMS key associated with the resource in the request.

        https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazonsagemaker.html#amazonsagemaker-policy-keys

        Applies to actions:

        - .toCreateDomain()
        - .toCreateUserProfile()
        - .toUpdateDomain()
        - .toUpdateUserProfile()

        :param value: The value(s) to check.
        :param operator: Works with `arn operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_ARN>`_. **Default:** ``ArnLike``.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "ifDomainSharingOutputKmsKey", [value, operator])

    @jsii.member(jsii_name="ifFileSystemAccessMode")
    def if_file_system_access_mode(
        self,
        value: typing.Union[builtins.str, typing.List[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, "Operator"]] = None,
    ) -> "Sagemaker":
        """File system access mode associated with the resource in the request.

        https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazonsagemaker.html#amazonsagemaker-policy-keys

        Applies to actions:

        - .toCreateHyperParameterTuningJob()
        - .toCreateTrainingJob()

        :param value: The value(s) to check.
        :param operator: Works with `string operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String>`_. **Default:** ``StringLike``.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "ifFileSystemAccessMode", [value, operator])

    @jsii.member(jsii_name="ifFileSystemDirectoryPath")
    def if_file_system_directory_path(
        self,
        value: typing.Union[builtins.str, typing.List[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, "Operator"]] = None,
    ) -> "Sagemaker":
        """File system directory path associated with the resource in the request.

        https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazonsagemaker.html#amazonsagemaker-policy-keys

        Applies to actions:

        - .toCreateHyperParameterTuningJob()
        - .toCreateTrainingJob()

        :param value: The value(s) to check.
        :param operator: Works with `string operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String>`_. **Default:** ``StringLike``.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "ifFileSystemDirectoryPath", [value, operator])

    @jsii.member(jsii_name="ifFileSystemId")
    def if_file_system_id(
        self,
        value: typing.Union[builtins.str, typing.List[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, "Operator"]] = None,
    ) -> "Sagemaker":
        """A file system ID associated with the resource in the request.

        https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazonsagemaker.html#amazonsagemaker-policy-keys

        Applies to actions:

        - .toCreateHyperParameterTuningJob()
        - .toCreateTrainingJob()

        :param value: The value(s) to check.
        :param operator: Works with `string operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String>`_. **Default:** ``StringLike``.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "ifFileSystemId", [value, operator])

    @jsii.member(jsii_name="ifFileSystemType")
    def if_file_system_type(
        self,
        value: typing.Union[builtins.str, typing.List[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, "Operator"]] = None,
    ) -> "Sagemaker":
        """File system type associated with the resource in the request.

        https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazonsagemaker.html#amazonsagemaker-policy-keys

        Applies to actions:

        - .toCreateHyperParameterTuningJob()
        - .toCreateTrainingJob()

        :param value: The value(s) to check.
        :param operator: Works with `string operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String>`_. **Default:** ``StringLike``.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "ifFileSystemType", [value, operator])

    @jsii.member(jsii_name="ifHomeEfsFileSystemKmsKey")
    def if_home_efs_file_system_kms_key(
        self,
        value: typing.Union[builtins.str, typing.List[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, "Operator"]] = None,
    ) -> "Sagemaker":
        """The KMS Key Id of the EFS File System used for UserProfile home directories, which is associated with the resource in the request.

        https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazonsagemaker.html#amazonsagemaker-policy-keys

        Applies to actions:

        - .toCreateDomain()

        :param value: The value(s) to check.
        :param operator: Works with `arn operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_ARN>`_. **Default:** ``ArnLike``.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "ifHomeEfsFileSystemKmsKey", [value, operator])

    @jsii.member(jsii_name="ifImageArns")
    def if_image_arns(
        self,
        value: typing.Union[builtins.str, typing.List[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, "Operator"]] = None,
    ) -> "Sagemaker":
        """Filters access by the list of all image arns associated with the resource in the request.

        https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazonsagemaker.html#amazonsagemaker-policy-keys

        Applies to actions:

        - .toCreateApp()
        - .toCreateDomain()
        - .toCreateUserProfile()
        - .toUpdateDomain()
        - .toUpdateUserProfile()

        :param value: The value(s) to check.
        :param operator: Works with `string operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String>`_. **Default:** ``StringLike``.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "ifImageArns", [value, operator])

    @jsii.member(jsii_name="ifImageVersionArns")
    def if_image_version_arns(
        self,
        value: typing.Union[builtins.str, typing.List[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, "Operator"]] = None,
    ) -> "Sagemaker":
        """Filters access by the list of all image version arns associated with the resource in the request.

        https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazonsagemaker.html#amazonsagemaker-policy-keys

        Applies to actions:

        - .toCreateApp()
        - .toCreateDomain()
        - .toCreateUserProfile()
        - .toUpdateDomain()
        - .toUpdateUserProfile()

        :param value: The value(s) to check.
        :param operator: Works with `string operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String>`_. **Default:** ``StringLike``.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "ifImageVersionArns", [value, operator])

    @jsii.member(jsii_name="ifInstanceTypes")
    def if_instance_types(
        self,
        value: typing.Union[builtins.str, typing.List[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, "Operator"]] = None,
    ) -> "Sagemaker":
        """The list of all instance types associated with the resource in the request.

        https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazonsagemaker.html#amazonsagemaker-policy-keys

        Applies to actions:

        - .toCreateApp()
        - .toCreateDomain()
        - .toCreateEndpointConfig()
        - .toCreateHyperParameterTuningJob()
        - .toCreateMonitoringSchedule()
        - .toCreateNotebookInstance()
        - .toCreateProcessingJob()
        - .toCreateTrainingJob()
        - .toCreateTransformJob()
        - .toCreateUserProfile()
        - .toUpdateDomain()
        - .toUpdateMonitoringSchedule()
        - .toUpdateNotebookInstance()
        - .toUpdateUserProfile()

        :param value: The value(s) to check.
        :param operator: Works with `string operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String>`_. **Default:** ``StringLike``.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "ifInstanceTypes", [value, operator])

    @jsii.member(jsii_name="ifInterContainerTrafficEncryption")
    def if_inter_container_traffic_encryption(
        self,
        value: typing.Optional[builtins.bool] = None,
    ) -> "Sagemaker":
        """The inter container traffic encryption associated with the resource in the request.

        https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazonsagemaker.html#amazonsagemaker-policy-keys

        Applies to actions:

        - .toCreateAutoMLJob()
        - .toCreateHyperParameterTuningJob()
        - .toCreateProcessingJob()
        - .toCreateTrainingJob()

        :param value: ``true`` or ``false``. **Default:** ``true``

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "ifInterContainerTrafficEncryption", [value])

    @jsii.member(jsii_name="ifMaxRuntimeInSeconds")
    def if_max_runtime_in_seconds(
        self,
        value: typing.Union[jsii.Number, typing.List[jsii.Number]],
        operator: typing.Optional[typing.Union[builtins.str, "Operator"]] = None,
    ) -> "Sagemaker":
        """The max runtime in seconds associated with the resource in the request.

        https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazonsagemaker.html#amazonsagemaker-policy-keys

        Applies to actions:

        - .toCreateHyperParameterTuningJob()
        - .toCreateMonitoringSchedule()
        - .toCreateProcessingJob()
        - .toCreateTrainingJob()
        - .toUpdateMonitoringSchedule()

        :param value: The value(s) to check.
        :param operator: Works with `numeric operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_Numeric>`_. **Default:** ``NumericEquals``.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "ifMaxRuntimeInSeconds", [value, operator])

    @jsii.member(jsii_name="ifModelArn")
    def if_model_arn(
        self,
        value: typing.Union[builtins.str, typing.List[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, "Operator"]] = None,
    ) -> "Sagemaker":
        """The model arn associated with the resource in the request.

        https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazonsagemaker.html#amazonsagemaker-policy-keys

        Applies to actions:

        - .toCreateEndpointConfig()
        - .toCreateTransformJob()

        :param value: The value(s) to check.
        :param operator: Works with `arn operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_ARN>`_. **Default:** ``ArnLike``.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "ifModelArn", [value, operator])

    @jsii.member(jsii_name="ifNetworkIsolation")
    def if_network_isolation(
        self,
        value: typing.Optional[builtins.bool] = None,
    ) -> "Sagemaker":
        """The network isolation associated with the resource in the request.

        https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazonsagemaker.html#amazonsagemaker-policy-keys

        Applies to actions:

        - .toCreateHyperParameterTuningJob()
        - .toCreateModel()
        - .toCreateMonitoringSchedule()
        - .toCreateProcessingJob()
        - .toCreateTrainingJob()
        - .toUpdateMonitoringSchedule()

        :param value: ``true`` or ``false``. **Default:** ``true``

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "ifNetworkIsolation", [value])

    @jsii.member(jsii_name="ifOutputKmsKey")
    def if_output_kms_key(
        self,
        value: typing.Union[builtins.str, typing.List[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, "Operator"]] = None,
    ) -> "Sagemaker":
        """The output kms key associated with the resource in the request.

        https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazonsagemaker.html#amazonsagemaker-policy-keys

        Applies to actions:

        - .toCreateAutoMLJob()
        - .toCreateHyperParameterTuningJob()
        - .toCreateLabelingJob()
        - .toCreateMonitoringSchedule()
        - .toCreateProcessingJob()
        - .toCreateTrainingJob()
        - .toCreateTransformJob()
        - .toUpdateMonitoringSchedule()

        :param value: The value(s) to check.
        :param operator: Works with `arn operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_ARN>`_. **Default:** ``ArnLike``.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "ifOutputKmsKey", [value, operator])

    @jsii.member(jsii_name="ifResourceTag")
    def if_resource_tag(
        self,
        tag_key: builtins.str,
        value: typing.Union[builtins.str, typing.List[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, "Operator"]] = None,
    ) -> "Sagemaker":
        """A tag key and value pair.

        https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazonsagemaker.html#amazonsagemaker-policy-keys

        Applies to resource types:

        - flow-definition
        - human-task-ui
        - labeling-job
        - workteam
        - workforce
        - domain
        - user-profile
        - app
        - app-image-config
        - notebook-instance
        - image
        - training-job
        - processing-job
        - hyper-parameter-tuning-job
        - model
        - endpoint-config
        - endpoint
        - transform-job
        - automl-job
        - monitoring-schedule
        - experiment
        - experiment-trial
        - experiment-trial-component

        :param tag_key: The tag key to check.
        :param value: The value(s) to check.
        :param operator: Works with `string operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String>`_. **Default:** ``StringLike``.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "ifResourceTag", [tag_key, value, operator])

    @jsii.member(jsii_name="ifResourceTagExists")
    def if_resource_tag_exists(
        self,
        value: typing.Union[builtins.str, typing.List[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, "Operator"]] = None,
    ) -> "Sagemaker":
        """The preface string for a tag key and value pair attached to a resource.

        https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazonsagemaker.html#amazonsagemaker-policy-keys

        :param value: The value(s) to check.
        :param operator: Works with `string operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String>`_. **Default:** ``StringLike``.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "ifResourceTagExists", [value, operator])

    @jsii.member(jsii_name="ifRootAccess")
    def if_root_access(
        self,
        value: typing.Union[builtins.str, typing.List[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, "Operator"]] = None,
    ) -> "Sagemaker":
        """The root access associated with the resource in the request.

        https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazonsagemaker.html#amazonsagemaker-policy-keys

        Applies to actions:

        - .toCreateNotebookInstance()
        - .toUpdateNotebookInstance()

        :param value: The value(s) to check.
        :param operator: Works with `string operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String>`_. **Default:** ``StringLike``.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "ifRootAccess", [value, operator])

    @jsii.member(jsii_name="ifTargetModel")
    def if_target_model(
        self,
        value: typing.Union[builtins.str, typing.List[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, "Operator"]] = None,
    ) -> "Sagemaker":
        """The target model associated with the Multi-Model Endpoint in the request.

        https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazonsagemaker.html#amazonsagemaker-policy-keys

        Applies to actions:

        - .toInvokeEndpoint()

        :param value: The value(s) to check.
        :param operator: Works with `string operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String>`_. **Default:** ``StringLike``.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "ifTargetModel", [value, operator])

    @jsii.member(jsii_name="ifVolumeKmsKey")
    def if_volume_kms_key(
        self,
        value: typing.Union[builtins.str, typing.List[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, "Operator"]] = None,
    ) -> "Sagemaker":
        """The volume kms key associated with the resource in the request.

        https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazonsagemaker.html#amazonsagemaker-policy-keys

        Applies to actions:

        - .toCreateAutoMLJob()
        - .toCreateEndpointConfig()
        - .toCreateHyperParameterTuningJob()
        - .toCreateLabelingJob()
        - .toCreateMonitoringSchedule()
        - .toCreateNotebookInstance()
        - .toCreateProcessingJob()
        - .toCreateTrainingJob()
        - .toCreateTransformJob()
        - .toUpdateMonitoringSchedule()

        :param value: The value(s) to check.
        :param operator: Works with `arn operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_ARN>`_. **Default:** ``ArnLike``.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "ifVolumeKmsKey", [value, operator])

    @jsii.member(jsii_name="ifVpcSecurityGroupIds")
    def if_vpc_security_group_ids(
        self,
        value: typing.Union[builtins.str, typing.List[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, "Operator"]] = None,
    ) -> "Sagemaker":
        """The list of all vpc security group ids associated with the resource in the request.

        https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazonsagemaker.html#amazonsagemaker-policy-keys

        Applies to actions:

        - .toCreateAutoMLJob()
        - .toCreateDomain()
        - .toCreateHyperParameterTuningJob()
        - .toCreateModel()
        - .toCreateMonitoringSchedule()
        - .toCreateNotebookInstance()
        - .toCreateProcessingJob()
        - .toCreateTrainingJob()
        - .toCreateUserProfile()
        - .toUpdateDomain()
        - .toUpdateMonitoringSchedule()
        - .toUpdateUserProfile()

        :param value: The value(s) to check.
        :param operator: Works with `string operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String>`_. **Default:** ``StringLike``.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "ifVpcSecurityGroupIds", [value, operator])

    @jsii.member(jsii_name="ifVpcSubnets")
    def if_vpc_subnets(
        self,
        value: typing.Union[builtins.str, typing.List[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, "Operator"]] = None,
    ) -> "Sagemaker":
        """The list of all vpc subnets associated with the resource in the request.

        https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazonsagemaker.html#amazonsagemaker-policy-keys

        Applies to actions:

        - .toCreateAutoMLJob()
        - .toCreateDomain()
        - .toCreateHyperParameterTuningJob()
        - .toCreateModel()
        - .toCreateMonitoringSchedule()
        - .toCreateNotebookInstance()
        - .toCreateProcessingJob()
        - .toCreateTrainingJob()
        - .toUpdateMonitoringSchedule()

        :param value: The value(s) to check.
        :param operator: Works with `string operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String>`_. **Default:** ``StringLike``.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "ifVpcSubnets", [value, operator])

    @jsii.member(jsii_name="ifWorkteamArn")
    def if_workteam_arn(
        self,
        value: typing.Union[builtins.str, typing.List[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, "Operator"]] = None,
    ) -> "Sagemaker":
        """The workteam arn associated to the request.

        https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazonsagemaker.html#amazonsagemaker-policy-keys

        Applies to actions:

        - .toCreateFlowDefinition()
        - .toCreateLabelingJob()

        :param value: The value(s) to check.
        :param operator: Works with `arn operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_ARN>`_. **Default:** ``ArnLike``.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "ifWorkteamArn", [value, operator])

    @jsii.member(jsii_name="ifWorkteamType")
    def if_workteam_type(
        self,
        value: typing.Union[builtins.str, typing.List[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, "Operator"]] = None,
    ) -> "Sagemaker":
        """The workteam type associated to the request. This can be public-crowd, private-crowd or vendor-crowd.

        https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazonsagemaker.html#amazonsagemaker-policy-keys

        Applies to actions:

        - .toCreateFlowDefinition()
        - .toCreateLabelingJob()

        :param value: The value(s) to check.
        :param operator: Works with `string operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String>`_. **Default:** ``StringLike``.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "ifWorkteamType", [value, operator])

    @jsii.member(jsii_name="onAlgorithm")
    def on_algorithm(
        self,
        algorithm_name: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Sagemaker":
        """Adds a resource of type algorithm to the statement.

        :param algorithm_name: - Identifier for the algorithmName.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "onAlgorithm", [algorithm_name, account, region, partition])

    @jsii.member(jsii_name="onApp")
    def on_app(
        self,
        domain_id: builtins.str,
        user_profile_name: builtins.str,
        app_type: builtins.str,
        app_name: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Sagemaker":
        """Adds a resource of type app to the statement.

        :param domain_id: - Identifier for the domainId.
        :param user_profile_name: - Identifier for the userProfileName.
        :param app_type: - Identifier for the appType.
        :param app_name: - Identifier for the appName.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``. Possible conditions: - .ifAwsResourceTag() - .ifResourceTag()

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "onApp", [domain_id, user_profile_name, app_type, app_name, account, region, partition])

    @jsii.member(jsii_name="onAppImageConfig")
    def on_app_image_config(
        self,
        app_image_config_name: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Sagemaker":
        """Adds a resource of type app-image-config to the statement.

        :param app_image_config_name: - Identifier for the appImageConfigName.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``. Possible conditions: - .ifAwsResourceTag() - .ifResourceTag()

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "onAppImageConfig", [app_image_config_name, account, region, partition])

    @jsii.member(jsii_name="onAutomlJob")
    def on_automl_job(
        self,
        auto_ml_job_job_name: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Sagemaker":
        """Adds a resource of type automl-job to the statement.

        :param auto_ml_job_job_name: - Identifier for the autoMLJobJobName.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``. Possible conditions: - .ifAwsResourceTag() - .ifResourceTag()

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "onAutomlJob", [auto_ml_job_job_name, account, region, partition])

    @jsii.member(jsii_name="onCodeRepository")
    def on_code_repository(
        self,
        code_repository_name: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Sagemaker":
        """Adds a resource of type code-repository to the statement.

        :param code_repository_name: - Identifier for the codeRepositoryName.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "onCodeRepository", [code_repository_name, account, region, partition])

    @jsii.member(jsii_name="onCompilationJob")
    def on_compilation_job(
        self,
        compilation_job_name: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Sagemaker":
        """Adds a resource of type compilation-job to the statement.

        :param compilation_job_name: - Identifier for the compilationJobName.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "onCompilationJob", [compilation_job_name, account, region, partition])

    @jsii.member(jsii_name="onDomain")
    def on_domain(
        self,
        domain_id: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Sagemaker":
        """Adds a resource of type domain to the statement.

        :param domain_id: - Identifier for the domainId.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``. Possible conditions: - .ifAwsResourceTag() - .ifResourceTag()

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "onDomain", [domain_id, account, region, partition])

    @jsii.member(jsii_name="onEndpoint")
    def on_endpoint(
        self,
        endpoint_name: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Sagemaker":
        """Adds a resource of type endpoint to the statement.

        :param endpoint_name: - Identifier for the endpointName.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``. Possible conditions: - .ifAwsResourceTag() - .ifResourceTag()

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "onEndpoint", [endpoint_name, account, region, partition])

    @jsii.member(jsii_name="onEndpointConfig")
    def on_endpoint_config(
        self,
        endpoint_config_name: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Sagemaker":
        """Adds a resource of type endpoint-config to the statement.

        :param endpoint_config_name: - Identifier for the endpointConfigName.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``. Possible conditions: - .ifAwsResourceTag() - .ifResourceTag()

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "onEndpointConfig", [endpoint_config_name, account, region, partition])

    @jsii.member(jsii_name="onExperiment")
    def on_experiment(
        self,
        experiment_name: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Sagemaker":
        """Adds a resource of type experiment to the statement.

        :param experiment_name: - Identifier for the experimentName.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``. Possible conditions: - .ifAwsResourceTag() - .ifResourceTag()

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "onExperiment", [experiment_name, account, region, partition])

    @jsii.member(jsii_name="onExperimentTrial")
    def on_experiment_trial(
        self,
        trial_name: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Sagemaker":
        """Adds a resource of type experiment-trial to the statement.

        :param trial_name: - Identifier for the trialName.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``. Possible conditions: - .ifAwsResourceTag() - .ifResourceTag()

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "onExperimentTrial", [trial_name, account, region, partition])

    @jsii.member(jsii_name="onExperimentTrialComponent")
    def on_experiment_trial_component(
        self,
        trial_component_name: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Sagemaker":
        """Adds a resource of type experiment-trial-component to the statement.

        :param trial_component_name: - Identifier for the trialComponentName.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``. Possible conditions: - .ifAwsResourceTag() - .ifResourceTag()

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "onExperimentTrialComponent", [trial_component_name, account, region, partition])

    @jsii.member(jsii_name="onFlowDefinition")
    def on_flow_definition(
        self,
        flow_definition_name: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Sagemaker":
        """Adds a resource of type flow-definition to the statement.

        :param flow_definition_name: - Identifier for the flowDefinitionName.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``. Possible conditions: - .ifAwsResourceTag() - .ifResourceTag()

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "onFlowDefinition", [flow_definition_name, account, region, partition])

    @jsii.member(jsii_name="onHumanLoop")
    def on_human_loop(
        self,
        human_loop_name: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Sagemaker":
        """Adds a resource of type human-loop to the statement.

        :param human_loop_name: - Identifier for the humanLoopName.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "onHumanLoop", [human_loop_name, account, region, partition])

    @jsii.member(jsii_name="onHumanTaskUi")
    def on_human_task_ui(
        self,
        human_task_ui_name: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Sagemaker":
        """Adds a resource of type human-task-ui to the statement.

        :param human_task_ui_name: - Identifier for the humanTaskUiName.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``. Possible conditions: - .ifAwsResourceTag() - .ifResourceTag()

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "onHumanTaskUi", [human_task_ui_name, account, region, partition])

    @jsii.member(jsii_name="onHyperParameterTuningJob")
    def on_hyper_parameter_tuning_job(
        self,
        hyper_parameter_tuning_job_name: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Sagemaker":
        """Adds a resource of type hyper-parameter-tuning-job to the statement.

        :param hyper_parameter_tuning_job_name: - Identifier for the hyperParameterTuningJobName.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``. Possible conditions: - .ifAwsResourceTag() - .ifResourceTag()

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "onHyperParameterTuningJob", [hyper_parameter_tuning_job_name, account, region, partition])

    @jsii.member(jsii_name="onImage")
    def on_image(
        self,
        image_name: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Sagemaker":
        """Adds a resource of type image to the statement.

        :param image_name: - Identifier for the imageName.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``. Possible conditions: - .ifAwsResourceTag() - .ifResourceTag()

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "onImage", [image_name, account, region, partition])

    @jsii.member(jsii_name="onImageVersion")
    def on_image_version(
        self,
        image_name: builtins.str,
        version: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Sagemaker":
        """Adds a resource of type image-version to the statement.

        :param image_name: - Identifier for the imageName.
        :param version: - Identifier for the version.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "onImageVersion", [image_name, version, account, region, partition])

    @jsii.member(jsii_name="onLabelingJob")
    def on_labeling_job(
        self,
        labeling_job_name: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Sagemaker":
        """Adds a resource of type labeling-job to the statement.

        :param labeling_job_name: - Identifier for the labelingJobName.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``. Possible conditions: - .ifAwsResourceTag() - .ifResourceTag()

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "onLabelingJob", [labeling_job_name, account, region, partition])

    @jsii.member(jsii_name="onModel")
    def on_model(
        self,
        model_name: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Sagemaker":
        """Adds a resource of type model to the statement.

        :param model_name: - Identifier for the modelName.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``. Possible conditions: - .ifAwsResourceTag() - .ifResourceTag()

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "onModel", [model_name, account, region, partition])

    @jsii.member(jsii_name="onModelPackage")
    def on_model_package(
        self,
        model_package_name: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Sagemaker":
        """Adds a resource of type model-package to the statement.

        :param model_package_name: - Identifier for the modelPackageName.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "onModelPackage", [model_package_name, account, region, partition])

    @jsii.member(jsii_name="onMonitoringSchedule")
    def on_monitoring_schedule(
        self,
        monitoring_schedule_name: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Sagemaker":
        """Adds a resource of type monitoring-schedule to the statement.

        :param monitoring_schedule_name: - Identifier for the monitoringScheduleName.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``. Possible conditions: - .ifAwsResourceTag() - .ifResourceTag()

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "onMonitoringSchedule", [monitoring_schedule_name, account, region, partition])

    @jsii.member(jsii_name="onNotebookInstance")
    def on_notebook_instance(
        self,
        notebook_instance_name: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Sagemaker":
        """Adds a resource of type notebook-instance to the statement.

        :param notebook_instance_name: - Identifier for the notebookInstanceName.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``. Possible conditions: - .ifAwsResourceTag() - .ifResourceTag()

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "onNotebookInstance", [notebook_instance_name, account, region, partition])

    @jsii.member(jsii_name="onNotebookInstanceLifecycleConfig")
    def on_notebook_instance_lifecycle_config(
        self,
        notebook_instance_lifecycle_config_name: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Sagemaker":
        """Adds a resource of type notebook-instance-lifecycle-config to the statement.

        :param notebook_instance_lifecycle_config_name: - Identifier for the notebookInstanceLifecycleConfigName.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "onNotebookInstanceLifecycleConfig", [notebook_instance_lifecycle_config_name, account, region, partition])

    @jsii.member(jsii_name="onProcessingJob")
    def on_processing_job(
        self,
        processing_job_name: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Sagemaker":
        """Adds a resource of type processing-job to the statement.

        :param processing_job_name: - Identifier for the processingJobName.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``. Possible conditions: - .ifAwsResourceTag() - .ifResourceTag()

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "onProcessingJob", [processing_job_name, account, region, partition])

    @jsii.member(jsii_name="onTrainingJob")
    def on_training_job(
        self,
        training_job_name: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Sagemaker":
        """Adds a resource of type training-job to the statement.

        :param training_job_name: - Identifier for the trainingJobName.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``. Possible conditions: - .ifAwsResourceTag() - .ifResourceTag()

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "onTrainingJob", [training_job_name, account, region, partition])

    @jsii.member(jsii_name="onTransformJob")
    def on_transform_job(
        self,
        transform_job_name: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Sagemaker":
        """Adds a resource of type transform-job to the statement.

        :param transform_job_name: - Identifier for the transformJobName.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``. Possible conditions: - .ifAwsResourceTag() - .ifResourceTag()

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "onTransformJob", [transform_job_name, account, region, partition])

    @jsii.member(jsii_name="onUserProfile")
    def on_user_profile(
        self,
        domain_id: builtins.str,
        user_profile_name: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Sagemaker":
        """Adds a resource of type user-profile to the statement.

        :param domain_id: - Identifier for the domainId.
        :param user_profile_name: - Identifier for the userProfileName.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``. Possible conditions: - .ifAwsResourceTag() - .ifResourceTag()

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "onUserProfile", [domain_id, user_profile_name, account, region, partition])

    @jsii.member(jsii_name="onWorkforce")
    def on_workforce(
        self,
        workforce_name: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Sagemaker":
        """Adds a resource of type workforce to the statement.

        :param workforce_name: - Identifier for the workforceName.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``. Possible conditions: - .ifAwsResourceTag() - .ifResourceTag()

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "onWorkforce", [workforce_name, account, region, partition])

    @jsii.member(jsii_name="onWorkteam")
    def on_workteam(
        self,
        workteam_name: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Sagemaker":
        """Adds a resource of type workteam to the statement.

        :param workteam_name: - Identifier for the workteamName.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``. Possible conditions: - .ifAwsResourceTag() - .ifResourceTag()

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "onWorkteam", [workteam_name, account, region, partition])

    @jsii.member(jsii_name="toAddTags")
    def to_add_tags(self) -> "Sagemaker":
        """Adds or overwrites one or more tags for the specified Amazon SageMaker resource.

        Access Level: Tagging

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsTagKeys()

        https://docs.aws.amazon.com/sagemaker/latest/dg/API_AddTags.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toAddTags", [])

    @jsii.member(jsii_name="toAssociateTrialComponent")
    def to_associate_trial_component(self) -> "Sagemaker":
        """Associate a trial component with a trial.

        Access Level: Write

        https://docs.aws.amazon.com/sagemaker/latest/dg/API_AssociateTrialComponent.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toAssociateTrialComponent", [])

    @jsii.member(jsii_name="toBatchGetMetrics")
    def to_batch_get_metrics(self) -> "Sagemaker":
        """Retrieve metrics associated with SageMaker Resources such as Training Jobs.

        This API is not publicly exposed at this point, however admins can control this action

        Access Level: Read

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toBatchGetMetrics", [])

    @jsii.member(jsii_name="toBatchPutMetrics")
    def to_batch_put_metrics(self) -> "Sagemaker":
        """Publish metrics associated with a SageMaker Resource such as a Training Job.

        This API is not publicly exposed at this point, however admins can control this action

        Access Level: Write

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toBatchPutMetrics", [])

    @jsii.member(jsii_name="toCreateAlgorithm")
    def to_create_algorithm(self) -> "Sagemaker":
        """Create an algorithm.

        Access Level: Write

        https://docs.aws.amazon.com/sagemaker/latest/dg/API_CreateAlgorithm.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toCreateAlgorithm", [])

    @jsii.member(jsii_name="toCreateApp")
    def to_create_app(self) -> "Sagemaker":
        """Grants permission to create an App for a SageMaker Studio UserProfile.

        Access Level: Write

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsTagKeys()
        - .ifInstanceTypes()
        - .ifImageArns()
        - .ifImageVersionArns()

        https://docs.aws.amazon.com/sagemaker/latest/dg/API_CreateApp.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toCreateApp", [])

    @jsii.member(jsii_name="toCreateAppImageConfig")
    def to_create_app_image_config(self) -> "Sagemaker":
        """Grants permission to create an AppImageConfig.

        Access Level: Write

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsTagKeys()

        https://docs.aws.amazon.com/sagemaker/latest/dg/API_CreateAppImageConfig.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toCreateAppImageConfig", [])

    @jsii.member(jsii_name="toCreateAutoMLJob")
    def to_create_auto_ml_job(self) -> "Sagemaker":
        """Creates automl job.

        Access Level: Write

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsTagKeys()
        - .ifInterContainerTrafficEncryption()
        - .ifOutputKmsKey()
        - .ifVolumeKmsKey()
        - .ifVpcSecurityGroupIds()
        - .ifVpcSubnets()

        Dependent actions:

        - iam:PassRole

        https://docs.aws.amazon.com/sagemaker/latest/dg/API_CreateAutoMLJob.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toCreateAutoMLJob", [])

    @jsii.member(jsii_name="toCreateCodeRepository")
    def to_create_code_repository(self) -> "Sagemaker":
        """Create a code repository.

        Access Level: Write

        https://docs.aws.amazon.com/sagemaker/latest/dg/API_CreateCodeRepository.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toCreateCodeRepository", [])

    @jsii.member(jsii_name="toCreateCompilationJob")
    def to_create_compilation_job(self) -> "Sagemaker":
        """Create a compilation job.

        Access Level: Write

        Dependent actions:

        - iam:PassRole

        https://docs.aws.amazon.com/sagemaker/latest/dg/API_CreateCompilationJob.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toCreateCompilationJob", [])

    @jsii.member(jsii_name="toCreateDomain")
    def to_create_domain(self) -> "Sagemaker":
        """Grants permission to create a Domain for SageMaker Studio.

        Access Level: Write

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsTagKeys()
        - .ifAppNetworkAccessType()
        - .ifInstanceTypes()
        - .ifVpcSecurityGroupIds()
        - .ifVpcSubnets()
        - .ifDomainSharingOutputKmsKey()
        - .ifHomeEfsFileSystemKmsKey()
        - .ifImageArns()
        - .ifImageVersionArns()

        Dependent actions:

        - iam:CreateServiceLinkedRole
        - iam:PassRole

        https://docs.aws.amazon.com/sagemaker/latest/dg/API_CreateDomain.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toCreateDomain", [])

    @jsii.member(jsii_name="toCreateEndpoint")
    def to_create_endpoint(self) -> "Sagemaker":
        """Creates an endpoint using the endpoint configuration specified in the request.

        Access Level: Write

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsTagKeys()

        https://docs.aws.amazon.com/sagemaker/latest/dg/API_CreateEndpoint.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toCreateEndpoint", [])

    @jsii.member(jsii_name="toCreateEndpointConfig")
    def to_create_endpoint_config(self) -> "Sagemaker":
        """Creates an endpoint configuration that can be deployed using Amazon SageMaker hosting services.

        Access Level: Write

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsTagKeys()
        - .ifAcceleratorTypes()
        - .ifInstanceTypes()
        - .ifModelArn()
        - .ifVolumeKmsKey()

        https://docs.aws.amazon.com/sagemaker/latest/dg/API_CreateEndpointConfig.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toCreateEndpointConfig", [])

    @jsii.member(jsii_name="toCreateExperiment")
    def to_create_experiment(self) -> "Sagemaker":
        """Create an experiment.

        Access Level: Write

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsTagKeys()

        https://docs.aws.amazon.com/sagemaker/latest/dg/API_CreateExperiment.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toCreateExperiment", [])

    @jsii.member(jsii_name="toCreateFlowDefinition")
    def to_create_flow_definition(self) -> "Sagemaker":
        """Creates a flow definition, which defines settings for a human workflow.

        Access Level: Write

        Possible conditions:

        - .ifWorkteamArn()
        - .ifWorkteamType()
        - .ifAwsRequestTag()
        - .ifAwsTagKeys()

        Dependent actions:

        - iam:PassRole

        https://docs.aws.amazon.com/sagemaker/latest/dg/API_CreateFlowDefinition.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toCreateFlowDefinition", [])

    @jsii.member(jsii_name="toCreateHumanTaskUi")
    def to_create_human_task_ui(self) -> "Sagemaker":
        """Defines the settings you will use for the human review workflow user interface.

        Access Level: Write

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsTagKeys()

        https://docs.aws.amazon.com/sagemaker/latest/dg/API_CreateHumanTaskUi.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toCreateHumanTaskUi", [])

    @jsii.member(jsii_name="toCreateHyperParameterTuningJob")
    def to_create_hyper_parameter_tuning_job(self) -> "Sagemaker":
        """Creates hyper parameter tuning job that can be deployed using Amazon SageMaker.

        Access Level: Write

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsTagKeys()
        - .ifFileSystemAccessMode()
        - .ifFileSystemDirectoryPath()
        - .ifFileSystemId()
        - .ifFileSystemType()
        - .ifInstanceTypes()
        - .ifInterContainerTrafficEncryption()
        - .ifMaxRuntimeInSeconds()
        - .ifNetworkIsolation()
        - .ifOutputKmsKey()
        - .ifVolumeKmsKey()
        - .ifVpcSecurityGroupIds()
        - .ifVpcSubnets()

        Dependent actions:

        - iam:PassRole

        https://docs.aws.amazon.com/sagemaker/latest/dg/API_CreateHyperParameterTuningJob.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toCreateHyperParameterTuningJob", [])

    @jsii.member(jsii_name="toCreateImage")
    def to_create_image(self) -> "Sagemaker":
        """Grants permissions to create a SageMaker Image.

        Access Level: Write

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsTagKeys()

        Dependent actions:

        - iam:PassRole

        https://docs.aws.amazon.com/sagemaker/latest/dg/API_CreateImage.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toCreateImage", [])

    @jsii.member(jsii_name="toCreateImageVersion")
    def to_create_image_version(self) -> "Sagemaker":
        """Grants permissions to create a SageMaker ImageVersion.

        Access Level: Write

        https://docs.aws.amazon.com/sagemaker/latest/dg/API_CreateImageVersion.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toCreateImageVersion", [])

    @jsii.member(jsii_name="toCreateLabelingJob")
    def to_create_labeling_job(self) -> "Sagemaker":
        """Starts a labeling job.

        A labeling job takes unlabeled data in and produces labeled data as output, which can be used for training SageMaker models.

        Access Level: Write

        Possible conditions:

        - .ifWorkteamArn()
        - .ifWorkteamType()
        - .ifVolumeKmsKey()
        - .ifOutputKmsKey()
        - .ifAwsRequestTag()
        - .ifAwsTagKeys()

        Dependent actions:

        - iam:PassRole

        https://docs.aws.amazon.com/sagemaker/latest/dg/API_CreateLabelingJob.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toCreateLabelingJob", [])

    @jsii.member(jsii_name="toCreateModel")
    def to_create_model(self) -> "Sagemaker":
        """Creates a model in Amazon SageMaker.

        In the request, you specify a name for the model and describe one or more containers.

        Access Level: Write

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsTagKeys()
        - .ifNetworkIsolation()
        - .ifVpcSecurityGroupIds()
        - .ifVpcSubnets()

        Dependent actions:

        - iam:PassRole

        https://docs.aws.amazon.com/sagemaker/latest/dg/API_CreateModel.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toCreateModel", [])

    @jsii.member(jsii_name="toCreateModelPackage")
    def to_create_model_package(self) -> "Sagemaker":
        """Create a model package.

        Access Level: Write

        https://docs.aws.amazon.com/sagemaker/latest/dg/API_CreateModelPackage.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toCreateModelPackage", [])

    @jsii.member(jsii_name="toCreateMonitoringSchedule")
    def to_create_monitoring_schedule(self) -> "Sagemaker":
        """Creates a monitoring schedule.

        Access Level: Write

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsTagKeys()
        - .ifInstanceTypes()
        - .ifMaxRuntimeInSeconds()
        - .ifNetworkIsolation()
        - .ifOutputKmsKey()
        - .ifVolumeKmsKey()
        - .ifVpcSecurityGroupIds()
        - .ifVpcSubnets()

        Dependent actions:

        - iam:PassRole

        https://docs.aws.amazon.com/sagemaker/latest/dg/API_CreateMonitoringSchedule.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toCreateMonitoringSchedule", [])

    @jsii.member(jsii_name="toCreateNotebookInstance")
    def to_create_notebook_instance(self) -> "Sagemaker":
        """Creates an Amazon SageMaker notebook instance. A notebook instance is an Amazon EC2 instance running on a Jupyter Notebook.

        Access Level: Write

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsTagKeys()
        - .ifAcceleratorTypes()
        - .ifDirectInternetAccess()
        - .ifInstanceTypes()
        - .ifRootAccess()
        - .ifVolumeKmsKey()
        - .ifVpcSecurityGroupIds()
        - .ifVpcSubnets()

        Dependent actions:

        - iam:PassRole

        https://docs.aws.amazon.com/sagemaker/latest/dg/API_CreateNotebookInstance.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toCreateNotebookInstance", [])

    @jsii.member(jsii_name="toCreateNotebookInstanceLifecycleConfig")
    def to_create_notebook_instance_lifecycle_config(self) -> "Sagemaker":
        """Creates an notebook instance lifecycle configuration that can be deployed using Amazon SageMaker.

        Access Level: Write

        https://docs.aws.amazon.com/sagemaker/latest/dg/API_CreateNotebookInstanceLifecycleConfig.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toCreateNotebookInstanceLifecycleConfig", [])

    @jsii.member(jsii_name="toCreatePresignedDomainUrl")
    def to_create_presigned_domain_url(self) -> "Sagemaker":
        """Grants permission to return a URL that you can use from your browser to connect to the Domain as a specified UserProfile when AuthMode is 'IAM'.

        Access Level: Write

        https://docs.aws.amazon.com/sagemaker/latest/dg/API_CreatePresignedDomainUrl.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toCreatePresignedDomainUrl", [])

    @jsii.member(jsii_name="toCreatePresignedNotebookInstanceUrl")
    def to_create_presigned_notebook_instance_url(self) -> "Sagemaker":
        """Returns a URL that you can use from your browser to connect to the Notebook Instance.

        Access Level: Write

        https://docs.aws.amazon.com/sagemaker/latest/dg/API_CreatePresignedNotebookInstanceUrl.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toCreatePresignedNotebookInstanceUrl", [])

    @jsii.member(jsii_name="toCreateProcessingJob")
    def to_create_processing_job(self) -> "Sagemaker":
        """Starts a processing job.

        After processing completes, Amazon SageMaker saves the resulting artifacts and other optional output to an Amazon S3 location that you specify.

        Access Level: Write

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsTagKeys()
        - .ifInstanceTypes()
        - .ifMaxRuntimeInSeconds()
        - .ifNetworkIsolation()
        - .ifOutputKmsKey()
        - .ifVolumeKmsKey()
        - .ifVpcSecurityGroupIds()
        - .ifVpcSubnets()
        - .ifInterContainerTrafficEncryption()

        Dependent actions:

        - iam:PassRole

        https://docs.aws.amazon.com/sagemaker/latest/dg/API_CreateProcessingJob.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toCreateProcessingJob", [])

    @jsii.member(jsii_name="toCreateTrainingJob")
    def to_create_training_job(self) -> "Sagemaker":
        """Starts a model training job.

        After training completes, Amazon SageMaker saves the resulting model artifacts and other optional output to an Amazon S3 location that you specify.

        Access Level: Write

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsTagKeys()
        - .ifFileSystemAccessMode()
        - .ifFileSystemDirectoryPath()
        - .ifFileSystemId()
        - .ifFileSystemType()
        - .ifInstanceTypes()
        - .ifInterContainerTrafficEncryption()
        - .ifMaxRuntimeInSeconds()
        - .ifNetworkIsolation()
        - .ifOutputKmsKey()
        - .ifVolumeKmsKey()
        - .ifVpcSecurityGroupIds()
        - .ifVpcSubnets()

        Dependent actions:

        - iam:PassRole

        https://docs.aws.amazon.com/sagemaker/latest/dg/API_CreateTrainingJob.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toCreateTrainingJob", [])

    @jsii.member(jsii_name="toCreateTransformJob")
    def to_create_transform_job(self) -> "Sagemaker":
        """Starts a transform job.

        After the results are obtained, Amazon SageMaker saves them to an Amazon S3 location that you specify.

        Access Level: Write

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsTagKeys()
        - .ifInstanceTypes()
        - .ifModelArn()
        - .ifOutputKmsKey()
        - .ifVolumeKmsKey()

        https://docs.aws.amazon.com/sagemaker/latest/dg/API_CreateTransformJob.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toCreateTransformJob", [])

    @jsii.member(jsii_name="toCreateTrial")
    def to_create_trial(self) -> "Sagemaker":
        """Create a trial.

        Access Level: Write

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsTagKeys()

        https://docs.aws.amazon.com/sagemaker/latest/dg/API_CreateTrial.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toCreateTrial", [])

    @jsii.member(jsii_name="toCreateTrialComponent")
    def to_create_trial_component(self) -> "Sagemaker":
        """Create a trial component.

        Access Level: Write

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsTagKeys()

        https://docs.aws.amazon.com/sagemaker/latest/dg/API_CreateTrialComponent.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toCreateTrialComponent", [])

    @jsii.member(jsii_name="toCreateUserProfile")
    def to_create_user_profile(self) -> "Sagemaker":
        """Grants permission to create a UserProfile for a SageMaker Studio Domain.

        Access Level: Write

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsTagKeys()
        - .ifVpcSecurityGroupIds()
        - .ifInstanceTypes()
        - .ifDomainSharingOutputKmsKey()
        - .ifImageArns()
        - .ifImageVersionArns()

        Dependent actions:

        - iam:PassRole

        https://docs.aws.amazon.com/sagemaker/latest/dg/API_CreateUserProfile.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toCreateUserProfile", [])

    @jsii.member(jsii_name="toCreateWorkforce")
    def to_create_workforce(self) -> "Sagemaker":
        """Create a workforce.

        Access Level: Write

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsTagKeys()

        https://docs.aws.amazon.com/sagemaker/latest/dg/API_CreateWorkforce.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toCreateWorkforce", [])

    @jsii.member(jsii_name="toCreateWorkteam")
    def to_create_workteam(self) -> "Sagemaker":
        """Create a workteam.

        Access Level: Write

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsTagKeys()

        https://docs.aws.amazon.com/sagemaker/latest/dg/API_CreateWorkteam.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toCreateWorkteam", [])

    @jsii.member(jsii_name="toDeleteAlgorithm")
    def to_delete_algorithm(self) -> "Sagemaker":
        """Deletes an algorithm.

        Access Level: Write

        https://docs.aws.amazon.com/sagemaker/latest/dg/API_DeleteAlgorithm.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDeleteAlgorithm", [])

    @jsii.member(jsii_name="toDeleteApp")
    def to_delete_app(self) -> "Sagemaker":
        """Grants permission to delete an App.

        Access Level: Write

        https://docs.aws.amazon.com/sagemaker/latest/dg/API_DeleteApp.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDeleteApp", [])

    @jsii.member(jsii_name="toDeleteAppImageConfig")
    def to_delete_app_image_config(self) -> "Sagemaker":
        """Grants permission to delete an AppImageConfig.

        Access Level: Write

        https://docs.aws.amazon.com/sagemaker/latest/dg/API_DeleteAppImageConfig.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDeleteAppImageConfig", [])

    @jsii.member(jsii_name="toDeleteCodeRepository")
    def to_delete_code_repository(self) -> "Sagemaker":
        """Deletes a code repository.

        Access Level: Write

        https://docs.aws.amazon.com/sagemaker/latest/dg/API_DeleteCodeRepository.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDeleteCodeRepository", [])

    @jsii.member(jsii_name="toDeleteDomain")
    def to_delete_domain(self) -> "Sagemaker":
        """Grants permission to delete a Domain.

        Access Level: Write

        https://docs.aws.amazon.com/sagemaker/latest/dg/API_DeleteDomain.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDeleteDomain", [])

    @jsii.member(jsii_name="toDeleteEndpoint")
    def to_delete_endpoint(self) -> "Sagemaker":
        """Deletes an endpoint. Amazon SageMaker frees up all the resources that were deployed when the endpoint was created.

        Access Level: Write

        https://docs.aws.amazon.com/sagemaker/latest/dg/API_DeleteEndpoint.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDeleteEndpoint", [])

    @jsii.member(jsii_name="toDeleteEndpointConfig")
    def to_delete_endpoint_config(self) -> "Sagemaker":
        """Deletes the endpoint configuration created using the CreateEndpointConfig API.

        The DeleteEndpointConfig API deletes only the specified configuration. It does not delete any endpoints created using the configuration.

        Access Level: Write

        https://docs.aws.amazon.com/sagemaker/latest/dg/API_DeleteEndpointConfig.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDeleteEndpointConfig", [])

    @jsii.member(jsii_name="toDeleteExperiment")
    def to_delete_experiment(self) -> "Sagemaker":
        """Deletes an experiment.

        Access Level: Write

        https://docs.aws.amazon.com/sagemaker/latest/dg/API_DeleteExperiment.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDeleteExperiment", [])

    @jsii.member(jsii_name="toDeleteFlowDefinition")
    def to_delete_flow_definition(self) -> "Sagemaker":
        """Deltes the specified flow definition.

        Access Level: Write

        https://docs.aws.amazon.com/sagemaker/latest/dg/API_DeleteFlowDefinition.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDeleteFlowDefinition", [])

    @jsii.member(jsii_name="toDeleteHumanLoop")
    def to_delete_human_loop(self) -> "Sagemaker":
        """Deletes the specified human loop.

        Access Level: Write

        https://docs.aws.amazon.com/sagemaker/latest/dg/API_DeleteHumanLoop.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDeleteHumanLoop", [])

    @jsii.member(jsii_name="toDeleteImage")
    def to_delete_image(self) -> "Sagemaker":
        """Grants permissions to delete a SageMaker Image.

        Access Level: Write

        https://docs.aws.amazon.com/sagemaker/latest/dg/API_DeleteImage.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDeleteImage", [])

    @jsii.member(jsii_name="toDeleteImageVersion")
    def to_delete_image_version(self) -> "Sagemaker":
        """Grants permissions to delete a SageMaker ImageVersion.

        Access Level: Write

        https://docs.aws.amazon.com/sagemaker/latest/dg/API_DeleteImageVersion.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDeleteImageVersion", [])

    @jsii.member(jsii_name="toDeleteModel")
    def to_delete_model(self) -> "Sagemaker":
        """Deletes a model created using the CreateModel API.

        The DeleteModel API deletes only the model entry in Amazon SageMaker that you created by calling the CreateModel API. It does not delete model artifacts, inference code, or the IAM role that you specified when creating the model.

        Access Level: Write

        https://docs.aws.amazon.com/sagemaker/latest/dg/API_DeleteModel.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDeleteModel", [])

    @jsii.member(jsii_name="toDeleteModelPackage")
    def to_delete_model_package(self) -> "Sagemaker":
        """Deletes a model package.

        Access Level: Write

        https://docs.aws.amazon.com/sagemaker/latest/dg/API_DeleteModelPackage.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDeleteModelPackage", [])

    @jsii.member(jsii_name="toDeleteMonitoringSchedule")
    def to_delete_monitoring_schedule(self) -> "Sagemaker":
        """Deletes a monitoring schedule. Amazon SageMaker will no longer run the scheduled monitoring.

        Access Level: Write

        https://docs.aws.amazon.com/sagemaker/latest/dg/API_DeleteMonitoringSchedule.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDeleteMonitoringSchedule", [])

    @jsii.member(jsii_name="toDeleteNotebookInstance")
    def to_delete_notebook_instance(self) -> "Sagemaker":
        """Deletes an Amazon SageMaker notebook instance. Before you can delete a notebook instance, you must call the StopNotebookInstance API.

        Access Level: Write

        https://docs.aws.amazon.com/sagemaker/latest/dg/API_DeleteNotebookInstance.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDeleteNotebookInstance", [])

    @jsii.member(jsii_name="toDeleteNotebookInstanceLifecycleConfig")
    def to_delete_notebook_instance_lifecycle_config(self) -> "Sagemaker":
        """Deletes an notebook instance lifecycle configuration that can be deployed using Amazon SageMaker.

        Access Level: Write

        https://docs.aws.amazon.com/sagemaker/latest/dg/API_DeleteNotebookInstanceLifecycleConfig.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDeleteNotebookInstanceLifecycleConfig", [])

    @jsii.member(jsii_name="toDeleteTags")
    def to_delete_tags(self) -> "Sagemaker":
        """Deletes the specified set of tags from an Amazon SageMaker resource.

        Access Level: Tagging

        Possible conditions:

        - .ifAwsTagKeys()

        https://docs.aws.amazon.com/sagemaker/latest/dg/API_DeleteTags.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDeleteTags", [])

    @jsii.member(jsii_name="toDeleteTrial")
    def to_delete_trial(self) -> "Sagemaker":
        """Deletes a trial.

        Access Level: Write

        https://docs.aws.amazon.com/sagemaker/latest/dg/API_DeleteTrial.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDeleteTrial", [])

    @jsii.member(jsii_name="toDeleteTrialComponent")
    def to_delete_trial_component(self) -> "Sagemaker":
        """Deletes a trial component.

        Access Level: Write

        https://docs.aws.amazon.com/sagemaker/latest/dg/API_DeleteTrialComponent.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDeleteTrialComponent", [])

    @jsii.member(jsii_name="toDeleteUserProfile")
    def to_delete_user_profile(self) -> "Sagemaker":
        """Grants permission to delete a UserProfile.

        Access Level: Write

        https://docs.aws.amazon.com/sagemaker/latest/dg/API_DeleteUserProfile.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDeleteUserProfile", [])

    @jsii.member(jsii_name="toDeleteWorkforce")
    def to_delete_workforce(self) -> "Sagemaker":
        """Deletes a workforce.

        Access Level: Write

        https://docs.aws.amazon.com/sagemaker/latest/dg/API_DeleteWorkforce.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDeleteWorkforce", [])

    @jsii.member(jsii_name="toDeleteWorkteam")
    def to_delete_workteam(self) -> "Sagemaker":
        """Deletes a workteam.

        Access Level: Write

        https://docs.aws.amazon.com/sagemaker/latest/dg/API_DeleteWorkteam.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDeleteWorkteam", [])

    @jsii.member(jsii_name="toDescribeAlgorithm")
    def to_describe_algorithm(self) -> "Sagemaker":
        """Returns information about an algorithm.

        Access Level: Read

        https://docs.aws.amazon.com/sagemaker/latest/dg/API_DescribeAlgorithm.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDescribeAlgorithm", [])

    @jsii.member(jsii_name="toDescribeApp")
    def to_describe_app(self) -> "Sagemaker":
        """Grants permission to describe an App.

        Access Level: Read

        https://docs.aws.amazon.com/sagemaker/latest/dg/API_DescribeApp.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDescribeApp", [])

    @jsii.member(jsii_name="toDescribeAppImageConfig")
    def to_describe_app_image_config(self) -> "Sagemaker":
        """Grants permission to describe an AppImageConfig.

        Access Level: Read

        https://docs.aws.amazon.com/sagemaker/latest/dg/API_DescribeAppImageConfig.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDescribeAppImageConfig", [])

    @jsii.member(jsii_name="toDescribeAutoMLJob")
    def to_describe_auto_ml_job(self) -> "Sagemaker":
        """Describes an automl job that was created via CreateAutoMLJob API.

        Access Level: Read

        https://docs.aws.amazon.com/sagemaker/latest/dg/API_DescribeAutoMLJob.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDescribeAutoMLJob", [])

    @jsii.member(jsii_name="toDescribeCodeRepository")
    def to_describe_code_repository(self) -> "Sagemaker":
        """Returns information about a code repository.

        Access Level: Read

        https://docs.aws.amazon.com/sagemaker/latest/dg/API_DescribeCodeRepository.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDescribeCodeRepository", [])

    @jsii.member(jsii_name="toDescribeCompilationJob")
    def to_describe_compilation_job(self) -> "Sagemaker":
        """Returns information about a compilation job.

        Access Level: Read

        https://docs.aws.amazon.com/sagemaker/latest/dg/API_DescribeCompilationJob.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDescribeCompilationJob", [])

    @jsii.member(jsii_name="toDescribeDomain")
    def to_describe_domain(self) -> "Sagemaker":
        """Grants permission to describe a Domain.

        Access Level: Read

        https://docs.aws.amazon.com/sagemaker/latest/dg/API_DescribeDomain.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDescribeDomain", [])

    @jsii.member(jsii_name="toDescribeEndpoint")
    def to_describe_endpoint(self) -> "Sagemaker":
        """Returns the description of an endpoint.

        Access Level: Read

        https://docs.aws.amazon.com/sagemaker/latest/dg/API_DescribeEndpoint.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDescribeEndpoint", [])

    @jsii.member(jsii_name="toDescribeEndpointConfig")
    def to_describe_endpoint_config(self) -> "Sagemaker":
        """Returns the description of an endpoint configuration, which was created using the CreateEndpointConfig API.

        Access Level: Read

        https://docs.aws.amazon.com/sagemaker/latest/dg/API_DescribeEndpointConfig.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDescribeEndpointConfig", [])

    @jsii.member(jsii_name="toDescribeExperiment")
    def to_describe_experiment(self) -> "Sagemaker":
        """Returns information about an experiment.

        Access Level: Read

        https://docs.aws.amazon.com/sagemaker/latest/dg/API_DescribeExperiment.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDescribeExperiment", [])

    @jsii.member(jsii_name="toDescribeFlowDefinition")
    def to_describe_flow_definition(self) -> "Sagemaker":
        """Returns detailed information about the specified flow definition.

        Access Level: Read

        https://docs.aws.amazon.com/sagemaker/latest/dg/API_DescribeFlowDefinition.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDescribeFlowDefinition", [])

    @jsii.member(jsii_name="toDescribeHumanLoop")
    def to_describe_human_loop(self) -> "Sagemaker":
        """Returns detailed information about the specified human loop.

        Access Level: Read

        https://docs.aws.amazon.com/sagemaker/latest/dg/API_DescribeHumanLoop.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDescribeHumanLoop", [])

    @jsii.member(jsii_name="toDescribeHumanTaskUi")
    def to_describe_human_task_ui(self) -> "Sagemaker":
        """Returns detailed information about the specified human review workflow user interface.

        Access Level: Read

        https://docs.aws.amazon.com/sagemaker/latest/dg/API_DescribeHumanTaskUi.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDescribeHumanTaskUi", [])

    @jsii.member(jsii_name="toDescribeHyperParameterTuningJob")
    def to_describe_hyper_parameter_tuning_job(self) -> "Sagemaker":
        """Describes a hyper parameter tuning job that was created via CreateHyperParameterTuningJob API.

        Access Level: Read

        https://docs.aws.amazon.com/sagemaker/latest/dg/API_DescribeHyperParameterTuningJob.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDescribeHyperParameterTuningJob", [])

    @jsii.member(jsii_name="toDescribeImage")
    def to_describe_image(self) -> "Sagemaker":
        """Grants permissions to return information about a SageMaker Image.

        Access Level: Read

        https://docs.aws.amazon.com/sagemaker/latest/dg/API_DescribeImage.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDescribeImage", [])

    @jsii.member(jsii_name="toDescribeImageVersion")
    def to_describe_image_version(self) -> "Sagemaker":
        """Grants permissions to return information about a SageMaker ImageVersion.

        Access Level: Read

        https://docs.aws.amazon.com/sagemaker/latest/dg/API_DescribeImageVersion.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDescribeImageVersion", [])

    @jsii.member(jsii_name="toDescribeLabelingJob")
    def to_describe_labeling_job(self) -> "Sagemaker":
        """Returns information about a labeling job.

        Access Level: Read

        https://docs.aws.amazon.com/sagemaker/latest/dg/API_DescribeLabelingJob.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDescribeLabelingJob", [])

    @jsii.member(jsii_name="toDescribeModel")
    def to_describe_model(self) -> "Sagemaker":
        """Describes a model that you created using the CreateModel API.

        Access Level: Read

        https://docs.aws.amazon.com/sagemaker/latest/dg/API_DescribeModel.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDescribeModel", [])

    @jsii.member(jsii_name="toDescribeModelPackage")
    def to_describe_model_package(self) -> "Sagemaker":
        """Returns information about a model package.

        Access Level: Read

        https://docs.aws.amazon.com/sagemaker/latest/dg/API_DescribeModelPackage.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDescribeModelPackage", [])

    @jsii.member(jsii_name="toDescribeMonitoringSchedule")
    def to_describe_monitoring_schedule(self) -> "Sagemaker":
        """Returns information about a monitoring schedule.

        Access Level: Read

        https://docs.aws.amazon.com/sagemaker/latest/dg/API_DescribeMonitoringSchedule.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDescribeMonitoringSchedule", [])

    @jsii.member(jsii_name="toDescribeNotebookInstance")
    def to_describe_notebook_instance(self) -> "Sagemaker":
        """Returns information about a notebook instance.

        Access Level: Read

        https://docs.aws.amazon.com/sagemaker/latest/dg/API_DescribeNotebookInstance.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDescribeNotebookInstance", [])

    @jsii.member(jsii_name="toDescribeNotebookInstanceLifecycleConfig")
    def to_describe_notebook_instance_lifecycle_config(self) -> "Sagemaker":
        """Describes an notebook instance lifecycle configuration that was created via CreateNotebookInstanceLifecycleConfig API.

        Access Level: Read

        https://docs.aws.amazon.com/sagemaker/latest/dg/API_DescribeNotebookInstanceLifecycleConfig.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDescribeNotebookInstanceLifecycleConfig", [])

    @jsii.member(jsii_name="toDescribeProcessingJob")
    def to_describe_processing_job(self) -> "Sagemaker":
        """Returns information about a processing job.

        Access Level: Read

        https://docs.aws.amazon.com/sagemaker/latest/dg/API_DescribeProcessingJob.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDescribeProcessingJob", [])

    @jsii.member(jsii_name="toDescribeSubscribedWorkteam")
    def to_describe_subscribed_workteam(self) -> "Sagemaker":
        """Returns information about a subscribed workteam.

        Access Level: Read

        https://docs.aws.amazon.com/sagemaker/latest/dg/API_DescribeSubscribedWorkteam.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDescribeSubscribedWorkteam", [])

    @jsii.member(jsii_name="toDescribeTrainingJob")
    def to_describe_training_job(self) -> "Sagemaker":
        """Returns information about a training job.

        Access Level: Read

        https://docs.aws.amazon.com/sagemaker/latest/dg/API_DescribeTrainingJob.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDescribeTrainingJob", [])

    @jsii.member(jsii_name="toDescribeTransformJob")
    def to_describe_transform_job(self) -> "Sagemaker":
        """Returns information about a transform job.

        Access Level: Read

        https://docs.aws.amazon.com/sagemaker/latest/dg/API_DescribeTransformJob.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDescribeTransformJob", [])

    @jsii.member(jsii_name="toDescribeTrial")
    def to_describe_trial(self) -> "Sagemaker":
        """Returns information about a trial.

        Access Level: Read

        https://docs.aws.amazon.com/sagemaker/latest/dg/API_DescribeTrial.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDescribeTrial", [])

    @jsii.member(jsii_name="toDescribeTrialComponent")
    def to_describe_trial_component(self) -> "Sagemaker":
        """Returns information about a trial component.

        Access Level: Read

        https://docs.aws.amazon.com/sagemaker/latest/dg/API_DescribeTrialComponent.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDescribeTrialComponent", [])

    @jsii.member(jsii_name="toDescribeUserProfile")
    def to_describe_user_profile(self) -> "Sagemaker":
        """Grants permission to describe a UserProfile.

        Access Level: Read

        https://docs.aws.amazon.com/sagemaker/latest/dg/API_DescribeUserProfile.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDescribeUserProfile", [])

    @jsii.member(jsii_name="toDescribeWorkforce")
    def to_describe_workforce(self) -> "Sagemaker":
        """Returns information about a workforce.

        Access Level: Read

        https://docs.aws.amazon.com/sagemaker/latest/dg/API_DescribeWorkforce.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDescribeWorkforce", [])

    @jsii.member(jsii_name="toDescribeWorkteam")
    def to_describe_workteam(self) -> "Sagemaker":
        """Returns information about a workteam.

        Access Level: Read

        https://docs.aws.amazon.com/sagemaker/latest/dg/API_DescribeWorkteam.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDescribeWorkteam", [])

    @jsii.member(jsii_name="toDisassociateTrialComponent")
    def to_disassociate_trial_component(self) -> "Sagemaker":
        """Disassociate a trial component with a trial.

        Access Level: Write

        https://docs.aws.amazon.com/sagemaker/latest/dg/API_DisassociateTrialComponent.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDisassociateTrialComponent", [])

    @jsii.member(jsii_name="toGetSearchSuggestions")
    def to_get_search_suggestions(self) -> "Sagemaker":
        """Get search suggestions when provided with keyword.

        Access Level: Read

        https://docs.aws.amazon.com/sagemaker/latest/dg/API_GetSearchSuggestions.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toGetSearchSuggestions", [])

    @jsii.member(jsii_name="toInvokeEndpoint")
    def to_invoke_endpoint(self) -> "Sagemaker":
        """After you deploy a model into production using Amazon SageMaker hosting services, your client applications use this API to get inferences from the model hosted at the specified endpoint.

        Access Level: Read

        Possible conditions:

        - .ifTargetModel()

        https://docs.aws.amazon.com/sagemaker/latest/dg/API_InvokeEndpoint.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toInvokeEndpoint", [])

    @jsii.member(jsii_name="toListAlgorithms")
    def to_list_algorithms(self) -> "Sagemaker":
        """Lists algorithms.

        Access Level: List

        https://docs.aws.amazon.com/sagemaker/latest/dg/API_ListAlgorithms.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toListAlgorithms", [])

    @jsii.member(jsii_name="toListAppImageConfigs")
    def to_list_app_image_configs(self) -> "Sagemaker":
        """Grants permission to list the AppImageConfigs in your account.

        Access Level: List

        https://docs.aws.amazon.com/sagemaker/latest/dg/API_ListAppImageConfigs.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toListAppImageConfigs", [])

    @jsii.member(jsii_name="toListApps")
    def to_list_apps(self) -> "Sagemaker":
        """Grants permission to list the Apps in your account.

        Access Level: List

        https://docs.aws.amazon.com/sagemaker/latest/dg/API_ListApps.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toListApps", [])

    @jsii.member(jsii_name="toListAutoMLJobs")
    def to_list_auto_ml_jobs(self) -> "Sagemaker":
        """Lists automl jobs created via the CreateAutoMLJob.

        Access Level: List

        https://docs.aws.amazon.com/sagemaker/latest/dg/API_ListAutoMLJobs.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toListAutoMLJobs", [])

    @jsii.member(jsii_name="toListCandidatesForAutoMLJob")
    def to_list_candidates_for_auto_ml_job(self) -> "Sagemaker":
        """Lists candidates for automl job created via the CreateAutoMLJob.

        Access Level: List

        https://docs.aws.amazon.com/sagemaker/latest/dg/API_ListCandidatesForAutoMLJob.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toListCandidatesForAutoMLJob", [])

    @jsii.member(jsii_name="toListCodeRepositories")
    def to_list_code_repositories(self) -> "Sagemaker":
        """Lists code repositories.

        Access Level: List

        https://docs.aws.amazon.com/sagemaker/latest/dg/API_ListCodeRepositories.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toListCodeRepositories", [])

    @jsii.member(jsii_name="toListCompilationJobs")
    def to_list_compilation_jobs(self) -> "Sagemaker":
        """Lists compilation jobs.

        Access Level: List

        https://docs.aws.amazon.com/sagemaker/latest/dg/API_ListCompilationJobs.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toListCompilationJobs", [])

    @jsii.member(jsii_name="toListDomains")
    def to_list_domains(self) -> "Sagemaker":
        """Grants permission to list the Domains in your account.

        Access Level: List

        https://docs.aws.amazon.com/sagemaker/latest/dg/API_ListDomains.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toListDomains", [])

    @jsii.member(jsii_name="toListEndpointConfigs")
    def to_list_endpoint_configs(self) -> "Sagemaker":
        """Lists endpoint configurations.

        Access Level: List

        https://docs.aws.amazon.com/sagemaker/latest/dg/API_ListEndpointConfigs.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toListEndpointConfigs", [])

    @jsii.member(jsii_name="toListEndpoints")
    def to_list_endpoints(self) -> "Sagemaker":
        """Lists endpoints.

        Access Level: List

        https://docs.aws.amazon.com/sagemaker/latest/dg/API_ListEndpoints.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toListEndpoints", [])

    @jsii.member(jsii_name="toListExperiments")
    def to_list_experiments(self) -> "Sagemaker":
        """Lists experiments.

        Access Level: List

        https://docs.aws.amazon.com/sagemaker/latest/dg/API_ListExperiments.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toListExperiments", [])

    @jsii.member(jsii_name="toListFlowDefinitions")
    def to_list_flow_definitions(self) -> "Sagemaker":
        """Returns summary information about flow definitions, given the specified parameters.

        Access Level: List

        https://docs.aws.amazon.com/sagemaker/latest/dg/API_ListFlowDefinitions.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toListFlowDefinitions", [])

    @jsii.member(jsii_name="toListHumanLoops")
    def to_list_human_loops(self) -> "Sagemaker":
        """Returns summary information about human loops, given the specified parameters.

        Access Level: List

        https://docs.aws.amazon.com/sagemaker/latest/dg/API_ListHumanLoops.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toListHumanLoops", [])

    @jsii.member(jsii_name="toListHumanTaskUis")
    def to_list_human_task_uis(self) -> "Sagemaker":
        """Returns summary information about human review workflow user interfaces, given the specified parameters.

        Access Level: List

        https://docs.aws.amazon.com/sagemaker/latest/dg/API_ListHumanTaskUis.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toListHumanTaskUis", [])

    @jsii.member(jsii_name="toListHyperParameterTuningJobs")
    def to_list_hyper_parameter_tuning_jobs(self) -> "Sagemaker":
        """Lists hyper parameter tuning jobs that was created using Amazon SageMaker.

        Access Level: List

        https://docs.aws.amazon.com/sagemaker/latest/dg/API_ListHyperParameterTuningJobs.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toListHyperParameterTuningJobs", [])

    @jsii.member(jsii_name="toListImages")
    def to_list_images(self) -> "Sagemaker":
        """Grants permissions to list SageMaker Images in your account.

        Access Level: List

        https://docs.aws.amazon.com/sagemaker/latest/dg/API_ListImages.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toListImages", [])

    @jsii.member(jsii_name="toListImageVersions")
    def to_list_image_versions(self) -> "Sagemaker":
        """Grants permissions to list ImageVersions that belong to a SageMaker Image.

        Access Level: List

        https://docs.aws.amazon.com/sagemaker/latest/dg/API_ListImageVersions.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toListImageVersions", [])

    @jsii.member(jsii_name="toListLabelingJobs")
    def to_list_labeling_jobs(self) -> "Sagemaker":
        """Lists labeling jobs.

        Access Level: List

        https://docs.aws.amazon.com/sagemaker/latest/dg/API_ListLabelingJobs.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toListLabelingJobs", [])

    @jsii.member(jsii_name="toListLabelingJobsForWorkteam")
    def to_list_labeling_jobs_for_workteam(self) -> "Sagemaker":
        """Lists labeling jobs for workteam.

        Access Level: List

        https://docs.aws.amazon.com/sagemaker/latest/dg/API_ListLabelingJobs.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toListLabelingJobsForWorkteam", [])

    @jsii.member(jsii_name="toListModelPackages")
    def to_list_model_packages(self) -> "Sagemaker":
        """Lists model packages.

        Access Level: List

        https://docs.aws.amazon.com/sagemaker/latest/dg/API_ListModelPackages.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toListModelPackages", [])

    @jsii.member(jsii_name="toListModels")
    def to_list_models(self) -> "Sagemaker":
        """Lists the models created with the CreateModel API.

        Access Level: List

        https://docs.aws.amazon.com/sagemaker/latest/dg/API_ListModels.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toListModels", [])

    @jsii.member(jsii_name="toListMonitoringExecutions")
    def to_list_monitoring_executions(self) -> "Sagemaker":
        """Lists monitoring executions.

        Access Level: List

        https://docs.aws.amazon.com/sagemaker/latest/dg/API_ListMonitoringExecutions.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toListMonitoringExecutions", [])

    @jsii.member(jsii_name="toListMonitoringSchedules")
    def to_list_monitoring_schedules(self) -> "Sagemaker":
        """Lists monitoring schedules.

        Access Level: List

        https://docs.aws.amazon.com/sagemaker/latest/dg/API_ListMonitoringSchedules.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toListMonitoringSchedules", [])

    @jsii.member(jsii_name="toListNotebookInstanceLifecycleConfigs")
    def to_list_notebook_instance_lifecycle_configs(self) -> "Sagemaker":
        """Lists notebook instance lifecycle configurations that can be deployed using Amazon SageMaker.

        Access Level: List

        https://docs.aws.amazon.com/sagemaker/latest/dg/API_ListNotebookInstanceLifecycleConfigs.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toListNotebookInstanceLifecycleConfigs", [])

    @jsii.member(jsii_name="toListNotebookInstances")
    def to_list_notebook_instances(self) -> "Sagemaker":
        """Returns a list of the Amazon SageMaker notebook instances in the requester's account in an AWS Region.

        Access Level: List

        https://docs.aws.amazon.com/sagemaker/latest/dg/API_ListNotebookInstances.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toListNotebookInstances", [])

    @jsii.member(jsii_name="toListProcessingJobs")
    def to_list_processing_jobs(self) -> "Sagemaker":
        """Lists processing jobs.

        Access Level: List

        https://docs.aws.amazon.com/sagemaker/latest/dg/API_ListProcessingJobs.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toListProcessingJobs", [])

    @jsii.member(jsii_name="toListSubscribedWorkteams")
    def to_list_subscribed_workteams(self) -> "Sagemaker":
        """Lists subscribed workteams.

        Access Level: List

        https://docs.aws.amazon.com/sagemaker/latest/dg/API_ListSubscribedWorkteams.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toListSubscribedWorkteams", [])

    @jsii.member(jsii_name="toListTags")
    def to_list_tags(self) -> "Sagemaker":
        """Returns the tag set associated with the specified resource.

        Access Level: List

        https://docs.aws.amazon.com/sagemaker/latest/dg/API_ListTags.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toListTags", [])

    @jsii.member(jsii_name="toListTrainingJobs")
    def to_list_training_jobs(self) -> "Sagemaker":
        """Lists training jobs.

        Access Level: List

        https://docs.aws.amazon.com/sagemaker/latest/dg/API_ListTrainingJobs.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toListTrainingJobs", [])

    @jsii.member(jsii_name="toListTrainingJobsForHyperParameterTuningJob")
    def to_list_training_jobs_for_hyper_parameter_tuning_job(self) -> "Sagemaker":
        """Lists training jobs for a hyper parameter tuning job that was created using Amazon SageMaker.

        Access Level: List

        https://docs.aws.amazon.com/sagemaker/latest/dg/API_ ListTrainingJobsForHyperParameterTuningJob.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toListTrainingJobsForHyperParameterTuningJob", [])

    @jsii.member(jsii_name="toListTransformJobs")
    def to_list_transform_jobs(self) -> "Sagemaker":
        """Lists transform jobs.

        Access Level: List

        https://docs.aws.amazon.com/sagemaker/latest/dg/API_ListTransformJobs.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toListTransformJobs", [])

    @jsii.member(jsii_name="toListTrialComponents")
    def to_list_trial_components(self) -> "Sagemaker":
        """Lists trial components.

        Access Level: List

        https://docs.aws.amazon.com/sagemaker/latest/dg/API_ListTrialComponents.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toListTrialComponents", [])

    @jsii.member(jsii_name="toListTrials")
    def to_list_trials(self) -> "Sagemaker":
        """Lists trials.

        Access Level: List

        https://docs.aws.amazon.com/sagemaker/latest/dg/API_ListTrials.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toListTrials", [])

    @jsii.member(jsii_name="toListUserProfiles")
    def to_list_user_profiles(self) -> "Sagemaker":
        """Grants permission to list the UserProfiles in your account.

        Access Level: List

        https://docs.aws.amazon.com/sagemaker/latest/dg/API_ListUserProfiles.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toListUserProfiles", [])

    @jsii.member(jsii_name="toListWorkforces")
    def to_list_workforces(self) -> "Sagemaker":
        """Lists workforces.

        Access Level: List

        https://docs.aws.amazon.com/sagemaker/latest/dg/API_ListWorkforces.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toListWorkforces", [])

    @jsii.member(jsii_name="toListWorkteams")
    def to_list_workteams(self) -> "Sagemaker":
        """Lists workteams.

        Access Level: List

        https://docs.aws.amazon.com/sagemaker/latest/dg/API_ListWorkteams.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toListWorkteams", [])

    @jsii.member(jsii_name="toRenderUiTemplate")
    def to_render_ui_template(self) -> "Sagemaker":
        """Render a UI template used for a human annotation task.

        Access Level: Read

        Dependent actions:

        - iam:PassRole

        https://docs.aws.amazon.com/sagemaker/latest/dg/API_RenderUiTemplate.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toRenderUiTemplate", [])

    @jsii.member(jsii_name="toSearch")
    def to_search(self) -> "Sagemaker":
        """Search for SageMaker objects.

        Access Level: Read

        https://docs.aws.amazon.com/sagemaker/latest/dg/API_Search.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toSearch", [])

    @jsii.member(jsii_name="toStartHumanLoop")
    def to_start_human_loop(self) -> "Sagemaker":
        """Starts a human loop.

        Access Level: Write

        https://docs.aws.amazon.com/sagemaker/latest/dg/API_StartHumanLoop.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toStartHumanLoop", [])

    @jsii.member(jsii_name="toStartMonitoringSchedule")
    def to_start_monitoring_schedule(self) -> "Sagemaker":
        """Starts a monitoring schedule.

        Access Level: Write

        https://docs.aws.amazon.com/sagemaker/latest/dg/API_StartMonitoringSchedule.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toStartMonitoringSchedule", [])

    @jsii.member(jsii_name="toStartNotebookInstance")
    def to_start_notebook_instance(self) -> "Sagemaker":
        """Launches an EC2 instance with the latest version of the libraries and attaches your EBS volume.

        Access Level: Write

        https://docs.aws.amazon.com/sagemaker/latest/dg/API_StartNotebookInstance.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toStartNotebookInstance", [])

    @jsii.member(jsii_name="toStopAutoMLJob")
    def to_stop_auto_ml_job(self) -> "Sagemaker":
        """Stops a running automl job created via the CreateAutoMLJob.

        Access Level: Write

        https://docs.aws.amazon.com/sagemaker/latest/dg/API_StopAutoMLJob.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toStopAutoMLJob", [])

    @jsii.member(jsii_name="toStopCompilationJob")
    def to_stop_compilation_job(self) -> "Sagemaker":
        """Stops a compilation job.

        Access Level: Write

        https://docs.aws.amazon.com/sagemaker/latest/dg/API_StopCompilationJob.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toStopCompilationJob", [])

    @jsii.member(jsii_name="toStopHumanLoop")
    def to_stop_human_loop(self) -> "Sagemaker":
        """Stops the specified human loop.

        Access Level: Write

        https://docs.aws.amazon.com/sagemaker/latest/dg/API_StopHumanLoop.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toStopHumanLoop", [])

    @jsii.member(jsii_name="toStopHyperParameterTuningJob")
    def to_stop_hyper_parameter_tuning_job(self) -> "Sagemaker":
        """Stops a running hyper parameter tuning job create via the CreateHyperParameterTuningJob.

        Access Level: Write

        https://docs.aws.amazon.com/sagemaker/latest/dg/API_StopHyperParameterTuningJob.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toStopHyperParameterTuningJob", [])

    @jsii.member(jsii_name="toStopLabelingJob")
    def to_stop_labeling_job(self) -> "Sagemaker":
        """Stops a labeling job. Any labels already generated will be exported before stopping.

        Access Level: Write

        https://docs.aws.amazon.com/sagemaker/latest/dg/API_StopLabelingJob.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toStopLabelingJob", [])

    @jsii.member(jsii_name="toStopMonitoringSchedule")
    def to_stop_monitoring_schedule(self) -> "Sagemaker":
        """Stops a monitoring schedule.

        Access Level: Write

        https://docs.aws.amazon.com/sagemaker/latest/dg/API_StopMonitoringSchedule.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toStopMonitoringSchedule", [])

    @jsii.member(jsii_name="toStopNotebookInstance")
    def to_stop_notebook_instance(self) -> "Sagemaker":
        """Terminates the EC2 instance.

        Before terminating the instance, Amazon SageMaker disconnects the EBS volume from it. Amazon SageMaker preserves the EBS volume.

        Access Level: Write

        https://docs.aws.amazon.com/sagemaker/latest/dg/API_StopNotebookInstance.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toStopNotebookInstance", [])

    @jsii.member(jsii_name="toStopProcessingJob")
    def to_stop_processing_job(self) -> "Sagemaker":
        """Stops a processing job.

        To stop a job, Amazon SageMaker sends the algorithm the SIGTERM signal, which delays job termination for 120 seconds.

        Access Level: Write

        https://docs.aws.amazon.com/sagemaker/latest/dg/API_StopProcessingJob.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toStopProcessingJob", [])

    @jsii.member(jsii_name="toStopTrainingJob")
    def to_stop_training_job(self) -> "Sagemaker":
        """Stops a training job.

        To stop a job, Amazon SageMaker sends the algorithm the SIGTERM signal, which delays job termination for 120 seconds.

        Access Level: Write

        https://docs.aws.amazon.com/sagemaker/latest/dg/API_StopTrainingJob.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toStopTrainingJob", [])

    @jsii.member(jsii_name="toStopTransformJob")
    def to_stop_transform_job(self) -> "Sagemaker":
        """Stops a transform job.

        When Amazon SageMaker receives a StopTransformJob request, the status of the job changes to Stopping. After Amazon SageMaker stops the job, the status is set to Stopped

        Access Level: Write

        https://docs.aws.amazon.com/sagemaker/latest/dg/API_StopTransformJob.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toStopTransformJob", [])

    @jsii.member(jsii_name="toUpdateAppImageConfig")
    def to_update_app_image_config(self) -> "Sagemaker":
        """Grants permission to update an AppImageConfig.

        Access Level: Write

        https://docs.aws.amazon.com/sagemaker/latest/dg/API_UpdateAppImageConfig.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toUpdateAppImageConfig", [])

    @jsii.member(jsii_name="toUpdateCodeRepository")
    def to_update_code_repository(self) -> "Sagemaker":
        """Updates a code repository.

        Access Level: Write

        https://docs.aws.amazon.com/sagemaker/latest/dg/API_UpdateCodeRepository.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toUpdateCodeRepository", [])

    @jsii.member(jsii_name="toUpdateDomain")
    def to_update_domain(self) -> "Sagemaker":
        """Grants permission to update a Domain.

        Access Level: Write

        Possible conditions:

        - .ifVpcSecurityGroupIds()
        - .ifInstanceTypes()
        - .ifDomainSharingOutputKmsKey()
        - .ifImageArns()
        - .ifImageVersionArns()

        https://docs.aws.amazon.com/sagemaker/latest/dg/API_UpdateDomain.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toUpdateDomain", [])

    @jsii.member(jsii_name="toUpdateEndpoint")
    def to_update_endpoint(self) -> "Sagemaker":
        """Updates an endpoint to use the endpoint configuration specified in the request.

        Access Level: Write

        https://docs.aws.amazon.com/sagemaker/latest/dg/API_UpdateEndpoint.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toUpdateEndpoint", [])

    @jsii.member(jsii_name="toUpdateEndpointWeightsAndCapacities")
    def to_update_endpoint_weights_and_capacities(self) -> "Sagemaker":
        """Updates variant weight, capacity, or both of one or more variants associated with an endpoint.

        Access Level: Write

        https://docs.aws.amazon.com/sagemaker/latest/dg/API_UpdateEndpointWeightsAndCapacities.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toUpdateEndpointWeightsAndCapacities", [])

    @jsii.member(jsii_name="toUpdateExperiment")
    def to_update_experiment(self) -> "Sagemaker":
        """Updates an experiment.

        Access Level: Write

        https://docs.aws.amazon.com/sagemaker/latest/dg/API_UpdateExperiment.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toUpdateExperiment", [])

    @jsii.member(jsii_name="toUpdateImage")
    def to_update_image(self) -> "Sagemaker":
        """Grants permissions to update the properties of a SageMaker Image.

        Access Level: Write

        Dependent actions:

        - iam:PassRole

        https://docs.aws.amazon.com/sagemaker/latest/dg/API_UpdateImage.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toUpdateImage", [])

    @jsii.member(jsii_name="toUpdateMonitoringSchedule")
    def to_update_monitoring_schedule(self) -> "Sagemaker":
        """Updates a monitoring schedule.

        Access Level: Write

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsTagKeys()
        - .ifInstanceTypes()
        - .ifMaxRuntimeInSeconds()
        - .ifNetworkIsolation()
        - .ifOutputKmsKey()
        - .ifVolumeKmsKey()
        - .ifVpcSecurityGroupIds()
        - .ifVpcSubnets()

        Dependent actions:

        - iam:PassRole

        https://docs.aws.amazon.com/sagemaker/latest/dg/API_UpdateMonitoringSchedule.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toUpdateMonitoringSchedule", [])

    @jsii.member(jsii_name="toUpdateNotebookInstance")
    def to_update_notebook_instance(self) -> "Sagemaker":
        """Updates a notebook instance.

        Notebook instance updates include upgrading or downgrading the EC2 instance used for your notebook instance to accommodate changes in your workload requirements. You can also update the VPC security groups.

        Access Level: Write

        Possible conditions:

        - .ifAcceleratorTypes()
        - .ifInstanceTypes()
        - .ifRootAccess()

        https://docs.aws.amazon.com/sagemaker/latest/dg/API_UpdateNotebookInstance.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toUpdateNotebookInstance", [])

    @jsii.member(jsii_name="toUpdateNotebookInstanceLifecycleConfig")
    def to_update_notebook_instance_lifecycle_config(self) -> "Sagemaker":
        """Updates a notebook instance lifecycle configuration created with the CreateNotebookInstanceLifecycleConfig API.

        Access Level: Write

        https://docs.aws.amazon.com/sagemaker/latest/dg/API_ UpdateNotebookInstanceLifecycleConfig.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toUpdateNotebookInstanceLifecycleConfig", [])

    @jsii.member(jsii_name="toUpdateTrial")
    def to_update_trial(self) -> "Sagemaker":
        """Updates a trial.

        Access Level: Write

        https://docs.aws.amazon.com/sagemaker/latest/dg/API_UpdateTrial.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toUpdateTrial", [])

    @jsii.member(jsii_name="toUpdateTrialComponent")
    def to_update_trial_component(self) -> "Sagemaker":
        """Updates a trial component.

        Access Level: Write

        https://docs.aws.amazon.com/sagemaker/latest/dg/API_UpdateTrialComponent.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toUpdateTrialComponent", [])

    @jsii.member(jsii_name="toUpdateUserProfile")
    def to_update_user_profile(self) -> "Sagemaker":
        """Grants permission to update a UserProfile.

        Access Level: Write

        Possible conditions:

        - .ifInstanceTypes()
        - .ifVpcSecurityGroupIds()
        - .ifInstanceTypes()
        - .ifDomainSharingOutputKmsKey()
        - .ifImageArns()
        - .ifImageVersionArns()

        https://docs.aws.amazon.com/sagemaker/latest/dg/API_UpdateUserProfile.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toUpdateUserProfile", [])

    @jsii.member(jsii_name="toUpdateWorkforce")
    def to_update_workforce(self) -> "Sagemaker":
        """Updates a workforce.

        Access Level: Write

        https://docs.aws.amazon.com/sagemaker/latest/dg/API_UpdateWorkforce.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toUpdateWorkforce", [])

    @jsii.member(jsii_name="toUpdateWorkteam")
    def to_update_workteam(self) -> "Sagemaker":
        """Updates a workteam.

        Access Level: Write

        https://docs.aws.amazon.com/sagemaker/latest/dg/API_UpdateWorkteam.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toUpdateWorkteam", [])

    @builtins.property # type: ignore
    @jsii.member(jsii_name="accessLevelList")
    def _access_level_list(self) -> "AccessLevelList":
        """
        stability
        :stability: experimental
        """
        return jsii.get(self, "accessLevelList")

    @_access_level_list.setter # type: ignore
    def _access_level_list(self, value: "AccessLevelList") -> None:
        jsii.set(self, "accessLevelList", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="servicePrefix")
    def service_prefix(self) -> builtins.str:
        """Holds the prefix of the service actions, e.g. ``ec2``.

        stability
        :stability: experimental
        """
        return jsii.get(self, "servicePrefix")

    @service_prefix.setter # type: ignore
    def service_prefix(self, value: builtins.str) -> None:
        jsii.set(self, "servicePrefix", value)


class Savingsplans(
    PolicyStatement,
    metaclass=jsii.JSIIMeta,
    jsii_type="iam-floyd.Savingsplans",
):
    """Statement provider for service `savingsplans <https://docs.aws.amazon.com/service-authorization/latest/reference/list_awssavingsplans.html>`_.

    stability
    :stability: experimental
    """

    def __init__(self, sid: typing.Optional[builtins.str] = None) -> None:
        """Statement provider for service `savingsplans <https://docs.aws.amazon.com/service-authorization/latest/reference/list_awssavingsplans.html>`_.

        :param sid: `SID <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html>`_ of the statement.

        stability
        :stability: experimental
        """
        jsii.create(Savingsplans, self, [sid])

    @jsii.member(jsii_name="onSavingsplan")
    def on_savingsplan(
        self,
        resource_id: builtins.str,
        account: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Savingsplans":
        """Adds a resource of type savingsplan to the statement.

        https://docs.aws.amazon.com/savingsplans/latest/userguide/API_SavingsPlan.html

        :param resource_id: - Identifier for the resourceId.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``. Possible conditions: - .ifAwsResourceTag()

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "onSavingsplan", [resource_id, account, partition])

    @jsii.member(jsii_name="toCreateSavingsPlan")
    def to_create_savings_plan(self) -> "Savingsplans":
        """Grants permission to create a savings plan.

        Access Level: Write

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsTagKeys()

        https://docs.aws.amazon.com/savingsplans/latest/APIReference/API_CreateSavingsPlan.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toCreateSavingsPlan", [])

    @jsii.member(jsii_name="toDeleteQueuedSavingsPlan")
    def to_delete_queued_savings_plan(self) -> "Savingsplans":
        """Grants permission to delete the queued savings plan associated with customers account.

        Access Level: Write

        Possible conditions:

        - .ifAwsResourceTag()

        https://docs.aws.amazon.com/savingsplans/latest/APIReference/API_DeleteQueuedSavingsPlan.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDeleteQueuedSavingsPlan", [])

    @jsii.member(jsii_name="toDescribeSavingsPlanRates")
    def to_describe_savings_plan_rates(self) -> "Savingsplans":
        """Grants permission to describe the rates associated with customers savings plan.

        Access Level: Read

        Possible conditions:

        - .ifAwsResourceTag()

        https://docs.aws.amazon.com/savingsplans/latest/APIReference/API_DescribeSavingsPlanRates.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDescribeSavingsPlanRates", [])

    @jsii.member(jsii_name="toDescribeSavingsPlans")
    def to_describe_savings_plans(self) -> "Savingsplans":
        """Grants permission to describe the savings plans associated with customers account.

        Access Level: Read

        Possible conditions:

        - .ifAwsResourceTag()

        https://docs.aws.amazon.com/savingsplans/latest/APIReference/API_DescribeSavingsPlans.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDescribeSavingsPlans", [])

    @jsii.member(jsii_name="toDescribeSavingsPlansOfferingRates")
    def to_describe_savings_plans_offering_rates(self) -> "Savingsplans":
        """Grants permission to describe the rates assciated with savings plans offerings.

        Access Level: Read

        https://docs.aws.amazon.com/savingsplans/latest/APIReference/API_DescribeSavingsPlansOfferingRates.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDescribeSavingsPlansOfferingRates", [])

    @jsii.member(jsii_name="toDescribeSavingsPlansOfferings")
    def to_describe_savings_plans_offerings(self) -> "Savingsplans":
        """Grants permission to describe the savings plans offerings that customer is eligible to purchase.

        Access Level: Read

        https://docs.aws.amazon.com/savingsplans/latest/APIReference/API_DescribeSavingsPlansOfferings.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDescribeSavingsPlansOfferings", [])

    @jsii.member(jsii_name="toListTagsForResource")
    def to_list_tags_for_resource(self) -> "Savingsplans":
        """Grants permission to list tags for a savings plan.

        Access Level: List

        https://docs.aws.amazon.com/savingsplans/latest/APIReference/API_ListTagsForResource.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toListTagsForResource", [])

    @jsii.member(jsii_name="toTagResource")
    def to_tag_resource(self) -> "Savingsplans":
        """Grants permission to tag a savings plan.

        Access Level: Tagging

        Possible conditions:

        - .ifAwsTagKeys()
        - .ifAwsRequestTag()

        https://docs.aws.amazon.com/savingsplans/latest/APIReference/API_TagResource.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toTagResource", [])

    @jsii.member(jsii_name="toUntagResource")
    def to_untag_resource(self) -> "Savingsplans":
        """Grants permission to untag a savings plan.

        Access Level: Tagging

        Possible conditions:

        - .ifAwsTagKeys()

        https://docs.aws.amazon.com/savingsplans/latest/APIReference/API_UntagResource.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toUntagResource", [])

    @builtins.property # type: ignore
    @jsii.member(jsii_name="accessLevelList")
    def _access_level_list(self) -> "AccessLevelList":
        """
        stability
        :stability: experimental
        """
        return jsii.get(self, "accessLevelList")

    @_access_level_list.setter # type: ignore
    def _access_level_list(self, value: "AccessLevelList") -> None:
        jsii.set(self, "accessLevelList", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="servicePrefix")
    def service_prefix(self) -> builtins.str:
        """Holds the prefix of the service actions, e.g. ``ec2``.

        stability
        :stability: experimental
        """
        return jsii.get(self, "servicePrefix")

    @service_prefix.setter # type: ignore
    def service_prefix(self, value: builtins.str) -> None:
        jsii.set(self, "servicePrefix", value)


class Schemas(PolicyStatement, metaclass=jsii.JSIIMeta, jsii_type="iam-floyd.Schemas"):
    """Statement provider for service `schemas <https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazoneventbridgeschemas.html>`_.

    stability
    :stability: experimental
    """

    def __init__(self, sid: typing.Optional[builtins.str] = None) -> None:
        """Statement provider for service `schemas <https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazoneventbridgeschemas.html>`_.

        :param sid: `SID <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html>`_ of the statement.

        stability
        :stability: experimental
        """
        jsii.create(Schemas, self, [sid])

    @jsii.member(jsii_name="onDiscoverer")
    def on_discoverer(
        self,
        discoverer_id: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Schemas":
        """Adds a resource of type discoverer to the statement.

        https://docs.aws.amazon.com/eventbridge/latest/userguide/iam-identity-based-access-control-eventbridge.html

        :param discoverer_id: - Identifier for the discovererId.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``. Possible conditions: - .ifAwsResourceTag()

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "onDiscoverer", [discoverer_id, account, region, partition])

    @jsii.member(jsii_name="onRegistry")
    def on_registry(
        self,
        registry_name: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Schemas":
        """Adds a resource of type registry to the statement.

        https://docs.aws.amazon.com/eventbridge/latest/userguide/iam-identity-based-access-control-eventbridge.html

        :param registry_name: - Identifier for the registryName.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``. Possible conditions: - .ifAwsResourceTag()

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "onRegistry", [registry_name, account, region, partition])

    @jsii.member(jsii_name="onSchema")
    def on_schema(
        self,
        registry_name: builtins.str,
        schema_name: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Schemas":
        """Adds a resource of type schema to the statement.

        https://docs.aws.amazon.com/eventbridge/latest/userguide/iam-identity-based-access-control-eventbridge.html

        :param registry_name: - Identifier for the registryName.
        :param schema_name: - Identifier for the schemaName.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``. Possible conditions: - .ifAwsResourceTag()

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "onSchema", [registry_name, schema_name, account, region, partition])

    @jsii.member(jsii_name="toCreateDiscoverer")
    def to_create_discoverer(self) -> "Schemas":
        """Creates an event schema discoverer. Once created, your events will be automatically map into corresponding schema documents.

        Access Level: Write

        https://docs.aws.amazon.com/eventbridge/latest/schema-reference/v1-discoverers-id-discovererid.html#CreateDiscoverer

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toCreateDiscoverer", [])

    @jsii.member(jsii_name="toCreateRegistry")
    def to_create_registry(self) -> "Schemas":
        """Create a new schema registry in your account.

        Access Level: Write

        https://docs.aws.amazon.com/eventbridge/latest/schema-reference/v1-registries-name-registryname.html#CreateRegistry

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toCreateRegistry", [])

    @jsii.member(jsii_name="toCreateSchema")
    def to_create_schema(self) -> "Schemas":
        """Create a new schema in your account.

        Access Level: Write

        https://docs.aws.amazon.com/eventbridge/latest/schema-reference/v1-registries-name-registryname-schemas-name-schemaname.html#CreateSchema

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toCreateSchema", [])

    @jsii.member(jsii_name="toDeleteDiscoverer")
    def to_delete_discoverer(self) -> "Schemas":
        """Deletes discoverer in your account.

        Access Level: Write

        https://docs.aws.amazon.com/eventbridge/latest/schema-reference/v1-discoverers-id-discovererid.html#DeleteDiscoverer

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDeleteDiscoverer", [])

    @jsii.member(jsii_name="toDeleteRegistry")
    def to_delete_registry(self) -> "Schemas":
        """Deletes an existing registry in your account.

        Access Level: Write

        https://docs.aws.amazon.com/eventbridge/latest/schema-reference/v1-registries-name-registryname.html#DeleteRegistry

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDeleteRegistry", [])

    @jsii.member(jsii_name="toDeleteResourcePolicy")
    def to_delete_resource_policy(self) -> "Schemas":
        """Delete the resource-based policy attached to a given registry.

        Access Level: Write

        https://docs.aws.amazon.com/eventbridge/latest/schema-reference/v1-policy.html#DeleteResourcePolicy

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDeleteResourcePolicy", [])

    @jsii.member(jsii_name="toDeleteSchema")
    def to_delete_schema(self) -> "Schemas":
        """Deletes an existing schema in your account.

        Access Level: Write

        https://docs.aws.amazon.com/eventbridge/latest/schema-reference/v1-registries-name-registryname-schemas-name-schemaname.html#DeleteSchema

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDeleteSchema", [])

    @jsii.member(jsii_name="toDeleteSchemaVersion")
    def to_delete_schema_version(self) -> "Schemas":
        """Deletes a specific version of schema in your account.

        Access Level: Write

        https://docs.aws.amazon.com/eventbridge/latest/schema-reference/v1-registries-name-registryname-schemas-name-schemaname-version-schemaversion.html#DeleteSchemaVersion

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDeleteSchemaVersion", [])

    @jsii.member(jsii_name="toDescribeCodeBinding")
    def to_describe_code_binding(self) -> "Schemas":
        """Retrieves metadata for generated code for specific schema in your account.

        Access Level: Read

        https://docs.aws.amazon.com/eventbridge/latest/schema-reference/v1-registries-name-registryname-schemas-name-schemaname-language-language.html#DescribeCodeBinding

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDescribeCodeBinding", [])

    @jsii.member(jsii_name="toDescribeDiscoverer")
    def to_describe_discoverer(self) -> "Schemas":
        """Retrieves discoverer metadata in your account.

        Access Level: Read

        https://docs.aws.amazon.com/eventbridge/latest/schema-reference/v1-discoverers-id-discovererid.html#DescribeDiscoverer

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDescribeDiscoverer", [])

    @jsii.member(jsii_name="toDescribeRegistry")
    def to_describe_registry(self) -> "Schemas":
        """Describes an existing registry metadata in your account.

        Access Level: Read

        https://docs.aws.amazon.com/eventbridge/latest/schema-reference/v1-registries-name-registryname.html#DescribeRegistry

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDescribeRegistry", [])

    @jsii.member(jsii_name="toDescribeSchema")
    def to_describe_schema(self) -> "Schemas":
        """Retrieves an existing schema in your account.

        Access Level: Read

        https://docs.aws.amazon.com/eventbridge/latest/schema-reference/v1-registries-name-registryname-schemas-name-schemaname.html#DescribeSchema

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDescribeSchema", [])

    @jsii.member(jsii_name="toExportSchema")
    def to_export_schema(self) -> "Schemas":
        """Allows exporting AWS registry or discovered schemas in OpenAPI 3 format to JSONSchema format.

        Access Level: Read

        https://docs.aws.amazon.com/eventbridge/latest/schema-reference/v1-policy.html#ExportSchema

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toExportSchema", [])

    @jsii.member(jsii_name="toGetCodeBindingSource")
    def to_get_code_binding_source(self) -> "Schemas":
        """Retrieves metadata for generated code for specific schema in your account.

        Access Level: Read

        https://docs.aws.amazon.com/eventbridge/latest/schema-reference/v1-registries-name-registryname-schemas-name-schemaname-language-language-source.html#GetCodeBindingSource

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toGetCodeBindingSource", [])

    @jsii.member(jsii_name="toGetDiscoveredSchema")
    def to_get_discovered_schema(self) -> "Schemas":
        """Retrieves schema for the provided list of sample events.

        Access Level: Read

        https://docs.aws.amazon.com/eventbridge/latest/schema-reference/v1-discover.html#GetDiscoveredSchema

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toGetDiscoveredSchema", [])

    @jsii.member(jsii_name="toGetResourcePolicy")
    def to_get_resource_policy(self) -> "Schemas":
        """Retrieves the resource-based policy attached to a given registry.

        Access Level: Read

        https://docs.aws.amazon.com/eventbridge/latest/schema-reference/v1-policy.html#GetResourcePolicy

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toGetResourcePolicy", [])

    @jsii.member(jsii_name="toListDiscoverers")
    def to_list_discoverers(self) -> "Schemas":
        """Lists all the discoverers in your account.

        Access Level: List

        https://docs.aws.amazon.com/eventbridge/latest/schema-reference/v1-discoverers.html#ListDiscoverers

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toListDiscoverers", [])

    @jsii.member(jsii_name="toListRegistries")
    def to_list_registries(self) -> "Schemas":
        """List all discoverers in your account.

        Access Level: List

        https://docs.aws.amazon.com/eventbridge/latest/schema-reference/v1-registries.html#ListRegistries

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toListRegistries", [])

    @jsii.member(jsii_name="toListSchemas")
    def to_list_schemas(self) -> "Schemas":
        """List all schemas.

        Access Level: List

        https://docs.aws.amazon.com/eventbridge/latest/schema-reference/v1-registries-name-registryname-schemas.html#ListSchemas

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toListSchemas", [])

    @jsii.member(jsii_name="toListSchemaVersions")
    def to_list_schema_versions(self) -> "Schemas":
        """List all versions of a schema.

        Access Level: List

        https://docs.aws.amazon.com/eventbridge/latest/schema-reference/v1-registries-name-registryname-schemas-name-schemaname-versions.html#ListSchemaVersions

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toListSchemaVersions", [])

    @jsii.member(jsii_name="toListTagsForResource")
    def to_list_tags_for_resource(self) -> "Schemas":
        """This action lists tags for a resource.

        Access Level: List

        https://docs.aws.amazon.com/eventbridge/latest/schema-reference/tags-resource-arn.html#ListTagsForResource

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toListTagsForResource", [])

    @jsii.member(jsii_name="toPutCodeBinding")
    def to_put_code_binding(self) -> "Schemas":
        """Generates code for specific schema in your account.

        Access Level: Write

        https://docs.aws.amazon.com/eventbridge/latest/schema-reference/v1-registries-name-registryname-schemas-name-schemaname-language-language.html#PutCodeBinding

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toPutCodeBinding", [])

    @jsii.member(jsii_name="toPutResourcePolicy")
    def to_put_resource_policy(self) -> "Schemas":
        """Attach resource-based policy to the specific registry.

        Access Level: Write

        https://docs.aws.amazon.com/eventbridge/latest/schema-reference/v1-policy.html#PutResourcePolicy

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toPutResourcePolicy", [])

    @jsii.member(jsii_name="toSearchSchemas")
    def to_search_schemas(self) -> "Schemas":
        """Searches schemas based on specified keywords in your account.

        Access Level: List

        https://docs.aws.amazon.com/eventbridge/latest/schema-reference/v1-registries-name-registryname-schemas-search.html#SearchSchemas

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toSearchSchemas", [])

    @jsii.member(jsii_name="toStartDiscoverer")
    def to_start_discoverer(self) -> "Schemas":
        """Starts the specified discoverer.

        Once started the discoverer will automatically register schemas for published events to configured source in your account

        Access Level: Write

        https://docs.aws.amazon.com/eventbridge/latest/schema-reference/v1-discoverers-id-discovererid.html#StartDiscoverer

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toStartDiscoverer", [])

    @jsii.member(jsii_name="toStopDiscoverer")
    def to_stop_discoverer(self) -> "Schemas":
        """Starts the specified discoverer.

        Once started the discoverer will automatically register schemas for published events to configured source in your account

        Access Level: Write

        https://docs.aws.amazon.com/eventbridge/latest/schema-reference/v1-discoverers-id-discovererid.html#StopDiscoverer

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toStopDiscoverer", [])

    @jsii.member(jsii_name="toTagResource")
    def to_tag_resource(self) -> "Schemas":
        """This action tags an resource.

        Access Level: Tagging

        Possible conditions:

        - .ifAwsTagKeys()
        - .ifAwsRequestTag()

        https://docs.aws.amazon.com/eventbridge/latest/schema-reference/tags-resource-arn.html#TagResource

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toTagResource", [])

    @jsii.member(jsii_name="toUntagResource")
    def to_untag_resource(self) -> "Schemas":
        """This action removes a tag from on a resource.

        Access Level: Tagging

        Possible conditions:

        - .ifAwsTagKeys()

        https://docs.aws.amazon.com/eventbridge/latest/schema-reference/tags-resource-arn.html#UntagResource

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toUntagResource", [])

    @jsii.member(jsii_name="toUpdateDiscoverer")
    def to_update_discoverer(self) -> "Schemas":
        """Updates an existing discoverer in your account.

        Access Level: Write

        https://docs.aws.amazon.com/eventbridge/latest/schema-reference/v1-discoverers-id-discovererid.html#UpdateDiscoverer

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toUpdateDiscoverer", [])

    @jsii.member(jsii_name="toUpdateRegistry")
    def to_update_registry(self) -> "Schemas":
        """Updates an existing registry metadata in your account.

        Access Level: Write

        https://docs.aws.amazon.com/eventbridge/latest/schema-reference/v1-registries-name-registryname.html#UpdateRegistry

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toUpdateRegistry", [])

    @jsii.member(jsii_name="toUpdateSchema")
    def to_update_schema(self) -> "Schemas":
        """Updates an existing schema in your account.

        Access Level: Write

        https://docs.aws.amazon.com/eventbridge/latest/schema-reference/v1-registries-name-registryname-schemas-name-schemaname.html#UpdateSchema

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toUpdateSchema", [])

    @builtins.property # type: ignore
    @jsii.member(jsii_name="accessLevelList")
    def _access_level_list(self) -> "AccessLevelList":
        """
        stability
        :stability: experimental
        """
        return jsii.get(self, "accessLevelList")

    @_access_level_list.setter # type: ignore
    def _access_level_list(self, value: "AccessLevelList") -> None:
        jsii.set(self, "accessLevelList", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="servicePrefix")
    def service_prefix(self) -> builtins.str:
        """Holds the prefix of the service actions, e.g. ``ec2``.

        stability
        :stability: experimental
        """
        return jsii.get(self, "servicePrefix")

    @service_prefix.setter # type: ignore
    def service_prefix(self, value: builtins.str) -> None:
        jsii.set(self, "servicePrefix", value)


class Sdb(PolicyStatement, metaclass=jsii.JSIIMeta, jsii_type="iam-floyd.Sdb"):
    """Statement provider for service `sdb <https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonsimpledb.html>`_.

    stability
    :stability: experimental
    """

    def __init__(self, sid: typing.Optional[builtins.str] = None) -> None:
        """Statement provider for service `sdb <https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonsimpledb.html>`_.

        :param sid: `SID <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html>`_ of the statement.

        stability
        :stability: experimental
        """
        jsii.create(Sdb, self, [sid])

    @jsii.member(jsii_name="onDomain")
    def on_domain(
        self,
        domain_name: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Sdb":
        """Adds a resource of type domain to the statement.

        https://docs.aws.amazon.com/sdb/latest/APIReference/DataModel.html

        :param domain_name: - Identifier for the domainName.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "onDomain", [domain_name, account, region, partition])

    @jsii.member(jsii_name="toBatchDeleteAttributes")
    def to_batch_delete_attributes(self) -> "Sdb":
        """Performs multiple DeleteAttributes operations in a single call, which reduces round trips and latencies.

        Access Level: Write

        https://docs.aws.amazon.com/AmazonSimpleDB/latest/DeveloperGuide/API_BatchDeleteAttributes.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toBatchDeleteAttributes", [])

    @jsii.member(jsii_name="toBatchPutAttributes")
    def to_batch_put_attributes(self) -> "Sdb":
        """With the BatchPutAttributes operation, you can perform multiple PutAttribute operations in a single call.

        With the BatchPutAttributes operation, you can perform multiple PutAttribute operations in a single call.

        Access Level: Write

        https://docs.aws.amazon.com/AmazonSimpleDB/latest/DeveloperGuide/API_BatchPutAttributes.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toBatchPutAttributes", [])

    @jsii.member(jsii_name="toCreateDomain")
    def to_create_domain(self) -> "Sdb":
        """The CreateDomain operation creates a new domain.

        Access Level: Write

        https://docs.aws.amazon.com/AmazonSimpleDB/latest/DeveloperGuide/API_CreateDomain.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toCreateDomain", [])

    @jsii.member(jsii_name="toDeleteAttributes")
    def to_delete_attributes(self) -> "Sdb":
        """Deletes one or more attributes associated with the item.

        Access Level: Write

        https://docs.aws.amazon.com/AmazonSimpleDB/latest/DeveloperGuide/API_DeleteAttributes.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDeleteAttributes", [])

    @jsii.member(jsii_name="toDeleteDomain")
    def to_delete_domain(self) -> "Sdb":
        """The DeleteDomain operation deletes a domain.

        Access Level: Write

        https://docs.aws.amazon.com/AmazonSimpleDB/latest/DeveloperGuide/API_DeleteDomain.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDeleteDomain", [])

    @jsii.member(jsii_name="toDomainMetadata")
    def to_domain_metadata(self) -> "Sdb":
        """Returns information about the domain, including when the domain was created, the number of items and attributes, and the size of attribute names and values.

        Access Level: Read

        https://docs.aws.amazon.com/AmazonSimpleDB/latest/DeveloperGuide/API_DomainMetadata.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDomainMetadata", [])

    @jsii.member(jsii_name="toGetAttributes")
    def to_get_attributes(self) -> "Sdb":
        """Returns all of the attributes associated with the item.

        Access Level: Read

        https://docs.aws.amazon.com/AmazonSimpleDB/latest/DeveloperGuide/API_GetAttributes.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toGetAttributes", [])

    @jsii.member(jsii_name="toListDomains")
    def to_list_domains(self) -> "Sdb":
        """Description for ListDomains.

        Access Level: List

        https://docs.aws.amazon.com/AmazonSimpleDB/latest/DeveloperGuide/API_ListDomains.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toListDomains", [])

    @jsii.member(jsii_name="toPutAttributes")
    def to_put_attributes(self) -> "Sdb":
        """The PutAttributes operation creates or replaces attributes in an item.

        Access Level: Write

        https://docs.aws.amazon.com/AmazonSimpleDB/latest/DeveloperGuide/API_PutAttributes.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toPutAttributes", [])

    @jsii.member(jsii_name="toSelect")
    def to_select(self) -> "Sdb":
        """Description for Select.

        Access Level: Read

        https://docs.aws.amazon.com/AmazonSimpleDB/latest/DeveloperGuide/API_Select.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toSelect", [])

    @builtins.property # type: ignore
    @jsii.member(jsii_name="accessLevelList")
    def _access_level_list(self) -> "AccessLevelList":
        """
        stability
        :stability: experimental
        """
        return jsii.get(self, "accessLevelList")

    @_access_level_list.setter # type: ignore
    def _access_level_list(self, value: "AccessLevelList") -> None:
        jsii.set(self, "accessLevelList", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="servicePrefix")
    def service_prefix(self) -> builtins.str:
        """Holds the prefix of the service actions, e.g. ``ec2``.

        stability
        :stability: experimental
        """
        return jsii.get(self, "servicePrefix")

    @service_prefix.setter # type: ignore
    def service_prefix(self, value: builtins.str) -> None:
        jsii.set(self, "servicePrefix", value)


class Secretsmanager(
    PolicyStatement,
    metaclass=jsii.JSIIMeta,
    jsii_type="iam-floyd.Secretsmanager",
):
    """Statement provider for service `secretsmanager <https://docs.aws.amazon.com/service-authorization/latest/reference/list_awssecretsmanager.html>`_.

    stability
    :stability: experimental
    """

    def __init__(self, sid: typing.Optional[builtins.str] = None) -> None:
        """Statement provider for service `secretsmanager <https://docs.aws.amazon.com/service-authorization/latest/reference/list_awssecretsmanager.html>`_.

        :param sid: `SID <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html>`_ of the statement.

        stability
        :stability: experimental
        """
        jsii.create(Secretsmanager, self, [sid])

    @jsii.member(jsii_name="ifBlockPublicPolicy")
    def if_block_public_policy(
        self,
        value: typing.Optional[builtins.bool] = None,
    ) -> "Secretsmanager":
        """Filters access by whether the resource policy blocks broad AWS account access.

        https://docs.aws.amazon.com/secretsmanager/latest/userguide/reference_iam-permissions.html#iam-contextkeys

        Applies to actions:

        - .toPutResourcePolicy()

        :param value: ``true`` or ``false``. **Default:** ``true``

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "ifBlockPublicPolicy", [value])

    @jsii.member(jsii_name="ifDescription")
    def if_description(
        self,
        value: typing.Union[builtins.str, typing.List[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, "Operator"]] = None,
    ) -> "Secretsmanager":
        """Filters access by the description text in the request.

        https://docs.aws.amazon.com/secretsmanager/latest/userguide/reference_iam-permissions.html#iam-contextkeys

        Applies to actions:

        - .toCreateSecret()
        - .toUpdateSecret()

        :param value: The value(s) to check.
        :param operator: Works with `string operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String>`_. **Default:** ``StringLike``.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "ifDescription", [value, operator])

    @jsii.member(jsii_name="ifForceDeleteWithoutRecovery")
    def if_force_delete_without_recovery(
        self,
        value: typing.Optional[builtins.bool] = None,
    ) -> "Secretsmanager":
        """Filters access by whether the secret is to be deleted immediately without any recovery window.

        https://docs.aws.amazon.com/secretsmanager/latest/userguide/reference_iam-permissions.html#iam-contextkeys

        Applies to actions:

        - .toDeleteSecret()

        :param value: ``true`` or ``false``. **Default:** ``true``

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "ifForceDeleteWithoutRecovery", [value])

    @jsii.member(jsii_name="ifKmsKeyId")
    def if_kms_key_id(
        self,
        value: typing.Union[builtins.str, typing.List[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, "Operator"]] = None,
    ) -> "Secretsmanager":
        """Filters access by the ARN of the KMS key in the request.

        https://docs.aws.amazon.com/secretsmanager/latest/userguide/reference_iam-permissions.html#iam-contextkeys

        Applies to actions:

        - .toCreateSecret()
        - .toUpdateSecret()

        :param value: The value(s) to check.
        :param operator: Works with `string operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String>`_. **Default:** ``StringLike``.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "ifKmsKeyId", [value, operator])

    @jsii.member(jsii_name="ifName")
    def if_name(
        self,
        value: typing.Union[builtins.str, typing.List[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, "Operator"]] = None,
    ) -> "Secretsmanager":
        """Filters access by the friendly name of the secret in the request.

        https://docs.aws.amazon.com/secretsmanager/latest/userguide/reference_iam-permissions.html#iam-contextkeys

        Applies to actions:

        - .toCreateSecret()

        :param value: The value(s) to check.
        :param operator: Works with `string operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String>`_. **Default:** ``StringLike``.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "ifName", [value, operator])

    @jsii.member(jsii_name="ifRecoveryWindowInDays")
    def if_recovery_window_in_days(
        self,
        value: typing.Union[jsii.Number, typing.List[jsii.Number]],
        operator: typing.Optional[typing.Union[builtins.str, "Operator"]] = None,
    ) -> "Secretsmanager":
        """Filters access by the number of days that Secrets Manager waits before it can delete the secret.

        https://docs.aws.amazon.com/secretsmanager/latest/userguide/reference_iam-permissions.html#iam-contextkeys

        Applies to actions:

        - .toDeleteSecret()

        :param value: The value(s) to check.
        :param operator: Works with `numeric operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_Numeric>`_. **Default:** ``NumericEquals``.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "ifRecoveryWindowInDays", [value, operator])

    @jsii.member(jsii_name="ifResource")
    def if_resource(
        self,
        allow_rotation_lambda_arn: builtins.str,
        value: typing.Union[builtins.str, typing.List[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, "Operator"]] = None,
    ) -> "Secretsmanager":
        """Filters access by the ARN of the rotation Lambda function associated with the secret.

        https://docs.aws.amazon.com/secretsmanager/latest/userguide/reference_iam-permissions.html#iam-contextkeys

        Applies to actions:

        - .toCancelRotateSecret()
        - .toDeleteResourcePolicy()
        - .toDeleteSecret()
        - .toDescribeSecret()
        - .toGetResourcePolicy()
        - .toGetSecretValue()
        - .toListSecretVersionIds()
        - .toPutResourcePolicy()
        - .toPutSecretValue()
        - .toRestoreSecret()
        - .toRotateSecret()
        - .toTagResource()
        - .toUntagResource()
        - .toUpdateSecret()
        - .toUpdateSecretVersionStage()
        - .toValidateResourcePolicy()

        Applies to resource types:

        - Secret

        :param allow_rotation_lambda_arn: The tag key to check.
        :param value: The value(s) to check.
        :param operator: Works with `arn operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_ARN>`_. **Default:** ``ArnLike``.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "ifResource", [allow_rotation_lambda_arn, value, operator])

    @jsii.member(jsii_name="ifResourceTag")
    def if_resource_tag(
        self,
        tagkey: builtins.str,
        value: typing.Union[builtins.str, typing.List[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, "Operator"]] = None,
    ) -> "Secretsmanager":
        """Filters access by a tag key and value pair.

        https://docs.aws.amazon.com/secretsmanager/latest/userguide/reference_iam-permissions.html#iam-contextkeys

        Applies to actions:

        - .toCancelRotateSecret()
        - .toCreateSecret()
        - .toDeleteResourcePolicy()
        - .toDeleteSecret()
        - .toDescribeSecret()
        - .toGetResourcePolicy()
        - .toGetSecretValue()
        - .toListSecretVersionIds()
        - .toPutResourcePolicy()
        - .toPutSecretValue()
        - .toRestoreSecret()
        - .toRotateSecret()
        - .toTagResource()
        - .toUntagResource()
        - .toUpdateSecret()
        - .toUpdateSecretVersionStage()
        - .toValidateResourcePolicy()

        Applies to resource types:

        - Secret

        :param tagkey: The tag key to check.
        :param value: The value(s) to check.
        :param operator: Works with `string operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String>`_. **Default:** ``StringLike``.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "ifResourceTag", [tagkey, value, operator])

    @jsii.member(jsii_name="ifRotationLambdaARN")
    def if_rotation_lambda_arn(
        self,
        value: typing.Union[builtins.str, typing.List[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, "Operator"]] = None,
    ) -> "Secretsmanager":
        """Filters access by the ARN of the rotation Lambda function in the request.

        https://docs.aws.amazon.com/secretsmanager/latest/userguide/reference_iam-permissions.html#iam-contextkeys

        Applies to actions:

        - .toRotateSecret()

        :param value: The value(s) to check.
        :param operator: Works with `arn operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_ARN>`_. **Default:** ``ArnLike``.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "ifRotationLambdaARN", [value, operator])

    @jsii.member(jsii_name="ifSecretId")
    def if_secret_id(
        self,
        value: typing.Union[builtins.str, typing.List[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, "Operator"]] = None,
    ) -> "Secretsmanager":
        """Filters access by the SecretID value in the request.

        https://docs.aws.amazon.com/secretsmanager/latest/userguide/reference_iam-permissions.html#iam-contextkeys

        Applies to actions:

        - .toCancelRotateSecret()
        - .toDeleteResourcePolicy()
        - .toDeleteSecret()
        - .toDescribeSecret()
        - .toGetResourcePolicy()
        - .toGetSecretValue()
        - .toListSecretVersionIds()
        - .toPutResourcePolicy()
        - .toPutSecretValue()
        - .toRestoreSecret()
        - .toRotateSecret()
        - .toTagResource()
        - .toUntagResource()
        - .toUpdateSecret()
        - .toUpdateSecretVersionStage()
        - .toValidateResourcePolicy()

        :param value: The value(s) to check.
        :param operator: Works with `arn operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_ARN>`_. **Default:** ``ArnLike``.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "ifSecretId", [value, operator])

    @jsii.member(jsii_name="ifVersionId")
    def if_version_id(
        self,
        value: typing.Union[builtins.str, typing.List[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, "Operator"]] = None,
    ) -> "Secretsmanager":
        """Filters access by the unique identifier of the version of the secret in the request.

        https://docs.aws.amazon.com/secretsmanager/latest/userguide/reference_iam-permissions.html#iam-contextkeys

        Applies to actions:

        - .toGetSecretValue()

        :param value: The value(s) to check.
        :param operator: Works with `string operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String>`_. **Default:** ``StringLike``.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "ifVersionId", [value, operator])

    @jsii.member(jsii_name="ifVersionStage")
    def if_version_stage(
        self,
        value: typing.Union[builtins.str, typing.List[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, "Operator"]] = None,
    ) -> "Secretsmanager":
        """Filters access by the list of version stages in the request.

        https://docs.aws.amazon.com/secretsmanager/latest/userguide/reference_iam-permissions.html#iam-contextkeys

        Applies to actions:

        - .toGetSecretValue()
        - .toUpdateSecretVersionStage()

        :param value: The value(s) to check.
        :param operator: Works with `string operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String>`_. **Default:** ``StringLike``.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "ifVersionStage", [value, operator])

    @jsii.member(jsii_name="onSecret")
    def on_secret(
        self,
        secret_id: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Secretsmanager":
        """Adds a resource of type Secret to the statement.

        https://docs.aws.amazon.com/secretsmanager/latest/userguide/reference_iam-permissions.html#iam-resources

        :param secret_id: - Identifier for the secretId.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``. Possible conditions: - .ifAwsRequestTag() - .ifAwsTagKeys() - .ifResourceTag() - .ifResource()

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "onSecret", [secret_id, account, region, partition])

    @jsii.member(jsii_name="toCancelRotateSecret")
    def to_cancel_rotate_secret(self) -> "Secretsmanager":
        """Enables the user to cancel an in-progress secret rotation.

        Access Level: Write

        Possible conditions:

        - .ifSecretId()
        - .ifResource()
        - .ifResourceTag()

        https://docs.aws.amazon.com/secretsmanager/latest/userguide/reference_iam-permissions.html#iam-actions

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toCancelRotateSecret", [])

    @jsii.member(jsii_name="toCreateSecret")
    def to_create_secret(self) -> "Secretsmanager":
        """Enables the user to create a secret that stores encrypted data that can be queried and rotated.

        Access Level: Write

        Possible conditions:

        - .ifName()
        - .ifDescription()
        - .ifKmsKeyId()
        - .ifAwsRequestTag()
        - .ifAwsTagKeys()
        - .ifResourceTag()

        https://docs.aws.amazon.com/secretsmanager/latest/userguide/reference_iam-permissions.html#iam-actions

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toCreateSecret", [])

    @jsii.member(jsii_name="toDeleteResourcePolicy")
    def to_delete_resource_policy(self) -> "Secretsmanager":
        """Enables the user to delete the resource policy attached to a secret.

        Access Level: Permissions management

        Possible conditions:

        - .ifSecretId()
        - .ifResource()
        - .ifResourceTag()

        https://docs.aws.amazon.com/secretsmanager/latest/userguide/reference_iam-permissions.html#iam-actions

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDeleteResourcePolicy", [])

    @jsii.member(jsii_name="toDeleteSecret")
    def to_delete_secret(self) -> "Secretsmanager":
        """Enables the user to delete a secret.

        Access Level: Write

        Possible conditions:

        - .ifSecretId()
        - .ifResource()
        - .ifRecoveryWindowInDays()
        - .ifForceDeleteWithoutRecovery()
        - .ifResourceTag()

        https://docs.aws.amazon.com/secretsmanager/latest/userguide/reference_iam-permissions.html#iam-actions

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDeleteSecret", [])

    @jsii.member(jsii_name="toDescribeSecret")
    def to_describe_secret(self) -> "Secretsmanager":
        """Enables the user to retrieve the metadata about a secret, but not the encrypted data.

        Access Level: Read

        Possible conditions:

        - .ifSecretId()
        - .ifResource()
        - .ifResourceTag()

        https://docs.aws.amazon.com/secretsmanager/latest/userguide/reference_iam-permissions.html#iam-actions

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDescribeSecret", [])

    @jsii.member(jsii_name="toGetRandomPassword")
    def to_get_random_password(self) -> "Secretsmanager":
        """Enables the user to generate a random string for use in password creation.

        Access Level: Read

        https://docs.aws.amazon.com/secretsmanager/latest/userguide/reference_iam-permissions.html#iam-actions

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toGetRandomPassword", [])

    @jsii.member(jsii_name="toGetResourcePolicy")
    def to_get_resource_policy(self) -> "Secretsmanager":
        """Enables the user to get the resource policy attached to a secret.

        Access Level: Read

        Possible conditions:

        - .ifSecretId()
        - .ifResource()
        - .ifResourceTag()

        https://docs.aws.amazon.com/secretsmanager/latest/userguide/reference_iam-permissions.html#iam-actions

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toGetResourcePolicy", [])

    @jsii.member(jsii_name="toGetSecretValue")
    def to_get_secret_value(self) -> "Secretsmanager":
        """Enables the user to retrieve and decrypt the encrypted data.

        Access Level: Read

        Possible conditions:

        - .ifSecretId()
        - .ifVersionId()
        - .ifVersionStage()
        - .ifResource()
        - .ifResourceTag()

        https://docs.aws.amazon.com/secretsmanager/latest/userguide/reference_iam-permissions.html#iam-actions

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toGetSecretValue", [])

    @jsii.member(jsii_name="toListSecrets")
    def to_list_secrets(self) -> "Secretsmanager":
        """Enables the user to list the available secrets.

        Access Level: List

        https://docs.aws.amazon.com/secretsmanager/latest/userguide/reference_iam-permissions.html#iam-actions

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toListSecrets", [])

    @jsii.member(jsii_name="toListSecretVersionIds")
    def to_list_secret_version_ids(self) -> "Secretsmanager":
        """Enables the user to list the available versions of a secret.

        Access Level: Read

        Possible conditions:

        - .ifSecretId()
        - .ifResource()
        - .ifResourceTag()

        https://docs.aws.amazon.com/secretsmanager/latest/userguide/reference_iam-permissions.html#iam-actions

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toListSecretVersionIds", [])

    @jsii.member(jsii_name="toPutResourcePolicy")
    def to_put_resource_policy(self) -> "Secretsmanager":
        """Enables the user to attach a resource policy to a secret.

        Access Level: Permissions management

        Possible conditions:

        - .ifSecretId()
        - .ifResource()
        - .ifResourceTag()
        - .ifBlockPublicPolicy()

        https://docs.aws.amazon.com/secretsmanager/latest/userguide/reference_iam-permissions.html#iam-actions

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toPutResourcePolicy", [])

    @jsii.member(jsii_name="toPutSecretValue")
    def to_put_secret_value(self) -> "Secretsmanager":
        """Enables the user to create a new version of the secret with new encrypted data.

        Access Level: Write

        Possible conditions:

        - .ifSecretId()
        - .ifResource()
        - .ifResourceTag()

        https://docs.aws.amazon.com/secretsmanager/latest/userguide/reference_iam-permissions.html#iam-actions

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toPutSecretValue", [])

    @jsii.member(jsii_name="toRestoreSecret")
    def to_restore_secret(self) -> "Secretsmanager":
        """Enables the user to cancel deletion of a secret.

        Access Level: Write

        Possible conditions:

        - .ifSecretId()
        - .ifResource()
        - .ifResourceTag()

        https://docs.aws.amazon.com/secretsmanager/latest/userguide/reference_iam-permissions.html#iam-actions

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toRestoreSecret", [])

    @jsii.member(jsii_name="toRotateSecret")
    def to_rotate_secret(self) -> "Secretsmanager":
        """Enables the user to start rotation of a secret.

        Access Level: Write

        Possible conditions:

        - .ifSecretId()
        - .ifRotationLambdaARN()
        - .ifResource()
        - .ifResourceTag()

        https://docs.aws.amazon.com/secretsmanager/latest/userguide/reference_iam-permissions.html#iam-actions

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toRotateSecret", [])

    @jsii.member(jsii_name="toTagResource")
    def to_tag_resource(self) -> "Secretsmanager":
        """Enables the user to add tags to a secret.

        Access Level: Tagging

        Possible conditions:

        - .ifSecretId()
        - .ifAwsRequestTag()
        - .ifAwsTagKeys()
        - .ifResource()
        - .ifResourceTag()

        https://docs.aws.amazon.com/secretsmanager/latest/userguide/reference_iam-permissions.html#iam-actions

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toTagResource", [])

    @jsii.member(jsii_name="toUntagResource")
    def to_untag_resource(self) -> "Secretsmanager":
        """Enables the user to remove tags from a secret.

        Access Level: Tagging

        Possible conditions:

        - .ifSecretId()
        - .ifAwsTagKeys()
        - .ifResource()
        - .ifResourceTag()

        https://docs.aws.amazon.com/secretsmanager/latest/userguide/reference_iam-permissions.html#iam-actions

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toUntagResource", [])

    @jsii.member(jsii_name="toUpdateSecret")
    def to_update_secret(self) -> "Secretsmanager":
        """Enables the user to update a secret with new metadata or with a new version of the encrypted data.

        Access Level: Write

        Possible conditions:

        - .ifSecretId()
        - .ifDescription()
        - .ifKmsKeyId()
        - .ifResource()
        - .ifResourceTag()

        https://docs.aws.amazon.com/secretsmanager/latest/userguide/reference_iam-permissions.html#iam-actions

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toUpdateSecret", [])

    @jsii.member(jsii_name="toUpdateSecretVersionStage")
    def to_update_secret_version_stage(self) -> "Secretsmanager":
        """Enables the user to move a stage from one secret to another.

        Access Level: Write

        Possible conditions:

        - .ifSecretId()
        - .ifVersionStage()
        - .ifResource()
        - .ifResourceTag()

        https://docs.aws.amazon.com/secretsmanager/latest/userguide/reference_iam-permissions.html#iam-actions

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toUpdateSecretVersionStage", [])

    @jsii.member(jsii_name="toValidateResourcePolicy")
    def to_validate_resource_policy(self) -> "Secretsmanager":
        """Enables the user to validate a resource policy before attaching policy.

        Access Level: Permissions management

        Possible conditions:

        - .ifSecretId()
        - .ifResource()
        - .ifResourceTag()

        https://docs.aws.amazon.com/secretsmanager/latest/userguide/reference_iam-permissions.html#iam-actions

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toValidateResourcePolicy", [])

    @builtins.property # type: ignore
    @jsii.member(jsii_name="accessLevelList")
    def _access_level_list(self) -> "AccessLevelList":
        """
        stability
        :stability: experimental
        """
        return jsii.get(self, "accessLevelList")

    @_access_level_list.setter # type: ignore
    def _access_level_list(self, value: "AccessLevelList") -> None:
        jsii.set(self, "accessLevelList", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="servicePrefix")
    def service_prefix(self) -> builtins.str:
        """Holds the prefix of the service actions, e.g. ``ec2``.

        stability
        :stability: experimental
        """
        return jsii.get(self, "servicePrefix")

    @service_prefix.setter # type: ignore
    def service_prefix(self, value: builtins.str) -> None:
        jsii.set(self, "servicePrefix", value)


class Securityhub(
    PolicyStatement,
    metaclass=jsii.JSIIMeta,
    jsii_type="iam-floyd.Securityhub",
):
    """Statement provider for service `securityhub <https://docs.aws.amazon.com/service-authorization/latest/reference/list_awssecurityhub.html>`_.

    stability
    :stability: experimental
    """

    def __init__(self, sid: typing.Optional[builtins.str] = None) -> None:
        """Statement provider for service `securityhub <https://docs.aws.amazon.com/service-authorization/latest/reference/list_awssecurityhub.html>`_.

        :param sid: `SID <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html>`_ of the statement.

        stability
        :stability: experimental
        """
        jsii.create(Securityhub, self, [sid])

    @jsii.member(jsii_name="ifASFFSyntaxPath")
    def if_asff_syntax_path(
        self,
        a_sff_syntax_path: builtins.str,
        value: typing.Union[builtins.str, typing.List[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, "Operator"]] = None,
    ) -> "Securityhub":
        """Filters access based on the presence of specific fields and values in the request.

        https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-asffsyntaxpath

        Applies to actions:

        - .toBatchUpdateFindings()

        :param a_sff_syntax_path: The tag key to check.
        :param value: The value(s) to check.
        :param operator: Works with `string operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String>`_. **Default:** ``StringLike``.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "ifASFFSyntaxPath", [a_sff_syntax_path, value, operator])

    @jsii.member(jsii_name="ifTargetAccount")
    def if_target_account(
        self,
        value: typing.Union[builtins.str, typing.List[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, "Operator"]] = None,
    ) -> "Securityhub":
        """Filters access based on the presence of AwsAccountId field in the requests.

        https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-access.html#conditions

        Applies to actions:

        - .toBatchImportFindings()

        :param value: The value(s) to check.
        :param operator: Works with `string operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String>`_. **Default:** ``StringLike``.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "ifTargetAccount", [value, operator])

    @jsii.member(jsii_name="onHub")
    def on_hub(
        self,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Securityhub":
        """Adds a resource of type hub to the statement.

        https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-access.html#resources

        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``. Possible conditions: - .ifAwsResourceTag()

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "onHub", [account, region, partition])

    @jsii.member(jsii_name="onProduct")
    def on_product(
        self,
        company: builtins.str,
        product_id: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Securityhub":
        """Adds a resource of type product to the statement.

        https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-access.html#resources

        :param company: - Identifier for the company.
        :param product_id: - Identifier for the productId.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "onProduct", [company, product_id, account, region, partition])

    @jsii.member(jsii_name="toAcceptInvitation")
    def to_accept_invitation(self) -> "Securityhub":
        """Grants permission to accept Security Hub invitations to become a member account.

        Access Level: Write

        https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_AcceptInvitation.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toAcceptInvitation", [])

    @jsii.member(jsii_name="toBatchDisableStandards")
    def to_batch_disable_standards(self) -> "Securityhub":
        """Grants permission to disable standards in Security Hub.

        Access Level: Write

        https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_BatchDisableStandards.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toBatchDisableStandards", [])

    @jsii.member(jsii_name="toBatchEnableStandards")
    def to_batch_enable_standards(self) -> "Securityhub":
        """Grants permission to enable standards in Security Hub.

        Access Level: Write

        https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_BatchEnableStandards.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toBatchEnableStandards", [])

    @jsii.member(jsii_name="toBatchImportFindings")
    def to_batch_import_findings(self) -> "Securityhub":
        """Grants permission to import findings into Security Hub from an integrated product.

        Access Level: Write

        Possible conditions:

        - .ifTargetAccount()

        https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_BatchImportFindings.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toBatchImportFindings", [])

    @jsii.member(jsii_name="toBatchUpdateFindings")
    def to_batch_update_findings(self) -> "Securityhub":
        """Grants permission to update customer-controlled fields for a selected set of Security Hub findings.

        Access Level: Write

        Possible conditions:

        - .ifASFFSyntaxPath()

        https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_BatchUpdateFindings.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toBatchUpdateFindings", [])

    @jsii.member(jsii_name="toCreateActionTarget")
    def to_create_action_target(self) -> "Securityhub":
        """Grants permission to create custom actions in Security Hub.

        Access Level: Write

        https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_CreateActionTarget.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toCreateActionTarget", [])

    @jsii.member(jsii_name="toCreateInsight")
    def to_create_insight(self) -> "Securityhub":
        """Grants permission to create insights in Security Hub. Insights are collections of related findings.

        Access Level: Write

        https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_CreateInsight.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toCreateInsight", [])

    @jsii.member(jsii_name="toCreateMembers")
    def to_create_members(self) -> "Securityhub":
        """Grants permission to create member accounts in Security Hub.

        Access Level: Write

        https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_CreateMembers.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toCreateMembers", [])

    @jsii.member(jsii_name="toDeclineInvitations")
    def to_decline_invitations(self) -> "Securityhub":
        """Grants permission to decline Security Hub invitations to become a member account.

        Access Level: Write

        https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_DeclineInvitations.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDeclineInvitations", [])

    @jsii.member(jsii_name="toDeleteActionTarget")
    def to_delete_action_target(self) -> "Securityhub":
        """Grants permission to delete custom actions in Security Hub.

        Access Level: Write

        https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_DeleteActionTarget.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDeleteActionTarget", [])

    @jsii.member(jsii_name="toDeleteInsight")
    def to_delete_insight(self) -> "Securityhub":
        """Grants permission to delete insights from Security Hub.

        Access Level: Write

        https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_DeleteInsight.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDeleteInsight", [])

    @jsii.member(jsii_name="toDeleteInvitations")
    def to_delete_invitations(self) -> "Securityhub":
        """Grants permission to delete Security Hub invitations to become a member account.

        Access Level: Write

        https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_DeleteInvitations.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDeleteInvitations", [])

    @jsii.member(jsii_name="toDeleteMembers")
    def to_delete_members(self) -> "Securityhub":
        """Grants permission to delete Security Hub member accounts.

        Access Level: Write

        https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_DeleteMembers.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDeleteMembers", [])

    @jsii.member(jsii_name="toDescribeActionTargets")
    def to_describe_action_targets(self) -> "Securityhub":
        """Grants permission to retrieve a list of custom actions using the API.

        Access Level: Read

        https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_DescribeActionTargets.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDescribeActionTargets", [])

    @jsii.member(jsii_name="toDescribeHub")
    def to_describe_hub(self) -> "Securityhub":
        """Grants permission to retrieve information about the hub resource in your account.

        Access Level: Read

        https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_DescribeHub.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDescribeHub", [])

    @jsii.member(jsii_name="toDescribeProducts")
    def to_describe_products(self) -> "Securityhub":
        """Grants permission to retrieve information about the available Security Hub product integrations.

        Access Level: Read

        https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_DescribeProducts.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDescribeProducts", [])

    @jsii.member(jsii_name="toDescribeStandards")
    def to_describe_standards(self) -> "Securityhub":
        """Grants permission to retrieve information about Security Hub standards.

        Access Level: Read

        https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_DescribeStandards.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDescribeStandards", [])

    @jsii.member(jsii_name="toDescribeStandardsControls")
    def to_describe_standards_controls(self) -> "Securityhub":
        """Grants permission to retrieve information about Security Hub standards controls.

        Access Level: Read

        https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_DescribeStandardsControls.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDescribeStandardsControls", [])

    @jsii.member(jsii_name="toDisableImportFindingsForProduct")
    def to_disable_import_findings_for_product(self) -> "Securityhub":
        """Grants permission to disable the findings importing for a Security Hub integrated product.

        Access Level: Write

        https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_DisableImportFindingsForProduct.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDisableImportFindingsForProduct", [])

    @jsii.member(jsii_name="toDisableSecurityHub")
    def to_disable_security_hub(self) -> "Securityhub":
        """Grants permission to disable Security Hub.

        Access Level: Write

        https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_DisableSecurityHub.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDisableSecurityHub", [])

    @jsii.member(jsii_name="toDisassociateFromMasterAccount")
    def to_disassociate_from_master_account(self) -> "Securityhub":
        """Grants permission to a Security Hub member account to disassociate from the associated master account.

        Access Level: Write

        https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_DisassociateFromMasterAccount.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDisassociateFromMasterAccount", [])

    @jsii.member(jsii_name="toDisassociateMembers")
    def to_disassociate_members(self) -> "Securityhub":
        """Grants permission to disassociate Security Hub member accounts from the associated master account.

        Access Level: Write

        https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_DisassociateMembers.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDisassociateMembers", [])

    @jsii.member(jsii_name="toEnableImportFindingsForProduct")
    def to_enable_import_findings_for_product(self) -> "Securityhub":
        """Grants permission to enable the findings importing for a Security Hub integrated product.

        Access Level: Write

        https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_EnableImportFindingsForProduct.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toEnableImportFindingsForProduct", [])

    @jsii.member(jsii_name="toEnableSecurityHub")
    def to_enable_security_hub(self) -> "Securityhub":
        """Grants permission to enable Security Hub.

        Access Level: Write

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsTagKeys()

        https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_EnableSecurityHub.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toEnableSecurityHub", [])

    @jsii.member(jsii_name="toGetEnabledStandards")
    def to_get_enabled_standards(self) -> "Securityhub":
        """Grants permission to retrieve a list of the standards that are enabled in Security Hub.

        Access Level: List

        https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_GetEnabledStandards.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toGetEnabledStandards", [])

    @jsii.member(jsii_name="toGetFindings")
    def to_get_findings(self) -> "Securityhub":
        """Grants permission to retrieve a list of findings from Security Hub.

        Access Level: Read

        https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_GetFindings.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toGetFindings", [])

    @jsii.member(jsii_name="toGetInsightResults")
    def to_get_insight_results(self) -> "Securityhub":
        """Grants permission to retrieve insight results from Security Hub.

        Access Level: Read

        https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_GetInsightResults.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toGetInsightResults", [])

    @jsii.member(jsii_name="toGetInsights")
    def to_get_insights(self) -> "Securityhub":
        """Grants permission to retrieve Security Hub insights.

        Access Level: List

        https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_GetInsights.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toGetInsights", [])

    @jsii.member(jsii_name="toGetInvitationsCount")
    def to_get_invitations_count(self) -> "Securityhub":
        """Grants permission to retrieve the count of Security Hub membership invitations sent to the account.

        Access Level: Read

        https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_GetInvitationsCount.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toGetInvitationsCount", [])

    @jsii.member(jsii_name="toGetMasterAccount")
    def to_get_master_account(self) -> "Securityhub":
        """Grants permission to retrieve details about the Security Hub master account.

        Access Level: Read

        https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_GetMasterAccount.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toGetMasterAccount", [])

    @jsii.member(jsii_name="toGetMembers")
    def to_get_members(self) -> "Securityhub":
        """Grants permission to retrieve the details of Security Hub member accounts.

        Access Level: Read

        https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_GetMembers.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toGetMembers", [])

    @jsii.member(jsii_name="toInviteMembers")
    def to_invite_members(self) -> "Securityhub":
        """Grants permission to invite other AWS accounts to become Security Hub member accounts.

        Access Level: Write

        https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_InviteMembers.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toInviteMembers", [])

    @jsii.member(jsii_name="toListEnabledProductsForImport")
    def to_list_enabled_products_for_import(self) -> "Securityhub":
        """Grants permission to retrieve the Security Hub integrated products that are currently enabled.

        Access Level: List

        https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_ListEnabledProductsForImport.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toListEnabledProductsForImport", [])

    @jsii.member(jsii_name="toListInvitations")
    def to_list_invitations(self) -> "Securityhub":
        """Grants permission to retrieve the Security Hub invitations sent to the account.

        Access Level: List

        https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_ListInvitations.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toListInvitations", [])

    @jsii.member(jsii_name="toListMembers")
    def to_list_members(self) -> "Securityhub":
        """Grants permission to retrieve details about Security Hub member accounts associated with the master account.

        Access Level: List

        https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_ListMembers.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toListMembers", [])

    @jsii.member(jsii_name="toListTagsForResource")
    def to_list_tags_for_resource(self) -> "Securityhub":
        """Grants permission to list of tags associated with a resource.

        Access Level: List

        https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_ListTagsForResource.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toListTagsForResource", [])

    @jsii.member(jsii_name="toTagResource")
    def to_tag_resource(self) -> "Securityhub":
        """Grants permission to add tags to a Security Hub resource.

        Access Level: Write

        https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_TagResource.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toTagResource", [])

    @jsii.member(jsii_name="toUntagResource")
    def to_untag_resource(self) -> "Securityhub":
        """Grants permission to remove tags from a Security Hub resource.

        Access Level: Write

        https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_UntagResource.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toUntagResource", [])

    @jsii.member(jsii_name="toUpdateActionTarget")
    def to_update_action_target(self) -> "Securityhub":
        """Grants permission to update custom actions in Security Hub.

        Access Level: Write

        https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_UpdateActionTarget.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toUpdateActionTarget", [])

    @jsii.member(jsii_name="toUpdateFindings")
    def to_update_findings(self) -> "Securityhub":
        """Grants permission to update Security Hub findings.

        Access Level: Write

        https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_UpdateFindings.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toUpdateFindings", [])

    @jsii.member(jsii_name="toUpdateInsight")
    def to_update_insight(self) -> "Securityhub":
        """Grants permission to update insights in Security Hub.

        Access Level: Write

        https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_UpdateInsight.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toUpdateInsight", [])

    @jsii.member(jsii_name="toUpdateSecurityHubConfiguration")
    def to_update_security_hub_configuration(self) -> "Securityhub":
        """Grants permission to update Security Hub configuration.

        Access Level: Write

        https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_UpdateSecurityHubConfiguration.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toUpdateSecurityHubConfiguration", [])

    @jsii.member(jsii_name="toUpdateStandardsControl")
    def to_update_standards_control(self) -> "Securityhub":
        """Grants permission to update Security Hub standards controls.

        Access Level: Write

        https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_UpdateStandardsControl.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toUpdateStandardsControl", [])

    @builtins.property # type: ignore
    @jsii.member(jsii_name="accessLevelList")
    def _access_level_list(self) -> "AccessLevelList":
        """
        stability
        :stability: experimental
        """
        return jsii.get(self, "accessLevelList")

    @_access_level_list.setter # type: ignore
    def _access_level_list(self, value: "AccessLevelList") -> None:
        jsii.set(self, "accessLevelList", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="servicePrefix")
    def service_prefix(self) -> builtins.str:
        """Holds the prefix of the service actions, e.g. ``ec2``.

        stability
        :stability: experimental
        """
        return jsii.get(self, "servicePrefix")

    @service_prefix.setter # type: ignore
    def service_prefix(self, value: builtins.str) -> None:
        jsii.set(self, "servicePrefix", value)


class Serverlessrepo(
    PolicyStatement,
    metaclass=jsii.JSIIMeta,
    jsii_type="iam-floyd.Serverlessrepo",
):
    """Statement provider for service `serverlessrepo <https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsserverlessapplicationrepository.html>`_.

    stability
    :stability: experimental
    """

    def __init__(self, sid: typing.Optional[builtins.str] = None) -> None:
        """Statement provider for service `serverlessrepo <https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsserverlessapplicationrepository.html>`_.

        :param sid: `SID <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html>`_ of the statement.

        stability
        :stability: experimental
        """
        jsii.create(Serverlessrepo, self, [sid])

    @jsii.member(jsii_name="ifApplicationType")
    def if_application_type(
        self,
        value: typing.Union[builtins.str, typing.List[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, "Operator"]] = None,
    ) -> "Serverlessrepo":
        """Application type.

        Applies to actions:

        - .toCreateCloudFormationChangeSet()
        - .toCreateCloudFormationTemplate()
        - .toGetApplication()
        - .toListApplicationDependencies()
        - .toListApplicationVersions()
        - .toSearchApplications()

        :param value: The value(s) to check.
        :param operator: Works with `string operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String>`_. **Default:** ``StringLike``.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "ifApplicationType", [value, operator])

    @jsii.member(jsii_name="onApplications")
    def on_applications(
        self,
        resource_id: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Serverlessrepo":
        """Adds a resource of type applications to the statement.

        :param resource_id: - Identifier for the resourceId.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "onApplications", [resource_id, account, region, partition])

    @jsii.member(jsii_name="toCreateApplication")
    def to_create_application(self) -> "Serverlessrepo":
        """Creates an application, optionally including an AWS SAM file to create the first application version in the same call.

        Access Level: Write

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toCreateApplication", [])

    @jsii.member(jsii_name="toCreateApplicationVersion")
    def to_create_application_version(self) -> "Serverlessrepo":
        """Creates an application version.

        Access Level: Write

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toCreateApplicationVersion", [])

    @jsii.member(jsii_name="toCreateCloudFormationChangeSet")
    def to_create_cloud_formation_change_set(self) -> "Serverlessrepo":
        """Creates an AWS CloudFormation ChangeSet for the given application.

        Access Level: Write

        Possible conditions:

        - .ifApplicationType()

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toCreateCloudFormationChangeSet", [])

    @jsii.member(jsii_name="toCreateCloudFormationTemplate")
    def to_create_cloud_formation_template(self) -> "Serverlessrepo":
        """Creates an AWS CloudFormation template.

        Access Level: Write

        Possible conditions:

        - .ifApplicationType()

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toCreateCloudFormationTemplate", [])

    @jsii.member(jsii_name="toDeleteApplication")
    def to_delete_application(self) -> "Serverlessrepo":
        """Deletes the specified application.

        Access Level: Write

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDeleteApplication", [])

    @jsii.member(jsii_name="toGetApplication")
    def to_get_application(self) -> "Serverlessrepo":
        """Gets the specified application.

        Access Level: Read

        Possible conditions:

        - .ifApplicationType()

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toGetApplication", [])

    @jsii.member(jsii_name="toGetApplicationPolicy")
    def to_get_application_policy(self) -> "Serverlessrepo":
        """Gets the policy for the specified application.

        Access Level: Read

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toGetApplicationPolicy", [])

    @jsii.member(jsii_name="toGetCloudFormationTemplate")
    def to_get_cloud_formation_template(self) -> "Serverlessrepo":
        """Gets the specified AWS CloudFormation template.

        Access Level: Read

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toGetCloudFormationTemplate", [])

    @jsii.member(jsii_name="toListApplicationDependencies")
    def to_list_application_dependencies(self) -> "Serverlessrepo":
        """Retrieves the list of applications nested in the containing application.

        Access Level: List

        Possible conditions:

        - .ifApplicationType()

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toListApplicationDependencies", [])

    @jsii.member(jsii_name="toListApplications")
    def to_list_applications(self) -> "Serverlessrepo":
        """Lists applications owned by the requester.

        Access Level: List

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toListApplications", [])

    @jsii.member(jsii_name="toListApplicationVersions")
    def to_list_application_versions(self) -> "Serverlessrepo":
        """Lists versions for the specified application owned by the requester.

        Access Level: List

        Possible conditions:

        - .ifApplicationType()

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toListApplicationVersions", [])

    @jsii.member(jsii_name="toPutApplicationPolicy")
    def to_put_application_policy(self) -> "Serverlessrepo":
        """Puts the policy for the specified application.

        Access Level: Write

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toPutApplicationPolicy", [])

    @jsii.member(jsii_name="toSearchApplications")
    def to_search_applications(self) -> "Serverlessrepo":
        """Gets all applications authorized for this user.

        Access Level: Read

        Possible conditions:

        - .ifApplicationType()

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toSearchApplications", [])

    @jsii.member(jsii_name="toUnshareApplication")
    def to_unshare_application(self) -> "Serverlessrepo":
        """Unshares the specified application.

        Access Level: Write

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toUnshareApplication", [])

    @jsii.member(jsii_name="toUpdateApplication")
    def to_update_application(self) -> "Serverlessrepo":
        """Updates meta-data of the application.

        Access Level: Write

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toUpdateApplication", [])

    @builtins.property # type: ignore
    @jsii.member(jsii_name="accessLevelList")
    def _access_level_list(self) -> "AccessLevelList":
        """
        stability
        :stability: experimental
        """
        return jsii.get(self, "accessLevelList")

    @_access_level_list.setter # type: ignore
    def _access_level_list(self, value: "AccessLevelList") -> None:
        jsii.set(self, "accessLevelList", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="servicePrefix")
    def service_prefix(self) -> builtins.str:
        """Holds the prefix of the service actions, e.g. ``ec2``.

        stability
        :stability: experimental
        """
        return jsii.get(self, "servicePrefix")

    @service_prefix.setter # type: ignore
    def service_prefix(self, value: builtins.str) -> None:
        jsii.set(self, "servicePrefix", value)


class Servicecatalog(
    PolicyStatement,
    metaclass=jsii.JSIIMeta,
    jsii_type="iam-floyd.Servicecatalog",
):
    """Statement provider for service `servicecatalog <https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsservicecatalog.html>`_.

    stability
    :stability: experimental
    """

    def __init__(self, sid: typing.Optional[builtins.str] = None) -> None:
        """Statement provider for service `servicecatalog <https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsservicecatalog.html>`_.

        :param sid: `SID <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html>`_ of the statement.

        stability
        :stability: experimental
        """
        jsii.create(Servicecatalog, self, [sid])

    @jsii.member(jsii_name="ifAccountLevel")
    def if_account_level(
        self,
        value: typing.Union[builtins.str, typing.List[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, "Operator"]] = None,
    ) -> "Servicecatalog":
        """Filters users to see and perform actions on resources created by anyone in the account.

        https://docs.aws.amazon.com/servicecatalog/latest/adminguide/permissions-examples.html

        Applies to actions:

        - .toDescribeRecord()
        - .toListRecordHistory()
        - .toScanProvisionedProducts()
        - .toSearchProvisionedProducts()
        - .toTerminateProvisionedProduct()
        - .toUpdateProvisionedProduct()

        :param value: The value(s) to check.
        :param operator: Works with `string operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String>`_. **Default:** ``StringLike``.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "ifAccountLevel", [value, operator])

    @jsii.member(jsii_name="ifRoleLevel")
    def if_role_level(
        self,
        value: typing.Union[builtins.str, typing.List[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, "Operator"]] = None,
    ) -> "Servicecatalog":
        """Filters users to see and perform actions on resources created either by them or by anyone federating into the same role as them.

        https://docs.aws.amazon.com/servicecatalog/latest/adminguide/permissions-examples.html

        Applies to actions:

        - .toDescribeRecord()
        - .toListRecordHistory()
        - .toScanProvisionedProducts()
        - .toSearchProvisionedProducts()
        - .toTerminateProvisionedProduct()
        - .toUpdateProvisionedProduct()

        :param value: The value(s) to check.
        :param operator: Works with `string operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String>`_. **Default:** ``StringLike``.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "ifRoleLevel", [value, operator])

    @jsii.member(jsii_name="ifUserLevel")
    def if_user_level(
        self,
        value: typing.Union[builtins.str, typing.List[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, "Operator"]] = None,
    ) -> "Servicecatalog":
        """Filters users to see and perform actions on only resources that they created.

        https://docs.aws.amazon.com/servicecatalog/latest/adminguide/permissions-examples.html

        Applies to actions:

        - .toDescribeRecord()
        - .toListRecordHistory()
        - .toScanProvisionedProducts()
        - .toSearchProvisionedProducts()
        - .toTerminateProvisionedProduct()
        - .toUpdateProvisionedProduct()

        :param value: The value(s) to check.
        :param operator: Works with `string operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String>`_. **Default:** ``StringLike``.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "ifUserLevel", [value, operator])

    @jsii.member(jsii_name="onApplication")
    def on_application(
        self,
        application_id: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Servicecatalog":
        """Adds a resource of type Application to the statement.

        https://docs.aws.amazon.com/servicecatalog/latest/dg/API_CreateApplication.html

        :param application_id: - Identifier for the applicationId.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``. Possible conditions: - .ifAwsResourceTag()

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "onApplication", [application_id, account, region, partition])

    @jsii.member(jsii_name="onAttributeGroup")
    def on_attribute_group(
        self,
        attribute_group_id: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Servicecatalog":
        """Adds a resource of type AttributeGroup to the statement.

        https://docs.aws.amazon.com/servicecatalog/latest/dg/API_CreateAttributeGroup.html

        :param attribute_group_id: - Identifier for the attributeGroupId.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``. Possible conditions: - .ifAwsResourceTag()

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "onAttributeGroup", [attribute_group_id, account, region, partition])

    @jsii.member(jsii_name="onPortfolio")
    def on_portfolio(
        self,
        portfolio_id: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Servicecatalog":
        """Adds a resource of type Portfolio to the statement.

        https://docs.aws.amazon.com/servicecatalog/latest/dg/API_PortfolioDetail.html

        :param portfolio_id: - Identifier for the portfolioId.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``. Possible conditions: - .ifAwsResourceTag()

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "onPortfolio", [portfolio_id, account, region, partition])

    @jsii.member(jsii_name="onProduct")
    def on_product(
        self,
        product_id: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Servicecatalog":
        """Adds a resource of type Product to the statement.

        https://docs.aws.amazon.com/servicecatalog/latest/dg/API_ProductViewDetail.html

        :param product_id: - Identifier for the productId.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``. Possible conditions: - .ifAwsResourceTag()

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "onProduct", [product_id, account, region, partition])

    @jsii.member(jsii_name="toAcceptPortfolioShare")
    def to_accept_portfolio_share(self) -> "Servicecatalog":
        """Grants permission to accept a portfolio that has been shared with you.

        Access Level: Write

        https://docs.aws.amazon.com/servicecatalog/latest/dg/API_AcceptPortfolioShare.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toAcceptPortfolioShare", [])

    @jsii.member(jsii_name="toAssociateAttributeGroup")
    def to_associate_attribute_group(self) -> "Servicecatalog":
        """Grants permission to associate an attribute group with an application.

        Access Level: Write

        https://docs.aws.amazon.com/servicecatalog/latest/dg/API_AssociateAttributeGroup.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toAssociateAttributeGroup", [])

    @jsii.member(jsii_name="toAssociateBudgetWithResource")
    def to_associate_budget_with_resource(self) -> "Servicecatalog":
        """Grants permission to associate a budget with a resource.

        Access Level: Write

        https://docs.aws.amazon.com/servicecatalog/latest/dg/API_AssociateBudgetWithResource.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toAssociateBudgetWithResource", [])

    @jsii.member(jsii_name="toAssociatePrincipalWithPortfolio")
    def to_associate_principal_with_portfolio(self) -> "Servicecatalog":
        """Grants permission to associate an IAM principal with a portfolio, giving the specified principal access to any products associated with the specified portfolio.

        Access Level: Write

        https://docs.aws.amazon.com/servicecatalog/latest/dg/API_AssociatePrincipalWithPortfolio.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toAssociatePrincipalWithPortfolio", [])

    @jsii.member(jsii_name="toAssociateProductWithPortfolio")
    def to_associate_product_with_portfolio(self) -> "Servicecatalog":
        """Grants permission to associate a product with a portfolio.

        Access Level: Write

        https://docs.aws.amazon.com/servicecatalog/latest/dg/API_AssociateProductWithPortfolio.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toAssociateProductWithPortfolio", [])

    @jsii.member(jsii_name="toAssociateResource")
    def to_associate_resource(self) -> "Servicecatalog":
        """Grants permission to associate a resource with an application.

        Access Level: Write

        https://docs.aws.amazon.com/servicecatalog/latest/dg/API_AssociateResource.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toAssociateResource", [])

    @jsii.member(jsii_name="toAssociateServiceActionWithProvisioningArtifact")
    def to_associate_service_action_with_provisioning_artifact(
        self,
    ) -> "Servicecatalog":
        """Grants permission to associate an action with a provisioning artifact.

        Access Level: Write

        https://docs.aws.amazon.com/servicecatalog/latest/dg/API_AssociateServiceActionWithProvisioningArtifact.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toAssociateServiceActionWithProvisioningArtifact", [])

    @jsii.member(jsii_name="toAssociateTagOptionWithResource")
    def to_associate_tag_option_with_resource(self) -> "Servicecatalog":
        """Grants permission to associate the specified TagOption with the specified portfolio or product.

        Access Level: Write

        https://docs.aws.amazon.com/servicecatalog/latest/dg/API_AssociateTagOptionWithResource.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toAssociateTagOptionWithResource", [])

    @jsii.member(jsii_name="toBatchAssociateServiceActionWithProvisioningArtifact")
    def to_batch_associate_service_action_with_provisioning_artifact(
        self,
    ) -> "Servicecatalog":
        """Grants permission to associate multiple self-service actions with provisioning artifacts.

        Access Level: Write

        https://docs.aws.amazon.com/servicecatalog/latest/dg/API_BatchAssociateServiceActionWithProvisioningArtifact.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toBatchAssociateServiceActionWithProvisioningArtifact", [])

    @jsii.member(jsii_name="toBatchDisassociateServiceActionFromProvisioningArtifact")
    def to_batch_disassociate_service_action_from_provisioning_artifact(
        self,
    ) -> "Servicecatalog":
        """Grants permission to disassociate a batch of self-service actions from the specified provisioning artifact.

        Access Level: Write

        https://docs.aws.amazon.com/servicecatalog/latest/dg/API_BatchDisassociateServiceActionFromProvisioningArtifact.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toBatchDisassociateServiceActionFromProvisioningArtifact", [])

    @jsii.member(jsii_name="toCopyProduct")
    def to_copy_product(self) -> "Servicecatalog":
        """Grants permission to copy the specified source product to the specified target product or a new product.

        Access Level: Write

        https://docs.aws.amazon.com/servicecatalog/latest/dg/API_CopyProduct.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toCopyProduct", [])

    @jsii.member(jsii_name="toCreateApplication")
    def to_create_application(self) -> "Servicecatalog":
        """Grants permission to create an application.

        Access Level: Write

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsTagKeys()

        https://docs.aws.amazon.com/servicecatalog/latest/dg/API_CreateApplication.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toCreateApplication", [])

    @jsii.member(jsii_name="toCreateAttributeGroup")
    def to_create_attribute_group(self) -> "Servicecatalog":
        """Grants permission to create an attribute group.

        Access Level: Write

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsTagKeys()

        https://docs.aws.amazon.com/servicecatalog/latest/dg/API_CreateAttributeGroup.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toCreateAttributeGroup", [])

    @jsii.member(jsii_name="toCreateConstraint")
    def to_create_constraint(self) -> "Servicecatalog":
        """Grants permission to create a constraint on an associated product and portfolio.

        Access Level: Write

        https://docs.aws.amazon.com/servicecatalog/latest/dg/API_CreateConstraint.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toCreateConstraint", [])

    @jsii.member(jsii_name="toCreatePortfolio")
    def to_create_portfolio(self) -> "Servicecatalog":
        """Grants permission to create a portfolio.

        Access Level: Write

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsTagKeys()

        https://docs.aws.amazon.com/servicecatalog/latest/dg/API_CreatePortfolio.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toCreatePortfolio", [])

    @jsii.member(jsii_name="toCreatePortfolioShare")
    def to_create_portfolio_share(self) -> "Servicecatalog":
        """Grants permission to share a portfolio you own with another AWS account.

        Access Level: Permissions management

        https://docs.aws.amazon.com/servicecatalog/latest/dg/API_CreatePortfolioShare.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toCreatePortfolioShare", [])

    @jsii.member(jsii_name="toCreateProduct")
    def to_create_product(self) -> "Servicecatalog":
        """Grants permission to create a product and that product's first provisioning artifact.

        Access Level: Write

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsTagKeys()

        https://docs.aws.amazon.com/servicecatalog/latest/dg/API_CreateProduct.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toCreateProduct", [])

    @jsii.member(jsii_name="toCreateProvisionedProductPlan")
    def to_create_provisioned_product_plan(self) -> "Servicecatalog":
        """Grants permission to add a new provisioned product plan.

        Access Level: Write

        https://docs.aws.amazon.com/servicecatalog/latest/dg/API_CreateProvisionedProductPlan.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toCreateProvisionedProductPlan", [])

    @jsii.member(jsii_name="toCreateProvisioningArtifact")
    def to_create_provisioning_artifact(self) -> "Servicecatalog":
        """Grants permission to add a new provisioning artifact to an existing product.

        Access Level: Write

        https://docs.aws.amazon.com/servicecatalog/latest/dg/API_CreateProvisioningArtifact.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toCreateProvisioningArtifact", [])

    @jsii.member(jsii_name="toCreateServiceAction")
    def to_create_service_action(self) -> "Servicecatalog":
        """Grants permission to create a self-service action.

        Access Level: Write

        https://docs.aws.amazon.com/servicecatalog/latest/dg/API_CreateServiceAction.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toCreateServiceAction", [])

    @jsii.member(jsii_name="toCreateTagOption")
    def to_create_tag_option(self) -> "Servicecatalog":
        """Grants permission to create a TagOption.

        Access Level: Write

        https://docs.aws.amazon.com/servicecatalog/latest/dg/API_CreateTagOption.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toCreateTagOption", [])

    @jsii.member(jsii_name="toDeleteApplication")
    def to_delete_application(self) -> "Servicecatalog":
        """Grants permission to delete an application if all associations have been removed from the application.

        Access Level: Write

        https://docs.aws.amazon.com/servicecatalog/latest/dg/API_DeleteApplication.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDeleteApplication", [])

    @jsii.member(jsii_name="toDeleteAttributeGroup")
    def to_delete_attribute_group(self) -> "Servicecatalog":
        """Grants permission to delete an attribute group if all associations have been removed from the attribute group.

        Access Level: Write

        https://docs.aws.amazon.com/servicecatalog/latest/dg/API_DeleteAttributeGroup.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDeleteAttributeGroup", [])

    @jsii.member(jsii_name="toDeleteConstraint")
    def to_delete_constraint(self) -> "Servicecatalog":
        """Grants permission to remove and delete an existing constraint from an associated product and portfolio.

        Access Level: Write

        https://docs.aws.amazon.com/servicecatalog/latest/dg/API_DeleteConstraint.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDeleteConstraint", [])

    @jsii.member(jsii_name="toDeletePortfolio")
    def to_delete_portfolio(self) -> "Servicecatalog":
        """Grants permission to delete a portfolio if all associations and shares have been removed from the portfolio.

        Access Level: Write

        https://docs.aws.amazon.com/servicecatalog/latest/dg/API_DeletePortfolio.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDeletePortfolio", [])

    @jsii.member(jsii_name="toDeletePortfolioShare")
    def to_delete_portfolio_share(self) -> "Servicecatalog":
        """Grants permission to unshare a portfolio you own from an AWS account you previously shared the portfolio with.

        Access Level: Permissions management

        https://docs.aws.amazon.com/servicecatalog/latest/dg/API_DeletePortfolioShare.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDeletePortfolioShare", [])

    @jsii.member(jsii_name="toDeleteProduct")
    def to_delete_product(self) -> "Servicecatalog":
        """Grants permission to delete a product if all associations have been removed from the product.

        Access Level: Write

        https://docs.aws.amazon.com/servicecatalog/latest/dg/API_DeleteProduct.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDeleteProduct", [])

    @jsii.member(jsii_name="toDeleteProvisionedProductPlan")
    def to_delete_provisioned_product_plan(self) -> "Servicecatalog":
        """Grants permission to delete a provisioned product plan.

        Access Level: Write

        https://docs.aws.amazon.com/servicecatalog/latest/dg/API_DeleteProvisionedProductPlan.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDeleteProvisionedProductPlan", [])

    @jsii.member(jsii_name="toDeleteProvisioningArtifact")
    def to_delete_provisioning_artifact(self) -> "Servicecatalog":
        """Grants permission to delete a provisioning artifact from a product.

        Access Level: Write

        https://docs.aws.amazon.com/servicecatalog/latest/dg/API_DeleteProvisioningArtifact.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDeleteProvisioningArtifact", [])

    @jsii.member(jsii_name="toDeleteServiceAction")
    def to_delete_service_action(self) -> "Servicecatalog":
        """Grants permission to delete a self-service action.

        Access Level: Write

        https://docs.aws.amazon.com/servicecatalog/latest/dg/API_DeleteServiceAction.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDeleteServiceAction", [])

    @jsii.member(jsii_name="toDeleteTagOption")
    def to_delete_tag_option(self) -> "Servicecatalog":
        """Grants permission to delete the specified TagOption.

        Access Level: Write

        https://docs.aws.amazon.com/servicecatalog/latest/dg/API_DeleteTagOption.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDeleteTagOption", [])

    @jsii.member(jsii_name="toDescribeConstraint")
    def to_describe_constraint(self) -> "Servicecatalog":
        """Grants permission to describe a constraint.

        Access Level: Read

        https://docs.aws.amazon.com/servicecatalog/latest/dg/API_DescribeConstraint.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDescribeConstraint", [])

    @jsii.member(jsii_name="toDescribeCopyProductStatus")
    def to_describe_copy_product_status(self) -> "Servicecatalog":
        """Grants permission to get the status of the specified copy product operation.

        Access Level: Read

        https://docs.aws.amazon.com/servicecatalog/latest/dg/API_DescribeCopyProductStatus.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDescribeCopyProductStatus", [])

    @jsii.member(jsii_name="toDescribePortfolio")
    def to_describe_portfolio(self) -> "Servicecatalog":
        """Grants permission to describe a portfolio.

        Access Level: Read

        https://docs.aws.amazon.com/servicecatalog/latest/dg/API_DescribePortfolio.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDescribePortfolio", [])

    @jsii.member(jsii_name="toDescribePortfolioShareStatus")
    def to_describe_portfolio_share_status(self) -> "Servicecatalog":
        """Grants permission to get the status of the specified portfolio share operation.

        Access Level: Read

        https://docs.aws.amazon.com/servicecatalog/latest/dg/API_DescribePortfolioShareStatus.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDescribePortfolioShareStatus", [])

    @jsii.member(jsii_name="toDescribeProduct")
    def to_describe_product(self) -> "Servicecatalog":
        """Grants permission to describe a product as an end-user.

        Access Level: Read

        https://docs.aws.amazon.com/servicecatalog/latest/dg/API_DescribeProduct.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDescribeProduct", [])

    @jsii.member(jsii_name="toDescribeProductAsAdmin")
    def to_describe_product_as_admin(self) -> "Servicecatalog":
        """Grants permission to describe a product as an admin.

        Access Level: Read

        https://docs.aws.amazon.com/servicecatalog/latest/dg/API_DescribeProductAsAdmin.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDescribeProductAsAdmin", [])

    @jsii.member(jsii_name="toDescribeProductView")
    def to_describe_product_view(self) -> "Servicecatalog":
        """Grants permission to describe a product as an end-user.

        Access Level: Read

        https://docs.aws.amazon.com/servicecatalog/latest/dg/API_DescribeProductView.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDescribeProductView", [])

    @jsii.member(jsii_name="toDescribeProvisionedProduct")
    def to_describe_provisioned_product(self) -> "Servicecatalog":
        """Grants permission to describe a provisioned product.

        Access Level: Read

        https://docs.aws.amazon.com/servicecatalog/latest/dg/API_DescribeProvisionedProduct.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDescribeProvisionedProduct", [])

    @jsii.member(jsii_name="toDescribeProvisionedProductPlan")
    def to_describe_provisioned_product_plan(self) -> "Servicecatalog":
        """Grants permission to describe a provisioned product plan.

        Access Level: Read

        https://docs.aws.amazon.com/servicecatalog/latest/dg/API_DescribeProvisionedProductPlan.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDescribeProvisionedProductPlan", [])

    @jsii.member(jsii_name="toDescribeProvisioningArtifact")
    def to_describe_provisioning_artifact(self) -> "Servicecatalog":
        """Grants permission to describe a provisioning artifact.

        Access Level: Read

        https://docs.aws.amazon.com/servicecatalog/latest/dg/API_DescribeProvisioningArtifact.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDescribeProvisioningArtifact", [])

    @jsii.member(jsii_name="toDescribeProvisioningParameters")
    def to_describe_provisioning_parameters(self) -> "Servicecatalog":
        """Grants permission to describe the parameters that you need to specify to successfully provision a specified provisioning artifact.

        Access Level: Read

        https://docs.aws.amazon.com/servicecatalog/latest/dg/API_DescribeProvisioningParameters.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDescribeProvisioningParameters", [])

    @jsii.member(jsii_name="toDescribeRecord")
    def to_describe_record(self) -> "Servicecatalog":
        """Grants permission to describe a record and lists any outputs.

        Access Level: Read

        Possible conditions:

        - .ifAccountLevel()
        - .ifRoleLevel()
        - .ifUserLevel()

        https://docs.aws.amazon.com/servicecatalog/latest/dg/API_DescribeRecord.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDescribeRecord", [])

    @jsii.member(jsii_name="toDescribeServiceAction")
    def to_describe_service_action(self) -> "Servicecatalog":
        """Grants permission to describe a self-service action.

        Access Level: Read

        https://docs.aws.amazon.com/servicecatalog/latest/dg/API_DescribeServiceAction.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDescribeServiceAction", [])

    @jsii.member(jsii_name="toDescribeServiceActionExecutionParameters")
    def to_describe_service_action_execution_parameters(self) -> "Servicecatalog":
        """Grants permission to get the default parameters if you executed the specified Service Action on the specified Provisioned Product.

        Access Level: Read

        https://docs.aws.amazon.com/servicecatalog/latest/dg/API_DescribeServiceActionExecutionParameters.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDescribeServiceActionExecutionParameters", [])

    @jsii.member(jsii_name="toDescribeTagOption")
    def to_describe_tag_option(self) -> "Servicecatalog":
        """Grants permission to get information about the specified TagOption.

        Access Level: Read

        https://docs.aws.amazon.com/servicecatalog/latest/dg/API_DescribeTagOption.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDescribeTagOption", [])

    @jsii.member(jsii_name="toDisableAWSOrganizationsAccess")
    def to_disable_aws_organizations_access(self) -> "Servicecatalog":
        """Grants permission to disable portfolio sharing through AWS Organizations feature.

        Access Level: Write

        https://docs.aws.amazon.com/servicecatalog/latest/dg/API_DisableAWSOrganizationsAccess.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDisableAWSOrganizationsAccess", [])

    @jsii.member(jsii_name="toDisassociateAttributeGroup")
    def to_disassociate_attribute_group(self) -> "Servicecatalog":
        """Grants permission to disassociate an attribute group from an application.

        Access Level: Write

        https://docs.aws.amazon.com/servicecatalog/latest/dg/API_DisassociateAttributeGroup.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDisassociateAttributeGroup", [])

    @jsii.member(jsii_name="toDisassociateBudgetFromResource")
    def to_disassociate_budget_from_resource(self) -> "Servicecatalog":
        """Grants permission to disassociate a budget from a resource.

        Access Level: Write

        https://docs.aws.amazon.com/servicecatalog/latest/dg/API_DisassociateBudgetFromResource.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDisassociateBudgetFromResource", [])

    @jsii.member(jsii_name="toDisassociatePrincipalFromPortfolio")
    def to_disassociate_principal_from_portfolio(self) -> "Servicecatalog":
        """Grants permission to disassociate an IAM principal from a portfolio.

        Access Level: Write

        https://docs.aws.amazon.com/servicecatalog/latest/dg/API_DisassociatePrincipalFromPortfolio.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDisassociatePrincipalFromPortfolio", [])

    @jsii.member(jsii_name="toDisassociateProductFromPortfolio")
    def to_disassociate_product_from_portfolio(self) -> "Servicecatalog":
        """Grants permission to disassociate a product from a portfolio.

        Access Level: Write

        https://docs.aws.amazon.com/servicecatalog/latest/dg/API_DisassociateProductFromPortfolio.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDisassociateProductFromPortfolio", [])

    @jsii.member(jsii_name="toDisassociateResource")
    def to_disassociate_resource(self) -> "Servicecatalog":
        """Grants permission to disassociate a resource from an application.

        Access Level: Write

        https://docs.aws.amazon.com/servicecatalog/latest/dg/API_DisassociateResource.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDisassociateResource", [])

    @jsii.member(jsii_name="toDisassociateServiceActionFromProvisioningArtifact")
    def to_disassociate_service_action_from_provisioning_artifact(
        self,
    ) -> "Servicecatalog":
        """Grants permission to disassociate the specified self-service action association from the specified provisioning artifact.

        Access Level: Write

        https://docs.aws.amazon.com/servicecatalog/latest/dg/API_DisassociateServiceActionFromProvisioningArtifact.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDisassociateServiceActionFromProvisioningArtifact", [])

    @jsii.member(jsii_name="toDisassociateTagOptionFromResource")
    def to_disassociate_tag_option_from_resource(self) -> "Servicecatalog":
        """Grants permission to disassociate the specified TagOption from the specified resource.

        Access Level: Write

        https://docs.aws.amazon.com/servicecatalog/latest/dg/API_DisassociateTagOptionFromResource.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toDisassociateTagOptionFromResource", [])

    @jsii.member(jsii_name="toEnableAWSOrganizationsAccess")
    def to_enable_aws_organizations_access(self) -> "Servicecatalog":
        """Grants permission to enable portfolio sharing feature through AWS Organizations.

        Access Level: Write

        https://docs.aws.amazon.com/servicecatalog/latest/dg/API_EnableAWSOrganizationsAccess.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toEnableAWSOrganizationsAccess", [])

    @jsii.member(jsii_name="toExecuteProvisionedProductPlan")
    def to_execute_provisioned_product_plan(self) -> "Servicecatalog":
        """Grants permission to execute a provisioned product plan.

        Access Level: Write

        https://docs.aws.amazon.com/servicecatalog/latest/dg/API_ExecuteProvisionedProductPlan.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toExecuteProvisionedProductPlan", [])

    @jsii.member(jsii_name="toExecuteProvisionedProductServiceAction")
    def to_execute_provisioned_product_service_action(self) -> "Servicecatalog":
        """Grants permission to executes a provisioned product plan.

        Access Level: Write

        https://docs.aws.amazon.com/servicecatalog/latest/dg/API_ExecuteProvisionedProductServiceAction.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toExecuteProvisionedProductServiceAction", [])

    @jsii.member(jsii_name="toGetApplication")
    def to_get_application(self) -> "Servicecatalog":
        """Grants permission to get an application.

        Access Level: Read

        https://docs.aws.amazon.com/servicecatalog/latest/dg/API_GetApplication.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toGetApplication", [])

    @jsii.member(jsii_name="toGetAttributeGroup")
    def to_get_attribute_group(self) -> "Servicecatalog":
        """Grants permission to get an attribute group.

        Access Level: Read

        https://docs.aws.amazon.com/servicecatalog/latest/dg/API_GetAttributeGroup.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toGetAttributeGroup", [])

    @jsii.member(jsii_name="toGetAWSOrganizationsAccessStatus")
    def to_get_aws_organizations_access_status(self) -> "Servicecatalog":
        """Grants permission to get the access status of AWS Organization portfolio share feature.

        Access Level: Read

        https://docs.aws.amazon.com/servicecatalog/latest/dg/API_GetAWSOrganizationsAccessStatus.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toGetAWSOrganizationsAccessStatus", [])

    @jsii.member(jsii_name="toImportAsProvisionedProduct")
    def to_import_as_provisioned_product(self) -> "Servicecatalog":
        """Grants permission to import a resource into a provisioned product.

        Access Level: Write

        https://docs.aws.amazon.com/servicecatalog/latest/dg/API_ImportAsProvisionedProduct.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toImportAsProvisionedProduct", [])

    @jsii.member(jsii_name="toListAcceptedPortfolioShares")
    def to_list_accepted_portfolio_shares(self) -> "Servicecatalog":
        """Grants permission to list the portfolios that have been shared with you and you have accepted.

        Access Level: List

        https://docs.aws.amazon.com/servicecatalog/latest/dg/API_ListAcceptedPortfolioShares.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toListAcceptedPortfolioShares", [])

    @jsii.member(jsii_name="toListApplications")
    def to_list_applications(self) -> "Servicecatalog":
        """Grants permission to list the applications in your account.

        Access Level: List

        https://docs.aws.amazon.com/servicecatalog/latest/dg/API_ListApplications.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toListApplications", [])

    @jsii.member(jsii_name="toListAssociatedAttributeGroups")
    def to_list_associated_attribute_groups(self) -> "Servicecatalog":
        """Grants permission to list the attribute groups associated with an application.

        Access Level: List

        https://docs.aws.amazon.com/servicecatalog/latest/dg/API_ListAssociatedAttributeGroups.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toListAssociatedAttributeGroups", [])

    @jsii.member(jsii_name="toListAssociatedResources")
    def to_list_associated_resources(self) -> "Servicecatalog":
        """Grants permission to list the resources associated with an application.

        Access Level: List

        https://docs.aws.amazon.com/servicecatalog/latest/dg/API_ListAssociatedResources.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toListAssociatedResources", [])

    @jsii.member(jsii_name="toListAttributeGroups")
    def to_list_attribute_groups(self) -> "Servicecatalog":
        """Grants permission to list the attribute groups in your account.

        Access Level: List

        https://docs.aws.amazon.com/servicecatalog/latest/dg/API_ListAttributeGroups.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toListAttributeGroups", [])

    @jsii.member(jsii_name="toListBudgetsForResource")
    def to_list_budgets_for_resource(self) -> "Servicecatalog":
        """Grants permission to list all the budgets associated to a resource.

        Access Level: List

        https://docs.aws.amazon.com/servicecatalog/latest/dg/API_ListBudgetsForResource.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toListBudgetsForResource", [])

    @jsii.member(jsii_name="toListConstraintsForPortfolio")
    def to_list_constraints_for_portfolio(self) -> "Servicecatalog":
        """Grants permission to list constraints associated with a given portfolio.

        Access Level: List

        https://docs.aws.amazon.com/servicecatalog/latest/dg/API_ListConstraintsForPortfolio.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toListConstraintsForPortfolio", [])

    @jsii.member(jsii_name="toListLaunchPaths")
    def to_list_launch_paths(self) -> "Servicecatalog":
        """Grants permission to list the different ways to launch a given product as an end-user.

        Access Level: List

        https://docs.aws.amazon.com/servicecatalog/latest/dg/API_ListLaunchPaths.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toListLaunchPaths", [])

    @jsii.member(jsii_name="toListOrganizationPortfolioAccess")
    def to_list_organization_portfolio_access(self) -> "Servicecatalog":
        """Grants permission to list the organization nodes that have access to the specified portfolio.

        Access Level: List

        https://docs.aws.amazon.com/servicecatalog/latest/dg/API_ListOrganizationPortfolioAccess.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toListOrganizationPortfolioAccess", [])

    @jsii.member(jsii_name="toListPortfolioAccess")
    def to_list_portfolio_access(self) -> "Servicecatalog":
        """Grants permission to list the AWS accounts you have shared a given portfolio with.

        Access Level: List

        https://docs.aws.amazon.com/servicecatalog/latest/dg/API_ListPortfolioAccess.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toListPortfolioAccess", [])

    @jsii.member(jsii_name="toListPortfolios")
    def to_list_portfolios(self) -> "Servicecatalog":
        """Grants permission to list the portfolios in your account.

        Access Level: List

        https://docs.aws.amazon.com/servicecatalog/latest/dg/API_ListPortfolios.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toListPortfolios", [])

    @jsii.member(jsii_name="toListPortfoliosForProduct")
    def to_list_portfolios_for_product(self) -> "Servicecatalog":
        """Grants permission to list the portfolios associated with a given product.

        Access Level: List

        https://docs.aws.amazon.com/servicecatalog/latest/dg/API_ListPortfoliosForProduct.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toListPortfoliosForProduct", [])

    @jsii.member(jsii_name="toListPrincipalsForPortfolio")
    def to_list_principals_for_portfolio(self) -> "Servicecatalog":
        """Grants permission to list the IAM principals associated with a given portfolio.

        Access Level: List

        https://docs.aws.amazon.com/servicecatalog/latest/dg/API_ListPrincipalsForPortfolio.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toListPrincipalsForPortfolio", [])

    @jsii.member(jsii_name="toListProvisionedProductPlans")
    def to_list_provisioned_product_plans(self) -> "Servicecatalog":
        """Grants permission to list the provisioned product plans.

        Access Level: List

        https://docs.aws.amazon.com/servicecatalog/latest/dg/API_ListProvisionedProductPlans.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toListProvisionedProductPlans", [])

    @jsii.member(jsii_name="toListProvisioningArtifacts")
    def to_list_provisioning_artifacts(self) -> "Servicecatalog":
        """Grants permission to list the provisioning artifacts associated with a given product.

        Access Level: List

        https://docs.aws.amazon.com/servicecatalog/latest/dg/API_ListProvisioningArtifacts.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toListProvisioningArtifacts", [])

    @jsii.member(jsii_name="toListProvisioningArtifactsForServiceAction")
    def to_list_provisioning_artifacts_for_service_action(self) -> "Servicecatalog":
        """Grants permission to list all provisioning artifacts for the specified self-service action.

        Access Level: List

        https://docs.aws.amazon.com/servicecatalog/latest/dg/API_ListProvisioningArtifactsForServiceAction.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toListProvisioningArtifactsForServiceAction", [])

    @jsii.member(jsii_name="toListRecordHistory")
    def to_list_record_history(self) -> "Servicecatalog":
        """Grants permission to list all the records in your account or all the records related to a given provisioned product.

        Access Level: List

        Possible conditions:

        - .ifAccountLevel()
        - .ifRoleLevel()
        - .ifUserLevel()

        https://docs.aws.amazon.com/servicecatalog/latest/dg/API_ListRecordHistory.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toListRecordHistory", [])

    @jsii.member(jsii_name="toListResourcesForTagOption")
    def to_list_resources_for_tag_option(self) -> "Servicecatalog":
        """Grants permission to list the resources associated with the specified TagOption.

        Access Level: List

        https://docs.aws.amazon.com/servicecatalog/latest/dg/API_ListResourcesForTagOption.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toListResourcesForTagOption", [])

    @jsii.member(jsii_name="toListServiceActions")
    def to_list_service_actions(self) -> "Servicecatalog":
        """Grants permission to list all self-service actions.

        Access Level: List

        https://docs.aws.amazon.com/servicecatalog/latest/dg/API_ListServiceActions.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toListServiceActions", [])

    @jsii.member(jsii_name="toListServiceActionsForProvisioningArtifact")
    def to_list_service_actions_for_provisioning_artifact(self) -> "Servicecatalog":
        """Grants permission to list all the service actions associated with the specified provisioning artifact in your account.

        Access Level: List

        https://docs.aws.amazon.com/servicecatalog/latest/dg/API_ListServiceActionsForProvisioningArtifact.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toListServiceActionsForProvisioningArtifact", [])

    @jsii.member(jsii_name="toListStackInstancesForProvisionedProduct")
    def to_list_stack_instances_for_provisioned_product(self) -> "Servicecatalog":
        """Grants permission to list account, region and status of each stack instances that are associated with a CFN_STACKSET type provisioned product.

        Access Level: List

        https://docs.aws.amazon.com/servicecatalog/latest/dg/API_ListStackInstancesForProvisionedProduct.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toListStackInstancesForProvisionedProduct", [])

    @jsii.member(jsii_name="toListTagOptions")
    def to_list_tag_options(self) -> "Servicecatalog":
        """Grants permission to list the specified TagOptions or all TagOptions.

        Access Level: List

        https://docs.aws.amazon.com/servicecatalog/latest/dg/API_ListTagOptions.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toListTagOptions", [])

    @jsii.member(jsii_name="toProvisionProduct")
    def to_provision_product(self) -> "Servicecatalog":
        """Grants permission to provision a product with a specified provisioning artifact and launch parameters.

        Access Level: Write

        https://docs.aws.amazon.com/servicecatalog/latest/dg/API_ProvisionProduct.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toProvisionProduct", [])

    @jsii.member(jsii_name="toRejectPortfolioShare")
    def to_reject_portfolio_share(self) -> "Servicecatalog":
        """Grants permission to reject a portfolio that has been shared with you that you previously accepted.

        Access Level: Write

        https://docs.aws.amazon.com/servicecatalog/latest/dg/API_RejectPortfolioShare.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toRejectPortfolioShare", [])

    @jsii.member(jsii_name="toScanProvisionedProducts")
    def to_scan_provisioned_products(self) -> "Servicecatalog":
        """Grants permission to list all the provisioned products in your account.

        Access Level: List

        Possible conditions:

        - .ifAccountLevel()
        - .ifRoleLevel()
        - .ifUserLevel()

        https://docs.aws.amazon.com/servicecatalog/latest/dg/API_ScanProvisionedProducts.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toScanProvisionedProducts", [])

    @jsii.member(jsii_name="toSearchProducts")
    def to_search_products(self) -> "Servicecatalog":
        """Grants permission to list the products available to you as an end-user.

        Access Level: List

        https://docs.aws.amazon.com/servicecatalog/latest/dg/API_SearchProducts.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toSearchProducts", [])

    @jsii.member(jsii_name="toSearchProductsAsAdmin")
    def to_search_products_as_admin(self) -> "Servicecatalog":
        """Grants permission to list all the products in your account or all the products associated with a given portfolio.

        Access Level: List

        https://docs.aws.amazon.com/servicecatalog/latest/dg/API_SearchProductsAsAdmin.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toSearchProductsAsAdmin", [])

    @jsii.member(jsii_name="toSearchProvisionedProducts")
    def to_search_provisioned_products(self) -> "Servicecatalog":
        """Grants permission to list all the provisioned products in your account.

        Access Level: List

        Possible conditions:

        - .ifAccountLevel()
        - .ifRoleLevel()
        - .ifUserLevel()

        https://docs.aws.amazon.com/servicecatalog/latest/dg/API_SearchProvisionedProducts.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toSearchProvisionedProducts", [])

    @jsii.member(jsii_name="toTerminateProvisionedProduct")
    def to_terminate_provisioned_product(self) -> "Servicecatalog":
        """Grants permission to terminate an existing provisioned product.

        Access Level: Write

        Possible conditions:

        - .ifAccountLevel()
        - .ifRoleLevel()
        - .ifUserLevel()

        https://docs.aws.amazon.com/servicecatalog/latest/dg/API_TerminateProvisionedProduct.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toTerminateProvisionedProduct", [])

    @jsii.member(jsii_name="toUpdateApplication")
    def to_update_application(self) -> "Servicecatalog":
        """Grants permission to update the attributes of an existing application.

        Access Level: Write

        https://docs.aws.amazon.com/servicecatalog/latest/dg/API_UpdateApplication.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toUpdateApplication", [])

    @jsii.member(jsii_name="toUpdateAttributeGroup")
    def to_update_attribute_group(self) -> "Servicecatalog":
        """Grants permission to update the attributes of an existing attribute group.

        Access Level: Write

        https://docs.aws.amazon.com/servicecatalog/latest/dg/API_UpdateAttributeGroup.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toUpdateAttributeGroup", [])

    @jsii.member(jsii_name="toUpdateConstraint")
    def to_update_constraint(self) -> "Servicecatalog":
        """Grants permission to update the metadata fields of an existing constraint.

        Access Level: Write

        https://docs.aws.amazon.com/servicecatalog/latest/dg/API_UpdateConstraint.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toUpdateConstraint", [])

    @jsii.member(jsii_name="toUpdatePortfolio")
    def to_update_portfolio(self) -> "Servicecatalog":
        """Grants permission to update the metadata fields and/or tags of an existing portfolio.

        Access Level: Write

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsTagKeys()

        https://docs.aws.amazon.com/servicecatalog/latest/dg/API_UpdatePortfolio.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toUpdatePortfolio", [])

    @jsii.member(jsii_name="toUpdateProduct")
    def to_update_product(self) -> "Servicecatalog":
        """Grants permission to update the metadata fields and/or tags of an existing product.

        Access Level: Write

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsTagKeys()

        https://docs.aws.amazon.com/servicecatalog/latest/dg/API_UpdateProduct.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toUpdateProduct", [])

    @jsii.member(jsii_name="toUpdateProvisionedProduct")
    def to_update_provisioned_product(self) -> "Servicecatalog":
        """Grants permission to update an existing provisioned product.

        Access Level: Write

        Possible conditions:

        - .ifAccountLevel()
        - .ifRoleLevel()
        - .ifUserLevel()

        https://docs.aws.amazon.com/servicecatalog/latest/dg/API_UpdateProvisionedProduct.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toUpdateProvisionedProduct", [])

    @jsii.member(jsii_name="toUpdateProvisionedProductProperties")
    def to_update_provisioned_product_properties(self) -> "Servicecatalog":
        """Grants permission to update the properties of an existing provisioned product.

        Access Level: Write

        https://docs.aws.amazon.com/servicecatalog/latest/dg/API_UpdateProvisionedProductProperties.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toUpdateProvisionedProductProperties", [])

    @jsii.member(jsii_name="toUpdateProvisioningArtifact")
    def to_update_provisioning_artifact(self) -> "Servicecatalog":
        """Grants permission to update the metadata fields of an existing provisioning artifact.

        Access Level: Write

        https://docs.aws.amazon.com/servicecatalog/latest/dg/API_UpdateProvisioningArtifact.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toUpdateProvisioningArtifact", [])

    @jsii.member(jsii_name="toUpdateServiceAction")
    def to_update_service_action(self) -> "Servicecatalog":
        """Grants permission to update a self-service action.

        Access Level: Write

        https://docs.aws.amazon.com/servicecatalog/latest/dg/API_UpdateServiceAction.html

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toUpdateServiceAction", [])

   