import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface AccessContextManagerAccessLevelsConfig extends cdktf.TerraformMetaArguments {
    /**
    * The AccessPolicy this AccessLevel lives in.
  Format: accessPolicies/{policy_id}
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_access_levels#parent AccessContextManagerAccessLevels#parent}
    */
    readonly parent: string;
    /**
    * access_levels block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_access_levels#access_levels AccessContextManagerAccessLevels#access_levels}
    */
    readonly accessLevels?: AccessContextManagerAccessLevelsAccessLevels[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_access_levels#timeouts AccessContextManagerAccessLevels#timeouts}
    */
    readonly timeouts?: AccessContextManagerAccessLevelsTimeouts;
}
export interface AccessContextManagerAccessLevelsAccessLevelsBasicConditionsDevicePolicyOsConstraints {
    /**
    * The minimum allowed OS version. If not set, any version
  of this OS satisfies the constraint.
  Format: "major.minor.patch" such as "10.5.301", "9.2.1".
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_access_levels#minimum_version AccessContextManagerAccessLevels#minimum_version}
    */
    readonly minimumVersion?: string;
    /**
    * The operating system type of the device. Possible values: ["OS_UNSPECIFIED", "DESKTOP_MAC", "DESKTOP_WINDOWS", "DESKTOP_LINUX", "DESKTOP_CHROME_OS", "ANDROID", "IOS"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_access_levels#os_type AccessContextManagerAccessLevels#os_type}
    */
    readonly osType: string;
}
export declare function accessContextManagerAccessLevelsAccessLevelsBasicConditionsDevicePolicyOsConstraintsToTerraform(struct?: AccessContextManagerAccessLevelsAccessLevelsBasicConditionsDevicePolicyOsConstraints | cdktf.IResolvable): any;
export interface AccessContextManagerAccessLevelsAccessLevelsBasicConditionsDevicePolicy {
    /**
    * A list of allowed device management levels.
  An empty list allows all management levels. Possible values: ["MANAGEMENT_UNSPECIFIED", "NONE", "BASIC", "COMPLETE"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_access_levels#allowed_device_management_levels AccessContextManagerAccessLevels#allowed_device_management_levels}
    */
    readonly allowedDeviceManagementLevels?: string[];
    /**
    * A list of allowed encryptions statuses.
  An empty list allows all statuses. Possible values: ["ENCRYPTION_UNSPECIFIED", "ENCRYPTION_UNSUPPORTED", "UNENCRYPTED", "ENCRYPTED"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_access_levels#allowed_encryption_statuses AccessContextManagerAccessLevels#allowed_encryption_statuses}
    */
    readonly allowedEncryptionStatuses?: string[];
    /**
    * Whether the device needs to be approved by the customer admin.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_access_levels#require_admin_approval AccessContextManagerAccessLevels#require_admin_approval}
    */
    readonly requireAdminApproval?: boolean | cdktf.IResolvable;
    /**
    * Whether the device needs to be corp owned.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_access_levels#require_corp_owned AccessContextManagerAccessLevels#require_corp_owned}
    */
    readonly requireCorpOwned?: boolean | cdktf.IResolvable;
    /**
    * Whether or not screenlock is required for the DevicePolicy
  to be true. Defaults to false.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_access_levels#require_screen_lock AccessContextManagerAccessLevels#require_screen_lock}
    */
    readonly requireScreenLock?: boolean | cdktf.IResolvable;
    /**
    * os_constraints block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_access_levels#os_constraints AccessContextManagerAccessLevels#os_constraints}
    */
    readonly osConstraints?: AccessContextManagerAccessLevelsAccessLevelsBasicConditionsDevicePolicyOsConstraints[] | cdktf.IResolvable;
}
export declare function accessContextManagerAccessLevelsAccessLevelsBasicConditionsDevicePolicyToTerraform(struct?: AccessContextManagerAccessLevelsAccessLevelsBasicConditionsDevicePolicyOutputReference | AccessContextManagerAccessLevelsAccessLevelsBasicConditionsDevicePolicy): any;
export declare class AccessContextManagerAccessLevelsAccessLevelsBasicConditionsDevicePolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AccessContextManagerAccessLevelsAccessLevelsBasicConditionsDevicePolicy | undefined;
    set internalValue(value: AccessContextManagerAccessLevelsAccessLevelsBasicConditionsDevicePolicy | undefined);
    private _allowedDeviceManagementLevels?;
    get allowedDeviceManagementLevels(): string[];
    set allowedDeviceManagementLevels(value: string[]);
    resetAllowedDeviceManagementLevels(): void;
    get allowedDeviceManagementLevelsInput(): string[] | undefined;
    private _allowedEncryptionStatuses?;
    get allowedEncryptionStatuses(): string[];
    set allowedEncryptionStatuses(value: string[]);
    resetAllowedEncryptionStatuses(): void;
    get allowedEncryptionStatusesInput(): string[] | undefined;
    private _requireAdminApproval?;
    get requireAdminApproval(): boolean | cdktf.IResolvable;
    set requireAdminApproval(value: boolean | cdktf.IResolvable);
    resetRequireAdminApproval(): void;
    get requireAdminApprovalInput(): boolean | cdktf.IResolvable | undefined;
    private _requireCorpOwned?;
    get requireCorpOwned(): boolean | cdktf.IResolvable;
    set requireCorpOwned(value: boolean | cdktf.IResolvable);
    resetRequireCorpOwned(): void;
    get requireCorpOwnedInput(): boolean | cdktf.IResolvable | undefined;
    private _requireScreenLock?;
    get requireScreenLock(): boolean | cdktf.IResolvable;
    set requireScreenLock(value: boolean | cdktf.IResolvable);
    resetRequireScreenLock(): void;
    get requireScreenLockInput(): boolean | cdktf.IResolvable | undefined;
    private _osConstraints?;
    get osConstraints(): AccessContextManagerAccessLevelsAccessLevelsBasicConditionsDevicePolicyOsConstraints[] | cdktf.IResolvable;
    set osConstraints(value: AccessContextManagerAccessLevelsAccessLevelsBasicConditionsDevicePolicyOsConstraints[] | cdktf.IResolvable);
    resetOsConstraints(): void;
    get osConstraintsInput(): cdktf.IResolvable | AccessContextManagerAccessLevelsAccessLevelsBasicConditionsDevicePolicyOsConstraints[] | undefined;
}
export interface AccessContextManagerAccessLevelsAccessLevelsBasicConditions {
    /**
    * A list of CIDR block IP subnetwork specification. May be IPv4
  or IPv6.
  Note that for a CIDR IP address block, the specified IP address
  portion must be properly truncated (i.e. all the host bits must
  be zero) or the input is considered malformed. For example,
  "192.0.2.0/24" is accepted but "192.0.2.1/24" is not. Similarly,
  for IPv6, "2001:db8::/32" is accepted whereas "2001:db8::1/32"
  is not. The originating IP of a request must be in one of the
  listed subnets in order for this Condition to be true.
  If empty, all IP addresses are allowed.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_access_levels#ip_subnetworks AccessContextManagerAccessLevels#ip_subnetworks}
    */
    readonly ipSubnetworks?: string[];
    /**
    * An allowed list of members (users, service accounts).
  Using groups is not supported yet.
  
  The signed-in user originating the request must be a part of one
  of the provided members. If not specified, a request may come
  from any user (logged in/not logged in, not present in any
  groups, etc.).
  Formats: 'user:{emailid}', 'serviceAccount:{emailid}'
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_access_levels#members AccessContextManagerAccessLevels#members}
    */
    readonly members?: string[];
    /**
    * Whether to negate the Condition. If true, the Condition becomes
  a NAND over its non-empty fields, each field must be false for
  the Condition overall to be satisfied. Defaults to false.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_access_levels#negate AccessContextManagerAccessLevels#negate}
    */
    readonly negate?: boolean | cdktf.IResolvable;
    /**
    * The request must originate from one of the provided
  countries/regions.
  Format: A valid ISO 3166-1 alpha-2 code.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_access_levels#regions AccessContextManagerAccessLevels#regions}
    */
    readonly regions?: string[];
    /**
    * A list of other access levels defined in the same Policy,
  referenced by resource name. Referencing an AccessLevel which
  does not exist is an error. All access levels listed must be
  granted for the Condition to be true.
  Format: accessPolicies/{policy_id}/accessLevels/{short_name}
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_access_levels#required_access_levels AccessContextManagerAccessLevels#required_access_levels}
    */
    readonly requiredAccessLevels?: string[];
    /**
    * device_policy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_access_levels#device_policy AccessContextManagerAccessLevels#device_policy}
    */
    readonly devicePolicy?: AccessContextManagerAccessLevelsAccessLevelsBasicConditionsDevicePolicy;
}
export declare function accessContextManagerAccessLevelsAccessLevelsBasicConditionsToTerraform(struct?: AccessContextManagerAccessLevelsAccessLevelsBasicConditions | cdktf.IResolvable): any;
export interface AccessContextManagerAccessLevelsAccessLevelsBasic {
    /**
    * How the conditions list should be combined to determine if a request
  is granted this AccessLevel. If AND is used, each Condition in
  conditions must be satisfied for the AccessLevel to be applied. If
  OR is used, at least one Condition in conditions must be satisfied
  for the AccessLevel to be applied. Default value: "AND" Possible values: ["AND", "OR"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_access_levels#combining_function AccessContextManagerAccessLevels#combining_function}
    */
    readonly combiningFunction?: string;
    /**
    * conditions block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_access_levels#conditions AccessContextManagerAccessLevels#conditions}
    */
    readonly conditions: AccessContextManagerAccessLevelsAccessLevelsBasicConditions[] | cdktf.IResolvable;
}
export declare function accessContextManagerAccessLevelsAccessLevelsBasicToTerraform(struct?: AccessContextManagerAccessLevelsAccessLevelsBasicOutputReference | AccessContextManagerAccessLevelsAccessLevelsBasic): any;
export declare class AccessContextManagerAccessLevelsAccessLevelsBasicOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AccessContextManagerAccessLevelsAccessLevelsBasic | undefined;
    set internalValue(value: AccessContextManagerAccessLevelsAccessLevelsBasic | undefined);
    private _combiningFunction?;
    get combiningFunction(): string;
    set combiningFunction(value: string);
    resetCombiningFunction(): void;
    get combiningFunctionInput(): string | undefined;
    private _conditions?;
    get conditions(): AccessContextManagerAccessLevelsAccessLevelsBasicConditions[] | cdktf.IResolvable;
    set conditions(value: AccessContextManagerAccessLevelsAccessLevelsBasicConditions[] | cdktf.IResolvable);
    get conditionsInput(): cdktf.IResolvable | AccessContextManagerAccessLevelsAccessLevelsBasicConditions[] | undefined;
}
export interface AccessContextManagerAccessLevelsAccessLevelsCustomExpr {
    /**
    * Description of the expression
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_access_levels#description AccessContextManagerAccessLevels#description}
    */
    readonly description?: string;
    /**
    * Textual representation of an expression in Common Expression Language syntax.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_access_levels#expression AccessContextManagerAccessLevels#expression}
    */
    readonly expression: string;
    /**
    * String indicating the location of the expression for error reporting, e.g. a file name and a position in the file
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_access_levels#location AccessContextManagerAccessLevels#location}
    */
    readonly location?: string;
    /**
    * Title for the expression, i.e. a short string describing its purpose.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_access_levels#title AccessContextManagerAccessLevels#title}
    */
    readonly title?: string;
}
export declare function accessContextManagerAccessLevelsAccessLevelsCustomExprToTerraform(struct?: AccessContextManagerAccessLevelsAccessLevelsCustomExprOutputReference | AccessContextManagerAccessLevelsAccessLevelsCustomExpr): any;
export declare class AccessContextManagerAccessLevelsAccessLevelsCustomExprOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AccessContextManagerAccessLevelsAccessLevelsCustomExpr | undefined;
    set internalValue(value: AccessContextManagerAccessLevelsAccessLevelsCustomExpr | undefined);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _expression?;
    get expression(): string;
    set expression(value: string);
    get expressionInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    resetLocation(): void;
    get locationInput(): string | undefined;
    private _title?;
    get title(): string;
    set title(value: string);
    resetTitle(): void;
    get titleInput(): string | undefined;
}
export interface AccessContextManagerAccessLevelsAccessLevelsCustom {
    /**
    * expr block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_access_levels#expr AccessContextManagerAccessLevels#expr}
    */
    readonly expr: AccessContextManagerAccessLevelsAccessLevelsCustomExpr;
}
export declare function accessContextManagerAccessLevelsAccessLevelsCustomToTerraform(struct?: AccessContextManagerAccessLevelsAccessLevelsCustomOutputReference | AccessContextManagerAccessLevelsAccessLevelsCustom): any;
export declare class AccessContextManagerAccessLevelsAccessLevelsCustomOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AccessContextManagerAccessLevelsAccessLevelsCustom | undefined;
    set internalValue(value: AccessContextManagerAccessLevelsAccessLevelsCustom | undefined);
    private _expr;
    get expr(): AccessContextManagerAccessLevelsAccessLevelsCustomExprOutputReference;
    putExpr(value: AccessContextManagerAccessLevelsAccessLevelsCustomExpr): void;
    get exprInput(): AccessContextManagerAccessLevelsAccessLevelsCustomExpr | undefined;
}
export interface AccessContextManagerAccessLevelsAccessLevels {
    /**
    * Description of the AccessLevel and its use. Does not affect behavior.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_access_levels#description AccessContextManagerAccessLevels#description}
    */
    readonly description?: string;
    /**
    * Resource name for the Access Level. The short_name component must begin
  with a letter and only include alphanumeric and '_'.
  Format: accessPolicies/{policy_id}/accessLevels/{short_name}
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_access_levels#name AccessContextManagerAccessLevels#name}
    */
    readonly name: string;
    /**
    * Human readable title. Must be unique within the Policy.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_access_levels#title AccessContextManagerAccessLevels#title}
    */
    readonly title: string;
    /**
    * basic block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_access_levels#basic AccessContextManagerAccessLevels#basic}
    */
    readonly basic?: AccessContextManagerAccessLevelsAccessLevelsBasic;
    /**
    * custom block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_access_levels#custom AccessContextManagerAccessLevels#custom}
    */
    readonly custom?: AccessContextManagerAccessLevelsAccessLevelsCustom;
}
export declare function accessContextManagerAccessLevelsAccessLevelsToTerraform(struct?: AccessContextManagerAccessLevelsAccessLevels | cdktf.IResolvable): any;
export interface AccessContextManagerAccessLevelsTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_access_levels#create AccessContextManagerAccessLevels#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_access_levels#delete AccessContextManagerAccessLevels#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_access_levels#update AccessContextManagerAccessLevels#update}
    */
    readonly update?: string;
}
export declare function accessContextManagerAccessLevelsTimeoutsToTerraform(struct?: AccessContextManagerAccessLevelsTimeoutsOutputReference | AccessContextManagerAccessLevelsTimeouts | cdktf.IResolvable): any;
export declare class AccessContextManagerAccessLevelsTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AccessContextManagerAccessLevelsTimeouts | undefined;
    set internalValue(value: AccessContextManagerAccessLevelsTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_access_levels google_access_context_manager_access_levels}
*/
export declare class AccessContextManagerAccessLevels extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_access_context_manager_access_levels";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_access_levels google_access_context_manager_access_levels} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options AccessContextManagerAccessLevelsConfig
    */
    constructor(scope: Construct, id: string, config: AccessContextManagerAccessLevelsConfig);
    get id(): string;
    private _parent?;
    get parent(): string;
    set parent(value: string);
    get parentInput(): string | undefined;
    private _accessLevels?;
    get accessLevels(): AccessContextManagerAccessLevelsAccessLevels[] | cdktf.IResolvable;
    set accessLevels(value: AccessContextManagerAccessLevelsAccessLevels[] | cdktf.IResolvable);
    resetAccessLevels(): void;
    get accessLevelsInput(): cdktf.IResolvable | AccessContextManagerAccessLevelsAccessLevels[] | undefined;
    private _timeouts;
    get timeouts(): AccessContextManagerAccessLevelsTimeoutsOutputReference;
    putTimeouts(value: AccessContextManagerAccessLevelsTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): AccessContextManagerAccessLevelsTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
