import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ComputeImageIamMemberConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_image_iam_member#image ComputeImageIamMember#image}
    */
    readonly image: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_image_iam_member#member ComputeImageIamMember#member}
    */
    readonly member: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_image_iam_member#project ComputeImageIamMember#project}
    */
    readonly project?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_image_iam_member#role ComputeImageIamMember#role}
    */
    readonly role: string;
    /**
    * condition block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_image_iam_member#condition ComputeImageIamMember#condition}
    */
    readonly condition?: ComputeImageIamMemberCondition;
}
export interface ComputeImageIamMemberCondition {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_image_iam_member#description ComputeImageIamMember#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_image_iam_member#expression ComputeImageIamMember#expression}
    */
    readonly expression: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_image_iam_member#title ComputeImageIamMember#title}
    */
    readonly title: string;
}
export declare function computeImageIamMemberConditionToTerraform(struct?: ComputeImageIamMemberConditionOutputReference | ComputeImageIamMemberCondition): any;
export declare class ComputeImageIamMemberConditionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeImageIamMemberCondition | undefined;
    set internalValue(value: ComputeImageIamMemberCondition | undefined);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _expression?;
    get expression(): string;
    set expression(value: string);
    get expressionInput(): string | undefined;
    private _title?;
    get title(): string;
    set title(value: string);
    get titleInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/compute_image_iam_member google_compute_image_iam_member}
*/
export declare class ComputeImageIamMember extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_compute_image_iam_member";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/compute_image_iam_member google_compute_image_iam_member} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ComputeImageIamMemberConfig
    */
    constructor(scope: Construct, id: string, config: ComputeImageIamMemberConfig);
    get etag(): string;
    get id(): string;
    private _image?;
    get image(): string;
    set image(value: string);
    get imageInput(): string | undefined;
    private _member?;
    get member(): string;
    set member(value: string);
    get memberInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _role?;
    get role(): string;
    set role(value: string);
    get roleInput(): string | undefined;
    private _condition;
    get condition(): ComputeImageIamMemberConditionOutputReference;
    putCondition(value: ComputeImageIamMemberCondition): void;
    resetCondition(): void;
    get conditionInput(): ComputeImageIamMemberCondition | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
