import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleComputeGlobalForwardingRuleConfig extends cdktf.TerraformMetaArguments {
    /**
    * Name of the resource; provided by the client when the resource is created. The name must be 1-63 characters long, and comply with [RFC1035](https://www.ietf.org/rfc/rfc1035.txt). Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/compute_global_forwarding_rule#name DataGoogleComputeGlobalForwardingRule#name}
    */
    readonly name: string;
    /**
    * The project this resource belongs in.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/compute_global_forwarding_rule#project DataGoogleComputeGlobalForwardingRule#project}
    */
    readonly project?: string;
}
export interface DataGoogleComputeGlobalForwardingRuleMetadataFiltersFilterLabels {
}
export declare function dataGoogleComputeGlobalForwardingRuleMetadataFiltersFilterLabelsToTerraform(struct?: DataGoogleComputeGlobalForwardingRuleMetadataFiltersFilterLabels): any;
export declare class DataGoogleComputeGlobalForwardingRuleMetadataFiltersFilterLabelsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleComputeGlobalForwardingRuleMetadataFiltersFilterLabels | undefined;
    set internalValue(value: DataGoogleComputeGlobalForwardingRuleMetadataFiltersFilterLabels | undefined);
    get name(): string;
    get value(): string;
}
export declare class DataGoogleComputeGlobalForwardingRuleMetadataFiltersFilterLabelsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleComputeGlobalForwardingRuleMetadataFiltersFilterLabelsOutputReference;
}
export interface DataGoogleComputeGlobalForwardingRuleMetadataFilters {
}
export declare function dataGoogleComputeGlobalForwardingRuleMetadataFiltersToTerraform(struct?: DataGoogleComputeGlobalForwardingRuleMetadataFilters): any;
export declare class DataGoogleComputeGlobalForwardingRuleMetadataFiltersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleComputeGlobalForwardingRuleMetadataFilters | undefined;
    set internalValue(value: DataGoogleComputeGlobalForwardingRuleMetadataFilters | undefined);
    private _filterLabels;
    get filterLabels(): DataGoogleComputeGlobalForwardingRuleMetadataFiltersFilterLabelsList;
    get filterMatchCriteria(): string;
}
export declare class DataGoogleComputeGlobalForwardingRuleMetadataFiltersList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleComputeGlobalForwardingRuleMetadataFiltersOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/d/compute_global_forwarding_rule google_compute_global_forwarding_rule}
*/
export declare class DataGoogleComputeGlobalForwardingRule extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "google_compute_global_forwarding_rule";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/d/compute_global_forwarding_rule google_compute_global_forwarding_rule} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGoogleComputeGlobalForwardingRuleConfig
    */
    constructor(scope: Construct, id: string, config: DataGoogleComputeGlobalForwardingRuleConfig);
    get description(): string;
    get id(): string;
    get ipAddress(): string;
    get ipProtocol(): string;
    get ipVersion(): string;
    get labelFingerprint(): string;
    labels(key: string): string | cdktf.IResolvable;
    get loadBalancingScheme(): string;
    private _metadataFilters;
    get metadataFilters(): DataGoogleComputeGlobalForwardingRuleMetadataFiltersList;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get network(): string;
    get portRange(): string;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    get selfLink(): string;
    get target(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
