import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleMonitoringIstioCanonicalServiceConfig extends cdktf.TerraformMetaArguments {
    /**
    * The name of the canonical service underlying this service..
                          Corresponds to the destination_service_name metric label in Istio metrics.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/monitoring_istio_canonical_service#canonical_service DataGoogleMonitoringIstioCanonicalService#canonical_service}
    */
    readonly canonicalService: string;
    /**
    * The namespace of the canonical service underlying this service.
                          Corresponds to the destination_service_namespace metric label in Istio metrics.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/monitoring_istio_canonical_service#canonical_service_namespace DataGoogleMonitoringIstioCanonicalService#canonical_service_namespace}
    */
    readonly canonicalServiceNamespace: string;
    /**
    * Identifier for the Istio mesh in which this canonical service is defined.
                          Corresponds to the meshUid metric label in Istio metrics.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/monitoring_istio_canonical_service#mesh_uid DataGoogleMonitoringIstioCanonicalService#mesh_uid}
    */
    readonly meshUid: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/monitoring_istio_canonical_service#project DataGoogleMonitoringIstioCanonicalService#project}
    */
    readonly project?: string;
}
export interface DataGoogleMonitoringIstioCanonicalServiceTelemetry {
}
export declare function dataGoogleMonitoringIstioCanonicalServiceTelemetryToTerraform(struct?: DataGoogleMonitoringIstioCanonicalServiceTelemetry): any;
export declare class DataGoogleMonitoringIstioCanonicalServiceTelemetryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleMonitoringIstioCanonicalServiceTelemetry | undefined;
    set internalValue(value: DataGoogleMonitoringIstioCanonicalServiceTelemetry | undefined);
    get resourceName(): string;
}
export declare class DataGoogleMonitoringIstioCanonicalServiceTelemetryList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleMonitoringIstioCanonicalServiceTelemetryOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/d/monitoring_istio_canonical_service google_monitoring_istio_canonical_service}
*/
export declare class DataGoogleMonitoringIstioCanonicalService extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "google_monitoring_istio_canonical_service";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/d/monitoring_istio_canonical_service google_monitoring_istio_canonical_service} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGoogleMonitoringIstioCanonicalServiceConfig
    */
    constructor(scope: Construct, id: string, config: DataGoogleMonitoringIstioCanonicalServiceConfig);
    private _canonicalService?;
    get canonicalService(): string;
    set canonicalService(value: string);
    get canonicalServiceInput(): string | undefined;
    private _canonicalServiceNamespace?;
    get canonicalServiceNamespace(): string;
    set canonicalServiceNamespace(value: string);
    get canonicalServiceNamespaceInput(): string | undefined;
    get displayName(): string;
    get id(): string;
    private _meshUid?;
    get meshUid(): string;
    set meshUid(value: string);
    get meshUidInput(): string | undefined;
    get name(): string;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    get serviceId(): string;
    private _telemetry;
    get telemetry(): DataGoogleMonitoringIstioCanonicalServiceTelemetryList;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
