import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GkeHubMembershipConfig extends cdktf.TerraformMetaArguments {
    /**
    * Labels to apply to this membership.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/gke_hub_membership#labels GkeHubMembership#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * The client-provided identifier of the membership.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/gke_hub_membership#membership_id GkeHubMembership#membership_id}
    */
    readonly membershipId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/gke_hub_membership#project GkeHubMembership#project}
    */
    readonly project?: string;
    /**
    * authority block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/gke_hub_membership#authority GkeHubMembership#authority}
    */
    readonly authority?: GkeHubMembershipAuthority;
    /**
    * endpoint block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/gke_hub_membership#endpoint GkeHubMembership#endpoint}
    */
    readonly endpoint?: GkeHubMembershipEndpoint;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/gke_hub_membership#timeouts GkeHubMembership#timeouts}
    */
    readonly timeouts?: GkeHubMembershipTimeouts;
}
export interface GkeHubMembershipAuthority {
    /**
    * A JSON Web Token (JWT) issuer URI. 'issuer' must start with 'https://' and // be a valid
  with length <2000 characters. For example: 'https://container.googleapis.com/v1/projects/my-project/locations/us-west1/clusters/my-cluster' (must be 'locations' rather than 'zones'). If the cluster is provisioned with Terraform, this is '"https://container.googleapis.com/v1/${google_container_cluster.my-cluster.id}"'.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/gke_hub_membership#issuer GkeHubMembership#issuer}
    */
    readonly issuer: string;
}
export declare function gkeHubMembershipAuthorityToTerraform(struct?: GkeHubMembershipAuthorityOutputReference | GkeHubMembershipAuthority): any;
export declare class GkeHubMembershipAuthorityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GkeHubMembershipAuthority | undefined;
    set internalValue(value: GkeHubMembershipAuthority | undefined);
    private _issuer?;
    get issuer(): string;
    set issuer(value: string);
    get issuerInput(): string | undefined;
}
export interface GkeHubMembershipEndpointGkeCluster {
    /**
    * Self-link of the GCP resource for the GKE cluster.
  For example: '//container.googleapis.com/projects/my-project/zones/us-west1-a/clusters/my-cluster'.
  It can be at the most 1000 characters in length. If the cluster is provisioned with Terraform,
  this can be '"//container.googleapis.com/${google_container_cluster.my-cluster.id}"' or
  'google_container_cluster.my-cluster.id'.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/gke_hub_membership#resource_link GkeHubMembership#resource_link}
    */
    readonly resourceLink: string;
}
export declare function gkeHubMembershipEndpointGkeClusterToTerraform(struct?: GkeHubMembershipEndpointGkeClusterOutputReference | GkeHubMembershipEndpointGkeCluster): any;
export declare class GkeHubMembershipEndpointGkeClusterOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GkeHubMembershipEndpointGkeCluster | undefined;
    set internalValue(value: GkeHubMembershipEndpointGkeCluster | undefined);
    private _resourceLink?;
    get resourceLink(): string;
    set resourceLink(value: string);
    get resourceLinkInput(): string | undefined;
}
export interface GkeHubMembershipEndpoint {
    /**
    * gke_cluster block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/gke_hub_membership#gke_cluster GkeHubMembership#gke_cluster}
    */
    readonly gkeCluster?: GkeHubMembershipEndpointGkeCluster;
}
export declare function gkeHubMembershipEndpointToTerraform(struct?: GkeHubMembershipEndpointOutputReference | GkeHubMembershipEndpoint): any;
export declare class GkeHubMembershipEndpointOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GkeHubMembershipEndpoint | undefined;
    set internalValue(value: GkeHubMembershipEndpoint | undefined);
    private _gkeCluster;
    get gkeCluster(): GkeHubMembershipEndpointGkeClusterOutputReference;
    putGkeCluster(value: GkeHubMembershipEndpointGkeCluster): void;
    resetGkeCluster(): void;
    get gkeClusterInput(): GkeHubMembershipEndpointGkeCluster | undefined;
}
export interface GkeHubMembershipTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/gke_hub_membership#create GkeHubMembership#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/gke_hub_membership#delete GkeHubMembership#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/gke_hub_membership#update GkeHubMembership#update}
    */
    readonly update?: string;
}
export declare function gkeHubMembershipTimeoutsToTerraform(struct?: GkeHubMembershipTimeoutsOutputReference | GkeHubMembershipTimeouts | cdktf.IResolvable): any;
export declare class GkeHubMembershipTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GkeHubMembershipTimeouts | undefined;
    set internalValue(value: GkeHubMembershipTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/gke_hub_membership google_gke_hub_membership}
*/
export declare class GkeHubMembership extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_gke_hub_membership";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/gke_hub_membership google_gke_hub_membership} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GkeHubMembershipConfig
    */
    constructor(scope: Construct, id: string, config: GkeHubMembershipConfig);
    get id(): string;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _membershipId?;
    get membershipId(): string;
    set membershipId(value: string);
    get membershipIdInput(): string | undefined;
    get name(): string;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _authority;
    get authority(): GkeHubMembershipAuthorityOutputReference;
    putAuthority(value: GkeHubMembershipAuthority): void;
    resetAuthority(): void;
    get authorityInput(): GkeHubMembershipAuthority | undefined;
    private _endpoint;
    get endpoint(): GkeHubMembershipEndpointOutputReference;
    putEndpoint(value: GkeHubMembershipEndpoint): void;
    resetEndpoint(): void;
    get endpointInput(): GkeHubMembershipEndpoint | undefined;
    private _timeouts;
    get timeouts(): GkeHubMembershipTimeoutsOutputReference;
    putTimeouts(value: GkeHubMembershipTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): GkeHubMembershipTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
