import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface MlEngineModelConfig extends cdktf.TerraformMetaArguments {
    /**
    * The description specified for the model when it was created.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/ml_engine_model#description MlEngineModel#description}
    */
    readonly description?: string;
    /**
    * One or more labels that you can add, to organize your models.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/ml_engine_model#labels MlEngineModel#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * The name specified for the model.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/ml_engine_model#name MlEngineModel#name}
    */
    readonly name: string;
    /**
    * If true, online prediction nodes send stderr and stdout streams to Stackdriver Logging
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/ml_engine_model#online_prediction_console_logging MlEngineModel#online_prediction_console_logging}
    */
    readonly onlinePredictionConsoleLogging?: boolean | cdktf.IResolvable;
    /**
    * If true, online prediction access logs are sent to StackDriver Logging.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/ml_engine_model#online_prediction_logging MlEngineModel#online_prediction_logging}
    */
    readonly onlinePredictionLogging?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/ml_engine_model#project MlEngineModel#project}
    */
    readonly project?: string;
    /**
    * The list of regions where the model is going to be deployed.
  Currently only one region per model is supported
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/ml_engine_model#regions MlEngineModel#regions}
    */
    readonly regions?: string[];
    /**
    * default_version block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/ml_engine_model#default_version MlEngineModel#default_version}
    */
    readonly defaultVersion?: MlEngineModelDefaultVersion;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/ml_engine_model#timeouts MlEngineModel#timeouts}
    */
    readonly timeouts?: MlEngineModelTimeouts;
}
export interface MlEngineModelDefaultVersion {
    /**
    * The name specified for the version when it was created.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/ml_engine_model#name MlEngineModel#name}
    */
    readonly name: string;
}
export declare function mlEngineModelDefaultVersionToTerraform(struct?: MlEngineModelDefaultVersionOutputReference | MlEngineModelDefaultVersion): any;
export declare class MlEngineModelDefaultVersionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MlEngineModelDefaultVersion | undefined;
    set internalValue(value: MlEngineModelDefaultVersion | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
}
export interface MlEngineModelTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/ml_engine_model#create MlEngineModel#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/ml_engine_model#delete MlEngineModel#delete}
    */
    readonly delete?: string;
}
export declare function mlEngineModelTimeoutsToTerraform(struct?: MlEngineModelTimeoutsOutputReference | MlEngineModelTimeouts | cdktf.IResolvable): any;
export declare class MlEngineModelTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MlEngineModelTimeouts | undefined;
    set internalValue(value: MlEngineModelTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/ml_engine_model google_ml_engine_model}
*/
export declare class MlEngineModel extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_ml_engine_model";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/ml_engine_model google_ml_engine_model} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options MlEngineModelConfig
    */
    constructor(scope: Construct, id: string, config: MlEngineModelConfig);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    get id(): string;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _onlinePredictionConsoleLogging?;
    get onlinePredictionConsoleLogging(): boolean | cdktf.IResolvable;
    set onlinePredictionConsoleLogging(value: boolean | cdktf.IResolvable);
    resetOnlinePredictionConsoleLogging(): void;
    get onlinePredictionConsoleLoggingInput(): boolean | cdktf.IResolvable | undefined;
    private _onlinePredictionLogging?;
    get onlinePredictionLogging(): boolean | cdktf.IResolvable;
    set onlinePredictionLogging(value: boolean | cdktf.IResolvable);
    resetOnlinePredictionLogging(): void;
    get onlinePredictionLoggingInput(): boolean | cdktf.IResolvable | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _regions?;
    get regions(): string[];
    set regions(value: string[]);
    resetRegions(): void;
    get regionsInput(): string[] | undefined;
    private _defaultVersion;
    get defaultVersion(): MlEngineModelDefaultVersionOutputReference;
    putDefaultVersion(value: MlEngineModelDefaultVersion): void;
    resetDefaultVersion(): void;
    get defaultVersionInput(): MlEngineModelDefaultVersion | undefined;
    private _timeouts;
    get timeouts(): MlEngineModelTimeoutsOutputReference;
    putTimeouts(value: MlEngineModelTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): MlEngineModelTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
