import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface NetworkConnectivityHubConfig extends cdktf.TerraformMetaArguments {
    /**
    * An optional description of the hub.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_connectivity_hub#description NetworkConnectivityHub#description}
    */
    readonly description?: string;
    /**
    * Optional labels in key:value format. For more information about labels, see [Requirements for labels](https://cloud.google.com/resource-manager/docs/creating-managing-labels#requirements).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_connectivity_hub#labels NetworkConnectivityHub#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * Immutable. The name of the hub. Hub names must be unique. They use the following form: `projects/{project_number}/locations/global/hubs/{hub_id}`
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_connectivity_hub#name NetworkConnectivityHub#name}
    */
    readonly name: string;
    /**
    * The project for the resource
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_connectivity_hub#project NetworkConnectivityHub#project}
    */
    readonly project?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_connectivity_hub#timeouts NetworkConnectivityHub#timeouts}
    */
    readonly timeouts?: NetworkConnectivityHubTimeouts;
}
export interface NetworkConnectivityHubRoutingVpcs {
}
export declare function networkConnectivityHubRoutingVpcsToTerraform(struct?: NetworkConnectivityHubRoutingVpcs): any;
export declare class NetworkConnectivityHubRoutingVpcsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): NetworkConnectivityHubRoutingVpcs | undefined;
    set internalValue(value: NetworkConnectivityHubRoutingVpcs | undefined);
    get uri(): string;
}
export declare class NetworkConnectivityHubRoutingVpcsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): NetworkConnectivityHubRoutingVpcsOutputReference;
}
export interface NetworkConnectivityHubTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_connectivity_hub#create NetworkConnectivityHub#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_connectivity_hub#delete NetworkConnectivityHub#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_connectivity_hub#update NetworkConnectivityHub#update}
    */
    readonly update?: string;
}
export declare function networkConnectivityHubTimeoutsToTerraform(struct?: NetworkConnectivityHubTimeoutsOutputReference | NetworkConnectivityHubTimeouts | cdktf.IResolvable): any;
export declare class NetworkConnectivityHubTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): NetworkConnectivityHubTimeouts | undefined;
    set internalValue(value: NetworkConnectivityHubTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/network_connectivity_hub google_network_connectivity_hub}
*/
export declare class NetworkConnectivityHub extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_network_connectivity_hub";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/network_connectivity_hub google_network_connectivity_hub} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options NetworkConnectivityHubConfig
    */
    constructor(scope: Construct, id: string, config: NetworkConnectivityHubConfig);
    get createTime(): string;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    get id(): string;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _routingVpcs;
    get routingVpcs(): NetworkConnectivityHubRoutingVpcsList;
    get state(): string;
    get uniqueId(): string;
    get updateTime(): string;
    private _timeouts;
    get timeouts(): NetworkConnectivityHubTimeoutsOutputReference;
    putTimeouts(value: NetworkConnectivityHubTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): NetworkConnectivityHubTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
