import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface OrganizationIamBindingConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/organization_iam_binding#members OrganizationIamBinding#members}
    */
    readonly members: string[];
    /**
    * The numeric ID of the organization in which you want to manage the audit logging config.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/organization_iam_binding#org_id OrganizationIamBinding#org_id}
    */
    readonly orgId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/organization_iam_binding#role OrganizationIamBinding#role}
    */
    readonly role: string;
    /**
    * condition block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/organization_iam_binding#condition OrganizationIamBinding#condition}
    */
    readonly condition?: OrganizationIamBindingCondition;
}
export interface OrganizationIamBindingCondition {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/organization_iam_binding#description OrganizationIamBinding#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/organization_iam_binding#expression OrganizationIamBinding#expression}
    */
    readonly expression: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/organization_iam_binding#title OrganizationIamBinding#title}
    */
    readonly title: string;
}
export declare function organizationIamBindingConditionToTerraform(struct?: OrganizationIamBindingConditionOutputReference | OrganizationIamBindingCondition): any;
export declare class OrganizationIamBindingConditionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): OrganizationIamBindingCondition | undefined;
    set internalValue(value: OrganizationIamBindingCondition | undefined);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _expression?;
    get expression(): string;
    set expression(value: string);
    get expressionInput(): string | undefined;
    private _title?;
    get title(): string;
    set title(value: string);
    get titleInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/organization_iam_binding google_organization_iam_binding}
*/
export declare class OrganizationIamBinding extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_organization_iam_binding";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/organization_iam_binding google_organization_iam_binding} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options OrganizationIamBindingConfig
    */
    constructor(scope: Construct, id: string, config: OrganizationIamBindingConfig);
    get etag(): string;
    get id(): string;
    private _members?;
    get members(): string[];
    set members(value: string[]);
    get membersInput(): string[] | undefined;
    private _orgId?;
    get orgId(): string;
    set orgId(value: string);
    get orgIdInput(): string | undefined;
    private _role?;
    get role(): string;
    set role(value: string);
    get roleInput(): string | undefined;
    private _condition;
    get condition(): OrganizationIamBindingConditionOutputReference;
    putCondition(value: OrganizationIamBindingCondition): void;
    resetCondition(): void;
    get conditionInput(): OrganizationIamBindingCondition | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
