"""
dLux/sandbox/JWST/constants.py
------------------------------
This contains the vertices of the primary mirror segments taken form 
the WebbPSF package.
"""

from jax import numpy as np
from jax.config import config


config.update("jax_enable_x64", True)


JWST_PRIMARY_SEGMENTS = (
    ('A1-1', np.array([
        [-0.38101, 0.667604],
        [-0.758826, 1.321999],
        [-0.38101, 1.976407],
        [0.38101, 1.976407],
        [0.758826, 1.321999],
        [0.38101, 0.667604]])),
    ('A2-2', np.array([
        [0.38765702, 0.66376634],
        [0.76547172, 1.31816209],
        [1.52111367, 1.31816784],
        [1.90212367, 0.65823916],
        [1.52429772, 0.00383691],
        [0.76866702, 0.00383766]])),
    ('A3-3', np.array([
        [0.76866702, -0.00383766],
        [1.52429772, -0.00383691],
        [1.90212367, -0.65823916],
        [1.52111367, -1.31816784],
        [0.76547172, -1.31816209],
        [0.38765702, -0.66376634]])),
    ('A4-4', np.array([
        [0.38101, -0.667604],
        [0.758826, -1.321999],
        [0.38101, -1.976407],
        [-0.38101, -1.976407],
        [-0.758826, -1.321999],
        [-0.38101, -0.667604]])),
    ('A5-5', np.array([
        [-0.38765702, -0.66376634],
        [-0.76547172, -1.31816209],
        [-1.52111367, -1.31816784],
        [-1.90212367, -0.65823916],
        [-1.52429772, -0.00383691],
        [-0.76866702, -0.00383766]])),
    ('A6-6', np.array([
        [-0.76866702, 0.00383766],
        [-1.52429772, 0.00383691],
        [-1.90212367, 0.65823916],
        [-1.52111367, 1.31816784],
        [-0.76547172, 1.31816209],
        [-0.38765702, 0.66376634]])),
    ('B1-7', np.array([
        [0.38101, 3.279674],
        [0.758826, 2.631791],
        [0.38101, 1.98402],
        [-0.38101, 1.98402],
        [-0.758826, 2.631791],
        [-0.38101, 3.279674]])),
    ('B2-9', np.array([
        [3.030786, 1.30987266],
        [2.65861086, 0.65873291],
        [1.90871672, 0.66204566],
        [1.52770672, 1.32197434],
        [1.89978486, 1.97305809],
        [2.649776, 1.96980134]])),
    ('B3-11', np.array([
        [2.649776, -1.96980134],
        [1.89978486, -1.97305809],
        [1.52770672, -1.32197434],
        [1.90871672, -0.66204566],
        [2.65861086, -0.65873291],
        [3.030786, -1.30987266]])),
    ('B4-13', np.array([
        [-0.38101, -3.279674],
        [-0.758826, -2.631791],
        [-0.38101, -1.98402],
        [0.38101, -1.98402],
        [0.758826, -2.631791],
        [0.38101, -3.279674]])),
    ('B5-15', np.array([
        [-3.030786, -1.30987266],
        [-2.65861086, -0.65873291],
        [-1.90871672, -0.66204566],
        [-1.52770672, -1.32197434],
        [-1.89978486, -1.97305809],
        [-2.649776, -1.96980134]])),
    ('B6-17', np.array([
        [-2.649776, 1.96980134],
        [-1.89978486, 1.97305809],
        [-1.52770672, 1.32197434],
        [-1.90871672, 0.66204566],
        [-2.65861086, 0.65873291],
        [-3.030786, 1.30987266]])),
    ('C1-8', np.array([
        [0.765201, 2.627516],
        [1.517956, 2.629178],
        [1.892896, 1.976441],
        [1.521076, 1.325812],
        [0.765454, 1.325807],
        [0.387649, 1.980196]])),
    ('C2-10', np.array([
        [2.6580961, 0.651074495],
        [3.03591294, 5.42172989e-07],
        [2.65809612, -0.651075523],
        [1.90872487, -0.654384457],
        [1.53090954, 8.90571587e-07],
        [1.90872454, .654384118]])),
    ('C3-12', np.array([
        [1.8928951, -1.97644151],
        [1.51795694, -2.62917746],
        [0.76520012, -2.62751652],
        [0.38764887, -1.98019646],
        [0.76545554, -1.32580611],
        [1.52107554, -1.32581188]])),
    ('C4-14', np.array([
        [-0.765201, -2.627516],
        [-1.517956, -2.629178],
        [-1.892896, -1.976441],
        [-1.521076, -1.325812],
        [-0.765454, -1.325807],
        [-0.387649, -1.980196]])),
    ('C5-16', np.array([
        [-2.6580961, -.651074495],
        [-3.03591294, -5.42172990e-07],
        [-2.65809612, .651075523],
        [-1.90872487, .654384457],
        [-1.53090954, -8.90571587e-07],
        [-1.90872454, -.654384118]])),
    ('C6-18', np.array([
        [-1.8928951, 1.97644151],
        [-1.51795694, 2.62917746],
        [-0.76520012, 2.62751652],
        [-0.38764887, 1.98019646],
        [-0.76545554, 1.32580611],
        [-1.52107554, 1.32581188]])),
)
