"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Account = exports.AccountProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const rds_generated_1 = require("./rds.generated");
Object.defineProperty(exports, "AccountProperty", { enumerable: true, get: function () { return rds_generated_1.RosAccount; } });
/**
 * A ROS resource type:  `ALIYUN::RDS::Account`
 */
class Account extends ros.Resource {
    /**
     * Create a new `ALIYUN::RDS::Account`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosAccount = new rds_generated_1.RosAccount(this, id, {
            accountDescription: props.accountDescription,
            dbInstanceId: props.dbInstanceId,
            accountType: props.accountType ? props.accountType : 'Normal',
            accountPassword: props.accountPassword,
            accountName: props.accountName,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosAccount;
        this.attrAccountName = rosAccount.attrAccountName;
    }
}
exports.Account = Account;
//# sourceMappingURL=data:application/json;base64,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