"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Database = exports.DatabaseProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const rds_generated_1 = require("./rds.generated");
Object.defineProperty(exports, "DatabaseProperty", { enumerable: true, get: function () { return rds_generated_1.RosDatabase; } });
/**
 * A ROS resource type:  `ALIYUN::RDS::Database`
 */
class Database extends ros.Resource {
    /**
     * Create a new `ALIYUN::RDS::Database`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosDatabase = new rds_generated_1.RosDatabase(this, id, {
            characterSetName: props.characterSetName,
            dbInstanceId: props.dbInstanceId,
            dbDescription: props.dbDescription,
            dbName: props.dbName,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosDatabase;
        this.attrDbInstanceId = rosDatabase.attrDbInstanceId;
        this.attrDbName = rosDatabase.attrDbName;
    }
}
exports.Database = Database;
//# sourceMappingURL=data:application/json;base64,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