"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DBInstanceParameterGroup = exports.DBInstanceParameterGroupProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const rds_generated_1 = require("./rds.generated");
Object.defineProperty(exports, "DBInstanceParameterGroupProperty", { enumerable: true, get: function () { return rds_generated_1.RosDBInstanceParameterGroup; } });
/**
 * A ROS resource type:  `ALIYUN::RDS::DBInstanceParameterGroup`
 */
class DBInstanceParameterGroup extends ros.Resource {
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the properties of this ROS resource, which will be assigned to ROS resource.
     */
    /**
     * Create a new `ALIYUN::RDS::DBInstanceParameterGroup`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosDBInstanceParameterGroup = new rds_generated_1.RosDBInstanceParameterGroup(this, id, {
            parameters: props.parameters,
            dbInstanceId: props.dbInstanceId,
            forcerestart: props.forcerestart ? props.forcerestart : 'false',
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosDBInstanceParameterGroup;
    }
}
exports.DBInstanceParameterGroup = DBInstanceParameterGroup;
//# sourceMappingURL=data:application/json;base64,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