"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.KongControlPlaneECS = void 0;
const aws_ecs_1 = require("aws-cdk-lib/aws-ecs");
const secretManager = require("aws-cdk-lib/aws-secretsmanager");
const constructs_1 = require("constructs");
// import { KongControlPlane } from '../KongControlPlane';
const kong_admin_service_1 = require("./kong-admin-service");
const kong_admin_taskdefinition_1 = require("./kong-admin-taskdefinition");
class KongControlPlaneECS extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        let secrets = {};
        if (props.rds.secret) {
            secrets.KONG_PG_USERNAME = aws_ecs_1.Secret.fromSecretsManager(props.rds.secret, 'username');
            secrets.KONG_PG_PASSWORD = aws_ecs_1.Secret.fromSecretsManager(props.rds.secret, 'password');
            if (props.licenseSecret) {
                const licenseSecret = secretManager.Secret.fromSecretNameV2(this, 'KongCPLicense', props.licenseSecret ?? '');
                secrets.KONG_LICENSE_DATA = aws_ecs_1.Secret.fromSecretsManager(licenseSecret, 'license');
            }
        }
        const kongAdminTaskDefinition = new kong_admin_taskdefinition_1.KongAdminTaskdefinition(this, 'KongCPTaskDefinition', {
            hostedZoneName: props.hostedZoneName,
            image: props.image,
            dbInstanceEndpointAddress: props.rds.dbInstanceEndpointAddress,
            dbInstanceEndpointPort: props.rds.dbInstanceEndpointPort,
            secrets: secrets,
            cluster: props.cluster,
            certificates: props.certificates,
            kongFeaturesProps: props.kongFeaturesProps,
            kongTaskProps: props.kongTaskProps,
        });
        new kong_admin_service_1.KongAdminService(this, 'KongCPFargateService', {
            kongServiceProps: {
                cluster: props.cluster,
                taskDefinition: kongAdminTaskDefinition,
                desiredCount: props.desiredCount,
            },
            adminNlb: props.adminNlb,
            managerNlb: props.managerNlb,
            devPortalNlb: props.devPortalNlb,
            kongFeaturesProps: props.kongFeaturesProps,
            hostedZoneName: props.hostedZoneName,
        });
    }
}
exports.KongControlPlaneECS = KongControlPlaneECS;
//# sourceMappingURL=data:application/json;base64,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