"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.MediaPipelineResources = void 0;
/* eslint-disable @typescript-eslint/indent */
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_iam_1 = require("aws-cdk-lib/aws-iam");
const custom_resources_1 = require("aws-cdk-lib/custom-resources");
const constructs_1 = require("constructs");
const media_pipelines_function_1 = require("../resources/media-pipelines/media-pipelines-function");
class MediaPipelineResources extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        this.lambda = this.ensureLambda();
        const MediaPipelineResourceProvider = new custom_resources_1.Provider(this, 'MediaPipelineResourceProvider', {
            onEventHandler: this.lambda,
        });
        this.mediaPipelineCustomResource = new aws_cdk_lib_1.CustomResource(this, 'mediaPipelineCustomResource', {
            serviceToken: MediaPipelineResourceProvider.serviceToken,
            properties: { ...props },
        });
    }
    ensureLambda() {
        const stack = aws_cdk_lib_1.Stack.of(this);
        // const constructName = 'MediaPipelineResources';
        // const existing = stack.node.tryFindChild(constructName);
        // istanbul ignore next */
        // if (existing) {
        //   return existing as Function;
        // }
        const mediaPipelineCustomResourceRole = new aws_iam_1.Role(this, 'mediaPipelineCustomResourceRole', {
            description: 'Amazon Chime SDK Media Pipeline Resources',
            assumedBy: new aws_iam_1.ServicePrincipal('lambda.amazonaws.com'),
            inlinePolicies: {
                ['chimePolicy']: new aws_iam_1.PolicyDocument({
                    statements: [
                        new aws_iam_1.PolicyStatement({
                            resources: ['*'],
                            actions: [
                                'chime:*MediaInsightsPipelineConfiguration',
                                'chime:ListVoiceConnectors',
                                'chime:tagResource',
                                's3:ListBucket',
                                'kinesis:DescribeStream',
                                'logs:GetLogDelivery',
                                'logs:DeleteLogDelivery',
                                'logs:ListLogDeliveries',
                                'logs:CreateLogGroup',
                                'logs:DescribeResourcePolicies',
                                'logs:PutResourcePolicy',
                                'logs:DescribeLogGroups',
                                'logs:CreateLogDelivery',
                                'lambda:GetPolicy',
                                'lambda:AddPermission',
                                'iam:PutRolePolicy',
                                'iam:CreateServiceLinkedRole',
                                'iam:PassRole',
                            ],
                        }),
                        new aws_iam_1.PolicyStatement({
                            resources: [
                                `arn:aws:ssm:${stack.region}:${stack.account}:parameter/chime/*`,
                            ],
                            actions: [
                                'ssm:PutParameter',
                                'ssm:GetParameter',
                                'ssm:DeleteParameter',
                            ],
                        }),
                    ],
                }),
            },
            managedPolicies: [
                aws_iam_1.ManagedPolicy.fromAwsManagedPolicyName('service-role/AWSLambdaBasicExecutionRole'),
            ],
        });
        const fn = new media_pipelines_function_1.MediaPipelinesFunction(this, 'MediaPipelinesFunction', {
            role: mediaPipelineCustomResourceRole,
            timeout: aws_cdk_lib_1.Duration.seconds(60),
        });
        return fn;
    }
}
exports.MediaPipelineResources = MediaPipelineResources;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibWVkaWFQaXBlbGluZXNDdXN0b21SZXNvdXJjZXMuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi9zcmMvbWVkaWEtcGlwZWxpbmVzL21lZGlhUGlwZWxpbmVzQ3VzdG9tUmVzb3VyY2VzLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7OztBQUFBLDhDQUE4QztBQUM5Qyw2Q0FBNkU7QUFDN0UsaURBTTZCO0FBRTdCLG1FQUF3RDtBQUN4RCwyQ0FBdUM7QUFDdkMsb0dBQStGO0FBUS9GLE1BQWEsc0JBQXVCLFNBQVEsc0JBQVM7SUFJbkQsWUFBWSxLQUFnQixFQUFFLEVBQVUsRUFBRSxLQUFpQztRQUN6RSxLQUFLLENBQUMsS0FBSyxFQUFFLEVBQUUsQ0FBQyxDQUFDO1FBQ2pCLElBQUksQ0FBQyxNQUFNLEdBQUcsSUFBSSxDQUFDLFlBQVksRUFBRSxDQUFDO1FBRWxDLE1BQU0sNkJBQTZCLEdBQUcsSUFBSSwyQkFBUSxDQUNoRCxJQUFJLEVBQ0osK0JBQStCLEVBQy9CO1lBQ0UsY0FBYyxFQUFFLElBQUksQ0FBQyxNQUFNO1NBQzVCLENBQ0YsQ0FBQztRQUVGLElBQUksQ0FBQywyQkFBMkIsR0FBRyxJQUFJLDRCQUFjLENBQ25ELElBQUksRUFDSiw2QkFBNkIsRUFDN0I7WUFDRSxZQUFZLEVBQUUsNkJBQTZCLENBQUMsWUFBWTtZQUN4RCxVQUFVLEVBQUUsRUFBRSxHQUFHLEtBQUssRUFBRTtTQUN6QixDQUNGLENBQUM7SUFDSixDQUFDO0lBRU8sWUFBWTtRQUNsQixNQUFNLEtBQUssR0FBRyxtQkFBSyxDQUFDLEVBQUUsQ0FBQyxJQUFJLENBQUMsQ0FBQztRQUM3QixrREFBa0Q7UUFDbEQsMkRBQTJEO1FBQzNELDBCQUEwQjtRQUMxQixrQkFBa0I7UUFDbEIsaUNBQWlDO1FBQ2pDLElBQUk7UUFFSixNQUFNLCtCQUErQixHQUFHLElBQUksY0FBSSxDQUM5QyxJQUFJLEVBQ0osaUNBQWlDLEVBQ2pDO1lBQ0UsV0FBVyxFQUFFLDJDQUEyQztZQUN4RCxTQUFTLEVBQUUsSUFBSSwwQkFBZ0IsQ0FBQyxzQkFBc0IsQ0FBQztZQUN2RCxjQUFjLEVBQUU7Z0JBQ2QsQ0FBQyxhQUFhLENBQUMsRUFBRSxJQUFJLHdCQUFjLENBQUM7b0JBQ2xDLFVBQVUsRUFBRTt3QkFDVixJQUFJLHlCQUFlLENBQUM7NEJBQ2xCLFNBQVMsRUFBRSxDQUFDLEdBQUcsQ0FBQzs0QkFDaEIsT0FBTyxFQUFFO2dDQUNQLDJDQUEyQztnQ0FDM0MsMkJBQTJCO2dDQUMzQixtQkFBbUI7Z0NBQ25CLGVBQWU7Z0NBQ2Ysd0JBQXdCO2dDQUN4QixxQkFBcUI7Z0NBQ3JCLHdCQUF3QjtnQ0FDeEIsd0JBQXdCO2dDQUN4QixxQkFBcUI7Z0NBQ3JCLCtCQUErQjtnQ0FDL0Isd0JBQXdCO2dDQUN4Qix3QkFBd0I7Z0NBQ3hCLHdCQUF3QjtnQ0FDeEIsa0JBQWtCO2dDQUNsQixzQkFBc0I7Z0NBQ3RCLG1CQUFtQjtnQ0FDbkIsNkJBQTZCO2dDQUM3QixjQUFjOzZCQUNmO3lCQUNGLENBQUM7d0JBQ0YsSUFBSSx5QkFBZSxDQUFDOzRCQUNsQixTQUFTLEVBQUU7Z0NBQ1QsZUFBZSxLQUFLLENBQUMsTUFBTSxJQUFJLEtBQUssQ0FBQyxPQUFPLG9CQUFvQjs2QkFDakU7NEJBQ0QsT0FBTyxFQUFFO2dDQUNQLGtCQUFrQjtnQ0FDbEIsa0JBQWtCO2dDQUNsQixxQkFBcUI7NkJBQ3RCO3lCQUNGLENBQUM7cUJBQ0g7aUJBQ0YsQ0FBQzthQUNIO1lBQ0QsZUFBZSxFQUFFO2dCQUNmLHVCQUFhLENBQUMsd0JBQXdCLENBQ3BDLDBDQUEwQyxDQUMzQzthQUNGO1NBQ0YsQ0FDRixDQUFDO1FBRUYsTUFBTSxFQUFFLEdBQUcsSUFBSSxpREFBc0IsQ0FBQyxJQUFJLEVBQUUsd0JBQXdCLEVBQUU7WUFDcEUsSUFBSSxFQUFFLCtCQUErQjtZQUNyQyxPQUFPLEVBQUUsc0JBQVEsQ0FBQyxPQUFPLENBQUMsRUFBRSxDQUFDO1NBQzlCLENBQUMsQ0FBQztRQUVILE9BQU8sRUFBYyxDQUFDO0lBQ3hCLENBQUM7Q0FDRjtBQS9GRCx3REErRkMiLCJzb3VyY2VzQ29udGVudCI6WyIvKiBlc2xpbnQtZGlzYWJsZSBAdHlwZXNjcmlwdC1lc2xpbnQvaW5kZW50ICovXG5pbXBvcnQgeyBEdXJhdGlvbiwgQ3VzdG9tUmVzb3VyY2UsIFJlc291cmNlUHJvcHMsIFN0YWNrIH0gZnJvbSAnYXdzLWNkay1saWInO1xuaW1wb3J0IHtcbiAgU2VydmljZVByaW5jaXBhbCxcbiAgUm9sZSxcbiAgTWFuYWdlZFBvbGljeSxcbiAgUG9saWN5RG9jdW1lbnQsXG4gIFBvbGljeVN0YXRlbWVudCxcbn0gZnJvbSAnYXdzLWNkay1saWIvYXdzLWlhbSc7XG5pbXBvcnQgeyBJRnVuY3Rpb24sIEZ1bmN0aW9uIH0gZnJvbSAnYXdzLWNkay1saWIvYXdzLWxhbWJkYSc7XG5pbXBvcnQgeyBQcm92aWRlciB9IGZyb20gJ2F3cy1jZGstbGliL2N1c3RvbS1yZXNvdXJjZXMnO1xuaW1wb3J0IHsgQ29uc3RydWN0IH0gZnJvbSAnY29uc3RydWN0cyc7XG5pbXBvcnQgeyBNZWRpYVBpcGVsaW5lc0Z1bmN0aW9uIH0gZnJvbSAnLi4vcmVzb3VyY2VzL21lZGlhLXBpcGVsaW5lcy9tZWRpYS1waXBlbGluZXMtZnVuY3Rpb24nO1xuXG5leHBvcnQgaW50ZXJmYWNlIE1lZGlhUGlwZWxpbmVSZXNvdXJjZVByb3BzIGV4dGVuZHMgUmVzb3VyY2VQcm9wcyB7XG4gIHJlYWRvbmx5IHByb3BlcnRpZXM6IHsgW3Byb3BuYW1lOiBzdHJpbmddOiBhbnkgfTtcbiAgcmVhZG9ubHkgcmVzb3VyY2VUeXBlOiAnTWVkaWFQaXBlbGluZUluc2lnaHRzJztcbiAgcmVhZG9ubHkgdWlkOiBzdHJpbmc7XG59XG5cbmV4cG9ydCBjbGFzcyBNZWRpYVBpcGVsaW5lUmVzb3VyY2VzIGV4dGVuZHMgQ29uc3RydWN0IHtcbiAgcHVibGljIHJlYWRvbmx5IGxhbWJkYTogSUZ1bmN0aW9uO1xuICBwdWJsaWMgcmVhZG9ubHkgbWVkaWFQaXBlbGluZUN1c3RvbVJlc291cmNlOiBDdXN0b21SZXNvdXJjZTtcblxuICBjb25zdHJ1Y3RvcihzY29wZTogQ29uc3RydWN0LCBpZDogc3RyaW5nLCBwcm9wczogTWVkaWFQaXBlbGluZVJlc291cmNlUHJvcHMpIHtcbiAgICBzdXBlcihzY29wZSwgaWQpO1xuICAgIHRoaXMubGFtYmRhID0gdGhpcy5lbnN1cmVMYW1iZGEoKTtcblxuICAgIGNvbnN0IE1lZGlhUGlwZWxpbmVSZXNvdXJjZVByb3ZpZGVyID0gbmV3IFByb3ZpZGVyKFxuICAgICAgdGhpcyxcbiAgICAgICdNZWRpYVBpcGVsaW5lUmVzb3VyY2VQcm92aWRlcicsXG4gICAgICB7XG4gICAgICAgIG9uRXZlbnRIYW5kbGVyOiB0aGlzLmxhbWJkYSxcbiAgICAgIH0sXG4gICAgKTtcblxuICAgIHRoaXMubWVkaWFQaXBlbGluZUN1c3RvbVJlc291cmNlID0gbmV3IEN1c3RvbVJlc291cmNlKFxuICAgICAgdGhpcyxcbiAgICAgICdtZWRpYVBpcGVsaW5lQ3VzdG9tUmVzb3VyY2UnLFxuICAgICAge1xuICAgICAgICBzZXJ2aWNlVG9rZW46IE1lZGlhUGlwZWxpbmVSZXNvdXJjZVByb3ZpZGVyLnNlcnZpY2VUb2tlbixcbiAgICAgICAgcHJvcGVydGllczogeyAuLi5wcm9wcyB9LFxuICAgICAgfSxcbiAgICApO1xuICB9XG5cbiAgcHJpdmF0ZSBlbnN1cmVMYW1iZGEoKTogRnVuY3Rpb24ge1xuICAgIGNvbnN0IHN0YWNrID0gU3RhY2sub2YodGhpcyk7XG4gICAgLy8gY29uc3QgY29uc3RydWN0TmFtZSA9ICdNZWRpYVBpcGVsaW5lUmVzb3VyY2VzJztcbiAgICAvLyBjb25zdCBleGlzdGluZyA9IHN0YWNrLm5vZGUudHJ5RmluZENoaWxkKGNvbnN0cnVjdE5hbWUpO1xuICAgIC8vIGlzdGFuYnVsIGlnbm9yZSBuZXh0ICovXG4gICAgLy8gaWYgKGV4aXN0aW5nKSB7XG4gICAgLy8gICByZXR1cm4gZXhpc3RpbmcgYXMgRnVuY3Rpb247XG4gICAgLy8gfVxuXG4gICAgY29uc3QgbWVkaWFQaXBlbGluZUN1c3RvbVJlc291cmNlUm9sZSA9IG5ldyBSb2xlKFxuICAgICAgdGhpcyxcbiAgICAgICdtZWRpYVBpcGVsaW5lQ3VzdG9tUmVzb3VyY2VSb2xlJyxcbiAgICAgIHtcbiAgICAgICAgZGVzY3JpcHRpb246ICdBbWF6b24gQ2hpbWUgU0RLIE1lZGlhIFBpcGVsaW5lIFJlc291cmNlcycsXG4gICAgICAgIGFzc3VtZWRCeTogbmV3IFNlcnZpY2VQcmluY2lwYWwoJ2xhbWJkYS5hbWF6b25hd3MuY29tJyksXG4gICAgICAgIGlubGluZVBvbGljaWVzOiB7XG4gICAgICAgICAgWydjaGltZVBvbGljeSddOiBuZXcgUG9saWN5RG9jdW1lbnQoe1xuICAgICAgICAgICAgc3RhdGVtZW50czogW1xuICAgICAgICAgICAgICBuZXcgUG9saWN5U3RhdGVtZW50KHtcbiAgICAgICAgICAgICAgICByZXNvdXJjZXM6IFsnKiddLFxuICAgICAgICAgICAgICAgIGFjdGlvbnM6IFtcbiAgICAgICAgICAgICAgICAgICdjaGltZToqTWVkaWFJbnNpZ2h0c1BpcGVsaW5lQ29uZmlndXJhdGlvbicsXG4gICAgICAgICAgICAgICAgICAnY2hpbWU6TGlzdFZvaWNlQ29ubmVjdG9ycycsXG4gICAgICAgICAgICAgICAgICAnY2hpbWU6dGFnUmVzb3VyY2UnLFxuICAgICAgICAgICAgICAgICAgJ3MzOkxpc3RCdWNrZXQnLFxuICAgICAgICAgICAgICAgICAgJ2tpbmVzaXM6RGVzY3JpYmVTdHJlYW0nLFxuICAgICAgICAgICAgICAgICAgJ2xvZ3M6R2V0TG9nRGVsaXZlcnknLFxuICAgICAgICAgICAgICAgICAgJ2xvZ3M6RGVsZXRlTG9nRGVsaXZlcnknLFxuICAgICAgICAgICAgICAgICAgJ2xvZ3M6TGlzdExvZ0RlbGl2ZXJpZXMnLFxuICAgICAgICAgICAgICAgICAgJ2xvZ3M6Q3JlYXRlTG9nR3JvdXAnLFxuICAgICAgICAgICAgICAgICAgJ2xvZ3M6RGVzY3JpYmVSZXNvdXJjZVBvbGljaWVzJyxcbiAgICAgICAgICAgICAgICAgICdsb2dzOlB1dFJlc291cmNlUG9saWN5JyxcbiAgICAgICAgICAgICAgICAgICdsb2dzOkRlc2NyaWJlTG9nR3JvdXBzJyxcbiAgICAgICAgICAgICAgICAgICdsb2dzOkNyZWF0ZUxvZ0RlbGl2ZXJ5JyxcbiAgICAgICAgICAgICAgICAgICdsYW1iZGE6R2V0UG9saWN5JyxcbiAgICAgICAgICAgICAgICAgICdsYW1iZGE6QWRkUGVybWlzc2lvbicsXG4gICAgICAgICAgICAgICAgICAnaWFtOlB1dFJvbGVQb2xpY3knLFxuICAgICAgICAgICAgICAgICAgJ2lhbTpDcmVhdGVTZXJ2aWNlTGlua2VkUm9sZScsXG4gICAgICAgICAgICAgICAgICAnaWFtOlBhc3NSb2xlJyxcbiAgICAgICAgICAgICAgICBdLFxuICAgICAgICAgICAgICB9KSxcbiAgICAgICAgICAgICAgbmV3IFBvbGljeVN0YXRlbWVudCh7XG4gICAgICAgICAgICAgICAgcmVzb3VyY2VzOiBbXG4gICAgICAgICAgICAgICAgICBgYXJuOmF3czpzc206JHtzdGFjay5yZWdpb259OiR7c3RhY2suYWNjb3VudH06cGFyYW1ldGVyL2NoaW1lLypgLFxuICAgICAgICAgICAgICAgIF0sXG4gICAgICAgICAgICAgICAgYWN0aW9uczogW1xuICAgICAgICAgICAgICAgICAgJ3NzbTpQdXRQYXJhbWV0ZXInLFxuICAgICAgICAgICAgICAgICAgJ3NzbTpHZXRQYXJhbWV0ZXInLFxuICAgICAgICAgICAgICAgICAgJ3NzbTpEZWxldGVQYXJhbWV0ZXInLFxuICAgICAgICAgICAgICAgIF0sXG4gICAgICAgICAgICAgIH0pLFxuICAgICAgICAgICAgXSxcbiAgICAgICAgICB9KSxcbiAgICAgICAgfSxcbiAgICAgICAgbWFuYWdlZFBvbGljaWVzOiBbXG4gICAgICAgICAgTWFuYWdlZFBvbGljeS5mcm9tQXdzTWFuYWdlZFBvbGljeU5hbWUoXG4gICAgICAgICAgICAnc2VydmljZS1yb2xlL0FXU0xhbWJkYUJhc2ljRXhlY3V0aW9uUm9sZScsXG4gICAgICAgICAgKSxcbiAgICAgICAgXSxcbiAgICAgIH0sXG4gICAgKTtcblxuICAgIGNvbnN0IGZuID0gbmV3IE1lZGlhUGlwZWxpbmVzRnVuY3Rpb24odGhpcywgJ01lZGlhUGlwZWxpbmVzRnVuY3Rpb24nLCB7XG4gICAgICByb2xlOiBtZWRpYVBpcGVsaW5lQ3VzdG9tUmVzb3VyY2VSb2xlLFxuICAgICAgdGltZW91dDogRHVyYXRpb24uc2Vjb25kcyg2MCksXG4gICAgfSk7XG5cbiAgICByZXR1cm4gZm4gYXMgRnVuY3Rpb247XG4gIH1cbn1cbiJdfQ==