"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ChimeSipRule = exports.TriggerType = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// import {
//   SipRuleTargetApplication,
//   TriggerType,
// } from '@aws-sdk/client-chime-sdk-voice';
const cdk = require("aws-cdk-lib");
const constructs_1 = require("constructs");
const pstnCustomResources_1 = require("./pstnCustomResources");
const sipRuleValidator_1 = require("./sipRuleValidator");
var TriggerType;
(function (TriggerType) {
    TriggerType["TO_PHONE_NUMBER"] = "ToPhoneNumber";
    TriggerType["REQUEST_URI_HOSTNAME"] = "RequestUriHostname";
})(TriggerType = exports.TriggerType || (exports.TriggerType = {}));
class ChimeSipRule extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const uid = cdk.Names.uniqueId(this);
        const { name, triggerType, triggerValue, targetApplications } = props;
        sipRuleValidator_1.sipRuleValidator(props);
        const sipRuleRequest = new pstnCustomResources_1.PSTNResources(this, 'sipRuleRequest', {
            resourceType: 'SMARule',
            uid: uid,
            properties: {
                name: name ?? uid,
                triggerType: triggerType,
                triggerValue: triggerValue,
                targetApplications: targetApplications,
            },
        });
        this.sipRuleId =
            sipRuleRequest.pstnCustomResource.getAttString('sipRuleId');
    }
}
exports.ChimeSipRule = ChimeSipRule;
_a = JSII_RTTI_SYMBOL_1;
ChimeSipRule[_a] = { fqn: "cdk-amazon-chime-resources.ChimeSipRule", version: "2.2.4" };
//# sourceMappingURL=data:application/json;base64,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