"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ChimeVoiceProfileDomain = void 0;
// import { Termination } from '@aws-sdk/client-chime-sdk-voice';
const cdk = require("aws-cdk-lib");
const constructs_1 = require("constructs");
const pstnCustomResources_1 = require("./pstnCustomResources");
class ChimeVoiceProfileDomain extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const uid = cdk.Names.uniqueId(this);
        const { name, description, serverSideEncryptionConfiguration, clientRequestToken, tags, } = props;
        const voiceProfileDomainRequest = new pstnCustomResources_1.PSTNResources(this, 'voiceConnectorRequest', {
            resourceType: 'VoiceProfileDomain',
            uid: uid,
            properties: {
                name: name ?? uid,
                description: description,
                serverSideEncryptionConfiguration: serverSideEncryptionConfiguration,
                clientRequestToken: clientRequestToken,
                tags: tags,
            },
        });
        this.voiceProfileDomainId =
            voiceProfileDomainRequest.pstnCustomResource.getAttString('voiceProfileDomainId');
        this.voiceProfileDomainArn =
            voiceProfileDomainRequest.pstnCustomResource.getAttString('voiceProfileDomainArn');
        this.voiceProfileDomainName =
            voiceProfileDomainRequest.pstnCustomResource.getAttString('voiceProfileDomainName');
    }
}
exports.ChimeVoiceProfileDomain = ChimeVoiceProfileDomain;
//# sourceMappingURL=data:application/json;base64,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