"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DeleteVoiceProfileDomain = exports.UpdateVoiceProfileDomain = exports.CreateVoiceProfileDomain = void 0;
/* eslint-disable import/no-extraneous-dependencies */
const client_chime_sdk_voice_1 = require("@aws-sdk/client-chime-sdk-voice");
const client_ssm_1 = require("@aws-sdk/client-ssm");
const chimeSDKVoiceClient = new client_chime_sdk_voice_1.ChimeSDKVoiceClient({
    region: process.env.AWS_REGION,
});
const ssmClient = new client_ssm_1.SSMClient({ region: process.env.AWS_REGION });
let formattedCreateVoiceProfileDomainParams;
let createVoiceProfileDomainResponse;
let getParameterCommandOutput;
let voiceProfileDomainId;
let updateVoiceProfileDomainParams;
let updateVoiceProfileDomainResponse;
let deleteVoiceProfileDomainResponse;
let formattedTags = [];
function capitalizeKeys(obj) {
    if (Array.isArray(obj)) {
        return obj.map((item) => capitalizeKeys(item));
    }
    if (typeof obj === 'object') {
        const capitalizedObj = {};
        for (const key in obj) {
            if (obj.hasOwnProperty(key)) {
                const capitalizedKey = key.charAt(0).toUpperCase() + key.slice(1);
                const value = obj[key];
                capitalizedObj[capitalizedKey] =
                    typeof value === 'string' && !isNaN(parseFloat(value))
                        ? parseFloat(value)
                        : capitalizeKeys(value);
            }
        }
        return capitalizedObj;
    }
    return obj;
}
const formatProps = (props) => {
    console.info(`Formatting Props: ${JSON.stringify(props)}`);
    if (props.tags) {
        console.info(`Formatting Tags: ${JSON.stringify(props.tags)}`);
        props.tags.forEach((tag) => {
            formattedTags.push(capitalizeKeys(tag));
        });
        console.info(`Formatted Tags: ${JSON.stringify(formattedTags)}`);
    }
    formattedCreateVoiceProfileDomainParams = {
        Name: props.name,
        ...(props.tags && { Tags: formattedTags }),
        ...(props.clientRequestToken && {
            ClientRequestToken: props.clientRequestToken,
        }),
        ...(props.description && { Description: props.description }),
        ...(props.serverSideEncryptionConfiguration && {
            ServerSideEncryptionConfiguration: {
                KmsKeyArn: props.serverSideEncryptionConfiguration.kmsKeyArn,
            },
        }),
    };
    return formattedCreateVoiceProfileDomainParams;
};
exports.CreateVoiceProfileDomain = async (uid, props) => {
    console.log(`Creating Voice Profile Domain: ${uid}`);
    console.log(`Create Voice Profile DomainProps: ${JSON.stringify(props)}`);
    formattedCreateVoiceProfileDomainParams = formatProps(props);
    console.log(`Create Voice Profile Domain params: ${JSON.stringify(formattedCreateVoiceProfileDomainParams)}`);
    console.log(`createVoiceProfileDomainParams: ${JSON.stringify(formattedCreateVoiceProfileDomainParams)}`);
    try {
        createVoiceProfileDomainResponse = await chimeSDKVoiceClient.send(new client_chime_sdk_voice_1.CreateVoiceProfileDomainCommand(formattedCreateVoiceProfileDomainParams));
        console.log(`createVoiceConnectorResponse: ${JSON.stringify(createVoiceProfileDomainResponse)}`);
    }
    catch (error) {
        if (error instanceof Error) {
            console.error(error);
            throw error;
        }
    }
    try {
        await ssmClient.send(new client_ssm_1.PutParameterCommand({
            Name: '/chime/voiceProfileDomain' + uid,
            Value: createVoiceProfileDomainResponse.VoiceProfileDomain
                .VoiceProfileDomainId,
            Description: 'Voice Profile Domain ID',
            Overwrite: true,
            Type: 'String',
        }));
    }
    catch (error) {
        if (error instanceof Error) {
            console.error(error);
            throw error;
        }
    }
    return {
        voiceProfileDomain: createVoiceProfileDomainResponse.VoiceProfileDomain,
    };
};
exports.UpdateVoiceProfileDomain = async (uid, props) => {
    console.log(`Updating Voice Profile Domain: ${uid}`);
    console.log(`Update Voice Profile DomainProps: ${JSON.stringify(props)}`);
    try {
        getParameterCommandOutput = await ssmClient.send(new client_ssm_1.GetParameterCommand({ Name: '/chime/voiceProfileDomain' + uid }));
        if (getParameterCommandOutput.Parameter &&
            getParameterCommandOutput.Parameter.Value) {
            voiceProfileDomainId = getParameterCommandOutput.Parameter.Value;
        }
    }
    catch (error) {
        if (error instanceof Error) {
            console.error(error);
            throw error;
        }
    }
    updateVoiceProfileDomainParams = {
        Name: props.name,
        Description: props.description,
        VoiceProfileDomainId: voiceProfileDomainId,
    };
    console.log(`updateVoiceConnectorParams: ${JSON.stringify(updateVoiceProfileDomainParams)}`);
    try {
        updateVoiceProfileDomainResponse = await chimeSDKVoiceClient.send(new client_chime_sdk_voice_1.UpdateVoiceProfileDomainCommand(updateVoiceProfileDomainParams));
        console.log(`updateVoiceProfileDomainResponse: ${JSON.stringify(updateVoiceProfileDomainResponse)}`);
    }
    catch (error) {
        if (error instanceof Error) {
            console.error(error);
            throw error;
        }
    }
    return {
        voiceProfileDomain: updateVoiceProfileDomainResponse.VoiceProfileDomain,
    };
};
exports.DeleteVoiceProfileDomain = async (uid) => {
    try {
        getParameterCommandOutput = await ssmClient.send(new client_ssm_1.GetParameterCommand({ Name: '/chime/voiceProfileDomain' + uid }));
        if (getParameterCommandOutput.Parameter &&
            getParameterCommandOutput.Parameter.Value) {
            voiceProfileDomainId = getParameterCommandOutput.Parameter.Value;
        }
    }
    catch (error) {
        if (error instanceof Error) {
            console.error(error);
            throw error;
        }
    }
    console.log(`Deleting voiceProfileDomainId: ${voiceProfileDomainId}`);
    try {
        deleteVoiceProfileDomainResponse = await chimeSDKVoiceClient.send(new client_chime_sdk_voice_1.DeleteVoiceProfileDomainCommand({
            VoiceProfileDomainId: voiceProfileDomainId,
        }));
        console.log(`Delete Voice Profile Domain Response: ${deleteVoiceProfileDomainResponse}`);
        await ssmClient.send(new client_ssm_1.DeleteParameterCommand({ Name: '/chime/voiceProfileDomain' + uid }));
    }
    catch (error) {
        if (error instanceof Error) {
            console.error(error);
            throw error;
        }
    }
};
//# sourceMappingURL=data:application/json;base64,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