import { ChimeSDKMediaPipelinesClient } from "./ChimeSDKMediaPipelinesClient";
import { CreateMediaCapturePipelineCommand, } from "./commands/CreateMediaCapturePipelineCommand";
import { CreateMediaConcatenationPipelineCommand, } from "./commands/CreateMediaConcatenationPipelineCommand";
import { CreateMediaInsightsPipelineCommand, } from "./commands/CreateMediaInsightsPipelineCommand";
import { CreateMediaInsightsPipelineConfigurationCommand, } from "./commands/CreateMediaInsightsPipelineConfigurationCommand";
import { CreateMediaLiveConnectorPipelineCommand, } from "./commands/CreateMediaLiveConnectorPipelineCommand";
import { DeleteMediaCapturePipelineCommand, } from "./commands/DeleteMediaCapturePipelineCommand";
import { DeleteMediaInsightsPipelineConfigurationCommand, } from "./commands/DeleteMediaInsightsPipelineConfigurationCommand";
import { DeleteMediaPipelineCommand, } from "./commands/DeleteMediaPipelineCommand";
import { GetMediaCapturePipelineCommand, } from "./commands/GetMediaCapturePipelineCommand";
import { GetMediaInsightsPipelineConfigurationCommand, } from "./commands/GetMediaInsightsPipelineConfigurationCommand";
import { GetMediaPipelineCommand, } from "./commands/GetMediaPipelineCommand";
import { ListMediaCapturePipelinesCommand, } from "./commands/ListMediaCapturePipelinesCommand";
import { ListMediaInsightsPipelineConfigurationsCommand, } from "./commands/ListMediaInsightsPipelineConfigurationsCommand";
import { ListMediaPipelinesCommand, } from "./commands/ListMediaPipelinesCommand";
import { ListTagsForResourceCommand, } from "./commands/ListTagsForResourceCommand";
import { TagResourceCommand } from "./commands/TagResourceCommand";
import { UntagResourceCommand, } from "./commands/UntagResourceCommand";
import { UpdateMediaInsightsPipelineConfigurationCommand, } from "./commands/UpdateMediaInsightsPipelineConfigurationCommand";
import { UpdateMediaInsightsPipelineStatusCommand, } from "./commands/UpdateMediaInsightsPipelineStatusCommand";
export class ChimeSDKMediaPipelines extends ChimeSDKMediaPipelinesClient {
    createMediaCapturePipeline(args, optionsOrCb, cb) {
        const command = new CreateMediaCapturePipelineCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    createMediaConcatenationPipeline(args, optionsOrCb, cb) {
        const command = new CreateMediaConcatenationPipelineCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    createMediaInsightsPipeline(args, optionsOrCb, cb) {
        const command = new CreateMediaInsightsPipelineCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    createMediaInsightsPipelineConfiguration(args, optionsOrCb, cb) {
        const command = new CreateMediaInsightsPipelineConfigurationCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    createMediaLiveConnectorPipeline(args, optionsOrCb, cb) {
        const command = new CreateMediaLiveConnectorPipelineCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    deleteMediaCapturePipeline(args, optionsOrCb, cb) {
        const command = new DeleteMediaCapturePipelineCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    deleteMediaInsightsPipelineConfiguration(args, optionsOrCb, cb) {
        const command = new DeleteMediaInsightsPipelineConfigurationCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    deleteMediaPipeline(args, optionsOrCb, cb) {
        const command = new DeleteMediaPipelineCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    getMediaCapturePipeline(args, optionsOrCb, cb) {
        const command = new GetMediaCapturePipelineCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    getMediaInsightsPipelineConfiguration(args, optionsOrCb, cb) {
        const command = new GetMediaInsightsPipelineConfigurationCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    getMediaPipeline(args, optionsOrCb, cb) {
        const command = new GetMediaPipelineCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    listMediaCapturePipelines(args, optionsOrCb, cb) {
        const command = new ListMediaCapturePipelinesCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    listMediaInsightsPipelineConfigurations(args, optionsOrCb, cb) {
        const command = new ListMediaInsightsPipelineConfigurationsCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    listMediaPipelines(args, optionsOrCb, cb) {
        const command = new ListMediaPipelinesCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    listTagsForResource(args, optionsOrCb, cb) {
        const command = new ListTagsForResourceCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    tagResource(args, optionsOrCb, cb) {
        const command = new TagResourceCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    untagResource(args, optionsOrCb, cb) {
        const command = new UntagResourceCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    updateMediaInsightsPipelineConfiguration(args, optionsOrCb, cb) {
        const command = new UpdateMediaInsightsPipelineConfigurationCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    updateMediaInsightsPipelineStatus(args, optionsOrCb, cb) {
        const command = new UpdateMediaInsightsPipelineStatusCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
}
