import { HttpRequest as __HttpRequest } from "@aws-sdk/protocol-http";
import { decorateServiceException as __decorateServiceException, expectBoolean as __expectBoolean, expectInt32 as __expectInt32, expectNonNull as __expectNonNull, expectNumber as __expectNumber, expectObject as __expectObject, expectString as __expectString, map as __map, parseEpochTimestamp as __parseEpochTimestamp, resolvedPath as __resolvedPath, throwDefaultError, } from "@aws-sdk/smithy-client";
import { v4 as generateIdempotencyToken } from "uuid";
import { ChimeSDKMessagingServiceException as __BaseException } from "../models/ChimeSDKMessagingServiceException";
import { BadRequestException, ConflictException, ForbiddenException, NotFoundException, ResourceLimitExceededException, ServiceFailureException, ServiceUnavailableException, ThrottledClientException, UnauthorizedClientException, } from "../models/models_0";
export const serializeAws_restJson1AssociateChannelFlowCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = map({}, isSerializableHeaderValue, {
        "content-type": "application/json",
        "x-amz-chime-bearer": input.ChimeBearer,
    });
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/channels/{ChannelArn}/channel-flow";
    resolvedPath = __resolvedPath(resolvedPath, input, "ChannelArn", () => input.ChannelArn, "{ChannelArn}", false);
    let body;
    body = JSON.stringify({
        ...(input.ChannelFlowArn != null && { ChannelFlowArn: input.ChannelFlowArn }),
    });
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "PUT",
        headers,
        path: resolvedPath,
        body,
    });
};
export const serializeAws_restJson1BatchCreateChannelMembershipCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = map({}, isSerializableHeaderValue, {
        "content-type": "application/json",
        "x-amz-chime-bearer": input.ChimeBearer,
    });
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/channels/{ChannelArn}/memberships";
    resolvedPath = __resolvedPath(resolvedPath, input, "ChannelArn", () => input.ChannelArn, "{ChannelArn}", false);
    const query = map({
        operation: [, "batch-create"],
    });
    let body;
    body = JSON.stringify({
        ...(input.MemberArns != null && { MemberArns: serializeAws_restJson1MemberArns(input.MemberArns, context) }),
        ...(input.SubChannelId != null && { SubChannelId: input.SubChannelId }),
        ...(input.Type != null && { Type: input.Type }),
    });
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "POST",
        headers,
        path: resolvedPath,
        query,
        body,
    });
};
export const serializeAws_restJson1ChannelFlowCallbackCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {
        "content-type": "application/json",
    };
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/channels/{ChannelArn}";
    resolvedPath = __resolvedPath(resolvedPath, input, "ChannelArn", () => input.ChannelArn, "{ChannelArn}", false);
    const query = map({
        operation: [, "channel-flow-callback"],
    });
    let body;
    body = JSON.stringify({
        CallbackId: input.CallbackId ?? generateIdempotencyToken(),
        ...(input.ChannelMessage != null && {
            ChannelMessage: serializeAws_restJson1ChannelMessageCallback(input.ChannelMessage, context),
        }),
        ...(input.DeleteResource != null && { DeleteResource: input.DeleteResource }),
    });
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "POST",
        headers,
        path: resolvedPath,
        query,
        body,
    });
};
export const serializeAws_restJson1CreateChannelCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = map({}, isSerializableHeaderValue, {
        "content-type": "application/json",
        "x-amz-chime-bearer": input.ChimeBearer,
    });
    const resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/channels";
    let body;
    body = JSON.stringify({
        ...(input.AppInstanceArn != null && { AppInstanceArn: input.AppInstanceArn }),
        ...(input.ChannelId != null && { ChannelId: input.ChannelId }),
        ClientRequestToken: input.ClientRequestToken ?? generateIdempotencyToken(),
        ...(input.ElasticChannelConfiguration != null && {
            ElasticChannelConfiguration: serializeAws_restJson1ElasticChannelConfiguration(input.ElasticChannelConfiguration, context),
        }),
        ...(input.ExpirationSettings != null && {
            ExpirationSettings: serializeAws_restJson1ExpirationSettings(input.ExpirationSettings, context),
        }),
        ...(input.MemberArns != null && { MemberArns: serializeAws_restJson1ChannelMemberArns(input.MemberArns, context) }),
        ...(input.Metadata != null && { Metadata: input.Metadata }),
        ...(input.Mode != null && { Mode: input.Mode }),
        ...(input.ModeratorArns != null && {
            ModeratorArns: serializeAws_restJson1ChannelModeratorArns(input.ModeratorArns, context),
        }),
        ...(input.Name != null && { Name: input.Name }),
        ...(input.Privacy != null && { Privacy: input.Privacy }),
        ...(input.Tags != null && { Tags: serializeAws_restJson1TagList(input.Tags, context) }),
    });
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "POST",
        headers,
        path: resolvedPath,
        body,
    });
};
export const serializeAws_restJson1CreateChannelBanCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = map({}, isSerializableHeaderValue, {
        "content-type": "application/json",
        "x-amz-chime-bearer": input.ChimeBearer,
    });
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/channels/{ChannelArn}/bans";
    resolvedPath = __resolvedPath(resolvedPath, input, "ChannelArn", () => input.ChannelArn, "{ChannelArn}", false);
    let body;
    body = JSON.stringify({
        ...(input.MemberArn != null && { MemberArn: input.MemberArn }),
    });
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "POST",
        headers,
        path: resolvedPath,
        body,
    });
};
export const serializeAws_restJson1CreateChannelFlowCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {
        "content-type": "application/json",
    };
    const resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/channel-flows";
    let body;
    body = JSON.stringify({
        ...(input.AppInstanceArn != null && { AppInstanceArn: input.AppInstanceArn }),
        ...(input.ClientRequestToken != null && { ClientRequestToken: input.ClientRequestToken }),
        ...(input.Name != null && { Name: input.Name }),
        ...(input.Processors != null && { Processors: serializeAws_restJson1ProcessorList(input.Processors, context) }),
        ...(input.Tags != null && { Tags: serializeAws_restJson1TagList(input.Tags, context) }),
    });
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "POST",
        headers,
        path: resolvedPath,
        body,
    });
};
export const serializeAws_restJson1CreateChannelMembershipCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = map({}, isSerializableHeaderValue, {
        "content-type": "application/json",
        "x-amz-chime-bearer": input.ChimeBearer,
    });
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/channels/{ChannelArn}/memberships";
    resolvedPath = __resolvedPath(resolvedPath, input, "ChannelArn", () => input.ChannelArn, "{ChannelArn}", false);
    let body;
    body = JSON.stringify({
        ...(input.MemberArn != null && { MemberArn: input.MemberArn }),
        ...(input.SubChannelId != null && { SubChannelId: input.SubChannelId }),
        ...(input.Type != null && { Type: input.Type }),
    });
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "POST",
        headers,
        path: resolvedPath,
        body,
    });
};
export const serializeAws_restJson1CreateChannelModeratorCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = map({}, isSerializableHeaderValue, {
        "content-type": "application/json",
        "x-amz-chime-bearer": input.ChimeBearer,
    });
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/channels/{ChannelArn}/moderators";
    resolvedPath = __resolvedPath(resolvedPath, input, "ChannelArn", () => input.ChannelArn, "{ChannelArn}", false);
    let body;
    body = JSON.stringify({
        ...(input.ChannelModeratorArn != null && { ChannelModeratorArn: input.ChannelModeratorArn }),
    });
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "POST",
        headers,
        path: resolvedPath,
        body,
    });
};
export const serializeAws_restJson1DeleteChannelCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = map({}, isSerializableHeaderValue, {
        "x-amz-chime-bearer": input.ChimeBearer,
    });
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/channels/{ChannelArn}";
    resolvedPath = __resolvedPath(resolvedPath, input, "ChannelArn", () => input.ChannelArn, "{ChannelArn}", false);
    const query = map({
        "sub-channel-id": [, input.SubChannelId],
    });
    let body;
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "DELETE",
        headers,
        path: resolvedPath,
        query,
        body,
    });
};
export const serializeAws_restJson1DeleteChannelBanCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = map({}, isSerializableHeaderValue, {
        "x-amz-chime-bearer": input.ChimeBearer,
    });
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/channels/{ChannelArn}/bans/{MemberArn}";
    resolvedPath = __resolvedPath(resolvedPath, input, "ChannelArn", () => input.ChannelArn, "{ChannelArn}", false);
    resolvedPath = __resolvedPath(resolvedPath, input, "MemberArn", () => input.MemberArn, "{MemberArn}", false);
    let body;
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "DELETE",
        headers,
        path: resolvedPath,
        body,
    });
};
export const serializeAws_restJson1DeleteChannelFlowCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {};
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/channel-flows/{ChannelFlowArn}";
    resolvedPath = __resolvedPath(resolvedPath, input, "ChannelFlowArn", () => input.ChannelFlowArn, "{ChannelFlowArn}", false);
    let body;
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "DELETE",
        headers,
        path: resolvedPath,
        body,
    });
};
export const serializeAws_restJson1DeleteChannelMembershipCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = map({}, isSerializableHeaderValue, {
        "x-amz-chime-bearer": input.ChimeBearer,
    });
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` +
        "/channels/{ChannelArn}/memberships/{MemberArn}";
    resolvedPath = __resolvedPath(resolvedPath, input, "ChannelArn", () => input.ChannelArn, "{ChannelArn}", false);
    resolvedPath = __resolvedPath(resolvedPath, input, "MemberArn", () => input.MemberArn, "{MemberArn}", false);
    const query = map({
        "sub-channel-id": [, input.SubChannelId],
    });
    let body;
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "DELETE",
        headers,
        path: resolvedPath,
        query,
        body,
    });
};
export const serializeAws_restJson1DeleteChannelMessageCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = map({}, isSerializableHeaderValue, {
        "x-amz-chime-bearer": input.ChimeBearer,
    });
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` +
        "/channels/{ChannelArn}/messages/{MessageId}";
    resolvedPath = __resolvedPath(resolvedPath, input, "ChannelArn", () => input.ChannelArn, "{ChannelArn}", false);
    resolvedPath = __resolvedPath(resolvedPath, input, "MessageId", () => input.MessageId, "{MessageId}", false);
    const query = map({
        "sub-channel-id": [, input.SubChannelId],
    });
    let body;
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "DELETE",
        headers,
        path: resolvedPath,
        query,
        body,
    });
};
export const serializeAws_restJson1DeleteChannelModeratorCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = map({}, isSerializableHeaderValue, {
        "x-amz-chime-bearer": input.ChimeBearer,
    });
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` +
        "/channels/{ChannelArn}/moderators/{ChannelModeratorArn}";
    resolvedPath = __resolvedPath(resolvedPath, input, "ChannelArn", () => input.ChannelArn, "{ChannelArn}", false);
    resolvedPath = __resolvedPath(resolvedPath, input, "ChannelModeratorArn", () => input.ChannelModeratorArn, "{ChannelModeratorArn}", false);
    let body;
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "DELETE",
        headers,
        path: resolvedPath,
        body,
    });
};
export const serializeAws_restJson1DeleteMessagingStreamingConfigurationsCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {};
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` +
        "/app-instances/{AppInstanceArn}/streaming-configurations";
    resolvedPath = __resolvedPath(resolvedPath, input, "AppInstanceArn", () => input.AppInstanceArn, "{AppInstanceArn}", false);
    let body;
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "DELETE",
        headers,
        path: resolvedPath,
        body,
    });
};
export const serializeAws_restJson1DescribeChannelCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = map({}, isSerializableHeaderValue, {
        "x-amz-chime-bearer": input.ChimeBearer,
    });
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/channels/{ChannelArn}";
    resolvedPath = __resolvedPath(resolvedPath, input, "ChannelArn", () => input.ChannelArn, "{ChannelArn}", false);
    let body;
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "GET",
        headers,
        path: resolvedPath,
        body,
    });
};
export const serializeAws_restJson1DescribeChannelBanCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = map({}, isSerializableHeaderValue, {
        "x-amz-chime-bearer": input.ChimeBearer,
    });
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/channels/{ChannelArn}/bans/{MemberArn}";
    resolvedPath = __resolvedPath(resolvedPath, input, "ChannelArn", () => input.ChannelArn, "{ChannelArn}", false);
    resolvedPath = __resolvedPath(resolvedPath, input, "MemberArn", () => input.MemberArn, "{MemberArn}", false);
    let body;
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "GET",
        headers,
        path: resolvedPath,
        body,
    });
};
export const serializeAws_restJson1DescribeChannelFlowCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {};
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/channel-flows/{ChannelFlowArn}";
    resolvedPath = __resolvedPath(resolvedPath, input, "ChannelFlowArn", () => input.ChannelFlowArn, "{ChannelFlowArn}", false);
    let body;
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "GET",
        headers,
        path: resolvedPath,
        body,
    });
};
export const serializeAws_restJson1DescribeChannelMembershipCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = map({}, isSerializableHeaderValue, {
        "x-amz-chime-bearer": input.ChimeBearer,
    });
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` +
        "/channels/{ChannelArn}/memberships/{MemberArn}";
    resolvedPath = __resolvedPath(resolvedPath, input, "ChannelArn", () => input.ChannelArn, "{ChannelArn}", false);
    resolvedPath = __resolvedPath(resolvedPath, input, "MemberArn", () => input.MemberArn, "{MemberArn}", false);
    const query = map({
        "sub-channel-id": [, input.SubChannelId],
    });
    let body;
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "GET",
        headers,
        path: resolvedPath,
        query,
        body,
    });
};
export const serializeAws_restJson1DescribeChannelMembershipForAppInstanceUserCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = map({}, isSerializableHeaderValue, {
        "x-amz-chime-bearer": input.ChimeBearer,
    });
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/channels/{ChannelArn}";
    resolvedPath = __resolvedPath(resolvedPath, input, "ChannelArn", () => input.ChannelArn, "{ChannelArn}", false);
    const query = map({
        scope: [, "app-instance-user-membership"],
        "app-instance-user-arn": [, __expectNonNull(input.AppInstanceUserArn, `AppInstanceUserArn`)],
    });
    let body;
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "GET",
        headers,
        path: resolvedPath,
        query,
        body,
    });
};
export const serializeAws_restJson1DescribeChannelModeratedByAppInstanceUserCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = map({}, isSerializableHeaderValue, {
        "x-amz-chime-bearer": input.ChimeBearer,
    });
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/channels/{ChannelArn}";
    resolvedPath = __resolvedPath(resolvedPath, input, "ChannelArn", () => input.ChannelArn, "{ChannelArn}", false);
    const query = map({
        scope: [, "app-instance-user-moderated-channel"],
        "app-instance-user-arn": [, __expectNonNull(input.AppInstanceUserArn, `AppInstanceUserArn`)],
    });
    let body;
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "GET",
        headers,
        path: resolvedPath,
        query,
        body,
    });
};
export const serializeAws_restJson1DescribeChannelModeratorCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = map({}, isSerializableHeaderValue, {
        "x-amz-chime-bearer": input.ChimeBearer,
    });
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` +
        "/channels/{ChannelArn}/moderators/{ChannelModeratorArn}";
    resolvedPath = __resolvedPath(resolvedPath, input, "ChannelArn", () => input.ChannelArn, "{ChannelArn}", false);
    resolvedPath = __resolvedPath(resolvedPath, input, "ChannelModeratorArn", () => input.ChannelModeratorArn, "{ChannelModeratorArn}", false);
    let body;
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "GET",
        headers,
        path: resolvedPath,
        body,
    });
};
export const serializeAws_restJson1DisassociateChannelFlowCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = map({}, isSerializableHeaderValue, {
        "x-amz-chime-bearer": input.ChimeBearer,
    });
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` +
        "/channels/{ChannelArn}/channel-flow/{ChannelFlowArn}";
    resolvedPath = __resolvedPath(resolvedPath, input, "ChannelArn", () => input.ChannelArn, "{ChannelArn}", false);
    resolvedPath = __resolvedPath(resolvedPath, input, "ChannelFlowArn", () => input.ChannelFlowArn, "{ChannelFlowArn}", false);
    let body;
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "DELETE",
        headers,
        path: resolvedPath,
        body,
    });
};
export const serializeAws_restJson1GetChannelMembershipPreferencesCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = map({}, isSerializableHeaderValue, {
        "x-amz-chime-bearer": input.ChimeBearer,
    });
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` +
        "/channels/{ChannelArn}/memberships/{MemberArn}/preferences";
    resolvedPath = __resolvedPath(resolvedPath, input, "ChannelArn", () => input.ChannelArn, "{ChannelArn}", false);
    resolvedPath = __resolvedPath(resolvedPath, input, "MemberArn", () => input.MemberArn, "{MemberArn}", false);
    let body;
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "GET",
        headers,
        path: resolvedPath,
        body,
    });
};
export const serializeAws_restJson1GetChannelMessageCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = map({}, isSerializableHeaderValue, {
        "x-amz-chime-bearer": input.ChimeBearer,
    });
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` +
        "/channels/{ChannelArn}/messages/{MessageId}";
    resolvedPath = __resolvedPath(resolvedPath, input, "ChannelArn", () => input.ChannelArn, "{ChannelArn}", false);
    resolvedPath = __resolvedPath(resolvedPath, input, "MessageId", () => input.MessageId, "{MessageId}", false);
    const query = map({
        "sub-channel-id": [, input.SubChannelId],
    });
    let body;
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "GET",
        headers,
        path: resolvedPath,
        query,
        body,
    });
};
export const serializeAws_restJson1GetChannelMessageStatusCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = map({}, isSerializableHeaderValue, {
        "x-amz-chime-bearer": input.ChimeBearer,
    });
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` +
        "/channels/{ChannelArn}/messages/{MessageId}";
    resolvedPath = __resolvedPath(resolvedPath, input, "ChannelArn", () => input.ChannelArn, "{ChannelArn}", false);
    resolvedPath = __resolvedPath(resolvedPath, input, "MessageId", () => input.MessageId, "{MessageId}", false);
    const query = map({
        scope: [, "message-status"],
        "sub-channel-id": [, input.SubChannelId],
    });
    let body;
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "GET",
        headers,
        path: resolvedPath,
        query,
        body,
    });
};
export const serializeAws_restJson1GetMessagingSessionEndpointCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {
        "content-type": "application/json",
    };
    const resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/endpoints/messaging-session";
    let body;
    body = "";
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "GET",
        headers,
        path: resolvedPath,
        body,
    });
};
export const serializeAws_restJson1GetMessagingStreamingConfigurationsCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {};
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` +
        "/app-instances/{AppInstanceArn}/streaming-configurations";
    resolvedPath = __resolvedPath(resolvedPath, input, "AppInstanceArn", () => input.AppInstanceArn, "{AppInstanceArn}", false);
    let body;
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "GET",
        headers,
        path: resolvedPath,
        body,
    });
};
export const serializeAws_restJson1ListChannelBansCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = map({}, isSerializableHeaderValue, {
        "x-amz-chime-bearer": input.ChimeBearer,
    });
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/channels/{ChannelArn}/bans";
    resolvedPath = __resolvedPath(resolvedPath, input, "ChannelArn", () => input.ChannelArn, "{ChannelArn}", false);
    const query = map({
        "max-results": [() => input.MaxResults !== void 0, () => input.MaxResults.toString()],
        "next-token": [, input.NextToken],
    });
    let body;
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "GET",
        headers,
        path: resolvedPath,
        query,
        body,
    });
};
export const serializeAws_restJson1ListChannelFlowsCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {};
    const resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/channel-flows";
    const query = map({
        "app-instance-arn": [, __expectNonNull(input.AppInstanceArn, `AppInstanceArn`)],
        "max-results": [() => input.MaxResults !== void 0, () => input.MaxResults.toString()],
        "next-token": [, input.NextToken],
    });
    let body;
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "GET",
        headers,
        path: resolvedPath,
        query,
        body,
    });
};
export const serializeAws_restJson1ListChannelMembershipsCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = map({}, isSerializableHeaderValue, {
        "x-amz-chime-bearer": input.ChimeBearer,
    });
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/channels/{ChannelArn}/memberships";
    resolvedPath = __resolvedPath(resolvedPath, input, "ChannelArn", () => input.ChannelArn, "{ChannelArn}", false);
    const query = map({
        type: [, input.Type],
        "max-results": [() => input.MaxResults !== void 0, () => input.MaxResults.toString()],
        "next-token": [, input.NextToken],
        "sub-channel-id": [, input.SubChannelId],
    });
    let body;
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "GET",
        headers,
        path: resolvedPath,
        query,
        body,
    });
};
export const serializeAws_restJson1ListChannelMembershipsForAppInstanceUserCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = map({}, isSerializableHeaderValue, {
        "x-amz-chime-bearer": input.ChimeBearer,
    });
    const resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/channels";
    const query = map({
        scope: [, "app-instance-user-memberships"],
        "app-instance-user-arn": [, input.AppInstanceUserArn],
        "max-results": [() => input.MaxResults !== void 0, () => input.MaxResults.toString()],
        "next-token": [, input.NextToken],
    });
    let body;
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "GET",
        headers,
        path: resolvedPath,
        query,
        body,
    });
};
export const serializeAws_restJson1ListChannelMessagesCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = map({}, isSerializableHeaderValue, {
        "x-amz-chime-bearer": input.ChimeBearer,
    });
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/channels/{ChannelArn}/messages";
    resolvedPath = __resolvedPath(resolvedPath, input, "ChannelArn", () => input.ChannelArn, "{ChannelArn}", false);
    const query = map({
        "sort-order": [, input.SortOrder],
        "not-before": [
            () => input.NotBefore !== void 0,
            () => (input.NotBefore.toISOString().split(".")[0] + "Z").toString(),
        ],
        "not-after": [
            () => input.NotAfter !== void 0,
            () => (input.NotAfter.toISOString().split(".")[0] + "Z").toString(),
        ],
        "max-results": [() => input.MaxResults !== void 0, () => input.MaxResults.toString()],
        "next-token": [, input.NextToken],
        "sub-channel-id": [, input.SubChannelId],
    });
    let body;
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "GET",
        headers,
        path: resolvedPath,
        query,
        body,
    });
};
export const serializeAws_restJson1ListChannelModeratorsCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = map({}, isSerializableHeaderValue, {
        "x-amz-chime-bearer": input.ChimeBearer,
    });
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/channels/{ChannelArn}/moderators";
    resolvedPath = __resolvedPath(resolvedPath, input, "ChannelArn", () => input.ChannelArn, "{ChannelArn}", false);
    const query = map({
        "max-results": [() => input.MaxResults !== void 0, () => input.MaxResults.toString()],
        "next-token": [, input.NextToken],
    });
    let body;
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "GET",
        headers,
        path: resolvedPath,
        query,
        body,
    });
};
export const serializeAws_restJson1ListChannelsCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = map({}, isSerializableHeaderValue, {
        "x-amz-chime-bearer": input.ChimeBearer,
    });
    const resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/channels";
    const query = map({
        "app-instance-arn": [, __expectNonNull(input.AppInstanceArn, `AppInstanceArn`)],
        privacy: [, input.Privacy],
        "max-results": [() => input.MaxResults !== void 0, () => input.MaxResults.toString()],
        "next-token": [, input.NextToken],
    });
    let body;
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "GET",
        headers,
        path: resolvedPath,
        query,
        body,
    });
};
export const serializeAws_restJson1ListChannelsAssociatedWithChannelFlowCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {};
    const resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/channels";
    const query = map({
        scope: [, "channel-flow-associations"],
        "channel-flow-arn": [, __expectNonNull(input.ChannelFlowArn, `ChannelFlowArn`)],
        "max-results": [() => input.MaxResults !== void 0, () => input.MaxResults.toString()],
        "next-token": [, input.NextToken],
    });
    let body;
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "GET",
        headers,
        path: resolvedPath,
        query,
        body,
    });
};
export const serializeAws_restJson1ListChannelsModeratedByAppInstanceUserCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = map({}, isSerializableHeaderValue, {
        "x-amz-chime-bearer": input.ChimeBearer,
    });
    const resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/channels";
    const query = map({
        scope: [, "app-instance-user-moderated-channels"],
        "app-instance-user-arn": [, input.AppInstanceUserArn],
        "max-results": [() => input.MaxResults !== void 0, () => input.MaxResults.toString()],
        "next-token": [, input.NextToken],
    });
    let body;
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "GET",
        headers,
        path: resolvedPath,
        query,
        body,
    });
};
export const serializeAws_restJson1ListSubChannelsCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = map({}, isSerializableHeaderValue, {
        "x-amz-chime-bearer": input.ChimeBearer,
    });
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/channels/{ChannelArn}/subchannels";
    resolvedPath = __resolvedPath(resolvedPath, input, "ChannelArn", () => input.ChannelArn, "{ChannelArn}", false);
    const query = map({
        "max-results": [() => input.MaxResults !== void 0, () => input.MaxResults.toString()],
        "next-token": [, input.NextToken],
    });
    let body;
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "GET",
        headers,
        path: resolvedPath,
        query,
        body,
    });
};
export const serializeAws_restJson1ListTagsForResourceCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {};
    const resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/tags";
    const query = map({
        arn: [, __expectNonNull(input.ResourceARN, `ResourceARN`)],
    });
    let body;
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "GET",
        headers,
        path: resolvedPath,
        query,
        body,
    });
};
export const serializeAws_restJson1PutChannelExpirationSettingsCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = map({}, isSerializableHeaderValue, {
        "content-type": "application/json",
        "x-amz-chime-bearer": input.ChimeBearer,
    });
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` +
        "/channels/{ChannelArn}/expiration-settings";
    resolvedPath = __resolvedPath(resolvedPath, input, "ChannelArn", () => input.ChannelArn, "{ChannelArn}", false);
    let body;
    body = JSON.stringify({
        ...(input.ExpirationSettings != null && {
            ExpirationSettings: serializeAws_restJson1ExpirationSettings(input.ExpirationSettings, context),
        }),
    });
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "PUT",
        headers,
        path: resolvedPath,
        body,
    });
};
export const serializeAws_restJson1PutChannelMembershipPreferencesCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = map({}, isSerializableHeaderValue, {
        "content-type": "application/json",
        "x-amz-chime-bearer": input.ChimeBearer,
    });
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` +
        "/channels/{ChannelArn}/memberships/{MemberArn}/preferences";
    resolvedPath = __resolvedPath(resolvedPath, input, "ChannelArn", () => input.ChannelArn, "{ChannelArn}", false);
    resolvedPath = __resolvedPath(resolvedPath, input, "MemberArn", () => input.MemberArn, "{MemberArn}", false);
    let body;
    body = JSON.stringify({
        ...(input.Preferences != null && {
            Preferences: serializeAws_restJson1ChannelMembershipPreferences(input.Preferences, context),
        }),
    });
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "PUT",
        headers,
        path: resolvedPath,
        body,
    });
};
export const serializeAws_restJson1PutMessagingStreamingConfigurationsCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {
        "content-type": "application/json",
    };
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` +
        "/app-instances/{AppInstanceArn}/streaming-configurations";
    resolvedPath = __resolvedPath(resolvedPath, input, "AppInstanceArn", () => input.AppInstanceArn, "{AppInstanceArn}", false);
    let body;
    body = JSON.stringify({
        ...(input.StreamingConfigurations != null && {
            StreamingConfigurations: serializeAws_restJson1StreamingConfigurationList(input.StreamingConfigurations, context),
        }),
    });
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "PUT",
        headers,
        path: resolvedPath,
        body,
    });
};
export const serializeAws_restJson1RedactChannelMessageCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = map({}, isSerializableHeaderValue, {
        "content-type": "application/json",
        "x-amz-chime-bearer": input.ChimeBearer,
    });
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` +
        "/channels/{ChannelArn}/messages/{MessageId}";
    resolvedPath = __resolvedPath(resolvedPath, input, "ChannelArn", () => input.ChannelArn, "{ChannelArn}", false);
    resolvedPath = __resolvedPath(resolvedPath, input, "MessageId", () => input.MessageId, "{MessageId}", false);
    const query = map({
        operation: [, "redact"],
    });
    let body;
    body = JSON.stringify({
        ...(input.SubChannelId != null && { SubChannelId: input.SubChannelId }),
    });
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "POST",
        headers,
        path: resolvedPath,
        query,
        body,
    });
};
export const serializeAws_restJson1SearchChannelsCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = map({}, isSerializableHeaderValue, {
        "content-type": "application/json",
        "x-amz-chime-bearer": input.ChimeBearer,
    });
    const resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/channels";
    const query = map({
        operation: [, "search"],
        "max-results": [() => input.MaxResults !== void 0, () => input.MaxResults.toString()],
        "next-token": [, input.NextToken],
    });
    let body;
    body = JSON.stringify({
        ...(input.Fields != null && { Fields: serializeAws_restJson1SearchFields(input.Fields, context) }),
    });
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "POST",
        headers,
        path: resolvedPath,
        query,
        body,
    });
};
export const serializeAws_restJson1SendChannelMessageCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = map({}, isSerializableHeaderValue, {
        "content-type": "application/json",
        "x-amz-chime-bearer": input.ChimeBearer,
    });
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/channels/{ChannelArn}/messages";
    resolvedPath = __resolvedPath(resolvedPath, input, "ChannelArn", () => input.ChannelArn, "{ChannelArn}", false);
    let body;
    body = JSON.stringify({
        ClientRequestToken: input.ClientRequestToken ?? generateIdempotencyToken(),
        ...(input.Content != null && { Content: input.Content }),
        ...(input.ContentType != null && { ContentType: input.ContentType }),
        ...(input.MessageAttributes != null && {
            MessageAttributes: serializeAws_restJson1MessageAttributeMap(input.MessageAttributes, context),
        }),
        ...(input.Metadata != null && { Metadata: input.Metadata }),
        ...(input.Persistence != null && { Persistence: input.Persistence }),
        ...(input.PushNotification != null && {
            PushNotification: serializeAws_restJson1PushNotificationConfiguration(input.PushNotification, context),
        }),
        ...(input.SubChannelId != null && { SubChannelId: input.SubChannelId }),
        ...(input.Type != null && { Type: input.Type }),
    });
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "POST",
        headers,
        path: resolvedPath,
        body,
    });
};
export const serializeAws_restJson1TagResourceCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {
        "content-type": "application/json",
    };
    const resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/tags";
    const query = map({
        operation: [, "tag-resource"],
    });
    let body;
    body = JSON.stringify({
        ...(input.ResourceARN != null && { ResourceARN: input.ResourceARN }),
        ...(input.Tags != null && { Tags: serializeAws_restJson1TagList(input.Tags, context) }),
    });
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "POST",
        headers,
        path: resolvedPath,
        query,
        body,
    });
};
export const serializeAws_restJson1UntagResourceCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {
        "content-type": "application/json",
    };
    const resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/tags";
    const query = map({
        operation: [, "untag-resource"],
    });
    let body;
    body = JSON.stringify({
        ...(input.ResourceARN != null && { ResourceARN: input.ResourceARN }),
        ...(input.TagKeys != null && { TagKeys: serializeAws_restJson1TagKeyList(input.TagKeys, context) }),
    });
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "POST",
        headers,
        path: resolvedPath,
        query,
        body,
    });
};
export const serializeAws_restJson1UpdateChannelCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = map({}, isSerializableHeaderValue, {
        "content-type": "application/json",
        "x-amz-chime-bearer": input.ChimeBearer,
    });
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/channels/{ChannelArn}";
    resolvedPath = __resolvedPath(resolvedPath, input, "ChannelArn", () => input.ChannelArn, "{ChannelArn}", false);
    let body;
    body = JSON.stringify({
        ...(input.Metadata != null && { Metadata: input.Metadata }),
        ...(input.Mode != null && { Mode: input.Mode }),
        ...(input.Name != null && { Name: input.Name }),
    });
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "PUT",
        headers,
        path: resolvedPath,
        body,
    });
};
export const serializeAws_restJson1UpdateChannelFlowCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {
        "content-type": "application/json",
    };
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/channel-flows/{ChannelFlowArn}";
    resolvedPath = __resolvedPath(resolvedPath, input, "ChannelFlowArn", () => input.ChannelFlowArn, "{ChannelFlowArn}", false);
    let body;
    body = JSON.stringify({
        ...(input.Name != null && { Name: input.Name }),
        ...(input.Processors != null && { Processors: serializeAws_restJson1ProcessorList(input.Processors, context) }),
    });
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "PUT",
        headers,
        path: resolvedPath,
        body,
    });
};
export const serializeAws_restJson1UpdateChannelMessageCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = map({}, isSerializableHeaderValue, {
        "content-type": "application/json",
        "x-amz-chime-bearer": input.ChimeBearer,
    });
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` +
        "/channels/{ChannelArn}/messages/{MessageId}";
    resolvedPath = __resolvedPath(resolvedPath, input, "ChannelArn", () => input.ChannelArn, "{ChannelArn}", false);
    resolvedPath = __resolvedPath(resolvedPath, input, "MessageId", () => input.MessageId, "{MessageId}", false);
    let body;
    body = JSON.stringify({
        ...(input.Content != null && { Content: input.Content }),
        ...(input.ContentType != null && { ContentType: input.ContentType }),
        ...(input.Metadata != null && { Metadata: input.Metadata }),
        ...(input.SubChannelId != null && { SubChannelId: input.SubChannelId }),
    });
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "PUT",
        headers,
        path: resolvedPath,
        body,
    });
};
export const serializeAws_restJson1UpdateChannelReadMarkerCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = map({}, isSerializableHeaderValue, {
        "content-type": "application/json",
        "x-amz-chime-bearer": input.ChimeBearer,
    });
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/channels/{ChannelArn}/readMarker";
    resolvedPath = __resolvedPath(resolvedPath, input, "ChannelArn", () => input.ChannelArn, "{ChannelArn}", false);
    let body;
    body = JSON.stringify({
        ...(input.SubChannelId != null && { SubChannelId: input.SubChannelId }),
    });
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "PUT",
        headers,
        path: resolvedPath,
        body,
    });
};
export const deserializeAws_restJson1AssociateChannelFlowCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return deserializeAws_restJson1AssociateChannelFlowCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    await collectBody(output.body, context);
    return contents;
};
const deserializeAws_restJson1AssociateChannelFlowCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkmessaging#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ConflictException":
        case "com.amazonaws.chimesdkmessaging#ConflictException":
            throw await deserializeAws_restJson1ConflictExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkmessaging#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chimesdkmessaging#NotFoundException":
            throw await deserializeAws_restJson1NotFoundExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkmessaging#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkmessaging#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkmessaging#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkmessaging#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1BatchCreateChannelMembershipCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return deserializeAws_restJson1BatchCreateChannelMembershipCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    if (data.BatchChannelMemberships != null) {
        contents.BatchChannelMemberships = deserializeAws_restJson1BatchChannelMemberships(data.BatchChannelMemberships, context);
    }
    if (data.Errors != null) {
        contents.Errors = deserializeAws_restJson1BatchCreateChannelMembershipErrors(data.Errors, context);
    }
    return contents;
};
const deserializeAws_restJson1BatchCreateChannelMembershipCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkmessaging#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkmessaging#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chimesdkmessaging#NotFoundException":
            throw await deserializeAws_restJson1NotFoundExceptionResponse(parsedOutput, context);
        case "ResourceLimitExceededException":
        case "com.amazonaws.chimesdkmessaging#ResourceLimitExceededException":
            throw await deserializeAws_restJson1ResourceLimitExceededExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkmessaging#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkmessaging#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkmessaging#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkmessaging#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1ChannelFlowCallbackCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return deserializeAws_restJson1ChannelFlowCallbackCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    if (data.CallbackId != null) {
        contents.CallbackId = __expectString(data.CallbackId);
    }
    if (data.ChannelArn != null) {
        contents.ChannelArn = __expectString(data.ChannelArn);
    }
    return contents;
};
const deserializeAws_restJson1ChannelFlowCallbackCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkmessaging#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ConflictException":
        case "com.amazonaws.chimesdkmessaging#ConflictException":
            throw await deserializeAws_restJson1ConflictExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkmessaging#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkmessaging#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkmessaging#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkmessaging#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkmessaging#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1CreateChannelCommand = async (output, context) => {
    if (output.statusCode !== 201 && output.statusCode >= 300) {
        return deserializeAws_restJson1CreateChannelCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    if (data.ChannelArn != null) {
        contents.ChannelArn = __expectString(data.ChannelArn);
    }
    return contents;
};
const deserializeAws_restJson1CreateChannelCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkmessaging#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ConflictException":
        case "com.amazonaws.chimesdkmessaging#ConflictException":
            throw await deserializeAws_restJson1ConflictExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkmessaging#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "ResourceLimitExceededException":
        case "com.amazonaws.chimesdkmessaging#ResourceLimitExceededException":
            throw await deserializeAws_restJson1ResourceLimitExceededExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkmessaging#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkmessaging#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkmessaging#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkmessaging#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1CreateChannelBanCommand = async (output, context) => {
    if (output.statusCode !== 201 && output.statusCode >= 300) {
        return deserializeAws_restJson1CreateChannelBanCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    if (data.ChannelArn != null) {
        contents.ChannelArn = __expectString(data.ChannelArn);
    }
    if (data.Member != null) {
        contents.Member = deserializeAws_restJson1Identity(data.Member, context);
    }
    return contents;
};
const deserializeAws_restJson1CreateChannelBanCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkmessaging#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ConflictException":
        case "com.amazonaws.chimesdkmessaging#ConflictException":
            throw await deserializeAws_restJson1ConflictExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkmessaging#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "ResourceLimitExceededException":
        case "com.amazonaws.chimesdkmessaging#ResourceLimitExceededException":
            throw await deserializeAws_restJson1ResourceLimitExceededExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkmessaging#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkmessaging#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkmessaging#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkmessaging#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1CreateChannelFlowCommand = async (output, context) => {
    if (output.statusCode !== 201 && output.statusCode >= 300) {
        return deserializeAws_restJson1CreateChannelFlowCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    if (data.ChannelFlowArn != null) {
        contents.ChannelFlowArn = __expectString(data.ChannelFlowArn);
    }
    return contents;
};
const deserializeAws_restJson1CreateChannelFlowCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkmessaging#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ConflictException":
        case "com.amazonaws.chimesdkmessaging#ConflictException":
            throw await deserializeAws_restJson1ConflictExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkmessaging#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "ResourceLimitExceededException":
        case "com.amazonaws.chimesdkmessaging#ResourceLimitExceededException":
            throw await deserializeAws_restJson1ResourceLimitExceededExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkmessaging#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkmessaging#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkmessaging#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkmessaging#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1CreateChannelMembershipCommand = async (output, context) => {
    if (output.statusCode !== 201 && output.statusCode >= 300) {
        return deserializeAws_restJson1CreateChannelMembershipCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    if (data.ChannelArn != null) {
        contents.ChannelArn = __expectString(data.ChannelArn);
    }
    if (data.Member != null) {
        contents.Member = deserializeAws_restJson1Identity(data.Member, context);
    }
    if (data.SubChannelId != null) {
        contents.SubChannelId = __expectString(data.SubChannelId);
    }
    return contents;
};
const deserializeAws_restJson1CreateChannelMembershipCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkmessaging#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ConflictException":
        case "com.amazonaws.chimesdkmessaging#ConflictException":
            throw await deserializeAws_restJson1ConflictExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkmessaging#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chimesdkmessaging#NotFoundException":
            throw await deserializeAws_restJson1NotFoundExceptionResponse(parsedOutput, context);
        case "ResourceLimitExceededException":
        case "com.amazonaws.chimesdkmessaging#ResourceLimitExceededException":
            throw await deserializeAws_restJson1ResourceLimitExceededExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkmessaging#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkmessaging#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkmessaging#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkmessaging#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1CreateChannelModeratorCommand = async (output, context) => {
    if (output.statusCode !== 201 && output.statusCode >= 300) {
        return deserializeAws_restJson1CreateChannelModeratorCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    if (data.ChannelArn != null) {
        contents.ChannelArn = __expectString(data.ChannelArn);
    }
    if (data.ChannelModerator != null) {
        contents.ChannelModerator = deserializeAws_restJson1Identity(data.ChannelModerator, context);
    }
    return contents;
};
const deserializeAws_restJson1CreateChannelModeratorCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkmessaging#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ConflictException":
        case "com.amazonaws.chimesdkmessaging#ConflictException":
            throw await deserializeAws_restJson1ConflictExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkmessaging#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "ResourceLimitExceededException":
        case "com.amazonaws.chimesdkmessaging#ResourceLimitExceededException":
            throw await deserializeAws_restJson1ResourceLimitExceededExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkmessaging#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkmessaging#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkmessaging#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkmessaging#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1DeleteChannelCommand = async (output, context) => {
    if (output.statusCode !== 204 && output.statusCode >= 300) {
        return deserializeAws_restJson1DeleteChannelCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    await collectBody(output.body, context);
    return contents;
};
const deserializeAws_restJson1DeleteChannelCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkmessaging#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkmessaging#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkmessaging#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkmessaging#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkmessaging#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkmessaging#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1DeleteChannelBanCommand = async (output, context) => {
    if (output.statusCode !== 204 && output.statusCode >= 300) {
        return deserializeAws_restJson1DeleteChannelBanCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    await collectBody(output.body, context);
    return contents;
};
const deserializeAws_restJson1DeleteChannelBanCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkmessaging#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkmessaging#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkmessaging#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkmessaging#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkmessaging#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkmessaging#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1DeleteChannelFlowCommand = async (output, context) => {
    if (output.statusCode !== 204 && output.statusCode >= 300) {
        return deserializeAws_restJson1DeleteChannelFlowCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    await collectBody(output.body, context);
    return contents;
};
const deserializeAws_restJson1DeleteChannelFlowCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkmessaging#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ConflictException":
        case "com.amazonaws.chimesdkmessaging#ConflictException":
            throw await deserializeAws_restJson1ConflictExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkmessaging#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkmessaging#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkmessaging#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkmessaging#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkmessaging#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1DeleteChannelMembershipCommand = async (output, context) => {
    if (output.statusCode !== 204 && output.statusCode >= 300) {
        return deserializeAws_restJson1DeleteChannelMembershipCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    await collectBody(output.body, context);
    return contents;
};
const deserializeAws_restJson1DeleteChannelMembershipCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkmessaging#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ConflictException":
        case "com.amazonaws.chimesdkmessaging#ConflictException":
            throw await deserializeAws_restJson1ConflictExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkmessaging#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkmessaging#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkmessaging#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkmessaging#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkmessaging#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1DeleteChannelMessageCommand = async (output, context) => {
    if (output.statusCode !== 204 && output.statusCode >= 300) {
        return deserializeAws_restJson1DeleteChannelMessageCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    await collectBody(output.body, context);
    return contents;
};
const deserializeAws_restJson1DeleteChannelMessageCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkmessaging#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkmessaging#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkmessaging#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkmessaging#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkmessaging#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkmessaging#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1DeleteChannelModeratorCommand = async (output, context) => {
    if (output.statusCode !== 204 && output.statusCode >= 300) {
        return deserializeAws_restJson1DeleteChannelModeratorCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    await collectBody(output.body, context);
    return contents;
};
const deserializeAws_restJson1DeleteChannelModeratorCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkmessaging#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkmessaging#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkmessaging#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkmessaging#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkmessaging#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkmessaging#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1DeleteMessagingStreamingConfigurationsCommand = async (output, context) => {
    if (output.statusCode !== 204 && output.statusCode >= 300) {
        return deserializeAws_restJson1DeleteMessagingStreamingConfigurationsCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    await collectBody(output.body, context);
    return contents;
};
const deserializeAws_restJson1DeleteMessagingStreamingConfigurationsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "ForbiddenException":
        case "com.amazonaws.chimesdkmessaging#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkmessaging#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkmessaging#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkmessaging#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkmessaging#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1DescribeChannelCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return deserializeAws_restJson1DescribeChannelCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    if (data.Channel != null) {
        contents.Channel = deserializeAws_restJson1Channel(data.Channel, context);
    }
    return contents;
};
const deserializeAws_restJson1DescribeChannelCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkmessaging#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkmessaging#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkmessaging#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkmessaging#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkmessaging#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkmessaging#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1DescribeChannelBanCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return deserializeAws_restJson1DescribeChannelBanCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    if (data.ChannelBan != null) {
        contents.ChannelBan = deserializeAws_restJson1ChannelBan(data.ChannelBan, context);
    }
    return contents;
};
const deserializeAws_restJson1DescribeChannelBanCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkmessaging#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkmessaging#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chimesdkmessaging#NotFoundException":
            throw await deserializeAws_restJson1NotFoundExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkmessaging#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkmessaging#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkmessaging#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkmessaging#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1DescribeChannelFlowCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return deserializeAws_restJson1DescribeChannelFlowCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    if (data.ChannelFlow != null) {
        contents.ChannelFlow = deserializeAws_restJson1ChannelFlow(data.ChannelFlow, context);
    }
    return contents;
};
const deserializeAws_restJson1DescribeChannelFlowCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkmessaging#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkmessaging#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkmessaging#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkmessaging#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkmessaging#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkmessaging#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1DescribeChannelMembershipCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return deserializeAws_restJson1DescribeChannelMembershipCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    if (data.ChannelMembership != null) {
        contents.ChannelMembership = deserializeAws_restJson1ChannelMembership(data.ChannelMembership, context);
    }
    return contents;
};
const deserializeAws_restJson1DescribeChannelMembershipCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkmessaging#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkmessaging#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chimesdkmessaging#NotFoundException":
            throw await deserializeAws_restJson1NotFoundExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkmessaging#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkmessaging#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkmessaging#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkmessaging#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1DescribeChannelMembershipForAppInstanceUserCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return deserializeAws_restJson1DescribeChannelMembershipForAppInstanceUserCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    if (data.ChannelMembership != null) {
        contents.ChannelMembership = deserializeAws_restJson1ChannelMembershipForAppInstanceUserSummary(data.ChannelMembership, context);
    }
    return contents;
};
const deserializeAws_restJson1DescribeChannelMembershipForAppInstanceUserCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkmessaging#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkmessaging#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkmessaging#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkmessaging#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkmessaging#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkmessaging#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1DescribeChannelModeratedByAppInstanceUserCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return deserializeAws_restJson1DescribeChannelModeratedByAppInstanceUserCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    if (data.Channel != null) {
        contents.Channel = deserializeAws_restJson1ChannelModeratedByAppInstanceUserSummary(data.Channel, context);
    }
    return contents;
};
const deserializeAws_restJson1DescribeChannelModeratedByAppInstanceUserCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkmessaging#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkmessaging#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkmessaging#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkmessaging#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkmessaging#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkmessaging#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1DescribeChannelModeratorCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return deserializeAws_restJson1DescribeChannelModeratorCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    if (data.ChannelModerator != null) {
        contents.ChannelModerator = deserializeAws_restJson1ChannelModerator(data.ChannelModerator, context);
    }
    return contents;
};
const deserializeAws_restJson1DescribeChannelModeratorCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkmessaging#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkmessaging#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chimesdkmessaging#NotFoundException":
            throw await deserializeAws_restJson1NotFoundExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkmessaging#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkmessaging#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkmessaging#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkmessaging#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1DisassociateChannelFlowCommand = async (output, context) => {
    if (output.statusCode !== 204 && output.statusCode >= 300) {
        return deserializeAws_restJson1DisassociateChannelFlowCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    await collectBody(output.body, context);
    return contents;
};
const deserializeAws_restJson1DisassociateChannelFlowCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkmessaging#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ConflictException":
        case "com.amazonaws.chimesdkmessaging#ConflictException":
            throw await deserializeAws_restJson1ConflictExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkmessaging#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chimesdkmessaging#NotFoundException":
            throw await deserializeAws_restJson1NotFoundExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkmessaging#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkmessaging#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkmessaging#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkmessaging#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1GetChannelMembershipPreferencesCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return deserializeAws_restJson1GetChannelMembershipPreferencesCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    if (data.ChannelArn != null) {
        contents.ChannelArn = __expectString(data.ChannelArn);
    }
    if (data.Member != null) {
        contents.Member = deserializeAws_restJson1Identity(data.Member, context);
    }
    if (data.Preferences != null) {
        contents.Preferences = deserializeAws_restJson1ChannelMembershipPreferences(data.Preferences, context);
    }
    return contents;
};
const deserializeAws_restJson1GetChannelMembershipPreferencesCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkmessaging#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkmessaging#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkmessaging#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkmessaging#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkmessaging#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkmessaging#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1GetChannelMessageCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return deserializeAws_restJson1GetChannelMessageCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    if (data.ChannelMessage != null) {
        contents.ChannelMessage = deserializeAws_restJson1ChannelMessage(data.ChannelMessage, context);
    }
    return contents;
};
const deserializeAws_restJson1GetChannelMessageCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkmessaging#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkmessaging#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chimesdkmessaging#NotFoundException":
            throw await deserializeAws_restJson1NotFoundExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkmessaging#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkmessaging#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkmessaging#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkmessaging#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1GetChannelMessageStatusCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return deserializeAws_restJson1GetChannelMessageStatusCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    if (data.Status != null) {
        contents.Status = deserializeAws_restJson1ChannelMessageStatusStructure(data.Status, context);
    }
    return contents;
};
const deserializeAws_restJson1GetChannelMessageStatusCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkmessaging#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkmessaging#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkmessaging#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkmessaging#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkmessaging#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkmessaging#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1GetMessagingSessionEndpointCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return deserializeAws_restJson1GetMessagingSessionEndpointCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    if (data.Endpoint != null) {
        contents.Endpoint = deserializeAws_restJson1MessagingSessionEndpoint(data.Endpoint, context);
    }
    return contents;
};
const deserializeAws_restJson1GetMessagingSessionEndpointCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "ForbiddenException":
        case "com.amazonaws.chimesdkmessaging#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkmessaging#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkmessaging#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkmessaging#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkmessaging#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1GetMessagingStreamingConfigurationsCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return deserializeAws_restJson1GetMessagingStreamingConfigurationsCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    if (data.StreamingConfigurations != null) {
        contents.StreamingConfigurations = deserializeAws_restJson1StreamingConfigurationList(data.StreamingConfigurations, context);
    }
    return contents;
};
const deserializeAws_restJson1GetMessagingStreamingConfigurationsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkmessaging#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkmessaging#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chimesdkmessaging#NotFoundException":
            throw await deserializeAws_restJson1NotFoundExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkmessaging#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkmessaging#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkmessaging#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkmessaging#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1ListChannelBansCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return deserializeAws_restJson1ListChannelBansCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    if (data.ChannelArn != null) {
        contents.ChannelArn = __expectString(data.ChannelArn);
    }
    if (data.ChannelBans != null) {
        contents.ChannelBans = deserializeAws_restJson1ChannelBanSummaryList(data.ChannelBans, context);
    }
    if (data.NextToken != null) {
        contents.NextToken = __expectString(data.NextToken);
    }
    return contents;
};
const deserializeAws_restJson1ListChannelBansCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkmessaging#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkmessaging#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkmessaging#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkmessaging#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkmessaging#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkmessaging#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1ListChannelFlowsCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return deserializeAws_restJson1ListChannelFlowsCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    if (data.ChannelFlows != null) {
        contents.ChannelFlows = deserializeAws_restJson1ChannelFlowSummaryList(data.ChannelFlows, context);
    }
    if (data.NextToken != null) {
        contents.NextToken = __expectString(data.NextToken);
    }
    return contents;
};
const deserializeAws_restJson1ListChannelFlowsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkmessaging#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkmessaging#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkmessaging#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkmessaging#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkmessaging#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkmessaging#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1ListChannelMembershipsCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return deserializeAws_restJson1ListChannelMembershipsCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    if (data.ChannelArn != null) {
        contents.ChannelArn = __expectString(data.ChannelArn);
    }
    if (data.ChannelMemberships != null) {
        contents.ChannelMemberships = deserializeAws_restJson1ChannelMembershipSummaryList(data.ChannelMemberships, context);
    }
    if (data.NextToken != null) {
        contents.NextToken = __expectString(data.NextToken);
    }
    return contents;
};
const deserializeAws_restJson1ListChannelMembershipsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkmessaging#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkmessaging#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkmessaging#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkmessaging#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkmessaging#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkmessaging#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1ListChannelMembershipsForAppInstanceUserCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return deserializeAws_restJson1ListChannelMembershipsForAppInstanceUserCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    if (data.ChannelMemberships != null) {
        contents.ChannelMemberships = deserializeAws_restJson1ChannelMembershipForAppInstanceUserSummaryList(data.ChannelMemberships, context);
    }
    if (data.NextToken != null) {
        contents.NextToken = __expectString(data.NextToken);
    }
    return contents;
};
const deserializeAws_restJson1ListChannelMembershipsForAppInstanceUserCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkmessaging#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkmessaging#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkmessaging#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkmessaging#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkmessaging#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkmessaging#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1ListChannelMessagesCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return deserializeAws_restJson1ListChannelMessagesCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    if (data.ChannelArn != null) {
        contents.ChannelArn = __expectString(data.ChannelArn);
    }
    if (data.ChannelMessages != null) {
        contents.ChannelMessages = deserializeAws_restJson1ChannelMessageSummaryList(data.ChannelMessages, context);
    }
    if (data.NextToken != null) {
        contents.NextToken = __expectString(data.NextToken);
    }
    if (data.SubChannelId != null) {
        contents.SubChannelId = __expectString(data.SubChannelId);
    }
    return contents;
};
const deserializeAws_restJson1ListChannelMessagesCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkmessaging#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkmessaging#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkmessaging#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkmessaging#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkmessaging#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkmessaging#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1ListChannelModeratorsCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return deserializeAws_restJson1ListChannelModeratorsCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    if (data.ChannelArn != null) {
        contents.ChannelArn = __expectString(data.ChannelArn);
    }
    if (data.ChannelModerators != null) {
        contents.ChannelModerators = deserializeAws_restJson1ChannelModeratorSummaryList(data.ChannelModerators, context);
    }
    if (data.NextToken != null) {
        contents.NextToken = __expectString(data.NextToken);
    }
    return contents;
};
const deserializeAws_restJson1ListChannelModeratorsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkmessaging#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkmessaging#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkmessaging#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkmessaging#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkmessaging#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkmessaging#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1ListChannelsCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return deserializeAws_restJson1ListChannelsCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    if (data.Channels != null) {
        contents.Channels = deserializeAws_restJson1ChannelSummaryList(data.Channels, context);
    }
    if (data.NextToken != null) {
        contents.NextToken = __expectString(data.NextToken);
    }
    return contents;
};
const deserializeAws_restJson1ListChannelsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkmessaging#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkmessaging#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkmessaging#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkmessaging#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkmessaging#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkmessaging#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1ListChannelsAssociatedWithChannelFlowCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return deserializeAws_restJson1ListChannelsAssociatedWithChannelFlowCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    if (data.Channels != null) {
        contents.Channels = deserializeAws_restJson1ChannelAssociatedWithFlowSummaryList(data.Channels, context);
    }
    if (data.NextToken != null) {
        contents.NextToken = __expectString(data.NextToken);
    }
    return contents;
};
const deserializeAws_restJson1ListChannelsAssociatedWithChannelFlowCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkmessaging#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkmessaging#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkmessaging#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkmessaging#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkmessaging#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkmessaging#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1ListChannelsModeratedByAppInstanceUserCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return deserializeAws_restJson1ListChannelsModeratedByAppInstanceUserCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    if (data.Channels != null) {
        contents.Channels = deserializeAws_restJson1ChannelModeratedByAppInstanceUserSummaryList(data.Channels, context);
    }
    if (data.NextToken != null) {
        contents.NextToken = __expectString(data.NextToken);
    }
    return contents;
};
const deserializeAws_restJson1ListChannelsModeratedByAppInstanceUserCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkmessaging#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkmessaging#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkmessaging#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkmessaging#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkmessaging#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkmessaging#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1ListSubChannelsCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return deserializeAws_restJson1ListSubChannelsCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    if (data.ChannelArn != null) {
        contents.ChannelArn = __expectString(data.ChannelArn);
    }
    if (data.NextToken != null) {
        contents.NextToken = __expectString(data.NextToken);
    }
    if (data.SubChannels != null) {
        contents.SubChannels = deserializeAws_restJson1SubChannelSummaryList(data.SubChannels, context);
    }
    return contents;
};
const deserializeAws_restJson1ListSubChannelsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkmessaging#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkmessaging#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkmessaging#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkmessaging#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkmessaging#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkmessaging#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1ListTagsForResourceCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return deserializeAws_restJson1ListTagsForResourceCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    if (data.Tags != null) {
        contents.Tags = deserializeAws_restJson1TagList(data.Tags, context);
    }
    return contents;
};
const deserializeAws_restJson1ListTagsForResourceCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkmessaging#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkmessaging#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkmessaging#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkmessaging#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkmessaging#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkmessaging#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1PutChannelExpirationSettingsCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return deserializeAws_restJson1PutChannelExpirationSettingsCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    if (data.ChannelArn != null) {
        contents.ChannelArn = __expectString(data.ChannelArn);
    }
    if (data.ExpirationSettings != null) {
        contents.ExpirationSettings = deserializeAws_restJson1ExpirationSettings(data.ExpirationSettings, context);
    }
    return contents;
};
const deserializeAws_restJson1PutChannelExpirationSettingsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkmessaging#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ConflictException":
        case "com.amazonaws.chimesdkmessaging#ConflictException":
            throw await deserializeAws_restJson1ConflictExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkmessaging#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkmessaging#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkmessaging#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkmessaging#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkmessaging#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1PutChannelMembershipPreferencesCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return deserializeAws_restJson1PutChannelMembershipPreferencesCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    if (data.ChannelArn != null) {
        contents.ChannelArn = __expectString(data.ChannelArn);
    }
    if (data.Member != null) {
        contents.Member = deserializeAws_restJson1Identity(data.Member, context);
    }
    if (data.Preferences != null) {
        contents.Preferences = deserializeAws_restJson1ChannelMembershipPreferences(data.Preferences, context);
    }
    return contents;
};
const deserializeAws_restJson1PutChannelMembershipPreferencesCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkmessaging#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ConflictException":
        case "com.amazonaws.chimesdkmessaging#ConflictException":
            throw await deserializeAws_restJson1ConflictExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkmessaging#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkmessaging#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkmessaging#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkmessaging#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkmessaging#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1PutMessagingStreamingConfigurationsCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return deserializeAws_restJson1PutMessagingStreamingConfigurationsCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    if (data.StreamingConfigurations != null) {
        contents.StreamingConfigurations = deserializeAws_restJson1StreamingConfigurationList(data.StreamingConfigurations, context);
    }
    return contents;
};
const deserializeAws_restJson1PutMessagingStreamingConfigurationsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkmessaging#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ConflictException":
        case "com.amazonaws.chimesdkmessaging#ConflictException":
            throw await deserializeAws_restJson1ConflictExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkmessaging#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chimesdkmessaging#NotFoundException":
            throw await deserializeAws_restJson1NotFoundExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkmessaging#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkmessaging#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkmessaging#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkmessaging#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1RedactChannelMessageCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return deserializeAws_restJson1RedactChannelMessageCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    if (data.ChannelArn != null) {
        contents.ChannelArn = __expectString(data.ChannelArn);
    }
    if (data.MessageId != null) {
        contents.MessageId = __expectString(data.MessageId);
    }
    if (data.SubChannelId != null) {
        contents.SubChannelId = __expectString(data.SubChannelId);
    }
    return contents;
};
const deserializeAws_restJson1RedactChannelMessageCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkmessaging#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ConflictException":
        case "com.amazonaws.chimesdkmessaging#ConflictException":
            throw await deserializeAws_restJson1ConflictExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkmessaging#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkmessaging#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkmessaging#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkmessaging#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkmessaging#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1SearchChannelsCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return deserializeAws_restJson1SearchChannelsCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    if (data.Channels != null) {
        contents.Channels = deserializeAws_restJson1ChannelSummaryList(data.Channels, context);
    }
    if (data.NextToken != null) {
        contents.NextToken = __expectString(data.NextToken);
    }
    return contents;
};
const deserializeAws_restJson1SearchChannelsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkmessaging#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkmessaging#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkmessaging#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkmessaging#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkmessaging#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkmessaging#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1SendChannelMessageCommand = async (output, context) => {
    if (output.statusCode !== 201 && output.statusCode >= 300) {
        return deserializeAws_restJson1SendChannelMessageCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    if (data.ChannelArn != null) {
        contents.ChannelArn = __expectString(data.ChannelArn);
    }
    if (data.MessageId != null) {
        contents.MessageId = __expectString(data.MessageId);
    }
    if (data.Status != null) {
        contents.Status = deserializeAws_restJson1ChannelMessageStatusStructure(data.Status, context);
    }
    if (data.SubChannelId != null) {
        contents.SubChannelId = __expectString(data.SubChannelId);
    }
    return contents;
};
const deserializeAws_restJson1SendChannelMessageCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkmessaging#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ConflictException":
        case "com.amazonaws.chimesdkmessaging#ConflictException":
            throw await deserializeAws_restJson1ConflictExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkmessaging#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkmessaging#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkmessaging#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkmessaging#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkmessaging#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1TagResourceCommand = async (output, context) => {
    if (output.statusCode !== 204 && output.statusCode >= 300) {
        return deserializeAws_restJson1TagResourceCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    await collectBody(output.body, context);
    return contents;
};
const deserializeAws_restJson1TagResourceCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkmessaging#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkmessaging#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "ResourceLimitExceededException":
        case "com.amazonaws.chimesdkmessaging#ResourceLimitExceededException":
            throw await deserializeAws_restJson1ResourceLimitExceededExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkmessaging#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkmessaging#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkmessaging#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkmessaging#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1UntagResourceCommand = async (output, context) => {
    if (output.statusCode !== 204 && output.statusCode >= 300) {
        return deserializeAws_restJson1UntagResourceCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    await collectBody(output.body, context);
    return contents;
};
const deserializeAws_restJson1UntagResourceCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkmessaging#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkmessaging#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkmessaging#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkmessaging#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkmessaging#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkmessaging#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1UpdateChannelCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return deserializeAws_restJson1UpdateChannelCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    if (data.ChannelArn != null) {
        contents.ChannelArn = __expectString(data.ChannelArn);
    }
    return contents;
};
const deserializeAws_restJson1UpdateChannelCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkmessaging#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ConflictException":
        case "com.amazonaws.chimesdkmessaging#ConflictException":
            throw await deserializeAws_restJson1ConflictExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkmessaging#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkmessaging#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkmessaging#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkmessaging#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkmessaging#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1UpdateChannelFlowCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return deserializeAws_restJson1UpdateChannelFlowCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    if (data.ChannelFlowArn != null) {
        contents.ChannelFlowArn = __expectString(data.ChannelFlowArn);
    }
    return contents;
};
const deserializeAws_restJson1UpdateChannelFlowCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkmessaging#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ConflictException":
        case "com.amazonaws.chimesdkmessaging#ConflictException":
            throw await deserializeAws_restJson1ConflictExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkmessaging#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkmessaging#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkmessaging#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkmessaging#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkmessaging#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1UpdateChannelMessageCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return deserializeAws_restJson1UpdateChannelMessageCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    if (data.ChannelArn != null) {
        contents.ChannelArn = __expectString(data.ChannelArn);
    }
    if (data.MessageId != null) {
        contents.MessageId = __expectString(data.MessageId);
    }
    if (data.Status != null) {
        contents.Status = deserializeAws_restJson1ChannelMessageStatusStructure(data.Status, context);
    }
    if (data.SubChannelId != null) {
        contents.SubChannelId = __expectString(data.SubChannelId);
    }
    return contents;
};
const deserializeAws_restJson1UpdateChannelMessageCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkmessaging#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ConflictException":
        case "com.amazonaws.chimesdkmessaging#ConflictException":
            throw await deserializeAws_restJson1ConflictExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkmessaging#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkmessaging#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkmessaging#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkmessaging#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkmessaging#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1UpdateChannelReadMarkerCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return deserializeAws_restJson1UpdateChannelReadMarkerCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    if (data.ChannelArn != null) {
        contents.ChannelArn = __expectString(data.ChannelArn);
    }
    if (data.SubChannelId != null) {
        contents.SubChannelId = __expectString(data.SubChannelId);
    }
    return contents;
};
const deserializeAws_restJson1UpdateChannelReadMarkerCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkmessaging#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ConflictException":
        case "com.amazonaws.chimesdkmessaging#ConflictException":
            throw await deserializeAws_restJson1ConflictExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkmessaging#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkmessaging#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkmessaging#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkmessaging#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkmessaging#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
const map = __map;
const deserializeAws_restJson1BadRequestExceptionResponse = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body;
    if (data.Code != null) {
        contents.Code = __expectString(data.Code);
    }
    if (data.Message != null) {
        contents.Message = __expectString(data.Message);
    }
    const exception = new BadRequestException({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return __decorateServiceException(exception, parsedOutput.body);
};
const deserializeAws_restJson1ConflictExceptionResponse = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body;
    if (data.Code != null) {
        contents.Code = __expectString(data.Code);
    }
    if (data.Message != null) {
        contents.Message = __expectString(data.Message);
    }
    const exception = new ConflictException({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return __decorateServiceException(exception, parsedOutput.body);
};
const deserializeAws_restJson1ForbiddenExceptionResponse = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body;
    if (data.Code != null) {
        contents.Code = __expectString(data.Code);
    }
    if (data.Message != null) {
        contents.Message = __expectString(data.Message);
    }
    const exception = new ForbiddenException({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return __decorateServiceException(exception, parsedOutput.body);
};
const deserializeAws_restJson1NotFoundExceptionResponse = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body;
    if (data.Code != null) {
        contents.Code = __expectString(data.Code);
    }
    if (data.Message != null) {
        contents.Message = __expectString(data.Message);
    }
    const exception = new NotFoundException({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return __decorateServiceException(exception, parsedOutput.body);
};
const deserializeAws_restJson1ResourceLimitExceededExceptionResponse = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body;
    if (data.Code != null) {
        contents.Code = __expectString(data.Code);
    }
    if (data.Message != null) {
        contents.Message = __expectString(data.Message);
    }
    const exception = new ResourceLimitExceededException({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return __decorateServiceException(exception, parsedOutput.body);
};
const deserializeAws_restJson1ServiceFailureExceptionResponse = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body;
    if (data.Code != null) {
        contents.Code = __expectString(data.Code);
    }
    if (data.Message != null) {
        contents.Message = __expectString(data.Message);
    }
    const exception = new ServiceFailureException({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return __decorateServiceException(exception, parsedOutput.body);
};
const deserializeAws_restJson1ServiceUnavailableExceptionResponse = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body;
    if (data.Code != null) {
        contents.Code = __expectString(data.Code);
    }
    if (data.Message != null) {
        contents.Message = __expectString(data.Message);
    }
    const exception = new ServiceUnavailableException({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return __decorateServiceException(exception, parsedOutput.body);
};
const deserializeAws_restJson1ThrottledClientExceptionResponse = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body;
    if (data.Code != null) {
        contents.Code = __expectString(data.Code);
    }
    if (data.Message != null) {
        contents.Message = __expectString(data.Message);
    }
    const exception = new ThrottledClientException({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return __decorateServiceException(exception, parsedOutput.body);
};
const deserializeAws_restJson1UnauthorizedClientExceptionResponse = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body;
    if (data.Code != null) {
        contents.Code = __expectString(data.Code);
    }
    if (data.Message != null) {
        contents.Message = __expectString(data.Message);
    }
    const exception = new UnauthorizedClientException({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return __decorateServiceException(exception, parsedOutput.body);
};
const serializeAws_restJson1ChannelMemberArns = (input, context) => {
    return input
        .filter((e) => e != null)
        .map((entry) => {
        return entry;
    });
};
const serializeAws_restJson1ChannelMembershipPreferences = (input, context) => {
    return {
        ...(input.PushNotifications != null && {
            PushNotifications: serializeAws_restJson1PushNotificationPreferences(input.PushNotifications, context),
        }),
    };
};
const serializeAws_restJson1ChannelMessageCallback = (input, context) => {
    return {
        ...(input.Content != null && { Content: input.Content }),
        ...(input.ContentType != null && { ContentType: input.ContentType }),
        ...(input.MessageAttributes != null && {
            MessageAttributes: serializeAws_restJson1MessageAttributeMap(input.MessageAttributes, context),
        }),
        ...(input.MessageId != null && { MessageId: input.MessageId }),
        ...(input.Metadata != null && { Metadata: input.Metadata }),
        ...(input.PushNotification != null && {
            PushNotification: serializeAws_restJson1PushNotificationConfiguration(input.PushNotification, context),
        }),
        ...(input.SubChannelId != null && { SubChannelId: input.SubChannelId }),
    };
};
const serializeAws_restJson1ChannelModeratorArns = (input, context) => {
    return input
        .filter((e) => e != null)
        .map((entry) => {
        return entry;
    });
};
const serializeAws_restJson1ElasticChannelConfiguration = (input, context) => {
    return {
        ...(input.MaximumSubChannels != null && { MaximumSubChannels: input.MaximumSubChannels }),
        ...(input.MinimumMembershipPercentage != null && {
            MinimumMembershipPercentage: input.MinimumMembershipPercentage,
        }),
        ...(input.TargetMembershipsPerSubChannel != null && {
            TargetMembershipsPerSubChannel: input.TargetMembershipsPerSubChannel,
        }),
    };
};
const serializeAws_restJson1ExpirationSettings = (input, context) => {
    return {
        ...(input.ExpirationCriterion != null && { ExpirationCriterion: input.ExpirationCriterion }),
        ...(input.ExpirationDays != null && { ExpirationDays: input.ExpirationDays }),
    };
};
const serializeAws_restJson1LambdaConfiguration = (input, context) => {
    return {
        ...(input.InvocationType != null && { InvocationType: input.InvocationType }),
        ...(input.ResourceArn != null && { ResourceArn: input.ResourceArn }),
    };
};
const serializeAws_restJson1MemberArns = (input, context) => {
    return input
        .filter((e) => e != null)
        .map((entry) => {
        return entry;
    });
};
const serializeAws_restJson1MessageAttributeMap = (input, context) => {
    return Object.entries(input).reduce((acc, [key, value]) => {
        if (value === null) {
            return acc;
        }
        acc[key] = serializeAws_restJson1MessageAttributeValue(value, context);
        return acc;
    }, {});
};
const serializeAws_restJson1MessageAttributeStringValues = (input, context) => {
    return input
        .filter((e) => e != null)
        .map((entry) => {
        return entry;
    });
};
const serializeAws_restJson1MessageAttributeValue = (input, context) => {
    return {
        ...(input.StringValues != null && {
            StringValues: serializeAws_restJson1MessageAttributeStringValues(input.StringValues, context),
        }),
    };
};
const serializeAws_restJson1Processor = (input, context) => {
    return {
        ...(input.Configuration != null && {
            Configuration: serializeAws_restJson1ProcessorConfiguration(input.Configuration, context),
        }),
        ...(input.ExecutionOrder != null && { ExecutionOrder: input.ExecutionOrder }),
        ...(input.FallbackAction != null && { FallbackAction: input.FallbackAction }),
        ...(input.Name != null && { Name: input.Name }),
    };
};
const serializeAws_restJson1ProcessorConfiguration = (input, context) => {
    return {
        ...(input.Lambda != null && { Lambda: serializeAws_restJson1LambdaConfiguration(input.Lambda, context) }),
    };
};
const serializeAws_restJson1ProcessorList = (input, context) => {
    return input
        .filter((e) => e != null)
        .map((entry) => {
        return serializeAws_restJson1Processor(entry, context);
    });
};
const serializeAws_restJson1PushNotificationConfiguration = (input, context) => {
    return {
        ...(input.Body != null && { Body: input.Body }),
        ...(input.Title != null && { Title: input.Title }),
        ...(input.Type != null && { Type: input.Type }),
    };
};
const serializeAws_restJson1PushNotificationPreferences = (input, context) => {
    return {
        ...(input.AllowNotifications != null && { AllowNotifications: input.AllowNotifications }),
        ...(input.FilterRule != null && { FilterRule: input.FilterRule }),
    };
};
const serializeAws_restJson1SearchField = (input, context) => {
    return {
        ...(input.Key != null && { Key: input.Key }),
        ...(input.Operator != null && { Operator: input.Operator }),
        ...(input.Values != null && { Values: serializeAws_restJson1SearchFieldValues(input.Values, context) }),
    };
};
const serializeAws_restJson1SearchFields = (input, context) => {
    return input
        .filter((e) => e != null)
        .map((entry) => {
        return serializeAws_restJson1SearchField(entry, context);
    });
};
const serializeAws_restJson1SearchFieldValues = (input, context) => {
    return input
        .filter((e) => e != null)
        .map((entry) => {
        return entry;
    });
};
const serializeAws_restJson1StreamingConfiguration = (input, context) => {
    return {
        ...(input.DataType != null && { DataType: input.DataType }),
        ...(input.ResourceArn != null && { ResourceArn: input.ResourceArn }),
    };
};
const serializeAws_restJson1StreamingConfigurationList = (input, context) => {
    return input
        .filter((e) => e != null)
        .map((entry) => {
        return serializeAws_restJson1StreamingConfiguration(entry, context);
    });
};
const serializeAws_restJson1Tag = (input, context) => {
    return {
        ...(input.Key != null && { Key: input.Key }),
        ...(input.Value != null && { Value: input.Value }),
    };
};
const serializeAws_restJson1TagKeyList = (input, context) => {
    return input
        .filter((e) => e != null)
        .map((entry) => {
        return entry;
    });
};
const serializeAws_restJson1TagList = (input, context) => {
    return input
        .filter((e) => e != null)
        .map((entry) => {
        return serializeAws_restJson1Tag(entry, context);
    });
};
const deserializeAws_restJson1AppInstanceUserMembershipSummary = (output, context) => {
    return {
        ReadMarkerTimestamp: output.ReadMarkerTimestamp != null
            ? __expectNonNull(__parseEpochTimestamp(__expectNumber(output.ReadMarkerTimestamp)))
            : undefined,
        SubChannelId: __expectString(output.SubChannelId),
        Type: __expectString(output.Type),
    };
};
const deserializeAws_restJson1BatchChannelMemberships = (output, context) => {
    return {
        ChannelArn: __expectString(output.ChannelArn),
        InvitedBy: output.InvitedBy != null ? deserializeAws_restJson1Identity(output.InvitedBy, context) : undefined,
        Members: output.Members != null ? deserializeAws_restJson1Members(output.Members, context) : undefined,
        SubChannelId: __expectString(output.SubChannelId),
        Type: __expectString(output.Type),
    };
};
const deserializeAws_restJson1BatchCreateChannelMembershipError = (output, context) => {
    return {
        ErrorCode: __expectString(output.ErrorCode),
        ErrorMessage: __expectString(output.ErrorMessage),
        MemberArn: __expectString(output.MemberArn),
    };
};
const deserializeAws_restJson1BatchCreateChannelMembershipErrors = (output, context) => {
    const retVal = (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        if (entry === null) {
            return null;
        }
        return deserializeAws_restJson1BatchCreateChannelMembershipError(entry, context);
    });
    return retVal;
};
const deserializeAws_restJson1Channel = (output, context) => {
    return {
        ChannelArn: __expectString(output.ChannelArn),
        ChannelFlowArn: __expectString(output.ChannelFlowArn),
        CreatedBy: output.CreatedBy != null ? deserializeAws_restJson1Identity(output.CreatedBy, context) : undefined,
        CreatedTimestamp: output.CreatedTimestamp != null
            ? __expectNonNull(__parseEpochTimestamp(__expectNumber(output.CreatedTimestamp)))
            : undefined,
        ElasticChannelConfiguration: output.ElasticChannelConfiguration != null
            ? deserializeAws_restJson1ElasticChannelConfiguration(output.ElasticChannelConfiguration, context)
            : undefined,
        ExpirationSettings: output.ExpirationSettings != null
            ? deserializeAws_restJson1ExpirationSettings(output.ExpirationSettings, context)
            : undefined,
        LastMessageTimestamp: output.LastMessageTimestamp != null
            ? __expectNonNull(__parseEpochTimestamp(__expectNumber(output.LastMessageTimestamp)))
            : undefined,
        LastUpdatedTimestamp: output.LastUpdatedTimestamp != null
            ? __expectNonNull(__parseEpochTimestamp(__expectNumber(output.LastUpdatedTimestamp)))
            : undefined,
        Metadata: __expectString(output.Metadata),
        Mode: __expectString(output.Mode),
        Name: __expectString(output.Name),
        Privacy: __expectString(output.Privacy),
    };
};
const deserializeAws_restJson1ChannelAssociatedWithFlowSummary = (output, context) => {
    return {
        ChannelArn: __expectString(output.ChannelArn),
        Metadata: __expectString(output.Metadata),
        Mode: __expectString(output.Mode),
        Name: __expectString(output.Name),
        Privacy: __expectString(output.Privacy),
    };
};
const deserializeAws_restJson1ChannelAssociatedWithFlowSummaryList = (output, context) => {
    const retVal = (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        if (entry === null) {
            return null;
        }
        return deserializeAws_restJson1ChannelAssociatedWithFlowSummary(entry, context);
    });
    return retVal;
};
const deserializeAws_restJson1ChannelBan = (output, context) => {
    return {
        ChannelArn: __expectString(output.ChannelArn),
        CreatedBy: output.CreatedBy != null ? deserializeAws_restJson1Identity(output.CreatedBy, context) : undefined,
        CreatedTimestamp: output.CreatedTimestamp != null
            ? __expectNonNull(__parseEpochTimestamp(__expectNumber(output.CreatedTimestamp)))
            : undefined,
        Member: output.Member != null ? deserializeAws_restJson1Identity(output.Member, context) : undefined,
    };
};
const deserializeAws_restJson1ChannelBanSummary = (output, context) => {
    return {
        Member: output.Member != null ? deserializeAws_restJson1Identity(output.Member, context) : undefined,
    };
};
const deserializeAws_restJson1ChannelBanSummaryList = (output, context) => {
    const retVal = (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        if (entry === null) {
            return null;
        }
        return deserializeAws_restJson1ChannelBanSummary(entry, context);
    });
    return retVal;
};
const deserializeAws_restJson1ChannelFlow = (output, context) => {
    return {
        ChannelFlowArn: __expectString(output.ChannelFlowArn),
        CreatedTimestamp: output.CreatedTimestamp != null
            ? __expectNonNull(__parseEpochTimestamp(__expectNumber(output.CreatedTimestamp)))
            : undefined,
        LastUpdatedTimestamp: output.LastUpdatedTimestamp != null
            ? __expectNonNull(__parseEpochTimestamp(__expectNumber(output.LastUpdatedTimestamp)))
            : undefined,
        Name: __expectString(output.Name),
        Processors: output.Processors != null ? deserializeAws_restJson1ProcessorList(output.Processors, context) : undefined,
    };
};
const deserializeAws_restJson1ChannelFlowSummary = (output, context) => {
    return {
        ChannelFlowArn: __expectString(output.ChannelFlowArn),
        Name: __expectString(output.Name),
        Processors: output.Processors != null ? deserializeAws_restJson1ProcessorList(output.Processors, context) : undefined,
    };
};
const deserializeAws_restJson1ChannelFlowSummaryList = (output, context) => {
    const retVal = (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        if (entry === null) {
            return null;
        }
        return deserializeAws_restJson1ChannelFlowSummary(entry, context);
    });
    return retVal;
};
const deserializeAws_restJson1ChannelMembership = (output, context) => {
    return {
        ChannelArn: __expectString(output.ChannelArn),
        CreatedTimestamp: output.CreatedTimestamp != null
            ? __expectNonNull(__parseEpochTimestamp(__expectNumber(output.CreatedTimestamp)))
            : undefined,
        InvitedBy: output.InvitedBy != null ? deserializeAws_restJson1Identity(output.InvitedBy, context) : undefined,
        LastUpdatedTimestamp: output.LastUpdatedTimestamp != null
            ? __expectNonNull(__parseEpochTimestamp(__expectNumber(output.LastUpdatedTimestamp)))
            : undefined,
        Member: output.Member != null ? deserializeAws_restJson1Identity(output.Member, context) : undefined,
        SubChannelId: __expectString(output.SubChannelId),
        Type: __expectString(output.Type),
    };
};
const deserializeAws_restJson1ChannelMembershipForAppInstanceUserSummary = (output, context) => {
    return {
        AppInstanceUserMembershipSummary: output.AppInstanceUserMembershipSummary != null
            ? deserializeAws_restJson1AppInstanceUserMembershipSummary(output.AppInstanceUserMembershipSummary, context)
            : undefined,
        ChannelSummary: output.ChannelSummary != null
            ? deserializeAws_restJson1ChannelSummary(output.ChannelSummary, context)
            : undefined,
    };
};
const deserializeAws_restJson1ChannelMembershipForAppInstanceUserSummaryList = (output, context) => {
    const retVal = (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        if (entry === null) {
            return null;
        }
        return deserializeAws_restJson1ChannelMembershipForAppInstanceUserSummary(entry, context);
    });
    return retVal;
};
const deserializeAws_restJson1ChannelMembershipPreferences = (output, context) => {
    return {
        PushNotifications: output.PushNotifications != null
            ? deserializeAws_restJson1PushNotificationPreferences(output.PushNotifications, context)
            : undefined,
    };
};
const deserializeAws_restJson1ChannelMembershipSummary = (output, context) => {
    return {
        Member: output.Member != null ? deserializeAws_restJson1Identity(output.Member, context) : undefined,
    };
};
const deserializeAws_restJson1ChannelMembershipSummaryList = (output, context) => {
    const retVal = (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        if (entry === null) {
            return null;
        }
        return deserializeAws_restJson1ChannelMembershipSummary(entry, context);
    });
    return retVal;
};
const deserializeAws_restJson1ChannelMessage = (output, context) => {
    return {
        ChannelArn: __expectString(output.ChannelArn),
        Content: __expectString(output.Content),
        ContentType: __expectString(output.ContentType),
        CreatedTimestamp: output.CreatedTimestamp != null
            ? __expectNonNull(__parseEpochTimestamp(__expectNumber(output.CreatedTimestamp)))
            : undefined,
        LastEditedTimestamp: output.LastEditedTimestamp != null
            ? __expectNonNull(__parseEpochTimestamp(__expectNumber(output.LastEditedTimestamp)))
            : undefined,
        LastUpdatedTimestamp: output.LastUpdatedTimestamp != null
            ? __expectNonNull(__parseEpochTimestamp(__expectNumber(output.LastUpdatedTimestamp)))
            : undefined,
        MessageAttributes: output.MessageAttributes != null
            ? deserializeAws_restJson1MessageAttributeMap(output.MessageAttributes, context)
            : undefined,
        MessageId: __expectString(output.MessageId),
        Metadata: __expectString(output.Metadata),
        Persistence: __expectString(output.Persistence),
        Redacted: __expectBoolean(output.Redacted),
        Sender: output.Sender != null ? deserializeAws_restJson1Identity(output.Sender, context) : undefined,
        Status: output.Status != null ? deserializeAws_restJson1ChannelMessageStatusStructure(output.Status, context) : undefined,
        SubChannelId: __expectString(output.SubChannelId),
        Type: __expectString(output.Type),
    };
};
const deserializeAws_restJson1ChannelMessageStatusStructure = (output, context) => {
    return {
        Detail: __expectString(output.Detail),
        Value: __expectString(output.Value),
    };
};
const deserializeAws_restJson1ChannelMessageSummary = (output, context) => {
    return {
        Content: __expectString(output.Content),
        ContentType: __expectString(output.ContentType),
        CreatedTimestamp: output.CreatedTimestamp != null
            ? __expectNonNull(__parseEpochTimestamp(__expectNumber(output.CreatedTimestamp)))
            : undefined,
        LastEditedTimestamp: output.LastEditedTimestamp != null
            ? __expectNonNull(__parseEpochTimestamp(__expectNumber(output.LastEditedTimestamp)))
            : undefined,
        LastUpdatedTimestamp: output.LastUpdatedTimestamp != null
            ? __expectNonNull(__parseEpochTimestamp(__expectNumber(output.LastUpdatedTimestamp)))
            : undefined,
        MessageAttributes: output.MessageAttributes != null
            ? deserializeAws_restJson1MessageAttributeMap(output.MessageAttributes, context)
            : undefined,
        MessageId: __expectString(output.MessageId),
        Metadata: __expectString(output.Metadata),
        Redacted: __expectBoolean(output.Redacted),
        Sender: output.Sender != null ? deserializeAws_restJson1Identity(output.Sender, context) : undefined,
        Status: output.Status != null ? deserializeAws_restJson1ChannelMessageStatusStructure(output.Status, context) : undefined,
        Type: __expectString(output.Type),
    };
};
const deserializeAws_restJson1ChannelMessageSummaryList = (output, context) => {
    const retVal = (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        if (entry === null) {
            return null;
        }
        return deserializeAws_restJson1ChannelMessageSummary(entry, context);
    });
    return retVal;
};
const deserializeAws_restJson1ChannelModeratedByAppInstanceUserSummary = (output, context) => {
    return {
        ChannelSummary: output.ChannelSummary != null
            ? deserializeAws_restJson1ChannelSummary(output.ChannelSummary, context)
            : undefined,
    };
};
const deserializeAws_restJson1ChannelModeratedByAppInstanceUserSummaryList = (output, context) => {
    const retVal = (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        if (entry === null) {
            return null;
        }
        return deserializeAws_restJson1ChannelModeratedByAppInstanceUserSummary(entry, context);
    });
    return retVal;
};
const deserializeAws_restJson1ChannelModerator = (output, context) => {
    return {
        ChannelArn: __expectString(output.ChannelArn),
        CreatedBy: output.CreatedBy != null ? deserializeAws_restJson1Identity(output.CreatedBy, context) : undefined,
        CreatedTimestamp: output.CreatedTimestamp != null
            ? __expectNonNull(__parseEpochTimestamp(__expectNumber(output.CreatedTimestamp)))
            : undefined,
        Moderator: output.Moderator != null ? deserializeAws_restJson1Identity(output.Moderator, context) : undefined,
    };
};
const deserializeAws_restJson1ChannelModeratorSummary = (output, context) => {
    return {
        Moderator: output.Moderator != null ? deserializeAws_restJson1Identity(output.Moderator, context) : undefined,
    };
};
const deserializeAws_restJson1ChannelModeratorSummaryList = (output, context) => {
    const retVal = (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        if (entry === null) {
            return null;
        }
        return deserializeAws_restJson1ChannelModeratorSummary(entry, context);
    });
    return retVal;
};
const deserializeAws_restJson1ChannelSummary = (output, context) => {
    return {
        ChannelArn: __expectString(output.ChannelArn),
        LastMessageTimestamp: output.LastMessageTimestamp != null
            ? __expectNonNull(__parseEpochTimestamp(__expectNumber(output.LastMessageTimestamp)))
            : undefined,
        Metadata: __expectString(output.Metadata),
        Mode: __expectString(output.Mode),
        Name: __expectString(output.Name),
        Privacy: __expectString(output.Privacy),
    };
};
const deserializeAws_restJson1ChannelSummaryList = (output, context) => {
    const retVal = (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        if (entry === null) {
            return null;
        }
        return deserializeAws_restJson1ChannelSummary(entry, context);
    });
    return retVal;
};
const deserializeAws_restJson1ElasticChannelConfiguration = (output, context) => {
    return {
        MaximumSubChannels: __expectInt32(output.MaximumSubChannels),
        MinimumMembershipPercentage: __expectInt32(output.MinimumMembershipPercentage),
        TargetMembershipsPerSubChannel: __expectInt32(output.TargetMembershipsPerSubChannel),
    };
};
const deserializeAws_restJson1ExpirationSettings = (output, context) => {
    return {
        ExpirationCriterion: __expectString(output.ExpirationCriterion),
        ExpirationDays: __expectInt32(output.ExpirationDays),
    };
};
const deserializeAws_restJson1Identity = (output, context) => {
    return {
        Arn: __expectString(output.Arn),
        Name: __expectString(output.Name),
    };
};
const deserializeAws_restJson1LambdaConfiguration = (output, context) => {
    return {
        InvocationType: __expectString(output.InvocationType),
        ResourceArn: __expectString(output.ResourceArn),
    };
};
const deserializeAws_restJson1Members = (output, context) => {
    const retVal = (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        if (entry === null) {
            return null;
        }
        return deserializeAws_restJson1Identity(entry, context);
    });
    return retVal;
};
const deserializeAws_restJson1MessageAttributeMap = (output, context) => {
    return Object.entries(output).reduce((acc, [key, value]) => {
        if (value === null) {
            return acc;
        }
        acc[key] = deserializeAws_restJson1MessageAttributeValue(value, context);
        return acc;
    }, {});
};
const deserializeAws_restJson1MessageAttributeStringValues = (output, context) => {
    const retVal = (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        if (entry === null) {
            return null;
        }
        return __expectString(entry);
    });
    return retVal;
};
const deserializeAws_restJson1MessageAttributeValue = (output, context) => {
    return {
        StringValues: output.StringValues != null
            ? deserializeAws_restJson1MessageAttributeStringValues(output.StringValues, context)
            : undefined,
    };
};
const deserializeAws_restJson1MessagingSessionEndpoint = (output, context) => {
    return {
        Url: __expectString(output.Url),
    };
};
const deserializeAws_restJson1Processor = (output, context) => {
    return {
        Configuration: output.Configuration != null
            ? deserializeAws_restJson1ProcessorConfiguration(output.Configuration, context)
            : undefined,
        ExecutionOrder: __expectInt32(output.ExecutionOrder),
        FallbackAction: __expectString(output.FallbackAction),
        Name: __expectString(output.Name),
    };
};
const deserializeAws_restJson1ProcessorConfiguration = (output, context) => {
    return {
        Lambda: output.Lambda != null ? deserializeAws_restJson1LambdaConfiguration(output.Lambda, context) : undefined,
    };
};
const deserializeAws_restJson1ProcessorList = (output, context) => {
    const retVal = (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        if (entry === null) {
            return null;
        }
        return deserializeAws_restJson1Processor(entry, context);
    });
    return retVal;
};
const deserializeAws_restJson1PushNotificationPreferences = (output, context) => {
    return {
        AllowNotifications: __expectString(output.AllowNotifications),
        FilterRule: __expectString(output.FilterRule),
    };
};
const deserializeAws_restJson1StreamingConfiguration = (output, context) => {
    return {
        DataType: __expectString(output.DataType),
        ResourceArn: __expectString(output.ResourceArn),
    };
};
const deserializeAws_restJson1StreamingConfigurationList = (output, context) => {
    const retVal = (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        if (entry === null) {
            return null;
        }
        return deserializeAws_restJson1StreamingConfiguration(entry, context);
    });
    return retVal;
};
const deserializeAws_restJson1SubChannelSummary = (output, context) => {
    return {
        MembershipCount: __expectInt32(output.MembershipCount),
        SubChannelId: __expectString(output.SubChannelId),
    };
};
const deserializeAws_restJson1SubChannelSummaryList = (output, context) => {
    const retVal = (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        if (entry === null) {
            return null;
        }
        return deserializeAws_restJson1SubChannelSummary(entry, context);
    });
    return retVal;
};
const deserializeAws_restJson1Tag = (output, context) => {
    return {
        Key: __expectString(output.Key),
        Value: __expectString(output.Value),
    };
};
const deserializeAws_restJson1TagList = (output, context) => {
    const retVal = (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        if (entry === null) {
            return null;
        }
        return deserializeAws_restJson1Tag(entry, context);
    });
    return retVal;
};
const deserializeMetadata = (output) => ({
    httpStatusCode: output.statusCode,
    requestId: output.headers["x-amzn-requestid"] ?? output.headers["x-amzn-request-id"] ?? output.headers["x-amz-request-id"],
    extendedRequestId: output.headers["x-amz-id-2"],
    cfId: output.headers["x-amz-cf-id"],
});
const collectBody = (streamBody = new Uint8Array(), context) => {
    if (streamBody instanceof Uint8Array) {
        return Promise.resolve(streamBody);
    }
    return context.streamCollector(streamBody) || Promise.resolve(new Uint8Array());
};
const collectBodyString = (streamBody, context) => collectBody(streamBody, context).then((body) => context.utf8Encoder(body));
const isSerializableHeaderValue = (value) => value !== undefined &&
    value !== null &&
    value !== "" &&
    (!Object.getOwnPropertyNames(value).includes("length") || value.length != 0) &&
    (!Object.getOwnPropertyNames(value).includes("size") || value.size != 0);
const parseBody = (streamBody, context) => collectBodyString(streamBody, context).then((encoded) => {
    if (encoded.length) {
        return JSON.parse(encoded);
    }
    return {};
});
const parseErrorBody = async (errorBody, context) => {
    const value = await parseBody(errorBody, context);
    value.message = value.message ?? value.Message;
    return value;
};
const loadRestJsonErrorCode = (output, data) => {
    const findKey = (object, key) => Object.keys(object).find((k) => k.toLowerCase() === key.toLowerCase());
    const sanitizeErrorCode = (rawValue) => {
        let cleanValue = rawValue;
        if (typeof cleanValue === "number") {
            cleanValue = cleanValue.toString();
        }
        if (cleanValue.indexOf(",") >= 0) {
            cleanValue = cleanValue.split(",")[0];
        }
        if (cleanValue.indexOf(":") >= 0) {
            cleanValue = cleanValue.split(":")[0];
        }
        if (cleanValue.indexOf("#") >= 0) {
            cleanValue = cleanValue.split("#")[1];
        }
        return cleanValue;
    };
    const headerKey = findKey(output.headers, "x-amzn-errortype");
    if (headerKey !== undefined) {
        return sanitizeErrorCode(output.headers[headerKey]);
    }
    if (data.code !== undefined) {
        return sanitizeErrorCode(data.code);
    }
    if (data["__type"] !== undefined) {
        return sanitizeErrorCode(data["__type"]);
    }
};
