import { HttpRequest as __HttpRequest, isValidHostname as __isValidHostname, } from "@aws-sdk/protocol-http";
import { decorateServiceException as __decorateServiceException, expectBoolean as __expectBoolean, expectInt32 as __expectInt32, expectNonNull as __expectNonNull, expectNumber as __expectNumber, expectObject as __expectObject, expectString as __expectString, map as __map, parseEpochTimestamp as __parseEpochTimestamp, parseRfc3339DateTimeWithOffset as __parseRfc3339DateTimeWithOffset, resolvedPath as __resolvedPath, throwDefaultError, } from "@aws-sdk/smithy-client";
import { v4 as generateIdempotencyToken } from "uuid";
import { ChimeServiceException as __BaseException } from "../models/ChimeServiceException";
import { AccessDeniedException, BadRequestException, ConflictException, ForbiddenException, NotFoundException, ResourceLimitExceededException, ServiceFailureException, ServiceUnavailableException, ThrottledClientException, UnauthorizedClientException, UnprocessableEntityException, } from "../models/models_0";
export const serializeAws_restJson1AssociatePhoneNumbersWithVoiceConnectorCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {
        "content-type": "application/json",
    };
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/voice-connectors/{VoiceConnectorId}";
    resolvedPath = __resolvedPath(resolvedPath, input, "VoiceConnectorId", () => input.VoiceConnectorId, "{VoiceConnectorId}", false);
    const query = map({
        operation: [, "associate-phone-numbers"],
    });
    let body;
    body = JSON.stringify({
        ...(input.E164PhoneNumbers != null && {
            E164PhoneNumbers: serializeAws_restJson1E164PhoneNumberList(input.E164PhoneNumbers, context),
        }),
        ...(input.ForceAssociate != null && { ForceAssociate: input.ForceAssociate }),
    });
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "POST",
        headers,
        path: resolvedPath,
        query,
        body,
    });
};
export const serializeAws_restJson1AssociatePhoneNumbersWithVoiceConnectorGroupCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {
        "content-type": "application/json",
    };
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` +
        "/voice-connector-groups/{VoiceConnectorGroupId}";
    resolvedPath = __resolvedPath(resolvedPath, input, "VoiceConnectorGroupId", () => input.VoiceConnectorGroupId, "{VoiceConnectorGroupId}", false);
    const query = map({
        operation: [, "associate-phone-numbers"],
    });
    let body;
    body = JSON.stringify({
        ...(input.E164PhoneNumbers != null && {
            E164PhoneNumbers: serializeAws_restJson1E164PhoneNumberList(input.E164PhoneNumbers, context),
        }),
        ...(input.ForceAssociate != null && { ForceAssociate: input.ForceAssociate }),
    });
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "POST",
        headers,
        path: resolvedPath,
        query,
        body,
    });
};
export const serializeAws_restJson1AssociatePhoneNumberWithUserCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {
        "content-type": "application/json",
    };
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/accounts/{AccountId}/users/{UserId}";
    resolvedPath = __resolvedPath(resolvedPath, input, "AccountId", () => input.AccountId, "{AccountId}", false);
    resolvedPath = __resolvedPath(resolvedPath, input, "UserId", () => input.UserId, "{UserId}", false);
    const query = map({
        operation: [, "associate-phone-number"],
    });
    let body;
    body = JSON.stringify({
        ...(input.E164PhoneNumber != null && { E164PhoneNumber: input.E164PhoneNumber }),
    });
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "POST",
        headers,
        path: resolvedPath,
        query,
        body,
    });
};
export const serializeAws_restJson1AssociateSigninDelegateGroupsWithAccountCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {
        "content-type": "application/json",
    };
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/accounts/{AccountId}";
    resolvedPath = __resolvedPath(resolvedPath, input, "AccountId", () => input.AccountId, "{AccountId}", false);
    const query = map({
        operation: [, "associate-signin-delegate-groups"],
    });
    let body;
    body = JSON.stringify({
        ...(input.SigninDelegateGroups != null && {
            SigninDelegateGroups: serializeAws_restJson1SigninDelegateGroupList(input.SigninDelegateGroups, context),
        }),
    });
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "POST",
        headers,
        path: resolvedPath,
        query,
        body,
    });
};
export const serializeAws_restJson1BatchCreateAttendeeCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {
        "content-type": "application/json",
    };
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/meetings/{MeetingId}/attendees";
    resolvedPath = __resolvedPath(resolvedPath, input, "MeetingId", () => input.MeetingId, "{MeetingId}", false);
    const query = map({
        operation: [, "batch-create"],
    });
    let body;
    body = JSON.stringify({
        ...(input.Attendees != null && {
            Attendees: serializeAws_restJson1CreateAttendeeRequestItemList(input.Attendees, context),
        }),
    });
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "POST",
        headers,
        path: resolvedPath,
        query,
        body,
    });
};
export const serializeAws_restJson1BatchCreateChannelMembershipCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = map({}, isSerializableHeaderValue, {
        "content-type": "application/json",
        "x-amz-chime-bearer": input.ChimeBearer,
    });
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/channels/{ChannelArn}/memberships";
    resolvedPath = __resolvedPath(resolvedPath, input, "ChannelArn", () => input.ChannelArn, "{ChannelArn}", false);
    const query = map({
        operation: [, "batch-create"],
    });
    let body;
    body = JSON.stringify({
        ...(input.MemberArns != null && { MemberArns: serializeAws_restJson1MemberArns(input.MemberArns, context) }),
        ...(input.Type != null && { Type: input.Type }),
    });
    let { hostname: resolvedHostname } = await context.endpoint();
    if (context.disableHostPrefix !== true) {
        resolvedHostname = "messaging-" + resolvedHostname;
        if (!__isValidHostname(resolvedHostname)) {
            throw new Error("ValidationError: prefixed hostname must be hostname compatible.");
        }
    }
    return new __HttpRequest({
        protocol,
        hostname: resolvedHostname,
        port,
        method: "POST",
        headers,
        path: resolvedPath,
        query,
        body,
    });
};
export const serializeAws_restJson1BatchCreateRoomMembershipCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {
        "content-type": "application/json",
    };
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` +
        "/accounts/{AccountId}/rooms/{RoomId}/memberships";
    resolvedPath = __resolvedPath(resolvedPath, input, "AccountId", () => input.AccountId, "{AccountId}", false);
    resolvedPath = __resolvedPath(resolvedPath, input, "RoomId", () => input.RoomId, "{RoomId}", false);
    const query = map({
        operation: [, "batch-create"],
    });
    let body;
    body = JSON.stringify({
        ...(input.MembershipItemList != null && {
            MembershipItemList: serializeAws_restJson1MembershipItemList(input.MembershipItemList, context),
        }),
    });
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "POST",
        headers,
        path: resolvedPath,
        query,
        body,
    });
};
export const serializeAws_restJson1BatchDeletePhoneNumberCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {
        "content-type": "application/json",
    };
    const resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/phone-numbers";
    const query = map({
        operation: [, "batch-delete"],
    });
    let body;
    body = JSON.stringify({
        ...(input.PhoneNumberIds != null && {
            PhoneNumberIds: serializeAws_restJson1NonEmptyStringList(input.PhoneNumberIds, context),
        }),
    });
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "POST",
        headers,
        path: resolvedPath,
        query,
        body,
    });
};
export const serializeAws_restJson1BatchSuspendUserCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {
        "content-type": "application/json",
    };
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/accounts/{AccountId}/users";
    resolvedPath = __resolvedPath(resolvedPath, input, "AccountId", () => input.AccountId, "{AccountId}", false);
    const query = map({
        operation: [, "suspend"],
    });
    let body;
    body = JSON.stringify({
        ...(input.UserIdList != null && { UserIdList: serializeAws_restJson1UserIdList(input.UserIdList, context) }),
    });
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "POST",
        headers,
        path: resolvedPath,
        query,
        body,
    });
};
export const serializeAws_restJson1BatchUnsuspendUserCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {
        "content-type": "application/json",
    };
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/accounts/{AccountId}/users";
    resolvedPath = __resolvedPath(resolvedPath, input, "AccountId", () => input.AccountId, "{AccountId}", false);
    const query = map({
        operation: [, "unsuspend"],
    });
    let body;
    body = JSON.stringify({
        ...(input.UserIdList != null && { UserIdList: serializeAws_restJson1UserIdList(input.UserIdList, context) }),
    });
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "POST",
        headers,
        path: resolvedPath,
        query,
        body,
    });
};
export const serializeAws_restJson1BatchUpdatePhoneNumberCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {
        "content-type": "application/json",
    };
    const resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/phone-numbers";
    const query = map({
        operation: [, "batch-update"],
    });
    let body;
    body = JSON.stringify({
        ...(input.UpdatePhoneNumberRequestItems != null && {
            UpdatePhoneNumberRequestItems: serializeAws_restJson1UpdatePhoneNumberRequestItemList(input.UpdatePhoneNumberRequestItems, context),
        }),
    });
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "POST",
        headers,
        path: resolvedPath,
        query,
        body,
    });
};
export const serializeAws_restJson1BatchUpdateUserCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {
        "content-type": "application/json",
    };
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/accounts/{AccountId}/users";
    resolvedPath = __resolvedPath(resolvedPath, input, "AccountId", () => input.AccountId, "{AccountId}", false);
    let body;
    body = JSON.stringify({
        ...(input.UpdateUserRequestItems != null && {
            UpdateUserRequestItems: serializeAws_restJson1UpdateUserRequestItemList(input.UpdateUserRequestItems, context),
        }),
    });
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "POST",
        headers,
        path: resolvedPath,
        body,
    });
};
export const serializeAws_restJson1CreateAccountCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {
        "content-type": "application/json",
    };
    const resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/accounts";
    let body;
    body = JSON.stringify({
        ...(input.Name != null && { Name: input.Name }),
    });
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "POST",
        headers,
        path: resolvedPath,
        body,
    });
};
export const serializeAws_restJson1CreateAppInstanceCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {
        "content-type": "application/json",
    };
    const resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/app-instances";
    let body;
    body = JSON.stringify({
        ClientRequestToken: input.ClientRequestToken ?? generateIdempotencyToken(),
        ...(input.Metadata != null && { Metadata: input.Metadata }),
        ...(input.Name != null && { Name: input.Name }),
        ...(input.Tags != null && { Tags: serializeAws_restJson1TagList(input.Tags, context) }),
    });
    let { hostname: resolvedHostname } = await context.endpoint();
    if (context.disableHostPrefix !== true) {
        resolvedHostname = "identity-" + resolvedHostname;
        if (!__isValidHostname(resolvedHostname)) {
            throw new Error("ValidationError: prefixed hostname must be hostname compatible.");
        }
    }
    return new __HttpRequest({
        protocol,
        hostname: resolvedHostname,
        port,
        method: "POST",
        headers,
        path: resolvedPath,
        body,
    });
};
export const serializeAws_restJson1CreateAppInstanceAdminCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {
        "content-type": "application/json",
    };
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/app-instances/{AppInstanceArn}/admins";
    resolvedPath = __resolvedPath(resolvedPath, input, "AppInstanceArn", () => input.AppInstanceArn, "{AppInstanceArn}", false);
    let body;
    body = JSON.stringify({
        ...(input.AppInstanceAdminArn != null && { AppInstanceAdminArn: input.AppInstanceAdminArn }),
    });
    let { hostname: resolvedHostname } = await context.endpoint();
    if (context.disableHostPrefix !== true) {
        resolvedHostname = "identity-" + resolvedHostname;
        if (!__isValidHostname(resolvedHostname)) {
            throw new Error("ValidationError: prefixed hostname must be hostname compatible.");
        }
    }
    return new __HttpRequest({
        protocol,
        hostname: resolvedHostname,
        port,
        method: "POST",
        headers,
        path: resolvedPath,
        body,
    });
};
export const serializeAws_restJson1CreateAppInstanceUserCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {
        "content-type": "application/json",
    };
    const resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/app-instance-users";
    let body;
    body = JSON.stringify({
        ...(input.AppInstanceArn != null && { AppInstanceArn: input.AppInstanceArn }),
        ...(input.AppInstanceUserId != null && { AppInstanceUserId: input.AppInstanceUserId }),
        ClientRequestToken: input.ClientRequestToken ?? generateIdempotencyToken(),
        ...(input.Metadata != null && { Metadata: input.Metadata }),
        ...(input.Name != null && { Name: input.Name }),
        ...(input.Tags != null && { Tags: serializeAws_restJson1TagList(input.Tags, context) }),
    });
    let { hostname: resolvedHostname } = await context.endpoint();
    if (context.disableHostPrefix !== true) {
        resolvedHostname = "identity-" + resolvedHostname;
        if (!__isValidHostname(resolvedHostname)) {
            throw new Error("ValidationError: prefixed hostname must be hostname compatible.");
        }
    }
    return new __HttpRequest({
        protocol,
        hostname: resolvedHostname,
        port,
        method: "POST",
        headers,
        path: resolvedPath,
        body,
    });
};
export const serializeAws_restJson1CreateAttendeeCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {
        "content-type": "application/json",
    };
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/meetings/{MeetingId}/attendees";
    resolvedPath = __resolvedPath(resolvedPath, input, "MeetingId", () => input.MeetingId, "{MeetingId}", false);
    let body;
    body = JSON.stringify({
        ...(input.ExternalUserId != null && { ExternalUserId: input.ExternalUserId }),
        ...(input.Tags != null && { Tags: serializeAws_restJson1AttendeeTagList(input.Tags, context) }),
    });
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "POST",
        headers,
        path: resolvedPath,
        body,
    });
};
export const serializeAws_restJson1CreateBotCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {
        "content-type": "application/json",
    };
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/accounts/{AccountId}/bots";
    resolvedPath = __resolvedPath(resolvedPath, input, "AccountId", () => input.AccountId, "{AccountId}", false);
    let body;
    body = JSON.stringify({
        ...(input.DisplayName != null && { DisplayName: input.DisplayName }),
        ...(input.Domain != null && { Domain: input.Domain }),
    });
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "POST",
        headers,
        path: resolvedPath,
        body,
    });
};
export const serializeAws_restJson1CreateChannelCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = map({}, isSerializableHeaderValue, {
        "content-type": "application/json",
        "x-amz-chime-bearer": input.ChimeBearer,
    });
    const resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/channels";
    let body;
    body = JSON.stringify({
        ...(input.AppInstanceArn != null && { AppInstanceArn: input.AppInstanceArn }),
        ClientRequestToken: input.ClientRequestToken ?? generateIdempotencyToken(),
        ...(input.Metadata != null && { Metadata: input.Metadata }),
        ...(input.Mode != null && { Mode: input.Mode }),
        ...(input.Name != null && { Name: input.Name }),
        ...(input.Privacy != null && { Privacy: input.Privacy }),
        ...(input.Tags != null && { Tags: serializeAws_restJson1TagList(input.Tags, context) }),
    });
    let { hostname: resolvedHostname } = await context.endpoint();
    if (context.disableHostPrefix !== true) {
        resolvedHostname = "messaging-" + resolvedHostname;
        if (!__isValidHostname(resolvedHostname)) {
            throw new Error("ValidationError: prefixed hostname must be hostname compatible.");
        }
    }
    return new __HttpRequest({
        protocol,
        hostname: resolvedHostname,
        port,
        method: "POST",
        headers,
        path: resolvedPath,
        body,
    });
};
export const serializeAws_restJson1CreateChannelBanCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = map({}, isSerializableHeaderValue, {
        "content-type": "application/json",
        "x-amz-chime-bearer": input.ChimeBearer,
    });
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/channels/{ChannelArn}/bans";
    resolvedPath = __resolvedPath(resolvedPath, input, "ChannelArn", () => input.ChannelArn, "{ChannelArn}", false);
    let body;
    body = JSON.stringify({
        ...(input.MemberArn != null && { MemberArn: input.MemberArn }),
    });
    let { hostname: resolvedHostname } = await context.endpoint();
    if (context.disableHostPrefix !== true) {
        resolvedHostname = "messaging-" + resolvedHostname;
        if (!__isValidHostname(resolvedHostname)) {
            throw new Error("ValidationError: prefixed hostname must be hostname compatible.");
        }
    }
    return new __HttpRequest({
        protocol,
        hostname: resolvedHostname,
        port,
        method: "POST",
        headers,
        path: resolvedPath,
        body,
    });
};
export const serializeAws_restJson1CreateChannelMembershipCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = map({}, isSerializableHeaderValue, {
        "content-type": "application/json",
        "x-amz-chime-bearer": input.ChimeBearer,
    });
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/channels/{ChannelArn}/memberships";
    resolvedPath = __resolvedPath(resolvedPath, input, "ChannelArn", () => input.ChannelArn, "{ChannelArn}", false);
    let body;
    body = JSON.stringify({
        ...(input.MemberArn != null && { MemberArn: input.MemberArn }),
        ...(input.Type != null && { Type: input.Type }),
    });
    let { hostname: resolvedHostname } = await context.endpoint();
    if (context.disableHostPrefix !== true) {
        resolvedHostname = "messaging-" + resolvedHostname;
        if (!__isValidHostname(resolvedHostname)) {
            throw new Error("ValidationError: prefixed hostname must be hostname compatible.");
        }
    }
    return new __HttpRequest({
        protocol,
        hostname: resolvedHostname,
        port,
        method: "POST",
        headers,
        path: resolvedPath,
        body,
    });
};
export const serializeAws_restJson1CreateChannelModeratorCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = map({}, isSerializableHeaderValue, {
        "content-type": "application/json",
        "x-amz-chime-bearer": input.ChimeBearer,
    });
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/channels/{ChannelArn}/moderators";
    resolvedPath = __resolvedPath(resolvedPath, input, "ChannelArn", () => input.ChannelArn, "{ChannelArn}", false);
    let body;
    body = JSON.stringify({
        ...(input.ChannelModeratorArn != null && { ChannelModeratorArn: input.ChannelModeratorArn }),
    });
    let { hostname: resolvedHostname } = await context.endpoint();
    if (context.disableHostPrefix !== true) {
        resolvedHostname = "messaging-" + resolvedHostname;
        if (!__isValidHostname(resolvedHostname)) {
            throw new Error("ValidationError: prefixed hostname must be hostname compatible.");
        }
    }
    return new __HttpRequest({
        protocol,
        hostname: resolvedHostname,
        port,
        method: "POST",
        headers,
        path: resolvedPath,
        body,
    });
};
export const serializeAws_restJson1CreateMediaCapturePipelineCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {
        "content-type": "application/json",
    };
    const resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/media-capture-pipelines";
    let body;
    body = JSON.stringify({
        ...(input.ChimeSdkMeetingConfiguration != null && {
            ChimeSdkMeetingConfiguration: serializeAws_restJson1ChimeSdkMeetingConfiguration(input.ChimeSdkMeetingConfiguration, context),
        }),
        ClientRequestToken: input.ClientRequestToken ?? generateIdempotencyToken(),
        ...(input.SinkArn != null && { SinkArn: input.SinkArn }),
        ...(input.SinkType != null && { SinkType: input.SinkType }),
        ...(input.SourceArn != null && { SourceArn: input.SourceArn }),
        ...(input.SourceType != null && { SourceType: input.SourceType }),
    });
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "POST",
        headers,
        path: resolvedPath,
        body,
    });
};
export const serializeAws_restJson1CreateMeetingCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {
        "content-type": "application/json",
    };
    const resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/meetings";
    let body;
    body = JSON.stringify({
        ClientRequestToken: input.ClientRequestToken ?? generateIdempotencyToken(),
        ...(input.ExternalMeetingId != null && { ExternalMeetingId: input.ExternalMeetingId }),
        ...(input.MediaRegion != null && { MediaRegion: input.MediaRegion }),
        ...(input.MeetingHostId != null && { MeetingHostId: input.MeetingHostId }),
        ...(input.NotificationsConfiguration != null && {
            NotificationsConfiguration: serializeAws_restJson1MeetingNotificationConfiguration(input.NotificationsConfiguration, context),
        }),
        ...(input.Tags != null && { Tags: serializeAws_restJson1MeetingTagList(input.Tags, context) }),
    });
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "POST",
        headers,
        path: resolvedPath,
        body,
    });
};
export const serializeAws_restJson1CreateMeetingDialOutCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {
        "content-type": "application/json",
    };
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/meetings/{MeetingId}/dial-outs";
    resolvedPath = __resolvedPath(resolvedPath, input, "MeetingId", () => input.MeetingId, "{MeetingId}", false);
    let body;
    body = JSON.stringify({
        ...(input.FromPhoneNumber != null && { FromPhoneNumber: input.FromPhoneNumber }),
        ...(input.JoinToken != null && { JoinToken: input.JoinToken }),
        ...(input.ToPhoneNumber != null && { ToPhoneNumber: input.ToPhoneNumber }),
    });
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "POST",
        headers,
        path: resolvedPath,
        body,
    });
};
export const serializeAws_restJson1CreateMeetingWithAttendeesCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {
        "content-type": "application/json",
    };
    const resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/meetings";
    const query = map({
        operation: [, "create-attendees"],
    });
    let body;
    body = JSON.stringify({
        ...(input.Attendees != null && {
            Attendees: serializeAws_restJson1CreateMeetingWithAttendeesRequestItemList(input.Attendees, context),
        }),
        ClientRequestToken: input.ClientRequestToken ?? generateIdempotencyToken(),
        ...(input.ExternalMeetingId != null && { ExternalMeetingId: input.ExternalMeetingId }),
        ...(input.MediaRegion != null && { MediaRegion: input.MediaRegion }),
        ...(input.MeetingHostId != null && { MeetingHostId: input.MeetingHostId }),
        ...(input.NotificationsConfiguration != null && {
            NotificationsConfiguration: serializeAws_restJson1MeetingNotificationConfiguration(input.NotificationsConfiguration, context),
        }),
        ...(input.Tags != null && { Tags: serializeAws_restJson1MeetingTagList(input.Tags, context) }),
    });
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "POST",
        headers,
        path: resolvedPath,
        query,
        body,
    });
};
export const serializeAws_restJson1CreatePhoneNumberOrderCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {
        "content-type": "application/json",
    };
    const resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/phone-number-orders";
    let body;
    body = JSON.stringify({
        ...(input.E164PhoneNumbers != null && {
            E164PhoneNumbers: serializeAws_restJson1E164PhoneNumberList(input.E164PhoneNumbers, context),
        }),
        ...(input.ProductType != null && { ProductType: input.ProductType }),
    });
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "POST",
        headers,
        path: resolvedPath,
        body,
    });
};
export const serializeAws_restJson1CreateProxySessionCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {
        "content-type": "application/json",
    };
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` +
        "/voice-connectors/{VoiceConnectorId}/proxy-sessions";
    resolvedPath = __resolvedPath(resolvedPath, input, "VoiceConnectorId", () => input.VoiceConnectorId, "{VoiceConnectorId}", false);
    let body;
    body = JSON.stringify({
        ...(input.Capabilities != null && {
            Capabilities: serializeAws_restJson1CapabilityList(input.Capabilities, context),
        }),
        ...(input.ExpiryMinutes != null && { ExpiryMinutes: input.ExpiryMinutes }),
        ...(input.GeoMatchLevel != null && { GeoMatchLevel: input.GeoMatchLevel }),
        ...(input.GeoMatchParams != null && {
            GeoMatchParams: serializeAws_restJson1GeoMatchParams(input.GeoMatchParams, context),
        }),
        ...(input.Name != null && { Name: input.Name }),
        ...(input.NumberSelectionBehavior != null && { NumberSelectionBehavior: input.NumberSelectionBehavior }),
        ...(input.ParticipantPhoneNumbers != null && {
            ParticipantPhoneNumbers: serializeAws_restJson1ParticipantPhoneNumberList(input.ParticipantPhoneNumbers, context),
        }),
    });
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "POST",
        headers,
        path: resolvedPath,
        body,
    });
};
export const serializeAws_restJson1CreateRoomCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {
        "content-type": "application/json",
    };
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/accounts/{AccountId}/rooms";
    resolvedPath = __resolvedPath(resolvedPath, input, "AccountId", () => input.AccountId, "{AccountId}", false);
    let body;
    body = JSON.stringify({
        ClientRequestToken: input.ClientRequestToken ?? generateIdempotencyToken(),
        ...(input.Name != null && { Name: input.Name }),
    });
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "POST",
        headers,
        path: resolvedPath,
        body,
    });
};
export const serializeAws_restJson1CreateRoomMembershipCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {
        "content-type": "application/json",
    };
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` +
        "/accounts/{AccountId}/rooms/{RoomId}/memberships";
    resolvedPath = __resolvedPath(resolvedPath, input, "AccountId", () => input.AccountId, "{AccountId}", false);
    resolvedPath = __resolvedPath(resolvedPath, input, "RoomId", () => input.RoomId, "{RoomId}", false);
    let body;
    body = JSON.stringify({
        ...(input.MemberId != null && { MemberId: input.MemberId }),
        ...(input.Role != null && { Role: input.Role }),
    });
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "POST",
        headers,
        path: resolvedPath,
        body,
    });
};
export const serializeAws_restJson1CreateSipMediaApplicationCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {
        "content-type": "application/json",
    };
    const resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/sip-media-applications";
    let body;
    body = JSON.stringify({
        ...(input.AwsRegion != null && { AwsRegion: input.AwsRegion }),
        ...(input.Endpoints != null && {
            Endpoints: serializeAws_restJson1SipMediaApplicationEndpointList(input.Endpoints, context),
        }),
        ...(input.Name != null && { Name: input.Name }),
    });
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "POST",
        headers,
        path: resolvedPath,
        body,
    });
};
export const serializeAws_restJson1CreateSipMediaApplicationCallCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {
        "content-type": "application/json",
    };
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` +
        "/sip-media-applications/{SipMediaApplicationId}/calls";
    resolvedPath = __resolvedPath(resolvedPath, input, "SipMediaApplicationId", () => input.SipMediaApplicationId, "{SipMediaApplicationId}", false);
    let body;
    body = JSON.stringify({
        ...(input.FromPhoneNumber != null && { FromPhoneNumber: input.FromPhoneNumber }),
        ...(input.SipHeaders != null && { SipHeaders: serializeAws_restJson1SipHeadersMap(input.SipHeaders, context) }),
        ...(input.ToPhoneNumber != null && { ToPhoneNumber: input.ToPhoneNumber }),
    });
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "POST",
        headers,
        path: resolvedPath,
        body,
    });
};
export const serializeAws_restJson1CreateSipRuleCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {
        "content-type": "application/json",
    };
    const resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/sip-rules";
    let body;
    body = JSON.stringify({
        ...(input.Disabled != null && { Disabled: input.Disabled }),
        ...(input.Name != null && { Name: input.Name }),
        ...(input.TargetApplications != null && {
            TargetApplications: serializeAws_restJson1SipRuleTargetApplicationList(input.TargetApplications, context),
        }),
        ...(input.TriggerType != null && { TriggerType: input.TriggerType }),
        ...(input.TriggerValue != null && { TriggerValue: input.TriggerValue }),
    });
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "POST",
        headers,
        path: resolvedPath,
        body,
    });
};
export const serializeAws_restJson1CreateUserCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {
        "content-type": "application/json",
    };
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/accounts/{AccountId}/users";
    resolvedPath = __resolvedPath(resolvedPath, input, "AccountId", () => input.AccountId, "{AccountId}", false);
    const query = map({
        operation: [, "create"],
    });
    let body;
    body = JSON.stringify({
        ...(input.Email != null && { Email: input.Email }),
        ...(input.UserType != null && { UserType: input.UserType }),
        ...(input.Username != null && { Username: input.Username }),
    });
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "POST",
        headers,
        path: resolvedPath,
        query,
        body,
    });
};
export const serializeAws_restJson1CreateVoiceConnectorCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {
        "content-type": "application/json",
    };
    const resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/voice-connectors";
    let body;
    body = JSON.stringify({
        ...(input.AwsRegion != null && { AwsRegion: input.AwsRegion }),
        ...(input.Name != null && { Name: input.Name }),
        ...(input.RequireEncryption != null && { RequireEncryption: input.RequireEncryption }),
    });
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "POST",
        headers,
        path: resolvedPath,
        body,
    });
};
export const serializeAws_restJson1CreateVoiceConnectorGroupCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {
        "content-type": "application/json",
    };
    const resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/voice-connector-groups";
    let body;
    body = JSON.stringify({
        ...(input.Name != null && { Name: input.Name }),
        ...(input.VoiceConnectorItems != null && {
            VoiceConnectorItems: serializeAws_restJson1VoiceConnectorItemList(input.VoiceConnectorItems, context),
        }),
    });
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "POST",
        headers,
        path: resolvedPath,
        body,
    });
};
export const serializeAws_restJson1DeleteAccountCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {};
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/accounts/{AccountId}";
    resolvedPath = __resolvedPath(resolvedPath, input, "AccountId", () => input.AccountId, "{AccountId}", false);
    let body;
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "DELETE",
        headers,
        path: resolvedPath,
        body,
    });
};
export const serializeAws_restJson1DeleteAppInstanceCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {};
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/app-instances/{AppInstanceArn}";
    resolvedPath = __resolvedPath(resolvedPath, input, "AppInstanceArn", () => input.AppInstanceArn, "{AppInstanceArn}", false);
    let body;
    let { hostname: resolvedHostname } = await context.endpoint();
    if (context.disableHostPrefix !== true) {
        resolvedHostname = "identity-" + resolvedHostname;
        if (!__isValidHostname(resolvedHostname)) {
            throw new Error("ValidationError: prefixed hostname must be hostname compatible.");
        }
    }
    return new __HttpRequest({
        protocol,
        hostname: resolvedHostname,
        port,
        method: "DELETE",
        headers,
        path: resolvedPath,
        body,
    });
};
export const serializeAws_restJson1DeleteAppInstanceAdminCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {};
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` +
        "/app-instances/{AppInstanceArn}/admins/{AppInstanceAdminArn}";
    resolvedPath = __resolvedPath(resolvedPath, input, "AppInstanceAdminArn", () => input.AppInstanceAdminArn, "{AppInstanceAdminArn}", false);
    resolvedPath = __resolvedPath(resolvedPath, input, "AppInstanceArn", () => input.AppInstanceArn, "{AppInstanceArn}", false);
    let body;
    let { hostname: resolvedHostname } = await context.endpoint();
    if (context.disableHostPrefix !== true) {
        resolvedHostname = "identity-" + resolvedHostname;
        if (!__isValidHostname(resolvedHostname)) {
            throw new Error("ValidationError: prefixed hostname must be hostname compatible.");
        }
    }
    return new __HttpRequest({
        protocol,
        hostname: resolvedHostname,
        port,
        method: "DELETE",
        headers,
        path: resolvedPath,
        body,
    });
};
export const serializeAws_restJson1DeleteAppInstanceStreamingConfigurationsCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {};
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` +
        "/app-instances/{AppInstanceArn}/streaming-configurations";
    resolvedPath = __resolvedPath(resolvedPath, input, "AppInstanceArn", () => input.AppInstanceArn, "{AppInstanceArn}", false);
    let body;
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "DELETE",
        headers,
        path: resolvedPath,
        body,
    });
};
export const serializeAws_restJson1DeleteAppInstanceUserCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {};
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/app-instance-users/{AppInstanceUserArn}";
    resolvedPath = __resolvedPath(resolvedPath, input, "AppInstanceUserArn", () => input.AppInstanceUserArn, "{AppInstanceUserArn}", false);
    let body;
    let { hostname: resolvedHostname } = await context.endpoint();
    if (context.disableHostPrefix !== true) {
        resolvedHostname = "identity-" + resolvedHostname;
        if (!__isValidHostname(resolvedHostname)) {
            throw new Error("ValidationError: prefixed hostname must be hostname compatible.");
        }
    }
    return new __HttpRequest({
        protocol,
        hostname: resolvedHostname,
        port,
        method: "DELETE",
        headers,
        path: resolvedPath,
        body,
    });
};
export const serializeAws_restJson1DeleteAttendeeCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {};
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` +
        "/meetings/{MeetingId}/attendees/{AttendeeId}";
    resolvedPath = __resolvedPath(resolvedPath, input, "MeetingId", () => input.MeetingId, "{MeetingId}", false);
    resolvedPath = __resolvedPath(resolvedPath, input, "AttendeeId", () => input.AttendeeId, "{AttendeeId}", false);
    let body;
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "DELETE",
        headers,
        path: resolvedPath,
        body,
    });
};
export const serializeAws_restJson1DeleteChannelCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = map({}, isSerializableHeaderValue, {
        "x-amz-chime-bearer": input.ChimeBearer,
    });
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/channels/{ChannelArn}";
    resolvedPath = __resolvedPath(resolvedPath, input, "ChannelArn", () => input.ChannelArn, "{ChannelArn}", false);
    let body;
    let { hostname: resolvedHostname } = await context.endpoint();
    if (context.disableHostPrefix !== true) {
        resolvedHostname = "messaging-" + resolvedHostname;
        if (!__isValidHostname(resolvedHostname)) {
            throw new Error("ValidationError: prefixed hostname must be hostname compatible.");
        }
    }
    return new __HttpRequest({
        protocol,
        hostname: resolvedHostname,
        port,
        method: "DELETE",
        headers,
        path: resolvedPath,
        body,
    });
};
export const serializeAws_restJson1DeleteChannelBanCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = map({}, isSerializableHeaderValue, {
        "x-amz-chime-bearer": input.ChimeBearer,
    });
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/channels/{ChannelArn}/bans/{MemberArn}";
    resolvedPath = __resolvedPath(resolvedPath, input, "ChannelArn", () => input.ChannelArn, "{ChannelArn}", false);
    resolvedPath = __resolvedPath(resolvedPath, input, "MemberArn", () => input.MemberArn, "{MemberArn}", false);
    let body;
    let { hostname: resolvedHostname } = await context.endpoint();
    if (context.disableHostPrefix !== true) {
        resolvedHostname = "messaging-" + resolvedHostname;
        if (!__isValidHostname(resolvedHostname)) {
            throw new Error("ValidationError: prefixed hostname must be hostname compatible.");
        }
    }
    return new __HttpRequest({
        protocol,
        hostname: resolvedHostname,
        port,
        method: "DELETE",
        headers,
        path: resolvedPath,
        body,
    });
};
export const serializeAws_restJson1DeleteChannelMembershipCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = map({}, isSerializableHeaderValue, {
        "x-amz-chime-bearer": input.ChimeBearer,
    });
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` +
        "/channels/{ChannelArn}/memberships/{MemberArn}";
    resolvedPath = __resolvedPath(resolvedPath, input, "ChannelArn", () => input.ChannelArn, "{ChannelArn}", false);
    resolvedPath = __resolvedPath(resolvedPath, input, "MemberArn", () => input.MemberArn, "{MemberArn}", false);
    let body;
    let { hostname: resolvedHostname } = await context.endpoint();
    if (context.disableHostPrefix !== true) {
        resolvedHostname = "messaging-" + resolvedHostname;
        if (!__isValidHostname(resolvedHostname)) {
            throw new Error("ValidationError: prefixed hostname must be hostname compatible.");
        }
    }
    return new __HttpRequest({
        protocol,
        hostname: resolvedHostname,
        port,
        method: "DELETE",
        headers,
        path: resolvedPath,
        body,
    });
};
export const serializeAws_restJson1DeleteChannelMessageCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = map({}, isSerializableHeaderValue, {
        "x-amz-chime-bearer": input.ChimeBearer,
    });
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` +
        "/channels/{ChannelArn}/messages/{MessageId}";
    resolvedPath = __resolvedPath(resolvedPath, input, "ChannelArn", () => input.ChannelArn, "{ChannelArn}", false);
    resolvedPath = __resolvedPath(resolvedPath, input, "MessageId", () => input.MessageId, "{MessageId}", false);
    let body;
    let { hostname: resolvedHostname } = await context.endpoint();
    if (context.disableHostPrefix !== true) {
        resolvedHostname = "messaging-" + resolvedHostname;
        if (!__isValidHostname(resolvedHostname)) {
            throw new Error("ValidationError: prefixed hostname must be hostname compatible.");
        }
    }
    return new __HttpRequest({
        protocol,
        hostname: resolvedHostname,
        port,
        method: "DELETE",
        headers,
        path: resolvedPath,
        body,
    });
};
export const serializeAws_restJson1DeleteChannelModeratorCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = map({}, isSerializableHeaderValue, {
        "x-amz-chime-bearer": input.ChimeBearer,
    });
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` +
        "/channels/{ChannelArn}/moderators/{ChannelModeratorArn}";
    resolvedPath = __resolvedPath(resolvedPath, input, "ChannelArn", () => input.ChannelArn, "{ChannelArn}", false);
    resolvedPath = __resolvedPath(resolvedPath, input, "ChannelModeratorArn", () => input.ChannelModeratorArn, "{ChannelModeratorArn}", false);
    let body;
    let { hostname: resolvedHostname } = await context.endpoint();
    if (context.disableHostPrefix !== true) {
        resolvedHostname = "messaging-" + resolvedHostname;
        if (!__isValidHostname(resolvedHostname)) {
            throw new Error("ValidationError: prefixed hostname must be hostname compatible.");
        }
    }
    return new __HttpRequest({
        protocol,
        hostname: resolvedHostname,
        port,
        method: "DELETE",
        headers,
        path: resolvedPath,
        body,
    });
};
export const serializeAws_restJson1DeleteEventsConfigurationCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {};
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` +
        "/accounts/{AccountId}/bots/{BotId}/events-configuration";
    resolvedPath = __resolvedPath(resolvedPath, input, "AccountId", () => input.AccountId, "{AccountId}", false);
    resolvedPath = __resolvedPath(resolvedPath, input, "BotId", () => input.BotId, "{BotId}", false);
    let body;
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "DELETE",
        headers,
        path: resolvedPath,
        body,
    });
};
export const serializeAws_restJson1DeleteMediaCapturePipelineCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {};
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` +
        "/media-capture-pipelines/{MediaPipelineId}";
    resolvedPath = __resolvedPath(resolvedPath, input, "MediaPipelineId", () => input.MediaPipelineId, "{MediaPipelineId}", false);
    let body;
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "DELETE",
        headers,
        path: resolvedPath,
        body,
    });
};
export const serializeAws_restJson1DeleteMeetingCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {};
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/meetings/{MeetingId}";
    resolvedPath = __resolvedPath(resolvedPath, input, "MeetingId", () => input.MeetingId, "{MeetingId}", false);
    let body;
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "DELETE",
        headers,
        path: resolvedPath,
        body,
    });
};
export const serializeAws_restJson1DeletePhoneNumberCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {};
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/phone-numbers/{PhoneNumberId}";
    resolvedPath = __resolvedPath(resolvedPath, input, "PhoneNumberId", () => input.PhoneNumberId, "{PhoneNumberId}", false);
    let body;
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "DELETE",
        headers,
        path: resolvedPath,
        body,
    });
};
export const serializeAws_restJson1DeleteProxySessionCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {};
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` +
        "/voice-connectors/{VoiceConnectorId}/proxy-sessions/{ProxySessionId}";
    resolvedPath = __resolvedPath(resolvedPath, input, "VoiceConnectorId", () => input.VoiceConnectorId, "{VoiceConnectorId}", false);
    resolvedPath = __resolvedPath(resolvedPath, input, "ProxySessionId", () => input.ProxySessionId, "{ProxySessionId}", false);
    let body;
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "DELETE",
        headers,
        path: resolvedPath,
        body,
    });
};
export const serializeAws_restJson1DeleteRoomCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {};
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/accounts/{AccountId}/rooms/{RoomId}";
    resolvedPath = __resolvedPath(resolvedPath, input, "AccountId", () => input.AccountId, "{AccountId}", false);
    resolvedPath = __resolvedPath(resolvedPath, input, "RoomId", () => input.RoomId, "{RoomId}", false);
    let body;
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "DELETE",
        headers,
        path: resolvedPath,
        body,
    });
};
export const serializeAws_restJson1DeleteRoomMembershipCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {};
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` +
        "/accounts/{AccountId}/rooms/{RoomId}/memberships/{MemberId}";
    resolvedPath = __resolvedPath(resolvedPath, input, "AccountId", () => input.AccountId, "{AccountId}", false);
    resolvedPath = __resolvedPath(resolvedPath, input, "RoomId", () => input.RoomId, "{RoomId}", false);
    resolvedPath = __resolvedPath(resolvedPath, input, "MemberId", () => input.MemberId, "{MemberId}", false);
    let body;
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "DELETE",
        headers,
        path: resolvedPath,
        body,
    });
};
export const serializeAws_restJson1DeleteSipMediaApplicationCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {};
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` +
        "/sip-media-applications/{SipMediaApplicationId}";
    resolvedPath = __resolvedPath(resolvedPath, input, "SipMediaApplicationId", () => input.SipMediaApplicationId, "{SipMediaApplicationId}", false);
    let body;
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "DELETE",
        headers,
        path: resolvedPath,
        body,
    });
};
export const serializeAws_restJson1DeleteSipRuleCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {};
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/sip-rules/{SipRuleId}";
    resolvedPath = __resolvedPath(resolvedPath, input, "SipRuleId", () => input.SipRuleId, "{SipRuleId}", false);
    let body;
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "DELETE",
        headers,
        path: resolvedPath,
        body,
    });
};
export const serializeAws_restJson1DeleteVoiceConnectorCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {};
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/voice-connectors/{VoiceConnectorId}";
    resolvedPath = __resolvedPath(resolvedPath, input, "VoiceConnectorId", () => input.VoiceConnectorId, "{VoiceConnectorId}", false);
    let body;
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "DELETE",
        headers,
        path: resolvedPath,
        body,
    });
};
export const serializeAws_restJson1DeleteVoiceConnectorEmergencyCallingConfigurationCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {};
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` +
        "/voice-connectors/{VoiceConnectorId}/emergency-calling-configuration";
    resolvedPath = __resolvedPath(resolvedPath, input, "VoiceConnectorId", () => input.VoiceConnectorId, "{VoiceConnectorId}", false);
    let body;
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "DELETE",
        headers,
        path: resolvedPath,
        body,
    });
};
export const serializeAws_restJson1DeleteVoiceConnectorGroupCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {};
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` +
        "/voice-connector-groups/{VoiceConnectorGroupId}";
    resolvedPath = __resolvedPath(resolvedPath, input, "VoiceConnectorGroupId", () => input.VoiceConnectorGroupId, "{VoiceConnectorGroupId}", false);
    let body;
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "DELETE",
        headers,
        path: resolvedPath,
        body,
    });
};
export const serializeAws_restJson1DeleteVoiceConnectorOriginationCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {};
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` +
        "/voice-connectors/{VoiceConnectorId}/origination";
    resolvedPath = __resolvedPath(resolvedPath, input, "VoiceConnectorId", () => input.VoiceConnectorId, "{VoiceConnectorId}", false);
    let body;
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "DELETE",
        headers,
        path: resolvedPath,
        body,
    });
};
export const serializeAws_restJson1DeleteVoiceConnectorProxyCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {};
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` +
        "/voice-connectors/{VoiceConnectorId}/programmable-numbers/proxy";
    resolvedPath = __resolvedPath(resolvedPath, input, "VoiceConnectorId", () => input.VoiceConnectorId, "{VoiceConnectorId}", false);
    let body;
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "DELETE",
        headers,
        path: resolvedPath,
        body,
    });
};
export const serializeAws_restJson1DeleteVoiceConnectorStreamingConfigurationCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {};
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` +
        "/voice-connectors/{VoiceConnectorId}/streaming-configuration";
    resolvedPath = __resolvedPath(resolvedPath, input, "VoiceConnectorId", () => input.VoiceConnectorId, "{VoiceConnectorId}", false);
    let body;
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "DELETE",
        headers,
        path: resolvedPath,
        body,
    });
};
export const serializeAws_restJson1DeleteVoiceConnectorTerminationCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {};
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` +
        "/voice-connectors/{VoiceConnectorId}/termination";
    resolvedPath = __resolvedPath(resolvedPath, input, "VoiceConnectorId", () => input.VoiceConnectorId, "{VoiceConnectorId}", false);
    let body;
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "DELETE",
        headers,
        path: resolvedPath,
        body,
    });
};
export const serializeAws_restJson1DeleteVoiceConnectorTerminationCredentialsCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {
        "content-type": "application/json",
    };
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` +
        "/voice-connectors/{VoiceConnectorId}/termination/credentials";
    resolvedPath = __resolvedPath(resolvedPath, input, "VoiceConnectorId", () => input.VoiceConnectorId, "{VoiceConnectorId}", false);
    const query = map({
        operation: [, "delete"],
    });
    let body;
    body = JSON.stringify({
        ...(input.Usernames != null && { Usernames: serializeAws_restJson1SensitiveStringList(input.Usernames, context) }),
    });
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "POST",
        headers,
        path: resolvedPath,
        query,
        body,
    });
};
export const serializeAws_restJson1DescribeAppInstanceCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {};
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/app-instances/{AppInstanceArn}";
    resolvedPath = __resolvedPath(resolvedPath, input, "AppInstanceArn", () => input.AppInstanceArn, "{AppInstanceArn}", false);
    let body;
    let { hostname: resolvedHostname } = await context.endpoint();
    if (context.disableHostPrefix !== true) {
        resolvedHostname = "identity-" + resolvedHostname;
        if (!__isValidHostname(resolvedHostname)) {
            throw new Error("ValidationError: prefixed hostname must be hostname compatible.");
        }
    }
    return new __HttpRequest({
        protocol,
        hostname: resolvedHostname,
        port,
        method: "GET",
        headers,
        path: resolvedPath,
        body,
    });
};
export const serializeAws_restJson1DescribeAppInstanceAdminCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {};
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` +
        "/app-instances/{AppInstanceArn}/admins/{AppInstanceAdminArn}";
    resolvedPath = __resolvedPath(resolvedPath, input, "AppInstanceAdminArn", () => input.AppInstanceAdminArn, "{AppInstanceAdminArn}", false);
    resolvedPath = __resolvedPath(resolvedPath, input, "AppInstanceArn", () => input.AppInstanceArn, "{AppInstanceArn}", false);
    let body;
    let { hostname: resolvedHostname } = await context.endpoint();
    if (context.disableHostPrefix !== true) {
        resolvedHostname = "identity-" + resolvedHostname;
        if (!__isValidHostname(resolvedHostname)) {
            throw new Error("ValidationError: prefixed hostname must be hostname compatible.");
        }
    }
    return new __HttpRequest({
        protocol,
        hostname: resolvedHostname,
        port,
        method: "GET",
        headers,
        path: resolvedPath,
        body,
    });
};
export const serializeAws_restJson1DescribeAppInstanceUserCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {};
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/app-instance-users/{AppInstanceUserArn}";
    resolvedPath = __resolvedPath(resolvedPath, input, "AppInstanceUserArn", () => input.AppInstanceUserArn, "{AppInstanceUserArn}", false);
    let body;
    let { hostname: resolvedHostname } = await context.endpoint();
    if (context.disableHostPrefix !== true) {
        resolvedHostname = "identity-" + resolvedHostname;
        if (!__isValidHostname(resolvedHostname)) {
            throw new Error("ValidationError: prefixed hostname must be hostname compatible.");
        }
    }
    return new __HttpRequest({
        protocol,
        hostname: resolvedHostname,
        port,
        method: "GET",
        headers,
        path: resolvedPath,
        body,
    });
};
export const serializeAws_restJson1DescribeChannelCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = map({}, isSerializableHeaderValue, {
        "x-amz-chime-bearer": input.ChimeBearer,
    });
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/channels/{ChannelArn}";
    resolvedPath = __resolvedPath(resolvedPath, input, "ChannelArn", () => input.ChannelArn, "{ChannelArn}", false);
    let body;
    let { hostname: resolvedHostname } = await context.endpoint();
    if (context.disableHostPrefix !== true) {
        resolvedHostname = "messaging-" + resolvedHostname;
        if (!__isValidHostname(resolvedHostname)) {
            throw new Error("ValidationError: prefixed hostname must be hostname compatible.");
        }
    }
    return new __HttpRequest({
        protocol,
        hostname: resolvedHostname,
        port,
        method: "GET",
        headers,
        path: resolvedPath,
        body,
    });
};
export const serializeAws_restJson1DescribeChannelBanCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = map({}, isSerializableHeaderValue, {
        "x-amz-chime-bearer": input.ChimeBearer,
    });
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/channels/{ChannelArn}/bans/{MemberArn}";
    resolvedPath = __resolvedPath(resolvedPath, input, "ChannelArn", () => input.ChannelArn, "{ChannelArn}", false);
    resolvedPath = __resolvedPath(resolvedPath, input, "MemberArn", () => input.MemberArn, "{MemberArn}", false);
    let body;
    let { hostname: resolvedHostname } = await context.endpoint();
    if (context.disableHostPrefix !== true) {
        resolvedHostname = "messaging-" + resolvedHostname;
        if (!__isValidHostname(resolvedHostname)) {
            throw new Error("ValidationError: prefixed hostname must be hostname compatible.");
        }
    }
    return new __HttpRequest({
        protocol,
        hostname: resolvedHostname,
        port,
        method: "GET",
        headers,
        path: resolvedPath,
        body,
    });
};
export const serializeAws_restJson1DescribeChannelMembershipCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = map({}, isSerializableHeaderValue, {
        "x-amz-chime-bearer": input.ChimeBearer,
    });
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` +
        "/channels/{ChannelArn}/memberships/{MemberArn}";
    resolvedPath = __resolvedPath(resolvedPath, input, "ChannelArn", () => input.ChannelArn, "{ChannelArn}", false);
    resolvedPath = __resolvedPath(resolvedPath, input, "MemberArn", () => input.MemberArn, "{MemberArn}", false);
    let body;
    let { hostname: resolvedHostname } = await context.endpoint();
    if (context.disableHostPrefix !== true) {
        resolvedHostname = "messaging-" + resolvedHostname;
        if (!__isValidHostname(resolvedHostname)) {
            throw new Error("ValidationError: prefixed hostname must be hostname compatible.");
        }
    }
    return new __HttpRequest({
        protocol,
        hostname: resolvedHostname,
        port,
        method: "GET",
        headers,
        path: resolvedPath,
        body,
    });
};
export const serializeAws_restJson1DescribeChannelMembershipForAppInstanceUserCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = map({}, isSerializableHeaderValue, {
        "x-amz-chime-bearer": input.ChimeBearer,
    });
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/channels/{ChannelArn}";
    resolvedPath = __resolvedPath(resolvedPath, input, "ChannelArn", () => input.ChannelArn, "{ChannelArn}", false);
    const query = map({
        scope: [, "app-instance-user-membership"],
        "app-instance-user-arn": [, __expectNonNull(input.AppInstanceUserArn, `AppInstanceUserArn`)],
    });
    let body;
    let { hostname: resolvedHostname } = await context.endpoint();
    if (context.disableHostPrefix !== true) {
        resolvedHostname = "messaging-" + resolvedHostname;
        if (!__isValidHostname(resolvedHostname)) {
            throw new Error("ValidationError: prefixed hostname must be hostname compatible.");
        }
    }
    return new __HttpRequest({
        protocol,
        hostname: resolvedHostname,
        port,
        method: "GET",
        headers,
        path: resolvedPath,
        query,
        body,
    });
};
export const serializeAws_restJson1DescribeChannelModeratedByAppInstanceUserCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = map({}, isSerializableHeaderValue, {
        "x-amz-chime-bearer": input.ChimeBearer,
    });
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/channels/{ChannelArn}";
    resolvedPath = __resolvedPath(resolvedPath, input, "ChannelArn", () => input.ChannelArn, "{ChannelArn}", false);
    const query = map({
        scope: [, "app-instance-user-moderated-channel"],
        "app-instance-user-arn": [, __expectNonNull(input.AppInstanceUserArn, `AppInstanceUserArn`)],
    });
    let body;
    let { hostname: resolvedHostname } = await context.endpoint();
    if (context.disableHostPrefix !== true) {
        resolvedHostname = "messaging-" + resolvedHostname;
        if (!__isValidHostname(resolvedHostname)) {
            throw new Error("ValidationError: prefixed hostname must be hostname compatible.");
        }
    }
    return new __HttpRequest({
        protocol,
        hostname: resolvedHostname,
        port,
        method: "GET",
        headers,
        path: resolvedPath,
        query,
        body,
    });
};
export const serializeAws_restJson1DescribeChannelModeratorCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = map({}, isSerializableHeaderValue, {
        "x-amz-chime-bearer": input.ChimeBearer,
    });
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` +
        "/channels/{ChannelArn}/moderators/{ChannelModeratorArn}";
    resolvedPath = __resolvedPath(resolvedPath, input, "ChannelArn", () => input.ChannelArn, "{ChannelArn}", false);
    resolvedPath = __resolvedPath(resolvedPath, input, "ChannelModeratorArn", () => input.ChannelModeratorArn, "{ChannelModeratorArn}", false);
    let body;
    let { hostname: resolvedHostname } = await context.endpoint();
    if (context.disableHostPrefix !== true) {
        resolvedHostname = "messaging-" + resolvedHostname;
        if (!__isValidHostname(resolvedHostname)) {
            throw new Error("ValidationError: prefixed hostname must be hostname compatible.");
        }
    }
    return new __HttpRequest({
        protocol,
        hostname: resolvedHostname,
        port,
        method: "GET",
        headers,
        path: resolvedPath,
        body,
    });
};
export const serializeAws_restJson1DisassociatePhoneNumberFromUserCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {};
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/accounts/{AccountId}/users/{UserId}";
    resolvedPath = __resolvedPath(resolvedPath, input, "AccountId", () => input.AccountId, "{AccountId}", false);
    resolvedPath = __resolvedPath(resolvedPath, input, "UserId", () => input.UserId, "{UserId}", false);
    const query = map({
        operation: [, "disassociate-phone-number"],
    });
    let body;
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "POST",
        headers,
        path: resolvedPath,
        query,
        body,
    });
};
export const serializeAws_restJson1DisassociatePhoneNumbersFromVoiceConnectorCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {
        "content-type": "application/json",
    };
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/voice-connectors/{VoiceConnectorId}";
    resolvedPath = __resolvedPath(resolvedPath, input, "VoiceConnectorId", () => input.VoiceConnectorId, "{VoiceConnectorId}", false);
    const query = map({
        operation: [, "disassociate-phone-numbers"],
    });
    let body;
    body = JSON.stringify({
        ...(input.E164PhoneNumbers != null && {
            E164PhoneNumbers: serializeAws_restJson1E164PhoneNumberList(input.E164PhoneNumbers, context),
        }),
    });
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "POST",
        headers,
        path: resolvedPath,
        query,
        body,
    });
};
export const serializeAws_restJson1DisassociatePhoneNumbersFromVoiceConnectorGroupCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {
        "content-type": "application/json",
    };
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` +
        "/voice-connector-groups/{VoiceConnectorGroupId}";
    resolvedPath = __resolvedPath(resolvedPath, input, "VoiceConnectorGroupId", () => input.VoiceConnectorGroupId, "{VoiceConnectorGroupId}", false);
    const query = map({
        operation: [, "disassociate-phone-numbers"],
    });
    let body;
    body = JSON.stringify({
        ...(input.E164PhoneNumbers != null && {
            E164PhoneNumbers: serializeAws_restJson1E164PhoneNumberList(input.E164PhoneNumbers, context),
        }),
    });
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "POST",
        headers,
        path: resolvedPath,
        query,
        body,
    });
};
export const serializeAws_restJson1DisassociateSigninDelegateGroupsFromAccountCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {
        "content-type": "application/json",
    };
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/accounts/{AccountId}";
    resolvedPath = __resolvedPath(resolvedPath, input, "AccountId", () => input.AccountId, "{AccountId}", false);
    const query = map({
        operation: [, "disassociate-signin-delegate-groups"],
    });
    let body;
    body = JSON.stringify({
        ...(input.GroupNames != null && {
            GroupNames: serializeAws_restJson1NonEmptyStringList(input.GroupNames, context),
        }),
    });
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "POST",
        headers,
        path: resolvedPath,
        query,
        body,
    });
};
export const serializeAws_restJson1GetAccountCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {};
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/accounts/{AccountId}";
    resolvedPath = __resolvedPath(resolvedPath, input, "AccountId", () => input.AccountId, "{AccountId}", false);
    let body;
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "GET",
        headers,
        path: resolvedPath,
        body,
    });
};
export const serializeAws_restJson1GetAccountSettingsCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {};
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/accounts/{AccountId}/settings";
    resolvedPath = __resolvedPath(resolvedPath, input, "AccountId", () => input.AccountId, "{AccountId}", false);
    let body;
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "GET",
        headers,
        path: resolvedPath,
        body,
    });
};
export const serializeAws_restJson1GetAppInstanceRetentionSettingsCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {};
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` +
        "/app-instances/{AppInstanceArn}/retention-settings";
    resolvedPath = __resolvedPath(resolvedPath, input, "AppInstanceArn", () => input.AppInstanceArn, "{AppInstanceArn}", false);
    let body;
    let { hostname: resolvedHostname } = await context.endpoint();
    if (context.disableHostPrefix !== true) {
        resolvedHostname = "identity-" + resolvedHostname;
        if (!__isValidHostname(resolvedHostname)) {
            throw new Error("ValidationError: prefixed hostname must be hostname compatible.");
        }
    }
    return new __HttpRequest({
        protocol,
        hostname: resolvedHostname,
        port,
        method: "GET",
        headers,
        path: resolvedPath,
        body,
    });
};
export const serializeAws_restJson1GetAppInstanceStreamingConfigurationsCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {};
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` +
        "/app-instances/{AppInstanceArn}/streaming-configurations";
    resolvedPath = __resolvedPath(resolvedPath, input, "AppInstanceArn", () => input.AppInstanceArn, "{AppInstanceArn}", false);
    let body;
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "GET",
        headers,
        path: resolvedPath,
        body,
    });
};
export const serializeAws_restJson1GetAttendeeCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {};
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` +
        "/meetings/{MeetingId}/attendees/{AttendeeId}";
    resolvedPath = __resolvedPath(resolvedPath, input, "MeetingId", () => input.MeetingId, "{MeetingId}", false);
    resolvedPath = __resolvedPath(resolvedPath, input, "AttendeeId", () => input.AttendeeId, "{AttendeeId}", false);
    let body;
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "GET",
        headers,
        path: resolvedPath,
        body,
    });
};
export const serializeAws_restJson1GetBotCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {};
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/accounts/{AccountId}/bots/{BotId}";
    resolvedPath = __resolvedPath(resolvedPath, input, "AccountId", () => input.AccountId, "{AccountId}", false);
    resolvedPath = __resolvedPath(resolvedPath, input, "BotId", () => input.BotId, "{BotId}", false);
    let body;
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "GET",
        headers,
        path: resolvedPath,
        body,
    });
};
export const serializeAws_restJson1GetChannelMessageCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = map({}, isSerializableHeaderValue, {
        "x-amz-chime-bearer": input.ChimeBearer,
    });
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` +
        "/channels/{ChannelArn}/messages/{MessageId}";
    resolvedPath = __resolvedPath(resolvedPath, input, "ChannelArn", () => input.ChannelArn, "{ChannelArn}", false);
    resolvedPath = __resolvedPath(resolvedPath, input, "MessageId", () => input.MessageId, "{MessageId}", false);
    let body;
    let { hostname: resolvedHostname } = await context.endpoint();
    if (context.disableHostPrefix !== true) {
        resolvedHostname = "messaging-" + resolvedHostname;
        if (!__isValidHostname(resolvedHostname)) {
            throw new Error("ValidationError: prefixed hostname must be hostname compatible.");
        }
    }
    return new __HttpRequest({
        protocol,
        hostname: resolvedHostname,
        port,
        method: "GET",
        headers,
        path: resolvedPath,
        body,
    });
};
export const serializeAws_restJson1GetEventsConfigurationCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {};
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` +
        "/accounts/{AccountId}/bots/{BotId}/events-configuration";
    resolvedPath = __resolvedPath(resolvedPath, input, "AccountId", () => input.AccountId, "{AccountId}", false);
    resolvedPath = __resolvedPath(resolvedPath, input, "BotId", () => input.BotId, "{BotId}", false);
    let body;
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "GET",
        headers,
        path: resolvedPath,
        body,
    });
};
export const serializeAws_restJson1GetGlobalSettingsCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {
        "content-type": "application/json",
    };
    const resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/settings";
    let body;
    body = "";
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "GET",
        headers,
        path: resolvedPath,
        body,
    });
};
export const serializeAws_restJson1GetMediaCapturePipelineCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {};
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` +
        "/media-capture-pipelines/{MediaPipelineId}";
    resolvedPath = __resolvedPath(resolvedPath, input, "MediaPipelineId", () => input.MediaPipelineId, "{MediaPipelineId}", false);
    let body;
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "GET",
        headers,
        path: resolvedPath,
        body,
    });
};
export const serializeAws_restJson1GetMeetingCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {};
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/meetings/{MeetingId}";
    resolvedPath = __resolvedPath(resolvedPath, input, "MeetingId", () => input.MeetingId, "{MeetingId}", false);
    let body;
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "GET",
        headers,
        path: resolvedPath,
        body,
    });
};
export const serializeAws_restJson1GetMessagingSessionEndpointCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {
        "content-type": "application/json",
    };
    const resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/endpoints/messaging-session";
    let body;
    body = "";
    let { hostname: resolvedHostname } = await context.endpoint();
    if (context.disableHostPrefix !== true) {
        resolvedHostname = "messaging-" + resolvedHostname;
        if (!__isValidHostname(resolvedHostname)) {
            throw new Error("ValidationError: prefixed hostname must be hostname compatible.");
        }
    }
    return new __HttpRequest({
        protocol,
        hostname: resolvedHostname,
        port,
        method: "GET",
        headers,
        path: resolvedPath,
        body,
    });
};
export const serializeAws_restJson1GetPhoneNumberCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {};
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/phone-numbers/{PhoneNumberId}";
    resolvedPath = __resolvedPath(resolvedPath, input, "PhoneNumberId", () => input.PhoneNumberId, "{PhoneNumberId}", false);
    let body;
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "GET",
        headers,
        path: resolvedPath,
        body,
    });
};
export const serializeAws_restJson1GetPhoneNumberOrderCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {};
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/phone-number-orders/{PhoneNumberOrderId}";
    resolvedPath = __resolvedPath(resolvedPath, input, "PhoneNumberOrderId", () => input.PhoneNumberOrderId, "{PhoneNumberOrderId}", false);
    let body;
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "GET",
        headers,
        path: resolvedPath,
        body,
    });
};
export const serializeAws_restJson1GetPhoneNumberSettingsCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {
        "content-type": "application/json",
    };
    const resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/settings/phone-number";
    let body;
    body = "";
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "GET",
        headers,
        path: resolvedPath,
        body,
    });
};
export const serializeAws_restJson1GetProxySessionCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {};
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` +
        "/voice-connectors/{VoiceConnectorId}/proxy-sessions/{ProxySessionId}";
    resolvedPath = __resolvedPath(resolvedPath, input, "VoiceConnectorId", () => input.VoiceConnectorId, "{VoiceConnectorId}", false);
    resolvedPath = __resolvedPath(resolvedPath, input, "ProxySessionId", () => input.ProxySessionId, "{ProxySessionId}", false);
    let body;
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "GET",
        headers,
        path: resolvedPath,
        body,
    });
};
export const serializeAws_restJson1GetRetentionSettingsCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {};
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/accounts/{AccountId}/retention-settings";
    resolvedPath = __resolvedPath(resolvedPath, input, "AccountId", () => input.AccountId, "{AccountId}", false);
    let body;
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "GET",
        headers,
        path: resolvedPath,
        body,
    });
};
export const serializeAws_restJson1GetRoomCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {};
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/accounts/{AccountId}/rooms/{RoomId}";
    resolvedPath = __resolvedPath(resolvedPath, input, "AccountId", () => input.AccountId, "{AccountId}", false);
    resolvedPath = __resolvedPath(resolvedPath, input, "RoomId", () => input.RoomId, "{RoomId}", false);
    let body;
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "GET",
        headers,
        path: resolvedPath,
        body,
    });
};
export const serializeAws_restJson1GetSipMediaApplicationCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {};
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` +
        "/sip-media-applications/{SipMediaApplicationId}";
    resolvedPath = __resolvedPath(resolvedPath, input, "SipMediaApplicationId", () => input.SipMediaApplicationId, "{SipMediaApplicationId}", false);
    let body;
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "GET",
        headers,
        path: resolvedPath,
        body,
    });
};
export const serializeAws_restJson1GetSipMediaApplicationLoggingConfigurationCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {};
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` +
        "/sip-media-applications/{SipMediaApplicationId}/logging-configuration";
    resolvedPath = __resolvedPath(resolvedPath, input, "SipMediaApplicationId", () => input.SipMediaApplicationId, "{SipMediaApplicationId}", false);
    let body;
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "GET",
        headers,
        path: resolvedPath,
        body,
    });
};
export const serializeAws_restJson1GetSipRuleCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {};
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/sip-rules/{SipRuleId}";
    resolvedPath = __resolvedPath(resolvedPath, input, "SipRuleId", () => input.SipRuleId, "{SipRuleId}", false);
    let body;
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "GET",
        headers,
        path: resolvedPath,
        body,
    });
};
export const serializeAws_restJson1GetUserCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {};
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/accounts/{AccountId}/users/{UserId}";
    resolvedPath = __resolvedPath(resolvedPath, input, "AccountId", () => input.AccountId, "{AccountId}", false);
    resolvedPath = __resolvedPath(resolvedPath, input, "UserId", () => input.UserId, "{UserId}", false);
    let body;
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "GET",
        headers,
        path: resolvedPath,
        body,
    });
};
export const serializeAws_restJson1GetUserSettingsCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {};
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` +
        "/accounts/{AccountId}/users/{UserId}/settings";
    resolvedPath = __resolvedPath(resolvedPath, input, "AccountId", () => input.AccountId, "{AccountId}", false);
    resolvedPath = __resolvedPath(resolvedPath, input, "UserId", () => input.UserId, "{UserId}", false);
    let body;
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "GET",
        headers,
        path: resolvedPath,
        body,
    });
};
export const serializeAws_restJson1GetVoiceConnectorCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {};
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/voice-connectors/{VoiceConnectorId}";
    resolvedPath = __resolvedPath(resolvedPath, input, "VoiceConnectorId", () => input.VoiceConnectorId, "{VoiceConnectorId}", false);
    let body;
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "GET",
        headers,
        path: resolvedPath,
        body,
    });
};
export const serializeAws_restJson1GetVoiceConnectorEmergencyCallingConfigurationCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {};
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` +
        "/voice-connectors/{VoiceConnectorId}/emergency-calling-configuration";
    resolvedPath = __resolvedPath(resolvedPath, input, "VoiceConnectorId", () => input.VoiceConnectorId, "{VoiceConnectorId}", false);
    let body;
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "GET",
        headers,
        path: resolvedPath,
        body,
    });
};
export const serializeAws_restJson1GetVoiceConnectorGroupCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {};
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` +
        "/voice-connector-groups/{VoiceConnectorGroupId}";
    resolvedPath = __resolvedPath(resolvedPath, input, "VoiceConnectorGroupId", () => input.VoiceConnectorGroupId, "{VoiceConnectorGroupId}", false);
    let body;
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "GET",
        headers,
        path: resolvedPath,
        body,
    });
};
export const serializeAws_restJson1GetVoiceConnectorLoggingConfigurationCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {};
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` +
        "/voice-connectors/{VoiceConnectorId}/logging-configuration";
    resolvedPath = __resolvedPath(resolvedPath, input, "VoiceConnectorId", () => input.VoiceConnectorId, "{VoiceConnectorId}", false);
    let body;
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "GET",
        headers,
        path: resolvedPath,
        body,
    });
};
export const serializeAws_restJson1GetVoiceConnectorOriginationCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {};
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` +
        "/voice-connectors/{VoiceConnectorId}/origination";
    resolvedPath = __resolvedPath(resolvedPath, input, "VoiceConnectorId", () => input.VoiceConnectorId, "{VoiceConnectorId}", false);
    let body;
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "GET",
        headers,
        path: resolvedPath,
        body,
    });
};
export const serializeAws_restJson1GetVoiceConnectorProxyCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {};
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` +
        "/voice-connectors/{VoiceConnectorId}/programmable-numbers/proxy";
    resolvedPath = __resolvedPath(resolvedPath, input, "VoiceConnectorId", () => input.VoiceConnectorId, "{VoiceConnectorId}", false);
    let body;
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "GET",
        headers,
        path: resolvedPath,
        body,
    });
};
export const serializeAws_restJson1GetVoiceConnectorStreamingConfigurationCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {};
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` +
        "/voice-connectors/{VoiceConnectorId}/streaming-configuration";
    resolvedPath = __resolvedPath(resolvedPath, input, "VoiceConnectorId", () => input.VoiceConnectorId, "{VoiceConnectorId}", false);
    let body;
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "GET",
        headers,
        path: resolvedPath,
        body,
    });
};
export const serializeAws_restJson1GetVoiceConnectorTerminationCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {};
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` +
        "/voice-connectors/{VoiceConnectorId}/termination";
    resolvedPath = __resolvedPath(resolvedPath, input, "VoiceConnectorId", () => input.VoiceConnectorId, "{VoiceConnectorId}", false);
    let body;
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "GET",
        headers,
        path: resolvedPath,
        body,
    });
};
export const serializeAws_restJson1GetVoiceConnectorTerminationHealthCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {};
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` +
        "/voice-connectors/{VoiceConnectorId}/termination/health";
    resolvedPath = __resolvedPath(resolvedPath, input, "VoiceConnectorId", () => input.VoiceConnectorId, "{VoiceConnectorId}", false);
    let body;
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "GET",
        headers,
        path: resolvedPath,
        body,
    });
};
export const serializeAws_restJson1InviteUsersCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {
        "content-type": "application/json",
    };
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/accounts/{AccountId}/users";
    resolvedPath = __resolvedPath(resolvedPath, input, "AccountId", () => input.AccountId, "{AccountId}", false);
    const query = map({
        operation: [, "add"],
    });
    let body;
    body = JSON.stringify({
        ...(input.UserEmailList != null && {
            UserEmailList: serializeAws_restJson1UserEmailList(input.UserEmailList, context),
        }),
        ...(input.UserType != null && { UserType: input.UserType }),
    });
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "POST",
        headers,
        path: resolvedPath,
        query,
        body,
    });
};
export const serializeAws_restJson1ListAccountsCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {};
    const resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/accounts";
    const query = map({
        name: [, input.Name],
        "user-email": [, input.UserEmail],
        "next-token": [, input.NextToken],
        "max-results": [() => input.MaxResults !== void 0, () => input.MaxResults.toString()],
    });
    let body;
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "GET",
        headers,
        path: resolvedPath,
        query,
        body,
    });
};
export const serializeAws_restJson1ListAppInstanceAdminsCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {};
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/app-instances/{AppInstanceArn}/admins";
    resolvedPath = __resolvedPath(resolvedPath, input, "AppInstanceArn", () => input.AppInstanceArn, "{AppInstanceArn}", false);
    const query = map({
        "max-results": [() => input.MaxResults !== void 0, () => input.MaxResults.toString()],
        "next-token": [, input.NextToken],
    });
    let body;
    let { hostname: resolvedHostname } = await context.endpoint();
    if (context.disableHostPrefix !== true) {
        resolvedHostname = "identity-" + resolvedHostname;
        if (!__isValidHostname(resolvedHostname)) {
            throw new Error("ValidationError: prefixed hostname must be hostname compatible.");
        }
    }
    return new __HttpRequest({
        protocol,
        hostname: resolvedHostname,
        port,
        method: "GET",
        headers,
        path: resolvedPath,
        query,
        body,
    });
};
export const serializeAws_restJson1ListAppInstancesCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {};
    const resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/app-instances";
    const query = map({
        "max-results": [() => input.MaxResults !== void 0, () => input.MaxResults.toString()],
        "next-token": [, input.NextToken],
    });
    let body;
    let { hostname: resolvedHostname } = await context.endpoint();
    if (context.disableHostPrefix !== true) {
        resolvedHostname = "identity-" + resolvedHostname;
        if (!__isValidHostname(resolvedHostname)) {
            throw new Error("ValidationError: prefixed hostname must be hostname compatible.");
        }
    }
    return new __HttpRequest({
        protocol,
        hostname: resolvedHostname,
        port,
        method: "GET",
        headers,
        path: resolvedPath,
        query,
        body,
    });
};
export const serializeAws_restJson1ListAppInstanceUsersCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {};
    const resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/app-instance-users";
    const query = map({
        "app-instance-arn": [, __expectNonNull(input.AppInstanceArn, `AppInstanceArn`)],
        "max-results": [() => input.MaxResults !== void 0, () => input.MaxResults.toString()],
        "next-token": [, input.NextToken],
    });
    let body;
    let { hostname: resolvedHostname } = await context.endpoint();
    if (context.disableHostPrefix !== true) {
        resolvedHostname = "identity-" + resolvedHostname;
        if (!__isValidHostname(resolvedHostname)) {
            throw new Error("ValidationError: prefixed hostname must be hostname compatible.");
        }
    }
    return new __HttpRequest({
        protocol,
        hostname: resolvedHostname,
        port,
        method: "GET",
        headers,
        path: resolvedPath,
        query,
        body,
    });
};
export const serializeAws_restJson1ListAttendeesCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {};
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/meetings/{MeetingId}/attendees";
    resolvedPath = __resolvedPath(resolvedPath, input, "MeetingId", () => input.MeetingId, "{MeetingId}", false);
    const query = map({
        "next-token": [, input.NextToken],
        "max-results": [() => input.MaxResults !== void 0, () => input.MaxResults.toString()],
    });
    let body;
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "GET",
        headers,
        path: resolvedPath,
        query,
        body,
    });
};
export const serializeAws_restJson1ListAttendeeTagsCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {};
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` +
        "/meetings/{MeetingId}/attendees/{AttendeeId}/tags";
    resolvedPath = __resolvedPath(resolvedPath, input, "MeetingId", () => input.MeetingId, "{MeetingId}", false);
    resolvedPath = __resolvedPath(resolvedPath, input, "AttendeeId", () => input.AttendeeId, "{AttendeeId}", false);
    let body;
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "GET",
        headers,
        path: resolvedPath,
        body,
    });
};
export const serializeAws_restJson1ListBotsCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {};
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/accounts/{AccountId}/bots";
    resolvedPath = __resolvedPath(resolvedPath, input, "AccountId", () => input.AccountId, "{AccountId}", false);
    const query = map({
        "max-results": [() => input.MaxResults !== void 0, () => input.MaxResults.toString()],
        "next-token": [, input.NextToken],
    });
    let body;
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "GET",
        headers,
        path: resolvedPath,
        query,
        body,
    });
};
export const serializeAws_restJson1ListChannelBansCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = map({}, isSerializableHeaderValue, {
        "x-amz-chime-bearer": input.ChimeBearer,
    });
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/channels/{ChannelArn}/bans";
    resolvedPath = __resolvedPath(resolvedPath, input, "ChannelArn", () => input.ChannelArn, "{ChannelArn}", false);
    const query = map({
        "max-results": [() => input.MaxResults !== void 0, () => input.MaxResults.toString()],
        "next-token": [, input.NextToken],
    });
    let body;
    let { hostname: resolvedHostname } = await context.endpoint();
    if (context.disableHostPrefix !== true) {
        resolvedHostname = "messaging-" + resolvedHostname;
        if (!__isValidHostname(resolvedHostname)) {
            throw new Error("ValidationError: prefixed hostname must be hostname compatible.");
        }
    }
    return new __HttpRequest({
        protocol,
        hostname: resolvedHostname,
        port,
        method: "GET",
        headers,
        path: resolvedPath,
        query,
        body,
    });
};
export const serializeAws_restJson1ListChannelMembershipsCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = map({}, isSerializableHeaderValue, {
        "x-amz-chime-bearer": input.ChimeBearer,
    });
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/channels/{ChannelArn}/memberships";
    resolvedPath = __resolvedPath(resolvedPath, input, "ChannelArn", () => input.ChannelArn, "{ChannelArn}", false);
    const query = map({
        type: [, input.Type],
        "max-results": [() => input.MaxResults !== void 0, () => input.MaxResults.toString()],
        "next-token": [, input.NextToken],
    });
    let body;
    let { hostname: resolvedHostname } = await context.endpoint();
    if (context.disableHostPrefix !== true) {
        resolvedHostname = "messaging-" + resolvedHostname;
        if (!__isValidHostname(resolvedHostname)) {
            throw new Error("ValidationError: prefixed hostname must be hostname compatible.");
        }
    }
    return new __HttpRequest({
        protocol,
        hostname: resolvedHostname,
        port,
        method: "GET",
        headers,
        path: resolvedPath,
        query,
        body,
    });
};
export const serializeAws_restJson1ListChannelMembershipsForAppInstanceUserCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = map({}, isSerializableHeaderValue, {
        "x-amz-chime-bearer": input.ChimeBearer,
    });
    const resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/channels";
    const query = map({
        scope: [, "app-instance-user-memberships"],
        "app-instance-user-arn": [, input.AppInstanceUserArn],
        "max-results": [() => input.MaxResults !== void 0, () => input.MaxResults.toString()],
        "next-token": [, input.NextToken],
    });
    let body;
    let { hostname: resolvedHostname } = await context.endpoint();
    if (context.disableHostPrefix !== true) {
        resolvedHostname = "messaging-" + resolvedHostname;
        if (!__isValidHostname(resolvedHostname)) {
            throw new Error("ValidationError: prefixed hostname must be hostname compatible.");
        }
    }
    return new __HttpRequest({
        protocol,
        hostname: resolvedHostname,
        port,
        method: "GET",
        headers,
        path: resolvedPath,
        query,
        body,
    });
};
export const serializeAws_restJson1ListChannelMessagesCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = map({}, isSerializableHeaderValue, {
        "x-amz-chime-bearer": input.ChimeBearer,
    });
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/channels/{ChannelArn}/messages";
    resolvedPath = __resolvedPath(resolvedPath, input, "ChannelArn", () => input.ChannelArn, "{ChannelArn}", false);
    const query = map({
        "sort-order": [, input.SortOrder],
        "not-before": [
            () => input.NotBefore !== void 0,
            () => (input.NotBefore.toISOString().split(".")[0] + "Z").toString(),
        ],
        "not-after": [
            () => input.NotAfter !== void 0,
            () => (input.NotAfter.toISOString().split(".")[0] + "Z").toString(),
        ],
        "max-results": [() => input.MaxResults !== void 0, () => input.MaxResults.toString()],
        "next-token": [, input.NextToken],
    });
    let body;
    let { hostname: resolvedHostname } = await context.endpoint();
    if (context.disableHostPrefix !== true) {
        resolvedHostname = "messaging-" + resolvedHostname;
        if (!__isValidHostname(resolvedHostname)) {
            throw new Error("ValidationError: prefixed hostname must be hostname compatible.");
        }
    }
    return new __HttpRequest({
        protocol,
        hostname: resolvedHostname,
        port,
        method: "GET",
        headers,
        path: resolvedPath,
        query,
        body,
    });
};
export const serializeAws_restJson1ListChannelModeratorsCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = map({}, isSerializableHeaderValue, {
        "x-amz-chime-bearer": input.ChimeBearer,
    });
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/channels/{ChannelArn}/moderators";
    resolvedPath = __resolvedPath(resolvedPath, input, "ChannelArn", () => input.ChannelArn, "{ChannelArn}", false);
    const query = map({
        "max-results": [() => input.MaxResults !== void 0, () => input.MaxResults.toString()],
        "next-token": [, input.NextToken],
    });
    let body;
    let { hostname: resolvedHostname } = await context.endpoint();
    if (context.disableHostPrefix !== true) {
        resolvedHostname = "messaging-" + resolvedHostname;
        if (!__isValidHostname(resolvedHostname)) {
            throw new Error("ValidationError: prefixed hostname must be hostname compatible.");
        }
    }
    return new __HttpRequest({
        protocol,
        hostname: resolvedHostname,
        port,
        method: "GET",
        headers,
        path: resolvedPath,
        query,
        body,
    });
};
export const serializeAws_restJson1ListChannelsCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = map({}, isSerializableHeaderValue, {
        "x-amz-chime-bearer": input.ChimeBearer,
    });
    const resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/channels";
    const query = map({
        "app-instance-arn": [, __expectNonNull(input.AppInstanceArn, `AppInstanceArn`)],
        privacy: [, input.Privacy],
        "max-results": [() => input.MaxResults !== void 0, () => input.MaxResults.toString()],
        "next-token": [, input.NextToken],
    });
    let body;
    let { hostname: resolvedHostname } = await context.endpoint();
    if (context.disableHostPrefix !== true) {
        resolvedHostname = "messaging-" + resolvedHostname;
        if (!__isValidHostname(resolvedHostname)) {
            throw new Error("ValidationError: prefixed hostname must be hostname compatible.");
        }
    }
    return new __HttpRequest({
        protocol,
        hostname: resolvedHostname,
        port,
        method: "GET",
        headers,
        path: resolvedPath,
        query,
        body,
    });
};
export const serializeAws_restJson1ListChannelsModeratedByAppInstanceUserCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = map({}, isSerializableHeaderValue, {
        "x-amz-chime-bearer": input.ChimeBearer,
    });
    const resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/channels";
    const query = map({
        scope: [, "app-instance-user-moderated-channels"],
        "app-instance-user-arn": [, input.AppInstanceUserArn],
        "max-results": [() => input.MaxResults !== void 0, () => input.MaxResults.toString()],
        "next-token": [, input.NextToken],
    });
    let body;
    let { hostname: resolvedHostname } = await context.endpoint();
    if (context.disableHostPrefix !== true) {
        resolvedHostname = "messaging-" + resolvedHostname;
        if (!__isValidHostname(resolvedHostname)) {
            throw new Error("ValidationError: prefixed hostname must be hostname compatible.");
        }
    }
    return new __HttpRequest({
        protocol,
        hostname: resolvedHostname,
        port,
        method: "GET",
        headers,
        path: resolvedPath,
        query,
        body,
    });
};
export const serializeAws_restJson1ListMediaCapturePipelinesCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {};
    const resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/media-capture-pipelines";
    const query = map({
        "next-token": [, input.NextToken],
        "max-results": [() => input.MaxResults !== void 0, () => input.MaxResults.toString()],
    });
    let body;
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "GET",
        headers,
        path: resolvedPath,
        query,
        body,
    });
};
export const serializeAws_restJson1ListMeetingsCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {};
    const resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/meetings";
    const query = map({
        "next-token": [, input.NextToken],
        "max-results": [() => input.MaxResults !== void 0, () => input.MaxResults.toString()],
    });
    let body;
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "GET",
        headers,
        path: resolvedPath,
        query,
        body,
    });
};
export const serializeAws_restJson1ListMeetingTagsCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {};
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/meetings/{MeetingId}/tags";
    resolvedPath = __resolvedPath(resolvedPath, input, "MeetingId", () => input.MeetingId, "{MeetingId}", false);
    let body;
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "GET",
        headers,
        path: resolvedPath,
        body,
    });
};
export const serializeAws_restJson1ListPhoneNumberOrdersCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {};
    const resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/phone-number-orders";
    const query = map({
        "next-token": [, input.NextToken],
        "max-results": [() => input.MaxResults !== void 0, () => input.MaxResults.toString()],
    });
    let body;
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "GET",
        headers,
        path: resolvedPath,
        query,
        body,
    });
};
export const serializeAws_restJson1ListPhoneNumbersCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {};
    const resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/phone-numbers";
    const query = map({
        status: [, input.Status],
        "product-type": [, input.ProductType],
        "filter-name": [, input.FilterName],
        "filter-value": [, input.FilterValue],
        "max-results": [() => input.MaxResults !== void 0, () => input.MaxResults.toString()],
        "next-token": [, input.NextToken],
    });
    let body;
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "GET",
        headers,
        path: resolvedPath,
        query,
        body,
    });
};
export const serializeAws_restJson1ListProxySessionsCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {};
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` +
        "/voice-connectors/{VoiceConnectorId}/proxy-sessions";
    resolvedPath = __resolvedPath(resolvedPath, input, "VoiceConnectorId", () => input.VoiceConnectorId, "{VoiceConnectorId}", false);
    const query = map({
        status: [, input.Status],
        "next-token": [, input.NextToken],
        "max-results": [() => input.MaxResults !== void 0, () => input.MaxResults.toString()],
    });
    let body;
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "GET",
        headers,
        path: resolvedPath,
        query,
        body,
    });
};
export const serializeAws_restJson1ListRoomMembershipsCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {};
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` +
        "/accounts/{AccountId}/rooms/{RoomId}/memberships";
    resolvedPath = __resolvedPath(resolvedPath, input, "AccountId", () => input.AccountId, "{AccountId}", false);
    resolvedPath = __resolvedPath(resolvedPath, input, "RoomId", () => input.RoomId, "{RoomId}", false);
    const query = map({
        "max-results": [() => input.MaxResults !== void 0, () => input.MaxResults.toString()],
        "next-token": [, input.NextToken],
    });
    let body;
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "GET",
        headers,
        path: resolvedPath,
        query,
        body,
    });
};
export const serializeAws_restJson1ListRoomsCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {};
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/accounts/{AccountId}/rooms";
    resolvedPath = __resolvedPath(resolvedPath, input, "AccountId", () => input.AccountId, "{AccountId}", false);
    const query = map({
        "member-id": [, input.MemberId],
        "max-results": [() => input.MaxResults !== void 0, () => input.MaxResults.toString()],
        "next-token": [, input.NextToken],
    });
    let body;
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "GET",
        headers,
        path: resolvedPath,
        query,
        body,
    });
};
export const serializeAws_restJson1ListSipMediaApplicationsCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {};
    const resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/sip-media-applications";
    const query = map({
        "max-results": [() => input.MaxResults !== void 0, () => input.MaxResults.toString()],
        "next-token": [, input.NextToken],
    });
    let body;
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "GET",
        headers,
        path: resolvedPath,
        query,
        body,
    });
};
export const serializeAws_restJson1ListSipRulesCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {};
    const resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/sip-rules";
    const query = map({
        "sip-media-application": [, input.SipMediaApplicationId],
        "max-results": [() => input.MaxResults !== void 0, () => input.MaxResults.toString()],
        "next-token": [, input.NextToken],
    });
    let body;
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "GET",
        headers,
        path: resolvedPath,
        query,
        body,
    });
};
export const serializeAws_restJson1ListSupportedPhoneNumberCountriesCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {};
    const resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/phone-number-countries";
    const query = map({
        "product-type": [, __expectNonNull(input.ProductType, `ProductType`)],
    });
    let body;
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "GET",
        headers,
        path: resolvedPath,
        query,
        body,
    });
};
export const serializeAws_restJson1ListTagsForResourceCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {};
    const resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/tags";
    const query = map({
        arn: [, __expectNonNull(input.ResourceARN, `ResourceARN`)],
    });
    let body;
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "GET",
        headers,
        path: resolvedPath,
        query,
        body,
    });
};
export const serializeAws_restJson1ListUsersCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {};
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/accounts/{AccountId}/users";
    resolvedPath = __resolvedPath(resolvedPath, input, "AccountId", () => input.AccountId, "{AccountId}", false);
    const query = map({
        "user-email": [, input.UserEmail],
        "user-type": [, input.UserType],
        "max-results": [() => input.MaxResults !== void 0, () => input.MaxResults.toString()],
        "next-token": [, input.NextToken],
    });
    let body;
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "GET",
        headers,
        path: resolvedPath,
        query,
        body,
    });
};
export const serializeAws_restJson1ListVoiceConnectorGroupsCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {};
    const resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/voice-connector-groups";
    const query = map({
        "next-token": [, input.NextToken],
        "max-results": [() => input.MaxResults !== void 0, () => input.MaxResults.toString()],
    });
    let body;
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "GET",
        headers,
        path: resolvedPath,
        query,
        body,
    });
};
export const serializeAws_restJson1ListVoiceConnectorsCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {};
    const resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/voice-connectors";
    const query = map({
        "next-token": [, input.NextToken],
        "max-results": [() => input.MaxResults !== void 0, () => input.MaxResults.toString()],
    });
    let body;
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "GET",
        headers,
        path: resolvedPath,
        query,
        body,
    });
};
export const serializeAws_restJson1ListVoiceConnectorTerminationCredentialsCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {};
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` +
        "/voice-connectors/{VoiceConnectorId}/termination/credentials";
    resolvedPath = __resolvedPath(resolvedPath, input, "VoiceConnectorId", () => input.VoiceConnectorId, "{VoiceConnectorId}", false);
    let body;
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "GET",
        headers,
        path: resolvedPath,
        body,
    });
};
export const serializeAws_restJson1LogoutUserCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {};
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/accounts/{AccountId}/users/{UserId}";
    resolvedPath = __resolvedPath(resolvedPath, input, "AccountId", () => input.AccountId, "{AccountId}", false);
    resolvedPath = __resolvedPath(resolvedPath, input, "UserId", () => input.UserId, "{UserId}", false);
    const query = map({
        operation: [, "logout"],
    });
    let body;
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "POST",
        headers,
        path: resolvedPath,
        query,
        body,
    });
};
export const serializeAws_restJson1PutAppInstanceRetentionSettingsCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {
        "content-type": "application/json",
    };
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` +
        "/app-instances/{AppInstanceArn}/retention-settings";
    resolvedPath = __resolvedPath(resolvedPath, input, "AppInstanceArn", () => input.AppInstanceArn, "{AppInstanceArn}", false);
    let body;
    body = JSON.stringify({
        ...(input.AppInstanceRetentionSettings != null && {
            AppInstanceRetentionSettings: serializeAws_restJson1AppInstanceRetentionSettings(input.AppInstanceRetentionSettings, context),
        }),
    });
    let { hostname: resolvedHostname } = await context.endpoint();
    if (context.disableHostPrefix !== true) {
        resolvedHostname = "identity-" + resolvedHostname;
        if (!__isValidHostname(resolvedHostname)) {
            throw new Error("ValidationError: prefixed hostname must be hostname compatible.");
        }
    }
    return new __HttpRequest({
        protocol,
        hostname: resolvedHostname,
        port,
        method: "PUT",
        headers,
        path: resolvedPath,
        body,
    });
};
export const serializeAws_restJson1PutAppInstanceStreamingConfigurationsCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {
        "content-type": "application/json",
    };
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` +
        "/app-instances/{AppInstanceArn}/streaming-configurations";
    resolvedPath = __resolvedPath(resolvedPath, input, "AppInstanceArn", () => input.AppInstanceArn, "{AppInstanceArn}", false);
    let body;
    body = JSON.stringify({
        ...(input.AppInstanceStreamingConfigurations != null && {
            AppInstanceStreamingConfigurations: serializeAws_restJson1AppInstanceStreamingConfigurationList(input.AppInstanceStreamingConfigurations, context),
        }),
    });
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "PUT",
        headers,
        path: resolvedPath,
        body,
    });
};
export const serializeAws_restJson1PutEventsConfigurationCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {
        "content-type": "application/json",
    };
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` +
        "/accounts/{AccountId}/bots/{BotId}/events-configuration";
    resolvedPath = __resolvedPath(resolvedPath, input, "AccountId", () => input.AccountId, "{AccountId}", false);
    resolvedPath = __resolvedPath(resolvedPath, input, "BotId", () => input.BotId, "{BotId}", false);
    let body;
    body = JSON.stringify({
        ...(input.LambdaFunctionArn != null && { LambdaFunctionArn: input.LambdaFunctionArn }),
        ...(input.OutboundEventsHTTPSEndpoint != null && {
            OutboundEventsHTTPSEndpoint: input.OutboundEventsHTTPSEndpoint,
        }),
    });
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "PUT",
        headers,
        path: resolvedPath,
        body,
    });
};
export const serializeAws_restJson1PutRetentionSettingsCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {
        "content-type": "application/json",
    };
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/accounts/{AccountId}/retention-settings";
    resolvedPath = __resolvedPath(resolvedPath, input, "AccountId", () => input.AccountId, "{AccountId}", false);
    let body;
    body = JSON.stringify({
        ...(input.RetentionSettings != null && {
            RetentionSettings: serializeAws_restJson1RetentionSettings(input.RetentionSettings, context),
        }),
    });
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "PUT",
        headers,
        path: resolvedPath,
        body,
    });
};
export const serializeAws_restJson1PutSipMediaApplicationLoggingConfigurationCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {
        "content-type": "application/json",
    };
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` +
        "/sip-media-applications/{SipMediaApplicationId}/logging-configuration";
    resolvedPath = __resolvedPath(resolvedPath, input, "SipMediaApplicationId", () => input.SipMediaApplicationId, "{SipMediaApplicationId}", false);
    let body;
    body = JSON.stringify({
        ...(input.SipMediaApplicationLoggingConfiguration != null && {
            SipMediaApplicationLoggingConfiguration: serializeAws_restJson1SipMediaApplicationLoggingConfiguration(input.SipMediaApplicationLoggingConfiguration, context),
        }),
    });
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "PUT",
        headers,
        path: resolvedPath,
        body,
    });
};
export const serializeAws_restJson1PutVoiceConnectorEmergencyCallingConfigurationCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {
        "content-type": "application/json",
    };
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` +
        "/voice-connectors/{VoiceConnectorId}/emergency-calling-configuration";
    resolvedPath = __resolvedPath(resolvedPath, input, "VoiceConnectorId", () => input.VoiceConnectorId, "{VoiceConnectorId}", false);
    let body;
    body = JSON.stringify({
        ...(input.EmergencyCallingConfiguration != null && {
            EmergencyCallingConfiguration: serializeAws_restJson1EmergencyCallingConfiguration(input.EmergencyCallingConfiguration, context),
        }),
    });
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "PUT",
        headers,
        path: resolvedPath,
        body,
    });
};
export const serializeAws_restJson1PutVoiceConnectorLoggingConfigurationCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {
        "content-type": "application/json",
    };
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` +
        "/voice-connectors/{VoiceConnectorId}/logging-configuration";
    resolvedPath = __resolvedPath(resolvedPath, input, "VoiceConnectorId", () => input.VoiceConnectorId, "{VoiceConnectorId}", false);
    let body;
    body = JSON.stringify({
        ...(input.LoggingConfiguration != null && {
            LoggingConfiguration: serializeAws_restJson1LoggingConfiguration(input.LoggingConfiguration, context),
        }),
    });
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "PUT",
        headers,
        path: resolvedPath,
        body,
    });
};
export const serializeAws_restJson1PutVoiceConnectorOriginationCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {
        "content-type": "application/json",
    };
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` +
        "/voice-connectors/{VoiceConnectorId}/origination";
    resolvedPath = __resolvedPath(resolvedPath, input, "VoiceConnectorId", () => input.VoiceConnectorId, "{VoiceConnectorId}", false);
    let body;
    body = JSON.stringify({
        ...(input.Origination != null && { Origination: serializeAws_restJson1Origination(input.Origination, context) }),
    });
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "PUT",
        headers,
        path: resolvedPath,
        body,
    });
};
export const serializeAws_restJson1PutVoiceConnectorProxyCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {
        "content-type": "application/json",
    };
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` +
        "/voice-connectors/{VoiceConnectorId}/programmable-numbers/proxy";
    resolvedPath = __resolvedPath(resolvedPath, input, "VoiceConnectorId", () => input.VoiceConnectorId, "{VoiceConnectorId}", false);
    let body;
    body = JSON.stringify({
        ...(input.DefaultSessionExpiryMinutes != null && {
            DefaultSessionExpiryMinutes: input.DefaultSessionExpiryMinutes,
        }),
        ...(input.Disabled != null && { Disabled: input.Disabled }),
        ...(input.FallBackPhoneNumber != null && { FallBackPhoneNumber: input.FallBackPhoneNumber }),
        ...(input.PhoneNumberPoolCountries != null && {
            PhoneNumberPoolCountries: serializeAws_restJson1CountryList(input.PhoneNumberPoolCountries, context),
        }),
    });
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "PUT",
        headers,
        path: resolvedPath,
        body,
    });
};
export const serializeAws_restJson1PutVoiceConnectorStreamingConfigurationCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {
        "content-type": "application/json",
    };
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` +
        "/voice-connectors/{VoiceConnectorId}/streaming-configuration";
    resolvedPath = __resolvedPath(resolvedPath, input, "VoiceConnectorId", () => input.VoiceConnectorId, "{VoiceConnectorId}", false);
    let body;
    body = JSON.stringify({
        ...(input.StreamingConfiguration != null && {
            StreamingConfiguration: serializeAws_restJson1StreamingConfiguration(input.StreamingConfiguration, context),
        }),
    });
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "PUT",
        headers,
        path: resolvedPath,
        body,
    });
};
export const serializeAws_restJson1PutVoiceConnectorTerminationCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {
        "content-type": "application/json",
    };
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` +
        "/voice-connectors/{VoiceConnectorId}/termination";
    resolvedPath = __resolvedPath(resolvedPath, input, "VoiceConnectorId", () => input.VoiceConnectorId, "{VoiceConnectorId}", false);
    let body;
    body = JSON.stringify({
        ...(input.Termination != null && { Termination: serializeAws_restJson1Termination(input.Termination, context) }),
    });
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "PUT",
        headers,
        path: resolvedPath,
        body,
    });
};
export const serializeAws_restJson1PutVoiceConnectorTerminationCredentialsCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {
        "content-type": "application/json",
    };
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` +
        "/voice-connectors/{VoiceConnectorId}/termination/credentials";
    resolvedPath = __resolvedPath(resolvedPath, input, "VoiceConnectorId", () => input.VoiceConnectorId, "{VoiceConnectorId}", false);
    const query = map({
        operation: [, "put"],
    });
    let body;
    body = JSON.stringify({
        ...(input.Credentials != null && { Credentials: serializeAws_restJson1CredentialList(input.Credentials, context) }),
    });
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "POST",
        headers,
        path: resolvedPath,
        query,
        body,
    });
};
export const serializeAws_restJson1RedactChannelMessageCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = map({}, isSerializableHeaderValue, {
        "x-amz-chime-bearer": input.ChimeBearer,
    });
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` +
        "/channels/{ChannelArn}/messages/{MessageId}";
    resolvedPath = __resolvedPath(resolvedPath, input, "ChannelArn", () => input.ChannelArn, "{ChannelArn}", false);
    resolvedPath = __resolvedPath(resolvedPath, input, "MessageId", () => input.MessageId, "{MessageId}", false);
    const query = map({
        operation: [, "redact"],
    });
    let body;
    let { hostname: resolvedHostname } = await context.endpoint();
    if (context.disableHostPrefix !== true) {
        resolvedHostname = "messaging-" + resolvedHostname;
        if (!__isValidHostname(resolvedHostname)) {
            throw new Error("ValidationError: prefixed hostname must be hostname compatible.");
        }
    }
    return new __HttpRequest({
        protocol,
        hostname: resolvedHostname,
        port,
        method: "POST",
        headers,
        path: resolvedPath,
        query,
        body,
    });
};
export const serializeAws_restJson1RedactConversationMessageCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {};
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` +
        "/accounts/{AccountId}/conversations/{ConversationId}/messages/{MessageId}";
    resolvedPath = __resolvedPath(resolvedPath, input, "AccountId", () => input.AccountId, "{AccountId}", false);
    resolvedPath = __resolvedPath(resolvedPath, input, "ConversationId", () => input.ConversationId, "{ConversationId}", false);
    resolvedPath = __resolvedPath(resolvedPath, input, "MessageId", () => input.MessageId, "{MessageId}", false);
    const query = map({
        operation: [, "redact"],
    });
    let body;
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "POST",
        headers,
        path: resolvedPath,
        query,
        body,
    });
};
export const serializeAws_restJson1RedactRoomMessageCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {};
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` +
        "/accounts/{AccountId}/rooms/{RoomId}/messages/{MessageId}";
    resolvedPath = __resolvedPath(resolvedPath, input, "AccountId", () => input.AccountId, "{AccountId}", false);
    resolvedPath = __resolvedPath(resolvedPath, input, "RoomId", () => input.RoomId, "{RoomId}", false);
    resolvedPath = __resolvedPath(resolvedPath, input, "MessageId", () => input.MessageId, "{MessageId}", false);
    const query = map({
        operation: [, "redact"],
    });
    let body;
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "POST",
        headers,
        path: resolvedPath,
        query,
        body,
    });
};
export const serializeAws_restJson1RegenerateSecurityTokenCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {};
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/accounts/{AccountId}/bots/{BotId}";
    resolvedPath = __resolvedPath(resolvedPath, input, "AccountId", () => input.AccountId, "{AccountId}", false);
    resolvedPath = __resolvedPath(resolvedPath, input, "BotId", () => input.BotId, "{BotId}", false);
    const query = map({
        operation: [, "regenerate-security-token"],
    });
    let body;
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "POST",
        headers,
        path: resolvedPath,
        query,
        body,
    });
};
export const serializeAws_restJson1ResetPersonalPINCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {};
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/accounts/{AccountId}/users/{UserId}";
    resolvedPath = __resolvedPath(resolvedPath, input, "AccountId", () => input.AccountId, "{AccountId}", false);
    resolvedPath = __resolvedPath(resolvedPath, input, "UserId", () => input.UserId, "{UserId}", false);
    const query = map({
        operation: [, "reset-personal-pin"],
    });
    let body;
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "POST",
        headers,
        path: resolvedPath,
        query,
        body,
    });
};
export const serializeAws_restJson1RestorePhoneNumberCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {};
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/phone-numbers/{PhoneNumberId}";
    resolvedPath = __resolvedPath(resolvedPath, input, "PhoneNumberId", () => input.PhoneNumberId, "{PhoneNumberId}", false);
    const query = map({
        operation: [, "restore"],
    });
    let body;
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "POST",
        headers,
        path: resolvedPath,
        query,
        body,
    });
};
export const serializeAws_restJson1SearchAvailablePhoneNumbersCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {};
    const resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/search";
    const query = map({
        type: [, "phone-numbers"],
        "area-code": [, input.AreaCode],
        city: [, input.City],
        country: [, input.Country],
        state: [, input.State],
        "toll-free-prefix": [, input.TollFreePrefix],
        "phone-number-type": [, input.PhoneNumberType],
        "max-results": [() => input.MaxResults !== void 0, () => input.MaxResults.toString()],
        "next-token": [, input.NextToken],
    });
    let body;
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "GET",
        headers,
        path: resolvedPath,
        query,
        body,
    });
};
export const serializeAws_restJson1SendChannelMessageCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = map({}, isSerializableHeaderValue, {
        "content-type": "application/json",
        "x-amz-chime-bearer": input.ChimeBearer,
    });
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/channels/{ChannelArn}/messages";
    resolvedPath = __resolvedPath(resolvedPath, input, "ChannelArn", () => input.ChannelArn, "{ChannelArn}", false);
    let body;
    body = JSON.stringify({
        ClientRequestToken: input.ClientRequestToken ?? generateIdempotencyToken(),
        ...(input.Content != null && { Content: input.Content }),
        ...(input.Metadata != null && { Metadata: input.Metadata }),
        ...(input.Persistence != null && { Persistence: input.Persistence }),
        ...(input.Type != null && { Type: input.Type }),
    });
    let { hostname: resolvedHostname } = await context.endpoint();
    if (context.disableHostPrefix !== true) {
        resolvedHostname = "messaging-" + resolvedHostname;
        if (!__isValidHostname(resolvedHostname)) {
            throw new Error("ValidationError: prefixed hostname must be hostname compatible.");
        }
    }
    return new __HttpRequest({
        protocol,
        hostname: resolvedHostname,
        port,
        method: "POST",
        headers,
        path: resolvedPath,
        body,
    });
};
export const serializeAws_restJson1StartMeetingTranscriptionCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {
        "content-type": "application/json",
    };
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/meetings/{MeetingId}/transcription";
    resolvedPath = __resolvedPath(resolvedPath, input, "MeetingId", () => input.MeetingId, "{MeetingId}", false);
    const query = map({
        operation: [, "start"],
    });
    let body;
    body = JSON.stringify({
        ...(input.TranscriptionConfiguration != null && {
            TranscriptionConfiguration: serializeAws_restJson1TranscriptionConfiguration(input.TranscriptionConfiguration, context),
        }),
    });
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "POST",
        headers,
        path: resolvedPath,
        query,
        body,
    });
};
export const serializeAws_restJson1StopMeetingTranscriptionCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {};
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/meetings/{MeetingId}/transcription";
    resolvedPath = __resolvedPath(resolvedPath, input, "MeetingId", () => input.MeetingId, "{MeetingId}", false);
    const query = map({
        operation: [, "stop"],
    });
    let body;
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "POST",
        headers,
        path: resolvedPath,
        query,
        body,
    });
};
export const serializeAws_restJson1TagAttendeeCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {
        "content-type": "application/json",
    };
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` +
        "/meetings/{MeetingId}/attendees/{AttendeeId}/tags";
    resolvedPath = __resolvedPath(resolvedPath, input, "MeetingId", () => input.MeetingId, "{MeetingId}", false);
    resolvedPath = __resolvedPath(resolvedPath, input, "AttendeeId", () => input.AttendeeId, "{AttendeeId}", false);
    const query = map({
        operation: [, "add"],
    });
    let body;
    body = JSON.stringify({
        ...(input.Tags != null && { Tags: serializeAws_restJson1AttendeeTagList(input.Tags, context) }),
    });
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "POST",
        headers,
        path: resolvedPath,
        query,
        body,
    });
};
export const serializeAws_restJson1TagMeetingCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {
        "content-type": "application/json",
    };
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/meetings/{MeetingId}/tags";
    resolvedPath = __resolvedPath(resolvedPath, input, "MeetingId", () => input.MeetingId, "{MeetingId}", false);
    const query = map({
        operation: [, "add"],
    });
    let body;
    body = JSON.stringify({
        ...(input.Tags != null && { Tags: serializeAws_restJson1MeetingTagList(input.Tags, context) }),
    });
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "POST",
        headers,
        path: resolvedPath,
        query,
        body,
    });
};
export const serializeAws_restJson1TagResourceCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {
        "content-type": "application/json",
    };
    const resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/tags";
    const query = map({
        operation: [, "tag-resource"],
    });
    let body;
    body = JSON.stringify({
        ...(input.ResourceARN != null && { ResourceARN: input.ResourceARN }),
        ...(input.Tags != null && { Tags: serializeAws_restJson1TagList(input.Tags, context) }),
    });
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "POST",
        headers,
        path: resolvedPath,
        query,
        body,
    });
};
export const serializeAws_restJson1UntagAttendeeCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {
        "content-type": "application/json",
    };
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` +
        "/meetings/{MeetingId}/attendees/{AttendeeId}/tags";
    resolvedPath = __resolvedPath(resolvedPath, input, "MeetingId", () => input.MeetingId, "{MeetingId}", false);
    resolvedPath = __resolvedPath(resolvedPath, input, "AttendeeId", () => input.AttendeeId, "{AttendeeId}", false);
    const query = map({
        operation: [, "delete"],
    });
    let body;
    body = JSON.stringify({
        ...(input.TagKeys != null && { TagKeys: serializeAws_restJson1AttendeeTagKeyList(input.TagKeys, context) }),
    });
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "POST",
        headers,
        path: resolvedPath,
        query,
        body,
    });
};
export const serializeAws_restJson1UntagMeetingCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {
        "content-type": "application/json",
    };
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/meetings/{MeetingId}/tags";
    resolvedPath = __resolvedPath(resolvedPath, input, "MeetingId", () => input.MeetingId, "{MeetingId}", false);
    const query = map({
        operation: [, "delete"],
    });
    let body;
    body = JSON.stringify({
        ...(input.TagKeys != null && { TagKeys: serializeAws_restJson1MeetingTagKeyList(input.TagKeys, context) }),
    });
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "POST",
        headers,
        path: resolvedPath,
        query,
        body,
    });
};
export const serializeAws_restJson1UntagResourceCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {
        "content-type": "application/json",
    };
    const resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/tags";
    const query = map({
        operation: [, "untag-resource"],
    });
    let body;
    body = JSON.stringify({
        ...(input.ResourceARN != null && { ResourceARN: input.ResourceARN }),
        ...(input.TagKeys != null && { TagKeys: serializeAws_restJson1TagKeyList(input.TagKeys, context) }),
    });
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "POST",
        headers,
        path: resolvedPath,
        query,
        body,
    });
};
export const serializeAws_restJson1UpdateAccountCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {
        "content-type": "application/json",
    };
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/accounts/{AccountId}";
    resolvedPath = __resolvedPath(resolvedPath, input, "AccountId", () => input.AccountId, "{AccountId}", false);
    let body;
    body = JSON.stringify({
        ...(input.DefaultLicense != null && { DefaultLicense: input.DefaultLicense }),
        ...(input.Name != null && { Name: input.Name }),
    });
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "POST",
        headers,
        path: resolvedPath,
        body,
    });
};
export const serializeAws_restJson1UpdateAccountSettingsCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {
        "content-type": "application/json",
    };
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/accounts/{AccountId}/settings";
    resolvedPath = __resolvedPath(resolvedPath, input, "AccountId", () => input.AccountId, "{AccountId}", false);
    let body;
    body = JSON.stringify({
        ...(input.AccountSettings != null && {
            AccountSettings: serializeAws_restJson1AccountSettings(input.AccountSettings, context),
        }),
    });
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "PUT",
        headers,
        path: resolvedPath,
        body,
    });
};
export const serializeAws_restJson1UpdateAppInstanceCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {
        "content-type": "application/json",
    };
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/app-instances/{AppInstanceArn}";
    resolvedPath = __resolvedPath(resolvedPath, input, "AppInstanceArn", () => input.AppInstanceArn, "{AppInstanceArn}", false);
    let body;
    body = JSON.stringify({
        ...(input.Metadata != null && { Metadata: input.Metadata }),
        ...(input.Name != null && { Name: input.Name }),
    });
    let { hostname: resolvedHostname } = await context.endpoint();
    if (context.disableHostPrefix !== true) {
        resolvedHostname = "identity-" + resolvedHostname;
        if (!__isValidHostname(resolvedHostname)) {
            throw new Error("ValidationError: prefixed hostname must be hostname compatible.");
        }
    }
    return new __HttpRequest({
        protocol,
        hostname: resolvedHostname,
        port,
        method: "PUT",
        headers,
        path: resolvedPath,
        body,
    });
};
export const serializeAws_restJson1UpdateAppInstanceUserCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {
        "content-type": "application/json",
    };
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/app-instance-users/{AppInstanceUserArn}";
    resolvedPath = __resolvedPath(resolvedPath, input, "AppInstanceUserArn", () => input.AppInstanceUserArn, "{AppInstanceUserArn}", false);
    let body;
    body = JSON.stringify({
        ...(input.Metadata != null && { Metadata: input.Metadata }),
        ...(input.Name != null && { Name: input.Name }),
    });
    let { hostname: resolvedHostname } = await context.endpoint();
    if (context.disableHostPrefix !== true) {
        resolvedHostname = "identity-" + resolvedHostname;
        if (!__isValidHostname(resolvedHostname)) {
            throw new Error("ValidationError: prefixed hostname must be hostname compatible.");
        }
    }
    return new __HttpRequest({
        protocol,
        hostname: resolvedHostname,
        port,
        method: "PUT",
        headers,
        path: resolvedPath,
        body,
    });
};
export const serializeAws_restJson1UpdateBotCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {
        "content-type": "application/json",
    };
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/accounts/{AccountId}/bots/{BotId}";
    resolvedPath = __resolvedPath(resolvedPath, input, "AccountId", () => input.AccountId, "{AccountId}", false);
    resolvedPath = __resolvedPath(resolvedPath, input, "BotId", () => input.BotId, "{BotId}", false);
    let body;
    body = JSON.stringify({
        ...(input.Disabled != null && { Disabled: input.Disabled }),
    });
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "POST",
        headers,
        path: resolvedPath,
        body,
    });
};
export const serializeAws_restJson1UpdateChannelCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = map({}, isSerializableHeaderValue, {
        "content-type": "application/json",
        "x-amz-chime-bearer": input.ChimeBearer,
    });
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/channels/{ChannelArn}";
    resolvedPath = __resolvedPath(resolvedPath, input, "ChannelArn", () => input.ChannelArn, "{ChannelArn}", false);
    let body;
    body = JSON.stringify({
        ...(input.Metadata != null && { Metadata: input.Metadata }),
        ...(input.Mode != null && { Mode: input.Mode }),
        ...(input.Name != null && { Name: input.Name }),
    });
    let { hostname: resolvedHostname } = await context.endpoint();
    if (context.disableHostPrefix !== true) {
        resolvedHostname = "messaging-" + resolvedHostname;
        if (!__isValidHostname(resolvedHostname)) {
            throw new Error("ValidationError: prefixed hostname must be hostname compatible.");
        }
    }
    return new __HttpRequest({
        protocol,
        hostname: resolvedHostname,
        port,
        method: "PUT",
        headers,
        path: resolvedPath,
        body,
    });
};
export const serializeAws_restJson1UpdateChannelMessageCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = map({}, isSerializableHeaderValue, {
        "content-type": "application/json",
        "x-amz-chime-bearer": input.ChimeBearer,
    });
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` +
        "/channels/{ChannelArn}/messages/{MessageId}";
    resolvedPath = __resolvedPath(resolvedPath, input, "ChannelArn", () => input.ChannelArn, "{ChannelArn}", false);
    resolvedPath = __resolvedPath(resolvedPath, input, "MessageId", () => input.MessageId, "{MessageId}", false);
    let body;
    body = JSON.stringify({
        ...(input.Content != null && { Content: input.Content }),
        ...(input.Metadata != null && { Metadata: input.Metadata }),
    });
    let { hostname: resolvedHostname } = await context.endpoint();
    if (context.disableHostPrefix !== true) {
        resolvedHostname = "messaging-" + resolvedHostname;
        if (!__isValidHostname(resolvedHostname)) {
            throw new Error("ValidationError: prefixed hostname must be hostname compatible.");
        }
    }
    return new __HttpRequest({
        protocol,
        hostname: resolvedHostname,
        port,
        method: "PUT",
        headers,
        path: resolvedPath,
        body,
    });
};
export const serializeAws_restJson1UpdateChannelReadMarkerCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = map({}, isSerializableHeaderValue, {
        "x-amz-chime-bearer": input.ChimeBearer,
    });
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/channels/{ChannelArn}/readMarker";
    resolvedPath = __resolvedPath(resolvedPath, input, "ChannelArn", () => input.ChannelArn, "{ChannelArn}", false);
    let body;
    let { hostname: resolvedHostname } = await context.endpoint();
    if (context.disableHostPrefix !== true) {
        resolvedHostname = "messaging-" + resolvedHostname;
        if (!__isValidHostname(resolvedHostname)) {
            throw new Error("ValidationError: prefixed hostname must be hostname compatible.");
        }
    }
    return new __HttpRequest({
        protocol,
        hostname: resolvedHostname,
        port,
        method: "PUT",
        headers,
        path: resolvedPath,
        body,
    });
};
export const serializeAws_restJson1UpdateGlobalSettingsCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {
        "content-type": "application/json",
    };
    const resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/settings";
    let body;
    body = JSON.stringify({
        ...(input.BusinessCalling != null && {
            BusinessCalling: serializeAws_restJson1BusinessCallingSettings(input.BusinessCalling, context),
        }),
        ...(input.VoiceConnector != null && {
            VoiceConnector: serializeAws_restJson1VoiceConnectorSettings(input.VoiceConnector, context),
        }),
    });
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "PUT",
        headers,
        path: resolvedPath,
        body,
    });
};
export const serializeAws_restJson1UpdatePhoneNumberCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {
        "content-type": "application/json",
    };
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/phone-numbers/{PhoneNumberId}";
    resolvedPath = __resolvedPath(resolvedPath, input, "PhoneNumberId", () => input.PhoneNumberId, "{PhoneNumberId}", false);
    let body;
    body = JSON.stringify({
        ...(input.CallingName != null && { CallingName: input.CallingName }),
        ...(input.ProductType != null && { ProductType: input.ProductType }),
    });
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "POST",
        headers,
        path: resolvedPath,
        body,
    });
};
export const serializeAws_restJson1UpdatePhoneNumberSettingsCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {
        "content-type": "application/json",
    };
    const resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/settings/phone-number";
    let body;
    body = JSON.stringify({
        ...(input.CallingName != null && { CallingName: input.CallingName }),
    });
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "PUT",
        headers,
        path: resolvedPath,
        body,
    });
};
export const serializeAws_restJson1UpdateProxySessionCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {
        "content-type": "application/json",
    };
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` +
        "/voice-connectors/{VoiceConnectorId}/proxy-sessions/{ProxySessionId}";
    resolvedPath = __resolvedPath(resolvedPath, input, "VoiceConnectorId", () => input.VoiceConnectorId, "{VoiceConnectorId}", false);
    resolvedPath = __resolvedPath(resolvedPath, input, "ProxySessionId", () => input.ProxySessionId, "{ProxySessionId}", false);
    let body;
    body = JSON.stringify({
        ...(input.Capabilities != null && {
            Capabilities: serializeAws_restJson1CapabilityList(input.Capabilities, context),
        }),
        ...(input.ExpiryMinutes != null && { ExpiryMinutes: input.ExpiryMinutes }),
    });
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "POST",
        headers,
        path: resolvedPath,
        body,
    });
};
export const serializeAws_restJson1UpdateRoomCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {
        "content-type": "application/json",
    };
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/accounts/{AccountId}/rooms/{RoomId}";
    resolvedPath = __resolvedPath(resolvedPath, input, "AccountId", () => input.AccountId, "{AccountId}", false);
    resolvedPath = __resolvedPath(resolvedPath, input, "RoomId", () => input.RoomId, "{RoomId}", false);
    let body;
    body = JSON.stringify({
        ...(input.Name != null && { Name: input.Name }),
    });
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "POST",
        headers,
        path: resolvedPath,
        body,
    });
};
export const serializeAws_restJson1UpdateRoomMembershipCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {
        "content-type": "application/json",
    };
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` +
        "/accounts/{AccountId}/rooms/{RoomId}/memberships/{MemberId}";
    resolvedPath = __resolvedPath(resolvedPath, input, "AccountId", () => input.AccountId, "{AccountId}", false);
    resolvedPath = __resolvedPath(resolvedPath, input, "RoomId", () => input.RoomId, "{RoomId}", false);
    resolvedPath = __resolvedPath(resolvedPath, input, "MemberId", () => input.MemberId, "{MemberId}", false);
    let body;
    body = JSON.stringify({
        ...(input.Role != null && { Role: input.Role }),
    });
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "POST",
        headers,
        path: resolvedPath,
        body,
    });
};
export const serializeAws_restJson1UpdateSipMediaApplicationCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {
        "content-type": "application/json",
    };
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` +
        "/sip-media-applications/{SipMediaApplicationId}";
    resolvedPath = __resolvedPath(resolvedPath, input, "SipMediaApplicationId", () => input.SipMediaApplicationId, "{SipMediaApplicationId}", false);
    let body;
    body = JSON.stringify({
        ...(input.Endpoints != null && {
            Endpoints: serializeAws_restJson1SipMediaApplicationEndpointList(input.Endpoints, context),
        }),
        ...(input.Name != null && { Name: input.Name }),
    });
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "PUT",
        headers,
        path: resolvedPath,
        body,
    });
};
export const serializeAws_restJson1UpdateSipMediaApplicationCallCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {
        "content-type": "application/json",
    };
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` +
        "/sip-media-applications/{SipMediaApplicationId}/calls/{TransactionId}";
    resolvedPath = __resolvedPath(resolvedPath, input, "SipMediaApplicationId", () => input.SipMediaApplicationId, "{SipMediaApplicationId}", false);
    resolvedPath = __resolvedPath(resolvedPath, input, "TransactionId", () => input.TransactionId, "{TransactionId}", false);
    let body;
    body = JSON.stringify({
        ...(input.Arguments != null && {
            Arguments: serializeAws_restJson1SMAUpdateCallArgumentsMap(input.Arguments, context),
        }),
    });
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "POST",
        headers,
        path: resolvedPath,
        body,
    });
};
export const serializeAws_restJson1UpdateSipRuleCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {
        "content-type": "application/json",
    };
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/sip-rules/{SipRuleId}";
    resolvedPath = __resolvedPath(resolvedPath, input, "SipRuleId", () => input.SipRuleId, "{SipRuleId}", false);
    let body;
    body = JSON.stringify({
        ...(input.Disabled != null && { Disabled: input.Disabled }),
        ...(input.Name != null && { Name: input.Name }),
        ...(input.TargetApplications != null && {
            TargetApplications: serializeAws_restJson1SipRuleTargetApplicationList(input.TargetApplications, context),
        }),
    });
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "PUT",
        headers,
        path: resolvedPath,
        body,
    });
};
export const serializeAws_restJson1UpdateUserCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {
        "content-type": "application/json",
    };
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/accounts/{AccountId}/users/{UserId}";
    resolvedPath = __resolvedPath(resolvedPath, input, "AccountId", () => input.AccountId, "{AccountId}", false);
    resolvedPath = __resolvedPath(resolvedPath, input, "UserId", () => input.UserId, "{UserId}", false);
    let body;
    body = JSON.stringify({
        ...(input.AlexaForBusinessMetadata != null && {
            AlexaForBusinessMetadata: serializeAws_restJson1AlexaForBusinessMetadata(input.AlexaForBusinessMetadata, context),
        }),
        ...(input.LicenseType != null && { LicenseType: input.LicenseType }),
        ...(input.UserType != null && { UserType: input.UserType }),
    });
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "POST",
        headers,
        path: resolvedPath,
        body,
    });
};
export const serializeAws_restJson1UpdateUserSettingsCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {
        "content-type": "application/json",
    };
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` +
        "/accounts/{AccountId}/users/{UserId}/settings";
    resolvedPath = __resolvedPath(resolvedPath, input, "AccountId", () => input.AccountId, "{AccountId}", false);
    resolvedPath = __resolvedPath(resolvedPath, input, "UserId", () => input.UserId, "{UserId}", false);
    let body;
    body = JSON.stringify({
        ...(input.UserSettings != null && {
            UserSettings: serializeAws_restJson1UserSettings(input.UserSettings, context),
        }),
    });
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "PUT",
        headers,
        path: resolvedPath,
        body,
    });
};
export const serializeAws_restJson1UpdateVoiceConnectorCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {
        "content-type": "application/json",
    };
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/voice-connectors/{VoiceConnectorId}";
    resolvedPath = __resolvedPath(resolvedPath, input, "VoiceConnectorId", () => input.VoiceConnectorId, "{VoiceConnectorId}", false);
    let body;
    body = JSON.stringify({
        ...(input.Name != null && { Name: input.Name }),
        ...(input.RequireEncryption != null && { RequireEncryption: input.RequireEncryption }),
    });
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "PUT",
        headers,
        path: resolvedPath,
        body,
    });
};
export const serializeAws_restJson1UpdateVoiceConnectorGroupCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {
        "content-type": "application/json",
    };
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` +
        "/voice-connector-groups/{VoiceConnectorGroupId}";
    resolvedPath = __resolvedPath(resolvedPath, input, "VoiceConnectorGroupId", () => input.VoiceConnectorGroupId, "{VoiceConnectorGroupId}", false);
    let body;
    body = JSON.stringify({
        ...(input.Name != null && { Name: input.Name }),
        ...(input.VoiceConnectorItems != null && {
            VoiceConnectorItems: serializeAws_restJson1VoiceConnectorItemList(input.VoiceConnectorItems, context),
        }),
    });
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "PUT",
        headers,
        path: resolvedPath,
        body,
    });
};
export const serializeAws_restJson1ValidateE911AddressCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {
        "content-type": "application/json",
    };
    const resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/emergency-calling/address";
    let body;
    body = JSON.stringify({
        ...(input.AwsAccountId != null && { AwsAccountId: input.AwsAccountId }),
        ...(input.City != null && { City: input.City }),
        ...(input.Country != null && { Country: input.Country }),
        ...(input.PostalCode != null && { PostalCode: input.PostalCode }),
        ...(input.State != null && { State: input.State }),
        ...(input.StreetInfo != null && { StreetInfo: input.StreetInfo }),
        ...(input.StreetNumber != null && { StreetNumber: input.StreetNumber }),
    });
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "POST",
        headers,
        path: resolvedPath,
        body,
    });
};
export const deserializeAws_restJson1AssociatePhoneNumbersWithVoiceConnectorCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return deserializeAws_restJson1AssociatePhoneNumbersWithVoiceConnectorCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    if (data.PhoneNumberErrors != null) {
        contents.PhoneNumberErrors = deserializeAws_restJson1PhoneNumberErrorList(data.PhoneNumberErrors, context);
    }
    return contents;
};
const deserializeAws_restJson1AssociatePhoneNumbersWithVoiceConnectorCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "AccessDeniedException":
        case "com.amazonaws.chime#AccessDeniedException":
            throw await deserializeAws_restJson1AccessDeniedExceptionResponse(parsedOutput, context);
        case "BadRequestException":
        case "com.amazonaws.chime#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chime#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chime#NotFoundException":
            throw await deserializeAws_restJson1NotFoundExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chime#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chime#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chime#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chime#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1AssociatePhoneNumbersWithVoiceConnectorGroupCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return deserializeAws_restJson1AssociatePhoneNumbersWithVoiceConnectorGroupCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    if (data.PhoneNumberErrors != null) {
        contents.PhoneNumberErrors = deserializeAws_restJson1PhoneNumberErrorList(data.PhoneNumberErrors, context);
    }
    return contents;
};
const deserializeAws_restJson1AssociatePhoneNumbersWithVoiceConnectorGroupCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "AccessDeniedException":
        case "com.amazonaws.chime#AccessDeniedException":
            throw await deserializeAws_restJson1AccessDeniedExceptionResponse(parsedOutput, context);
        case "BadRequestException":
        case "com.amazonaws.chime#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chime#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chime#NotFoundException":
            throw await deserializeAws_restJson1NotFoundExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chime#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chime#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chime#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chime#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1AssociatePhoneNumberWithUserCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return deserializeAws_restJson1AssociatePhoneNumberWithUserCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    await collectBody(output.body, context);
    return contents;
};
const deserializeAws_restJson1AssociatePhoneNumberWithUserCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "AccessDeniedException":
        case "com.amazonaws.chime#AccessDeniedException":
            throw await deserializeAws_restJson1AccessDeniedExceptionResponse(parsedOutput, context);
        case "BadRequestException":
        case "com.amazonaws.chime#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chime#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chime#NotFoundException":
            throw await deserializeAws_restJson1NotFoundExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chime#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chime#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chime#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chime#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1AssociateSigninDelegateGroupsWithAccountCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return deserializeAws_restJson1AssociateSigninDelegateGroupsWithAccountCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    await collectBody(output.body, context);
    return contents;
};
const deserializeAws_restJson1AssociateSigninDelegateGroupsWithAccountCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chime#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chime#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chime#NotFoundException":
            throw await deserializeAws_restJson1NotFoundExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chime#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chime#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chime#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chime#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1BatchCreateAttendeeCommand = async (output, context) => {
    if (output.statusCode !== 201 && output.statusCode >= 300) {
        return deserializeAws_restJson1BatchCreateAttendeeCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    if (data.Attendees != null) {
        contents.Attendees = deserializeAws_restJson1AttendeeList(data.Attendees, context);
    }
    if (data.Errors != null) {
        contents.Errors = deserializeAws_restJson1BatchCreateAttendeeErrorList(data.Errors, context);
    }
    return contents;
};
const deserializeAws_restJson1BatchCreateAttendeeCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chime#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chime#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chime#NotFoundException":
            throw await deserializeAws_restJson1NotFoundExceptionResponse(parsedOutput, context);
        case "ResourceLimitExceededException":
        case "com.amazonaws.chime#ResourceLimitExceededException":
            throw await deserializeAws_restJson1ResourceLimitExceededExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chime#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chime#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chime#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chime#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1BatchCreateChannelMembershipCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return deserializeAws_restJson1BatchCreateChannelMembershipCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    if (data.BatchChannelMemberships != null) {
        contents.BatchChannelMemberships = deserializeAws_restJson1BatchChannelMemberships(data.BatchChannelMemberships, context);
    }
    if (data.Errors != null) {
        contents.Errors = deserializeAws_restJson1BatchCreateChannelMembershipErrors(data.Errors, context);
    }
    return contents;
};
const deserializeAws_restJson1BatchCreateChannelMembershipCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chime#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chime#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chime#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chime#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chime#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chime#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1BatchCreateRoomMembershipCommand = async (output, context) => {
    if (output.statusCode !== 201 && output.statusCode >= 300) {
        return deserializeAws_restJson1BatchCreateRoomMembershipCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    if (data.Errors != null) {
        contents.Errors = deserializeAws_restJson1MemberErrorList(data.Errors, context);
    }
    return contents;
};
const deserializeAws_restJson1BatchCreateRoomMembershipCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chime#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chime#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chime#NotFoundException":
            throw await deserializeAws_restJson1NotFoundExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chime#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chime#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chime#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chime#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1BatchDeletePhoneNumberCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return deserializeAws_restJson1BatchDeletePhoneNumberCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    if (data.PhoneNumberErrors != null) {
        contents.PhoneNumberErrors = deserializeAws_restJson1PhoneNumberErrorList(data.PhoneNumberErrors, context);
    }
    return contents;
};
const deserializeAws_restJson1BatchDeletePhoneNumberCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chime#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chime#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chime#NotFoundException":
            throw await deserializeAws_restJson1NotFoundExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chime#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chime#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chime#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chime#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1BatchSuspendUserCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return deserializeAws_restJson1BatchSuspendUserCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    if (data.UserErrors != null) {
        contents.UserErrors = deserializeAws_restJson1UserErrorList(data.UserErrors, context);
    }
    return contents;
};
const deserializeAws_restJson1BatchSuspendUserCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chime#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chime#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chime#NotFoundException":
            throw await deserializeAws_restJson1NotFoundExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chime#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chime#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chime#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chime#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1BatchUnsuspendUserCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return deserializeAws_restJson1BatchUnsuspendUserCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    if (data.UserErrors != null) {
        contents.UserErrors = deserializeAws_restJson1UserErrorList(data.UserErrors, context);
    }
    return contents;
};
const deserializeAws_restJson1BatchUnsuspendUserCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chime#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chime#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chime#NotFoundException":
            throw await deserializeAws_restJson1NotFoundExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chime#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chime#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chime#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chime#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1BatchUpdatePhoneNumberCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return deserializeAws_restJson1BatchUpdatePhoneNumberCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    if (data.PhoneNumberErrors != null) {
        contents.PhoneNumberErrors = deserializeAws_restJson1PhoneNumberErrorList(data.PhoneNumberErrors, context);
    }
    return contents;
};
const deserializeAws_restJson1BatchUpdatePhoneNumberCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chime#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chime#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chime#NotFoundException":
            throw await deserializeAws_restJson1NotFoundExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chime#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chime#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chime#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chime#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1BatchUpdateUserCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return deserializeAws_restJson1BatchUpdateUserCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    if (data.UserErrors != null) {
        contents.UserErrors = deserializeAws_restJson1UserErrorList(data.UserErrors, context);
    }
    return contents;
};
const deserializeAws_restJson1BatchUpdateUserCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chime#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chime#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chime#NotFoundException":
            throw await deserializeAws_restJson1NotFoundExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chime#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chime#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chime#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chime#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1CreateAccountCommand = async (output, context) => {
    if (output.statusCode !== 201 && output.statusCode >= 300) {
        return deserializeAws_restJson1CreateAccountCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    if (data.Account != null) {
        contents.Account = deserializeAws_restJson1Account(data.Account, context);
    }
    return contents;
};
const deserializeAws_restJson1CreateAccountCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chime#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chime#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chime#NotFoundException":
            throw await deserializeAws_restJson1NotFoundExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chime#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chime#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chime#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chime#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1CreateAppInstanceCommand = async (output, context) => {
    if (output.statusCode !== 201 && output.statusCode >= 300) {
        return deserializeAws_restJson1CreateAppInstanceCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    if (data.AppInstanceArn != null) {
        contents.AppInstanceArn = __expectString(data.AppInstanceArn);
    }
    return contents;
};
const deserializeAws_restJson1CreateAppInstanceCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chime#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ConflictException":
        case "com.amazonaws.chime#ConflictException":
            throw await deserializeAws_restJson1ConflictExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chime#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "ResourceLimitExceededException":
        case "com.amazonaws.chime#ResourceLimitExceededException":
            throw await deserializeAws_restJson1ResourceLimitExceededExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chime#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chime#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chime#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chime#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1CreateAppInstanceAdminCommand = async (output, context) => {
    if (output.statusCode !== 201 && output.statusCode >= 300) {
        return deserializeAws_restJson1CreateAppInstanceAdminCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    if (data.AppInstanceAdmin != null) {
        contents.AppInstanceAdmin = deserializeAws_restJson1Identity(data.AppInstanceAdmin, context);
    }
    if (data.AppInstanceArn != null) {
        contents.AppInstanceArn = __expectString(data.AppInstanceArn);
    }
    return contents;
};
const deserializeAws_restJson1CreateAppInstanceAdminCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chime#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ConflictException":
        case "com.amazonaws.chime#ConflictException":
            throw await deserializeAws_restJson1ConflictExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chime#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "ResourceLimitExceededException":
        case "com.amazonaws.chime#ResourceLimitExceededException":
            throw await deserializeAws_restJson1ResourceLimitExceededExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chime#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chime#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chime#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chime#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1CreateAppInstanceUserCommand = async (output, context) => {
    if (output.statusCode !== 201 && output.statusCode >= 300) {
        return deserializeAws_restJson1CreateAppInstanceUserCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    if (data.AppInstanceUserArn != null) {
        contents.AppInstanceUserArn = __expectString(data.AppInstanceUserArn);
    }
    return contents;
};
const deserializeAws_restJson1CreateAppInstanceUserCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chime#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ConflictException":
        case "com.amazonaws.chime#ConflictException":
            throw await deserializeAws_restJson1ConflictExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chime#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "ResourceLimitExceededException":
        case "com.amazonaws.chime#ResourceLimitExceededException":
            throw await deserializeAws_restJson1ResourceLimitExceededExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chime#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chime#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chime#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chime#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1CreateAttendeeCommand = async (output, context) => {
    if (output.statusCode !== 201 && output.statusCode >= 300) {
        return deserializeAws_restJson1CreateAttendeeCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    if (data.Attendee != null) {
        contents.Attendee = deserializeAws_restJson1Attendee(data.Attendee, context);
    }
    return contents;
};
const deserializeAws_restJson1CreateAttendeeCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chime#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chime#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chime#NotFoundException":
            throw await deserializeAws_restJson1NotFoundExceptionResponse(parsedOutput, context);
        case "ResourceLimitExceededException":
        case "com.amazonaws.chime#ResourceLimitExceededException":
            throw await deserializeAws_restJson1ResourceLimitExceededExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chime#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chime#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chime#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chime#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1CreateBotCommand = async (output, context) => {
    if (output.statusCode !== 201 && output.statusCode >= 300) {
        return deserializeAws_restJson1CreateBotCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    if (data.Bot != null) {
        contents.Bot = deserializeAws_restJson1Bot(data.Bot, context);
    }
    return contents;
};
const deserializeAws_restJson1CreateBotCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chime#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chime#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chime#NotFoundException":
            throw await deserializeAws_restJson1NotFoundExceptionResponse(parsedOutput, context);
        case "ResourceLimitExceededException":
        case "com.amazonaws.chime#ResourceLimitExceededException":
            throw await deserializeAws_restJson1ResourceLimitExceededExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chime#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chime#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chime#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chime#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1CreateChannelCommand = async (output, context) => {
    if (output.statusCode !== 201 && output.statusCode >= 300) {
        return deserializeAws_restJson1CreateChannelCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    if (data.ChannelArn != null) {
        contents.ChannelArn = __expectString(data.ChannelArn);
    }
    return contents;
};
const deserializeAws_restJson1CreateChannelCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chime#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ConflictException":
        case "com.amazonaws.chime#ConflictException":
            throw await deserializeAws_restJson1ConflictExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chime#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "ResourceLimitExceededException":
        case "com.amazonaws.chime#ResourceLimitExceededException":
            throw await deserializeAws_restJson1ResourceLimitExceededExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chime#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chime#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chime#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chime#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1CreateChannelBanCommand = async (output, context) => {
    if (output.statusCode !== 201 && output.statusCode >= 300) {
        return deserializeAws_restJson1CreateChannelBanCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    if (data.ChannelArn != null) {
        contents.ChannelArn = __expectString(data.ChannelArn);
    }
    if (data.Member != null) {
        contents.Member = deserializeAws_restJson1Identity(data.Member, context);
    }
    return contents;
};
const deserializeAws_restJson1CreateChannelBanCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chime#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ConflictException":
        case "com.amazonaws.chime#ConflictException":
            throw await deserializeAws_restJson1ConflictExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chime#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "ResourceLimitExceededException":
        case "com.amazonaws.chime#ResourceLimitExceededException":
            throw await deserializeAws_restJson1ResourceLimitExceededExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chime#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chime#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chime#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chime#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1CreateChannelMembershipCommand = async (output, context) => {
    if (output.statusCode !== 201 && output.statusCode >= 300) {
        return deserializeAws_restJson1CreateChannelMembershipCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    if (data.ChannelArn != null) {
        contents.ChannelArn = __expectString(data.ChannelArn);
    }
    if (data.Member != null) {
        contents.Member = deserializeAws_restJson1Identity(data.Member, context);
    }
    return contents;
};
const deserializeAws_restJson1CreateChannelMembershipCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chime#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ConflictException":
        case "com.amazonaws.chime#ConflictException":
            throw await deserializeAws_restJson1ConflictExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chime#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "ResourceLimitExceededException":
        case "com.amazonaws.chime#ResourceLimitExceededException":
            throw await deserializeAws_restJson1ResourceLimitExceededExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chime#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chime#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chime#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chime#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1CreateChannelModeratorCommand = async (output, context) => {
    if (output.statusCode !== 201 && output.statusCode >= 300) {
        return deserializeAws_restJson1CreateChannelModeratorCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    if (data.ChannelArn != null) {
        contents.ChannelArn = __expectString(data.ChannelArn);
    }
    if (data.ChannelModerator != null) {
        contents.ChannelModerator = deserializeAws_restJson1Identity(data.ChannelModerator, context);
    }
    return contents;
};
const deserializeAws_restJson1CreateChannelModeratorCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chime#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ConflictException":
        case "com.amazonaws.chime#ConflictException":
            throw await deserializeAws_restJson1ConflictExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chime#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "ResourceLimitExceededException":
        case "com.amazonaws.chime#ResourceLimitExceededException":
            throw await deserializeAws_restJson1ResourceLimitExceededExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chime#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chime#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chime#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chime#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1CreateMediaCapturePipelineCommand = async (output, context) => {
    if (output.statusCode !== 201 && output.statusCode >= 300) {
        return deserializeAws_restJson1CreateMediaCapturePipelineCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    if (data.MediaCapturePipeline != null) {
        contents.MediaCapturePipeline = deserializeAws_restJson1MediaCapturePipeline(data.MediaCapturePipeline, context);
    }
    return contents;
};
const deserializeAws_restJson1CreateMediaCapturePipelineCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chime#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chime#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "ResourceLimitExceededException":
        case "com.amazonaws.chime#ResourceLimitExceededException":
            throw await deserializeAws_restJson1ResourceLimitExceededExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chime#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chime#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chime#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chime#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1CreateMeetingCommand = async (output, context) => {
    if (output.statusCode !== 201 && output.statusCode >= 300) {
        return deserializeAws_restJson1CreateMeetingCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    if (data.Meeting != null) {
        contents.Meeting = deserializeAws_restJson1Meeting(data.Meeting, context);
    }
    return contents;
};
const deserializeAws_restJson1CreateMeetingCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chime#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chime#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "ResourceLimitExceededException":
        case "com.amazonaws.chime#ResourceLimitExceededException":
            throw await deserializeAws_restJson1ResourceLimitExceededExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chime#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chime#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chime#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chime#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1CreateMeetingDialOutCommand = async (output, context) => {
    if (output.statusCode !== 201 && output.statusCode >= 300) {
        return deserializeAws_restJson1CreateMeetingDialOutCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    if (data.TransactionId != null) {
        contents.TransactionId = __expectString(data.TransactionId);
    }
    return contents;
};
const deserializeAws_restJson1CreateMeetingDialOutCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "AccessDeniedException":
        case "com.amazonaws.chime#AccessDeniedException":
            throw await deserializeAws_restJson1AccessDeniedExceptionResponse(parsedOutput, context);
        case "BadRequestException":
        case "com.amazonaws.chime#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chime#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "ResourceLimitExceededException":
        case "com.amazonaws.chime#ResourceLimitExceededException":
            throw await deserializeAws_restJson1ResourceLimitExceededExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chime#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chime#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chime#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chime#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1CreateMeetingWithAttendeesCommand = async (output, context) => {
    if (output.statusCode !== 201 && output.statusCode >= 300) {
        return deserializeAws_restJson1CreateMeetingWithAttendeesCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    if (data.Attendees != null) {
        contents.Attendees = deserializeAws_restJson1AttendeeList(data.Attendees, context);
    }
    if (data.Errors != null) {
        contents.Errors = deserializeAws_restJson1BatchCreateAttendeeErrorList(data.Errors, context);
    }
    if (data.Meeting != null) {
        contents.Meeting = deserializeAws_restJson1Meeting(data.Meeting, context);
    }
    return contents;
};
const deserializeAws_restJson1CreateMeetingWithAttendeesCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chime#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chime#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "ResourceLimitExceededException":
        case "com.amazonaws.chime#ResourceLimitExceededException":
            throw await deserializeAws_restJson1ResourceLimitExceededExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chime#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chime#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chime#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chime#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1CreatePhoneNumberOrderCommand = async (output, context) => {
    if (output.statusCode !== 201 && output.statusCode >= 300) {
        return deserializeAws_restJson1CreatePhoneNumberOrderCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    if (data.PhoneNumberOrder != null) {
        contents.PhoneNumberOrder = deserializeAws_restJson1PhoneNumberOrder(data.PhoneNumberOrder, context);
    }
    return contents;
};
const deserializeAws_restJson1CreatePhoneNumberOrderCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "AccessDeniedException":
        case "com.amazonaws.chime#AccessDeniedException":
            throw await deserializeAws_restJson1AccessDeniedExceptionResponse(parsedOutput, context);
        case "BadRequestException":
        case "com.amazonaws.chime#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chime#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "ResourceLimitExceededException":
        case "com.amazonaws.chime#ResourceLimitExceededException":
            throw await deserializeAws_restJson1ResourceLimitExceededExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chime#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chime#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chime#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chime#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1CreateProxySessionCommand = async (output, context) => {
    if (output.statusCode !== 201 && output.statusCode >= 300) {
        return deserializeAws_restJson1CreateProxySessionCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    if (data.ProxySession != null) {
        contents.ProxySession = deserializeAws_restJson1ProxySession(data.ProxySession, context);
    }
    return contents;
};
const deserializeAws_restJson1CreateProxySessionCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chime#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chime#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chime#NotFoundException":
            throw await deserializeAws_restJson1NotFoundExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chime#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chime#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chime#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chime#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1CreateRoomCommand = async (output, context) => {
    if (output.statusCode !== 201 && output.statusCode >= 300) {
        return deserializeAws_restJson1CreateRoomCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    if (data.Room != null) {
        contents.Room = deserializeAws_restJson1Room(data.Room, context);
    }
    return contents;
};
const deserializeAws_restJson1CreateRoomCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chime#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chime#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chime#NotFoundException":
            throw await deserializeAws_restJson1NotFoundExceptionResponse(parsedOutput, context);
        case "ResourceLimitExceededException":
        case "com.amazonaws.chime#ResourceLimitExceededException":
            throw await deserializeAws_restJson1ResourceLimitExceededExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chime#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chime#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chime#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chime#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1CreateRoomMembershipCommand = async (output, context) => {
    if (output.statusCode !== 201 && output.statusCode >= 300) {
        return deserializeAws_restJson1CreateRoomMembershipCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    if (data.RoomMembership != null) {
        contents.RoomMembership = deserializeAws_restJson1RoomMembership(data.RoomMembership, context);
    }
    return contents;
};
const deserializeAws_restJson1CreateRoomMembershipCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chime#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ConflictException":
        case "com.amazonaws.chime#ConflictException":
            throw await deserializeAws_restJson1ConflictExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chime#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chime#NotFoundException":
            throw await deserializeAws_restJson1NotFoundExceptionResponse(parsedOutput, context);
        case "ResourceLimitExceededException":
        case "com.amazonaws.chime#ResourceLimitExceededException":
            throw await deserializeAws_restJson1ResourceLimitExceededExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chime#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chime#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chime#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chime#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1CreateSipMediaApplicationCommand = async (output, context) => {
    if (output.statusCode !== 201 && output.statusCode >= 300) {
        return deserializeAws_restJson1CreateSipMediaApplicationCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    if (data.SipMediaApplication != null) {
        contents.SipMediaApplication = deserializeAws_restJson1SipMediaApplication(data.SipMediaApplication, context);
    }
    return contents;
};
const deserializeAws_restJson1CreateSipMediaApplicationCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "AccessDeniedException":
        case "com.amazonaws.chime#AccessDeniedException":
            throw await deserializeAws_restJson1AccessDeniedExceptionResponse(parsedOutput, context);
        case "BadRequestException":
        case "com.amazonaws.chime#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ConflictException":
        case "com.amazonaws.chime#ConflictException":
            throw await deserializeAws_restJson1ConflictExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chime#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "ResourceLimitExceededException":
        case "com.amazonaws.chime#ResourceLimitExceededException":
            throw await deserializeAws_restJson1ResourceLimitExceededExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chime#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chime#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chime#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chime#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1CreateSipMediaApplicationCallCommand = async (output, context) => {
    if (output.statusCode !== 201 && output.statusCode >= 300) {
        return deserializeAws_restJson1CreateSipMediaApplicationCallCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    if (data.SipMediaApplicationCall != null) {
        contents.SipMediaApplicationCall = deserializeAws_restJson1SipMediaApplicationCall(data.SipMediaApplicationCall, context);
    }
    return contents;
};
const deserializeAws_restJson1CreateSipMediaApplicationCallCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "AccessDeniedException":
        case "com.amazonaws.chime#AccessDeniedException":
            throw await deserializeAws_restJson1AccessDeniedExceptionResponse(parsedOutput, context);
        case "BadRequestException":
        case "com.amazonaws.chime#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chime#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "ResourceLimitExceededException":
        case "com.amazonaws.chime#ResourceLimitExceededException":
            throw await deserializeAws_restJson1ResourceLimitExceededExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chime#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chime#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chime#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chime#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1CreateSipRuleCommand = async (output, context) => {
    if (output.statusCode !== 201 && output.statusCode >= 300) {
        return deserializeAws_restJson1CreateSipRuleCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    if (data.SipRule != null) {
        contents.SipRule = deserializeAws_restJson1SipRule(data.SipRule, context);
    }
    return contents;
};
const deserializeAws_restJson1CreateSipRuleCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "AccessDeniedException":
        case "com.amazonaws.chime#AccessDeniedException":
            throw await deserializeAws_restJson1AccessDeniedExceptionResponse(parsedOutput, context);
        case "BadRequestException":
        case "com.amazonaws.chime#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ConflictException":
        case "com.amazonaws.chime#ConflictException":
            throw await deserializeAws_restJson1ConflictExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chime#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "ResourceLimitExceededException":
        case "com.amazonaws.chime#ResourceLimitExceededException":
            throw await deserializeAws_restJson1ResourceLimitExceededExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chime#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chime#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chime#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chime#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1CreateUserCommand = async (output, context) => {
    if (output.statusCode !== 201 && output.statusCode >= 300) {
        return deserializeAws_restJson1CreateUserCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    if (data.User != null) {
        contents.User = deserializeAws_restJson1User(data.User, context);
    }
    return contents;
};
const deserializeAws_restJson1CreateUserCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chime#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ConflictException":
        case "com.amazonaws.chime#ConflictException":
            throw await deserializeAws_restJson1ConflictExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chime#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chime#NotFoundException":
            throw await deserializeAws_restJson1NotFoundExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chime#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chime#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chime#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chime#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1CreateVoiceConnectorCommand = async (output, context) => {
    if (output.statusCode !== 201 && output.statusCode >= 300) {
        return deserializeAws_restJson1CreateVoiceConnectorCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    if (data.VoiceConnector != null) {
        contents.VoiceConnector = deserializeAws_restJson1VoiceConnector(data.VoiceConnector, context);
    }
    return contents;
};
const deserializeAws_restJson1CreateVoiceConnectorCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "AccessDeniedException":
        case "com.amazonaws.chime#AccessDeniedException":
            throw await deserializeAws_restJson1AccessDeniedExceptionResponse(parsedOutput, context);
        case "BadRequestException":
        case "com.amazonaws.chime#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chime#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "ResourceLimitExceededException":
        case "com.amazonaws.chime#ResourceLimitExceededException":
            throw await deserializeAws_restJson1ResourceLimitExceededExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chime#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chime#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chime#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chime#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1CreateVoiceConnectorGroupCommand = async (output, context) => {
    if (output.statusCode !== 201 && output.statusCode >= 300) {
        return deserializeAws_restJson1CreateVoiceConnectorGroupCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    if (data.VoiceConnectorGroup != null) {
        contents.VoiceConnectorGroup = deserializeAws_restJson1VoiceConnectorGroup(data.VoiceConnectorGroup, context);
    }
    return contents;
};
const deserializeAws_restJson1CreateVoiceConnectorGroupCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "AccessDeniedException":
        case "com.amazonaws.chime#AccessDeniedException":
            throw await deserializeAws_restJson1AccessDeniedExceptionResponse(parsedOutput, context);
        case "BadRequestException":
        case "com.amazonaws.chime#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chime#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "ResourceLimitExceededException":
        case "com.amazonaws.chime#ResourceLimitExceededException":
            throw await deserializeAws_restJson1ResourceLimitExceededExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chime#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chime#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chime#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chime#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1DeleteAccountCommand = async (output, context) => {
    if (output.statusCode !== 204 && output.statusCode >= 300) {
        return deserializeAws_restJson1DeleteAccountCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    await collectBody(output.body, context);
    return contents;
};
const deserializeAws_restJson1DeleteAccountCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chime#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chime#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chime#NotFoundException":
            throw await deserializeAws_restJson1NotFoundExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chime#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chime#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chime#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chime#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        case "UnprocessableEntityException":
        case "com.amazonaws.chime#UnprocessableEntityException":
            throw await deserializeAws_restJson1UnprocessableEntityExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1DeleteAppInstanceCommand = async (output, context) => {
    if (output.statusCode !== 204 && output.statusCode >= 300) {
        return deserializeAws_restJson1DeleteAppInstanceCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    await collectBody(output.body, context);
    return contents;
};
const deserializeAws_restJson1DeleteAppInstanceCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chime#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chime#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chime#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chime#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chime#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chime#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1DeleteAppInstanceAdminCommand = async (output, context) => {
    if (output.statusCode !== 204 && output.statusCode >= 300) {
        return deserializeAws_restJson1DeleteAppInstanceAdminCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    await collectBody(output.body, context);
    return contents;
};
const deserializeAws_restJson1DeleteAppInstanceAdminCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chime#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ConflictException":
        case "com.amazonaws.chime#ConflictException":
            throw await deserializeAws_restJson1ConflictExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chime#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chime#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chime#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chime#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chime#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1DeleteAppInstanceStreamingConfigurationsCommand = async (output, context) => {
    if (output.statusCode !== 204 && output.statusCode >= 300) {
        return deserializeAws_restJson1DeleteAppInstanceStreamingConfigurationsCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    await collectBody(output.body, context);
    return contents;
};
const deserializeAws_restJson1DeleteAppInstanceStreamingConfigurationsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chime#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chime#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chime#NotFoundException":
            throw await deserializeAws_restJson1NotFoundExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chime#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chime#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chime#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chime#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1DeleteAppInstanceUserCommand = async (output, context) => {
    if (output.statusCode !== 204 && output.statusCode >= 300) {
        return deserializeAws_restJson1DeleteAppInstanceUserCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    await collectBody(output.body, context);
    return contents;
};
const deserializeAws_restJson1DeleteAppInstanceUserCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chime#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chime#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chime#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chime#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chime#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chime#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1DeleteAttendeeCommand = async (output, context) => {
    if (output.statusCode !== 204 && output.statusCode >= 300) {
        return deserializeAws_restJson1DeleteAttendeeCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    await collectBody(output.body, context);
    return contents;
};
const deserializeAws_restJson1DeleteAttendeeCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chime#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chime#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chime#NotFoundException":
            throw await deserializeAws_restJson1NotFoundExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chime#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chime#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chime#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chime#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1DeleteChannelCommand = async (output, context) => {
    if (output.statusCode !== 204 && output.statusCode >= 300) {
        return deserializeAws_restJson1DeleteChannelCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    await collectBody(output.body, context);
    return contents;
};
const deserializeAws_restJson1DeleteChannelCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chime#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chime#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chime#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chime#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chime#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chime#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1DeleteChannelBanCommand = async (output, context) => {
    if (output.statusCode !== 204 && output.statusCode >= 300) {
        return deserializeAws_restJson1DeleteChannelBanCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    await collectBody(output.body, context);
    return contents;
};
const deserializeAws_restJson1DeleteChannelBanCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chime#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chime#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chime#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chime#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chime#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chime#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1DeleteChannelMembershipCommand = async (output, context) => {
    if (output.statusCode !== 204 && output.statusCode >= 300) {
        return deserializeAws_restJson1DeleteChannelMembershipCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    await collectBody(output.body, context);
    return contents;
};
const deserializeAws_restJson1DeleteChannelMembershipCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chime#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ConflictException":
        case "com.amazonaws.chime#ConflictException":
            throw await deserializeAws_restJson1ConflictExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chime#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chime#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chime#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chime#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chime#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1DeleteChannelMessageCommand = async (output, context) => {
    if (output.statusCode !== 204 && output.statusCode >= 300) {
        return deserializeAws_restJson1DeleteChannelMessageCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    await collectBody(output.body, context);
    return contents;
};
const deserializeAws_restJson1DeleteChannelMessageCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chime#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chime#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chime#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chime#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chime#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chime#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1DeleteChannelModeratorCommand = async (output, context) => {
    if (output.statusCode !== 204 && output.statusCode >= 300) {
        return deserializeAws_restJson1DeleteChannelModeratorCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    await collectBody(output.body, context);
    return contents;
};
const deserializeAws_restJson1DeleteChannelModeratorCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chime#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chime#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chime#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chime#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chime#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chime#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1DeleteEventsConfigurationCommand = async (output, context) => {
    if (output.statusCode !== 204 && output.statusCode >= 300) {
        return deserializeAws_restJson1DeleteEventsConfigurationCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    await collectBody(output.body, context);
    return contents;
};
const deserializeAws_restJson1DeleteEventsConfigurationCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chime#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chime#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "ResourceLimitExceededException":
        case "com.amazonaws.chime#ResourceLimitExceededException":
            throw await deserializeAws_restJson1ResourceLimitExceededExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chime#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chime#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chime#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1DeleteMediaCapturePipelineCommand = async (output, context) => {
    if (output.statusCode !== 204 && output.statusCode >= 300) {
        return deserializeAws_restJson1DeleteMediaCapturePipelineCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    await collectBody(output.body, context);
    return contents;
};
const deserializeAws_restJson1DeleteMediaCapturePipelineCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chime#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chime#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chime#NotFoundException":
            throw await deserializeAws_restJson1NotFoundExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chime#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chime#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chime#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chime#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1DeleteMeetingCommand = async (output, context) => {
    if (output.statusCode !== 204 && output.statusCode >= 300) {
        return deserializeAws_restJson1DeleteMeetingCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    await collectBody(output.body, context);
    return contents;
};
const deserializeAws_restJson1DeleteMeetingCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chime#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chime#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chime#NotFoundException":
            throw await deserializeAws_restJson1NotFoundExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chime#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chime#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chime#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chime#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1DeletePhoneNumberCommand = async (output, context) => {
    if (output.statusCode !== 204 && output.statusCode >= 300) {
        return deserializeAws_restJson1DeletePhoneNumberCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    await collectBody(output.body, context);
    return contents;
};
const deserializeAws_restJson1DeletePhoneNumberCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chime#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chime#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chime#NotFoundException":
            throw await deserializeAws_restJson1NotFoundExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chime#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chime#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chime#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chime#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1DeleteProxySessionCommand = async (output, context) => {
    if (output.statusCode !== 204 && output.statusCode >= 300) {
        return deserializeAws_restJson1DeleteProxySessionCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    await collectBody(output.body, context);
    return contents;
};
const deserializeAws_restJson1DeleteProxySessionCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chime#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chime#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chime#NotFoundException":
            throw await deserializeAws_restJson1NotFoundExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chime#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chime#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chime#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chime#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1DeleteRoomCommand = async (output, context) => {
    if (output.statusCode !== 204 && output.statusCode >= 300) {
        return deserializeAws_restJson1DeleteRoomCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    await collectBody(output.body, context);
    return contents;
};
const deserializeAws_restJson1DeleteRoomCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chime#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chime#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chime#NotFoundException":
            throw await deserializeAws_restJson1NotFoundExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chime#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chime#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chime#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chime#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1DeleteRoomMembershipCommand = async (output, context) => {
    if (output.statusCode !== 204 && output.statusCode >= 300) {
        return deserializeAws_restJson1DeleteRoomMembershipCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    await collectBody(output.body, context);
    return contents;
};
const deserializeAws_restJson1DeleteRoomMembershipCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chime#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chime#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chime#NotFoundException":
            throw await deserializeAws_restJson1NotFoundExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chime#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chime#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chime#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chime#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1DeleteSipMediaApplicationCommand = async (output, context) => {
    if (output.statusCode !== 204 && output.statusCode >= 300) {
        return deserializeAws_restJson1DeleteSipMediaApplicationCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    await collectBody(output.body, context);
    return contents;
};
const deserializeAws_restJson1DeleteSipMediaApplicationCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chime#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ConflictException":
        case "com.amazonaws.chime#ConflictException":
            throw await deserializeAws_restJson1ConflictExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chime#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chime#NotFoundException":
            throw await deserializeAws_restJson1NotFoundExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chime#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chime#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chime#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chime#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1DeleteSipRuleCommand = async (output, context) => {
    if (output.statusCode !== 204 && output.statusCode >= 300) {
        return deserializeAws_restJson1DeleteSipRuleCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    await collectBody(output.body, context);
    return contents;
};
const deserializeAws_restJson1DeleteSipRuleCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chime#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ConflictException":
        case "com.amazonaws.chime#ConflictException":
            throw await deserializeAws_restJson1ConflictExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chime#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chime#NotFoundException":
            throw await deserializeAws_restJson1NotFoundExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chime#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chime#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chime#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chime#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1DeleteVoiceConnectorCommand = async (output, context) => {
    if (output.statusCode !== 204 && output.statusCode >= 300) {
        return deserializeAws_restJson1DeleteVoiceConnectorCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    await collectBody(output.body, context);
    return contents;
};
const deserializeAws_restJson1DeleteVoiceConnectorCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chime#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ConflictException":
        case "com.amazonaws.chime#ConflictException":
            throw await deserializeAws_restJson1ConflictExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chime#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chime#NotFoundException":
            throw await deserializeAws_restJson1NotFoundExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chime#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chime#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chime#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chime#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1DeleteVoiceConnectorEmergencyCallingConfigurationCommand = async (output, context) => {
    if (output.statusCode !== 204 && output.statusCode >= 300) {
        return deserializeAws_restJson1DeleteVoiceConnectorEmergencyCallingConfigurationCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    await collectBody(output.body, context);
    return contents;
};
const deserializeAws_restJson1DeleteVoiceConnectorEmergencyCallingConfigurationCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chime#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chime#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chime#NotFoundException":
            throw await deserializeAws_restJson1NotFoundExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chime#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chime#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chime#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chime#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1DeleteVoiceConnectorGroupCommand = async (output, context) => {
    if (output.statusCode !== 204 && output.statusCode >= 300) {
        return deserializeAws_restJson1DeleteVoiceConnectorGroupCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    await collectBody(output.body, context);
    return contents;
};
const deserializeAws_restJson1DeleteVoiceConnectorGroupCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chime#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ConflictException":
        case "com.amazonaws.chime#ConflictException":
            throw await deserializeAws_restJson1ConflictExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chime#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chime#NotFoundException":
            throw await deserializeAws_restJson1NotFoundExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chime#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chime#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chime#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chime#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1DeleteVoiceConnectorOriginationCommand = async (output, context) => {
    if (output.statusCode !== 204 && output.statusCode >= 300) {
        return deserializeAws_restJson1DeleteVoiceConnectorOriginationCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    await collectBody(output.body, context);
    return contents;
};
const deserializeAws_restJson1DeleteVoiceConnectorOriginationCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chime#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chime#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chime#NotFoundException":
            throw await deserializeAws_restJson1NotFoundExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chime#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chime#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chime#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chime#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1DeleteVoiceConnectorProxyCommand = async (output, context) => {
    if (output.statusCode !== 204 && output.statusCode >= 300) {
        return deserializeAws_restJson1DeleteVoiceConnectorProxyCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    await collectBody(output.body, context);
    return contents;
};
const deserializeAws_restJson1DeleteVoiceConnectorProxyCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chime#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chime#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chime#NotFoundException":
            throw await deserializeAws_restJson1NotFoundExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chime#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chime#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chime#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chime#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1DeleteVoiceConnectorStreamingConfigurationCommand = async (output, context) => {
    if (output.statusCode !== 204 && output.statusCode >= 300) {
        return deserializeAws_restJson1DeleteVoiceConnectorStreamingConfigurationCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    await collectBody(output.body, context);
    return contents;
};
const deserializeAws_restJson1DeleteVoiceConnectorStreamingConfigurationCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chime#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chime#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chime#NotFoundException":
            throw await deserializeAws_restJson1NotFoundExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chime#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chime#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chime#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chime#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1DeleteVoiceConnectorTerminationCommand = async (output, context) => {
    if (output.statusCode !== 204 && output.statusCode >= 300) {
        return deserializeAws_restJson1DeleteVoiceConnectorTerminationCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    await collectBody(output.body, context);
    return contents;
};
const deserializeAws_restJson1DeleteVoiceConnectorTerminationCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chime#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chime#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chime#NotFoundException":
            throw await deserializeAws_restJson1NotFoundExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chime#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chime#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chime#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chime#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1DeleteVoiceConnectorTerminationCredentialsCommand = async (output, context) => {
    if (output.statusCode !== 204 && output.statusCode >= 300) {
        return deserializeAws_restJson1DeleteVoiceConnectorTerminationCredentialsCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    await collectBody(output.body, context);
    return contents;
};
const deserializeAws_restJson1DeleteVoiceConnectorTerminationCredentialsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chime#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chime#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chime#NotFoundException":
            throw await deserializeAws_restJson1NotFoundExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chime#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chime#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chime#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chime#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1DescribeAppInstanceCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return deserializeAws_restJson1DescribeAppInstanceCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    if (data.AppInstance != null) {
        contents.AppInstance = deserializeAws_restJson1AppInstance(data.AppInstance, context);
    }
    return contents;
};
const deserializeAws_restJson1DescribeAppInstanceCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chime#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chime#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chime#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chime#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chime#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chime#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1DescribeAppInstanceAdminCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return deserializeAws_restJson1DescribeAppInstanceAdminCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    if (data.AppInstanceAdmin != null) {
        contents.AppInstanceAdmin = deserializeAws_restJson1AppInstanceAdmin(data.AppInstanceAdmin, context);
    }
    return contents;
};
const deserializeAws_restJson1DescribeAppInstanceAdminCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chime#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chime#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chime#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chime#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chime#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chime#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1DescribeAppInstanceUserCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return deserializeAws_restJson1DescribeAppInstanceUserCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    if (data.AppInstanceUser != null) {
        contents.AppInstanceUser = deserializeAws_restJson1AppInstanceUser(data.AppInstanceUser, context);
    }
    return contents;
};
const deserializeAws_restJson1DescribeAppInstanceUserCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chime#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chime#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chime#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chime#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chime#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chime#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1DescribeChannelCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return deserializeAws_restJson1DescribeChannelCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    if (data.Channel != null) {
        contents.Channel = deserializeAws_restJson1Channel(data.Channel, context);
    }
    return contents;
};
const deserializeAws_restJson1DescribeChannelCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chime#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chime#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chime#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chime#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chime#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chime#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1DescribeChannelBanCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return deserializeAws_restJson1DescribeChannelBanCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    if (data.ChannelBan != null) {
        contents.ChannelBan = deserializeAws_restJson1ChannelBan(data.ChannelBan, context);
    }
    return contents;
};
const deserializeAws_restJson1DescribeChannelBanCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chime#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chime#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chime#NotFoundException":
            throw await deserializeAws_restJson1NotFoundExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chime#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chime#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chime#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chime#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1DescribeChannelMembershipCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return deserializeAws_restJson1DescribeChannelMembershipCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    if (data.ChannelMembership != null) {
        contents.ChannelMembership = deserializeAws_restJson1ChannelMembership(data.ChannelMembership, context);
    }
    return contents;
};
const deserializeAws_restJson1DescribeChannelMembershipCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chime#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chime#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chime#NotFoundException":
            throw await deserializeAws_restJson1NotFoundExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chime#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chime#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chime#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chime#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1DescribeChannelMembershipForAppInstanceUserCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return deserializeAws_restJson1DescribeChannelMembershipForAppInstanceUserCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    if (data.ChannelMembership != null) {
        contents.ChannelMembership = deserializeAws_restJson1ChannelMembershipForAppInstanceUserSummary(data.ChannelMembership, context);
    }
    return contents;
};
const deserializeAws_restJson1DescribeChannelMembershipForAppInstanceUserCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chime#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chime#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chime#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chime#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chime#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chime#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1DescribeChannelModeratedByAppInstanceUserCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return deserializeAws_restJson1DescribeChannelModeratedByAppInstanceUserCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    if (data.Channel != null) {
        contents.Channel = deserializeAws_restJson1ChannelModeratedByAppInstanceUserSummary(data.Channel, context);
    }
    return contents;
};
const deserializeAws_restJson1DescribeChannelModeratedByAppInstanceUserCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chime#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chime#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chime#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chime#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chime#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chime#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1DescribeChannelModeratorCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return deserializeAws_restJson1DescribeChannelModeratorCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    if (data.ChannelModerator != null) {
        contents.ChannelModerator = deserializeAws_restJson1ChannelModerator(data.ChannelModerator, context);
    }
    return contents;
};
const deserializeAws_restJson1DescribeChannelModeratorCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chime#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chime#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chime#NotFoundException":
            throw await deserializeAws_restJson1NotFoundExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chime#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chime#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chime#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chime#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1DisassociatePhoneNumberFromUserCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return deserializeAws_restJson1DisassociatePhoneNumberFromUserCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    await collectBody(output.body, context);
    return contents;
};
const deserializeAws_restJson1DisassociatePhoneNumberFromUserCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chime#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chime#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chime#NotFoundException":
            throw await deserializeAws_restJson1NotFoundExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chime#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chime#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chime#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chime#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1DisassociatePhoneNumbersFromVoiceConnectorCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return deserializeAws_restJson1DisassociatePhoneNumbersFromVoiceConnectorCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    if (data.PhoneNumberErrors != null) {
        contents.PhoneNumberErrors = deserializeAws_restJson1PhoneNumberErrorList(data.PhoneNumberErrors, context);
    }
    return contents;
};
const deserializeAws_restJson1DisassociatePhoneNumbersFromVoiceConnectorCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chime#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chime#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chime#NotFoundException":
            throw await deserializeAws_restJson1NotFoundExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chime#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chime#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chime#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chime#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1DisassociatePhoneNumbersFromVoiceConnectorGroupCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return deserializeAws_restJson1DisassociatePhoneNumbersFromVoiceConnectorGroupCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    if (data.PhoneNumberErrors != null) {
        contents.PhoneNumberErrors = deserializeAws_restJson1PhoneNumberErrorList(data.PhoneNumberErrors, context);
    }
    return contents;
};
const deserializeAws_restJson1DisassociatePhoneNumbersFromVoiceConnectorGroupCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chime#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chime#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chime#NotFoundException":
            throw await deserializeAws_restJson1NotFoundExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chime#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chime#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chime#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chime#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1DisassociateSigninDelegateGroupsFromAccountCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return deserializeAws_restJson1DisassociateSigninDelegateGroupsFromAccountCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    await collectBody(output.body, context);
    return contents;
};
const deserializeAws_restJson1DisassociateSigninDelegateGroupsFromAccountCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chime#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chime#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chime#NotFoundException":
            throw await deserializeAws_restJson1NotFoundExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chime#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chime#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chime#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chime#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1GetAccountCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return deserializeAws_restJson1GetAccountCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    if (data.Account != null) {
        contents.Account = deserializeAws_restJson1Account(data.Account, context);
    }
    return contents;
};
const deserializeAws_restJson1GetAccountCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chime#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chime#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chime#NotFoundException":
            throw await deserializeAws_restJson1NotFoundExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chime#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chime#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chime#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chime#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1GetAccountSettingsCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return deserializeAws_restJson1GetAccountSettingsCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    if (data.AccountSettings != null) {
        contents.AccountSettings = deserializeAws_restJson1AccountSettings(data.AccountSettings, context);
    }
    return contents;
};
const deserializeAws_restJson1GetAccountSettingsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chime#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chime#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chime#NotFoundException":
            throw await deserializeAws_restJson1NotFoundExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chime#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chime#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chime#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chime#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1GetAppInstanceRetentionSettingsCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return deserializeAws_restJson1GetAppInstanceRetentionSettingsCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    if (data.AppInstanceRetentionSettings != null) {
        contents.AppInstanceRetentionSettings = deserializeAws_restJson1AppInstanceRetentionSettings(data.AppInstanceRetentionSettings, context);
    }
    if (data.InitiateDeletionTimestamp != null) {
        contents.InitiateDeletionTimestamp = __expectNonNull(__parseEpochTimestamp(__expectNumber(data.InitiateDeletionTimestamp)));
    }
    return contents;
};
const deserializeAws_restJson1GetAppInstanceRetentionSettingsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chime#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chime#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chime#NotFoundException":
            throw await deserializeAws_restJson1NotFoundExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chime#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chime#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chime#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chime#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1GetAppInstanceStreamingConfigurationsCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return deserializeAws_restJson1GetAppInstanceStreamingConfigurationsCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    if (data.AppInstanceStreamingConfigurations != null) {
        contents.AppInstanceStreamingConfigurations = deserializeAws_restJson1AppInstanceStreamingConfigurationList(data.AppInstanceStreamingConfigurations, context);
    }
    return contents;
};
const deserializeAws_restJson1GetAppInstanceStreamingConfigurationsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chime#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chime#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chime#NotFoundException":
            throw await deserializeAws_restJson1NotFoundExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chime#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chime#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chime#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chime#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1GetAttendeeCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return deserializeAws_restJson1GetAttendeeCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    if (data.Attendee != null) {
        contents.Attendee = deserializeAws_restJson1Attendee(data.Attendee, context);
    }
    return contents;
};
const deserializeAws_restJson1GetAttendeeCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chime#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chime#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chime#NotFoundException":
            throw await deserializeAws_restJson1NotFoundExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chime#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chime#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chime#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chime#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1GetBotCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return deserializeAws_restJson1GetBotCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    if (data.Bot != null) {
        contents.Bot = deserializeAws_restJson1Bot(data.Bot, context);
    }
    return contents;
};
const deserializeAws_restJson1GetBotCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chime#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chime#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chime#NotFoundException":
            throw await deserializeAws_restJson1NotFoundExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chime#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chime#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chime#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chime#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1GetChannelMessageCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return deserializeAws_restJson1GetChannelMessageCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    if (data.ChannelMessage != null) {
        contents.ChannelMessage = deserializeAws_restJson1ChannelMessage(data.ChannelMessage, context);
    }
    return contents;
};
const deserializeAws_restJson1GetChannelMessageCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chime#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chime#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chime#NotFoundException":
            throw await deserializeAws_restJson1NotFoundExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chime#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chime#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chime#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chime#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1GetEventsConfigurationCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return deserializeAws_restJson1GetEventsConfigurationCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    if (data.EventsConfiguration != null) {
        contents.EventsConfiguration = deserializeAws_restJson1EventsConfiguration(data.EventsConfiguration, context);
    }
    return contents;
};
const deserializeAws_restJson1GetEventsConfigurationCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chime#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chime#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chime#NotFoundException":
            throw await deserializeAws_restJson1NotFoundExceptionResponse(parsedOutput, context);
        case "ResourceLimitExceededException":
        case "com.amazonaws.chime#ResourceLimitExceededException":
            throw await deserializeAws_restJson1ResourceLimitExceededExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chime#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chime#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chime#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1GetGlobalSettingsCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return deserializeAws_restJson1GetGlobalSettingsCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    if (data.BusinessCalling != null) {
        contents.BusinessCalling = deserializeAws_restJson1BusinessCallingSettings(data.BusinessCalling, context);
    }
    if (data.VoiceConnector != null) {
        contents.VoiceConnector = deserializeAws_restJson1VoiceConnectorSettings(data.VoiceConnector, context);
    }
    return contents;
};
const deserializeAws_restJson1GetGlobalSettingsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chime#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chime#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chime#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chime#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chime#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chime#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1GetMediaCapturePipelineCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return deserializeAws_restJson1GetMediaCapturePipelineCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    if (data.MediaCapturePipeline != null) {
        contents.MediaCapturePipeline = deserializeAws_restJson1MediaCapturePipeline(data.MediaCapturePipeline, context);
    }
    return contents;
};
const deserializeAws_restJson1GetMediaCapturePipelineCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chime#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chime#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chime#NotFoundException":
            throw await deserializeAws_restJson1NotFoundExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chime#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chime#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chime#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chime#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1GetMeetingCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return deserializeAws_restJson1GetMeetingCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    if (data.Meeting != null) {
        contents.Meeting = deserializeAws_restJson1Meeting(data.Meeting, context);
    }
    return contents;
};
const deserializeAws_restJson1GetMeetingCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chime#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chime#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chime#NotFoundException":
            throw await deserializeAws_restJson1NotFoundExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chime#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chime#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chime#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chime#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1GetMessagingSessionEndpointCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return deserializeAws_restJson1GetMessagingSessionEndpointCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    if (data.Endpoint != null) {
        contents.Endpoint = deserializeAws_restJson1MessagingSessionEndpoint(data.Endpoint, context);
    }
    return contents;
};
const deserializeAws_restJson1GetMessagingSessionEndpointCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "ForbiddenException":
        case "com.amazonaws.chime#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chime#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chime#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chime#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chime#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1GetPhoneNumberCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return deserializeAws_restJson1GetPhoneNumberCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    if (data.PhoneNumber != null) {
        contents.PhoneNumber = deserializeAws_restJson1PhoneNumber(data.PhoneNumber, context);
    }
    return contents;
};
const deserializeAws_restJson1GetPhoneNumberCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chime#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chime#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chime#NotFoundException":
            throw await deserializeAws_restJson1NotFoundExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chime#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chime#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chime#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chime#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1GetPhoneNumberOrderCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return deserializeAws_restJson1GetPhoneNumberOrderCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    if (data.PhoneNumberOrder != null) {
        contents.PhoneNumberOrder = deserializeAws_restJson1PhoneNumberOrder(data.PhoneNumberOrder, context);
    }
    return contents;
};
const deserializeAws_restJson1GetPhoneNumberOrderCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chime#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chime#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chime#NotFoundException":
            throw await deserializeAws_restJson1NotFoundExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chime#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chime#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chime#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chime#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1GetPhoneNumberSettingsCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return deserializeAws_restJson1GetPhoneNumberSettingsCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    if (data.CallingName != null) {
        contents.CallingName = __expectString(data.CallingName);
    }
    if (data.CallingNameUpdatedTimestamp != null) {
        contents.CallingNameUpdatedTimestamp = __expectNonNull(__parseRfc3339DateTimeWithOffset(data.CallingNameUpdatedTimestamp));
    }
    return contents;
};
const deserializeAws_restJson1GetPhoneNumberSettingsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chime#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chime#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chime#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chime#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chime#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chime#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1GetProxySessionCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return deserializeAws_restJson1GetProxySessionCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    if (data.ProxySession != null) {
        contents.ProxySession = deserializeAws_restJson1ProxySession(data.ProxySession, context);
    }
    return contents;
};
const deserializeAws_restJson1GetProxySessionCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chime#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chime#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chime#NotFoundException":
            throw await deserializeAws_restJson1NotFoundExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chime#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chime#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chime#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chime#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1GetRetentionSettingsCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return deserializeAws_restJson1GetRetentionSettingsCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    if (data.InitiateDeletionTimestamp != null) {
        contents.InitiateDeletionTimestamp = __expectNonNull(__parseRfc3339DateTimeWithOffset(data.InitiateDeletionTimestamp));
    }
    if (data.RetentionSettings != null) {
        contents.RetentionSettings = deserializeAws_restJson1RetentionSettings(data.RetentionSettings, context);
    }
    return contents;
};
const deserializeAws_restJson1GetRetentionSettingsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chime#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chime#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chime#NotFoundException":
            throw await deserializeAws_restJson1NotFoundExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chime#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chime#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chime#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chime#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1GetRoomCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return deserializeAws_restJson1GetRoomCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    if (data.Room != null) {
        contents.Room = deserializeAws_restJson1Room(data.Room, context);
    }
    return contents;
};
const deserializeAws_restJson1GetRoomCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chime#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chime#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chime#NotFoundException":
            throw await deserializeAws_restJson1NotFoundExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chime#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chime#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chime#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chime#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1GetSipMediaApplicationCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return deserializeAws_restJson1GetSipMediaApplicationCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    if (data.SipMediaApplication != null) {
        contents.SipMediaApplication = deserializeAws_restJson1SipMediaApplication(data.SipMediaApplication, context);
    }
    return contents;
};
const deserializeAws_restJson1GetSipMediaApplicationCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chime#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chime#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chime#NotFoundException":
            throw await deserializeAws_restJson1NotFoundExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chime#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chime#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chime#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chime#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1GetSipMediaApplicationLoggingConfigurationCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return deserializeAws_restJson1GetSipMediaApplicationLoggingConfigurationCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    if (data.SipMediaApplicationLoggingConfiguration != null) {
        contents.SipMediaApplicationLoggingConfiguration = deserializeAws_restJson1SipMediaApplicationLoggingConfiguration(data.SipMediaApplicationLoggingConfiguration, context);
    }
    return contents;
};
const deserializeAws_restJson1GetSipMediaApplicationLoggingConfigurationCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chime#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chime#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chime#NotFoundException":
            throw await deserializeAws_restJson1NotFoundExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chime#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chime#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chime#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chime#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1GetSipRuleCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return deserializeAws_restJson1GetSipRuleCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    if (data.SipRule != null) {
        contents.SipRule = deserializeAws_restJson1SipRule(data.SipRule, context);
    }
    return contents;
};
const deserializeAws_restJson1GetSipRuleCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chime#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chime#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chime#NotFoundException":
            throw await deserializeAws_restJson1NotFoundExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chime#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chime#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chime#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chime#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1GetUserCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return deserializeAws_restJson1GetUserCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    if (data.User != null) {
        contents.User = deserializeAws_restJson1User(data.User, context);
    }
    return contents;
};
const deserializeAws_restJson1GetUserCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chime#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chime#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chime#NotFoundException":
            throw await deserializeAws_restJson1NotFoundExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chime#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chime#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chime#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chime#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1GetUserSettingsCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return deserializeAws_restJson1GetUserSettingsCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    if (data.UserSettings != null) {
        contents.UserSettings = deserializeAws_restJson1UserSettings(data.UserSettings, context);
    }
    return contents;
};
const deserializeAws_restJson1GetUserSettingsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chime#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chime#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chime#NotFoundException":
            throw await deserializeAws_restJson1NotFoundExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chime#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chime#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chime#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chime#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1GetVoiceConnectorCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return deserializeAws_restJson1GetVoiceConnectorCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    if (data.VoiceConnector != null) {
        contents.VoiceConnector = deserializeAws_restJson1VoiceConnector(data.VoiceConnector, context);
    }
    return contents;
};
const deserializeAws_restJson1GetVoiceConnectorCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chime#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chime#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chime#NotFoundException":
            throw await deserializeAws_restJson1NotFoundExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chime#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chime#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chime#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chime#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1GetVoiceConnectorEmergencyCallingConfigurationCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return deserializeAws_restJson1GetVoiceConnectorEmergencyCallingConfigurationCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    if (data.EmergencyCallingConfiguration != null) {
        contents.EmergencyCallingConfiguration = deserializeAws_restJson1EmergencyCallingConfiguration(data.EmergencyCallingConfiguration, context);
    }
    return contents;
};
const deserializeAws_restJson1GetVoiceConnectorEmergencyCallingConfigurationCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chime#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chime#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chime#NotFoundException":
            throw await deserializeAws_restJson1NotFoundExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chime#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chime#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chime#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chime#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1GetVoiceConnectorGroupCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return deserializeAws_restJson1GetVoiceConnectorGroupCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    if (data.VoiceConnectorGroup != null) {
        contents.VoiceConnectorGroup = deserializeAws_restJson1VoiceConnectorGroup(data.VoiceConnectorGroup, context);
    }
    return contents;
};
const deserializeAws_restJson1GetVoiceConnectorGroupCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chime#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chime#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chime#NotFoundException":
            throw await deserializeAws_restJson1NotFoundExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chime#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chime#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chime#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chime#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1GetVoiceConnectorLoggingConfigurationCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return deserializeAws_restJson1GetVoiceConnectorLoggingConfigurationCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    if (data.LoggingConfiguration != null) {
        contents.LoggingConfiguration = deserializeAws_restJson1LoggingConfiguration(data.LoggingConfiguration, context);
    }
    return contents;
};
const deserializeAws_restJson1GetVoiceConnectorLoggingConfigurationCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chime#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chime#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chime#NotFoundException":
            throw await deserializeAws_restJson1NotFoundExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chime#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chime#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chime#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chime#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1GetVoiceConnectorOriginationCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return deserializeAws_restJson1GetVoiceConnectorOriginationCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    if (data.Origination != null) {
        contents.Origination = deserializeAws_restJson1Origination(data.Origination, context);
    }
    return contents;
};
const deserializeAws_restJson1GetVoiceConnectorOriginationCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chime#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chime#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chime#NotFoundException":
            throw await deserializeAws_restJson1NotFoundExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chime#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chime#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chime#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chime#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1GetVoiceConnectorProxyCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return deserializeAws_restJson1GetVoiceConnectorProxyCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    if (data.Proxy != null) {
        contents.Proxy = deserializeAws_restJson1Proxy(data.Proxy, context);
    }
    return contents;
};
const deserializeAws_restJson1GetVoiceConnectorProxyCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chime#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chime#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chime#NotFoundException":
            throw await deserializeAws_restJson1NotFoundExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chime#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chime#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chime#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chime#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1GetVoiceConnectorStreamingConfigurationCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return deserializeAws_restJson1GetVoiceConnectorStreamingConfigurationCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    if (data.StreamingConfiguration != null) {
        contents.StreamingConfiguration = deserializeAws_restJson1StreamingConfiguration(data.StreamingConfiguration, context);
    }
    return contents;
};
const deserializeAws_restJson1GetVoiceConnectorStreamingConfigurationCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chime#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chime#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chime#NotFoundException":
            throw await deserializeAws_restJson1NotFoundExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chime#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chime#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chime#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chime#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1GetVoiceConnectorTerminationCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return deserializeAws_restJson1GetVoiceConnectorTerminationCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    if (data.Termination != null) {
        contents.Termination = deserializeAws_restJson1Termination(data.Termination, context);
    }
    return contents;
};
const deserializeAws_restJson1GetVoiceConnectorTerminationCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chime#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chime#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chime#NotFoundException":
            throw await deserializeAws_restJson1NotFoundExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chime#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chime#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chime#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chime#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1GetVoiceConnectorTerminationHealthCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return deserializeAws_restJson1GetVoiceConnectorTerminationHealthCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    if (data.TerminationHealth != null) {
        contents.TerminationHealth = deserializeAws_restJson1TerminationHealth(data.TerminationHealth, context);
    }
    return contents;
};
const deserializeAws_restJson1GetVoiceConnectorTerminationHealthCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chime#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chime#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chime#NotFoundException":
            throw await deserializeAws_restJson1NotFoundExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chime#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chime#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chime#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chime#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1InviteUsersCommand = async (output, context) => {
    if (output.statusCode !== 201 && output.statusCode >= 300) {
        return deserializeAws_restJson1InviteUsersCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    if (data.Invites != null) {
        contents.Invites = deserializeAws_restJson1InviteList(data.Invites, context);
    }
    return contents;
};
const deserializeAws_restJson1InviteUsersCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chime#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chime#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chime#NotFoundException":
            throw await deserializeAws_restJson1NotFoundExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chime#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chime#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chime#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chime#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1ListAccountsCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return deserializeAws_restJson1ListAccountsCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    if (data.Accounts != null) {
        contents.Accounts = deserializeAws_restJson1AccountList(data.Accounts, context);
    }
    if (data.NextToken != null) {
        contents.NextToken = __expectString(data.NextToken);
    }
    return contents;
};
const deserializeAws_restJson1ListAccountsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chime#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chime#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chime#NotFoundException":
            throw await deserializeAws_restJson1NotFoundExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chime#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chime#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chime#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chime#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1ListAppInstanceAdminsCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return deserializeAws_restJson1ListAppInstanceAdminsCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    if (data.AppInstanceAdmins != null) {
        contents.AppInstanceAdmins = deserializeAws_restJson1AppInstanceAdminList(data.AppInstanceAdmins, context);
    }
    if (data.AppInstanceArn != null) {
        contents.AppInstanceArn = __expectString(data.AppInstanceArn);
    }
    if (data.NextToken != null) {
        contents.NextToken = __expectString(data.NextToken);
    }
    return contents;
};
const deserializeAws_restJson1ListAppInstanceAdminsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chime#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chime#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chime#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chime#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chime#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chime#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1ListAppInstancesCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return deserializeAws_restJson1ListAppInstancesCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    if (data.AppInstances != null) {
        contents.AppInstances = deserializeAws_restJson1AppInstanceList(data.AppInstances, context);
    }
    if (data.NextToken != null) {
        contents.NextToken = __expectString(data.NextToken);
    }
    return contents;
};
const deserializeAws_restJson1ListAppInstancesCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chime#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chime#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chime#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chime#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chime#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chime#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1ListAppInstanceUsersCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return deserializeAws_restJson1ListAppInstanceUsersCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    if (data.AppInstanceArn != null) {
        contents.AppInstanceArn = __expectString(data.AppInstanceArn);
    }
    if (data.AppInstanceUsers != null) {
        contents.AppInstanceUsers = deserializeAws_restJson1AppInstanceUserList(data.AppInstanceUsers, context);
    }
    if (data.NextToken != null) {
        contents.NextToken = __expectString(data.NextToken);
    }
    return contents;
};
const deserializeAws_restJson1ListAppInstanceUsersCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chime#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chime#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chime#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chime#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chime#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chime#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1ListAttendeesCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return deserializeAws_restJson1ListAttendeesCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    if (data.Attendees != null) {
        contents.Attendees = deserializeAws_restJson1AttendeeList(data.Attendees, context);
    }
    if (data.NextToken != null) {
        contents.NextToken = __expectString(data.NextToken);
    }
    return contents;
};
const deserializeAws_restJson1ListAttendeesCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chime#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chime#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chime#NotFoundException":
            throw await deserializeAws_restJson1NotFoundExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chime#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chime#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chime#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chime#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1ListAttendeeTagsCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return deserializeAws_restJson1ListAttendeeTagsCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    if (data.Tags != null) {
        contents.Tags = deserializeAws_restJson1TagList(data.Tags, context);
    }
    return contents;
};
const deserializeAws_restJson1ListAttendeeTagsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chime#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chime#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chime#NotFoundException":
            throw await deserializeAws_restJson1NotFoundExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chime#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chime#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chime#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chime#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1ListBotsCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return deserializeAws_restJson1ListBotsCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    if (data.Bots != null) {
        contents.Bots = deserializeAws_restJson1BotList(data.Bots, context);
    }
    if (data.NextToken != null) {
        contents.NextToken = __expectString(data.NextToken);
    }
    return contents;
};
const deserializeAws_restJson1ListBotsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chime#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chime#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chime#NotFoundException":
            throw await deserializeAws_restJson1NotFoundExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chime#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chime#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chime#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chime#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1ListChannelBansCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return deserializeAws_restJson1ListChannelBansCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    if (data.ChannelArn != null) {
        contents.ChannelArn = __expectString(data.ChannelArn);
    }
    if (data.ChannelBans != null) {
        contents.ChannelBans = deserializeAws_restJson1ChannelBanSummaryList(data.ChannelBans, context);
    }
    if (data.NextToken != null) {
        contents.NextToken = __expectString(data.NextToken);
    }
    return contents;
};
const deserializeAws_restJson1ListChannelBansCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chime#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chime#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chime#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chime#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chime#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chime#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1ListChannelMembershipsCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return deserializeAws_restJson1ListChannelMembershipsCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    if (data.ChannelArn != null) {
        contents.ChannelArn = __expectString(data.ChannelArn);
    }
    if (data.ChannelMemberships != null) {
        contents.ChannelMemberships = deserializeAws_restJson1ChannelMembershipSummaryList(data.ChannelMemberships, context);
    }
    if (data.NextToken != null) {
        contents.NextToken = __expectString(data.NextToken);
    }
    return contents;
};
const deserializeAws_restJson1ListChannelMembershipsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chime#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chime#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chime#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chime#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chime#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chime#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1ListChannelMembershipsForAppInstanceUserCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return deserializeAws_restJson1ListChannelMembershipsForAppInstanceUserCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    if (data.ChannelMemberships != null) {
        contents.ChannelMemberships = deserializeAws_restJson1ChannelMembershipForAppInstanceUserSummaryList(data.ChannelMemberships, context);
    }
    if (data.NextToken != null) {
        contents.NextToken = __expectString(data.NextToken);
    }
    return contents;
};
const deserializeAws_restJson1ListChannelMembershipsForAppInstanceUserCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chime#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chime#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chime#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chime#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chime#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chime#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1ListChannelMessagesCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return deserializeAws_restJson1ListChannelMessagesCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    if (data.ChannelArn != null) {
        contents.ChannelArn = __expectString(data.ChannelArn);
    }
    if (data.ChannelMessages != null) {
        contents.ChannelMessages = deserializeAws_restJson1ChannelMessageSummaryList(data.ChannelMessages, context);
    }
    if (data.NextToken != null) {
        contents.NextToken = __expectString(data.NextToken);
    }
    return contents;
};
const deserializeAws_restJson1ListChannelMessagesCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chime#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chime#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chime#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chime#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chime#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chime#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1ListChannelModeratorsCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return deserializeAws_restJson1ListChannelModeratorsCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    if (data.ChannelArn != null) {
        contents.ChannelArn = __expectString(data.ChannelArn);
    }
    if (data.ChannelModerators != null) {
        contents.ChannelModerators = deserializeAws_restJson1ChannelModeratorSummaryList(data.ChannelModerators, context);
    }
    if (data.NextToken != null) {
        contents.NextToken = __expectString(data.NextToken);
    }
    return contents;
};
const deserializeAws_restJson1ListChannelModeratorsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chime#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chime#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chime#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chime#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chime#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chime#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1ListChannelsCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return deserializeAws_restJson1ListChannelsCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    if (data.Channels != null) {
        contents.Channels = deserializeAws_restJson1ChannelSummaryList(data.Channels, context);
    }
    if (data.NextToken != null) {
        contents.NextToken = __expectString(data.NextToken);
    }
    return contents;
};
const deserializeAws_restJson1ListChannelsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chime#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chime#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chime#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chime#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chime#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chime#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1ListChannelsModeratedByAppInstanceUserCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return deserializeAws_restJson1ListChannelsModeratedByAppInstanceUserCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    if (data.Channels != null) {
        contents.Channels = deserializeAws_restJson1ChannelModeratedByAppInstanceUserSummaryList(data.Channels, context);
    }
    if (data.NextToken != null) {
        contents.NextToken = __expectString(data.NextToken);
    }
    return contents;
};
const deserializeAws_restJson1ListChannelsModeratedByAppInstanceUserCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chime#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chime#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chime#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chime#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chime#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chime#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1ListMediaCapturePipelinesCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return deserializeAws_restJson1ListMediaCapturePipelinesCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    if (data.MediaCapturePipelines != null) {
        contents.MediaCapturePipelines = deserializeAws_restJson1MediaCapturePipelineList(data.MediaCapturePipelines, context);
    }
    if (data.NextToken != null) {
        contents.NextToken = __expectString(data.NextToken);
    }
    return contents;
};
const deserializeAws_restJson1ListMediaCapturePipelinesCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chime#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chime#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chime#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chime#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chime#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chime#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1ListMeetingsCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return deserializeAws_restJson1ListMeetingsCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    if (data.Meetings != null) {
        contents.Meetings = deserializeAws_restJson1MeetingList(data.Meetings, context);
    }
    if (data.NextToken != null) {
        contents.NextToken = __expectString(data.NextToken);
    }
    return contents;
};
const deserializeAws_restJson1ListMeetingsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chime#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chime#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chime#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chime#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chime#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chime#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1ListMeetingTagsCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return deserializeAws_restJson1ListMeetingTagsCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    if (data.Tags != null) {
        contents.Tags = deserializeAws_restJson1TagList(data.Tags, context);
    }
    return contents;
};
const deserializeAws_restJson1ListMeetingTagsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chime#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chime#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chime#NotFoundException":
            throw await deserializeAws_restJson1NotFoundExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chime#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chime#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chime#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chime#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1ListPhoneNumberOrdersCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return deserializeAws_restJson1ListPhoneNumberOrdersCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    if (data.NextToken != null) {
        contents.NextToken = __expectString(data.NextToken);
    }
    if (data.PhoneNumberOrders != null) {
        contents.PhoneNumberOrders = deserializeAws_restJson1PhoneNumberOrderList(data.PhoneNumberOrders, context);
    }
    return contents;
};
const deserializeAws_restJson1ListPhoneNumberOrdersCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chime#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chime#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chime#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chime#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chime#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chime#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1ListPhoneNumbersCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return deserializeAws_restJson1ListPhoneNumbersCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    if (data.NextToken != null) {
        contents.NextToken = __expectString(data.NextToken);
    }
    if (data.PhoneNumbers != null) {
        contents.PhoneNumbers = deserializeAws_restJson1PhoneNumberList(data.PhoneNumbers, context);
    }
    return contents;
};
const deserializeAws_restJson1ListPhoneNumbersCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chime#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chime#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chime#NotFoundException":
            throw await deserializeAws_restJson1NotFoundExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chime#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chime#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chime#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chime#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1ListProxySessionsCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return deserializeAws_restJson1ListProxySessionsCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    if (data.NextToken != null) {
        contents.NextToken = __expectString(data.NextToken);
    }
    if (data.ProxySessions != null) {
        contents.ProxySessions = deserializeAws_restJson1ProxySessions(data.ProxySessions, context);
    }
    return contents;
};
const deserializeAws_restJson1ListProxySessionsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chime#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chime#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chime#NotFoundException":
            throw await deserializeAws_restJson1NotFoundExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chime#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chime#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chime#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chime#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1ListRoomMembershipsCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return deserializeAws_restJson1ListRoomMembershipsCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    if (data.NextToken != null) {
        contents.NextToken = __expectString(data.NextToken);
    }
    if (data.RoomMemberships != null) {
        contents.RoomMemberships = deserializeAws_restJson1RoomMembershipList(data.RoomMemberships, context);
    }
    return contents;
};
const deserializeAws_restJson1ListRoomMembershipsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chime#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chime#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chime#NotFoundException":
            throw await deserializeAws_restJson1NotFoundExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chime#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chime#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chime#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chime#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1ListRoomsCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return deserializeAws_restJson1ListRoomsCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    if (data.NextToken != null) {
        contents.NextToken = __expectString(data.NextToken);
    }
    if (data.Rooms != null) {
        contents.Rooms = deserializeAws_restJson1RoomList(data.Rooms, context);
    }
    return contents;
};
const deserializeAws_restJson1ListRoomsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chime#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chime#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chime#NotFoundException":
            throw await deserializeAws_restJson1NotFoundExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chime#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chime#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chime#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chime#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1ListSipMediaApplicationsCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return deserializeAws_restJson1ListSipMediaApplicationsCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    if (data.NextToken != null) {
        contents.NextToken = __expectString(data.NextToken);
    }
    if (data.SipMediaApplications != null) {
        contents.SipMediaApplications = deserializeAws_restJson1SipMediaApplicationList(data.SipMediaApplications, context);
    }
    return contents;
};
const deserializeAws_restJson1ListSipMediaApplicationsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chime#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chime#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chime#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chime#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chime#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chime#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1ListSipRulesCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return deserializeAws_restJson1ListSipRulesCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    if (data.NextToken != null) {
        contents.NextToken = __expectString(data.NextToken);
    }
    if (data.SipRules != null) {
        contents.SipRules = deserializeAws_restJson1SipRuleList(data.SipRules, context);
    }
    return contents;
};
const deserializeAws_restJson1ListSipRulesCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chime#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chime#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chime#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chime#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chime#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chime#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1ListSupportedPhoneNumberCountriesCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return deserializeAws_restJson1ListSupportedPhoneNumberCountriesCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    if (data.PhoneNumberCountries != null) {
        contents.PhoneNumberCountries = deserializeAws_restJson1PhoneNumberCountriesList(data.PhoneNumberCountries, context);
    }
    return contents;
};
const deserializeAws_restJson1ListSupportedPhoneNumberCountriesCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "AccessDeniedException":
        case "com.amazonaws.chime#AccessDeniedException":
            throw await deserializeAws_restJson1AccessDeniedExceptionResponse(parsedOutput, context);
        case "BadRequestException":
        case "com.amazonaws.chime#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chime#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chime#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chime#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chime#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chime#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1ListTagsForResourceCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return deserializeAws_restJson1ListTagsForResourceCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    if (data.Tags != null) {
        contents.Tags = deserializeAws_restJson1TagList(data.Tags, context);
    }
    return contents;
};
const deserializeAws_restJson1ListTagsForResourceCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chime#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chime#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chime#NotFoundException":
            throw await deserializeAws_restJson1NotFoundExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chime#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chime#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chime#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1ListUsersCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return deserializeAws_restJson1ListUsersCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    if (data.NextToken != null) {
        contents.NextToken = __expectString(data.NextToken);
    }
    if (data.Users != null) {
        contents.Users = deserializeAws_restJson1UserList(data.Users, context);
    }
    return contents;
};
const deserializeAws_restJson1ListUsersCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chime#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chime#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chime#NotFoundException":
            throw await deserializeAws_restJson1NotFoundExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chime#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chime#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chime#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chime#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1ListVoiceConnectorGroupsCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return deserializeAws_restJson1ListVoiceConnectorGroupsCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    if (data.NextToken != null) {
        contents.NextToken = __expectString(data.NextToken);
    }
    if (data.VoiceConnectorGroups != null) {
        contents.VoiceConnectorGroups = deserializeAws_restJson1VoiceConnectorGroupList(data.VoiceConnectorGroups, context);
    }
    return contents;
};
const deserializeAws_restJson1ListVoiceConnectorGroupsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chime#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chime#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chime#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chime#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chime#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chime#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1ListVoiceConnectorsCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return deserializeAws_restJson1ListVoiceConnectorsCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    if (data.NextToken != null) {
        contents.NextToken = __expectString(data.NextToken);
    }
    if (data.VoiceConnectors != null) {
        contents.VoiceConnectors = deserializeAws_restJson1VoiceConnectorList(data.VoiceConnectors, context);
    }
    return contents;
};
const deserializeAws_restJson1ListVoiceConnectorsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chime#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chime#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chime#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chime#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chime#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chime#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1ListVoiceConnectorTerminationCredentialsCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return deserializeAws_restJson1ListVoiceConnectorTerminationCredentialsCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    if (data.Usernames != null) {
        contents.Usernames = deserializeAws_restJson1SensitiveStringList(data.Usernames, context);
    }
    return contents;
};
const deserializeAws_restJson1ListVoiceConnectorTerminationCredentialsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chime#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chime#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chime#NotFoundException":
            throw await deserializeAws_restJson1NotFoundExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chime#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chime#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chime#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chime#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1LogoutUserCommand = async (output, context) => {
    if (output.statusCode !== 204 && output.statusCode >= 300) {
        return deserializeAws_restJson1LogoutUserCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    await collectBody(output.body, context);
    return contents;
};
const deserializeAws_restJson1LogoutUserCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chime#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chime#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chime#NotFoundException":
            throw await deserializeAws_restJson1NotFoundExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chime#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chime#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chime#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chime#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1PutAppInstanceRetentionSettingsCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return deserializeAws_restJson1PutAppInstanceRetentionSettingsCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    if (data.AppInstanceRetentionSettings != null) {
        contents.AppInstanceRetentionSettings = deserializeAws_restJson1AppInstanceRetentionSettings(data.AppInstanceRetentionSettings, context);
    }
    if (data.InitiateDeletionTimestamp != null) {
        contents.InitiateDeletionTimestamp = __expectNonNull(__parseEpochTimestamp(__expectNumber(data.InitiateDeletionTimestamp)));
    }
    return contents;
};
const deserializeAws_restJson1PutAppInstanceRetentionSettingsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chime#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ConflictException":
        case "com.amazonaws.chime#ConflictException":
            throw await deserializeAws_restJson1ConflictExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chime#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chime#NotFoundException":
            throw await deserializeAws_restJson1NotFoundExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chime#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chime#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chime#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chime#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1PutAppInstanceStreamingConfigurationsCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return deserializeAws_restJson1PutAppInstanceStreamingConfigurationsCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    if (data.AppInstanceStreamingConfigurations != null) {
        contents.AppInstanceStreamingConfigurations = deserializeAws_restJson1AppInstanceStreamingConfigurationList(data.AppInstanceStreamingConfigurations, context);
    }
    return contents;
};
const deserializeAws_restJson1PutAppInstanceStreamingConfigurationsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chime#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chime#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chime#NotFoundException":
            throw await deserializeAws_restJson1NotFoundExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chime#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chime#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chime#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chime#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1PutEventsConfigurationCommand = async (output, context) => {
    if (output.statusCode !== 201 && output.statusCode >= 300) {
        return deserializeAws_restJson1PutEventsConfigurationCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    if (data.EventsConfiguration != null) {
        contents.EventsConfiguration = deserializeAws_restJson1EventsConfiguration(data.EventsConfiguration, context);
    }
    return contents;
};
const deserializeAws_restJson1PutEventsConfigurationCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chime#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chime#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chime#NotFoundException":
            throw await deserializeAws_restJson1NotFoundExceptionResponse(parsedOutput, context);
        case "ResourceLimitExceededException":
        case "com.amazonaws.chime#ResourceLimitExceededException":
            throw await deserializeAws_restJson1ResourceLimitExceededExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chime#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chime#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chime#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1PutRetentionSettingsCommand = async (output, context) => {
    if (output.statusCode !== 204 && output.statusCode >= 300) {
        return deserializeAws_restJson1PutRetentionSettingsCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    if (data.InitiateDeletionTimestamp != null) {
        contents.InitiateDeletionTimestamp = __expectNonNull(__parseRfc3339DateTimeWithOffset(data.InitiateDeletionTimestamp));
    }
    if (data.RetentionSettings != null) {
        contents.RetentionSettings = deserializeAws_restJson1RetentionSettings(data.RetentionSettings, context);
    }
    return contents;
};
const deserializeAws_restJson1PutRetentionSettingsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chime#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ConflictException":
        case "com.amazonaws.chime#ConflictException":
            throw await deserializeAws_restJson1ConflictExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chime#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chime#NotFoundException":
            throw await deserializeAws_restJson1NotFoundExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chime#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chime#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chime#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chime#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1PutSipMediaApplicationLoggingConfigurationCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return deserializeAws_restJson1PutSipMediaApplicationLoggingConfigurationCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    if (data.SipMediaApplicationLoggingConfiguration != null) {
        contents.SipMediaApplicationLoggingConfiguration = deserializeAws_restJson1SipMediaApplicationLoggingConfiguration(data.SipMediaApplicationLoggingConfiguration, context);
    }
    return contents;
};
const deserializeAws_restJson1PutSipMediaApplicationLoggingConfigurationCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chime#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chime#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chime#NotFoundException":
            throw await deserializeAws_restJson1NotFoundExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chime#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chime#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chime#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chime#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1PutVoiceConnectorEmergencyCallingConfigurationCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return deserializeAws_restJson1PutVoiceConnectorEmergencyCallingConfigurationCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    if (data.EmergencyCallingConfiguration != null) {
        contents.EmergencyCallingConfiguration = deserializeAws_restJson1EmergencyCallingConfiguration(data.EmergencyCallingConfiguration, context);
    }
    return contents;
};
const deserializeAws_restJson1PutVoiceConnectorEmergencyCallingConfigurationCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chime#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chime#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chime#NotFoundException":
            throw await deserializeAws_restJson1NotFoundExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chime#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chime#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chime#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chime#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1PutVoiceConnectorLoggingConfigurationCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return deserializeAws_restJson1PutVoiceConnectorLoggingConfigurationCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    if (data.LoggingConfiguration != null) {
        contents.LoggingConfiguration = deserializeAws_restJson1LoggingConfiguration(data.LoggingConfiguration, context);
    }
    return contents;
};
const deserializeAws_restJson1PutVoiceConnectorLoggingConfigurationCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chime#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chime#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chime#NotFoundException":
            throw await deserializeAws_restJson1NotFoundExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chime#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chime#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chime#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chime#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1PutVoiceConnectorOriginationCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return deserializeAws_restJson1PutVoiceConnectorOriginationCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    if (data.Origination != null) {
        contents.Origination = deserializeAws_restJson1Origination(data.Origination, context);
    }
    return contents;
};
const deserializeAws_restJson1PutVoiceConnectorOriginationCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chime#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chime#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chime#NotFoundException":
            throw await deserializeAws_restJson1NotFoundExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chime#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chime#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chime#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chime#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1PutVoiceConnectorProxyCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return deserializeAws_restJson1PutVoiceConnectorProxyCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    if (data.Proxy != null) {
        contents.Proxy = deserializeAws_restJson1Proxy(data.Proxy, context);
    }
    return contents;
};
const deserializeAws_restJson1PutVoiceConnectorProxyCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "AccessDeniedException":
        case "com.amazonaws.chime#AccessDeniedException":
            throw await deserializeAws_restJson1AccessDeniedExceptionResponse(parsedOutput, context);
        case "BadRequestException":
        case "com.amazonaws.chime#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chime#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chime#NotFoundException":
            throw await deserializeAws_restJson1NotFoundExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chime#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chime#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chime#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chime#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1PutVoiceConnectorStreamingConfigurationCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return deserializeAws_restJson1PutVoiceConnectorStreamingConfigurationCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    if (data.StreamingConfiguration != null) {
        contents.StreamingConfiguration = deserializeAws_restJson1StreamingConfiguration(data.StreamingConfiguration, context);
    }
    return contents;
};
const deserializeAws_restJson1PutVoiceConnectorStreamingConfigurationCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chime#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chime#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chime#NotFoundException":
            throw await deserializeAws_restJson1NotFoundExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chime#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chime#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chime#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chime#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1PutVoiceConnectorTerminationCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return deserializeAws_restJson1PutVoiceConnectorTerminationCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    if (data.Termination != null) {
        contents.Termination = deserializeAws_restJson1Termination(data.Termination, context);
    }
    return contents;
};
const deserializeAws_restJson1PutVoiceConnectorTerminationCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "AccessDeniedException":
        case "com.amazonaws.chime#AccessDeniedException":
            throw await deserializeAws_restJson1AccessDeniedExceptionResponse(parsedOutput, context);
        case "BadRequestException":
        case "com.amazonaws.chime#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chime#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chime#NotFoundException":
            throw await deserializeAws_restJson1NotFoundExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chime#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chime#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chime#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chime#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1PutVoiceConnectorTerminationCredentialsCommand = async (output, context) => {
    if (output.statusCode !== 204 && output.statusCode >= 300) {
        return deserializeAws_restJson1PutVoiceConnectorTerminationCredentialsCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    await collectBody(output.body, context);
    return contents;
};
const deserializeAws_restJson1PutVoiceConnectorTerminationCredentialsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chime#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chime#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chime#NotFoundException":
            throw await deserializeAws_restJson1NotFoundExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chime#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chime#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chime#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chime#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1RedactChannelMessageCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return deserializeAws_restJson1RedactChannelMessageCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    if (data.ChannelArn != null) {
        contents.ChannelArn = __expectString(data.ChannelArn);
    }
    if (data.MessageId != null) {
        contents.MessageId = __expectString(data.MessageId);
    }
    return contents;
};
const deserializeAws_restJson1RedactChannelMessageCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chime#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chime#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chime#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chime#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chime#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chime#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1RedactConversationMessageCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return deserializeAws_restJson1RedactConversationMessageCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    await collectBody(output.body, context);
    return contents;
};
const deserializeAws_restJson1RedactConversationMessageCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chime#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chime#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chime#NotFoundException":
            throw await deserializeAws_restJson1NotFoundExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chime#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chime#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chime#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chime#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1RedactRoomMessageCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return deserializeAws_restJson1RedactRoomMessageCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    await collectBody(output.body, context);
    return contents;
};
const deserializeAws_restJson1RedactRoomMessageCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chime#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chime#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chime#NotFoundException":
            throw await deserializeAws_restJson1NotFoundExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chime#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chime#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chime#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chime#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1RegenerateSecurityTokenCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return deserializeAws_restJson1RegenerateSecurityTokenCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    if (data.Bot != null) {
        contents.Bot = deserializeAws_restJson1Bot(data.Bot, context);
    }
    return contents;
};
const deserializeAws_restJson1RegenerateSecurityTokenCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chime#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chime#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chime#NotFoundException":
            throw await deserializeAws_restJson1NotFoundExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chime#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chime#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chime#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chime#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1ResetPersonalPINCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return deserializeAws_restJson1ResetPersonalPINCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    if (data.User != null) {
        contents.User = deserializeAws_restJson1User(data.User, context);
    }
    return contents;
};
const deserializeAws_restJson1ResetPersonalPINCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chime#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chime#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chime#NotFoundException":
            throw await deserializeAws_restJson1NotFoundExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chime#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chime#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chime#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chime#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1RestorePhoneNumberCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return deserializeAws_restJson1RestorePhoneNumberCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    if (data.PhoneNumber != null) {
        contents.PhoneNumber = deserializeAws_restJson1PhoneNumber(data.PhoneNumber, context);
    }
    return contents;
};
const deserializeAws_restJson1RestorePhoneNumberCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chime#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chime#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chime#NotFoundException":
            throw await deserializeAws_restJson1NotFoundExceptionResponse(parsedOutput, context);
        case "ResourceLimitExceededException":
        case "com.amazonaws.chime#ResourceLimitExceededException":
            throw await deserializeAws_restJson1ResourceLimitExceededExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chime#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chime#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chime#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chime#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1SearchAvailablePhoneNumbersCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return deserializeAws_restJson1SearchAvailablePhoneNumbersCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    if (data.E164PhoneNumbers != null) {
        contents.E164PhoneNumbers = deserializeAws_restJson1E164PhoneNumberList(data.E164PhoneNumbers, context);
    }
    if (data.NextToken != null) {
        contents.NextToken = __expectString(data.NextToken);
    }
    return contents;
};
const deserializeAws_restJson1SearchAvailablePhoneNumbersCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "AccessDeniedException":
        case "com.amazonaws.chime#AccessDeniedException":
            throw await deserializeAws_restJson1AccessDeniedExceptionResponse(parsedOutput, context);
        case "BadRequestException":
        case "com.amazonaws.chime#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chime#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chime#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chime#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chime#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chime#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1SendChannelMessageCommand = async (output, context) => {
    if (output.statusCode !== 201 && output.statusCode >= 300) {
        return deserializeAws_restJson1SendChannelMessageCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    if (data.ChannelArn != null) {
        contents.ChannelArn = __expectString(data.ChannelArn);
    }
    if (data.MessageId != null) {
        contents.MessageId = __expectString(data.MessageId);
    }
    return contents;
};
const deserializeAws_restJson1SendChannelMessageCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chime#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ConflictException":
        case "com.amazonaws.chime#ConflictException":
            throw await deserializeAws_restJson1ConflictExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chime#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chime#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chime#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chime#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chime#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1StartMeetingTranscriptionCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return deserializeAws_restJson1StartMeetingTranscriptionCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    await collectBody(output.body, context);
    return contents;
};
const deserializeAws_restJson1StartMeetingTranscriptionCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chime#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chime#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chime#NotFoundException":
            throw await deserializeAws_restJson1NotFoundExceptionResponse(parsedOutput, context);
        case "ResourceLimitExceededException":
        case "com.amazonaws.chime#ResourceLimitExceededException":
            throw await deserializeAws_restJson1ResourceLimitExceededExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chime#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chime#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chime#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chime#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        case "UnprocessableEntityException":
        case "com.amazonaws.chime#UnprocessableEntityException":
            throw await deserializeAws_restJson1UnprocessableEntityExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1StopMeetingTranscriptionCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return deserializeAws_restJson1StopMeetingTranscriptionCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    await collectBody(output.body, context);
    return contents;
};
const deserializeAws_restJson1StopMeetingTranscriptionCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chime#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chime#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chime#NotFoundException":
            throw await deserializeAws_restJson1NotFoundExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chime#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chime#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chime#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chime#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        case "UnprocessableEntityException":
        case "com.amazonaws.chime#UnprocessableEntityException":
            throw await deserializeAws_restJson1UnprocessableEntityExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1TagAttendeeCommand = async (output, context) => {
    if (output.statusCode !== 204 && output.statusCode >= 300) {
        return deserializeAws_restJson1TagAttendeeCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    await collectBody(output.body, context);
    return contents;
};
const deserializeAws_restJson1TagAttendeeCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chime#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chime#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chime#NotFoundException":
            throw await deserializeAws_restJson1NotFoundExceptionResponse(parsedOutput, context);
        case "ResourceLimitExceededException":
        case "com.amazonaws.chime#ResourceLimitExceededException":
            throw await deserializeAws_restJson1ResourceLimitExceededExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chime#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chime#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chime#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chime#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1TagMeetingCommand = async (output, context) => {
    if (output.statusCode !== 204 && output.statusCode >= 300) {
        return deserializeAws_restJson1TagMeetingCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    await collectBody(output.body, context);
    return contents;
};
const deserializeAws_restJson1TagMeetingCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chime#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chime#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chime#NotFoundException":
            throw await deserializeAws_restJson1NotFoundExceptionResponse(parsedOutput, context);
        case "ResourceLimitExceededException":
        case "com.amazonaws.chime#ResourceLimitExceededException":
            throw await deserializeAws_restJson1ResourceLimitExceededExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chime#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chime#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chime#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chime#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1TagResourceCommand = async (output, context) => {
    if (output.statusCode !== 204 && output.statusCode >= 300) {
        return deserializeAws_restJson1TagResourceCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    await collectBody(output.body, context);
    return contents;
};
const deserializeAws_restJson1TagResourceCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chime#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chime#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chime#NotFoundException":
            throw await deserializeAws_restJson1NotFoundExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chime#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chime#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chime#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1UntagAttendeeCommand = async (output, context) => {
    if (output.statusCode !== 204 && output.statusCode >= 300) {
        return deserializeAws_restJson1UntagAttendeeCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    await collectBody(output.body, context);
    return contents;
};
const deserializeAws_restJson1UntagAttendeeCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chime#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chime#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chime#NotFoundException":
            throw await deserializeAws_restJson1NotFoundExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chime#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chime#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chime#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chime#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1UntagMeetingCommand = async (output, context) => {
    if (output.statusCode !== 204 && output.statusCode >= 300) {
        return deserializeAws_restJson1UntagMeetingCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    await collectBody(output.body, context);
    return contents;
};
const deserializeAws_restJson1UntagMeetingCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chime#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chime#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chime#NotFoundException":
            throw await deserializeAws_restJson1NotFoundExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chime#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chime#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chime#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chime#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1UntagResourceCommand = async (output, context) => {
    if (output.statusCode !== 204 && output.statusCode >= 300) {
        return deserializeAws_restJson1UntagResourceCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    await collectBody(output.body, context);
    return contents;
};
const deserializeAws_restJson1UntagResourceCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chime#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chime#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chime#NotFoundException":
            throw await deserializeAws_restJson1NotFoundExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chime#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chime#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chime#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1UpdateAccountCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return deserializeAws_restJson1UpdateAccountCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    if (data.Account != null) {
        contents.Account = deserializeAws_restJson1Account(data.Account, context);
    }
    return contents;
};
const deserializeAws_restJson1UpdateAccountCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chime#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chime#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chime#NotFoundException":
            throw await deserializeAws_restJson1NotFoundExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chime#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chime#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chime#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chime#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1UpdateAccountSettingsCommand = async (output, context) => {
    if (output.statusCode !== 204 && output.statusCode >= 300) {
        return deserializeAws_restJson1UpdateAccountSettingsCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    await collectBody(output.body, context);
    return contents;
};
const deserializeAws_restJson1UpdateAccountSettingsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chime#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ConflictException":
        case "com.amazonaws.chime#ConflictException":
            throw await deserializeAws_restJson1ConflictExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chime#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chime#NotFoundException":
            throw await deserializeAws_restJson1NotFoundExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chime#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chime#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chime#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chime#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1UpdateAppInstanceCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return deserializeAws_restJson1UpdateAppInstanceCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    if (data.AppInstanceArn != null) {
        contents.AppInstanceArn = __expectString(data.AppInstanceArn);
    }
    return contents;
};
const deserializeAws_restJson1UpdateAppInstanceCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chime#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ConflictException":
        case "com.amazonaws.chime#ConflictException":
            throw await deserializeAws_restJson1ConflictExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chime#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chime#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chime#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chime#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chime#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1UpdateAppInstanceUserCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return deserializeAws_restJson1UpdateAppInstanceUserCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    if (data.AppInstanceUserArn != null) {
        contents.AppInstanceUserArn = __expectString(data.AppInstanceUserArn);
    }
    return contents;
};
const deserializeAws_restJson1UpdateAppInstanceUserCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chime#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ConflictException":
        case "com.amazonaws.chime#ConflictException":
            throw await deserializeAws_restJson1ConflictExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chime#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chime#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chime#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chime#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chime#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1UpdateBotCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return deserializeAws_restJson1UpdateBotCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    if (data.Bot != null) {
        contents.Bot = deserializeAws_restJson1Bot(data.Bot, context);
    }
    return contents;
};
const deserializeAws_restJson1UpdateBotCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chime#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chime#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chime#NotFoundException":
            throw await deserializeAws_restJson1NotFoundExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chime#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chime#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chime#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chime#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1UpdateChannelCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return deserializeAws_restJson1UpdateChannelCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    if (data.ChannelArn != null) {
        contents.ChannelArn = __expectString(data.ChannelArn);
    }
    return contents;
};
const deserializeAws_restJson1UpdateChannelCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chime#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ConflictException":
        case "com.amazonaws.chime#ConflictException":
            throw await deserializeAws_restJson1ConflictExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chime#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chime#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chime#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chime#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chime#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1UpdateChannelMessageCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return deserializeAws_restJson1UpdateChannelMessageCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    if (data.ChannelArn != null) {
        contents.ChannelArn = __expectString(data.ChannelArn);
    }
    if (data.MessageId != null) {
        contents.MessageId = __expectString(data.MessageId);
    }
    return contents;
};
const deserializeAws_restJson1UpdateChannelMessageCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chime#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ConflictException":
        case "com.amazonaws.chime#ConflictException":
            throw await deserializeAws_restJson1ConflictExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chime#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chime#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chime#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chime#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chime#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1UpdateChannelReadMarkerCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return deserializeAws_restJson1UpdateChannelReadMarkerCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    if (data.ChannelArn != null) {
        contents.ChannelArn = __expectString(data.ChannelArn);
    }
    return contents;
};
const deserializeAws_restJson1UpdateChannelReadMarkerCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chime#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ConflictException":
        case "com.amazonaws.chime#ConflictException":
            throw await deserializeAws_restJson1ConflictExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chime#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chime#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chime#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chime#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chime#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1UpdateGlobalSettingsCommand = async (output, context) => {
    if (output.statusCode !== 204 && output.statusCode >= 300) {
        return deserializeAws_restJson1UpdateGlobalSettingsCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    await collectBody(output.body, context);
    return contents;
};
const deserializeAws_restJson1UpdateGlobalSettingsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chime#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chime#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chime#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chime#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chime#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chime#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1UpdatePhoneNumberCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return deserializeAws_restJson1UpdatePhoneNumberCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    if (data.PhoneNumber != null) {
        contents.PhoneNumber = deserializeAws_restJson1PhoneNumber(data.PhoneNumber, context);
    }
    return contents;
};
const deserializeAws_restJson1UpdatePhoneNumberCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chime#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ConflictException":
        case "com.amazonaws.chime#ConflictException":
            throw await deserializeAws_restJson1ConflictExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chime#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chime#NotFoundException":
            throw await deserializeAws_restJson1NotFoundExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chime#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chime#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chime#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chime#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1UpdatePhoneNumberSettingsCommand = async (output, context) => {
    if (output.statusCode !== 204 && output.statusCode >= 300) {
        return deserializeAws_restJson1UpdatePhoneNumberSettingsCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    await collectBody(output.body, context);
    return contents;
};
const deserializeAws_restJson1UpdatePhoneNumberSettingsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chime#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chime#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chime#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chime#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chime#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chime#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1UpdateProxySessionCommand = async (output, context) => {
    if (output.statusCode !== 201 && output.statusCode >= 300) {
        return deserializeAws_restJson1UpdateProxySessionCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    if (data.ProxySession != null) {
        contents.ProxySession = deserializeAws_restJson1ProxySession(data.ProxySession, context);
    }
    return contents;
};
const deserializeAws_restJson1UpdateProxySessionCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chime#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chime#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chime#NotFoundException":
            throw await deserializeAws_restJson1NotFoundExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chime#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chime#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chime#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chime#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1UpdateRoomCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return deserializeAws_restJson1UpdateRoomCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    if (data.Room != null) {
        contents.Room = deserializeAws_restJson1Room(data.Room, context);
    }
    return contents;
};
const deserializeAws_restJson1UpdateRoomCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chime#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chime#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chime#NotFoundException":
            throw await deserializeAws_restJson1NotFoundExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chime#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chime#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chime#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chime#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1UpdateRoomMembershipCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return deserializeAws_restJson1UpdateRoomMembershipCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    if (data.RoomMembership != null) {
        contents.RoomMembership = deserializeAws_restJson1RoomMembership(data.RoomMembership, context);
    }
    return contents;
};
const deserializeAws_restJson1UpdateRoomMembershipCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chime#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chime#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chime#NotFoundException":
            throw await deserializeAws_restJson1NotFoundExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chime#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chime#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chime#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chime#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1UpdateSipMediaApplicationCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return deserializeAws_restJson1UpdateSipMediaApplicationCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    if (data.SipMediaApplication != null) {
        contents.SipMediaApplication = deserializeAws_restJson1SipMediaApplication(data.SipMediaApplication, context);
    }
    return contents;
};
const deserializeAws_restJson1UpdateSipMediaApplicationCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chime#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ConflictException":
        case "com.amazonaws.chime#ConflictException":
            throw await deserializeAws_restJson1ConflictExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chime#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chime#NotFoundException":
            throw await deserializeAws_restJson1NotFoundExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chime#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chime#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chime#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chime#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1UpdateSipMediaApplicationCallCommand = async (output, context) => {
    if (output.statusCode !== 202 && output.statusCode >= 300) {
        return deserializeAws_restJson1UpdateSipMediaApplicationCallCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    if (data.SipMediaApplicationCall != null) {
        contents.SipMediaApplicationCall = deserializeAws_restJson1SipMediaApplicationCall(data.SipMediaApplicationCall, context);
    }
    return contents;
};
const deserializeAws_restJson1UpdateSipMediaApplicationCallCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chime#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chime#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chime#NotFoundException":
            throw await deserializeAws_restJson1NotFoundExceptionResponse(parsedOutput, context);
        case "ResourceLimitExceededException":
        case "com.amazonaws.chime#ResourceLimitExceededException":
            throw await deserializeAws_restJson1ResourceLimitExceededExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chime#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chime#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chime#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chime#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1UpdateSipRuleCommand = async (output, context) => {
    if (output.statusCode !== 202 && output.statusCode >= 300) {
        return deserializeAws_restJson1UpdateSipRuleCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    if (data.SipRule != null) {
        contents.SipRule = deserializeAws_restJson1SipRule(data.SipRule, context);
    }
    return contents;
};
const deserializeAws_restJson1UpdateSipRuleCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chime#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ConflictException":
        case "com.amazonaws.chime#ConflictException":
            throw await deserializeAws_restJson1ConflictExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chime#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chime#NotFoundException":
            throw await deserializeAws_restJson1NotFoundExceptionResponse(parsedOutput, context);
        case "ResourceLimitExceededException":
        case "com.amazonaws.chime#ResourceLimitExceededException":
            throw await deserializeAws_restJson1ResourceLimitExceededExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chime#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chime#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chime#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chime#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1UpdateUserCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return deserializeAws_restJson1UpdateUserCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    if (data.User != null) {
        contents.User = deserializeAws_restJson1User(data.User, context);
    }
    return contents;
};
const deserializeAws_restJson1UpdateUserCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chime#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chime#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chime#NotFoundException":
            throw await deserializeAws_restJson1NotFoundExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chime#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chime#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chime#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chime#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1UpdateUserSettingsCommand = async (output, context) => {
    if (output.statusCode !== 204 && output.statusCode >= 300) {
        return deserializeAws_restJson1UpdateUserSettingsCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    await collectBody(output.body, context);
    return contents;
};
const deserializeAws_restJson1UpdateUserSettingsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chime#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chime#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chime#NotFoundException":
            throw await deserializeAws_restJson1NotFoundExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chime#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chime#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chime#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chime#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1UpdateVoiceConnectorCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return deserializeAws_restJson1UpdateVoiceConnectorCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    if (data.VoiceConnector != null) {
        contents.VoiceConnector = deserializeAws_restJson1VoiceConnector(data.VoiceConnector, context);
    }
    return contents;
};
const deserializeAws_restJson1UpdateVoiceConnectorCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chime#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chime#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chime#NotFoundException":
            throw await deserializeAws_restJson1NotFoundExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chime#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chime#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chime#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chime#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1UpdateVoiceConnectorGroupCommand = async (output, context) => {
    if (output.statusCode !== 202 && output.statusCode >= 300) {
        return deserializeAws_restJson1UpdateVoiceConnectorGroupCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    if (data.VoiceConnectorGroup != null) {
        contents.VoiceConnectorGroup = deserializeAws_restJson1VoiceConnectorGroup(data.VoiceConnectorGroup, context);
    }
    return contents;
};
const deserializeAws_restJson1UpdateVoiceConnectorGroupCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chime#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ConflictException":
        case "com.amazonaws.chime#ConflictException":
            throw await deserializeAws_restJson1ConflictExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chime#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chime#NotFoundException":
            throw await deserializeAws_restJson1NotFoundExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chime#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chime#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chime#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chime#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_restJson1ValidateE911AddressCommand = async (output, context) => {
    if (output.statusCode !== 202 && output.statusCode >= 300) {
        return deserializeAws_restJson1ValidateE911AddressCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    if (data.Address != null) {
        contents.Address = deserializeAws_restJson1Address(data.Address, context);
    }
    if (data.AddressExternalId != null) {
        contents.AddressExternalId = __expectString(data.AddressExternalId);
    }
    if (data.CandidateAddressList != null) {
        contents.CandidateAddressList = deserializeAws_restJson1CandidateAddressList(data.CandidateAddressList, context);
    }
    if (data.ValidationResult != null) {
        contents.ValidationResult = __expectInt32(data.ValidationResult);
    }
    return contents;
};
const deserializeAws_restJson1ValidateE911AddressCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chime#BadRequestException":
            throw await deserializeAws_restJson1BadRequestExceptionResponse(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chime#ForbiddenException":
            throw await deserializeAws_restJson1ForbiddenExceptionResponse(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chime#NotFoundException":
            throw await deserializeAws_restJson1NotFoundExceptionResponse(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chime#ServiceFailureException":
            throw await deserializeAws_restJson1ServiceFailureExceptionResponse(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chime#ServiceUnavailableException":
            throw await deserializeAws_restJson1ServiceUnavailableExceptionResponse(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chime#ThrottledClientException":
            throw await deserializeAws_restJson1ThrottledClientExceptionResponse(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chime#UnauthorizedClientException":
            throw await deserializeAws_restJson1UnauthorizedClientExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
const map = __map;
const deserializeAws_restJson1AccessDeniedExceptionResponse = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body;
    if (data.Code != null) {
        contents.Code = __expectString(data.Code);
    }
    if (data.Message != null) {
        contents.Message = __expectString(data.Message);
    }
    const exception = new AccessDeniedException({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return __decorateServiceException(exception, parsedOutput.body);
};
const deserializeAws_restJson1BadRequestExceptionResponse = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body;
    if (data.Code != null) {
        contents.Code = __expectString(data.Code);
    }
    if (data.Message != null) {
        contents.Message = __expectString(data.Message);
    }
    const exception = new BadRequestException({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return __decorateServiceException(exception, parsedOutput.body);
};
const deserializeAws_restJson1ConflictExceptionResponse = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body;
    if (data.Code != null) {
        contents.Code = __expectString(data.Code);
    }
    if (data.Message != null) {
        contents.Message = __expectString(data.Message);
    }
    const exception = new ConflictException({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return __decorateServiceException(exception, parsedOutput.body);
};
const deserializeAws_restJson1ForbiddenExceptionResponse = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body;
    if (data.Code != null) {
        contents.Code = __expectString(data.Code);
    }
    if (data.Message != null) {
        contents.Message = __expectString(data.Message);
    }
    const exception = new ForbiddenException({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return __decorateServiceException(exception, parsedOutput.body);
};
const deserializeAws_restJson1NotFoundExceptionResponse = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body;
    if (data.Code != null) {
        contents.Code = __expectString(data.Code);
    }
    if (data.Message != null) {
        contents.Message = __expectString(data.Message);
    }
    const exception = new NotFoundException({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return __decorateServiceException(exception, parsedOutput.body);
};
const deserializeAws_restJson1ResourceLimitExceededExceptionResponse = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body;
    if (data.Code != null) {
        contents.Code = __expectString(data.Code);
    }
    if (data.Message != null) {
        contents.Message = __expectString(data.Message);
    }
    const exception = new ResourceLimitExceededException({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return __decorateServiceException(exception, parsedOutput.body);
};
const deserializeAws_restJson1ServiceFailureExceptionResponse = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body;
    if (data.Code != null) {
        contents.Code = __expectString(data.Code);
    }
    if (data.Message != null) {
        contents.Message = __expectString(data.Message);
    }
    const exception = new ServiceFailureException({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return __decorateServiceException(exception, parsedOutput.body);
};
const deserializeAws_restJson1ServiceUnavailableExceptionResponse = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body;
    if (data.Code != null) {
        contents.Code = __expectString(data.Code);
    }
    if (data.Message != null) {
        contents.Message = __expectString(data.Message);
    }
    const exception = new ServiceUnavailableException({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return __decorateServiceException(exception, parsedOutput.body);
};
const deserializeAws_restJson1ThrottledClientExceptionResponse = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body;
    if (data.Code != null) {
        contents.Code = __expectString(data.Code);
    }
    if (data.Message != null) {
        contents.Message = __expectString(data.Message);
    }
    const exception = new ThrottledClientException({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return __decorateServiceException(exception, parsedOutput.body);
};
const deserializeAws_restJson1UnauthorizedClientExceptionResponse = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body;
    if (data.Code != null) {
        contents.Code = __expectString(data.Code);
    }
    if (data.Message != null) {
        contents.Message = __expectString(data.Message);
    }
    const exception = new UnauthorizedClientException({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return __decorateServiceException(exception, parsedOutput.body);
};
const deserializeAws_restJson1UnprocessableEntityExceptionResponse = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body;
    if (data.Code != null) {
        contents.Code = __expectString(data.Code);
    }
    if (data.Message != null) {
        contents.Message = __expectString(data.Message);
    }
    const exception = new UnprocessableEntityException({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return __decorateServiceException(exception, parsedOutput.body);
};
const serializeAws_restJson1AccountSettings = (input, context) => {
    return {
        ...(input.DisableRemoteControl != null && { DisableRemoteControl: input.DisableRemoteControl }),
        ...(input.EnableDialOut != null && { EnableDialOut: input.EnableDialOut }),
    };
};
const serializeAws_restJson1AlexaForBusinessMetadata = (input, context) => {
    return {
        ...(input.AlexaForBusinessRoomArn != null && { AlexaForBusinessRoomArn: input.AlexaForBusinessRoomArn }),
        ...(input.IsAlexaForBusinessEnabled != null && { IsAlexaForBusinessEnabled: input.IsAlexaForBusinessEnabled }),
    };
};
const serializeAws_restJson1AppInstanceRetentionSettings = (input, context) => {
    return {
        ...(input.ChannelRetentionSettings != null && {
            ChannelRetentionSettings: serializeAws_restJson1ChannelRetentionSettings(input.ChannelRetentionSettings, context),
        }),
    };
};
const serializeAws_restJson1AppInstanceStreamingConfiguration = (input, context) => {
    return {
        ...(input.AppInstanceDataType != null && { AppInstanceDataType: input.AppInstanceDataType }),
        ...(input.ResourceArn != null && { ResourceArn: input.ResourceArn }),
    };
};
const serializeAws_restJson1AppInstanceStreamingConfigurationList = (input, context) => {
    return input
        .filter((e) => e != null)
        .map((entry) => {
        return serializeAws_restJson1AppInstanceStreamingConfiguration(entry, context);
    });
};
const serializeAws_restJson1ArtifactsConfiguration = (input, context) => {
    return {
        ...(input.Audio != null && { Audio: serializeAws_restJson1AudioArtifactsConfiguration(input.Audio, context) }),
        ...(input.Content != null && {
            Content: serializeAws_restJson1ContentArtifactsConfiguration(input.Content, context),
        }),
        ...(input.Video != null && { Video: serializeAws_restJson1VideoArtifactsConfiguration(input.Video, context) }),
    };
};
const serializeAws_restJson1AttendeeIdList = (input, context) => {
    return input
        .filter((e) => e != null)
        .map((entry) => {
        return entry;
    });
};
const serializeAws_restJson1AttendeeTagKeyList = (input, context) => {
    return input
        .filter((e) => e != null)
        .map((entry) => {
        return entry;
    });
};
const serializeAws_restJson1AttendeeTagList = (input, context) => {
    return input
        .filter((e) => e != null)
        .map((entry) => {
        return serializeAws_restJson1Tag(entry, context);
    });
};
const serializeAws_restJson1AudioArtifactsConfiguration = (input, context) => {
    return {
        ...(input.MuxType != null && { MuxType: input.MuxType }),
    };
};
const serializeAws_restJson1BusinessCallingSettings = (input, context) => {
    return {
        ...(input.CdrBucket != null && { CdrBucket: input.CdrBucket }),
    };
};
const serializeAws_restJson1CallingRegionList = (input, context) => {
    return input
        .filter((e) => e != null)
        .map((entry) => {
        return entry;
    });
};
const serializeAws_restJson1CapabilityList = (input, context) => {
    return input
        .filter((e) => e != null)
        .map((entry) => {
        return entry;
    });
};
const serializeAws_restJson1ChannelRetentionSettings = (input, context) => {
    return {
        ...(input.RetentionDays != null && { RetentionDays: input.RetentionDays }),
    };
};
const serializeAws_restJson1ChimeSdkMeetingConfiguration = (input, context) => {
    return {
        ...(input.ArtifactsConfiguration != null && {
            ArtifactsConfiguration: serializeAws_restJson1ArtifactsConfiguration(input.ArtifactsConfiguration, context),
        }),
        ...(input.SourceConfiguration != null && {
            SourceConfiguration: serializeAws_restJson1SourceConfiguration(input.SourceConfiguration, context),
        }),
    };
};
const serializeAws_restJson1ContentArtifactsConfiguration = (input, context) => {
    return {
        ...(input.MuxType != null && { MuxType: input.MuxType }),
        ...(input.State != null && { State: input.State }),
    };
};
const serializeAws_restJson1ConversationRetentionSettings = (input, context) => {
    return {
        ...(input.RetentionDays != null && { RetentionDays: input.RetentionDays }),
    };
};
const serializeAws_restJson1CountryList = (input, context) => {
    return input
        .filter((e) => e != null)
        .map((entry) => {
        return entry;
    });
};
const serializeAws_restJson1CreateAttendeeRequestItem = (input, context) => {
    return {
        ...(input.ExternalUserId != null && { ExternalUserId: input.ExternalUserId }),
        ...(input.Tags != null && { Tags: serializeAws_restJson1AttendeeTagList(input.Tags, context) }),
    };
};
const serializeAws_restJson1CreateAttendeeRequestItemList = (input, context) => {
    return input
        .filter((e) => e != null)
        .map((entry) => {
        return serializeAws_restJson1CreateAttendeeRequestItem(entry, context);
    });
};
const serializeAws_restJson1CreateMeetingWithAttendeesRequestItemList = (input, context) => {
    return input
        .filter((e) => e != null)
        .map((entry) => {
        return serializeAws_restJson1CreateAttendeeRequestItem(entry, context);
    });
};
const serializeAws_restJson1Credential = (input, context) => {
    return {
        ...(input.Password != null && { Password: input.Password }),
        ...(input.Username != null && { Username: input.Username }),
    };
};
const serializeAws_restJson1CredentialList = (input, context) => {
    return input
        .filter((e) => e != null)
        .map((entry) => {
        return serializeAws_restJson1Credential(entry, context);
    });
};
const serializeAws_restJson1DNISEmergencyCallingConfiguration = (input, context) => {
    return {
        ...(input.CallingCountry != null && { CallingCountry: input.CallingCountry }),
        ...(input.EmergencyPhoneNumber != null && { EmergencyPhoneNumber: input.EmergencyPhoneNumber }),
        ...(input.TestPhoneNumber != null && { TestPhoneNumber: input.TestPhoneNumber }),
    };
};
const serializeAws_restJson1DNISEmergencyCallingConfigurationList = (input, context) => {
    return input
        .filter((e) => e != null)
        .map((entry) => {
        return serializeAws_restJson1DNISEmergencyCallingConfiguration(entry, context);
    });
};
const serializeAws_restJson1E164PhoneNumberList = (input, context) => {
    return input
        .filter((e) => e != null)
        .map((entry) => {
        return entry;
    });
};
const serializeAws_restJson1EmergencyCallingConfiguration = (input, context) => {
    return {
        ...(input.DNIS != null && {
            DNIS: serializeAws_restJson1DNISEmergencyCallingConfigurationList(input.DNIS, context),
        }),
    };
};
const serializeAws_restJson1EngineTranscribeMedicalSettings = (input, context) => {
    return {
        ...(input.ContentIdentificationType != null && { ContentIdentificationType: input.ContentIdentificationType }),
        ...(input.LanguageCode != null && { LanguageCode: input.LanguageCode }),
        ...(input.Region != null && { Region: input.Region }),
        ...(input.Specialty != null && { Specialty: input.Specialty }),
        ...(input.Type != null && { Type: input.Type }),
        ...(input.VocabularyName != null && { VocabularyName: input.VocabularyName }),
    };
};
const serializeAws_restJson1EngineTranscribeSettings = (input, context) => {
    return {
        ...(input.ContentIdentificationType != null && { ContentIdentificationType: input.ContentIdentificationType }),
        ...(input.ContentRedactionType != null && { ContentRedactionType: input.ContentRedactionType }),
        ...(input.EnablePartialResultsStabilization != null && {
            EnablePartialResultsStabilization: input.EnablePartialResultsStabilization,
        }),
        ...(input.LanguageCode != null && { LanguageCode: input.LanguageCode }),
        ...(input.LanguageModelName != null && { LanguageModelName: input.LanguageModelName }),
        ...(input.PartialResultsStability != null && { PartialResultsStability: input.PartialResultsStability }),
        ...(input.PiiEntityTypes != null && { PiiEntityTypes: input.PiiEntityTypes }),
        ...(input.Region != null && { Region: input.Region }),
        ...(input.VocabularyFilterMethod != null && { VocabularyFilterMethod: input.VocabularyFilterMethod }),
        ...(input.VocabularyFilterName != null && { VocabularyFilterName: input.VocabularyFilterName }),
        ...(input.VocabularyName != null && { VocabularyName: input.VocabularyName }),
    };
};
const serializeAws_restJson1ExternalUserIdList = (input, context) => {
    return input
        .filter((e) => e != null)
        .map((entry) => {
        return entry;
    });
};
const serializeAws_restJson1GeoMatchParams = (input, context) => {
    return {
        ...(input.AreaCode != null && { AreaCode: input.AreaCode }),
        ...(input.Country != null && { Country: input.Country }),
    };
};
const serializeAws_restJson1LoggingConfiguration = (input, context) => {
    return {
        ...(input.EnableMediaMetricLogs != null && { EnableMediaMetricLogs: input.EnableMediaMetricLogs }),
        ...(input.EnableSIPLogs != null && { EnableSIPLogs: input.EnableSIPLogs }),
    };
};
const serializeAws_restJson1MeetingNotificationConfiguration = (input, context) => {
    return {
        ...(input.SnsTopicArn != null && { SnsTopicArn: input.SnsTopicArn }),
        ...(input.SqsQueueArn != null && { SqsQueueArn: input.SqsQueueArn }),
    };
};
const serializeAws_restJson1MeetingTagKeyList = (input, context) => {
    return input
        .filter((e) => e != null)
        .map((entry) => {
        return entry;
    });
};
const serializeAws_restJson1MeetingTagList = (input, context) => {
    return input
        .filter((e) => e != null)
        .map((entry) => {
        return serializeAws_restJson1Tag(entry, context);
    });
};
const serializeAws_restJson1MemberArns = (input, context) => {
    return input
        .filter((e) => e != null)
        .map((entry) => {
        return entry;
    });
};
const serializeAws_restJson1MembershipItem = (input, context) => {
    return {
        ...(input.MemberId != null && { MemberId: input.MemberId }),
        ...(input.Role != null && { Role: input.Role }),
    };
};
const serializeAws_restJson1MembershipItemList = (input, context) => {
    return input
        .filter((e) => e != null)
        .map((entry) => {
        return serializeAws_restJson1MembershipItem(entry, context);
    });
};
const serializeAws_restJson1NonEmptyStringList = (input, context) => {
    return input
        .filter((e) => e != null)
        .map((entry) => {
        return entry;
    });
};
const serializeAws_restJson1Origination = (input, context) => {
    return {
        ...(input.Disabled != null && { Disabled: input.Disabled }),
        ...(input.Routes != null && { Routes: serializeAws_restJson1OriginationRouteList(input.Routes, context) }),
    };
};
const serializeAws_restJson1OriginationRoute = (input, context) => {
    return {
        ...(input.Host != null && { Host: input.Host }),
        ...(input.Port != null && { Port: input.Port }),
        ...(input.Priority != null && { Priority: input.Priority }),
        ...(input.Protocol != null && { Protocol: input.Protocol }),
        ...(input.Weight != null && { Weight: input.Weight }),
    };
};
const serializeAws_restJson1OriginationRouteList = (input, context) => {
    return input
        .filter((e) => e != null)
        .map((entry) => {
        return serializeAws_restJson1OriginationRoute(entry, context);
    });
};
const serializeAws_restJson1ParticipantPhoneNumberList = (input, context) => {
    return input
        .filter((e) => e != null)
        .map((entry) => {
        return entry;
    });
};
const serializeAws_restJson1RetentionSettings = (input, context) => {
    return {
        ...(input.ConversationRetentionSettings != null && {
            ConversationRetentionSettings: serializeAws_restJson1ConversationRetentionSettings(input.ConversationRetentionSettings, context),
        }),
        ...(input.RoomRetentionSettings != null && {
            RoomRetentionSettings: serializeAws_restJson1RoomRetentionSettings(input.RoomRetentionSettings, context),
        }),
    };
};
const serializeAws_restJson1RoomRetentionSettings = (input, context) => {
    return {
        ...(input.RetentionDays != null && { RetentionDays: input.RetentionDays }),
    };
};
const serializeAws_restJson1SelectedVideoStreams = (input, context) => {
    return {
        ...(input.AttendeeIds != null && { AttendeeIds: serializeAws_restJson1AttendeeIdList(input.AttendeeIds, context) }),
        ...(input.ExternalUserIds != null && {
            ExternalUserIds: serializeAws_restJson1ExternalUserIdList(input.ExternalUserIds, context),
        }),
    };
};
const serializeAws_restJson1SensitiveStringList = (input, context) => {
    return input
        .filter((e) => e != null)
        .map((entry) => {
        return entry;
    });
};
const serializeAws_restJson1SigninDelegateGroup = (input, context) => {
    return {
        ...(input.GroupName != null && { GroupName: input.GroupName }),
    };
};
const serializeAws_restJson1SigninDelegateGroupList = (input, context) => {
    return input
        .filter((e) => e != null)
        .map((entry) => {
        return serializeAws_restJson1SigninDelegateGroup(entry, context);
    });
};
const serializeAws_restJson1SipHeadersMap = (input, context) => {
    return Object.entries(input).reduce((acc, [key, value]) => {
        if (value === null) {
            return acc;
        }
        acc[key] = value;
        return acc;
    }, {});
};
const serializeAws_restJson1SipMediaApplicationEndpoint = (input, context) => {
    return {
        ...(input.LambdaArn != null && { LambdaArn: input.LambdaArn }),
    };
};
const serializeAws_restJson1SipMediaApplicationEndpointList = (input, context) => {
    return input
        .filter((e) => e != null)
        .map((entry) => {
        return serializeAws_restJson1SipMediaApplicationEndpoint(entry, context);
    });
};
const serializeAws_restJson1SipMediaApplicationLoggingConfiguration = (input, context) => {
    return {
        ...(input.EnableSipMediaApplicationMessageLogs != null && {
            EnableSipMediaApplicationMessageLogs: input.EnableSipMediaApplicationMessageLogs,
        }),
    };
};
const serializeAws_restJson1SipRuleTargetApplication = (input, context) => {
    return {
        ...(input.AwsRegion != null && { AwsRegion: input.AwsRegion }),
        ...(input.Priority != null && { Priority: input.Priority }),
        ...(input.SipMediaApplicationId != null && { SipMediaApplicationId: input.SipMediaApplicationId }),
    };
};
const serializeAws_restJson1SipRuleTargetApplicationList = (input, context) => {
    return input
        .filter((e) => e != null)
        .map((entry) => {
        return serializeAws_restJson1SipRuleTargetApplication(entry, context);
    });
};
const serializeAws_restJson1SMAUpdateCallArgumentsMap = (input, context) => {
    return Object.entries(input).reduce((acc, [key, value]) => {
        if (value === null) {
            return acc;
        }
        acc[key] = value;
        return acc;
    }, {});
};
const serializeAws_restJson1SourceConfiguration = (input, context) => {
    return {
        ...(input.SelectedVideoStreams != null && {
            SelectedVideoStreams: serializeAws_restJson1SelectedVideoStreams(input.SelectedVideoStreams, context),
        }),
    };
};
const serializeAws_restJson1StreamingConfiguration = (input, context) => {
    return {
        ...(input.DataRetentionInHours != null && { DataRetentionInHours: input.DataRetentionInHours }),
        ...(input.Disabled != null && { Disabled: input.Disabled }),
        ...(input.StreamingNotificationTargets != null && {
            StreamingNotificationTargets: serializeAws_restJson1StreamingNotificationTargetList(input.StreamingNotificationTargets, context),
        }),
    };
};
const serializeAws_restJson1StreamingNotificationTarget = (input, context) => {
    return {
        ...(input.NotificationTarget != null && { NotificationTarget: input.NotificationTarget }),
    };
};
const serializeAws_restJson1StreamingNotificationTargetList = (input, context) => {
    return input
        .filter((e) => e != null)
        .map((entry) => {
        return serializeAws_restJson1StreamingNotificationTarget(entry, context);
    });
};
const serializeAws_restJson1StringList = (input, context) => {
    return input
        .filter((e) => e != null)
        .map((entry) => {
        return entry;
    });
};
const serializeAws_restJson1Tag = (input, context) => {
    return {
        ...(input.Key != null && { Key: input.Key }),
        ...(input.Value != null && { Value: input.Value }),
    };
};
const serializeAws_restJson1TagKeyList = (input, context) => {
    return input
        .filter((e) => e != null)
        .map((entry) => {
        return entry;
    });
};
const serializeAws_restJson1TagList = (input, context) => {
    return input
        .filter((e) => e != null)
        .map((entry) => {
        return serializeAws_restJson1Tag(entry, context);
    });
};
const serializeAws_restJson1TelephonySettings = (input, context) => {
    return {
        ...(input.InboundCalling != null && { InboundCalling: input.InboundCalling }),
        ...(input.OutboundCalling != null && { OutboundCalling: input.OutboundCalling }),
        ...(input.SMS != null && { SMS: input.SMS }),
    };
};
const serializeAws_restJson1Termination = (input, context) => {
    return {
        ...(input.CallingRegions != null && {
            CallingRegions: serializeAws_restJson1CallingRegionList(input.CallingRegions, context),
        }),
        ...(input.CidrAllowedList != null && {
            CidrAllowedList: serializeAws_restJson1StringList(input.CidrAllowedList, context),
        }),
        ...(input.CpsLimit != null && { CpsLimit: input.CpsLimit }),
        ...(input.DefaultPhoneNumber != null && { DefaultPhoneNumber: input.DefaultPhoneNumber }),
        ...(input.Disabled != null && { Disabled: input.Disabled }),
    };
};
const serializeAws_restJson1TranscriptionConfiguration = (input, context) => {
    return {
        ...(input.EngineTranscribeMedicalSettings != null && {
            EngineTranscribeMedicalSettings: serializeAws_restJson1EngineTranscribeMedicalSettings(input.EngineTranscribeMedicalSettings, context),
        }),
        ...(input.EngineTranscribeSettings != null && {
            EngineTranscribeSettings: serializeAws_restJson1EngineTranscribeSettings(input.EngineTranscribeSettings, context),
        }),
    };
};
const serializeAws_restJson1UpdatePhoneNumberRequestItem = (input, context) => {
    return {
        ...(input.CallingName != null && { CallingName: input.CallingName }),
        ...(input.PhoneNumberId != null && { PhoneNumberId: input.PhoneNumberId }),
        ...(input.ProductType != null && { ProductType: input.ProductType }),
    };
};
const serializeAws_restJson1UpdatePhoneNumberRequestItemList = (input, context) => {
    return input
        .filter((e) => e != null)
        .map((entry) => {
        return serializeAws_restJson1UpdatePhoneNumberRequestItem(entry, context);
    });
};
const serializeAws_restJson1UpdateUserRequestItem = (input, context) => {
    return {
        ...(input.AlexaForBusinessMetadata != null && {
            AlexaForBusinessMetadata: serializeAws_restJson1AlexaForBusinessMetadata(input.AlexaForBusinessMetadata, context),
        }),
        ...(input.LicenseType != null && { LicenseType: input.LicenseType }),
        ...(input.UserId != null && { UserId: input.UserId }),
        ...(input.UserType != null && { UserType: input.UserType }),
    };
};
const serializeAws_restJson1UpdateUserRequestItemList = (input, context) => {
    return input
        .filter((e) => e != null)
        .map((entry) => {
        return serializeAws_restJson1UpdateUserRequestItem(entry, context);
    });
};
const serializeAws_restJson1UserEmailList = (input, context) => {
    return input
        .filter((e) => e != null)
        .map((entry) => {
        return entry;
    });
};
const serializeAws_restJson1UserIdList = (input, context) => {
    return input
        .filter((e) => e != null)
        .map((entry) => {
        return entry;
    });
};
const serializeAws_restJson1UserSettings = (input, context) => {
    return {
        ...(input.Telephony != null && { Telephony: serializeAws_restJson1TelephonySettings(input.Telephony, context) }),
    };
};
const serializeAws_restJson1VideoArtifactsConfiguration = (input, context) => {
    return {
        ...(input.MuxType != null && { MuxType: input.MuxType }),
        ...(input.State != null && { State: input.State }),
    };
};
const serializeAws_restJson1VoiceConnectorItem = (input, context) => {
    return {
        ...(input.Priority != null && { Priority: input.Priority }),
        ...(input.VoiceConnectorId != null && { VoiceConnectorId: input.VoiceConnectorId }),
    };
};
const serializeAws_restJson1VoiceConnectorItemList = (input, context) => {
    return input
        .filter((e) => e != null)
        .map((entry) => {
        return serializeAws_restJson1VoiceConnectorItem(entry, context);
    });
};
const serializeAws_restJson1VoiceConnectorSettings = (input, context) => {
    return {
        ...(input.CdrBucket != null && { CdrBucket: input.CdrBucket }),
    };
};
const deserializeAws_restJson1Account = (output, context) => {
    return {
        AccountId: __expectString(output.AccountId),
        AccountStatus: __expectString(output.AccountStatus),
        AccountType: __expectString(output.AccountType),
        AwsAccountId: __expectString(output.AwsAccountId),
        CreatedTimestamp: output.CreatedTimestamp != null
            ? __expectNonNull(__parseRfc3339DateTimeWithOffset(output.CreatedTimestamp))
            : undefined,
        DefaultLicense: __expectString(output.DefaultLicense),
        Name: __expectString(output.Name),
        SigninDelegateGroups: output.SigninDelegateGroups != null
            ? deserializeAws_restJson1SigninDelegateGroupList(output.SigninDelegateGroups, context)
            : undefined,
        SupportedLicenses: output.SupportedLicenses != null
            ? deserializeAws_restJson1LicenseList(output.SupportedLicenses, context)
            : undefined,
    };
};
const deserializeAws_restJson1AccountList = (output, context) => {
    const retVal = (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        if (entry === null) {
            return null;
        }
        return deserializeAws_restJson1Account(entry, context);
    });
    return retVal;
};
const deserializeAws_restJson1AccountSettings = (output, context) => {
    return {
        DisableRemoteControl: __expectBoolean(output.DisableRemoteControl),
        EnableDialOut: __expectBoolean(output.EnableDialOut),
    };
};
const deserializeAws_restJson1Address = (output, context) => {
    return {
        city: __expectString(output.city),
        country: __expectString(output.country),
        postDirectional: __expectString(output.postDirectional),
        postalCode: __expectString(output.postalCode),
        postalCodePlus4: __expectString(output.postalCodePlus4),
        preDirectional: __expectString(output.preDirectional),
        state: __expectString(output.state),
        streetName: __expectString(output.streetName),
        streetNumber: __expectString(output.streetNumber),
        streetSuffix: __expectString(output.streetSuffix),
    };
};
const deserializeAws_restJson1AlexaForBusinessMetadata = (output, context) => {
    return {
        AlexaForBusinessRoomArn: __expectString(output.AlexaForBusinessRoomArn),
        IsAlexaForBusinessEnabled: __expectBoolean(output.IsAlexaForBusinessEnabled),
    };
};
const deserializeAws_restJson1AppInstance = (output, context) => {
    return {
        AppInstanceArn: __expectString(output.AppInstanceArn),
        CreatedTimestamp: output.CreatedTimestamp != null
            ? __expectNonNull(__parseEpochTimestamp(__expectNumber(output.CreatedTimestamp)))
            : undefined,
        LastUpdatedTimestamp: output.LastUpdatedTimestamp != null
            ? __expectNonNull(__parseEpochTimestamp(__expectNumber(output.LastUpdatedTimestamp)))
            : undefined,
        Metadata: __expectString(output.Metadata),
        Name: __expectString(output.Name),
    };
};
const deserializeAws_restJson1AppInstanceAdmin = (output, context) => {
    return {
        Admin: output.Admin != null ? deserializeAws_restJson1Identity(output.Admin, context) : undefined,
        AppInstanceArn: __expectString(output.AppInstanceArn),
        CreatedTimestamp: output.CreatedTimestamp != null
            ? __expectNonNull(__parseEpochTimestamp(__expectNumber(output.CreatedTimestamp)))
            : undefined,
    };
};
const deserializeAws_restJson1AppInstanceAdminList = (output, context) => {
    const retVal = (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        if (entry === null) {
            return null;
        }
        return deserializeAws_restJson1AppInstanceAdminSummary(entry, context);
    });
    return retVal;
};
const deserializeAws_restJson1AppInstanceAdminSummary = (output, context) => {
    return {
        Admin: output.Admin != null ? deserializeAws_restJson1Identity(output.Admin, context) : undefined,
    };
};
const deserializeAws_restJson1AppInstanceList = (output, context) => {
    const retVal = (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        if (entry === null) {
            return null;
        }
        return deserializeAws_restJson1AppInstanceSummary(entry, context);
    });
    return retVal;
};
const deserializeAws_restJson1AppInstanceRetentionSettings = (output, context) => {
    return {
        ChannelRetentionSettings: output.ChannelRetentionSettings != null
            ? deserializeAws_restJson1ChannelRetentionSettings(output.ChannelRetentionSettings, context)
            : undefined,
    };
};
const deserializeAws_restJson1AppInstanceStreamingConfiguration = (output, context) => {
    return {
        AppInstanceDataType: __expectString(output.AppInstanceDataType),
        ResourceArn: __expectString(output.ResourceArn),
    };
};
const deserializeAws_restJson1AppInstanceStreamingConfigurationList = (output, context) => {
    const retVal = (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        if (entry === null) {
            return null;
        }
        return deserializeAws_restJson1AppInstanceStreamingConfiguration(entry, context);
    });
    return retVal;
};
const deserializeAws_restJson1AppInstanceSummary = (output, context) => {
    return {
        AppInstanceArn: __expectString(output.AppInstanceArn),
        Metadata: __expectString(output.Metadata),
        Name: __expectString(output.Name),
    };
};
const deserializeAws_restJson1AppInstanceUser = (output, context) => {
    return {
        AppInstanceUserArn: __expectString(output.AppInstanceUserArn),
        CreatedTimestamp: output.CreatedTimestamp != null
            ? __expectNonNull(__parseEpochTimestamp(__expectNumber(output.CreatedTimestamp)))
            : undefined,
        LastUpdatedTimestamp: output.LastUpdatedTimestamp != null
            ? __expectNonNull(__parseEpochTimestamp(__expectNumber(output.LastUpdatedTimestamp)))
            : undefined,
        Metadata: __expectString(output.Metadata),
        Name: __expectString(output.Name),
    };
};
const deserializeAws_restJson1AppInstanceUserList = (output, context) => {
    const retVal = (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        if (entry === null) {
            return null;
        }
        return deserializeAws_restJson1AppInstanceUserSummary(entry, context);
    });
    return retVal;
};
const deserializeAws_restJson1AppInstanceUserMembershipSummary = (output, context) => {
    return {
        ReadMarkerTimestamp: output.ReadMarkerTimestamp != null
            ? __expectNonNull(__parseEpochTimestamp(__expectNumber(output.ReadMarkerTimestamp)))
            : undefined,
        Type: __expectString(output.Type),
    };
};
const deserializeAws_restJson1AppInstanceUserSummary = (output, context) => {
    return {
        AppInstanceUserArn: __expectString(output.AppInstanceUserArn),
        Metadata: __expectString(output.Metadata),
        Name: __expectString(output.Name),
    };
};
const deserializeAws_restJson1ArtifactsConfiguration = (output, context) => {
    return {
        Audio: output.Audio != null ? deserializeAws_restJson1AudioArtifactsConfiguration(output.Audio, context) : undefined,
        Content: output.Content != null
            ? deserializeAws_restJson1ContentArtifactsConfiguration(output.Content, context)
            : undefined,
        Video: output.Video != null ? deserializeAws_restJson1VideoArtifactsConfiguration(output.Video, context) : undefined,
    };
};
const deserializeAws_restJson1Attendee = (output, context) => {
    return {
        AttendeeId: __expectString(output.AttendeeId),
        ExternalUserId: __expectString(output.ExternalUserId),
        JoinToken: __expectString(output.JoinToken),
    };
};
const deserializeAws_restJson1AttendeeIdList = (output, context) => {
    const retVal = (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        if (entry === null) {
            return null;
        }
        return __expectString(entry);
    });
    return retVal;
};
const deserializeAws_restJson1AttendeeList = (output, context) => {
    const retVal = (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        if (entry === null) {
            return null;
        }
        return deserializeAws_restJson1Attendee(entry, context);
    });
    return retVal;
};
const deserializeAws_restJson1AudioArtifactsConfiguration = (output, context) => {
    return {
        MuxType: __expectString(output.MuxType),
    };
};
const deserializeAws_restJson1BatchChannelMemberships = (output, context) => {
    return {
        ChannelArn: __expectString(output.ChannelArn),
        InvitedBy: output.InvitedBy != null ? deserializeAws_restJson1Identity(output.InvitedBy, context) : undefined,
        Members: output.Members != null ? deserializeAws_restJson1Members(output.Members, context) : undefined,
        Type: __expectString(output.Type),
    };
};
const deserializeAws_restJson1BatchCreateAttendeeErrorList = (output, context) => {
    const retVal = (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        if (entry === null) {
            return null;
        }
        return deserializeAws_restJson1CreateAttendeeError(entry, context);
    });
    return retVal;
};
const deserializeAws_restJson1BatchCreateChannelMembershipError = (output, context) => {
    return {
        ErrorCode: __expectString(output.ErrorCode),
        ErrorMessage: __expectString(output.ErrorMessage),
        MemberArn: __expectString(output.MemberArn),
    };
};
const deserializeAws_restJson1BatchCreateChannelMembershipErrors = (output, context) => {
    const retVal = (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        if (entry === null) {
            return null;
        }
        return deserializeAws_restJson1BatchCreateChannelMembershipError(entry, context);
    });
    return retVal;
};
const deserializeAws_restJson1Bot = (output, context) => {
    return {
        BotEmail: __expectString(output.BotEmail),
        BotId: __expectString(output.BotId),
        BotType: __expectString(output.BotType),
        CreatedTimestamp: output.CreatedTimestamp != null
            ? __expectNonNull(__parseRfc3339DateTimeWithOffset(output.CreatedTimestamp))
            : undefined,
        Disabled: __expectBoolean(output.Disabled),
        DisplayName: __expectString(output.DisplayName),
        SecurityToken: __expectString(output.SecurityToken),
        UpdatedTimestamp: output.UpdatedTimestamp != null
            ? __expectNonNull(__parseRfc3339DateTimeWithOffset(output.UpdatedTimestamp))
            : undefined,
        UserId: __expectString(output.UserId),
    };
};
const deserializeAws_restJson1BotList = (output, context) => {
    const retVal = (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        if (entry === null) {
            return null;
        }
        return deserializeAws_restJson1Bot(entry, context);
    });
    return retVal;
};
const deserializeAws_restJson1BusinessCallingSettings = (output, context) => {
    return {
        CdrBucket: __expectString(output.CdrBucket),
    };
};
const deserializeAws_restJson1CallingRegionList = (output, context) => {
    const retVal = (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        if (entry === null) {
            return null;
        }
        return __expectString(entry);
    });
    return retVal;
};
const deserializeAws_restJson1CandidateAddress = (output, context) => {
    return {
        city: __expectString(output.city),
        country: __expectString(output.country),
        postalCode: __expectString(output.postalCode),
        postalCodePlus4: __expectString(output.postalCodePlus4),
        state: __expectString(output.state),
        streetInfo: __expectString(output.streetInfo),
        streetNumber: __expectString(output.streetNumber),
    };
};
const deserializeAws_restJson1CandidateAddressList = (output, context) => {
    const retVal = (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        if (entry === null) {
            return null;
        }
        return deserializeAws_restJson1CandidateAddress(entry, context);
    });
    return retVal;
};
const deserializeAws_restJson1CapabilityList = (output, context) => {
    const retVal = (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        if (entry === null) {
            return null;
        }
        return __expectString(entry);
    });
    return retVal;
};
const deserializeAws_restJson1Channel = (output, context) => {
    return {
        ChannelArn: __expectString(output.ChannelArn),
        CreatedBy: output.CreatedBy != null ? deserializeAws_restJson1Identity(output.CreatedBy, context) : undefined,
        CreatedTimestamp: output.CreatedTimestamp != null
            ? __expectNonNull(__parseEpochTimestamp(__expectNumber(output.CreatedTimestamp)))
            : undefined,
        LastMessageTimestamp: output.LastMessageTimestamp != null
            ? __expectNonNull(__parseEpochTimestamp(__expectNumber(output.LastMessageTimestamp)))
            : undefined,
        LastUpdatedTimestamp: output.LastUpdatedTimestamp != null
            ? __expectNonNull(__parseEpochTimestamp(__expectNumber(output.LastUpdatedTimestamp)))
            : undefined,
        Metadata: __expectString(output.Metadata),
        Mode: __expectString(output.Mode),
        Name: __expectString(output.Name),
        Privacy: __expectString(output.Privacy),
    };
};
const deserializeAws_restJson1ChannelBan = (output, context) => {
    return {
        ChannelArn: __expectString(output.ChannelArn),
        CreatedBy: output.CreatedBy != null ? deserializeAws_restJson1Identity(output.CreatedBy, context) : undefined,
        CreatedTimestamp: output.CreatedTimestamp != null
            ? __expectNonNull(__parseEpochTimestamp(__expectNumber(output.CreatedTimestamp)))
            : undefined,
        Member: output.Member != null ? deserializeAws_restJson1Identity(output.Member, context) : undefined,
    };
};
const deserializeAws_restJson1ChannelBanSummary = (output, context) => {
    return {
        Member: output.Member != null ? deserializeAws_restJson1Identity(output.Member, context) : undefined,
    };
};
const deserializeAws_restJson1ChannelBanSummaryList = (output, context) => {
    const retVal = (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        if (entry === null) {
            return null;
        }
        return deserializeAws_restJson1ChannelBanSummary(entry, context);
    });
    return retVal;
};
const deserializeAws_restJson1ChannelMembership = (output, context) => {
    return {
        ChannelArn: __expectString(output.ChannelArn),
        CreatedTimestamp: output.CreatedTimestamp != null
            ? __expectNonNull(__parseEpochTimestamp(__expectNumber(output.CreatedTimestamp)))
            : undefined,
        InvitedBy: output.InvitedBy != null ? deserializeAws_restJson1Identity(output.InvitedBy, context) : undefined,
        LastUpdatedTimestamp: output.LastUpdatedTimestamp != null
            ? __expectNonNull(__parseEpochTimestamp(__expectNumber(output.LastUpdatedTimestamp)))
            : undefined,
        Member: output.Member != null ? deserializeAws_restJson1Identity(output.Member, context) : undefined,
        Type: __expectString(output.Type),
    };
};
const deserializeAws_restJson1ChannelMembershipForAppInstanceUserSummary = (output, context) => {
    return {
        AppInstanceUserMembershipSummary: output.AppInstanceUserMembershipSummary != null
            ? deserializeAws_restJson1AppInstanceUserMembershipSummary(output.AppInstanceUserMembershipSummary, context)
            : undefined,
        ChannelSummary: output.ChannelSummary != null
            ? deserializeAws_restJson1ChannelSummary(output.ChannelSummary, context)
            : undefined,
    };
};
const deserializeAws_restJson1ChannelMembershipForAppInstanceUserSummaryList = (output, context) => {
    const retVal = (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        if (entry === null) {
            return null;
        }
        return deserializeAws_restJson1ChannelMembershipForAppInstanceUserSummary(entry, context);
    });
    return retVal;
};
const deserializeAws_restJson1ChannelMembershipSummary = (output, context) => {
    return {
        Member: output.Member != null ? deserializeAws_restJson1Identity(output.Member, context) : undefined,
    };
};
const deserializeAws_restJson1ChannelMembershipSummaryList = (output, context) => {
    const retVal = (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        if (entry === null) {
            return null;
        }
        return deserializeAws_restJson1ChannelMembershipSummary(entry, context);
    });
    return retVal;
};
const deserializeAws_restJson1ChannelMessage = (output, context) => {
    return {
        ChannelArn: __expectString(output.ChannelArn),
        Content: __expectString(output.Content),
        CreatedTimestamp: output.CreatedTimestamp != null
            ? __expectNonNull(__parseEpochTimestamp(__expectNumber(output.CreatedTimestamp)))
            : undefined,
        LastEditedTimestamp: output.LastEditedTimestamp != null
            ? __expectNonNull(__parseEpochTimestamp(__expectNumber(output.LastEditedTimestamp)))
            : undefined,
        LastUpdatedTimestamp: output.LastUpdatedTimestamp != null
            ? __expectNonNull(__parseEpochTimestamp(__expectNumber(output.LastUpdatedTimestamp)))
            : undefined,
        MessageId: __expectString(output.MessageId),
        Metadata: __expectString(output.Metadata),
        Persistence: __expectString(output.Persistence),
        Redacted: __expectBoolean(output.Redacted),
        Sender: output.Sender != null ? deserializeAws_restJson1Identity(output.Sender, context) : undefined,
        Type: __expectString(output.Type),
    };
};
const deserializeAws_restJson1ChannelMessageSummary = (output, context) => {
    return {
        Content: __expectString(output.Content),
        CreatedTimestamp: output.CreatedTimestamp != null
            ? __expectNonNull(__parseEpochTimestamp(__expectNumber(output.CreatedTimestamp)))
            : undefined,
        LastEditedTimestamp: output.LastEditedTimestamp != null
            ? __expectNonNull(__parseEpochTimestamp(__expectNumber(output.LastEditedTimestamp)))
            : undefined,
        LastUpdatedTimestamp: output.LastUpdatedTimestamp != null
            ? __expectNonNull(__parseEpochTimestamp(__expectNumber(output.LastUpdatedTimestamp)))
            : undefined,
        MessageId: __expectString(output.MessageId),
        Metadata: __expectString(output.Metadata),
        Redacted: __expectBoolean(output.Redacted),
        Sender: output.Sender != null ? deserializeAws_restJson1Identity(output.Sender, context) : undefined,
        Type: __expectString(output.Type),
    };
};
const deserializeAws_restJson1ChannelMessageSummaryList = (output, context) => {
    const retVal = (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        if (entry === null) {
            return null;
        }
        return deserializeAws_restJson1ChannelMessageSummary(entry, context);
    });
    return retVal;
};
const deserializeAws_restJson1ChannelModeratedByAppInstanceUserSummary = (output, context) => {
    return {
        ChannelSummary: output.ChannelSummary != null
            ? deserializeAws_restJson1ChannelSummary(output.ChannelSummary, context)
            : undefined,
    };
};
const deserializeAws_restJson1ChannelModeratedByAppInstanceUserSummaryList = (output, context) => {
    const retVal = (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        if (entry === null) {
            return null;
        }
        return deserializeAws_restJson1ChannelModeratedByAppInstanceUserSummary(entry, context);
    });
    return retVal;
};
const deserializeAws_restJson1ChannelModerator = (output, context) => {
    return {
        ChannelArn: __expectString(output.ChannelArn),
        CreatedBy: output.CreatedBy != null ? deserializeAws_restJson1Identity(output.CreatedBy, context) : undefined,
        CreatedTimestamp: output.CreatedTimestamp != null
            ? __expectNonNull(__parseEpochTimestamp(__expectNumber(output.CreatedTimestamp)))
            : undefined,
        Moderator: output.Moderator != null ? deserializeAws_restJson1Identity(output.Moderator, context) : undefined,
    };
};
const deserializeAws_restJson1ChannelModeratorSummary = (output, context) => {
    return {
        Moderator: output.Moderator != null ? deserializeAws_restJson1Identity(output.Moderator, context) : undefined,
    };
};
const deserializeAws_restJson1ChannelModeratorSummaryList = (output, context) => {
    const retVal = (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        if (entry === null) {
            return null;
        }
        return deserializeAws_restJson1ChannelModeratorSummary(entry, context);
    });
    return retVal;
};
const deserializeAws_restJson1ChannelRetentionSettings = (output, context) => {
    return {
        RetentionDays: __expectInt32(output.RetentionDays),
    };
};
const deserializeAws_restJson1ChannelSummary = (output, context) => {
    return {
        ChannelArn: __expectString(output.ChannelArn),
        LastMessageTimestamp: output.LastMessageTimestamp != null
            ? __expectNonNull(__parseEpochTimestamp(__expectNumber(output.LastMessageTimestamp)))
            : undefined,
        Metadata: __expectString(output.Metadata),
        Mode: __expectString(output.Mode),
        Name: __expectString(output.Name),
        Privacy: __expectString(output.Privacy),
    };
};
const deserializeAws_restJson1ChannelSummaryList = (output, context) => {
    const retVal = (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        if (entry === null) {
            return null;
        }
        return deserializeAws_restJson1ChannelSummary(entry, context);
    });
    return retVal;
};
const deserializeAws_restJson1ChimeSdkMeetingConfiguration = (output, context) => {
    return {
        ArtifactsConfiguration: output.ArtifactsConfiguration != null
            ? deserializeAws_restJson1ArtifactsConfiguration(output.ArtifactsConfiguration, context)
            : undefined,
        SourceConfiguration: output.SourceConfiguration != null
            ? deserializeAws_restJson1SourceConfiguration(output.SourceConfiguration, context)
            : undefined,
    };
};
const deserializeAws_restJson1ContentArtifactsConfiguration = (output, context) => {
    return {
        MuxType: __expectString(output.MuxType),
        State: __expectString(output.State),
    };
};
const deserializeAws_restJson1ConversationRetentionSettings = (output, context) => {
    return {
        RetentionDays: __expectInt32(output.RetentionDays),
    };
};
const deserializeAws_restJson1CreateAttendeeError = (output, context) => {
    return {
        ErrorCode: __expectString(output.ErrorCode),
        ErrorMessage: __expectString(output.ErrorMessage),
        ExternalUserId: __expectString(output.ExternalUserId),
    };
};
const deserializeAws_restJson1DNISEmergencyCallingConfiguration = (output, context) => {
    return {
        CallingCountry: __expectString(output.CallingCountry),
        EmergencyPhoneNumber: __expectString(output.EmergencyPhoneNumber),
        TestPhoneNumber: __expectString(output.TestPhoneNumber),
    };
};
const deserializeAws_restJson1DNISEmergencyCallingConfigurationList = (output, context) => {
    const retVal = (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        if (entry === null) {
            return null;
        }
        return deserializeAws_restJson1DNISEmergencyCallingConfiguration(entry, context);
    });
    return retVal;
};
const deserializeAws_restJson1E164PhoneNumberList = (output, context) => {
    const retVal = (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        if (entry === null) {
            return null;
        }
        return __expectString(entry);
    });
    return retVal;
};
const deserializeAws_restJson1EmergencyCallingConfiguration = (output, context) => {
    return {
        DNIS: output.DNIS != null
            ? deserializeAws_restJson1DNISEmergencyCallingConfigurationList(output.DNIS, context)
            : undefined,
    };
};
const deserializeAws_restJson1EventsConfiguration = (output, context) => {
    return {
        BotId: __expectString(output.BotId),
        LambdaFunctionArn: __expectString(output.LambdaFunctionArn),
        OutboundEventsHTTPSEndpoint: __expectString(output.OutboundEventsHTTPSEndpoint),
    };
};
const deserializeAws_restJson1ExternalUserIdList = (output, context) => {
    const retVal = (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        if (entry === null) {
            return null;
        }
        return __expectString(entry);
    });
    return retVal;
};
const deserializeAws_restJson1GeoMatchParams = (output, context) => {
    return {
        AreaCode: __expectString(output.AreaCode),
        Country: __expectString(output.Country),
    };
};
const deserializeAws_restJson1Identity = (output, context) => {
    return {
        Arn: __expectString(output.Arn),
        Name: __expectString(output.Name),
    };
};
const deserializeAws_restJson1Invite = (output, context) => {
    return {
        EmailAddress: __expectString(output.EmailAddress),
        EmailStatus: __expectString(output.EmailStatus),
        InviteId: __expectString(output.InviteId),
        Status: __expectString(output.Status),
    };
};
const deserializeAws_restJson1InviteList = (output, context) => {
    const retVal = (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        if (entry === null) {
            return null;
        }
        return deserializeAws_restJson1Invite(entry, context);
    });
    return retVal;
};
const deserializeAws_restJson1LicenseList = (output, context) => {
    const retVal = (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        if (entry === null) {
            return null;
        }
        return __expectString(entry);
    });
    return retVal;
};
const deserializeAws_restJson1LoggingConfiguration = (output, context) => {
    return {
        EnableMediaMetricLogs: __expectBoolean(output.EnableMediaMetricLogs),
        EnableSIPLogs: __expectBoolean(output.EnableSIPLogs),
    };
};
const deserializeAws_restJson1MediaCapturePipeline = (output, context) => {
    return {
        ChimeSdkMeetingConfiguration: output.ChimeSdkMeetingConfiguration != null
            ? deserializeAws_restJson1ChimeSdkMeetingConfiguration(output.ChimeSdkMeetingConfiguration, context)
            : undefined,
        CreatedTimestamp: output.CreatedTimestamp != null
            ? __expectNonNull(__parseRfc3339DateTimeWithOffset(output.CreatedTimestamp))
            : undefined,
        MediaPipelineId: __expectString(output.MediaPipelineId),
        SinkArn: __expectString(output.SinkArn),
        SinkType: __expectString(output.SinkType),
        SourceArn: __expectString(output.SourceArn),
        SourceType: __expectString(output.SourceType),
        Status: __expectString(output.Status),
        UpdatedTimestamp: output.UpdatedTimestamp != null
            ? __expectNonNull(__parseRfc3339DateTimeWithOffset(output.UpdatedTimestamp))
            : undefined,
    };
};
const deserializeAws_restJson1MediaCapturePipelineList = (output, context) => {
    const retVal = (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        if (entry === null) {
            return null;
        }
        return deserializeAws_restJson1MediaCapturePipeline(entry, context);
    });
    return retVal;
};
const deserializeAws_restJson1MediaPlacement = (output, context) => {
    return {
        AudioFallbackUrl: __expectString(output.AudioFallbackUrl),
        AudioHostUrl: __expectString(output.AudioHostUrl),
        EventIngestionUrl: __expectString(output.EventIngestionUrl),
        ScreenDataUrl: __expectString(output.ScreenDataUrl),
        ScreenSharingUrl: __expectString(output.ScreenSharingUrl),
        ScreenViewingUrl: __expectString(output.ScreenViewingUrl),
        SignalingUrl: __expectString(output.SignalingUrl),
        TurnControlUrl: __expectString(output.TurnControlUrl),
    };
};
const deserializeAws_restJson1Meeting = (output, context) => {
    return {
        ExternalMeetingId: __expectString(output.ExternalMeetingId),
        MediaPlacement: output.MediaPlacement != null
            ? deserializeAws_restJson1MediaPlacement(output.MediaPlacement, context)
            : undefined,
        MediaRegion: __expectString(output.MediaRegion),
        MeetingId: __expectString(output.MeetingId),
    };
};
const deserializeAws_restJson1MeetingList = (output, context) => {
    const retVal = (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        if (entry === null) {
            return null;
        }
        return deserializeAws_restJson1Meeting(entry, context);
    });
    return retVal;
};
const deserializeAws_restJson1Member = (output, context) => {
    return {
        AccountId: __expectString(output.AccountId),
        Email: __expectString(output.Email),
        FullName: __expectString(output.FullName),
        MemberId: __expectString(output.MemberId),
        MemberType: __expectString(output.MemberType),
    };
};
const deserializeAws_restJson1MemberError = (output, context) => {
    return {
        ErrorCode: __expectString(output.ErrorCode),
        ErrorMessage: __expectString(output.ErrorMessage),
        MemberId: __expectString(output.MemberId),
    };
};
const deserializeAws_restJson1MemberErrorList = (output, context) => {
    const retVal = (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        if (entry === null) {
            return null;
        }
        return deserializeAws_restJson1MemberError(entry, context);
    });
    return retVal;
};
const deserializeAws_restJson1Members = (output, context) => {
    const retVal = (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        if (entry === null) {
            return null;
        }
        return deserializeAws_restJson1Identity(entry, context);
    });
    return retVal;
};
const deserializeAws_restJson1MessagingSessionEndpoint = (output, context) => {
    return {
        Url: __expectString(output.Url),
    };
};
const deserializeAws_restJson1OrderedPhoneNumber = (output, context) => {
    return {
        E164PhoneNumber: __expectString(output.E164PhoneNumber),
        Status: __expectString(output.Status),
    };
};
const deserializeAws_restJson1OrderedPhoneNumberList = (output, context) => {
    const retVal = (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        if (entry === null) {
            return null;
        }
        return deserializeAws_restJson1OrderedPhoneNumber(entry, context);
    });
    return retVal;
};
const deserializeAws_restJson1Origination = (output, context) => {
    return {
        Disabled: __expectBoolean(output.Disabled),
        Routes: output.Routes != null ? deserializeAws_restJson1OriginationRouteList(output.Routes, context) : undefined,
    };
};
const deserializeAws_restJson1OriginationRoute = (output, context) => {
    return {
        Host: __expectString(output.Host),
        Port: __expectInt32(output.Port),
        Priority: __expectInt32(output.Priority),
        Protocol: __expectString(output.Protocol),
        Weight: __expectInt32(output.Weight),
    };
};
const deserializeAws_restJson1OriginationRouteList = (output, context) => {
    const retVal = (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        if (entry === null) {
            return null;
        }
        return deserializeAws_restJson1OriginationRoute(entry, context);
    });
    return retVal;
};
const deserializeAws_restJson1Participant = (output, context) => {
    return {
        PhoneNumber: __expectString(output.PhoneNumber),
        ProxyPhoneNumber: __expectString(output.ProxyPhoneNumber),
    };
};
const deserializeAws_restJson1Participants = (output, context) => {
    const retVal = (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        if (entry === null) {
            return null;
        }
        return deserializeAws_restJson1Participant(entry, context);
    });
    return retVal;
};
const deserializeAws_restJson1PhoneNumber = (output, context) => {
    return {
        Associations: output.Associations != null
            ? deserializeAws_restJson1PhoneNumberAssociationList(output.Associations, context)
            : undefined,
        CallingName: __expectString(output.CallingName),
        CallingNameStatus: __expectString(output.CallingNameStatus),
        Capabilities: output.Capabilities != null
            ? deserializeAws_restJson1PhoneNumberCapabilities(output.Capabilities, context)
            : undefined,
        Country: __expectString(output.Country),
        CreatedTimestamp: output.CreatedTimestamp != null
            ? __expectNonNull(__parseRfc3339DateTimeWithOffset(output.CreatedTimestamp))
            : undefined,
        DeletionTimestamp: output.DeletionTimestamp != null
            ? __expectNonNull(__parseRfc3339DateTimeWithOffset(output.DeletionTimestamp))
            : undefined,
        E164PhoneNumber: __expectString(output.E164PhoneNumber),
        PhoneNumberId: __expectString(output.PhoneNumberId),
        ProductType: __expectString(output.ProductType),
        Status: __expectString(output.Status),
        Type: __expectString(output.Type),
        UpdatedTimestamp: output.UpdatedTimestamp != null
            ? __expectNonNull(__parseRfc3339DateTimeWithOffset(output.UpdatedTimestamp))
            : undefined,
    };
};
const deserializeAws_restJson1PhoneNumberAssociation = (output, context) => {
    return {
        AssociatedTimestamp: output.AssociatedTimestamp != null
            ? __expectNonNull(__parseRfc3339DateTimeWithOffset(output.AssociatedTimestamp))
            : undefined,
        Name: __expectString(output.Name),
        Value: __expectString(output.Value),
    };
};
const deserializeAws_restJson1PhoneNumberAssociationList = (output, context) => {
    const retVal = (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        if (entry === null) {
            return null;
        }
        return deserializeAws_restJson1PhoneNumberAssociation(entry, context);
    });
    return retVal;
};
const deserializeAws_restJson1PhoneNumberCapabilities = (output, context) => {
    return {
        InboundCall: __expectBoolean(output.InboundCall),
        InboundMMS: __expectBoolean(output.InboundMMS),
        InboundSMS: __expectBoolean(output.InboundSMS),
        OutboundCall: __expectBoolean(output.OutboundCall),
        OutboundMMS: __expectBoolean(output.OutboundMMS),
        OutboundSMS: __expectBoolean(output.OutboundSMS),
    };
};
const deserializeAws_restJson1PhoneNumberCountriesList = (output, context) => {
    const retVal = (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        if (entry === null) {
            return null;
        }
        return deserializeAws_restJson1PhoneNumberCountry(entry, context);
    });
    return retVal;
};
const deserializeAws_restJson1PhoneNumberCountry = (output, context) => {
    return {
        CountryCode: __expectString(output.CountryCode),
        SupportedPhoneNumberTypes: output.SupportedPhoneNumberTypes != null
            ? deserializeAws_restJson1PhoneNumberTypeList(output.SupportedPhoneNumberTypes, context)
            : undefined,
    };
};
const deserializeAws_restJson1PhoneNumberError = (output, context) => {
    return {
        ErrorCode: __expectString(output.ErrorCode),
        ErrorMessage: __expectString(output.ErrorMessage),
        PhoneNumberId: __expectString(output.PhoneNumberId),
    };
};
const deserializeAws_restJson1PhoneNumberErrorList = (output, context) => {
    const retVal = (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        if (entry === null) {
            return null;
        }
        return deserializeAws_restJson1PhoneNumberError(entry, context);
    });
    return retVal;
};
const deserializeAws_restJson1PhoneNumberList = (output, context) => {
    const retVal = (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        if (entry === null) {
            return null;
        }
        return deserializeAws_restJson1PhoneNumber(entry, context);
    });
    return retVal;
};
const deserializeAws_restJson1PhoneNumberOrder = (output, context) => {
    return {
        CreatedTimestamp: output.CreatedTimestamp != null
            ? __expectNonNull(__parseRfc3339DateTimeWithOffset(output.CreatedTimestamp))
            : undefined,
        OrderedPhoneNumbers: output.OrderedPhoneNumbers != null
            ? deserializeAws_restJson1OrderedPhoneNumberList(output.OrderedPhoneNumbers, context)
            : undefined,
        PhoneNumberOrderId: __expectString(output.PhoneNumberOrderId),
        ProductType: __expectString(output.ProductType),
        Status: __expectString(output.Status),
        UpdatedTimestamp: output.UpdatedTimestamp != null
            ? __expectNonNull(__parseRfc3339DateTimeWithOffset(output.UpdatedTimestamp))
            : undefined,
    };
};
const deserializeAws_restJson1PhoneNumberOrderList = (output, context) => {
    const retVal = (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        if (entry === null) {
            return null;
        }
        return deserializeAws_restJson1PhoneNumberOrder(entry, context);
    });
    return retVal;
};
const deserializeAws_restJson1PhoneNumberTypeList = (output, context) => {
    const retVal = (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        if (entry === null) {
            return null;
        }
        return __expectString(entry);
    });
    return retVal;
};
const deserializeAws_restJson1Proxy = (output, context) => {
    return {
        DefaultSessionExpiryMinutes: __expectInt32(output.DefaultSessionExpiryMinutes),
        Disabled: __expectBoolean(output.Disabled),
        FallBackPhoneNumber: __expectString(output.FallBackPhoneNumber),
        PhoneNumberCountries: output.PhoneNumberCountries != null
            ? deserializeAws_restJson1StringList(output.PhoneNumberCountries, context)
            : undefined,
    };
};
const deserializeAws_restJson1ProxySession = (output, context) => {
    return {
        Capabilities: output.Capabilities != null ? deserializeAws_restJson1CapabilityList(output.Capabilities, context) : undefined,
        CreatedTimestamp: output.CreatedTimestamp != null
            ? __expectNonNull(__parseRfc3339DateTimeWithOffset(output.CreatedTimestamp))
            : undefined,
        EndedTimestamp: output.EndedTimestamp != null
            ? __expectNonNull(__parseRfc3339DateTimeWithOffset(output.EndedTimestamp))
            : undefined,
        ExpiryMinutes: __expectInt32(output.ExpiryMinutes),
        GeoMatchLevel: __expectString(output.GeoMatchLevel),
        GeoMatchParams: output.GeoMatchParams != null
            ? deserializeAws_restJson1GeoMatchParams(output.GeoMatchParams, context)
            : undefined,
        Name: __expectString(output.Name),
        NumberSelectionBehavior: __expectString(output.NumberSelectionBehavior),
        Participants: output.Participants != null ? deserializeAws_restJson1Participants(output.Participants, context) : undefined,
        ProxySessionId: __expectString(output.ProxySessionId),
        Status: __expectString(output.Status),
        UpdatedTimestamp: output.UpdatedTimestamp != null
            ? __expectNonNull(__parseRfc3339DateTimeWithOffset(output.UpdatedTimestamp))
            : undefined,
        VoiceConnectorId: __expectString(output.VoiceConnectorId),
    };
};
const deserializeAws_restJson1ProxySessions = (output, context) => {
    const retVal = (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        if (entry === null) {
            return null;
        }
        return deserializeAws_restJson1ProxySession(entry, context);
    });
    return retVal;
};
const deserializeAws_restJson1RetentionSettings = (output, context) => {
    return {
        ConversationRetentionSettings: output.ConversationRetentionSettings != null
            ? deserializeAws_restJson1ConversationRetentionSettings(output.ConversationRetentionSettings, context)
            : undefined,
        RoomRetentionSettings: output.RoomRetentionSettings != null
            ? deserializeAws_restJson1RoomRetentionSettings(output.RoomRetentionSettings, context)
            : undefined,
    };
};
const deserializeAws_restJson1Room = (output, context) => {
    return {
        AccountId: __expectString(output.AccountId),
        CreatedBy: __expectString(output.CreatedBy),
        CreatedTimestamp: output.CreatedTimestamp != null
            ? __expectNonNull(__parseRfc3339DateTimeWithOffset(output.CreatedTimestamp))
            : undefined,
        Name: __expectString(output.Name),
        RoomId: __expectString(output.RoomId),
        UpdatedTimestamp: output.UpdatedTimestamp != null
            ? __expectNonNull(__parseRfc3339DateTimeWithOffset(output.UpdatedTimestamp))
            : undefined,
    };
};
const deserializeAws_restJson1RoomList = (output, context) => {
    const retVal = (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        if (entry === null) {
            return null;
        }
        return deserializeAws_restJson1Room(entry, context);
    });
    return retVal;
};
const deserializeAws_restJson1RoomMembership = (output, context) => {
    return {
        InvitedBy: __expectString(output.InvitedBy),
        Member: output.Member != null ? deserializeAws_restJson1Member(output.Member, context) : undefined,
        Role: __expectString(output.Role),
        RoomId: __expectString(output.RoomId),
        UpdatedTimestamp: output.UpdatedTimestamp != null
            ? __expectNonNull(__parseRfc3339DateTimeWithOffset(output.UpdatedTimestamp))
            : undefined,
    };
};
const deserializeAws_restJson1RoomMembershipList = (output, context) => {
    const retVal = (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        if (entry === null) {
            return null;
        }
        return deserializeAws_restJson1RoomMembership(entry, context);
    });
    return retVal;
};
const deserializeAws_restJson1RoomRetentionSettings = (output, context) => {
    return {
        RetentionDays: __expectInt32(output.RetentionDays),
    };
};
const deserializeAws_restJson1SelectedVideoStreams = (output, context) => {
    return {
        AttendeeIds: output.AttendeeIds != null ? deserializeAws_restJson1AttendeeIdList(output.AttendeeIds, context) : undefined,
        ExternalUserIds: output.ExternalUserIds != null
            ? deserializeAws_restJson1ExternalUserIdList(output.ExternalUserIds, context)
            : undefined,
    };
};
const deserializeAws_restJson1SensitiveStringList = (output, context) => {
    const retVal = (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        if (entry === null) {
            return null;
        }
        return __expectString(entry);
    });
    return retVal;
};
const deserializeAws_restJson1SigninDelegateGroup = (output, context) => {
    return {
        GroupName: __expectString(output.GroupName),
    };
};
const deserializeAws_restJson1SigninDelegateGroupList = (output, context) => {
    const retVal = (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        if (entry === null) {
            return null;
        }
        return deserializeAws_restJson1SigninDelegateGroup(entry, context);
    });
    return retVal;
};
const deserializeAws_restJson1SipMediaApplication = (output, context) => {
    return {
        AwsRegion: __expectString(output.AwsRegion),
        CreatedTimestamp: output.CreatedTimestamp != null
            ? __expectNonNull(__parseRfc3339DateTimeWithOffset(output.CreatedTimestamp))
            : undefined,
        Endpoints: output.Endpoints != null
            ? deserializeAws_restJson1SipMediaApplicationEndpointList(output.Endpoints, context)
            : undefined,
        Name: __expectString(output.Name),
        SipMediaApplicationId: __expectString(output.SipMediaApplicationId),
        UpdatedTimestamp: output.UpdatedTimestamp != null
            ? __expectNonNull(__parseRfc3339DateTimeWithOffset(output.UpdatedTimestamp))
            : undefined,
    };
};
const deserializeAws_restJson1SipMediaApplicationCall = (output, context) => {
    return {
        TransactionId: __expectString(output.TransactionId),
    };
};
const deserializeAws_restJson1SipMediaApplicationEndpoint = (output, context) => {
    return {
        LambdaArn: __expectString(output.LambdaArn),
    };
};
const deserializeAws_restJson1SipMediaApplicationEndpointList = (output, context) => {
    const retVal = (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        if (entry === null) {
            return null;
        }
        return deserializeAws_restJson1SipMediaApplicationEndpoint(entry, context);
    });
    return retVal;
};
const deserializeAws_restJson1SipMediaApplicationList = (output, context) => {
    const retVal = (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        if (entry === null) {
            return null;
        }
        return deserializeAws_restJson1SipMediaApplication(entry, context);
    });
    return retVal;
};
const deserializeAws_restJson1SipMediaApplicationLoggingConfiguration = (output, context) => {
    return {
        EnableSipMediaApplicationMessageLogs: __expectBoolean(output.EnableSipMediaApplicationMessageLogs),
    };
};
const deserializeAws_restJson1SipRule = (output, context) => {
    return {
        CreatedTimestamp: output.CreatedTimestamp != null
            ? __expectNonNull(__parseRfc3339DateTimeWithOffset(output.CreatedTimestamp))
            : undefined,
        Disabled: __expectBoolean(output.Disabled),
        Name: __expectString(output.Name),
        SipRuleId: __expectString(output.SipRuleId),
        TargetApplications: output.TargetApplications != null
            ? deserializeAws_restJson1SipRuleTargetApplicationList(output.TargetApplications, context)
            : undefined,
        TriggerType: __expectString(output.TriggerType),
        TriggerValue: __expectString(output.TriggerValue),
        UpdatedTimestamp: output.UpdatedTimestamp != null
            ? __expectNonNull(__parseRfc3339DateTimeWithOffset(output.UpdatedTimestamp))
            : undefined,
    };
};
const deserializeAws_restJson1SipRuleList = (output, context) => {
    const retVal = (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        if (entry === null) {
            return null;
        }
        return deserializeAws_restJson1SipRule(entry, context);
    });
    return retVal;
};
const deserializeAws_restJson1SipRuleTargetApplication = (output, context) => {
    return {
        AwsRegion: __expectString(output.AwsRegion),
        Priority: __expectInt32(output.Priority),
        SipMediaApplicationId: __expectString(output.SipMediaApplicationId),
    };
};
const deserializeAws_restJson1SipRuleTargetApplicationList = (output, context) => {
    const retVal = (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        if (entry === null) {
            return null;
        }
        return deserializeAws_restJson1SipRuleTargetApplication(entry, context);
    });
    return retVal;
};
const deserializeAws_restJson1SourceConfiguration = (output, context) => {
    return {
        SelectedVideoStreams: output.SelectedVideoStreams != null
            ? deserializeAws_restJson1SelectedVideoStreams(output.SelectedVideoStreams, context)
            : undefined,
    };
};
const deserializeAws_restJson1StreamingConfiguration = (output, context) => {
    return {
        DataRetentionInHours: __expectInt32(output.DataRetentionInHours),
        Disabled: __expectBoolean(output.Disabled),
        StreamingNotificationTargets: output.StreamingNotificationTargets != null
            ? deserializeAws_restJson1StreamingNotificationTargetList(output.StreamingNotificationTargets, context)
            : undefined,
    };
};
const deserializeAws_restJson1StreamingNotificationTarget = (output, context) => {
    return {
        NotificationTarget: __expectString(output.NotificationTarget),
    };
};
const deserializeAws_restJson1StreamingNotificationTargetList = (output, context) => {
    const retVal = (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        if (entry === null) {
            return null;
        }
        return deserializeAws_restJson1StreamingNotificationTarget(entry, context);
    });
    return retVal;
};
const deserializeAws_restJson1StringList = (output, context) => {
    const retVal = (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        if (entry === null) {
            return null;
        }
        return __expectString(entry);
    });
    return retVal;
};
const deserializeAws_restJson1Tag = (output, context) => {
    return {
        Key: __expectString(output.Key),
        Value: __expectString(output.Value),
    };
};
const deserializeAws_restJson1TagList = (output, context) => {
    const retVal = (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        if (entry === null) {
            return null;
        }
        return deserializeAws_restJson1Tag(entry, context);
    });
    return retVal;
};
const deserializeAws_restJson1TelephonySettings = (output, context) => {
    return {
        InboundCalling: __expectBoolean(output.InboundCalling),
        OutboundCalling: __expectBoolean(output.OutboundCalling),
        SMS: __expectBoolean(output.SMS),
    };
};
const deserializeAws_restJson1Termination = (output, context) => {
    return {
        CallingRegions: output.CallingRegions != null
            ? deserializeAws_restJson1CallingRegionList(output.CallingRegions, context)
            : undefined,
        CidrAllowedList: output.CidrAllowedList != null ? deserializeAws_restJson1StringList(output.CidrAllowedList, context) : undefined,
        CpsLimit: __expectInt32(output.CpsLimit),
        DefaultPhoneNumber: __expectString(output.DefaultPhoneNumber),
        Disabled: __expectBoolean(output.Disabled),
    };
};
const deserializeAws_restJson1TerminationHealth = (output, context) => {
    return {
        Source: __expectString(output.Source),
        Timestamp: output.Timestamp != null ? __expectNonNull(__parseRfc3339DateTimeWithOffset(output.Timestamp)) : undefined,
    };
};
const deserializeAws_restJson1User = (output, context) => {
    return {
        AccountId: __expectString(output.AccountId),
        AlexaForBusinessMetadata: output.AlexaForBusinessMetadata != null
            ? deserializeAws_restJson1AlexaForBusinessMetadata(output.AlexaForBusinessMetadata, context)
            : undefined,
        DisplayName: __expectString(output.DisplayName),
        InvitedOn: output.InvitedOn != null ? __expectNonNull(__parseRfc3339DateTimeWithOffset(output.InvitedOn)) : undefined,
        LicenseType: __expectString(output.LicenseType),
        PersonalPIN: __expectString(output.PersonalPIN),
        PrimaryEmail: __expectString(output.PrimaryEmail),
        PrimaryProvisionedNumber: __expectString(output.PrimaryProvisionedNumber),
        RegisteredOn: output.RegisteredOn != null ? __expectNonNull(__parseRfc3339DateTimeWithOffset(output.RegisteredOn)) : undefined,
        UserId: __expectString(output.UserId),
        UserInvitationStatus: __expectString(output.UserInvitationStatus),
        UserRegistrationStatus: __expectString(output.UserRegistrationStatus),
        UserType: __expectString(output.UserType),
    };
};
const deserializeAws_restJson1UserError = (output, context) => {
    return {
        ErrorCode: __expectString(output.ErrorCode),
        ErrorMessage: __expectString(output.ErrorMessage),
        UserId: __expectString(output.UserId),
    };
};
const deserializeAws_restJson1UserErrorList = (output, context) => {
    const retVal = (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        if (entry === null) {
            return null;
        }
        return deserializeAws_restJson1UserError(entry, context);
    });
    return retVal;
};
const deserializeAws_restJson1UserList = (output, context) => {
    const retVal = (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        if (entry === null) {
            return null;
        }
        return deserializeAws_restJson1User(entry, context);
    });
    return retVal;
};
const deserializeAws_restJson1UserSettings = (output, context) => {
    return {
        Telephony: output.Telephony != null ? deserializeAws_restJson1TelephonySettings(output.Telephony, context) : undefined,
    };
};
const deserializeAws_restJson1VideoArtifactsConfiguration = (output, context) => {
    return {
        MuxType: __expectString(output.MuxType),
        State: __expectString(output.State),
    };
};
const deserializeAws_restJson1VoiceConnector = (output, context) => {
    return {
        AwsRegion: __expectString(output.AwsRegion),
        CreatedTimestamp: output.CreatedTimestamp != null
            ? __expectNonNull(__parseRfc3339DateTimeWithOffset(output.CreatedTimestamp))
            : undefined,
        Name: __expectString(output.Name),
        OutboundHostName: __expectString(output.OutboundHostName),
        RequireEncryption: __expectBoolean(output.RequireEncryption),
        UpdatedTimestamp: output.UpdatedTimestamp != null
            ? __expectNonNull(__parseRfc3339DateTimeWithOffset(output.UpdatedTimestamp))
            : undefined,
        VoiceConnectorArn: __expectString(output.VoiceConnectorArn),
        VoiceConnectorId: __expectString(output.VoiceConnectorId),
    };
};
const deserializeAws_restJson1VoiceConnectorGroup = (output, context) => {
    return {
        CreatedTimestamp: output.CreatedTimestamp != null
            ? __expectNonNull(__parseRfc3339DateTimeWithOffset(output.CreatedTimestamp))
            : undefined,
        Name: __expectString(output.Name),
        UpdatedTimestamp: output.UpdatedTimestamp != null
            ? __expectNonNull(__parseRfc3339DateTimeWithOffset(output.UpdatedTimestamp))
            : undefined,
        VoiceConnectorGroupArn: __expectString(output.VoiceConnectorGroupArn),
        VoiceConnectorGroupId: __expectString(output.VoiceConnectorGroupId),
        VoiceConnectorItems: output.VoiceConnectorItems != null
            ? deserializeAws_restJson1VoiceConnectorItemList(output.VoiceConnectorItems, context)
            : undefined,
    };
};
const deserializeAws_restJson1VoiceConnectorGroupList = (output, context) => {
    const retVal = (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        if (entry === null) {
            return null;
        }
        return deserializeAws_restJson1VoiceConnectorGroup(entry, context);
    });
    return retVal;
};
const deserializeAws_restJson1VoiceConnectorItem = (output, context) => {
    return {
        Priority: __expectInt32(output.Priority),
        VoiceConnectorId: __expectString(output.VoiceConnectorId),
    };
};
const deserializeAws_restJson1VoiceConnectorItemList = (output, context) => {
    const retVal = (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        if (entry === null) {
            return null;
        }
        return deserializeAws_restJson1VoiceConnectorItem(entry, context);
    });
    return retVal;
};
const deserializeAws_restJson1VoiceConnectorList = (output, context) => {
    const retVal = (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        if (entry === null) {
            return null;
        }
        return deserializeAws_restJson1VoiceConnector(entry, context);
    });
    return retVal;
};
const deserializeAws_restJson1VoiceConnectorSettings = (output, context) => {
    return {
        CdrBucket: __expectString(output.CdrBucket),
    };
};
const deserializeMetadata = (output) => ({
    httpStatusCode: output.statusCode,
    requestId: output.headers["x-amzn-requestid"] ?? output.headers["x-amzn-request-id"] ?? output.headers["x-amz-request-id"],
    extendedRequestId: output.headers["x-amz-id-2"],
    cfId: output.headers["x-amz-cf-id"],
});
const collectBody = (streamBody = new Uint8Array(), context) => {
    if (streamBody instanceof Uint8Array) {
        return Promise.resolve(streamBody);
    }
    return context.streamCollector(streamBody) || Promise.resolve(new Uint8Array());
};
const collectBodyString = (streamBody, context) => collectBody(streamBody, context).then((body) => context.utf8Encoder(body));
const isSerializableHeaderValue = (value) => value !== undefined &&
    value !== null &&
    value !== "" &&
    (!Object.getOwnPropertyNames(value).includes("length") || value.length != 0) &&
    (!Object.getOwnPropertyNames(value).includes("size") || value.size != 0);
const parseBody = (streamBody, context) => collectBodyString(streamBody, context).then((encoded) => {
    if (encoded.length) {
        return JSON.parse(encoded);
    }
    return {};
});
const parseErrorBody = async (errorBody, context) => {
    const value = await parseBody(errorBody, context);
    value.message = value.message ?? value.Message;
    return value;
};
const loadRestJsonErrorCode = (output, data) => {
    const findKey = (object, key) => Object.keys(object).find((k) => k.toLowerCase() === key.toLowerCase());
    const sanitizeErrorCode = (rawValue) => {
        let cleanValue = rawValue;
        if (typeof cleanValue === "number") {
            cleanValue = cleanValue.toString();
        }
        if (cleanValue.indexOf(",") >= 0) {
            cleanValue = cleanValue.split(",")[0];
        }
        if (cleanValue.indexOf(":") >= 0) {
            cleanValue = cleanValue.split(":")[0];
        }
        if (cleanValue.indexOf("#") >= 0) {
            cleanValue = cleanValue.split("#")[1];
        }
        return cleanValue;
    };
    const headerKey = findKey(output.headers, "x-amzn-errortype");
    if (headerKey !== undefined) {
        return sanitizeErrorCode(output.headers[headerKey]);
    }
    if (data.code !== undefined) {
        return sanitizeErrorCode(data.code);
    }
    if (data["__type"] !== undefined) {
        return sanitizeErrorCode(data["__type"]);
    }
};
