"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Analytics = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const ec2 = require("@aws-cdk/aws-ec2");
const es = require("@aws-cdk/aws-elasticsearch");
const iam = require("@aws-cdk/aws-iam");
const cdk = require("@aws-cdk/core");
/**
 * @experimental
 */
class Analytics extends cdk.Construct {
    /**
     * @experimental
     */
    constructor(scope, id, props) {
        var _b;
        super(scope, id);
        const region = cdk.Stack.of(this).region;
        const account = cdk.Stack.of(this).account;
        // const stack = cdk.Stack.of(this);
        const esDomainName = (_b = props.domainName) !== null && _b !== void 0 ? _b : props.clusterId;
        // PolicyName: ElasticsearchPermissions
        const elasticsearchPermissionsPolicy = new iam.PolicyStatement({
            effect: iam.Effect.ALLOW,
            actions: [
                'es:ESHttp*',
            ],
            principals: [
                new iam.AnyPrincipal,
            ],
            resources: [`arn:aws:es:${region}:${account}:domain/${esDomainName}/*`],
        });
        //Create Elasticsearch service
        const esDomain = new es.Domain(this, 'ElasticsearchDomain', {
            version: es.ElasticsearchVersion.V7_4,
            domainName: esDomainName,
            nodeToNodeEncryption: true,
            encryptionAtRest: {
                enabled: true,
            },
            ebs: {
                volumeSize: 100,
                volumeType: ec2.EbsDeviceVolumeType.GP2,
                enabled: true,
            },
            capacity: {
                masterNodes: 3,
                masterNodeInstanceType: 'm5.large.elasticsearch',
                dataNodes: 2,
                dataNodeInstanceType: 'm5.large.elasticsearch',
            },
            zoneAwareness: {
                enabled: true,
            },
            automatedSnapshotStartHour: 0,
            accessPolicies: [
                elasticsearchPermissionsPolicy,
            ],
            enforceHttps: true,
            logging: {
                slowSearchLogEnabled: true,
                appLogEnabled: true,
                slowIndexLogEnabled: true,
            },
        });
        new cdk.CfnOutput(this, 'ESDomainArn:', { value: esDomain.domainArn });
        new cdk.CfnOutput(this, 'ESDomainEndpoint:', { value: esDomain.domainEndpoint });
    }
}
exports.Analytics = Analytics;
_a = JSII_RTTI_SYMBOL_1;
Analytics[_a] = { fqn: "cdk-soca.Analytics", version: "0.1.121" };
//# sourceMappingURL=data:application/json;base64,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