"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Workload = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_ec2_1 = require("@aws-cdk/aws-ec2");
const cdk = require("@aws-cdk/core");
const analytics_1 = require("./analytics");
const iam_roles_1 = require("./iam-roles");
const network_1 = require("./network");
const scheduler_1 = require("./scheduler");
const storage_1 = require("./storage");
/**
 * @experimental
 */
class Workload extends cdk.Construct {
    /**
     * @experimental
     */
    constructor(scope, id, props = {}) {
        var _b, _c, _d, _e;
        super(scope, id);
        const stack = cdk.Stack.of(this);
        const s3InstallBucket = (_b = props.s3InstallBucket) !== null && _b !== void 0 ? _b : 'solutions-reference';
        const s3InstallFolder = (_c = props.s3InstallFolder) !== null && _c !== void 0 ? _c : 'scale-out-computing-on-aws/v2.5.0';
        // network construct
        const network = new network_1.Network(stack, 'SocaNetwork');
        // assets construct
        // const assets = new Assets(stack, 'S3Assets');
        // iam roles
        new iam_roles_1.IamRoles(stack, 'IamRoles', {
            s3InstallBucketName: s3InstallBucket,
            network,
        });
        // compute node security group
        const computeNodeSecurityGroup = new aws_ec2_1.SecurityGroup(this, 'ComputeNodeSecurityGroup', {
            vpc: network.vpc,
        });
        /**
         * Allow all traffic internally
         */
        computeNodeSecurityGroup.connections.allowInternally(aws_ec2_1.Port.allTraffic());
        const schedulerSecurityGroup = new aws_ec2_1.SecurityGroup(this, 'SchedulerSecurityGroup', {
            vpc: network.vpc,
        });
        /**
         * SchedulerInboundRule
         * Allow all traffic from computeNodeSecurityGroup to schedulerSecurityGroup
         */
        schedulerSecurityGroup.connections.allowFrom(computeNodeSecurityGroup, aws_ec2_1.Port.allTraffic());
        /**
         * SchedulerInboundRuleAllowClientIP
         * SchedulerInboundRuleAllowClientIPHTTPS
         * SchedulerInboundRuleAllowClientIPHTTP
         * 1. Allow SSH traffic from client IP to master host
         * 2. Allow HTTP traffic from client IP to ELB
         * 3. Allow HTTPS traffic from client IP to ELB
         */
        if (props.clientIpCidr) {
            schedulerSecurityGroup.connections.allowFrom(aws_ec2_1.Peer.ipv4(props.clientIpCidr), aws_ec2_1.Port.tcp(22));
            schedulerSecurityGroup.connections.allowFrom(aws_ec2_1.Peer.ipv4(props.clientIpCidr), aws_ec2_1.Port.tcp(80));
            schedulerSecurityGroup.connections.allowFrom(aws_ec2_1.Peer.ipv4(props.clientIpCidr), aws_ec2_1.Port.tcp(443));
        }
        /**
         * Allow traffic between Master agent and compute nodes
         */
        computeNodeSecurityGroup.connections.allowFrom(schedulerSecurityGroup, aws_ec2_1.Port.allTraffic());
        /**
         * Allow ELB healtcheck to communicate with web ui on master host
         */
        schedulerSecurityGroup.connections.allowInternally(aws_ec2_1.Port.tcp(8443));
        const storage = new storage_1.EfsStorage(stack, 'EfsStorage', {
            clusterId: network.clusterId,
            vpc: network.vpc,
            schedulerSecurityGroup,
            computeNodeSecurityGroup,
        });
        // add elasticsearch stack
        new analytics_1.Analytics(stack, 'Analytics', {
            vpc: network.vpc,
            schedulerSecurityGroup: schedulerSecurityGroup,
            clusterId: network.clusterId,
        });
        new scheduler_1.Scheduler(stack, 'Scheduler', {
            s3InstallBucket,
            s3InstallFolder,
            schedulerSecurityGroup,
            network,
            storage,
            instanceType: new aws_ec2_1.InstanceType('m5.large'),
            ldapUserName: (_d = props.ldapUserName) !== null && _d !== void 0 ? _d : 'ldapUserName',
            ldapUserPassword: (_e = props.ldapUserPassword) !== null && _e !== void 0 ? _e : 'ldapUserPassword!123',
        });
    }
}
exports.Workload = Workload;
_a = JSII_RTTI_SYMBOL_1;
Workload[_a] = { fqn: "cdk-soca.Workload", version: "0.1.121" };
//# sourceMappingURL=data:application/json;base64,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