# https://en.wikipedia.org/wiki/List_of_Malaysian_dishes#Malaysian_dishes
malay = {
    'ambuyat',
    'asam pedas',
    'ayam bakar',
    'ayam goreng',
    'ayam masak kicap',
    'ayam masak merah',
    'bubur asyura',
    'bubur kacang hijau',
    'bubur lambuk',
    'bubur pedas',
    'gulai',
    'ikan bakar',
    'ikan goreng',
    'kangkung belacan',
    'ketupat',
    'laksa',
    'lemang',
    'lontong',
    'mee bandung muar',
    'nasi ambeng',
    'nasi campur',
    'nasi dagang',
    'nasi goreng',
    'nasi goreng pattaya',
    'nasi kerabu',
    'nasi lemak',
    'nasi tumpang',
    'nasi ulam',
    'otak otak',
    'pulot tartal',
    'rendang',
    'rojak',
    'roti jala',
    'satay',
    'satay celup',
    'sup kambing',
    'ulam',
    'nasi ayam',
}

chinese = {
    'bak kut teh',
    'bakkwa',
    'banmian',
    'bean sprouts chicken',
    'bubur pulut hitam',
    'chai tow kway',
    'char kway teow',
    'char siu',
    'chee cheong fun',
    'chwee kueh',
    'claypot chicken rice',
    'duck soup noodles',
    'economy rice',
    'fish ball',
    'hae mee',
    'hainanese chicken rice',
    'hokkien mee',
    'kaya toast',
    'kolo mee',
    'loh bak',
    'lor mee',
    'mee pok',
    'mixed rice',
    'oyster omelette',
    'pan mee',
    'pao',
    'popiah',
    'tong sui',
    'wonton mee',
    'yong tau foo',
    'you char kway',
    'yusheng',
    'asam laksa',
    'bubur cha cha',
    'cap cai',
    'curry mee',
    'laksa lemak',
    'mee siam',
    'nyonya bak chang',
}

indian = {
    'adhirasam',
    'appam',
    'bajji',
    'banana leaf rice',
    'chapati',
    'curd rice',
    'dalcha',
    'dosai',
    'fish head curry',
    'fish molee',
    'idli',
    'korma',
    'maggi goreng',
    'mamak',
    'mee goreng',
    'mee goreng mamak',
    'mee rebus',
    'murtabak',
    'murukku',
    'naan',
    'nasi biryani',
    'nasi kandar',
    'paniyaram',
    'papadum',
    'pasembur',
    'payasam',
    'pongal',
    'puliyodarai',
    'puri',
    'putu mayam',
    'rasam',
    'rojak',
    'roti canai',
    'roti prata',
    'roti tissue',
    'sambar',
    'sup kambing',
    'upma',
    'vadai',
}

sabah_sarawak = {
    'bosou',
    'hinava',
    'linatan',
    'linongot',
    'manok pansoh',
    'midin',
    'nasi kombos',
    'nasi laru',
    'nasik aruk',
    'sinalau bakas',
    'tonokon',
    'tuhau',
    'umai',
}

kuih = {
    'ang ku',
    'bahulu',
    'kek batik',
    'heong peng',
    'kek sarawak',
    'amplang',
    'lekor',
    'mee siput muar',
    'rempeyek',
    'apam balik',
    'bingka',
    'borasa',
    'cakoi',
    'kuih cincin',
    'cucur',
    'dodol',
    'kuih gelang',
    'kuih jala',
    'kuih jelurut',
    'kuih jemput jemput',
    'karipap',
    'kuih kelupis',
    'kochi',
    'penyaram',
    'pisang goreng',
    'kuih gulung',
    'kuih kasturi',
    'kuih lapis',
    'kuih lidah',
    'kuih makmur',
    'ondeh ondeh',
    'otokon',
    'kuih pais',
    'pie tee',
    'pulut inti',
    'pulut panggang',
    'putu bambu',
    'putu bumbong',
    'putu mangkuk',
    'kuih gulong',
    'kuih kapit',
    'kuih sapit',
    'seri muka',
}

dessert = {'lamban', 'punjung', 'tapai', 'wajid'}

malaysian_food = malay | chinese | indian | sabah_sarawak | kuih | dessert

hot_ice_beverage = {
    'teh',
    'milo',
    'neslo',
    'kopi',
    'soya',
    'susu',
    'sirap',
    'kosong',
}

hot_ice_beverage_regex = '(?:\s*|ice|hot|cold|ais|panas|sejuk)\s*(?:susu|teh|kosong|soya|kopi|neslo|milo|sirap|coffee|tea)\s*(?:o|\s*)\s*(?:ice|sejuk|hot|panas|cold|ais|\s*)\s*(?:tarik|pull|)\\b'
fruit_juice_regex = '(?:juice|jus)\s*(?:durian|kelapa|manggis|strawberry|nanas|langsat|nangka|cempedak|kedondong|pisang|laici|betik|tembikai|jambu|ciku|nenas|mangga|orange|watermelon|rambutan|strawberri|apple|guava|epal|oren|mango|longan|asam|belimbing|carrot|limau)|(?:durian|kelapa|manggis|strawberry|nanas|langsat|nangka|cempedak|kedondong|pisang|laici|betik|tembikai|jambu|ciku|nenas|mangga|orange|watermelon|rambutan|strawberri|apple|guava|epal|oren|mango|longan|asam|belimbing|carrot|limau)\s*(?:juice|jus)\\b'


unique_beverage = {
    'ais kacang',
    'asam boi',
    'leng chee kang',
    'barley ais',
    'tau hua',
    'cendol',
    'bubur cha bha',
    'tong sui',
    'tealive',
    'bubble tea',
    'milk tea',
    'chatime',
    'boba',
    'laici kang',
}

unique_beverage_regex = '(?:' + '|'.join(list(unique_beverage)) + ')'

fruits = {
    'durian',
    'manggis',
    'longan',
    'laici',
    'rambutan',
    'langsat',
    'cempedak',
    'guava',
    'jambu',
    'betik',
    'belimbing',
    'tembikai',
    'watermelon',
    'nangka',
    'strawberry',
    'strawberri',
    'mangga',
    'mango',
    'nanas',
    'nenas',
    'ciku',
    'apple',
    'epal',
    'carrot',
    'pisang',
    'kelapa',
    'limau',
    'asam',
    'kedondong',
    'oren',
    'orange',
}

american = {
    'hotdog',
    'pie',
    'cookie',
    'cobbler',
    'nacho',
    'stew',
    'barbecue',
    'lime pie',
    'tots',
    'tater',
    'sourdough',
    'cobb',
    'salad',
    'pot roast',
    'twinkies',
    'jerky',
    'fajitas',
    'banana split',
    'cornbread',
    'jambalaya',
    'steak',
    'salmon',
    'meatloaf',
    'grit',
    'macaroni',
    'cheese',
    'crabcake',
    'chip',
    'cioppino',
    'bean',
    'popcorn',
    'ayam goreng',
    'fried chicken',
    'waffle',
}

italian = {
    'pizza',
    'focaccia',
    'carbonara',
    'pizza',
    'risotto',
    'pasta',
    'noodle',
    'tiramisu',
    'lasagne',
}

# https://en.wikipedia.org/wiki/Indonesian_cuisine

indonesian = {
    'acar',
    'ayam bakar',
    'ayam goreng',
    'ayam kecap',
    'bubur ayam',
    'bubur kacang hijau',
    'bubur ketan hitam',
    'gado gado',
    'ikan asin',
    'ikan bakar',
    'ikan goreng',
    'ketupat',
    'lontong',
    'nasi bakar',
    'nasi campur',
    'nasi goreng',
    'nasi kuning',
    'otak otak',
    'perkedel',
    'pindang',
    'rijsttafel',
    'rujak',
    'sambal',
    'sambal goreng udang',
    'sate',
    'semur',
    'sop buntut',
    'soto',
    'soto mie',
    'tahu goreng',
    'telur pindang',
    'tempeh goreng',
    'tempe goreng',
    'tumis kangkung',
}

acehnese = {'mie aceh', 'mie caluk', 'nasi gurih', 'roti canai', 'timphan'}

balinese = {'babi guling', 'betutu', 'lawar', 'nasi bali', 'sate lilit'}

bataknese = {
    'arsik',
    'babi panggang',
    'bentidali ni horbo',
    'dengke mas na niura',
    'itak gurgur',
    'lampet',
    'manuk napinadar',
    'na nidugu',
    'na tinombur',
    'ombusombus',
    'pohulpohul',
    'saksang',
    'sambal',
    'sasagun',
    'tanggotanggo',
    'tipatipa',
    'tuktuk',
}

betawi = {
    'asinan betawi',
    'kerak telor',
    'ketoprak',
    'ketupat sayur',
    'laksa betawi',
    'mie kangkung',
    'nasi uduk',
    'nasi ulam',
    'soto betawi',
}

bugis_makassar = {
    'burasa',
    'coto makassar',
    'gogos',
    'kapurung',
    'konro',
    'pallubasa',
    'sop saudara',
}

cirebonese = {
    'docang',
    'empal gentong',
    'mie koclok',
    'sega jamblang',
    'sega lengko',
    'tahu gejrot',
}

chinese_peranakan = {
    'babi kecap',
    'bakmi',
    'bakpau',
    'bakso',
    'cap cai',
    'fu yung hai',
    'i fu mie',
    'kepiting saus tiram',
    'kwetiau goreng',
    'laksa',
    'lontong cap go meh',
    'lumpia',
    'mie ayam',
    'mie goreng',
    'mie kering',
    'mun tahu',
    'nasi tim',
    'sapo tahu',
    'sekba',
    'siomay',
    'swikee',
}

javanese = {
    'ayam penyet',
    'botok',
    'buntil',
    'gudeg',
    'iga penyet',
    'krechek',
    'kuluban',
    'mie jawa',
    'mie rebus',
    'nasi ambeng',
    'nasi bogana',
    'nasi kucing',
    'nasi liwet',
    'nasi pecel',
    'opor',
    'pecel',
    'pecel lele',
    'rambak petis',
    'rawon',
    'sayur lodeh',
    'selat solo',
    'serundeng',
    'tahu campur',
    'tongseng',
    'trancam',
    'tumpeng',
    'urap',
}

minangkabau = {
    'asam pedas',
    'balado',
    'dendeng',
    'galamai',
    'gulai',
    'kepiting saus padang',
    'keripik sanjay',
    'lemang',
    'nasi kapau',
    'nasi padang',
    'rendang',
    'sate padang',
    'soto padang',
    'udang balado',
}

palembang = {
    'burgo',
    'laksan',
    'lakso',
    'mie celor',
    'nasi minyak',
    'pempek',
    'pindang',
    'tekwan',
    'tempoyak',
}

sasak = {'ayam taliwang', 'beberuk terong', 'plecing kangkung'}

sundanese = {
    'asinan bogor',
    'bandung',
    'batagor',
    'empal gepuk',
    'karedok',
    'kupat tahu',
    'laksa bogor',
    'lalab',
    'mie kocok',
    'nasi timbel',
    'oncom',
    'pepes',
    'sate bandeng',
    'sayur asem',
    'seblak',
    'soto',
    'tahu sumedang',
    'tauge goreng',
}

middle_eastern = {
    'hummus',
    'manakeesh',
    'halloumi',
    'meddamas',
    'falafel',
    'tabouleh',
    'moutabal',
    'ghanoush',
    'fattoush',
    'ummali',
    'shanklish',
    'shawarma',
    'tawook',
    'dolma',
    'kofta',
    'quwarmah',
    'mansaf',
    'kebab',
    'baklava',
    'knafeh',
    'masgouf',
}

indonesian_food = (
    indonesian
    | acehnese
    | balinese
    | bataknese
    | betawi
    | bugis_makassar
    | cirebonese
    | chinese_peranakan
    | javanese
    | minangkabau
    | palembang
    | sasak
    | sundanese
)

total_foods = (
    malaysian_food | indonesian_food | american | italian | middle_eastern
)

total_foods_regex = '(?:' + '|'.join(list(total_foods)) + ')'
