import numpy as np
import pickle, warnings, string

# https://www.kaggle.com/kyakovlev/jigsaw-general-helper-public/code
########################### Url extensions
#################################################################################
url_extensions = """com|net|org|edu|gov|mil|aero|asia|biz|cat|coop|info|int|jobs|mobi|museum|name|post|pro|tel|travel|xxx|nyc|ac|ad|ae|af|ag|ai|al|am|an|ao|aq|ar|as|at|au|aw|ax|az|ba|bb|bd|be|bf|bg|bh|bi|bj|bm|bn|bo|br|bs|bt|bv|bw|by|bz|ca|cc|cd|cf|cg|ch|ci|ck|cl|cm|cn|co|cr|cs|cu|cv|cx|cy|cz|dd|de|dj|dk|dm|do|dz|ec|ee|eg|eh|er|es|et|eu|fi|fj|fk|fm|fo|fr|ga|gb|gd|ge|gf|gg|gh|gi|gl|gm|gn|gp|gq|gr|gs|gt|gu|gw|gy|hk|hm|hn|hr|ht|hu|id|ie|il|im|in|io|iq|ir|is|it|je|jm|jo|jp|ke|kg|kh|ki|km|kn|kp|kr|kw|ky|kz|la|lb|lc|li|lk|lr|ls|lt|lu|lv|ly|ma|mc|md|me|mg|mh|mk|ml|mm|mn|mo|mp|mq|mr|ms|mt|mu|mv|mw|mx|my|mz|na|nc|ne|nf|ng|ni|nl|no|np|nr|nu|nz|om|pa|pe|pf|pg|ph|pk|pl|pm|pn|pr|ps|pt|pw|py|qa|re|ro|rs|ru|rw|sa|sb|sc|sd|se|sg|sh|si|sj|Ja|sk|sl|sm|sn|so|sr|ss|st|su|sv|sx|sy|sz|tc|td|tf|tg|th|tj|tk|tl|tm|tn|to|tp|tr|tt|tv|tw|tz|ua|ug|uk|us|uy|uz|va|vc|ve|vg|vi|vn|vu|wf|ws|ye|yt|yu|za|zm|zw"""
url_extensions = [c for c in url_extensions.split('|')]


########################### HTML valid tags
#################################################################################
html_tags = [
    'a',
    'abbr',
    'address',
    'area',
    'article',
    'aside',
    'audio',
    'b',
    'base',
    'bdi',
    'bdo',
    'blockquote',
    'body',
    'br',
    'button',
    'canvas',
    'caption',
    'cite',
    'code',
    'col',
    'colgroup',
    'data',
    'datalist',
    'dd',
    'del',
    'details',
    'dfn',
    'dialog',
    'div',
    'dl',
    'dt',
    'em',
    'embed',
    'fieldset',
    'figcaption',
    'figure',
    'footer',
    'form',
    'h1',
    'h2',
    'h3',
    'h4',
    'h5',
    'h6',
    'head',
    'header',
    'hgroup',
    'hr',
    'html',
    'i',
    'iframe',
    'img',
    'input',
    'ins',
    'kbd',
    'keygen',
    'label',
    'legend',
    'li',
    'link',
    'main',
    'map',
    'mark',
    'math',
    'menu',
    'menuitem',
    'meta',
    'meter',
    'nav',
    'noscript',
    'object',
    'ol',
    'optgroup',
    'option',
    'output',
    'p',
    'param',
    'picture',
    'pre',
    'progress',
    'q',
    'rb',
    'rp',
    'rt',
    'rtc',
    'ruby',
    's',
    'samp',
    'script',
    'section',
    'select',
    'slot',
    'small',
    'source',
    'span',
    'strong',
    'style',
    'sub',
    'summary',
    'sup',
    'svg',
    'table',
    'tbody',
    'td',
    'template',
    'textarea',
    'tfoot',
    'th',
    'thead',
    'time',
    'title',
    'tr',
    'track',
    'u',
    'ul',
    'var',
    'video',
    'wbr',
]


########################### Good chars Dieter Kernel
#################################################################################
good_chars_dieter = '.,?!-;*"…:—()%#$&_/@＼・ω+=”“[]^–>\\°<~•≠™ˈʊɒ∞§{}·τα❤☺ɡ|¢→̶`❥━┣┫┗Ｏ►★©―ɪ✔®\x96\x92●£♥➤´¹☕≈÷♡◐║▬′ɔː€۩۞†μ✒➥═☆ˌ◄½ʻπδηλσερνʃ✬ＳＵＰＥＲＩＴ☻±♍µº¾✓◾؟．⬅℅»Вав❣⋅¿¬♫ＣＭβ█▓▒░⇒⭐›¡₂₃❧▰▔◞▀▂▃▄▅▆▇↙γ̄″☹➡«φ⅓„✋：¥̲̅́∙‛◇✏▷❓❗¶˚˙）сиʿ✨。ɑ\x80◕！％¯−ﬂﬁ₁²ʌ¼⁴⁄₄⌠♭✘╪▶☭✭♪☔☠♂☃☎✈✌✰❆☙○‣⚓年∎ℒ▪▙☏⅛ｃａｓǀ℮¸ｗ‚∼‖ℳ❄←☼⋆ʒ⊂、⅔¨͡๏⚾⚽Φ×θ￦？（℃⏩☮⚠月✊❌⭕▸■⇌☐☑⚡☄ǫ╭∩╮，例＞ʕɐ̣Δ₀✞┈╱╲▏▕┃╰▊▋╯┳┊≥☒↑☝ɹ✅☛♩☞ＡＪＢ◔◡↓♀⬆̱ℏ\x91⠀ˤ╚↺⇤∏✾◦♬³の｜／∵∴√Ω¤☜▲↳▫‿⬇✧ｏｖｍ－２０８＇‰≤∕ˆ⚜☁'


########################### Bad chars Dieter Kernel
#################################################################################
bad_chars_dieter = '\n🍕\r🐵😑\xa0\ue014\t\uf818\uf04a\xad😢🐶️\uf0e0😜😎👊\u200b\u200e😁عدويهصقأناخلىبمغر😍💖💵Е👎😀😂\u202a\u202c🔥😄🏻💥ᴍʏʀᴇɴᴅᴏᴀᴋʜᴜʟᴛᴄᴘʙғᴊᴡɢ😋👏שלוםבי😱‼\x81エンジ故障\u2009🚌ᴵ͞🌟😊😳😧🙀😐😕\u200f👍😮😃😘אעכח💩💯⛽🚄🏼ஜ😖ᴠ🚲‐😟😈💪🙏🎯🌹😇💔😡\x7f👌ἐὶήιὲκἀίῃἴξ🙄Ｈ😠\ufeff\u2028😉😤⛺🙂\u3000تحكسة👮💙فزط😏🍾🎉😞\u2008🏾😅😭👻😥😔😓🏽🎆🍻🍽🎶🌺🤔😪\x08‑🐰🐇🐱🙆😨🙃💕𝘊𝘦𝘳𝘢𝘵𝘰𝘤𝘺𝘴𝘪𝘧𝘮𝘣💗💚地獄谷улкнПоАН🐾🐕😆ה🔗🚽歌舞伎🙈😴🏿🤗🇺🇸мυтѕ⤵🏆🎃😩\u200a🌠🐟💫💰💎эпрд\x95🖐🙅⛲🍰🤐👆🙌\u2002💛🙁👀🙊🙉\u2004ˢᵒʳʸᴼᴷᴺʷᵗʰᵉᵘ\x13🚬🤓\ue602😵άοόςέὸתמדףנרךצט😒͝🆕👅👥👄🔄🔤👉👤👶👲🔛🎓\uf0b7\uf04c\x9f\x10成都😣⏺😌🤑🌏😯ех😲Ἰᾶὁ💞🚓🔔📚🏀👐\u202d💤🍇\ue613小土豆🏡❔⁉\u202f👠》कर्मा🇹🇼🌸蔡英文🌞🎲レクサス😛外国人关系Сб💋💀🎄💜🤢َِьыгя不是\x9c\x9d🗑\u2005💃📣👿༼つ༽😰ḷЗз▱ц￼🤣卖温哥华议会下降你失去所有的钱加拿大坏税骗子🐝ツ🎅\x85🍺آإشء🎵🌎͟ἔ油别克🤡🤥😬🤧й\u2003🚀🤴ʲшчИОРФДЯМюж😝🖑ὐύύ特殊作戦群щ💨圆明园קℐ🏈😺🌍⏏ệ🍔🐮🍁🍆🍑🌮🌯🤦\u200d𝓒𝓲𝓿𝓵안영하세요ЖљКћ🍀😫🤤ῦ我出生在了可以说普通话汉语好极🎼🕺🍸🥂🗽🎇🎊🆘🤠👩🖒🚪天一家⚲\u2006⚭⚆⬭⬯⏖新✀╌🇫🇷🇩🇪🇮🇬🇧😷🇨🇦ХШ🌐\x1f杀鸡给猴看ʁ𝗪𝗵𝗲𝗻𝘆𝗼𝘂𝗿𝗮𝗹𝗶𝘇𝗯𝘁𝗰𝘀𝘅𝗽𝘄𝗱📺ϖ\u2000үսᴦᎥһͺ\u2007հ\u2001ɩｙｅ൦ｌƽｈ𝐓𝐡𝐞𝐫𝐮𝐝𝐚𝐃𝐜𝐩𝐭𝐢𝐨𝐧Ƅᴨןᑯ໐ΤᏧ௦Іᴑ܁𝐬𝐰𝐲𝐛𝐦𝐯𝐑𝐙𝐣𝐇𝐂𝐘𝟎ԜТᗞ౦〔Ꭻ𝐳𝐔𝐱𝟔𝟓𝐅🐋ﬃ💘💓ё𝘥𝘯𝘶💐🌋🌄🌅𝙬𝙖𝙨𝙤𝙣𝙡𝙮𝙘𝙠𝙚𝙙𝙜𝙧𝙥𝙩𝙪𝙗𝙞𝙝𝙛👺🐷ℋ𝐀𝐥𝐪🚶𝙢Ἱ🤘ͦ💸ج패티Ｗ𝙇ᵻ👂👃ɜ🎫\uf0a7БУі🚢🚂ગુજરાતીῆ🏃𝓬𝓻𝓴𝓮𝓽𝓼☘﴾̯﴿₽\ue807𝑻𝒆𝒍𝒕𝒉𝒓𝒖𝒂𝒏𝒅𝒔𝒎𝒗𝒊👽😙\u200cЛ‒🎾👹⎌🏒⛸公寓养宠物吗🏄🐀🚑🤷操美𝒑𝒚𝒐𝑴🤙🐒欢迎来到阿拉斯ספ𝙫🐈𝒌𝙊𝙭𝙆𝙋𝙍𝘼𝙅ﷻ🦄巨收赢得白鬼愤怒要买额ẽ🚗🐳𝟏𝐟𝟖𝟑𝟕𝒄𝟗𝐠𝙄𝙃👇锟斤拷𝗢𝟳𝟱𝟬⦁マルハニチロ株式社⛷한국어ㄸㅓ니͜ʖ𝘿𝙔₵𝒩ℯ𝒾𝓁𝒶𝓉𝓇𝓊𝓃𝓈𝓅ℴ𝒻𝒽𝓀𝓌𝒸𝓎𝙏ζ𝙟𝘃𝗺𝟮𝟭𝟯𝟲👋🦊多伦🐽🎻🎹⛓🏹🍷🦆为和中友谊祝贺与其想象对法如直接问用自己猜本传教士没积唯认识基督徒曾经让相信耶稣复活死怪他但当们聊些政治题时候战胜因圣把全堂结婚孩恐惧且栗谓这样还♾🎸🤕🤒⛑🎁批判检讨🏝🦁🙋😶쥐스탱트뤼도석유가격인상이경제황을렵게만들지않록잘관리해야합다캐나에서대마초와화약금의품런성분갈때는반드시허된사용🔫👁凸ὰ💲🗯𝙈Ἄ𝒇𝒈𝒘𝒃𝑬𝑶𝕾𝖙𝖗𝖆𝖎𝖌𝖍𝖕𝖊𝖔𝖑𝖉𝖓𝖐𝖜𝖞𝖚𝖇𝕿𝖘𝖄𝖛𝖒𝖋𝖂𝕴𝖟𝖈𝕸👑🚿💡知彼百\uf005𝙀𝒛𝑲𝑳𝑾𝒋𝟒😦𝙒𝘾𝘽🏐𝘩𝘨ὼṑ𝑱𝑹𝑫𝑵𝑪🇰🇵👾ᓇᒧᔭᐃᐧᐦᑳᐨᓃᓂᑲᐸᑭᑎᓀᐣ🐄🎈🔨🐎🤞🐸💟🎰🌝🛳点击查版🍭𝑥𝑦𝑧ＮＧ👣\uf020っ🏉ф💭🎥Ξ🐴👨🤳🦍\x0b🍩𝑯𝒒😗𝟐🏂👳🍗🕉🐲چی𝑮𝗕𝗴🍒ꜥⲣⲏ🐑⏰鉄リ事件ї💊「」\uf203\uf09a\uf222\ue608\uf202\uf099\uf469\ue607\uf410\ue600燻製シ虚偽屁理屈Г𝑩𝑰𝒀𝑺🌤𝗳𝗜𝗙𝗦𝗧🍊ὺἈἡχῖΛ⤏🇳𝒙ψՁմեռայինրւդձ冬至ὀ𝒁🔹🤚🍎𝑷🐂💅𝘬𝘱𝘸𝘷𝘐𝘭𝘓𝘖𝘹𝘲𝘫کΒώ💢ΜΟΝΑΕ🇱♲𝝈↴💒⊘Ȼ🚴🖕🖤🥘📍👈➕🚫🎨🌑🐻𝐎𝐍𝐊𝑭🤖🎎😼🕷ｇｒｎｔｉｄｕｆｂｋ𝟰🇴🇭🇻🇲𝗞𝗭𝗘𝗤👼📉🍟🍦🌈🔭《🐊🐍\uf10aლڡ🐦\U0001f92f\U0001f92a🐡💳ἱ🙇𝗸𝗟𝗠𝗷🥜さようなら🔼'


########################### Contractions
#################################################################################
contractions = {
    "aren't": 'are not',
    "Aren't": 'Are not',
    "AREN'T": 'ARE NOT',
    "C'est": "C'est",
    "C'mon": "C'mon",
    "c'mon": "c'mon",
    "can't": 'cannot',
    "Can't": 'Cannot',
    "CAN'T": 'CANNOT',
    "con't": 'continued',
    "cont'd": 'continued',
    "could've": 'could have',
    "couldn't": 'could not',
    "Couldn't": 'Could not',
    "didn't": 'did not',
    "Didn't": 'Did not',
    "DIDN'T": 'DID NOT',
    "don't": 'do not',
    "Don't": 'Do not',
    "DON'T": 'DO NOT',
    "doesn't": 'does not',
    "Doesn't": 'Does not',
    "else's": 'else',
    "gov's": 'government',
    "Gov's": 'government',
    "gov't": 'government',
    "Gov't": 'government',
    "govt's": 'government',
    "gov'ts": 'governments',
    "hadn't": 'had not',
    "hasn't": 'has not',
    "Hasn't": 'Has not',
    "haven't": 'have not',
    "Haven't": 'Have not',
    "he's": 'he is',
    "He's": 'He is',
    "he'll": 'he will',
    "He'll": 'He will',
    "he'd": 'he would',
    "He'd": 'He would',
    "Here's": 'Here is',
    "here's": 'here is',
    "I'm": 'I am',
    "i'm": 'i am',
    "I'M": 'I am',
    "I've": 'I have',
    "i've": 'i have',
    "I'll": 'I will',
    "i'll": 'i will',
    "I'd": 'I would',
    "i'd": 'i would',
    "ain't": 'is not',
    "isn't": 'is not',
    "Isn't": 'Is not',
    "ISN'T": 'IS NOT',
    "it's": 'it is',
    "It's": 'It is',
    "IT'S": 'IT IS',
    "I's": 'It is',
    "i's": 'it is',
    "it'll": 'it will',
    "It'll": 'It will',
    "it'd": 'it would',
    "It'd": 'It would',
    "Let's": "Let's",
    "let's": 'let us',
    "ma'am": 'madam',
    "Ma'am": 'Madam',
    "she's": 'she is',
    "She's": 'She is',
    "she'll": 'she will',
    "She'll": 'She will',
    "she'd": 'she would',
    "She'd": 'She would',
    "shouldn't": 'should not',
    "that's": 'that is',
    "That's": 'That is',
    "THAT'S": 'THAT IS',
    "THAT's": 'THAT IS',
    "that'll": 'that will',
    "That'll": 'That will',
    "there's": 'there is',
    "There's": 'There is',
    "there'll": 'there will',
    "There'll": 'There will',
    "there'd": 'there would',
    "they're": 'they are',
    "They're": 'They are',
    "they've": 'they have',
    "They've": 'They Have',
    "they'll": 'they will',
    "They'll": 'They will',
    "they'd": 'they would',
    "They'd": 'They would',
    "wasn't": 'was not',
    "we're": 'we are',
    "We're": 'We are',
    "we've": 'we have',
    "We've": 'We have',
    "we'll": 'we will',
    "We'll": 'We will',
    "we'd": 'we would',
    "We'd": 'We would',
    "What'll": 'What will',
    "weren't": 'were not',
    "Weren't": 'Were not',
    "what's": 'what is',
    "What's": 'What is',
    "When's": 'When is',
    "Where's": 'Where is',
    "where's": 'where is',
    "Where'd": 'Where would',
    "who're": 'who are',
    "who've": 'who have',
    "who's": 'who is',
    "Who's": 'Who is',
    "who'll": 'who will',
    "who'd": 'Who would',
    "Who'd": 'Who would',
    "won't": 'will not',
    "Won't": 'will not',
    "WON'T": 'WILL NOT',
    "would've": 'would have',
    "wouldn't": 'would not',
    "Wouldn't": 'Would not',
    "would't": 'would not',
    "Would't": 'Would not',
    "y'all": 'you all',
    "Y'all": 'You all',
    "you're": 'you are',
    "You're": 'You are',
    "YOU'RE": 'YOU ARE',
    "you've": 'you have',
    "You've": 'You have',
    "y'know": 'you know',
    "Y'know": 'You know',
    "ya'll": 'you will',
    "you'll": 'you will',
    "You'll": 'You will',
    "you'd": 'you would',
    "You'd": 'You would',
    "Y'got": 'You got',
    'cause': 'because',
    "had'nt": 'had not',
    "Had'nt": 'Had not',
    "how'd": 'how did',
    "how'd'y": 'how do you',
    "how'll": 'how will',
    "how's": 'how is',
    "I'd've": 'I would have',
    "I'll've": 'I will have',
    "i'd've": 'i would have',
    "i'll've": 'i will have',
    "it'd've": 'it would have',
    "it'll've": 'it will have',
    "mayn't": 'may not',
    "might've": 'might have',
    "mightn't": 'might not',
    "mightn't've": 'might not have',
    "must've": 'must have',
    "mustn't": 'must not',
    "mustn't've": 'must not have',
    "needn't": 'need not',
    "needn't've": 'need not have',
    "o'clock": 'of the clock',
    "oughtn't": 'ought not',
    "oughtn't've": 'ought not have',
    "shan't": 'shall not',
    "sha'n't": 'shall not',
    "shan't've": 'shall not have',
    "she'd've": 'she would have',
    "she'll've": 'she will have',
    "should've": 'should have',
    "shouldn't've": 'should not have',
    "so've": 'so have',
    "so's": 'so as',
    "this's": 'this is',
    "that'd": 'that would',
    "that'd've": 'that would have',
    "there'd've": 'there would have',
    "they'd've": 'they would have',
    "they'll've": 'they will have',
    "to've": 'to have',
    "we'd've": 'we would have',
    "we'll've": 'we will have',
    "what'll": 'what will',
    "what'll've": 'what will have',
    "what're": 'what are',
    "what've": 'what have',
    "when's": 'when is',
    "when've": 'when have',
    "where'd": 'where did',
    "where've": 'where have',
    "who'll've": 'who will have',
    "why's": 'why is',
    "why've": 'why have',
    "will've": 'will have',
    "won't've": 'will not have',
    "wouldn't've": 'would not have',
    "y'all'd": 'you all would',
    "y'all'd've": 'you all would have',
    "y'all're": 'you all are',
    "y'all've": 'you all have',
    "you'd've": 'you would have',
    "you'll've": 'you will have',
}


########################### Chars Normalization
#################################################################################
normalized_chars = {}

chars = '‒–―‐—━—-▬'
for char in chars:
    normalized_chars[ord(char)] = '-'

chars = '«»“”¨"'
for char in chars:
    normalized_chars[ord(char)] = '"'

chars = "’'ʻˈ´`′‘’\x92"
for char in chars:
    normalized_chars[ord(char)] = "'"

chars = '̲_'
for char in chars:
    normalized_chars[ord(char)] = '_'

chars = '\xad\x7f'
for char in chars:
    normalized_chars[ord(char)] = ''

chars = '\n\r\t\u200b\x96'
for char in chars:
    normalized_chars[ord(char)] = ' '


########################### White list chars
#################################################################################
latin_similar = "’'‘ÆÐƎƏƐƔĲŊŒẞÞǷȜæðǝəɛɣĳŋœĸſßþƿȝĄƁÇĐƊĘĦĮƘŁØƠŞȘŢȚŦŲƯY̨Ƴąɓçđɗęħįƙłøơşșţțŧųưy̨ƴÁÀÂÄǍĂĀÃÅǺĄÆǼǢƁĆĊĈČÇĎḌĐƊÐÉÈĖÊËĚĔĒĘẸƎƏƐĠĜǦĞĢƔáàâäǎăāãåǻąæǽǣɓćċĉčçďḍđɗðéèėêëěĕēęẹǝəɛġĝǧğģɣĤḤĦIÍÌİÎÏǏĬĪĨĮỊĲĴĶƘĹĻŁĽĿʼNŃN̈ŇÑŅŊÓÒÔÖǑŎŌÕŐỌØǾƠŒĥḥħıíìiîïǐĭīĩįịĳĵķƙĸĺļłľŀŉńn̈ňñņŋóòôöǒŏōõőọøǿơœŔŘŖŚŜŠŞȘṢẞŤŢṬŦÞÚÙÛÜǓŬŪŨŰŮŲỤƯẂẀŴẄǷÝỲŶŸȲỸƳŹŻŽẒŕřŗſśŝšşșṣßťţṭŧþúùûüǔŭūũűůųụưẃẁŵẅƿýỳŷÿȳỹƴźżžẓ"
white_list_chars = string.ascii_letters + string.digits + latin_similar + ' '
white_list_chars += "'"


########################### Text Pictograms / Emotions
#################################################################################
pictograms = [
    [
        [
            ':‑)',
            ';-))',
            ':)',
            ':-]',
            ':]',
            ':-3',
            ':3',
            ':->',
            ':>',
            '8-)',
            '8)',
            ':-}',
            ':}',
            ':o)',
            ':c)',
            ':^)',
            '=]',
            '=)',
            ':)]',
            ';-}',
            ':>)',
            ':<)',
            ':~)',
            ':))',
            ':-]',
            '=)',
            ':).',
            ':),',
            ':-}',
            ':-)',
        ],
        ['😁'],
    ],
    [
        [':‑D', ':D', '8‑D', '8D', 'x‑D', 'xD', 'X‑D', 'XD', '=D', '=3', 'B^D'],
        ['😃'],
    ],
    [[':-))'], ['😃']],
    [
        [
            ':‑(',
            ':(',
            ':‑c',
            ':c',
            ':‑<',
            ':<',
            ':‑[',
            ':[',
            ':-||',
            '>:[',
            ':{',
            ':@',
            '>:(',
            ':(.',
            '>_<',
            ':-(',
            ':0(',
        ],
        ['😡'],
    ],
    [[":'‑(", ":'(", ':,('], ['😢']],
    [[":'‑)", ":')"], ['😂']],
    [["D‑':", 'D:<', 'D:', 'D8', 'D;', 'D=', 'DX'], ['😱']],
    [
        [
            ':‑O',
            ':O',
            ':‑o',
            ':o',
            ':-0',
            '8‑0',
            '>:O',
            '=:o',
            ':o)',
            ':0)',
            ':o)]',
            '=o)',
        ],
        ['😮'],
    ],
    [[':-*', ':*', ':×'], ['😘']],
    [
        [
            ';‑)',
            ';)',
            '*-)',
            '*)',
            ';‑]',
            ';]',
            ';^)',
            ':‑,',
            ';D',
            ';-))',
            ';>)',
            '=)~',
        ],
        ['😜'],
    ],
    [
        [
            ':‑P',
            ':P',
            'X‑P',
            'XP',
            'x‑p',
            'xp',
            ':‑p',
            ':p',
            ':‑Þ',
            ':Þ',
            ':‑þ',
            ':þ',
            ':‑b',
            ':b',
            'd:',
            '=p',
            '>:P',
            '>:/',
            ':)"',
        ],
        ['😛'],
    ],
    [
        [
            ':‑/',
            ':/',
            ':‑.',
            '>:\\',
            '>:/',
            ':\\',
            '=/',
            '=\\',
            ':L',
            '=L',
            ':S',
        ],
        ['🤔'],
    ],
    [[':‑|', ':|', ':-|', ';-|', ':|'], ['😐']],
    [[':$'], ['😞']],
    [[':‑X', ':X', ':‑#', ':#', ':‑&', ':&'], ['🤐']],
    [['O:‑)', 'O:)', '0:‑3', '0:3', '0:‑)', '0:)', '0;^)'], ['😇']],
    [['>:‑)', '>:)', '}:‑)', '}:)', '3:‑)', '3:)', '>;)'], ['😈']],
    [['|;‑)', '|‑O'], ['😎']],
    [[':‑J'], ['😏']],
    [['%‑)', '%)'], ['😵']],
    [[':‑###..', ':###..'], ['🤢']],
    [['@};- ', '@}->-- ', "@}‑;‑'‑‑‑", '@>‑‑>‑‑'], ['🌹']],
    [['5:‑)', '~:‑\\'], ['Elvis']],
    [['*<|:‑)'], ['🎅']],
    [['~(_8^(I)'], ['Homer Simpson']],
    [['=:o]'], ['Bill Clinton']],
    [['7:^]', ',:‑)'], ['Ronald Reagan']],
    [['</3', '<\3'], ['💔']],
    [['<3'], ['❤']],
    [['><>', '<*)))‑{', '><(((*>'], ['Fish']],
    [['\o/'], ['Yay, yay']],
    [['*\0/*'], ['Cheerleader']],
    [['//0‑0\\\\'], ['John Lennon']],
    [['v.v'], ['😱']],
    [
        ['O_O', 'o‑o', 'O_o', 'o_O', 'o_o', 'O-O', 'o_x', '0_x', 'O_o', 'x_x'],
        ['😮'],
    ],
    [['>.<'], ['🤔']],
]

pictograms_to_emoji = {}
for line in pictograms:
    for k in line[0]:
        pictograms_to_emoji[k] = line[1][0]

########################### Toxic words
#################################################################################
toxic_misspell_dict = {
    's*it': 'shit',
    'sh*t': 'shit',
    's**t': 'shit',
    'shi***': 'shitty',
    'shi**y': 'shitty',
    'shi*': 'shit',
    'shi*s': 'shits',
    'dipsh*t': 'dipshit',
    's%#*': 'shit',
    'Bu**sh*t': 'Bullshit',
    'bullsh*t': 'bullshit',
    'b******t': 'bullshit',
    'b*llsh*t': 'bullshit',
    'batsh*t': 'batshit',
    'sh*tbird': 'shitbird',
    'sh*tty': 'shitty',
    'bullsh*tter': 'bullshitter',
    'sh@#': 'shit',
    'Sh^t': 'shit',
    'sh^t': 'shit',
    'sh@t': 'shit',
    '$het': 'Shit',
    '$h!t': 'shit',
    'sh1t': 'shit',
    'shlt': 'shit',
    '$h*t': 'shit',
    'bat-s**t': 'bat-shit',
    '$hit': 'shit',
    'sh!te': 'shit',
    'sh!t': 'shit',
    'bullsh1t': 'bullshit',
    'b...llsh1t': 'bullshit',
    's***': 'suck',
    '5h1t': 'shit',
    'sh*thole': 'shithole',
    'bats**t': 'batshit',
    'S**t': 'shit',
    'Batsh*t': 'batshit',
    'Bullsh*t': 'Bullshit',
    'SH*T': 'shit',
    'sh**t': 'shit',
    'sh*t-kicked': 'shit kicked',
    's@!t': 'shit',
    'sh@%%t': 'shit',
    's#@t': 'shit',
    '#%@$': 'shit',
    '#*@$': 'shit',
    '^@%#': 'fuck',
    '!@#$': 'fuck',
    's@#t': 'shit',
    'sh@tless': 'shitless',
    '8&@!': 'shit',
    '!@#!!': 'shit',
    '$@%t': 'shit',
    'f@$#': 'fuck',
    'F$$@': 'fuck',
    'F@#$': 'fuck',
    '#@!!%': 'fuck',
    '$%@%ing': 'fucking',
    'F@#k': 'fuck',
    'f@#k': 'fuck',
    '#@!&*': 'fuck',
    'f@#&ing': 'fucking',
    'f@#$^*': 'fucked',
    'F$#@ing': 'fucking',
    '#!$@%^': 'fuck',
    'FU!@#': 'fuck',
    '#%$@er': 'fucker',
    '$@%ing': 'fucking',
    '%#@&ing': 'fucking',
    "*&@k's": 'fuckers',
    '!@#$$!': 'fuck',
    'F#@%ing': 'fucking',
    'F#@*': 'fuck',
    'f@!k': 'fuck',
    '*^@$': 'fuck',
    '$/#@': 'fuck',
    'F!@#in': 'fucking',
    'Fuc@ed': 'fucked',
    'fu@&d': 'fucked',
    'F&@&': 'fuck',
    '$#@^': 'fuck',
    '&@$#': 'fuck',
    '$%@!': 'fuck',
    'fu@#$&': 'fucked',
    '*@#k': 'fuck',
    'F@%!s': 'fucks',
    'fuc$&@ng': 'fucking',
    'f#@k': 'fuck',
    '!$@#%': 'fuck',
    'f******': 'fucking',
    ' f***ing': 'fucking',
    'motherf***ing': 'motherfucking',
    'f***': 'fuck',
    'f***ked': 'fucked',
    'f***ed': 'fucked',
    'fu**ing': 'fucking',
    'clusterf*ck': 'clusterfuck',
    'ratf*cking': 'ratfucking',
    'f*ck': 'fuck',
    'f**k': 'fuck',
    "f**kin'": 'fucking',
    'F**K': 'fuck',
    'F***': 'fuck',
    'F*ck': 'fuck',
    'f**ks': 'fuck',
    'f**cker': 'fucker',
    'F******': 'fucked',
    'f*&$ing': 'fucking',
    'f*k': 'fuck',
    'F*ggot': 'faggot',
    'F*cks': 'fucks',
    'F*CKING': 'fucking',
    'F*** O**': 'fuck off',
    'f*** o**': 'fuck off',
    'f-up': 'fuck up',
    'F-up': 'fuck up',
    'F@#@CK': 'fuck',
    'F---ck': 'fuck',
    'f---ck': 'fuck',
    'f--ck': 'fuck',
    'F--ck': 'fuck',
    'f-ck': 'fuck',
    'F-ck': 'fuck',
    'f-ckin': 'fucking',
    'fu#$ed': 'fucked',
    'f*$(': 'fuck',
    ' f*$K': 'fuck',
    'f__k': 'fuck',
    'f.ck': 'fuck',
    'fck': 'fuck',
    'Fck': 'fuck',
    'F*ing': 'fucking',
    'f*ing': 'fucking',
    'fukin': 'fucking',
    'fuking': 'fucking',
    'f++k': 'fuck',
    'f*%k': 'fuck',
    '.uck': 'fuck',
    'F@ck': 'fuck',
    'fcuking': 'fucking',
    'a55es': 'asses',
    'a**': 'ass',
    'a*#': 'ass',
    'a******': 'asshole',
    'a*****e': 'asshole',
    '@ss': 'ass',
    '@$$': 'ass',
    'A**': 'ass',
    'A**hole': 'asshole',
    '@##': 'ass',
    '@#$': 'ass',
    'a-hole': 'asshole',
    '@sshole': 'asshole',
    '@ssholes': 'asshole',
    'A@@': 'ass',
    'a!@$#$ed': 'assed',
    'ass@s': 'asses',
    'a@#': 'ass',
    'AS^*$@$': 'asses',
    'A#@#$': 'asses',
    '@&&': 'ass',
    'b!tch': 'bitch',
    'b1tch': 'bitch',
    'b*tch': 'bitch',
    'b***h': 'bitch',
    'b***s': 'bitchs',
    'b*th': 'bitch',
    'bit*#^s': 'bitch',
    'b*tt': 'butt',
    'B****': 'bitch',
    'Bit@#$': 'bitch',
    'B***h': 'bitch',
    'Bit*h': 'bitch',
    'bit*h': 'bitch',
    'b****': 'bitch',
    'Bi^@h': 'bitch',
    'B@##S': 'bitchs',
    'Bat-h': 'bitch',
    'b@##$': 'bitch',
    'B@##s': 'bitchs',
    'bit@$': 'bitch',
    'b!t@h': 'bitch',
    'dumb***es': 'dumbasses',
    'Dumb*ss': 'Dumbass',
    'dumba*ss': 'dumbass',
    'broke-a**': 'broke-ass',
    'a***oles': 'assholes',
    'a**holes': 'assholes',
    'da*ned': 'damned',
    'c*#ksukking': 'cock sucking',
    'c***': 'cock',
    'p***y': 'putty',
    'p****': 'putty',
    'P***Y': 'pussy',
    'p***y-grabbing': 'pussy-grabbing',
    'p@$$y': 'pussy',
    'pu$$y': 'pussy',
    'pus$y': 'pussy',
    'pu$sy': 'pussy',
    'p*ssy': 'pussy',
    'pu@#y': 'pussy',
    'p@#$y': 'pussy',
    'puXXy': 'puxxy',
    'puxxy': 'puxxy',
    'N***ga': 'Nigga',
    's*ck': 'suck',
    'suckees': 'sucker',
    'suckee': 'sucker',
    's@#k': 'suck',
    's%@': 'suck',
    's@#K': 'suck',
    'd#$k': 'dick',
    'd@#K': 'dick',
    'd@mn': 'damn',
    'D@mn': 'damn',
    'D@MN': 'damn',
    'da@m': 'damn',
    'p0rn': 'porn',
    '$ex': 'sex',
    'b@stard': 'bastard',
    'b@st@rd': 'bastard',
    'b@#$%^&s': 'bastards',
    'bast@#ds': 'bastards',
    'bas#$@d': 'bastard',
    'b@ssturds': 'bastards',
    'stu*pid': 'stupid',
    'F@KE': 'fake',
    'F@ke': 'fake',
    'N#$@#er': 'nutshell',
    '1%ers': 'very rich people',
    'f@rt': 'fart',
    'd00d': 'dude',
    'n00b': 'noob',
    'ret@rd$': 'retards',
    'ret@rd': 'retard',
    'id-iot': 'idiot',
    'chickens**ts': 'chickenshat',
    'chickens**t': 'chickenshat',
    '0bama': 'obama',
    'ofass': 'of ass',
    'b@t': 'bat',
    'cr@p': 'crap',
    'kr@p': 'crap',
    'c&@p': 'crap',
    'kr@ppy': 'crappy',
    'wh@re': 'whore',
    'b@ll': 'ball',
    'b@ll$': 'balls',
    '6@!!': 'ball',
    'r@pe': 'rape',
    'f@ggot': 'faggot',
    '#@$%': 'cock',
    'su@k': 'suck',
    'r@cist': 'racist',
    'r@ce': 'race',
    'h@ll': 'hell',
    'Isl@m': 'islam',
    '$@rew': 'screwed',
    'scr@wed': 'screwed',
    'j@rk': 'jark',
    's@x': 'sex',
    'idi@t': 'idiot',
    'r@ping': 'raping',
    'V@gina': 'virgina',
    'P^##@*': 'pissed',
    '$k@nk': 'skank',
    'N@zi': 'nazi',
    'MANIA': 'Make America a Nitwit Idiocracy Again',
    'B@t$h!t': 'batshit',
    'bats@3t': 'batshit',
    'f@g': 'fag',
    'R@pe': 'rape',
    's*#@t': 'slot',
    'p@ssw0rd': 'password',
    'p@assword': 'password',
    'Sh*t': 'shit',
    's**T': 'shit',
    'S**T': 'shit',
    'bullSh*t': 'bullshit',
    'BULLSH*T': 'bullshit',
    'B******T': 'bullshit',
    'Bullsh*tter': 'bullshitter',
    'sh1T': 'shit',
    'Sh1t': 'shit',
    'SH1T': 'shit',
    '$Hit': 'shit',
    '$HIT': 'shit',
    'sh!T': 'shit',
    'Sh!t': 'shit',
    'SH!T': 'shit',
    'Bullsh1t': 'bullshit',
    'S***': 'suck',
    'F***ing': 'fucking',
    'F***ked': 'fucked',
    'Fu**ing': 'fucking',
    'F*CK': 'fuck',
    'F**k': 'fuck',
    'F**ks': 'fuck',
    'F**KS': 'fuck',
    'F*k': 'fuck',
    'F-ckin': 'fucking',
    'F__k': 'fuck',
    'F__K': 'fuck',
    'F.ck': 'fuck',
    'fCk': 'fuck',
    'FcK': 'fuck',
    'FCK': 'fuck',
    'Fukin': 'fucking',
    'f++K': 'fuck',
    'F*%k': 'fuck',
    'A*****e': 'asshole',
    '@SS': 'ass',
    'A-hole': 'asshole',
    'A-Hole': 'asshole',
    'A-HOLE': 'asshole',
    'A@#': 'ass',
    'B!tch': 'bitch',
    'B!TCH': 'bitch',
    'B*tch': 'bitch',
    'B***S': 'bitchs',
    'B*tt': 'butt',
    'DUMBA*SS': 'dumbass',
    'A**holes': 'assholes',
    'A**holeS': 'assholes',
    'C***': 'cock',
    'P***y': 'putty',
    'P****': 'putty',
    'P@$$Y': 'pussy',
    'Pu$$y': 'pussy',
    'PU$$Y': 'pussy',
    'PuS$y': 'pussy',
    'P*ssy': 'pussy',
    'Puxxy': 'puxxy',
    'N00b': 'noob',
    '0Bama': 'obama',
    'B@t': 'bat',
    'Cr@p': 'crap',
    'CR@P': 'crap',
    'Kr@p': 'crap',
    'B@ll': 'ball',
    'P@ssw0rd': 'password',
    'bat****': 'batshit',
    'Bat****': 'batshit',
    'a******s': 'assholes',
    'p****d': 'passed',
    's****': 'shit',
    'S****': 'shit',
    'bull****': 'bullshit',
    'Bull****': 'bullshit',
    'n*****': 'niggar',
    'b*****d': 'bastard',
    'r*****d': 'retarded',
    'f*****g': 'fucking',
    "a******'s": 'asshole',
    'f****': 'fuck',
    'moth******': 'mother fucker',
    'F******g': 'fucking',
    'n****r': 'niggar',
    'cr*p': 'crap',
    'a-holes': 'asshole',
    'f--k': 'fuck',
    'a**hole': 'asshole',
    'a$$': 'ass',
    'a$s': 'ass',
    'as$': 'ass',
    '@$s': 'ass',
    '@s$': 'ass',
    '$h': 'sh',
    'f***ing': 'fucking',
    '*ss': 'ass',
    'h***': 'hell',
    'p---y': 'pussy',
    "f'n": 'fucking',
    '*&^%': 'shit',
    'a$$hole': 'asshole',
    'p**sy': 'pussy',
    'f---': 'fuck',
    'pi$$': 'piss',
    "f'd up": 'fucked up',
    'c**k': 'cock',
    'a**clown': 'assclown',
    'p___y': 'pussy',
    'sh--': 'shit',
    'f.cking': 'fucking',
    'a--': 'ass',
    'N—–': 'nigga',
    's*x': 'sex',
    'notalent@$$clown': 'no talent assclown',
    'f--king': 'fucking',
    'a--hole': 'asshole',
    '#whitefragilitycankissmyass': '# white fragility can kiss my ass',
    'N*****': 'niggar',
    'B*****d': 'bastard',
    'F*****G': 'fucking',
    'F****': 'fuck',
    'N****r': 'niggar',
    'Cr*p': 'crap',
    'A-holes': 'asshole',
    'A-Holes': 'asshole',
    'A-HOLES': 'asshole',
    'F--k': 'fuck',
    'F--K': 'fuck',
    'A$$': 'ass',
    '@$S': 'ass',
    '$H': 'sh',
    'F***ing': 'fucking',
    '*SS': 'ass',
    'H***': 'hell',
    'P---y': 'pussy',
    "F'n": 'fucking',
    "F'N": 'fucking',
    'A$$hole': 'asshole',
    'A$$HOLE': 'asshole',
    'P**sy': 'pussy',
    'P**SY': 'pussy',
    'F---': 'fuck',
    'Pi$$': 'piss',
    "F'd up": 'fucked up',
    "F'D UP": 'fucked up',
    'C**k': 'cock',
    'P___y': 'pussy',
    'Sh--': 'shit',
    'SH--': 'shit',
    'A--': 'ass',
    'S*x': 'sex',
    'F--king': 'fucking',
    'A--HOLE': 'asshole',
    'pi**ing': 'pissing',
    '**ok': 'fuck',
    'bi*ch': 'bitch',
    'Sh*ts': 'Shits',
    'Rat****ing': 'fuck',
    '*ds': 'faggots',
    'C*nt': 'Cunt',
    '***ed': 'assholed',
    'h*ll': 'asshole',
    'Re*****s': 'Retards',
    'c*unt': 'cunt',
    'f*rt': 'fuck',
    'p***ing': 'pissing',
    'Pi**ing': 'Pissing',
    'd**m': 'Damn',
    'f***': 'fuck',
    's*': 'Suck',
    'c*nt': 'cunt',
    'dam*d': 'damned',
    'nigg*r': 'nigger',
    'an*l': 'anal',
    'f**t': 'faggot',
    's***': 'shit',
    'H*ll': 'asshole',
    'p***ed': 'pissed',
    'a**ed': 'assholed',
    'd****d': 'fuck',
    'they*you': 'fuck',
    '*****RG': 'fuck',
    'a*s': 'ass',
    'h**l': 'asshole',
    'a*sholes': 'assholes',
    'b****': 'bitch',
    'd*ck': 'fuck',
    'H**L': 'Asshole',
    'mother*cking': 'mother fucking',
    'b*tch': 'bitch',
    'as**in': 'ass',
    'motherfu**ers': 'mother fuckers',
    'bull**it': 'bullshit',
    '****may': '**** may',
    '*Let': '* Let',
}

rules_normalizer = {
    'sapa': 'siapa',
    'tq': 'terima kasih',
    'ty': 'terima kasih',
    'january': 'januari',
    'february': 'februari',
    'march': 'mac',
    'may': 'mei',
    'june': 'jun',
    'july': 'julai',
    'august': 'ogos',
    'october': 'oktober',
    'december': 'disember',
    'dec': 'disember',
    'oct': 'oktober',
    'monday': 'isnin',
    'mon': 'isnin',
    'tuesday': 'selasa',
    'tues': 'selasa',
    'wednesday': 'rabu',
    'wed': 'rabu',
    'thursday': 'khamis',
    'thurs': 'khamis',
    'friday': 'jumaat',
    'fri': 'jumaat',
    'saturday': 'sabtu',
    'sat': 'sabtu',
    'sunday': 'ahad',
    'sun': 'ahad',
    'gemen': 'kerajaan',
    'camtu': 'macam itu',
    'experience': 'pengalaman',
    'kpd': 'kepada',
    'bengng': 'bengang',
    'mntak': 'minta',
    'bagasi': 'bagasi',
    'kg': 'kampung',
    'kilo': 'kilogram',
    'g': 'pergi',
    'grm': 'gram',
    'k': 'okay',
    'abgkat': 'abang dekat',
    'abis': 'habis',
    'ade': 'ada',
    'adoi': 'aduh',
    'adoii': 'aduh',
    'aerodarat': 'kapal darat',
    'agkt': 'angkat',
    'ahh': 'ah',
    'ailior': 'air liur',
    'airasia': 'air asia x',
    'airasiax': 'penerbangan',
    'airline': 'penerbangan',
    'airlines': 'penerbangan',
    'airport': 'lapangan terbang',
    'airpot': 'lapangan terbang',
    'aje': 'saja',
    'ajelah': 'sahajalah',
    'ajer': 'sahaja',
    'ak': 'aku',
    'aq': 'aku',
    'all': 'semua',
    'ambik': 'ambil',
    'amek': 'ambil',
    'amer': 'amir',
    'amik': 'ambil',
    'ana': 'saya',
    'angkt': 'angkat',
    'anual': 'tahunan',
    'apapun': 'apa pun',
    'ape': 'apa',
    'arab': 'arab',
    'area': 'kawasan',
    'aritu': 'hari itu',
    'ask': 'tanya',
    'astro': 'astro',
    'at': 'pada',
    'attitude': 'sikap',
    'babi': 'khinzir',
    'back': 'belakang',
    'bag': 'beg',
    'bang': 'abang',
    'bangla': 'bangladesh',
    'banyk': 'banyak',
    'bard': 'pujangga',
    'bargasi': 'bagasi',
    'bawak': 'bawa',
    'bawanges': 'bawang',
    'be': 'jadi',
    'behave': 'berkelakuan baik',
    'belagak': 'berlagak',
    'berdisiplin': 'berdisplin',
    'berenti': 'berhenti',
    'beskal': 'basikal',
    'bff': 'rakan karib',
    'bg': 'bagi',
    'bgi': 'bagi',
    'biase': 'biasa',
    'big': 'besar',
    'bike': 'basikal',
    'bile': 'bila',
    'binawe': 'binatang',
    'bini': 'isteri',
    'bkn': 'bukan',
    'bla': 'bila',
    'blom': 'belum',
    'bnyak': 'banyak',
    'body': 'tubuh',
    'bole': 'boleh',
    'boss': 'bos',
    'bowling': 'boling',
    'bpe': 'berapa',
    'brand': 'jenama',
    'brg': 'bareng',
    'briefing': 'taklimat',
    'brng': 'barang',
    'bro': 'abang',
    'bru': 'baru',
    'bruntung': 'beruntung',
    'bsikal': 'basikal',
    'btnggjwb': 'bertanggungjawab',
    'btul': 'betul',
    'buatlh': 'buatlah',
    'buh': 'letak',
    'buka': 'buka',
    'but': 'tetapi',
    'bwk': 'bawa',
    'by': 'dengan',
    'byr': 'bayar',
    'bz': 'sibuk',
    'camera': 'kamera',
    'camni': 'macam ini',
    'cane': 'macam mana',
    'cant': 'tak boleh',
    'carakerja': 'cara kerja',
    'care': 'jaga',
    'cargo': 'kargo',
    'cctv': 'kamera litar tertutup',
    'celako': 'celaka',
    'cer': 'cerita',
    'cheap': 'murah',
    'check': 'semak',
    'ciput': 'sedikit',
    'cite': 'cerita',
    'citer': 'cerita',
    'ckit': 'sikit',
    'cikit': 'sikit',
    'ckp': 'cukup',
    'class': 'kelas',
    'cm': 'macam',
    'cmni': 'macam ini',
    'cmpak': 'campak',
    'committed': 'komited',
    'company': 'syarikat',
    'complain': 'aduan',
    'corn': 'jagung',
    'couldnt': 'tak boleh',
    'cr': 'cari',
    'crew': 'krew',
    'cube': 'cuba',
    'cuma': 'cuma',
    'curinyaa': 'curinya',
    'cust': 'pelanggan',
    'customer': 'pelanggan',
    'd': 'di',
    'da': 'dah',
    'dn': 'dan',
    'dahh': 'dah',
    'damaged': 'rosak',
    'dapek': 'dapat',
    'day': 'hari',
    'dazrin': 'dazrin',
    'dbalingnya': 'dibalingnya',
    'de': 'ada',
    'deep': 'dalam',
    'deliberately': 'sengaja',
    'depa': 'mereka',
    'dessa': 'desa',
    'dgn': 'dengan',
    'dh': 'dah',
    'didunia': 'di dunia',
    'diorang': 'mereka',
    'diorng': 'mereka',
    'direct': 'secara terus',
    'diving': 'junam',
    'dkt': 'dekat',
    'dlempar': 'dilempar',
    'dlm': 'dalam',
    'dlt': 'padam',
    'dlu': 'dulu',
    'done': 'siap',
    'dont': 'jangan',
    'dorg': 'mereka',
    'dpermudhkn': 'dipermudahkan',
    'dpt': 'dapat',
    'dri': 'dari',
    'dsb': 'dan sebagainya',
    'dy': 'dia',
    'educate': 'mendidik',
    'ensure': 'memastikan',
    'everything': 'semua',
    'ewahh': 'wah',
    'expect': 'sangka',
    'fb': 'facebook',
    'fired': 'pecat',
    'first': 'pertama',
    'fkr': 'fikir',
    'flight': 'kapal terbang',
    'for': 'untuk',
    'free': 'percuma',
    'friend': 'kawan',
    'fyi': 'untuk pengetahuan anda',
    'gantila': 'gantilah',
    'gantirugi': 'ganti rugi',
    'gentlemen': 'lelaki budiman',
    'gerenti': 'jaminan',
    'gile': 'gila',
    'gk': 'juga',
    'gnti': 'ganti',
    'go': 'pergi',
    'gomen': 'kerajaan',
    'goment': 'kerajaan',
    'good': 'baik',
    'ground': 'tanah',
    'guarno': 'macam mana',
    'hampa': 'mereka',
    'hampeh': 'teruk',
    'hanat': 'jahanam',
    'handle': 'kawal',
    'handling': 'kawalan',
    'hanta': 'hantar',
    'haritu': 'hari itu',
    'harini': 'hari ini',
    'hate': 'benci',
    'have': 'ada',
    'hawau': 'celaka',
    'henpon': 'telefon',
    'heran': 'hairan',
    'him': 'dia',
    'his': 'dia',
    'hmpa': 'mereka',
    'hntr': 'hantar',
    'hotak': 'botak',
    'hr': 'hari',
    'i': 'saya',
    'hrga': 'harga',
    'hrp': 'harap',
    'hu': 'sedih',
    'humble': 'merendah diri',
    'ibon': 'ikon',
    'ichi': 'inci',
    'idung': 'hidung',
    'if': 'jika',
    'ig': 'instagram',
    'iklas': 'ikhlas',
    'improve': 'menambah baik',
    'in': 'masuk',
    'isn t': 'tidak',
    'isyaallah': 'insyallah',
    'ja': 'sahaja',
    'japan': 'jepun',
    'jd': 'jadi',
    'saja': 'sahaja',
    'saje': 'sahaja',
    'je': 'sahaja',
    'jee': 'sahaja',
    'jek': 'sahaja',
    'jepun': 'jepun',
    'jer': 'sahaja',
    'jerr': 'sahaja',
    'jez': 'sahaja',
    'jg': 'juga',
    'jgk': 'juga',
    'jgn': 'jangan',
    'jgnla': 'janganlah',
    'jibake': 'celaka',
    'jjur': 'jujur',
    'job': 'kerja',
    'jobscope': 'skop kerja',
    'jogja': 'jogjakarta',
    'jpam': 'jpam',
    'jth': 'jatuh',
    'jugak': 'juga',
    'ka': 'ke',
    'kalo': 'kalau',
    'kalu': 'kalau',
    'kang': 'nanti',
    'kantoi': 'temberang',
    'kasi': 'kasih',
    'kat': 'dekat',
    'kbye': 'ok bye',
    'kearah': 'ke arah',
    'kecik': 'kecil',
    'keja': 'kerja',
    'keje': 'kerja',
    'kejo': 'kerja',
    'keksongan': 'kekosongan',
    'kemana': 'ke mana',
    'kene': 'kena',
    'kenekan': 'kenakan',
    'kesah': 'kisah',
    'ketempat': 'ke tempat',
    'kije': 'kerja',
    'kijo': 'kerja',
    'kiss': 'cium',
    'kite': 'kita',
    'kito': 'kita',
    'kje': 'kerja',
    'kjr': 'kerja',
    'kk': 'okay',
    'kmi': 'kami',
    'kt': 'kat',
    'tlg': 'tolong',
    'kl': 'kuala lumpur',
    'klai': 'kalau',
    'klau': 'kalau',
    'klia': 'klia',
    'klo': 'kalau',
    'klu': 'kalau',
    'kn': 'kan',
    'knapa': 'kenapa',
    'kne': 'kena',
    'ko': 'kau',
    'kompom': 'sah',
    'korang': 'kamu semua',
    'korea': 'korea',
    'korg': 'kamu semua',
    'kot': 'mungkin',
    'krja': 'kerja',
    'ksalahan': 'kesalahan',
    'kta': 'kita',
    'kuar': 'keluar',
    'kut': 'mungkin',
    'la': 'lah',
    'laa': 'lah',
    'lahabau': 'celaka',
    'lahanat': 'celaka',
    'lainda': 'lain dah',
    'lak': 'pula',
    'last': 'akhir',
    'le': 'lah',
    'leader': 'ketua',
    'leave': 'pergi',
    'ler': 'lah',
    'less': 'kurang',
    'letter': 'surat',
    'lg': 'lagi',
    'lgi': 'lagi',
    'lngsong': 'langsung',
    'lol': 'haha',
    'lorr': 'lah',
    'low': 'rendah',
    'lps': 'lepas',
    'luggage': 'bagasi',
    'lumbe': 'lumba',
    'lyak': 'layak',
    'maap': 'maaf',
    'maapkan': 'maafkan',
    'mahai': 'mahal',
    'mampos': 'mampus',
    'mart': 'kedai',
    'mau': 'mahu',
    'mcm': 'macam',
    'mcmtu': 'macam itu',
    'memerlukn': 'memerlukan',
    'mengembirakan': 'menggembirakan',
    'mengmbilnyer': 'mengambilnya',
    'mengtasi': 'mengatasi',
    'mg': 'memang',
    'mihak': 'memihak',
    'min': 'admin',
    'mingu': 'minggu',
    'mintak': 'minta',
    'mjtuhkn': 'menjatuhkan',
    'mkyong': 'mak yong',
    'mlibatkn': 'melibatkan',
    'mmg': 'memang',
    'mmnjang': 'memanjang',
    'mmpos': 'mampus',
    'mn': 'mana',
    'mna': 'mana',
    'mntk': 'minta',
    'mnyusun': 'menyusun',
    'mood': 'suasana',
    'most': 'paling',
    'mr': 'tuan',
    'msa': 'masa',
    'msia': 'malaysia',
    'mst': 'mesti',
    'mu': 'awak',
    'much': 'banyak',
    'muko': 'muka',
    'mum': 'emak',
    'n': 'dan',
    'nah': 'nah',
    'nanny': 'nenek',
    'napo': 'kenapa',
    'nati': 'nanti',
    'ngan': 'dengan',
    'ngn': 'dengan',
    'ni': 'ini',
    'nie': 'ini',
    'nii': 'ini',
    'nk': 'nak',
    'nmpk': 'nampak',
    'nye': 'nya',
    'ofis': 'pejabat',
    'ohh': 'oh',
    'oii': 'hoi',
    'one': 'satu',
    'online': 'dalam talian',
    'or': 'atau',
    'org': 'orang',
    'orng': 'orang',
    'otek': 'otak',
    'p': 'pergi',
    'paid': 'dah bayar',
    'palabana': 'kepala otak',
    'pasni': 'lepas ini',
    'passengers': 'penumpang',
    'passengger': 'penumpang',
    'pastu': 'lepas itu',
    'pd': 'pada',
    'pegi': 'pergi',
    'pekerje': 'pekerja',
    'pekrja': 'pekerja',
    'perabih': 'perabis',
    'perkerja': 'pekerja',
    'pg': 'pergi',
    'phuii': 'puih',
    'pikir': 'fikir',
    'pilot': 'juruterbang',
    'pk': 'fikir',
    'pkerja': 'pekerja',
    'pkerjaan': 'pekerjaan',
    'pki': 'pakai',
    'please': 'tolong',
    'pls': 'tolong',
    'pn': 'pun',
    'pnh': 'pernah',
    'pnt': 'penat',
    'pnya': 'punya',
    'pon': 'pun',
    'priority': 'keutamaan',
    'properties': 'harta benda',
    'ptugas': 'petugas',
    'pub': 'kelab malam',
    'pulak': 'pula',
    'puye': 'punya',
    'pwrcuma': 'percuma',
    'pyahnya': 'payahnya',
    'quality': 'kualiti',
    'quit': 'keluar',
    'ramly': 'ramly',
    'rege': 'harga',
    'reger': 'harga',
    'report': 'laporan',
    'resigned': 'meletakkan jawatan',
    'respect': 'hormat',
    'rizal': 'rizal',
    'rosak': 'rosak',
    'rosok': 'rosak',
    'rse': 'rasa',
    'sacked': 'buang',
    'sado': 'tegap',
    'salute': 'sanjung',
    'sam': 'sama',
    'same': 'sama',
    'samp': 'sampah',
    'sbb': 'sebab',
    'sbgai': 'sebagai',
    'sblm': 'sebelum',
    'sblum': 'sebelum',
    'sbnarnya': 'sebenarnya',
    'sbum': 'sebelum',
    'sdg': 'sedang',
    'sebb': 'sebab',
    'sebijik': 'sebiji',
    'see': 'sih',
    'seen': 'dilihat',
    'selangor': 'selangor',
    'selfie': 'swafoto',
    'sempoi': 'cantik',
    'senaraihitam': 'senarai hitam',
    'seorg': 'seorang',
    'service': 'perkhidmatan',
    'sgt': 'sangat',
    'shared': 'kongsi',
    'shirt': 'kemeja',
    'shut': 'tutup',
    'sib': 'nasib',
    'skali': 'sekali',
    'sket': 'sikit',
    'sma': 'sama',
    'smoga': 'semoga',
    'smpoi': 'cantik',
    'sndiri': 'sendiri',
    'sndr': 'sendiri',
    'sndri': 'sendiri',
    'sne': 'sana',
    'so': 'jadi',
    'sop': 'tatacara pengendalian piawai',
    'sorang': 'seorang',
    'spoting': 'pembintikan',
    'sronok': 'seronok',
    'ssh': 'susah',
    'staff': 'staf',
    'standing': 'berdiri',
    'start': 'mula',
    'steady': 'mantap',
    'stiap': 'setiap',
    'stress': 'stres',
    'student': 'pelajar',
    'study': 'belajar',
    'studycase': 'kajian kes',
    'sure': 'pasti',
    'sykt': 'syarikat',
    'taik': 'tahi',
    'takan': 'tak akan',
    'takat': 'setakat',
    'takde': 'tak ada',
    'takkan': 'tak akan',
    'taknak': 'tak nak',
    'tang': 'tentang',
    'tanggungjawab': 'bertanggungjawab',
    'taraa': 'sementara',
    'tau': 'tahu',
    'tbabit': 'terbabit',
    'team': 'pasukan',
    'terbaekk': 'terbaik',
    'teruknye': 'teruknya',
    'tgk': 'tengok',
    'that': 'itu',
    'thinking': 'fikir',
    'those': 'itu',
    'time': 'masa',
    'tk': 'tak',
    'tnggongjwb': 'tanggungjawab',
    'tngok': 'tengok',
    'tngu': 'tunggu',
    'to': 'kepada',
    'tosak': 'rosak',
    'tp': 'tapi',
    'tpi': 'tapi',
    'tpon': 'telefon',
    'transfer': 'pindah',
    'trgelak': 'tergelak',
    'ts': 'tan sri',
    'tstony': 'tan sri tony',
    'tu': 'itu',
    'tuh': 'itu',
    'tula': 'itulah',
    'umeno': 'umno',
    'unfortunately': 'malangnya',
    'unhappy': 'tidak gembira',
    'up': 'naik',
    'upkan': 'naikkan',
    'ur': 'awak',
    'utk': 'untuk',
    'very': 'sangat',
    'viral': 'tular',
    'vote': 'undi',
    'warning': 'amaran',
    'warranty': 'waranti',
    'wassap': 'whatsapp',
    'wat': 'apa',
    'weii': 'wei',
    'well': 'maklumlah',
    'win': 'menang',
    'with': 'dengan',
    'wt': 'buat',
    'x': 'tak',
    'tw': 'tahu',
    'ye': 'ya',
    'yee': 'ya',
    'yg': 'yang',
    'yng': 'yang',
    'you': 'awak',
    'your': 'awak',
    'sakai': 'selekeh',
    'rmb': 'billion ringgit',
    'rmj': 'juta ringgit',
    'rmk': 'ribu ringgit',
    'rm': 'ringgit',
    ':*': '<kiss>',
    ':-*': '<kiss>',
    ':x': '<kiss>',
    ':-)': '<happy>',
    ':-))': '<happy>',
    ':-)))': '<happy>',
    ':-))))': '<happy>',
    ':-)))))': '<happy>',
    ':-))))))': '<happy>',
    ':)': '<happy>',
    ':))': '<happy>',
    ':)))': '<happy>',
    ':))))': '<happy>',
    ':)))))': '<happy>',
    ':))))))': '<happy>',
    ':)))))))': '<happy>',
    ':o)': '<happy>',
    ':]': '<happy>',
    ':3': '<happy>',
    ':c)': '<happy>',
    ':>': '<happy>',
    '=]': '<happy>',
    '8)': '<happy>',
    '=)': '<happy>',
    ':}': '<happy>',
    ':^)': '<happy>',
    '|;-)': '<happy>',
    ":'-)": '<happy>',
    ":')": '<happy>',
    '\\o/': '<happy>',
    '*\\0/*': '<happy>',
    ':-D': '<laugh>',
    ':D': '<laugh>',
    '8-D': '<laugh>',
    '8D': '<laugh>',
    'x-D': '<laugh>',
    'xD': '<laugh>',
    'X-D': '<laugh>',
    'XD': '<laugh>',
    '=-D': '<laugh>',
    '=D': '<laugh>',
    '=-3': '<laugh>',
    '=3': '<laugh>',
    'B^D': '<laugh>',
    '>:[': '<sad>',
    ':-(': '<sad>',
    ':-((': '<sad>',
    ':-(((': '<sad>',
    ':-((((': '<sad>',
    ':-(((((': '<sad>',
    ':-((((((': '<sad>',
    ':-(((((((': '<sad>',
    ':(': '<sad>',
    ':((': '<sad>',
    ':(((': '<sad>',
    ':((((': '<sad>',
    ':(((((': '<sad>',
    ':((((((': '<sad>',
    ':(((((((': '<sad>',
    ':((((((((': '<sad>',
    ':-c': '<sad>',
    ':c': '<sad>',
    ':-<': '<sad>',
    ':<': '<sad>',
    ':-[': '<sad>',
    ':[': '<sad>',
    ':{': '<sad>',
    ':-||': '<sad>',
    ':@': '<sad>',
    ":'-(": '<sad>',
    ":'(": '<sad>',
    'D:<': '<sad>',
    'D:': '<sad>',
    'D8': '<sad>',
    'D;': '<sad>',
    'D=': '<sad>',
    'DX': '<sad>',
    'v.v': '<sad>',
    "D-':": '<sad>',
    '(>_<)': '<sad>',
    ':|': '<sad>',
    '>:O': '<surprise>',
    ':-O': '<surprise>',
    ':-o': '<surprise>',
    ':O': '<surprise>',
    '°o°': '<surprise>',
    'o_O': '<surprise>',
    'o_0': '<surprise>',
    'o.O': '<surprise>',
    'o-o': '<surprise>',
    '8-0': '<surprise>',
    '|-O': '<surprise>',
    ';-)': '<wink>',
    ';)': '<wink>',
    '*-)': '<wink>',
    '*)': '<wink>',
    ';-]': '<wink>',
    ';]': '<wink>',
    ';D': '<wink>',
    ';^)': '<wink>',
    ':-,': '<wink>',
    '>:P': '<tong>',
    ':-P': '<tong>',
    ':P': '<tong>',
    'X-P': '<tong>',
    'x-p': '<tong>',
    'xp': '<tong>',
    'XP': '<tong>',
    ':-p': '<tong>',
    ':p': '<tong>',
    '=p': '<tong>',
    ':-Þ': '<tong>',
    ':Þ': '<tong>',
    ':-b': '<tong>',
    ':b': '<tong>',
    ':-&': '<tong>',
    '>:\\': '<annoyed>',
    '>:/': '<annoyed>',
    ':-/': '<annoyed>',
    ':-.': '<annoyed>',
    ':/': '<annoyed>',
    ':\\': '<annoyed>',
    '=/': '<annoyed>',
    '=\\': '<annoyed>',
    ':L': '<annoyed>',
    '=L': '<annoyed>',
    ':S': '<annoyed>',
    '>.<': '<annoyed>',
    ':-|': '<annoyed>',
    '<:-|': '<annoyed>',
    ':-X': '<seallips>',
    ':X': '<seallips>',
    ':-#': '<seallips>',
    ':#': '<seallips>',
    'O:-)': '<angel>',
    '0:-3': '<angel>',
    '0:3': '<angel>',
    '0:-)': '<angel>',
    '0:)': '<angel>',
    '0;^)': '<angel>',
    '>:)': '<devil>',
    '>:D': '<devil>',
    '>:-D': '<devil>',
    '>;)': '<devil>',
    '>:-)': '<devil>',
    '}:-)': '<devil>',
    '}:)': '<devil>',
    '3:-)': '<devil>',
    '3:)': '<devil>',
    'o/\\o': '<highfive>',
    '^5': '<highfive>',
    '>_>^': '<highfive>',
    '^<_<': '<highfive>',
    '<3': '<heart>',
    'met': 'selamat',
    'netaas': 'menetas',
    'keberpa': 'keberapa',
    'kaka': 'kakak',
    'smga': 'semoga',
    'slalu': 'selalu',
    'trus': 'terus',
    'sii': 'sih',
    'nyenengin': 'menyenangkan',
    'bgt': 'sangat',
    'gemess': 'gemas',
    'udah': 'sudah',
    'gitu': 'begitu',
    'aja': 'saja',
    'gemesiin': 'menggemaskan',
    'menyenangkn': 'menyenangkan',
    'akau': 'aku',
    'saranin': 'menyarankan',
    'nemuin': 'menemukan',
    'yah': 'ya',
    'gtu': 'begitu',
    'skarang': 'sekarang',
    'sempet': 'sempat',
    'karna': 'kerana',
    'ngga': 'tidak',
    'mantep': 'mantap',
    'sampe': 'sampai',
    'ngikutin': 'mengikuti',
    'gayany': 'gayanya',
    'bnk': 'bang',
    'pengen': 'ingin',
    'kpan': 'bila',
    'sdkit': 'sedikit',
    'bngt': 'sangat',
    'lgu': 'lagu',
    'kharismanya': 'karismanya',
    'jdi': 'jadi',
    'kek': 'kayak',
    'lgunya': 'lagunya',
    'nyamain': 'menyamakan',
    'lakik': 'laki',
    'nyangka': 'menyangka',
    'inget': 'ingat',
    'bingitsss': 'sangat',
    'dmn': 'dimana',
    'bird': 'biru',
    'gimna': 'bagaimana',
    'nyebur': 'mencebur',
    'dbuat': 'dibuat',
    'pingin': 'ingin',
    'bangcat': 'bangsat',
    'yha': 'ya',
    'tmpt': 'tempat',
    'dhe': 'dah',
    'bgttt': 'sangat',
    'berarto': 'bererti',
    'amiend': 'amien',
    'ameen': 'amin',
    'ngomong': 'bercakap',
    'mamer': 'memamerkan',
    'keles': 'kali',
    'jelase': 'jelas',
    'liat': 'lihat',
    'ntar': 'entar',
    'gini': 'begini',
    'salfok': 'salah fokus',
    'njir': 'anjing',
    'astgfrullah': 'astagfirullah',
    'gbs': 'tak boleh',
    'bhs': 'bahasa',
    'gak': 'juga',
    'bangshad': 'bangsat',
    'stagahhhh': 'astaga',
    'kpn': 'bila',
    'iooo': 'lo',
    'mslh': 'masalah',
    'dhi': 'di',
    'mengherthii': 'mengerti',
    'yanckh': 'yang',
    'chelalyyu': 'selalu',
    'therchakitty': 'tersakiti',
    'bangat': 'sangat',
    'bkin': 'bikin',
    'sweger': 'segar',
    'bingiit': 'sangat',
    'kebukaaa': 'terbuka',
    'keliatan': 'kelihatan',
    'yakk': 'ya',
    'kyk': 'macam',
    'cntiknya': 'cantiknya',
    'bat': 'sangat',
    'ngeliatnya': 'melihatnya',
    'sll': 'selalu',
    'bet': 'sangat',
    'njerr': 'anjing',
    'masi': 'masih',
    'gni': 'begini',
    'hdk': 'hendak',
    'mksud': 'maksud',
    'tetep': 'tetap',
    'mbakx': 'kakak',
    'syantik': 'cantik',
    'mksd': 'maksud',
    'bejilbbnya': 'berjilbabnya',
    'masio': 'masih',
    'yahhh': 'ya',
    'makasih': 'terima kasih',
    'leh': 'boleh',
    'ugaaa': 'juga',
    'jerewi': 'jerawat',
    'ilang': 'hilang',
    'jilbabnyaah': 'jilbabnya',
    'mantes': 'memantas',
    'ucullllll': 'lucu',
    'males': 'malas',
    'mbil': 'sambil',
    'ngmng': 'bercakap',
    'ngemeng': 'bercakap',
    'epe': 'apa',
    'seehh': 'sih',
    'yank': 'sayang',
    'ucul': 'lucu',
    'yahh': 'ya',
    'ngakak': 'mengakak',
    'mnta': 'minta',
    'syg': 'sayang',
    'ntik': 'cantik',
    'pny': 'punya',
    'dapet': 'dapat',
    'suru': 'suruh',
    'ketawakkkk': 'ketawa',
    'kyanya': 'kayanya',
    'bnget': 'sangat',
    'nakutin': 'menakutkan',
    'bgtt': 'sangat',
    'lucuk': 'lucu',
    'megang': 'memegang',
    'kawinin': 'mengawini',
    'liatin': 'perlihatkan',
    'bdan': 'badan',
    'gemesin': 'menggemaskan',
    'fotoin': 'memfoto',
    'ngaku': 'mengaku',
    'pcarny': 'pacarnya',
    'kri': 'kiri',
    'knpa': 'kenapa',
    'pda': 'pada',
    'cmn': 'cuman',
    'namax': 'namanya',
    'bungkusin': 'bungkuskan',
    'atu': 'satu',
    'ngegantiin': 'menggantikan',
    'alloh': 'allah',
    'smpe': 'sampai',
    'msh': 'masih',
    'trsa': 'terasa',
    'khadirannya': 'kehadirannya',
    'fikiran': 'pikiran',
    'hayalanku': 'khayalanku',
    'nton': 'menonton',
    'ngapain': 'mengapai',
    'kgn': 'kangen',
    'ninggalin': 'meninggalkan',
    'smg': 'semoga',
    'terangkhn': 'terangkan',
    'bgtttt': 'sangat',
    'knp': 'kenapa',
    'tuk': 'untuk',
    'slama': 'selama',
    'bngunlah': 'bangunlah',
    'bngun': 'bangun',
    'hiri': 'hari',
    'aza': 'saja',
    'alm': 'almarhum',
    'skrg': 'sekarang',
    'sie': 'itu',
    'benet': 'benar',
    'tuu': 'itu',
    'skrang': 'sekarang',
    'gda': 'tiada',
    'gantiin': 'menggantikan',
    'kklau': 'kalau',
    'acra': 'acara',
    'kasian': 'kasihan',
    'bnerr': 'benar',
    'emk': 'emak',
    'temenn': 'teman',
    'pngenn': 'ingin',
    'ajhh': 'sahaja',
    'mnjadi': 'menjadi',
    'shbt': 'sahabat',
    'bner': 'benar',
    'ktny': 'katanya',
    'dimusiumin': 'dimuseumkan',
    'bntu': 'bantu',
    'udh': 'sudah',
    'kangem': 'rindu',
    'smua': 'semua',
    'slmt': 'selamat',
    'jln': 'jalan',
    'tenny': 'tenang',
    'sdh': 'sudah',
    'tnya': 'tanya',
    'blm': 'belum',
    'kmrn': 'kemarin',
    'wkt': 'waktu',
    'ama': 'sama',
    'lht': 'lihat',
    'mnrtkuu': 'menurutku',
    'trs': 'terus',
    'ikutin': 'mengikuti',
    'jdwl': 'jadwal',
    'dtnggu': 'ditunggu',
    'jan': 'jangan',
    'kunjungin': 'kunjungi',
    'diluangin': 'diluangkan',
    'jga': 'juga',
    'mimin': 'admin',
    'nangis': 'menangis',
    'ngaku"': 'mengaku-ngaku',
    'donkk': 'lah',
    'kejawab': 'terjawab',
    'mohom': 'mohon',
    'kebalas': 'terbalas',
    'nyempetin': 'menyempatkan',
    'wktunya': 'waktunya',
    'ngobrol': 'mengobrol',
    'namain': 'namai',
    'bls': 'balas',
    'ijap': 'ijab',
    'kobul': 'kabul',
    'pst': 'pasti',
    'inggat': 'ingat',
    'brdua': 'berdua',
    'sanggat': 'sangat',
    'hdup': 'hidup',
    'hdp': 'hidup',
    'kedpan': 'kedepan',
    'mndaptkan': 'mendapatkan',
    'iyah': 'iya',
    'sja': 'saja',
    'peengn': 'ingin',
    'tuch': 'tuh',
    'muantteepp': 'mantap',
    'cpt': 'cepat',
    'mrit': 'merit',
    'ngapasih': 'mengapa sih',
    'segitunya': 'sebegitunya',
    'fto': 'foto',
    'pke': 'pakai',
    'sisain': 'menyisakan',
    'slamt': 'selamat',
    'emg': 'memang',
    'pantes': 'pantas',
    'lairannya': 'kelahirannya',
    'jmnya': 'jamnya',
    'ajha': 'saja',
    'nyari': 'mencari',
    'ndak': 'indak',
    'ngerti': 'mengerti',
    'mrekaaaa': 'mereka',
    'yaampuuuunnnn': 'ya ampun',
    'nyanyiin': 'menyanyikan',
    'pgen': 'ingin',
    'tempt': 'tempat',
    'bgini': 'begini',
    'brani': 'berani',
    'ngajak': 'mengajak',
    'kka': 'kakak',
    'yak': 'ya',
    'ttep': 'tetap',
    'sperti': 'seperti',
    'jrang': 'jarang',
    'msuk': 'masuk',
    'gilzz': 'gila',
    'nyaru': 'menyaru',
    'mantabs': 'mantab',
    'jgan': 'jangan',
    'mlu': 'melulu',
    'ntaf': 'mantap',
    'beneran': 'benaran',
    'gada': 'tiada',
    'milikin': 'memiliki',
    'kamo': 'kamu',
    'inih': 'ini',
    'kirain': 'mengira',
    'yach': 'ya',
    'ginii': 'begini',
    'liptsk': 'lipstik',
    'nyeplak': 'menjiplak',
    'kmarin': 'kemarin',
    'mengncang': 'mengencang',
    'ksh': 'kasih',
    'skrng': 'sekarang',
    'mksh': 'terima kasih',
    'ank': 'anak',
    'skitar': 'sekitar',
    'ktmu': 'ketemu',
    'tmen': 'teman',
    'ats': 'atas',
    'donk': 'lah',
    'heii': 'hai',
    'diputusin': 'diputuskan',
    'pcrnya': 'pacarnya',
    'mnjual': 'menjual',
    'ngadain': 'mengadakan',
    'kkak': 'kakak',
    'rekomendasiin': 'rekomendasikan',
    'mrip': 'mirip',
    'mama.nyy': 'mamanya',
    'bosenin': 'membosankan',
    'kmu': 'kamu',
    'bukn': 'bukan',
    'sey': 'sih',
    'banger': 'sangat',
    'kaa': 'kak',
    'eakyu': 'waktu',
    'cntik': 'cantik',
    'kakanya': 'kakaknya',
    'doeloe': 'dulu',
    'bngtt': 'sangat',
    'iyak': 'iya',
    'malh': 'malah',
    'mlah': 'malah',
    'ngak': 'tidak',
    'gag': 'tidak',
    'fhotonya': 'fotonya',
    'bleh': 'boleh',
    'brp': 'berapa',
    'tnggl': 'tanggal',
    'tanteny': 'tantenya',
    'sklinyaa': 'sekalinya',
    'lha': 'lah',
    'dunk': 'lah',
    'yuwkkk': 'yuk',
    'nnti': 'nanti',
    'thu': 'itu',
    'mai': 'mau',
    'nama.a': 'namanya',
    'kmauan': 'kemauan',
    'dmana': 'dimana',
    'bayangin': 'bayangkan',
    'yaudh': 'ya sudah',
    'ajaaa': 'saja',
    'gakuat': 'tidak kuat',
    'nged': 'sangat',
    'nantik': 'nanti',
    'ksitu': 'kesitu',
    'liad': 'lihat',
    'kluarga': 'keluarga',
    'biasahhh': 'biasa',
    'tutorialx': 'tutorialnya',
    'dpke': 'dipakai',
    'fhoto': 'foto',
    'binggo': 'sangat',
    'rekomndd': 'rekomendasi',
    'bwt': 'buat',
    'wado': 'aduh',
    'smpt': 'sempat',
    'blg': 'bilang',
    'trserah': 'terserah',
    'cwo': 'cowok',
    'prnah': 'pernah',
    'wlwpun': 'walaupun',
    'trpsah': 'terpisah',
    'klw': 'kalau',
    'prsatukn': 'persatukan',
    'slh': 'salah',
    'ngomng': 'bercakap',
    'skedar': 'sekadar',
    'klow': 'kalau',
    'muke': 'muka',
    'ajh': 'saja',
    'nyesel': 'menyesal',
    'besarin': 'membesarkan',
    'tanyang': 'tayang',
    'ber2': 'berdua',
    'jngan': 'jangan',
    'ngelarang': 'melarang',
    'bngettt': 'sangat',
    'baperr': 'bawa perasaan',
    'sudh': 'sudah',
    'sbr': 'sabar',
    'pngen': 'ingin',
    'nntn': 'menonton',
    'pemainy': 'pemainnya',
    'aqu': 'aku',
    'ngeliat': 'melihat',
    'baper': 'bawa perasaan',
    'akn': 'akan',
    'nyampe': 'sampai',
    'kbawa': 'terbawa',
    'bradegan': 'beradegan',
    'mlm': 'malam',
    'nikahin': 'menikahi',
    'hadeuh': 'aduh',
    'nyambung': 'menyambung',
    'liyat': 'lihat',
    'krn': 'kerana',
    'adengan': 'adegan',
    'engga': 'tidak',
    'bingit': 'sangat',
    'dapetin': 'mendapatkan',
    'sitayngin': 'ditayangkan',
    'cocokny': 'cocoknya',
    'iniw': 'ini',
    'setju': 'setuju',
    'bnern': 'benaran',
    'pcrn': 'pacaran',
    'klian': 'kalian',
    'bngett': 'sangat',
    'abes': 'habis',
    'mksdny': 'maksudnya',
    'brpa': 'berapa',
    'kesampean': 'kesampaian',
    'ntr': 'hantar',
    'beliin': 'belikan',
    'kya': 'kaya',
    'keq': 'kayak',
    'ngerasa': 'merasa',
    'sygkuu': 'sayangku',
    'ngeselin': 'mengesalkan',
    "baju'a": 'bajunya',
    "pokok'a": 'pokoknya',
    'kuyy': 'yuk',
    'nha': 'nya',
    'rasain': 'merasai',
    'ngelihatnya': 'melihatnya',
    'bdn': 'badan',
    'lau': 'kau',
    'sexxi': 'seksi',
    'bulet': 'bulat',
    'ngocok': 'mengocok',
    'nyoba': 'mencoba',
    'kencqng': 'kencang',
    'kra': 'kira',
    'diginikan': 'dibeginikan',
    'gambarin': 'gambarkan',
    'digambarin': 'digambarkan',
    'klen': 'kalian',
    'bangke': 'bangkai',
    'kog': 'kok',
    'liatnya': 'lihatnya',
    'negri': 'negeri',
    'mbk': 'mbak',
    'pgin': 'ingin',
    'krudungan': 'kerudungan',
    'ajaa': 'saja',
    'maksutku': 'maksudku',
    'njirr': 'anjing',
    "jd'y": 'jadinya',
    'thun': 'tahun',
    'mbg': 'mbak',
    'ngaco': 'mengaco',
    'ngomen': 'mengomentari',
    'gituh': 'begitu',
    'tenggah': 'tengah',
    'ksukaanmuuu': 'kesukaanmu',
    'nontonx': 'menontonnya',
    'dpn': 'depan',
    'gilakkkkkk': 'gila',
    'kepingin': 'ingin',
    'ntappp': 'mantap',
    'cyiiin': 'cinta',
    'iyha': 'iya',
    'muantaap': 'mantap',
    'pake': 'pakai',
    'ngantri': 'mengantri',
    'bli': 'beli',
    'nraktir': 'mentraktir',
    'nonton': 'menonton',
    'sbnyak': 'sebanyak',
    'nontonya': 'menontonnya',
    'nunggu': 'menunggu',
    'qta': 'kita',
    'peen': 'pengin',
    'gga': 'tidak',
    'yaah': 'ya',
    'gilak': 'gila',
    'ceritax': 'ceritanya',
    'kuy': 'ya',
    'udahh': 'sudah',
    'kqmu': 'kamu',
    'banggain': 'banggakan',
    'thn': 'tahun',
    'pengan': 'ingin',
    'sendeng': 'senang',
    'simpen': 'simpan',
    'gakk': 'juga',
    'bagiin': 'membagikan',
    'nanggepin': 'menanggapi',
    'kapn': 'bila',
    'kirimin': 'mengirimi',
    'senengin': 'senangi',
    'ngasih': 'mengasih',
    'bln': 'bulan',
    'teruzzz': 'terus',
    'trbaik': 'terbaik',
    'dlam': 'dalam',
    'jendess': 'janda',
    'sichh': 'sih',
    'namnya': 'namanya',
    'geh': 'gih',
    'nggak': 'tidak',
    '22nya': 'dua-duanya',
    'waww': 'wow',
    'uga': 'juga',
    'njiirr': 'anjing',
    'bgs': 'bagus',
    'gemay': 'gemas',
    'dstu': 'disitu',
    'samoga': 'semoga',
    'nyangkaa': 'menyangka',
    'prnh': 'pernah',
    'lhoo': 'lah',
    'donx': 'lah',
    'gthu': 'begitu',
    'nda': 'indak',
    'berntung': 'beruntung',
    'merka': 'mereka',
    'jln2': 'jalan-jalan',
    'romntis': 'romantis',
    'slamat': 'selamat',
    'ulan': 'ulang',
    'mngkin': 'mungkin',
    'diksi': 'dikasih',
    'taun': 'tahun',
    'nungguin': 'menunggu',
    'ngeluarin': 'mengeluarkan',
    'ughaa': 'juga',
    'banged': 'sangat',
    'abeees': 'habis',
    'adain': 'mengadakan',
    'bsa': 'boleh',
    'beneraan': 'benaran',
    'bgd': 'sangat',
    'catiiiiik': 'cantik',
    'subahanallah': 'subhanallah',
    'padet': 'padat',
    'buktiin': 'membuktikan',
    'cantiq': 'cantik',
    'jelashh': 'jelas',
    'temen': 'teman',
    'nyebelin': 'menyebalkan',
    'diliatnya': 'dilihatnya',
    'gpp': 'tiada apa-apa',
    'gemesnya': 'gemasnya',
    'ngilangin': 'menghilangkan',
    'tbuh': 'tubuh',
    'itungan': 'hitungan',
    'ledekin': 'ledeki',
    'ckup': 'cukup',
    'dptkan': 'dapatkan',
    'ninggiin': 'meninggikan',
    'baget': 'sangat',
    'lgsg': 'langsung',
    'ngk': 'tidak',
    'balesin': 'membalas',
    'gausah': 'tak perlu',
    'lutuna': 'lucunya',
    'ciapa': 'siapa',
    'gemesss': 'gemas',
    'sampek': 'sampai',
    'ckrng': 'sekarang',
    'ngegemesin': 'menggemaskan',
    'imoet': 'imut',
    'jagain': 'menjaga',
    'yahbh': 'ya',
    'msih': 'masih',
    'sktika': 'seketika',
    'lutu': 'lucu',
    'ksni': 'kesini',
    'begok': 'bego',
    'bkan': 'bukan',
    'nti': 'nanti',
    'pgi': 'pagi',
    'bagaatt': 'sangat',
    'gayannxa': 'gayanya',
    'uda': 'sudah',
    'ngekeh': 'kekeh',
    'xlian': 'kalian',
    'lcu': 'lucu',
    'pait': 'pahit',
    'yachhh': 'ya',
    'gokil': 'gila',
    'ngelihat': 'melihat',
    'ngelawak': 'melawak',
    'nyolotinnnn': 'menyolot',
    'smnagatin': 'menyemangati',
    'pakek': 'pakai',
    'kanapa': 'kenapa',
    'cans': 'cantik',
    'banhet': 'sangat',
    'bgttttttt': 'sangat',
    'blng': 'bilang',
    'mngasi': 'mengasih',
    'kmbang': 'kembang',
    'pla': 'pula',
    'blakon': 'berlakon',
    'bngtzt': 'sangat',
    'lucukkkkk': 'lucu',
    'sbelah': 'sebelah',
    'baek': 'baik',
    'ciusss': 'serius',
    'palinf': 'paling',
    'fav': 'favorit',
    'ngakaaaakkk': 'mengakak',
    'gokill': 'gila',
    'ngekek': 'mengekek',
    'pegangin': 'memegang',
    'nyender': 'menyandar',
    'bener': 'benar',
    'manjain': 'memanjakan',
    'peleotin': 'meleot',
    'bng': 'bang',
    'nyatakan': 'menyatakan',
    'bingits': 'sangat',
    'yuppss': 'ya',
    'nyindir': 'menyindir',
    'onoh': 'sono',
    'bnyk': 'banyak',
    'anakny': 'anaknya',
    'begete': 'sangat',
    'ynk': 'sayang',
    'emank': 'memang',
    'diemin': 'diamkan',
    'hancurin': 'menghancurkan',
    'mgkn': 'mungkin',
    'ato': 'atau',
    'diapain': 'diapakan',
    'haragain': 'menghargai',
    'nyakitin': 'menyakiti',
    'sbaiknya': 'sebaiknya',
    'mngerti': 'mengerti',
    'blajar': 'belajar',
    'spt': 'seperti',
    'mnding': 'mending',
    'nyinyirin': 'nyinyir',
    'pdhl': 'padahal',
    'nyerang': 'menyerang',
    'hrs': 'harus',
    'mrk': 'mereka',
    'trima': 'terima',
    'ngomomg': 'bercakap',
    'mang': 'memang',
    'kbetulan': 'kebetulan',
    'orgtuanya': 'orang tuanya',
    'sbelum': 'sebelum',
    'ngamatin': 'mengamati',
    'ngintip': 'mengintip',
    'stelah': 'setelah',
    'ngintilin': 'mengintil',
    'smnjak': 'semenjak',
    'trbukti': 'terbukti',
    'nyambet': 'menyambat',
    'msk': 'masuk',
    'krmh': 'ke rumah',
    'rmh': 'rumah',
    "bo'ong": 'bohong',
    'eloo': 'lo',
    'elo': 'lo',
    'kbiasaan': 'kebiasaan',
    'hdpnya': 'hidupnya',
    'lbh': 'lebih',
    'byk': 'banyak',
    'anknya': 'anaknya',
    'tdr': 'tidur',
    'sbuah': 'sebuah',
    'tdnya': 'tadinya',
    'ank2nya': 'anak-anaknya',
    'milih': 'memilih',
    'branjak': 'beranjak',
    'ank2': 'anak-anak',
    'masyarakay': 'masyarakat',
    'menegerti': 'mengerti',
    'nasehatin': 'menasihati',
    'ngaca': 'mengaca',
    'ajah': 'saja',
    'slamet': 'selamat',
    'ampe': 'sampai',
    'nari': 'menari',
    'ngcpin': 'mengucapkan',
    'iaa': 'iya',
    'kdg': 'kadang',
    'kebagi': 'terbagi',
    'nerusin': 'meneruskan',
    'indo': 'indonesia',
    'univ': 'universitas',
    'maen': 'main',
    'jakety': 'jaketnya',
    'nggk': 'tidak',
    'skli': 'sekali',
    'kli': 'kali',
    'ttp': 'tetap',
    'pala': 'kepala',
    'pucing': 'pusing',
    'maho': 'manusia homo',
    'gantng': 'tampan',
    'alak': 'kepala',
    'hilangv': 'hilang',
    'gapap': 'tiada apa-apa',
    'kyak': 'kayak',
    'pling': 'paling',
    'gokiiill': 'gila',
    'busedh': 'buset',
    'gokilnya': 'gilanya',
    'pluk': 'peluk',
    'kpada': 'kepada',
    'ortu': 'orang tua',
    'ktaa': 'kita',
    'yup': 'ya',
    'tdk': 'tidak',
    'ajja': 'saja',
    'dech': 'dah',
    'oprasi': 'operasi',
    'gya': 'gaya',
    'kndung': 'kandung',
    'sbg': 'sebagai',
    'ksenangan': 'kesenangan',
    'ddpt': 'didapat',
    'jwab': 'jawab',
    'mmbodohkan': 'membodohkan',
    'orlaen': 'orang lain',
    'bgtu': 'begitu',
    'drpd': 'daripada',
    'malem': 'malam',
    'aplikasiin': 'mengaplikasikan',
    'berangat': 'berangkat',
    'praktekin': 'mempraktikkan',
    'gmn': 'bagaimana',
    'omdo': 'omong doang',
    'kate': 'kata',
    'prjuangan': 'perjuangan',
    'kmewahan': 'kemewahan',
    'stimpal': 'setimpal',
    'ddpat': 'didapat',
    'sprt': 'seperti',
    'mnilai': 'menilai',
    'sekarng': 'sekarang',
    'sprti': 'seperti',
    'mkanya': 'makanya',
    'hay': 'hai',
    'mreka': 'mereka',
    'bhagia': 'bahagia',
    'ngebales': 'membalas',
    'krna': 'kerana',
    'sasama': 'sesama',
    'seklian': 'sekalian',
    'kluar': 'keluar',
    'tuuu': 'itu',
    'ngurusan': 'mengurusi',
    'campurin': 'mencampuri',
    'emnknya': 'memangnya',
    'mrangkul': 'merangkul',
    'adlh': 'adalah',
    'wlo': 'walau',
    'manusiy': 'manusia',
    'samara': 'sakinah mawadah rahman',
    'teringt': 'teringat',
    'trmsuk': 'termasuk',
    'pilihnmu': 'pilihanmu',
    'swmntara': 'sementara',
    'trmasuk': 'termasuk',
    'liht': 'lihat',
    'suaminy': 'suaminya',
    'jadulnya': 'jaman dulunya',
    'mantaff': 'mantap',
    'ngata2in': 'mengatai-ngatai',
    'bagaimna': 'bagaimana',
    'bgus': 'bagus',
    'gmana': 'bagaimana',
    'kpleset': 'tergelincir',
    'yawlah': 'ya allah',
    'kepeleset': 'tergelincir',
    'kayanye': 'kayanya',
    'wewww': 'wow',
    'dumsss': 'lah',
    'perbaikin': 'memperbaiki',
    'permasalhkan': 'permasalahkan',
    'jauhin': 'jauhi',
    'dateng': 'datang',
    'ddlm': 'di dalam',
    'kmbali': 'kembali',
    'dkuburnya': 'dikuburnya',
    'ttg': 'tentang',
    'lbih': 'lebih',
    'critamu': 'ceritamu',
    'bres': 'beres',
    'cmkn': 'camkan',
    'diurusin': 'diurusi',
    'biarin': 'biarkan',
    'kale': 'kali',
    'donks': 'lah',
    'mengperbolehkan': 'memperbolehkan',
    'krena': 'kerana',
    'ngri': 'negeri',
    'lma': 'lama',
    "dibangga'in": 'dibangga-banggakan',
    'ngebolehin': 'membolehkan',
    'denger': 'dengar',
    'jelek"in': 'menjelek-jelekkan',
    'gausa': 'tidak perlu',
    'maksain': 'memaksakan',
    'smog': 'semoga',
    'mnerima': 'menerima',
    'baikxa': 'baiknya',
    'nolongin': 'menolong',
    'seluru': 'seluruh',
    'tebir': 'ribet',
    'doangam': 'doang',
    'tebir"': 'ribet-ribet',
    'amad': 'amat',
    'mkst': 'maksud',
    'rempong': 'repot',
    'ngurusin': 'mengurusi',
    'kerjaan': 'pekerjaan',
    'bingittzz': 'sangat',
    'bangets': 'sangat',
    'ikh': 'ih',
    'dwh': 'dah',
    'nengok': 'menengok',
    'bante': 'bantai',
    'komenannya': 'komentarnya',
    'hadapin': 'menghadapi',
    'dengarin': 'mendengarkan',
    'ush': 'usah',
    'widihh': 'idih',
    'mantepp': 'mantap',
    'stu': 'satu',
    'syratnya': 'syaratnya',
    'pnjang': 'panjang',
    'shat': 'sihat',
    'inginkn': 'inginkan',
    'burem': 'buram',
    'tlp': 'telefon',
    'dngan': 'dengan',
    'ngerasain': 'merasai',
    'kancang': 'kencang',
    'tmbh': 'tambah',
    'mansyoallah': 'masyaallah',
    'subhanalloh': 'subhanallah',
    'lkuin': 'lakukan',
    'langgenh': 'langgeng',
    'pkai': 'pakai',
    'org2': 'orang-orang',
    'seneng': 'senang',
    'pdng': 'padang',
    'keedaannya': 'keadaannya',
    'sekrng': 'sekarang',
    'ttap': 'tetap',
    'spertinya': 'sepertinya',
    'mrah': 'marah',
    'gra2': 'gara-gara',
    'sngaja': 'sengaja',
    'jlek': 'jelek',
    'udah2': 'sudah-sudah',
    'gatau': 'tidak tahu',
    'matany': 'matanya',
    'dteng': 'datang',
    "mata'y": 'matanya',
    'emng': 'memang',
    'perubut': 'perebut',
    'sumai': 'suami',
    'urusin': 'urus',
    'apah': 'apa',
    'say': 'sayang',
    'mmbela': 'membela',
    'mslhnya': 'masalahnya',
    'hnya': 'hanya',
    'llki': 'lelaki',
    'dluar': 'diluar',
    'sna': 'sana',
    'dya': 'dia',
    'nyaranin': 'menyarankan',
    'tongolin': 'menongol',
    'cabol': 'cabul',
    'nyet': 'monyet',
    'muna': 'munafik',
    'jing': 'anjing',
    'tot': 'entot',
    'hidiyah': 'hidayah',
    'percya': 'percaya',
    'sya': 'saya',
    'sdri': 'sendiri',
    'tdi': 'tadi',
    'mgkin': 'mungkin',
    'bhwa': 'bahwa',
    'skaligus': 'sekaligus',
    'spti': 'seperti',
    'smakin': 'semakin',
    'bgmn': 'bagaimana',
    'kyknya': 'kayaknya',
    'dng': 'dengan',
    'bbrp': 'beberapa',
    'bhw': 'bahwa',
    'tunjukan': 'tunjukkan',
    'ngasih2': 'mengasih-ngasih',
    'berfikir': 'berpikir',
    'mba': 'mbak',
    'elu': 'awak',
    'ngajuin': 'mengajukan',
    'jkt': 'jakarta',
    'terbaeq': 'terbaik',
    'namany': 'namanya',
    'diakibtkn': 'diakibatkan',
    'suk': 'suka',
    'dsrny': 'dasarnya',
    'jkrta': 'jakarta',
    'ncek': 'encek',
    'kdg2': 'kadang-kadang',
    'sebelumbya': 'sebelumnya',
    'tunjukin': 'tunjukkan',
    'koment': 'komentar',
    'nyampein': 'menyampaikan',
    'naksir': 'menaksir',
    'nafkahin': 'menafkahi',
    'ngitem': 'menghitam',
    'lhat': 'lihat',
    'cantika': 'cantik',
    'cwek': 'cewek',
    'kngen': 'kangen',
    'sinet': 'sinetron',
    'jendral': 'jenderal',
    'nanya': 'bertanya',
    'maenya': 'mainnya',
    'cantiks': 'cantik',
    'wktu': 'waktu',
    'pilm': 'film',
    'taon': 'tahun',
    'slah': 'salah',
    'cini': 'sini',
    'nambah': 'menambah',
    'naek': 'naik',
    'terimaksih': 'terima kasih',
    'kemuh': 'kamu',
    'pinginnn': 'ingin',
    'buanget': 'sangat',
    'kebawa': 'terbawa',
    'wanjerrr': 'anjing',
    'motret': 'memotret',
    'nyeniii': 'menyeni',
    'bget': 'sangat',
    'seeh': 'sih',
    'deuhh': 'duh',
    'b2an': 'berduaan',
    'dihargain': 'dihargai',
    'gilsss': 'gila',
    'nganbek': 'mengambek',
    'enk': 'enak',
    'mendam': 'memendam',
    'manta': 'mantan',
    'bgun': 'bangun',
    'tdur': 'tidur',
    'cntk': 'cantik',
    'knl': 'kenal',
    'anugrah': 'anugerah',
    'slm': 'salam',
    'kliatan': 'kelihatan',
    'awoohhh': 'allah',
    'sbbyak': 'sebanyak',
    'apun': 'apapun',
    'nyangkutnya': 'menyangkutnya',
    'untk': 'untuk',
    'wadaaw': 'aduh',
    'sampw': 'sampai',
    'dijelekin': 'dijelekkan',
    'napa': 'kenapa',
    'azeeeek': 'asik',
    'ntikk': 'cantik',
    'mayan': 'lumayan',
    'mnisss': 'manis',
    'tambahim': 'tambahkan',
    'tambahin': 'tambahkan',
    'make': 'memakai',
    'krpoooo': 'kepo',
    'pengn': 'ingin',
    'nyusul': 'menyusul',
    'nyok': 'yuk',
    'ngiri': 'mengiri',
    'mmang': 'memang',
    'nentuin': 'menentukan',
    'mnjmput': 'menjemput',
    'mblooo': 'jomblo',
    'berexpresi': 'berekspresi',
    'jdulnya': 'judulnya',
    'aurot': 'aurat',
    'laginy': 'laginya',
    'alkhamdulilah': 'alhamdulillah',
    'ktnya': 'katanya',
    'ngeh': 'engah',
    'amen': 'amin',
    'ngmngnya': 'mengomongnya',
    'fotony': 'fotonya',
    'ngiritya': 'mengiritnya',
    'yeeee': 'ya',
    'nget': 'sangat',
    'kususnya': 'khususnya',
    'krm': 'kirim',
    'ajaaahhhhh': 'saja',
    'syediiihhh': 'sedih',
    'kebukti': 'terbukti',
    'tuwanya': 'tuanya',
    'comen2nya': 'komen-komennya',
    'skg': 'sekarang',
    'nyebut2': 'menyebut-nyebut',
    'plg': 'pulang',
    'smbil': 'sambil',
    'hellooooooo': 'hello',
    'ngrebut': 'merebut',
    'mnjdi': 'menjadi',
    'taek': 'tahi',
    'lupain': 'melupakan',
    'bangkret': 'bangkrut',
    'taekk': 'tahi',
    'nyimak': 'menyimak',
    'komenx': 'komennya',
    'ngumpet"': 'mengumpet-ngumpet',
    'blim': 'belum',
    'sekrang': 'sekarang',
    'ngerebut': 'merebut',
    'mnjijikaaaaaan': 'menjijikkan',
    'astgfrlh': 'astagfirullah',
    'gnyngka': 'tak sangka',
    'sendirir': 'sendiri',
    'ngomentnya': 'mengomentarinya',
    'nusuk': 'menusuk',
    'dpotong': 'dipotong',
    'helo': 'hello',
    'kmrin': 'kemarin',
    'ngmgin': 'mengomongkan',
    'gkhianati': 'mengkhianati',
    'pljaran': 'pelajaran',
    'spy': 'supaya',
    'mngikuti': 'mengikuti',
    'klkuan': 'kelakuan',
    'gimana': 'bagaimana',
    'nnt': 'nanti',
    'kasiannn': 'kasihan',
    'syekaliii': 'sekali',
    'hgga': 'hingga',
    'sholihah': 'salihah',
    'adeuh': 'aduh',
    'halahh': 'alah',
    'yoo': 'ya',
    'ginian': 'beginian',
    'artix': 'artinya',
    'cewe': 'cewek',
    'cowo': 'cowok',
    'cwe': 'cewek',
    'serem': 'seram',
    'kepoin': 'kepo',
    'keluarin': 'keluarkan',
    'gajelas': 'tak jelas',
    'pedes': 'pedas',
    'komentnya': 'komentarnya',
    'omongin': 'omongkan',
    'ngalirrrrr': 'mengalir',
    'idup': 'hidup',
    'nmbah': 'menambah',
    'terossss': 'terus',
    'ngehujat': 'menghujat',
    'ngebela': 'membela',
    'seindonesiyah': 'seindonesia',
    'seh': 'sih',
    'senyumin': 'senyumi',
    'ngalir': 'mengalir',
    'ngrusak': 'merosak',
    'kslhn': 'kesalahan',
    'skrngnya': 'sekarangnya',
    'emang': 'memang',
    'kalik': 'kali',
    'bilangin': 'bilang',
    'nyambungin': 'menyambung',
    'sllu': 'selalu',
    'scra': 'secara',
    'nggali': 'menggali',
    'cmpur': 'campur',
    'dgr': 'dengar',
    'kurng': 'kurang',
    'nangiiiiis': 'menangis',
    'nangiiis': 'menangis',
    'ngomentarin': 'mengomentari',
    'idupnya': 'hidupnya',
    'ortunya': 'orang tuanya',
    'woey': 'woy',
    'bloghhh': 'bodoh',
    'ngomongin': 'mengomongkan',
    'doank': 'doang',
    'ngehina': 'menghina',
    'gmna': 'bagaimana',
    'kebanggan': 'kebanggaan',
    'dah': 'dah',
    'jngn': 'jangan',
    'mnjawab': 'menjawab',
    'ingt': 'ingat',
    'ngkkkkkk': 'mengakak',
    'makny': 'maknya',
    'wdooohhh': 'aduh',
    'kasihn': 'kasihan',
    'lhirr': 'lahir',
    'palgi': 'apa lagi',
    'ngets': 'sangat',
    'stp': 'setiap',
    'penbelian': 'pembelian',
    'cuaantik': 'cantik',
    'sukakkk': 'suka',
    'lyt': 'lihat',
    'expresi': 'ekspresi',
    'natap': 'menatap',
    'ccok': 'sesuai',
    'helloo': 'hello',
    'dripada': 'daripada',
    'difotoin': 'difoto',
    'psangan': 'pasangan',
    'ngiriii': 'mengiri',
    'coxok': 'sesuai',
    'buatin': 'membuat',
    'statusx': 'statusnya',
    'cem': 'macam',
    'sunggu': 'sungguh',
    'haddeh': 'aduh',
    'kemn': 'kemana',
    'suipit': 'sipit',
    'kedengeran': 'kedengaran',
    'promil': 'program hamil',
    'lancr': 'lancar',
    'keputihn': 'keputihan',
    'kebayang': 'terbayang',
    'mendapatkn': 'mendapatkan',
    'yaoloh': 'yaallah',
    'ngerayain': 'merayakan',
    'sotoy': 'sok tau',
    'yok': 'yuk',
    'd.bikinin': 'dibikin',
    'mmz': 'mas',
    'bikinin': 'membikin',
    'keliatannya': 'kelihatannya',
    'diginiin': 'dibeginikan',
    'hadeehh': 'aduh',
    'krenn': 'keren',
    'kebykan': 'kebanyakan',
    'tingal': 'tinggal',
    'pernikahn': 'pernikahan',
    'ngtain': 'mengatai',
    'macem': 'macam',
    'bagusnyeee': 'bagusnya',
    'kemaren': 'kemarin',
    'hmpir': 'hampir',
    'liatnyaaa': 'lihatnya',
    'waw': 'wow',
    'mbuh': 'embuh',
    'bsk': 'besok',
    'waaa': 'wah',
    'berbiiiiiihhh': 'barbie',
    'canteek': 'cantik',
    'teru': 'terus',
    'nyatok': 'mencatok',
    'nyampenya': 'sampainya',
    'goncengin': 'boncengkan',
    'dianterin': 'dihantar',
    'gebleg': 'geblek',
    'bosen': 'bosan',
    'anterin': 'antarkan',
    'ngantar': 'menghantar',
    'nganterin': 'menghantarkan',
    'nerima': 'menerima',
    'yeuh': 'ya',
    'kmn': 'kemana',
    'dianter': 'dihantar',
    'disupirin': 'ditemani',
    'jidad': 'jidat',
    'novembr': 'november',
    'hri': 'hari',
    'bedain': 'membezakan',
    'brrt': 'bererti',
    'kana': 'kanan',
    'dtg': 'datang',
    'sblah': 'sebelah',
    'tengaj': 'tengah',
    'gmpg': 'gampang',
    'engk': 'tidak',
    'apal': 'hapal',
    'dak': 'indak',
    'kembaq': 'kembar',
    'tngh': 'tengah',
    'mknya': 'makanya',
    'prmpuan': 'perempuan',
    'ketuker': 'tertukar',
    'drimnanya': 'darimananya',
    'cntikan': 'cantikan',
    'syp': 'siapa',
    'bcnda': 'bercanda',
    'bazengg': 'bajingan',
    'hrsnya': 'harusnya',
    'silahkan': 'silakan',
    'lwt': 'lewat',
    'cma': 'cuma',
    'dibkatakan': 'dikatakan',
    'pengikuy': 'pengikut',
    'ngmngin': 'mengomongkan',
    'sblmnya': 'sebelumnya',
    'maksd': 'maksud',
    'adkah': 'adakah',
    'menbelah': 'membelah',
    'ayuk': 'ayo',
    'mngira': 'mengira',
    'bertolernsi': 'bertoleransi',
    'slahkan': 'salahkan',
    'tolernsi': 'toleransi',
    'ingi': 'ingin',
    'oalaaaa': 'walah',
    'menjelekan': 'menjelekkan',
    'hadeuuh': 'aduh',
    'dikemanain': 'dikemanakan',
    'bpknya': 'bapaknya',
    'baca2': 'baca-baca',
    'jwb': 'jawab',
    'sbagai': 'sebagai',
    'gndakan': 'gandakan',
    'gaa': 'tidak',
    "ganti'kn": 'menggantikan',
    'tnang': 'tenang',
    'kgeeeen': 'kangen',
    'bsok': 'besok',
    'hbis': 'habis',
    'mti': 'mati',
    'bgect': 'sangat',
    'kebaikan"y': 'kebaikannya',
    'dssi': 'disisi',
    'kngenn': 'kangen',
    'dasyat': 'dahsyat',
    'aer': 'air',
    'bgni': 'begini',
    'skalii': 'sekali',
    'dtinggl': 'ditinggal',
    'kakakgh': 'kakak',
    'prempuan': 'perempuan',
    'manteep': 'mantap',
    'nggeh': 'engah',
    'inia': 'ini',
    'cepetan': 'cepatan',
    'ntapsss': 'mantap',
    'smangat': 'semangat',
    'qmu': 'kamu',
    'sdkit2': 'sedikit-sedikit',
    'tntg': 'tentang',
    'penyakitny': 'penyakitnya',
    'ngajarin': 'mengajari',
    'laenny': 'lainnya',
    'scpatny': 'secepatnya',
    'sampein': 'sampaikan',
    'tuany': 'tuanya',
    'pjg': 'panjang',
    'bca': 'baca',
    'netes': 'menetes',
    'mataq': 'mataku',
    'byangin': 'membayangkan',
    'trjadi': 'terjadi',
    'dposisi': 'diposisi',
    'dijwb': 'dijawab',
    'sayy': 'sayang',
    'ngajar': 'mengajar',
    'fto2': 'foto-foto',
    'laen': 'lain',
    'tentanh': 'tentang',
    'nangiss': 'menangis',
    'nnton': 'menonton',
    'kejadianny': 'kejadiannya',
    'klg': 'keluarga',
    'msg2': 'masing-masing',
    'pgnnya': 'teringinnya',
    'meluk': 'memeluk',
    'mupeng': 'muka ingin',
    'caya': 'percaya',
    'mblo': 'jomblo',
    'gagahx': 'gagahnya',
    'niru': 'meniru',
    'bpkmu': 'bapakmu',
    'sangt': 'sangat',
    'gasih': 'tidak lah',
    'yuu': 'yuk',
    'yuuu': 'yuk',
    'ngademin': 'mengademkan',
    'makasi': 'terima kasih',
    'yokk': 'yuk',
    'gils': 'gila',
    'ono': 'sono',
    'weeeh': 'wih',
    'suksea': 'sukses',
    'temenan': 'berteman',
    'sehh': 'sih',
    'deket': 'dekat',
    'dekt': 'dekat',
    'yawloh': 'ya allah',
    'bhnya': 'bahannya',
    'loo': 'lah',
    'dsni': 'disini',
    'kokohh': 'engkoh',
    'pdhal': 'padahal',
    'yuks': 'yuk',
    'pnjual': 'penjual',
    'dung': 'lah',
    'latian': 'latihan',
    'soga': 'moga',
    'tteh': 'teteh',
    'sintron': 'sinetron',
    'ancurrr': 'hancur',
    'dblkang': 'dibelakang',
    'yayang': 'sayang',
    'gokillllll': 'gila',
    'aplks': 'aplikasi',
    'ska': 'suka',
    'ktawa': 'ketawa',
    'ngepoin': 'mengepoi',
    'beut': 'sangat',
    'njirrr': 'anjing',
    'gtuu': 'begitu',
    'njayyy': 'anjay',
    'maacih': 'terima kasih',
    'tokayyy': 'tahi',
    'mksdku': 'maksudku',
    'gituin': 'begitukan',
    'lgsung': 'langsung',
    'cba': 'coba',
    'giniin': 'beginikan',
    'ksini': 'kesini',
    'kubarikan': 'kuberikan',
    'ayank': 'sayang',
    'anyeng': 'anjing',
    'yankkk': 'sayang',
    'qaqaaaa': 'kakak',
    'banx': 'bang',
    'bape': 'bawa perasaan',
    'ngelahirin': 'melahirkan',
    'paksain': 'memaksa',
    'hub': 'hubungan',
    'telimakacih': 'terima kasih',
    'nerawang': 'menerawang',
    'didapet': 'didapat',
    'pede': 'percaya diri',
    'nyolot': 'menyolot',
    'pnting': 'penting',
    'wlaupun': 'walaupun',
    'agma': 'agama',
    'ngetik': 'mengetik',
    'ntah': 'entah',
    'mateeeek': 'mati',
    'sewain': 'menyewa',
    'yappp': 'ya',
    'bnr2': 'benar-benar',
    'psgn': 'pasangan',
    'ujg': 'ujung',
    'rmbut': 'rambut',
    'smp': 'sampai',
    'kki': 'kaki',
    'ntab': 'mantab',
    'yukss': 'yuk',
    'gapernah': 'tak pernah',
    'liatiii': 'lihat',
    'jombsss': 'jomblo',
    'emesshhh': 'gemas',
    'gemeessss': 'gemas',
    'gemesyak': 'gemas ya',
    'bngttt': 'sangat',
    'ngegmesin': 'menggemaskan',
    'hndak': 'hendak',
    'hndk': 'hendak',
    'lutunaa': 'lucunya',
    'abiz': 'habis',
    'gemes': 'gemas',
    'ngareppppp': 'mengharap',
    'abizzz': 'habis',
    'tay': 'tahi',
    'toketnya': 'teteknya',
    'lenje': 'lenjeh',
    'cantinya': 'cantiknya',
    'ngatain': 'mengatai',
    'mbaknyaahh': 'mbaknya',
    'pyudara': 'payudara',
    'ditutupin': 'ditutupi',
    'bgitu': 'begitu',
    'ngomongnya': 'mengomongnya',
    'sich': 'sih',
    'hati.a': 'hatinya',
    'mk.a': 'makanya',
    'mlt.a': 'mulutnya',
    'nyerocooooos': 'mencerocos',
    'kyk.a': 'kayaknya',
    'sklh': 'sekolah',
    'pljrn': 'pelajaran',
    'srng': 'sering',
    'ngilang': 'menghilang',
    'dikatain': 'dikatai',
    'ngalahin': 'mengalahkan',
    'brisi': 'berisi',
    'pkoknya': 'pokoknya',
    'canti': 'cantik',
    'astagfirullh': 'astagfirullah',
    'nutupin': 'menutupi',
    'ori': 'orisinal',
    'batwc': 'sangat',
    'kamyuhhh': 'kamu',
    'dbwh': 'dibawah',
    'senenggg': 'senang',
    'mao': 'mahu',
    'murhan': 'murahan',
    'prwtn': 'perawatan',
    'wjh': 'wajah',
    'bgettt': 'sangat',
    'pakke': 'pakai',
    'dipake': 'dipakai',
    'ktergantungan': 'ketergantungan',
    'prwatn': 'perawatan',
    'ngebuktiin': 'membuktikan',
    'hslnya': 'hasilnya',
    'setabil': 'stabil',
    'maksih': 'terima kasih',
    'bbrpa': 'beberapa',
    'pokonya': 'pokoknya',
    'digituin': 'dibegitukan',
    'sekolahin': 'sekolahkan',
    'ajarin': 'ajarkan',
    'mrnghadapi': 'menghadapi',
    'apalg': 'apa lagi',
    'naka': 'nakal',
    'sdkt': 'sedikit',
    'bgmana': 'bagaimana',
    's*inetr*n': 'sinetron',
    'mrusak': 'merosak',
    'mndpt': 'mendapat',
    'sebnyak': 'sebanyak',
    'nantangin': 'menantang',
    'ngegampar': 'menggampar',
    'ngelaporin': 'melaporkan',
    'salahin': 'salahkan',
    'gabisa': 'tidak perlu',
    'konsekwensi': 'konsekuensi',
    'muliany': 'mulianya',
    'mungki': 'mungkin',
    'lngsung': 'langsung',
    'tsb': 'tersebut',
    'bacahalah': 'bacalah',
    'dikerasin': 'dikerasi',
    'gkkan': 'tidak akan',
    'ngulangin': 'mengulangi',
    'pnyaa': 'punya',
    'bol3h': 'boleh',
    'ngadu': 'mengadu',
    'ketauan': 'ketahuan',
    'dimarahin': 'dimarahi',
    'nyelesain': 'menyelesaikan',
    'troma': 'trauma',
    'kerasin': 'kerasi',
    'cewer': 'jewer',
    'bilanh': 'bilang',
    'jwban': 'jawaban',
    'nuduh': 'menuduh',
    'ngatur': 'mengatur',
    'kekk': 'kayak',
    'byak': 'banyak',
    'kepad': 'kepada',
    'bantuanny': 'bantuannya',
    'perna': 'pernah',
    'grgr': 'gara-gara',
    'pukulin': 'pukuli',
    'komentarin': 'mengomentari',
    'menurur': 'menurut',
    'diliat': 'dilihat',
    'liatlah': 'lihatlah',
    'gr2': 'gara-gara',
    'gamau': 'tidak mahu',
    'skolah': 'sekolah',
    'pdahal': 'padahal',
    'klas': 'kelas',
    'tkut': 'takut',
    'grunya': 'gurunya',
    'pndah': 'pindah',
    'liat2': 'lihat-lihat',
    'masukin': 'memasuki',
    'dilindungin': 'dilindungi',
    'tinggalin': 'tinggalkan',
    'kaitannha': 'kaitannya',
    'sud': 'sudah',
    'pinter': 'pintar',
    'rana': 'ranah',
    'thdp': 'terhadap',
    'scr': 'secara',
    'bhkn': 'bahkan',
    'justeru': 'justru',
    'ngatai': 'mengatai',
    'kln': 'kalian',
    'sukak': 'suka',
    'brkunjun': 'berkunjung',
    'bgussss': 'bagus',
    'kmaren': 'kemarin',
    'ambilin': 'mengambil',
    'redho': 'ridho',
    'rezki': 'rezeki',
    'kepd': 'kepada',
    'jadilh': 'jadilah',
    'bnr': 'benar',
    'orrunya': 'orang tuanya',
    'flm': 'film',
    'kalok': 'kalau',
    'ituh': 'itu',
    'trims': 'terima kasih',
    'dehat': 'sihat',
    'sihat': 'sihat',
    'rekomendain': 'rekomendasikan',
    'trussss': 'terus',
    'bangt': 'sangat',
    'cepet': 'cepat',
    'pesen': 'pesan',
    'boong': 'bohong',
    'prawatan': 'perawatan',
    'mkin': 'makin',
    'dimao': 'dimau',
    'dijadiin': 'dijadikan',
    'silahkn': 'silakan',
    'kasiatnya': 'khasiatnya',
    'prodak': 'produk',
    'trasa': 'terasa',
    'minpi': 'mimpi',
    'bner2': 'benar-benar',
    'mutihin': 'memutihkan',
    'smster': 'semester',
    'kmren': 'kemarin',
    'ucull': 'lucu',
    'ngomong"': 'ngomong-ngomong',
    'udehh': 'sudah',
    'syngnya': 'sayangnya',
    'dipermainin': 'dipermainkan',
    'mukax': 'mukanya',
    'cantikx': 'cantiknya',
    'fatanik': 'fanatik',
    'protestin': 'protestan',
    'kakau': 'kalau',
    'marh': 'marah',
    'emngnya': 'memangnya',
    'darpada': 'daripada',
    'pkk': 'pakai',
    'sling': 'saling',
    "agama'ny": 'agamanya',
    'bilng': 'bilang',
    'prcy': 'percaya',
    'lurusin': 'meluruskan',
    'luco': 'lucu',
    'ultha': 'ultah',
    'luchu': 'lucu',
    'syang': 'sayang',
    'ngasi': 'mengasih',
    'astafirullah': 'astagfirullah',
    'peragain': 'peragakan',
    'shayyy': 'say',
    'shay': 'say',
    'shaaaay': 'say',
    'shayy': 'say',
    'syantiek': 'cantik',
    'njay': 'anjay',
    'kam': 'kamu',
    'ingeet': 'ingat',
    'sblh': 'sebelah',
    'nawarin': 'menawari',
    'ajakin': 'mengajak',
    'mntn': 'mantan',
    'luhhh': 'lu',
    'yooookkk': 'yuk',
    'jrnk': 'jarang',
    'kayax': 'kayak',
    'dblkng': 'dibelakang',
    'iyap': 'iya',
    'mayann': 'lumayan',
    'autuhh': 'tau tuh',
    'atutt': 'takut',
    'ketara': 'tertara',
    'giniii': 'begini',
    'bund': 'bunda',
    'almh': 'almarhumah',
    "suami'y": 'suaminya',
    'entr': 'entar',
    'kyax': 'kayak',
    'cuantikkk': 'cantik',
    'mksdnya': 'maksudnya',
    "kucing'y": 'kucingnya',
    "nama'in": 'namai',
    "panggilan'ya": 'panggilannya',
    "panggilan'y": 'panggilannya',
    'kalw': 'kalau',
    'alu': 'aku',
    'ngriii': 'mengiri',
    'smpai': 'sampai',
    'kox': 'kok',
    'tmbah': 'tambah',
    'cntikk': 'cantik',
    'pkee': 'pakai',
    'smkin': 'semakin',
    'bgmna': 'bagaimana',
    'ssorg': 'seseorang',
    'hdpn': 'hadapan',
    'mnambh': 'menambah',
    'ktaatan': 'ketaatan',
    'stju': 'setuju',
    'istiqomahhh': 'istikamah',
    'prodaknya': 'produknya',
    'amu': 'kamu',
    'jilbb': 'jilbab',
    'tmn': 'teman',
    'ndut': 'gendut',
    'ngecek': 'mengecek',
    'psti': 'pasti',
    'penasarn': 'penasaran',
    'astauviruloh': 'astagfirullah',
    'diajarin': 'diajari',
    'gawl': 'gaul',
    'kecr': 'kece',
    'aned': 'sangat',
    'gingsungny': 'gingsulnya',
    'blh': 'boleh',
    'cariin': 'carikan',
    'kenceng': 'kencang',
    'cuanti': 'cantik',
    'mbanya': 'mbaknya',
    'knlan': 'kenalan',
    'mrka': 'mereka',
    'nyusahhin': 'menyusahkan',
    'byaran': 'bayaran',
    'wlawpun': 'walaupun',
    'sedangkn': 'sedangkan',
    'tnpa': 'tanpa',
    'bnggain': 'banggakan',
    'nyusahin': 'menyusahkan',
    'dibanggain': 'dibanggakan',
    'wlau': 'walau',
    'komenan': 'komentar',
    'bangga"in': 'membangga-banggakan',
    'krya': 'karya',
    'dmna': 'dimana',
    'dripda': 'daripada',
    'dibnggain': 'dibanggakan',
    'drimana': 'darimana',
    "ngepake'": 'memakai',
    'gksalah': 'tidak salah',
    'nuntut': 'menuntut',
    'ngebiarin': 'membiarkan',
    'bhas': 'bahas',
    "lagu'y": 'lagunya',
    'jadiin': 'jadikan',
    'diem': 'diam',
    'nyampah': 'menyampah',
    "bukan'a": 'bukannya',
    'pacara': 'pacaran',
    'ngerussak': 'merosak',
    'bellain': 'membela',
    'coment': 'komentar',
    'comnet': 'komen',
    "kaya'a": 'kayanya',
    'kuyyy': 'yuk',
    "sgtu'y": 'sebegitunya',
    'ngebelain': 'membela',
    'tpii': 'tapi',
    'cali': 'caci',
    'penghrgaan': 'penghargaan',
    'ajjh': 'saja',
    'drii': 'dari',
    'stidaknya': 'setidaknya',
    'trbaikk': 'terbaik',
    'jngnn': 'jangan',
    'frestasiii': 'prestasi',
    'add': 'ada',
    'sibukx': 'sibuknya',
    'syng': 'sayang',
    'adenya': 'adeknya',
    'pkoknyaa': 'pokoknya',
    'dsana': 'disana',
    'sichhhhhhhhhh': 'sih',
    'nampak': 'menampak',
    'cobain': 'mencoba',
    'muga': 'moga',
    'kenalin': 'memperkenalkan',
    'janka': 'jangka',
    'wawwwww': 'wow',
    'waaaww': 'wow',
    'waaawwww': 'wow',
    'oplas': 'operasi plastik',
    'nambahh': 'bertambah',
    'paripurnahh': 'paripurna',
    'wanitah': 'wanita',
    'indonesiaah': 'indonesia',
    'cumn': 'cuman',
    'gegra': 'gegara',
    'brita': 'berita',
    'fotbar': 'foto bareng',
    'sngt': 'sangat',
    'bingiittt': 'sangat',
    'nampar': 'menampar',
    'tukan': 'tukang',
    'jatoh': 'jatuh',
    'sdgkn': 'sedangkan',
    'mancungin': 'memancungkan',
    'kusem': 'kusam',
    'drpada': 'daripada',
    'kmar': 'kamar',
    'diemm': 'diam',
    'tnggu': 'tunggu',
    'ketawain': 'mentertawakan',
    'yaelahhh': 'alah',
    'bales': 'balas',
    'ngejatuhin': 'manjatuhkan',
    'ngelakuin': 'melakukan',
    'gedeg': 'gedek',
    'eey': 'eh',
    'kslahan': 'kesalahan',
    'perhatiam': 'perhatian',
    'dibiarin': 'dibiarkan',
    'sbnrny': 'sebenarnya',
    'trjd': 'terjadi',
    'mkir': 'memikir',
    'hny': 'hanya',
    'apalai': 'apa lagi',
    'bkal': 'bakal',
    'nyadar': 'menyadar',
    'bka': 'buka',
    "pipi'y": 'pipinya',
    'sukam': 'suka',
    'menghilangkn': 'menghilangkan',
    'mnjdkan': 'menjadikan',
    'stlh': 'setelah',
    'soalx': 'soalnya',
    'keche': 'kece',
    'btuh': 'butuh',
    'ktanya': 'katanya',
    'bebrp': 'beberapa',
    'santab': 'santap',
    'salehah': 'salihah',
    'mikirin': 'memikirkan',
    'konsul': 'konsultasi',
    'pengalam': 'pengalaman',
    'poko': 'pokok',
    'trun': 'turun',
    'warnany': 'warnanya',
    'seger': 'segar',
    'senangat': 'semangat',
    'msknya': 'masaknya',
    'ciptain': 'menciptakan',
    'sayangkuh': 'sayangku',
    'gans': 'tampan',
    'kren': 'keren',
    'babget': 'sangat',
    'jadu': 'jadi',
    'ksyngn': 'kesayangan',
    'haru': 'harus',
    'ngingetin': 'mengingatkan',
    'narik': 'menarik',
    'gokilll': 'gila',
    'beudd': 'sangat',
    'termiribkan': 'termiripkan',
    'dngerin': 'mendengarkan',
    'brrti': 'bererti',
    'wenakk': 'enak',
    'nganteng': 'tampan',
    'gtuh': 'begitu',
    'emeezzz': 'gemas',
    'amohhh': 'kamu',
    'eyke': 'aku',
    'gilakkkkk': 'gila',
    'awk': 'awak',
    'aloh': 'allah',
    'ngettt': 'sangat',
    'maso': 'masa',
    'brubah': 'berubah',
    'pelastik': 'plastik',
    'keak': 'kayak',
    'dengerin': 'mendengarkan',
    'beud': 'sangat',
    'pahamin': 'memahami',
    'ahahahanjirrr': 'anjing',
    'jogetin': 'berjoget',
    'shaay': 'say',
    'boker': 'berak',
    'wanjiir': 'anjing',
    'minta': 'meminta',
    'bnran': 'benaran',
    'sgla': 'segala',
    'uitnya': 'duitnya',
    'beliiin': 'belikan',
    'sekaeang': 'sekarang',
    'tanyain': 'tanyakan',
    'banyakin': 'membanyaki',
    'gituan': 'begituan',
    'kaj': 'kak',
    'melebihin': 'melebihi',
    'gakpapa': 'tiada apa-apa',
    'kalogak': 'kalau tidak',
    'ndukung': 'mendukung',
    'skluarga': 'sekeluarga',
    'suaminga': 'suaminya',
    'berhijap': 'berhijab',
    'smgaa': 'semoga',
    'istiqamah': 'istikamah',
    'cuaaantikk': 'cantik',
    'bets': 'sangat',
    'sembuhin': 'menyembuhkan',
    'pengrusak': 'perosak',
    'ngoceh': 'mengoceh',
    'hpus': 'hapus',
    'pjang': 'pajang',
    'bdampingan': 'berdampingan',
    'kaga': 'kagak',
    'uih': 'uh',
    'happi"': 'hepi-hepi',
    'bgtuu': 'begitu',
    'mff': 'maaf',
    'ktwa': 'ketawa',
    'trlalu': 'terlalu',
    'ngmg': 'bercakap',
    'kepelesett': 'terpeleset',
    'geeelaakk': 'gila',
    'bolang': 'bocah petualang',
    'pkek': 'pakai',
    'lagihh': 'lagi',
    'hedeuuhh': 'aduh',
    'saltummmm': 'salah kostum',
    'mboizzz': 'bois',
    'suda': 'sudah',
    'kayaq': 'kayak',
    'ema': 'emak',
    'dirumahny': 'dirumahnya',
    'yuh': 'tuh',
    'rmbt': 'rambut',
    'apus': 'hapus',
    'siapayahh': 'siapa ya',
    'kostom': 'kostum',
    'gnii': 'begini',
    'atuu': 'satu',
    'pipine': 'pipinya',
    'glembeeeer': 'gelambir',
    'lucunaaa': 'lucunya',
    'cubanget': 'lucu sangat',
    'pengenn': 'ingin',
    'unyuuk': 'unyu',
    'dedek': 'adik',
    'lucunyah': 'lucunya',
    'trsrh': 'terserah',
    'ksih': 'kasih',
    'seterong': 'setrong',
    'teyuss': 'terus',
    'dimasukin': 'dimasuki',
    'jelekin': 'menjelekkan',
    'jahatin': 'menjahati',
    'tai': 'tahi',
    'gtw': 'tidak tahu',
    'nulis': 'menulis',
    'nyebutin': 'menyebutkan',
    'ngertiin': 'mengerti',
    'rasaiin': 'rasai',
    'gakusah': 'tidak perlu',
    'disni': 'disini',
    'nyalahin': 'menyalahkan',
    'bedainnya': 'membezakannya',
    'keknya': 'kayaknya',
    'krus': 'kurus',
    'elaaaahhhh': 'alah',
    'cogan': 'lelaki tampan',
    'tap8': 'tapi',
    'pandanginya': 'memandanginya',
    'kenaliiin': 'kenalkan',
    'suko': 'suka',
    'segtu': 'sebegitu',
    'ngebenci': 'membenci',
    'padhe': 'pakde',
    'atw': 'atau',
    'maafin': 'memaafi',
    'kgak': 'kagak',
    'woles': 'selow',
    'hianatin': 'khianati',
    'halangin': 'halangi',
    'iyuh': 'ih',
    'iyuuuhhhh': 'ih',
    'gaje': 'tidak jelas',
    'gabakal': 'tidak jadi',
    'adapin': 'menghadapi',
    'ngehakimi': 'menghakimi',
    'ngejuangin': 'memperjuangkan',
    'dipojokin': 'dipojokkan',
    'bacotin': 'bacoti',
    'berati': 'bererti',
    'kebangetak': 'kebangetan',
    'tangkep': 'tangkap',
    'maksir': 'menaksir',
    'pndang': 'pandang',
    'pmbelajaran': 'pembelajaran',
    'ngejelek': 'menjelekkan',
    'maslah': 'masalah',
    'mmperbaiki': 'memperbaiki',
    'nahan': 'menahan',
    'kafeh': 'kafe',
    'tinggl': 'tinggal',
    'dirmh': 'dirumah',
    'iyuuhhh': 'ih',
    'ktika': 'ketika',
    'ngrasain': 'merasai',
    'ityl': 'itil',
    'hbs': 'habis',
    'wenak': 'enak',
    'ngarang': 'mengarang',
    "kelas'a": 'kelasnya',
    'hadeeehhh': 'aduh',
    'gtu"an': 'begitu-gituan',
    'gmanapun': 'bagaimanapun',
    'taux': 'taunya',
    'ketarik': 'tertarik',
    'ngorbanin': 'mengorbankan',
    'eksprsi': 'ekspresi',
    'gitulah': 'begitulah',
    'mamas': 'mas',
    'bandingin': 'bandingkan',
    'badingkan': 'membandingkan',
    'ngurus': 'mengurus',
    'lanjutin': 'lanjutkan',
    'ributin': 'meributkan',
    'brantem': 'berantem',
    'belain': 'membela',
    'lipetan': 'lipatan',
    'bneraan': 'benaran',
    'rmbuut': 'rambut',
    'walik': 'balik',
    'kellen': 'kalian',
    'nyerocos': 'mencerocos',
    'ngomenin': 'mengomentari',
    'niyyyyhhhh': 'nih',
    'blik': 'balik',
    'kenape': 'kenapa',
    'ladenin': 'meladeni',
    'skit': 'sakit',
    'jilbabnye': 'jilbabnya',
    'ledkin': 'meledeki',
    'digabtikan': 'digantikan',
    'jng': 'jangan',
    'ngumung': 'bercakap',
    'ilang-in': 'hilangkan',
    'prinadi': 'pribadi',
    'luh': 'lu',
    'yep': 'ya',
    'helooooo': 'hello',
    'loe': 'lo',
    'berjinah': 'berzina',
    'urusn': 'urusan',
    'saudra': 'saudara',
    'trganggu': 'terganggu',
    'bhijab': 'berhijab',
    'lepasin': 'melepas',
    'smentara': 'sementara',
    'ursan': 'urusan',
    'sudab': 'sudah',
    'dwsa': 'dewasa',
    'ngaji': 'mengaji',
    'nmr': 'nomor',
    'romantiz': 'romantis',
    'murmer': 'murah meriah',
    'pensaran': 'penasaran',
    'nyupir': 'menyopir',
    'steess': 'stres',
    'kwatir': 'kawatir',
    'duetin': 'duet',
    'sebenernya': 'sebenarnya',
    'silsturahmi': 'silaturahmi',
    'dijkt': 'dijakarta',
    'ayukk': 'yuk',
    'ngucapin': 'mengucapkan',
    'filmny': 'filmnya',
    'ntn': 'menonton',
    'nobar': 'menonton bareng',
    'knpp': 'kenapa',
    'lggi': 'lagi',
    'gaprgi': 'tidak pergi',
    'dtunggu': 'ditunggu',
    'kepikir': 'terpikir',
    'emeshh': 'gemas',
    'kaya': 'kayak',
    'pacarn': 'pacaran',
    'ktg': 'kita',
    'pacaranya': 'pacarannya',
    'ngalah': 'mengalah',
    'pacarane': 'pacarannya',
    'tuwek': 'tua',
    'mukae': 'mukanya',
    'ultahe': 'ultahnya',
    'kliatanya': 'kelihatannya',
    'pcaranya': 'pacarannya',
    'bermaksut': 'bermaksud',
    'tampialannya': 'tampilannya',
    'ngumbar': 'mengumbar',
    'dhpusin': 'dihapuskan',
    'istiqomah': 'istikamah',
    'mnutup': 'menutup',
    'bngatt': 'sangat',
    'hapusin': 'hapuskan',
    'ngeuh': 'engah',
    'sneng': 'senang',
    'mutusin': 'memutuskan',
    'ngapus': 'menghapus',
    'awl': 'awal',
    'hrus': 'harus',
    'bngkit': 'bangkit',
    'mncoba': 'mencoba',
    'mutuain': 'memutuskan',
    'ngirim': 'mengirim',
    'ngidam': 'mengidam',
    'sampis': 'sampah habis',
    'maapin': 'maafi',
    'ngebala': 'bala',
    'hrusnya': 'harusnya',
    'sabal': 'sabar',
    'udahlah': 'sudahlah',
    'sabaro': 'sabar',
    'kreative': 'kreatif',
    'bangrt': 'sangat',
    'azekkkk': 'asik',
    'bhet': 'sangat',
    'inggrisny': 'inggrisnya',
    'dsna': 'disana',
    'mksih': 'terima kasih',
    'nga': 'tidak',
    'canyk': 'cantik',
    'prodac': 'produk',
    'nyesell': 'menyesal',
    'ciyusss': 'serius',
    'cyin': 'cinta',
    'sexi': 'seksi',
    'bettt': 'sangat',
    'brapa': 'berapa',
    'thnan': 'tahunan',
    'cuantik': 'cantik',
    'segerr': 'segar',
    'wouww': 'wow',
    'catokin': 'catok',
    'comment2nya': 'komentar-komentarnya',
    'knsul': 'konsultasi',
    'brhasil': 'berhasil',
    'hilangin': 'menghilangkan',
    'dptnya': 'dapatnya',
    'bngeet': 'sangat',
    'gemesinnnnn': 'menggemaskan',
    'ganteung': 'tampan',
    'bhgia': 'bahagia',
    'lucuukk': 'lucu',
    'ngarep': 'mengharap',
    'testinya': 'testimoninya',
    'mengirusi': 'mengurusi',
    'khdpn': 'kehidupan',
    'ngelawan': 'melawan',
    'bisax': 'bisanya',
    'klmbutan': 'kelembutan',
    'diingetin': 'diingatkan',
    'nich': 'nih',
    'akhlah': 'akhlak',
    'elo2': 'lo-lo',
    'mandiin': 'memandikan',
    'nguburin': 'menguburkan',
    'ngebedain': 'membezakan',
    'urusanny': 'urusannya',
    'tuhanny': 'tuhannya',
    'brtngkar': 'bertengkar',
    'pndapat': 'pendapat',
    'sharusnya': 'seharusnya',
    'mngkannya': 'mangkanya',
    'nyia2in': 'menyia-nyiakan',
    'brarti': 'bererti',
    'mndpat': 'mendapat',
    'kpuasan': 'kepuasan',
    'sgampang': 'segampang',
    'mlepaskan': 'melepaskan',
    'trll': 'terlalu',
    'sbbrnya': 'sebenarnya',
    'testi': 'testimoni',
    'd.apa': 'diapa',
    'apain': 'apai',
    'dsar': 'dasar',
    'benetaran': 'benaran',
    'bneran': 'benaran',
    'kraya': 'karya',
    'ngebantu': 'membantu',
    'janjutin': 'lanjutkan',
    'recommendasi': 'rekomendasi',
    'btulan': 'betulan',
    'kha': 'kah',
    'tutupin': 'menutupi',
    'wik': 'wig',
    'ithu': 'itu',
    'botakin': 'botaki',
    'bnrn': 'benaran',
    'week': 'wig',
    'gawul': 'gaul',
    'modes': 'modis',
    'kcantikan': 'kecantikan',
    'bronis': 'brondong manis',
    'gapunya': 'bukan punya',
    'bkln': 'bakalan',
    'kecantikanga': 'kecantikannya',
    'zama': 'zaman',
    'nmnya': 'namanya',
    'tapo': 'tapi',
    'gkk': 'juga',
    'indefendet': 'independen',
    'ngayal': 'mengkhayal',
    'smvk': 'sempak',
    'knyataan': 'kenyataan',
    'njrittt': 'anjing',
    'selmt': 'selamat',
    'taz': 'atas',
    'klhran': 'kelahiran',
    'pertma': 'pertama',
    'kelahuran': 'kelahiran',
    'pertamany': 'pertamanya',
    'mamax': 'mamanya',
    'ankx': 'anaknya',
    'cantip': 'cantik',
    'klahiran': 'kelahiran',
    'slmat': 'selamat',
    'mmbanggakan': 'membanggakan',
    'ortuny': 'orang tuanya',
    'selmat': 'selamat',
    'bnda': 'bunda',
    'nyah': 'nya',
    'prtamax': 'pertamanya',
    'moqa': 'moga',
    'brbakti': 'berbakti',
    'gewlaaaaa': 'gila',
    'basodaraa': 'bersaudara',
    'hargs': 'harga',
    'perhatiin': 'perhatikan',
    'bantuim': 'bantu',
    'adl': 'adalah',
    'pelwak': 'pelawak',
    'suces': 'sukses',
    'sucses': 'sukses',
    'garemin': 'garami',
    'gapake': 'tidak pakai',
    'ngiringan': 'mengiringi',
    'karir.a': 'karirnya',
    'teruz': 'terus',
    'kemarn': 'kemarin',
    'recomendasinya': 'rekomendasinya',
    'mskasih': 'terima kasih',
    'batesin': 'batasi',
    'bijin': 'bikin',
    'ngeidealin': 'mengidealkan',
    'bhn': 'bahan',
    'gasalah': 'tidak salah',
    'brsma': 'bersama',
    'ugha': 'juga',
    'heeee': 'hai',
    'yam': 'ya',
    'kartunin': 'kartun',
    'kyaknya': 'nampaknya',
    'abez': 'habis',
    'gimanaaaa': 'bagaimana',
    'pans': 'fan',
    'kuliyh': 'kuliah',
    'orgny': 'orangnya',
    'owalaah': 'walah',
    'aslinyo': 'aslinya',
    'komuk': 'muka',
    'kalahnye': 'kalahnya',
    'smrg': 'semarang',
    'koq': 'kok',
    'insonniaaa': 'insomnia',
    'adekx': 'adeknya',
    'gksi': 'tidak lah',
    'greged': 'greget',
    'ktemu': 'ketemu',
    'ditayangin': 'ditayangkan',
    'meranin': 'memerankan',
    'nontonny': 'menontonnya',
    'rekomendasiiin': 'merekomendasikan',
    'ngg': 'tidak',
    'nanget': 'sangat',
    'ngeditnya': 'mengeditnya',
    'himana': 'bagaimana',
    'kekgini': 'kayak begini',
    'tlsn': 'tulisan',
    'nagiss': 'menangis',
    'aneut': 'sangat',
    'trrharu': 'terharu',
    'subhnallah': 'subhanallah',
    'dcintai': 'dicintai',
    'klrga': 'keluarga',
    "liat'y": 'lihatnya',
    'lggeng': 'langgeng',
    'romantisny': 'romatisnya',
    'pcar': 'pacar',
    'kakanga': 'kakaknya',
    'cpa': 'siapa',
    'aelah': 'alah',
    'orabg': 'orang',
    'kakakny': 'kakaknya',
    'ngelucu': 'melucu',
    'bukak': 'buka',
    'mato': 'mata',
    'kareno': 'kerana',
    'cino': 'cina',
    'meker': 'mikir',
    'indoneaia': 'indonesia',
    'benarin': 'membenarkan',
    'apo': 'apa',
    'nyo': 'nya',
    'miara': 'memiara',
    'jalanani': 'menjalani',
    'sdah': 'sudah',
    'emangnya': 'memangnya',
    'rumpiin': 'rumpi',
    'jawabanny': 'jawabannya',
    'ajj': 'saja',
    'melihara': 'memelihara',
    'hidupx': 'hidupnya',
    'ngefans': 'fan',
    'lsg': 'langsung',
    'uztad': 'ustad',
    'menasehati': 'menasihati',
    'kelus': 'kali',
    'hubngan': 'hubungan',
    'koclak': 'kocak',
    'bju': 'baju',
    'yahhhh': 'ya',
    'syediih': 'sedih',
    'mirp': 'mirip',
    'baju.a': 'bajunya',
    'gantheng': 'tampan',
    'synk': 'sayang',
    'ngfans': 'fan',
    'idungnya': 'hidungnya',
    'dtggu': 'ditunggu',
    'trnyata': 'ternyata',
    'bgtttttttt': 'sangat',
    'rapih': 'rapi',
    'iyaappps': 'iya',
    'sukse': 'sukses',
    'kecptan': 'kecepatan',
    'rmbutnya': 'rambutnya',
    'giti': 'begitu',
    'penganten': 'pengantin',
    'wrn': 'warna',
    'fans': 'fan',
    'loksyut': 'lokasi syuting',
    'amfun': 'ampun',
    'dsini': 'disini',
    'dibls': 'dibalas',
    'ceklist': 'ceklis',
    'tlvn': 'telefon',
    'trkrim': 'terkirim',
    'kelaluan': 'kelakuan',
    'guanteng': 'tampan',
    'cucok': 'cucuk',
    'haduh': 'aduh',
    'mlz': 'malas',
    'kepoh': 'kepo',
    'jalanin': 'menjalani',
    'repong': 'repot',
    'ngrusin': 'mengurusi',
    'dnk': 'lah',
    'senyumna': 'senyumnya',
    'ngejelek2in': 'menjelek-jelekkan',
    'hotx': 'hotnya',
    'cwnya': 'ceweknya',
    'pasangn': 'pasangan',
    'sttus': 'status',
    'hadeuuhhhh': 'aduh',
    'sstu': 'sesuatu',
    'cocokx': 'cocoknya',
    'emakx': 'emaknya',
    'kll': 'kalau',
    'arghhh': 'ah',
    'ungkapin': 'ungkapkan',
    'merrid': 'merit',
    'neh': 'nih',
    'yaolohh': 'ya allah',
    'aee': 'saja',
    'naggung': 'menanggung',
    'battt': 'sangat',
    'luthuna': 'lucunya',
    'suaraynyaa': 'suaranya',
    'ancur': 'hancur',
    'koplak': 'kocak',
    'uaaasssiiiik': 'asik',
    'nyubit': 'mencubit',
    'dede': 'adik',
    'gemez': 'gemas',
    'tium': 'cium',
    'ppa': 'papa',
    'ginting': 'tampan',
    'bingiiittzz': 'sangat',
    'dedeknya': 'adeknya',
    'hadeeuh': 'aduh',
    'geneeee': 'begini',
    'yooow': 'ya',
    'gemezz': 'gemas',
    'gayax': 'gayanya',
    'infpyunnnn': 'ampun',
    'ngambek': 'mengambek',
    'haduuuh': 'aduh',
    'nginjek': 'menginjak',
    'didatengin': 'didatangi',
    'abg': 'abang',
    'ayoklaa': 'ayolah',
    'srruu': 'seru',
    'jmpaaaa': 'jumpa',
    'syukaaakkk': 'suka',
    'akuh': 'aku',
    'mesrany': 'mesranya',
    'jendes': 'janda',
    'ngggk': 'tidak',
    'jendesss': 'janda',
    'bngtttt': 'sangat',
    'ponakn': 'ponakan',
    'tpy': 'tapi',
    'jnda': 'janda',
    'bngy': 'sangat',
    'bujngn': 'bujangan',
    'ngp': 'mengapa',
    'padetan': 'padatan',
    'nyobain': 'mencoba',
    'pcaran': 'pacaran',
    'tdak': 'tidak',
    'prcuma': 'percuma',
    'hayal': 'khayal',
    'bedua': 'berdua',
    'bapeerr': 'bawa perasaan',
    'keinget': 'teringat',
    'merekak': 'mereka',
    'kreeenn': 'keren',
    'abisss': 'habis',
    'abiiiss': 'habis',
    'flim.a': 'filmnya',
    'trusan.a': 'terusannya',
    'tdung': 'tudung',
    'gangguin': 'mengganggu',
    'lgkah2': 'langkah-langkah',
    'taw': 'tau',
    'cntiiikkk': 'cantik',
    'sktlrang': 'sekarang',
    'sjk': 'sejak',
    'tambh': 'tambah',
    'nangiis': 'menangis',
    'gaada': 'tidak ada',
    'malsudnya': 'maksudnya',
    'kueren2': 'keren-keren',
    'abgnya': 'abangnya',
    'warkop': 'warung kopi',
    'hayuu': 'hayo',
    'mansetan': 'bermanset',
    'telefisi': 'televisi',
    'nikmatin': 'menikmati',
    'mtanya': 'matanya',
    'cpit': 'sipit',
    'dee': 'dek',
    'sumvahh': 'sumpah',
    'tamvann': 'tampan',
    'yap': 'ya',
    'capa': 'sapa',
    'ngakakkk': 'mengakak',
    'liaat': 'lihat',
    'gantweng': 'tampan',
    'anjjjjjjjj': 'anjing',
    'gakwad': 'tidak kuat',
    'dinyanyiin': 'dinyanyikan',
    'nyengir': 'menyengir',
    'temennya': 'temannya',
    'klk': 'kelak',
    'brjdh': 'berjodoh',
    'akhrt': 'akhirat',
    'ysh': 'ya',
    'sypa': 'siapa',
    'nangisss': 'menangis',
    'brjodoh': 'berjodoh',
    'kpnpun': 'bila pun',
    'mendj': 'menjadi',
    'lhir': 'lahir',
    'udeh': 'sudah',
    'menjdi': 'menjadi',
    'debay': 'adik bayi',
    'lafazd': 'lafaz',
    'pmbyran': 'pembayaran',
    'plsa': 'pulsa',
    'ngambekan': 'ambekan',
    'ngom': 'bercakap',
    'bodhooo': 'bodoh',
    'kemakan': 'termakan',
    'bodhoo': 'bodoh',
    'smuaaa': 'semua',
    'ngambeknya': 'mengambeknya',
    'kebongkar': 'terbongkar',
    'kasiian': 'kasihan',
    'diladenin': 'diladeni',
    'comen': 'komen',
    'ngtif': 'negatif',
    'comntr': 'komentar',
    'brdiri': 'berdiri',
    'mulutny': 'mulutnya',
    'msalah': 'masalah',
    'trserh': 'terserah',
    'ngedukung': 'mendukung',
    'dihpus': 'dihapus',
    'mrekaa': 'mereka',
    'benerr': 'benar',
    'brg"': 'bareng-bareng',
    'ngetsz': 'sangat',
    'utkmu': 'untukmu',
    'anj': 'anjing',
    'dieee': 'dia',
    'yaahh': 'ya',
    'hijap': 'hijab',
    'ternodain': 'ternodai',
    'kt2': 'kata-kata',
    'agk': 'agak',
    'slhkan': 'salahkan',
    'jilbabny': 'jilbabnya',
    'perilakuny': 'perilakunya',
    'ketaatanny': 'ketaatannya',
    'kepda': 'kepada',
    'sblmny': 'sebelumnya',
    'bljr': 'belajar',
    'ingetin': 'mengingatkan',
    'terjrumus': 'terjerumus',
    'stuju': 'setuju',
    'igtlah': 'ingatlah',
    'dtgkan': 'datangkan',
    'benahin': 'membenahi',
    'yapp': 'ya',
    'bingitt': 'sangat',
    'ngembali': 'kembali',
    'semngat': 'semangat',
    'lekong': 'laki',
    'ngimpi': 'mimpi',
    'owh': 'oh',
    'ngerampas': 'merampas',
    'ngehancurin': 'menghancurkan',
    'kaleee': 'kali',
    'caranga': 'caranya',
    'usa': 'usah',
    'dipikirin': 'dipikirkan',
    'nunduk': 'menunduk',
    'nyubitt': 'mencubit',
    'adyem': 'adem',
    'mitnah': 'memfitnah',
    'tmbm': 'tembam',
    'cantix': 'cantik',
    'kriput': 'keriput',
    'jelex': 'jelek',
    'drmn': 'darimana',
    'kacian': 'kasihan',
    'cape': 'capek',
    'kpancing': 'terpancing',
    'lakuin': 'melakukan',
    'cri': 'cari',
    'sbenernya': 'sebenarnya',
    'mengalahkn': 'mengalahkan',
    'nyindirin': 'menyindir',
    'nee': 'ini',
    'klakuan': 'kelakuan',
    'mksdx': 'maksudnya',
    'shabat': 'sahabat',
    'brbuat': 'berbuat',
    'mmberi': 'memberi',
    'sbhabat': 'sahabat',
    'pnjerumus': 'penjerumus',
    'tman': 'teman',
    'shbat': 'sahabat',
    'melakukn': 'melakukan',
    'berkluarga': 'berkeluarga',
    'ketipu': 'tertipu',
    'gosipin': 'menggosipkan',
    'sendri': 'sendiri',
    'bntar': 'bentar',
    'nmbk': 'menembak',
    'gakkk': 'tidak',
    'cwok': 'cowok',
    'bangedd': 'sangat',
    'wuastagah': 'astaga',
    'jaoooh': 'jauh',
    'mateeeeeeeeeeee': 'mati',
    'parsis': 'persis',
    'sumpeh': 'sumpah',
    'iyh': 'iya',
    'kmana': 'kemana',
    'cantiqs': 'cantik',
    'brasa': 'berasa',
    'trlihat': 'terlihat',
    'mmberikan': 'memberikan',
    'khidupan': 'kehidupan',
    'srpti': 'seperti',
    'dinamakn': 'dinamakan',
    'sgtu': 'sebegitu',
    'paati': 'pasti',
    'khadiran': 'kehadiran',
    'kel': 'keluarga',
    'srta': 'serta',
    'kcil': 'kecil',
    'kberkahn': 'keberkahan',
    'kbahagiaan': 'kebahagiaan',
    'tntram': 'tentram',
    'brsama': 'bersama',
    'hngga': 'hingga',
    'brpndapat': 'berpendapat',
    'trutama': 'terutama',
    'hiraukn': 'hiraukan',
    'diamkn': 'diamkan',
    'hrsny': 'harusny',
    'brsyukur': 'bersyukur',
    'mmberikn': 'memberikan',
    'rasakn': 'rasakan',
    'kesalahanny': 'kesalahannya',
    'kekuranganny': 'kekurangannya',
    'seandainy': 'seandainya',
    'perasaanny': 'perasaannya',
    'diindonesis': 'diindonesia',
    'liyatnya': 'lihatnya',
    'kayahhh': 'kaya',
    'yook': 'yuk',
    'yoookkkk': 'yuk',
    'belom': 'belum',
    'padahl': 'padahal',
    'kejahatn': 'kejahatan',
    'slam': 'salam',
    'ngelewati': 'melewati',
    'ngerendahin': 'merendahkan',
    'tnp': 'tanpa',
    'mnt': 'minta',
    'kiya': 'kita',
    'yoiiu': 'yoi',
    'suka.a': 'sukanya',
    'jdii': 'jadi',
    'blnja': 'belanja',
    'brangnya': 'barangnya',
    'nimpuk': 'menimpuk',
    'abiss': 'habis',
    'prlu': 'perlu',
    'jnagn': 'jangan',
    'kcwa': 'kecewa',
    'dket2in': 'dekat-dekati',
    'cobak': 'coba',
    'britanya': 'beritanya',
    'jamam': 'jaman',
    'seharusny': 'seharusnya',
    'blkng': 'belakang',
    'kcewa': 'kecewa',
    'mnusuk': 'menusuk',
    'blkang': 'belakang',
    'nembak': 'menembak',
    'trmanis': 'termanis',
    'krng': 'kurang',
    'kaciiaann': 'kasihan',
    'nyela': 'mencela',
    'ngejilat': 'menjilat',
    'deketin': 'dekati',
    'tayik': 'tahi',
    'ustzah': 'ustazah',
    'halow': 'hello',
    'nyimpen': 'menyimpan',
    'ngarsipin': 'mengarsipkan',
    'cman': 'cuman',
    'kyy': 'kaya',
    'kngn': 'kangen',
    'nyesek': 'menyesak',
    'gemezzzz': 'gemas',
    'prh': 'parah',
    'gmau': 'tidak mahu',
    'prasaan': 'perasaan',
    'skrnh': 'sekarang',
    'kurangin': 'kurangi',
    "s'lalu": 'selalu',
    'mintk': 'minta',
    'nyolong': 'mencolong',
    'pnjng': 'panjang',
    'slaluuuuu': 'selalu',
    'rezeqinya': 'rezekinya',
    'pintr': 'pintar',
    'maw': 'mahu',
    'nempel': 'menempel',
    'peduliin': 'mempedulikan',
    'komntr': 'komentar',
    'smngat': 'semangat',
    'dosax': 'dosanya',
    'pahalax': 'pahalanya',
    'akhirt': 'akhirat',
    'tinggalkn': 'tinggalkan',
    'rumh': 'rumah',
    'trhtung': 'terhitung',
    'didengerin': 'didengarkan',
    'ngerespon': 'merespons',
    'brusaha': 'berusaha',
    'lebh': 'lebih',
    'positippp': 'positif',
    'brhjb': 'berhijab',
    'slmnya': 'salamnya',
    'jlbb': 'jilbab',
    'dempga': 'semoga',
    'selmnya': 'selamanya',
    'tth': 'teteh',
    'trusss': 'terus',
    'cuantek': 'cantik',
    'iniehh': 'ini',
    'sayangx': 'sayangnya',
    'jodohx': 'jodohnya',
    'haslnya': 'hasilnya',
    'kencng': 'kencang',
    'pmbantu': 'pembantu',
    'kmbl': 'kembali',
    'cuchook': 'sesuai',
    'klihatan': 'kelihatan',
    'cintax': 'cintanya',
    'pnuh': 'penuh',
    'ngrti': 'mengerti',
    'mantanny': 'mantannya',
    'jodohny': 'jodohnya',
    'cantk': 'cantik',
    'kaasian': 'kasihan',
    'padhl': 'padahal',
    'ank"': 'anak-anak',
    'pkrin': 'pikirkan',
    'anakx': 'anaknya',
    'kreean': 'keren',
    'berenanh': 'berenang',
    'bingitss': 'sangat',
    'ngeliatin': 'melihati',
    'ngumbar2': 'mengumbar-umbar',
    'lgs': 'langsung',
    'bangedt': 'sangat',
    'gde': 'gede',
    'lutunaaa': 'lucunya',
    'lucux': 'lucunya',
    'bntr': 'bentar',
    'buanyaaak': 'banyak',
    'ntap': 'mantap',
    'abgnyaah': 'abangnya',
    'manteb': 'mantap',
    'tebel': 'tebal',
    'nganggepin': 'menanggapi',
    'perjabatt': 'pejabat',
    'makany': 'makanya',
    'benneeeeeerr': 'benar',
    'krjaan': 'pekerjaan',
    'kdng': 'kadang',
    'kdang': 'kadang',
    'knan': 'kanan',
    "anak'y": 'anaknya',
    'trknal': 'terkenal',
    'gtu"': 'begitu-gitu',
    'klok': 'kalau',
    'pengennnn': 'ingin',
    'guw': 'saya',
    'selaloe': 'selalu',
    "soal'y": 'soalnya',
    'prhatian': 'perhatian',
    'liatt': 'lihat',
    'gehh': 'gih',
    'ankknyaaa': 'anaknya',
    'gemesshzzzzhzzhzhzhsjssjs': 'gemas',
    'ngacaaa': 'mengaca',
    'jirr': 'anjing',
    'pcran': 'pacaran',
    'anedh': 'sangat',
    'ampyunnnn': 'ampun',
    'nyta': 'nyata',
    'kampungn': 'kampungan',
    'mnghina': 'menghina',
    'ngolokin': 'mengolok',
    'blum': 'belum',
    'than': 'tahan',
    'dsr': 'dasar',
    'khan': 'kan',
    'bingitzzzz': 'sangat',
    'tlog': 'tolong',
    'dbnding': 'dibanding',
    'nrka': 'neraka',
    's3ndiri': 'sendiri',
    'bhgiain': 'membahagiakan',
    'kdua': 'kedua',
    'prcya': 'percaya',
    'bhagaia': 'bahagia',
    'cuco': 'sesuai',
    'mlikk': 'milik',
    'canci': 'cantik',
    'aneed': 'sangat',
    'gimanaa': 'bagaimana',
    'krudung': 'kerudung',
    'jirrrr': 'anjing',
    'oprasiya': 'operasinya',
    'uwee': 'saya',
    'pilihannny': 'pilihannya',
    'berbakiti': 'berbakti',
    'alhamd': 'alhamdulillah',
    'slmttt': 'selamat',
    'ucapin': 'mengucapkan',
    'tetp': 'tetap',
    'abs': 'habis',
    "kebnyak'an": 'kebanyakan',
    'melahirin': 'melahirkan',
    'lhooo': 'lah',
    'gimn': 'bagaimana',
    'smogaaa': 'semoga',
    'biza': 'boleh',
    'lngsing': 'langsing',
    'smulla': 'semula',
    'pdhall': 'padahal',
    'blln': 'bulan',
    'cpet': 'cepat',
    'gataunya': 'tidak tahu',
    'gtau': 'tidak tahu',
    'gaharus': 'jangan harus',
    'aja': 'sahaja',
    'gw': 'saya',
}
