from enum import Enum

class FCDEF(Enum):
    ENCODER = 0x0
    DECODER = 0x1

TRA_DEFINITION = ["CDR3a","TRAV","TRAJ"]
TRB_DEFINITION = ["CDR3b","TRBV","TRBJ"]
TRAB_DEFINITION = ["CDR3a","CDR3b","TRAV","TRAJ","TRBV","TRBJ"]


TRA_DEFINITION_ORIG = ["IR_VJ_1_junction_aa",
    "IR_VJ_1_v_call",
    "IR_VJ_1_j_call"
]
TRB_DEFINITION_ORIG = [
    "IR_VDJ_1_junction_aa",
    "IR_VDJ_1_v_call",
    "IR_VDJ_1_j_call"
]
TRAB_DEFINITION_ORIG = [
    "IR_VJ_1_junction_aa",            
    "IR_VDJ_1_junction_aa",
    "IR_VJ_1_v_call",
    "IR_VJ_1_j_call",
    "IR_VDJ_1_v_call",
    "IR_VDJ_1_j_call"
]

CDR1a = [
    'TSGFYG',
    'TSGFNG',
    'VSNAYN',
    'VSGNPY',
    'NIATNDY',
    'DSSSTY',
    'NYSPAY',
    'VSRFNN',
    'YGGTVN',
    'SSYSPS',
    'YGATPY',
    'SSVPPY',
    'SSVSVY',
    'YSGVPS',
    'TTQYPS',
    'ATGYPS',
    'VSPFSN',
    'ERTLFN',
    'NSASQS',
    'DRGSQS',
    'NSAFQY',
    'DSASNY',
    'NSASDY',
    'TSDPSYG',
    'YSGSPE',
    'TSINN',
    'SSYSTF',
    'TRDTTYY',
    'VSGLRG',
    'DSAIYN',
    'DSVNN',
    'NTAFDY',
    'SSNFYA',
    'TTLSN',
    'TISGNEY',
    'TISGTDY',
    'SVFSS',
    'NSMFDY',
    'KALYS',
    'KTLYG',
    'SIFNT',
    'VTNFRS',
    'TSENNYY',
    'TSESDYY',
    'TTSDR',
    'STGYPT',
    'VGISA'
]

CDR2a = ['NALDGL',
'NVLDGL',
'GSKP',
'YITGDNLV',
'GYKTK',
'IFSNMDM',
'IRENEKE',
'MYSAGYE',
'YFSGDPLV',
'YTSAATLV',
'YFSGDTLV',
'YTSAATLV',
'YLSGSTLV',
'DLTEATQV',
'AMKANDK',
'ATKADDK',
'MTFSENT',
'IQSSQKE',
'VYSSGN',
'IYSNGD',
'TYSSGN',
'IRSNVGE',
'IRSNMDK',
'QGSYDQQN',
'HISR',
'IRSNERE',
'SSENQE',
'RNSFDEQN',
'LYSAGEE',
'IQSSQRE',
'IPSGT',
'IRPDVSE',
'MTLNGDE',
'LVKSGEV',
'GLKNN',
'GLTSN',
'VVTGGEV',
'ISSIKDK',
'LLKGGEQ',
'LQKGGEE',
'LYKAGEL',
'LTSSGIE',
'QEAYKQQN',
'QEAYKQQN',
'LLSNGAV',
'ETME',
'LSSGK']

CDR1b = ['GHDS',
'SNHLY',
'LGHDT',
'LGHNA',
'MGHRA',
'LGHNA',
'LGHNA',
'SGHRS',
'SGHSS',
'SGHNT',
'SGHKS',
'SGHDT',
'SGHTS',
'SGHTS',
'MNHNS',
'MNHEY',
'MNHEY',
'MRHNA',
'MNHEY',
'MNHNY',
'MNHEY',
'MNHGY',
'MNHGY',
'SGHNA',
'SGHTA',
'SGHTA',
'SGHVT',
'SGHVS',
'SSHAT',
'SGHVS',
'SEHNR',
'SGDLS',
'WNHNN',
'WSHSY',
'ENHRY',
'SGHAT',
'SGHAT',
'SGHNT',
'SGHND',
'FGHNF',
'SGHNS',
'SGHDY',
'LGHNT',
'PRHDT',
'SGHDN',
'LNHNV',
'KGHSY',
'SGHMF',
'KGHSH',
'LNHDA',
'DFQATT',
'KAHSY',
'KGHTF',
'KGHDR',
'MGHDK',
'MNHVT',
'MNHEY',
'MDHEN',
'SQVTM',
'GTSNPN',
'FQATT']

CDR2b = ['YNCKEF',
'FYNNEI',
'YNNKEL',
'YSNKEP',
'YSYEKL',
'YNFKEQ',
'YSLEER',
'YFSETQ',
'YANELR',
'YYREEE',
'YYEKEE',
'YYEEEE',
'YYEKEE',
'YDEGEE',
'SASEGT',
'SVGEGT',
'SVGEGT',
'SNTAGT',
'SVGAGI',
'SVGAGI',
'SVAAAL',
'SAAAGT',
'SVAAGI',
'FQGKDA',
'FQGNSA',
'FQGTGA',
'SQSDAQ',
'FNYEAQ',
'FNYEAQ',
'FQNEAQ',
'FQNEAQ',
'YYNGEE',
'SYGVQD',
'SAAADI',
'SYGVKD',
'FQDESV',
'FQNNGV',
'YENEEA',
'FCSWTL',
'FRS*SI',
'FNNNVP',
'FNNNVP',
'FRNRAP',
'FYEKMQ',
'FVKESK',
'YYDKDF',
'FQNENV',
'FQYQNI',
'LQKENI',
'SQIVND',
'SNEGSKA',
'FQNEEL',
'FQNEQV',
'SFDVKD',
'SYGVNS',
'SPGTGS',
'SMNVEV',
'SYDVKM',
'ANQGSEA',
'SVGIG',
'SNEGSEV']

TRAV_KEYS = ['TRAV1-1',
'TRAV1-2',
'TRAV2',
'TRAV3',
'TRAV4',
'TRAV5',
'TRAV6',
'TRAV7',
'TRAV8-1',
'TRAV8-2',
'TRAV8-3',
'TRAV8-4',
'TRAV8-6',
'TRAV8-7',
'TRAV9-1',
'TRAV9-2',
'TRAV10',
'TRAV11',
'TRAV12-1',
'TRAV12-2',
'TRAV12-3',
'TRAV13-1',
'TRAV13-2',
'TRAV14DV4',
'TRAV16',
'TRAV17',
'TRAV18',
'TRAV19',
'TRAV20',
'TRAV21',
'TRAV22',
'TRAV23DV6',
'TRAV24',
'TRAV25',
'TRAV26-1',
'TRAV26-2',
'TRAV27',
'TRAV29DV5',
'TRAV30',
'TRAV34',
'TRAV35',
'TRAV36DV7',
'TRAV38-1',
'TRAV38-2DV8',
'TRAV39',
'TRAV40',
'TRAV41',]

TRBV_KEYS = ['TRBV1',
'TRBV2',
'TRBV3-1',
'TRBV3-2',
'TRBV4-1',
'TRBV4-2',
'TRBV4-3',
'TRBV5-1',
'TRBV5-3',
'TRBV5-4',
'TRBV5-5',
'TRBV5-6',
'TRBV5-7',
'TRBV5-8',
'TRBV6-1',
'TRBV6-2',
'TRBV6-3',
'TRBV6-4',
'TRBV6-5',
'TRBV6-6',
'TRBV6-7',
'TRBV6-8',
'TRBV6-9',
'TRBV7-1',
'TRBV7-2',
'TRBV7-3',
'TRBV7-4',
'TRBV7-6',
'TRBV7-7',
'TRBV7-8',
'TRBV7-9',
'TRBV9',
'TRBV10-1',
'TRBV10-2',
'TRBV10-3',
'TRBV11-1',
'TRBV11-2',
'TRBV11-3',
'TRBV12-1',
'TRBV12-2',
'TRBV12-3',
'TRBV12-4',
'TRBV12-5',
'TRBV13',
'TRBV14',
'TRBV15',
'TRBV16',
'TRBV17',
'TRBV18',
'TRBV19',
'TRBV20-1',
'TRBV21-1',
'TRBV23-1',
'TRBV24-1',
'TRBV25-1',
'TRBV26',
'TRBV27',
'TRBV28',
'TRBV29-1',
'TRBV30',
'TRBV29OR9-2']

TRAV2CDR1a = dict(zip(TRAV_KEYS, CDR1a))
TRAV2CDR2a = dict(zip(TRAV_KEYS, CDR2a))
TRBV2CDR1b = dict(zip(TRBV_KEYS, CDR1b))
TRBV2CDR2b = dict(zip(TRBV_KEYS, CDR2b))
